/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.ui.refactoring;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.ReplaceEdit;

public interface IChangeValidator {
    default public boolean skipChange(List<String> affectedList, String key, String value, IDocument doc, ReplaceEdit re) {
        int lin;
        block9: {
            int keyIndex;
            int valIndex;
            String line;
            block8: {
                if (affectedList == null || affectedList.isEmpty()) {
                    return false;
                }
                int pos = re.getOffset();
                lin = doc.getLineOfOffset(pos);
                int off = doc.getLineOffset(lin);
                int len = doc.getLineLength(lin);
                line = doc.get(off, len);
                valIndex = line.indexOf(value);
                keyIndex = line.indexOf(key);
                if (valIndex >= 0 && pos >= off + valIndex + value.length()) break block8;
                return true;
            }
            if (keyIndex < 0) break block9;
            if (IChangeValidator.containsKey(line.substring(keyIndex, valIndex), affectedList)) {
                return false;
            }
        }
        try {
            int i = lin - 1;
            while (i > 0) {
                String s = doc.get(doc.getLineOffset(i), doc.getLineLength(i));
                if (s.contains(key)) {
                    return !IChangeValidator.containsKey(s, affectedList);
                }
                --i;
            }
        }
        catch (BadLocationException e) {
            Status status = new Status(4, "com.nxp.s32ds.ext.ide.ui", e.getMessage(), (Throwable)e);
            ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
        }
        return true;
    }

    public static boolean containsKey(String text, List<String> affectedList) {
        for (String attribute : affectedList) {
            Pattern pattern = Pattern.compile(attribute, 2);
            Matcher matcher = pattern.matcher(text);
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }
}

