/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rpt.cross.spt.ui;

import com.freescale.s32ds.cross.core.model.Parameter;
import com.freescale.s32ds.cross.core.model.context.ProjectContext;
import com.freescale.s32ds.cross.wizard.IWizardParticipant;
import com.nxp.s32ds.ext.cdt.core.CdtCore;
import com.nxp.s32ds.gte.sptprogram.design.SptProgramDescriptor;
import com.nxp.s32ds.gte.sptprogram.design.SptProgramRepresenter;
import com.nxp.s32ds.vgt.ide.core.VgtDescriptor;
import com.nxp.s32ds.vgt.ide.ui.VgtRepresenter;
import com.nxp.s32ds.vgt.ide.ui.operations.VgtProjectConfigurator;
import com.nxp.s32ds.vgt.ide.ui.operations.VgtProjectCreationOperation;
import java.net.URI;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public abstract class SptProgramWizardParticipant
implements IWizardParticipant,
VgtProjectConfigurator {
    protected static final String POSTFIX_GRAPH = "_graph";

    public boolean isApplicable(ProjectContext context) {
        Parameter parameter = context.getParameter(this.getGraphEnableParameterId());
        return parameter != null && context.getBooleanValue(parameter.getTag());
    }

    protected abstract String getGraphEnableParameterId();

    public WorkspaceModifyOperation participate(ProjectContext context, IProject target, IWorkingSet[] workingSets) {
        String targetName = target.getName();
        String projectName = String.valueOf(targetName) + POSTFIX_GRAPH;
        IProject projectHandle = target.getWorkspace().getRoot().getProject(projectName);
        SptProgramRepresenter representer = this.getRepresenter();
        SptProgramDescriptor descriptor = representer.createSptProgramDescriptor();
        descriptor.hostProjectChanged(targetName);
        URI targetLocation = target.getLocationURI();
        URI projectLocation = null;
        if (targetLocation != null) {
            projectLocation = URIUtil.toURI((String)(String.valueOf(URIUtil.toDecodedString((URI)targetLocation)) + POSTFIX_GRAPH), (boolean)false);
        }
        VgtProjectCreationOperation operation = new VgtProjectCreationOperation((VgtRepresenter)representer, (VgtDescriptor)descriptor, projectHandle, target, projectLocation, workingSets);
        operation.addConfigurator((VgtProjectConfigurator)this);
        return operation;
    }

    protected abstract SptProgramRepresenter getRepresenter();

    public IStatus configure(VgtDescriptor descriptor, IProgressMonitor monitor) {
        try {
            String targetProjectName = descriptor.getStringValue(SptProgramDescriptor.TARGET_PROJECT_NAME);
            String targetFolderName = descriptor.getStringValue(SptProgramDescriptor.TARGET_FOLDER_NAME);
            CdtCore.createSourceFolder((String)targetProjectName, (String)targetFolderName, (IProgressMonitor)monitor);
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }
}

