/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.debug.gdbjtag.ppc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;

class SemihostingProcess
extends Process
implements Runnable {
    boolean fRunning;
    Thread fThread = null;
    Socket socket;
    protected static final int BUFFER_SIZE = 2048;
    protected byte[] rawBytes = new byte[2048];
    protected InputStream fInputStream;
    protected OutputStream fOutputStream;
    protected InputStream fErrorStream;
    protected PipedInputStream fPipeIn;
    protected PipedOutputStream fPipeOut;
    private String fHost;
    private int fPort;
    public int i;

    public SemihostingProcess(String host, int port) {
        System.out.println("SemihostingProcess(" + host + "," + port + ") " + this);
        this.fHost = host;
        this.fPort = port;
        this.fRunning = false;
        this.fInputStream = new NullInputStream();
        this.fErrorStream = new NullInputStream();
        this.fOutputStream = new NullOutputStream();
        this.fPipeOut = new PipedOutputStream();
        try {
            this.fPipeIn = new PipedInputStream(this.fPipeOut);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void destroy() {
        System.out.println("SemihostingProcess.destroy() " + Thread.currentThread() + " " + this.fThread);
        if (this.fRunning) {
            if (this.fThread != null && this.fThread != Thread.currentThread()) {
                this.fThread.interrupt();
                System.out.println("SemihostingProcess.destroy() after interrupt");
            }
            try {
                if (this.socket != null && !this.socket.isClosed()) {
                    System.out.println("SemihostingProcess.destroy() before shutdownInput");
                    this.socket.shutdownInput();
                    System.out.println("SemihostingProcess.destroy() before shutdownOutput");
                    this.socket.shutdownOutput();
                }
            }
            catch (IOException iOException) {
                System.out.println("SemihostingProcess.destroy() exception");
            }
        }
        System.out.println("SemihostingProcess.destroy() return");
    }

    @Override
    public int exitValue() {
        if (this.fRunning) {
            throw new IllegalThreadStateException();
        }
        return 0;
    }

    @Override
    public InputStream getErrorStream() {
        return this.fErrorStream;
    }

    @Override
    public InputStream getInputStream() {
        return this.fPipeIn;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.fOutputStream;
    }

    @Override
    public int waitFor() throws InterruptedException {
        System.out.println("SemihostingProcess.waitFor() " + Thread.currentThread() + " " + this.fThread);
        this.fThread.join();
        System.out.println("SemihostingProcess.waitFor() return " + Thread.currentThread());
        return 0;
    }

    @Override
    public void run() {
        block40: {
            System.out.println("SemihostingProcess.run() " + Thread.currentThread());
            this.fRunning = true;
            int nTimeout = 10000;
            this.i = 50;
            while (this.i > 0) {
                InetSocketAddress address = new InetSocketAddress(this.fHost, this.fPort);
                this.socket = new Socket();
                try {
                    this.socket.connect(address, nTimeout);
                    break;
                }
                catch (IOException iOException) {
                    --this.i;
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (this.i != 0) continue;
                    System.out.println("cannot connect, no way to go further.");
                    return;
                }
            }
            this.fRunning = true;
            try {
                try {
                    this.fInputStream = this.socket.getInputStream();
                    this.fOutputStream = this.socket.getOutputStream();
                    this.socket.setKeepAlive(true);
                    while (this.socket.isConnected() & this.fRunning) {
                        int nRawBytes = this.fInputStream.read(this.rawBytes);
                        if (nRawBytes == -1) {
                            System.out.println("Connection closed by the GDB server.");
                            this.fPipeOut.write("Connection closed by the GDB server.".getBytes());
                            break;
                        }
                        if (nRawBytes <= 0) continue;
                        this.fPipeOut.write(this.rawBytes, 0, nRawBytes);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        this.fPipeOut.close();
                    }
                    catch (IOException iOException) {}
                    try {
                        this.fErrorStream.close();
                    }
                    catch (IOException iOException) {}
                    try {
                        this.socket.close();
                        this.socket = null;
                    }
                    catch (IOException iOException) {}
                    try {
                        this.fInputStream.close();
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                    catch (IOException iOException) {}
                    this.fRunning = false;
                    break block40;
                }
            }
            catch (Throwable throwable) {
                try {
                    this.fPipeOut.close();
                }
                catch (IOException iOException) {}
                try {
                    this.fErrorStream.close();
                }
                catch (IOException iOException) {}
                try {
                    this.socket.close();
                    this.socket = null;
                }
                catch (IOException iOException) {}
                try {
                    this.fInputStream.close();
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (IOException iOException) {}
                this.fRunning = false;
                throw throwable;
            }
            try {
                this.fPipeOut.close();
            }
            catch (IOException iOException) {}
            try {
                this.fErrorStream.close();
            }
            catch (IOException iOException) {}
            try {
                this.socket.close();
                this.socket = null;
            }
            catch (IOException iOException) {}
            try {
                this.fInputStream.close();
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (IOException iOException) {}
            this.fRunning = false;
        }
        System.out.println("SemihostingProcess.run() completed ");
    }

    public void submit() {
        System.out.println("SemihostingProcess.submit() " + Thread.currentThread());
        this.fThread = new Thread(this);
        this.fThread.setName("Semihosting and SWV fake process");
        this.fThread.setDaemon(true);
        this.fThread.setPriority(1);
        this.fThread.start();
    }

    protected class NullInputStream
    extends InputStream {
        private boolean fIsOpened = true;
        private Thread fThread = null;

        protected NullInputStream() {
        }

        @Override
        public int read() throws IOException {
            if (!this.fIsOpened) {
                return -1;
            }
            try {
                this.fThread = Thread.currentThread();
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("NullInputStream read interrupted");
            }
            return 0;
        }

        @Override
        public int available() {
            return 0;
        }

        @Override
        public void close() throws IOException {
            System.out.println("NullInputStream.close() " + Thread.currentThread());
            if (this.fIsOpened) {
                super.close();
                this.fIsOpened = false;
                if (this.fThread != null) {
                    System.out.println("NullInputStream.close() interrupt " + Thread.currentThread() + " " + this.fThread);
                    this.fThread.interrupt();
                }
            }
        }
    }

    protected class NullOutputStream
    extends OutputStream {
        protected NullOutputStream() {
        }

        @Override
        public void write(int arg0) throws IOException {
        }
    }
}

