/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.emf.ecore.derived;

import com.nxp.s32ds.ext.emf.ecore.derived.DerivedFieldAdaptor;
import com.nxp.s32ds.ext.emf.internal.ecore.EmfEcoreActivator;
import com.nxp.s32ds.ext.rcp.jse.collection.MapBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class DerivedFieldAdapterRegistry {
    public static final DerivedFieldAdapterRegistry INSTANCE = new DerivedFieldAdapterRegistry();
    private static final Map<Class<?>, Class<?>> PRIMITIVES_TO_WRAPPERS = new MapBuilder().put(Boolean.TYPE, Boolean.class).put(Byte.TYPE, Byte.class).put(Character.TYPE, Character.class).put(Double.TYPE, Double.class).put(Float.TYPE, Float.class).put(Integer.TYPE, Integer.class).put(Long.TYPE, Long.class).put(Short.TYPE, Short.class).put(Void.TYPE, Void.class).build();
    private static final Map<Class<?>, Object> PRIMITIVES_DEFAULT_VALUE = new MapBuilder().put(Boolean.TYPE, (Object)new Boolean(false)).put(Byte.TYPE, (Object)new Byte(0)).put(Character.TYPE, (Object)new Character('\u0000')).put(Double.TYPE, (Object)new Double(0.0)).put(Float.TYPE, (Object)new Float(0.0f)).put(Integer.TYPE, (Object)new Integer(0)).put(Long.TYPE, (Object)new Long(0L)).put(Short.TYPE, (Object)new Short(0)).build();
    private final List<DerivedFieldAdaptor> adaptors = new ArrayList<DerivedFieldAdaptor>();

    public void addAdaptors(List<DerivedFieldAdaptor> adaptors) {
        this.adaptors.addAll(adaptors);
    }

    public <T> T call(EStructuralFeature feature, EObject instance, Class<T> clazz) {
        EClass eContainingClass = feature.getEContainingClass();
        if (!eContainingClass.isInstance((Object)instance)) {
            EmfEcoreActivator.log("Instance object is not instance off [" + eContainingClass + "]", new Exception());
            return (T)PRIMITIVES_DEFAULT_VALUE.get(clazz);
        }
        EClassifier eType = feature.getEType();
        if (!eType.getInstanceClass().equals(clazz)) {
            EmfEcoreActivator.log("Expected type is not instance of [" + eType + "]", new Exception());
            return (T)PRIMITIVES_DEFAULT_VALUE.get(clazz);
        }
        for (DerivedFieldAdaptor adaptor : this.adaptors) {
            try {
                if (!adaptor.isApplicable(feature)) continue;
                Object result = adaptor.call(feature, instance);
                if (result == null) {
                    return (T)PRIMITIVES_DEFAULT_VALUE.get(clazz);
                }
                Class<Object> realClass = clazz;
                if (clazz.isPrimitive()) {
                    realClass = PRIMITIVES_TO_WRAPPERS.get(clazz);
                }
                if (!realClass.isInstance(result)) {
                    EmfEcoreActivator.log("Result is not instance of [" + eType + "]", new Exception());
                    return (T)PRIMITIVES_DEFAULT_VALUE.get(clazz);
                }
                return (T)result;
            }
            catch (Exception e) {
                EmfEcoreActivator.log("Exception during evaluating feature [" + feature + "]", e);
            }
        }
        EmfEcoreActivator.log("Cannot find addapter for feature [" + String.valueOf(feature) + "]", new Exception());
        return (T)PRIMITIVES_DEFAULT_VALUE.get(clazz);
    }
}

