/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.emf.common.util;

import com.nxp.s32ds.ext.emf.common.util.CycleUtil;
import com.nxp.s32ds.ext.emf.common.util.InputOutputProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

public class LoopChecker {
    private final InputOutputProvider provider;

    public LoopChecker(InputOutputProvider provider) {
        this.provider = provider;
    }

    public List<EObject> detectGlobalCycles(EObject graph) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        TreeIterator treeIterator = graph.eAllContents();
        while (treeIterator.hasNext()) {
            EObject element;
            EObject eObject = (EObject)treeIterator.next();
            if (eObject instanceof EObject && this.getInputsInt(element = eObject).isEmpty() && this.getOutputsInt(element).isEmpty()) {
                result.add(element);
            }
            treeIterator.prune();
        }
        return result;
    }

    public List<CycleUtil.LocalCycleInfo> detectLocalCycles(EObject graph) {
        ArrayList<CycleUtil.LocalCycleInfo> result = new ArrayList<CycleUtil.LocalCycleInfo>();
        List<EObject> inputs = this.provider.getInputs(graph);
        for (EObject nameElement : inputs) {
            result.addAll(this.detectLocalCyclesInt(nameElement));
        }
        return result;
    }

    private Collection<CycleUtil.LocalCycleInfo> detectLocalCyclesInt(EObject source) {
        ArrayList<CycleUtil.LocalCycleInfo> result = new ArrayList<CycleUtil.LocalCycleInfo>();
        HashSet<EObject> visited = new HashSet<EObject>();
        ArrayList<CycleUtil.LocalCyclesInternalInfo> forProcessing = new ArrayList<CycleUtil.LocalCyclesInternalInfo>();
        forProcessing.add(new CycleUtil.LocalCyclesInternalInfo(null, Collections.singletonList(source)));
        while (forProcessing.size() > 0) {
            ArrayList<CycleUtil.LocalCyclesInternalInfo> newForProcessing = new ArrayList<CycleUtil.LocalCyclesInternalInfo>();
            for (CycleUtil.LocalCyclesInternalInfo cyclesInternalInfo : forProcessing) {
                for (EObject nameElement : cyclesInternalInfo.outputs) {
                    if (cyclesInternalInfo.source != null && (visited.contains(nameElement) || nameElement.equals(cyclesInternalInfo.source))) {
                        result.add(new CycleUtil.LocalCycleInfo(cyclesInternalInfo.source, nameElement));
                        continue;
                    }
                    if (cyclesInternalInfo.source == null) {
                        visited.add(cyclesInternalInfo.outputs.get(0));
                    } else {
                        visited.add(cyclesInternalInfo.source);
                    }
                    List<EObject> curOutputs = this.provider.getOutputs(nameElement);
                    if (curOutputs.size() <= 0) continue;
                    newForProcessing.add(new CycleUtil.LocalCyclesInternalInfo(nameElement, curOutputs));
                }
            }
            forProcessing = newForProcessing;
        }
        return result;
    }

    public List<DiscontinuityInfo> detectDiscontinuity(EObject graph) {
        ArrayList<DiscontinuityInfo> result = new ArrayList<DiscontinuityInfo>();
        List<EObject> inputs = this.getInputsInt(graph);
        List<EObject> outputs = this.getOutputsInt(graph);
        for (EObject nameElement : inputs) {
            List<EObject> localOutputs = this.getOutputsInt(nameElement);
            ArrayList<EObject> outputsCopy = new ArrayList<EObject>(outputs);
            outputsCopy.removeAll(localOutputs);
            if (outputsCopy.size() <= 0) continue;
            result.add(new DiscontinuityInfo(nameElement, outputsCopy));
        }
        return result;
    }

    public List<EObject> detectInputCycles(EObject graph) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        List<EObject> outputs = this.getOutputsInt(graph);
        for (EObject nameElement : outputs) {
            if (!this.getInputsInt(nameElement).isEmpty()) continue;
            result.add(nameElement);
        }
        return result;
    }

    private List<EObject> getOutputsInt(EObject source) {
        ArrayList<EObject> outputs = new ArrayList<EObject>();
        ArrayList<EObject> visited = new ArrayList<EObject>();
        ArrayList<EObject> forProcessing = new ArrayList<EObject>();
        forProcessing.add(source);
        while (forProcessing.size() > 0) {
            ArrayList<EObject> newForProcessing = new ArrayList<EObject>();
            for (EObject nameElement : forProcessing) {
                if (visited.contains(nameElement)) continue;
                visited.add(nameElement);
                List<EObject> curOutputs = this.provider.getOutputs(nameElement);
                if (curOutputs.size() == 0) {
                    outputs.add(nameElement);
                    continue;
                }
                newForProcessing.addAll(curOutputs);
            }
            forProcessing = newForProcessing;
        }
        return outputs;
    }

    private List<EObject> getInputsInt(EObject source) {
        ArrayList<EObject> inputs = new ArrayList<EObject>();
        ArrayList<EObject> visited = new ArrayList<EObject>();
        ArrayList<EObject> forProcessing = new ArrayList<EObject>();
        forProcessing.add(source);
        while (forProcessing.size() > 0) {
            ArrayList<EObject> newForProcessing = new ArrayList<EObject>();
            for (EObject nameElement : forProcessing) {
                if (visited.contains(nameElement)) continue;
                visited.add(nameElement);
                List<EObject> curInputs = this.provider.getInputs(nameElement);
                if (curInputs.size() == 0) {
                    inputs.add(nameElement);
                    continue;
                }
                newForProcessing.addAll(curInputs);
            }
            forProcessing = newForProcessing;
        }
        return inputs;
    }

    public static class DiscontinuityInfo {
        public final EObject input;
        public final List<EObject> unreachebleOtputs;

        public DiscontinuityInfo(EObject input, List<EObject> unreachebleOtputs) {
            this.input = input;
            this.unreachebleOtputs = Collections.unmodifiableList(unreachebleOtputs);
        }
    }
}

