/**************************************************************************
 * FILE NAME: MPC5777M.h                     COPYRIGHT (c) Freescale 2015 * 
 * REVISION:  4.0                                     All Rights Reserved *
 *                                                                        *
 * DESCRIPTION:                                                           *
 * This file contains all of the register and bit field definitions for   *
 * the MPC5777M.                                                          *
 *========================================================================*
 * UPDATE HISTORY                                                         *
 * REV      AUTHOR      DATE       	DESCRIPTION OF CHANGE                 *
 * ---   -----------  ---------    	---------------------                 *
 * 0.2      P.A.      21-Mar-12     Adding register array style           *
 *                                                                        *
 * 0.3      P.A.      05-Apr-12     Adding new modules sent by Curt       *
 *                                  Hillier                               *
 *                                                                        *
 * 0.4      P.A.      25-Jul-12     Adding latest modules.                *
 * 0.4A     C.H.      13-Aug-12     Corrected errors in memory map.       *
 *                                                                        ******
 * CGM was incorrectly generated at 0UL.  Corrected to 0xFFFB0700UL            *
 * FR_0 was incorrectly generated at 0xFC250000UL.  Corrected to 0xFFE50000UL  *
 * LFAST was incorrectly generated at 0x1UL.  Corrected to 0xFFFD8000UL        *
 * PRAMC was incorrectly generated at 0UL.  Correct to 0xFC020000UL.           *
 *                                                                             *
 * 0.4b to                                                                     *
 *  0.5b    C.H.      22-Oct-12     Interim builds for debugging.              *
 * 0.5c     C.H.      23-Oct-12     replace autogenerated SARADC               *
 *                                  block with McKinley.  Too many mis-        *
 *                                  matches present.                           *
 *                                  Collapse DSPI CTARs to array               *
 * 0.5d     C.H.      24-Oct-12     Incorporate feedback from PE.              *
 *                                    add #ifdef support for SARADC arrays     *
 *                                    add array support for MC_ME_RUN_MC       *
 * 0.6      C.H.      26-Oct-12     MC_CGM uses base address of 0xFFFB_0700    *
 *                                  and registers offsets starting at 0x0700.  *
 *                                  This results in incorrect absolute         *
 *                                  addresses starting at 0xFFFB_0E000.        *
 *                                  To fix this, commented out the reserved    *
 *                                  space "//  uint8_t MC_CGM_reserved0[1792];" *
 *                                  and keep module base address = 0xFFFB_0700. *
 *                                  This matches McKinley implementation.      *
 *                                                                             *
 * 0.7      M.D.      05-Mar-13     Updated to RDP from Jan 2013 as follows:   *
 *                                  Module INTC: Added register MPROT          *
 *                                  And updated structure of PSR register      * 
 *                                  Module MCAN: Updated registers NDAT1,      *
 *                                  NDAT2, RXFOS, RXF1S, TXFQS, TXEFS          *
 *                                  Also added some comments to Module MCAN    *
 *                                                                             *
 * 0.8      M.D.      13-Mar-13     Updated PRAMC & CRC from new XML drop      *
 *                                  Expanded AC0_DC[5] register                *
 *                                  Change to PRAMC was manually inserted as   *
 *                                  code generated from XML was not correct    *  
 *                                  MC_ME: Inserted hand coded PCTL11 & 15     *
 *                                  due to missing from XML                    *
 *                                                                        *   
 * 0.9      M.D.      25-Jul-13     Updated from new XML drop             *
 *                                                                        *
 * 1.0      M.D.      17-Oct-13     Updated from RDP rev3                 *
 *                                                                        *
 * 1.1      M.D.      31-Jan-14     Added GTM104 modules                  *
 *                                                                        *     
 * 1.2      M.D.      26-Feb-14     Compressed GTM_ATOM modules           *
 *                                                                        *     
 * 1.3      M.D.      27-Feb-14     Compressed GTM modules: MCSs, AFDs,   *
 *                                  F2As, FIFOs, SPEs, TIMs and TOM       *
 *                                                                        *     
 * 1.4      M.D.      27-Feb-14     Removed a module                      *
 *                                                                        *
 * 1.5      M.D.      13-Mar-14     Updated with new GTM RDP              *
 *                                                                        *
 * 1.6      M.D.      02-Apr-14     Updated with RDP Rev 3                *
 *                                                                        *
 * 1.7      M.D.      03-Apr-14     Corrected some GTM macros             *
 *                                                                        *
 * 1.8      M.D.      07-Apr-14     Corrected MC_CGM base address         *
 *                                                                        *
 * 1.9      M.D.      08-Apr-14     Corrected GTM_AFD macro definitions   *
 *                                                                        *
 * 4.0      M.D.      12-Aug-15     Updated with RDP Rev 4				  *
 *                                                                        *
 *========================================================================*
 * COPYRIGHT:                                                             *
 *  Freescale Semiconductor, INC. All Rights Reserved. You are hereby     *
 *  granted a copyright license to use, modify, and distribute the        *
 *  SOFTWARE so long as this entire notice is retained without alteration *
 *  in any modified and/or redistributed versions, and that such modified *
 *  versions are clearly identified as such. No licenses are granted by   *
 *  implication, estoppel or otherwise under any patentsor trademarks     *
 *  of Freescale Semiconductor, Inc. This software is provided on an      *
 *  "AS IS" basis and without warranty.                                   *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, Freescale          *
 *  Semiconductor DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED,    *
 *  INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A      *
 *  PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD  *
 *  TO THE SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY     *
 *  ACCOMPANYING WRITTEN MATERIALS.                                       *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, IN NO EVENT        *
 *  SHALL Freescale Semiconductor BE LIABLE FOR ANY DAMAGES WHATSOEVER    *
 *  (INCLUDING WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,  *
 *  BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER         *
 *  PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.  *
 *                                                                        *
 *  Freescale Semiconductor assumes no responsibility for the             *
 *  maintenance and support of this software                              *
 *                                                                        *
 **************************************************************************/
/*>>>>>>> NOTE! this file is auto-generated please do not edit it! <<<<<<<*/

/**************************************************************************
 * Example register & bit field write:                                    *
 *                                                                        *
 *  <MODULE>.<REGISTER>.B.<BIT> = 1;                                      *
 *  <MODULE>.<REGISTER>.R       = 0x10000000;                             *
 *                                                                        *
 **************************************************************************/

#ifndef _MPC5777M_H_
#define _MPC5777M_H_
#include "typedefs.h"
#ifdef __cplusplus
extern "C" {
#endif
#ifdef __MWERKS__
#pragma push
#pragma ANSI_strict off
#endif
#ifdef __ghs__
#pragma ghs nowarning 618
#endif


/* ============================================================================
   =============================== Module: C55FMC =============================
   ============================================================================ */

typedef union C55FMC_MCR_union_tag {   /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t RVE:1;                   /* Read Voltage Error */
    vuint32_t RRE:1;                   /* Read Reference Error */
    vuint32_t AEE:1;                   /* Address Encode Error */
    vuint32_t EEE:1;                   /* ECC after ECC Error */
    vuint32_t  :12;
    vuint32_t EER:1;                   /* ECC Event Error */
    vuint32_t RWE:1;                   /* Read-While-Write Event Error */
    vuint32_t SBC:1;                   /* Single Bit Correction */
    vuint32_t  :1;
    vuint32_t PEAS:1;                  /* Program Access Space */
    vuint32_t DONE:1;                  /* State Machine Status */
    vuint32_t PEG:1;                   /* Program/Erase Good */
    vuint32_t PECIE:1;                 /* Program/Erase Complete Interrupt Enable */
    vuint32_t FERS:1;                  /* Factory Erase and Program */
    vuint32_t  :2;
    vuint32_t PGM:1;                   /* Program */
    vuint32_t PSUS:1;                  /* Program Suspend */
    vuint32_t ERS:1;                   /* Erase */
    vuint32_t ESUS:1;                  /* Erase Suspend */
    vuint32_t EHV:1;                   /* Enable High Voltage */
  } B;
} C55FMC_MCR_tag;

typedef union C55FMC_MCRA_union_tag {  /* Alternate Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :20;
    vuint32_t PEASa:1;                 /* Program Access Space */
    vuint32_t DONEa:1;                 /* State Machine Status */
    vuint32_t PEGa:1;                  /* Program/Erase Good */
    vuint32_t  :4;
    vuint32_t PGMa:1;                  /* Program */
    vuint32_t PSUSa:1;                 /* Program Suspend */
    vuint32_t ERSa:1;                  /* Erase Suspend */
    vuint32_t ESUSa:1;                 /* Erase Suspend */
    vuint32_t EHVa:1;                  /* Enable High Voltage */
  } B;
} C55FMC_MCRA_tag;

typedef union C55FMC_MCRE_union_tag {  /* Extended Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t HT:1;                    /* High Temperature Enabled. */
    vuint32_t  :2;
    vuint32_t n256K:5;
    vuint32_t n64Kh:3;
    vuint32_t n32Kh:2;
    vuint32_t n16Kh:3;
    vuint32_t n64Km:3;
    vuint32_t n32Km:2;
    vuint32_t n16Km:3;
    vuint32_t n64Kl:3;
    vuint32_t n32Kl:2;
    vuint32_t n16Kl:3;
  } B;
} C55FMC_MCRE_tag;

typedef union C55FMC_LOCK0_union_tag { /* Lock 0 register */
  vuint32_t R;
  struct {
    vuint32_t TSLOCK:1;                /* UTest NVM Lock. */
    vuint32_t  :1;
    vuint32_t LOWLOCK:14;              /* Low Block Lock */
    vuint32_t MIDLOCK:16;              /* Mid Block Lock */
  } B;
} C55FMC_LOCK0_tag;

typedef union C55FMC_LOCK1_union_tag { /* Lock 1 register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t HIGHLOCK:16;             /* High Block Lock */
  } B;
} C55FMC_LOCK1_tag;

typedef union C55FMC_LOCK2_union_tag { /* Lock 2 register */
  vuint32_t R;
  struct {
    vuint32_t A256KLOCK:32;            /* 256 KB Block Lock */
  } B;
} C55FMC_LOCK2_tag;

typedef union C55FMC_LOCK3_union_tag { /* Lock 3 register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t A256KLOCK:16;            /* 256 KB Block Lock */
  } B;
} C55FMC_LOCK3_tag;

typedef union C55FMC_LOCK0A_union_tag { /* Alternate Lock 0 register */
  vuint32_t R;
  struct {
    vuint32_t TSLOCKa:1;               /* Alternate UTest NVM Lock. */
    vuint32_t  :1;
    vuint32_t LOWLOCKa:14;             /* Alternate Low Block Lock */
    vuint32_t MIDLOCKa:16;             /* Alternate Mid Block Lock */
  } B;
} C55FMC_LOCK0A_tag;

typedef union C55FMC_LOCK1A_union_tag { /* Alternate Lock 1 register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t HIGHLOCKa:16;            /* Alternate High Block Lock */
  } B;
} C55FMC_LOCK1A_tag;

typedef union C55FMC_SEL0_union_tag {  /* Select 0 register */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t LOWSEL:14;               /* LOW Block Select. */
    vuint32_t MIDSEL:16;               /* Mid Block Select. */
  } B;
} C55FMC_SEL0_tag;

typedef union C55FMC_SEL1_union_tag {  /* Select 1 register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t HIGHSEL:16;              /* High Block Select. */
  } B;
} C55FMC_SEL1_tag;

typedef union C55FMC_SEL2_union_tag {  /* Select 2 register */
  vuint32_t R;
  struct {
    vuint32_t A256KSEL:32;             /* 256 KB Block Select. */
  } B;
} C55FMC_SEL2_tag;

typedef union C55FMC_SEL3_union_tag {  /* Select 3 register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t A256KSEL:16;             /* 256 KB Block Select. */
  } B;
} C55FMC_SEL3_tag;

typedef union C55FMC_ADR_union_tag {   /* Address register */
  vuint32_t R;
  struct {
    vuint32_t SAD:1;
    vuint32_t aH:1;
    vuint32_t aM:1;
    vuint32_t aL:1;
    vuint32_t a256k:1;
    vuint32_t a64k:1;
    vuint32_t a32k:1;
    vuint32_t a16k:1;
    vuint32_t ADDR:21;
    vuint32_t  :3;
  } B;
} C55FMC_ADR_tag;

typedef union C55FMC_UT0_union_tag {   /* UTest 0 register */
  vuint32_t R;
  struct {
    vuint32_t UTE:1;
    vuint32_t SBCE:1;
    vuint32_t  :11;
    vuint32_t CPR:1;
    vuint32_t CPA:1;
    vuint32_t CPE:1;
    vuint32_t  :6;
    vuint32_t NAIBP:1;
    vuint32_t AIBPE:1;
    vuint32_t  :1;
    vuint32_t AISUS:1;
    vuint32_t MRE:1;
    vuint32_t MRV:1;
    vuint32_t  :1;
    vuint32_t AIS:1;
    vuint32_t AIE:1;
    vuint32_t AID:1;
  } B;
} C55FMC_UT0_tag;

typedef union C55FMC_UM_union_tag {    /* UMISR register */
  vuint32_t R;
  struct {
    vuint32_t MISR:32;
  } B;
} C55FMC_UM_tag;

typedef union C55FMC_UM9_union_tag {   /* UMISR register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t MISR:1;                  /* MISR[288]. */
  } B;
} C55FMC_UM9_tag;

typedef union C55FMC_OPP0_union_tag {  /* Over-Program Protection 0 register */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t LOWOPP:14;               /* Low Block Over-Program Protection[13:0]. */
    vuint32_t MIDOPP:16;               /* Mid Block Over-Program Protection[15:0]. */
  } B;
} C55FMC_OPP0_tag;

typedef union C55FMC_OPP1_union_tag {  /* Over-Program Protection 1 register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t HIGHOPP:16;              /* High Block Over-Program Protection[15:0]. */
  } B;
} C55FMC_OPP1_tag;

typedef union C55FMC_OPP2_union_tag {  /* Over-Program Protection 2 register */
  vuint32_t R;
  struct {
    vuint32_t A256KOPP:32;             /* 256K Block Over-Program Protection[31:0]. */
  } B;
} C55FMC_OPP2_tag;

typedef union C55FMC_OPP3_union_tag {  /* Over-Program Protection 3 register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t A256KOPP:16;             /* 256K Block Over-Program Protection[47:32]. */
  } B;
} C55FMC_OPP3_tag;

typedef union C55FMC_TMD_union_tag {   /* Test Mode Disable Password Check register */
  vuint32_t R;
  struct {
    vuint32_t PWD:32;                  /* Password challenge */
  } B;
} C55FMC_TMD_tag;

struct C55FMC_tag {
  C55FMC_MCR_tag MCR;                  /* Module Configuration Register */
  C55FMC_MCRA_tag MCRA;                /* Alternate Module Configuration Register */
  C55FMC_MCRE_tag MCRE;                /* Extended Module Configuration Register */
  uint8_t C55FMC_reserved0[4];
  C55FMC_LOCK0_tag LOCK0;              /* Lock 0 register */
  C55FMC_LOCK1_tag LOCK1;              /* Lock 1 register */
  C55FMC_LOCK2_tag LOCK2;              /* Lock 2 register */
  C55FMC_LOCK3_tag LOCK3;              /* Lock 3 register */
  uint8_t C55FMC_reserved1[8];
  C55FMC_LOCK0A_tag LOCK0A;            /* Alternate Lock 0 register */
  C55FMC_LOCK1A_tag LOCK1A;            /* Alternate Lock 1 register */
  uint8_t C55FMC_reserved2[8];
  C55FMC_SEL0_tag SEL0;                /* Select 0 register */
  C55FMC_SEL1_tag SEL1;                /* Select 1 register */
  C55FMC_SEL2_tag SEL2;                /* Select 2 register */
  C55FMC_SEL3_tag SEL3;                /* Select 3 register */
  uint8_t C55FMC_reserved3[8];
  C55FMC_ADR_tag ADR;                  /* Address register */
  C55FMC_UT0_tag UT0;                  /* UTest 0 register */
  C55FMC_UM_tag UM[9];                 /* UMISR register */
  C55FMC_UM9_tag UM9;                  /* UMISR register */
  C55FMC_OPP0_tag OPP0;                /* Over-Program Protection 0 register */
  C55FMC_OPP1_tag OPP1;                /* Over-Program Protection 1 register */
  C55FMC_OPP2_tag OPP2;                /* Over-Program Protection 2 register */
  C55FMC_OPP3_tag OPP3;                /* Over-Program Protection 3 register */
  C55FMC_TMD_tag TMD;                  /* Test Mode Disable Password Check register */
};


/* ============================================================================
   =============================== Module: CMU ================================
   ============================================================================ */

typedef union CMU_CSR_union_tag {      /* CMU Control Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t SFM:1;                   /* Start frequency measure. */
    vuint32_t  :13;
    vuint32_t CKSEL1:2;                /* Frequency measure clock selection bit. */
    vuint32_t  :5;
    vuint32_t RCDIV:2;                 /* CLKMT0_RMN division factor. */
    vuint32_t CME:1;                   /* CLKMN1 monitor enable. */
  } B;
} CMU_CSR_tag;

typedef union CMU_FDR_union_tag {      /* CMU Frequency Display Register */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t FD:20;                   /* Measured frequency bits. */
  } B;
} CMU_FDR_tag;

typedef union CMU_HFREFR_union_tag {   /* CMU High Frequency Reference Register CLKMN1 */
  vuint32_t R;
  struct {
    vuint32_t  :20;
    vuint32_t HFREF:12;                /* High Frequency reference value. */
  } B;
} CMU_HFREFR_tag;

typedef union CMU_LFREFR_union_tag {   /* CMU Low Frequency Reference Register CLKMN1 */
  vuint32_t R;
  struct {
    vuint32_t  :20;
    vuint32_t LFREF:12;                /* Low Frequency reference value. */
  } B;
} CMU_LFREFR_tag;

typedef union CMU_ISR_union_tag {      /* CMU Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :28;
    vuint32_t  :1;
    vuint32_t FHHI:1;                  /* CLKMN1 frequency higher than high reference event status. */
    vuint32_t FLLI:1;                  /* CLKMN1 frequency less than low reference event status. */
    vuint32_t OLRI:1;                  /* Oscillator frequency less than f CLKMT0_RMN * 2RCDIVevent status. */
  } B;
} CMU_ISR_tag;

typedef union CMU_MDR_union_tag {      /* CMU Measurement Duration Register */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t MD:20;                   /* Measurement duration bits */
  } B;
} CMU_MDR_tag;

struct CMU_tag {
  CMU_CSR_tag CSR;                     /* CMU Control Status Register */
  CMU_FDR_tag FDR;                     /* CMU Frequency Display Register */
  CMU_HFREFR_tag HFREFR;               /* CMU High Frequency Reference Register CLKMN1 */
  CMU_LFREFR_tag LFREFR;               /* CMU Low Frequency Reference Register CLKMN1 */
  CMU_ISR_tag ISR;                     /* CMU Interrupt Status Register */
  uint8_t CMU_reserved0[4];
  CMU_MDR_tag MDR;                     /* CMU Measurement Duration Register */
};


/* ============================================================================
   =============================== Module: CRC ================================
   ============================================================================ */

typedef union CRC_CFG_union_tag {      /* Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t  :18;
    vuint32_t SWAP_BYTEWISE:1;         /* Swap CRC_INP byte-wise */
    vuint32_t SWAP_BITWISE:1;          /* Swap CRC_INP bit-wise */
    vuint32_t POLYG:2;                 /* Polynomial selection */
    vuint32_t SWAP:1;                  /* Swap selection */
    vuint32_t INV:1;                   /* Inversion selection */
  } B;
} CRC_CFG_tag;

typedef union CRC_INP_union_tag {      /* Input Register */
  vuint32_t R;
  struct {
    vuint32_t INP:32;                  /* Input data for the CRC computation */
  } B;
} CRC_INP_tag;

typedef union CRC_CSTAT_union_tag {    /* Current Status Register */
  vuint32_t R;
  struct {
    vuint32_t CSTAT:32;                /* CRC signature status */
  } B;
} CRC_CSTAT_tag;

typedef union CRC_OUTP_union_tag {     /* Output Register */
  vuint32_t R;
  struct {
    vuint32_t OUTP:32;                 /* Final CRC signature */
  } B;
} CRC_OUTP_tag;

struct CRC_tag {
  CRC_CFG_tag CFG;                     /* Configuration Register */
  CRC_INP_tag INP;                     /* Input Register */
  CRC_CSTAT_tag CSTAT;                 /* Current Status Register */
  CRC_OUTP_tag OUTP;                   /* Output Register */
};


/* ============================================================================
   =============================== Module: DMAMUX =============================
   ============================================================================ */

typedef union DMAMUX_CHCFG_union_tag { /* Channel Configuration register */
  vuint8_t R;
  struct {
    vuint8_t ENBL:1;                   /* DMA Channel Enable */
    vuint8_t TRIG:1;                   /* DMA Channel Trigger Enable */
    vuint8_t SOURCE:6;                 /* DMA Channel Source (Slot) */
  } B;
} DMAMUX_CHCFG_tag;

struct DMAMUX_tag {
  DMAMUX_CHCFG_tag CHCFG[16];          /* Channel Configuration register */
};


/* ============================================================================
   =============================== Module: DSPI ===============================
   ============================================================================ */

typedef union DSPI_MCR_union_tag {     /* DSPI Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MSTR:1;
    vuint32_t CONT_SCKE:1;
    vuint32_t DCONF:2;
    vuint32_t FRZ:1;
    vuint32_t MTFE:1;
    vuint32_t PCSSE:1;
    vuint32_t ROOE:1;
    vuint32_t PCSIS:8;
    vuint32_t  :1;
    vuint32_t MDIS:1;
    vuint32_t DIS_TXF:1;
    vuint32_t DIS_RXF:1;
    vuint32_t CLR_TXF:1;
    vuint32_t CLR_RXF:1;
    vuint32_t SMPL_PT:2;
    vuint32_t  :4;
    vuint32_t XSPI:1;
    vuint32_t FCPCS:1;
    vuint32_t PES:1;
    vuint32_t HALT:1;
  } B;
} DSPI_MCR_tag;

typedef union DSPI_TCR_union_tag {     /* DSPI Transfer Count Register */
  vuint32_t R;
  struct {
    vuint32_t SPI_TCNT:16;
    vuint32_t  :16;
  } B;
} DSPI_TCR_tag;

typedef union DSPI_MODE_CTAR_union_tag { /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
  vuint32_t R;
  struct {
    vuint32_t DBR:1;
    vuint32_t FMSZ:4;
    vuint32_t CPOL:1;
    vuint32_t CPHA:1;
    vuint32_t LSBFE:1;
    vuint32_t PCSSCK:2;
    vuint32_t PASC:2;
    vuint32_t PDT:2;
    vuint32_t PBR:2;
    vuint32_t CSSCK:4;
    vuint32_t ASC:4;
    vuint32_t DT:4;
    vuint32_t BR:4;
  } B;
} DSPI_MODE_CTAR_tag;

typedef union DSPI_MODE_CTAR_SLAVE_union_tag { /* DSPI Clock and Transfer Attributes Register (In Slave Mode) */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t FMSZ:4;                  /* Frame Size */
    vuint32_t CPOL:1;
    vuint32_t CPHA:1;
    vuint32_t PE:1;
    vuint32_t PP:1;
    vuint32_t  :1;
    vuint32_t  :22;
  } B;
} DSPI_MODE_CTAR_SLAVE_tag;

typedef union DSPI_MODE_union_tag {
  DSPI_MODE_CTAR_tag CTAR[8];          /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
  DSPI_MODE_CTAR_SLAVE_tag CTAR_SLAVE[2]; /* DSPI Clock and Transfer Attributes Register (In Slave Mode) */
} DSPI_MODE_tag;

typedef union DSPI_SR_union_tag {      /* DSPI Status Register */
  vuint32_t R;
  struct {
    vuint32_t TCF:1;
    vuint32_t TXRXS:1;
    vuint32_t SPITCF:1;
    vuint32_t EOQF:1;
    vuint32_t TFUF:1;
    vuint32_t DSITCF:1;
    vuint32_t TFFF:1;
    vuint32_t BSYF:1;
    vuint32_t CMDTCF:1;
    vuint32_t DPEF:1;
    vuint32_t SPEF:1;
    vuint32_t DDIF:1;
    vuint32_t RFOF:1;
    vuint32_t TFIWF:1;
    vuint32_t RFDF:1;
    vuint32_t CMDFFF:1;
    vuint32_t TXCTR:4;
    vuint32_t TXNXTPTR:4;
    vuint32_t RXCTR:4;
    vuint32_t POPNXTPTR:4;
  } B;
} DSPI_SR_tag;

typedef union DSPI_RSER_union_tag {    /* DSPI DMA/Interrupt Request Select and Enable Register */
  vuint32_t R;
  struct {
    vuint32_t TCF_RE:1;
    vuint32_t CMDFFF_RE:1;
    vuint32_t SPITCF_RE:1;
    vuint32_t EOQF_RE:1;
    vuint32_t TFUF_RE:1;
    vuint32_t DSITCF_RE:1;
    vuint32_t TFFF_RE:1;
    vuint32_t TFFF_DIRS:1;
    vuint32_t CMDTCF_RE:1;
    vuint32_t DPEF_RE:1;
    vuint32_t SPEF_RE:1;
    vuint32_t DDIF_RE:1;
    vuint32_t RFOF_RE:1;
    vuint32_t TFIWF_RE:1;
    vuint32_t RFDF_RE:1;
    vuint32_t RFDF_DIRS:1;
    vuint32_t CMDFFF_DIRS:1;
    vuint32_t DDIF_DIRS:1;
    vuint32_t  :14;
  } B;
} DSPI_RSER_tag;

typedef union DSPI_PUSHR_PUSHR_union_tag { /* DSPI PUSH FIFO Register In Master Mode */
  vuint32_t R;
  struct {
    vuint32_t CONT:1;
    vuint32_t CTAS:3;
    vuint32_t EOQ:1;
    vuint32_t CTCNT:1;
    vuint32_t PE_MASC:1;
    vuint32_t PP_MCSC:1;
    vuint32_t PCS:8;
    vuint32_t TXDATA:16;
  } B;
} DSPI_PUSHR_PUSHR_tag;

typedef union DSPI_PUSHR_PUSHR_SLAVE_union_tag { /* DSPI PUSH FIFO Register In Slave Mode */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t TXDATA:16;
  } B;
} DSPI_PUSHR_PUSHR_SLAVE_tag;

typedef union DSPI_PUSHR_union_tag {
  DSPI_PUSHR_PUSHR_tag PUSHR;          /* DSPI PUSH FIFO Register In Master Mode */
  DSPI_PUSHR_PUSHR_SLAVE_tag PUSHR_SLAVE; /* DSPI PUSH FIFO Register In Slave Mode */
} DSPI_PUSHR_tag;

typedef union DSPI_POPR_union_tag {    /* DSPI POP FIFO Register */
  vuint32_t R;
  struct {
    vuint32_t RXDATA:32;
  } B;
} DSPI_POPR_tag;

typedef union DSPI_TXFR_union_tag {    /* DSPI Transmit FIFO Registers */
  vuint32_t R;
  struct {
    vuint32_t TXCMD_TXDATA:16;
    vuint32_t TXDATA:16;
  } B;
} DSPI_TXFR_tag;

typedef union DSPI_RXFR_union_tag {    /* DSPI Receive FIFO Registers */
  vuint32_t R;
  struct {
    vuint32_t RXDATA:32;
  } B;
} DSPI_RXFR_tag;

typedef union DSPI_DSICR0_union_tag {  /* DSPI DSI Configuration Register 0 */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t FMSZ4:1;
    vuint32_t  :6;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t ITSB:1;
    vuint32_t TSBC:1;
    vuint32_t TXSS:1;
    vuint32_t TPOL:1;
    vuint32_t  :1;
    vuint32_t CID:1;
    vuint32_t DCONT:1;
    vuint32_t DSICTAS:3;
    vuint32_t DMS:1;
    vuint32_t PES:1;
    vuint32_t PE:1;
    vuint32_t PP:1;
    vuint32_t DPCSx:8;
  } B;
} DSPI_DSICR0_tag;

typedef union DSPI_SDR0_union_tag {    /* DSPI DSI Serialization Data Register 0 */
  vuint32_t R;
  struct {
    vuint32_t SER_DATA:32;
  } B;
} DSPI_SDR0_tag;

typedef union DSPI_ASDR0_union_tag {   /* DSPI DSI Alternate Serialization Data Register 0 */
  vuint32_t R;
  struct {
    vuint32_t ASER_DATA:32;
  } B;
} DSPI_ASDR0_tag;

typedef union DSPI_COMPR0_union_tag {  /* DSPI DSI Transmit Comparison Register 0 */
  vuint32_t R;
  struct {
    vuint32_t COMP_DATA:32;
  } B;
} DSPI_COMPR0_tag;

typedef union DSPI_DDR0_union_tag {    /* DSPI DSI Deserialization Data Register 0 */
  vuint32_t R;
  struct {
    vuint32_t DESER_DATA:32;
  } B;
} DSPI_DDR0_tag;

typedef union DSPI_DSICR1_union_tag {  /* DSPI DSI Configuration Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :3;
    vuint32_t TSBCNT:5;
    vuint32_t  :5;
    vuint32_t  :1;
    vuint32_t DSE1:1;
    vuint32_t DSE0:1;
    vuint32_t TRGPRD:8;
    vuint32_t DPCS1_x:8;
  } B;
} DSPI_DSICR1_tag;

typedef union DSPI_SSR0_union_tag {    /* DSPI DSI Serialization Source Select Register 0 */
  vuint32_t R;
  struct {
    vuint32_t SS:32;
  } B;
} DSPI_SSR0_tag;

typedef union DSPI_DIMR0_union_tag {   /* DSPI DSI Deserialized Data Interrupt Mask Register 0 */
  vuint32_t R;
  struct {
    vuint32_t MASK:32;
  } B;
} DSPI_DIMR0_tag;

typedef union DSPI_DPIR0_union_tag {   /* DSPI DSI Deserialized Data Polarity Interrupt Register 0 */
  vuint32_t R;
  struct {
    vuint32_t DP:32;
  } B;
} DSPI_DPIR0_tag;

typedef union DSPI_CTARE_union_tag {   /* DSPI Clock and Transfer Attributes Register Extended */
  vuint32_t R;
  struct {
    vuint32_t  :15;
    vuint32_t FMSZE:1;
    vuint32_t  :5;
    vuint32_t DTCP:11;
  } B;
} DSPI_CTARE_tag;

typedef union DSPI_SREX_union_tag {    /* DSPI Status Register Extended */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t CMDCTR:4;
    vuint32_t CMDNXTPTR:4;
  } B;
} DSPI_SREX_tag;

struct DSPI_tag {
  DSPI_MCR_tag MCR;                    /* DSPI Module Configuration Register */
  uint8_t DSPI_reserved0[4];
  DSPI_TCR_tag TCR;                    /* DSPI Transfer Count Register */
  DSPI_MODE_tag MODE;
  DSPI_SR_tag SR;                      /* DSPI Status Register */
  DSPI_RSER_tag RSER;                  /* DSPI DMA/Interrupt Request Select and Enable Register */
  DSPI_PUSHR_tag PUSHR;
  DSPI_POPR_tag POPR;                  /* DSPI POP FIFO Register */
  DSPI_TXFR_tag TXFR[4];               /* DSPI Transmit FIFO Registers */
  uint8_t DSPI_reserved1[48];
  DSPI_RXFR_tag RXFR[4];               /* DSPI Receive FIFO Registers */
  uint8_t DSPI_reserved2[48];
  DSPI_DSICR0_tag DSICR0;              /* DSPI DSI Configuration Register 0 */
  DSPI_SDR0_tag SDR0;                  /* DSPI DSI Serialization Data Register 0 */
  DSPI_ASDR0_tag ASDR0;                /* DSPI DSI Alternate Serialization Data Register 0 */
  DSPI_COMPR0_tag COMPR0;              /* DSPI DSI Transmit Comparison Register 0 */
  DSPI_DDR0_tag DDR0;                  /* DSPI DSI Deserialization Data Register 0 */
  DSPI_DSICR1_tag DSICR1;              /* DSPI DSI Configuration Register 1 */
  DSPI_SSR0_tag SSR0;                  /* DSPI DSI Serialization Source Select Register 0 */
  uint8_t DSPI_reserved3[16];
  DSPI_DIMR0_tag DIMR0;                /* DSPI DSI Deserialized Data Interrupt Mask Register 0 */
  DSPI_DPIR0_tag DPIR0;                /* DSPI DSI Deserialized Data Polarity Interrupt Register 0 */
  uint8_t DSPI_reserved4[44];
  DSPI_CTARE_tag CTARE[8];             /* DSPI Clock and Transfer Attributes Register Extended */
  DSPI_SREX_tag SREX;                  /* DSPI Status Register Extended */
};


/* ============================================================================
   =============================== Module: DTS ================================
   ============================================================================ */

typedef union DTS_ENABLE_union_tag {   /* Output Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :30;
    vuint32_t DTS_EN_B:1;
    vuint32_t DTS_EN:1;
  } B;
} DTS_ENABLE_tag;

typedef union DTS_STARTUP_union_tag {  /* Startup Register */
  vuint32_t R;
  struct {
    vuint32_t AD:32;
  } B;
} DTS_STARTUP_tag;

typedef union DTS_SEMAPHORE_union_tag { /* Semaphore Register */
  vuint32_t R;
  struct {
    vuint32_t ST:32;
  } B;
} DTS_SEMAPHORE_tag;

typedef union DTS_SEMAPHORE_B_union_tag { /* Semaphore Extension */
  vuint32_t R;
  struct {
    vuint32_t ST_B:32;
  } B;
} DTS_SEMAPHORE_B_tag;

struct DTS_tag {
  DTS_ENABLE_tag ENABLE;               /* Output Enable Register */
  DTS_STARTUP_tag STARTUP;             /* Startup Register */
  DTS_SEMAPHORE_tag SEMAPHORE;         /* Semaphore Register */
  DTS_SEMAPHORE_B_tag SEMAPHORE_B;     /* Semaphore Extension */
};


/* ============================================================================
   =============================== Module: EBI ================================
   ============================================================================ */

typedef union EBI_MCR_union_tag {      /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t ACGE:1;
    vuint32_t  :2;
    vuint32_t  :2;
    vuint32_t  :4;
    vuint32_t MDIS:1;
    vuint32_t  :3;
    vuint32_t D16_31:1;
    vuint32_t  :1;
    vuint32_t DBM:1;
  } B;
} EBI_MCR_tag;

typedef union EBI_BR0_union_tag {      /* Base Register Bank */
  vuint32_t R;
  struct {
    vuint32_t BA:17;
    vuint32_t  :2;
    vuint32_t LWRN:1;
    vuint32_t PS:1;
    vuint32_t EOE:2;
    vuint32_t SBL:1;
    vuint32_t AD_MUX:1;
    vuint32_t BL:1;
    vuint32_t WEBS:1;
    vuint32_t TBDIP:1;
    vuint32_t GCSN:1;
    vuint32_t  :1;
    vuint32_t BI:1;
    vuint32_t V:1;
  } B;
} EBI_BR0_tag;

typedef union EBI_OR0_union_tag {      /* Option Register Bank */
  vuint32_t R;
  struct {
    vuint32_t AM:17;
    vuint32_t  :2;
    vuint32_t APS:1;                   /* Address by Port Size */
    vuint32_t  :1;
    vuint32_t AWE:1;                   /* Address / Write Enable Select */
    vuint32_t  :2;
    vuint32_t SCY:4;
    vuint32_t  :1;
    vuint32_t BSCY:2;
    vuint32_t  :1;
  } B;
} EBI_OR0_tag;

typedef union EBI_BR1_union_tag {      /* Base Register Bank */
  vuint32_t R;
  struct {
    vuint32_t BA:17;
    vuint32_t  :2;
    vuint32_t LWRN:1;
    vuint32_t PS:1;
    vuint32_t EOE:2;
    vuint32_t SBL:1;
    vuint32_t AD_MUX:1;
    vuint32_t BL:1;
    vuint32_t WEBS:1;
    vuint32_t TBDIP:1;
    vuint32_t GCSN:1;
    vuint32_t  :1;
    vuint32_t BI:1;
    vuint32_t V:1;
  } B;
} EBI_BR1_tag;

typedef union EBI_OR1_union_tag {      /* Option Register Bank */
  vuint32_t R;
  struct {
    vuint32_t AM:17;
    vuint32_t  :2;
    vuint32_t APS:1;                   /* Address by Port Size */
    vuint32_t  :1;
    vuint32_t AWE:1;                   /* Address / Write Enable Select */
    vuint32_t  :2;
    vuint32_t SCY:4;
    vuint32_t  :1;
    vuint32_t BSCY:2;
    vuint32_t  :1;
  } B;
} EBI_OR1_tag;

typedef union EBI_BR2_union_tag {      /* Base Register Bank */
  vuint32_t R;
  struct {
    vuint32_t BA:17;
    vuint32_t  :2;
    vuint32_t LWRN:1;
    vuint32_t PS:1;
    vuint32_t EOE:2;
    vuint32_t SBL:1;
    vuint32_t AD_MUX:1;
    vuint32_t BL:1;
    vuint32_t WEBS:1;
    vuint32_t TBDIP:1;
    vuint32_t GCSN:1;
    vuint32_t  :1;
    vuint32_t BI:1;
    vuint32_t V:1;
  } B;
} EBI_BR2_tag;

typedef union EBI_OR2_union_tag {      /* Option Register Bank */
  vuint32_t R;
  struct {
    vuint32_t AM:17;
    vuint32_t  :2;
    vuint32_t APS:1;                   /* Address by Port Size */
    vuint32_t  :1;
    vuint32_t AWE:1;                   /* Address / Write Enable Select */
    vuint32_t  :2;
    vuint32_t SCY:4;
    vuint32_t  :1;
    vuint32_t BSCY:2;
    vuint32_t  :1;
  } B;
} EBI_OR2_tag;

struct EBI_tag {
  EBI_MCR_tag MCR;                     /* Module Configuration Register */
  uint8_t EBI_reserved0[12];
  EBI_BR0_tag BR0;                     /* Base Register Bank */
  EBI_OR0_tag OR0;                     /* Option Register Bank */
  EBI_BR1_tag BR1;                     /* Base Register Bank */
  EBI_OR1_tag OR1;                     /* Option Register Bank */
  EBI_BR2_tag BR2;                     /* Base Register Bank */
  EBI_OR2_tag OR2;                     /* Option Register Bank */
};


/* ============================================================================
   =============================== Module: FCCU ===============================
   ============================================================================ */

typedef union FCCU_CTRL_union_tag {    /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t FILTER_BYPASS:1;
    vuint32_t FILTER_WIDTH:2;
    vuint32_t  :19;
    vuint32_t DEBUG:1;
    vuint32_t  :1;
    vuint32_t OPS:2;
    vuint32_t  :1;
    vuint32_t OPR:5;
  } B;
} FCCU_CTRL_tag;

typedef union FCCU_CTRLK_union_tag {   /* CTRL Key Register */
  vuint32_t R;
  struct {
    vuint32_t CTRLK:32;
  } B;
} FCCU_CTRLK_tag;

typedef union FCCU_CFG_union_tag {     /* Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :7;
    vuint32_t FCCU_SET_AFTER_RESET:1;
    vuint32_t FCCU_SET_CLEAR:2;
    vuint32_t  :2;
    vuint32_t  :4;
    vuint32_t  :1;
    vuint32_t  :2;
    vuint32_t OD:1;
    vuint32_t  :1;
    vuint32_t SM:1;
    vuint32_t PS:1;
    vuint32_t FOM:3;
    vuint32_t  :6;
  } B;
} FCCU_CFG_tag;

typedef union FCCU_RF_CFG_union_tag {  /* RF Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t RFC31:1;
    vuint32_t RFC30:1;
    vuint32_t RFC29:1;
    vuint32_t RFC28:1;
    vuint32_t RFC27:1;
    vuint32_t RFC26:1;
    vuint32_t RFC25:1;
    vuint32_t RFC24:1;
    vuint32_t RFC23:1;
    vuint32_t RFC22:1;
    vuint32_t RFC21:1;
    vuint32_t RFC20:1;
    vuint32_t RFC19:1;
    vuint32_t RFC18:1;
    vuint32_t RFC17:1;
    vuint32_t RFC16:1;
    vuint32_t RFC15:1;
    vuint32_t RFC14:1;
    vuint32_t RFC13:1;
    vuint32_t RFC12:1;
    vuint32_t RFC11:1;
    vuint32_t RFC10:1;
    vuint32_t RFC9:1;
    vuint32_t RFC8:1;
    vuint32_t RFC7:1;
    vuint32_t RFC6:1;
    vuint32_t RFC5:1;
    vuint32_t RFC4:1;
    vuint32_t RFC3:1;
    vuint32_t RFC2:1;
    vuint32_t RFC1:1;
    vuint32_t RFC0:1;
  } B;
} FCCU_RF_CFG_tag;

typedef union FCCU_RFS_CFG_union_tag { /* RFS Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t RFSC31:1;
    vuint32_t RFSC30:1;
    vuint32_t RFSC29:1;
    vuint32_t RFSC28:1;
    vuint32_t RFSC27:1;
    vuint32_t RFSC26:1;
    vuint32_t RFSC25:1;
    vuint32_t RFSC24:1;
    vuint32_t RFSC23:1;
    vuint32_t RFSC22:1;
    vuint32_t RFSC21:1;
    vuint32_t RFSC20:1;
    vuint32_t RFSC19:1;
    vuint32_t RFSC18:1;
    vuint32_t RFSC17:1;
    vuint32_t RFSC16:1;
    vuint32_t RFSC15:1;
    vuint32_t RFSC14:1;
    vuint32_t RFSC13:1;
    vuint32_t RFSC12:1;
    vuint32_t RFSC11:1;
    vuint32_t RFSC10:1;
    vuint32_t RFSC9:1;
    vuint32_t RFSC8:1;
    vuint32_t RFSC7:1;
    vuint32_t RFSC6:1;
    vuint32_t RFSC5:1;
    vuint32_t RFSC4:1;
    vuint32_t RFSC3:1;
    vuint32_t RFSC2:1;
    vuint32_t RFSC1:1;
    vuint32_t RFSC0:1;
  } B;
} FCCU_RFS_CFG_tag;

typedef union FCCU_RF_S_union_tag {    /* UF Status Register */
  vuint32_t R;
  struct {
    vuint32_t RFS31:1;
    vuint32_t RFS30:1;
    vuint32_t RFS29:1;
    vuint32_t RFS28:1;
    vuint32_t RFS27:1;
    vuint32_t RFS26:1;
    vuint32_t RFS25:1;
    vuint32_t RFS24:1;
    vuint32_t RFS23:1;
    vuint32_t RFS22:1;
    vuint32_t RFS21:1;
    vuint32_t RFS20:1;
    vuint32_t RFS19:1;
    vuint32_t RFS18:1;
    vuint32_t RFS17:1;
    vuint32_t RFS16:1;
    vuint32_t RFS15:1;
    vuint32_t RFS14:1;
    vuint32_t RFS13:1;
    vuint32_t RFS12:1;
    vuint32_t RFS11:1;
    vuint32_t RFS10:1;
    vuint32_t RFS9:1;
    vuint32_t RFS8:1;
    vuint32_t RFS7:1;
    vuint32_t RFS6:1;
    vuint32_t RFS5:1;
    vuint32_t RFS4:1;
    vuint32_t RFS3:1;
    vuint32_t RFS2:1;
    vuint32_t RFS1:1;
    vuint32_t RFS0:1;
  } B;
} FCCU_RF_S_tag;

typedef union FCCU_RFK_union_tag {     /* RF Key Register */
  vuint32_t R;
  struct {
    vuint32_t RFK:32;
  } B;
} FCCU_RFK_tag;

typedef union FCCU_RF_E_union_tag {    /* RF Enable Register */
  vuint32_t R;
  struct {
    vuint32_t RFE31:1;
    vuint32_t RFE30:1;
    vuint32_t RFE29:1;
    vuint32_t RFE28:1;
    vuint32_t RFE27:1;
    vuint32_t RFE26:1;
    vuint32_t RFE25:1;
    vuint32_t RFE24:1;
    vuint32_t RFE23:1;
    vuint32_t RFE22:1;
    vuint32_t RFE21:1;
    vuint32_t RFE20:1;
    vuint32_t RFE19:1;
    vuint32_t RFE18:1;
    vuint32_t RFE17:1;
    vuint32_t RFE16:1;
    vuint32_t RFE15:1;
    vuint32_t RFE14:1;
    vuint32_t RFE13:1;
    vuint32_t RFE12:1;
    vuint32_t RFE11:1;
    vuint32_t RFE10:1;
    vuint32_t RFE9:1;
    vuint32_t RFE8:1;
    vuint32_t RFE7:1;
    vuint32_t RFE6:1;
    vuint32_t RFE5:1;
    vuint32_t RFE4:1;
    vuint32_t RFE3:1;
    vuint32_t RFE2:1;
    vuint32_t RFE1:1;
    vuint32_t RFE0:1;
  } B;
} FCCU_RF_E_tag;

typedef union FCCU_RF_TOE_union_tag {  /* RF Time-out Enable Register */
  vuint32_t R;
  struct {
    vuint32_t RFTOE31:1;
    vuint32_t RFTOE30:1;
    vuint32_t RFTOE29:1;
    vuint32_t RFTOE28:1;
    vuint32_t RFTOE27:1;
    vuint32_t RFTOE26:1;
    vuint32_t RFTOE25:1;
    vuint32_t RFTOE24:1;
    vuint32_t RFTOE23:1;
    vuint32_t RFTOE22:1;
    vuint32_t RFTOE21:1;
    vuint32_t RFTOE20:1;
    vuint32_t RFTOE19:1;
    vuint32_t RFTOE18:1;
    vuint32_t RFTOE17:1;
    vuint32_t RFTOE16:1;
    vuint32_t RFTOE15:1;
    vuint32_t RFTOE14:1;
    vuint32_t RFTOE13:1;
    vuint32_t RFTOE12:1;
    vuint32_t RFTOE11:1;
    vuint32_t RFTOE10:1;
    vuint32_t RFTOE9:1;
    vuint32_t RFTOE8:1;
    vuint32_t RFTOE7:1;
    vuint32_t RFTOE6:1;
    vuint32_t RFTOE5:1;
    vuint32_t RFTOE4:1;
    vuint32_t RFTOE3:1;
    vuint32_t RFTOE2:1;
    vuint32_t RFTOE1:1;
    vuint32_t RFTOE0:1;
  } B;
} FCCU_RF_TOE_tag;

typedef union FCCU_RF_TO_union_tag {   /* RF Time-out Register */
  vuint32_t R;
  struct {
    vuint32_t TO:32;
  } B;
} FCCU_RF_TO_tag;

typedef union FCCU_CFG_TO_union_tag {  /* CFG Timeout Register */
  vuint32_t R;
  struct {
    vuint32_t  :29;
    vuint32_t TO:3;
  } B;
} FCCU_CFG_TO_tag;

typedef union FCCU_EINOUT_union_tag {  /* IO Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t EIN1:1;
    vuint32_t EIN0:1;
    vuint32_t  :2;
    vuint32_t EOUT1:1;
    vuint32_t EOUT0:1;
  } B;
} FCCU_EINOUT_tag;

typedef union FCCU_STAT_union_tag {    /* Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t PhysicErrorPin:2;
    vuint32_t ESTAT:1;
    vuint32_t STATUS:3;
  } B;
} FCCU_STAT_tag;

typedef union FCCU_N2AF_STATUS_union_tag { /* NA Freeze Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t NAFS:8;
  } B;
} FCCU_N2AF_STATUS_tag;

typedef union FCCU_A2FF_STATUS_union_tag { /* AF Freeze Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t AF_SRC:2;
    vuint32_t AFFS:8;
  } B;
} FCCU_A2FF_STATUS_tag;

typedef union FCCU_N2FF_STATUS_union_tag { /* NF Freeze Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t NF_SRC:2;
    vuint32_t NFFS:8;
  } B;
} FCCU_N2FF_STATUS_tag;

typedef union FCCU_F2A_STATUS_union_tag { /* FA Freeze Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :23;
    vuint32_t FAFS:9;
  } B;
} FCCU_F2A_STATUS_tag;

typedef union FCCU_RFF_union_tag {     /* RF Fake Register */
  vuint32_t R;
  struct {
    vuint32_t  :25;
    vuint32_t FRFC:7;
  } B;
} FCCU_RFF_tag;

typedef union FCCU_IRQ_STAT_union_tag { /* IRQ Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :27;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t NMI_STAT:1;
    vuint32_t ALRM_STAT:1;
    vuint32_t CFG_TO_STAT:1;
  } B;
} FCCU_IRQ_STAT_tag;

typedef union FCCU_IRQ_EN_union_tag {  /* IRQ Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :28;
    vuint32_t  :1;
    vuint32_t  :2;
    vuint32_t CFG_TO_IEN:1;
  } B;
} FCCU_IRQ_EN_tag;

typedef union FCCU_XTMR_union_tag {    /* XTMR Register */
  vuint32_t R;
  struct {
    vuint32_t XTMR:32;
  } B;
} FCCU_XTMR_tag;

typedef union FCCU_MCS_union_tag {     /* MCS Register */
  vuint32_t R;
  struct {
    vuint32_t VL3:1;
    vuint32_t FS3:1;
    vuint32_t  :2;
    vuint32_t MCS3:4;
    vuint32_t VL2:1;
    vuint32_t FS2:1;
    vuint32_t  :2;
    vuint32_t MCS2:4;
    vuint32_t VL1:1;
    vuint32_t FS1:1;
    vuint32_t  :2;
    vuint32_t MCS1:4;
    vuint32_t VL0:1;
    vuint32_t FS0:1;
    vuint32_t  :2;
    vuint32_t MCS0:4;
  } B;
} FCCU_MCS_tag;

typedef union FCCU_TRANS_LOCK_union_tag { /* Transient Lock Register */
  vuint32_t R;
  struct {
    vuint32_t  :23;
    vuint32_t TRANSKEY:9;
  } B;
} FCCU_TRANS_LOCK_tag;

typedef union FCCU_PERMNT_LOCK_union_tag { /* Permanent Lock Register */
  vuint32_t R;
  struct {
    vuint32_t  :23;
    vuint32_t PERMNTKEY:9;
  } B;
} FCCU_PERMNT_LOCK_tag;

typedef union FCCU_DELTA_T_union_tag { /* Delta T Register */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t  :14;
    vuint32_t  :2;
    vuint32_t DELTA_T:14;
  } B;
} FCCU_DELTA_T_tag;

typedef union FCCU_IRQ_ALARM_EN_union_tag { /* IRQ Alarm Enable Register */
  vuint32_t R;
  struct {
    vuint32_t IRQEN31:1;
    vuint32_t IRQEN30:1;
    vuint32_t IRQEN29:1;
    vuint32_t IRQEN28:1;
    vuint32_t IRQEN27:1;
    vuint32_t IRQEN26:1;
    vuint32_t IRQEN25:1;
    vuint32_t IRQEN24:1;
    vuint32_t IRQEN23:1;
    vuint32_t IRQEN22:1;
    vuint32_t IRQEN21:1;
    vuint32_t IRQEN20:1;
    vuint32_t IRQEN19:1;
    vuint32_t IRQEN18:1;
    vuint32_t IRQEN17:1;
    vuint32_t IRQEN16:1;
    vuint32_t IRQEN15:1;
    vuint32_t IRQEN14:1;
    vuint32_t IRQEN13:1;
    vuint32_t IRQEN12:1;
    vuint32_t IRQEN11:1;
    vuint32_t IRQEN10:1;
    vuint32_t IRQEN9:1;
    vuint32_t IRQEN8:1;
    vuint32_t IRQEN7:1;
    vuint32_t IRQEN6:1;
    vuint32_t IRQEN5:1;
    vuint32_t IRQEN4:1;
    vuint32_t IRQEN3:1;
    vuint32_t IRQEN2:1;
    vuint32_t IRQEN1:1;
    vuint32_t IRQEN0:1;
  } B;
} FCCU_IRQ_ALARM_EN_tag;

typedef union FCCU_NMI_EN_union_tag {  /* NMI Enable Register */
  vuint32_t R;
  struct {
    vuint32_t NMIEN31:1;
    vuint32_t NMIEN30:1;
    vuint32_t NMIEN29:1;
    vuint32_t NMIEN28:1;
    vuint32_t NMIEN27:1;
    vuint32_t NMIEN26:1;
    vuint32_t NMIEN25:1;
    vuint32_t NMIEN24:1;
    vuint32_t NMIEN23:1;
    vuint32_t NMIEN22:1;
    vuint32_t NMIEN21:1;
    vuint32_t NMIEN20:1;
    vuint32_t NMIEN19:1;
    vuint32_t NMIEN18:1;
    vuint32_t NMIEN17:1;
    vuint32_t NMIEN16:1;
    vuint32_t NMIEN15:1;
    vuint32_t NMIEN14:1;
    vuint32_t NMIEN13:1;
    vuint32_t NMIEN12:1;
    vuint32_t NMIEN11:1;
    vuint32_t NMIEN10:1;
    vuint32_t NMIEN9:1;
    vuint32_t NMIEN8:1;
    vuint32_t NMIEN7:1;
    vuint32_t NMIEN6:1;
    vuint32_t NMIEN5:1;
    vuint32_t NMIEN4:1;
    vuint32_t NMIEN3:1;
    vuint32_t NMIEN2:1;
    vuint32_t NMIEN1:1;
    vuint32_t NMIEN0:1;
  } B;
} FCCU_NMI_EN_tag;

typedef union FCCU_EOUT_SIG_EN_union_tag { /* EOUT Signaling Enable Register */
  vuint32_t R;
  struct {
    vuint32_t EOUTEN31:1;
    vuint32_t EOUTEN30:1;
    vuint32_t EOUTEN29:1;
    vuint32_t EOUTEN28:1;
    vuint32_t EOUTEN27:1;
    vuint32_t EOUTEN26:1;
    vuint32_t EOUTEN25:1;
    vuint32_t EOUTEN24:1;
    vuint32_t EOUTEN23:1;
    vuint32_t EOUTEN22:1;
    vuint32_t EOUTEN21:1;
    vuint32_t EOUTEN20:1;
    vuint32_t EOUTEN19:1;
    vuint32_t EOUTEN18:1;
    vuint32_t EOUTEN17:1;
    vuint32_t EOUTEN16:1;
    vuint32_t EOUTEN15:1;
    vuint32_t EOUTEN14:1;
    vuint32_t EOUTEN13:1;
    vuint32_t EOUTEN12:1;
    vuint32_t EOUTEN11:1;
    vuint32_t EOUTEN10:1;
    vuint32_t EOUTEN9:1;
    vuint32_t EOUTEN8:1;
    vuint32_t EOUTEN7:1;
    vuint32_t EOUTEN6:1;
    vuint32_t EOUTEN5:1;
    vuint32_t EOUTEN4:1;
    vuint32_t EOUTEN3:1;
    vuint32_t EOUTEN2:1;
    vuint32_t EOUTEN1:1;
    vuint32_t EOUTEN0:1;
  } B;
} FCCU_EOUT_SIG_EN_tag;

struct FCCU_tag {
  FCCU_CTRL_tag CTRL;                  /* Control Register */
  FCCU_CTRLK_tag CTRLK;                /* CTRL Key Register */
  FCCU_CFG_tag CFG;                    /* Configuration Register */
  uint8_t FCCU_reserved0[16];
  FCCU_RF_CFG_tag RF_CFG[4];           /* RF Configuration Register */
  uint8_t FCCU_reserved1[32];
  FCCU_RFS_CFG_tag RFS_CFG[8];         /* RFS Configuration Register */
  uint8_t FCCU_reserved2[20];
  FCCU_RF_S_tag RF_S[4];               /* UF Status Register */
  FCCU_RFK_tag RFK;                    /* RF Key Register */
  FCCU_RF_E_tag RF_E[4];               /* RF Enable Register */
  FCCU_RF_TOE_tag RF_TOE[4];           /* RF Time-out Enable Register */
  FCCU_RF_TO_tag RF_TO;                /* RF Time-out Register */
  FCCU_CFG_TO_tag CFG_TO;              /* CFG Timeout Register */
  FCCU_EINOUT_tag EINOUT;              /* IO Control Register */
  FCCU_STAT_tag STAT;                  /* Status Register */
  FCCU_N2AF_STATUS_tag N2AF_STATUS;    /* NA Freeze Status Register */
  FCCU_A2FF_STATUS_tag A2FF_STATUS;    /* AF Freeze Status Register */
  FCCU_N2FF_STATUS_tag N2FF_STATUS;    /* NF Freeze Status Register */
  FCCU_F2A_STATUS_tag F2A_STATUS;      /* FA Freeze Status Register */
  uint8_t FCCU_reserved3[8];
  FCCU_RFF_tag RFF;                    /* RF Fake Register */
  FCCU_IRQ_STAT_tag IRQ_STAT;          /* IRQ Status Register */
  FCCU_IRQ_EN_tag IRQ_EN;              /* IRQ Enable Register */
  FCCU_XTMR_tag XTMR;                  /* XTMR Register */
  FCCU_MCS_tag MCS;                    /* MCS Register */
  FCCU_TRANS_LOCK_tag TRANS_LOCK;      /* Transient Lock Register */
  FCCU_PERMNT_LOCK_tag PERMNT_LOCK;    /* Permanent Lock Register */
  FCCU_DELTA_T_tag DELTA_T;            /* Delta T Register */
  FCCU_IRQ_ALARM_EN_tag IRQ_ALARM_EN[4]; /* IRQ Alarm Enable Register */
  FCCU_NMI_EN_tag NMI_EN[4];           /* NMI Enable Register */
  FCCU_EOUT_SIG_EN_tag EOUT_SIG_EN[4]; /* EOUT Signaling Enable Register */
};


/* ============================================================================
   =============================== Module: FEC ================================
   ============================================================================ */

typedef union FEC_EIR_union_tag {      /* Interrupt Event Register */
  vuint32_t R;
  struct {
    vuint32_t HBERR:1;
    vuint32_t BABR:1;
    vuint32_t BABT:1;
    vuint32_t GRA:1;
    vuint32_t TXF:1;
    vuint32_t TXB:1;
    vuint32_t RXF:1;
    vuint32_t RXB:1;
    vuint32_t MII:1;
    vuint32_t EBERR:1;
    vuint32_t LC:1;
    vuint32_t RL:1;
    vuint32_t UN:1;
    vuint32_t  :19;
  } B;
} FEC_EIR_tag;

typedef union FEC_EIMR_union_tag {     /* Interrupt Mask Register */
  vuint32_t R;
  struct {
    vuint32_t HBERR:1;
    vuint32_t BABR:1;
    vuint32_t BABT:1;
    vuint32_t GRA:1;
    vuint32_t TXF:1;
    vuint32_t TXB:1;
    vuint32_t RXF:1;
    vuint32_t RXB:1;
    vuint32_t MII:1;
    vuint32_t EBERR:1;
    vuint32_t LC:1;
    vuint32_t RL:1;
    vuint32_t UN:1;
    vuint32_t  :19;
  } B;
} FEC_EIMR_tag;

typedef union FEC_RDAR_union_tag {     /* Receive Descriptor Active Register */
  vuint32_t R;
  struct {
    vuint32_t  :7;
    vuint32_t RDAR:1;
    vuint32_t  :24;
  } B;
} FEC_RDAR_tag;

typedef union FEC_TDAR_union_tag {     /* Transmit Descriptor Active Register */
  vuint32_t R;
  struct {
    vuint32_t  :7;
    vuint32_t TDAR:1;
    vuint32_t  :24;
  } B;
} FEC_TDAR_tag;

typedef union FEC_ECR_union_tag {      /* Ethernet Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t  :23;
    vuint32_t  :1;
    vuint32_t ETHER_EN:1;
    vuint32_t RESET:1;
  } B;
} FEC_ECR_tag;

typedef union FEC_MMFR_union_tag {     /* MII Management Frame Register */
  vuint32_t R;
  struct {
    vuint32_t ST:2;
    vuint32_t OP:2;
    vuint32_t PA:5;
    vuint32_t RA:5;
    vuint32_t TA:2;
    vuint32_t DATA:16;
  } B;
} FEC_MMFR_tag;

typedef union FEC_MSCR_union_tag {     /* MII Speed Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t DIS_PRE:1;
    vuint32_t MII_SPEED:6;
    vuint32_t  :1;
  } B;
} FEC_MSCR_tag;

typedef union FEC_MIBC_union_tag {     /* MIB Control Register */
  vuint32_t R;
  struct {
    vuint32_t MIB_DIS:1;
    vuint32_t MIB_IDLE:1;
    vuint32_t  :30;
  } B;
} FEC_MIBC_tag;

typedef union FEC_RCR_union_tag {      /* Receive Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :5;
    vuint32_t MAX_FL:11;
    vuint32_t  :4;
    vuint32_t RMII_ECHO:1;
    vuint32_t RMII_LOOP:1;
    vuint32_t RMII_10T:1;
    vuint32_t RMII_MODE:1;
    vuint32_t  :2;
    vuint32_t FCE:1;
    vuint32_t BC_REJ:1;
    vuint32_t PROM:1;
    vuint32_t MII_MODE:1;
    vuint32_t DRT:1;
    vuint32_t LOOP:1;
  } B;
} FEC_RCR_tag;

typedef union FEC_TCR_union_tag {      /* Transmit Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :27;
    vuint32_t RFC_PAUSE:1;
    vuint32_t TFC_PAUSE:1;
    vuint32_t FDEN:1;
    vuint32_t HBC:1;
    vuint32_t GTS:1;
  } B;
} FEC_TCR_tag;

typedef union FEC_PALR_union_tag {     /* Physical Address Low Register */
  vuint32_t R;
  struct {
    vuint32_t PADDR1:32;
  } B;
} FEC_PALR_tag;

typedef union FEC_PAUR_union_tag {     /* Physical Address High Register and Type Field */
  vuint32_t R;
  struct {
    vuint32_t PADDR2:16;
    vuint32_t TYPE:16;
  } B;
} FEC_PAUR_tag;

typedef union FEC_OPD_union_tag {      /* Opcode/Pause Duration */
  vuint32_t R;
  struct {
    vuint32_t OPCODE:16;
    vuint32_t PAUSE_DUR:16;
  } B;
} FEC_OPD_tag;

typedef union FEC_IAUR_union_tag {     /* Descriptor Individual Upper Address Register */
  vuint32_t R;
  struct {
    vuint32_t IADDR1:32;
  } B;
} FEC_IAUR_tag;

typedef union FEC_IALR_union_tag {     /* Descriptor Individual Lower Address Register */
  vuint32_t R;
  struct {
    vuint32_t IADDR2:32;
  } B;
} FEC_IALR_tag;

typedef union FEC_GAUR_union_tag {     /* Descriptor Group Upper Address Register */
  vuint32_t R;
  struct {
    vuint32_t GADDR1:32;
  } B;
} FEC_GAUR_tag;

typedef union FEC_GALR_union_tag {     /* Descriptor Group Lower Address Register */
  vuint32_t R;
  struct {
    vuint32_t GADDR2:32;
  } B;
} FEC_GALR_tag;

typedef union FEC_TFWR_union_tag {     /* Transmit FIFO Watermark */
  vuint32_t R;
  struct {
    vuint32_t  :30;
    vuint32_t TFWR:2;
  } B;
} FEC_TFWR_tag;

typedef union FEC_FRBR_union_tag {     /* FIFO Receive Bound Register */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t  :1;
    vuint32_t R_BOUND:8;
    vuint32_t  :2;
  } B;
} FEC_FRBR_tag;

typedef union FEC_FRSR_union_tag {     /* FIFO Receive Start Register */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t  :1;
    vuint32_t R_FSTART:8;
    vuint32_t  :2;
  } B;
} FEC_FRSR_tag;

typedef union FEC_ERDSR_union_tag {    /* Receive Descriptor Ring Start Register */
  vuint32_t R;
  struct {
    vuint32_t R_DES_START:30;
    vuint32_t  :2;
  } B;
} FEC_ERDSR_tag;

typedef union FEC_ETDSR_union_tag {    /* Transmit Buffer Descriptor Ring Start Register */
  vuint32_t R;
  struct {
    vuint32_t X_DES_START:30;
    vuint32_t  :2;
  } B;
} FEC_ETDSR_tag;

typedef union FEC_EMRBR_union_tag {    /* Receive Buffer Size Register */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t R_BUF_SIZE:7;
    vuint32_t  :4;
  } B;
} FEC_EMRBR_tag;

typedef union FEC_RMON_T_DROP_union_tag { /* Count of frames not counted correctly */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_DROP:32;
  } B;
} FEC_RMON_T_DROP_tag;

typedef union FEC_RMON_T_PACKETS_union_tag { /* RMON Tx packet count */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_PACKETS:32;
  } B;
} FEC_RMON_T_PACKETS_tag;

typedef union FEC_RMON_T_BC_PKT_union_tag { /* RMON Tx broadcast packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_BC_PKT:32;
  } B;
} FEC_RMON_T_BC_PKT_tag;

typedef union FEC_RMON_T_MC_PKT_union_tag { /* RMON Tx multicast packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_MC_PKT:32;
  } B;
} FEC_RMON_T_MC_PKT_tag;

typedef union FEC_RMON_T_CRC_ALIGN_union_tag { /* RMON Tx packets with CRC/align error */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_CRC_ALIGN:32;
  } B;
} FEC_RMON_T_CRC_ALIGN_tag;

typedef union FEC_RMON_T_UNDERSIZE_union_tag { /* RMON Tx packets < 64 bytes, good CRC */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_UNDERSIZE:32;
  } B;
} FEC_RMON_T_UNDERSIZE_tag;

typedef union FEC_RMON_T_OVERSIZE_union_tag { /* RMON Tx packets > MAX_FL bytes, good CRC */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_OVERSIZE:32;
  } B;
} FEC_RMON_T_OVERSIZE_tag;

typedef union FEC_RMON_T_FRAG_union_tag { /* RMON Tx packets < 64 bytes, bad CRC */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_FRAG:32;
  } B;
} FEC_RMON_T_FRAG_tag;

typedef union FEC_RMON_T_JAB_union_tag { /* RMON Tx packets > MAX_FL bytes, bad CRC */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_JAB:32;
  } B;
} FEC_RMON_T_JAB_tag;

typedef union FEC_RMON_T_COL_union_tag { /* RMON Tx collision count */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_COL:32;
  } B;
} FEC_RMON_T_COL_tag;

typedef union FEC_RMON_T_P64_union_tag { /* RMON Tx 64 byte packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_P64:32;
  } B;
} FEC_RMON_T_P64_tag;

typedef union FEC_RMON_T_P65TO127_union_tag { /* RMON Tx 65 to 127 byte packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_P65TO127:32;
  } B;
} FEC_RMON_T_P65TO127_tag;

typedef union FEC_RMON_T_P128TO255_union_tag { /* RMON Tx 128 to 255 byte packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_P128TO255:32;
  } B;
} FEC_RMON_T_P128TO255_tag;

typedef union FEC_RMON_T_P256TO511_union_tag { /* RMON Tx 256 to 511 byte packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_P256TO511:32;
  } B;
} FEC_RMON_T_P256TO511_tag;

typedef union FEC_RMON_T_P512TO1023_union_tag { /* RMON Tx 512 to 1023 byte packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_P512TO1023:32;
  } B;
} FEC_RMON_T_P512TO1023_tag;

typedef union FEC_RMON_T_P1024TO2047_union_tag { /* RMON Tx 1024 to 2047 byte packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_P1024TO2047:32;
  } B;
} FEC_RMON_T_P1024TO2047_tag;

typedef union FEC_RMON_T_P_GTE2048_union_tag { /* RMON Tx packets with > 2048 bytes */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_P_GTE2048:32;
  } B;
} FEC_RMON_T_P_GTE2048_tag;

typedef union FEC_RMON_T_OCTETS_union_tag { /* RMON Tx Octets */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_OCTETS:32;
  } B;
} FEC_RMON_T_OCTETS_tag;

typedef union FEC_IEEE_T_DROP_union_tag { /* Count of transmitted frames not counted correctly */
  vuint32_t R;
  struct {
    vuint32_t IEEE_T_DROP:32;
  } B;
} FEC_IEEE_T_DROP_tag;

typedef union FEC_IEEE_T_FRAME_OK_union_tag { /* Frames transmitted OK */
  vuint32_t R;
  struct {
    vuint32_t IEEE_T_FRAME_OK:32;
  } B;
} FEC_IEEE_T_FRAME_OK_tag;

typedef union FEC_IEEE_T_1COL_union_tag { /* Frames transmitted with single collision */
  vuint32_t R;
  struct {
    vuint32_t IEEE_T_1COL:32;
  } B;
} FEC_IEEE_T_1COL_tag;

typedef union FEC_IEEE_T_MCOL_union_tag { /* Frames transmitted with multiple collisions */
  vuint32_t R;
  struct {
    vuint32_t IEEE_T_MCOL:32;
  } B;
} FEC_IEEE_T_MCOL_tag;

typedef union FEC_IEEE_T_DEF_union_tag { /* Frames transmitted after deferral delay */
  vuint32_t R;
  struct {
    vuint32_t IEEE_T_DEF:32;
  } B;
} FEC_IEEE_T_DEF_tag;

typedef union FEC_IEEE_T_LCOL_union_tag { /* Frames transmitted with late collision */
  vuint32_t R;
  struct {
    vuint32_t IEEE_T_LCOL:32;
  } B;
} FEC_IEEE_T_LCOL_tag;

typedef union FEC_IEEE_T_EXCOL_union_tag { /* Frames transmitted with excessive collisions */
  vuint32_t R;
  struct {
    vuint32_t IEEE_T_EXCOL:32;
  } B;
} FEC_IEEE_T_EXCOL_tag;

typedef union FEC_IEEE_T_MACERR_union_tag { /* Frames transmitted with Tx FIFO underrun */
  vuint32_t R;
  struct {
    vuint32_t IEEE_T_MACERR:32;
  } B;
} FEC_IEEE_T_MACERR_tag;

typedef union FEC_IEEE_T_CSERR_union_tag { /* Frames transmitted with carrier sense error */
  vuint32_t R;
  struct {
    vuint32_t IEEE_T_CSERR:32;
  } B;
} FEC_IEEE_T_CSERR_tag;

typedef union FEC_IEEE_T_SQE_union_tag { /* Frames transmitted with SQE error */
  vuint32_t R;
  struct {
    vuint32_t IEEE_T_SQE:32;
  } B;
} FEC_IEEE_T_SQE_tag;

typedef union FEC_IEEE_T_FDXFC_union_tag { /* Flow control pause frames transmitted */
  vuint32_t R;
  struct {
    vuint32_t IEEE_T_FDXFC:32;
  } B;
} FEC_IEEE_T_FDXFC_tag;

typedef union FEC_IEEE_T_OCTETS_OK_union_tag { /* Octet count for frames transmitted without error */
  vuint32_t R;
  struct {
    vuint32_t IEEE_T_OCTETS_OK:32;
  } B;
} FEC_IEEE_T_OCTETS_OK_tag;

typedef union FEC_RMON_R_DROP_union_tag { /* Count of received frames not counted correctly */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_DROP:32;
  } B;
} FEC_RMON_R_DROP_tag;

typedef union FEC_RMON_R_PACKETS_union_tag { /* RMON Rx packet count */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_PACKETS:32;
  } B;
} FEC_RMON_R_PACKETS_tag;

typedef union FEC_RMON_R_BC_PKT_union_tag { /* RMON Rx broadcast packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_BC_PKT:32;
  } B;
} FEC_RMON_R_BC_PKT_tag;

typedef union FEC_RMON_R_MC_PKT_union_tag { /* RMON Rx multicast packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_MC_PKT:32;
  } B;
} FEC_RMON_R_MC_PKT_tag;

typedef union FEC_RMON_R_CRC_ALIGN_union_tag { /* RMON Rx packets with CRC/Align error */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_CRC_ALIGN:32;
  } B;
} FEC_RMON_R_CRC_ALIGN_tag;

typedef union FEC_RMON_R_UNDERSIZE_union_tag { /* RMON Rx packets < 64 bytes, good CRC */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_UNDERSIZE:32;
  } B;
} FEC_RMON_R_UNDERSIZE_tag;

typedef union FEC_RMON_R_OVERSIZE_union_tag { /* RMON Rx packets > MAX_FL bytes, good CRC */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_OVERSIZE:32;
  } B;
} FEC_RMON_R_OVERSIZE_tag;

typedef union FEC_RMON_R_FRAG_union_tag { /* RMON Rx packets < 64 bytes, bad CRC */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_FRAG:32;
  } B;
} FEC_RMON_R_FRAG_tag;

typedef union FEC_RMON_R_JAB_union_tag { /* RMON Rx packets > MAX_FL bytes, bad CRC */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_JAB:32;
  } B;
} FEC_RMON_R_JAB_tag;

typedef union FEC_RMON_R_RESVD_0_union_tag { /* Reserved */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_RESVD_0:32;
  } B;
} FEC_RMON_R_RESVD_0_tag;

typedef union FEC_RMON_R_P64_union_tag { /* RMON Rx 64 byte packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_P64:32;
  } B;
} FEC_RMON_R_P64_tag;

typedef union FEC_RMON_R_P65TO127_union_tag { /* RMON Rx 65 to 127 byte packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_P65TO127:32;
  } B;
} FEC_RMON_R_P65TO127_tag;

typedef union FEC_RMON_R_P128TO255_union_tag { /* RMON Rx 128 to 255 byte packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_P128TO255:32;
  } B;
} FEC_RMON_R_P128TO255_tag;

typedef union FEC_RMON_R_P256TO511_union_tag { /* RMON Rx 256 to 511 byte packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_P256TO511:32;
  } B;
} FEC_RMON_R_P256TO511_tag;

typedef union FEC_RMON_R_P512TO1023_union_tag { /* RMON Rx 512 to 1023 byte packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_P512TO1023:32;
  } B;
} FEC_RMON_R_P512TO1023_tag;

typedef union FEC_RMON_R_P1024TO2047_union_tag { /* RMON Rx 1024 to 2047 byte packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_P1024TO2047:32;
  } B;
} FEC_RMON_R_P1024TO2047_tag;

typedef union FEC_RMON_R_P_GTE2048_union_tag { /* RMON Rx packets with > 2048 bytes */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_P_GTE2048:32;
  } B;
} FEC_RMON_R_P_GTE2048_tag;

typedef union FEC_RMON_R_OCTETS_union_tag { /* RMON Rx octets */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_OCTETS:32;
  } B;
} FEC_RMON_R_OCTETS_tag;

typedef union FEC_IEEE_R_DROP_union_tag { /* Count of received frames not counted correctly */
  vuint32_t R;
  struct {
    vuint32_t IEEE_R_DROP:32;
  } B;
} FEC_IEEE_R_DROP_tag;

typedef union FEC_IEEE_R_FRAME_OK_union_tag { /* Frames received OK */
  vuint32_t R;
  struct {
    vuint32_t IEEE_R_FRAME_OK:32;
  } B;
} FEC_IEEE_R_FRAME_OK_tag;

typedef union FEC_IEEE_R_CRC_union_tag { /* Frames received with CRC error */
  vuint32_t R;
  struct {
    vuint32_t IEEE_R_CRC:32;
  } B;
} FEC_IEEE_R_CRC_tag;

typedef union FEC_IEEE_R_ALIGN_union_tag { /* Frames received with alignment error */
  vuint32_t R;
  struct {
    vuint32_t IEEE_R_ALIGN:32;
  } B;
} FEC_IEEE_R_ALIGN_tag;

typedef union FEC_IEEE_R_MACERR_union_tag { /* Receive FIFO overflow count */
  vuint32_t R;
  struct {
    vuint32_t IEEE_R_MACERR:32;
  } B;
} FEC_IEEE_R_MACERR_tag;

typedef union FEC_IEEE_R_FDXFC_union_tag { /* Flow control pause frames received */
  vuint32_t R;
  struct {
    vuint32_t IEEE_R_FDXFC:32;
  } B;
} FEC_IEEE_R_FDXFC_tag;

typedef union FEC_IEEE_R_OCTETS_OK_union_tag { /* Octet count for frames received without error */
  vuint32_t R;
  struct {
    vuint32_t IEEE_R_OCTETS_OK:32;
  } B;
} FEC_IEEE_R_OCTETS_OK_tag;

struct FEC_tag {
  uint8_t FEC_reserved0[4];
  FEC_EIR_tag EIR;                     /* Interrupt Event Register */
  FEC_EIMR_tag EIMR;                   /* Interrupt Mask Register */
  uint8_t FEC_reserved1[4];
  FEC_RDAR_tag RDAR;                   /* Receive Descriptor Active Register */
  FEC_TDAR_tag TDAR;                   /* Transmit Descriptor Active Register */
  uint8_t FEC_reserved2[12];
  FEC_ECR_tag ECR;                     /* Ethernet Control Register */
  uint8_t FEC_reserved3[24];
  FEC_MMFR_tag MMFR;                   /* MII Management Frame Register */
  FEC_MSCR_tag MSCR;                   /* MII Speed Control Register */
  uint8_t FEC_reserved4[28];
  FEC_MIBC_tag MIBC;                   /* MIB Control Register */
  uint8_t FEC_reserved5[28];
  FEC_RCR_tag RCR;                     /* Receive Control Register */
  uint8_t FEC_reserved6[60];
  FEC_TCR_tag TCR;                     /* Transmit Control Register */
  uint8_t FEC_reserved7[28];
  FEC_PALR_tag PALR;                   /* Physical Address Low Register */
  FEC_PAUR_tag PAUR;                   /* Physical Address High Register and Type Field */
  FEC_OPD_tag OPD;                     /* Opcode/Pause Duration */
  uint8_t FEC_reserved8[40];
  FEC_IAUR_tag IAUR;                   /* Descriptor Individual Upper Address Register */
  FEC_IALR_tag IALR;                   /* Descriptor Individual Lower Address Register */
  FEC_GAUR_tag GAUR;                   /* Descriptor Group Upper Address Register */
  FEC_GALR_tag GALR;                   /* Descriptor Group Lower Address Register */
  uint8_t FEC_reserved9[28];
  FEC_TFWR_tag TFWR;                   /* Transmit FIFO Watermark */
  uint8_t FEC_reserved10[4];
  FEC_FRBR_tag FRBR;                   /* FIFO Receive Bound Register */
  FEC_FRSR_tag FRSR;                   /* FIFO Receive Start Register */
  uint8_t FEC_reserved11[44];
  FEC_ERDSR_tag ERDSR;                 /* Receive Descriptor Ring Start Register */
  FEC_ETDSR_tag ETDSR;                 /* Transmit Buffer Descriptor Ring Start Register */
  FEC_EMRBR_tag EMRBR;                 /* Receive Buffer Size Register */
  uint8_t FEC_reserved12[116];
  FEC_RMON_T_DROP_tag RMON_T_DROP;     /* Count of frames not counted correctly */
  FEC_RMON_T_PACKETS_tag RMON_T_PACKETS; /* RMON Tx packet count */
  FEC_RMON_T_BC_PKT_tag RMON_T_BC_PKT; /* RMON Tx broadcast packets */
  FEC_RMON_T_MC_PKT_tag RMON_T_MC_PKT; /* RMON Tx multicast packets */
  FEC_RMON_T_CRC_ALIGN_tag RMON_T_CRC_ALIGN; /* RMON Tx packets with CRC/align error */
  FEC_RMON_T_UNDERSIZE_tag RMON_T_UNDERSIZE; /* RMON Tx packets < 64 bytes, good CRC */
  FEC_RMON_T_OVERSIZE_tag RMON_T_OVERSIZE; /* RMON Tx packets > MAX_FL bytes, good CRC */
  FEC_RMON_T_FRAG_tag RMON_T_FRAG;     /* RMON Tx packets < 64 bytes, bad CRC */
  FEC_RMON_T_JAB_tag RMON_T_JAB;       /* RMON Tx packets > MAX_FL bytes, bad CRC */
  FEC_RMON_T_COL_tag RMON_T_COL;       /* RMON Tx collision count */
  FEC_RMON_T_P64_tag RMON_T_P64;       /* RMON Tx 64 byte packets */
  FEC_RMON_T_P65TO127_tag RMON_T_P65TO127; /* RMON Tx 65 to 127 byte packets */
  FEC_RMON_T_P128TO255_tag RMON_T_P128TO255; /* RMON Tx 128 to 255 byte packets */
  FEC_RMON_T_P256TO511_tag RMON_T_P256TO511; /* RMON Tx 256 to 511 byte packets */
  FEC_RMON_T_P512TO1023_tag RMON_T_P512TO1023; /* RMON Tx 512 to 1023 byte packets */
  FEC_RMON_T_P1024TO2047_tag RMON_T_P1024TO2047; /* RMON Tx 1024 to 2047 byte packets */
  FEC_RMON_T_P_GTE2048_tag RMON_T_P_GTE2048; /* RMON Tx packets with > 2048 bytes */
  FEC_RMON_T_OCTETS_tag RMON_T_OCTETS; /* RMON Tx Octets */
  FEC_IEEE_T_DROP_tag IEEE_T_DROP;     /* Count of transmitted frames not counted correctly */
  FEC_IEEE_T_FRAME_OK_tag IEEE_T_FRAME_OK; /* Frames transmitted OK */
  FEC_IEEE_T_1COL_tag IEEE_T_1COL;     /* Frames transmitted with single collision */
  FEC_IEEE_T_MCOL_tag IEEE_T_MCOL;     /* Frames transmitted with multiple collisions */
  FEC_IEEE_T_DEF_tag IEEE_T_DEF;       /* Frames transmitted after deferral delay */
  FEC_IEEE_T_LCOL_tag IEEE_T_LCOL;     /* Frames transmitted with late collision */
  FEC_IEEE_T_EXCOL_tag IEEE_T_EXCOL;   /* Frames transmitted with excessive collisions */
  FEC_IEEE_T_MACERR_tag IEEE_T_MACERR; /* Frames transmitted with Tx FIFO underrun */
  FEC_IEEE_T_CSERR_tag IEEE_T_CSERR;   /* Frames transmitted with carrier sense error */
  FEC_IEEE_T_SQE_tag IEEE_T_SQE;       /* Frames transmitted with SQE error */
  FEC_IEEE_T_FDXFC_tag IEEE_T_FDXFC;   /* Flow control pause frames transmitted */
  FEC_IEEE_T_OCTETS_OK_tag IEEE_T_OCTETS_OK; /* Octet count for frames transmitted without error */
  uint8_t FEC_reserved13[8];
  FEC_RMON_R_DROP_tag RMON_R_DROP;     /* Count of received frames not counted correctly */
  FEC_RMON_R_PACKETS_tag RMON_R_PACKETS; /* RMON Rx packet count */
  FEC_RMON_R_BC_PKT_tag RMON_R_BC_PKT; /* RMON Rx broadcast packets */
  FEC_RMON_R_MC_PKT_tag RMON_R_MC_PKT; /* RMON Rx multicast packets */
  FEC_RMON_R_CRC_ALIGN_tag RMON_R_CRC_ALIGN; /* RMON Rx packets with CRC/Align error */
  FEC_RMON_R_UNDERSIZE_tag RMON_R_UNDERSIZE; /* RMON Rx packets < 64 bytes, good CRC */
  FEC_RMON_R_OVERSIZE_tag RMON_R_OVERSIZE; /* RMON Rx packets > MAX_FL bytes, good CRC */
  FEC_RMON_R_FRAG_tag RMON_R_FRAG;     /* RMON Rx packets < 64 bytes, bad CRC */
  FEC_RMON_R_JAB_tag RMON_R_JAB;       /* RMON Rx packets > MAX_FL bytes, bad CRC */
  FEC_RMON_R_RESVD_0_tag RMON_R_RESVD_0; /* Reserved */
  FEC_RMON_R_P64_tag RMON_R_P64;       /* RMON Rx 64 byte packets */
  FEC_RMON_R_P65TO127_tag RMON_R_P65TO127; /* RMON Rx 65 to 127 byte packets */
  FEC_RMON_R_P128TO255_tag RMON_R_P128TO255; /* RMON Rx 128 to 255 byte packets */
  FEC_RMON_R_P256TO511_tag RMON_R_P256TO511; /* RMON Rx 256 to 511 byte packets */
  FEC_RMON_R_P512TO1023_tag RMON_R_P512TO1023; /* RMON Rx 512 to 1023 byte packets */
  FEC_RMON_R_P1024TO2047_tag RMON_R_P1024TO2047; /* RMON Rx 1024 to 2047 byte packets */
  FEC_RMON_R_P_GTE2048_tag RMON_R_P_GTE2048; /* RMON Rx packets with > 2048 bytes */
  FEC_RMON_R_OCTETS_tag RMON_R_OCTETS; /* RMON Rx octets */
  FEC_IEEE_R_DROP_tag IEEE_R_DROP;     /* Count of received frames not counted correctly */
  FEC_IEEE_R_FRAME_OK_tag IEEE_R_FRAME_OK; /* Frames received OK */
  FEC_IEEE_R_CRC_tag IEEE_R_CRC;       /* Frames received with CRC error */
  FEC_IEEE_R_ALIGN_tag IEEE_R_ALIGN;   /* Frames received with alignment error */
  FEC_IEEE_R_MACERR_tag IEEE_R_MACERR; /* Receive FIFO overflow count */
  FEC_IEEE_R_FDXFC_tag IEEE_R_FDXFC;   /* Flow control pause frames received */
  FEC_IEEE_R_OCTETS_OK_tag IEEE_R_OCTETS_OK; /* Octet count for frames received without error */
};


/* ============================================================================
   =============================== Module: FR =================================
   ============================================================================ */

typedef union FR_MVR_union_tag {       /* Module Version Register */
  vuint16_t R;
  struct {
    vuint16_t CHIVER:8;
    vuint16_t PEVER:8;
  } B;
} FR_MVR_tag;

typedef union FR_MCR_union_tag {       /* Module Configuration Register */
  vuint16_t R;
  struct {
    vuint16_t MEN:1;
    vuint16_t SBFF:1;                  /* System Bus Failure Freeze */
    vuint16_t SCM:1;
    vuint16_t CHB:1;
    vuint16_t CHA:1;
    vuint16_t SFFE:1;
    vuint16_t ECCE:1;
    vuint16_t  :1;                     /* Reserved bit, will not be changed. Application must not write any value different from the reset value. */
    vuint16_t FUM:1;
    vuint16_t FAM:1;
    vuint16_t  :1;
    vuint16_t CLKSEL:1;
    vuint16_t BITRATE:3;
    vuint16_t  :1;
  } B;
} FR_MCR_tag;

typedef union FR_SYMBADHR_union_tag {  /* System Memory Base Address High Register */
  vuint16_t R;
  struct {
    vuint16_t SMBA:16;                 /* System Memory Base Address high. This is the value of the system memory base address for the individual message buffers and sync frame table. This is the value of the system memory base address for the receive FIFO if the FIFO address mode bit FR_MCR[FAM] is set to 1. It is defines as a byte address. */
  } B;
} FR_SYMBADHR_tag;

typedef union FR_SYMBADLR_union_tag {  /* System Memory Base Address Low Register */
  vuint16_t R;
  struct {
    vuint16_t SMBA:12;
    vuint16_t  :4;
  } B;
} FR_SYMBADLR_tag;

typedef union FR_STBSCR_union_tag {    /* Strobe Signal Control Register */
  vuint16_t R;
  struct {
    vuint16_t WMD:1;
    vuint16_t  :3;
    vuint16_t SEL:4;
    vuint16_t  :3;
    vuint16_t ENB:1;
    vuint16_t  :2;
    vuint16_t STBPSEL:2;
  } B;
} FR_STBSCR_tag;

typedef union FR_MBDSR_union_tag {     /* Message Buffer Data Size Register */
  vuint16_t R;
  struct {
    vuint16_t  :1;
    vuint16_t MBSEG2DS:7;
    vuint16_t  :1;
    vuint16_t MBSEG1DS:7;
  } B;
} FR_MBDSR_tag;

typedef union FR_MBSSUTR_union_tag {   /* Message Buffer Segment Size and Utilization Register */
  vuint16_t R;
  struct {
    vuint16_t  :1;
    vuint16_t LAST_MB_SEG1:7;
    vuint16_t  :1;
    vuint16_t LAST_MB_UTIL:7;
  } B;
} FR_MBSSUTR_tag;

typedef union FR_PEDRAR_union_tag {    /* PE DRAM Access Register */
  vuint16_t R;
  struct {
    vuint16_t INST:4;
    vuint16_t ADDR:11;
    vuint16_t DAD:1;
  } B;
} FR_PEDRAR_tag;

typedef union FR_PEDRDR_union_tag {    /* PE DRAM Data Register */
  vuint16_t R;
  struct {
    vuint16_t DATA:16;
  } B;
} FR_PEDRDR_tag;

typedef union FR_POCR_union_tag {      /* Protocol Operation Control Register */
  vuint16_t R;
  struct {
    vuint16_t WME:1;
    vuint16_t  :3;
    vuint16_t EOC_AP:2;
    vuint16_t ERC_AP:2;
    vuint16_t BSY_WMC:1;
    vuint16_t  :3;
    vuint16_t POCCMD:4;
  } B;
} FR_POCR_tag;

typedef union FR_GIFER_union_tag {     /* Global Interrupt Flag and Enable Register */
  vuint16_t R;
  struct {
    vuint16_t MIF:1;
    vuint16_t PRIF:1;
    vuint16_t CHIF:1;
    vuint16_t WUPIF:1;
    vuint16_t FAFBIF:1;
    vuint16_t FAFAIF:1;
    vuint16_t RBIF:1;
    vuint16_t TBIF:1;
    vuint16_t MIE:1;
    vuint16_t PRIE:1;
    vuint16_t CHIE:1;
    vuint16_t WUPIE:1;
    vuint16_t FAFBIE:1;
    vuint16_t FAFAIE:1;
    vuint16_t RBIE:1;
    vuint16_t TBIE:1;
  } B;
} FR_GIFER_tag;

typedef union FR_PIFR0_union_tag {     /* Protocol Interrupt Flag Register 0 */
  vuint16_t R;
  struct {
    vuint16_t FATL_IF:1;
    vuint16_t INTL_IF:1;
    vuint16_t ILCF_IF:1;
    vuint16_t CSA_IF:1;
    vuint16_t MRC_IF:1;
    vuint16_t MOC_IF:1;
    vuint16_t CCL_IF:1;
    vuint16_t MXS_IF:1;
    vuint16_t MTX_IF:1;
    vuint16_t LTXB_IF:1;
    vuint16_t LTXA_IF:1;
    vuint16_t TBVB_IF:1;
    vuint16_t TBVA_IF:1;
    vuint16_t TI2_IF:1;
    vuint16_t TI1_IF:1;
    vuint16_t CYS_IF:1;
  } B;
} FR_PIFR0_tag;

typedef union FR_PIFR1_union_tag {     /* Protocol Interrupt Flag Register 1 */
  vuint16_t R;
  struct {
    vuint16_t EMC_IF:1;
    vuint16_t IPC_IF:1;
    vuint16_t PECF_IF:1;
    vuint16_t PSC_IF:1;
    vuint16_t SSI3_IF:1;
    vuint16_t SSI2_IF:1;
    vuint16_t SSI1_IF:1;
    vuint16_t SSI0_IF:1;
    vuint16_t  :2;
    vuint16_t EVT_IF:1;
    vuint16_t ODT_IF:1;
    vuint16_t  :4;
  } B;
} FR_PIFR1_tag;

typedef union FR_PIER0_union_tag {     /* Protocol Interrupt Enable Register 0 */
  vuint16_t R;
  struct {
    vuint16_t FATL_IE:1;
    vuint16_t INTL_IE:1;
    vuint16_t ILCF_IE:1;
    vuint16_t CSA_IE:1;
    vuint16_t MRC_IE:1;
    vuint16_t MOC_IE:1;
    vuint16_t CCL_IE:1;
    vuint16_t MXS_IE:1;
    vuint16_t MTX_IE:1;
    vuint16_t LTXB_IE:1;
    vuint16_t LTXA_IE:1;
    vuint16_t TBVB_IE:1;
    vuint16_t TBVA_IE:1;
    vuint16_t TI2_IE:1;
    vuint16_t TI1_IE:1;
    vuint16_t CYS_IE:1;
  } B;
} FR_PIER0_tag;

typedef union FR_PIER1_union_tag {     /* Protocol Interrupt Enable Register 1 */
  vuint16_t R;
  struct {
    vuint16_t EMC_IE:1;
    vuint16_t IPC_IE:1;
    vuint16_t PECF_IE:1;
    vuint16_t PSC_IE:1;
    vuint16_t SSI3_IE:1;
    vuint16_t SSI2_IE:1;
    vuint16_t SSI1_IE:1;
    vuint16_t SSI0_IE:1;
    vuint16_t  :2;
    vuint16_t EVT_IE:1;
    vuint16_t ODT_IE:1;
    vuint16_t  :4;
  } B;
} FR_PIER1_tag;

typedef union FR_CHIERFR_union_tag {   /* CHI Error Flag Register */
  vuint16_t R;
  struct {
    vuint16_t FRLB_EF:1;
    vuint16_t FRLA_EF:1;
    vuint16_t PCMI_EF:1;
    vuint16_t FOVB_EF:1;
    vuint16_t FOVA_EF:1;
    vuint16_t MBS_EF:1;
    vuint16_t MBU_EF:1;
    vuint16_t LCK_EF:1;
    vuint16_t  :1;
    vuint16_t SBCF_EF:1;
    vuint16_t FID_EF:1;
    vuint16_t DPL_EF:1;
    vuint16_t SPL_EF:1;
    vuint16_t NML_EF:1;
    vuint16_t NMF_EF:1;
    vuint16_t ILSA_EF:1;
  } B;
} FR_CHIERFR_tag;

typedef union FR_MBIVEC_union_tag {    /* Message Buffer Interrupt Vector Register */
  vuint16_t R;
  struct {
    vuint16_t  :1;
    vuint16_t TBIVEC:7;
    vuint16_t  :1;
    vuint16_t RBIVEC:7;
  } B;
} FR_MBIVEC_tag;

typedef union FR_CASERCR_union_tag {   /* Channel A Status Error Counter Register */
  vuint16_t R;
  struct {
    vuint16_t CHAERSCNT:16;
  } B;
} FR_CASERCR_tag;

typedef union FR_CBSERCR_union_tag {   /* Channel B Status Error Counter Register */
  vuint16_t R;
  struct {
    vuint16_t CHBERSCNT:16;
  } B;
} FR_CBSERCR_tag;

typedef union FR_PSR0_union_tag {      /* Protocol Status Register 0 */
  vuint16_t R;
  struct {
    vuint16_t ERRMODE:2;
    vuint16_t SLOTMODE:2;
    vuint16_t  :1;
    vuint16_t PROTSTATE:3;
    vuint16_t STARTUPSTATE:4;
    vuint16_t  :1;
    vuint16_t WAKEUPSTATUS:3;
  } B;
} FR_PSR0_tag;

typedef union FR_PSR1_union_tag {      /* Protocol Status Register 1 */
  vuint16_t R;
  struct {
    vuint16_t CSAA:1;
    vuint16_t CSP:1;
    vuint16_t  :1;
    vuint16_t REMCSAT:5;
    vuint16_t CPN:1;
    vuint16_t HHR:1;
    vuint16_t FRZ:1;
    vuint16_t APTAC:5;
  } B;
} FR_PSR1_tag;

typedef union FR_PSR2_union_tag {      /* Protocol Status Register 2 */
  vuint16_t R;
  struct {
    vuint16_t NBVB:1;
    vuint16_t NSEB:1;
    vuint16_t STCB:1;
    vuint16_t SBVB:1;
    vuint16_t SSEB:1;
    vuint16_t MTB:1;
    vuint16_t NBVA:1;
    vuint16_t NSEA:1;
    vuint16_t STCA:1;
    vuint16_t SBVA:1;
    vuint16_t SSEA:1;
    vuint16_t MTA:1;
    vuint16_t CKCORFCNT:4;
  } B;
} FR_PSR2_tag;

typedef union FR_PSR3_union_tag {      /* Protocol Status Register 3 */
  vuint16_t R;
  struct {
    vuint16_t  :2;
    vuint16_t WUB:1;
    vuint16_t ABVB:1;
    vuint16_t AACB:1;
    vuint16_t ACEB:1;
    vuint16_t ASEB:1;
    vuint16_t AVFB:1;
    vuint16_t  :2;
    vuint16_t WUA:1;
    vuint16_t ABVA:1;
    vuint16_t AACA:1;
    vuint16_t ACEA:1;
    vuint16_t ASEA:1;
    vuint16_t AVFA:1;
  } B;
} FR_PSR3_tag;

typedef union FR_MTCTR_union_tag {     /* Macrotick Counter Register */
  vuint16_t R;
  struct {
    vuint16_t  :2;
    vuint16_t MTCT:14;
  } B;
} FR_MTCTR_tag;

typedef union FR_CYCTR_union_tag {     /* Cycle Counter Register */
  vuint16_t R;
  struct {
    vuint16_t  :10;
    vuint16_t CYCCNT:6;
  } B;
} FR_CYCTR_tag;

typedef union FR_SLTCTAR_union_tag {   /* Slot Counter Channel A Register */
  vuint16_t R;
  struct {
    vuint16_t  :5;
    vuint16_t SLOTCNTA:11;
  } B;
} FR_SLTCTAR_tag;

typedef union FR_SLTCTBR_union_tag {   /* Slot Counter Channel B Register */
  vuint16_t R;
  struct {
    vuint16_t  :5;
    vuint16_t SLOTCNTB:11;
  } B;
} FR_SLTCTBR_tag;

typedef union FR_RTCORVR_union_tag {   /* Rate Correction Value Register */
  vuint16_t R;
  struct {
    vuint16_t RATECORR:16;
  } B;
} FR_RTCORVR_tag;

typedef union FR_OFCORVR_union_tag {   /* Offset Correction Value Register */
  vuint16_t R;
  struct {
    vuint16_t OFFSETCORR:16;
  } B;
} FR_OFCORVR_tag;

typedef union FR_CIFR_union_tag {      /* Combined Interrupt Flag Register */
  vuint16_t R;
  struct {
    vuint16_t  :8;
    vuint16_t MIF:1;
    vuint16_t PRIF:1;
    vuint16_t CHIF:1;
    vuint16_t WUPIF:1;
    vuint16_t FAFBIF:1;
    vuint16_t FAFAIF:1;
    vuint16_t RBIF:1;
    vuint16_t TBIF:1;
  } B;
} FR_CIFR_tag;

typedef union FR_SYMATOR_union_tag {   /* System Memory Access Time-Out Register */
  vuint16_t R;
  struct {
    vuint16_t  :8;
    vuint16_t TIMEOUT:8;
  } B;
} FR_SYMATOR_tag;

typedef union FR_SFCNTR_union_tag {    /* Sync Frame Counter Register */
  vuint16_t R;
  struct {
    vuint16_t SFEVB:4;
    vuint16_t SFEVA:4;
    vuint16_t SFODB:4;
    vuint16_t SFODA:4;
  } B;
} FR_SFCNTR_tag;

typedef union FR_SFTOR_union_tag {     /* Sync Frame Table Offset Register */
  vuint16_t R;
  struct {
    vuint16_t SFT_OFFSET:15;
    vuint16_t  :1;
  } B;
} FR_SFTOR_tag;

typedef union FR_SFTCCSR_union_tag {   /* Sync Frame Table Configuration, Control, Status Register */
  vuint16_t R;
  struct {
    vuint16_t ELKT:1;
    vuint16_t OLKT:1;
    vuint16_t CYCNUM:6;
    vuint16_t ELKS:1;
    vuint16_t OLKS:1;
    vuint16_t EVAL:1;
    vuint16_t OVAL:1;
    vuint16_t  :1;
    vuint16_t OPT:1;
    vuint16_t SDVEN:1;
    vuint16_t SIDEN:1;
  } B;
} FR_SFTCCSR_tag;

typedef union FR_SFIDRFR_union_tag {   /* Sync Frame ID Rejection Filter Register */
  vuint16_t R;
  struct {
    vuint16_t  :6;
    vuint16_t SYNFRID:10;
  } B;
} FR_SFIDRFR_tag;

typedef union FR_SFIDAFVR_union_tag {  /* Sync Frame ID Acceptance Filter Value Register */
  vuint16_t R;
  struct {
    vuint16_t  :6;
    vuint16_t FVAL:10;
  } B;
} FR_SFIDAFVR_tag;

typedef union FR_SFIDAFMR_union_tag {  /* Sync Frame ID Acceptance Filter Mask Register */
  vuint16_t R;
  struct {
    vuint16_t  :6;
    vuint16_t FMSK:10;
  } B;
} FR_SFIDAFMR_tag;

typedef union FR_NMVR_union_tag {      /* Network Management Vector Register */
  vuint16_t R;
  struct {
    vuint16_t NMVP:16;
  } B;
} FR_NMVR_tag;

typedef union FR_NMVLR_union_tag {     /* Network Management Vector Length Register */
  vuint16_t R;
  struct {
    vuint16_t  :12;
    vuint16_t NMVL:4;
  } B;
} FR_NMVLR_tag;

typedef union FR_TICCR_union_tag {     /* Timer Configuration and Control Register */
  vuint16_t R;
  struct {
    vuint16_t  :2;
    vuint16_t T2_CFG:1;
    vuint16_t T2_REP:1;
    vuint16_t  :1;
    vuint16_t T2SP:1;
    vuint16_t T2TR:1;
    vuint16_t T2ST:1;
    vuint16_t  :3;
    vuint16_t T1_REP:1;
    vuint16_t  :1;
    vuint16_t T1SP:1;
    vuint16_t T1TR:1;
    vuint16_t T1ST:1;
  } B;
} FR_TICCR_tag;

typedef union FR_TI1CYSR_union_tag {   /* Timer 1 Cycle Set Register */
  vuint16_t R;
  struct {
    vuint16_t  :2;
    vuint16_t T1_CYC_VAL:6;
    vuint16_t  :2;
    vuint16_t T1_CYC_MSK:6;
  } B;
} FR_TI1CYSR_tag;

typedef union FR_TI1MTOR_union_tag {   /* Timer 1 Macrotick Offset Register */
  vuint16_t R;
  struct {
    vuint16_t  :2;
    vuint16_t T1_MTOFFSET:14;
  } B;
} FR_TI1MTOR_tag;

typedef union FR_TI2CR0_ABS_union_tag { /* Timer 2 Configuration Register 0 (Absolute Timer Configuration) */
  vuint16_t R;
  struct {
    vuint16_t  :2;
    vuint16_t T2CYCVAL:6;              /* Timer T2 Cycle Filter Mask */
    vuint16_t  :2;
    vuint16_t T2CYCMSK:6;              /* Timer T2 Cycle Filter Mask */
  } B;
} FR_TI2CR0_ABS_tag;

typedef union FR_TI2CR0_REL_union_tag { /* Timer 2 Configuration Register 0 (Relative Timer Configuration) */
  vuint16_t R;
  struct {
    vuint16_t T2MTCNT:16;              /* Timer T2 Macrotick High Word */
  } B;
} FR_TI2CR0_REL_tag;

typedef union FR_TI2CR0_union_tag {
  FR_TI2CR0_ABS_tag ABS;               /* Timer 2 Configuration Register 0 (Absolute Timer Configuration) */
  FR_TI2CR0_REL_tag REL;               /* Timer 2 Configuration Register 0 (Relative Timer Configuration) */
} FR_TI2CR0_tag;

typedef union FR_TI2CR1_ABS_union_tag { /* Timer 2 Configuration Register 1 (Absolute Timer Configuration) */
  vuint16_t R;
  struct {
    vuint16_t  :2;
    vuint16_t T2MOFF:14;               /* Timer T2 Macrotick Offset */
  } B;
} FR_TI2CR1_ABS_tag;

typedef union FR_TI2CR1_REL_union_tag { /* Timer 2 Configuration Register 1 (Relative Timer Configuration) */
  vuint16_t R;
  struct {
    vuint16_t T2MTCNT:16;
  } B;
} FR_TI2CR1_REL_tag;

typedef union FR_TI2CR1_union_tag {
  FR_TI2CR1_ABS_tag ABS;               /* Timer 2 Configuration Register 1 (Absolute Timer Configuration) */
  FR_TI2CR1_REL_tag REL;               /* Timer 2 Configuration Register 1 (Relative Timer Configuration) */
} FR_TI2CR1_tag;

typedef union FR_SSSR_union_tag {      /* Slot Status Selection Register */
  vuint16_t R;
  struct {
    vuint16_t WMD:1;
    vuint16_t  :1;
    vuint16_t SEL:2;
    vuint16_t  :1;
    vuint16_t SLOTNUMBER:11;
  } B;
} FR_SSSR_tag;

typedef union FR_SSCCR_union_tag {     /* Slot Status Counter Condition Register */
  vuint16_t R;
  struct {
    vuint16_t WMD:1;
    vuint16_t  :1;
    vuint16_t SEL:2;
    vuint16_t  :1;
    vuint16_t CNTCFG:2;
    vuint16_t MCY:1;
    vuint16_t VFR:1;
    vuint16_t SYF:1;
    vuint16_t NUF:1;
    vuint16_t SUF:1;
    vuint16_t STATUSMASK:4;
  } B;
} FR_SSCCR_tag;

typedef union FR_SSR_union_tag {       /* Slot Status Register */
  vuint16_t R;
  struct {
    vuint16_t VFB:1;
    vuint16_t SYB:1;
    vuint16_t NFB:1;
    vuint16_t SUB:1;
    vuint16_t SEB:1;
    vuint16_t CEB:1;
    vuint16_t BVB:1;
    vuint16_t TCB:1;
    vuint16_t VFA:1;
    vuint16_t SYA:1;
    vuint16_t NFA:1;
    vuint16_t SUA:1;
    vuint16_t SEA:1;
    vuint16_t CEA:1;
    vuint16_t BVA:1;
    vuint16_t TCA:1;
  } B;
} FR_SSR_tag;

typedef union FR_SSCR_union_tag {      /* Slot Status Counter Register */
  vuint16_t R;
  struct {
    vuint16_t SLOTSTATUSCNT:16;
  } B;
} FR_SSCR_tag;

typedef union FR_MTSACFR_union_tag {   /* MTS A Configuration Register */
  vuint16_t R;
  struct {
    vuint16_t MTE:1;
    vuint16_t  :1;
    vuint16_t CYCCNTMSK:6;
    vuint16_t  :2;
    vuint16_t CYCCNTVAL:6;
  } B;
} FR_MTSACFR_tag;

typedef union FR_MTSBCFR_union_tag {   /* MTS B Configuration Register */
  vuint16_t R;
  struct {
    vuint16_t MTE:1;
    vuint16_t  :1;
    vuint16_t CYCCNTMSK:6;
    vuint16_t  :2;
    vuint16_t CYCCNTVAL:6;
  } B;
} FR_MTSBCFR_tag;

typedef union FR_RSBIR_union_tag {     /* Receive Shadow Buffer Index Register */
  vuint16_t R;
  struct {
    vuint16_t WMD:1;
    vuint16_t  :1;
    vuint16_t SEL:2;
    vuint16_t  :4;
    vuint16_t RSBIDX:8;                /* RSBIDXA1/RSBIDXA2/RSBIDXB1/RSBIDXB2- Receive Shadow Buffer Index */
  } B;
} FR_RSBIR_tag;

typedef union FR_RFWMSR_union_tag {    /* Receive FIFO Watermark and Selection Register */
  vuint16_t R;
  struct {
    vuint16_t WM:8;                    /* WMA/WMB - Watermark */
    vuint16_t  :7;
    vuint16_t SEL:1;
  } B;
} FR_RFWMSR_tag;

typedef union FR_RFSIR_union_tag {     /* Receive FIFO Start Index Register */
  vuint16_t R;
  struct {
    vuint16_t  :6;
    vuint16_t SIDX:10;                 /* SIDXA/SIDXB - Start Index */
  } B;
} FR_RFSIR_tag;

typedef union FR_RFDSR_union_tag {     /* Receive FIFO Depth and Size Register */
  vuint16_t R;
  struct {
    vuint16_t FIFO_DEPTH:8;            /* FIFO_DEPTHA/FIFO_DEPTHB - FIFO Depth */
    vuint16_t  :1;
    vuint16_t ENTRY_SIZE:7;            /* ENTRY_SIZEA/ENTRY_SIZEB - Entry Size */
  } B;
} FR_RFDSR_tag;

typedef union FR_RFARIR_union_tag {    /* Receive FIFO A Read Index Register */
  vuint16_t R;
  struct {
    vuint16_t  :6;
    vuint16_t RDIDX:10;
  } B;
} FR_RFARIR_tag;

typedef union FR_RFBRIR_union_tag {    /* Receive FIFO B Read Index Register */
  vuint16_t R;
  struct {
    vuint16_t  :6;
    vuint16_t RDIDX:10;
  } B;
} FR_RFBRIR_tag;

typedef union FR_RFMIDAFVR_union_tag { /* Receive FIFO Message ID Acceptance Filter Value Register */
  vuint16_t R;
  struct {
    vuint16_t MIDAFVAL:16;             /* MIDAFVALA/MIDAFVALB - Message ID Acceptance Filter Value */
  } B;
} FR_RFMIDAFVR_tag;

typedef union FR_RFMIDAFMR_union_tag { /* Receive FIFO Message ID Acceptance Filter Mask Register */
  vuint16_t R;
  struct {
    vuint16_t MIDAFMSK:16;             /* MIDAFMSKA/MIDAFMSKB - Message ID Acceptance Filter Mask */
  } B;
} FR_RFMIDAFMR_tag;

typedef union FR_RFFIDRFVR_union_tag { /* Receive FIFO Frame ID Rejection Filter Value Register */
  vuint16_t R;
  struct {
    vuint16_t  :5;
    vuint16_t FIDRFVAL:11;             /* FIDRFVALA/FIDRFVALB - Frame ID Rejection Filter Value */
  } B;
} FR_RFFIDRFVR_tag;

typedef union FR_RFFIDRFMR_union_tag { /* Receive FIFO Frame ID Rejection Filter Mask Register */
  vuint16_t R;
  struct {
    vuint16_t  :5;
    vuint16_t FIDRFMSK:11;
  } B;
} FR_RFFIDRFMR_tag;

typedef union FR_RFRFCFR_union_tag {   /* Receive FIFO Range Filter Configuration Register */
  vuint16_t R;
  struct {
    vuint16_t WMD:1;
    vuint16_t IBD:1;
    vuint16_t SEL:2;
    vuint16_t  :1;
    vuint16_t SID:11;                  /* Slot ID */
  } B;
} FR_RFRFCFR_tag;

typedef union FR_RFRFCTR_union_tag {   /* Receive FIFO Range Filter Control Register */
  vuint16_t R;
  struct {
    vuint16_t  :4;
    vuint16_t F3MD:1;
    vuint16_t F2MD:1;
    vuint16_t F1MD:1;
    vuint16_t F0MD:1;
    vuint16_t  :4;
    vuint16_t F3EN:1;
    vuint16_t F2EN:1;
    vuint16_t F1EN:1;
    vuint16_t F0EN:1;
  } B;
} FR_RFRFCTR_tag;

typedef union FR_LDTXSLAR_union_tag {  /* Last Dynamic Transmit Slot Channel A Register */
  vuint16_t R;
  struct {
    vuint16_t  :5;
    vuint16_t LDYNTXSLOTA:11;
  } B;
} FR_LDTXSLAR_tag;

typedef union FR_LDTXSLBR_union_tag {  /* Last Dynamic Transmit Slot Channel B Register */
  vuint16_t R;
  struct {
    vuint16_t  :5;
    vuint16_t LDYNTXSLOTB:11;
  } B;
} FR_LDTXSLBR_tag;

typedef union FR_PCR0_union_tag {      /* Protocol Configuration Register 0 */
  vuint16_t R;
  struct {
    vuint16_t action_point_offset:6;
    vuint16_t static_slot_length:10;
  } B;
} FR_PCR0_tag;

typedef union FR_PCR1_union_tag {      /* Protocol Configuration Register 1 */
  vuint16_t R;
  struct {
    vuint16_t  :2;
    vuint16_t macro_after_first_static_slot:14;
  } B;
} FR_PCR1_tag;

typedef union FR_PCR2_union_tag {      /* Protocol Configuration Register 2 */
  vuint16_t R;
  struct {
    vuint16_t minislot_after_action_point:6;
    vuint16_t number_of_static_slots:10; /* gNumberOfStaticSlots */
  } B;
} FR_PCR2_tag;

typedef union FR_PCR3_union_tag {      /* Protocol Configuration Register 3 */
  vuint16_t R;
  struct {
    vuint16_t wakeup_symbol_rx_low:6;
    vuint16_t minislot_action_point_offset:5;
    vuint16_t coldstart_attempts:5;
  } B;
} FR_PCR3_tag;

typedef union FR_PCR4_union_tag {      /* Protocol Configuration Register 4 */
  vuint16_t R;
  struct {
    vuint16_t cas_rx_low_max:7;
    vuint16_t wakeup_symbol_rx_window:9;
  } B;
} FR_PCR4_tag;

typedef union FR_PCR5_union_tag {      /* Protocol Configuration Register 5 */
  vuint16_t R;
  struct {
    vuint16_t tss_transmitter:4;
    vuint16_t wakeup_symbol_tx_low:6;
    vuint16_t wakeup_symbol_rx_idle:6;
  } B;
} FR_PCR5_tag;

typedef union FR_PCR6_union_tag {      /* Protocol Configuration Register 6 */
  vuint16_t R;
  struct {
    vuint16_t  :1;
    vuint16_t symbol_window_after_action_point:8;
    vuint16_t macro_initial_offset_a:7;
  } B;
} FR_PCR6_tag;

typedef union FR_PCR7_union_tag {      /* Protocol Configuration Register 7 */
  vuint16_t R;
  struct {
    vuint16_t decoding_correction_b:9;
    vuint16_t micro_per_macro_nom_half:7;
  } B;
} FR_PCR7_tag;

typedef union FR_PCR8_union_tag {      /* Protocol Configuration Register 8 */
  vuint16_t R;
  struct {
    vuint16_t max_without_clock_correction_fatal:4;
    vuint16_t max_without_clock_correction_passive:4;
    vuint16_t wakeup_symbol_tx_idle:8;
  } B;
} FR_PCR8_tag;

typedef union FR_PCR9_union_tag {      /* Protocol Configuration Register 9 */
  vuint16_t R;
  struct {
    vuint16_t minislot_exists:1;
    vuint16_t symbol_window_exists:1;
    vuint16_t offset_correction_out:14;
  } B;
} FR_PCR9_tag;

typedef union FR_PCR10_union_tag {     /* Protocol Configuration Register 10 */
  vuint16_t R;
  struct {
    vuint16_t single_slot_enabled:1;
    vuint16_t wakeup_channel:1;
    vuint16_t macro_per_cycle:14;
  } B;
} FR_PCR10_tag;

typedef union FR_PCR11_union_tag {     /* Protocol Configuration Register 11 */
  vuint16_t R;
  struct {
    vuint16_t key_slot_used_for_startup:1;
    vuint16_t key_slot_used_for_sync:1;
    vuint16_t offset_correction_start:14;
  } B;
} FR_PCR11_tag;

typedef union FR_PCR12_union_tag {     /* Protocol Configuration Register 12 */
  vuint16_t R;
  struct {
    vuint16_t allow_passive_to_active:5;
    vuint16_t key_slot_header_crc:11;
  } B;
} FR_PCR12_tag;

typedef union FR_PCR13_union_tag {     /* Protocol Configuration Register 13 */
  vuint16_t R;
  struct {
    vuint16_t first_minislot_action_point_offset:6;
    vuint16_t static_slot_after_action_point:10;
  } B;
} FR_PCR13_tag;

typedef union FR_PCR14_union_tag {     /* Protocol Configuration Register 14 */
  vuint16_t R;
  struct {
    vuint16_t rate_correction_out:11;
    vuint16_t listen_timeout:5;
  } B;
} FR_PCR14_tag;

typedef union FR_PCR15_union_tag {     /* Protocol Configuration Register 15 */
  vuint16_t R;
  struct {
    vuint16_t listen_timeout:16;
  } B;
} FR_PCR15_tag;

typedef union FR_PCR16_union_tag {     /* Protocol Configuration Register 16 */
  vuint16_t R;
  struct {
    vuint16_t macro_initial_offset_b:7;
    vuint16_t noise_listen_timeout:9;
  } B;
} FR_PCR16_tag;

typedef union FR_PCR17_union_tag {     /* Protocol Configuration Register 17 */
  vuint16_t R;
  struct {
    vuint16_t noise_listen_timeout:16;
  } B;
} FR_PCR17_tag;

typedef union FR_PCR18_union_tag {     /* Protocol Configuration Register 18 */
  vuint16_t R;
  struct {
    vuint16_t wakeup_pattern:6;
    vuint16_t key_slot_id:10;
  } B;
} FR_PCR18_tag;

typedef union FR_PCR19_union_tag {     /* Protocol Configuration Register 19 */
  vuint16_t R;
  struct {
    vuint16_t decoding_correction_a:9;
    vuint16_t payload_length_static:7;
  } B;
} FR_PCR19_tag;

typedef union FR_PCR20_union_tag {     /* Protocol Configuration Register 20 */
  vuint16_t R;
  struct {
    vuint16_t micro_initial_offset_b:8;
    vuint16_t micro_initial_offset_a:8;
  } B;
} FR_PCR20_tag;

typedef union FR_PCR21_union_tag {     /* Protocol Configuration Register 21 */
  vuint16_t R;
  struct {
    vuint16_t extern_rate_correction:3;
    vuint16_t latest_tx:13;
  } B;
} FR_PCR21_tag;

typedef union FR_PCR22_union_tag {     /* Protocol Configuration Register 22 */
  vuint16_t R;
  struct {
    vuint16_t  :1;                     /* Reserved bit, will not be changed. Application must not write any value different from the reset value. */
    vuint16_t comp_accepted_startup_range_a:11;
    vuint16_t micro_per_cycle:4;
  } B;
} FR_PCR22_tag;

typedef union FR_PCR23_union_tag {     /* Protocol Configuration Register 23 */
  vuint16_t R;
  struct {
    vuint16_t micro_per_cycle:16;
  } B;
} FR_PCR23_tag;

typedef union FR_PCR24_union_tag {     /* Protocol Configuration Register 24 */
  vuint16_t R;
  struct {
    vuint16_t cluster_drift_damping:5;
    vuint16_t max_payload_length_dynamic:7;
    vuint16_t micro_per_cycle_min:4;
  } B;
} FR_PCR24_tag;

typedef union FR_PCR25_union_tag {     /* Protocol Configuration Register 25 */
  vuint16_t R;
  struct {
    vuint16_t micro_per_cycle_min:16;
  } B;
} FR_PCR25_tag;

typedef union FR_PCR26_union_tag {     /* Protocol Configuration Register 26 */
  vuint16_t R;
  struct {
    vuint16_t allow_halt_due_to_clock:1;
    vuint16_t comp_accepted_startup_range_b:11;
    vuint16_t micro_per_cycle_max:4;
  } B;
} FR_PCR26_tag;

typedef union FR_PCR27_union_tag {     /* Protocol Configuration Register 27 */
  vuint16_t R;
  struct {
    vuint16_t micro_per_cycle_max:16;
  } B;
} FR_PCR27_tag;

typedef union FR_PCR28_union_tag {     /* Protocol Configuration Register 28 */
  vuint16_t R;
  struct {
    vuint16_t dynamic_slot_idle_phase:2;
    vuint16_t macro_after_offset_correction:14;
  } B;
} FR_PCR28_tag;

typedef union FR_PCR29_union_tag {     /* Protocol Configuration Register 29 */
  vuint16_t R;
  struct {
    vuint16_t extern_offset_correction:3;
    vuint16_t minislots_max:13;
  } B;
} FR_PCR29_tag;

typedef union FR_PCR30_union_tag {     /* Protocol Configuration Register 30 */
  vuint16_t R;
  struct {
    vuint16_t  :12;
    vuint16_t sync_node_max:4;
  } B;
} FR_PCR30_tag;

typedef union FR_STPWR_union_tag {     /* StopWatch Count Register */
  vuint32_t R;
  struct {
    vuint32_t STPW:32;                 /* StopWatch Count Register */
  } B;
} FR_STPWR_tag;

typedef union FR_PEOER_union_tag {     /* Protocol Event Output Enable and StopWatch Control Register */
  vuint16_t R;
  struct {
    vuint16_t  :7;
    vuint16_t STPW_EN:1;               /* Stopwatch count Enable */
    vuint16_t  :5;
    vuint16_t TIM2_EE:1;
    vuint16_t TIM1_EE:1;
    vuint16_t CYC_EE:1;
  } B;
} FR_PEOER_tag;

typedef union FR_RFSDOR_union_tag {    /* Receive FIFO Start Data Offset Register */
  vuint16_t R;
  struct {
    vuint16_t SDO:16;                  /* SDOA/SDOB - Start Data Field Offset */
  } B;
} FR_RFSDOR_tag;

typedef union FR_RFSYMBADHR_union_tag { /* Receive FIFO System Memory Base Address High Register */
  vuint16_t R;
  struct {
    vuint16_t SMBA:16;
  } B;
} FR_RFSYMBADHR_tag;

typedef union FR_RFSYMBADLR_union_tag { /* Receive FIFO System Memory Base Address Low Register */
  vuint16_t R;
  struct {
    vuint16_t SMBA:12;
    vuint16_t  :4;
  } B;
} FR_RFSYMBADLR_tag;

typedef union FR_RFPTR_union_tag {     /* Receive FIFO Periodic Timer Register */
  vuint16_t R;
  struct {
    vuint16_t  :2;
    vuint16_t PTD:14;
  } B;
} FR_RFPTR_tag;

typedef union FR_RFFLPCR_union_tag {   /* Receive FIFO Fill Level and POP Count Register */
  vuint16_t R;
  struct {
    vuint16_t FLB_or_PCB:8;
    vuint16_t FLA_or_PCA:8;
  } B;
} FR_RFFLPCR_tag;

typedef union FR_EEIFER_union_tag {    /* ECC Error Interrupt Flag and Enable Register */
  vuint16_t R;
  struct {
    vuint16_t LRNE_OF:1;
    vuint16_t LRCE_OF:1;
    vuint16_t DRNE_OF:1;
    vuint16_t DRCE_OF:1;
    vuint16_t LRNE_IF:1;
    vuint16_t LRCE_IF:1;
    vuint16_t DRNE_IF:1;
    vuint16_t DRCE_IF:1;
    vuint16_t  :4;
    vuint16_t LRNE_IE:1;
    vuint16_t LRCE_IE:1;
    vuint16_t DRNE_IE:1;
    vuint16_t DRCE_IE:1;
  } B;
} FR_EEIFER_tag;

typedef union FR_EERICR_union_tag {    /* ECC Error Report and Injection Control Register */
  vuint16_t R;
  struct {
    vuint16_t BSY:1;
    vuint16_t  :5;
    vuint16_t ERS:2;
    vuint16_t  :3;
    vuint16_t ERM:1;
    vuint16_t  :2;
    vuint16_t EIM:1;
    vuint16_t EIE:1;
  } B;
} FR_EERICR_tag;

typedef union FR_EERAR_union_tag {     /* ECC Error Report Address Register */
  vuint16_t R;
  struct {
    vuint16_t MID:1;
    vuint16_t BANK:3;
    vuint16_t ADDR:12;
  } B;
} FR_EERAR_tag;

typedef union FR_EERDR_union_tag {     /* ECC Error Report Data Register */
  vuint16_t R;
  struct {
    vuint16_t DATA:16;
  } B;
} FR_EERDR_tag;

typedef union FR_EERCR_union_tag {     /* ECC Error Report Code Register */
  vuint16_t R;
  struct {
    vuint16_t  :11;
    vuint16_t CODE:5;
  } B;
} FR_EERCR_tag;

typedef union FR_EEIAR_union_tag {     /* ECC Error Injection Address Register */
  vuint16_t R;
  struct {
    vuint16_t MID:1;
    vuint16_t BANK:3;
    vuint16_t ADDR:12;
  } B;
} FR_EEIAR_tag;

typedef union FR_EEIDR_union_tag {     /* ECC Error Injection Data Register */
  vuint16_t R;
  struct {
    vuint16_t DATA:16;
  } B;
} FR_EEIDR_tag;

typedef union FR_EEICR_union_tag {     /* ECC Error Injection Code Register */
  vuint16_t R;
  struct {
    vuint16_t  :11;
    vuint16_t CODE:5;
  } B;
} FR_EEICR_tag;

typedef union FR_MB_CCSR_union_tag {   /* Message Buffer Configuration, Control, Status Register */
  vuint16_t R;
  struct {
    vuint16_t  :3;
    vuint16_t MTD:1;
    vuint16_t CMT:1;
    vuint16_t EDT:1;
    vuint16_t LCKT:1;
    vuint16_t MBIE:1;
    vuint16_t  :3;
    vuint16_t DUP:1;
    vuint16_t DVAL:1;
    vuint16_t EDS:1;
    vuint16_t LCKS:1;
    vuint16_t MBIF:1;
  } B;
} FR_MB_CCSR_tag;

typedef union FR_MB_CCFR_union_tag {   /* Message Buffer Cycle Counter Filter Register */
  vuint16_t R;
  struct {
    vuint16_t MTM:1;
    vuint16_t CHA:1;
    vuint16_t CHB:1;
    vuint16_t CCFE:1;
    vuint16_t CCFMSK:6;
    vuint16_t CCFVAL:6;
  } B;
} FR_MB_CCFR_tag;

typedef union FR_MB_FIDR_union_tag {   /* Message Buffer Frame ID Register */
  vuint16_t R;
  struct {
    vuint16_t  :5;
    vuint16_t FID:11;
  } B;
} FR_MB_FIDR_tag;

typedef union FR_MB_IDXR_union_tag {   /* Message Buffer Index Register */
  vuint16_t R;
  struct {
    vuint16_t  :8;
    vuint16_t MBIDX:8;
  } B;
} FR_MB_IDXR_tag;

typedef struct FR_MB_struct_tag {
  FR_MB_CCSR_tag CCSR;                 /* Message Buffer Configuration, Control, Status Register */
  FR_MB_CCFR_tag CCFR;                 /* Message Buffer Cycle Counter Filter Register */
  FR_MB_FIDR_tag FIDR;                 /* Message Buffer Frame ID Register */
  FR_MB_IDXR_tag IDXR;                 /* Message Buffer Index Register */
} FR_MB_tag;

typedef union FR_MBDOR_union_tag {     /* Message Buffer Data Field Offset Register */
  vuint16_t R;
  struct {
    vuint16_t MBDO:16;
  } B;
} FR_MBDOR_tag;

typedef union FR_LEETR_union_tag {     /* LRAM ECC Error Test Register */
  vuint16_t R;
  struct {
    vuint16_t LEETD:16;
  } B;
} FR_LEETR_tag;

struct FR_tag {
  FR_MVR_tag MVR;                      /* Module Version Register */
  FR_MCR_tag MCR;                      /* Module Configuration Register */
  FR_SYMBADHR_tag SYMBADHR;            /* System Memory Base Address High Register */
  FR_SYMBADLR_tag SYMBADLR;            /* System Memory Base Address Low Register */
  FR_STBSCR_tag STBSCR;                /* Strobe Signal Control Register */
  uint8_t FR_reserved0[2];
  FR_MBDSR_tag MBDSR;                  /* Message Buffer Data Size Register */
  FR_MBSSUTR_tag MBSSUTR;              /* Message Buffer Segment Size and Utilization Register */
  FR_PEDRAR_tag PEDRAR;                /* PE DRAM Access Register */
  FR_PEDRDR_tag PEDRDR;                /* PE DRAM Data Register */
  FR_POCR_tag POCR;                    /* Protocol Operation Control Register */
  FR_GIFER_tag GIFER;                  /* Global Interrupt Flag and Enable Register */
  FR_PIFR0_tag PIFR0;                  /* Protocol Interrupt Flag Register 0 */
  FR_PIFR1_tag PIFR1;                  /* Protocol Interrupt Flag Register 1 */
  FR_PIER0_tag PIER0;                  /* Protocol Interrupt Enable Register 0 */
  FR_PIER1_tag PIER1;                  /* Protocol Interrupt Enable Register 1 */
  FR_CHIERFR_tag CHIERFR;              /* CHI Error Flag Register */
  FR_MBIVEC_tag MBIVEC;                /* Message Buffer Interrupt Vector Register */
  FR_CASERCR_tag CASERCR;              /* Channel A Status Error Counter Register */
  FR_CBSERCR_tag CBSERCR;              /* Channel B Status Error Counter Register */
  FR_PSR0_tag PSR0;                    /* Protocol Status Register 0 */
  FR_PSR1_tag PSR1;                    /* Protocol Status Register 1 */
  FR_PSR2_tag PSR2;                    /* Protocol Status Register 2 */
  FR_PSR3_tag PSR3;                    /* Protocol Status Register 3 */
  FR_MTCTR_tag MTCTR;                  /* Macrotick Counter Register */
  FR_CYCTR_tag CYCTR;                  /* Cycle Counter Register */
  FR_SLTCTAR_tag SLTCTAR;              /* Slot Counter Channel A Register */
  FR_SLTCTBR_tag SLTCTBR;              /* Slot Counter Channel B Register */
  FR_RTCORVR_tag RTCORVR;              /* Rate Correction Value Register */
  FR_OFCORVR_tag OFCORVR;              /* Offset Correction Value Register */
  FR_CIFR_tag CIFR;                    /* Combined Interrupt Flag Register */
  FR_SYMATOR_tag SYMATOR;              /* System Memory Access Time-Out Register */
  FR_SFCNTR_tag SFCNTR;                /* Sync Frame Counter Register */
  FR_SFTOR_tag SFTOR;                  /* Sync Frame Table Offset Register */
  FR_SFTCCSR_tag SFTCCSR;              /* Sync Frame Table Configuration, Control, Status Register */
  FR_SFIDRFR_tag SFIDRFR;              /* Sync Frame ID Rejection Filter Register */
  FR_SFIDAFVR_tag SFIDAFVR;            /* Sync Frame ID Acceptance Filter Value Register */
  FR_SFIDAFMR_tag SFIDAFMR;            /* Sync Frame ID Acceptance Filter Mask Register */
  FR_NMVR_tag NMVR[6];                 /* Network Management Vector Register */
  FR_NMVLR_tag NMVLR;                  /* Network Management Vector Length Register */
  FR_TICCR_tag TICCR;                  /* Timer Configuration and Control Register */
  FR_TI1CYSR_tag TI1CYSR;              /* Timer 1 Cycle Set Register */
  FR_TI1MTOR_tag TI1MTOR;              /* Timer 1 Macrotick Offset Register */
  FR_TI2CR0_tag TI2CR0;
  FR_TI2CR1_tag TI2CR1;
  FR_SSSR_tag SSSR;                    /* Slot Status Selection Register */
  FR_SSCCR_tag SSCCR;                  /* Slot Status Counter Condition Register */
  FR_SSR_tag SSR[8];                   /* Slot Status Register */
  FR_SSCR_tag SSCR[4];                 /* Slot Status Counter Register */
  FR_MTSACFR_tag MTSACFR;              /* MTS A Configuration Register */
  FR_MTSBCFR_tag MTSBCFR;              /* MTS B Configuration Register */
  FR_RSBIR_tag RSBIR;                  /* Receive Shadow Buffer Index Register */
  FR_RFWMSR_tag RFWMSR;                /* Receive FIFO Watermark and Selection Register */
  FR_RFSIR_tag RFSIR;                  /* Receive FIFO Start Index Register */
  FR_RFDSR_tag RFDSR;                  /* Receive FIFO Depth and Size Register */
  FR_RFARIR_tag RFARIR;                /* Receive FIFO A Read Index Register */
  FR_RFBRIR_tag RFBRIR;                /* Receive FIFO B Read Index Register */
  FR_RFMIDAFVR_tag RFMIDAFVR;          /* Receive FIFO Message ID Acceptance Filter Value Register */
  FR_RFMIDAFMR_tag RFMIDAFMR;          /* Receive FIFO Message ID Acceptance Filter Mask Register */
  FR_RFFIDRFVR_tag RFFIDRFVR;          /* Receive FIFO Frame ID Rejection Filter Value Register */
  FR_RFFIDRFMR_tag RFFIDRFMR;          /* Receive FIFO Frame ID Rejection Filter Mask Register */
  FR_RFRFCFR_tag RFRFCFR;              /* Receive FIFO Range Filter Configuration Register */
  FR_RFRFCTR_tag RFRFCTR;              /* Receive FIFO Range Filter Control Register */
  FR_LDTXSLAR_tag LDTXSLAR;            /* Last Dynamic Transmit Slot Channel A Register */
  FR_LDTXSLBR_tag LDTXSLBR;            /* Last Dynamic Transmit Slot Channel B Register */
  FR_PCR0_tag PCR0;                    /* Protocol Configuration Register 0 */
  FR_PCR1_tag PCR1;                    /* Protocol Configuration Register 1 */
  FR_PCR2_tag PCR2;                    /* Protocol Configuration Register 2 */
  FR_PCR3_tag PCR3;                    /* Protocol Configuration Register 3 */
  FR_PCR4_tag PCR4;                    /* Protocol Configuration Register 4 */
  FR_PCR5_tag PCR5;                    /* Protocol Configuration Register 5 */
  FR_PCR6_tag PCR6;                    /* Protocol Configuration Register 6 */
  FR_PCR7_tag PCR7;                    /* Protocol Configuration Register 7 */
  FR_PCR8_tag PCR8;                    /* Protocol Configuration Register 8 */
  FR_PCR9_tag PCR9;                    /* Protocol Configuration Register 9 */
  FR_PCR10_tag PCR10;                  /* Protocol Configuration Register 10 */
  FR_PCR11_tag PCR11;                  /* Protocol Configuration Register 11 */
  FR_PCR12_tag PCR12;                  /* Protocol Configuration Register 12 */
  FR_PCR13_tag PCR13;                  /* Protocol Configuration Register 13 */
  FR_PCR14_tag PCR14;                  /* Protocol Configuration Register 14 */
  FR_PCR15_tag PCR15;                  /* Protocol Configuration Register 15 */
  FR_PCR16_tag PCR16;                  /* Protocol Configuration Register 16 */
  FR_PCR17_tag PCR17;                  /* Protocol Configuration Register 17 */
  FR_PCR18_tag PCR18;                  /* Protocol Configuration Register 18 */
  FR_PCR19_tag PCR19;                  /* Protocol Configuration Register 19 */
  FR_PCR20_tag PCR20;                  /* Protocol Configuration Register 20 */
  FR_PCR21_tag PCR21;                  /* Protocol Configuration Register 21 */
  FR_PCR22_tag PCR22;                  /* Protocol Configuration Register 22 */
  FR_PCR23_tag PCR23;                  /* Protocol Configuration Register 23 */
  FR_PCR24_tag PCR24;                  /* Protocol Configuration Register 24 */
  FR_PCR25_tag PCR25;                  /* Protocol Configuration Register 25 */
  FR_PCR26_tag PCR26;                  /* Protocol Configuration Register 26 */
  FR_PCR27_tag PCR27;                  /* Protocol Configuration Register 27 */
  FR_PCR28_tag PCR28;                  /* Protocol Configuration Register 28 */
  FR_PCR29_tag PCR29;                  /* Protocol Configuration Register 29 */
  FR_PCR30_tag PCR30;                  /* Protocol Configuration Register 30 */
  FR_STPWR_tag STPWR;                  /* StopWatch Count Register */
  FR_PEOER_tag PEOER;                  /* Protocol Event Output Enable and StopWatch Control Register */
  uint8_t FR_reserved1[2];
  FR_RFSDOR_tag RFSDOR;                /* Receive FIFO Start Data Offset Register */
  FR_RFSYMBADHR_tag RFSYMBADHR;        /* Receive FIFO System Memory Base Address High Register */
  FR_RFSYMBADLR_tag RFSYMBADLR;        /* Receive FIFO System Memory Base Address Low Register */
  FR_RFPTR_tag RFPTR;                  /* Receive FIFO Periodic Timer Register */
  FR_RFFLPCR_tag RFFLPCR;              /* Receive FIFO Fill Level and POP Count Register */
  FR_EEIFER_tag EEIFER;                /* ECC Error Interrupt Flag and Enable Register */
  FR_EERICR_tag EERICR;                /* ECC Error Report and Injection Control Register */
  FR_EERAR_tag EERAR;                  /* ECC Error Report Address Register */
  FR_EERDR_tag EERDR;                  /* ECC Error Report Data Register */
  FR_EERCR_tag EERCR;                  /* ECC Error Report Code Register */
  FR_EEIAR_tag EEIAR;                  /* ECC Error Injection Address Register */
  FR_EEIDR_tag EEIDR;                  /* ECC Error Injection Data Register */
  FR_EEICR_tag EEICR;                  /* ECC Error Injection Code Register */
  uint8_t FR_reserved2[1792];
  FR_MB_tag MB[128];
  uint8_t FR_reserved3[1024];
  FR_MBDOR_tag MBDOR[132];             /* Message Buffer Data Field Offset Register */
  FR_LEETR_tag LEETR[6];               /* LRAM ECC Error Test Register */
};


/* ============================================================================
   =============================== Module: GTM ================================
   ============================================================================ */

struct GTM_tag {
  union {                              /* GTM Revision Register */
    vuint32_t R;
    struct {
      vuint32_t DEV_CODE2:4;           /* Device encoding digit 2. */
      vuint32_t DEV_CODE1:4;           /* Device encoding digit 1. */
      vuint32_t DEV_CODE0:4;           /* Device encoding digit 0. */
      vuint32_t MAJOR:4;               /* Major version number */
      vuint32_t MINOR:4;               /* Minor version number */
      vuint32_t NO:4;                  /* Delivery number. */
      vuint32_t STEP:8;                /* Release step. */
    } B;
  } REV;

  union {                              /* GTM Reset Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t RST:1;                 /* GTM Reset. */
    } B;
  } RST;

  union {                              /* GTM Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;                  /* Read as zero, should be written as zero. */
      vuint32_t TO_VAL:5;              /* AEI Timeout value. */
      vuint32_t  :2;                   /* Read as zero, should be written as zero. */
      vuint32_t TO_MODE:1;             /* AEI Timeout mode. */
      vuint32_t RF_PROT:1;             /* RST and FORCINT protection. */
    } B;
  } CTRL;

  union {                              /* GTM AEI Address Pointer Register */
    vuint32_t R;
    struct {
      vuint32_t  :11;
      vuint32_t TO_W1R0:1;             /* AEI Timeout Read/Write flag. */
      vuint32_t TO_ADDR:20;            /* AEI Timeout address. */
    } B;
  } AEI_ADDR_XPT;

  union {                              /* GTM Interrupt Request Notification Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t AEI_USP_BE:1;          /* AEI Unsupported byte enable interrupt. */
      vuint32_t AEI_IM_ADDR:1;         /* AEI Illegal Module address interrupt. */
      vuint32_t AEI_USP_ADDR:1;        /* AEI Unsupported address interrupt. */
      vuint32_t AEI_TO_XPT:1;          /* AEI Timeout exception occurred. */
    } B;
  } IRQ_NOTIFY;

  union {                              /* GTM Interrupt Request Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t AEI_USP_BE_IRQ_EN:1;   /* AEI Unsupported Byte Enable Interrupt Enable. */
      vuint32_t AEI_IM_ADDR_IRQ_EN:1;  /* AEI Illegal Module Address Interrupt Enable. */
      vuint32_t AEI_USP_ADDR_IRQ_EN:1; /* AEI Unsupported Address Interrupt Enable. */
      vuint32_t AEI_TO_XPT_IRQ_EN:1;   /* AEI Timeout Exception Interrupt Enable. */
    } B;
  } IRQ_EN;

  union {                              /* GTM Force Interrupt Request Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t TRG_AEI_USP_BE:1;      /* Trigger AEI_USP_BE_IRQ interrupt by software. */
      vuint32_t TRG_AEI_IM_ADDR:1;     /* Trigger AEI_IM_ADDR_IRQ interrupt by software. */
      vuint32_t TRG_AEI_USP_ADDR:1;    /* Trigger AEI_USP_ADDR_IRQ interrupt by software. */
      vuint32_t TRG_AEI_TO_XPT:1;      /* Trigger AEI_TO_XPT_IRQ interrupt by software. */
    } B;
  } IRQ_FORCINT;

  union {                              /* GTM Interrupt Request Mode Register */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Read as zero, should be written as zero. */
      vuint32_t IRQ_MODE:2;            /* Interrupt strategy mode selection for the AEI timeout and address monitoring interrupts. */
    } B;
  } IRQ_MODE;

  union {                              /* GTM Error Interrupt Request Enable register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t AEI_USP_BE_EIRQ_EN:1;  /* AEI_USP_BE_EIRQ error interrupt enable. */
      vuint32_t AEI_IM_ADDR_EIRQ_EN:1; /* AEI_IM_ADDR_EIRQ error interrupt enable. */
      vuint32_t AEI_USP_ADDR_EIRQ_EN:1; /* AEI_USP_ADDR_EIRQ error interrupt enable. */
      vuint32_t AEI_TO_XPT_EIRQ_EN:1;  /* AEI_TO_XPT_EIRQ error interrupt enable. */
    } B;
  } EIRQ_EN;

  uint8_t GTM_reserved0[12];
  union {                              /* GTM Bridge Mode Register */
    vuint32_t R;
    struct {
      vuint32_t BUFF_DPT:8;            /* Buffer depth of AEI bridge. */
      vuint32_t  :7;
      vuint32_t BRG_RST:1;             /* Bridge software reset. */
      vuint32_t  :3;
      vuint32_t SYNC_INPUT_REG:1;      /* Additional pipelined stage in synchronous bridge mode. */
      vuint32_t  :2;
      vuint32_t BUFF_OVL:1;            /* Buffer overflow register. */
      vuint32_t MODE_UP_PGR:1;         /* Mode update in progress. */
      vuint32_t  :6;
      vuint32_t MSK_WR_RSP:1;          /* Mask write response. */
      vuint32_t BRG_MODE:1;            /* Defines the operation mode for the AEI bridge. */
    } B;
  } BRIDGE_MODE;

  union {                              /* GTM Bridge Pointer 1 Register */
    vuint32_t R;
    struct {
      vuint32_t RSP_TRAN_RDY:6;        /* Response transactions ready. */
      vuint32_t FBC:6;                 /* Free buffer count. */
      vuint32_t ABT_TRAN_PGR:5;        /* Aborted transaction in progress pointer. */
      vuint32_t TRAN_IN_PGR:5;         /* Transaction in progress pointer (acquire). */
      vuint32_t FIRST_RSP_PTR:5;       /* First response pointer. */
      vuint32_t NEW_TRAN_PTR:5;        /* New transaction pointer. */
    } B;
  } BRIDGE_PTR1;

  union {                              /* GTM Bridge Pointer 2 Register */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t TRAN_IN_PGR2:5;        /* Transaction in progress pointer (aquire2). */
    } B;
  } BRIDGE_PTR2;

  uint8_t GTM_reserved1[4];
  union {                              /* GTM TIM0 Auxiliary Input Source register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t SRC_CH7:1;             /* Defines AUX_IN source of TIM[i] channel 7. */
      vuint32_t SRC_CH6:1;             /* Defines AUX_IN source of TIM[i] channel 6. */
      vuint32_t SRC_CH5:1;             /* Defines AUX_IN source of TIM[i] channel 5. */
      vuint32_t SRC_CH4:1;             /* Defines AUX_IN source of TIM[i] channel 4. */
      vuint32_t SRC_CH3:1;             /* Defines AUX_IN source of TIM[i] channel 3. */
      vuint32_t SRC_CH2:1;             /* Defines AUX_IN source of TIM[i] channel 2. */
      vuint32_t SRC_CH1:1;             /* Defines AUX_IN source of TIM[i] channel 1. */
      vuint32_t SRC_CH0:1;             /* Defines AUX_IN source of TIM[i] channel 0. */
    } B;
  } TIM0_AUX_IN_SRC;

  union {                              /* GTM TIM1 Auxiliary Input Source register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t SRC_CH7:1;             /* Defines AUX_IN source of TIM[i] channel 7. */
      vuint32_t SRC_CH6:1;             /* Defines AUX_IN source of TIM[i] channel 6. */
      vuint32_t SRC_CH5:1;             /* Defines AUX_IN source of TIM[i] channel 5. */
      vuint32_t SRC_CH4:1;             /* Defines AUX_IN source of TIM[i] channel 4. */
      vuint32_t SRC_CH3:1;             /* Defines AUX_IN source of TIM[i] channel 3. */
      vuint32_t SRC_CH2:1;             /* Defines AUX_IN source of TIM[i] channel 2. */
      vuint32_t SRC_CH1:1;             /* Defines AUX_IN source of TIM[i] channel 1. */
      vuint32_t SRC_CH0:1;             /* Defines AUX_IN source of TIM[i] channel 0. */
    } B;
  } TIM1_AUX_IN_SRC;

  union {                              /* GTM TIM2 Auxiliary Input Source register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t SRC_CH7:1;             /* Defines AUX_IN source of TIM[i] channel 7. */
      vuint32_t SRC_CH6:1;             /* Defines AUX_IN source of TIM[i] channel 6. */
      vuint32_t SRC_CH5:1;             /* Defines AUX_IN source of TIM[i] channel 5. */
      vuint32_t SRC_CH4:1;             /* Defines AUX_IN source of TIM[i] channel 4. */
      vuint32_t SRC_CH3:1;             /* Defines AUX_IN source of TIM[i] channel 3. */
      vuint32_t SRC_CH2:1;             /* Defines AUX_IN source of TIM[i] channel 2. */
      vuint32_t SRC_CH1:1;             /* Defines AUX_IN source of TIM[i] channel 1. */
      vuint32_t SRC_CH0:1;             /* Defines AUX_IN source of TIM[i] channel 0. */
    } B;
  } TIM2_AUX_IN_SRC;

  union {                              /* GTM TIM3 Auxiliary Input Source register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t SRC_CH7:1;             /* Defines AUX_IN source of TIM[i] channel 7. */
      vuint32_t SRC_CH6:1;             /* Defines AUX_IN source of TIM[i] channel 6. */
      vuint32_t SRC_CH5:1;             /* Defines AUX_IN source of TIM[i] channel 5. */
      vuint32_t SRC_CH4:1;             /* Defines AUX_IN source of TIM[i] channel 4. */
      vuint32_t SRC_CH3:1;             /* Defines AUX_IN source of TIM[i] channel 3. */
      vuint32_t SRC_CH2:1;             /* Defines AUX_IN source of TIM[i] channel 2. */
      vuint32_t SRC_CH1:1;             /* Defines AUX_IN source of TIM[i] channel 1. */
      vuint32_t SRC_CH0:1;             /* Defines AUX_IN source of TIM[i] channel 0. */
    } B;
  } TIM3_AUX_IN_SRC;

  union {                              /* GTM TIM4 Auxiliary Input Source register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t SRC_CH7:1;             /* Defines AUX_IN source of TIM[i] channel 7. */
      vuint32_t SRC_CH6:1;             /* Defines AUX_IN source of TIM[i] channel 6. */
      vuint32_t SRC_CH5:1;             /* Defines AUX_IN source of TIM[i] channel 5. */
      vuint32_t SRC_CH4:1;             /* Defines AUX_IN source of TIM[i] channel 4. */
      vuint32_t SRC_CH3:1;             /* Defines AUX_IN source of TIM[i] channel 3. */
      vuint32_t SRC_CH2:1;             /* Defines AUX_IN source of TIM[i] channel 2. */
      vuint32_t SRC_CH1:1;             /* Defines AUX_IN source of TIM[i] channel 1. */
      vuint32_t SRC_CH0:1;             /* Defines AUX_IN source of TIM[i] channel 0. */
    } B;
  } TIM4_AUX_IN_SRC;

  union {                              /* GTM TIM5 Auxiliary Input Source register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t SRC_CH7:1;             /* Defines AUX_IN source of TIM[i] channel 7. */
      vuint32_t SRC_CH6:1;             /* Defines AUX_IN source of TIM[i] channel 6. */
      vuint32_t SRC_CH5:1;             /* Defines AUX_IN source of TIM[i] channel 5. */
      vuint32_t SRC_CH4:1;             /* Defines AUX_IN source of TIM[i] channel 4. */
      vuint32_t SRC_CH3:1;             /* Defines AUX_IN source of TIM[i] channel 3. */
      vuint32_t SRC_CH2:1;             /* Defines AUX_IN source of TIM[i] channel 2. */
      vuint32_t SRC_CH1:1;             /* Defines AUX_IN source of TIM[i] channel 1. */
      vuint32_t SRC_CH0:1;             /* Defines AUX_IN source of TIM[i] channel 0. */
    } B;
  } TIM5_AUX_IN_SRC;
};


/* ============================================================================
   =============================== Module: GTMINT =============================
   ============================================================================ */

typedef union GTMINT_GTMMCR_union_tag { /* GTM Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* [Covers: Saf1461] MDIS Module Disable. */
    vuint32_t  :13;
    vuint32_t AEISREN:1;               /* Saf1276 - Safety-critical AEISREN AEI interface soft-reset control enable. */
    vuint32_t  :1;
    vuint32_t STPS:1;                  /* [Covers: Saf1461] STPS Stop Mode Status. */
    vuint32_t  :14;
  } B;
} GTMINT_GTMMCR_tag;

typedef union GTMINT_GTMINTCLR_union_tag { /* GTM Interrupts Clear Register */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t INTCLR_PTR:10;           /* [Covers: Saf1461] INTCLR_PTR Interrupt Clear Pointer. */
  } B;
} GTMINT_GTMINTCLR_tag;

typedef union GTMINT_GTMAEICR_union_tag { /* GTM AEI Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t AEISRST:1;               /* [Covers: Saf1461] AEISRST AEI interface soft-reset control. */
  } B;
} GTMINT_GTMAEICR_tag;

struct GTMINT_tag {
  uint8_t GTMINT_reserved0[192];
  GTMINT_GTMMCR_tag GTMMCR;            /* GTM Module Configuration Register */
  uint8_t GTMINT_reserved1[4];
  GTMINT_GTMINTCLR_tag GTMINTCLR;      /* GTM Interrupts Clear Register */
  GTMINT_GTMAEICR_tag GTMAEICR;        /* GTM AEI Control Register */
};


/* ============================================================================
   =============================== Module: GTM_AFD ============================
   ============================================================================ */

struct GTM_AFD_tag {
  struct {
    union {                            /* AFD FIFO Channel n Buffer Access Register, n=0:7 */
      vuint32_t R;
      struct {
        vuint32_t  :3;
        vuint32_t DATA:29;             /* Read/write data from/to FIFO. */
      } B;
    } BUF_ACC;
    uint8_t CH_reserved0[12];
  } CH[8];
};


/* ============================================================================
   =============================== Module: GTM_ARU ============================
   ============================================================================ */

struct GTM_ARU_tag {
  union {                              /* ARU Access Register */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t WREQ:1;                /* Initiate write request. */
      vuint32_t RREQ:1;                /* Initiate read request. */
      vuint32_t  :3;
      vuint32_t ADDR:9;                /* ARU address. */
    } B;
  } ACCESS;

  union {                              /* ARU Data High Register */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t DATA:29;               /* Upper ARU data word. */
    } B;
  } DATA_H;

  union {                              /* ARU Data Low Register */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t DATA:29;               /* Lower ARU data word. */
    } B;
  } DATA_L;

  union {                              /* ARU Debug Access 0 Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t ADDR:9;                /* ARU debugging address. */
    } B;
  } DBG_ACCESS0;

  union {                              /* ARU Debug Data 0 High Register */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t DATA:29;               /* Upper debug data word. */
    } B;
  } DBG_DATA0_H;

  union {                              /* ARU Debug Data 0 Low Register */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t DATA:29;               /* Lower debug data word. */
    } B;
  } DBG_DATA0_L;

  union {                              /* ARU Debug Access 1 Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t ADDR:9;                /* ARU debugging address. */
    } B;
  } DBG_ACCESS1;

  union {                              /* ARU Debug Data 1 High */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t DATA:29;               /* Upper debug data word */
    } B;
  } DBG_DATA1_H;

  union {                              /* ARU Debug Data 1 Low Register */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t DATA:29;               /* Lower debug data word. */
    } B;
  } DBG_DATA1_L;

  union {                              /* ARU Interrupt Request Notification Register */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t ACC_ACK:1;             /* On read access data valid, AEI to ARU access is complete. */
      vuint32_t NEW_DATA1:1;           /* Data was transferred for address ARU_DBG_ACCESS1. */
      vuint32_t NEW_DATA0:1;           /* Data was transferred for address ARU_DBG_ACCESS0. */
    } B;
  } IRQ_NOTIFY;

  union {                              /* ARU Interrupt Request Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t ACC_ACK_IRQ_EN:1;      /* ACC_ACK_IRQ interrupt enable. */
      vuint32_t NEW_DATA1_IRQ_EN:1;    /* ARU_NEW_DATA1_IRQ interrupt enable. */
      vuint32_t NEW_DATA0_IRQ_EN:1;    /* ARU_NEW_DATA0_IRQ interrupt enable. */
    } B;
  } IRQ_EN;

  union {                              /* ARU Force Interrupt Request Register */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t TRG_ACC_ACK:1;         /* Trigger ACC_ACK interrupt. */
      vuint32_t TRG_NEW_DATA1:1;       /* Trigger new data 1 interrupt. */
      vuint32_t TRG_NEW_DATA0:1;       /* Trigger new data 0 interrupt. */
    } B;
  } IRQ_FORCINT;

  union {                              /* ARU Interrupt Request Mode Register */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t IRQ_MODE:2;            /* IRQ mode select. */
    } B;
  } IRQ_MODE;
};


/* ============================================================================
   =============================== Module: GTM_ATOM ===========================
   ============================================================================ */

struct GTM_ATOM_tag {
  union {                              /* ATOM Channel n Read Address Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t RDADDR1:9;             /* ARU Read address 1. */
      vuint32_t  :7;
      vuint32_t RDADDR0:9;             /* ARU Read address 0. */
    } B;
  } CH0_RDADDR;

  union {                              /* ATOM Channel n Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t ABM:1;                 /* ARU blocking mode. */
      vuint32_t OSM:1;                 /* One-shot mode. */
      vuint32_t SLA:1;                 /* Serve last ARU communication strategy */
      vuint32_t TRIGOUT:1;             /* NTrigger output selection (output signal TRIG_CHn) of module ATOM_CHn. */
      vuint32_t  :3;                   /* Reads as zero, should be written as zero. */
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :3;
      vuint32_t WR_REQ:1;              /* CPU Write request bit for late compare register update. */
      vuint32_t  :1;
      vuint32_t CLK_SRC_SR:3;          /* Actual CMU clock source (SOMS) / shadow register for CMU clock source (SOMP). */
      vuint32_t SL:1;                  /* Initial signal level after channel enable. */
      vuint32_t  :1;
      vuint32_t CMP_CTRL:1;            /* CCUn compare strategy select.. */
      vuint32_t ACB:5;                 /* ATOM Mode control bits. */
      vuint32_t ARU_EN:1;              /* ARU Input stream enable. */
      vuint32_t TB12_SEL:1;            /* Select time base value TBU_TS1 or TBU_TS2. */
      vuint32_t MODE:2;                /* ATOM channel mode select. */
    } B;
  } CH0_CTRL;

  union {                              /* ATOM Channel n Shadow 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SR0:24;                /* ATOM channel n shadow register SR0. */
    } B;
  } CH0_SR0;

  union {                              /* ATOM Channel n Shadow 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SR1:24;                /* ATOM channel n shadow register SR1. */
    } B;
  } CH0_SR1;

  union {                              /* ATOM Channel n Compare Match 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CM0:24;                /* ATOM CCU0 compare register. */
    } B;
  } CH0_CM0;

  union {                              /* ATOM Channel n Compare Match 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CM1:24;                /* ATOM CCU1 compare register. */
    } B;
  } CH0_CM1;

  union {                              /* ATOM Channel n Counter 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CN0:24;                /* ATOM CCU0 counter register. */
    } B;
  } CH0_CN0;

  union {                              /* ATOM Channel n Status Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t ACBO:5;                /* ATOM Internal status bits. */
      vuint32_t  :1;
      vuint32_t WRF:1;                 /* Write request of CPU failed for late update. */
      vuint32_t DV:1;                  /* Valid ARU Data stored in compare registers. */
      vuint32_t ACBI:5;                /* ATOM Mode control bits received through ARU. */
      vuint32_t  :15;
      vuint32_t OL:1;                  /* Actual output signal level of ATOM_CHn_OUT. */
    } B;
  } CH0_STAT;

  union {                              /* ATOM Channel n Interrupt Request Notification Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH0_IRQ_NOTIFY;

  union {                              /* ATOM Channel n Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t CCU1TC_IRQ_EN:1;       /* ATOM_CCU1TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* ATOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH0_IRQ_EN;

  union {                              /* ATOM Channel n Force Interrupt Request Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t TRG_CCU1TC:1;          /* Trigger ATOM_CCU1TC_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC:1;          /* Trigger ATOM_CCU0TC_IRQ interrupt by software. */
    } B;
  } CH0_IRQ_FORCINT;

  union {                              /* ATOM Channel n Interrupt Request Mode Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH0_IRQ_MODE;

  uint8_t ATOM_reserved0[16];
  union {                              /* ATOM AGC Global Control Register */
    vuint32_t R;
    struct {
      vuint32_t UPEN_CTRL7:2;          /* For channel 7, ATOM channel enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL6:2;          /* For channel 6, ATOM channel enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL5:2;          /* For channel 5, ATOM channel enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL4:2;          /* For channel 4, ATOM channel enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL3:2;          /* For channel 3, ATOM channel enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL2:2;          /* For channel 2, ATOM channel enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL1:2;          /* For channel 1, ATOM channel enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL0:2;          /* For channel 0, ATOM channel enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t RST_CH7:1;             /* See RST_CH0 */
      vuint32_t RST_CH6:1;             /* See RST_CH0 */
      vuint32_t RST_CH5:1;             /* See RST_CH0 */
      vuint32_t RST_CH4:1;             /* See RST_CH0 */
      vuint32_t RST_CH3:1;             /* See RST_CH0 */
      vuint32_t RST_CH2:1;             /* See RST_CH0 */
      vuint32_t RST_CH1:1;             /* See RST_CH0 */
      vuint32_t RST_CH0:1;             /* Software reset of corresponding channel 0. */
      vuint32_t  :7;
      vuint32_t HOST_TRIG:1;           /* Trigger request signal (see AGC) to update the register ENDIS_STAT and OUTEN_STAT. */
    } B;
  } AGC_GLB_CTRL;

  union {                              /* ATOM TGC0 Enable/Disable Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t ENDIS_CTRL7:2;         /* Channel 7 enable/disable update value. */
      vuint32_t ENDIS_CTRL6:2;         /* Channel 6 enable/disable update value. */
      vuint32_t ENDIS_CTRL5:2;         /* Channel 5 enable/disable update value. */
      vuint32_t ENDIS_CTRL4:2;         /* TOM channel 4 enable/disable update value. */
      vuint32_t ENDIS_CTRL3:2;         /* TOM channel 3 enable/disable update value. */
      vuint32_t ENDIS_CTRL2:2;         /* TOM channel 2 enable/disable update value. */
      vuint32_t ENDIS_CTRL1:2;         /* TOM channel 1 enable/disable update value. */
      vuint32_t ENDIS_CTRL0:2;         /* TOM channel 0 enable/disable update value. */
    } B;
  } AGC_ENDIS_CTRL;

  union {                              /* ATOM TGC0 Enable/Disable Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t ENDIS_STAT7:2;         /* TOM channel 7 enable/disable. */
      vuint32_t ENDIS_STAT6:2;         /* TOM channel 6 enable/disable. */
      vuint32_t ENDIS_STAT5:2;         /* TOM channel 5 enable/disable. */
      vuint32_t ENDIS_STAT4:2;         /* TOM channel 4 enable/disable. */
      vuint32_t ENDIS_STAT3:2;         /* TOM channel 3 enable/disable. */
      vuint32_t ENDIS_STAT2:2;         /* TOM channel 2 enable/disable. */
      vuint32_t ENDIS_STAT1:2;         /* TOM channel 1 enable/disable. */
      vuint32_t ENDIS_STAT0:2;         /* TOM channel 0 enable/disable. */
    } B;
  } AGC_ENDIS_STAT;

  union {                              /* ATOM TGC0 Action Time Base Register */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t TBU_SEL:2;             /* Selection of time base used for comparison. */
      vuint32_t TB_TRIG:1;             /* Set trigger request. */
      vuint32_t ACT_TB:24;             /* Specifies the signed compare value with selected signal TBU_TS[n], x=0..2. */
    } B;
  } AGC_ACT_TB;

  union {                              /* ATOM TGC0 Out Enable Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t OUTEN_CTRL7:2;         /* Output TOM_OUT(7) enable/disable update value. */
      vuint32_t OUTEN_CTRL6:2;         /* Output TOM_OUT(6) enable/disable update value. */
      vuint32_t OUTEN_CTRL5:2;         /* Output TOM_OUT(5) enable/disable update value. */
      vuint32_t OUTEN_CTRL4:2;         /* Output TOM_OUT(4) enable/disable update value. */
      vuint32_t OUTEN_CTRL3:2;         /* Output TOM_OUT(3) enable/disable update value. */
      vuint32_t OUTEN_CTRL2:2;         /* Output TOM_OUT(2) enable/disable update value. */
      vuint32_t OUTEN_CTRL1:2;         /* Output TOM_OUT(1) enable/disable update value. */
      vuint32_t OUTEN_CTRL0:2;         /* Output TOM_OUT(0) enable/disable update value. */
    } B;
  } AGC_OUTEN_CTRL;

  union {                              /* ATOM TGC0 Out Enable Control/Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t OUTEN_STAT7:2;         /* Control/status of output TOM_OUT(7). */
      vuint32_t OUTEN_STAT6:2;         /* Control/status of output TOM_OUT(6). */
      vuint32_t OUTEN_STAT5:2;         /* Control/status of output TOM_OUT(5). */
      vuint32_t OUTEN_STAT4:2;         /* Control/status of output TOM_OUT(4) */
      vuint32_t OUTEN_STAT3:2;         /* Control/status of output TOM_OUT(3). */
      vuint32_t OUTEN_STAT2:2;         /* Control/status of output TOM_OUT(2). */
      vuint32_t OUTEN_STAT1:2;         /* Control/status of output TOM_OUT(1). */
      vuint32_t OUTEN_STAT0:2;         /* Control/status of output TOM_OUT(0). */
    } B;
  } AGC_OUTEN_STAT;

  union {                              /* ATOM TGC0 Force Update Control Register */
    vuint32_t R;
    struct {
      vuint32_t RSTCN0_CH7:2;          /* Reset CN0 of channel 7 on force update event. */
      vuint32_t RSTCN0_CH6:2;          /* Reset CN0 of channel 6 on force update event. */
      vuint32_t RSTCN0_CH5:2;          /* Reset CN0 of channel 5 on force update event. */
      vuint32_t RSTCN0_CH4:2;          /* Reset CN0 of channel 4 on force update event. */
      vuint32_t RSTCN0_CH3:2;          /* Reset CN0 of channel 3 on force update event. */
      vuint32_t RSTCN0_CH2:2;          /* Reset CN0 of channel 2 on force update event. */
      vuint32_t RSTCN0_CH1:2;          /* Reset CN0 of channel 1 on force update event. */
      vuint32_t RSTCN0_CH0:2;          /* Reset CN0 of channel 0 on force update event. */
      vuint32_t FUPD_CTRL7:2;          /* Force update of TOM channel 7 operation registers. */
      vuint32_t FUPD_CTRL6:2;          /* Force update of TOM channel 6 operation registers, */
      vuint32_t FUPD_CTRL5:2;          /* Force update of TOM channel 5 operation registers. */
      vuint32_t FUPD_CTRL4:2;          /* Force update of TOM channel 4 operation registers. */
      vuint32_t FUPD_CTRL3:2;          /* Force update of TOM channel 3 operation registers. */
      vuint32_t FUPD_CTRL2:2;          /* ce update of TOM channel 2 operation registers. */
      vuint32_t FUPD_CTRL1:2;          /* Force update of TOM channel 1 operation registers. */
      vuint32_t FUPD_CTRL0:2;          /* Force update of TOM channel 0 operation registers. */
    } B;
  } AGC_FUPD_CTRL;

  union {                              /* ATOM TGC0 Interrupt Trigger Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t INT_TRIG7:2;           /* Select input signal TRIG_7 as a trigger source. */
      vuint32_t INT_TRIG6:2;           /* Select input signal TRIG_6 as a trigger source. */
      vuint32_t INT_TRIG5:2;           /* Select input signal TRIG_5 as a trigger source. */
      vuint32_t INT_TRIG4:2;           /* Select input signal TRIG_4 as a trigger source. */
      vuint32_t INT_TRIG3:2;           /* Select input signal TRIG_3 as a trigger source. */
      vuint32_t INT_TRIG2:2;           /* Select input signal TRIG_2 as a trigger source. */
      vuint32_t INT_TRIG1:2;           /* Select input signal TRIG_1 as a trigger source. */
      vuint32_t INT_TRIG0:2;           /* Select input signal TRIG_0 as a trigger source. */
    } B;
  } AGC_INT_TRIG;

  uint8_t ATOM_reserved1[32];
  union {                              /* ATOM Channel n Read Address Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t RDADDR1:9;             /* ARU Read address 1. */
      vuint32_t  :7;
      vuint32_t RDADDR0:9;             /* ARU Read address 0. */
    } B;
  } CH1_RDADDR;

  union {                              /* ATOM Channel n Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t ABM:1;                 /* ARU blocking mode. */
      vuint32_t OSM:1;                 /* One-shot mode. */
      vuint32_t SLA:1;                 /* Serve last ARU communication strategy */
      vuint32_t TRIGOUT:1;             /* NTrigger output selection (output signal TRIG_CHn) of module ATOM_CHn. */
      vuint32_t  :3;                   /* Reads as zero, should be written as zero. */
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :3;
      vuint32_t WR_REQ:1;              /* CPU Write request bit for late compare register update. */
      vuint32_t  :1;
      vuint32_t CLK_SRC_SR:3;          /* Actual CMU clock source (SOMS) / shadow register for CMU clock source (SOMP). */
      vuint32_t SL:1;                  /* Initial signal level after channel enable. */
      vuint32_t  :1;
      vuint32_t CMP_CTRL:1;            /* CCUn compare strategy select.. */
      vuint32_t ACB:5;                 /* ATOM Mode control bits. */
      vuint32_t ARU_EN:1;              /* ARU Input stream enable. */
      vuint32_t TB12_SEL:1;            /* Select time base value TBU_TS1 or TBU_TS2. */
      vuint32_t MODE:2;                /* ATOM channel mode select. */
    } B;
  } CH1_CTRL;

  union {                              /* ATOM Channel n Shadow 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SR0:24;                /* ATOM channel n shadow register SR0. */
    } B;
  } CH1_SR0;

  union {                              /* ATOM Channel n Shadow 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SR1:24;                /* ATOM channel n shadow register SR1. */
    } B;
  } CH1_SR1;

  union {                              /* ATOM Channel n Compare Match 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CM0:24;                /* ATOM CCU0 compare register. */
    } B;
  } CH1_CM0;

  union {                              /* ATOM Channel n Compare Match 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CM1:24;                /* ATOM CCU1 compare register. */
    } B;
  } CH1_CM1;

  union {                              /* ATOM Channel n Counter 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CN0:24;                /* ATOM CCU0 counter register. */
    } B;
  } CH1_CN0;

  union {                              /* ATOM Channel n Status Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t ACBO:5;                /* ATOM Internal status bits. */
      vuint32_t  :1;
      vuint32_t WRF:1;                 /* Write request of CPU failed for late update. */
      vuint32_t DV:1;                  /* Valid ARU Data stored in compare registers. */
      vuint32_t ACBI:5;                /* ATOM Mode control bits received through ARU. */
      vuint32_t  :15;
      vuint32_t OL:1;                  /* Actual output signal level of ATOM_CHn_OUT. */
    } B;
  } CH1_STAT;

  union {                              /* ATOM Channel n Interrupt Request Notification Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH1_IRQ_NOTIFY;

  union {                              /* ATOM Channel n Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t CCU1TC_IRQ_EN:1;       /* ATOM_CCU1TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* ATOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH1_IRQ_EN;

  union {                              /* ATOM Channel n Force Interrupt Request Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t TRG_CCU1TC:1;          /* Trigger ATOM_CCU1TC_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC:1;          /* Trigger ATOM_CCU0TC_IRQ interrupt by software. */
    } B;
  } CH1_IRQ_FORCINT;

  union {                              /* ATOM Channel n Interrupt Request Mode Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH1_IRQ_MODE;

  uint8_t ATOM_reserved2[80];
  union {                              /* ATOM Channel n Read Address Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t RDADDR1:9;             /* ARU Read address 1. */
      vuint32_t  :7;
      vuint32_t RDADDR0:9;             /* ARU Read address 0. */
    } B;
  } CH2_RDADDR;

  union {                              /* ATOM Channel n Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t ABM:1;                 /* ARU blocking mode. */
      vuint32_t OSM:1;                 /* One-shot mode. */
      vuint32_t SLA:1;                 /* Serve last ARU communication strategy */
      vuint32_t TRIGOUT:1;             /* NTrigger output selection (output signal TRIG_CHn) of module ATOM_CHn. */
      vuint32_t  :3;                   /* Reads as zero, should be written as zero. */
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :3;
      vuint32_t WR_REQ:1;              /* CPU Write request bit for late compare register update. */
      vuint32_t  :1;
      vuint32_t CLK_SRC_SR:3;          /* Actual CMU clock source (SOMS) / shadow register for CMU clock source (SOMP). */
      vuint32_t SL:1;                  /* Initial signal level after channel enable. */
      vuint32_t  :1;
      vuint32_t CMP_CTRL:1;            /* CCUn compare strategy select.. */
      vuint32_t ACB:5;                 /* ATOM Mode control bits. */
      vuint32_t ARU_EN:1;              /* ARU Input stream enable. */
      vuint32_t TB12_SEL:1;            /* Select time base value TBU_TS1 or TBU_TS2. */
      vuint32_t MODE:2;                /* ATOM channel mode select. */
    } B;
  } CH2_CTRL;

  union {                              /* ATOM Channel n Shadow 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SR0:24;                /* ATOM channel n shadow register SR0. */
    } B;
  } CH2_SR0;

  union {                              /* ATOM Channel n Shadow 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SR1:24;                /* ATOM channel n shadow register SR1. */
    } B;
  } CH2_SR1;

  union {                              /* ATOM Channel n Compare Match 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CM0:24;                /* ATOM CCU0 compare register. */
    } B;
  } CH2_CM0;

  union {                              /* ATOM Channel n Compare Match 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CM1:24;                /* ATOM CCU1 compare register. */
    } B;
  } CH2_CM1;

  union {                              /* ATOM Channel n Counter 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CN0:24;                /* ATOM CCU0 counter register. */
    } B;
  } CH2_CN0;

  union {                              /* ATOM Channel n Status Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t ACBO:5;                /* ATOM Internal status bits. */
      vuint32_t  :1;
      vuint32_t WRF:1;                 /* Write request of CPU failed for late update. */
      vuint32_t DV:1;                  /* Valid ARU Data stored in compare registers. */
      vuint32_t ACBI:5;                /* ATOM Mode control bits received through ARU. */
      vuint32_t  :15;
      vuint32_t OL:1;                  /* Actual output signal level of ATOM_CHn_OUT. */
    } B;
  } CH2_STAT;

  union {                              /* ATOM Channel n Interrupt Request Notification Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH2_IRQ_NOTIFY;

  union {                              /* ATOM Channel n Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t CCU1TC_IRQ_EN:1;       /* ATOM_CCU1TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* ATOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH2_IRQ_EN;

  union {                              /* ATOM Channel n Force Interrupt Request Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t TRG_CCU1TC:1;          /* Trigger ATOM_CCU1TC_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC:1;          /* Trigger ATOM_CCU0TC_IRQ interrupt by software. */
    } B;
  } CH2_IRQ_FORCINT;

  union {                              /* ATOM Channel n Interrupt Request Mode Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH2_IRQ_MODE;

  uint8_t ATOM_reserved3[80];
  union {                              /* ATOM Channel n Read Address Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t RDADDR1:9;             /* ARU Read address 1. */
      vuint32_t  :7;
      vuint32_t RDADDR0:9;             /* ARU Read address 0. */
    } B;
  } CH3_RDADDR;

  union {                              /* ATOM Channel n Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t ABM:1;                 /* ARU blocking mode. */
      vuint32_t OSM:1;                 /* One-shot mode. */
      vuint32_t SLA:1;                 /* Serve last ARU communication strategy */
      vuint32_t TRIGOUT:1;             /* NTrigger output selection (output signal TRIG_CHn) of module ATOM_CHn. */
      vuint32_t  :3;                   /* Reads as zero, should be written as zero. */
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :3;
      vuint32_t WR_REQ:1;              /* CPU Write request bit for late compare register update. */
      vuint32_t  :1;
      vuint32_t CLK_SRC_SR:3;          /* Actual CMU clock source (SOMS) / shadow register for CMU clock source (SOMP). */
      vuint32_t SL:1;                  /* Initial signal level after channel enable. */
      vuint32_t  :1;
      vuint32_t CMP_CTRL:1;            /* CCUn compare strategy select.. */
      vuint32_t ACB:5;                 /* ATOM Mode control bits. */
      vuint32_t ARU_EN:1;              /* ARU Input stream enable. */
      vuint32_t TB12_SEL:1;            /* Select time base value TBU_TS1 or TBU_TS2. */
      vuint32_t MODE:2;                /* ATOM channel mode select. */
    } B;
  } CH3_CTRL;

  union {                              /* ATOM Channel n Shadow 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SR0:24;                /* ATOM channel n shadow register SR0. */
    } B;
  } CH3_SR0;

  union {                              /* ATOM Channel n Shadow 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SR1:24;                /* ATOM channel n shadow register SR1. */
    } B;
  } CH3_SR1;

  union {                              /* ATOM Channel n Compare Match 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CM0:24;                /* ATOM CCU0 compare register. */
    } B;
  } CH3_CM0;

  union {                              /* ATOM Channel n Compare Match 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CM1:24;                /* ATOM CCU1 compare register. */
    } B;
  } CH3_CM1;

  union {                              /* ATOM Channel n Counter 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CN0:24;                /* ATOM CCU0 counter register. */
    } B;
  } CH3_CN0;

  union {                              /* ATOM Channel n Status Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t ACBO:5;                /* ATOM Internal status bits. */
      vuint32_t  :1;
      vuint32_t WRF:1;                 /* Write request of CPU failed for late update. */
      vuint32_t DV:1;                  /* Valid ARU Data stored in compare registers. */
      vuint32_t ACBI:5;                /* ATOM Mode control bits received through ARU. */
      vuint32_t  :15;
      vuint32_t OL:1;                  /* Actual output signal level of ATOM_CHn_OUT. */
    } B;
  } CH3_STAT;

  union {                              /* ATOM Channel n Interrupt Request Notification Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH3_IRQ_NOTIFY;

  union {                              /* ATOM Channel n Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t CCU1TC_IRQ_EN:1;       /* ATOM_CCU1TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* ATOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH3_IRQ_EN;

  union {                              /* ATOM Channel n Force Interrupt Request Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t TRG_CCU1TC:1;          /* Trigger ATOM_CCU1TC_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC:1;          /* Trigger ATOM_CCU0TC_IRQ interrupt by software. */
    } B;
  } CH3_IRQ_FORCINT;

  union {                              /* ATOM Channel n Interrupt Request Mode Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH3_IRQ_MODE;

  uint8_t ATOM_reserved4[80];
  union {                              /* ATOM Channel n Read Address Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t RDADDR1:9;             /* ARU Read address 1. */
      vuint32_t  :7;
      vuint32_t RDADDR0:9;             /* ARU Read address 0. */
    } B;
  } CH4_RDADDR;

  union {                              /* ATOM Channel n Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t ABM:1;                 /* ARU blocking mode. */
      vuint32_t OSM:1;                 /* One-shot mode. */
      vuint32_t SLA:1;                 /* Serve last ARU communication strategy */
      vuint32_t TRIGOUT:1;             /* NTrigger output selection (output signal TRIG_CHn) of module ATOM_CHn. */
      vuint32_t  :3;                   /* Reads as zero, should be written as zero. */
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :3;
      vuint32_t WR_REQ:1;              /* CPU Write request bit for late compare register update. */
      vuint32_t  :1;
      vuint32_t CLK_SRC_SR:3;          /* Actual CMU clock source (SOMS) / shadow register for CMU clock source (SOMP). */
      vuint32_t SL:1;                  /* Initial signal level after channel enable. */
      vuint32_t  :1;
      vuint32_t CMP_CTRL:1;            /* CCUn compare strategy select.. */
      vuint32_t ACB:5;                 /* ATOM Mode control bits. */
      vuint32_t ARU_EN:1;              /* ARU Input stream enable. */
      vuint32_t TB12_SEL:1;            /* Select time base value TBU_TS1 or TBU_TS2. */
      vuint32_t MODE:2;                /* ATOM channel mode select. */
    } B;
  } CH4_CTRL;

  union {                              /* ATOM Channel n Shadow 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SR0:24;                /* ATOM channel n shadow register SR0. */
    } B;
  } CH4_SR0;

  union {                              /* ATOM Channel n Shadow 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SR1:24;                /* ATOM channel n shadow register SR1. */
    } B;
  } CH4_SR1;

  union {                              /* ATOM Channel n Compare Match 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CM0:24;                /* ATOM CCU0 compare register. */
    } B;
  } CH4_CM0;

  union {                              /* ATOM Channel n Compare Match 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CM1:24;                /* ATOM CCU1 compare register. */
    } B;
  } CH4_CM1;

  union {                              /* ATOM Channel n Counter 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CN0:24;                /* ATOM CCU0 counter register. */
    } B;
  } CH4_CN0;

  union {                              /* ATOM Channel n Status Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t ACBO:5;                /* ATOM Internal status bits. */
      vuint32_t  :1;
      vuint32_t WRF:1;                 /* Write request of CPU failed for late update. */
      vuint32_t DV:1;                  /* Valid ARU Data stored in compare registers. */
      vuint32_t ACBI:5;                /* ATOM Mode control bits received through ARU. */
      vuint32_t  :15;
      vuint32_t OL:1;                  /* Actual output signal level of ATOM_CHn_OUT. */
    } B;
  } CH4_STAT;

  union {                              /* ATOM Channel n Interrupt Request Notification Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH4_IRQ_NOTIFY;

  union {                              /* ATOM Channel n Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t CCU1TC_IRQ_EN:1;       /* ATOM_CCU1TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* ATOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH4_IRQ_EN;

  union {                              /* ATOM Channel n Force Interrupt Request Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t TRG_CCU1TC:1;          /* Trigger ATOM_CCU1TC_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC:1;          /* Trigger ATOM_CCU0TC_IRQ interrupt by software. */
    } B;
  } CH4_IRQ_FORCINT;

  union {                              /* ATOM Channel n Interrupt Request Mode Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH4_IRQ_MODE;

  uint8_t ATOM_reserved5[80];
  union {                              /* ATOM Channel n Read Address Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t RDADDR1:9;             /* ARU Read address 1. */
      vuint32_t  :7;
      vuint32_t RDADDR0:9;             /* ARU Read address 0. */
    } B;
  } CH5_RDADDR;

  union {                              /* ATOM Channel n Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t ABM:1;                 /* ARU blocking mode. */
      vuint32_t OSM:1;                 /* One-shot mode. */
      vuint32_t SLA:1;                 /* Serve last ARU communication strategy */
      vuint32_t TRIGOUT:1;             /* NTrigger output selection (output signal TRIG_CHn) of module ATOM_CHn. */
      vuint32_t  :3;                   /* Reads as zero, should be written as zero. */
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :3;
      vuint32_t WR_REQ:1;              /* CPU Write request bit for late compare register update. */
      vuint32_t  :1;
      vuint32_t CLK_SRC_SR:3;          /* Actual CMU clock source (SOMS) / shadow register for CMU clock source (SOMP). */
      vuint32_t SL:1;                  /* Initial signal level after channel enable. */
      vuint32_t  :1;
      vuint32_t CMP_CTRL:1;            /* CCUn compare strategy select.. */
      vuint32_t ACB:5;                 /* ATOM Mode control bits. */
      vuint32_t ARU_EN:1;              /* ARU Input stream enable. */
      vuint32_t TB12_SEL:1;            /* Select time base value TBU_TS1 or TBU_TS2. */
      vuint32_t MODE:2;                /* ATOM channel mode select. */
    } B;
  } CH5_CTRL;

  union {                              /* ATOM Channel n Shadow 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SR0:24;                /* ATOM channel n shadow register SR0. */
    } B;
  } CH5_SR0;

  union {                              /* ATOM Channel n Shadow 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SR1:24;                /* ATOM channel n shadow register SR1. */
    } B;
  } CH5_SR1;

  union {                              /* ATOM Channel n Compare Match 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CM0:24;                /* ATOM CCU0 compare register. */
    } B;
  } CH5_CM0;

  union {                              /* ATOM Channel n Compare Match 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CM1:24;                /* ATOM CCU1 compare register. */
    } B;
  } CH5_CM1;

  union {                              /* ATOM Channel n Counter 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CN0:24;                /* ATOM CCU0 counter register. */
    } B;
  } CH5_CN0;

  union {                              /* ATOM Channel n Status Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t ACBO:5;                /* ATOM Internal status bits. */
      vuint32_t  :1;
      vuint32_t WRF:1;                 /* Write request of CPU failed for late update. */
      vuint32_t DV:1;                  /* Valid ARU Data stored in compare registers. */
      vuint32_t ACBI:5;                /* ATOM Mode control bits received through ARU. */
      vuint32_t  :15;
      vuint32_t OL:1;                  /* Actual output signal level of ATOM_CHn_OUT. */
    } B;
  } CH5_STAT;

  union {                              /* ATOM Channel n Interrupt Request Notification Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH5_IRQ_NOTIFY;

  union {                              /* ATOM Channel n Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t CCU1TC_IRQ_EN:1;       /* ATOM_CCU1TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* ATOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH5_IRQ_EN;

  union {                              /* ATOM Channel n Force Interrupt Request Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t TRG_CCU1TC:1;          /* Trigger ATOM_CCU1TC_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC:1;          /* Trigger ATOM_CCU0TC_IRQ interrupt by software. */
    } B;
  } CH5_IRQ_FORCINT;

  union {                              /* ATOM Channel n Interrupt Request Mode Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH5_IRQ_MODE;

  uint8_t ATOM_reserved6[80];
  union {                              /* ATOM Channel n Read Address Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t RDADDR1:9;             /* ARU Read address 1. */
      vuint32_t  :7;
      vuint32_t RDADDR0:9;             /* ARU Read address 0. */
    } B;
  } CH6_RDADDR;

  union {                              /* ATOM Channel n Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t ABM:1;                 /* ARU blocking mode. */
      vuint32_t OSM:1;                 /* One-shot mode. */
      vuint32_t SLA:1;                 /* Serve last ARU communication strategy */
      vuint32_t TRIGOUT:1;             /* NTrigger output selection (output signal TRIG_CHn) of module ATOM_CHn. */
      vuint32_t  :3;                   /* Reads as zero, should be written as zero. */
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :3;
      vuint32_t WR_REQ:1;              /* CPU Write request bit for late compare register update. */
      vuint32_t  :1;
      vuint32_t CLK_SRC_SR:3;          /* Actual CMU clock source (SOMS) / shadow register for CMU clock source (SOMP). */
      vuint32_t SL:1;                  /* Initial signal level after channel enable. */
      vuint32_t  :1;
      vuint32_t CMP_CTRL:1;            /* CCUn compare strategy select.. */
      vuint32_t ACB:5;                 /* ATOM Mode control bits. */
      vuint32_t ARU_EN:1;              /* ARU Input stream enable. */
      vuint32_t TB12_SEL:1;            /* Select time base value TBU_TS1 or TBU_TS2. */
      vuint32_t MODE:2;                /* ATOM channel mode select. */
    } B;
  } CH6_CTRL;

  union {                              /* ATOM Channel n Shadow 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SR0:24;                /* ATOM channel n shadow register SR0. */
    } B;
  } CH6_SR0;

  union {                              /* ATOM Channel n Shadow 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SR1:24;                /* ATOM channel n shadow register SR1. */
    } B;
  } CH6_SR1;

  union {                              /* ATOM Channel n Compare Match 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CM0:24;                /* ATOM CCU0 compare register. */
    } B;
  } CH6_CM0;

  union {                              /* ATOM Channel n Compare Match 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CM1:24;                /* ATOM CCU1 compare register. */
    } B;
  } CH6_CM1;

  union {                              /* ATOM Channel n Counter 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CN0:24;                /* ATOM CCU0 counter register. */
    } B;
  } CH6_CN0;

  union {                              /* ATOM Channel n Status Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t ACBO:5;                /* ATOM Internal status bits. */
      vuint32_t  :1;
      vuint32_t WRF:1;                 /* Write request of CPU failed for late update. */
      vuint32_t DV:1;                  /* Valid ARU Data stored in compare registers. */
      vuint32_t ACBI:5;                /* ATOM Mode control bits received through ARU. */
      vuint32_t  :15;
      vuint32_t OL:1;                  /* Actual output signal level of ATOM_CHn_OUT. */
    } B;
  } CH6_STAT;

  union {                              /* ATOM Channel n Interrupt Request Notification Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH6_IRQ_NOTIFY;

  union {                              /* ATOM Channel n Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t CCU1TC_IRQ_EN:1;       /* ATOM_CCU1TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* ATOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH6_IRQ_EN;

  union {                              /* ATOM Channel n Force Interrupt Request Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t TRG_CCU1TC:1;          /* Trigger ATOM_CCU1TC_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC:1;          /* Trigger ATOM_CCU0TC_IRQ interrupt by software. */
    } B;
  } CH6_IRQ_FORCINT;

  union {                              /* ATOM Channel n Interrupt Request Mode Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH6_IRQ_MODE;

  uint8_t ATOM_reserved7[80];
  union {                              /* ATOM Channel n Read Address Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t RDADDR1:9;             /* ARU Read address 1. */
      vuint32_t  :7;
      vuint32_t RDADDR0:9;             /* ARU Read address 0. */
    } B;
  } CH7_RDADDR;

  union {                              /* ATOM Channel n Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t ABM:1;                 /* ARU blocking mode. */
      vuint32_t OSM:1;                 /* One-shot mode. */
      vuint32_t SLA:1;                 /* Serve last ARU communication strategy */
      vuint32_t TRIGOUT:1;             /* NTrigger output selection (output signal TRIG_CHn) of module ATOM_CHn. */
      vuint32_t  :3;                   /* Reads as zero, should be written as zero. */
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :3;
      vuint32_t WR_REQ:1;              /* CPU Write request bit for late compare register update. */
      vuint32_t  :1;
      vuint32_t CLK_SRC_SR:3;          /* Actual CMU clock source (SOMS) / shadow register for CMU clock source (SOMP). */
      vuint32_t SL:1;                  /* Initial signal level after channel enable. */
      vuint32_t  :1;
      vuint32_t CMP_CTRL:1;            /* CCUn compare strategy select.. */
      vuint32_t ACB:5;                 /* ATOM Mode control bits. */
      vuint32_t ARU_EN:1;              /* ARU Input stream enable. */
      vuint32_t TB12_SEL:1;            /* Select time base value TBU_TS1 or TBU_TS2. */
      vuint32_t MODE:2;                /* ATOM channel mode select. */
    } B;
  } CH7_CTRL;

  union {                              /* ATOM Channel n Shadow 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SR0:24;                /* ATOM channel n shadow register SR0. */
    } B;
  } CH7_SR0;

  union {                              /* ATOM Channel n Shadow 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SR1:24;                /* ATOM channel n shadow register SR1. */
    } B;
  } CH7_SR1;

  union {                              /* ATOM Channel n Compare Match 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CM0:24;                /* ATOM CCU0 compare register. */
    } B;
  } CH7_CM0;

  union {                              /* ATOM Channel n Compare Match 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CM1:24;                /* ATOM CCU1 compare register. */
    } B;
  } CH7_CM1;

  union {                              /* ATOM Channel n Counter 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CN0:24;                /* ATOM CCU0 counter register. */
    } B;
  } CH7_CN0;

  union {                              /* ATOM Channel n Status Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t ACBO:5;                /* ATOM Internal status bits. */
      vuint32_t  :1;
      vuint32_t WRF:1;                 /* Write request of CPU failed for late update. */
      vuint32_t DV:1;                  /* Valid ARU Data stored in compare registers. */
      vuint32_t ACBI:5;                /* ATOM Mode control bits received through ARU. */
      vuint32_t  :15;
      vuint32_t OL:1;                  /* Actual output signal level of ATOM_CHn_OUT. */
    } B;
  } CH7_STAT;

  union {                              /* ATOM Channel n Interrupt Request Notification Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH7_IRQ_NOTIFY;

  union {                              /* ATOM Channel n Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t CCU1TC_IRQ_EN:1;       /* ATOM_CCU1TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* ATOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH7_IRQ_EN;

  union {                              /* ATOM Channel n Force Interrupt Request Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t TRG_CCU1TC:1;          /* Trigger ATOM_CCU1TC_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC:1;          /* Trigger ATOM_CCU0TC_IRQ interrupt by software. */
    } B;
  } CH7_IRQ_FORCINT;

  union {                              /* ATOM Channel n Interrupt Request Mode Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH7_IRQ_MODE;
};


/* ============================================================================
   =============================== Module: GTM_BRC ============================
   ============================================================================ */

struct GTM_BRC_tag {
  struct {
    union {                            /* BRC Source n Address Register, n[0:11] */
      vuint32_t R;
      struct {
        vuint32_t  :19;
        vuint32_t BRC_MODE:1;          /* BRC Operation mode select. */
        vuint32_t  :3;
        vuint32_t ADDR:9;              /* Source ARU address. */
      } B;
    } ADDR;
    union {                            /* BRC Source n to Destination Register, n[0:11] */
      vuint32_t R;
      struct {
        vuint32_t  :9;
        vuint32_t EN_TRASHBIN:1;       /* Control trash bin functionality. */
        vuint32_t EN_DEST21:1;         /* See EN_DEST0. */
        vuint32_t EN_DEST20:1;         /* See EN_DEST0. */
        vuint32_t EN_DEST19:1;         /* See EN_DEST0. */
        vuint32_t EN_DEST18:1;         /* See EN_DEST0. */
        vuint32_t EN_DEST17:1;         /* See EN_DEST0. */
        vuint32_t EN_DEST16:1;         /* See EN_DEST0. */
        vuint32_t EN_DEST15:1;         /* See EN_DEST0. */
        vuint32_t EN_DEST14:1;         /* See EN_DEST0. */
        vuint32_t EN_DEST13:1;         /* See EN_DEST0. */
        vuint32_t EN_DEST12:1;         /* See EN_DEST0. */
        vuint32_t EN_DEST11:1;         /* See EN_DEST0. */
        vuint32_t EN_DEST10:1;         /* See EN_DEST0. */
        vuint32_t EN_DEST9:1;          /* See EN_DEST0. */
        vuint32_t EN_DEST8:1;          /* See EN_DEST0. */
        vuint32_t EN_DEST7:1;          /* See EN_DEST0. */
        vuint32_t EN_DEST6:1;          /* See EN_DEST0. */
        vuint32_t EN_DEST5:1;          /* See EN_DEST0. */
        vuint32_t EN_DEST4:1;          /* See EN_DEST0. */
        vuint32_t EN_DEST3:1;          /* See EN_DEST0. */
        vuint32_t EN_DEST2:1;          /* See EN_DEST0. */
        vuint32_t EN_DEST1:1;          /* See EN_DEST0. */
        vuint32_t EN_DEST0:1;          /* Enable BRC destination address. */
      } B;
    } DEST;
  } SRC[12];

  union {                              /* BRC Interrupt Request Notification Register */
    vuint32_t R;
    struct {
      vuint32_t  :19;
      vuint32_t DID0:1;                /* Data inconsistency occurred in MTM mode. */
      vuint32_t DID1:1;                /* Data inconsistency occurred in MTM mode. */
      vuint32_t DID2:1;                /* Data inconsistency occurred in MTM mode. */
      vuint32_t DID3:1;                /* Data inconsistency occurred in MTM mode. */
      vuint32_t DID4:1;                /* Data inconsistency occurred in MTM mode. */
      vuint32_t DID5:1;                /* Data inconsistency occurred in MTM mode. */
      vuint32_t DID6:1;                /* Data inconsistency occurred in MTM mode. */
      vuint32_t DID7:1;                /* Data inconsistency occurred in MTM mode. */
      vuint32_t DID8:1;                /* Data inconsistency occurred in MTM mode. */
      vuint32_t DID9:1;                /* Data inconsistency occurred in MTM mode. */
      vuint32_t DID10:1;               /* Data inconsistency occurred in MTM mode. */
      vuint32_t DID11:1;               /* Data inconsistency occurred in MTM mode. */
      vuint32_t DEST_ERR:1;            /* Configuration error interrupt for BRC submodule. */
    } B;
  } IRQ_NOTIFY;

  union {                              /* BRC Interrupt Request Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :19;
      vuint32_t DID_IRQ_EN0:1;         /* BRC_DID_IRQ interrupt enable. */
      vuint32_t DID_IRQ_EN1:1;         /* BRC_DID_IRQ interrupt enable. */
      vuint32_t DID_IRQ_EN2:1;         /* BRC_DID_IRQ interrupt enable. */
      vuint32_t DID_IRQ_EN3:1;         /* BRC_DID_IRQ interrupt enable. */
      vuint32_t DID_IRQ_EN4:1;         /* BRC_DID_IRQ interrupt enable. */
      vuint32_t DID_IRQ_EN5:1;         /* BRC_DID_IRQ interrupt enable. */
      vuint32_t DID_IRQ_EN6:1;         /* BRC_DID_IRQ interrupt enable. */
      vuint32_t DID_IRQ_EN7:1;         /* BRC_DID_IRQ interrupt enable. */
      vuint32_t DID_IRQ_EN8:1;         /* BRC_DID_IRQ interrupt enable. */
      vuint32_t DID_IRQ_EN9:1;         /* BRC_DID_IRQ interrupt enable. */
      vuint32_t DID_IRQ_EN10:1;        /* BRC_DID_IRQ interrupt enable. */
      vuint32_t DID_IRQ_EN11:1;        /* BRC_DID_IRQ interrupt enable. */
      vuint32_t DEST_ERR_EN:1;         /* BRC_DEST_ERR_IRQ interrupt enable. */
    } B;
  } IRQ_EN;

  union {                              /* BRC Force Interrupt Request Register */
    vuint32_t R;
    struct {
      vuint32_t  :19;
      vuint32_t TRG_DID0:1;            /* Trigger data inconsistency error interrupt. */
      vuint32_t TRG_DID1:1;            /* Trigger data inconsistency error interrupt. */
      vuint32_t TRG_DID2:1;            /* Trigger data inconsistency error interrupt. */
      vuint32_t TRG_DID3:1;            /* Trigger data inconsistency error interrupt. */
      vuint32_t TRG_DID4:1;            /* Trigger data inconsistency error interrupt. */
      vuint32_t TRG_DID5:1;            /* Trigger data inconsistency error interrupt. */
      vuint32_t TRG_DID6:1;            /* Trigger data inconsistency error interrupt. */
      vuint32_t TRG_DID7:1;            /* Trigger data inconsistency error interrupt. */
      vuint32_t TRG_DID8:1;            /* Trigger data inconsistency error interrupt. */
      vuint32_t TRG_DID9:1;            /* Trigger data inconsistency error interrupt. */
      vuint32_t TRG_DID10:1;           /* Trigger data inconsistency error interrupt. */
      vuint32_t TRG_DID11:1;           /* Trigger data inconsistency error interrupt. */
      vuint32_t TRG_DEST_ERR:1;        /* Trigger destination error interrupt. */
    } B;
  } IRQ_FORCINT;

  union {                              /* BRC Interrupt Request Mode Register */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode select */
    } B;
  } IRQ_MODE;

  union {                              /* BRC Software Reset Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t RST:1;                 /* Software reset. */
    } B;
  } RST;

  union {                              /* BRC Error Interrupt Request Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :19;
      vuint32_t DID_EIRQ_EN0:1;        /* BRC_DID_EIRQ error interrupt enable. */
      vuint32_t DID_EIRQ_EN1:1;        /* BRC_DID_EIRQ error interrupt enable. */
      vuint32_t DID_EIRQ_EN2:1;        /* BRC_DID_EIRQ error interrupt enable. */
      vuint32_t DID_EIRQ_EN3:1;        /* BRC_DID_EIRQ error interrupt enable. */
      vuint32_t DID_EIRQ_EN4:1;        /* BRC_DID_EIRQ error interrupt enable. */
      vuint32_t DID_EIRQ_EN5:1;        /* BRC_DID_EIRQ error interrupt enable. */
      vuint32_t DID_EIRQ_EN6:1;        /* BRC_DID_EIRQ error interrupt enable. */
      vuint32_t DID_EIRQ_EN7:1;        /* BRC_DID_EIRQ error interrupt enable. */
      vuint32_t DID_EIRQ_EN8:1;        /* BRC_DID_EIRQ error interrupt enable. */
      vuint32_t DID_EIRQ_EN9:1;        /* BRC_DID_EIRQ error interrupt enable. */
      vuint32_t DID_EIRQ_EN10:1;       /* BRC_DID_EIRQ error interrupt enable. */
      vuint32_t DID_EIRQ_EN11:1;       /* BRC_DID_EIRQ error interrupt enable. */
      vuint32_t DEST_ERR_EIRQ_EN:1;    /* BRC_DEST_ERR_EIRQ error interrupt enable. */
    } B;
  } EIRQ_EN;
};


/* ============================================================================
   =============================== Module: GTM_CMP ============================
   ============================================================================ */

struct GTM_CMP_tag {
  union {                              /* Compare Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t TBWC11_EN:1;           /* See TBWC0_EN. */
      vuint32_t TBWC10_EN:1;           /* See TBWC0_EN. */
      vuint32_t TBWC9_EN:1;            /* See TBWC0_EN. */
      vuint32_t TBWC8_EN:1;            /* See TBWC0_EN. */
      vuint32_t TBWC7_EN:1;            /* See TBWC0_EN. */
      vuint32_t TBWC6_EN:1;            /* See TBWC0_EN. */
      vuint32_t TBWC5_EN:1;            /* See TBWC0_EN. */
      vuint32_t TBWC4_EN:1;            /* See TBWC0_EN. */
      vuint32_t TBWC3_EN:1;            /* See TBWC0_EN. */
      vuint32_t TBWC2_EN:1;            /* See TBWC0_EN. */
      vuint32_t TBWC1_EN:1;            /* See TBWC0_EN. */
      vuint32_t TBWC0_EN:1;            /* Enable corresponding comparator in TBWC. */
      vuint32_t ABWC11_EN:1;           /* See ABWC0_EN. */
      vuint32_t ABWC10_EN:1;           /* See ABWC0_EN. */
      vuint32_t ABWC9_EN:1;            /* See ABWC0_EN. */
      vuint32_t ABWC8_EN:1;            /* See ABWC0_EN. */
      vuint32_t ABWC7_EN:1;            /* See ABWC0_EN. */
      vuint32_t ABWC6_EN:1;            /* See ABWC0_EN. */
      vuint32_t ABWC5_EN:1;            /* See ABWC0_EN. */
      vuint32_t ABWC4_EN:1;            /* See ABWC0_EN. */
      vuint32_t ABWC3_EN:1;            /* See ABWC0_EN. */
      vuint32_t ABWC2_EN:1;            /* See ABWC0_EN. */
      vuint32_t ABWC1_EN:1;            /* See ABWC0_EN. */
      vuint32_t ABWC0_EN:1;            /* Enable corresponding comparator in ABWC. */
    } B;
  } EN;

  union {                              /* Compare Interrupt Request Notification Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t TBWC11:1;              /* See TBWC0. */
      vuint32_t TBWC10:1;              /* See TBWC0. */
      vuint32_t TBWC9:1;               /* See TBWC0. */
      vuint32_t TBWC8:1;               /* See TBWC0. */
      vuint32_t TBCW7:1;               /* See TBWC0. */
      vuint32_t TBWC6:1;               /* See TBWC0. */
      vuint32_t TBWC5:1;               /* See TBWC0. */
      vuint32_t TBWC4:1;               /* See TBWC0. */
      vuint32_t TBWC3:1;               /* See TBWC0. */
      vuint32_t TBWC2:1;               /* See TBWC0. */
      vuint32_t TBWC1:1;               /* See TBWC0. */
      vuint32_t TBWC0:1;               /* TOM sub modules outputs bitwise comparator 0 error indication. */
      vuint32_t ABWC11:1;              /* See ABWC0. */
      vuint32_t ABWC10:1;              /* See ABWC0. */
      vuint32_t ABWC9:1;               /* See ABWC0. */
      vuint32_t ABWC8:1;               /* See ABWC0. */
      vuint32_t ABWC7:1;               /* See ABWC0. */
      vuint32_t ABWC6:1;               /* See ABWC0. */
      vuint32_t ABWC5:1;               /* See ABWC0. */
      vuint32_t ABWC4:1;               /* See ABWC0. */
      vuint32_t ABWC3:1;               /* See ABWC0. */
      vuint32_t ABWC2:1;               /* See ABWC0. */
      vuint32_t ABWC1:1;               /* See ABWC0. */
      vuint32_t ABWC0:1;               /* ATOM sub modules outputs bitwise comparator error indication. */
    } B;
  } IRQ_NOTIFY;

  union {                              /* Compare Interrupt Request Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t TBWC11_EN_IRQ:1;       /* See TBWC0_EN_IRQ. */
      vuint32_t TBWC10_EN_IRQ:1;       /* See TBWC0_EN_IRQ. */
      vuint32_t TBWC9_EN_IRQ:1;        /* See TBWC0_EN_IRQ. */
      vuint32_t TBWC8_EN_IRQ:1;        /* See TBWC0_EN_IRQ. */
      vuint32_t TBWC7_EN_IRQ:1;        /* See TBWC0_EN_IRQ. */
      vuint32_t TBWC6_EN_IRQ:1;        /* See TBWC0_EN_IRQ. */
      vuint32_t TBWC5_EN_IRQ:1;        /* See TBWC0_EN_IRQ. */
      vuint32_t TBWC4_EN_IRQ:1;        /* See TBWC0_EN_IRQ. */
      vuint32_t TBWC3_EN_IRQ:1;        /* See TBWC0_EN_IRQ. */
      vuint32_t TBWC2_EN_IRQ:1;        /* See TBWC0_EN_IRQ. */
      vuint32_t TBWC1_EN_IRQ:1;        /* See TBWC0_EN_IRQ. */
      vuint32_t TBWC0_EN_IRQ:1;        /* Enable corresponding TBWC interrupt source for CMP_IRQ line. */
      vuint32_t ABWC11_EN_IRQ:1;       /* See ABWC0_EN_IRQ. */
      vuint32_t ABWC10_EN_IRQ:1;       /* See ABWC0_EN_IRQ. */
      vuint32_t ABWC9_EN_IRQ:1;        /* See ABWC0_EN_IRQ. */
      vuint32_t ABWC8_EN_IRQ:1;        /* See ABWC0_EN_IRQ. */
      vuint32_t ABWC7_EN_IRQ:1;        /* See ABWC0_EN_IRQ. */
      vuint32_t ABWC6_EN_IRQ:1;        /* See ABWC0_EN_IRQ. */
      vuint32_t ABWC5_EN_IRQ:1;        /* See ABWC0_EN_IRQ. */
      vuint32_t ABWC4_EN_IRQ:1;        /* See ABWC0_EN_IRQ. */
      vuint32_t ABWC3_EN_IRQ:1;        /* See ABWC0_EN_IRQ. */
      vuint32_t ABWC2_EN_IRQ:1;        /* See ABWC0_EN_IRQ. */
      vuint32_t ABWC1_EN_IRQ:1;        /* See ABWC0_EN_IRQ. */
      vuint32_t ABWC0_EN_IRQ:1;        /* Enable corresponding ABWC interrupt source for CMP_IRQ line. */
    } B;
  } IRQ_EN;

  union {                              /* Compare Force Interrupt Request Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t TRG_TBWC11:1;          /* See TRG_TBWC0. */
      vuint32_t TRG_TBWC10:1;          /* See TRG_TBWC0. */
      vuint32_t TRG_TBWC9:1;           /* See TRG_TBWC0. */
      vuint32_t TRG_TBWC8:1;           /* See TRG_TBWC0. */
      vuint32_t TRG_TBWC7:1;           /* See TRG_TBWC0. */
      vuint32_t TRG_TBWC6:1;           /* See TRG_TBWC0. */
      vuint32_t TRG_TBWC5:1;           /* See TRG_TBWC0. */
      vuint32_t TRG_TBWC4:1;           /* See TRG_TBWC0. */
      vuint32_t TRG_TBWC3:1;           /* See TRG_TBWC0. */
      vuint32_t TRG_TBWC2:1;           /* See TRG_TBWC0. */
      vuint32_t TRG_TBWC1:1;           /* See TRG_TBWC0. */
      vuint32_t TRG_TBWC0:1;           /* Trigger corresponding TBWC bit in CMP_IRQ_NOTIFY register by software. */
      vuint32_t TRG_ABWC11:1;          /* See TRG_ABWC0. */
      vuint32_t TRG_ABWC10:1;          /* See TRG_ABWC0. */
      vuint32_t TRG_ABWC9:1;           /* See TRG_ABWC0. */
      vuint32_t TRG_ABWC8:1;           /* See TRG_ABWC0. */
      vuint32_t TRG_ABWC7:1;           /* See TRG_ABWC0. */
      vuint32_t TRG_ABWC6:1;           /* See TRG_ABWC0. */
      vuint32_t TRG_ABWC5:1;           /* See TRG_ABWC0. */
      vuint32_t TRG_ABWC4:1;           /* See TRG_ABWC0. */
      vuint32_t TRG_ABWC3:1;           /* See TRG_ABWC0. */
      vuint32_t TRG_ABWC2:1;           /* See TRG_ABWC0. */
      vuint32_t TRG_ABWC1:1;           /* See TRG_ABWC0. */
      vuint32_t TRG_ABWC0:1;           /* Trigger corresponding ABWC bit in CMP_IRQ_NOTIFY register by software. */
    } B;
  } IRQ_FORCINT;

  union {                              /* Compare Interrupt Request Mode Register */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } IRQ_MODE;

  union {                              /* Compare Error Interrupt Request Enable register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t TBWC11_EN_EIRQ:1;      /* See TBWC0_EN_EIRQ. */
      vuint32_t TBWC10_EN_EIRQ:1;      /* See TBWC0_EN_EIRQ. */
      vuint32_t TBWC9_EN_EIRQ:1;       /* See TBWC0_EN_EIRQ. */
      vuint32_t TBWC8_EN_EIRQ:1;       /* See TBWC0_EN_EIRQ. */
      vuint32_t TBWC7_EN_EIRQ:1;       /* See TBWC0_EN_EIRQ. */
      vuint32_t TBWC6_EN_EIRQ:1;       /* See TBWC0_EN_EIRQ. */
      vuint32_t TBWC5_EN_EIRQ:1;       /* See TBWC0_EN_EIRQ. */
      vuint32_t TBWC4_EN_EIRQ:1;       /* See TBWC0_EN_EIRQ. */
      vuint32_t TBWC3_EN_EIRQ:1;       /* See TBWC0_EN_EIRQ. */
      vuint32_t TBWC2_EN_EIRQ:1;       /* See TBWC0_EN_EIRQ. */
      vuint32_t TBWC1_EN_EIRQ:1;       /* See TBWC0_EN_EIRQ. */
      vuint32_t TBWC0_EN_EIRQ:1;       /* Enable comparator 0-11 in TBWC. */
      vuint32_t ABWC11_EN_EIRQ:1;      /* ABWC0_EN_EIRQ */
      vuint32_t ABWC10_EN_EIRQ:1;      /* ABWC0_EN_EIRQ */
      vuint32_t ABWC9_EN_EIRQ:1;       /* ABWC0_EN_EIRQ */
      vuint32_t ABWC8_EN_EIRQ:1;       /* ABWC0_EN_EIRQ */
      vuint32_t ABWC7_EN_EIRQ:1;       /* ABWC0_EN_EIRQ */
      vuint32_t ABWC6_EN_EIRQ:1;       /* ABWC0_EN_EIRQ */
      vuint32_t ABWC5_EN_EIRQ:1;       /* ABWC0_EN_EIRQ */
      vuint32_t ABWC4_EN_EIRQ:1;       /* ABWC0_EN_EIRQ */
      vuint32_t ABWC3_EN_EIRQ:1;       /* ABWC0_EN_EIRQ */
      vuint32_t ABWC2_EN_EIRQ:1;       /* ABWC0_EN_EIRQ */
      vuint32_t ABWC1_EN_EIRQ:1;       /* ABWC0_EN_EIRQ */
      vuint32_t ABWC0_EN_EIRQ:1;       /* Enable comparator 0-11 in ABWC. */
    } B;
  } EIRQ_EN;
};


/* ============================================================================
   =============================== Module: GTM_CMU ============================
   ============================================================================ */

struct GTM_CMU_tag {
  union {                              /* CMU Clock Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t EN_FXCLK:2;            /* Enable all CMU_FXCLK. */
      vuint32_t EN_ECLK2:2;            /* Enable ECLK 2 generation subunit. */
      vuint32_t EN_ECLK1:2;            /* Enable ECLK 1 generation subunit */
      vuint32_t EN_ECLK0:2;            /* Enable ECLK 0 generation subunit. */
      vuint32_t EN_CLK7:2;             /* Enable clock source 7. */
      vuint32_t EN_CLK6:2;             /* Enable clock source 6. */
      vuint32_t EN_CLK5:2;             /* Enable clock source 5. */
      vuint32_t EN_CLK4:2;             /* Enable clock source 4. */
      vuint32_t EN_CLK3:2;             /* Enable clock source 3 */
      vuint32_t EN_CLK2:2;             /* Enable clock source 2. */
      vuint32_t EN_CLK1:2;             /* Enable clock source 1 */
      vuint32_t EN_CLK0:2;             /* Enable clock source 0. */
    } B;
  } CLK_EN;

  union {                              /* Global Clock Control Numerator Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t GCLK_NUM:24;           /* Numerator for global clock divider. */
    } B;
  } GCLK_NUM;

  union {                              /* Global Clock Control Denominator Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t GCLK_DEN:24;           /* Denominator for global clock divider. */
    } B;
  } GCLK_DEN;

  union {                              /* Control for Clock Source n register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CLK_CNT:24;            /* Clock count. */
    } B;
  } CLK_CTRL[6];

  union {                              /* Control for Clock Source 6 register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t CLK6_SEL:1;            /* Clock source selection for CMU_CLK6. */
      vuint32_t CLK_CNT:24;            /* Clock count. */
    } B;
  } CLK_6_CTRL;

  union {                              /* Control for Clock Source 7 register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t CLK7_SEL:1;            /* Clock source selection for CMU_CLK7. */
      vuint32_t CLK_CNT:24;            /* Clock count. */
    } B;
  } CLK_7_CTRL;

  struct {
    union {                            /* CMU External Clock n Numerator Register */
      vuint32_t R;
      struct {
        vuint32_t  :8;
        vuint32_t ECLK_NUM:24;         /* Numerator for external clock divider. */
      } B;
    } NUM;
    union {                            /* CMU External Clock n Denominator Register */
      vuint32_t R;
      struct {
        vuint32_t  :8;
        vuint32_t ECLK_DEN:24;         /* Denominator for external clock divider. */
      } B;
    } DEN;
  } ECLK[3];

  union {                              /* CMU FX Clock Control register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t FXCLK_SEL:4;           /* Input clock selection for EN_FXCLK line. */
    } B;
  } FXCLK_CTRL;
};


/* ============================================================================
   =============================== Module: GTM_DPLL ===========================
   ============================================================================ */

struct GTM_DPLL_tag {
  union {                              /* Control Register 0 */
    vuint32_t R;
    struct {
      vuint32_t RMO:1;                 /* Reference mode. */
      vuint32_t TEN:1;                 /* TRIGGER enable. */
      vuint32_t SEN:1;                 /* STATE enable. */
      vuint32_t IDT:1;                 /* Input delay TRIGGER. */
      vuint32_t IDS:1;                 /* Input delay STATE. */
      vuint32_t AMT:1;                 /* Adapt mode TRIGGER */
      vuint32_t AMS:1;                 /* Addapt mode STATE. */
      vuint32_t TNU:9;                 /* TRIGGER number. */
      vuint32_t SNU:5;                 /* STATE number. */
      vuint32_t IFP:1;                 /* Input filter position. */
      vuint32_t MLT:10;                /* Multiplier for TRIGGER. */
    } B;
  } CTRL_0;

  union {                              /* Control Register 1 */
    vuint32_t R;
    struct {
      vuint32_t TSL:2;                 /* TRIGGER slope select. */
      vuint32_t SSL:2;                 /* STATE slope select. */
      vuint32_t SMC:1;                 /* Synchronous Motor Control */
      vuint32_t TS0_HRT:1;             /* Time stamp high resolution TRIGGER */
      vuint32_t TS0_HRS:1;             /* Time stamp high resolution STATE. */
      vuint32_t SYSF:1;                /* SYN_NS for FULL_SCALE. */
      vuint32_t SWR:1;                 /* Software reset */
      vuint32_t LCD:1;                 /* Locking Condition Definition. */
      vuint32_t SYN_NT:6;              /* Synchronization number of TRIGGER. */
      vuint32_t SYN_NS:5;              /* Synchronization number of STATE. */
      vuint32_t PCM2:1;                /* Pulse Correction Mode. */
      vuint32_t DLM2:1;                /* Direct Load Mode. */
      vuint32_t SGE2:1;                /* SUB_INC2 generator enable. */
      vuint32_t PCM1:1;                /* Pulse Correction Mode. */
      vuint32_t DLM1:1;                /* Direct Load Mode. */
      vuint32_t SGE1:1;                /* SUB_INC1 generator enable. */
      vuint32_t PIT:1;                 /* Plausibility. */
      vuint32_t COA:1;                 /* Correction strategy in automatic end mode (DMO=0). */
      vuint32_t IDDS:1;                /* Input Direction Detection Strategy in the case of SMC=0. */
      vuint32_t DEN:1;                 /* DPLL enable. */
      vuint32_t DMO:1;                 /* DPLL mode select. */
    } B;
  } CTRL_1;

  union {                              /* Action Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t WAD7:1;                /* Write control bit of Action_7. */
      vuint32_t WAD6:1;                /* Write control bit of Action_6. */
      vuint32_t WAD5:1;                /* Write control bit of Action_5. */
      vuint32_t WAD4:1;                /* Write control bit of Action_4. */
      vuint32_t WAD3:1;                /* Write control bit of Action_3. */
      vuint32_t WAD2:1;                /* Write control bit of Action_2. */
      vuint32_t WAD1:1;                /* Write control bit of Action_1. */
      vuint32_t WAD0:1;                /* Write control bit of Action_0. */
      vuint32_t AEN7:1;                /* ACTION_7 enable. */
      vuint32_t AEN6:1;                /* ACTION_6 enable. */
      vuint32_t AEN5:1;                /* ACTION_5 enable. */
      vuint32_t AEN4:1;                /* ACTION_4 enable. */
      vuint32_t AEN3:1;                /* ACTION_3 enable. */
      vuint32_t AEN2:1;                /* ACTION_2 enable. */
      vuint32_t AEN1:1;                /* ACTION_1 enable. */
      vuint32_t AEN0:1;                /* ACTION_0 enable. */
      vuint32_t  :8;                   /* Reserved. */
    } B;
  } CTRL_2;

  union {                              /* Action Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t WAD15:1;               /* Write control bit of Action_15. */
      vuint32_t WAD14:1;               /* Write control bit of Action_14. */
      vuint32_t WAD13:1;               /* Write control bit of Action_13. */
      vuint32_t WAD12:1;               /* Write control bit of Action_12. */
      vuint32_t WAD11:1;               /* Write control bit of Action_11. */
      vuint32_t WAD10:1;               /* Write control bit of Action_10. */
      vuint32_t WAD9:1;                /* Write control bit of Action_9. */
      vuint32_t WAD8:1;                /* Write control bit of Action_8. */
      vuint32_t AEN15:1;               /* ACTION_15 enable. */
      vuint32_t AEN14:1;               /* ACTION_14 enable. */
      vuint32_t AEN13:1;               /* ACTION_13 enable. */
      vuint32_t AEN12:1;               /* ACTION_12 enable. */
      vuint32_t AEN11:1;               /* ACTION_11 enable. */
      vuint32_t AEN10:1;               /* ACTION_10 enable. */
      vuint32_t AEN9:1;                /* ACTION_9 enable. */
      vuint32_t AEN8:1;                /* ACTION_8 enable. */
      vuint32_t  :8;
    } B;
  } CTRL_3;

  union {                              /* Action Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t WAD23:1;               /* Write control bit of Action_23. */
      vuint32_t WAD22:1;               /* Write control bit of Action_22. */
      vuint32_t WAD21:1;               /* Write control bit of Action_21. */
      vuint32_t WAD20:1;               /* Write control bit of Action_20. */
      vuint32_t WAD19:1;               /* Write control bit of Action_19. */
      vuint32_t WAD18:1;               /* Write control bit of Action_18. */
      vuint32_t WAD17:1;               /* Write control bit of Action_17. */
      vuint32_t WAD16:1;               /* Write control bit of Action_16. */
      vuint32_t AEN23:1;               /* ACTION_23 enable. */
      vuint32_t AEN22:1;               /* ACTION_22 enable. */
      vuint32_t AEN21:1;               /* ACTION_21 enable. */
      vuint32_t AEN20:1;               /* ACTION_20 enable. */
      vuint32_t AEN19:1;               /* ACTION_19 enable. */
      vuint32_t AEN18:1;               /* ACTION_18 enable. */
      vuint32_t AEN17:1;               /* ACTION_17 enable. */
      vuint32_t AEN16:1;               /* ACTION_16 enable. */
      vuint32_t  :8;
    } B;
  } CTRL_4;

  union {                              /* Action Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t WAD31:1;               /* Write control bit of Action_31. */
      vuint32_t WAD30:1;               /* Write control bit of Action_30. */
      vuint32_t WAD29:1;               /* Write control bit of Action_29. */
      vuint32_t WAD28:1;               /* Write control bit of Action_28. */
      vuint32_t WAD27:1;               /* Write control bit of Action_27. */
      vuint32_t WAD26:1;               /* Write control bit of Action_26. */
      vuint32_t WAD25:1;               /* Write control bit of Action_25. */
      vuint32_t WAD24:1;               /* Write control bit of Action_24. */
      vuint32_t AEN31:1;               /* ACTION_31 enable. */
      vuint32_t AEN30:1;               /* ACTION_30 enable. */
      vuint32_t AEN29:1;               /* ACTION_29 enable. */
      vuint32_t AEN28:1;               /* ACTION_28 enable. */
      vuint32_t AEN27:1;               /* ACTION_27 enable. */
      vuint32_t AEN26:1;               /* ACTION_26 enable. */
      vuint32_t AEN25:1;               /* ACTION_25 enable. */
      vuint32_t AEN24:1;               /* ACTION_24 enable. */
      vuint32_t  :8;
    } B;
  } CTRL_5;

  union {                              /* Action Status Register including Shadow Register */
    vuint32_t R;
    struct {
      vuint32_t ACT_N:32;              /* New output data values concerning to action i provided. */
    } B;
  } ACT_STA;

  union {                              /* Offset and Switch Old/New Address Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t OSS:2;                 /* Offset size of RAM region 2. */
      vuint32_t  :6;
      vuint32_t SWON_T:1;              /* Switch of new TRIGGER. */
      vuint32_t SWON_S:1;              /* Switch of new STATE. */
    } B;
  } OSW;

  union {                              /* Address Offset Register of RAM2 Regions */
    vuint32_t R;
    struct {
      vuint32_t AOSV_2D:8;             /* Address offset value of the RAM 2d region. */
      vuint32_t AOSV_2C:8;             /* Address offset value of the RAM 2c region. */
      vuint32_t AOSV_2B:8;             /* Address offset value of the RAM 2b region. */
      vuint32_t AOSV_2A:8;             /* Address offset value of the RAM 2a region. */
    } B;
  } AOSV_2;

  union {                              /* Actual RAM Pointer Address for Trigger */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t APT_2B:10;             /* Address pointer TRIGGER for RAM region 2b. */
      vuint32_t WAPT_2B:1;             /* Write bit for address pointer APT_2b, read as zero. */
      vuint32_t  :1;
      vuint32_t APT:10;                /* Address pointer TRIGGER. */
      vuint32_t WAPT:1;                /* Write bit for address pointer APT, reads as zero. */
      vuint32_t  :1;
    } B;
  } APT;

  union {                              /* Actual RAM Pointer Address for STATE */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t APS_1C2:6;             /* Address pointer STATE for RAM regoin 1c2. */
      vuint32_t WAPS_1C2:1;            /* Write bit for address pointer APS_1c2, reads as zero. */
      vuint32_t  :5;
      vuint32_t APS:6;                 /* Address pointer STATE. */
      vuint32_t WAPS:1;                /* Write bit for address pointer APS, reads as zero. */
      vuint32_t  :1;
    } B;
  } APS;

  union {                              /* Actual RAM Pointer Address for Region 2C */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t APT_2C:10;             /* Address pointer TRIGGER for RAM region 2c. */
      vuint32_t  :2;
    } B;
  } APT_2C;

  union {                              /* Actual RAM Pointer Address for Region 1C3 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t APS_1C3:6;             /* Address pointer STATE for RAM region 1c3. */
      vuint32_t  :2;
    } B;
  } APS_1C3;

  union {                              /* Number of Recent TRIGGER Events used for Calculations */
    vuint32_t R;
    struct {
      vuint32_t WVTN:1;                /* Write control bit for VTN; reads as zero. */
      vuint32_t WSYN:1;                /* Write control bit for SYN_T and SYN_T_old; reads as zero. */
      vuint32_t WNUT:1;                /* Write control bit for NUTE and FST; reads as zero. */
      vuint32_t  :4;
      vuint32_t VTN:6;                 /* Virtual TRIGGER number. */
      vuint32_t SYN_T_old:3;           /* Number of real and virtual events to be considered for the last increment. */
      vuint32_t SYN_T:3;               /* Number of real and virtual events to be considered for the current increment. */
      vuint32_t  :2;
      vuint32_t FST:1;                 /* FULL_SCALE of TRIGGER. */
      vuint32_t NUTE:10;               /* Number of recent TRIGGER events used for SUB_INC1 and action calculations modulo 2 * (TNU max +1). */
    } B;
  } NUTC;

  union {                              /* Number of Recent STATE Events used for Calculations */
    vuint32_t R;
    struct {
      vuint32_t WVSN:1;                /* Write control bit for VSN; reads as zero. */
      vuint32_t WSYN:1;                /* Write control bit for SYN_S and SYN_S_old; reads as zero. */
      vuint32_t WNUS:1;                /* Write control bit for NUSE; reads as zero. */
      vuint32_t  :4;
      vuint32_t VSN:6;                 /* Virtual STATE number. */
      vuint32_t SYN_S_OLD:6;           /* Number of real and virtual events to be considered for the last increment. */
      vuint32_t SYN_S:6;               /* Number of real and virtual events to be considered for the current increment. */
      vuint32_t FSS:1;                 /* FULL_SCALE of STATE. */
      vuint32_t NUSE:6;                /* Number of recent STATE events used for SUB_INCx calculations modulo 2*(SNU max +1). */
    } B;
  } NUSC;

  union {                              /* Number of Active TRIGGER Events to Interrupt */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t NTI_CNT:10;            /* Number of TRIGGERs to interrupt. */
    } B;
  } NTI_CNT;

  union {                              /* Interrupt Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t DCGI:1;                /* Direction change interrupt. */
      vuint32_t SORI:1;                /* STATE out of range. */
      vuint32_t TORI:1;                /* TRIGGER out of range interrupt. */
      vuint32_t CDSI:1;                /* Calculation of STATE duration done. */
      vuint32_t CDTI:1;                /* Calculation of TRIGGER duration done, only while NTI_CNT is zero. */
      vuint32_t TE4I:1;                /* TRIGGER event interrupt 4. */
      vuint32_t TE3I:1;                /* TRIGGER event interrupt 3. */
      vuint32_t TE2I:1;                /* TRIGGER event interrupt 2. */
      vuint32_t TE1I:1;                /* TRIGGER event interrupt 1. */
      vuint32_t TE0I:1;                /* TRIGGER event interrupt 0. */
      vuint32_t LL2I:1;                /* Loss of lock interrupt for SUB_INC2. */
      vuint32_t GL2I:1;                /* Get of lock interrupt, for SUB_INC2. */
      vuint32_t EI:1;                  /* Error interrupt (see status register bit 31). */
      vuint32_t LL1I:1;                /* Loss of lock interrupt for SUB_INC1. */
      vuint32_t GL1I:1;                /* Get of lock interrupt, for SUB_INC1. */
      vuint32_t W1I:1;                 /* Write access to RAM region 1b or 1c interrupt. */
      vuint32_t W2I:1;                 /* RAM write access to RAM region 2 interrupt. */
      vuint32_t PWI:1;                 /* Plausibility window (PVT) violation interrupt of TRIGGER. */
      vuint32_t TASI:1;                /* TRIGGER active slope interrupt. */
      vuint32_t SASI:1;                /* STATE active slope interrupt. */
      vuint32_t MTI:1;                 /* Missing TRIGGER interrupt. */
      vuint32_t MSI:1;                 /* Missing STATE interrupt. */
      vuint32_t TISI:1;                /* TRIGGER inactive slope interrupt. */
      vuint32_t SISI:1;                /* STATE inactive slope interrupt. */
      vuint32_t TAXI:1;                /* TRIGGER maximum hold time violation interrupt (dt > THMA > 0). */
      vuint32_t TINI:1;
      vuint32_t PEI:1;                 /* DPLL enable interrupt; announces the switch on of the DEN bit. */
      vuint32_t PDI:1;                 /* DPLL disable interrupt; announces the switch off of the DEN bit. */
    } B;
  } IRQ_NOTIFY;

  union {                              /* Interrupt Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t DCGI_IRQ_EN:1;         /* Direction change interrupt. */
      vuint32_t SORI_IRQ_EN:1;         /* STATE out of range. */
      vuint32_t TORI_IRQ_EN:1;         /* TRIGGER out of range interrupt. */
      vuint32_t CDSI_IRQ_EN:1;         /* Enable interrupt when calculation of TRIGGER duration done. */
      vuint32_t CDTI_IRQ_EN:1;         /* Enable interrupt when calculation of TRIGGER duration done. */
      vuint32_t TE4I_IRQ_EN:1;         /* TRIGGER event interrupt 4 enable. */
      vuint32_t TE3I_IRQ_EN:1;         /* TRIGGER event interrupt 3 enable. */
      vuint32_t TE2I_IRQ_EN:1;         /* TRIGGER event interrupt 2 enable. */
      vuint32_t TE1I_IRQ_EN:1;         /* TRIGGER event interrupt 1 enable. */
      vuint32_t TE0I_IRQ_EN:1;         /* TRIGGER event interrupt 0 enable. */
      vuint32_t LL2I_IRQ_EN:1;         /* Loss of lock interrupt enable for SUB_INC2. */
      vuint32_t GL2I_IRQ_EN:1;         /* Get of lock interrupt enable for SUB_INC2. */
      vuint32_t EI_IRQ_EN:1;           /* Error interrupt enable (see status register). */
      vuint32_t LL1I_IRQ_EN:1;         /* Loss of lock interrupt enable. */
      vuint32_t GL1I_IRQ_EN:1;         /* Get of lock interrupt enable, when lock arises. */
      vuint32_t W1I_IRQ_EN:1;          /* Write access to RAM region 1b or 1c interrupt. */
      vuint32_t W2I_IRQ_EN:1;          /* RAM write access to RAM region 2 interrupt enable. */
      vuint32_t PWI_IRQ_EN:1;          /* Plausibility window (PVT) violation interrupt of TRIGGER enable. */
      vuint32_t TASI_IRQ_EN:1;         /* TRIGGER active slope interrupt enable. */
      vuint32_t SASI_IRQ_EN:1;         /* STATE active slope interrupt enable. */
      vuint32_t MTI_IRQ_EN:1;          /* Missing TRIGGER interrupt enable. */
      vuint32_t MSI_IRQ_EN:1;          /* Missing STATE interrupt enable. */
      vuint32_t TISI_IRQ_EN:1;         /* TRIGGER inactive slope interrupt enable bit. */
      vuint32_t SISI_IRQ_EN:1;         /* STATE inactive slope interrupt enable bit. */
      vuint32_t TAXI_IRQ_EN:1;         /* TRIGGER maximum hold time violation interrupt enable bit. */
      vuint32_t TINI_IRQ_EN:1;         /* TRIGGER minimum hold time violation interrupt enable bit. */
      vuint32_t PEI_IRQ_EN:1;          /* DPLL enable interrupt enable, when switch on of the DEN bit. */
      vuint32_t PDI_IRQ_EN:1;          /* DPLL disable interrupt enable, when switch off of the DEN bit. */
    } B;
  } IRQ_EN;

  union {                              /* Force Interrupt Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;                   /* Reserved. */
      vuint32_t TRG_DCGI:1;            /* Force interrupt DCGI. */
      vuint32_t TRG_SORI:1;            /* Force Interrupt SORI. */
      vuint32_t TRG_TORI:1;            /* Force Interrupt TORI. */
      vuint32_t TRG_CDSI:1;            /* Force Interrupt CDSI. */
      vuint32_t TRG_CDTI:1;            /* Force Interrupt CDTI. */
      vuint32_t TRG_TE4I:1;            /* Force Interrupt TE4I. */
      vuint32_t TRG_TE3I:1;            /* Force Interrupt TE3I. */
      vuint32_t TRG_TE2I:1;            /* Force Interrupt TE2I. */
      vuint32_t TRG_TE1I:1;            /* Force Interrupt TE1I. */
      vuint32_t TRG_TE0I:1;            /* Force Interrupt TE0I. */
      vuint32_t TRG_LL2I:1;            /* Force Interrupt LL2I. */
      vuint32_t TRG_GL2I:1;            /* Force Interrupt GL2I. */
      vuint32_t TRG_EI:1;              /* Force Interrupt EI. */
      vuint32_t TRG_LL1I:1;            /* Force Interrupt LL1I. */
      vuint32_t TRG_GL1I:1;            /* Force Interrupt GL1I. */
      vuint32_t TRG_W1I:1;             /* Force Interrupt W1I. */
      vuint32_t TRG_W2I:1;             /* Force Interrupt W2I. */
      vuint32_t TRG_PWI:1;             /* Force Interrupt PWI. */
      vuint32_t TRG_TASI:1;            /* Force Interrupt TASI. */
      vuint32_t TRG_SASI:1;            /* Force Interrupt SASI. */
      vuint32_t TRG_MTI:1;
      vuint32_t TRG_MSI:1;             /* Force Interrupt MSI. */
      vuint32_t TRG_TISI:1;            /* Force Interrupt TISI. */
      vuint32_t TRG_SISI:1;            /* Force Interrupt SISI. */
      vuint32_t TRG_TAXI:1;            /* Force Interrupt TAXI. */
      vuint32_t TRG_TINI:1;            /* Force Interrupt TINI. */
      vuint32_t TRG_PEI:1;             /* Force Interrupt PEI. */
      vuint32_t TRG_PDI:1;             /* Force Interrupt PDI. */
    } B;
  } IRQ_FORCINT;

  union {                              /* Interrupt Request Mode */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } IRQ_MODE;

  union {                              /* Error Interrupt Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t DCGI_EIRQ_EN:1;        /* Direction Change Interrupt. */
      vuint32_t SORI_EIRQ_EN:1;        /* STATE Out of Range Interrupt. */
      vuint32_t TORI_EIRQ_EN:1;        /* TRIGGER Out of Range Interrupt */
      vuint32_t CDSI_EIRQ_EN:1;        /* Enable interrupt when calculation of STATE duration done. */
      vuint32_t CDTI_EIRQ_EN:1;        /* Enable interrupt when calculation of TRIGGER duration done */
      vuint32_t TE4I_EIRQ_EN:1;        /* TRIGGER event interrupt 4 enable. */
      vuint32_t TE3I_EIRQ_EN:1;        /* TRIGGER event interrupt 3 enable. */
      vuint32_t TE2I_EIRQ_EN:1;        /* TRIGGER event interrupt 2 enable. */
      vuint32_t TE1I_EIRQ_EN:1;        /* TRIGGER event interrupt 1 enable. */
      vuint32_t TE0I_EIRQ_EN:1;        /* TRIGGER event interrupt 0 enable. */
      vuint32_t LL2I_EIRQ_EN:1;        /* Loss of lock interrupt enable for SUB_INC2. */
      vuint32_t GL2I_EIRQ_EN:1;        /* Get of lock interrupt enable for SUB_INC2. */
      vuint32_t EI_EIRQ_EN:1;          /* Error interrupt enable (see status register). */
      vuint32_t LL1I_EIRQ_EN:1;        /* Loss of lock interrupt enable. */
      vuint32_t GL1I_EIRQ_EN:1;        /* Get of lock interrupt enable, when lock arises. */
      vuint32_t W1I_EIRQ_EN:1;         /* Write access to RAM region 1b or 1c interrupt. */
      vuint32_t W2I_EIRQ_EN:1;         /* RAM write access to RAM region 2 interrupt enable. */
      vuint32_t PWI_EIRQ_EN:1;         /* Plausibility window (PVT) violation interrupt of TRIGGER enable. */
      vuint32_t TASI_EIRQ_EN:1;        /* TRIGGER active slope interrupt enable. */
      vuint32_t SASI_EIRQ_EN:1;        /* STATE active slope interrupt enable. */
      vuint32_t MTI_EIRQ_EN:1;         /* Missing TRIGGER interrupt enable. */
      vuint32_t MSI_EIRQ_EN:1;         /* Missing STATE interrupt enable. */
      vuint32_t TISI_EIRQ_EN:1;        /* TRIGGER inactive slope interrupt enable bit. */
      vuint32_t SISI_EIRQ_EN:1;        /* STATE inactive slope interrupt enable bit. */
      vuint32_t TAXI_EIRQ_EN:1;        /* TRIGGER maximum hold time violation interrupt enable bit. */
      vuint32_t TINI_EIRQ_EN:1;        /* TRIGGER minimum hold time violation interrupt enable bit. */
      vuint32_t PEI_EIRQ_EN:1;         /* DPLL enable interrupt enable, when switch on of the DEN bit. */
      vuint32_t PDI_EIRQ_EN:1;         /* DPLL disable interrupt enable, when switch off of the DEN bit. */
    } B;
  } EIRQ_EN;

  uint8_t DPLL_reserved0[92];
  union {                              /* Counter Value of Sent SUB_INC1 Pulses */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t INC_CNT1:24;           /* Actual number of pulses to be still sent out at the current increment until the next valid input signal in automatic end mode. */
    } B;
  } INC_CNT1;

  union {                              /* Counter Value of sent SUB_INC2 values (for SMC=1 and RMO=1) */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t INC_CNT2:24;           /* Actual number of pulses to be still sent out at the current increment until the next valid input signal in automatic end mode. */
    } B;
  } INC_CNT2;

  union {                              /* TRIGGER Time Stamp Field Offset at Synchronization Time */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t APT_2B_OLD:10;         /* Address pointer TRIGGER for RAM region 2B at synchronization time. */
      vuint32_t  :7;
      vuint32_t APT_2B_STATUS:1;       /* Address pointer 2B status. */
      vuint32_t APT_2B_EXT:6;          /* Address pointer 2B extension. */
    } B;
  } APT_SYNC;

  union {                              /* STATE Time Stamp Field Offset at Synchronization Time */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t APS_1C2_OLD:6;         /* Address pointer STATE for RAM regoin 1C2 at synchronization time. */
      vuint32_t  :7;
      vuint32_t APS_1C2_STATUS:1;      /* Address pointer 1C2 status. */
      vuint32_t APS_1C2_EXT:6;         /* Address pointer 1C2 extension. */
    } B;
  } APS_SYNC;

  union {                              /* Time Stamp Value for the last valid TRIGGER */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t TBU_TS0_T:24;          /* Value of TBU_TS0 at the last TRIGGER event. */
    } B;
  } TBU_TS0_T;

  union {                              /* Time Stamp Value for the last valid STATE */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t TBU_TS0_S:24;          /* Value of TBU_TS0 at the last STATE event. */
    } B;
  } TBU_TS0_S;

  union {                              /* ADD_IN Value in Direct Load Mode for TRIGGER */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t ADD_IN_LD1:24;         /* Input value for SUB_INC1 generation. */
    } B;
  } ADD_IN_LD1;

  union {                              /* ADD_IN Value in Direct Load Mode for STATE */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t ADD_IN_LD2:24;         /* Input value for SUB_INC2 generation. */
    } B;
  } ADD_IN_LD2;

  uint8_t DPLL_reserved1[44];
  union {                              /* Status Register */
    vuint32_t R;
    struct {
      vuint32_t ERR:1;                 /* Error. */
      vuint32_t LOCK1:1;               /* DPLL Lock status concerning SUB_INC1. */
      vuint32_t FTD:1;                 /* First TRIGGER detected. */
      vuint32_t FSD:1;                 /* First STATE detected. */
      vuint32_t SYT:1;                 /* Synchronization condition of TRIGGER fixed. */
      vuint32_t SYS:1;                 /* Synchronization condition of STATE fixed. */
      vuint32_t LOCK2:1;               /* DPLL Lock status concerning SUB_INC2. */
      vuint32_t  :1;
      vuint32_t BWD1:1;                /* Backwards drive of SUB_INC1. */
      vuint32_t BWD2:1;                /* Backwards drive of SUB_INC2. */
      vuint32_t ITN:1;                 /* Increment number of TRIGGER is not plausible. */
      vuint32_t ISN:1;                 /* Increment number of STATE is not plausible. */
      vuint32_t CAIP1:1;               /* Calculation of actions 0 to 11 in progress (1st part). */
      vuint32_t CAIP2:1;               /* Calculation of actions 12 to 23 in progress (2nd part). */
      vuint32_t CSVT:1;                /* Current signal value TRIGGER. */
      vuint32_t CSVS:1;                /* Current signal value STATE. */
      vuint32_t LOW_RES:1;             /* Low resolution of TBU_TS0. */
      vuint32_t  :2;
      vuint32_t RAM2_ERR:1;            /* DPLL internal access to not configured RAM2 memory space. */
      vuint32_t MT:1;                  /* Missing TRIGGER detected according to TOV. */
      vuint32_t TOR:1;                 /* TRIGGER out of range. */
      vuint32_t MS:1;                  /* Missing STATE detected according to TOV_S. */
      vuint32_t SOR:1;                 /* STATE out of range. */
      vuint32_t PSE:1;                 /* Prediction space configuration error. */
      vuint32_t RCT:1;                 /* Resolution conflict TRIGGER. */
      vuint32_t RCS:1;                 /* Resolution conflict STATE. */
      vuint32_t CRO:1;                 /* Calculated Reciprocal value overflow. */
      vuint32_t CTO:1;                 /* Calculated TRIGGER duration overflow. */
      vuint32_t  :1;
      vuint32_t CSO:1;                 /* Calculated STATE duration overflow. */
      vuint32_t  :1;
    } B;
  } STATUS;

  union {                              /* ID Information for In ut Signal PTR x (Position minus Time Request) */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t ID_PMTR_n:9;           /* ID information to the input signal PMTR_n from the ARU. */
    } B;
  } ID_PMTR[32];

  uint8_t DPLL_reserved2[96];
  union {                              /* Shadow Register of DPLL_CTRL_0 controlled by a valid TRIGGER Slope */
    vuint32_t R;
    struct {
      vuint32_t RMO:1;                 /* Reference mode. */
      vuint32_t  :3;
      vuint32_t IDT:1;                 /* Input delay TRIGGER; */
      vuint32_t  :1;
      vuint32_t AMT:1;                 /* Adapt mode TRIGGER */
      vuint32_t  :14;
      vuint32_t IFP:1;                 /* Input filter position. */
      vuint32_t MLT:10;                /* Multiplier for TRIGGER. */
    } B;
  } CTRL_0_SHADOW_TRIGGER;

  union {                              /* Shadow Register of DPLL_CTRL_0 controlled by a valid STATE Slope */
    vuint32_t R;
    struct {
      vuint32_t RMO:1;                 /* Reference mode. */
      vuint32_t  :3;
      vuint32_t IDS:1;                 /* Input delay STATE. */
      vuint32_t  :1;
      vuint32_t AMS:1;                 /* Addapt mode STATE. */
      vuint32_t  :14;
      vuint32_t IFP:1;                 /* Input filter position. */
      vuint32_t  :10;
    } B;
  } CTRL_0_SHADOW_STATE;

  union {                              /* Shadow Register of DPLL_CTRL_1 controlled by a valid TRIGGER Slope */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t PCM1:1;                /* Pulse Correction Mode. */
      vuint32_t DLM1:1;                /* Direct Load Mode. */
      vuint32_t SGE1:1;                /* SUB_INC1 generator enable. */
      vuint32_t PIT:1;                 /* Plausibility. */
      vuint32_t COA:1;                 /* Correction strategy in automatic end mode (DMO=0). */
      vuint32_t  :2;
      vuint32_t DMO:1;                 /* DPLL mode select.. */
    } B;
  } CTRL_1_SHADOW_TRIGGER;

  union {                              /* Shadow Register of DPLL_CTRL_1 controlled by a valid STATE Slope */
    vuint32_t R;
    struct {
      vuint32_t SYN_NS:21;             /* Synchronization number of STATE. */
      vuint32_t PCM2:1;                /* Pulse Correction Mode for SUB_INC2 generation. */
      vuint32_t DLM2:1;                /* Direct Load Mode for SUB_INC2 generation. */
      vuint32_t SGE2:1;                /* SUB_INC2 generator enable. */
      vuint32_t PCM1:1;                /* Pulse Correction Mode for SUB_INC1 generation. */
      vuint32_t DLM1:1;                /* Direct Load Mode for SUB_INC1 generation. */
      vuint32_t SGE1:1;                /* SUB_INC1 generator enable. */
      vuint32_t PIT:1;                 /* Plausibility value PVT to next valid TRIGGER is time related. */
      vuint32_t COA:1;                 /* Correction strategy in automatic end mode (DMO=0). */
      vuint32_t  :1;
      vuint32_t DEN:1;                 /* DPLL enable. */
      vuint32_t DMO:1;                 /* DPLL mode select. */
    } B;
  } CTRL_1_SHADOW_STATE;

  uint8_t DPLL_reserved3[12];
  union {                              /* Register to control the RAM Initialization */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t INIT_RAM:1;            /* RAM regions 1A, 1B and 2 are to be initialized. */
      vuint32_t  :1;
      vuint32_t INIT_2:1;              /* RAM region 2 initialization in progress. */
      vuint32_t INIT_1B:1;             /* RAM region 1B initialization in progress. */
      vuint32_t INIT_1A:1;             /* RAM region 1A initialization in progress. */
    } B;
  } RAM_INI;

  uint8_t DPLL_reserved4[3072];
  union {                              /* Calculated Time Value to start Action i */
    vuint32_t R;
    struct {
      vuint32_t TSAC:32;               /* Calculated time stamp for ACTION_i. */
    } B;
  } TSAC[32];

  union {                              /* DPLL Calculated Position Value ACTION i */
    vuint32_t R;
    struct {
      vuint32_t PSAC:32;               /* Calculated position value for the start of ACTION_i . */
    } B;
  } PSAC[32];

  union {                              /* Control Bits for up to 32 Actions */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t ACB_3:5;               /* Action Control Bits of ACTION_(i + 3), reflects ACT_D[i+3](52:48), i=4*j. */
      vuint32_t  :3;
      vuint32_t ACB_2:5;               /* Action Control Bits of ACTION_(i + 2), reflects ACT_D[i+2](52:48), i=4*j. */
      vuint32_t  :3;
      vuint32_t ACB_1:5;               /* Action Control Bits of ACTION_(i + 1) , reflects ACT_D[i+1](52:48), i=4*j. */
      vuint32_t  :3;
      vuint32_t ACB_0:5;               /* Control Bits of ACTION_i, reflects ACT_D[i](52:48), i=4*j. */
    } B;
  } ACB[8];
};


/* ============================================================================
   =============================== Module: GTM_F2A ============================
   ============================================================================ */

struct GTM_F2A_tag {
  union {                              /* F2A Read Channel n Address Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t ADDR:9;                /* ARU Read address. */
    } B;
  } CH_ARU_RD_FIFO[8];

  union {                              /* F2A Channel n Stream Configuration Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t DIR:1;                 /* Data transfer direction. */
      vuint32_t TMODE:2;               /* Transfer mode for 53 bit ARU data from/to FIFO. */
      vuint32_t  :16;
    } B;
  } CH_STR_CFG[8];

  union {                              /* F2A Stream Activation Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t STR7_EN:2;             /* Enable/disable stream 7. */
      vuint32_t STR6_EN:2;             /* Enable/disable stream 6. */
      vuint32_t STR5_EN:2;             /* Enable/disable stream 5. */
      vuint32_t STR4_EN:2;             /* Enable/disable stream 4. */
      vuint32_t STR3_EN:2;             /* Enable/disable stream 3. */
      vuint32_t STR2_EN:2;             /* Enable/disable stream 2. */
      vuint32_t STR1_EN:2;             /* Enable/disable stream 1. */
      vuint32_t STR0_EN:2;             /* STR0_EN */
    } B;
  } ENABLE;
};


/* ============================================================================
   =============================== Module: GTM_FIFO ===========================
   ============================================================================ */

struct GTM_FIFO_tag {
  struct {
    union {                            /* FIFO Channel Control Register */
      vuint32_t R;
      struct {
        vuint32_t  :28;                /* Reserved. */
        vuint32_t WULOCK:1;            /* RAM write unlock. */
        vuint32_t FLUSH:1;             /* FIFO Flush control. */
        vuint32_t RAP:1;               /* RAM access priority. */
        vuint32_t RBM:1;               /* Ring buffer mode enable. */
      } B;
    } CTRL;
    union {                            /* FIFO Channel End Address Register */
      vuint32_t R;
      struct {
        vuint32_t  :22;                /* Reserved. */
        vuint32_t ADDR:10;             /* End address for FIFO channel n. */
      } B;
    } END_ADDR;
    union {                            /* FIFO Channel Start Address Register */
      vuint32_t R;
      struct {
        vuint32_t  :22;                /* Reserved. */
        vuint32_t ADDR:10;             /* Start address for FIFO channel n. */
      } B;
    } START_ADDR;
    union {                            /* FIFO Channel Upper Watermark Register */
      vuint32_t R;
      struct {
        vuint32_t  :22;                /* Reserved. */
        vuint32_t ADDR:10;             /* Upper watermark. */
      } B;
    } UPPER_WM;
    union {                            /* FIFO Channel Lower Watermark Register */
      vuint32_t R;
      struct {
        vuint32_t  :22;                /* Reserved. */
        vuint32_t ADDR:10;             /* Normal Operation mode: Lower watermark. Ring buffer operation mode: Gate pointer from LWU to UWE. */
      } B;
    } LOWER_WM;
    union {                            /* FIFO Channel Status Register */
      vuint32_t R;
      struct {
        vuint32_t  :28;                /* Reserved. */
        vuint32_t UP_WM:1;             /* Upper watermark reached. */
        vuint32_t LOW_WM:1;            /* Lower watermark reached. */
        vuint32_t FULL:1;              /* FIFO fill level status. */
        vuint32_t EMPTY:1;             /* FIFO fill level status. */
      } B;
    } STATUS;
    union {                            /* FIFO Channel Fill Level Register */
      vuint32_t R;
      struct {
        vuint32_t  :21;                /* Reserved. */
        vuint32_t LEVEL:11;            /* Fill level of the current FIFO. */
      } B;
    } FILL_LEVEL;
    union {                            /* FIFO Channel Write Pointer Register */
      vuint32_t R;
      struct {
        vuint32_t  :22;                /* Reserved. */
        vuint32_t ADDR:10;             /* Position of the write pointer. */
      } B;
    } WR_PTR;
    union {                            /* FIFO Channel Read Pointer */
      vuint32_t R;
      struct {
        vuint32_t  :22;                /* Reserved. */
        vuint32_t ADDR:10;             /* Position of the read pointer. */
      } B;
    } RD_PTR;
    union {                            /* FIFO Channel IRQ Notification Register */
      vuint32_t R;
      struct {
        vuint32_t  :28;                /* Reserved. */
        vuint32_t FIFO_UWM:1;          /* FIFO Upper watermark was over-run. */
        vuint32_t FIFO_LWM:1;          /* FIFO Lower watermark was under-run. */
        vuint32_t FIFO_FULL:1;         /* FIFO is full. */
        vuint32_t FIFO_EMPTY:1;        /* FIFO is empty. */
      } B;
    } IRQ_NOTIFY;
    union {                            /* FIFO Channel IRQ Enable Register */
      vuint32_t R;
      struct {
        vuint32_t  :28;                /* Reserved. */
        vuint32_t FIFO_UWM_IRQ_EN:1;   /* FIFO Upper Water Mark Interrupt Enable. */
        vuint32_t FIFO_LWM_IRQ_EN:1;   /* FIFO Lower Watermark Interrupt Enable. */
        vuint32_t FIFO_FULL_IRQ_EN:1;  /* FIFO Full Interrupt Enable. */
        vuint32_t FIFO_EMPTY_IRQ_EN:1; /* FIFO Empty Interrupt Enable. */
      } B;
    } IRQ_EN;
    union {                            /* FIFO Channel Force Interrupt Register */
      vuint32_t R;
      struct {
        vuint32_t  :28;                /* Reserved. */
        vuint32_t TRG_FIFO_UWM:1;      /* Force interrupt of upper watermark. */
        vuint32_t TRG_FIFO_LWM:1;      /* Force interrupt of lower watermark. */
        vuint32_t TRG_FIFO_FULL:1;     /* Force interrupt of FIFO full status. */
        vuint32_t TRG_FIFO_EMPTY:1;    /* Force interrupt of FIFO empty status. */
      } B;
    } IRQ_FORCINT;
    union {                            /* FIFO Channel IRQ Mode Register */
      vuint32_t R;
      struct {
        vuint32_t  :28;                /* Reserved. */
        vuint32_t DMA_HYST_DIR:1;      /* DMA direction in hysteresis mode. */
        vuint32_t DMA_HYSTERESIS:1;    /* Enable DMA hysteresis mode. */
        vuint32_t IRQ_MODE:2;          /* IRQ mode select. */
      } B;
    } IRQ_MODE;
    union {                            /* FIFO Channel Error Interrupt Request Register */
      vuint32_t R;
      struct {
        vuint32_t  :28;
        vuint32_t FIFO_UWM_EIRQ_EN:1;  /* FIFO Upper Water Mark Error Interrupt Request Enable. */
        vuint32_t FIFO_LWM_EIRQ_EN:1;  /* FIFO Lower Water Mark Error Interrupt Request Enable. */
        vuint32_t FIFO_FULL_EIRQ_EN:1; /* FIFO Full Error Interrupt Request Enable. */
        vuint32_t FIFO_EMPTY_EIRQ_EN:1; /* FIFO Empty Error Interrupt Request Enable. */
      } B;
    } EIRQ_EN;
    uint8_t CHANNEL_reserved0[8];
  } CHANNEL[8];
};


/* ============================================================================
   =============================== Module: GTM_ICM ============================
   ============================================================================ */

struct GTM_ICM_tag {
  union {                              /* GTM Infrastructure Interrupt Group Register */
    vuint32_t R;
    struct {
      vuint32_t PSM1_CH7_IRQ:1;        /* PSM1 shared submodule channel 7 interrupt. */
      vuint32_t PSM1_CH6_IRQ:1;        /* PSM1 shared submodule channel 6 interrupt. */
      vuint32_t PSM1_CH5_IRQ:1;        /* PSM1 shared submodule channel 5 interrupt. */
      vuint32_t PSM1_CH4_IRQ:1;        /* PSM1 shared submodule channel 4 interrupt. */
      vuint32_t PSM1_CH3_IRQ:1;        /* PSM1 shared submodule channel 3 interrupt. */
      vuint32_t PSM1_CH2_IRQ:1;        /* PSM1 shared submodule channel 2 interrupt. */
      vuint32_t PSM1_CH1_IRQ:1;        /* PSM1 shared submodule channel 1 interrupt. */
      vuint32_t PSM1_CH0_IRQ:1;        /* PSM1 shared submodule channel 0 interrupt. */
      vuint32_t PSM0_CH7_IRQ:1;        /* PSM0 shared submodule channel 7 interrupt. */
      vuint32_t PSM0_CH6_IRQ:1;        /* PSM0 shared submodule channel 6 interrupt. */
      vuint32_t PSM0_CH5_IRQ:1;        /* PSM0 shared submodule channel 5 interrupt. */
      vuint32_t PSM0_CH4_IRQ:1;        /* PSM0 shared submodule channel 4 interrupt. */
      vuint32_t PSM0_CH3_IRQ:1;        /* PSM0 shared submodule channel 3 interrupt. */
      vuint32_t PSM0_CH2_IRQ:1;        /* PSM0 shared submodule channel 2 interrupt. */
      vuint32_t PSM0_CH1_IRQ:1;        /* PSM0 shared submodule channel 1 interrupt. */
      vuint32_t PSM0_CH0_IRQ:1;        /* PSM0 shared submodule channel 0 interrupt. */
      vuint32_t  :6;
      vuint32_t SPE3_IRQ:1;            /* SPE3 shared submodule interrupt. */
      vuint32_t SPE2_IRQ:1;            /* SPE2 shared submodule interrupt. */
      vuint32_t SPE1_IRQ:1;            /* SPE1 shared submodule interrupt. */
      vuint32_t SPE0_IRQ:1;            /* SPE0 shared submodule interrupt. */
      vuint32_t CMP_IRQ:1;             /* CMP shared submodule interrupt. */
      vuint32_t AEI_IRQ:1;             /* AEI_IRQ interrupt. */
      vuint32_t BRC_IRQ:1;             /* BRC shared submodule interrupt. */
      vuint32_t ARU_ACC_ACK_IRQ:1;     /* ARU_ACC_ACK interrupt. */
      vuint32_t ARU_NEW_DATA1_IRQ:1;   /* ARU_NEW_DATA1 interrupt. */
      vuint32_t ARU_NEW_DATA0_IRQ:1;   /* ARU_NEW_DATA0 interrupt. */
    } B;
  } IRQG_0;

  union {                              /* DPLL Interrupt Group Register */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t DPLL_SORI_IRQ:1;       /* DPLL calculated duration interrupt for STATE. */
      vuint32_t DPLL_TORI_IRQ:1;       /* DPLL calculated duration interrupt for TRIGGER. */
      vuint32_t DPLL_CDSI_IRQ:1;       /* DPLL calculated duration interrupt for STATE. */
      vuint32_t DPLL_CDTI_IRQ:1;       /* DPLL calculated duration interrupt for TRIGGER. */
      vuint32_t DPLL_TE4I_IRQ:1;       /* TRIGGER event interrupt 4. */
      vuint32_t DPLL_TE3I_IRQ:1;       /* TRIGGER event interrupt 3. */
      vuint32_t DPLL_TE2I_IRQ:1;       /* TRIGGER event interrupt 2. */
      vuint32_t DPLL_TE1I_IRQ:1;       /* TRIGGER event interrupt 1. */
      vuint32_t DPLL_TE0I_IRQ:1;       /* TRIGGER event interrupt 0. */
      vuint32_t DPLL_LL2I_IRQ:1;       /* Lost of lock interrupt for SUB_INC2. */
      vuint32_t DPLL_GL2I_IRQ:1;       /* Get of lock interrupt for SUB_INC2. */
      vuint32_t DPLL_EI_IRQ:1;         /* Error interrupt. */
      vuint32_t DPLL_LLI_IRQ:1;        /* Lost of lock interrupt for SUB_INC1. */
      vuint32_t DPLL_GLI_IRQ:1;        /* Get of lock interrupt for SUB_INC1. */
      vuint32_t DPLL_W1I_IRQ:1;        /* Write access to RAM region 1b or 1c interrupt. */
      vuint32_t DPLL_W2I_IRQ:1;        /* Write access to RAM region 2 interrupt. */
      vuint32_t DPLL_PWI_IRQ:1;        /* Plausibility window (PVT) violation interrupt of TRIGGER. */
      vuint32_t DPLL_TASI_IRQ:1;       /* TRIGGER active slope detected while NTI_CNT is zero. */
      vuint32_t DPLL_SASI_IRQ:1;       /* STATE active slope detected. */
      vuint32_t DPLL_MTI_IRQ:1;        /* Missing TRIGGER interrupt. */
      vuint32_t DPLL_MSI_IRQ:1;        /* Missing STATE interrupt. */
      vuint32_t DPLL_TISI_IRQ:1;       /* TRIGGER inactive slope detected interrupt. */
      vuint32_t DPLL_SISI_IRQ:1;       /* STATE inactive slope detected interrupt. */
      vuint32_t DPLL_TAXI_IRQ:1;       /* TRIGGER maximum hold time (THMA) violation detected interrupt. */
      vuint32_t DPLL_TINI_IRQ:1;       /* TRIGGER minimum hold time (THMI) violation detected interrupt. */
      vuint32_t DPLL_EDI_IRQ:1;        /* DPLL enable/disable interrupt. */
      vuint32_t DPLL_DCGI_IRQ:1;       /* TRIGGER direction change detected. */
    } B;
  } IRQG_1;

  union {                              /* TIM Interrupt Group 0 Register */
    vuint32_t R;
    struct {
      vuint32_t TIM3_CH7_IRQ:1;        /* TIM3 shared interrupt channel 7. */
      vuint32_t TIM3_CH6_IRQ:1;        /* TIM3 shared interrupt channel 6. */
      vuint32_t TIM3_CH5_IRQ:1;        /* TIM3 shared interrupt channel 5. */
      vuint32_t TIM3_CH4_IRQ:1;        /* TIM3 shared interrupt channel 4. */
      vuint32_t TIM3_CH3_IRQ:1;        /* TIM3 shared interrupt channel 3. */
      vuint32_t TIM3_CH2_IRQ:1;        /* TIM3 shared interrupt channel 2. */
      vuint32_t TIM3_CH1_IRQ:1;        /* TIM3 shared interrupt channel 1. */
      vuint32_t TIM3_CH0_IRQ:1;        /* TIM3 shared interrupt channel 0. */
      vuint32_t TIM2_CH7_IRQ:1;        /* TIM2 shared interrupt channel 7. */
      vuint32_t TIM2_CH6_IRQ:1;        /* TIM2 shared interrupt channel 6. */
      vuint32_t TIM2_CH5_IRQ:1;        /* TIM2 shared interrupt channel 5. */
      vuint32_t TIM2_CH4_IRQ:1;        /* TIM2 shared interrupt channel 4. */
      vuint32_t TIM2_CH3_IRQ:1;        /* TIM2 shared interrupt channel 3. */
      vuint32_t TIM2_CH2_IRQ:1;        /* TIM2 shared interrupt channel 2. */
      vuint32_t TIM2_CH1_IRQ:1;        /* TIM2 shared interrupt channel 1. */
      vuint32_t TIM2_CH0_IRQ:1;        /* TIM2 shared interrupt channel 0. */
      vuint32_t TIM1_CH7_IRQ:1;        /* TIM1 shared interrupt channel 7. */
      vuint32_t TIM1_CH6_IRQ:1;        /* TIM1 shared interrupt channel 6. */
      vuint32_t TIM1_CH5_IRQ:1;        /* TIM1 shared interrupt channel 5. */
      vuint32_t TIM1_CH4_IRQ:1;        /* TIM1 shared interrupt channel 4. */
      vuint32_t TIM1_CH3_IRQ:1;        /* TIM1 shared interrupt channel 3. */
      vuint32_t TIM1_CH2_IRQ:1;        /* TIM1 shared interrupt channel 2. */
      vuint32_t TIM1_CH1_IRQ:1;        /* TIM1 shared interrupt channel 1. */
      vuint32_t TIM1_CH0_IRQ:1;        /* TIM1 shared interrupt channel 0. */
      vuint32_t TIM0_CH7_IRQ:1;        /* TIM0 shared interrupt channel 7. */
      vuint32_t TIM0_CH6_IRQ:1;        /* TIM0 shared interrupt channel 6. */
      vuint32_t TIM0_CH5_IRQ:1;        /* TIM0 shared interrupt channel 5. */
      vuint32_t TIM0_CH4_IRQ:1;        /* TIM0 shared interrupt channel 4. */
      vuint32_t TIM0_CH3_IRQ:1;        /* TIM0 shared interrupt channel 3. */
      vuint32_t TIM0_CH2_IRQ:1;        /* TIM0 shared interrupt channel 2. */
      vuint32_t TIM0_CH1_IRQ:1;        /* TIM0 shared interrupt channel 1. */
      vuint32_t TIM0_CH0_IRQ:1;        /* TIM0 shared interrupt channel 0. */
    } B;
  } IRQG_2;

  union {                              /* TIM Interrupt Group 1 Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t TIM6_CH7_IRQ:1;        /* TIM6 shared interrupt channel 7. */
      vuint32_t TIM6_CH6_IRQ:1;        /* TIM6 shared interrupt channel 6. */
      vuint32_t TIM6_CH5_IRQ:1;        /* TIM6 shared interrupt channel 5. */
      vuint32_t TIM6_CH4_IRQ:1;        /* TIM6 shared interrupt channel 4. */
      vuint32_t TIM6_CH3_IRQ:1;        /* TIM6 shared interrupt channel 3. */
      vuint32_t TIM6_CH2_IRQ:1;        /* TIM6 shared interrupt channel 2. */
      vuint32_t TIM6_CH1_IRQ:1;        /* TIM6 shared interrupt channel 1. */
      vuint32_t TIM6_CH0_IRQ:1;        /* TIM6 shared interrupt channel 0. */
      vuint32_t TIM5_CH7_IRQ:1;        /* TIM5 shared interrupt channel 7. */
      vuint32_t TIM5_CH6_IRQ:1;        /* TIM5 shared interrupt channel 6. */
      vuint32_t TIM5_CH5_IRQ:1;        /* TIM5 shared interrupt channel 5. */
      vuint32_t TIM5_CH4_IRQ:1;        /* TIM5 shared interrupt channel 4. */
      vuint32_t TIM5_CH3_IRQ:1;        /* TIM5 shared interrupt channel 3. */
      vuint32_t TIM5_CH2_IRQ:1;        /* TIM5 shared interrupt channel 2. */
      vuint32_t TIM5_CH1_IRQ:1;        /* TIM5 shared interrupt channel 1. */
      vuint32_t TIM5_CH0_IRQ:1;        /* TIM5 shared interrupt channel 0. */
      vuint32_t TIM4_CH7_IRQ:1;        /* TIM4 shared interrupt channel 7. */
      vuint32_t TIM4_CH6_IRQ:1;        /* TIM4 shared interrupt channel 6. */
      vuint32_t TIM4_CH5_IRQ:1;        /* TIM4 shared interrupt channel 5. */
      vuint32_t TIM4_CH4_IRQ:1;        /* TIM4 shared interrupt channel 4. */
      vuint32_t TIM4_CH3_IRQ:1;        /* TIM4 shared interrupt channel 3. */
      vuint32_t TIM4_CH2_IRQ:1;        /* TIM4 shared interrupt channel 2. */
      vuint32_t TIM4_CH1_IRQ:1;        /* TIM4 shared interrupt channel 1. */
      vuint32_t TIM4_CH0_IRQ:1;        /* TIM4 shared interrupt channel 0. */
    } B;
  } IRQG_3;

  union {                              /* MCS Interrupt Group 0 Register */
    vuint32_t R;
    struct {
      vuint32_t MCS3_CH7_IRQ:1;        /* MCS3 channel 7 interrupt. */
      vuint32_t MCS3_CH6_IRQ:1;        /* MCS3 channel 6 interrupt. */
      vuint32_t MCS3_CH5_IRQ:1;        /* MCS3 channel 5 interrupt. */
      vuint32_t MCS3_CH4_IRQ:1;        /* MCS3 channel 4 interrupt. */
      vuint32_t MCS3_CH3_IRQ:1;        /* MCS3 channel 3 interrupt. */
      vuint32_t MCS3_CH2_IRQ:1;        /* MCS3 channel 2 interrupt. */
      vuint32_t MCS3_CH1_IRQ:1;        /* MCS3 channel 1 interrupt. */
      vuint32_t MCS3_CH0_IRQ:1;        /* MCS3 channel 0 interrupt. */
      vuint32_t MCS2_CH7_IRQ:1;        /* MCS2 channel 7 interrupt. */
      vuint32_t MCS2_CH6_IRQ:1;        /* MCS2 channel 6 interrupt. */
      vuint32_t MCS2_CH5_IRQ:1;        /* MCS2 channel 5 interrupt. */
      vuint32_t MCS2_CH4_IRQ:1;        /* MCS2 channel 4 interrupt. */
      vuint32_t MCS2_CH3_IRQ:1;        /* MCS2 channel 3 interrupt. */
      vuint32_t MCS2_CH2_IRQ:1;        /* MCS2 channel 2 interrupt. */
      vuint32_t MCS2_CH1_IRQ:1;        /* MCS2 channel 1 interrupt. */
      vuint32_t MCS2_CH0_IRQ:1;        /* MCS2 channel 0 interrupt. */
      vuint32_t MCS1_CH7_IRQ:1;        /* MCS1 channel 7 interrupt. */
      vuint32_t MCS1_CH6_IRQ:1;        /* MCS1 channel 6 interrupt. */
      vuint32_t MCS1_CH5_IRQ:1;        /* MCS1 channel 5 interrupt. */
      vuint32_t MCS1_CH4_IRQ:1;        /* MCS1 channel 4 interrupt. */
      vuint32_t MCS1_CH3_IRQ:1;        /* MCS1 channel 3 interrupt. */
      vuint32_t MCS1_CH2_IRQ:1;        /* MCS1 channel 2 interrupt. */
      vuint32_t MCS1_CH1_IRQ:1;        /* MCS1 channel 1 interrupt. */
      vuint32_t MCS1_CH0_IRQ:1;        /* MCS1 channel 0 interrupt. */
      vuint32_t MCS0_CH7_IRQ:1;        /* MCS0 channel 7 interrupt. */
      vuint32_t MCS0_CH6_IRQ:1;        /* MCS0 channel 6 interrupt. */
      vuint32_t MCS0_CH5_IRQ:1;        /* MCS0 channel 5 interrupt. */
      vuint32_t MCS0_CH4_IRQ:1;        /* MCS0 channel 4 interrupt. */
      vuint32_t MCS0_CH3_IRQ:1;        /* MCS0 channel 3 interrupt. */
      vuint32_t MCS0_CH2_IRQ:1;        /* MCS0 channel 2 interrupt. */
      vuint32_t MCS0_CH1_IRQ:1;        /* MCS0 channel 1 interrupt. */
      vuint32_t MCS0_CH0_IRQ:1;        /* MCS0 channel 0 interrupt. */
    } B;
  } IRQG_4;

  union {                              /* MCS Interrupt Group 1 Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t MCS6_CH7_IRQ:1;        /* MCS6 channel 7 interrupt. */
      vuint32_t MCS6_CH6_IRQ:1;        /* MCS6 channel 6 interrupt. */
      vuint32_t MCS6_CH5_IRQ:1;        /* MCS6 channel 5 interrupt. */
      vuint32_t MCS6_CH4_IRQ:1;        /* MCS6 channel 4 interrupt. */
      vuint32_t MCS6_CH3_IRQ:1;        /* MCS6 channel 3 interrupt. */
      vuint32_t MCS6_CH2_IRQ:1;        /* MCS6 channel 2 interrupt. */
      vuint32_t MCS6_CH1_IRQ:1;        /* MCS6 channel 1 interrupt. */
      vuint32_t MCS6_CH0_IRQ:1;        /* MCS6 channel 0 interrupt. */
      vuint32_t MCS5_CH7_IRQ:1;        /* MCS5 channel 7 interrupt. */
      vuint32_t MCS5_CH6_IRQ:1;        /* MCS5 channel 6 interrupt. */
      vuint32_t MCS5_CH5_IRQ:1;        /* MCS5 channel 5 interrupt. */
      vuint32_t MCS5_CH4_IRQ:1;        /* MCS5 channel 4 interrupt. */
      vuint32_t MCS5_CH3_IRQ:1;        /* MCS5 channel 3 interrupt. */
      vuint32_t MCS5_CH2_IRQ:1;        /* MCS5 channel 2 interrupt. */
      vuint32_t MCS5_CH1_IRQ:1;        /* MCS5 channel 1 interrupt. */
      vuint32_t MCS5_CH0_IRQ:1;        /* MCS5 channel 0 interrupt. */
      vuint32_t MCS4_CH7_IRQ:1;        /* MCS4 channel 7 interrupt. */
      vuint32_t MCS4_CH6_IRQ:1;        /* MCS4 channel 6 interrupt. */
      vuint32_t MCS4_CH5_IRQ:1;        /* MCS4 channel 5 interrupt. */
      vuint32_t MCS4_CH4_IRQ:1;        /* MCS4 channel 4 interrupt. */
      vuint32_t MCS4_CH3_IRQ:1;        /* MCS4 channel 3 interrupt. */
      vuint32_t MCS4_CH2_IRQ:1;        /* MCS4 channel 2 interrupt. */
      vuint32_t MCS4_CH1_IRQ:1;        /* MCS4 channel 1 interrupt. */
      vuint32_t MCS4_CH0_IRQ:1;        /* MCS4 channel 0 interrupt. */
    } B;
  } IRQG_5;

  union {                              /* TOM Interrupt Group 0 Register */
    vuint32_t R;
    struct {
      vuint32_t TOM1_CH15_IRQ:1;       /* TOM1 channel 15 shared interrupt. */
      vuint32_t TOM1_CH14_IRQ:1;       /* TOM1 channel 14 shared interrupt. */
      vuint32_t TOM1_CH13_IRQ:1;       /* TOM1 channel 13 shared interrupt. */
      vuint32_t TOM1_CH12_IRQ:1;       /* TOM1 channel 12 shared interrupt. */
      vuint32_t TOM1_CH11_IRQ:1;       /* TOM1 channel 11 shared interrupt. */
      vuint32_t TOM1_CH10_IRQ:1;       /* TOM1 channel 10 shared interrupt. */
      vuint32_t TOM1_CH9_IRQ:1;        /* TOM1 channel 9 shared interrupt. */
      vuint32_t TOM1_CH8_IRQ:1;        /* TOM1 channel 8 shared interrupt. */
      vuint32_t TOM1_CH7_IRQ:1;        /* TOM1 channel 7 shared interrupt. */
      vuint32_t TOM1_CH6_IRQ:1;        /* TOM1 channel 6 shared interrupt. */
      vuint32_t TOM1_CH5_IRQ:1;        /* TOM1 channel 5 shared interrupt. */
      vuint32_t TOM1_CH4_IRQ:1;        /* TOM1 channel 4 shared interrupt. */
      vuint32_t TOM1_CH3_IRQ:1;        /* TOM1 channel 3 shared interrupt. */
      vuint32_t TOM1_CH2_IRQ:1;        /* TOM1 channel 2 shared interrupt. */
      vuint32_t TOM1_CH1_IRQ:1;        /* TOM1 channel 1 shared interrupt. */
      vuint32_t TOM1_CH0_IRQ:1;        /* TOM1 channel 0 shared interrupt. */
      vuint32_t TOM0_CH15_IRQ:1;       /* TOM0 channel 15 shared interrupt. */
      vuint32_t TOM0_CH14_IRQ:1;       /* TOM0 channel 14 shared interrupt. */
      vuint32_t TOM0_CH13_IRQ:1;       /* TOM0 channel 13 shared interrupt. */
      vuint32_t TOM0_CH12_IRQ:1;       /* TOM0 channel 12 shared interrupt. */
      vuint32_t TOM0_CH11_IRQ:1;       /* TOM0 channel 11 shared interrupt. */
      vuint32_t TOM0_CH10_IRQ:1;       /* TOM0 channel 10 shared interrupt. */
      vuint32_t TOM0_CH9_IRQ:1;        /* TOM0 channel 9 shared interrupt. */
      vuint32_t TOM0_CH8_IRQ:1;        /* TOM0 channel 8 shared interrupt. */
      vuint32_t TOM0_CH7_IRQ:1;        /* TOM0 channel 7 shared interrupt. */
      vuint32_t TOM0_CH6_IRQ:1;        /* TOM0 channel 6 shared interrupt. */
      vuint32_t TOM0_CH5_IRQ:1;        /* TOM0 channel 5 shared interrupt. */
      vuint32_t TOM0_CH4_IRQ:1;        /* TOM0 channel 4 shared interrupt. */
      vuint32_t TOM0_CH3_IRQ:1;        /* TOM0 channel 3 shared interrupt. */
      vuint32_t TOM0_CH2_IRQ:1;        /* TOM0 channel 2 shared interrupt. */
      vuint32_t TOM0_CH1_IRQ:1;        /* TOM0 channel 1 shared interrupt */
      vuint32_t TOM0_CH0_IRQ:1;        /* TOM0 channel 0 shared interrupt. */
    } B;
  } IRQG_6;

  union {                              /* TOM Interrupt Group 1 Register */
    vuint32_t R;
    struct {
      vuint32_t TOM3_CH15_IRQ:1;       /* TOM3 channel 15 shared interrupt. */
      vuint32_t TOM3_CH14_IRQ:1;       /* TOM3 channel 14 shared interrupt. */
      vuint32_t TOM3_CH13_IRQ:1;       /* TOM3 channel 13 shared interrupt. */
      vuint32_t TOM3_CH12_IRQ:1;       /* TOM3 channel 12 shared interrupt. */
      vuint32_t TOM3_CH11_IRQ:1;       /* TOM3 channel 11 shared interrupt. */
      vuint32_t TOM3_CH10_IRQ:1;       /* TOM3 channel 10 shared interrupt. */
      vuint32_t TOM3_CH9_IRQ:1;        /* TOM3 channel 9 shared interrupt. */
      vuint32_t TOM3_CH8_IRQ:1;        /* TOM3 channel 8 shared interrupt. */
      vuint32_t TOM3_CH7_IRQ:1;        /* TOM3 channel 7 shared interrupt. */
      vuint32_t TOM3_CH6_IRQ:1;        /* TOM3 channel 7 shared interrupt. */
      vuint32_t TOM3_CH5_IRQ:1;        /* TOM3 channel 5 shared interrupt. */
      vuint32_t TOM3_CH4_IRQ:1;        /* TOM3 channel 4 shared interrupt. */
      vuint32_t TOM3_CH3_IRQ:1;        /* TOM3 channel 3 shared interrupt. */
      vuint32_t TOM3_CH2_IRQ:1;        /* TOM3 channel 2 shared interrupt. */
      vuint32_t TOM3_CH1_IRQ:1;        /* TOM3 channel 1 shared interrupt. */
      vuint32_t TOM3_CH0_IRQ:1;        /* TOM3 channel 0 shared interrupt. */
      vuint32_t TOM2_CH15_IRQ:1;       /* TOM2 channel 15 shared interrupt. */
      vuint32_t TOM2_CH14_IRQ:1;       /* TOM2 channel 14 shared interrupt. */
      vuint32_t TOM2_CH13_IRQ:1;       /* TOM2 channel 13 shared interrupt. */
      vuint32_t TOM2_CH12_IRQ:1;       /* TOM2 channel 12 shared interrupt. */
      vuint32_t TOM2_CH11_IRQ:1;       /* TOM2 channel 11 shared interrupt. */
      vuint32_t TOM2_CH10_IRQ:1;       /* TOM2 channel 10 shared interrupt. */
      vuint32_t TOM2_CH9_IRQ:1;        /* TOM2 channel 9 shared interrupt. */
      vuint32_t TOM2_CH8_IRQ:1;        /* TOM2 channel 8 shared interrupt. */
      vuint32_t TOM2_CH7_IRQ:1;        /* TOM2 channel 7 shared interrupt. */
      vuint32_t TOM2_CH6_IRQ:1;        /* TOM2 channel 6 shared interrupt. */
      vuint32_t TOM2_CH5_IRQ:1;        /* TOM2 channel 5 shared interrupt. */
      vuint32_t TOM2_CH4_IRQ:1;        /* TOM2 channel 4 shared interrupt. */
      vuint32_t TOM2_CH3_IRQ:1;        /* TOM2 channel 3 shared interrupt. */
      vuint32_t TOM2_CH2_IRQ:1;        /* TOM2 channel 2 shared interrupt. */
      vuint32_t TOM2_CH1_IRQ:1;        /* TOM2 channel 1 shared interrupt */
      vuint32_t TOM2_CH0_IRQ:1;        /* TOM2 channel 0 shared interrupt. */
    } B;
  } IRQG_7;

  union {                              /* TOM Interrupt Group 2 Register */
    vuint32_t R;
    struct {
      vuint32_t TOM5_CH15_IRQ:1;       /* TOM5 channel 15 shared interrupt. */
      vuint32_t TOM5_CH14_IRQ:1;       /* TOM5 channel 14 shared interrupt. */
      vuint32_t TOM5_CH13_IRQ:1;       /* TOM5 channel 13 shared interrupt. */
      vuint32_t TOM5_CH12_IRQ:1;       /* TOM5 channel 12 shared interrupt. */
      vuint32_t TOM5_CH11_IRQ:1;       /* TOM5 channel 11 shared interrupt. */
      vuint32_t TOM5_CH10_IRQ:1;       /* TOM5 channel 10 shared interrupt. */
      vuint32_t TOM5_CH9_IRQ:1;        /* TOM5 channel 9 shared interrupt. */
      vuint32_t TOM5_CH8_IRQ:1;        /* TOM5 channel 8 shared interrupt. */
      vuint32_t TOM5_CH7_IRQ:1;        /* TOM5 channel 7 shared interrupt. */
      vuint32_t TOM5_CH6_IRQ:1;        /* TOM5 channel 6 shared interrupt. */
      vuint32_t TOM5_CH5_IRQ:1;        /* TOM5 channel 5 shared interrupt. */
      vuint32_t TOM5_CH4_IRQ:1;        /* TOM5 channel 4 shared interrupt. */
      vuint32_t TOM5_CH3_IRQ:1;        /* TOM5 channel 3 shared interrupt. */
      vuint32_t TOM5_CH2_IRQ:1;        /* TOM5 channel 2 shared interrupt. */
      vuint32_t TOM5_CH1_IRQ:1;        /* TOM5 channel 1 shared interrupt. */
      vuint32_t TOM5_CH0_IRQ:1;        /* TOM5 channel 0 shared interrupt. */
      vuint32_t TOM4_CH15_IRQ:1;       /* TOM4 channel 15 shared interrupt. */
      vuint32_t TOM4_CH14_IRQ:1;       /* TOM4 channel 14 shared interrupt. */
      vuint32_t TOM4_CH13_IRQ:1;       /* TOM4 channel 13 shared interrupt. */
      vuint32_t TOM4_CH12_IRQ:1;       /* TOM4 channel 12 shared interrupt. */
      vuint32_t TOM4_CH11_IRQ:1;       /* TOM4 channel 11 shared interrupt. */
      vuint32_t TOM4_CH10_IRQ:1;       /* TOM4 channel 10 shared interrupt. */
      vuint32_t TOM4_CH9_IRQ:1;        /* TOM4 channel 9 shared interrupt. */
      vuint32_t TOM4_CH8_IRQ:1;        /* TOM4 channel 8 shared interrupt. */
      vuint32_t TOM4_CH7_IRQ:1;        /* TOM4 channel 7 shared interrupt. */
      vuint32_t TOM4_CH6_IRQ:1;        /* TOM4 channel 6 shared interrupt. */
      vuint32_t TOM4_CH5_IRQ:1;        /* TOM4 channel 5 shared interrupt. */
      vuint32_t TOM4_CH4_IRQ:1;        /* TOM4 channel 4 shared interrupt. */
      vuint32_t TOM4_CH3_IRQ:1;        /* TOM4 channel 3 shared interrupt. */
      vuint32_t TOM4_CH2_IRQ:1;        /* TOM4 channel 2 shared interrupt. */
      vuint32_t TOM4_CH1_IRQ:1;        /* TOM4 channel 1 shared interrupt */
      vuint32_t TOM4_CH0_IRQ:1;        /* TOM4 channel 0 shared interrupt. */
    } B;
  } IRQG_8;

  union {                              /* ATOM Interrupt Group 0 Register */
    vuint32_t R;
    struct {
      vuint32_t ATOM3_CH7_IRQ:1;       /* ATOM3 channel 7 interrupt. */
      vuint32_t ATOM3_CH6_IRQ:1;       /* ATOM3 channel 6 interrupt. */
      vuint32_t ATOM3_CH5_IRQ:1;       /* ATOM3 channel 5 interrupt. */
      vuint32_t ATOM3_CH4_IRQ:1;       /* ATOM3 channel 4 interrupt. */
      vuint32_t ATOM3_CH3_IRQ:1;       /* ATOM3 channel 3 interrupt. */
      vuint32_t ATOM3_CH2_IRQ:1;       /* ATOM3 channel 2 interrupt. */
      vuint32_t ATOM3_CH1_IRQ:1;       /* ATOM3 channel 1 interrupt. */
      vuint32_t ATOM3_CH0_IRQ:1;       /* ATOM3 channel 0 interrupt. */
      vuint32_t ATOM2_CH7_IRQ:1;       /* ATOM2 channel 7 interrupt. */
      vuint32_t ATOM2_CH6_IRQ:1;       /* ATOM2 channel 6 interrupt. */
      vuint32_t ATOM2_CH5_IRQ:1;       /* ATOM2 channel 5 interrupt. */
      vuint32_t ATOM2_CH4_IRQ:1;       /* ATOM2 channel 4 interrupt. */
      vuint32_t ATOM2_CH3_IRQ:1;       /* ATOM2 channel 3 interrupt. */
      vuint32_t ATOM2_CH2_IRQ:1;       /* ATOM2 channel 2 interrupt. */
      vuint32_t ATOM2_CH1_IRQ:1;       /* ATOM2 channel 1 interrupt. */
      vuint32_t ATOM2_CH0_IRQ:1;       /* ATOM2 channel 0 interrupt. */
      vuint32_t ATOM1_CH7_IRQ:1;       /* ATOM1 channel 7 interrupt. */
      vuint32_t ATOM1_CH6_IRQ:1;       /* ATOM1 channel 6 interrupt. */
      vuint32_t ATOM1_CH5_IRQ:1;       /* ATOM1 channel 5 interrupt. */
      vuint32_t ATOM1_CH4_IRQ:1;       /* ATOM1 channel 4 interrupt. */
      vuint32_t ATOM1_CH3_IRQ:1;       /* ATOM1 channel 3 interrupt. */
      vuint32_t ATOM1_CH2_IRQ:1;       /* ATOM1 channel 2 interrupt. */
      vuint32_t ATOM1_CH1_IRQ:1;       /* ATOM1 channel 1 interrupt. */
      vuint32_t ATOM1_CH0_IRQ:1;       /* ATOM1 channel 0 interrupt. */
      vuint32_t ATOM0_CH7_IRQ:1;       /* ATOM0 channel 7 interrupt. */
      vuint32_t ATOM0_CH6_IRQ:1;       /* ATOM0 channel 6 interrupt. */
      vuint32_t ATOM0_CH5_IRQ:1;       /* ATOM0 channel 5 interrupt. */
      vuint32_t ATOM0_CH4_IRQ:1;       /* ATOM0 channel 4 interrupt. */
      vuint32_t ATOM0_CH3_IRQ:1;       /* ATOM0 channel 3 interrupt. */
      vuint32_t ATOM0_CH2_IRQ:1;       /* ATOM0 channel 2 interrupt. */
      vuint32_t ATOM0_CH1_IRQ:1;       /* ATOM0 channel 1 interrupt. */
      vuint32_t ATOM0_CH0_IRQ:1;       /* ATOM0 channel 0 interrupt. */
    } B;
  } IRQG_9;

  union {                              /* ATOM Interrupt Group 1 Register */
    vuint32_t R;
    struct {
      vuint32_t ATOM7_CH7_IRQ:1;       /* ATOM7 channel 7 interrupt. */
      vuint32_t ATOM7_CH6_IRQ:1;       /* ATOM7 channel 6 interrupt. */
      vuint32_t ATOM7_CH5_IRQ:1;       /* ATOM7 channel 5 interrupt. */
      vuint32_t ATOM7_CH4_IRQ:1;       /* ATOM7 channel 4 interrupt. */
      vuint32_t ATOM7_CH3_IRQ:1;       /* ATOM7 channel 3 interrupt. */
      vuint32_t ATOM7_CH2_IRQ:1;       /* ATOM7 channel 2 interrupt. */
      vuint32_t ATOM7_CH1_IRQ:1;       /* ATOM7 channel 1 interrupt. */
      vuint32_t ATOM7_CH0_IRQ:1;       /* ATOM7 channel 0 interrupt. */
      vuint32_t ATOM6_CH7_IRQ:1;       /* ATOM6 channel 7 interrupt. */
      vuint32_t ATOM6_CH6_IRQ:1;       /* ATOM6 channel 6 interrupt. */
      vuint32_t ATOM6_CH5_IRQ:1;       /* ATOM6 channel 5 interrupt. */
      vuint32_t ATOM6_CH4_IRQ:1;       /* ATOM channel 4 interrupt. */
      vuint32_t ATOM6_CH3_IRQ:1;       /* ATOM6 channel 3 interrupt. */
      vuint32_t ATOM6_CH2_IRQ:1;       /* ATOM6 channel 2 interrupt. */
      vuint32_t ATOM6_CH1_IRQ:1;       /* ATOM6 channel 1 interrupt. */
      vuint32_t ATOM6_CH0_IRQ:1;       /* ATOM6 channel 0 interrupt. */
      vuint32_t ATOM5_CH7_IRQ:1;       /* ATOM5 channel 7 interrupt. */
      vuint32_t ATOM5_CH6_IRQ:1;       /* ATOM5 channel 6 interrupt. */
      vuint32_t ATOM5_CH5_IRQ:1;       /* ATOM5 channel 5 interrupt. */
      vuint32_t ATOM5_CH4_IRQ:1;       /* ATOM5 channel 4 interrupt. */
      vuint32_t ATOM5_CH3_IRQ:1;       /* ATOM5 channel 3 interrupt. */
      vuint32_t ATOM5_CH2_IRQ:1;       /* ATOM5 channel 2 interrupt. */
      vuint32_t ATOM5_CH1_IRQ:1;       /* ATOM5 channel 1 interrupt. */
      vuint32_t ATOM5_CH0_IRQ:1;       /* ATOM5 channel 0 interrupt. */
      vuint32_t ATOM4_CH7_IRQ:1;       /* ATOM4 channel 7 interrupt. */
      vuint32_t ATOM4_CH6_IRQ:1;       /* ATOM4 channel 6 interrupt. */
      vuint32_t ATOM4_CH5_IRQ:1;       /* ATOM4 channel 5 interrupt. */
      vuint32_t ATOM4_CH4_IRQ:1;       /* ATOM4 channel 4 interrupt. */
      vuint32_t ATOM4_CH3_IRQ:1;       /* ATOM4 channel 3 interrupt. */
      vuint32_t ATOM4_CH2_IRQ:1;       /* ATOM4 channel 2 interrupt. */
      vuint32_t ATOM4_CH1_IRQ:1;       /* ATOM4 channel 1 interrupt. */
      vuint32_t ATOM4_CH0_IRQ:1;       /* ATOM4 channel 0 interrupt. */
    } B;
  } IRQG_10;

  union {                              /* ATOM Interrupt Group 2 Register */
    vuint32_t R;
    struct {
      vuint32_t ATOM11_CH7_IRQ:1;      /* ATOM11 channel 7 interrupt. */
      vuint32_t ATOM11_CH6_IRQ:1;      /* ATOM11 channel 6 interrupt. */
      vuint32_t ATOM11_CH5_IRQ:1;      /* ATOM11 channel 5 interrupt. */
      vuint32_t ATOM11_CH4_IRQ:1;      /* ATOM11 channel 4 interrupt. */
      vuint32_t ATOM11_CH3_IRQ:1;      /* ATOM11 channel 3 interrupt. */
      vuint32_t ATOM11_CH2_IRQ:1;      /* ATOM11 channel 2 interrupt. */
      vuint32_t ATOM11_CH1_IRQ:1;      /* ATOM11 channel 1 interrupt. */
      vuint32_t ATOM11_CH0_IRQ:1;      /* ATOM11 channel 0 interrupt. */
      vuint32_t ATOM10_CH7_IRQ:1;      /* ATOM10 channel 7 interrupt. */
      vuint32_t ATOM10_CH6_IRQ:1;      /* ATOM10 channel 6 interrupt. */
      vuint32_t ATOM10_CH5_IRQ:1;      /* ATOM10 channel 5 interrupt. */
      vuint32_t ATOM10_CH4_IRQ:1;      /* ATOM10 channel 4 interrupt. */
      vuint32_t ATOM10_CH3_IRQ:1;      /* ATOM10 channel 3 interrupt. */
      vuint32_t ATOM10_CH2_IRQ:1;      /* ATOM10 channel 2 interrupt. */
      vuint32_t ATOM10_CH1_IRQ:1;      /* ATOM10 channel 1 interrupt. */
      vuint32_t ATOM10_CH0_IRQ:1;      /* ATOM10 channel 0 interrupt. */
      vuint32_t ATOM9_CH7_IRQ:1;       /* ATOM9 channel 7 interrupt. */
      vuint32_t ATOM9_CH6_IRQ:1;       /* ATOM9 channel 6 interrupt. */
      vuint32_t ATOM9_CH5_IRQ:1;       /* ATOM9 channel 5 interrupt. */
      vuint32_t ATOM9_CH4_IRQ:1;       /* ATOM9 channel 4 interrupt. */
      vuint32_t ATOM9_CH3_IRQ:1;       /* ATOM9 channel 3 interrupt. */
      vuint32_t ATOM9_CH2_IRQ:1;       /* ATOM9 channel 2 interrupt. */
      vuint32_t ATOM9_CH1_IRQ:1;       /* ATOM9 channel 1 interrupt. */
      vuint32_t ATOM9_CH0_IRQ:1;       /* ATOM9 channel 0 interrupt. */
      vuint32_t ATOM8_CH7_IRQ:1;       /* ATOM8 channel 7 interrupt. */
      vuint32_t ATOM8_CH6_IRQ:1;       /* ATOM8 channel 6 interrupt. */
      vuint32_t ATOM8_CH5_IRQ:1;       /* ATOM8 channel 5 interrupt. */
      vuint32_t ATOM8_CH4_IRQ:1;       /* ATOM8 channel 4 interrupt. */
      vuint32_t ATOM4_CH3_IR8:1;       /* ATOM8 channel 3 interrupt. */
      vuint32_t ATOM8_CH2_IRQ:1;       /* ATOM8 channel 2 interrupt. */
      vuint32_t ATOM8_CH1_IRQ:1;       /* ATOM8 channel 1 interrupt. */
      vuint32_t ATOM8_CH0_IRQ:1;       /* ATOM8 channel 0 interrupt. */
    } B;
  } IRQG_11;

  union {                              /* ICM IRQG Module Error Interrupt register */
    vuint32_t R;
    struct {
      vuint32_t  :6;
      vuint32_t DPLL_EIRQ:1;           /* DPLL error interrupt. */
      vuint32_t CMP_EIRQ:1;            /* CMP error interrupt. */
      vuint32_t SPE3_EIRQ:1;           /* SPE3 error interrupt. */
      vuint32_t SPE2_EIRQ:1;           /* SPE2 error interrupt. */
      vuint32_t SPE1_EIRQ:1;           /* SPE1 error interrupt. */
      vuint32_t SPE0_EIRQ:1;           /* SPE0 error interrupt. */
      vuint32_t  :1;
      vuint32_t MCS6_EIRQ:1;           /* MCS6 error interrupt. */
      vuint32_t MCS5_EIRQ:1;           /* MCS5 error interrupt. */
      vuint32_t MCS4_EIRQ:1;           /* MCS4 error interrupt. */
      vuint32_t MCS3_EIRQ:1;           /* MCS3 error interrupt. */
      vuint32_t MCS2_EIRQ:1;           /* MCS2 error interrupt. */
      vuint32_t MCS1_EIRQ:1;           /* MCS1 error interrupt */
      vuint32_t MCS0_EIRQ:1;           /* MCS0 error interrupt. */
      vuint32_t  :1;
      vuint32_t TIM6_EIRQ:1;           /* TIM6 error interrupt. */
      vuint32_t TIM5_EIRQ:1;           /* TIM5 error interrupt. */
      vuint32_t TIM4_EIRQ:1;           /* TIM4 error interrupt. */
      vuint32_t TIM3_EIRQ:1;           /* TIM3 error interrupt. */
      vuint32_t TIM2_EIRQ:1;           /* TIM2 error interrupt. */
      vuint32_t TIM1_EIRQ:1;           /* TIM1 error interrupt. */
      vuint32_t TIM0_EIRQ:1;           /* TIM0 error interrupt. */
      vuint32_t FIFO1_EIRQ:1;          /* FIFO1 error interrupt. */
      vuint32_t FIFO0_EIRQ:1;          /* FIFO0 error interrupt. */
      vuint32_t BRC_EIRQ:1;            /* BRC error interrupt. */
      vuint32_t GTM_EIRQ:1;            /* GTM Error interrupt request. */
    } B;
  } IRQG_MEI;

  union {                              /* ICM Channel Error Interrupt Request Group 0 register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t FIFO1_CH7_EIRQ:1;      /* FIFO1 channel 7 error interrupt */
      vuint32_t FIFO1_CH6_EIRQ:1;      /* FIFO1 channel 6 error interrupt */
      vuint32_t FIFO1_CH5_EIRQ:1;      /* FIFO1 channel 5 error interrupt */
      vuint32_t FIFO1_CH4_EIRQ:1;      /* FIFO1 channel 4 error interrupt */
      vuint32_t FIFO1_CH3_EIRQ:1;      /* FIFO1 channel 3 error interrupt */
      vuint32_t FIFO1_CH2_EIRQ:1;      /* FIFO1 channel 2 error interrupt */
      vuint32_t FIFO1_CH1_EIRQ:1;      /* FIFO1 channel 1 error interrupt */
      vuint32_t FIFO1_CH0_EIRQ:1;      /* FIFO1 channel 0 error interrupt */
      vuint32_t FIFO0_CH7_EIRQ:1;      /* FIFO0 channel 7 error interrupt */
      vuint32_t FIFO0_CH6_EIRQ:1;      /* FIFO0 channel 6 error interrupt */
      vuint32_t FIFO0_CH5_EIRQ:1;      /* FIFO0 channel 5 error interrupt */
      vuint32_t FIFO0_CH4_EIRQ:1;      /* FIFO0 channel 4 error interrupt */
      vuint32_t FIFO0_CH3_EIRQ:1;      /* FIFO0 channel 3 error interrupt */
      vuint32_t FIFO0_CH2_EIRQ:1;      /* FIFO0 channel 2 error interrupt */
      vuint32_t FIFO0_CH1_EIRQ:1;      /* FIFO0 channel 1 error interrupt */
      vuint32_t FIFO0_CH0_EIRQ:1;      /* FIFO0 channel 0 error interrupt */
    } B;
  } IRQG_CEI0;

  union {                              /* Channel Error Interrupt Request Group 1 register */
    vuint32_t R;
    struct {
      vuint32_t TIM3_CH7_EIRQ:1;       /* TIM3 Channel 7 Error interrupt */
      vuint32_t TIM3_CH6_EIRQ:1;       /* TIM3 Channel 6 Error interrupt */
      vuint32_t TIM3_CH5_EIRQ:1;       /* TIM3 Channel 5 Error interrupt */
      vuint32_t TIM3_CH4_EIRQ:1;       /* TIM3 Channel 4 Error interrupt */
      vuint32_t TIM3_CH3_EIRQ:1;       /* TIM3 Channel 3 Error interrupt */
      vuint32_t TIM3_CH2_EIRQ:1;       /* TIM3 Channel 2 Error interrupt */
      vuint32_t TIM3_CH1_EIRQ:1;       /* TIM3 Channel 1 Error interrupt */
      vuint32_t TIM3_CH0_EIRQ:1;       /* TIM3 Channel 0 Error interrupt */
      vuint32_t TIM2_CH7_EIRQ:1;       /* TIM2 Channel 7 Error interrupt */
      vuint32_t TIM2_CH6_EIRQ:1;       /* TIM2 Channel 6 Error interrupt */
      vuint32_t TIM2_CH5_EIRQ:1;       /* TIM2 Channel 5 Error interrupt */
      vuint32_t TIM2_CH4_EIRQ:1;       /* TIM2 Channel 4 Error interrupt */
      vuint32_t TIM2_CH3_EIRQ:1;       /* TIM2 Channel 3 Error interrupt */
      vuint32_t TIM2_CH2_EIRQ:1;       /* TIM2 Channel 2 Error interrupt */
      vuint32_t TIM2_CH1_EIRQ:1;       /* TIM2 Channel 1 Error interrupt */
      vuint32_t TIM2_CH0_EIRQ:1;       /* TIM2 Channel 0 Error interrupt */
      vuint32_t TIM1_CH7_EIRQ:1;       /* TIM1 Channel 7 Error interrupt */
      vuint32_t TIM1_CH6_EIRQ:1;       /* TIM1 Channel 6 Error interrupt */
      vuint32_t TIM1_CH5_EIRQ:1;       /* TIM1 Channel 5 Error interrupt */
      vuint32_t TIM1_CH4_EIRQ:1;       /* TIM1 Channel 4 Error interrupt */
      vuint32_t TIM1_CH3_EIRQ:1;       /* TIM1 Channel 3 Error interrupt */
      vuint32_t TIM1_CH2_EIRQ:1;       /* TIM1 Channel 2 Error interrupt */
      vuint32_t TIM1_CH1_EIRQ:1;       /* TIM1 Channel 1 Error interrupt */
      vuint32_t TIM1_CH0_EIRQ:1;       /* TIM1 Channel 0 Error interrupt */
      vuint32_t TIM0_CH7_EIRQ:1;       /* TIM0 Channel 7 Error interrupt */
      vuint32_t TIM0_CH6_EIRQ:1;       /* TIM0 Channel 6 Error interrupt */
      vuint32_t TIM0_CH5_EIRQ:1;       /* TIM0 Channel 5 Error interrupt */
      vuint32_t TIM0_CH4_EIRQ:1;       /* TIM0 Channel 4 Error interrupt */
      vuint32_t TIM0_CH3_EIRQ:1;       /* TIM0 Channel 3 Error interrupt */
      vuint32_t TIM0_CH2_EIRQ:1;       /* TIM0 Channel 2 Error interrupt */
      vuint32_t TIM0_CH1_EIRQ:1;       /* TIM0 Channel 1 Error interrupt */
      vuint32_t TIM0_CH0_EIRQ:1;       /* TIM0 Channel 0 Error interrupt */
    } B;
  } IRQG_CEI1;

  union {                              /* Channel Error Interrupt Request Group 2 register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t TIM6_CH7_EIRQ:1;       /* TIM6 Channel 7 Error interrupt */
      vuint32_t TIM6_CH6_EIRQ:1;       /* TIM6 Channel 6 Error interrupt */
      vuint32_t TIM6_CH5_EIRQ:1;       /* TIM6 Channel 5 Error interrupt */
      vuint32_t TIM6_CH4_EIRQ:1;       /* TIM6 Channel 4 Error interrupt */
      vuint32_t TIM6_CH3_EIRQ:1;       /* TIM6 Channel 3 Error interrupt */
      vuint32_t TIM6_CH2_EIRQ:1;       /* TIM6 Channel 2 Error interrupt */
      vuint32_t TIM6_CH1_EIRQ:1;       /* TIM6 Channel 1 Error interrupt */
      vuint32_t TIM6_CH0_EIRQ:1;       /* TIM6 Channel 0 Error interrupt */
      vuint32_t TIM5_CH7_EIRQ:1;       /* TIM5 Channel 7 Error interrupt */
      vuint32_t TIM5_CH6_EIRQ:1;       /* TIM5 Channel 6 Error interrupt */
      vuint32_t TIM5_CH5_EIRQ:1;       /* TIM5 Channel 5 Error interrupt */
      vuint32_t TIM5_CH4_EIRQ:1;       /* TIM5 Channel 4 Error interrupt */
      vuint32_t TIM5_CH3_EIRQ:1;       /* TIM5 Channel 3 Error interrupt */
      vuint32_t TIM5_CH2_EIRQ:1;       /* TIM5 Channel 2 Error interrupt */
      vuint32_t TIM5_CH1_EIRQ:1;       /* TIM5 Channel 1 Error interrupt */
      vuint32_t TIM5_CH0_EIRQ:1;       /* TIM5 Channel 0 Error interrupt */
      vuint32_t TIM4_CH7_EIRQ:1;       /* TIM4 Channel 7 Error interrupt */
      vuint32_t TIM4_CH6_EIRQ:1;       /* TIM4 Channel 6 Error interrupt */
      vuint32_t TIM4_CH5_EIRQ:1;       /* TIM4 Channel 5 Error interrupt */
      vuint32_t TIM4_CH4_EIRQ:1;       /* TIM4 Channel 4 Error interrupt */
      vuint32_t TIM4_CH3_EIRQ:1;       /* TIM4 Channel 3 Error interrupt */
      vuint32_t TIM4_CH2_EIRQ:1;       /* TIM4 Channel 2 Error interrupt */
      vuint32_t TIM4_CH1_EIRQ:1;       /* TIM4 Channel 1 Error interrupt */
      vuint32_t TIM4_CH0_EIRQ:1;       /* TIM4 Channel 0 Error interrupt */
    } B;
  } IRQG_CEI2;

  union {                              /* Channel Error Interrupt Request Group 3 register */
    vuint32_t R;
    struct {
      vuint32_t MCS3_CH7_EIRQ:1;       /* MCS3 Channel 7 error interrupt */
      vuint32_t MCS3_CH6_EIRQ:1;       /* MCS3 Channel 6 error interrupt */
      vuint32_t MCS3_CH5_EIRQ:1;       /* MCS3 Channel 5 error interrupt */
      vuint32_t MCS3_CH4_EIRQ:1;       /* MCS3 Channel 4 error interrupt */
      vuint32_t MCS3_CH3_EIRQ:1;       /* MCS3 Channel 3 error interrupt */
      vuint32_t MCS3_CH2_EIRQ:1;       /* MCS3 Channel 2 error interrupt */
      vuint32_t MCS3_CH1_EIRQ:1;       /* MCS3 Channel 1 error interrupt */
      vuint32_t MCS3_CH0_EIRQ:1;       /* MCS3 Channel 0 error interrupt */
      vuint32_t MCS2_CH7_EIRQ:1;       /* MCS2 Channel 7 error interrupt */
      vuint32_t MCS2_CH6_EIRQ:1;       /* MCS2 Channel 6 error interrupt */
      vuint32_t MCS2_CH5_EIRQ:1;       /* MCS2 Channel 5 error interrupt */
      vuint32_t MCS2_CH4_EIRQ:1;       /* MCS2 Channel 4 error interrupt */
      vuint32_t MCS2_CH3_EIRQ:1;       /* MCS2 Channel 3 error interrupt */
      vuint32_t MCS2_CH2_EIRQ:1;       /* MCS2 Channel 2 error interrupt */
      vuint32_t MCS2_CH1_EIRQ:1;       /* MCS2 Channel 1 error interrupt */
      vuint32_t MCS2_CH0_EIRQ:1;       /* MCS2 Channel 0 error interrupt */
      vuint32_t MCS1_CH7_EIRQ:1;       /* MCS1 Channel 7 error interrupt */
      vuint32_t MCS1_CH6_EIRQ:1;       /* MCS1 Channel 6 error interrupt */
      vuint32_t MCS1_CH5_EIRQ:1;       /* MCS1 Channel 5 error interrupt */
      vuint32_t MCS1_CH4_EIRQ:1;       /* MCS1 Channel 4 error interrupt */
      vuint32_t MCS1_CH3_EIRQ:1;       /* MCS1 Channel 3 error interrupt */
      vuint32_t MCS1_CH2_EIRQ:1;       /* MCS1 Channel 2 error interrupt */
      vuint32_t MCS1_CH1_EIRQ:1;       /* MCS1 Channel 1 error interrupt */
      vuint32_t MCS1_CH0_EIRQ:1;       /* MCS1 Channel 0 error interrupt */
      vuint32_t MCS0_CH7_EIRQ:1;       /* MCS0 Channel 7 error interrupt */
      vuint32_t MCS0_CH6_EIRQ:1;       /* MCS0 Channel 6 error interrupt */
      vuint32_t MCS0_CH5_EIRQ:1;       /* MCS0 Channel 5 error interrupt */
      vuint32_t MCS0_CH4_EIRQ:1;       /* MCS0 Channel 4 error interrupt */
      vuint32_t MCS0_CH3_EIRQ:1;       /* MCS0 Channel 3 error interrupt */
      vuint32_t MCS0_CH2_EIRQ:1;       /* MCS0 Channel 2 error interrupt */
      vuint32_t MCS0_CH1_EIRQ:1;       /* MCS0 Channel 1 error interrupt */
      vuint32_t MCS0_CH0_EIRQ:1;       /* MCS0 Channel 0 error interrupt */
    } B;
  } IRQG_CEI3;

  union {                              /* Channel Error Interrupt Request Group 4 register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t MCS6_CH7_EIRQ:1;       /* MCS6 Channel 7 error interrupt */
      vuint32_t MCS6_CH6_EIRQ:1;       /* MCS6 Channel 6 error interrupt */
      vuint32_t MCS6_CH5_EIRQ:1;       /* MCS6 Channel 5 error interrupt */
      vuint32_t MCS6_CH4_EIRQ:1;       /* MCS6 Channel 4 error interrupt */
      vuint32_t MCS6_CH3_EIRQ:1;       /* MCS6 Channel 3 error interrupt */
      vuint32_t MCS6_CH2_EIRQ:1;       /* MCS6 Channel 2 error interrupt */
      vuint32_t MCS6_CH1_EIRQ:1;       /* MCS6 Channel 1 error interrupt */
      vuint32_t MCS6_CH0_EIRQ:1;       /* MCS6 Channel 0 error interrupt */
      vuint32_t MCS5_CH7_EIRQ:1;       /* MCS5 Channel 7 error interrupt */
      vuint32_t MCS5_CH6_EIRQ:1;       /* MCS5 Channel 6 error interrupt */
      vuint32_t MCS5_CH5_EIRQ:1;       /* MCS5 Channel 5 error interrupt */
      vuint32_t MCS5_CH4_EIRQ:1;       /* MCS5 Channel 4 error interrupt */
      vuint32_t MCS5_CH3_EIRQ:1;       /* MCS5 Channel 3 error interrupt */
      vuint32_t MCS5_CH2_EIRQ:1;       /* MCS5 Channel 2 error interrupt */
      vuint32_t MCS5_CH1_EIRQ:1;       /* MCS5 Channel 1 error interrupt */
      vuint32_t MCS5_CH0_EIRQ:1;       /* MCS5 Channel 0 error interrupt */
      vuint32_t MCS4_CH7_EIRQ:1;       /* MCS4 Channel 7 error interrupt */
      vuint32_t MCS4_CH6_EIRQ:1;       /* MCS4 Channel 6 error interrupt */
      vuint32_t MCS4_CH5_EIRQ:1;       /* MCS4 Channel 5 error interrupt */
      vuint32_t MCS4_CH4_EIRQ:1;       /* MCS4 Channel 4 error interrupt */
      vuint32_t MCS4_CH3_EIRQ:1;       /* MCS4 Channel 3 error interrupt */
      vuint32_t MCS4_CH2_EIRQ:1;       /* MCS4 Channel 2 error interrupt */
      vuint32_t MCS4_CH1_EIRQ:1;       /* MCS4 Channel 1 error interrupt */
      vuint32_t MCS4_CH0_EIRQ:1;       /* MCS4 Channel 0 error interrupt */
    } B;
  } IRQG_CEI4;
};


/* ============================================================================
   =============================== Module: GTM_MAP ============================
   ============================================================================ */

struct GTM_MAP_tag {
  union {                              /* TIM0 Input MAP Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t TSPP1_I2V:1;           /* Disable of TSPP1 TIM0_CHz(48) input line. */
      vuint32_t TSPP1_I1V:1;           /* Disable of TSPP1 TIM0_CHy(48) input line. */
      vuint32_t TSPP1_I0V:1;           /* Disable of TSPP1 TIM0_CHx(48) input line. */
      vuint32_t  :2;
      vuint32_t TSPP1_DLD:1;           /* DIR level definition bit. */
      vuint32_t TSPP1_EN:1;            /* Enable of TSPP1 subunit. */
      vuint32_t  :1;
      vuint32_t TSPP0_I2V:1;           /* Disable of TSPP0 TIM0_CHz(48) input line. */
      vuint32_t TSPP0_I1V:1;           /* Disable of TSPP0 TIM0_CHy(48) input line. */
      vuint32_t TSPP0_I0V:1;           /* Disable of TSPP0 TIM0_CHx(48) input line. */
      vuint32_t  :2;
      vuint32_t TSPP0_DLD:1;           /* DIR level definition bit. */
      vuint32_t TSPP0_EN:1;            /* Enable of TSPP0 subunit. */
      vuint32_t  :11;
      vuint32_t LSEL:1;                /* TIM0_IN6 input level selection. */
      vuint32_t SSL:3;                 /* STATE signal output select. */
      vuint32_t TSEL:1;                /* TRIGGER signal output select. */
    } B;
  } CTRL;
};


/* ============================================================================
   =============================== Module: GTM_MCFG ===========================
   ============================================================================ */

struct GTM_MCFG_tag {
  union {                              /* Memory Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t MEM6:2;                /* Configure Memory pages for MCS-instance MCS6. */
      vuint32_t MEM5:2;                /* Configure Memory pages for MCS-instance MCS5. */
      vuint32_t MEM4:2;                /* Configure Memory pages for MCS-instance MCS4. */
      vuint32_t MEM3:2;                /* Configure Memory pages for MCS-instance MCS3 */
      vuint32_t MEM2:2;                /* Configure Memory pages for MCS-instance MCS2 */
      vuint32_t MEM1:2;                /* Configure Memory pages for MCS-instance MCS1. */
      vuint32_t MEM0:2;                /* Configure Memory pages for MCS-instance MCS0. */
    } B;
  } CTRL;
};


/* ============================================================================
   =============================== Module: GTM_MCS ============================
   ============================================================================ */

struct GTM_MCS_tag {
  union {                              /* MCS Channel n General Purpose 0 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R0. */
    } B;
  } CH0_R0;

  union {                              /* MCS Channel n General Purpose 1 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R1. */
    } B;
  } CH0_R1;

  union {                              /* MCS Channel n General Purpose 2 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R2. */
    } B;
  } CH0_R2;

  union {                              /* MCS Channel n General Purpose 3 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R3. */
    } B;
  } CH0_R3;

  union {                              /* MCS Channel n General Purpose 4 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R4. */
    } B;
  } CH0_R4;

  union {                              /* MCS Channel n General Purpose 5 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R5. */
    } B;
  } CH0_R5;

  union {                              /* MCS Channel n General Purpose 6 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R6. */
    } B;
  } CH0_R6;

  union {                              /* MCS Channel n General Purpose 7 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R7. */
    } B;
  } CH0_R7;

  union {                              /* MCS Channel n Control Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t SP_CNT:3;              /* Stack pointer counter value. */
      vuint32_t  :5;
      vuint32_t SAT:1;                 /* Successful ARU transfer bit. */
      vuint32_t CWT:1;                 /* Cancel WURM instruction state. */
      vuint32_t CAT:1;                 /* Cancel ARU transfer state. */
      vuint32_t N:1;                   /* Negative bit state. */
      vuint32_t V:1;                   /* Overflow bit state. */
      vuint32_t Z:1;                   /* Zero bit state. */
      vuint32_t CY:1;                  /* Carry bit state. */
      vuint32_t  :1;
      vuint32_t ERR:1;                 /* Error state. */
      vuint32_t IRQ:1;                 /* Interrupt state. */
      vuint32_t EN:1;                  /* Enable MCS-channel. */
    } B;
  } CH0_CTRL;

  union {                              /* MCS Channel n ARU Control Bit Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t ACB4:1;                /* See ACB0. */
      vuint32_t ACB3:1;                /* See ACB0. */
      vuint32_t ACB2:1;                /* See ACB0. */
      vuint32_t ACB1:1;                /* See ACB0. */
      vuint32_t ACB0:1;                /* ARU Control bit[4:0]. */
    } B;
  } CH0_ACB;

  union {                              /* MCS Clear Trigger Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TRG15:1;               /* Trigger bit. */
      vuint32_t TRG14:1;               /* Trigger bit. */
      vuint32_t TRG13:1;               /* Trigger bit. */
      vuint32_t TRG12:1;               /* Trigger bit. */
      vuint32_t TRG11:1;               /* Trigger bit. */
      vuint32_t TRG10:1;               /* Trigger bit. */
      vuint32_t TRG9:1;                /* Trigger bit. */
      vuint32_t TRG8:1;                /* Trigger bit. */
      vuint32_t TRG7:1;                /* Trigger bit. */
      vuint32_t TRG6:1;                /* Trigger bit. */
      vuint32_t TRG5:1;                /* Trigger bit. */
      vuint32_t TRG4:1;                /* Trigger bit. */
      vuint32_t TRG3:1;                /* Trigger bit. */
      vuint32_t TRG2:1;                /* Trigger bit. */
      vuint32_t TRG1:1;                /* Trigger bit. */
      vuint32_t TRG0:1;                /* Trigger bit. */
    } B;
  } CTRG;

  union {                              /* MCS Set Trigger Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TRG15:1;               /* Trigger bit. */
      vuint32_t TRG14:1;               /* Trigger bit. */
      vuint32_t TRG13:1;               /* Trigger bit. */
      vuint32_t TRG12:1;               /* Trigger bit. */
      vuint32_t TRG11:1;               /* Trigger bit. */
      vuint32_t TRG10:1;               /* Trigger bit. */
      vuint32_t TRG9:1;                /* Trigger bit. */
      vuint32_t TRG8:1;                /* Trigger bit. */
      vuint32_t TRG7:1;                /* Trigger bit. */
      vuint32_t TRG6:1;                /* Trigger bit. */
      vuint32_t TRG5:1;                /* Trigger bit. */
      vuint32_t TRG4:1;                /* Trigger bit. */
      vuint32_t TRG3:1;                /* Trigger bit. */
      vuint32_t TRG2:1;                /* Trigger bit. */
      vuint32_t TRG1:1;                /* Trigger bit. */
      vuint32_t TRG0:1;                /* Trigger bit. */
    } B;
  } STRG;

  uint8_t MCS_reserved0[16];
  union {                              /* MCS Channel n Program Counter Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t PC:14;                 /* Current Program Counter. */
    } B;
  } CH0_PC;

  union {                              /* MCS Channel n Interrupt Request Notification Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_IRQ:1;         /* Memory access out of range in channel n. */
      vuint32_t STK_ERR_IRQ:1;         /* Stack counter overflow/underflow of channel n. */
      vuint32_t MCS_IRQ:1;             /* Interrupt request by MCS-channel n. */
    } B;
  } CH0_IRQ_NOTIFY;

  union {                              /* MCS Channel n Interrupt Request Enable Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_IRQ_EN:1;      /* MCS channel n MEM_ERR_IRQ interrupt enable. */
      vuint32_t STK_ERR_IRQ_EN:1;      /* MCS channel n STK_ERR_IRQ interrupt enable. */
      vuint32_t MCS_IRQ_EN:1;          /* MCS channel n MCS_IRQ interrupt enable. */
    } B;
  } CH0_IRQ_EN;

  union {                              /* MCS Channel n Force Interrupt Request Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t TRG_MEM_ERR_IRQ:1;     /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register by software. */
      vuint32_t TRG_STK_ERR_IRQ:1;     /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register by software. */
      vuint32_t TRG_MCS_IRQ:1;         /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register */
    } B;
  } CH0_IRQ_FORCINT;

  union {                              /* MCS Channel n Interrupt Request Mode Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH0_IRQ_MODE;

  union {                              /* MCS Channel n Error Interrupt Request Enable register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_EIRQ_EN:1;     /* MCS[i] channel n MEM_ERR_EIRQ error interrupt enable. */
      vuint32_t STK_ERR_EIRQ_EN:1;     /* MCS[i] channel n STK_ERR_IRQ error interrupt enable. */
      vuint32_t MCS_EIRQ_EN:1;         /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register */
    } B;
  } CH0_EIRQ_EN;

  uint8_t MCS_reserved1[28];
  union {                              /* MCS Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t RAM_RST:1;             /* RAM reset bit. */
      vuint32_t  :14;
      vuint32_t HLT_SP_OFL:1;          /* Halt on stack pointer overflow. */
      vuint32_t SCHED:1;               /* MCS submodule scheduling scheme. */
    } B;
  } CTRL;

  union {                              /* MCS Reset Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CWT7:1;                /* Cancel WURM instruction for channel. */
      vuint32_t CWT6:1;                /* Cancel WURM instruction for channel. */
      vuint32_t CWT5:1;                /* Cancel WURM instruction for channel. */
      vuint32_t CWT4:1;                /* Cancel WURM instruction for channel. */
      vuint32_t CWT3:1;                /* Cancel WURM instruction for channel. */
      vuint32_t CWT2:1;                /* Cancel WURM instruction for channel. */
      vuint32_t CWT1:1;                /* Cancel WURM instruction for channel. */
      vuint32_t CWT0:1;                /* Cancel WURM instruction for channel. */
      vuint32_t CAT7:1;                /* Cancel ARU transfer for channel. */
      vuint32_t CAT6:1;                /* Cancel ARU transfer for channel. */
      vuint32_t CAT5:1;                /* Cancel ARU transfer for channel. */
      vuint32_t CAT4:1;                /* Cancel ARU transfer for channel. */
      vuint32_t CAT3:1;                /* Cancel ARU transfer for channel. */
      vuint32_t CAT2:1;                /* Cancel ARU transfer for channel. */
      vuint32_t CAT1:1;                /* Cancel ARU transfer for channel. */
      vuint32_t CAT0:1;                /* Cancel ARU transfer for channel. */
      vuint32_t RST7:1;                /* Software reset of channel. */
      vuint32_t RST6:1;                /* Software reset of channel. */
      vuint32_t RST5:1;                /* Software reset of channel. */
      vuint32_t RST4:1;                /* Software reset of channel. */
      vuint32_t RST3:1;                /* Software reset of channel. */
      vuint32_t RST2:1;                /* Software reset of channel. */
      vuint32_t RST1:1;                /* Software reset of channel. */
      vuint32_t RST0:1;                /* Software reset of channel. */
    } B;
  } RST;

  union {                              /* MCS Error Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t ERR7:1;                /* Error State of MCS-channel. */
      vuint32_t ERR6:1;                /* Error State of MCS-channel. */
      vuint32_t ERR5:1;                /* Error State of MCS-channel. */
      vuint32_t ERR4:1;                /* Error State of MCS-channel. */
      vuint32_t ERR3:1;                /* Error State of MCS-channel. */
      vuint32_t ERR2:1;                /* Error State of MCS-channel. */
      vuint32_t ERR1:1;                /* Error State of MCS-channel. */
      vuint32_t ERR0:1;                /* Error State of MCS-channel. */
    } B;
  } ERR;

  union {                              /* MCS Channel n General Purpose 0 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R0. */
    } B;
  } CH1_R0;

  union {                              /* MCS Channel n General Purpose 1 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R1. */
    } B;
  } CH1_R1;

  union {                              /* MCS Channel n General Purpose 2 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R2. */
    } B;
  } CH1_R2;

  union {                              /* MCS Channel n General Purpose 3 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R3. */
    } B;
  } CH1_R3;

  union {                              /* MCS Channel n General Purpose 4 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R4. */
    } B;
  } CH1_R4;

  union {                              /* MCS Channel n General Purpose 5 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R5. */
    } B;
  } CH1_R5;

  union {                              /* MCS Channel n General Purpose 6 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R6. */
    } B;
  } CH1_R6;

  union {                              /* MCS Channel n General Purpose 7 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R7. */
    } B;
  } CH1_R7;

  union {                              /* MCS Channel n Control Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t SP_CNT:3;              /* Stack pointer counter value. */
      vuint32_t  :5;
      vuint32_t SAT:1;                 /* Successful ARU transfer bit. */
      vuint32_t CWT:1;                 /* Cancel WURM instruction state. */
      vuint32_t CAT:1;                 /* Cancel ARU transfer state. */
      vuint32_t N:1;                   /* Negative bit state. */
      vuint32_t V:1;                   /* Overflow bit state. */
      vuint32_t Z:1;                   /* Zero bit state. */
      vuint32_t CY:1;                  /* Carry bit state. */
      vuint32_t  :1;
      vuint32_t ERR:1;                 /* Error state. */
      vuint32_t IRQ:1;                 /* Interrupt state. */
      vuint32_t EN:1;                  /* Enable MCS-channel. */
    } B;
  } CH1_CTRL;

  union {                              /* MCS Channel n ARU Control Bit Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t ACB4:1;                /* See ACB0. */
      vuint32_t ACB3:1;                /* See ACB0. */
      vuint32_t ACB2:1;                /* See ACB0. */
      vuint32_t ACB1:1;                /* See ACB0. */
      vuint32_t ACB0:1;                /* ARU Control bit[4:0]. */
    } B;
  } CH1_ACB;

  uint8_t MCS_reserved2[24];
  union {                              /* MCS Channel n Program Counter Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t PC:14;                 /* Current Program Counter. */
    } B;
  } CH1_PC;

  union {                              /* MCS Channel n Interrupt Request Notification Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_IRQ:1;         /* Memory access out of range in channel n. */
      vuint32_t STK_ERR_IRQ:1;         /* Stack counter overflow/underflow of channel n. */
      vuint32_t MCS_IRQ:1;             /* Interrupt request by MCS-channel n. */
    } B;
  } CH1_IRQ_NOTIFY;

  union {                              /* MCS Channel n Interrupt Request Enable Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_IRQ_EN:1;      /* MCS channel n MEM_ERR_IRQ interrupt enable. */
      vuint32_t STK_ERR_IRQ_EN:1;      /* MCS channel n STK_ERR_IRQ interrupt enable. */
      vuint32_t MCS_IRQ_EN:1;          /* MCS channel n MCS_IRQ interrupt enable. */
    } B;
  } CH1_IRQ_EN;

  union {                              /* MCS Channel n Force Interrupt Request Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t TRG_MEM_ERR_IRQ:1;     /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register by software. */
      vuint32_t TRG_STK_ERR_IRQ:1;     /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register by software. */
      vuint32_t TRG_MCS_IRQ:1;         /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register */
    } B;
  } CH1_IRQ_FORCINT;

  union {                              /* MCS Channel n Interrupt Request Mode Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH1_IRQ_MODE;

  union {                              /* MCS Channel n Error Interrupt Request Enable register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_EIRQ_EN:1;     /* MCS[i] channel n MEM_ERR_EIRQ error interrupt enable. */
      vuint32_t STK_ERR_EIRQ_EN:1;     /* MCS[i] channel n STK_ERR_IRQ error interrupt enable. */
      vuint32_t MCS_EIRQ_EN:1;         /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register */
    } B;
  } CH1_EIRQ_EN;

  uint8_t MCS_reserved3[40];
  union {                              /* MCS Channel n General Purpose 0 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R0. */
    } B;
  } CH2_R0;

  union {                              /* MCS Channel n General Purpose 1 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R1. */
    } B;
  } CH2_R1;

  union {                              /* MCS Channel n General Purpose 2 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R2. */
    } B;
  } CH2_R2;

  union {                              /* MCS Channel n General Purpose 3 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R3. */
    } B;
  } CH2_R3;

  union {                              /* MCS Channel n General Purpose 4 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R4. */
    } B;
  } CH2_R4;

  union {                              /* MCS Channel n General Purpose 5 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R5. */
    } B;
  } CH2_R5;

  union {                              /* MCS Channel n General Purpose 6 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R6. */
    } B;
  } CH2_R6;

  union {                              /* MCS Channel n General Purpose 7 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R7. */
    } B;
  } CH2_R7;

  union {                              /* MCS Channel n Control Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t SP_CNT:3;              /* Stack pointer counter value. */
      vuint32_t  :5;
      vuint32_t SAT:1;                 /* Successful ARU transfer bit. */
      vuint32_t CWT:1;                 /* Cancel WURM instruction state. */
      vuint32_t CAT:1;                 /* Cancel ARU transfer state. */
      vuint32_t N:1;                   /* Negative bit state. */
      vuint32_t V:1;                   /* Overflow bit state. */
      vuint32_t Z:1;                   /* Zero bit state. */
      vuint32_t CY:1;                  /* Carry bit state. */
      vuint32_t  :1;
      vuint32_t ERR:1;                 /* Error state. */
      vuint32_t IRQ:1;                 /* Interrupt state. */
      vuint32_t EN:1;                  /* Enable MCS-channel. */
    } B;
  } CH2_CTRL;

  union {                              /* MCS Channel n ARU Control Bit Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t ACB4:1;                /* See ACB0. */
      vuint32_t ACB3:1;                /* See ACB0. */
      vuint32_t ACB2:1;                /* See ACB0. */
      vuint32_t ACB1:1;                /* See ACB0. */
      vuint32_t ACB0:1;                /* ARU Control bit[4:0]. */
    } B;
  } CH2_ACB;

  uint8_t MCS_reserved4[24];
  union {                              /* MCS Channel n Program Counter Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t PC:14;                 /* Current Program Counter. */
    } B;
  } CH2_PC;

  union {                              /* MCS Channel n Interrupt Request Notification Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_IRQ:1;         /* Memory access out of range in channel n. */
      vuint32_t STK_ERR_IRQ:1;         /* Stack counter overflow/underflow of channel n. */
      vuint32_t MCS_IRQ:1;             /* Interrupt request by MCS-channel n. */
    } B;
  } CH2_IRQ_NOTIFY;

  union {                              /* MCS Channel n Interrupt Request Enable Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_IRQ_EN:1;      /* MCS channel n MEM_ERR_IRQ interrupt enable. */
      vuint32_t STK_ERR_IRQ_EN:1;      /* MCS channel n STK_ERR_IRQ interrupt enable. */
      vuint32_t MCS_IRQ_EN:1;          /* MCS channel n MCS_IRQ interrupt enable. */
    } B;
  } CH2_IRQ_EN;

  union {                              /* MCS Channel n Force Interrupt Request Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t TRG_MEM_ERR_IRQ:1;     /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register by software. */
      vuint32_t TRG_STK_ERR_IRQ:1;     /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register by software. */
      vuint32_t TRG_MCS_IRQ:1;         /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register */
    } B;
  } CH2_IRQ_FORCINT;

  union {                              /* MCS Channel n Interrupt Request Mode Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH2_IRQ_MODE;

  union {                              /* MCS Channel n Error Interrupt Request Enable register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_EIRQ_EN:1;     /* MCS[i] channel n MEM_ERR_EIRQ error interrupt enable. */
      vuint32_t STK_ERR_EIRQ_EN:1;     /* MCS[i] channel n STK_ERR_IRQ error interrupt enable. */
      vuint32_t MCS_EIRQ_EN:1;         /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register */
    } B;
  } CH2_EIRQ_EN;

  uint8_t MCS_reserved5[40];
  union {                              /* MCS Channel n General Purpose 0 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R0. */
    } B;
  } CH3_R0;

  union {                              /* MCS Channel n General Purpose 1 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R1. */
    } B;
  } CH3_R1;

  union {                              /* MCS Channel n General Purpose 2 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R2. */
    } B;
  } CH3_R2;

  union {                              /* MCS Channel n General Purpose 3 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R3. */
    } B;
  } CH3_R3;

  union {                              /* MCS Channel n General Purpose 4 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R4. */
    } B;
  } CH3_R4;

  union {                              /* MCS Channel n General Purpose 5 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R5. */
    } B;
  } CH3_R5;

  union {                              /* MCS Channel n General Purpose 6 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R6. */
    } B;
  } CH3_R6;

  union {                              /* MCS Channel n General Purpose 7 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R7. */
    } B;
  } CH3_R7;

  union {                              /* MCS Channel n Control Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t SP_CNT:3;              /* Stack pointer counter value. */
      vuint32_t  :5;
      vuint32_t SAT:1;                 /* Successful ARU transfer bit. */
      vuint32_t CWT:1;                 /* Cancel WURM instruction state. */
      vuint32_t CAT:1;                 /* Cancel ARU transfer state. */
      vuint32_t N:1;                   /* Negative bit state. */
      vuint32_t V:1;                   /* Overflow bit state. */
      vuint32_t Z:1;                   /* Zero bit state. */
      vuint32_t CY:1;                  /* Carry bit state. */
      vuint32_t  :1;
      vuint32_t ERR:1;                 /* Error state. */
      vuint32_t IRQ:1;                 /* Interrupt state. */
      vuint32_t EN:1;                  /* Enable MCS-channel. */
    } B;
  } CH3_CTRL;

  union {                              /* MCS Channel n ARU Control Bit Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t ACB4:1;                /* See ACB0. */
      vuint32_t ACB3:1;                /* See ACB0. */
      vuint32_t ACB2:1;                /* See ACB0. */
      vuint32_t ACB1:1;                /* See ACB0. */
      vuint32_t ACB0:1;                /* ARU Control bit[4:0]. */
    } B;
  } CH3_ACB;

  uint8_t MCS_reserved6[24];
  union {                              /* MCS Channel n Program Counter Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t PC:14;                 /* Current Program Counter. */
    } B;
  } CH3_PC;

  union {                              /* MCS Channel n Interrupt Request Notification Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_IRQ:1;         /* Memory access out of range in channel n. */
      vuint32_t STK_ERR_IRQ:1;         /* Stack counter overflow/underflow of channel n. */
      vuint32_t MCS_IRQ:1;             /* Interrupt request by MCS-channel n. */
    } B;
  } CH3_IRQ_NOTIFY;

  union {                              /* MCS Channel n Interrupt Request Enable Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_IRQ_EN:1;      /* MCS channel n MEM_ERR_IRQ interrupt enable. */
      vuint32_t STK_ERR_IRQ_EN:1;      /* MCS channel n STK_ERR_IRQ interrupt enable. */
      vuint32_t MCS_IRQ_EN:1;          /* MCS channel n MCS_IRQ interrupt enable. */
    } B;
  } CH3_IRQ_EN;

  union {                              /* MCS Channel n Force Interrupt Request Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t TRG_MEM_ERR_IRQ:1;     /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register by software. */
      vuint32_t TRG_STK_ERR_IRQ:1;     /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register by software. */
      vuint32_t TRG_MCS_IRQ:1;         /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register */
    } B;
  } CH3_IRQ_FORCINT;

  union {                              /* MCS Channel n Interrupt Request Mode Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH3_IRQ_MODE;

  union {                              /* MCS Channel n Error Interrupt Request Enable register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_EIRQ_EN:1;     /* MCS[i] channel n MEM_ERR_EIRQ error interrupt enable. */
      vuint32_t STK_ERR_EIRQ_EN:1;     /* MCS[i] channel n STK_ERR_IRQ error interrupt enable. */
      vuint32_t MCS_EIRQ_EN:1;         /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register */
    } B;
  } CH3_EIRQ_EN;

  uint8_t MCS_reserved7[40];
  union {                              /* MCS Channel n General Purpose 0 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R0. */
    } B;
  } CH4_R0;

  union {                              /* MCS Channel n General Purpose 1 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R1. */
    } B;
  } CH4_R1;

  union {                              /* MCS Channel n General Purpose 2 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R2. */
    } B;
  } CH4_R2;

  union {                              /* MCS Channel n General Purpose 3 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R3. */
    } B;
  } CH4_R3;

  union {                              /* MCS Channel n General Purpose 4 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R4. */
    } B;
  } CH4_R4;

  union {                              /* MCS Channel n General Purpose 5 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R5. */
    } B;
  } CH4_R5;

  union {                              /* MCS Channel n General Purpose 6 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R6. */
    } B;
  } CH4_R6;

  union {                              /* MCS Channel n General Purpose 7 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R7. */
    } B;
  } CH4_R7;

  union {                              /* MCS Channel n Control Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t SP_CNT:3;              /* Stack pointer counter value. */
      vuint32_t  :5;
      vuint32_t SAT:1;                 /* Successful ARU transfer bit. */
      vuint32_t CWT:1;                 /* Cancel WURM instruction state. */
      vuint32_t CAT:1;                 /* Cancel ARU transfer state. */
      vuint32_t N:1;                   /* Negative bit state. */
      vuint32_t V:1;                   /* Overflow bit state. */
      vuint32_t Z:1;                   /* Zero bit state. */
      vuint32_t CY:1;                  /* Carry bit state. */
      vuint32_t  :1;
      vuint32_t ERR:1;                 /* Error state. */
      vuint32_t IRQ:1;                 /* Interrupt state. */
      vuint32_t EN:1;                  /* Enable MCS-channel. */
    } B;
  } CH4_CTRL;

  union {                              /* MCS Channel n ARU Control Bit Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t ACB4:1;                /* See ACB0. */
      vuint32_t ACB3:1;                /* See ACB0. */
      vuint32_t ACB2:1;                /* See ACB0. */
      vuint32_t ACB1:1;                /* See ACB0. */
      vuint32_t ACB0:1;                /* ARU Control bit[4:0]. */
    } B;
  } CH4_ACB;

  uint8_t MCS_reserved8[24];
  union {                              /* MCS Channel n Program Counter Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t PC:14;                 /* Current Program Counter. */
    } B;
  } CH4_PC;

  union {                              /* MCS Channel n Interrupt Request Notification Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_IRQ:1;         /* Memory access out of range in channel n. */
      vuint32_t STK_ERR_IRQ:1;         /* Stack counter overflow/underflow of channel n. */
      vuint32_t MCS_IRQ:1;             /* Interrupt request by MCS-channel n. */
    } B;
  } CH4_IRQ_NOTIFY;

  union {                              /* MCS Channel n Interrupt Request Enable Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_IRQ_EN:1;      /* MCS channel n MEM_ERR_IRQ interrupt enable. */
      vuint32_t STK_ERR_IRQ_EN:1;      /* MCS channel n STK_ERR_IRQ interrupt enable. */
      vuint32_t MCS_IRQ_EN:1;          /* MCS channel n MCS_IRQ interrupt enable. */
    } B;
  } CH4_IRQ_EN;

  union {                              /* MCS Channel n Force Interrupt Request Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t TRG_MEM_ERR_IRQ:1;     /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register by software. */
      vuint32_t TRG_STK_ERR_IRQ:1;     /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register by software. */
      vuint32_t TRG_MCS_IRQ:1;         /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register */
    } B;
  } CH4_IRQ_FORCINT;

  union {                              /* MCS Channel n Interrupt Request Mode Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH4_IRQ_MODE;

  union {                              /* MCS Channel n Error Interrupt Request Enable register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_EIRQ_EN:1;     /* MCS[i] channel n MEM_ERR_EIRQ error interrupt enable. */
      vuint32_t STK_ERR_EIRQ_EN:1;     /* MCS[i] channel n STK_ERR_IRQ error interrupt enable. */
      vuint32_t MCS_EIRQ_EN:1;         /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register */
    } B;
  } CH4_EIRQ_EN;

  uint8_t MCS_reserved9[40];
  union {                              /* MCS Channel n General Purpose 0 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R0. */
    } B;
  } CH5_R0;

  union {                              /* MCS Channel n General Purpose 1 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R1. */
    } B;
  } CH5_R1;

  union {                              /* MCS Channel n General Purpose 2 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R2. */
    } B;
  } CH5_R2;

  union {                              /* MCS Channel n General Purpose 3 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R3. */
    } B;
  } CH5_R3;

  union {                              /* MCS Channel n General Purpose 4 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R4. */
    } B;
  } CH5_R4;

  union {                              /* MCS Channel n General Purpose 5 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R5. */
    } B;
  } CH5_R5;

  union {                              /* MCS Channel n General Purpose 6 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R6. */
    } B;
  } CH5_R6;

  union {                              /* MCS Channel n General Purpose 7 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R7. */
    } B;
  } CH5_R7;

  union {                              /* MCS Channel n Control Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t SP_CNT:3;              /* Stack pointer counter value. */
      vuint32_t  :5;
      vuint32_t SAT:1;                 /* Successful ARU transfer bit. */
      vuint32_t CWT:1;                 /* Cancel WURM instruction state. */
      vuint32_t CAT:1;                 /* Cancel ARU transfer state. */
      vuint32_t N:1;                   /* Negative bit state. */
      vuint32_t V:1;                   /* Overflow bit state. */
      vuint32_t Z:1;                   /* Zero bit state. */
      vuint32_t CY:1;                  /* Carry bit state. */
      vuint32_t  :1;
      vuint32_t ERR:1;                 /* Error state. */
      vuint32_t IRQ:1;                 /* Interrupt state. */
      vuint32_t EN:1;                  /* Enable MCS-channel. */
    } B;
  } CH5_CTRL;

  union {                              /* MCS Channel n ARU Control Bit Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t ACB4:1;                /* See ACB0. */
      vuint32_t ACB3:1;                /* See ACB0. */
      vuint32_t ACB2:1;                /* See ACB0. */
      vuint32_t ACB1:1;                /* See ACB0. */
      vuint32_t ACB0:1;                /* ARU Control bit[4:0]. */
    } B;
  } CH5_ACB;

  uint8_t MCS_reserved10[24];
  union {                              /* MCS Channel n Program Counter Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t PC:14;                 /* Current Program Counter. */
    } B;
  } CH5_PC;

  union {                              /* MCS Channel n Interrupt Request Notification Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_IRQ:1;         /* Memory access out of range in channel n. */
      vuint32_t STK_ERR_IRQ:1;         /* Stack counter overflow/underflow of channel n. */
      vuint32_t MCS_IRQ:1;             /* Interrupt request by MCS-channel n. */
    } B;
  } CH5_IRQ_NOTIFY;

  union {                              /* MCS Channel n Interrupt Request Enable Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_IRQ_EN:1;      /* MCS channel n MEM_ERR_IRQ interrupt enable. */
      vuint32_t STK_ERR_IRQ_EN:1;      /* MCS channel n STK_ERR_IRQ interrupt enable. */
      vuint32_t MCS_IRQ_EN:1;          /* MCS channel n MCS_IRQ interrupt enable. */
    } B;
  } CH5_IRQ_EN;

  union {                              /* MCS Channel n Force Interrupt Request Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t TRG_MEM_ERR_IRQ:1;     /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register by software. */
      vuint32_t TRG_STK_ERR_IRQ:1;     /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register by software. */
      vuint32_t TRG_MCS_IRQ:1;         /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register */
    } B;
  } CH5_IRQ_FORCINT;

  union {                              /* MCS Channel n Interrupt Request Mode Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH5_IRQ_MODE;

  union {                              /* MCS Channel n Error Interrupt Request Enable register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_EIRQ_EN:1;     /* MCS[i] channel n MEM_ERR_EIRQ error interrupt enable. */
      vuint32_t STK_ERR_EIRQ_EN:1;     /* MCS[i] channel n STK_ERR_IRQ error interrupt enable. */
      vuint32_t MCS_EIRQ_EN:1;         /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register */
    } B;
  } CH5_EIRQ_EN;

  uint8_t MCS_reserved11[40];
  union {                              /* MCS Channel n General Purpose 0 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R0. */
    } B;
  } CH6_R0;

  union {                              /* MCS Channel n General Purpose 1 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R1. */
    } B;
  } CH6_R1;

  union {                              /* MCS Channel n General Purpose 2 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R2. */
    } B;
  } CH6_R2;

  union {                              /* MCS Channel n General Purpose 3 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R3. */
    } B;
  } CH6_R3;

  union {                              /* MCS Channel n General Purpose 4 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R4. */
    } B;
  } CH6_R4;

  union {                              /* MCS Channel n General Purpose 5 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R5. */
    } B;
  } CH6_R5;

  union {                              /* MCS Channel n General Purpose 6 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R6. */
    } B;
  } CH6_R6;

  union {                              /* MCS Channel n General Purpose 7 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R7. */
    } B;
  } CH6_R7;

  union {                              /* MCS Channel n Control Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t SP_CNT:3;              /* Stack pointer counter value. */
      vuint32_t  :5;
      vuint32_t SAT:1;                 /* Successful ARU transfer bit. */
      vuint32_t CWT:1;                 /* Cancel WURM instruction state. */
      vuint32_t CAT:1;                 /* Cancel ARU transfer state. */
      vuint32_t N:1;                   /* Negative bit state. */
      vuint32_t V:1;                   /* Overflow bit state. */
      vuint32_t Z:1;                   /* Zero bit state. */
      vuint32_t CY:1;                  /* Carry bit state. */
      vuint32_t  :1;
      vuint32_t ERR:1;                 /* Error state. */
      vuint32_t IRQ:1;                 /* Interrupt state. */
      vuint32_t EN:1;                  /* Enable MCS-channel. */
    } B;
  } CH6_CTRL;

  union {                              /* MCS Channel n ARU Control Bit Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t ACB4:1;                /* See ACB0. */
      vuint32_t ACB3:1;                /* See ACB0. */
      vuint32_t ACB2:1;                /* See ACB0. */
      vuint32_t ACB1:1;                /* See ACB0. */
      vuint32_t ACB0:1;                /* ARU Control bit[4:0]. */
    } B;
  } CH6_ACB;

  uint8_t MCS_reserved12[24];
  union {                              /* MCS Channel n Program Counter Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t PC:14;                 /* Current Program Counter. */
    } B;
  } CH6_PC;

  union {                              /* MCS Channel n Interrupt Request Notification Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_IRQ:1;         /* Memory access out of range in channel n. */
      vuint32_t STK_ERR_IRQ:1;         /* Stack counter overflow/underflow of channel n. */
      vuint32_t MCS_IRQ:1;             /* Interrupt request by MCS-channel n. */
    } B;
  } CH6_IRQ_NOTIFY;

  union {                              /* MCS Channel n Interrupt Request Enable Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_IRQ_EN:1;      /* MCS channel n MEM_ERR_IRQ interrupt enable. */
      vuint32_t STK_ERR_IRQ_EN:1;      /* MCS channel n STK_ERR_IRQ interrupt enable. */
      vuint32_t MCS_IRQ_EN:1;          /* MCS channel n MCS_IRQ interrupt enable. */
    } B;
  } CH6_IRQ_EN;

  union {                              /* MCS Channel n Force Interrupt Request Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t TRG_MEM_ERR_IRQ:1;     /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register by software. */
      vuint32_t TRG_STK_ERR_IRQ:1;     /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register by software. */
      vuint32_t TRG_MCS_IRQ:1;         /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register */
    } B;
  } CH6_IRQ_FORCINT;

  union {                              /* MCS Channel n Interrupt Request Mode Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH6_IRQ_MODE;

  union {                              /* MCS Channel n Error Interrupt Request Enable register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_EIRQ_EN:1;     /* MCS[i] channel n MEM_ERR_EIRQ error interrupt enable. */
      vuint32_t STK_ERR_EIRQ_EN:1;     /* MCS[i] channel n STK_ERR_IRQ error interrupt enable. */
      vuint32_t MCS_EIRQ_EN:1;         /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register */
    } B;
  } CH6_EIRQ_EN;

  uint8_t MCS_reserved13[40];
  union {                              /* MCS Channel n General Purpose 0 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R0. */
    } B;
  } CH7_R0;

  union {                              /* MCS Channel n General Purpose 1 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R1. */
    } B;
  } CH7_R1;

  union {                              /* MCS Channel n General Purpose 2 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R2. */
    } B;
  } CH7_R2;

  union {                              /* MCS Channel n General Purpose 3 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R3. */
    } B;
  } CH7_R3;

  union {                              /* MCS Channel n General Purpose 4 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R4. */
    } B;
  } CH7_R4;

  union {                              /* MCS Channel n General Purpose 5 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R5. */
    } B;
  } CH7_R5;

  union {                              /* MCS Channel n General Purpose 6 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R6. */
    } B;
  } CH7_R6;

  union {                              /* MCS Channel n General Purpose 7 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R7. */
    } B;
  } CH7_R7;

  union {                              /* MCS Channel n Control Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t SP_CNT:3;              /* Stack pointer counter value. */
      vuint32_t  :5;
      vuint32_t SAT:1;                 /* Successful ARU transfer bit. */
      vuint32_t CWT:1;                 /* Cancel WURM instruction state. */
      vuint32_t CAT:1;                 /* Cancel ARU transfer state. */
      vuint32_t N:1;                   /* Negative bit state. */
      vuint32_t V:1;                   /* Overflow bit state. */
      vuint32_t Z:1;                   /* Zero bit state. */
      vuint32_t CY:1;                  /* Carry bit state. */
      vuint32_t  :1;
      vuint32_t ERR:1;                 /* Error state. */
      vuint32_t IRQ:1;                 /* Interrupt state. */
      vuint32_t EN:1;                  /* Enable MCS-channel. */
    } B;
  } CH7_CTRL;

  union {                              /* MCS Channel n ARU Control Bit Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t ACB4:1;                /* See ACB0. */
      vuint32_t ACB3:1;                /* See ACB0. */
      vuint32_t ACB2:1;                /* See ACB0. */
      vuint32_t ACB1:1;                /* See ACB0. */
      vuint32_t ACB0:1;                /* ARU Control bit[4:0]. */
    } B;
  } CH7_ACB;

  uint8_t MCS_reserved14[24];
  union {                              /* MCS Channel n Program Counter Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t PC:14;                 /* Current Program Counter. */
    } B;
  } CH7_PC;

  union {                              /* MCS Channel n Interrupt Request Notification Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_IRQ:1;         /* Memory access out of range in channel n. */
      vuint32_t STK_ERR_IRQ:1;         /* Stack counter overflow/underflow of channel n. */
      vuint32_t MCS_IRQ:1;             /* Interrupt request by MCS-channel n. */
    } B;
  } CH7_IRQ_NOTIFY;

  union {                              /* MCS Channel n Interrupt Request Enable Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_IRQ_EN:1;      /* MCS channel n MEM_ERR_IRQ interrupt enable. */
      vuint32_t STK_ERR_IRQ_EN:1;      /* MCS channel n STK_ERR_IRQ interrupt enable. */
      vuint32_t MCS_IRQ_EN:1;          /* MCS channel n MCS_IRQ interrupt enable. */
    } B;
  } CH7_IRQ_EN;

  union {                              /* MCS Channel n Force Interrupt Request Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t TRG_MEM_ERR_IRQ:1;     /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register by software. */
      vuint32_t TRG_STK_ERR_IRQ:1;     /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register by software. */
      vuint32_t TRG_MCS_IRQ:1;         /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register */
    } B;
  } CH7_IRQ_FORCINT;

  union {                              /* MCS Channel n Interrupt Request Mode Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH7_IRQ_MODE;

  union {                              /* MCS Channel n Error Interrupt Request Enable register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_EIRQ_EN:1;     /* MCS[i] channel n MEM_ERR_EIRQ error interrupt enable. */
      vuint32_t STK_ERR_EIRQ_EN:1;     /* MCS[i] channel n STK_ERR_IRQ error interrupt enable. */
      vuint32_t MCS_EIRQ_EN:1;         /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register */
    } B;
  } CH7_EIRQ_EN;
};


/* ============================================================================
   =============================== Module: GTM_MON ============================
   ============================================================================ */

struct GTM_MON_tag {
  union {                              /* Monitor Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t MCS6_ERR:1;            /* See MCS0_ERR. */
      vuint32_t MCS5_ERR:1;            /* See MCS0_ERR. */
      vuint32_t MCS4_ERR:1;            /* See MCS0_ERR. */
      vuint32_t MCS3_ERR:1;            /* See MCS0_ERR. */
      vuint32_t MCS2_ERR:1;            /* See MCS0_ERR. */
      vuint32_t MCS1_ERR:1;            /* See MCS0_ERR. */
      vuint32_t MCS0_ERR:1;            /* Error detected at corresponding MCS. */
      vuint32_t  :3;
      vuint32_t CMP_ERR:1;             /* Error detected at CMP. */
      vuint32_t  :3;
      vuint32_t ACT_CMUFX4:1;          /* See ACT_CMUFX0. */
      vuint32_t ACT_CMUFX3:1;          /* See ACT_CMUFX0. */
      vuint32_t ACT_CMUFX2:1;          /* See ACT_CMUFX0. */
      vuint32_t ACT_CMUFX1:1;          /* See ACT_CMUFX0. */
      vuint32_t ACT_CMUFX0:1;          /* Corresponding CMU_CLKFX activity. */
      vuint32_t ACT_CMU7:1;            /* See ACT_CMU0. */
      vuint32_t ACT_CMU6:1;            /* See ACT_CMU0. */
      vuint32_t ACT_CMU5:1;            /* See ACT_CMU0. */
      vuint32_t ACT_CMU4:1;            /* See ACT_CMU0. */
      vuint32_t ACT_CMU3:1;            /* See ACT_CMU0. */
      vuint32_t ACT_CMU2:1;            /* See ACT_CMU0. */
      vuint32_t ACT_CMU1:1;            /* See ACT_CMU0. */
      vuint32_t ACT_CMU0:1;            /* Corresponding CMU_CLK activity. */
    } B;
  } STATUS;

  union {                              /* Monitor Acitivity 0 */
    vuint32_t R;
    struct {
      vuint32_t MCA_3_7:1;             /* See MCA_3_0. */
      vuint32_t MCA_3_6:1;             /* See MCA_3_0. */
      vuint32_t MCA_3_5:1;             /* See MCA_3_0. */
      vuint32_t MCA_3_4:1;             /* See MCA_3_0. */
      vuint32_t MCA_3_3:1;             /* See MCA_3_0. */
      vuint32_t MCA_3_2:1;             /* See MCA_3_0. */
      vuint32_t MCA_3_1:1;             /* See MCA_3_0. */
      vuint32_t MCA_3_0:1;             /* Activity of check performed in module MCS[3] at corresponding channel. */
      vuint32_t MCA_2_7:1;             /* See MCA_2_0. */
      vuint32_t MCA_2_6:1;             /* See MCA_2_0. */
      vuint32_t MCA_2_5:1;             /* See MCA_2_0. */
      vuint32_t MCA_2_4:1;             /* See MCA_2_0. */
      vuint32_t MCA_2_3:1;             /* See MCA_2_0. */
      vuint32_t MCA_2_2:1;             /* See MCA_2_0. */
      vuint32_t MCA_2_1:1;             /* See MCA_2_0. */
      vuint32_t MCA_2_0:1;             /* Activity of check performed in module MCS[2] at corresponding channel. */
      vuint32_t MCA_1_7:1;             /* See MCA_1_0. */
      vuint32_t MCA_1_6:1;             /* See MCA_1_0. */
      vuint32_t MCA_1_5:1;             /* See MCA_1_0. */
      vuint32_t MCA_1_4:1;             /* See MCA_1_0. */
      vuint32_t MCA_1_3:1;             /* See MCA_1_0. */
      vuint32_t MCA_1_2:1;             /* See MCA_1_0. */
      vuint32_t MCA_1_1:1;             /* See MCA_1_0. */
      vuint32_t MCA_1_0:1;             /* Activity of check performed in module MCS[1] at corresponding channel. */
      vuint32_t MCA_0_7:1;             /* See MCA_0_0. */
      vuint32_t MCA_0_6:1;             /* See MCA_0_0. */
      vuint32_t MCA_0_5:1;             /* See MCA_0_0. */
      vuint32_t MCA_0_4:1;             /* See MCA_0_0. */
      vuint32_t MCA_0_3:1;             /* See MCA_0_0. */
      vuint32_t MCA_0_2:1;             /* See MCA_0_0. */
      vuint32_t MCA_0_1:1;             /* See MCA_0_0. */
      vuint32_t MCA_0_0:1;             /* Activity of check performed in module MCS[0] at corresponding channel. */
    } B;
  } ACTIVITY_0;

  union {                              /* Monitor Acitivity 1 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t MCA_6_7:1;             /* See MCA_6_0. */
      vuint32_t MCA_6_6:1;             /* See MCA_6_0. */
      vuint32_t MCA_6_5:1;             /* See MCA_6_0. */
      vuint32_t MCA_6_4:1;             /* See MCA_6_0. */
      vuint32_t MCA_6_3:1;             /* See MCA_6_0. */
      vuint32_t MCA_6_2:1;             /* See MCA_6_0. */
      vuint32_t MCA_6_1:1;             /* See MCA_6_0. */
      vuint32_t MCA_6_0:1;             /* Activity of check performed in module MCS[6] at corresponding channel. */
      vuint32_t MCA_5_7:1;             /* See MCA_5_0. */
      vuint32_t MCA_5_6:1;             /* See MCA_5_0. */
      vuint32_t MCA_5_5:1;             /* See MCA_5_0. */
      vuint32_t MCA_5_4:1;             /* See MCA_5_0. */
      vuint32_t MCA_5_3:1;             /* See MCA_5_0. */
      vuint32_t MCA_5_2:1;             /* See MCA_5_0. */
      vuint32_t MCA_5_1:1;             /* See MCA_5_0. */
      vuint32_t MCA_5_0:1;             /* Activity of check performed in module MCS[5] at corresponding channel. */
      vuint32_t MCA_4_7:1;             /* See MCA_4_0. */
      vuint32_t MCA_4_6:1;             /* See MCA_4_0. */
      vuint32_t MCA_4_5:1;             /* See MCA_4_0. */
      vuint32_t MCA_4_4:1;             /* See MCA_4_0. */
      vuint32_t MCA_4_3:1;             /* See MCA_4_0. */
      vuint32_t MCA_4_2:1;             /* See MCA_4_0. */
      vuint32_t MCA_4_1:1;             /* See MCA_4_0. */
      vuint32_t MCA_4_0:1;             /* Activity of check performed in module MCS[4] at corresponding channel. */
    } B;
  } ACTIVITY_1;
};


/* ============================================================================
   =============================== Module: GTM_SPE ============================
   ============================================================================ */

struct GTM_SPE_tag {
  union {                              /* SPE Control Status Register */
    vuint32_t R;
    struct {
      vuint32_t FSOL:8;                /* Fast Shut-Off Level for TOM[i] channel 0 to 7. */
      vuint32_t  :1;
      vuint32_t NIP:3;                 /* New input pattern that was detected. */
      vuint32_t PDIR:1;                /* Previous rotation direction. */
      vuint32_t PIP:3;                 /* Previous input pattern that was detected by a regular input pattern change. */
      vuint32_t ADIR:1;                /* Actual rotation direction. */
      vuint32_t AIP:3;                 /* Actual input pattern that was detected by a regular input pattern change. */
      vuint32_t  :1;
      vuint32_t SPE_PAT_PTR:3;         /* Pattern selector for TOM output signals. */
      vuint32_t FSOM:1;                /* Fast Shut-Off Mode. */
      vuint32_t TIM_SEL:1;             /* Select TIM input signal. */
      vuint32_t TRIG_SEL:2;            /* Select trigger input signal. */
      vuint32_t SIE2:1;                /* SPE Input enable for TIM_CHz(48). */
      vuint32_t SIE1:1;                /* SPE Input enable for TIM_CHy(48). */
      vuint32_t SIE0:1;                /* SPE Input enable for TIM_CHx(48). */
      vuint32_t EN:1;                  /* SPE Submodule enable. */
    } B;
  } CTRL_STAT;

  union {                              /* SPE Input Pattern Register */
    vuint32_t R;
    struct {
      vuint32_t IP7_PAT:3;             /* Input pattern 7. */
      vuint32_t IP7_VAL:1;             /* Input pattern 7 is a valid pattern. */
      vuint32_t IP6_PAT:3;             /* Input pattern 6. */
      vuint32_t IP6_VAL:1;             /* Input pattern 6 is a valid pattern. */
      vuint32_t IP5_PAT:3;             /* Input pattern 5. */
      vuint32_t IP5_VAL:1;             /* Input pattern 5 is a valid pattern. */
      vuint32_t IP4_PAT:3;             /* Input pattern 4. */
      vuint32_t IP4_VAL:1;             /* Input pattern 4 is a valid pattern. */
      vuint32_t IP3_PAT:3;             /* Input pattern 3. */
      vuint32_t IP3_VAL:1;             /* Input pattern 3 is a valid pattern. */
      vuint32_t IP2_PAT:3;             /* Input pattern 2. */
      vuint32_t IP2_VAL:1;             /* Input pattern 2 is a valid pattern. */
      vuint32_t IP1_PAT:3;
      vuint32_t IP1_VAL:1;             /* Input pattern 1 is a valid pattern. */
      vuint32_t IP0_PAT:3;             /* Input pattern 0. */
      vuint32_t IP0_VAL:1;             /* Input pattern 0 is a valid pattern. */
    } B;
  } PAT;

  union {                              /* SPE Output Pattern n Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SPE_OUT_PAT:16;        /* SPE output control value for TOM_CH0 to TOM_CH7 SPE_OUT_PAT[n+1:n] defines output select signal of TOM[i]_CH[n]. */
    } B;
  } OUT_PAT[8];

  union {                              /* SPE Output Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;                  /* Reserved. */
      vuint32_t SPE_OUT_CTRL:16;       /* SPE output control value for TOM_CH0 to TOM_CH7. */
    } B;
  } OUT_CTRL;

  union {                              /* SPE Interrupt Request Notify Register */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t SPE_RCMP:1;            /* SPE revolution counter match event. */
      vuint32_t SPE_BIS:1;             /* Bouncing input signal detected. */
      vuint32_t SPE_PERR:1;            /* Wrong or invalid pattern detected at input. */
      vuint32_t SPE_DCHG:1;            /* SPE_DIR bit changed on behalf of new input pattern. */
      vuint32_t SPE_NIPD:1;            /* New input pattern interrupt occurred. */
    } B;
  } IRQ_NOTIFY;

  union {                              /* SPE Interrupt Request Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :27;                  /* Reserved. */
      vuint32_t SPE_RCMP_IRQ_EN:1;     /* SPE_RCMP_IRQ interrupt enable. */
      vuint32_t SPE_BIS_IRQ_EN:1;      /* SPE_BIS_IRQ interrupt enable. */
      vuint32_t SPE_PERR_IRQ_EN:1;     /* SPE_PERR_IRQ interrupt enable. */
      vuint32_t SPE_DCHG_IRQ_EN:1;     /* SPE_DCHG_IRQ interrupt enable. */
      vuint32_t SPE_NIPD_IRQ_EN:1;     /* SPE_NIPD_IRQ interrupt enable. */
    } B;
  } IRQ_EN;

  union {                              /* SPE Interrupt Request Force Interrupt Register */
    vuint32_t R;
    struct {
      vuint32_t  :27;                  /* Reserved. */
      vuint32_t TRG_SPE_RCMP:1;        /* Force interrupt of SPE_RCMP. */
      vuint32_t TRG_SPE_BIS:1;         /* Force interrupt of SPE_BIS. */
      vuint32_t TRG_SPE_PERR:1;        /* Force interrupt of SPE_PERR. */
      vuint32_t TRG_SPE_DCHG:1;        /* Force interrupt of SPE_DCHG. */
      vuint32_t TRG_SPE_NIPD:1;        /* Force interrupt of SPE_NIPD. */
    } B;
  } IRQ_FORCINT;

  union {                              /* SPE Interrupt Request Mode Register */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } IRQ_MODE;

  union {                              /* SPE Error Interrupt Request Enable register */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t SPE_RCMP_EIRQ_EN:1;    /* SPE_BIS_EIRQ error interrupt enable. */
      vuint32_t SPE_BIS_EIRQ_EN:1;     /* SPE_BIS_EIRQ error interrupt enable. */
      vuint32_t SPE_PERR_EIRQ_EN:1;    /* SPE_PERR_EIRQ interrupt enable. */
      vuint32_t SPE_DCHG_EIRQ_EN:1;
      vuint32_t SPE_NIPD_EIRQ_EN:1;    /* SPE_NIPD_EIRQ interrupt enable. */
    } B;
  } EIRQ_EN;

  union {                              /* SPE Revolution Counter register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t REV_CNT:24;            /* Input signal revolution counter. */
    } B;
  } REV_CNT;

  union {                              /* SPE Revolution Counter Compare register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t REV_CMP:24;            /* Input signal revolution counter compare value. */
    } B;
  } REV_CMP;
};


/* ============================================================================
   =============================== Module: GTM_TBU ============================
   ============================================================================ */

struct GTM_TBU_tag {
  union {                              /* TBU Global Channel Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t ENDIS_CH2:2;           /* TBU channel 2 enable/disable control. */
      vuint32_t ENDIS_CH1:2;           /* TBU channel 1 enable/disable control. */
      vuint32_t ENDIS_CH0:2;           /* TBU channel 0 enable/disable control. */
    } B;
  } CHEN;

  union {                              /* TBU Channel 0 Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t CH_CLK_SRC:3;          /* Clock source for channel 0. */
      vuint32_t LOW_RES:1;             /* TBU_CH0_BASE register resolution. */
    } B;
  } CH0_CTRL;

  union {                              /* TBU Channel 0 Base Register */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t BASE:27;               /* Time base value for channel 0. */
    } B;
  } CH0_BASE;

  union {                              /* TBU Channel 1 Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t CH_CLK_SRC:3;          /* Clock source for channel time base counter. */
      vuint32_t CH_MODE:1;             /* Channel mode. */
    } B;
  } CH1_CTRL;

  union {                              /* TBU Channel 1 Base Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t BASE:24;               /* Time base value for the channel. */
    } B;
  } CH1_BASE;

  union {                              /* TBU Channel 2 Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t CH_CLK_SRC:3;          /* Clock source for channel time base counter. */
      vuint32_t CH_MODE:1;             /* Channel mode. */
    } B;
  } CH2_CTRL;

  union {                              /* TBU Channel 2 Base Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t BASE:24;               /* Time base value for the channel. */
    } B;
  } CH2_BASE;
};


/* ============================================================================
   =============================== Module: GTM_TIM ============================
   ============================================================================ */

struct GTM_TIM_tag {
  union {                              /* TIM Channel n General Purpose Register 0, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t GPR0:24;               /* Input signal characteristic parameter 0. */
    } B;
  } CH0_GPR0;

  union {                              /* TIM Channel n General Purpose Register 1, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t GPR1:24;               /* Input signal characteristic parameter 1. */
    } B;
  } CH0_GPR1;

  union {                              /* TIM Channel n Count Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CNT:24;                /* Actual SMU counter value. */
    } B;
  } CH0_CNT;

  union {                              /* TIM Channel n Edge Counter Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t ECNT:16;               /* Edge counter. */
    } B;
  } CH0_ECNT;

  union {                              /* TIM Channel n Counter Shadow Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t CNTS:24;               /* Counter shadow register. */
    } B;
  } CH0_CNTS;

  union {                              /* TIM Channel n TDUC Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TO_CNT:8;              /* Current Timeout value for channel n (n:0...m-1). */
    } B;
  } CH0_TDUC;

  union {                              /* TIM Channel n TDUV Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t TCS:3;                 /* Timeout Clock selection. */
      vuint32_t  :20;
      vuint32_t TOV:8;                 /* Time out duration for channel n (n:0...m-1). */
    } B;
  } CH0_TDUV;

  union {                              /* TIM Channel n Filter Parameter 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FLT_RE:24;             /* Filter parameter for rising edge. */
    } B;
  } CH0_FLT_RE;

  union {                              /* TIM Channel n Filter Parameter 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FLT_FE:24;             /* Filter parameter for falling edge. */
    } B;
  } CH0_FLT_FE;

  union {                              /* TIM Channel n Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t TOCTRL:2;              /* Timeout control */
      vuint32_t EGPR1_SEL:1;           /* Extension of GPR1_SEL bit field. */
      vuint32_t EGPR0_SEL:1;           /* Extension of GPR0_SEL bit field. */
      vuint32_t FR_ECNT_OFL:1;         /* Extended Edge counter overflow behavior. */
      vuint32_t CLK_SEL:3;             /* CMU clock source select for channel. */
      vuint32_t FLT_CTR_FE:1;          /* Filter counter mode for falling edge. */
      vuint32_t FLT_MODE_FE:1;         /* Filter mode for falling edge. */
      vuint32_t FLT_CTR_RE:1;          /* Filter counter mode for rising edge. */
      vuint32_t FLT_MODE_RE:1;         /* Filter mode for rising edge. */
      vuint32_t EXT_CAP_EN:1;          /* Enables external capture mode. The selected TIM mode is only sensitive to external capture pulses, the input event changes are ignored. */
      vuint32_t FLT_CNT_FRQ:2;         /* Filter counter frequency select. */
      vuint32_t FLT_EN:1;              /* Filter enable for channel n. */
      vuint32_t ECNT_RESET:1;          /* Enables resetting the ECNT counter in periodic sampling mode. */
      vuint32_t ISL:1;                 /* Ignore Signal Level. */
      vuint32_t DSL:1;                 /* Signal level control. */
      vuint32_t CNTS_SEL:1;            /* Selection for CNTS register. */
      vuint32_t GPR1_SEL:2;            /* Selection for GPR1 register. */
      vuint32_t GPR0_SEL:2;            /* Selection for GPR0 register. */
      vuint32_t TBU0_SEL:1;            /* TBU_TS0 bits input select for TIM_CHn_GPRz (z: 0, 1) */
      vuint32_t CICTRL:1;              /* Channel Input Control. */
      vuint32_t ARU_EN:1;              /* GPR0 and GPR1 register values routed to ARU. */
      vuint32_t OSM:1;                 /* One-shot mode. */
      vuint32_t TIM_MODE:3;            /* TIM channel n mode. */
      vuint32_t TIM_EN:1;              /* TIM channel n enable. */
    } B;
  } CH0_CTRL;

  union {                              /* TIM Channel n External Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t EXT_CAP_SRC:3;         /* Defines selected source for triggering the EXT_CAPTURE functionality. */
    } B;
  } CH0_ECTRL;

  union {                              /* TIM Channel n Interrupt Request Notification Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET:1;           /* Glitch detected on channel n. */
      vuint32_t TODET:1;               /* Timeout reached for input signal of channel n. */
      vuint32_t GPROFL:1;              /* GPR0 and GPR1 data overflow, old data not read out before new data has arrived at input pin. */
      vuint32_t CNTOFL:1;              /* SMU CNT counter overflow of channel n. */
      vuint32_t ECNTOFL:1;             /* ECNT counter overflow of channel n. */
      vuint32_t NEWVAL:1;              /* New measurement value detected by in channel n */
    } B;
  } CH0_IRQ_NOTIFY;

  union {                              /* TIM Channel n Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET_IRQ_EN:1;    /* TIM_GLITCHDETx_IRQ interrupt enable. */
      vuint32_t TODET_IRQ_EN:1;        /* TIM_TODETn_IRQ interrupt enable. */
      vuint32_t GPROFL_IRQ_EN:1;       /* TIM_GPROFL_IRQ interrupt enable. */
      vuint32_t CNTOFL_IRQ_EN:1;       /* TIM_CNTOFLn_IRQ interrupt enable. */
      vuint32_t ECNTOFL_IRQ_EN:1;      /* TIM_ECNTOFLn_IRQ interrupt enable. */
      vuint32_t NEWVAL_IRQ_EN:1;       /* TIM_NEWVALn_IRQ interrupt enable. */
    } B;
  } CH0_IRQ_EN;

  union {                              /* TIM Channel n Force Interrupt Request Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t TRG_GLITCHDET:1;       /* Trigger bit TIM_CHn_IRQ_NOTIFY[GLITCHDET] by software. */
      vuint32_t TRG_TODET:1;           /* Trigger bit TIM_CHn_IRQ_NOTIFY[TODET] by software. */
      vuint32_t TRG_GPROFL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[GPROFL] by software. */
      vuint32_t TRG_CNTOFL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[CNTOFL] by software. */
      vuint32_t TRG_ECNTOFL:1;         /* Trigger bit TIM_CHn_IRQ_NOTIFY[ECNTOFL] by software. */
      vuint32_t TRG_NEWVAL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[NEWVAL] by software. */
    } B;
  } CH0_IRQ_FORCINT;

  union {                              /* TIM Channel n Interrupt Request Mode Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH0_IRQ_MODE;

  union {                              /* TIM Channel Error Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET_EIRQ_EN:1;   /* TIM_GLITCHDETx_IRQ interrupt enable. */
      vuint32_t TODET_EIRQ_EN:1;       /* TIM_TODETx_IRQ interrupt enable. */
      vuint32_t GPROFL_EIRQ_EN:1;      /* TIM_GPROFL_IRQ interrupt enable. */
      vuint32_t CNTOFL_EIRQ_EN:1;      /* TIM_CNTOFLx_IRQ interrupt enable. */
      vuint32_t ECNTOFL_EIRQ_EN:1;     /* TIM_ECNTOFLx_IRQ interrupt enable. */
      vuint32_t NEWVAL_EIRQ_EN:1;      /* TIM_NEWVALx_EIRQ error interrupt enable. */
    } B;
  } CH0_EIRQ_EN;

  uint8_t TIM_reserved0[56];
  union {                              /* TIM Input Source Register */
    vuint32_t R;
    struct {
      vuint32_t MODE_7:2;              /* Input source to Channel 7 */
      vuint32_t VAL_7:2;               /* Value to be fed to Channel 7 */
      vuint32_t MODE_6:2;              /* Input source to Channel 6 */
      vuint32_t VAL_6:2;               /* Value to be fed to Channel 6 */
      vuint32_t MODE_5:2;              /* Input source to Channel 5 */
      vuint32_t VAL_5:2;               /* Value to be fed to Channel 5 */
      vuint32_t MODE_4:2;              /* Input source to Channel 4 */
      vuint32_t VAL_4:2;               /* Value to be fed to Channel 4 */
      vuint32_t MODE_3:2;              /* Input source to Channel 3 */
      vuint32_t VAL_3:2;               /* Value to be fed to Channel 3 */
      vuint32_t MODE_2:2;              /* Input source to Channel 2 */
      vuint32_t VAL_2:2;               /* Value to be fed to Channel 2 */
      vuint32_t MODE_1:2;              /* Input source to Channel 1 */
      vuint32_t VAL_1:2;               /* Value to be fed to Channel 1 */
      vuint32_t MODE_0:2;              /* Input source to Channel 0 */
      vuint32_t VAL_0:2;               /* Value to be fed to Channel 0 */
    } B;
  } IN_SRC;

  union {                              /* TIM Channel Reset Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t RST_CH7:1;             /* Software reset of channel 7. */
      vuint32_t RST_CH6:1;             /* Software reset of channel 6. */
      vuint32_t RST_CH5:1;             /* Software reset of channel 5. */
      vuint32_t RST_CH4:1;             /* Software reset of channel 4. */
      vuint32_t RST_CH3:1;             /* Software reset of channel 3. */
      vuint32_t RST_CH2:1;             /* Software reset of channel 2. */
      vuint32_t RST_CH1:1;             /* Software reset of channel 1. */
      vuint32_t RST_CH0:1;             /* Software reset of channel 0. */
    } B;
  } RST;

  union {                              /* TIM Channel n General Purpose Register 0, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t GPR0:24;               /* Input signal characteristic parameter 0. */
    } B;
  } CH1_GPR0;

  union {                              /* TIM Channel n General Purpose Register 1, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t GPR1:24;               /* Input signal characteristic parameter 1. */
    } B;
  } CH1_GPR1;

  union {                              /* TIM Channel n Count Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CNT:24;                /* Actual SMU counter value. */
    } B;
  } CH1_CNT;

  union {                              /* TIM Channel n Edge Counter Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t ECNT:16;               /* Edge counter. */
    } B;
  } CH1_ECNT;

  union {                              /* TIM Channel n Counter Shadow Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t CNTS:24;               /* Counter shadow register. */
    } B;
  } CH1_CNTS;

  union {                              /* TIM Channel n TDUC Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TO_CNT:8;              /* Current Timeout value for channel n (n:0...m-1). */
    } B;
  } CH1_TDUC;

  union {                              /* TIM Channel n TDUV Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t TCS:3;                 /* Timeout Clock selection. */
      vuint32_t  :20;
      vuint32_t TOV:8;                 /* Time out duration for channel n (n:0...m-1). */
    } B;
  } CH1_TDUV;

  union {                              /* TIM Channel n Filter Parameter 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FLT_RE:24;             /* Filter parameter for rising edge. */
    } B;
  } CH1_FLT_RE;

  union {                              /* TIM Channel n Filter Parameter 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FLT_FE:24;             /* Filter parameter for falling edge. */
    } B;
  } CH1_FLT_FE;

  union {                              /* TIM Channel n Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t TOCTRL:2;              /* Timeout control */
      vuint32_t EGPR1_SEL:1;           /* Extension of GPR1_SEL bit field. */
      vuint32_t EGPR0_SEL:1;           /* Extension of GPR0_SEL bit field. */
      vuint32_t FR_ECNT_OFL:1;         /* Extended Edge counter overflow behavior. */
      vuint32_t CLK_SEL:3;             /* CMU clock source select for channel. */
      vuint32_t FLT_CTR_FE:1;          /* Filter counter mode for falling edge. */
      vuint32_t FLT_MODE_FE:1;         /* Filter mode for falling edge. */
      vuint32_t FLT_CTR_RE:1;          /* Filter counter mode for rising edge. */
      vuint32_t FLT_MODE_RE:1;         /* Filter mode for rising edge. */
      vuint32_t EXT_CAP_EN:1;          /* Enables external capture mode. The selected TIM mode is only sensitive to external capture pulses, the input event changes are ignored. */
      vuint32_t FLT_CNT_FRQ:2;         /* Filter counter frequency select. */
      vuint32_t FLT_EN:1;              /* Filter enable for channel n. */
      vuint32_t ECNT_RESET:1;          /* Enables resetting the ECNT counter in periodic sampling mode. */
      vuint32_t ISL:1;                 /* Ignore Signal Level. */
      vuint32_t DSL:1;                 /* Signal level control. */
      vuint32_t CNTS_SEL:1;            /* Selection for CNTS register. */
      vuint32_t GPR1_SEL:2;            /* Selection for GPR1 register. */
      vuint32_t GPR0_SEL:2;            /* Selection for GPR0 register. */
      vuint32_t TBU0_SEL:1;            /* TBU_TS0 bits input select for TIM_CHn_GPRz (z: 0, 1) */
      vuint32_t CICTRL:1;              /* Channel Input Control. */
      vuint32_t ARU_EN:1;              /* GPR0 and GPR1 register values routed to ARU. */
      vuint32_t OSM:1;                 /* One-shot mode. */
      vuint32_t TIM_MODE:3;            /* TIM channel n mode. */
      vuint32_t TIM_EN:1;              /* TIM channel n enable. */
    } B;
  } CH1_CTRL;

  union {                              /* TIM Channel n External Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t EXT_CAP_SRC:3;         /* Defines selected source for triggering the EXT_CAPTURE functionality. */
    } B;
  } CH1_ECTRL;

  union {                              /* TIM Channel n Interrupt Request Notification Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET:1;           /* Glitch detected on channel n. */
      vuint32_t TODET:1;               /* Timeout reached for input signal of channel n. */
      vuint32_t GPROFL:1;              /* GPR0 and GPR1 data overflow, old data not read out before new data has arrived at input pin. */
      vuint32_t CNTOFL:1;              /* SMU CNT counter overflow of channel n. */
      vuint32_t ECNTOFL:1;             /* ECNT counter overflow of channel n. */
      vuint32_t NEWVAL:1;              /* New measurement value detected by in channel n */
    } B;
  } CH1_IRQ_NOTIFY;

  union {                              /* TIM Channel n Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET_IRQ_EN:1;    /* TIM_GLITCHDETx_IRQ interrupt enable. */
      vuint32_t TODET_IRQ_EN:1;        /* TIM_TODETn_IRQ interrupt enable. */
      vuint32_t GPROFL_IRQ_EN:1;       /* TIM_GPROFL_IRQ interrupt enable. */
      vuint32_t CNTOFL_IRQ_EN:1;       /* TIM_CNTOFLn_IRQ interrupt enable. */
      vuint32_t ECNTOFL_IRQ_EN:1;      /* TIM_ECNTOFLn_IRQ interrupt enable. */
      vuint32_t NEWVAL_IRQ_EN:1;       /* TIM_NEWVALn_IRQ interrupt enable. */
    } B;
  } CH1_IRQ_EN;

  union {                              /* TIM Channel n Force Interrupt Request Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t TRG_GLITCHDET:1;       /* Trigger bit TIM_CHn_IRQ_NOTIFY[GLITCHDET] by software. */
      vuint32_t TRG_TODET:1;           /* Trigger bit TIM_CHn_IRQ_NOTIFY[TODET] by software. */
      vuint32_t TRG_GPROFL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[GPROFL] by software. */
      vuint32_t TRG_CNTOFL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[CNTOFL] by software. */
      vuint32_t TRG_ECNTOFL:1;         /* Trigger bit TIM_CHn_IRQ_NOTIFY[ECNTOFL] by software. */
      vuint32_t TRG_NEWVAL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[NEWVAL] by software. */
    } B;
  } CH1_IRQ_FORCINT;

  union {                              /* TIM Channel n Interrupt Request Mode Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH1_IRQ_MODE;

  union {                              /* TIM Channel Error Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET_EIRQ_EN:1;   /* TIM_GLITCHDETx_IRQ interrupt enable. */
      vuint32_t TODET_EIRQ_EN:1;       /* TIM_TODETx_IRQ interrupt enable. */
      vuint32_t GPROFL_EIRQ_EN:1;      /* TIM_GPROFL_IRQ interrupt enable. */
      vuint32_t CNTOFL_EIRQ_EN:1;      /* TIM_CNTOFLx_IRQ interrupt enable. */
      vuint32_t ECNTOFL_EIRQ_EN:1;     /* TIM_ECNTOFLx_IRQ interrupt enable. */
      vuint32_t NEWVAL_EIRQ_EN:1;      /* TIM_NEWVALx_EIRQ error interrupt enable. */
    } B;
  } CH1_EIRQ_EN;

  uint8_t TIM_reserved1[64];
  union {                              /* TIM Channel n General Purpose Register 0, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t GPR0:24;               /* Input signal characteristic parameter 0. */
    } B;
  } CH2_GPR0;

  union {                              /* TIM Channel n General Purpose Register 1, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t GPR1:24;               /* Input signal characteristic parameter 1. */
    } B;
  } CH2_GPR1;

  union {                              /* TIM Channel n Count Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CNT:24;                /* Actual SMU counter value. */
    } B;
  } CH2_CNT;

  union {                              /* TIM Channel n Edge Counter Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t ECNT:16;               /* Edge counter. */
    } B;
  } CH2_ECNT;

  union {                              /* TIM Channel n Counter Shadow Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t CNTS:24;               /* Counter shadow register. */
    } B;
  } CH2_CNTS;

  union {                              /* TIM Channel n TDUC Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TO_CNT:8;              /* Current Timeout value for channel n (n:0...m-1). */
    } B;
  } CH2_TDUC;

  union {                              /* TIM Channel n TDUV Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t TCS:3;                 /* Timeout Clock selection. */
      vuint32_t  :20;
      vuint32_t TOV:8;                 /* Time out duration for channel n (n:0...m-1). */
    } B;
  } CH2_TDUV;

  union {                              /* TIM Channel n Filter Parameter 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FLT_RE:24;             /* Filter parameter for rising edge. */
    } B;
  } CH2_FLT_RE;

  union {                              /* TIM Channel n Filter Parameter 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FLT_FE:24;             /* Filter parameter for falling edge. */
    } B;
  } CH2_FLT_FE;

  union {                              /* TIM Channel n Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t TOCTRL:2;              /* Timeout control */
      vuint32_t EGPR1_SEL:1;           /* Extension of GPR1_SEL bit field. */
      vuint32_t EGPR0_SEL:1;           /* Extension of GPR0_SEL bit field. */
      vuint32_t FR_ECNT_OFL:1;         /* Extended Edge counter overflow behavior. */
      vuint32_t CLK_SEL:3;             /* CMU clock source select for channel. */
      vuint32_t FLT_CTR_FE:1;          /* Filter counter mode for falling edge. */
      vuint32_t FLT_MODE_FE:1;         /* Filter mode for falling edge. */
      vuint32_t FLT_CTR_RE:1;          /* Filter counter mode for rising edge. */
      vuint32_t FLT_MODE_RE:1;         /* Filter mode for rising edge. */
      vuint32_t EXT_CAP_EN:1;          /* Enables external capture mode. The selected TIM mode is only sensitive to external capture pulses, the input event changes are ignored. */
      vuint32_t FLT_CNT_FRQ:2;         /* Filter counter frequency select. */
      vuint32_t FLT_EN:1;              /* Filter enable for channel n. */
      vuint32_t ECNT_RESET:1;          /* Enables resetting the ECNT counter in periodic sampling mode. */
      vuint32_t ISL:1;                 /* Ignore Signal Level. */
      vuint32_t DSL:1;                 /* Signal level control. */
      vuint32_t CNTS_SEL:1;            /* Selection for CNTS register. */
      vuint32_t GPR1_SEL:2;            /* Selection for GPR1 register. */
      vuint32_t GPR0_SEL:2;            /* Selection for GPR0 register. */
      vuint32_t TBU0_SEL:1;            /* TBU_TS0 bits input select for TIM_CHn_GPRz (z: 0, 1) */
      vuint32_t CICTRL:1;              /* Channel Input Control. */
      vuint32_t ARU_EN:1;              /* GPR0 and GPR1 register values routed to ARU. */
      vuint32_t OSM:1;                 /* One-shot mode. */
      vuint32_t TIM_MODE:3;            /* TIM channel n mode. */
      vuint32_t TIM_EN:1;              /* TIM channel n enable. */
    } B;
  } CH2_CTRL;

  union {                              /* TIM Channel n External Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t EXT_CAP_SRC:3;         /* Defines selected source for triggering the EXT_CAPTURE functionality. */
    } B;
  } CH2_ECTRL;

  union {                              /* TIM Channel n Interrupt Request Notification Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET:1;           /* Glitch detected on channel n. */
      vuint32_t TODET:1;               /* Timeout reached for input signal of channel n. */
      vuint32_t GPROFL:1;              /* GPR0 and GPR1 data overflow, old data not read out before new data has arrived at input pin. */
      vuint32_t CNTOFL:1;              /* SMU CNT counter overflow of channel n. */
      vuint32_t ECNTOFL:1;             /* ECNT counter overflow of channel n. */
      vuint32_t NEWVAL:1;              /* New measurement value detected by in channel n */
    } B;
  } CH2_IRQ_NOTIFY;

  union {                              /* TIM Channel n Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET_IRQ_EN:1;    /* TIM_GLITCHDETx_IRQ interrupt enable. */
      vuint32_t TODET_IRQ_EN:1;        /* TIM_TODETn_IRQ interrupt enable. */
      vuint32_t GPROFL_IRQ_EN:1;       /* TIM_GPROFL_IRQ interrupt enable. */
      vuint32_t CNTOFL_IRQ_EN:1;       /* TIM_CNTOFLn_IRQ interrupt enable. */
      vuint32_t ECNTOFL_IRQ_EN:1;      /* TIM_ECNTOFLn_IRQ interrupt enable. */
      vuint32_t NEWVAL_IRQ_EN:1;       /* TIM_NEWVALn_IRQ interrupt enable. */
    } B;
  } CH2_IRQ_EN;

  union {                              /* TIM Channel n Force Interrupt Request Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t TRG_GLITCHDET:1;       /* Trigger bit TIM_CHn_IRQ_NOTIFY[GLITCHDET] by software. */
      vuint32_t TRG_TODET:1;           /* Trigger bit TIM_CHn_IRQ_NOTIFY[TODET] by software. */
      vuint32_t TRG_GPROFL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[GPROFL] by software. */
      vuint32_t TRG_CNTOFL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[CNTOFL] by software. */
      vuint32_t TRG_ECNTOFL:1;         /* Trigger bit TIM_CHn_IRQ_NOTIFY[ECNTOFL] by software. */
      vuint32_t TRG_NEWVAL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[NEWVAL] by software. */
    } B;
  } CH2_IRQ_FORCINT;

  union {                              /* TIM Channel n Interrupt Request Mode Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH2_IRQ_MODE;

  union {                              /* TIM Channel Error Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET_EIRQ_EN:1;   /* TIM_GLITCHDETx_IRQ interrupt enable. */
      vuint32_t TODET_EIRQ_EN:1;       /* TIM_TODETx_IRQ interrupt enable. */
      vuint32_t GPROFL_EIRQ_EN:1;      /* TIM_GPROFL_IRQ interrupt enable. */
      vuint32_t CNTOFL_EIRQ_EN:1;      /* TIM_CNTOFLx_IRQ interrupt enable. */
      vuint32_t ECNTOFL_EIRQ_EN:1;     /* TIM_ECNTOFLx_IRQ interrupt enable. */
      vuint32_t NEWVAL_EIRQ_EN:1;      /* TIM_NEWVALx_EIRQ error interrupt enable. */
    } B;
  } CH2_EIRQ_EN;

  uint8_t TIM_reserved2[64];
  union {                              /* TIM Channel n General Purpose Register 0, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t GPR0:24;               /* Input signal characteristic parameter 0. */
    } B;
  } CH3_GPR0;

  union {                              /* TIM Channel n General Purpose Register 1, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t GPR1:24;               /* Input signal characteristic parameter 1. */
    } B;
  } CH3_GPR1;

  union {                              /* TIM Channel n Count Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CNT:24;                /* Actual SMU counter value. */
    } B;
  } CH3_CNT;

  union {                              /* TIM Channel n Edge Counter Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t ECNT:16;               /* Edge counter. */
    } B;
  } CH3_ECNT;

  union {                              /* TIM Channel n Counter Shadow Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t CNTS:24;               /* Counter shadow register. */
    } B;
  } CH3_CNTS;

  union {                              /* TIM Channel n TDUC Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TO_CNT:8;              /* Current Timeout value for channel n (n:0...m-1). */
    } B;
  } CH3_TDUC;

  union {                              /* TIM Channel n TDUV Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t TCS:3;                 /* Timeout Clock selection. */
      vuint32_t  :20;
      vuint32_t TOV:8;                 /* Time out duration for channel n (n:0...m-1). */
    } B;
  } CH3_TDUV;

  union {                              /* TIM Channel n Filter Parameter 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FLT_RE:24;             /* Filter parameter for rising edge. */
    } B;
  } CH3_FLT_RE;

  union {                              /* TIM Channel n Filter Parameter 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FLT_FE:24;             /* Filter parameter for falling edge. */
    } B;
  } CH3_FLT_FE;

  union {                              /* TIM Channel n Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t TOCTRL:2;              /* Timeout control */
      vuint32_t EGPR1_SEL:1;           /* Extension of GPR1_SEL bit field. */
      vuint32_t EGPR0_SEL:1;           /* Extension of GPR0_SEL bit field. */
      vuint32_t FR_ECNT_OFL:1;         /* Extended Edge counter overflow behavior. */
      vuint32_t CLK_SEL:3;             /* CMU clock source select for channel. */
      vuint32_t FLT_CTR_FE:1;          /* Filter counter mode for falling edge. */
      vuint32_t FLT_MODE_FE:1;         /* Filter mode for falling edge. */
      vuint32_t FLT_CTR_RE:1;          /* Filter counter mode for rising edge. */
      vuint32_t FLT_MODE_RE:1;         /* Filter mode for rising edge. */
      vuint32_t EXT_CAP_EN:1;          /* Enables external capture mode. The selected TIM mode is only sensitive to external capture pulses, the input event changes are ignored. */
      vuint32_t FLT_CNT_FRQ:2;         /* Filter counter frequency select. */
      vuint32_t FLT_EN:1;              /* Filter enable for channel n. */
      vuint32_t ECNT_RESET:1;          /* Enables resetting the ECNT counter in periodic sampling mode. */
      vuint32_t ISL:1;                 /* Ignore Signal Level. */
      vuint32_t DSL:1;                 /* Signal level control. */
      vuint32_t CNTS_SEL:1;            /* Selection for CNTS register. */
      vuint32_t GPR1_SEL:2;            /* Selection for GPR1 register. */
      vuint32_t GPR0_SEL:2;            /* Selection for GPR0 register. */
      vuint32_t TBU0_SEL:1;            /* TBU_TS0 bits input select for TIM_CHn_GPRz (z: 0, 1) */
      vuint32_t CICTRL:1;              /* Channel Input Control. */
      vuint32_t ARU_EN:1;              /* GPR0 and GPR1 register values routed to ARU. */
      vuint32_t OSM:1;                 /* One-shot mode. */
      vuint32_t TIM_MODE:3;            /* TIM channel n mode. */
      vuint32_t TIM_EN:1;              /* TIM channel n enable. */
    } B;
  } CH3_CTRL;

  union {                              /* TIM Channel n External Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t EXT_CAP_SRC:3;         /* Defines selected source for triggering the EXT_CAPTURE functionality. */
    } B;
  } CH3_ECTRL;

  union {                              /* TIM Channel n Interrupt Request Notification Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET:1;           /* Glitch detected on channel n. */
      vuint32_t TODET:1;               /* Timeout reached for input signal of channel n. */
      vuint32_t GPROFL:1;              /* GPR0 and GPR1 data overflow, old data not read out before new data has arrived at input pin. */
      vuint32_t CNTOFL:1;              /* SMU CNT counter overflow of channel n. */
      vuint32_t ECNTOFL:1;             /* ECNT counter overflow of channel n. */
      vuint32_t NEWVAL:1;              /* New measurement value detected by in channel n */
    } B;
  } CH3_IRQ_NOTIFY;

  union {                              /* TIM Channel n Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET_IRQ_EN:1;    /* TIM_GLITCHDETx_IRQ interrupt enable. */
      vuint32_t TODET_IRQ_EN:1;        /* TIM_TODETn_IRQ interrupt enable. */
      vuint32_t GPROFL_IRQ_EN:1;       /* TIM_GPROFL_IRQ interrupt enable. */
      vuint32_t CNTOFL_IRQ_EN:1;       /* TIM_CNTOFLn_IRQ interrupt enable. */
      vuint32_t ECNTOFL_IRQ_EN:1;      /* TIM_ECNTOFLn_IRQ interrupt enable. */
      vuint32_t NEWVAL_IRQ_EN:1;       /* TIM_NEWVALn_IRQ interrupt enable. */
    } B;
  } CH3_IRQ_EN;

  union {                              /* TIM Channel n Force Interrupt Request Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t TRG_GLITCHDET:1;       /* Trigger bit TIM_CHn_IRQ_NOTIFY[GLITCHDET] by software. */
      vuint32_t TRG_TODET:1;           /* Trigger bit TIM_CHn_IRQ_NOTIFY[TODET] by software. */
      vuint32_t TRG_GPROFL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[GPROFL] by software. */
      vuint32_t TRG_CNTOFL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[CNTOFL] by software. */
      vuint32_t TRG_ECNTOFL:1;         /* Trigger bit TIM_CHn_IRQ_NOTIFY[ECNTOFL] by software. */
      vuint32_t TRG_NEWVAL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[NEWVAL] by software. */
    } B;
  } CH3_IRQ_FORCINT;

  union {                              /* TIM Channel n Interrupt Request Mode Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH3_IRQ_MODE;

  union {                              /* TIM Channel Error Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET_EIRQ_EN:1;   /* TIM_GLITCHDETx_IRQ interrupt enable. */
      vuint32_t TODET_EIRQ_EN:1;       /* TIM_TODETx_IRQ interrupt enable. */
      vuint32_t GPROFL_EIRQ_EN:1;      /* TIM_GPROFL_IRQ interrupt enable. */
      vuint32_t CNTOFL_EIRQ_EN:1;      /* TIM_CNTOFLx_IRQ interrupt enable. */
      vuint32_t ECNTOFL_EIRQ_EN:1;     /* TIM_ECNTOFLx_IRQ interrupt enable. */
      vuint32_t NEWVAL_EIRQ_EN:1;      /* TIM_NEWVALx_EIRQ error interrupt enable. */
    } B;
  } CH3_EIRQ_EN;

  uint8_t TIM_reserved3[64];
  union {                              /* TIM Channel n General Purpose Register 0, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t GPR0:24;               /* Input signal characteristic parameter 0. */
    } B;
  } CH4_GPR0;

  union {                              /* TIM Channel n General Purpose Register 1, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t GPR1:24;               /* Input signal characteristic parameter 1. */
    } B;
  } CH4_GPR1;

  union {                              /* TIM Channel n Count Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CNT:24;                /* Actual SMU counter value. */
    } B;
  } CH4_CNT;

  union {                              /* TIM Channel n Edge Counter Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t ECNT:16;               /* Edge counter. */
    } B;
  } CH4_ECNT;

  union {                              /* TIM Channel n Counter Shadow Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t CNTS:24;               /* Counter shadow register. */
    } B;
  } CH4_CNTS;

  union {                              /* TIM Channel n TDUC Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TO_CNT:8;              /* Current Timeout value for channel n (n:0...m-1). */
    } B;
  } CH4_TDUC;

  union {                              /* TIM Channel n TDUV Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t TCS:3;                 /* Timeout Clock selection. */
      vuint32_t  :20;
      vuint32_t TOV:8;                 /* Time out duration for channel n (n:0...m-1). */
    } B;
  } CH4_TDUV;

  union {                              /* TIM Channel n Filter Parameter 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FLT_RE:24;             /* Filter parameter for rising edge. */
    } B;
  } CH4_FLT_RE;

  union {                              /* TIM Channel n Filter Parameter 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FLT_FE:24;             /* Filter parameter for falling edge. */
    } B;
  } CH4_FLT_FE;

  union {                              /* TIM Channel n Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t TOCTRL:2;              /* Timeout control */
      vuint32_t EGPR1_SEL:1;           /* Extension of GPR1_SEL bit field. */
      vuint32_t EGPR0_SEL:1;           /* Extension of GPR0_SEL bit field. */
      vuint32_t FR_ECNT_OFL:1;         /* Extended Edge counter overflow behavior. */
      vuint32_t CLK_SEL:3;             /* CMU clock source select for channel. */
      vuint32_t FLT_CTR_FE:1;          /* Filter counter mode for falling edge. */
      vuint32_t FLT_MODE_FE:1;         /* Filter mode for falling edge. */
      vuint32_t FLT_CTR_RE:1;          /* Filter counter mode for rising edge. */
      vuint32_t FLT_MODE_RE:1;         /* Filter mode for rising edge. */
      vuint32_t EXT_CAP_EN:1;          /* Enables external capture mode. The selected TIM mode is only sensitive to external capture pulses, the input event changes are ignored. */
      vuint32_t FLT_CNT_FRQ:2;         /* Filter counter frequency select. */
      vuint32_t FLT_EN:1;              /* Filter enable for channel n. */
      vuint32_t ECNT_RESET:1;          /* Enables resetting the ECNT counter in periodic sampling mode. */
      vuint32_t ISL:1;                 /* Ignore Signal Level. */
      vuint32_t DSL:1;                 /* Signal level control. */
      vuint32_t CNTS_SEL:1;            /* Selection for CNTS register. */
      vuint32_t GPR1_SEL:2;            /* Selection for GPR1 register. */
      vuint32_t GPR0_SEL:2;            /* Selection for GPR0 register. */
      vuint32_t TBU0_SEL:1;            /* TBU_TS0 bits input select for TIM_CHn_GPRz (z: 0, 1) */
      vuint32_t CICTRL:1;              /* Channel Input Control. */
      vuint32_t ARU_EN:1;              /* GPR0 and GPR1 register values routed to ARU. */
      vuint32_t OSM:1;                 /* One-shot mode. */
      vuint32_t TIM_MODE:3;            /* TIM channel n mode. */
      vuint32_t TIM_EN:1;              /* TIM channel n enable. */
    } B;
  } CH4_CTRL;

  union {                              /* TIM Channel n External Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t EXT_CAP_SRC:3;         /* Defines selected source for triggering the EXT_CAPTURE functionality. */
    } B;
  } CH4_ECTRL;

  union {                              /* TIM Channel n Interrupt Request Notification Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET:1;           /* Glitch detected on channel n. */
      vuint32_t TODET:1;               /* Timeout reached for input signal of channel n. */
      vuint32_t GPROFL:1;              /* GPR0 and GPR1 data overflow, old data not read out before new data has arrived at input pin. */
      vuint32_t CNTOFL:1;              /* SMU CNT counter overflow of channel n. */
      vuint32_t ECNTOFL:1;             /* ECNT counter overflow of channel n. */
      vuint32_t NEWVAL:1;              /* New measurement value detected by in channel n */
    } B;
  } CH4_IRQ_NOTIFY;

  union {                              /* TIM Channel n Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET_IRQ_EN:1;    /* TIM_GLITCHDETx_IRQ interrupt enable. */
      vuint32_t TODET_IRQ_EN:1;        /* TIM_TODETn_IRQ interrupt enable. */
      vuint32_t GPROFL_IRQ_EN:1;       /* TIM_GPROFL_IRQ interrupt enable. */
      vuint32_t CNTOFL_IRQ_EN:1;       /* TIM_CNTOFLn_IRQ interrupt enable. */
      vuint32_t ECNTOFL_IRQ_EN:1;      /* TIM_ECNTOFLn_IRQ interrupt enable. */
      vuint32_t NEWVAL_IRQ_EN:1;       /* TIM_NEWVALn_IRQ interrupt enable. */
    } B;
  } CH4_IRQ_EN;

  union {                              /* TIM Channel n Force Interrupt Request Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t TRG_GLITCHDET:1;       /* Trigger bit TIM_CHn_IRQ_NOTIFY[GLITCHDET] by software. */
      vuint32_t TRG_TODET:1;           /* Trigger bit TIM_CHn_IRQ_NOTIFY[TODET] by software. */
      vuint32_t TRG_GPROFL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[GPROFL] by software. */
      vuint32_t TRG_CNTOFL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[CNTOFL] by software. */
      vuint32_t TRG_ECNTOFL:1;         /* Trigger bit TIM_CHn_IRQ_NOTIFY[ECNTOFL] by software. */
      vuint32_t TRG_NEWVAL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[NEWVAL] by software. */
    } B;
  } CH4_IRQ_FORCINT;

  union {                              /* TIM Channel n Interrupt Request Mode Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH4_IRQ_MODE;

  union {                              /* TIM Channel Error Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET_EIRQ_EN:1;   /* TIM_GLITCHDETx_IRQ interrupt enable. */
      vuint32_t TODET_EIRQ_EN:1;       /* TIM_TODETx_IRQ interrupt enable. */
      vuint32_t GPROFL_EIRQ_EN:1;      /* TIM_GPROFL_IRQ interrupt enable. */
      vuint32_t CNTOFL_EIRQ_EN:1;      /* TIM_CNTOFLx_IRQ interrupt enable. */
      vuint32_t ECNTOFL_EIRQ_EN:1;     /* TIM_ECNTOFLx_IRQ interrupt enable. */
      vuint32_t NEWVAL_EIRQ_EN:1;      /* TIM_NEWVALx_EIRQ error interrupt enable. */
    } B;
  } CH4_EIRQ_EN;

  uint8_t TIM_reserved4[64];
  union {                              /* TIM Channel n General Purpose Register 0, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t GPR0:24;               /* Input signal characteristic parameter 0. */
    } B;
  } CH5_GPR0;

  union {                              /* TIM Channel n General Purpose Register 1, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t GPR1:24;               /* Input signal characteristic parameter 1. */
    } B;
  } CH5_GPR1;

  union {                              /* TIM Channel n Count Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CNT:24;                /* Actual SMU counter value. */
    } B;
  } CH5_CNT;

  union {                              /* TIM Channel n Edge Counter Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t ECNT:16;               /* Edge counter. */
    } B;
  } CH5_ECNT;

  union {                              /* TIM Channel n Counter Shadow Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t CNTS:24;               /* Counter shadow register. */
    } B;
  } CH5_CNTS;

  union {                              /* TIM Channel n TDUC Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TO_CNT:8;              /* Current Timeout value for channel n (n:0...m-1). */
    } B;
  } CH5_TDUC;

  union {                              /* TIM Channel n TDUV Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t TCS:3;                 /* Timeout Clock selection. */
      vuint32_t  :20;
      vuint32_t TOV:8;                 /* Time out duration for channel n (n:0...m-1). */
    } B;
  } CH5_TDUV;

  union {                              /* TIM Channel n Filter Parameter 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FLT_RE:24;             /* Filter parameter for rising edge. */
    } B;
  } CH5_FLT_RE;

  union {                              /* TIM Channel n Filter Parameter 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FLT_FE:24;             /* Filter parameter for falling edge. */
    } B;
  } CH5_FLT_FE;

  union {                              /* TIM Channel n Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t TOCTRL:2;              /* Timeout control */
      vuint32_t EGPR1_SEL:1;           /* Extension of GPR1_SEL bit field. */
      vuint32_t EGPR0_SEL:1;           /* Extension of GPR0_SEL bit field. */
      vuint32_t FR_ECNT_OFL:1;         /* Extended Edge counter overflow behavior. */
      vuint32_t CLK_SEL:3;             /* CMU clock source select for channel. */
      vuint32_t FLT_CTR_FE:1;          /* Filter counter mode for falling edge. */
      vuint32_t FLT_MODE_FE:1;         /* Filter mode for falling edge. */
      vuint32_t FLT_CTR_RE:1;          /* Filter counter mode for rising edge. */
      vuint32_t FLT_MODE_RE:1;         /* Filter mode for rising edge. */
      vuint32_t EXT_CAP_EN:1;          /* Enables external capture mode. The selected TIM mode is only sensitive to external capture pulses, the input event changes are ignored. */
      vuint32_t FLT_CNT_FRQ:2;         /* Filter counter frequency select. */
      vuint32_t FLT_EN:1;              /* Filter enable for channel n. */
      vuint32_t ECNT_RESET:1;          /* Enables resetting the ECNT counter in periodic sampling mode. */
      vuint32_t ISL:1;                 /* Ignore Signal Level. */
      vuint32_t DSL:1;                 /* Signal level control. */
      vuint32_t CNTS_SEL:1;            /* Selection for CNTS register. */
      vuint32_t GPR1_SEL:2;            /* Selection for GPR1 register. */
      vuint32_t GPR0_SEL:2;            /* Selection for GPR0 register. */
      vuint32_t TBU0_SEL:1;            /* TBU_TS0 bits input select for TIM_CHn_GPRz (z: 0, 1) */
      vuint32_t CICTRL:1;              /* Channel Input Control. */
      vuint32_t ARU_EN:1;              /* GPR0 and GPR1 register values routed to ARU. */
      vuint32_t OSM:1;                 /* One-shot mode. */
      vuint32_t TIM_MODE:3;            /* TIM channel n mode. */
      vuint32_t TIM_EN:1;              /* TIM channel n enable. */
    } B;
  } CH5_CTRL;

  union {                              /* TIM Channel n External Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t EXT_CAP_SRC:3;         /* Defines selected source for triggering the EXT_CAPTURE functionality. */
    } B;
  } CH5_ECTRL;

  union {                              /* TIM Channel n Interrupt Request Notification Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET:1;           /* Glitch detected on channel n. */
      vuint32_t TODET:1;               /* Timeout reached for input signal of channel n. */
      vuint32_t GPROFL:1;              /* GPR0 and GPR1 data overflow, old data not read out before new data has arrived at input pin. */
      vuint32_t CNTOFL:1;              /* SMU CNT counter overflow of channel n. */
      vuint32_t ECNTOFL:1;             /* ECNT counter overflow of channel n. */
      vuint32_t NEWVAL:1;              /* New measurement value detected by in channel n */
    } B;
  } CH5_IRQ_NOTIFY;

  union {                              /* TIM Channel n Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET_IRQ_EN:1;    /* TIM_GLITCHDETx_IRQ interrupt enable. */
      vuint32_t TODET_IRQ_EN:1;        /* TIM_TODETn_IRQ interrupt enable. */
      vuint32_t GPROFL_IRQ_EN:1;       /* TIM_GPROFL_IRQ interrupt enable. */
      vuint32_t CNTOFL_IRQ_EN:1;       /* TIM_CNTOFLn_IRQ interrupt enable. */
      vuint32_t ECNTOFL_IRQ_EN:1;      /* TIM_ECNTOFLn_IRQ interrupt enable. */
      vuint32_t NEWVAL_IRQ_EN:1;       /* TIM_NEWVALn_IRQ interrupt enable. */
    } B;
  } CH5_IRQ_EN;

  union {                              /* TIM Channel n Force Interrupt Request Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t TRG_GLITCHDET:1;       /* Trigger bit TIM_CHn_IRQ_NOTIFY[GLITCHDET] by software. */
      vuint32_t TRG_TODET:1;           /* Trigger bit TIM_CHn_IRQ_NOTIFY[TODET] by software. */
      vuint32_t TRG_GPROFL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[GPROFL] by software. */
      vuint32_t TRG_CNTOFL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[CNTOFL] by software. */
      vuint32_t TRG_ECNTOFL:1;         /* Trigger bit TIM_CHn_IRQ_NOTIFY[ECNTOFL] by software. */
      vuint32_t TRG_NEWVAL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[NEWVAL] by software. */
    } B;
  } CH5_IRQ_FORCINT;

  union {                              /* TIM Channel n Interrupt Request Mode Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH5_IRQ_MODE;

  union {                              /* TIM Channel Error Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET_EIRQ_EN:1;   /* TIM_GLITCHDETx_IRQ interrupt enable. */
      vuint32_t TODET_EIRQ_EN:1;       /* TIM_TODETx_IRQ interrupt enable. */
      vuint32_t GPROFL_EIRQ_EN:1;      /* TIM_GPROFL_IRQ interrupt enable. */
      vuint32_t CNTOFL_EIRQ_EN:1;      /* TIM_CNTOFLx_IRQ interrupt enable. */
      vuint32_t ECNTOFL_EIRQ_EN:1;     /* TIM_ECNTOFLx_IRQ interrupt enable. */
      vuint32_t NEWVAL_EIRQ_EN:1;      /* TIM_NEWVALx_EIRQ error interrupt enable. */
    } B;
  } CH5_EIRQ_EN;

  uint8_t TIM_reserved5[64];
  union {                              /* TIM Channel n General Purpose Register 0, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t GPR0:24;               /* Input signal characteristic parameter 0. */
    } B;
  } CH6_GPR0;

  union {                              /* TIM Channel n General Purpose Register 1, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t GPR1:24;               /* Input signal characteristic parameter 1. */
    } B;
  } CH6_GPR1;

  union {                              /* TIM Channel n Count Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CNT:24;                /* Actual SMU counter value. */
    } B;
  } CH6_CNT;

  union {                              /* TIM Channel n Edge Counter Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t ECNT:16;               /* Edge counter. */
    } B;
  } CH6_ECNT;

  union {                              /* TIM Channel n Counter Shadow Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t CNTS:24;               /* Counter shadow register. */
    } B;
  } CH6_CNTS;

  union {                              /* TIM Channel n TDUC Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TO_CNT:8;              /* Current Timeout value for channel n (n:0...m-1). */
    } B;
  } CH6_TDUC;

  union {                              /* TIM Channel n TDUV Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t TCS:3;                 /* Timeout Clock selection. */
      vuint32_t  :20;
      vuint32_t TOV:8;                 /* Time out duration for channel n (n:0...m-1). */
    } B;
  } CH6_TDUV;

  union {                              /* TIM Channel n Filter Parameter 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FLT_RE:24;             /* Filter parameter for rising edge. */
    } B;
  } CH6_FLT_RE;

  union {                              /* TIM Channel n Filter Parameter 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FLT_FE:24;             /* Filter parameter for falling edge. */
    } B;
  } CH6_FLT_FE;

  union {                              /* TIM Channel n Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t TOCTRL:2;              /* Timeout control */
      vuint32_t EGPR1_SEL:1;           /* Extension of GPR1_SEL bit field. */
      vuint32_t EGPR0_SEL:1;           /* Extension of GPR0_SEL bit field. */
      vuint32_t FR_ECNT_OFL:1;         /* Extended Edge counter overflow behavior. */
      vuint32_t CLK_SEL:3;             /* CMU clock source select for channel. */
      vuint32_t FLT_CTR_FE:1;          /* Filter counter mode for falling edge. */
      vuint32_t FLT_MODE_FE:1;         /* Filter mode for falling edge. */
      vuint32_t FLT_CTR_RE:1;          /* Filter counter mode for rising edge. */
      vuint32_t FLT_MODE_RE:1;         /* Filter mode for rising edge. */
      vuint32_t EXT_CAP_EN:1;          /* Enables external capture mode. The selected TIM mode is only sensitive to external capture pulses, the input event changes are ignored. */
      vuint32_t FLT_CNT_FRQ:2;         /* Filter counter frequency select. */
      vuint32_t FLT_EN:1;              /* Filter enable for channel n. */
      vuint32_t ECNT_RESET:1;          /* Enables resetting the ECNT counter in periodic sampling mode. */
      vuint32_t ISL:1;                 /* Ignore Signal Level. */
      vuint32_t DSL:1;                 /* Signal level control. */
      vuint32_t CNTS_SEL:1;            /* Selection for CNTS register. */
      vuint32_t GPR1_SEL:2;            /* Selection for GPR1 register. */
      vuint32_t GPR0_SEL:2;            /* Selection for GPR0 register. */
      vuint32_t TBU0_SEL:1;            /* TBU_TS0 bits input select for TIM_CHn_GPRz (z: 0, 1) */
      vuint32_t CICTRL:1;              /* Channel Input Control. */
      vuint32_t ARU_EN:1;              /* GPR0 and GPR1 register values routed to ARU. */
      vuint32_t OSM:1;                 /* One-shot mode. */
      vuint32_t TIM_MODE:3;            /* TIM channel n mode. */
      vuint32_t TIM_EN:1;              /* TIM channel n enable. */
    } B;
  } CH6_CTRL;

  union {                              /* TIM Channel n External Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t EXT_CAP_SRC:3;         /* Defines selected source for triggering the EXT_CAPTURE functionality. */
    } B;
  } CH6_ECTRL;

  union {                              /* TIM Channel n Interrupt Request Notification Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET:1;           /* Glitch detected on channel n. */
      vuint32_t TODET:1;               /* Timeout reached for input signal of channel n. */
      vuint32_t GPROFL:1;              /* GPR0 and GPR1 data overflow, old data not read out before new data has arrived at input pin. */
      vuint32_t CNTOFL:1;              /* SMU CNT counter overflow of channel n. */
      vuint32_t ECNTOFL:1;             /* ECNT counter overflow of channel n. */
      vuint32_t NEWVAL:1;              /* New measurement value detected by in channel n */
    } B;
  } CH6_IRQ_NOTIFY;

  union {                              /* TIM Channel n Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET_IRQ_EN:1;    /* TIM_GLITCHDETx_IRQ interrupt enable. */
      vuint32_t TODET_IRQ_EN:1;        /* TIM_TODETn_IRQ interrupt enable. */
      vuint32_t GPROFL_IRQ_EN:1;       /* TIM_GPROFL_IRQ interrupt enable. */
      vuint32_t CNTOFL_IRQ_EN:1;       /* TIM_CNTOFLn_IRQ interrupt enable. */
      vuint32_t ECNTOFL_IRQ_EN:1;      /* TIM_ECNTOFLn_IRQ interrupt enable. */
      vuint32_t NEWVAL_IRQ_EN:1;       /* TIM_NEWVALn_IRQ interrupt enable. */
    } B;
  } CH6_IRQ_EN;

  union {                              /* TIM Channel n Force Interrupt Request Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t TRG_GLITCHDET:1;       /* Trigger bit TIM_CHn_IRQ_NOTIFY[GLITCHDET] by software. */
      vuint32_t TRG_TODET:1;           /* Trigger bit TIM_CHn_IRQ_NOTIFY[TODET] by software. */
      vuint32_t TRG_GPROFL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[GPROFL] by software. */
      vuint32_t TRG_CNTOFL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[CNTOFL] by software. */
      vuint32_t TRG_ECNTOFL:1;         /* Trigger bit TIM_CHn_IRQ_NOTIFY[ECNTOFL] by software. */
      vuint32_t TRG_NEWVAL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[NEWVAL] by software. */
    } B;
  } CH6_IRQ_FORCINT;

  union {                              /* TIM Channel n Interrupt Request Mode Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH6_IRQ_MODE;

  union {                              /* TIM Channel Error Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET_EIRQ_EN:1;   /* TIM_GLITCHDETx_IRQ interrupt enable. */
      vuint32_t TODET_EIRQ_EN:1;       /* TIM_TODETx_IRQ interrupt enable. */
      vuint32_t GPROFL_EIRQ_EN:1;      /* TIM_GPROFL_IRQ interrupt enable. */
      vuint32_t CNTOFL_EIRQ_EN:1;      /* TIM_CNTOFLx_IRQ interrupt enable. */
      vuint32_t ECNTOFL_EIRQ_EN:1;     /* TIM_ECNTOFLx_IRQ interrupt enable. */
      vuint32_t NEWVAL_EIRQ_EN:1;      /* TIM_NEWVALx_EIRQ error interrupt enable. */
    } B;
  } CH6_EIRQ_EN;

  uint8_t TIM_reserved6[64];
  union {                              /* TIM Channel n General Purpose Register 0, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t GPR0:24;               /* Input signal characteristic parameter 0. */
    } B;
  } CH7_GPR0;

  union {                              /* TIM Channel n General Purpose Register 1, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t GPR1:24;               /* Input signal characteristic parameter 1. */
    } B;
  } CH7_GPR1;

  union {                              /* TIM Channel n Count Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CNT:24;                /* Actual SMU counter value. */
    } B;
  } CH7_CNT;

  union {                              /* TIM Channel n Edge Counter Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t ECNT:16;               /* Edge counter. */
    } B;
  } CH7_ECNT;

  union {                              /* TIM Channel n Counter Shadow Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t CNTS:24;               /* Counter shadow register. */
    } B;
  } CH7_CNTS;

  union {                              /* TIM Channel n TDUC Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TO_CNT:8;              /* Current Timeout value for channel n (n:0...m-1). */
    } B;
  } CH7_TDUC;

  union {                              /* TIM Channel n TDUV Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t TCS:3;                 /* Timeout Clock selection. */
      vuint32_t  :20;
      vuint32_t TOV:8;                 /* Time out duration for channel n (n:0...m-1). */
    } B;
  } CH7_TDUV;

  union {                              /* TIM Channel n Filter Parameter 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FLT_RE:24;             /* Filter parameter for rising edge. */
    } B;
  } CH7_FLT_RE;

  union {                              /* TIM Channel n Filter Parameter 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FLT_FE:24;             /* Filter parameter for falling edge. */
    } B;
  } CH7_FLT_FE;

  union {                              /* TIM Channel n Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t TOCTRL:2;              /* Timeout control */
      vuint32_t EGPR1_SEL:1;           /* Extension of GPR1_SEL bit field. */
      vuint32_t EGPR0_SEL:1;           /* Extension of GPR0_SEL bit field. */
      vuint32_t FR_ECNT_OFL:1;         /* Extended Edge counter overflow behavior. */
      vuint32_t CLK_SEL:3;             /* CMU clock source select for channel. */
      vuint32_t FLT_CTR_FE:1;          /* Filter counter mode for falling edge. */
      vuint32_t FLT_MODE_FE:1;         /* Filter mode for falling edge. */
      vuint32_t FLT_CTR_RE:1;          /* Filter counter mode for rising edge. */
      vuint32_t FLT_MODE_RE:1;         /* Filter mode for rising edge. */
      vuint32_t EXT_CAP_EN:1;          /* Enables external capture mode. The selected TIM mode is only sensitive to external capture pulses, the input event changes are ignored. */
      vuint32_t FLT_CNT_FRQ:2;         /* Filter counter frequency select. */
      vuint32_t FLT_EN:1;              /* Filter enable for channel n. */
      vuint32_t ECNT_RESET:1;          /* Enables resetting the ECNT counter in periodic sampling mode. */
      vuint32_t ISL:1;                 /* Ignore Signal Level. */
      vuint32_t DSL:1;                 /* Signal level control. */
      vuint32_t CNTS_SEL:1;            /* Selection for CNTS register. */
      vuint32_t GPR1_SEL:2;            /* Selection for GPR1 register. */
      vuint32_t GPR0_SEL:2;            /* Selection for GPR0 register. */
      vuint32_t TBU0_SEL:1;            /* TBU_TS0 bits input select for TIM_CHn_GPRz (z: 0, 1) */
      vuint32_t CICTRL:1;              /* Channel Input Control. */
      vuint32_t ARU_EN:1;              /* GPR0 and GPR1 register values routed to ARU. */
      vuint32_t OSM:1;                 /* One-shot mode. */
      vuint32_t TIM_MODE:3;            /* TIM channel n mode. */
      vuint32_t TIM_EN:1;              /* TIM channel n enable. */
    } B;
  } CH7_CTRL;

  union {                              /* TIM Channel n External Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t EXT_CAP_SRC:3;         /* Defines selected source for triggering the EXT_CAPTURE functionality. */
    } B;
  } CH7_ECTRL;

  union {                              /* TIM Channel n Interrupt Request Notification Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET:1;           /* Glitch detected on channel n. */
      vuint32_t TODET:1;               /* Timeout reached for input signal of channel n. */
      vuint32_t GPROFL:1;              /* GPR0 and GPR1 data overflow, old data not read out before new data has arrived at input pin. */
      vuint32_t CNTOFL:1;              /* SMU CNT counter overflow of channel n. */
      vuint32_t ECNTOFL:1;             /* ECNT counter overflow of channel n. */
      vuint32_t NEWVAL:1;              /* New measurement value detected by in channel n */
    } B;
  } CH7_IRQ_NOTIFY;

  union {                              /* TIM Channel n Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET_IRQ_EN:1;    /* TIM_GLITCHDETx_IRQ interrupt enable. */
      vuint32_t TODET_IRQ_EN:1;        /* TIM_TODETn_IRQ interrupt enable. */
      vuint32_t GPROFL_IRQ_EN:1;       /* TIM_GPROFL_IRQ interrupt enable. */
      vuint32_t CNTOFL_IRQ_EN:1;       /* TIM_CNTOFLn_IRQ interrupt enable. */
      vuint32_t ECNTOFL_IRQ_EN:1;      /* TIM_ECNTOFLn_IRQ interrupt enable. */
      vuint32_t NEWVAL_IRQ_EN:1;       /* TIM_NEWVALn_IRQ interrupt enable. */
    } B;
  } CH7_IRQ_EN;

  union {                              /* TIM Channel n Force Interrupt Request Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t TRG_GLITCHDET:1;       /* Trigger bit TIM_CHn_IRQ_NOTIFY[GLITCHDET] by software. */
      vuint32_t TRG_TODET:1;           /* Trigger bit TIM_CHn_IRQ_NOTIFY[TODET] by software. */
      vuint32_t TRG_GPROFL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[GPROFL] by software. */
      vuint32_t TRG_CNTOFL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[CNTOFL] by software. */
      vuint32_t TRG_ECNTOFL:1;         /* Trigger bit TIM_CHn_IRQ_NOTIFY[ECNTOFL] by software. */
      vuint32_t TRG_NEWVAL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[NEWVAL] by software. */
    } B;
  } CH7_IRQ_FORCINT;

  union {                              /* TIM Channel n Interrupt Request Mode Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH7_IRQ_MODE;

  union {                              /* TIM Channel Error Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET_EIRQ_EN:1;   /* TIM_GLITCHDETx_IRQ interrupt enable. */
      vuint32_t TODET_EIRQ_EN:1;       /* TIM_TODETx_IRQ interrupt enable. */
      vuint32_t GPROFL_EIRQ_EN:1;      /* TIM_GPROFL_IRQ interrupt enable. */
      vuint32_t CNTOFL_EIRQ_EN:1;      /* TIM_CNTOFLx_IRQ interrupt enable. */
      vuint32_t ECNTOFL_EIRQ_EN:1;     /* TIM_ECNTOFLx_IRQ interrupt enable. */
      vuint32_t NEWVAL_EIRQ_EN:1;      /* TIM_NEWVALx_EIRQ error interrupt enable. */
    } B;
  } CH7_EIRQ_EN;
};


/* ============================================================================
   =============================== Module: GTM_TOM ============================
   ============================================================================ */

struct GTM_TOM_tag {
  union {                              /* TOM Channel n Control Register, n[0:14] */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t GCM:1;                 /* Gated Counter Mode enable. */
      vuint32_t SPEM:1;                /* SPE mode enable for channel. */
      vuint32_t  :1;
      vuint32_t OSM:1;                 /* One-shot mode.. */
      vuint32_t  :1;
      vuint32_t TRIGOUT:1;             /* Trigger output selection (output signal TRIG_[n]) of module TOM_CH[n]. */
      vuint32_t  :3;
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :5;
      vuint32_t CLK_SRC_SR:3;          /* Clock source select for channel. */
      vuint32_t SL:1;                  /* Signal level for duty cycle. */
      vuint32_t  :11;
    } B;
  } CH0_CTRL;

  union {                              /* TOM Channel n Shadow 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR0:16;                /* TOM channel n shadow register SR0 for update of compare register CM0. */
    } B;
  } CH0_SR0;

  union {                              /* TOM Channel n Shadow 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR1:16;                /* TOM channel n shadow register SR1 for update of compare register CM1. */
    } B;
  } CH0_SR1;

  union {                              /* TOM Channel n Compare 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM0:16;                /* TOM CCU0 compare register. */
    } B;
  } CH0_CM0;

  union {                              /* TOM Channel n Compare 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM1:16;                /* TOM CCU1 compare register. */
    } B;
  } CH0_CM1;

  union {                              /* TOM Channel n CN0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CN0:16;                /* TOM CCU0 counter register. */
    } B;
  } CH0_CN0;

  union {                              /* TOM Channel n Status Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :31;                  /* Reserved. */
      vuint32_t OL:1;                  /* Output level of output TOM_OUT(n). */
    } B;
  } CH0_STAT;

  union {                              /* TOM Channel n Interrupt Request Notification Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH0_IRQ_NOTIFY;

  union {                              /* TOM Channel n Interrupt Request Enable Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH0_IRQ_EN;

  union {                              /* TOM Channel n Force Interrupt Request Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t TRG_CCU1TC0:1;         /* Trigger TOM_CCU1TC0_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC0:1;         /* Trigger TOM_CCU0TC0_IRQ interrupt by software. */
    } B;
  } CH0_IRQ_FORCINT;

  union {                              /* TOM Channel n Interrupt Request Mode Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH0_IRQ_MODE;

  uint8_t TOM_reserved0[4];
  union {                              /* TOM TGC0 Global Control Register */
    vuint32_t R;
    struct {
      vuint32_t UPEN_CTRL7:2;          /* TOM channel 7 enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL6:2;          /* TOM channel 6 enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL5:2;          /* TOM channel 5 enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL4:2;          /* TOM channel 4 enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL3:2;          /* TOM channel 3 enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL2:2;          /* TOM channel 2 enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL1:2;          /* TOM channel 1 enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL0:2;          /* TOM channel 0 enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t RST_CH7:1;             /* Software reset of channel 7. */
      vuint32_t RST_CH6:1;             /* Software reset of channel 6. */
      vuint32_t RST_CH5:1;             /* Software reset of channel 5. */
      vuint32_t RST_CH4:1;             /* Software reset of channel 4. */
      vuint32_t RST_CH3:1;             /* Software reset of channel 3. */
      vuint32_t RST_CH2:1;             /* Software reset of channel 2. */
      vuint32_t RST_CH1:1;             /* Software reset of channel 1. */
      vuint32_t RST_CH0:1;             /* Software reset of channel 0. */
      vuint32_t  :7;
      vuint32_t HOST_TRIG:1;           /* Trigger request signal (see TGC0, TGC1) to update the register ENDIS_STAT and OUTEN_STAT. */
    } B;
  } TGC0_GLB_CTRL;

  union {                              /* TOM TGC0 Action Time Base Register */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t TBU_SEL:2;             /* Selection of time base used for comparison. */
      vuint32_t TB_TRIG:1;             /* Set trigger request. */
      vuint32_t ACT_TB:24;             /* Specifies the signed compare value with selected signal TBU_TS[n], x=0..2. */
    } B;
  } TGC0_ACT_TB;

  union {                              /* TOM TGC0 Force Update Control Register */
    vuint32_t R;
    struct {
      vuint32_t RSTCN0_CH7:2;          /* Reset CN0 of channel 7 on force update event. */
      vuint32_t RSTCN0_CH6:2;          /* Reset CN0 of channel 6 on force update event. */
      vuint32_t RSTCN0_CH5:2;          /* Reset CN0 of channel 5 on force update event. */
      vuint32_t RSTCN0_CH4:2;          /* Reset CN0 of channel 4 on force update event. */
      vuint32_t RSTCN0_CH3:2;          /* Reset CN0 of channel 3 on force update event. */
      vuint32_t RSTCN0_CH2:2;          /* Reset CN0 of channel 2 on force update event. */
      vuint32_t RSTCN0_CH1:2;          /* Reset CN0 of channel 1 on force update event. */
      vuint32_t RSTCN0_CH0:2;          /* Reset CN0 of channel 0 on force update event. */
      vuint32_t FUPD_CTRL7:2;          /* Force update of TOM channel 7 operation registers. */
      vuint32_t FUPD_CTRL6:2;          /* Force update of TOM channel 6 operation registers, */
      vuint32_t FUPD_CTRL5:2;          /* Force update of TOM channel 5 operation registers. */
      vuint32_t FUPD_CTRL4:2;          /* Force update of TOM channel 4 operation registers. */
      vuint32_t FUPD_CTRL3:2;          /* Force update of TOM channel 3 operation registers. */
      vuint32_t FUPD_CTRL2:2;          /* ce update of TOM channel 2 operation registers. */
      vuint32_t FUPD_CTRL1:2;          /* Force update of TOM channel 1 operation registers. */
      vuint32_t FUPD_CTRL0:2;          /* Force update of TOM channel 0 operation registers. */
    } B;
  } TGC0_FUPD_CTRL;

  union {                              /* TOM TGC0 Interrupt Trigger Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t INT_TRIG7:2;           /* Select input signal TRIG_7 as a trigger source. */
      vuint32_t INT_TRIG6:2;           /* Select input signal TRIG_6 as a trigger source. */
      vuint32_t INT_TRIG5:2;           /* Select input signal TRIG_5 as a trigger source. */
      vuint32_t INT_TRIG4:2;           /* Select input signal TRIG_4 as a trigger source. */
      vuint32_t INT_TRIG3:2;           /* Select input signal TRIG_3 as a trigger source. */
      vuint32_t INT_TRIG2:2;           /* Select input signal TRIG_2 as a trigger source. */
      vuint32_t INT_TRIG1:2;           /* Select input signal TRIG_1 as a trigger source. */
      vuint32_t INT_TRIG0:2;           /* Select input signal TRIG_0 as a trigger source. */
    } B;
  } TGC0_INT_TRIG;

  union {                              /* TOM Channel n Control Register, n[0:14] */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t GCM:1;                 /* Gated Counter Mode enable. */
      vuint32_t SPEM:1;                /* SPE mode enable for channel. */
      vuint32_t  :1;
      vuint32_t OSM:1;                 /* One-shot mode.. */
      vuint32_t  :1;
      vuint32_t TRIGOUT:1;             /* Trigger output selection (output signal TRIG_[n]) of module TOM_CH[n]. */
      vuint32_t  :3;
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :5;
      vuint32_t CLK_SRC_SR:3;          /* Clock source select for channel. */
      vuint32_t SL:1;                  /* Signal level for duty cycle. */
      vuint32_t  :11;
    } B;
  } CH1_CTRL;

  union {                              /* TOM Channel n Shadow 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR0:16;                /* TOM channel n shadow register SR0 for update of compare register CM0. */
    } B;
  } CH1_SR0;

  union {                              /* TOM Channel n Shadow 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR1:16;                /* TOM channel n shadow register SR1 for update of compare register CM1. */
    } B;
  } CH1_SR1;

  union {                              /* TOM Channel n Compare 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM0:16;                /* TOM CCU0 compare register. */
    } B;
  } CH1_CM0;

  union {                              /* TOM Channel n Compare 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM1:16;                /* TOM CCU1 compare register. */
    } B;
  } CH1_CM1;

  union {                              /* TOM Channel n CN0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CN0:16;                /* TOM CCU0 counter register. */
    } B;
  } CH1_CN0;

  union {                              /* TOM Channel n Status Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :31;                  /* Reserved. */
      vuint32_t OL:1;                  /* Output level of output TOM_OUT(n). */
    } B;
  } CH1_STAT;

  union {                              /* TOM Channel n Interrupt Request Notification Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH1_IRQ_NOTIFY;

  union {                              /* TOM Channel n Interrupt Request Enable Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH1_IRQ_EN;

  union {                              /* TOM Channel n Force Interrupt Request Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t TRG_CCU1TC0:1;         /* Trigger TOM_CCU1TC0_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC0:1;         /* Trigger TOM_CCU0TC0_IRQ interrupt by software. */
    } B;
  } CH1_IRQ_FORCINT;

  union {                              /* TOM Channel n Interrupt Request Mode Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH1_IRQ_MODE;

  uint8_t TOM_reserved1[4];
  union {                              /* TOM TGC0 Enable/Disable Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t ENDIS_CTRL7:2;         /* Channel 7 enable/disable update value. */
      vuint32_t ENDIS_CTRL6:2;         /* Channel 6 enable/disable update value. */
      vuint32_t ENDIS_CTRL5:2;         /* Channel 5 enable/disable update value. */
      vuint32_t ENDIS_CTRL4:2;         /* TOM channel 4 enable/disable update value. */
      vuint32_t ENDIS_CTRL3:2;         /* TOM channel 3 enable/disable update value. */
      vuint32_t ENDIS_CTRL2:2;         /* TOM channel 2 enable/disable update value. */
      vuint32_t ENDIS_CTRL1:2;         /* TOM channel 1 enable/disable update value. */
      vuint32_t ENDIS_CTRL0:2;         /* TOM channel 0 enable/disable update value. */
    } B;
  } TGC0_ENDIS_CTRL;

  union {                              /* TOM TGC0 Enable/Disable Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t ENDIS_STAT7:2;         /* TOM channel 7 enable/disable. */
      vuint32_t ENDIS_STAT6:2;         /* TOM channel 6 enable/disable. */
      vuint32_t ENDIS_STAT5:2;         /* TOM channel 5 enable/disable. */
      vuint32_t ENDIS_STAT4:2;         /* TOM channel 4 enable/disable. */
      vuint32_t ENDIS_STAT3:2;         /* TOM channel 3 enable/disable. */
      vuint32_t ENDIS_STAT2:2;         /* TOM channel 2 enable/disable. */
      vuint32_t ENDIS_STAT1:2;         /* TOM channel 1 enable/disable. */
      vuint32_t ENDIS_STAT0:2;         /* TOM channel 0 enable/disable. */
    } B;
  } TGC0_ENDIS_STAT;

  union {                              /* TOM TGC0 Out Enable Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t OUTEN_CTRL7:2;         /* Output TOM_OUT(7) enable/disable update value. */
      vuint32_t OUTEN_CTRL6:2;         /* Output TOM_OUT(6) enable/disable update value. */
      vuint32_t OUTEN_CTRL5:2;         /* Output TOM_OUT(5) enable/disable update value. */
      vuint32_t OUTEN_CTRL4:2;         /* Output TOM_OUT(4) enable/disable update value. */
      vuint32_t OUTEN_CTRL3:2;         /* Output TOM_OUT(3) enable/disable update value. */
      vuint32_t OUTEN_CTRL2:2;         /* Output TOM_OUT(2) enable/disable update value. */
      vuint32_t OUTEN_CTRL1:2;         /* Output TOM_OUT(1) enable/disable update value. */
      vuint32_t OUTEN_CTRL0:2;         /* Output TOM_OUT(0) enable/disable update value. */
    } B;
  } TGC0_OUTEN_CTRL;

  union {                              /* TOM TGC0 Out Enable Control/Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t OUTEN_STAT7:2;         /* Control/status of output TOM_OUT(7). */
      vuint32_t OUTEN_STAT6:2;         /* Control/status of output TOM_OUT(6). */
      vuint32_t OUTEN_STAT5:2;         /* Control/status of output TOM_OUT(5). */
      vuint32_t OUTEN_STAT4:2;         /* Control/status of output TOM_OUT(4) */
      vuint32_t OUTEN_STAT3:2;         /* Control/status of output TOM_OUT(3). */
      vuint32_t OUTEN_STAT2:2;         /* Control/status of output TOM_OUT(2). */
      vuint32_t OUTEN_STAT1:2;         /* Control/status of output TOM_OUT(1). */
      vuint32_t OUTEN_STAT0:2;         /* Control/status of output TOM_OUT(0). */
    } B;
  } TGC0_OUTEN_STAT;

  union {                              /* TOM Channel n Control Register, n[0:14] */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t GCM:1;                 /* Gated Counter Mode enable. */
      vuint32_t SPEM:1;                /* SPE mode enable for channel. */
      vuint32_t  :1;
      vuint32_t OSM:1;                 /* One-shot mode.. */
      vuint32_t  :1;
      vuint32_t TRIGOUT:1;             /* Trigger output selection (output signal TRIG_[n]) of module TOM_CH[n]. */
      vuint32_t  :3;
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :5;
      vuint32_t CLK_SRC_SR:3;          /* Clock source select for channel. */
      vuint32_t SL:1;                  /* Signal level for duty cycle. */
      vuint32_t  :11;
    } B;
  } CH2_CTRL;

  union {                              /* TOM Channel n Shadow 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR0:16;                /* TOM channel n shadow register SR0 for update of compare register CM0. */
    } B;
  } CH2_SR0;

  union {                              /* TOM Channel n Shadow 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR1:16;                /* TOM channel n shadow register SR1 for update of compare register CM1. */
    } B;
  } CH2_SR1;

  union {                              /* TOM Channel n Compare 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM0:16;                /* TOM CCU0 compare register. */
    } B;
  } CH2_CM0;

  union {                              /* TOM Channel n Compare 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM1:16;                /* TOM CCU1 compare register. */
    } B;
  } CH2_CM1;

  union {                              /* TOM Channel n CN0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CN0:16;                /* TOM CCU0 counter register. */
    } B;
  } CH2_CN0;

  union {                              /* TOM Channel n Status Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :31;                  /* Reserved. */
      vuint32_t OL:1;                  /* Output level of output TOM_OUT(n). */
    } B;
  } CH2_STAT;

  union {                              /* TOM Channel n Interrupt Request Notification Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH2_IRQ_NOTIFY;

  union {                              /* TOM Channel n Interrupt Request Enable Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH2_IRQ_EN;

  union {                              /* TOM Channel n Force Interrupt Request Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t TRG_CCU1TC0:1;         /* Trigger TOM_CCU1TC0_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC0:1;         /* Trigger TOM_CCU0TC0_IRQ interrupt by software. */
    } B;
  } CH2_IRQ_FORCINT;

  union {                              /* TOM Channel n Interrupt Request Mode Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH2_IRQ_MODE;

  uint8_t TOM_reserved2[20];
  union {                              /* TOM Channel n Control Register, n[0:14] */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t GCM:1;                 /* Gated Counter Mode enable. */
      vuint32_t SPEM:1;                /* SPE mode enable for channel. */
      vuint32_t  :1;
      vuint32_t OSM:1;                 /* One-shot mode.. */
      vuint32_t  :1;
      vuint32_t TRIGOUT:1;             /* Trigger output selection (output signal TRIG_[n]) of module TOM_CH[n]. */
      vuint32_t  :3;
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :5;
      vuint32_t CLK_SRC_SR:3;          /* Clock source select for channel. */
      vuint32_t SL:1;                  /* Signal level for duty cycle. */
      vuint32_t  :11;
    } B;
  } CH3_CTRL;

  union {                              /* TOM Channel n Shadow 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR0:16;                /* TOM channel n shadow register SR0 for update of compare register CM0. */
    } B;
  } CH3_SR0;

  union {                              /* TOM Channel n Shadow 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR1:16;                /* TOM channel n shadow register SR1 for update of compare register CM1. */
    } B;
  } CH3_SR1;

  union {                              /* TOM Channel n Compare 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM0:16;                /* TOM CCU0 compare register. */
    } B;
  } CH3_CM0;

  union {                              /* TOM Channel n Compare 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM1:16;                /* TOM CCU1 compare register. */
    } B;
  } CH3_CM1;

  union {                              /* TOM Channel n CN0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CN0:16;                /* TOM CCU0 counter register. */
    } B;
  } CH3_CN0;

  union {                              /* TOM Channel n Status Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :31;                  /* Reserved. */
      vuint32_t OL:1;                  /* Output level of output TOM_OUT(n). */
    } B;
  } CH3_STAT;

  union {                              /* TOM Channel n Interrupt Request Notification Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH3_IRQ_NOTIFY;

  union {                              /* TOM Channel n Interrupt Request Enable Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH3_IRQ_EN;

  union {                              /* TOM Channel n Force Interrupt Request Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t TRG_CCU1TC0:1;         /* Trigger TOM_CCU1TC0_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC0:1;         /* Trigger TOM_CCU0TC0_IRQ interrupt by software. */
    } B;
  } CH3_IRQ_FORCINT;

  union {                              /* TOM Channel n Interrupt Request Mode Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH3_IRQ_MODE;

  uint8_t TOM_reserved3[20];
  union {                              /* TOM Channel n Control Register, n[0:14] */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t GCM:1;                 /* Gated Counter Mode enable. */
      vuint32_t SPEM:1;                /* SPE mode enable for channel. */
      vuint32_t  :1;
      vuint32_t OSM:1;                 /* One-shot mode.. */
      vuint32_t  :1;
      vuint32_t TRIGOUT:1;             /* Trigger output selection (output signal TRIG_[n]) of module TOM_CH[n]. */
      vuint32_t  :3;
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :5;
      vuint32_t CLK_SRC_SR:3;          /* Clock source select for channel. */
      vuint32_t SL:1;                  /* Signal level for duty cycle. */
      vuint32_t  :11;
    } B;
  } CH4_CTRL;

  union {                              /* TOM Channel n Shadow 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR0:16;                /* TOM channel n shadow register SR0 for update of compare register CM0. */
    } B;
  } CH4_SR0;

  union {                              /* TOM Channel n Shadow 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR1:16;                /* TOM channel n shadow register SR1 for update of compare register CM1. */
    } B;
  } CH4_SR1;

  union {                              /* TOM Channel n Compare 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM0:16;                /* TOM CCU0 compare register. */
    } B;
  } CH4_CM0;

  union {                              /* TOM Channel n Compare 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM1:16;                /* TOM CCU1 compare register. */
    } B;
  } CH4_CM1;

  union {                              /* TOM Channel n CN0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CN0:16;                /* TOM CCU0 counter register. */
    } B;
  } CH4_CN0;

  union {                              /* TOM Channel n Status Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :31;                  /* Reserved. */
      vuint32_t OL:1;                  /* Output level of output TOM_OUT(n). */
    } B;
  } CH4_STAT;

  union {                              /* TOM Channel n Interrupt Request Notification Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH4_IRQ_NOTIFY;

  union {                              /* TOM Channel n Interrupt Request Enable Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH4_IRQ_EN;

  union {                              /* TOM Channel n Force Interrupt Request Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t TRG_CCU1TC0:1;         /* Trigger TOM_CCU1TC0_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC0:1;         /* Trigger TOM_CCU0TC0_IRQ interrupt by software. */
    } B;
  } CH4_IRQ_FORCINT;

  union {                              /* TOM Channel n Interrupt Request Mode Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH4_IRQ_MODE;

  uint8_t TOM_reserved4[20];
  union {                              /* TOM Channel n Control Register, n[0:14] */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t GCM:1;                 /* Gated Counter Mode enable. */
      vuint32_t SPEM:1;                /* SPE mode enable for channel. */
      vuint32_t  :1;
      vuint32_t OSM:1;                 /* One-shot mode.. */
      vuint32_t  :1;
      vuint32_t TRIGOUT:1;             /* Trigger output selection (output signal TRIG_[n]) of module TOM_CH[n]. */
      vuint32_t  :3;
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :5;
      vuint32_t CLK_SRC_SR:3;          /* Clock source select for channel. */
      vuint32_t SL:1;                  /* Signal level for duty cycle. */
      vuint32_t  :11;
    } B;
  } CH5_CTRL;

  union {                              /* TOM Channel n Shadow 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR0:16;                /* TOM channel n shadow register SR0 for update of compare register CM0. */
    } B;
  } CH5_SR0;

  union {                              /* TOM Channel n Shadow 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR1:16;                /* TOM channel n shadow register SR1 for update of compare register CM1. */
    } B;
  } CH5_SR1;

  union {                              /* TOM Channel n Compare 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM0:16;                /* TOM CCU0 compare register. */
    } B;
  } CH5_CM0;

  union {                              /* TOM Channel n Compare 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM1:16;                /* TOM CCU1 compare register. */
    } B;
  } CH5_CM1;

  union {                              /* TOM Channel n CN0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CN0:16;                /* TOM CCU0 counter register. */
    } B;
  } CH5_CN0;

  union {                              /* TOM Channel n Status Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :31;                  /* Reserved. */
      vuint32_t OL:1;                  /* Output level of output TOM_OUT(n). */
    } B;
  } CH5_STAT;

  union {                              /* TOM Channel n Interrupt Request Notification Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH5_IRQ_NOTIFY;

  union {                              /* TOM Channel n Interrupt Request Enable Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH5_IRQ_EN;

  union {                              /* TOM Channel n Force Interrupt Request Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t TRG_CCU1TC0:1;         /* Trigger TOM_CCU1TC0_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC0:1;         /* Trigger TOM_CCU0TC0_IRQ interrupt by software. */
    } B;
  } CH5_IRQ_FORCINT;

  union {                              /* TOM Channel n Interrupt Request Mode Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH5_IRQ_MODE;

  uint8_t TOM_reserved5[20];
  union {                              /* TOM Channel n Control Register, n[0:14] */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t GCM:1;                 /* Gated Counter Mode enable. */
      vuint32_t SPEM:1;                /* SPE mode enable for channel. */
      vuint32_t  :1;
      vuint32_t OSM:1;                 /* One-shot mode.. */
      vuint32_t  :1;
      vuint32_t TRIGOUT:1;             /* Trigger output selection (output signal TRIG_[n]) of module TOM_CH[n]. */
      vuint32_t  :3;
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :5;
      vuint32_t CLK_SRC_SR:3;          /* Clock source select for channel. */
      vuint32_t SL:1;                  /* Signal level for duty cycle. */
      vuint32_t  :11;
    } B;
  } CH6_CTRL;

  union {                              /* TOM Channel n Shadow 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR0:16;                /* TOM channel n shadow register SR0 for update of compare register CM0. */
    } B;
  } CH6_SR0;

  union {                              /* TOM Channel n Shadow 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR1:16;                /* TOM channel n shadow register SR1 for update of compare register CM1. */
    } B;
  } CH6_SR1;

  union {                              /* TOM Channel n Compare 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM0:16;                /* TOM CCU0 compare register. */
    } B;
  } CH6_CM0;

  union {                              /* TOM Channel n Compare 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM1:16;                /* TOM CCU1 compare register. */
    } B;
  } CH6_CM1;

  union {                              /* TOM Channel n CN0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CN0:16;                /* TOM CCU0 counter register. */
    } B;
  } CH6_CN0;

  union {                              /* TOM Channel n Status Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :31;                  /* Reserved. */
      vuint32_t OL:1;                  /* Output level of output TOM_OUT(n). */
    } B;
  } CH6_STAT;

  union {                              /* TOM Channel n Interrupt Request Notification Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH6_IRQ_NOTIFY;

  union {                              /* TOM Channel n Interrupt Request Enable Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH6_IRQ_EN;

  union {                              /* TOM Channel n Force Interrupt Request Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t TRG_CCU1TC0:1;         /* Trigger TOM_CCU1TC0_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC0:1;         /* Trigger TOM_CCU0TC0_IRQ interrupt by software. */
    } B;
  } CH6_IRQ_FORCINT;

  union {                              /* TOM Channel n Interrupt Request Mode Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH6_IRQ_MODE;

  uint8_t TOM_reserved6[20];
  union {                              /* TOM Channel n Control Register, n[0:14] */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t GCM:1;                 /* Gated Counter Mode enable. */
      vuint32_t SPEM:1;                /* SPE mode enable for channel. */
      vuint32_t  :1;
      vuint32_t OSM:1;                 /* One-shot mode.. */
      vuint32_t  :1;
      vuint32_t TRIGOUT:1;             /* Trigger output selection (output signal TRIG_[n]) of module TOM_CH[n]. */
      vuint32_t  :3;
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :5;
      vuint32_t CLK_SRC_SR:3;          /* Clock source select for channel. */
      vuint32_t SL:1;                  /* Signal level for duty cycle. */
      vuint32_t  :11;
    } B;
  } CH7_CTRL;

  union {                              /* TOM Channel n Shadow 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR0:16;                /* TOM channel n shadow register SR0 for update of compare register CM0. */
    } B;
  } CH7_SR0;

  union {                              /* TOM Channel n Shadow 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR1:16;                /* TOM channel n shadow register SR1 for update of compare register CM1. */
    } B;
  } CH7_SR1;

  union {                              /* TOM Channel n Compare 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM0:16;                /* TOM CCU0 compare register. */
    } B;
  } CH7_CM0;

  union {                              /* TOM Channel n Compare 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM1:16;                /* TOM CCU1 compare register. */
    } B;
  } CH7_CM1;

  union {                              /* TOM Channel n CN0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CN0:16;                /* TOM CCU0 counter register. */
    } B;
  } CH7_CN0;

  union {                              /* TOM Channel n Status Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :31;                  /* Reserved. */
      vuint32_t OL:1;                  /* Output level of output TOM_OUT(n). */
    } B;
  } CH7_STAT;

  union {                              /* TOM Channel n Interrupt Request Notification Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH7_IRQ_NOTIFY;

  union {                              /* TOM Channel n Interrupt Request Enable Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH7_IRQ_EN;

  union {                              /* TOM Channel n Force Interrupt Request Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t TRG_CCU1TC0:1;         /* Trigger TOM_CCU1TC0_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC0:1;         /* Trigger TOM_CCU0TC0_IRQ interrupt by software. */
    } B;
  } CH7_IRQ_FORCINT;

  union {                              /* TOM Channel n Interrupt Request Mode Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH7_IRQ_MODE;

  uint8_t TOM_reserved7[20];
  union {                              /* TOM Channel n Control Register, n[0:14] */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t GCM:1;                 /* Gated Counter Mode enable. */
      vuint32_t SPEM:1;                /* SPE mode enable for channel. */
      vuint32_t  :1;
      vuint32_t OSM:1;                 /* One-shot mode.. */
      vuint32_t  :1;
      vuint32_t TRIGOUT:1;             /* Trigger output selection (output signal TRIG_[n]) of module TOM_CH[n]. */
      vuint32_t  :3;
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :5;
      vuint32_t CLK_SRC_SR:3;          /* Clock source select for channel. */
      vuint32_t SL:1;                  /* Signal level for duty cycle. */
      vuint32_t  :11;
    } B;
  } CH8_CTRL;

  union {                              /* TOM Channel n Shadow 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR0:16;                /* TOM channel n shadow register SR0 for update of compare register CM0. */
    } B;
  } CH8_SR0;

  union {                              /* TOM Channel n Shadow 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR1:16;                /* TOM channel n shadow register SR1 for update of compare register CM1. */
    } B;
  } CH8_SR1;

  union {                              /* TOM Channel n Compare 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM0:16;                /* TOM CCU0 compare register. */
    } B;
  } CH8_CM0;

  union {                              /* TOM Channel n Compare 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM1:16;                /* TOM CCU1 compare register. */
    } B;
  } CH8_CM1;

  union {                              /* TOM Channel n CN0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CN0:16;                /* TOM CCU0 counter register. */
    } B;
  } CH8_CN0;

  union {                              /* TOM Channel n Status Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :31;                  /* Reserved. */
      vuint32_t OL:1;                  /* Output level of output TOM_OUT(n). */
    } B;
  } CH8_STAT;

  union {                              /* TOM Channel n Interrupt Request Notification Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH8_IRQ_NOTIFY;

  union {                              /* TOM Channel n Interrupt Request Enable Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH8_IRQ_EN;

  union {                              /* TOM Channel n Force Interrupt Request Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t TRG_CCU1TC0:1;         /* Trigger TOM_CCU1TC0_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC0:1;         /* Trigger TOM_CCU0TC0_IRQ interrupt by software. */
    } B;
  } CH8_IRQ_FORCINT;

  union {                              /* TOM Channel n Interrupt Request Mode Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH8_IRQ_MODE;

  uint8_t TOM_reserved8[4];
  union {                              /* TOM TGC1 Global Control Register */
    vuint32_t R;
    struct {
      vuint32_t UPEN_CTRL15:2;         /* TOM channel 15 enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL14:2;         /* TOM channel 14 enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL13:2;         /* TOM channel 13 enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL12:2;         /* TOM channel 12 enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL11:2;         /* TOM channel 11 enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL10:2;         /* TOM channel 10 enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL9:2;          /* TOM channel 9 enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL8:2;          /* TOM channel 8 enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t RST_CH15:1;            /* Software reset of channel 15. */
      vuint32_t RST_CH14:1;            /* Software reset of channel 14. */
      vuint32_t RST_CH13:1;            /* Software reset of channel 13. */
      vuint32_t RST_CH12:1;            /* Software reset of channel 12. */
      vuint32_t RST_CH11:1;            /* Software reset of channel 11. */
      vuint32_t RST_CH10:1;            /* Software reset of channel 10. */
      vuint32_t RST_CH9:1;             /* Software reset of channel 9. */
      vuint32_t RST_CH8:1;             /* Software reset of channel 8. */
      vuint32_t  :7;
      vuint32_t HOST_TRIG:1;           /* Trigger request signal (see TGC0, TGC1) to update the register ENDIS_STAT and OUTEN_STAT. */
    } B;
  } TGC1_GLB_CTRL;

  union {                              /* TOM TGC1 Action Time Base Register */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t TBU_SEL:2;             /* Selection of time base used for comparison. */
      vuint32_t TB_TRIG:1;             /* Set trigger request. */
      vuint32_t ACT_TB:24;             /* Specifies the signed compare value with selected signal TBU_TS[n], x=0..2. */
    } B;
  } TGC1_ACT_TB;

  union {                              /* TOM TGC1 Force Update Control Register */
    vuint32_t R;
    struct {
      vuint32_t RSTCN0_CH15:2;         /* Reset CN0 of channel 15 on force update event. */
      vuint32_t RSTCN0_CH14:2;         /* Reset CN0 of channel 14 on force update event. */
      vuint32_t RSTCN0_CH13:2;         /* Reset CN0 of channel 13 on force update event. */
      vuint32_t RSTCN0_CH12:2;         /* Reset CN0 of channel 12 on force update event. */
      vuint32_t RSTCN0_CH11:2;         /* Reset CN0 of channel 11 on force update event. */
      vuint32_t RSTCN0_CH10:2;         /* Reset CN0 of channel 10 on force update event. */
      vuint32_t RSTCN0_CH9:2;          /* Reset CN0 of channel 9 on force update event. */
      vuint32_t RSTCN0_CH8:2;          /* Reset CN0 of channel 8 on force update event. */
      vuint32_t FUPD_CTRL15:2;         /* Force update of TOM channel 15 operation registers. */
      vuint32_t FUPD_CTRL14:2;         /* Force update of TOM channel 14 operation registers, */
      vuint32_t FUPD_CTRL13:2;         /* Force update of TOM channel 13 operation registers. */
      vuint32_t FUPD_CTRL12:2;         /* Force update of TOM channel 12 operation registers. */
      vuint32_t FUPD_CTRL11:2;         /* Force update of TOM channel 11 operation registers. */
      vuint32_t FUPD_CTRL10:2;         /* ce update of TOM channel 10 operation registers. */
      vuint32_t FUPD_CTRL9:2;          /* Force update of TOM channel 9 operation registers. */
      vuint32_t FUPD_CTRL8:2;          /* Force update of TOM channel 8 operation registers. */
    } B;
  } TGC1_FUPD_CTRL;

  union {                              /* TOM TGC1 Interrupt Trigger Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t INT_TRIG15:2;          /* Select input signal TRIG_15 as a trigger source. */
      vuint32_t INT_TRIG14:2;          /* Select input signal TRIG_14 as a trigger source. */
      vuint32_t INT_TRIG13:2;          /* Select input signal TRIG_13as a trigger source. */
      vuint32_t INT_TRIG12:2;          /* Select input signal TRIG_12 as a trigger source. */
      vuint32_t INT_TRIG11:2;          /* Select input signal TRIG_1 as a trigger source. */
      vuint32_t INT_TRIG10:2;          /* Select input signal TRIG_10 as a trigger source. */
      vuint32_t INT_TRIG9:2;           /* Select input signal TRIG_9 as a trigger source. */
      vuint32_t INT_TRIG8:2;           /* Select input signal TRIG_8 as a trigger source. */
    } B;
  } TGC1_INT_TRIG;

  union {                              /* TOM Channel n Control Register, n[0:14] */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t GCM:1;                 /* Gated Counter Mode enable. */
      vuint32_t SPEM:1;                /* SPE mode enable for channel. */
      vuint32_t  :1;
      vuint32_t OSM:1;                 /* One-shot mode.. */
      vuint32_t  :1;
      vuint32_t TRIGOUT:1;             /* Trigger output selection (output signal TRIG_[n]) of module TOM_CH[n]. */
      vuint32_t  :3;
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :5;
      vuint32_t CLK_SRC_SR:3;          /* Clock source select for channel. */
      vuint32_t SL:1;                  /* Signal level for duty cycle. */
      vuint32_t  :11;
    } B;
  } CH9_CTRL;

  union {                              /* TOM Channel n Shadow 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR0:16;                /* TOM channel n shadow register SR0 for update of compare register CM0. */
    } B;
  } CH9_SR0;

  union {                              /* TOM Channel n Shadow 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR1:16;                /* TOM channel n shadow register SR1 for update of compare register CM1. */
    } B;
  } CH9_SR1;

  union {                              /* TOM Channel n Compare 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM0:16;                /* TOM CCU0 compare register. */
    } B;
  } CH9_CM0;

  union {                              /* TOM Channel n Compare 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM1:16;                /* TOM CCU1 compare register. */
    } B;
  } CH9_CM1;

  union {                              /* TOM Channel n CN0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CN0:16;                /* TOM CCU0 counter register. */
    } B;
  } CH9_CN0;

  union {                              /* TOM Channel n Status Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :31;                  /* Reserved. */
      vuint32_t OL:1;                  /* Output level of output TOM_OUT(n). */
    } B;
  } CH9_STAT;

  union {                              /* TOM Channel n Interrupt Request Notification Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH9_IRQ_NOTIFY;

  union {                              /* TOM Channel n Interrupt Request Enable Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH9_IRQ_EN;

  union {                              /* TOM Channel n Force Interrupt Request Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t TRG_CCU1TC0:1;         /* Trigger TOM_CCU1TC0_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC0:1;         /* Trigger TOM_CCU0TC0_IRQ interrupt by software. */
    } B;
  } CH9_IRQ_FORCINT;

  union {                              /* TOM Channel n Interrupt Request Mode Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH9_IRQ_MODE;

  uint8_t TOM_reserved9[4];
  union {                              /* TOM TGC1 Enable/Disable Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t ENDIS_CTRL15:2;        /* Channel 15 enable/disable update value. */
      vuint32_t ENDIS_CTRL14:2;        /* Channel 14 enable/disable update value. */
      vuint32_t ENDIS_CTRL13:2;        /* Channel 13 enable/disable update value. */
      vuint32_t ENDIS_CTRL12:2;        /* TOM channel 12 enable/disable update value. */
      vuint32_t ENDIS_CTRL11:2;        /* TOM channel 11 enable/disable update value. */
      vuint32_t ENDIS_CTRL10:2;        /* TOM channel 10 enable/disable update value. */
      vuint32_t ENDIS_CTRL9:2;         /* TOM channel 9 enable/disable update value. */
      vuint32_t ENDIS_CTRL8:2;         /* TOM channel 8 enable/disable update value. */
    } B;
  } TGC1_ENDIS_CTRL;

  union {                              /* TOM TGC1 Enable/Disable Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t ENDIS_STAT15:2;        /* TOM channel 15 enable/disable. */
      vuint32_t ENDIS_STAT14:2;        /* TOM channel 14 enable/disable. */
      vuint32_t ENDIS_STAT13:2;        /* TOM channel 13 enable/disable. */
      vuint32_t ENDIS_STAT12:2;        /* TOM channel 12 enable/disable. */
      vuint32_t ENDIS_STAT11:2;        /* TOM channel 11 enable/disable. */
      vuint32_t ENDIS_STAT10:2;        /* TOM channel 10 enable/disable. */
      vuint32_t ENDIS_STAT9:2;         /* TOM channel 9 enable/disable. */
      vuint32_t ENDIS_STAT8:2;         /* TOM channel 8 enable/disable. */
    } B;
  } TGC1_ENDIS_STAT;

  union {                              /* TOM TGC1 Out Enable Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t OUTEN_CTRL15:2;        /* Output TOM_OUT(15) enable/disable update value. */
      vuint32_t OUTEN_CTRL14:2;        /* Output TOM_OUT(14) enable/disable update value. */
      vuint32_t OUTEN_CTRL13:2;        /* Output TOM_OUT(13) enable/disable update value. */
      vuint32_t OUTEN_CTRL12:2;        /* Output TOM_OUT(12) enable/disable update value. */
      vuint32_t OUTEN_CTRL11:2;        /* Output TOM_OUT(11) enable/disable update value. */
      vuint32_t OUTEN_CTRL10:2;        /* Output TOM_OUT(10) enable/disable update value. */
      vuint32_t OUTEN_CTRL9:2;         /* Output TOM_OUT(9) enable/disable update value. */
      vuint32_t OUTEN_CTRL8:2;         /* Output TOM_OUT(8) enable/disable update value. */
    } B;
  } TGC1_OUTEN_CTRL;

  union {                              /* TOM TGC1 Out Enable Control/Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t OUTEN_STAT15:2;        /* Control/status of output TOM_OUT(15). */
      vuint32_t OUTEN_STAT14:2;        /* Control/status of output TOM_OUT(14). */
      vuint32_t OUTEN_STAT13:2;        /* Control/status of output TOM_OUT(13). */
      vuint32_t OUTEN_STAT12:2;        /* Control/status of output TOM_OUT(12) */
      vuint32_t OUTEN_STAT11:2;        /* Control/status of output TOM_OUT(11). */
      vuint32_t OUTEN_STAT10:2;        /* Control/status of output TOM_OUT(10). */
      vuint32_t OUTEN_STAT9:2;         /* Control/status of output TOM_OUT(9). */
      vuint32_t OUTEN_STAT8:2;         /* Control/status of output TOM_OUT(8). */
    } B;
  } TGC1_OUTEN_STAT;

  union {                              /* TOM Channel n Control Register, n[0:14] */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t GCM:1;                 /* Gated Counter Mode enable. */
      vuint32_t SPEM:1;                /* SPE mode enable for channel. */
      vuint32_t  :1;
      vuint32_t OSM:1;                 /* One-shot mode.. */
      vuint32_t  :1;
      vuint32_t TRIGOUT:1;             /* Trigger output selection (output signal TRIG_[n]) of module TOM_CH[n]. */
      vuint32_t  :3;
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :5;
      vuint32_t CLK_SRC_SR:3;          /* Clock source select for channel. */
      vuint32_t SL:1;                  /* Signal level for duty cycle. */
      vuint32_t  :11;
    } B;
  } CH10_CTRL;

  union {                              /* TOM Channel n Shadow 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR0:16;                /* TOM channel n shadow register SR0 for update of compare register CM0. */
    } B;
  } CH10_SR0;

  union {                              /* TOM Channel n Shadow 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR1:16;                /* TOM channel n shadow register SR1 for update of compare register CM1. */
    } B;
  } CH10_SR1;

  union {                              /* TOM Channel n Compare 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM0:16;                /* TOM CCU0 compare register. */
    } B;
  } CH10_CM0;

  union {                              /* TOM Channel n Compare 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM1:16;                /* TOM CCU1 compare register. */
    } B;
  } CH10_CM1;

  union {                              /* TOM Channel n CN0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CN0:16;                /* TOM CCU0 counter register. */
    } B;
  } CH10_CN0;

  union {                              /* TOM Channel n Status Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :31;                  /* Reserved. */
      vuint32_t OL:1;                  /* Output level of output TOM_OUT(n). */
    } B;
  } CH10_STAT;

  union {                              /* TOM Channel n Interrupt Request Notification Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH10_IRQ_NOTIFY;

  union {                              /* TOM Channel n Interrupt Request Enable Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH10_IRQ_EN;

  union {                              /* TOM Channel n Force Interrupt Request Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t TRG_CCU1TC0:1;         /* Trigger TOM_CCU1TC0_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC0:1;         /* Trigger TOM_CCU0TC0_IRQ interrupt by software. */
    } B;
  } CH10_IRQ_FORCINT;

  union {                              /* TOM Channel n Interrupt Request Mode Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH10_IRQ_MODE;

  uint8_t TOM_reserved10[20];
  union {                              /* TOM Channel n Control Register, n[0:14] */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t GCM:1;                 /* Gated Counter Mode enable. */
      vuint32_t SPEM:1;                /* SPE mode enable for channel. */
      vuint32_t  :1;
      vuint32_t OSM:1;                 /* One-shot mode.. */
      vuint32_t  :1;
      vuint32_t TRIGOUT:1;             /* Trigger output selection (output signal TRIG_[n]) of module TOM_CH[n]. */
      vuint32_t  :3;
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :5;
      vuint32_t CLK_SRC_SR:3;          /* Clock source select for channel. */
      vuint32_t SL:1;                  /* Signal level for duty cycle. */
      vuint32_t  :11;
    } B;
  } CH11_CTRL;

  union {                              /* TOM Channel n Shadow 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR0:16;                /* TOM channel n shadow register SR0 for update of compare register CM0. */
    } B;
  } CH11_SR0;

  union {                              /* TOM Channel n Shadow 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR1:16;                /* TOM channel n shadow register SR1 for update of compare register CM1. */
    } B;
  } CH11_SR1;

  union {                              /* TOM Channel n Compare 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM0:16;                /* TOM CCU0 compare register. */
    } B;
  } CH11_CM0;

  union {                              /* TOM Channel n Compare 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM1:16;                /* TOM CCU1 compare register. */
    } B;
  } CH11_CM1;

  union {                              /* TOM Channel n CN0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CN0:16;                /* TOM CCU0 counter register. */
    } B;
  } CH11_CN0;

  union {                              /* TOM Channel n Status Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :31;                  /* Reserved. */
      vuint32_t OL:1;                  /* Output level of output TOM_OUT(n). */
    } B;
  } CH11_STAT;

  union {                              /* TOM Channel n Interrupt Request Notification Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH11_IRQ_NOTIFY;

  union {                              /* TOM Channel n Interrupt Request Enable Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH11_IRQ_EN;

  union {                              /* TOM Channel n Force Interrupt Request Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t TRG_CCU1TC0:1;         /* Trigger TOM_CCU1TC0_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC0:1;         /* Trigger TOM_CCU0TC0_IRQ interrupt by software. */
    } B;
  } CH11_IRQ_FORCINT;

  union {                              /* TOM Channel n Interrupt Request Mode Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH11_IRQ_MODE;

  uint8_t TOM_reserved11[20];
  union {                              /* TOM Channel n Control Register, n[0:14] */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t GCM:1;                 /* Gated Counter Mode enable. */
      vuint32_t SPEM:1;                /* SPE mode enable for channel. */
      vuint32_t  :1;
      vuint32_t OSM:1;                 /* One-shot mode.. */
      vuint32_t  :1;
      vuint32_t TRIGOUT:1;             /* Trigger output selection (output signal TRIG_[n]) of module TOM_CH[n]. */
      vuint32_t  :3;
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :5;
      vuint32_t CLK_SRC_SR:3;          /* Clock source select for channel. */
      vuint32_t SL:1;                  /* Signal level for duty cycle. */
      vuint32_t  :11;
    } B;
  } CH12_CTRL;

  union {                              /* TOM Channel n Shadow 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR0:16;                /* TOM channel n shadow register SR0 for update of compare register CM0. */
    } B;
  } CH12_SR0;

  union {                              /* TOM Channel n Shadow 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR1:16;                /* TOM channel n shadow register SR1 for update of compare register CM1. */
    } B;
  } CH12_SR1;

  union {                              /* TOM Channel n Compare 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM0:16;                /* TOM CCU0 compare register. */
    } B;
  } CH12_CM0;

  union {                              /* TOM Channel n Compare 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM1:16;                /* TOM CCU1 compare register. */
    } B;
  } CH12_CM1;

  union {                              /* TOM Channel n CN0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CN0:16;                /* TOM CCU0 counter register. */
    } B;
  } CH12_CN0;

  union {                              /* TOM Channel n Status Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :31;                  /* Reserved. */
      vuint32_t OL:1;                  /* Output level of output TOM_OUT(n). */
    } B;
  } CH12_STAT;

  union {                              /* TOM Channel n Interrupt Request Notification Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH12_IRQ_NOTIFY;

  union {                              /* TOM Channel n Interrupt Request Enable Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH12_IRQ_EN;

  union {                              /* TOM Channel n Force Interrupt Request Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t TRG_CCU1TC0:1;         /* Trigger TOM_CCU1TC0_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC0:1;         /* Trigger TOM_CCU0TC0_IRQ interrupt by software. */
    } B;
  } CH12_IRQ_FORCINT;

  union {                              /* TOM Channel n Interrupt Request Mode Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH12_IRQ_MODE;

  uint8_t TOM_reserved12[20];
  union {                              /* TOM Channel n Control Register, n[0:14] */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t GCM:1;                 /* Gated Counter Mode enable. */
      vuint32_t SPEM:1;                /* SPE mode enable for channel. */
      vuint32_t  :1;
      vuint32_t OSM:1;                 /* One-shot mode.. */
      vuint32_t  :1;
      vuint32_t TRIGOUT:1;             /* Trigger output selection (output signal TRIG_[n]) of module TOM_CH[n]. */
      vuint32_t  :3;
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :5;
      vuint32_t CLK_SRC_SR:3;          /* Clock source select for channel. */
      vuint32_t SL:1;                  /* Signal level for duty cycle. */
      vuint32_t  :11;
    } B;
  } CH13_CTRL;

  union {                              /* TOM Channel n Shadow 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR0:16;                /* TOM channel n shadow register SR0 for update of compare register CM0. */
    } B;
  } CH13_SR0;

  union {                              /* TOM Channel n Shadow 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR1:16;                /* TOM channel n shadow register SR1 for update of compare register CM1. */
    } B;
  } CH13_SR1;

  union {                              /* TOM Channel n Compare 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM0:16;                /* TOM CCU0 compare register. */
    } B;
  } CH13_CM0;

  union {                              /* TOM Channel n Compare 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM1:16;                /* TOM CCU1 compare register. */
    } B;
  } CH13_CM1;

  union {                              /* TOM Channel n CN0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CN0:16;                /* TOM CCU0 counter register. */
    } B;
  } CH13_CN0;

  union {                              /* TOM Channel n Status Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :31;                  /* Reserved. */
      vuint32_t OL:1;                  /* Output level of output TOM_OUT(n). */
    } B;
  } CH13_STAT;

  union {                              /* TOM Channel n Interrupt Request Notification Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH13_IRQ_NOTIFY;

  union {                              /* TOM Channel n Interrupt Request Enable Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH13_IRQ_EN;

  union {                              /* TOM Channel n Force Interrupt Request Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t TRG_CCU1TC0:1;         /* Trigger TOM_CCU1TC0_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC0:1;         /* Trigger TOM_CCU0TC0_IRQ interrupt by software. */
    } B;
  } CH13_IRQ_FORCINT;

  union {                              /* TOM Channel n Interrupt Request Mode Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH13_IRQ_MODE;

  uint8_t TOM_reserved13[20];
  union {                              /* TOM Channel n Control Register, n[0:14] */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t GCM:1;                 /* Gated Counter Mode enable. */
      vuint32_t SPEM:1;                /* SPE mode enable for channel. */
      vuint32_t  :1;
      vuint32_t OSM:1;                 /* One-shot mode.. */
      vuint32_t  :1;
      vuint32_t TRIGOUT:1;             /* Trigger output selection (output signal TRIG_[n]) of module TOM_CH[n]. */
      vuint32_t  :3;
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :5;
      vuint32_t CLK_SRC_SR:3;          /* Clock source select for channel. */
      vuint32_t SL:1;                  /* Signal level for duty cycle. */
      vuint32_t  :11;
    } B;
  } CH14_CTRL;

  union {                              /* TOM Channel n Shadow 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR0:16;                /* TOM channel n shadow register SR0 for update of compare register CM0. */
    } B;
  } CH14_SR0;

  union {                              /* TOM Channel n Shadow 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR1:16;                /* TOM channel n shadow register SR1 for update of compare register CM1. */
    } B;
  } CH14_SR1;

  union {                              /* TOM Channel n Compare 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM0:16;                /* TOM CCU0 compare register. */
    } B;
  } CH14_CM0;

  union {                              /* TOM Channel n Compare 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM1:16;                /* TOM CCU1 compare register. */
    } B;
  } CH14_CM1;

  union {                              /* TOM Channel n CN0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CN0:16;                /* TOM CCU0 counter register. */
    } B;
  } CH14_CN0;

  union {                              /* TOM Channel n Status Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :31;                  /* Reserved. */
      vuint32_t OL:1;                  /* Output level of output TOM_OUT(n). */
    } B;
  } CH14_STAT;

  union {                              /* TOM Channel n Interrupt Request Notification Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH14_IRQ_NOTIFY;

  union {                              /* TOM Channel n Interrupt Request Enable Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH14_IRQ_EN;

  union {                              /* TOM Channel n Force Interrupt Request Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t TRG_CCU1TC0:1;         /* Trigger TOM_CCU1TC0_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC0:1;         /* Trigger TOM_CCU0TC0_IRQ interrupt by software. */
    } B;
  } CH14_IRQ_FORCINT;

  union {                              /* TOM Channel n Interrupt Request Mode Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH14_IRQ_MODE;

  uint8_t TOM_reserved14[20];
  union {                              /* TOM Channel 15 Control register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t BITREV:1;              /* Bit-reversing of output of counter register CN0.. */
      vuint32_t OSM:1;                 /* One-shot mode. */
      vuint32_t  :1;
      vuint32_t TRIGOUT:1;             /* Trigger output selection (output signal TRIG_15) of module TOM_CH15. */
      vuint32_t  :3;
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :5;
      vuint32_t CLK_SRC_SR:3;          /* Clock source select for channel. */
      vuint32_t SL:1;                  /* Signal level for duty cycle. */
      vuint32_t  :11;
    } B;
  } CH15_CTRL;

  union {                              /* TOM Channel n Shadow 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR0:16;                /* TOM channel n shadow register SR0 for update of compare register CM0. */
    } B;
  } CH15_SR0;

  union {                              /* TOM Channel n Shadow 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR1:16;                /* TOM channel n shadow register SR1 for update of compare register CM1. */
    } B;
  } CH15_SR1;

  union {                              /* TOM Channel n Compare 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM0:16;                /* TOM CCU0 compare register. */
    } B;
  } CH15_CM0;

  union {                              /* TOM Channel n Compare 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM1:16;                /* TOM CCU1 compare register. */
    } B;
  } CH15_CM1;

  union {                              /* TOM Channel n CN0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CN0:16;                /* TOM CCU0 counter register. */
    } B;
  } CH15_CN0;

  union {                              /* TOM Channel n Status Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :31;                  /* Reserved. */
      vuint32_t OL:1;                  /* Output level of output TOM_OUT(n). */
    } B;
  } CH15_STAT;

  union {                              /* TOM Channel n Interrupt Request Notification Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH15_IRQ_NOTIFY;

  union {                              /* TOM Channel n Interrupt Request Enable Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH15_IRQ_EN;

  union {                              /* TOM Channel n Force Interrupt Request Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t TRG_CCU1TC0:1;         /* Trigger TOM_CCU1TC0_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC0:1;         /* Trigger TOM_CCU0TC0_IRQ interrupt by software. */
    } B;
  } CH15_IRQ_FORCINT;

  union {                              /* TOM Channel n Interrupt Request Mode Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH15_IRQ_MODE;
};


/* ============================================================================
   =============================== Module: I2C ================================
   ============================================================================ */

typedef union I2C_IBAD_union_tag {     /* I2C Bus Address Register */
  vuint8_t R;
  struct {
    vuint8_t ADR:7;
    vuint8_t  :1;
  } B;
} I2C_IBAD_tag;

typedef union I2C_IBFD_union_tag {     /* I2C Bus Frequency Divider Register */
  vuint8_t R;
  struct {
    vuint8_t IBC:8;
  } B;
} I2C_IBFD_tag;

typedef union I2C_IBCR_union_tag {     /* I2C Bus Control Register */
  vuint8_t R;
  struct {
    vuint8_t MDIS:1;
    vuint8_t IBIE:1;
    vuint8_t MSSL:1;
    vuint8_t TXRX:1;
    vuint8_t NOACK:1;
    vuint8_t RSTA:1;
    vuint8_t DMAEN:1;
    vuint8_t  :1;
  } B;
} I2C_IBCR_tag;

typedef union I2C_IBSR_union_tag {     /* I2C Bus Status Register */
  vuint8_t R;
  struct {
    vuint8_t TCF:1;
    vuint8_t IAAS:1;
    vuint8_t IBB:1;
    vuint8_t IBAL:1;
    vuint8_t  :1;
    vuint8_t SRW:1;
    vuint8_t IBIF:1;
    vuint8_t RXAK:1;
  } B;
} I2C_IBSR_tag;

typedef union I2C_IBDR_union_tag {     /* I2C Bus Data I/O Register */
  vuint8_t R;
  struct {
    vuint8_t DATA:8;
  } B;
} I2C_IBDR_tag;

typedef union I2C_IBIC_union_tag {     /* I2C Bus Interrupt Config Register */
  vuint8_t R;
  struct {
    vuint8_t BIIE:1;
    vuint8_t BYTERXIE:1;
    vuint8_t  :6;
  } B;
} I2C_IBIC_tag;

typedef union I2C_IBDBG_union_tag {    /* I2C Bus Debug Register */
  vuint8_t R;
  struct {
    vuint8_t  :6;
    vuint8_t IPG_DEBUG_HALTED:1;
    vuint8_t IPG_DEBUG_EN:1;
  } B;
} I2C_IBDBG_tag;

struct I2C_tag {
  I2C_IBAD_tag IBAD;                   /* I2C Bus Address Register */
  I2C_IBFD_tag IBFD;                   /* I2C Bus Frequency Divider Register */
  I2C_IBCR_tag IBCR;                   /* I2C Bus Control Register */
  I2C_IBSR_tag IBSR;                   /* I2C Bus Status Register */
  I2C_IBDR_tag IBDR;                   /* I2C Bus Data I/O Register */
  I2C_IBIC_tag IBIC;                   /* I2C Bus Interrupt Config Register */
  I2C_IBDBG_tag IBDBG;                 /* I2C Bus Debug Register */
};


/* ============================================================================
   =============================== Module: IMA ================================
   ============================================================================ */

typedef union IMA_CTRL_union_tag {     /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t READ:1;
  } B;
} IMA_CTRL_tag;

typedef union IMA_ENABLE_union_tag {   /* Enable Access Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t EN:1;
  } B;
} IMA_ENABLE_tag;

typedef union IMA_STATUS_union_tag {   /* Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :23;
    vuint32_t WRITE_LOCK:1;
    vuint32_t  :7;
    vuint32_t READ_LOCK:1;
  } B;
} IMA_STATUS_tag;

typedef union IMA_SLCT_union_tag {     /* RAM Select Register */
  vuint32_t R;
  struct {
    vuint32_t  :3;
    vuint32_t ROW_SLCT:13;
    vuint32_t  :10;
    vuint32_t ARRAY_SLCT:6;
  } B;
} IMA_SLCT_tag;

typedef union IMA_WRITE_UNLOCK_union_tag { /* Write Unlock Register */
  vuint32_t R;
  struct {
    vuint32_t WRITE_KEY:32;
  } B;
} IMA_WRITE_UNLOCK_tag;

typedef union IMA_READ_UNLOCK_union_tag { /* Read Unlock Register */
  vuint32_t R;
  struct {
    vuint32_t READ_KEY:32;
  } B;
} IMA_READ_UNLOCK_tag;

typedef union IMA_WRITE_DATA_4_union_tag { /* RAM Write Data Register 4 */
  vuint32_t R;
  struct {
    vuint32_t WRITE_4:32;
  } B;
} IMA_WRITE_DATA_4_tag;

typedef union IMA_WRITE_DATA_3_union_tag { /* RAM Write Data Register 3 */
  vuint32_t R;
  struct {
    vuint32_t WRITE_3:32;
  } B;
} IMA_WRITE_DATA_3_tag;

typedef union IMA_WRITE_DATA_2_union_tag { /* RAM Write Data Register 2 */
  vuint32_t R;
  struct {
    vuint32_t WRITE_2:32;
  } B;
} IMA_WRITE_DATA_2_tag;

typedef union IMA_WRITE_DATA_1_union_tag { /* RAM Write Data Register 1 */
  vuint32_t R;
  struct {
    vuint32_t WRITE_1:32;
  } B;
} IMA_WRITE_DATA_1_tag;

typedef union IMA_WRITE_DATA_0_union_tag { /* RAM Write Data Register 0 */
  vuint32_t R;
  struct {
    vuint32_t WRITE_0:32;
  } B;
} IMA_WRITE_DATA_0_tag;

typedef union IMA_READ_DATA_4_union_tag { /* RAM Read Data Register 4 */
  vuint32_t R;
  struct {
    vuint32_t READ_4:32;
  } B;
} IMA_READ_DATA_4_tag;

typedef union IMA_READ_DATA_3_union_tag { /* RAM Read Data Register 3 */
  vuint32_t R;
  struct {
    vuint32_t READ_3:32;
  } B;
} IMA_READ_DATA_3_tag;

typedef union IMA_READ_DATA_2_union_tag { /* RAM Read Data Register 2 */
  vuint32_t R;
  struct {
    vuint32_t READ_2:32;
  } B;
} IMA_READ_DATA_2_tag;

typedef union IMA_READ_DATA_1_union_tag { /* RAM Read Data Register 1 */
  vuint32_t R;
  struct {
    vuint32_t READ_1:32;
  } B;
} IMA_READ_DATA_1_tag;

typedef union IMA_READ_DATA_0_union_tag { /* RAM Read Data Register 0 */
  vuint32_t R;
  struct {
    vuint32_t READ_0:32;
  } B;
} IMA_READ_DATA_0_tag;

struct IMA_tag {
  IMA_CTRL_tag CTRL;                   /* Control Register */
  IMA_ENABLE_tag ENABLE;               /* Enable Access Register */
  IMA_STATUS_tag STATUS;               /* Status Register */
  IMA_SLCT_tag SLCT;                   /* RAM Select Register */
  IMA_WRITE_UNLOCK_tag WRITE_UNLOCK;   /* Write Unlock Register */
  IMA_READ_UNLOCK_tag READ_UNLOCK;     /* Read Unlock Register */
  uint8_t IMA_reserved0[20];
  IMA_WRITE_DATA_4_tag WRITE_DATA_4;   /* RAM Write Data Register 4 */
  IMA_WRITE_DATA_3_tag WRITE_DATA_3;   /* RAM Write Data Register 3 */
  IMA_WRITE_DATA_2_tag WRITE_DATA_2;   /* RAM Write Data Register 2 */
  IMA_WRITE_DATA_1_tag WRITE_DATA_1;   /* RAM Write Data Register 1 */
  IMA_WRITE_DATA_0_tag WRITE_DATA_0;   /* RAM Write Data Register 0 */
  uint8_t IMA_reserved1[12];
  IMA_READ_DATA_4_tag READ_DATA_4;     /* RAM Read Data Register 4 */
  IMA_READ_DATA_3_tag READ_DATA_3;     /* RAM Read Data Register 3 */
  IMA_READ_DATA_2_tag READ_DATA_2;     /* RAM Read Data Register 2 */
  IMA_READ_DATA_1_tag READ_DATA_1;     /* RAM Read Data Register 1 */
  IMA_READ_DATA_0_tag READ_DATA_0;     /* RAM Read Data Register 0 */
};


/* ============================================================================
   =============================== Module: INTC ===============================
   ============================================================================ */

typedef union INTC_BCR_union_tag {     /* INTC Block Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :19;
    vuint32_t HVEN3:1;
    vuint32_t  :3;
    vuint32_t HVEN2:1;
    vuint32_t  :3;
    vuint32_t HVEN1:1;
    vuint32_t  :3;
    vuint32_t HVEN0:1;
  } B;
} INTC_BCR_tag;

typedef union INTC_MPROT_union_tag {   /* INTC Master Protection Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t ID:2;
    vuint32_t  :3;
    vuint32_t MPROT:1;
  } B;
} INTC_MPROT_tag;

typedef union INTC_CPR_union_tag {     /* INTC Current Priority Register for Processor 0 */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t PRI:6;
  } B;
} INTC_CPR_tag;

typedef union INTC_IACKR_union_tag {   /* INTC Interrupt Acknowledge Register for Processor 0 */
  vuint32_t R;
  struct {
    vuint32_t VTBA:20;
    vuint32_t INTVEC:10;
    vuint32_t  :2;
  } B;
} INTC_IACKR_tag;

typedef union INTC_EOIR_union_tag {    /* INTC End Of Interrupt Register for Processor 0 */
  vuint32_t R;
  struct {
    vuint32_t EOI:32;
  } B;
} INTC_EOIR_tag;

typedef union INTC_SSCIR_union_tag {   /* INTC Software Set/Clear Interrupt Register */
  vuint8_t R;
  struct {
    vuint8_t  :6;
    vuint8_t SET:1;
    vuint8_t CLR:1;
  } B;
} INTC_SSCIR_tag;

typedef union INTC_PSR_union_tag {     /* INTC Priority Select Register */
  vuint16_t R;
  struct {
    vuint16_t PRC_SELN0:1;
    vuint16_t PRC_SELN1:1;
    vuint16_t PRC_SELN2:1;
    vuint16_t PRC_SELN3:1;
    vuint16_t  :3;
    vuint16_t SWTN:1;
    vuint16_t  :2;
    vuint16_t PRIN:6;
  } B;
} INTC_PSR_tag;

struct INTC_tag {
  INTC_BCR_tag BCR;                    /* INTC Block Configuration Register */
  INTC_MPROT_tag MPROT;                /* INTC Master Protection Register */
  uint8_t INTC_reserved0[8];
  INTC_CPR_tag CPR[4];                 /* INTC Current Priority Register for Processor 0 */
  INTC_IACKR_tag IACKR[4];             /* INTC Interrupt Acknowledge Register for Processor 0 */
  INTC_EOIR_tag EOIR[4];               /* INTC End Of Interrupt Register for Processor 0 */
  INTC_SSCIR_tag SSCIR[32];            /* INTC Software Set/Clear Interrupt Register */
  INTC_PSR_tag PSR[1024];              /* INTC Priority Select Register */
};


/* ============================================================================
   =============================== Module: IRCOSC =============================
   ============================================================================ */

typedef union IRCOSC_CTL_union_tag {   /* IRCOSC Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :7;
    vuint32_t  :1;
    vuint32_t  :3;
    vuint32_t USER_TRIM:5;
    vuint32_t  :3;
    vuint32_t  :5;
    vuint32_t  :2;
    vuint32_t  :1;
    vuint32_t  :5;
  } B;
} IRCOSC_CTL_tag;

struct IRCOSC_tag {
  IRCOSC_CTL_tag CTL;                  /* IRCOSC Control Register */
};


/* ============================================================================
   =============================== Module: JDC ================================
   ============================================================================ */

typedef union JDC_MCR_union_tag {      /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :15;
    vuint32_t JIN_IEN:1;
    vuint32_t  :15;
    vuint32_t JOUT_IEN:1;
  } B;
} JDC_MCR_tag;

typedef union JDC_MSR_union_tag {      /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :13;
    vuint32_t JIN_RDY:1;
    vuint32_t  :1;
    vuint32_t JIN_INT:1;
    vuint32_t  :13;
    vuint32_t JOUT_RDY:1;
    vuint32_t  :1;
    vuint32_t JOUT_INT:1;
  } B;
} JDC_MSR_tag;

typedef union JDC_JOUT_IPS_union_tag { /* JTAG Output Data Register */
  vuint32_t R;
  struct {
    vuint32_t Data:32;
  } B;
} JDC_JOUT_IPS_tag;

typedef union JDC_JIN_IPS_union_tag {  /* JTAG Input Data Register */
  vuint32_t R;
  struct {
    vuint32_t Data:32;
  } B;
} JDC_JIN_IPS_tag;

struct JDC_tag {
  JDC_MCR_tag MCR;                     /* Module Configuration Register */
  JDC_MSR_tag MSR;                     /* Module Status Register */
  JDC_JOUT_IPS_tag JOUT_IPS;           /* JTAG Output Data Register */
  JDC_JIN_IPS_tag JIN_IPS;             /* JTAG Input Data Register */
};


/* ============================================================================
   =============================== Module: JTAGM ==============================
   ============================================================================ */

typedef union JTAGM_MCR_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t SWRESET:1;
    vuint32_t evto0_sense:2;
    vuint32_t evto1_sense:2;
    vuint32_t evto_IE:1;
    vuint32_t evti0_assert:1;
    vuint32_t evti1_assert:1;
    vuint32_t  :10;
    vuint32_t inter_jtag_frame_timer:6;
    vuint32_t  :1;
    vuint32_t SIE:1;
    vuint32_t IIE:1;
    vuint32_t TCKSEL:3;
    vuint32_t jtagm_JCOMP:1;
    vuint32_t DTM:1;
  } B;
} JTAGM_MCR_tag;

typedef union JTAGM_SR_union_tag {     /* Status Register */
  vuint32_t R;
  struct {
    vuint32_t Overrun:1;
    vuint32_t  :1;
    vuint32_t TXGOOD:1;
    vuint32_t TXERROR:1;
    vuint32_t RXOVFL:1;
    vuint32_t INVFPS:1;
    vuint32_t INVICLC:1;
    vuint32_t ILLLCT:1;
    vuint32_t  :1;
    vuint32_t LVDSEN:1;
    vuint32_t JTAGEN:1;
    vuint32_t LVDSSAFE:1;
    vuint32_t JTAGSAFE:1;
    vuint32_t LVDSESC:1;
    vuint32_t LFASTEN:1;
    vuint32_t TOOL:1;
    vuint32_t evto0_edge:1;
    vuint32_t evto1_edge:1;
    vuint32_t SPU_INT_CLR:1;
    vuint32_t SPU_INT:1;
    vuint32_t CRC_err:1;
    vuint32_t Nexus_err:1;
    vuint32_t Idle:1;
    vuint32_t NR:1;
    vuint32_t CRC:8;
  } B;
} JTAGM_SR_tag;

typedef union JTAGM_DOR0_union_tag {   /* Data Out Register 0 */
  vuint32_t R;
  struct {
    vuint32_t TMS_HIGH:32;
  } B;
} JTAGM_DOR0_tag;

typedef union JTAGM_DOR1_union_tag {   /* Data Out Register 1 */
  vuint32_t R;
  struct {
    vuint32_t TMS_LOW:28;
    vuint32_t  :4;
  } B;
} JTAGM_DOR1_tag;

typedef union JTAGM_DOR2_union_tag {   /* Data Out Register 2 */
  vuint32_t R;
  struct {
    vuint32_t TDI_HIGH:32;
  } B;
} JTAGM_DOR2_tag;

typedef union JTAGM_DOR3_union_tag {   /* Data Out Register 3 */
  vuint32_t R;
  struct {
    vuint32_t TDI_LOW:28;
    vuint32_t  :3;
    vuint32_t Send:1;
  } B;
} JTAGM_DOR3_tag;

typedef union JTAGM_RxCRC_union_tag {  /* Receive CRC Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t CRC:8;
  } B;
} JTAGM_RxCRC_tag;

typedef union JTAGM_DIR0_union_tag {   /* Data Input Register 0 */
  vuint32_t R;
  struct {
    vuint32_t TDO_LOW:32;
  } B;
} JTAGM_DIR0_tag;

typedef union JTAGM_DIR1_union_tag {   /* Data Input Register 1 */
  vuint32_t R;
  struct {
    vuint32_t TDO_HIGH:28;
    vuint32_t  :4;
  } B;
} JTAGM_DIR1_tag;

struct JTAGM_tag {
  JTAGM_MCR_tag MCR;                   /* Module Configuration Register */
  JTAGM_SR_tag SR;                     /* Status Register */
  JTAGM_DOR0_tag DOR0;                 /* Data Out Register 0 */
  JTAGM_DOR1_tag DOR1;                 /* Data Out Register 1 */
  JTAGM_DOR2_tag DOR2;                 /* Data Out Register 2 */
  JTAGM_DOR3_tag DOR3;                 /* Data Out Register 3 */
  JTAGM_RxCRC_tag RxCRC;               /* Receive CRC Register */
  JTAGM_DIR0_tag DIR0;                 /* Data Input Register 0 */
  JTAGM_DIR1_tag DIR1;                 /* Data Input Register 1 */
};


/* ============================================================================
   =============================== Module: LFAST ==============================
   ============================================================================ */

typedef union LFAST_MCR_union_tag {    /* LFAST Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MSEN:1;
    vuint32_t  :6;
    vuint32_t IPGDBG:1;
    vuint32_t  :7;
    vuint32_t LSSEL:1;
    vuint32_t DRFEN:1;
    vuint32_t RXEN:1;
    vuint32_t TXEN:1;
    vuint32_t  :8;
    vuint32_t TXARBD:1;
    vuint32_t CTSEN:1;
    vuint32_t  :1;
    vuint32_t DRFRST:1;
    vuint32_t DATAEN:1;
  } B;
} LFAST_MCR_tag;

typedef union LFAST_SCR_union_tag {    /* LFAST Speed Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :15;
    vuint32_t DRMD:1;
    vuint32_t  :7;
    vuint32_t RDR:1;
    vuint32_t  :7;
    vuint32_t TDR:1;
  } B;
} LFAST_SCR_tag;

typedef union LFAST_COCR_union_tag {   /* LFAST Correlator Control Register */
  vuint32_t R;
  struct {
    vuint32_t SMPSEL:8;
    vuint32_t  :6;
    vuint32_t  :2;
    vuint32_t  :12;
    vuint32_t CORRTH:3;
    vuint32_t PHSSEL:1;
  } B;
} LFAST_COCR_tag;

typedef union LFAST_TMCR_union_tag {   /* LFAST Test Mode Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :6;
    vuint32_t CLKTST:1;
    vuint32_t LPON:1;
    vuint32_t  :5;
    vuint32_t LPMOD:3;
    vuint32_t LPFRMTH:16;
  } B;
} LFAST_TMCR_tag;

typedef union LFAST_ALCR_union_tag {   /* LFAST Auto Loopback Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :15;
    vuint32_t LPCNTEN:1;
    vuint32_t LPFMCNT:16;
  } B;
} LFAST_ALCR_tag;

typedef union LFAST_RCDCR_union_tag {  /* LFAST Rate Change Delay Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t DRCNT:4;
    vuint32_t  :16;
  } B;
} LFAST_RCDCR_tag;

typedef union LFAST_SLCR_union_tag {   /* LFAST Wakeup Delay Control Register */
  vuint32_t R;
  struct {
    vuint32_t HSCNT:8;
    vuint32_t  :4;
    vuint32_t LSCNT:4;
    vuint32_t HWKCNT:8;
    vuint32_t  :4;
    vuint32_t LWKCNT:4;
  } B;
} LFAST_SLCR_tag;

typedef union LFAST_ICR_union_tag {    /* LFAST ICLC Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :14;
    vuint32_t ICLCSEQ:1;
    vuint32_t SNDICLC:1;
    vuint32_t  :8;
    vuint32_t ICLCPLD:8;
  } B;
} LFAST_ICR_tag;

typedef union LFAST_PICR_union_tag {   /* LFAST Ping Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :15;
    vuint32_t PNGREQ:1;
    vuint32_t PNGAUTO:1;
    vuint32_t  :7;
    vuint32_t PNGPYLD:8;
  } B;
} LFAST_PICR_tag;

typedef union LFAST_RFCR_union_tag {   /* LFAST Rx FIFO CTS Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :10;
    vuint32_t RCTSMX:6;
    vuint32_t  :10;
    vuint32_t RCTSMN:6;
  } B;
} LFAST_RFCR_tag;

typedef union LFAST_TIER_union_tag {   /* LFAST Tx Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :14;
    vuint32_t TXIIE:1;
    vuint32_t TXOVIE:1;
    vuint32_t  :11;
    vuint32_t TXPNGIE:1;
    vuint32_t  :1;
    vuint32_t TXUNSIE:1;
    vuint32_t TXICLCIE:1;
    vuint32_t TXDTIE:1;
  } B;
} LFAST_TIER_tag;

typedef union LFAST_RIER_union_tag {   /* LFAST Rx Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RXUOIE:1;
    vuint32_t RXMNIE:1;
    vuint32_t RXMXIE:1;
    vuint32_t RXUFIE:1;
    vuint32_t RXOFIE:1;
    vuint32_t RXSZIE:1;
    vuint32_t RXICIE:1;
    vuint32_t RXLCEIE:1;
    vuint32_t  :12;
    vuint32_t RXCTSIE:1;
    vuint32_t RXDIE:1;
    vuint32_t RXUNSIE:1;
    vuint32_t  :1;
  } B;
} LFAST_RIER_tag;

typedef union LFAST_RIIER_union_tag {  /* LFAST Rx ICLC Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :18;
    vuint32_t ICPFIE:1;
    vuint32_t ICPSIE:1;
    vuint32_t ICPRIE:1;
    vuint32_t ICTOIE:1;
    vuint32_t ICLPIE:1;
    vuint32_t ICCTIE:1;
    vuint32_t ICTDIE:1;
    vuint32_t ICTEIE:1;
    vuint32_t ICRFIE:1;
    vuint32_t ICRSIE:1;
    vuint32_t ICTFIE:1;
    vuint32_t ICTSIE:1;
    vuint32_t ICPOFIE:1;
    vuint32_t ICPONIE:1;
  } B;
} LFAST_RIIER_tag;

typedef union LFAST_PLLCR_union_tag {  /* LFAST PLL Control Register */
  vuint32_t R;
  struct {
    vuint32_t IPTMOD:3;
    vuint32_t  :11;
    vuint32_t SWPOFF:1;
    vuint32_t SWPON:1;
    vuint32_t REFINV:1;
    vuint32_t LPCFG:2;
    vuint32_t  :2;
    vuint32_t PLCKCW:2;
    vuint32_t FDIVEN:1;
    vuint32_t FBDIV:6;
    vuint32_t PREDIV:2;
  } B;
} LFAST_PLLCR_tag;

typedef union LFAST_LCR_union_tag {    /* LFAST LVDS Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t SWWKLD:1;
    vuint32_t SWSLPLD:1;
    vuint32_t SWWKLR:1;
    vuint32_t SWSLPLR:1;
    vuint32_t SWOFFLD:1;
    vuint32_t SWONLD:1;
    vuint32_t SWOFFLR:1;
    vuint32_t SWONLR:1;
    vuint32_t LVRXOFF:1;
    vuint32_t LVTXOE:1;
    vuint32_t TXCMUX:1;
    vuint32_t LVRFEN:1;
    vuint32_t LVLPEN:1;                /* Tx LVDS internal loopback enable */
    vuint32_t  :5;
    vuint32_t LVRXOP_TR:1;
    vuint32_t  :1;
    vuint32_t LVRXOP_BR:1;
    vuint32_t LVTXOP:1;
    vuint32_t LVCKSS:1;                /* LVDS Clock Sync Select */
    vuint32_t LVCKP:1;
  } B;
} LFAST_LCR_tag;

typedef union LFAST_UNSTCR_union_tag { /* LFAST Unsolicited Tx Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :15;
    vuint32_t USNDRQ:1;
    vuint32_t  :9;
    vuint32_t UNSHDR:7;
  } B;
} LFAST_UNSTCR_tag;

typedef union LFAST_UNSTDR_union_tag { /* LFAST Unsolicited Tx Data Registers */
  vuint32_t R;
  struct {
    vuint32_t UNTXD:32;
  } B;
} LFAST_UNSTDR_tag;

typedef union LFAST_GSR_union_tag {    /* LFAST Global Status Register */
  vuint32_t R;
  struct {
    vuint32_t DUALMD:1;
    vuint32_t  :12;
    vuint32_t LRMD:1;
    vuint32_t LDSM:1;
    vuint32_t DRSM:1;
    vuint32_t  :11;
    vuint32_t LPTXDN:1;
    vuint32_t LPFPDV:1;
    vuint32_t LPCPDV:1;
    vuint32_t LPCHDV:1;
    vuint32_t LPCSDV:1;
  } B;
} LFAST_GSR_tag;

typedef union LFAST_PISR_union_tag {   /* LFAST Ping Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t RXPNGD:8;
  } B;
} LFAST_PISR_tag;

typedef union LFAST_DFSR_union_tag {   /* LFAST Data Frame Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t RXDCNT:6;
    vuint32_t  :5;
    vuint32_t RXFCNT:3;
    vuint32_t  :2;
    vuint32_t TXDCNT:6;
    vuint32_t  :5;
    vuint32_t TXFCNT:3;
  } B;
} LFAST_DFSR_tag;

typedef union LFAST_TISR_union_tag {   /* LFAST Tx Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :14;
    vuint32_t TXIEF:1;
    vuint32_t TXOVF:1;
    vuint32_t  :11;
    vuint32_t TXPNGF:1;
    vuint32_t  :1;
    vuint32_t TXUNSF:1;
    vuint32_t TXICLCF:1;
    vuint32_t TXDTF:1;
  } B;
} LFAST_TISR_tag;

typedef union LFAST_RISR_union_tag {   /* LFAST Rx Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RXUOF:1;
    vuint32_t RXMNF:1;
    vuint32_t RXMXF:1;
    vuint32_t RXUFF:1;
    vuint32_t RXOFF:1;
    vuint32_t RXSZF:1;
    vuint32_t RXICF:1;
    vuint32_t RXLCEF:1;
    vuint32_t  :12;
    vuint32_t RXCTSF:1;
    vuint32_t RXDF:1;
    vuint32_t RXUNSF:1;
    vuint32_t  :1;
  } B;
} LFAST_RISR_tag;

typedef union LFAST_RIISR_union_tag {  /* LFAST Rx ICLC Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :18;
    vuint32_t ICPFF:1;
    vuint32_t ICPSF:1;
    vuint32_t ICPRF:1;
    vuint32_t ICTOF:1;
    vuint32_t ICLPF:1;
    vuint32_t ICCTF:1;
    vuint32_t ICTDF:1;
    vuint32_t ICTEF:1;
    vuint32_t ICRFF:1;
    vuint32_t ICRSF:1;
    vuint32_t ICTFF:1;
    vuint32_t ICTSF:1;
    vuint32_t ICPOFF:1;
    vuint32_t ICPONF:1;
  } B;
} LFAST_RIISR_tag;

typedef union LFAST_PLLLSR_union_tag { /* LFAST PLL and LVDS Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :14;
    vuint32_t PLLDIS:1;
    vuint32_t PLDCR:1;
    vuint32_t  :12;
    vuint32_t LRSLPS:1;
    vuint32_t LDSLPS:1;
    vuint32_t LDPDS:1;
    vuint32_t LRPDS:1;
  } B;
} LFAST_PLLLSR_tag;

typedef union LFAST_UNSRSR_union_tag { /* LFAST Unsolicited Rx Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :23;
    vuint32_t URXDV:1;
    vuint32_t  :5;
    vuint32_t URPCNT:3;
  } B;
} LFAST_UNSRSR_tag;

typedef union LFAST_UNSRDR_union_tag { /* LFAST Unsolicited Rx Data Register */
  vuint32_t R;
  struct {
    vuint32_t UNRXD:32;
  } B;
} LFAST_UNSRDR_tag;

struct LFAST_tag {
  LFAST_MCR_tag MCR;                   /* LFAST Mode Configuration Register */
  LFAST_SCR_tag SCR;                   /* LFAST Speed Control Register */
  LFAST_COCR_tag COCR;                 /* LFAST Correlator Control Register */
  LFAST_TMCR_tag TMCR;                 /* LFAST Test Mode Control Register */
  LFAST_ALCR_tag ALCR;                 /* LFAST Auto Loopback Control Register */
  LFAST_RCDCR_tag RCDCR;               /* LFAST Rate Change Delay Control Register */
  LFAST_SLCR_tag SLCR;                 /* LFAST Wakeup Delay Control Register */
  LFAST_ICR_tag ICR;                   /* LFAST ICLC Control Register */
  LFAST_PICR_tag PICR;                 /* LFAST Ping Control Register */
  uint8_t LFAST_reserved0[8];
  LFAST_RFCR_tag RFCR;                 /* LFAST Rx FIFO CTS Control Register */
  LFAST_TIER_tag TIER;                 /* LFAST Tx Interrupt Enable Register */
  LFAST_RIER_tag RIER;                 /* LFAST Rx Interrupt Enable Register */
  LFAST_RIIER_tag RIIER;               /* LFAST Rx ICLC Interrupt Enable Register */
  LFAST_PLLCR_tag PLLCR;               /* LFAST PLL Control Register */
  LFAST_LCR_tag LCR;                   /* LFAST LVDS Control Register */
  LFAST_UNSTCR_tag UNSTCR;             /* LFAST Unsolicited Tx Control Register */
  LFAST_UNSTDR_tag UNSTDR[9];          /* LFAST Unsolicited Tx Data Registers */
  uint8_t LFAST_reserved1[20];
  LFAST_GSR_tag GSR;                   /* LFAST Global Status Register */
  LFAST_PISR_tag PISR;                 /* LFAST Ping Status Register */
  uint8_t LFAST_reserved2[12];
  LFAST_DFSR_tag DFSR;                 /* LFAST Data Frame Status Register */
  LFAST_TISR_tag TISR;                 /* LFAST Tx Interrupt Status Register */
  LFAST_RISR_tag RISR;                 /* LFAST Rx Interrupt Status Register */
  LFAST_RIISR_tag RIISR;               /* LFAST Rx ICLC Interrupt Status Register */
  LFAST_PLLLSR_tag PLLLSR;             /* LFAST PLL and LVDS Status Register */
  LFAST_UNSRSR_tag UNSRSR;             /* LFAST Unsolicited Rx Status Register */
  LFAST_UNSRDR_tag UNSRDR[9];          /* LFAST Unsolicited Rx Data Register */
};


/* ============================================================================
   =============================== Module: LINFlexD ===========================
   ============================================================================ */

typedef union LINFlexD_LINCR1_union_tag { /* LIN Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t CCD:1;
    vuint32_t CFD:1;
    vuint32_t LASE:1;
    vuint32_t AUTOWU:1;
    vuint32_t MBL:4;
    vuint32_t BF:1;
    vuint32_t  :1;
    vuint32_t LBKM:1;
    vuint32_t MME:1;
    vuint32_t SSBL:1;
    vuint32_t RBLM:1;
    vuint32_t SLEEP:1;
    vuint32_t INIT:1;
  } B;
} LINFlexD_LINCR1_tag;

typedef union LINFlexD_LINIER_union_tag { /* LIN Interrupt enable register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t SZIE:1;
    vuint32_t OCIE:1;
    vuint32_t BEIE:1;
    vuint32_t CEIE:1;
    vuint32_t HEIE:1;
    vuint32_t  :2;
    vuint32_t FEIE:1;
    vuint32_t BOIE:1;
    vuint32_t LSIE:1;
    vuint32_t WUIE:1;
    vuint32_t DBFIE:1;
    vuint32_t DBEIETOIE:1;
    vuint32_t DRIE:1;
    vuint32_t DTIE:1;
    vuint32_t HRIE:1;
  } B;
} LINFlexD_LINIER_tag;

typedef union LINFlexD_LINSR_union_tag { /* LIN Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t AUTOSYNC_COMP:1;
    vuint32_t RDC:3;
    vuint32_t LINS:4;                  /* LIN state */
    vuint32_t  :2;
    vuint32_t RMB:1;
    vuint32_t DRBNE:1;
    vuint32_t RXbusy:1;
    vuint32_t RDI:1;
    vuint32_t WUF:1;
    vuint32_t DBFF:1;
    vuint32_t DBEF:1;
    vuint32_t DRF:1;
    vuint32_t DTF:1;
    vuint32_t HRF:1;
  } B;
} LINFlexD_LINSR_tag;

typedef union LINFlexD_LINESR_union_tag { /* LIN Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t SZF:1;
    vuint32_t OCF:1;
    vuint32_t BEF:1;
    vuint32_t CEF:1;
    vuint32_t SFEF:1;
    vuint32_t SDEF:1;
    vuint32_t IDPEF:1;
    vuint32_t FEF:1;
    vuint32_t BOF:1;
    vuint32_t  :6;
    vuint32_t NF:1;
  } B;
} LINFlexD_LINESR_tag;

typedef union LINFlexD_UARTCR_union_tag { /* UART Mode Control Register */
  vuint32_t R;
  struct {
    vuint32_t MIS:1;
    vuint32_t CSP:3;
    vuint32_t OSR:4;
    vuint32_t ROSE:1;
    vuint32_t NEF:3;
    vuint32_t DTU_PCETX:1;             /* Disable Timeout in UART mode/Parity transmission and checking */
    vuint32_t SBUR:2;
    vuint32_t WLS:1;
    vuint32_t TDFL_TFC:3;
    vuint32_t RDFL_RFC:3;
    vuint32_t RFBM:1;
    vuint32_t TFBM:1;
    vuint32_t WL1:1;
    vuint32_t PC1:1;
    vuint32_t RxEn:1;
    vuint32_t TxEn:1;
    vuint32_t PC0:1;
    vuint32_t PCE:1;
    vuint32_t WL0:1;
    vuint32_t UART:1;
  } B;
} LINFlexD_UARTCR_tag;

typedef union LINFlexD_UARTSR_union_tag { /* UART Mode Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t SZF:1;
    vuint32_t OCF:1;
    vuint32_t PE:4;
    vuint32_t RMB:1;
    vuint32_t FEF:1;
    vuint32_t BOF:1;
    vuint32_t RDI:1;
    vuint32_t WUF:1;
    vuint32_t RFNE:1;
    vuint32_t TO:1;
    vuint32_t DRFRFE:1;
    vuint32_t DTFTFF:1;
    vuint32_t NF:1;
  } B;
} LINFlexD_UARTSR_tag;

typedef union LINFlexD_LINTCSR_union_tag { /* LIN Time-Out Control Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t MODE:1;
    vuint32_t IOT:1;
    vuint32_t TOCE:1;
    vuint32_t CNT:8;
  } B;
} LINFlexD_LINTCSR_tag;

typedef union LINFlexD_LINOCR_union_tag { /* LIN Output Compare Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t OC2:8;
    vuint32_t OC1:8;
  } B;
} LINFlexD_LINOCR_tag;

typedef union LINFlexD_LINTOCR_union_tag { /* LIN Time-Out Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :20;
    vuint32_t RTO:4;
    vuint32_t  :1;
    vuint32_t HTO:7;
  } B;
} LINFlexD_LINTOCR_tag;

typedef union LINFlexD_LINFBRR_union_tag { /* LIN Fractional Baud Rate Register */
  vuint32_t R;
  struct {
    vuint32_t  :28;
    vuint32_t FBR:4;
  } B;
} LINFlexD_LINFBRR_tag;

typedef union LINFlexD_LINIBRR_union_tag { /* LIN Integer Baud Rate Register */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t IBR:20;
  } B;
} LINFlexD_LINIBRR_tag;

typedef union LINFlexD_LINCFR_union_tag { /* LIN Checksum Field Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t CF:8;
  } B;
} LINFlexD_LINCFR_tag;

typedef union LINFlexD_LINCR2_union_tag { /* LIN Control Register 2 */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t TBDE:1;
    vuint32_t IOBE:1;
    vuint32_t IOPE:1;
    vuint32_t WURQ:1;
    vuint32_t DDRQ:1;
    vuint32_t DTRQ:1;
    vuint32_t ABRQ:1;
    vuint32_t HTRQ:1;
    vuint32_t  :8;
  } B;
} LINFlexD_LINCR2_tag;

typedef union LINFlexD_BIDR_union_tag { /* Buffer Identifier Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t DFL:6;
    vuint32_t DIR:1;
    vuint32_t CCS:1;
    vuint32_t  :2;
    vuint32_t ID:6;
  } B;
} LINFlexD_BIDR_tag;

typedef union LINFlexD_BDRL_union_tag { /* Buffer Data Register Least Significant */
  vuint32_t R;
  struct {
    vuint32_t DATA3:8;
    vuint32_t DATA2:8;
    vuint32_t DATA1:8;
    vuint32_t DATA0:8;
  } B;
} LINFlexD_BDRL_tag;

typedef union LINFlexD_BDRM_union_tag { /* Buffer Data Register Most Significant */
  vuint32_t R;
  struct {
    vuint32_t DATA7:8;
    vuint32_t DATA6:8;
    vuint32_t DATA5:8;
    vuint32_t DATA4:8;
  } B;
} LINFlexD_BDRM_tag;

typedef union LINFlexD_IFER_union_tag { /* Identifier Filter Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t FACT:16;
  } B;
} LINFlexD_IFER_tag;

typedef union LINFlexD_IFMI_union_tag { /* Identifier Filter Match Index */
  vuint32_t R;
  struct {
    vuint32_t  :27;
    vuint32_t IFMI:5;
  } B;
} LINFlexD_IFMI_tag;

typedef union LINFlexD_IFMR_union_tag { /* Identifier Filter Mode Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t IFM:8;
  } B;
} LINFlexD_IFMR_tag;

typedef union LINFlexD_IFCR_union_tag { /* Identifier Filter Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t DFL:6;                   /* Data Field Length */
    vuint32_t DIR:1;                   /* Direction */
    vuint32_t CCS:1;                   /* Classic Checksum */
    vuint32_t  :2;
    vuint32_t ID:6;                    /* Identifier */
  } B;
} LINFlexD_IFCR_tag;

typedef union LINFlexD_GCR_union_tag { /* Global Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t TDFBM:1;
    vuint32_t RDFBM:1;
    vuint32_t TDLIS:1;
    vuint32_t RDLIS:1;
    vuint32_t STOP:1;
    vuint32_t SR:1;
  } B;
} LINFlexD_GCR_tag;

typedef union LINFlexD_UARTPTO_union_tag { /* UART Preset Timeout Register */
  vuint32_t R;
  struct {
    vuint32_t  :20;
    vuint32_t PTO:12;
  } B;
} LINFlexD_UARTPTO_tag;

typedef union LINFlexD_UARTCTO_union_tag { /* UART Current Timeout Register */
  vuint32_t R;
  struct {
    vuint32_t  :20;
    vuint32_t CTO:12;
  } B;
} LINFlexD_UARTCTO_tag;

typedef union LINFlexD_DMATXE_union_tag { /* DMA Tx Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t DTE:16;
  } B;
} LINFlexD_DMATXE_tag;

typedef union LINFlexD_DMARXE_union_tag { /* DMA Rx Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t DRE:16;
  } B;
} LINFlexD_DMARXE_tag;

typedef union LINFlexD_PTD_union_tag { /* PSI5-S Tx Delay register */
  vuint32_t R;
  struct {
    vuint32_t  :27;
    vuint32_t IFD:4;
    vuint32_t EN:1;
  } B;
} LINFlexD_PTD_tag;

struct LINFlexD_tag {
  LINFlexD_LINCR1_tag LINCR1;          /* LIN Control Register 1 */
  LINFlexD_LINIER_tag LINIER;          /* LIN Interrupt enable register */
  LINFlexD_LINSR_tag LINSR;            /* LIN Status Register */
  LINFlexD_LINESR_tag LINESR;          /* LIN Error Status Register */
  LINFlexD_UARTCR_tag UARTCR;          /* UART Mode Control Register */
  LINFlexD_UARTSR_tag UARTSR;          /* UART Mode Status Register */
  LINFlexD_LINTCSR_tag LINTCSR;        /* LIN Time-Out Control Status Register */
  LINFlexD_LINOCR_tag LINOCR;          /* LIN Output Compare Register */
  LINFlexD_LINTOCR_tag LINTOCR;        /* LIN Time-Out Control Register */
  LINFlexD_LINFBRR_tag LINFBRR;        /* LIN Fractional Baud Rate Register */
  LINFlexD_LINIBRR_tag LINIBRR;        /* LIN Integer Baud Rate Register */
  LINFlexD_LINCFR_tag LINCFR;          /* LIN Checksum Field Register */
  LINFlexD_LINCR2_tag LINCR2;          /* LIN Control Register 2 */
  LINFlexD_BIDR_tag BIDR;              /* Buffer Identifier Register */
  LINFlexD_BDRL_tag BDRL;              /* Buffer Data Register Least Significant */
  LINFlexD_BDRM_tag BDRM;              /* Buffer Data Register Most Significant */
  LINFlexD_IFER_tag IFER;              /* Identifier Filter Enable Register */
  LINFlexD_IFMI_tag IFMI;              /* Identifier Filter Match Index */
  LINFlexD_IFMR_tag IFMR;              /* Identifier Filter Mode Register */
  LINFlexD_IFCR_tag IFCR[16];          /* Identifier Filter Control Register */
  LINFlexD_GCR_tag GCR;                /* Global Control Register */
  LINFlexD_UARTPTO_tag UARTPTO;        /* UART Preset Timeout Register */
  LINFlexD_UARTCTO_tag UARTCTO;        /* UART Current Timeout Register */
  LINFlexD_DMATXE_tag DMATXE;          /* DMA Tx Enable Register */
  LINFlexD_DMARXE_tag DMARXE;          /* DMA Rx Enable Register */
  LINFlexD_PTD_tag PTD;                /* PSI5-S Tx Delay register */
};


/* ============================================================================
   =============================== Module: MC_CGM =============================
   ============================================================================ */

typedef union MC_CGM_AC5_CDC0_union_tag { /* Auxiliary Clock 5 Cascaded Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :5;
    vuint32_t DIV:10;
    vuint32_t  :16;
  } B;
} MC_CGM_AC5_CDC0_tag;

typedef union MC_CGM_AC5_CDC1_union_tag { /* Auxiliary Clock 5 Cascaded Divider 1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :5;
    vuint32_t DIV:10;
    vuint32_t  :16;
  } B;
} MC_CGM_AC5_CDC1_tag;

typedef union MC_CGM_AC5_CDC2_union_tag { /* Auxiliary Clock 5 Cascaded Divider 2 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :5;
    vuint32_t DIV:10;
    vuint32_t  :16;
  } B;
} MC_CGM_AC5_CDC2_tag;

typedef union MC_CGM_AC5_CDC10_union_tag { /* Auxiliary Clock 5 Cascaded Divider 10 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :5;
    vuint32_t DIV:10;
    vuint32_t  :16;
  } B;
} MC_CGM_AC5_CDC10_tag;

typedef union MC_CGM_AC5_CDC11_union_tag { /* Auxiliary Clock 5 Cascaded Divider 11 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :5;
    vuint32_t DIV:10;
    vuint32_t  :16;
  } B;
} MC_CGM_AC5_CDC11_tag;

typedef union MC_CGM_AC5_CDC12_union_tag { /* Auxiliary Clock 5 Cascaded Divider 12 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :5;
    vuint32_t DIV:10;
    vuint32_t  :16;
  } B;
} MC_CGM_AC5_CDC12_tag;

typedef union MC_CGM_AC5_CDC13_union_tag { /* Auxiliary Clock 5 Cascaded Divider 13 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :5;
    vuint32_t DIV:10;
    vuint32_t  :16;
  } B;
} MC_CGM_AC5_CDC13_tag;

typedef union MC_CGM_AC5_CDC20_union_tag { /* Auxiliary Clock 5 Cascaded Divider 20 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :5;
    vuint32_t DIV:10;
    vuint32_t  :16;
  } B;
} MC_CGM_AC5_CDC20_tag;

typedef union MC_CGM_AC5_CDC21_union_tag { /* Auxiliary Clock 5 Cascaded Divider 21 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :5;
    vuint32_t DIV:10;
    vuint32_t  :16;
  } B;
} MC_CGM_AC5_CDC21_tag;

typedef union MC_CGM_AC5_CDC22_union_tag { /* Auxiliary Clock 5 Cascaded Divider 22 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :5;
    vuint32_t DIV:10;
    vuint32_t  :16;
  } B;
} MC_CGM_AC5_CDC22_tag;

typedef union MC_CGM_AC5_CDC23_union_tag { /* Auxiliary Clock 5 Cascaded Divider 23 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :5;
    vuint32_t DIV:10;
    vuint32_t  :16;
  } B;
} MC_CGM_AC5_CDC23_tag;

typedef union MC_CGM_PCS_SDUR_union_tag { /* PCS Switch Duration Register */
  vuint8_t R;
  struct {
    vuint8_t SDUR:8;
  } B;
} MC_CGM_PCS_SDUR_tag;

typedef union MC_CGM_PCS_DIVC1_union_tag { /* PCS Divider Change Register 1 */
  vuint32_t R;
  struct {
    vuint32_t INIT:16;
    vuint32_t  :8;
    vuint32_t RATE:8;
  } B;
} MC_CGM_PCS_DIVC1_tag;

typedef union MC_CGM_PCS_DIVE1_union_tag { /* PCS Divider End Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t DIVE:20;
  } B;
} MC_CGM_PCS_DIVE1_tag;

typedef union MC_CGM_PCS_DIVS1_union_tag { /* PCS Divider Start Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t DIVS:20;
  } B;
} MC_CGM_PCS_DIVS1_tag;

typedef union MC_CGM_PCS_DIVC2_union_tag { /* PCS Divider Change Register 2 */
  vuint32_t R;
  struct {
    vuint32_t INIT:16;
    vuint32_t  :8;
    vuint32_t RATE:8;
  } B;
} MC_CGM_PCS_DIVC2_tag;

typedef union MC_CGM_PCS_DIVE2_union_tag { /* PCS Divider End Register 2 */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t DIVE:20;
  } B;
} MC_CGM_PCS_DIVE2_tag;

typedef union MC_CGM_PCS_DIVS2_union_tag { /* PCS Divider Start Register 2 */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t DIVS:20;
  } B;
} MC_CGM_PCS_DIVS2_tag;

typedef union MC_CGM_PCS_DIVC4_union_tag { /* PCS Divider Change Register 4 */
  vuint32_t R;
  struct {
    vuint32_t INIT:16;
    vuint32_t  :8;
    vuint32_t RATE:8;
  } B;
} MC_CGM_PCS_DIVC4_tag;

typedef union MC_CGM_PCS_DIVE4_union_tag { /* PCS Divider End Register 4 */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t DIVE:20;
  } B;
} MC_CGM_PCS_DIVE4_tag;

typedef union MC_CGM_PCS_DIVS4_union_tag { /* PCS Divider Start Register 4 */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t DIVS:20;
  } B;
} MC_CGM_PCS_DIVS4_tag;

typedef union MC_CGM_SC_DIV_RC_union_tag { /* System Clock Divider Ratio Change Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t SYS_DIV_RATIO_CHNG:1;
  } B;
} MC_CGM_SC_DIV_RC_tag;

typedef union MC_CGM_DIV_UPD_TYPE_union_tag { /* Divider Update Type Register */
  vuint32_t R;
  struct {
    vuint32_t SYS_UPD_TYPE:1;
    vuint32_t  :31;
  } B;
} MC_CGM_DIV_UPD_TYPE_tag;

typedef union MC_CGM_DIV_UPD_TRIG_union_tag { /* Divider Update Trigger Register */
  vuint32_t R;
  struct {
    vuint32_t DIV_UPD_TRIGGER:32;
  } B;
} MC_CGM_DIV_UPD_TRIG_tag;

typedef union MC_CGM_DIV_UPD_STAT_union_tag { /* Divider Update Status Register */
  vuint32_t R;
  struct {
    vuint32_t SYS_UPD_STAT:1;
    vuint32_t  :31;
  } B;
} MC_CGM_DIV_UPD_STAT_tag;

typedef union MC_CGM_SC_SS_union_tag { /* System Clock Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELSTAT:4;
    vuint32_t  :4;
    vuint32_t SWTRG:3;
    vuint32_t SWIP:1;
    vuint32_t  :16;
  } B;
} MC_CGM_SC_SS_tag;

typedef union MC_CGM_SC_DC0_union_tag { /* System Clock Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :9;
    vuint32_t DIV:6;
    vuint32_t  :16;
  } B;
} MC_CGM_SC_DC0_tag;

typedef union MC_CGM_SC_DC1_union_tag { /* System Clock Divider 1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :9;
    vuint32_t DIV:6;
    vuint32_t  :16;
  } B;
} MC_CGM_SC_DC1_tag;

typedef union MC_CGM_SC_DC2_union_tag { /* System Clock Divider 2 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :9;
    vuint32_t DIV:6;
    vuint32_t  :16;
  } B;
} MC_CGM_SC_DC2_tag;

typedef union MC_CGM_SC_DC3_union_tag { /* System Clock Divider 3 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :9;
    vuint32_t DIV:6;
    vuint32_t  :16;
  } B;
} MC_CGM_SC_DC3_tag;

typedef union MC_CGM_SC_DC4_union_tag { /* System Clock Divider 4 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :9;
    vuint32_t DIV:6;
    vuint32_t  :16;
  } B;
} MC_CGM_SC_DC4_tag;

typedef union MC_CGM_AC0_SC_union_tag { /* Auxiliary Clock 0 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELCTL:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC0_SC_tag;

typedef union MC_CGM_AC0_SS_union_tag { /* Auxiliary Clock 0 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELSTAT:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC0_SS_tag;

typedef union MC_CGM_AC0_DC0_union_tag { /* Auxiliary Clock 0 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :11;
    vuint32_t DIV:4;
    vuint32_t  :16;
  } B;
} MC_CGM_AC0_DC0_tag;

typedef union MC_CGM_AC0_DC1_union_tag { /* Auxiliary Clock 0 Divider 1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :8;
    vuint32_t DIV:7;
    vuint32_t  :16;
  } B;
} MC_CGM_AC0_DC1_tag;

typedef union MC_CGM_AC0_DC2_union_tag { /* Auxiliary Clock 0 Divider 2 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :8;
    vuint32_t DIV:7;
    vuint32_t  :16;
  } B;
} MC_CGM_AC0_DC2_tag;

typedef union MC_CGM_AC0_DC3_union_tag { /* Auxiliary Clock 0 Divider 3 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :6;
    vuint32_t DIV:9;
    vuint32_t  :14;
    vuint32_t DIV_FMT:2;
  } B;
} MC_CGM_AC0_DC3_tag;

typedef union MC_CGM_AC0_DC4_union_tag { /* Auxiliary Clock 0 Divider 4 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :11;
    vuint32_t DIV:4;
    vuint32_t  :16;
  } B;
} MC_CGM_AC0_DC4_tag;

typedef union MC_CGM_AC1_SC_union_tag { /* Auxiliary Clock 1 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELCTL:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC1_SC_tag;

typedef union MC_CGM_AC1_SS_union_tag { /* Auxiliary Clock 1 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELSTAT:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC1_SS_tag;

typedef union MC_CGM_AC1_DC0_union_tag { /* Auxiliary Clock 1 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :8;
    vuint32_t DIV:7;
    vuint32_t  :16;
  } B;
} MC_CGM_AC1_DC0_tag;

typedef union MC_CGM_AC2_DC0_union_tag { /* Auxiliary Clock 2 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :9;
    vuint32_t DIV:6;
    vuint32_t  :16;
  } B;
} MC_CGM_AC2_DC0_tag;

typedef union MC_CGM_AC2_DC1_union_tag { /* Auxiliary Clock 2 Divider 1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :9;
    vuint32_t DIV:6;
    vuint32_t  :16;
  } B;
} MC_CGM_AC2_DC1_tag;

typedef union MC_CGM_AC3_SC_union_tag { /* Auxiliary Clock 3 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELCTL:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC3_SC_tag;

typedef union MC_CGM_AC3_SS_union_tag { /* Auxiliary Clock 3 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELSTAT:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC3_SS_tag;

typedef union MC_CGM_AC4_SC_union_tag { /* Auxiliary Clock 4 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELCTL:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC4_SC_tag;

typedef union MC_CGM_AC4_SS_union_tag { /* Auxiliary Clock 4 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELSTAT:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC4_SS_tag;

typedef union MC_CGM_AC5_DC0_union_tag { /* Auxiliary Clock 5 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :2;
    vuint32_t DIV:13;
    vuint32_t  :14;
    vuint32_t DIV_FMT:2;
  } B;
} MC_CGM_AC5_DC0_tag;

typedef union MC_CGM_AC5_DC1_union_tag { /* Auxiliary Clock 5 Divider 1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :7;
    vuint32_t DIV:8;
    vuint32_t  :16;
  } B;
} MC_CGM_AC5_DC1_tag;

typedef union MC_CGM_AC5_DC2_union_tag { /* Auxiliary Clock 5 Divider 2 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :5;
    vuint32_t DIV:10;
    vuint32_t  :16;
  } B;
} MC_CGM_AC5_DC2_tag;

typedef union MC_CGM_AC6_SC_union_tag { /* Auxiliary Clock 6 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELCTL:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC6_SC_tag;

typedef union MC_CGM_AC6_SS_union_tag { /* Auxiliary Clock 6 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELSTAT:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC6_SS_tag;

typedef union MC_CGM_AC6_DC0_union_tag { /* Auxiliary Clock 6 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :6;
    vuint32_t DIV:9;
    vuint32_t  :16;
  } B;
} MC_CGM_AC6_DC0_tag;

typedef union MC_CGM_AC7_SC_union_tag { /* Auxiliary Clock 7 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELCTL:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC7_SC_tag;

typedef union MC_CGM_AC7_SS_union_tag { /* Auxiliary Clock 7 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELSTAT:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC7_SS_tag;

typedef union MC_CGM_AC7_DC0_union_tag { /* Auxiliary Clock 7 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :6;
    vuint32_t DIV:9;
    vuint32_t  :16;
  } B;
} MC_CGM_AC7_DC0_tag;

typedef union MC_CGM_AC8_SC_union_tag { /* Auxiliary Clock 8 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELCTL:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC8_SC_tag;

typedef union MC_CGM_AC8_SS_union_tag { /* Auxiliary Clock 8 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELSTAT:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC8_SS_tag;

typedef union MC_CGM_AC8_DC0_union_tag { /* Auxiliary Clock 8 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :9;
    vuint32_t DIV:6;
    vuint32_t  :16;
  } B;
} MC_CGM_AC8_DC0_tag;

typedef union MC_CGM_AC9_SC_union_tag { /* Auxiliary Clock 9 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELCTL:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC9_SC_tag;

typedef union MC_CGM_AC9_SS_union_tag { /* Auxiliary Clock 9 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELSTAT:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC9_SS_tag;

typedef union MC_CGM_AC9_DC0_union_tag { /* Auxiliary Clock 9 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :9;
    vuint32_t DIV:6;
    vuint32_t  :16;
  } B;
} MC_CGM_AC9_DC0_tag;

typedef union MC_CGM_AC10_SC_union_tag { /* Auxiliary Clock 10 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELCTL:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC10_SC_tag;

typedef union MC_CGM_AC10_SS_union_tag { /* Auxiliary Clock 10 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELSTAT:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC10_SS_tag;

typedef union MC_CGM_AC10_DC0_union_tag { /* Auxiliary Clock 10 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :11;
    vuint32_t DIV:4;
    vuint32_t  :16;
  } B;
} MC_CGM_AC10_DC0_tag;

struct MC_CGM_tag {
  uint8_t MC_CGM_reserved0[1664];
  MC_CGM_AC5_CDC0_tag AC5_CDC0;        /* Auxiliary Clock 5 Cascaded Divider 0 Configuration Register */
  MC_CGM_AC5_CDC1_tag AC5_CDC1;        /* Auxiliary Clock 5 Cascaded Divider 1 Configuration Register */
  MC_CGM_AC5_CDC2_tag AC5_CDC2;        /* Auxiliary Clock 5 Cascaded Divider 2 Configuration Register */
  uint8_t MC_CGM_reserved1[4];
  MC_CGM_AC5_CDC10_tag AC5_CDC10;      /* Auxiliary Clock 5 Cascaded Divider 10 Configuration Register */
  MC_CGM_AC5_CDC11_tag AC5_CDC11;      /* Auxiliary Clock 5 Cascaded Divider 11 Configuration Register */
  MC_CGM_AC5_CDC12_tag AC5_CDC12;      /* Auxiliary Clock 5 Cascaded Divider 12 Configuration Register */
  MC_CGM_AC5_CDC13_tag AC5_CDC13;      /* Auxiliary Clock 5 Cascaded Divider 13 Configuration Register */
  MC_CGM_AC5_CDC20_tag AC5_CDC20;      /* Auxiliary Clock 5 Cascaded Divider 20 Configuration Register */
  MC_CGM_AC5_CDC21_tag AC5_CDC21;      /* Auxiliary Clock 5 Cascaded Divider 21 Configuration Register */
  MC_CGM_AC5_CDC22_tag AC5_CDC22;      /* Auxiliary Clock 5 Cascaded Divider 22 Configuration Register */
  MC_CGM_AC5_CDC23_tag AC5_CDC23;      /* Auxiliary Clock 5 Cascaded Divider 23 Configuration Register */
  uint8_t MC_CGM_reserved2[80];
  MC_CGM_PCS_SDUR_tag PCS_SDUR;        /* PCS Switch Duration Register */
  uint8_t MC_CGM_reserved3[3];
  MC_CGM_PCS_DIVC1_tag PCS_DIVC1;      /* PCS Divider Change Register 1 */
  MC_CGM_PCS_DIVE1_tag PCS_DIVE1;      /* PCS Divider End Register 1 */
  MC_CGM_PCS_DIVS1_tag PCS_DIVS1;      /* PCS Divider Start Register 1 */
  MC_CGM_PCS_DIVC2_tag PCS_DIVC2;      /* PCS Divider Change Register 2 */
  MC_CGM_PCS_DIVE2_tag PCS_DIVE2;      /* PCS Divider End Register 2 */
  MC_CGM_PCS_DIVS2_tag PCS_DIVS2;      /* PCS Divider Start Register 2 */
  uint8_t MC_CGM_reserved4[12];
  MC_CGM_PCS_DIVC4_tag PCS_DIVC4;      /* PCS Divider Change Register 4 */
  MC_CGM_PCS_DIVE4_tag PCS_DIVE4;      /* PCS Divider End Register 4 */
  MC_CGM_PCS_DIVS4_tag PCS_DIVS4;      /* PCS Divider Start Register 4 */
  uint8_t MC_CGM_reserved5[156];
  MC_CGM_SC_DIV_RC_tag SC_DIV_RC;      /* System Clock Divider Ratio Change Register */
  MC_CGM_DIV_UPD_TYPE_tag DIV_UPD_TYPE; /* Divider Update Type Register */
  MC_CGM_DIV_UPD_TRIG_tag DIV_UPD_TRIG; /* Divider Update Trigger Register */
  MC_CGM_DIV_UPD_STAT_tag DIV_UPD_STAT; /* Divider Update Status Register */
  uint8_t MC_CGM_reserved6[4];
  MC_CGM_SC_SS_tag SC_SS;              /* System Clock Select Status Register */
  MC_CGM_SC_DC0_tag SC_DC0;            /* System Clock Divider 0 Configuration Register */
  MC_CGM_SC_DC1_tag SC_DC1;            /* System Clock Divider 1 Configuration Register */
  MC_CGM_SC_DC2_tag SC_DC2;            /* System Clock Divider 2 Configuration Register */
  MC_CGM_SC_DC3_tag SC_DC3;            /* System Clock Divider 3 Configuration Register */
  MC_CGM_SC_DC4_tag SC_DC4;            /* System Clock Divider 4 Configuration Register */
  uint8_t MC_CGM_reserved7[4];
  MC_CGM_AC0_SC_tag AC0_SC;            /* Auxiliary Clock 0 Select Control Register */
  MC_CGM_AC0_SS_tag AC0_SS;            /* Auxiliary Clock 0 Select Status Register */
  MC_CGM_AC0_DC0_tag AC0_DC0;          /* Auxiliary Clock 0 Divider 0 Configuration Register */
  MC_CGM_AC0_DC1_tag AC0_DC1;          /* Auxiliary Clock 0 Divider 1 Configuration Register */
  MC_CGM_AC0_DC2_tag AC0_DC2;          /* Auxiliary Clock 0 Divider 2 Configuration Register */
  MC_CGM_AC0_DC3_tag AC0_DC3;          /* Auxiliary Clock 0 Divider 3 Configuration Register */
  MC_CGM_AC0_DC4_tag AC0_DC4;          /* Auxiliary Clock 0 Divider 4 Configuration Register */
  uint8_t MC_CGM_reserved8[4];
  MC_CGM_AC1_SC_tag AC1_SC;            /* Auxiliary Clock 1 Select Control Register */
  MC_CGM_AC1_SS_tag AC1_SS;            /* Auxiliary Clock 1 Select Status Register */
  MC_CGM_AC1_DC0_tag AC1_DC0;          /* Auxiliary Clock 1 Divider 0 Configuration Register */
  uint8_t MC_CGM_reserved9[28];
  MC_CGM_AC2_DC0_tag AC2_DC0;          /* Auxiliary Clock 2 Divider 0 Configuration Register */
  MC_CGM_AC2_DC1_tag AC2_DC1;          /* Auxiliary Clock 2 Divider 1 Configuration Register */
  uint8_t MC_CGM_reserved10[16];
  MC_CGM_AC3_SC_tag AC3_SC;            /* Auxiliary Clock 3 Select Control Register */
  MC_CGM_AC3_SS_tag AC3_SS;            /* Auxiliary Clock 3 Select Status Register */
  uint8_t MC_CGM_reserved11[24];
  MC_CGM_AC4_SC_tag AC4_SC;            /* Auxiliary Clock 4 Select Control Register */
  MC_CGM_AC4_SS_tag AC4_SS;            /* Auxiliary Clock 4 Select Status Register */
  uint8_t MC_CGM_reserved12[32];
  MC_CGM_AC5_DC0_tag AC5_DC0;          /* Auxiliary Clock 5 Divider 0 Configuration Register */
  MC_CGM_AC5_DC1_tag AC5_DC1;          /* Auxiliary Clock 5 Divider 1 Configuration Register */
  MC_CGM_AC5_DC2_tag AC5_DC2;          /* Auxiliary Clock 5 Divider 2 Configuration Register */
  uint8_t MC_CGM_reserved13[12];
  MC_CGM_AC6_SC_tag AC6_SC;            /* Auxiliary Clock 6 Select Control Register */
  MC_CGM_AC6_SS_tag AC6_SS;            /* Auxiliary Clock 6 Select Status Register */
  MC_CGM_AC6_DC0_tag AC6_DC0;          /* Auxiliary Clock 6 Divider 0 Configuration Register */
  uint8_t MC_CGM_reserved14[20];
  MC_CGM_AC7_SC_tag AC7_SC;            /* Auxiliary Clock 7 Select Control Register */
  MC_CGM_AC7_SS_tag AC7_SS;            /* Auxiliary Clock 7 Select Status Register */
  MC_CGM_AC7_DC0_tag AC7_DC0;          /* Auxiliary Clock 7 Divider 0 Configuration Register */
  uint8_t MC_CGM_reserved15[20];
  MC_CGM_AC8_SC_tag AC8_SC;            /* Auxiliary Clock 8 Select Control Register */
  MC_CGM_AC8_SS_tag AC8_SS;            /* Auxiliary Clock 8 Select Status Register */
  MC_CGM_AC8_DC0_tag AC8_DC0;          /* Auxiliary Clock 8 Divider 0 Configuration Register */
  uint8_t MC_CGM_reserved16[20];
  MC_CGM_AC9_SC_tag AC9_SC;            /* Auxiliary Clock 9 Select Control Register */
  MC_CGM_AC9_SS_tag AC9_SS;            /* Auxiliary Clock 9 Select Status Register */
  MC_CGM_AC9_DC0_tag AC9_DC0;          /* Auxiliary Clock 9 Divider 0 Configuration Register */
  uint8_t MC_CGM_reserved17[20];
  MC_CGM_AC10_SC_tag AC10_SC;          /* Auxiliary Clock 10 Select Control Register */
  MC_CGM_AC10_SS_tag AC10_SS;          /* Auxiliary Clock 10 Select Status Register */
  MC_CGM_AC10_DC0_tag AC10_DC0;        /* Auxiliary Clock 10 Divider 0 Configuration Register */
};


/* ============================================================================
   =============================== Module: MC_ME ==============================
   ============================================================================ */

typedef union MC_ME_GS_union_tag {     /* Global Status Register */
  vuint32_t R;
  struct {
    vuint32_t S_CURRENT_MODE:4;
    vuint32_t S_MTRANS:1;
    vuint32_t  :1;
    vuint32_t  :2;
    vuint32_t S_PDO:1;
    vuint32_t  :2;
    vuint32_t S_MVR:1;
    vuint32_t  :2;
    vuint32_t S_FLA:2;
    vuint32_t  :8;
    vuint32_t S_PLL1:1;
    vuint32_t S_PLL0:1;
    vuint32_t S_XOSC:1;
    vuint32_t S_IRC:1;
    vuint32_t S_SYSCLK:4;
  } B;
} MC_ME_GS_tag;

typedef union MC_ME_MCTL_union_tag {   /* Mode Control Register */
  vuint32_t R;
  struct {
    vuint32_t TARGET_MODE:4;
    vuint32_t  :12;
    vuint32_t KEY:16;
  } B;
} MC_ME_MCTL_tag;

typedef union MC_ME_ME_union_tag {     /* Mode Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t RESET_DEST:1;
    vuint32_t  :4;
    vuint32_t STOP0:1;
    vuint32_t  :1;
    vuint32_t HALT0:1;
    vuint32_t RUN3:1;
    vuint32_t RUN2:1;
    vuint32_t RUN1:1;
    vuint32_t RUN0:1;
    vuint32_t DRUN:1;
    vuint32_t SAFE:1;
    vuint32_t TEST:1;
    vuint32_t RESET_FUNC:1;
  } B;
} MC_ME_ME_tag;

typedef union MC_ME_IS_union_tag {     /* Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t I_ICONF_CC:1;
    vuint32_t I_ICONF_CU:1;
    vuint32_t I_ICONF:1;
    vuint32_t I_IMODE:1;
    vuint32_t I_SAFE:1;
    vuint32_t I_MTC:1;
  } B;
} MC_ME_IS_tag;

typedef union MC_ME_IM_union_tag {     /* Interrupt Mask Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t M_ICONF_CC:1;
    vuint32_t M_ICONF_CU:1;
    vuint32_t M_ICONF:1;
    vuint32_t M_IMODE:1;
    vuint32_t M_SAFE:1;
    vuint32_t M_MTC:1;
  } B;
} MC_ME_IM_tag;

typedef union MC_ME_IMTS_union_tag {   /* Invalid Mode Transition Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t S_MRIG:1;
    vuint32_t S_MTI:1;
    vuint32_t S_MRI:1;
    vuint32_t S_DMA:1;
    vuint32_t S_NMA:1;
    vuint32_t S_SEA:1;
  } B;
} MC_ME_IMTS_tag;

typedef union MC_ME_DMTS_union_tag {   /* Debug Mode Transition Status Register */
  vuint32_t R;
  struct {
    vuint32_t PREVIOUS_MODE:4;
    vuint32_t  :4;
    vuint32_t MPH_BUSY:1;
    vuint32_t  :2;
    vuint32_t PMC_PROG:1;
    vuint32_t DBG_MODE:1;
    vuint32_t CCKL_PROG:1;
    vuint32_t PCS_PROG:1;
    vuint32_t SMR:1;
    vuint32_t  :1;
    vuint32_t VREG_CSRC_SC:1;
    vuint32_t CSRC_CSRC_SC:1;
    vuint32_t IRC_SC:1;
    vuint32_t SCSRC_SC:1;
    vuint32_t SYSCLK_SW:1;
    vuint32_t  :1;
    vuint32_t FLASH_SC:1;
    vuint32_t CDP_PRPH_224_255:1;
    vuint32_t CDP_PRPH_192_223:1;
    vuint32_t CDP_PRPH_160_191:1;
    vuint32_t CDP_PRPH_128_159:1;
    vuint32_t CDP_PRPH_96_127:1;
    vuint32_t CDP_PRPH_64_95:1;
    vuint32_t CDP_PRPH_32_63:1;
    vuint32_t CDP_PRPH_0_31:1;
  } B;
} MC_ME_DMTS_tag;

typedef union MC_ME_RESET_MC_union_tag { /* RESET Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t PWRLVL:3;
    vuint32_t  :4;
    vuint32_t PDO:1;
    vuint32_t  :2;
    vuint32_t MVRON:1;
    vuint32_t  :2;
    vuint32_t FLAON:2;
    vuint32_t  :8;
    vuint32_t PLL1ON:1;
    vuint32_t PLL0ON:1;
    vuint32_t XOSCON:1;
    vuint32_t IRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_RESET_MC_tag;

typedef union MC_ME_TEST_MC_union_tag { /* TEST Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t PWRLVL:3;
    vuint32_t  :4;
    vuint32_t PDO:1;
    vuint32_t  :2;
    vuint32_t MVRON:1;
    vuint32_t  :2;
    vuint32_t FLAON:2;
    vuint32_t  :8;
    vuint32_t PLL1ON:1;
    vuint32_t PLL0ON:1;
    vuint32_t XOSCON:1;
    vuint32_t IRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_TEST_MC_tag;

typedef union MC_ME_SAFE_MC_union_tag { /* SAFE Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t PWRLVL:3;
    vuint32_t  :4;
    vuint32_t PDO:1;
    vuint32_t  :2;
    vuint32_t MVRON:1;
    vuint32_t  :2;
    vuint32_t FLAON:2;
    vuint32_t  :8;
    vuint32_t PLL1ON:1;
    vuint32_t PLL0ON:1;
    vuint32_t XOSCON:1;
    vuint32_t IRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_SAFE_MC_tag;

typedef union MC_ME_DRUN_MC_union_tag { /* DRUN Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t PWRLVL:3;
    vuint32_t  :4;
    vuint32_t PDO:1;
    vuint32_t  :2;
    vuint32_t MVRON:1;
    vuint32_t  :2;
    vuint32_t FLAON:2;
    vuint32_t  :8;
    vuint32_t PLL1ON:1;
    vuint32_t PLL0ON:1;
    vuint32_t XOSCON:1;
    vuint32_t IRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_DRUN_MC_tag;

typedef union MC_ME_RUN_MC_union_tag { /* RUN0 Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t PWRLVL:3;
    vuint32_t  :4;
    vuint32_t PDO:1;
    vuint32_t  :2;
    vuint32_t MVRON:1;
    vuint32_t  :2;
    vuint32_t FLAON:2;
    vuint32_t  :8;
    vuint32_t PLL1ON:1;
    vuint32_t PLL0ON:1;
    vuint32_t XOSCON:1;
    vuint32_t IRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_RUN_MC_tag;

typedef union MC_ME_HALT0_MC_union_tag { /* HALT0 Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t PWRLVL:3;
    vuint32_t  :4;
    vuint32_t PDO:1;
    vuint32_t  :2;
    vuint32_t MVRON:1;
    vuint32_t  :2;
    vuint32_t FLAON:2;
    vuint32_t  :8;
    vuint32_t PLL1ON:1;
    vuint32_t PLL0ON:1;
    vuint32_t XOSCON:1;
    vuint32_t IRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_HALT0_MC_tag;

typedef union MC_ME_STOP0_MC_union_tag { /* STOP0 Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t PWRLVL:3;
    vuint32_t  :4;
    vuint32_t PDO:1;
    vuint32_t  :2;
    vuint32_t MVRON:1;
    vuint32_t  :2;
    vuint32_t FLAON:2;
    vuint32_t  :8;
    vuint32_t PLL1ON:1;
    vuint32_t PLL0ON:1;
    vuint32_t XOSCON:1;
    vuint32_t IRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_STOP0_MC_tag;

typedef union MC_ME_PS0_union_tag {    /* Peripheral Status Register 0 */
  vuint32_t R;
  struct {
    vuint32_t S_PIT_RTC_1:1;
    vuint32_t S_PIT_RTC_0:1;
    vuint32_t  :14;
    vuint32_t S_SIUL:1;
    vuint32_t  :3;
    vuint32_t S_SIPI_0:1;
    vuint32_t  :1;
    vuint32_t S_LFAST_0:1;
    vuint32_t  :5;
    vuint32_t S_EBI_0:1;
    vuint32_t  :3;
  } B;
} MC_ME_PS0_tag;

typedef union MC_ME_PS1_union_tag {    /* Peripheral Status Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :3;
    vuint32_t S_ADCSD_0:1;
    vuint32_t S_ADCSD_2:1;
    vuint32_t S_ADCSD_4:1;
    vuint32_t S_ADCSD_6:1;
    vuint32_t S_ADCSD_8:1;
    vuint32_t  :17;
    vuint32_t S_CRC_0:1;
    vuint32_t  :1;
    vuint32_t S_DMAMUX_0:1;
    vuint32_t  :4;
  } B;
} MC_ME_PS1_tag;

typedef union MC_ME_PS2_union_tag {    /* Peripheral Status Register 2 */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t S_DSPI_12:1;
    vuint32_t S_LINFlexD_0:1;
    vuint32_t S_LINFlexD_1:1;
    vuint32_t  :5;
    vuint32_t S_LINFlexD_14:1;
    vuint32_t S_LINFlexD_16:1;
    vuint32_t  :9;
    vuint32_t S_CAN_RAM_CTRL:1;
    vuint32_t  :1;
    vuint32_t S_TTCAN:1;
    vuint32_t  :1;
    vuint32_t S_MCAN_1:1;
    vuint32_t S_MCAN_2:1;
    vuint32_t S_MCAN_3:1;
    vuint32_t S_MCAN_4:1;
    vuint32_t  :3;
  } B;
} MC_ME_PS2_tag;

typedef union MC_ME_PS3_union_tag {    /* Peripheral Status Register 3 */
  vuint32_t R;
  struct {
    vuint32_t S_ADCSAR_0:1;
    vuint32_t  :3;
    vuint32_t S_ADCSAR_4:1;
    vuint32_t  :10;
    vuint32_t S_ADCSAR_b:1;
    vuint32_t S_PSI5_0:1;
    vuint32_t  :3;
    vuint32_t S_FLEXRAY_0:1;
    vuint32_t  :2;
    vuint32_t S_SENT_0:1;
    vuint32_t  :2;
    vuint32_t S_IIC_0:1;
    vuint32_t  :1;
    vuint32_t S_DSPI_0:1;
    vuint32_t S_DSPI_1:1;
    vuint32_t S_DSPI_4:1;
    vuint32_t S_DSPI_6:1;
  } B;
} MC_ME_PS3_tag;

typedef union MC_ME_PS4_union_tag {    /* Peripheral Status Register 4 */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t S_GTMINT:1;
  } B;
} MC_ME_PS4_tag;

typedef union MC_ME_PS5_union_tag {    /* Peripheral Status Register 5 */
  vuint32_t R;
  struct {
    vuint32_t  :3;
    vuint32_t S_ADCSD_1:1;
    vuint32_t S_ADCSD_3:1;
    vuint32_t S_ADCSD_5:1;
    vuint32_t S_ADCSD_7:1;
    vuint32_t S_ADCSD_9:1;
    vuint32_t  :17;
    vuint32_t S_CRC_1:1;
    vuint32_t  :3;
    vuint32_t S_PSI5S_0:1;
    vuint32_t  :2;
  } B;
} MC_ME_PS5_tag;

typedef union MC_ME_PS6_union_tag {    /* Peripheral Status Register 6 */
  vuint32_t R;
  struct {
    vuint32_t  :3;
    vuint32_t S_LINFlexD_2:1;
    vuint32_t  :6;
    vuint32_t S_LINFlexD_15:1;
    vuint32_t  :21;
  } B;
} MC_ME_PS6_tag;

typedef union MC_ME_PS7_union_tag {    /* Peripheral Status Register 7 */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t S_ADCSAR_1:1;
    vuint32_t S_ADCSAR_2:1;
    vuint32_t S_ADCSAR_3:1;
    vuint32_t  :1;
    vuint32_t S_ADCSAR_5:1;
    vuint32_t S_ADCSAR_6:1;
    vuint32_t S_ADCSAR_7:1;
    vuint32_t S_ADCSAR_8:1;
    vuint32_t S_ADCSAR_9:1;
    vuint32_t S_ADCSAR_10:1;
    vuint32_t  :5;
    vuint32_t S_PSI5_1:1;
    vuint32_t  :3;
    vuint32_t S_FLEXRAY_1:1;
    vuint32_t  :2;
    vuint32_t S_SENT_1:1;
    vuint32_t  :2;
    vuint32_t S_IIC_1:1;
    vuint32_t  :1;
    vuint32_t S_DSPI_2:1;
    vuint32_t S_DSPI_3:1;
    vuint32_t S_DSPI_5:1;
    vuint32_t  :1;
  } B;
} MC_ME_PS7_tag;

typedef union MC_ME_RUN_PC_union_tag { /* Run Peripheral Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t RUN3:1;
    vuint32_t RUN2:1;
    vuint32_t RUN1:1;
    vuint32_t RUN0:1;
    vuint32_t DRUN:1;
    vuint32_t SAFE:1;
    vuint32_t TEST:1;
    vuint32_t RESET:1;
  } B;
} MC_ME_RUN_PC_tag;

typedef union MC_ME_LP_PC_union_tag {  /* Low-Power Peripheral Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t STOP0:1;
    vuint32_t  :1;
    vuint32_t HALT0:1;
    vuint32_t  :8;
  } B;
} MC_ME_LP_PC_tag;

typedef union MC_ME_PCTL3_union_tag {  /* EBI_0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL3_tag;

typedef union MC_ME_PCTL9_union_tag {  /* LFAST_0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL9_tag;

typedef union MC_ME_PCTL11_union_tag { /* SIPI_0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL11_tag;

typedef union MC_ME_PCTL15_union_tag { /* SIUL Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL15_tag;

typedef union MC_ME_PCTL30_union_tag { /* PIT_RTC_0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL30_tag;

typedef union MC_ME_PCTL31_union_tag { /* PIT_RTC_1 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL31_tag;

typedef union MC_ME_PCTL36_union_tag { /* DMAMUX_0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL36_tag;

typedef union MC_ME_PCTL38_union_tag { /* CRC_0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL38_tag;

typedef union MC_ME_PCTL56_union_tag { /* ADCSD_8 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL56_tag;

typedef union MC_ME_PCTL57_union_tag { /* ADCSD_6 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL57_tag;

typedef union MC_ME_PCTL58_union_tag { /* ADCSD_4 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL58_tag;

typedef union MC_ME_PCTL59_union_tag { /* ADCSD_2 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL59_tag;

typedef union MC_ME_PCTL60_union_tag { /* ADCSD_0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL60_tag;

typedef union MC_ME_PCTL67_union_tag { /* MCAN_4 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL67_tag;

typedef union MC_ME_PCTL68_union_tag { /* MCAN_3 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL68_tag;

typedef union MC_ME_PCTL69_union_tag { /* MCAN_2 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL69_tag;

typedef union MC_ME_PCTL70_union_tag { /* MCAN_1 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL70_tag;

typedef union MC_ME_PCTL72_union_tag { /* TTCAN Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL72_tag;

typedef union MC_ME_PCTL74_union_tag { /* CAN_RAM_CTRL Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL74_tag;

typedef union MC_ME_PCTL84_union_tag { /* LINFlexD_16 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL84_tag;

typedef union MC_ME_PCTL85_union_tag { /* LINFlexD_14 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL85_tag;

typedef union MC_ME_PCTL91_union_tag { /* LINFlexD_1 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL91_tag;

typedef union MC_ME_PCTL92_union_tag { /* LINFlexD_0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL92_tag;

typedef union MC_ME_PCTL93_union_tag { /* DSPI_12 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL93_tag;

typedef union MC_ME_PCTL96_union_tag { /* DSPI_6 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL96_tag;

typedef union MC_ME_PCTL97_union_tag { /* DSPI_4 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL97_tag;

typedef union MC_ME_PCTL98_union_tag { /* DSPI_1 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL98_tag;

typedef union MC_ME_PCTL99_union_tag { /* DSPI_0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL99_tag;

typedef union MC_ME_PCTL101_union_tag { /* IIC_0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL101_tag;

typedef union MC_ME_PCTL104_union_tag { /* SENT_0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL104_tag;

typedef union MC_ME_PCTL107_union_tag { /* FLEXRAY_0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL107_tag;

typedef union MC_ME_PCTL111_union_tag { /* PSI5_0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL111_tag;

typedef union MC_ME_PCTL112_union_tag { /* ADCSAR_b Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL112_tag;

typedef union MC_ME_PCTL123_union_tag { /* ADCSAR_4 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL123_tag;

typedef union MC_ME_PCTL127_union_tag { /* ADCSAR_0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL127_tag;

typedef union MC_ME_PCTL128_union_tag { /* GTMINT Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL128_tag;

typedef union MC_ME_PCTL162_union_tag { /* PSI5_S_0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL162_tag;

typedef union MC_ME_PCTL166_union_tag { /* CRC_1 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL166_tag;

typedef union MC_ME_PCTL184_union_tag { /* ADCSD_9 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL184_tag;

typedef union MC_ME_PCTL185_union_tag { /* ADCSD_7 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL185_tag;

typedef union MC_ME_PCTL186_union_tag { /* ADCSD_5 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL186_tag;

typedef union MC_ME_PCTL187_union_tag { /* ADCSD_3 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL187_tag;

typedef union MC_ME_PCTL188_union_tag { /* ADCSD_1 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL188_tag;

typedef union MC_ME_PCTL213_union_tag { /* LINFlexD_15 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL213_tag;

typedef union MC_ME_PCTL220_union_tag { /* LINFlexD_2 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL220_tag;

typedef union MC_ME_PCTL225_union_tag { /* DSPI_5 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL225_tag;

typedef union MC_ME_PCTL226_union_tag { /* DSPI_3 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL226_tag;

typedef union MC_ME_PCTL227_union_tag { /* DSPI_2 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL227_tag;

typedef union MC_ME_PCTL229_union_tag { /* IIC_1 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL229_tag;

typedef union MC_ME_PCTL232_union_tag { /* SENT_1 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL232_tag;

typedef union MC_ME_PCTL235_union_tag { /* FLEXRAY_1 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL235_tag;

typedef union MC_ME_PCTL239_union_tag { /* PSI5_1 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL239_tag;

typedef union MC_ME_PCTL245_union_tag { /* ADCSAR_10 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL245_tag;

typedef union MC_ME_PCTL246_union_tag { /* ADCSAR_9 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL246_tag;

typedef union MC_ME_PCTL247_union_tag { /* ADCSAR_8 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL247_tag;

typedef union MC_ME_PCTL248_union_tag { /* ADCSAR_7 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL248_tag;

typedef union MC_ME_PCTL249_union_tag { /* ADCSAR_6 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL249_tag;

typedef union MC_ME_PCTL250_union_tag { /* ADCSAR_5 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL250_tag;

typedef union MC_ME_PCTL252_union_tag { /* ADCSAR_3 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL252_tag;

typedef union MC_ME_PCTL253_union_tag { /* ADCSAR_2 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL253_tag;

typedef union MC_ME_PCTL254_union_tag { /* ADCSAR_1 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t  :1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL254_tag;

typedef union MC_ME_CS_union_tag {     /* Core Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :27;
    vuint32_t S_CORE4:1;
    vuint32_t S_CORE3:1;
    vuint32_t S_CORE2:1;
    vuint32_t S_CORE1:1;
    vuint32_t S_CORE0:1;
  } B;
} MC_ME_CS_tag;

typedef union MC_ME_CCTL0_union_tag {  /* CORE0 Core Control Register */
  vuint16_t R;
  struct {
    vuint16_t  :5;
    vuint16_t STOP0:1;
    vuint16_t  :1;
    vuint16_t HALT0:1;
    vuint16_t RUN3:1;
    vuint16_t RUN2:1;
    vuint16_t RUN1:1;
    vuint16_t RUN0:1;
    vuint16_t DRUN:1;
    vuint16_t SAFE:1;
    vuint16_t TEST:1;
    vuint16_t RESET:1;
  } B;
} MC_ME_CCTL0_tag;

typedef union MC_ME_CCTL1_union_tag {  /* CORE1 Core Control Register */
  vuint16_t R;
  struct {
    vuint16_t  :5;
    vuint16_t STOP0:1;
    vuint16_t  :1;
    vuint16_t HALT0:1;
    vuint16_t RUN3:1;
    vuint16_t RUN2:1;
    vuint16_t RUN1:1;
    vuint16_t RUN0:1;
    vuint16_t DRUN:1;
    vuint16_t SAFE:1;
    vuint16_t TEST:1;
    vuint16_t RESET:1;
  } B;
} MC_ME_CCTL1_tag;

typedef union MC_ME_CCTL2_union_tag {  /* CORE2 Core Control Register */
  vuint16_t R;
  struct {
    vuint16_t  :5;
    vuint16_t STOP0:1;
    vuint16_t  :1;
    vuint16_t HALT0:1;
    vuint16_t RUN3:1;
    vuint16_t RUN2:1;
    vuint16_t RUN1:1;
    vuint16_t RUN0:1;
    vuint16_t DRUN:1;
    vuint16_t SAFE:1;
    vuint16_t TEST:1;
    vuint16_t RESET:1;
  } B;
} MC_ME_CCTL2_tag;

typedef union MC_ME_CCTL3_union_tag {  /* CORE3 Core Control Register */
  vuint16_t R;
  struct {
    vuint16_t  :5;
    vuint16_t STOP0:1;
    vuint16_t  :1;
    vuint16_t HALT0:1;
    vuint16_t RUN3:1;
    vuint16_t RUN2:1;
    vuint16_t RUN1:1;
    vuint16_t RUN0:1;
    vuint16_t DRUN:1;
    vuint16_t SAFE:1;
    vuint16_t TEST:1;
    vuint16_t RESET:1;
  } B;
} MC_ME_CCTL3_tag;

typedef union MC_ME_CCTL4_union_tag {  /* CORE4 Core Control Register */
  vuint16_t R;
  struct {
    vuint16_t  :5;
    vuint16_t STOP0:1;
    vuint16_t  :1;
    vuint16_t HALT0:1;
    vuint16_t RUN3:1;
    vuint16_t RUN2:1;
    vuint16_t RUN1:1;
    vuint16_t RUN0:1;
    vuint16_t DRUN:1;
    vuint16_t SAFE:1;
    vuint16_t TEST:1;
    vuint16_t RESET:1;
  } B;
} MC_ME_CCTL4_tag;

typedef union MC_ME_CADDR0_union_tag { /* CORE0 Core Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:30;
    vuint32_t  :1;
    vuint32_t RMC:1;
  } B;
} MC_ME_CADDR0_tag;

typedef union MC_ME_CADDR1_union_tag { /* CORE1 Core Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:30;
    vuint32_t  :1;
    vuint32_t RMC:1;
  } B;
} MC_ME_CADDR1_tag;

typedef union MC_ME_CADDR2_union_tag { /* CORE2 Core Address Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t RMC:1;
  } B;
} MC_ME_CADDR2_tag;

typedef union MC_ME_CADDR3_union_tag { /* CORE3 Core Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:30;
    vuint32_t  :1;
    vuint32_t RMC:1;
  } B;
} MC_ME_CADDR3_tag;

typedef union MC_ME_CADDR4_union_tag { /* CORE4 Core Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:30;
    vuint32_t  :1;
    vuint32_t RMC:1;
  } B;
} MC_ME_CADDR4_tag;

struct MC_ME_tag {
  MC_ME_GS_tag GS;                     /* Global Status Register */
  MC_ME_MCTL_tag MCTL;                 /* Mode Control Register */
  MC_ME_ME_tag ME;                     /* Mode Enable Register */
  MC_ME_IS_tag IS;                     /* Interrupt Status Register */
  MC_ME_IM_tag IM;                     /* Interrupt Mask Register */
  MC_ME_IMTS_tag IMTS;                 /* Invalid Mode Transition Status Register */
  MC_ME_DMTS_tag DMTS;                 /* Debug Mode Transition Status Register */
  uint8_t MC_ME_reserved0[4];
  MC_ME_RESET_MC_tag RESET_MC;         /* RESET Mode Configuration Register */
  MC_ME_TEST_MC_tag TEST_MC;           /* TEST Mode Configuration Register */
  MC_ME_SAFE_MC_tag SAFE_MC;           /* SAFE Mode Configuration Register */
  MC_ME_DRUN_MC_tag DRUN_MC;           /* DRUN Mode Configuration Register */
  MC_ME_RUN_MC_tag RUN_MC[4];          /* RUN0 Mode Configuration Register */
  MC_ME_HALT0_MC_tag HALT0_MC;         /* HALT0 Mode Configuration Register */
  uint8_t MC_ME_reserved1[4];
  MC_ME_STOP0_MC_tag STOP0_MC;         /* STOP0 Mode Configuration Register */
  uint8_t MC_ME_reserved2[20];
  MC_ME_PS0_tag PS0;                   /* Peripheral Status Register 0 */
  MC_ME_PS1_tag PS1;                   /* Peripheral Status Register 1 */
  MC_ME_PS2_tag PS2;                   /* Peripheral Status Register 2 */
  MC_ME_PS3_tag PS3;                   /* Peripheral Status Register 3 */
  MC_ME_PS4_tag PS4;                   /* Peripheral Status Register 4 */
  MC_ME_PS5_tag PS5;                   /* Peripheral Status Register 5 */
  MC_ME_PS6_tag PS6;                   /* Peripheral Status Register 6 */
  MC_ME_PS7_tag PS7;                   /* Peripheral Status Register 7 */
  MC_ME_RUN_PC_tag RUN_PC[8];          /* Run Peripheral Configuration Register */
  MC_ME_LP_PC_tag LP_PC[8];            /* Low-Power Peripheral Configuration Register */
  uint8_t MC_ME_reserved3[3];
  MC_ME_PCTL3_tag PCTL3;               /* EBI_0 Peripheral Control Register */
  uint8_t MC_ME_reserved4[5];
  MC_ME_PCTL9_tag PCTL9;               /* LFAST_0 Peripheral Control Register */
  uint8_t MC_ME_reserved5[1];
  MC_ME_PCTL11_tag PCTL11;             /* SIPI_0 Peripheral Control Register */
  uint8_t MC_ME_reserved6[3];
  MC_ME_PCTL15_tag PCTL15;             /* SIUL Peripheral Control Register */
  uint8_t MC_ME_reserved7[14];
  MC_ME_PCTL30_tag PCTL30;             /* PIT_RTC_0 Peripheral Control Register */
  MC_ME_PCTL31_tag PCTL31;             /* PIT_RTC_1 Peripheral Control Register */
  uint8_t MC_ME_reserved8[4];
  MC_ME_PCTL36_tag PCTL36;             /* DMAMUX_0 Peripheral Control Register */
  uint8_t MC_ME_reserved9[1];
  MC_ME_PCTL38_tag PCTL38;             /* CRC_0 Peripheral Control Register */
  uint8_t MC_ME_reserved10[17];
  MC_ME_PCTL56_tag PCTL56;             /* ADCSD_8 Peripheral Control Register */
  MC_ME_PCTL57_tag PCTL57;             /* ADCSD_6 Peripheral Control Register */
  MC_ME_PCTL58_tag PCTL58;             /* ADCSD_4 Peripheral Control Register */
  MC_ME_PCTL59_tag PCTL59;             /* ADCSD_2 Peripheral Control Register */
  MC_ME_PCTL60_tag PCTL60;             /* ADCSD_0 Peripheral Control Register */
  uint8_t MC_ME_reserved11[6];
  MC_ME_PCTL67_tag PCTL67;             /* MCAN_4 Peripheral Control Register */
  MC_ME_PCTL68_tag PCTL68;             /* MCAN_3 Peripheral Control Register */
  MC_ME_PCTL69_tag PCTL69;             /* MCAN_2 Peripheral Control Register */
  MC_ME_PCTL70_tag PCTL70;             /* MCAN_1 Peripheral Control Register */
  uint8_t MC_ME_reserved12[1];
  MC_ME_PCTL72_tag PCTL72;             /* TTCAN Peripheral Control Register */
  uint8_t MC_ME_reserved13[1];
  MC_ME_PCTL74_tag PCTL74;             /* CAN_RAM_CTRL Peripheral Control Register */
  uint8_t MC_ME_reserved14[9];
  MC_ME_PCTL84_tag PCTL84;             /* LINFlexD_16 Peripheral Control Register */
  MC_ME_PCTL85_tag PCTL85;             /* LINFlexD_14 Peripheral Control Register */
  uint8_t MC_ME_reserved15[5];
  MC_ME_PCTL91_tag PCTL91;             /* LINFlexD_1 Peripheral Control Register */
  MC_ME_PCTL92_tag PCTL92;             /* LINFlexD_0 Peripheral Control Register */
  MC_ME_PCTL93_tag PCTL93;             /* DSPI_12 Peripheral Control Register */
  uint8_t MC_ME_reserved16[2];
  MC_ME_PCTL96_tag PCTL96;             /* DSPI_6 Peripheral Control Register */
  MC_ME_PCTL97_tag PCTL97;             /* DSPI_4 Peripheral Control Register */
  MC_ME_PCTL98_tag PCTL98;             /* DSPI_1 Peripheral Control Register */
  MC_ME_PCTL99_tag PCTL99;             /* DSPI_0 Peripheral Control Register */
  uint8_t MC_ME_reserved17[1];
  MC_ME_PCTL101_tag PCTL101;           /* IIC_0 Peripheral Control Register */
  uint8_t MC_ME_reserved18[2];
  MC_ME_PCTL104_tag PCTL104;           /* SENT_0 Peripheral Control Register */
  uint8_t MC_ME_reserved19[2];
  MC_ME_PCTL107_tag PCTL107;           /* FLEXRAY_0 Peripheral Control Register */
  uint8_t MC_ME_reserved20[3];
  MC_ME_PCTL111_tag PCTL111;           /* PSI5_0 Peripheral Control Register */
  MC_ME_PCTL112_tag PCTL112;           /* ADCSAR_b Peripheral Control Register */
  uint8_t MC_ME_reserved21[10];
  MC_ME_PCTL123_tag PCTL123;           /* ADCSAR_4 Peripheral Control Register */
  uint8_t MC_ME_reserved22[3];
  MC_ME_PCTL127_tag PCTL127;           /* ADCSAR_0 Peripheral Control Register */
  MC_ME_PCTL128_tag PCTL128;           /* GTMINT Peripheral Control Register */
  uint8_t MC_ME_reserved23[33];
  MC_ME_PCTL162_tag PCTL162;           /* PSI5_S_0 Peripheral Control Register */
  uint8_t MC_ME_reserved24[3];
  MC_ME_PCTL166_tag PCTL166;           /* CRC_1 Peripheral Control Register */
  uint8_t MC_ME_reserved25[17];
  MC_ME_PCTL184_tag PCTL184;           /* ADCSD_9 Peripheral Control Register */
  MC_ME_PCTL185_tag PCTL185;           /* ADCSD_7 Peripheral Control Register */
  MC_ME_PCTL186_tag PCTL186;           /* ADCSD_5 Peripheral Control Register */
  MC_ME_PCTL187_tag PCTL187;           /* ADCSD_3 Peripheral Control Register */
  MC_ME_PCTL188_tag PCTL188;           /* ADCSD_1 Peripheral Control Register */
  uint8_t MC_ME_reserved26[24];
  MC_ME_PCTL213_tag PCTL213;           /* LINFlexD_15 Peripheral Control Register */
  uint8_t MC_ME_reserved27[6];
  MC_ME_PCTL220_tag PCTL220;           /* LINFlexD_2 Peripheral Control Register */
  uint8_t MC_ME_reserved28[4];
  MC_ME_PCTL225_tag PCTL225;           /* DSPI_5 Peripheral Control Register */
  MC_ME_PCTL226_tag PCTL226;           /* DSPI_3 Peripheral Control Register */
  MC_ME_PCTL227_tag PCTL227;           /* DSPI_2 Peripheral Control Register */
  uint8_t MC_ME_reserved29[1];
  MC_ME_PCTL229_tag PCTL229;           /* IIC_1 Peripheral Control Register */
  uint8_t MC_ME_reserved30[2];
  MC_ME_PCTL232_tag PCTL232;           /* SENT_1 Peripheral Control Register */
  uint8_t MC_ME_reserved31[2];
  MC_ME_PCTL235_tag PCTL235;           /* FLEXRAY_1 Peripheral Control Register */
  uint8_t MC_ME_reserved32[3];
  MC_ME_PCTL239_tag PCTL239;           /* PSI5_1 Peripheral Control Register */
  uint8_t MC_ME_reserved33[5];
  MC_ME_PCTL245_tag PCTL245;           /* ADCSAR_10 Peripheral Control Register */
  MC_ME_PCTL246_tag PCTL246;           /* ADCSAR_9 Peripheral Control Register */
  MC_ME_PCTL247_tag PCTL247;           /* ADCSAR_8 Peripheral Control Register */
  MC_ME_PCTL248_tag PCTL248;           /* ADCSAR_7 Peripheral Control Register */
  MC_ME_PCTL249_tag PCTL249;           /* ADCSAR_6 Peripheral Control Register */
  MC_ME_PCTL250_tag PCTL250;           /* ADCSAR_5 Peripheral Control Register */
  uint8_t MC_ME_reserved34[1];
  MC_ME_PCTL252_tag PCTL252;           /* ADCSAR_3 Peripheral Control Register */
  MC_ME_PCTL253_tag PCTL253;           /* ADCSAR_2 Peripheral Control Register */
  MC_ME_PCTL254_tag PCTL254;           /* ADCSAR_1 Peripheral Control Register */
  uint8_t MC_ME_reserved35[1];
  MC_ME_CS_tag CS;                     /* Core Status Register */
  MC_ME_CCTL0_tag CCTL0;               /* CORE0 Core Control Register */
  MC_ME_CCTL1_tag CCTL1;               /* CORE1 Core Control Register */
  MC_ME_CCTL2_tag CCTL2;               /* CORE2 Core Control Register */
  MC_ME_CCTL3_tag CCTL3;               /* CORE3 Core Control Register */
  MC_ME_CCTL4_tag CCTL4;               /* CORE4 Core Control Register */
  uint8_t MC_ME_reserved36[18];
  MC_ME_CADDR0_tag CADDR0;             /* CORE0 Core Address Register */
  MC_ME_CADDR1_tag CADDR1;             /* CORE1 Core Address Register */
  MC_ME_CADDR2_tag CADDR2;             /* CORE2 Core Address Register */
  MC_ME_CADDR3_tag CADDR3;             /* CORE3 Core Address Register */
  MC_ME_CADDR4_tag CADDR4;             /* CORE4 Core Address Register */
};


/* ============================================================================
   =============================== Module: MC_PCU =============================
   ============================================================================ */

typedef union MC_PCU_PSTAT_union_tag { /* Power Domain Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t PD0:1;
  } B;
} MC_PCU_PSTAT_tag;

struct MC_PCU_tag {
  uint8_t MC_PCU_reserved0[64];
  MC_PCU_PSTAT_tag PSTAT;              /* Power Domain Status Register */
};


/* ============================================================================
   =============================== Module: MC_RGM =============================
   ============================================================================ */

typedef union MC_RGM_DES_union_tag {   /* 'Destructive' Event Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :7;
    vuint32_t F_VOR_DEST:1;
    vuint32_t F_TSR_DEST:1;
    vuint32_t  :7;
    vuint32_t F_HSM_DEST:1;
    vuint32_t F_SSCM_DEST:1;
    vuint32_t  :3;
    vuint32_t F_JTAG_DEST:1;
    vuint32_t F_FIF:1;
    vuint32_t F_EDR:1;
    vuint32_t  :2;
    vuint32_t F_SUF:1;
    vuint32_t F_FFRR:1;
    vuint32_t F_SOFT_DEST:1;
    vuint32_t  :1;
    vuint32_t F_PORST:1;
    vuint32_t F_POR:1;
  } B;
} MC_RGM_DES_tag;

typedef union MC_RGM_DERD_union_tag {  /* 'Destructive' Event Reset Disable Register */
  vuint32_t R;
  struct {
    vuint32_t  :7;
    vuint32_t D_VOR_DEST:1;
    vuint32_t  :8;
    vuint32_t D_HSM_DEST:1;
    vuint32_t D_SSCM_DEST:1;
    vuint32_t  :3;
    vuint32_t D_JTAG_DEST:1;
    vuint32_t D_FIF:1;
    vuint32_t D_EDR:1;
    vuint32_t  :2;
    vuint32_t D_SUF:1;
    vuint32_t D_FFRR:1;
    vuint32_t D_SOFT_DEST:1;
    vuint32_t  :1;
    vuint32_t D_PORST:1;
    vuint32_t D_POR:1;
  } B;
} MC_RGM_DERD_tag;

typedef union MC_RGM_DEAR_union_tag {  /* 'Destructive' Event Alternate Request Register */
  vuint32_t R;
  struct {
    vuint32_t  :30;
    vuint32_t AR_PORST:1;
    vuint32_t  :1;
  } B;
} MC_RGM_DEAR_tag;

typedef union MC_RGM_DBRE_union_tag {  /* 'Destructive' Bidirectional Reset Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :7;
    vuint32_t BE_VOR_DEST:1;
    vuint32_t BE_TSR_DEST:1;
    vuint32_t  :7;
    vuint32_t BE_HSM_DEST:1;
    vuint32_t BE_SSCM_DEST:1;
    vuint32_t  :3;
    vuint32_t BE_JTAG_DEST:1;
    vuint32_t BE_FIF:1;
    vuint32_t BE_EDR:1;
    vuint32_t  :2;
    vuint32_t BE_SUF:1;
    vuint32_t BE_FFRR:1;
    vuint32_t BE_SOFT_DEST:1;
    vuint32_t  :1;
    vuint32_t BE_PORST:1;
    vuint32_t BE_POR:1;
  } B;
} MC_RGM_DBRE_tag;

typedef union MC_RGM_FES_union_tag {   /* 'Functional' Event Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :7;
    vuint32_t F_VOR_FUNC:1;
    vuint32_t F_TSR_FUNC:1;
    vuint32_t  :7;
    vuint32_t F_HSM_FUNC:1;
    vuint32_t  :4;
    vuint32_t F_JTAG_FUNC:1;
    vuint32_t  :3;
    vuint32_t F_FCCU_SOFT:1;
    vuint32_t F_FCCU_HARD:1;
    vuint32_t  :1;
    vuint32_t F_SOFT_FUNC:1;
    vuint32_t F_ST_DONE:1;
    vuint32_t F_ESR1:1;
    vuint32_t F_ESR0:1;
  } B;
} MC_RGM_FES_tag;

typedef union MC_RGM_FERD_union_tag {  /* 'Functional' Event Reset Disable Register */
  vuint32_t R;
  struct {
    vuint32_t  :7;
    vuint32_t D_VOR_FUNC:1;
    vuint32_t D_TSR_FUNC:1;
    vuint32_t  :7;
    vuint32_t D_HSM_FUNC:1;
    vuint32_t  :4;
    vuint32_t D_JTAG_FUNC:1;
    vuint32_t  :3;
    vuint32_t D_FCCU_SOFT:1;
    vuint32_t D_FCCU_HARD:1;
    vuint32_t D_SOFT_FUNC:1;
    vuint32_t  :1;
    vuint32_t D_ST_DONE:1;
    vuint32_t D_ESR1:1;
    vuint32_t D_ESR0:1;
  } B;
} MC_RGM_FERD_tag;

typedef union MC_RGM_FEAR_union_tag {  /* 'Functional' Event Alternate Request Register */
  vuint32_t R;
  struct {
    vuint32_t  :7;
    vuint32_t AR_VOR_FUNC:1;
    vuint32_t AR_TSR_FUNC:1;
    vuint32_t  :21;
    vuint32_t AR_ESR1:1;
    vuint32_t  :1;
  } B;
} MC_RGM_FEAR_tag;

typedef union MC_RGM_FBRE_union_tag {  /* 'Functional' Bidirectional Reset Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :7;
    vuint32_t BE_VOR_FUNC:1;
    vuint32_t BE_TSR_FUNC:1;
    vuint32_t  :7;
    vuint32_t BE_HSM_FUNC:1;
    vuint32_t  :4;
    vuint32_t BE_JTAG_FUNC:1;
    vuint32_t  :3;
    vuint32_t BE_FCCU_SOFT:1;
    vuint32_t BE_FCCU_HARD:1;
    vuint32_t  :1;
    vuint32_t BE_SOFT_FUNC:1;
    vuint32_t BE_ST_DONE:1;
    vuint32_t BE_ESR1:1;
    vuint32_t BE_ESR0:1;
  } B;
} MC_RGM_FBRE_tag;

typedef union MC_RGM_FESS_union_tag {  /* 'Functional' Event Short Sequence Register */
  vuint32_t R;
  struct {
    vuint32_t  :7;
    vuint32_t SS_VOR_FUNC:1;
    vuint32_t SS_TSR_FUNC:1;
    vuint32_t  :7;
    vuint32_t SS_HSM_FUNC:1;
    vuint32_t  :4;
    vuint32_t SS_JTAG_FUNC:1;
    vuint32_t  :3;
    vuint32_t SS_FCCU_SOFT:1;
    vuint32_t SS_FCCU_HARD:1;
    vuint32_t  :1;
    vuint32_t SS_SOFT_FUNC:1;
    vuint32_t SS_ST_DONE:1;
    vuint32_t SS_ESR1:1;
    vuint32_t SS_ESR0:1;
  } B;
} MC_RGM_FESS_tag;

typedef union MC_RGM_FRET_union_tag {  /* 'Functional' Reset Escalation Threshold Register */
  vuint8_t R;
  struct {
    vuint8_t  :4;
    vuint8_t FRET:4;
  } B;
} MC_RGM_FRET_tag;

typedef union MC_RGM_DRET_union_tag {  /* 'Destructive' Reset Escalation Threshold Register */
  vuint8_t R;
  struct {
    vuint8_t  :4;
    vuint8_t DRET:4;
  } B;
} MC_RGM_DRET_tag;

typedef union MC_RGM_EROEC_union_tag { /* External Reset Output Extension Control Register */
  vuint8_t R;
  struct {
    vuint8_t  :6;
    vuint8_t ERIS:1;
    vuint8_t EROEC:1;
  } B;
} MC_RGM_EROEC_tag;

typedef union MC_RGM_PRST0_union_tag { /* Peripheral Reset Register 0 */
  vuint32_t R;
  struct {
    vuint32_t PIT_RTC_1_RST:1;
    vuint32_t PIT_RTC_0_RST:1;
    vuint32_t  :14;
    vuint32_t SIUL_RST:1;
    vuint32_t  :3;
    vuint32_t SIPI_0_RST:1;
    vuint32_t  :1;
    vuint32_t LFAST_0_RST:1;
    vuint32_t  :5;
    vuint32_t EBI_0_RST:1;
    vuint32_t  :3;
  } B;
} MC_RGM_PRST0_tag;

typedef union MC_RGM_PRST1_union_tag { /* Peripheral Reset Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :3;
    vuint32_t ADCSD_0_RST:1;
    vuint32_t ADCSD_2_RST:1;
    vuint32_t ADCSD_4_RST:1;
    vuint32_t ADCSD_6_RST:1;
    vuint32_t ADCSD_8_RST:1;
    vuint32_t  :17;
    vuint32_t CRC_0_RST:1;
    vuint32_t  :1;
    vuint32_t DMAMUX_0_RST:1;
    vuint32_t  :4;
  } B;
} MC_RGM_PRST1_tag;

typedef union MC_RGM_PRST2_union_tag { /* Peripheral Reset Register 2 */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t DSPI_12_RST:1;
    vuint32_t LINFlexD_0_RST:1;
    vuint32_t LINFlexD_1_RST:1;
    vuint32_t  :5;
    vuint32_t LINFlexD_14_RST:1;
    vuint32_t LINFlexD_16_RST:1;
    vuint32_t  :9;
    vuint32_t CAN_RAM_CTR_RST:1;
    vuint32_t  :1;
    vuint32_t TTCAN_RST:1;
    vuint32_t  :1;
    vuint32_t MCAN_1_RST:1;
    vuint32_t MCAN_2_RST:1;
    vuint32_t MCAN_3_RST:1;
    vuint32_t MCAN_4_RST:1;
    vuint32_t  :3;
  } B;
} MC_RGM_PRST2_tag;

typedef union MC_RGM_PRST3_union_tag { /* Peripheral Reset Register 3 */
  vuint32_t R;
  struct {
    vuint32_t ADCSAR_0_RST:1;
    vuint32_t  :3;
    vuint32_t ADCSAR_4_RST:1;
    vuint32_t  :10;
    vuint32_t ADCSAR_b_RST:1;
    vuint32_t PSI5_0_RST:1;
    vuint32_t  :3;
    vuint32_t FLEXRAY_0_RST:1;
    vuint32_t  :2;
    vuint32_t SENT_0_RST:1;
    vuint32_t  :2;
    vuint32_t IIC_0_RST:1;
    vuint32_t  :1;
    vuint32_t DSPI_0_RST:1;
    vuint32_t DSPI_1_RST:1;
    vuint32_t DSPI_4_RST:1;
    vuint32_t DSPI_6_RST:1;
  } B;
} MC_RGM_PRST3_tag;

typedef union MC_RGM_PRST4_union_tag { /* Peripheral Reset Register 4 */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t GTMINT_RST:1;
  } B;
} MC_RGM_PRST4_tag;

typedef union MC_RGM_PRST5_union_tag { /* Peripheral Reset Register 5 */
  vuint32_t R;
  struct {
    vuint32_t  :3;
    vuint32_t ADCSD_1_RST:1;
    vuint32_t ADCSD_3_RST:1;
    vuint32_t ADCSD_5_RST:1;
    vuint32_t ADCSD_7_RST:1;
    vuint32_t ADCSD_9_RST:1;
    vuint32_t  :14;
    vuint32_t FCCU_RST:1;
    vuint32_t  :2;
    vuint32_t CRC_1_RST:1;
    vuint32_t  :3;
    vuint32_t PSI5_S_0_RST:1;
    vuint32_t  :2;
  } B;
} MC_RGM_PRST5_tag;

typedef union MC_RGM_PRST6_union_tag { /* Peripheral Reset Register 6 */
  vuint32_t R;
  struct {
    vuint32_t  :3;
    vuint32_t LINFlexD_2_RST:1;
    vuint32_t  :6;
    vuint32_t LINFlexD_15_RST:1;
    vuint32_t  :21;
  } B;
} MC_RGM_PRST6_tag;

typedef union MC_RGM_PRST7_union_tag { /* Peripheral Reset Register 7 */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t ADCSAR_1_RST:1;
    vuint32_t ADCSAR_2_RST:1;
    vuint32_t ADCSAR_3_RST:1;
    vuint32_t  :1;
    vuint32_t ADCSAR_5_RST:1;
    vuint32_t ADCSAR_6_RST:1;
    vuint32_t ADCSAR_7_RST:1;
    vuint32_t ADCSAR_8_RST:1;
    vuint32_t ADCSAR_9_RST:1;
    vuint32_t ADCSAR_10_RST:1;
    vuint32_t  :5;
    vuint32_t PSI5_1_RST:1;
    vuint32_t  :3;
    vuint32_t FLEXRAY_1_RST:1;
    vuint32_t  :2;
    vuint32_t SENT_1_RST:1;
    vuint32_t  :2;
    vuint32_t IIC_1_RST:1;
    vuint32_t  :1;
    vuint32_t DSPI_2_RST:1;
    vuint32_t DSPI_3_RST:1;
    vuint32_t DSPI_5_RST:1;
    vuint32_t  :1;
  } B;
} MC_RGM_PRST7_tag;

struct MC_RGM_tag {
  MC_RGM_DES_tag DES;                  /* 'Destructive' Event Status Register */
  uint8_t MC_RGM_reserved0[12];
  MC_RGM_DERD_tag DERD;                /* 'Destructive' Event Reset Disable Register */
  uint8_t MC_RGM_reserved1[12];
  MC_RGM_DEAR_tag DEAR;                /* 'Destructive' Event Alternate Request Register */
  uint8_t MC_RGM_reserved2[12];
  MC_RGM_DBRE_tag DBRE;                /* 'Destructive' Bidirectional Reset Enable Register */
  uint8_t MC_RGM_reserved3[716];
  MC_RGM_FES_tag FES;                  /* 'Functional' Event Status Register */
  uint8_t MC_RGM_reserved4[12];
  MC_RGM_FERD_tag FERD;                /* 'Functional' Event Reset Disable Register */
  uint8_t MC_RGM_reserved5[12];
  MC_RGM_FEAR_tag FEAR;                /* 'Functional' Event Alternate Request Register */
  uint8_t MC_RGM_reserved6[12];
  MC_RGM_FBRE_tag FBRE;                /* 'Functional' Bidirectional Reset Enable Register */
  uint8_t MC_RGM_reserved7[12];
  MC_RGM_FESS_tag FESS;                /* 'Functional' Event Short Sequence Register */
  uint8_t MC_RGM_reserved8[704];
  MC_RGM_FRET_tag FRET;                /* 'Functional' Reset Escalation Threshold Register */
  uint8_t MC_RGM_reserved9[3];
  MC_RGM_DRET_tag DRET;                /* 'Destructive' Reset Escalation Threshold Register */
  uint8_t MC_RGM_reserved10[3];
  MC_RGM_EROEC_tag EROEC;              /* External Reset Output Extension Control Register */
  uint8_t MC_RGM_reserved11[3];
  MC_RGM_PRST0_tag PRST0;              /* Peripheral Reset Register 0 */
  MC_RGM_PRST1_tag PRST1;              /* Peripheral Reset Register 1 */
  MC_RGM_PRST2_tag PRST2;              /* Peripheral Reset Register 2 */
  MC_RGM_PRST3_tag PRST3;              /* Peripheral Reset Register 3 */
  MC_RGM_PRST4_tag PRST4;              /* Peripheral Reset Register 4 */
  MC_RGM_PRST5_tag PRST5;              /* Peripheral Reset Register 5 */
  MC_RGM_PRST6_tag PRST6;              /* Peripheral Reset Register 6 */
  MC_RGM_PRST7_tag PRST7;              /* Peripheral Reset Register 7 */
};


/* ============================================================================
   =============================== Module: MEMU ===============================
   ============================================================================ */

typedef union MEMU_CTRL_union_tag {    /* Control register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t SWR:1;
    vuint32_t  :15;
  } B;
} MEMU_CTRL_tag;

typedef union MEMU_ERR_FLAG_union_tag { /* Error flag register */
  vuint32_t R;
  struct {
    vuint32_t  :11;
    vuint32_t PR_CE:1;
    vuint32_t PR_UCE:1;
    vuint32_t PR_CEO:1;
    vuint32_t PR_UCO:1;
    vuint32_t PR_EBO:1;
    vuint32_t  :3;
    vuint32_t F_CE:1;
    vuint32_t F_UCE:1;
    vuint32_t F_CEO:1;
    vuint32_t F_UCO:1;
    vuint32_t F_EBO:1;
    vuint32_t  :3;
    vuint32_t SR_CE:1;
    vuint32_t SR_UCE:1;
    vuint32_t SR_CEO:1;
    vuint32_t SR_UCO:1;
    vuint32_t SR_EBO:1;
  } B;
} MEMU_ERR_FLAG_tag;

typedef union MEMU_DEBUG_union_tag {   /* Debug register */
  vuint32_t R;
  struct {
    vuint32_t  :11;
    vuint32_t FR_PR_CE:1;
    vuint32_t FR_PR_UCE:1;
    vuint32_t FR_PR_CEO:1;
    vuint32_t FR_PR_UCO:1;
    vuint32_t FR_PR_EBO:1;
    vuint32_t  :3;
    vuint32_t FR_F_CE:1;
    vuint32_t FR_F_UCE:1;
    vuint32_t FR_F_CEO:1;
    vuint32_t FR_F_UCO:1;
    vuint32_t FR_F_EBO:1;
    vuint32_t  :3;
    vuint32_t FR_SR_CE:1;
    vuint32_t FR_SR_UCE:1;
    vuint32_t FR_SR_CEO:1;
    vuint32_t FR_SR_UCO:1;
    vuint32_t FR_SR_EBO:1;
  } B;
} MEMU_DEBUG_tag;

typedef union MEMU_SYS_RAM_CERR_STS_union_tag { /* System RAM correctable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t  :23;
    vuint32_t BAD_BIT:8;
  } B;
} MEMU_SYS_RAM_CERR_STS_tag;

typedef union MEMU_SYS_RAM_CERR_ADDR_union_tag { /* System RAM correctable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_SYS_RAM_CERR_ADDR_tag;

typedef struct MEMU_SYS_RAM_CERR_struct_tag {
  MEMU_SYS_RAM_CERR_STS_tag STS;       /* System RAM correctable error reporting table status register */
  MEMU_SYS_RAM_CERR_ADDR_tag ADDR;     /* System RAM correctable error reporting table address register */
} MEMU_SYS_RAM_CERR_tag;

typedef union MEMU_SYS_RAM_UNCERR_STS_union_tag { /* System RAM uncorrectable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t  :31;
  } B;
} MEMU_SYS_RAM_UNCERR_STS_tag;

typedef union MEMU_SYS_RAM_UNCERR_ADDR_union_tag { /* System RAM uncorrectable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_SYS_RAM_UNCERR_ADDR_tag;

typedef union MEMU_SYS_RAM_OFLW_union_tag { /* System RAM concurrent overflow register */
  vuint32_t R;
  struct {
    vuint32_t OFLW:32;
  } B;
} MEMU_SYS_RAM_OFLW_tag;

typedef union MEMU_PERIPH_RAM_CERR_STS_union_tag { /* Peripheral RAM correctable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t  :23;
    vuint32_t BAD_BIT:8;
  } B;
} MEMU_PERIPH_RAM_CERR_STS_tag;

typedef union MEMU_PERIPH_RAM_CERR_ADDR_union_tag { /* Peripheral RAM correctable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_PERIPH_RAM_CERR_ADDR_tag;

typedef struct MEMU_PERIPH_RAM_CERR_struct_tag {
  MEMU_PERIPH_RAM_CERR_STS_tag STS;    /* Peripheral RAM correctable error reporting table status register */
  MEMU_PERIPH_RAM_CERR_ADDR_tag ADDR;  /* Peripheral RAM correctable error reporting table address register */
} MEMU_PERIPH_RAM_CERR_tag;

typedef union MEMU_PERIPH_RAM_UNCERR_STS_union_tag { /* Peripheral RAM uncorrectable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t  :31;
  } B;
} MEMU_PERIPH_RAM_UNCERR_STS_tag;

typedef union MEMU_PERIPH_RAM_UNCERR_ADDR_union_tag { /* Peripheral RAM uncorrectable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_PERIPH_RAM_UNCERR_ADDR_tag;

typedef union MEMU_PERIPH_RAM_OFLW_union_tag { /* Peripheral RAM concurrent overflow register */
  vuint32_t R;
  struct {
    vuint32_t OFLW:32;
  } B;
} MEMU_PERIPH_RAM_OFLW_tag;

typedef union MEMU_FLASH_CERR_STS_union_tag { /* Flash memory correctable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t  :23;
    vuint32_t BAD_BIT:8;
  } B;
} MEMU_FLASH_CERR_STS_tag;

typedef union MEMU_FLASH_CERR_ADDR_union_tag { /* Flash memory correctable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_FLASH_CERR_ADDR_tag;

typedef struct MEMU_FLASH_CERR_struct_tag {
  MEMU_FLASH_CERR_STS_tag STS;         /* Flash memory correctable error reporting table status register */
  MEMU_FLASH_CERR_ADDR_tag ADDR;       /* Flash memory correctable error reporting table address register */
} MEMU_FLASH_CERR_tag;

typedef union MEMU_FLASH_UNCERR_STS_union_tag { /* Flash memory uncorrectable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t  :31;
  } B;
} MEMU_FLASH_UNCERR_STS_tag;

typedef union MEMU_FLASH_UNCERR_ADDR_union_tag { /* Flash memory uncorrectable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_FLASH_UNCERR_ADDR_tag;

typedef union MEMU_FLASH_OFLW0_union_tag { /* Flash memory concurrent overflow register */
  vuint32_t R;
  struct {
    vuint32_t OFLW:32;
  } B;
} MEMU_FLASH_OFLW0_tag;

struct MEMU_tag {
  MEMU_CTRL_tag CTRL;                  /* Control register */
  MEMU_ERR_FLAG_tag ERR_FLAG;          /* Error flag register */
  uint8_t MEMU_reserved0[4];
  MEMU_DEBUG_tag DEBUG;                /* Debug register */
  uint8_t MEMU_reserved1[16];
  MEMU_SYS_RAM_CERR_tag SYS_RAM_CERR[10];
  MEMU_SYS_RAM_UNCERR_STS_tag SYS_RAM_UNCERR_STS; /* System RAM uncorrectable error reporting table status register */
  MEMU_SYS_RAM_UNCERR_ADDR_tag SYS_RAM_UNCERR_ADDR; /* System RAM uncorrectable error reporting table address register */
  MEMU_SYS_RAM_OFLW_tag SYS_RAM_OFLW[3]; /* System RAM concurrent overflow register */
  uint8_t MEMU_reserved2[1436];
  MEMU_PERIPH_RAM_CERR_tag PERIPH_RAM_CERR[2];
  MEMU_PERIPH_RAM_UNCERR_STS_tag PERIPH_RAM_UNCERR_STS; /* Peripheral RAM uncorrectable error reporting table status register */
  MEMU_PERIPH_RAM_UNCERR_ADDR_tag PERIPH_RAM_UNCERR_ADDR; /* Peripheral RAM uncorrectable error reporting table address register */
  MEMU_PERIPH_RAM_OFLW_tag PERIPH_RAM_OFLW[2]; /* Peripheral RAM concurrent overflow register */
  uint8_t MEMU_reserved3[1504];
  MEMU_FLASH_CERR_tag FLASH_CERR[20];
  MEMU_FLASH_UNCERR_STS_tag FLASH_UNCERR_STS; /* Flash memory uncorrectable error reporting table status register */
  MEMU_FLASH_UNCERR_ADDR_tag FLASH_UNCERR_ADDR; /* Flash memory uncorrectable error reporting table address register */
  MEMU_FLASH_OFLW0_tag FLASH_OFLW0;    /* Flash memory concurrent overflow register */
};


/* ============================================================================
   =============================== Module: M_CAN ==============================
   ============================================================================ */

typedef union M_CAN_CREL_union_tag {   /* Core Release Register */
  vuint32_t R;
  struct {
    vuint32_t REL:4;
    vuint32_t STEP:4;
    vuint32_t SUBSTEP:4;
    vuint32_t YEAR:4;
    vuint32_t MON:8;
    vuint32_t DAY:8;
  } B;
} M_CAN_CREL_tag;

typedef union M_CAN_ENDN_union_tag {   /* Endian Register */
  vuint32_t R;
  struct {
    vuint32_t ETV:32;
  } B;
} M_CAN_ENDN_tag;

typedef union M_CAN_FBTP_union_tag {   /* Fast Bit Timing and Prescaler Register */
  vuint32_t R;
  struct {
    vuint32_t  :3;
    vuint32_t TDCO:5;                  /* Transceiver Delay Compensation Offset */
    vuint32_t TDC:1;                   /* Transceiver Delay Compensation */
    vuint32_t  :2;
    vuint32_t FBRP:5;                  /* Fast Baud Rate Prescaler */
    vuint32_t  :4;
    vuint32_t FTSEG1:4;                /* Fast time segment before sample point */
    vuint32_t  :1;
    vuint32_t FTSEG2:3;                /* Fast time segment before sample point */
    vuint32_t  :2;
    vuint32_t FSJW:2;                  /* Fast (Re) Synchronization Jump Width */
  } B;
} M_CAN_FBTP_tag;

typedef union M_CAN_TEST_union_tag {   /* Test Register */
  vuint32_t R;
  struct {
    vuint32_t  :18;
    vuint32_t TDCV:6;                  /* Transceiver Delay Compensation Value */
    vuint32_t RX:1;
    vuint32_t TX:2;
    vuint32_t LBCK:1;
    vuint32_t  :4;
  } B;
} M_CAN_TEST_tag;

typedef union M_CAN_RWD_union_tag {    /* RAM Watchdog Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t WDV:8;
    vuint32_t WDC:8;
  } B;
} M_CAN_RWD_tag;

typedef union M_CAN_CCCR_union_tag {   /* CC Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t  :1;
    vuint32_t TXP:1;                   /* Transmit Pause */
    vuint32_t FDBS:1;                  /* CAN FD Bit Rate Switching */
    vuint32_t FDO:1;                   /* Fast Frame Mode Active */
    vuint32_t CMR:2;                   /* CAN Mode Request */
    vuint32_t CME:2;                   /* CAN Mode Enable */
    vuint32_t TEST:1;
    vuint32_t DAR:1;
    vuint32_t MON:1;
    vuint32_t CSR:1;
    vuint32_t CSA:1;
    vuint32_t ASM:1;
    vuint32_t CCE:1;
    vuint32_t INIT:1;
  } B;
} M_CAN_CCCR_tag;

typedef union M_CAN_BTP_union_tag {    /* Bit Timing and Prescaler Register */
  vuint32_t R;
  struct {
    vuint32_t  :6;
    vuint32_t BRP:10;                  /* Baud Rate Prescaler */
    vuint32_t  :2;
    vuint32_t TSEG1:6;
    vuint32_t TSEG2:4;
    vuint32_t SJW:4;
  } B;
} M_CAN_BTP_tag;

typedef union M_CAN_TSCC_union_tag {   /* Timestamp Counter Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t TCP:4;
    vuint32_t  :14;
    vuint32_t TSS:2;
  } B;
} M_CAN_TSCC_tag;

typedef union M_CAN_TSCV_union_tag {   /* Timestamp Counter Value Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t TSC:16;                  /* Timestamp Counter */
  } B;
} M_CAN_TSCV_tag;

typedef union M_CAN_TOCC_union_tag {   /* Timeout Counter Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t TOP:16;
    vuint32_t  :13;
    vuint32_t TOS:2;
    vuint32_t ETOC:1;
  } B;
} M_CAN_TOCC_tag;

typedef union M_CAN_TOCV_union_tag {   /* Timeout Counter Value Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t TOC:16;
  } B;
} M_CAN_TOCV_tag;

typedef union M_CAN_ECR_union_tag {    /* Error Counter Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t CEL:8;
    vuint32_t RP:1;
    vuint32_t REC:7;
    vuint32_t TEC:8;
  } B;
} M_CAN_ECR_tag;

typedef union M_CAN_PSR_union_tag {    /* Protocol Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :18;
    vuint32_t REDL:1;                  /* Received CAN FD Message with EDL flag */
    vuint32_t RBRS:1;                  /* BRS flag of last received CAN FD Message */
    vuint32_t RESI:1;                  /* ESI CAN FD Message with ESI flag */
    vuint32_t FLEC:3;                  /* Fast Last Error Code */
    vuint32_t BO:1;
    vuint32_t EW:1;
    vuint32_t EP:1;
    vuint32_t ACT:2;
    vuint32_t LEC:3;
  } B;
} M_CAN_PSR_tag;

typedef union M_CAN_IR_union_tag {     /* Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t STE:1;
    vuint32_t FOE:1;
    vuint32_t ACKE:1;
    vuint32_t BE:1;
    vuint32_t CRCE:1;
    vuint32_t WDI:1;
    vuint32_t BO:1;
    vuint32_t EW:1;
    vuint32_t EP:1;
    vuint32_t ELO:1;
    vuint32_t BEU:1;
    vuint32_t BEC:1;
    vuint32_t DRX:1;                   /* Message stored to Dedicated Rx Buffer */
    vuint32_t TOO:1;
    vuint32_t MRAF:1;                  /* Message RAM Access Failure */
    vuint32_t TSW:1;
    vuint32_t TEFL:1;
    vuint32_t TEFF:1;
    vuint32_t TEFW:1;
    vuint32_t TEFN:1;
    vuint32_t TFE:1;
    vuint32_t TCF:1;
    vuint32_t TC:1;
    vuint32_t HPM:1;
    vuint32_t RF1L:1;
    vuint32_t RF1F:1;
    vuint32_t RF1W:1;
    vuint32_t RF1N:1;
    vuint32_t RF0L:1;
    vuint32_t RF0F:1;
    vuint32_t RF0W:1;
    vuint32_t RF0N:1;
  } B;
} M_CAN_IR_tag;

typedef union M_CAN_IE_union_tag {     /* Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t STEE:1;
    vuint32_t FOEE:1;
    vuint32_t ACKEE:1;
    vuint32_t BEE:1;
    vuint32_t CRCEE:1;
    vuint32_t WDIE:1;
    vuint32_t BOE:1;
    vuint32_t EWE:1;
    vuint32_t EPE:1;
    vuint32_t ELOE:1;
    vuint32_t BEUE:1;
    vuint32_t BECE:1;
    vuint32_t DRXE:1;                  /* Message stored to Dedicated Rx Buffer Interrupt Enable */
    vuint32_t TOOE:1;
    vuint32_t MRAFE:1;
    vuint32_t TSWE:1;
    vuint32_t TEFLE:1;
    vuint32_t TEFFE:1;
    vuint32_t TEFWE:1;
    vuint32_t TEFNE:1;
    vuint32_t TFEE:1;
    vuint32_t TCFE:1;
    vuint32_t TCE:1;
    vuint32_t HPME:1;
    vuint32_t RF1LE:1;
    vuint32_t RF1FE:1;
    vuint32_t RF1WE:1;
    vuint32_t RF1NE:1;
    vuint32_t RF0LE:1;
    vuint32_t RF0FE:1;
    vuint32_t RF0WE:1;
    vuint32_t RF0NE:1;
  } B;
} M_CAN_IE_tag;

typedef union M_CAN_ILS_union_tag {    /* Interrupt Line Select Register */
  vuint32_t R;
  struct {
    vuint32_t STEL:1;
    vuint32_t FOEL:1;
    vuint32_t ACKEL:1;
    vuint32_t BEL:1;
    vuint32_t CRCEL:1;
    vuint32_t WDIL:1;
    vuint32_t BOL:1;
    vuint32_t EWL:1;
    vuint32_t EPL:1;
    vuint32_t ELOL:1;
    vuint32_t BEUL:1;
    vuint32_t BECL:1;
    vuint32_t DRXL:1;                  /* Message stored to Dedicated Rx Buffer Interrupt Line */
    vuint32_t TOOL:1;
    vuint32_t MRAFL:1;
    vuint32_t TSWL:1;
    vuint32_t TEFLL:1;
    vuint32_t TEFFL:1;
    vuint32_t TEFWL:1;
    vuint32_t TEFNL:1;
    vuint32_t TFEL:1;
    vuint32_t TCFL:1;
    vuint32_t TCL:1;
    vuint32_t HPML:1;
    vuint32_t RF1LL:1;
    vuint32_t RF1FL:1;
    vuint32_t RF1WL:1;
    vuint32_t RF1NL:1;
    vuint32_t RF0LL:1;
    vuint32_t RF0FL:1;
    vuint32_t RF0WL:1;
    vuint32_t RF0NL:1;
  } B;
} M_CAN_ILS_tag;

typedef union M_CAN_ILE_union_tag {    /* Interrupt Line Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :30;
    vuint32_t EINT1:1;
    vuint32_t EINT0:1;
  } B;
} M_CAN_ILE_tag;

typedef union M_CAN_GFC_union_tag {    /* Global Filter Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t ANFS:2;
    vuint32_t ANFE:2;
    vuint32_t RRFS:1;
    vuint32_t RRFE:1;
  } B;
} M_CAN_GFC_tag;

typedef union M_CAN_SIDFC_union_tag {  /* Standard ID Filter Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t LSS:8;
    vuint32_t FLSSA:14;
    vuint32_t  :2;
  } B;
} M_CAN_SIDFC_tag;

typedef union M_CAN_XIDFC_union_tag {  /* Extended ID Filter Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :9;
    vuint32_t LSE:7;
    vuint32_t FLESA:14;
    vuint32_t  :2;
  } B;
} M_CAN_XIDFC_tag;

typedef union M_CAN_XIDAM_union_tag {  /* Extended ID and Mask Register */
  vuint32_t R;
  struct {
    vuint32_t  :3;
    vuint32_t EIDM:29;
  } B;
} M_CAN_XIDAM_tag;

typedef union M_CAN_HPMS_union_tag {   /* High Priority Message Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t FLST:1;
    vuint32_t FIDX:7;
    vuint32_t MSI:2;
    vuint32_t BIDX:6;
  } B;
} M_CAN_HPMS_tag;

typedef union M_CAN_NDAT1_union_tag {  /* New Data 1 Register */
  vuint32_t R;
  struct {
    vuint32_t ND1:32;                  /* New Data[0:31] */
  } B;
} M_CAN_NDAT1_tag;

typedef union M_CAN_NDAT2_union_tag {  /* New Data 2 Register */
  vuint32_t R;
  struct {
    vuint32_t ND2:32;                  /* New Data[32:63] */
  } B;
} M_CAN_NDAT2_tag;

typedef union M_CAN_RXF0C_union_tag {  /* Rx FIFO 0 Configuration */
  vuint32_t R;
  struct {
    vuint32_t F0OM:1;                  /* FIFO 0 Operation Mode */
    vuint32_t F0WM:7;
    vuint32_t  :2;
    vuint32_t F0S:6;
    vuint32_t F0SA:14;
    vuint32_t  :2;
  } B;
} M_CAN_RXF0C_tag;

typedef union M_CAN_RXF0S_union_tag {  /* Rx FIFO 0 Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :6;
    vuint32_t RF0L:1;
    vuint32_t F0F:1;
    vuint32_t  :2;
    vuint32_t F0PI:6;                  /* Rx FIFO 0 Put Index */
    vuint32_t  :2;
    vuint32_t F0GI:6;
    vuint32_t  :1;
    vuint32_t F0FL:7;
  } B;
} M_CAN_RXF0S_tag;

typedef union M_CAN_RXF0A_union_tag {  /* Rx FIFO 0 Acknowledge Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t F0AI:6;
  } B;
} M_CAN_RXF0A_tag;

typedef union M_CAN_RXBC_union_tag {   /* Rx Buffer Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t RBSA:14;                 /* Rx Buffer Start Address */
    vuint32_t  :2;
  } B;
} M_CAN_RXBC_tag;

typedef union M_CAN_RXF1C_union_tag {  /* Rx FIFO 1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t F1OM:1;                  /* FIFO 1 Operation Mode */
    vuint32_t F1WM:7;
    vuint32_t  :1;
    vuint32_t F1S:7;
    vuint32_t F1SA:14;
    vuint32_t  :2;
  } B;
} M_CAN_RXF1C_tag;

typedef union M_CAN_RXF1S_union_tag {  /* Rx FIFO 1 Status Register */
  vuint32_t R;
  struct {
    vuint32_t DMS:2;
    vuint32_t  :4;
    vuint32_t RF1L:1;
    vuint32_t F1F:1;
    vuint32_t  :2;
    vuint32_t F1PI:6;                  /* Rx FIFO 1 Put Index */
    vuint32_t  :2;
    vuint32_t F1G1:6;
    vuint32_t  :1;
    vuint32_t F1FL:7;
  } B;
} M_CAN_RXF1S_tag;

typedef union M_CAN_RXF1A_union_tag {  /* Rx FIFO 1 Acknowledge Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t F1AI:6;
  } B;
} M_CAN_RXF1A_tag;

typedef union M_CAN_RXESC_union_tag {  /* Rx Buffer / FIFO Element Size Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t RBDS:3;                  /* Rx Buffer Data Field Size */
    vuint32_t  :1;
    vuint32_t F1DS:3;                  /* Rx FIFO 1 Data Field Size */
    vuint32_t  :1;
    vuint32_t F0DS:3;                  /* Rx FIFO 0 Data Field Size */
  } B;
} M_CAN_RXESC_tag;

typedef union M_CAN_TXBC_union_tag {   /* Tx Buffer Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t TQFM:1;
    vuint32_t TQFS:6;
    vuint32_t  :2;
    vuint32_t NDTB:6;
    vuint32_t TBSA:14;
    vuint32_t  :2;
  } B;
} M_CAN_TXBC_tag;

typedef union M_CAN_TXFQS_union_tag {  /* Tx FIFO/Queue Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :10;
    vuint32_t TFQF:1;
    vuint32_t TFQPI:5;
    vuint32_t  :3;
    vuint32_t TFGI:5;                  /* Tx FIFO Get Index */
    vuint32_t  :2;
    vuint32_t TFFL:6;
  } B;
} M_CAN_TXFQS_tag;

typedef union M_CAN_TXESC_union_tag {  /* Tx Buffer Element Size Configuration */
  vuint32_t R;
  struct {
    vuint32_t  :29;
    vuint32_t TBDS:3;
  } B;
} M_CAN_TXESC_tag;

typedef union M_CAN_TXBRP_union_tag {  /* Tx Buffer Request Pending Register */
  vuint32_t R;
  struct {
    vuint32_t TRP:32;                  /* Transmission Request Pending */
  } B;
} M_CAN_TXBRP_tag;

typedef union M_CAN_TXBAR_union_tag {  /* Tx Buffer Add Request register */
  vuint32_t R;
  struct {
    vuint32_t AR:32;                   /* Add Request */
  } B;
} M_CAN_TXBAR_tag;

typedef union M_CAN_TXBCR_union_tag {  /* Tx Buffer Cancellation Request register */
  vuint32_t R;
  struct {
    vuint32_t CR:32;                   /* Cancellation Request */
  } B;
} M_CAN_TXBCR_tag;

typedef union M_CAN_TXBTO_union_tag {  /* Tx Buffer Transmission Occurred register */
  vuint32_t R;
  struct {
    vuint32_t TO:32;                   /* Transmission Occurred */
  } B;
} M_CAN_TXBTO_tag;

typedef union M_CAN_TXBCF_union_tag {  /* Tx Buffer Cancellation Finished register */
  vuint32_t R;
  struct {
    vuint32_t CF:32;                   /* Cancellation Finished */
  } B;
} M_CAN_TXBCF_tag;

typedef union M_CAN_TXBTIE_union_tag { /* Tx Buffer Transmission Interrupt Enable register */
  vuint32_t R;
  struct {
    vuint32_t TIE:32;
  } B;
} M_CAN_TXBTIE_tag;

typedef union M_CAN_TXBCIE_union_tag { /* Tx Buffer Cancellation Finished Interrupt Enable register */
  vuint32_t R;
  struct {
    vuint32_t CFIE:32;
  } B;
} M_CAN_TXBCIE_tag;

typedef union M_CAN_TXEFC_union_tag {  /* Tx Event FIFO Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t EFWM:6;
    vuint32_t  :2;
    vuint32_t EFS:6;
    vuint32_t EFSA:14;
    vuint32_t  :2;
  } B;
} M_CAN_TXEFC_tag;

typedef union M_CAN_TXEFS_union_tag {  /* Tx Event FIFO Status register */
  vuint32_t R;
  struct {
    vuint32_t  :6;
    vuint32_t TEFL:1;
    vuint32_t EFF:1;
    vuint32_t  :3;
    vuint32_t EFPI:5;
    vuint32_t  :3;
    vuint32_t EFGI:5;
    vuint32_t  :2;
    vuint32_t EFFL:6;
  } B;
} M_CAN_TXEFS_tag;

typedef union M_CAN_TXEFA_union_tag {  /* Tx Event FIFO Acknowledge register */
  vuint32_t R;
  struct {
    vuint32_t  :27;
    vuint32_t EFAI:5;
  } B;
} M_CAN_TXEFA_tag;

struct M_CAN_tag {
  M_CAN_CREL_tag CREL;                 /* Core Release Register */
  M_CAN_ENDN_tag ENDN;                 /* Endian Register */
  uint8_t M_CAN_reserved0[4];
  M_CAN_FBTP_tag FBTP;                 /* Fast Bit Timing and Prescaler Register */
  M_CAN_TEST_tag TEST;                 /* Test Register */
  M_CAN_RWD_tag RWD;                   /* RAM Watchdog Register */
  M_CAN_CCCR_tag CCCR;                 /* CC Control Register */
  M_CAN_BTP_tag BTP;                   /* Bit Timing and Prescaler Register */
  M_CAN_TSCC_tag TSCC;                 /* Timestamp Counter Configuration Register */
  M_CAN_TSCV_tag TSCV;                 /* Timestamp Counter Value Register */
  M_CAN_TOCC_tag TOCC;                 /* Timeout Counter Configuration Register */
  M_CAN_TOCV_tag TOCV;                 /* Timeout Counter Value Register */
  uint8_t M_CAN_reserved1[16];
  M_CAN_ECR_tag ECR;                   /* Error Counter Register */
  M_CAN_PSR_tag PSR;                   /* Protocol Status Register */
  uint8_t M_CAN_reserved2[8];
  M_CAN_IR_tag IR;                     /* Interrupt Register */
  M_CAN_IE_tag IE;                     /* Interrupt Enable Register */
  M_CAN_ILS_tag ILS;                   /* Interrupt Line Select Register */
  M_CAN_ILE_tag ILE;                   /* Interrupt Line Enable Register */
  uint8_t M_CAN_reserved3[32];
  M_CAN_GFC_tag GFC;                   /* Global Filter Configuration Register */
  M_CAN_SIDFC_tag SIDFC;               /* Standard ID Filter Configuration Register */
  M_CAN_XIDFC_tag XIDFC;               /* Extended ID Filter Configuration Register */
  uint8_t M_CAN_reserved4[4];
  M_CAN_XIDAM_tag XIDAM;               /* Extended ID and Mask Register */
  M_CAN_HPMS_tag HPMS;                 /* High Priority Message Status Register */
  M_CAN_NDAT1_tag NDAT1;               /* New Data 1 Register */
  M_CAN_NDAT2_tag NDAT2;               /* New Data 2 Register */
  M_CAN_RXF0C_tag RXF0C;               /* Rx FIFO 0 Configuration */
  M_CAN_RXF0S_tag RXF0S;               /* Rx FIFO 0 Status Register */
  M_CAN_RXF0A_tag RXF0A;               /* Rx FIFO 0 Acknowledge Register */
  M_CAN_RXBC_tag RXBC;                 /* Rx Buffer Configuration Register */
  M_CAN_RXF1C_tag RXF1C;               /* Rx FIFO 1 Configuration Register */
  M_CAN_RXF1S_tag RXF1S;               /* Rx FIFO 1 Status Register */
  M_CAN_RXF1A_tag RXF1A;               /* Rx FIFO 1 Acknowledge Register */
  M_CAN_RXESC_tag RXESC;               /* Rx Buffer / FIFO Element Size Configuration Register */
  M_CAN_TXBC_tag TXBC;                 /* Tx Buffer Configuration Register */
  M_CAN_TXFQS_tag TXFQS;               /* Tx FIFO/Queue Status Register */
  M_CAN_TXESC_tag TXESC;               /* Tx Buffer Element Size Configuration */
  M_CAN_TXBRP_tag TXBRP;               /* Tx Buffer Request Pending Register */
  M_CAN_TXBAR_tag TXBAR;               /* Tx Buffer Add Request register */
  M_CAN_TXBCR_tag TXBCR;               /* Tx Buffer Cancellation Request register */
  M_CAN_TXBTO_tag TXBTO;               /* Tx Buffer Transmission Occurred register */
  M_CAN_TXBCF_tag TXBCF;               /* Tx Buffer Cancellation Finished register */
  M_CAN_TXBTIE_tag TXBTIE;             /* Tx Buffer Transmission Interrupt Enable register */
  M_CAN_TXBCIE_tag TXBCIE;             /* Tx Buffer Cancellation Finished Interrupt Enable register */
  uint8_t M_CAN_reserved5[8];
  M_CAN_TXEFC_tag TXEFC;               /* Tx Event FIFO Configuration Register */
  M_CAN_TXEFS_tag TXEFS;               /* Tx Event FIFO Status register */
  M_CAN_TXEFA_tag TXEFA;               /* Tx Event FIFO Acknowledge register */
};


/* ============================================================================
   =============================== Module: M_TTCAN ============================
   ============================================================================ */

typedef union M_TTCAN_CREL_union_tag { /* Core Release Register */
  vuint32_t R;
  struct {
    vuint32_t REL:4;
    vuint32_t STEP:4;
    vuint32_t SUBSTEP:4;
    vuint32_t YEAR:4;
    vuint32_t MON:8;
    vuint32_t DAY:8;
  } B;
} M_TTCAN_CREL_tag;

typedef union M_TTCAN_ENDN_union_tag { /* Endian Register */
  vuint32_t R;
  struct {
    vuint32_t ETV:32;
  } B;
} M_TTCAN_ENDN_tag;

typedef union M_TTCAN_FBTP_union_tag { /* Fast Bit Timing and Prescaler Register */
  vuint32_t R;
  struct {
    vuint32_t TDCO:4;                  /* Transceiver Delay Compensation Offset */
    vuint32_t TDC:1;                   /* Transceiver Delay Compensation */
    vuint32_t  :1;
    vuint32_t FBRP:10;                 /* Fast Baud Rate Prescaler */
    vuint32_t  :4;
    vuint32_t FTSEG1:4;                /* Fast time segment before sample point */
    vuint32_t  :1;
    vuint32_t FTSEG2:3;                /* Fast time segment before sample point */
    vuint32_t  :2;
    vuint32_t FSJW:2;                  /* Fast (Re) Synchronization Jump Width */
  } B;
} M_TTCAN_FBTP_tag;

typedef union M_TTCAN_TEST_union_tag { /* Test Register */
  vuint32_t R;
  struct {
    vuint32_t  :19;
    vuint32_t TDCV:5;                  /* Transceiver Delay Compensation Value */
    vuint32_t RX:1;
    vuint32_t TX:2;
    vuint32_t LBCK:1;
    vuint32_t CAT:1;                   /* Check ASC Transmit Control */
    vuint32_t CAM:1;                   /* Check ASC Multiplexer Control */
    vuint32_t TAT:1;                   /* Test ASC Transmit Control */
    vuint32_t TAM:1;                   /* Test ASC Multiplexer Control */
  } B;
} M_TTCAN_TEST_tag;

typedef union M_TTCAN_RWD_union_tag {  /* RAM Watchdog Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t WDV:8;
    vuint32_t WDC:8;
  } B;
} M_TTCAN_RWD_tag;

typedef union M_TTCAN_CCCR_union_tag { /* CC Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :18;
    vuint32_t FDBS:1;                  /* Long Frame Mode Active */
    vuint32_t FDO:1;                   /* Fast Frame Mode Active */
    vuint32_t CMR:2;                   /* CAN Mode Request */
    vuint32_t CME:2;                   /* CAN Mode Enable */
    vuint32_t TEST:1;
    vuint32_t DAR:1;
    vuint32_t MON:1;
    vuint32_t CSR:1;
    vuint32_t CSA:1;
    vuint32_t ASM:1;                   /* ASM Restricted Operation Mode */
    vuint32_t CCE:1;
    vuint32_t INIT:1;
  } B;
} M_TTCAN_CCCR_tag;

typedef union M_TTCAN_BTP_union_tag {  /* Bit Timing and Prescaler Register */
  vuint32_t R;
  struct {
    vuint32_t  :6;
    vuint32_t BRP:10;                  /* Baud Rate Prescaler */
    vuint32_t  :2;
    vuint32_t TSEG1:6;
    vuint32_t TSEG2:4;                 /* Time segment after sample point */
    vuint32_t SJW:4;                   /* (Re) Synchronization Jump Width */
  } B;
} M_TTCAN_BTP_tag;

typedef union M_TTCAN_TSCC_union_tag { /* Timestamp Counter Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t TCP:4;
    vuint32_t  :14;
    vuint32_t TSS:2;
  } B;
} M_TTCAN_TSCC_tag;

typedef union M_TTCAN_TSCV_union_tag { /* Timestamp Counter Value Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t TSC:16;
  } B;
} M_TTCAN_TSCV_tag;

typedef union M_TTCAN_TOCC_union_tag { /* Timeout Counter Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t TOP:16;
    vuint32_t  :13;
    vuint32_t TOS:2;
    vuint32_t ETOC:1;
  } B;
} M_TTCAN_TOCC_tag;

typedef union M_TTCAN_TOCV_union_tag { /* Timeout Counter Value Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t TOC:16;
  } B;
} M_TTCAN_TOCV_tag;

typedef union M_TTCAN_ECR_union_tag {  /* Error Counter Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t CEL:8;
    vuint32_t RP:1;
    vuint32_t REC:7;
    vuint32_t TEC:8;
  } B;
} M_TTCAN_ECR_tag;

typedef union M_TTCAN_PSR_union_tag {  /* Protocol Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :18;
    vuint32_t REDL:1;                  /* Received a CAN FD Message */
    vuint32_t RBRS:1;                  /* BRS flag of last received CAN FD Message */
    vuint32_t RESI:1;                  /* ESI CAN FD Message with ESI flag */
    vuint32_t FLEC:3;                  /* Fast Last Error Code */
    vuint32_t BO:1;
    vuint32_t EW:1;
    vuint32_t EP:1;
    vuint32_t ACT:2;
    vuint32_t LEC:3;
  } B;
} M_TTCAN_PSR_tag;

typedef union M_TTCAN_IR_union_tag {   /* Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t STE:1;
    vuint32_t FOE:1;
    vuint32_t ACKE:1;
    vuint32_t BE:1;
    vuint32_t CRCE:1;
    vuint32_t WDI:1;
    vuint32_t BO:1;
    vuint32_t EW:1;
    vuint32_t EP:1;
    vuint32_t ELO:1;
    vuint32_t BEU:1;
    vuint32_t BEC:1;
    vuint32_t DRX:1;                   /* Message stored to Dedicated Rx Buffer */
    vuint32_t TOO:1;
    vuint32_t UMD:1;
    vuint32_t TSW:1;
    vuint32_t TEFL:1;
    vuint32_t TEFF:1;
    vuint32_t TEFW:1;
    vuint32_t TEFN:1;
    vuint32_t TFE:1;
    vuint32_t TCF:1;
    vuint32_t TC:1;
    vuint32_t HPM:1;
    vuint32_t RF1L:1;
    vuint32_t RF1F:1;
    vuint32_t RF1W:1;
    vuint32_t RF1N:1;
    vuint32_t RF0L:1;
    vuint32_t RF0F:1;
    vuint32_t RF0W:1;
    vuint32_t RF0N:1;
  } B;
} M_TTCAN_IR_tag;

typedef union M_TTCAN_IE_union_tag {   /* Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t STEE:1;
    vuint32_t FOEE:1;
    vuint32_t ACKEE:1;
    vuint32_t BEE:1;
    vuint32_t CRCEE:1;
    vuint32_t WDIE:1;
    vuint32_t BOE:1;
    vuint32_t EWE:1;
    vuint32_t EPE:1;
    vuint32_t ELOE:1;
    vuint32_t BEUE:1;
    vuint32_t BECE:1;
    vuint32_t DRXE:1;                  /* Message stored to Dedicated Rx Buffer Interrupt Enable */
    vuint32_t TOOE:1;
    vuint32_t UMDE:1;
    vuint32_t TSWE:1;
    vuint32_t TEFLE:1;
    vuint32_t TEFFE:1;
    vuint32_t TEFWE:1;
    vuint32_t TEFNE:1;
    vuint32_t TFEE:1;
    vuint32_t TCFE:1;
    vuint32_t TCE:1;
    vuint32_t HPME:1;
    vuint32_t RF1LE:1;
    vuint32_t RF1FE:1;
    vuint32_t RF1WE:1;
    vuint32_t RF1NE:1;
    vuint32_t RF0LE:1;
    vuint32_t RF0FE:1;
    vuint32_t RF0WE:1;
    vuint32_t RF0NE:1;
  } B;
} M_TTCAN_IE_tag;

typedef union M_TTCAN_ILS_union_tag {  /* Interrupt Line Select Register */
  vuint32_t R;
  struct {
    vuint32_t STEL:1;
    vuint32_t FOEL:1;
    vuint32_t ACKEL:1;
    vuint32_t BEL:1;
    vuint32_t CRCEL:1;
    vuint32_t WDIL:1;
    vuint32_t BOL:1;
    vuint32_t EWL:1;
    vuint32_t EPL:1;
    vuint32_t ELOL:1;
    vuint32_t BEUL:1;
    vuint32_t BECL:1;
    vuint32_t DRXL:1;                  /* Message stored to Dedicated Rx Buffer Interrupt Line */
    vuint32_t TOOL:1;
    vuint32_t UMDL:1;
    vuint32_t TSWL:1;
    vuint32_t TEFLL:1;
    vuint32_t TEFFL:1;
    vuint32_t TEFWL:1;
    vuint32_t TEFNL:1;
    vuint32_t TFEL:1;
    vuint32_t TCFL:1;
    vuint32_t TCL:1;
    vuint32_t HPML:1;
    vuint32_t RF1LL:1;
    vuint32_t RF1FL:1;
    vuint32_t RF1WL:1;
    vuint32_t RF1NL:1;
    vuint32_t RF0LL:1;
    vuint32_t RF0FL:1;
    vuint32_t RF0WL:1;
    vuint32_t RF0NL:1;
  } B;
} M_TTCAN_ILS_tag;

typedef union M_TTCAN_ILE_union_tag {  /* Interrupt Line Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :30;
    vuint32_t EINT1:1;
    vuint32_t EINT0:1;
  } B;
} M_TTCAN_ILE_tag;

typedef union M_TTCAN_GFC_union_tag {  /* Global Filter Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t ANFS:2;
    vuint32_t ANFE:2;
    vuint32_t RRFS:1;
    vuint32_t RRFE:1;
  } B;
} M_TTCAN_GFC_tag;

typedef union M_TTCAN_SIDFC_union_tag { /* Standard ID Filter Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t LSS:8;
    vuint32_t FLSSA:14;
    vuint32_t  :2;
  } B;
} M_TTCAN_SIDFC_tag;

typedef union M_TTCAN_XIDFC_union_tag { /* Extended ID Filter Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :9;
    vuint32_t LSE:7;
    vuint32_t FLESA:14;
    vuint32_t  :2;
  } B;
} M_TTCAN_XIDFC_tag;

typedef union M_TTCAN_XIDAM_union_tag { /* Extended ID and Mask Register */
  vuint32_t R;
  struct {
    vuint32_t  :3;
    vuint32_t EIDM:29;
  } B;
} M_TTCAN_XIDAM_tag;

typedef union M_TTCAN_HPMS_union_tag { /* High Priority Message Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t FLST:1;
    vuint32_t FIDX:7;
    vuint32_t MSI:2;
    vuint32_t BIDX:6;
  } B;
} M_TTCAN_HPMS_tag;

typedef union M_TTCAN_NDAT1_union_tag { /* New Data 1 Register */
  vuint32_t R;
  struct {
    vuint32_t ND1:32;                  /* New Data[0:31] */
  } B;
} M_TTCAN_NDAT1_tag;

typedef union M_TTCAN_NDAT2_union_tag { /* New Data 2 Register */
  vuint32_t R;
  struct {
    vuint32_t ND2:32;                  /* New Data[63:32] */
  } B;
} M_TTCAN_NDAT2_tag;

typedef union M_TTCAN_RXF0C_union_tag { /* Rx FIFO 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t F0WM:7;
    vuint32_t  :1;
    vuint32_t F0S:7;
    vuint32_t FOSA:14;
    vuint32_t  :2;
  } B;
} M_TTCAN_RXF0C_tag;

typedef union M_TTCAN_RXF0S_union_tag { /* Rx FIFO 0 Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :6;
    vuint32_t RF0L:1;
    vuint32_t F0F:1;
    vuint32_t  :2;
    vuint32_t F0PI:6;
    vuint32_t  :2;
    vuint32_t F0GI:6;
    vuint32_t  :1;
    vuint32_t F0FL:7;
  } B;
} M_TTCAN_RXF0S_tag;

typedef union M_TTCAN_RXF0A_union_tag { /* Rx FIFO 0 Acknowledge Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t F0AI:6;
  } B;
} M_TTCAN_RXF0A_tag;

typedef union M_TTCAN_RXBC_union_tag { /* Rx Buffer Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t RBSA:14;                 /* Rx Buffer Start Address */
    vuint32_t  :2;
  } B;
} M_TTCAN_RXBC_tag;

typedef union M_TTCAN_RXF1C_union_tag { /* Rx FIFO 1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t F1WM:7;
    vuint32_t  :1;
    vuint32_t F1S:7;
    vuint32_t F1SA:14;
    vuint32_t  :2;
  } B;
} M_TTCAN_RXF1C_tag;

typedef union M_TTCAN_RXF1S_union_tag { /* Rx FIFO 1 Status Register */
  vuint32_t R;
  struct {
    vuint32_t DMS:2;                   /* Debug Message Status */
    vuint32_t  :4;
    vuint32_t RF1L:1;
    vuint32_t F1F:1;
    vuint32_t  :2;
    vuint32_t F1PI:6;
    vuint32_t  :2;
    vuint32_t F1GI:6;
    vuint32_t  :1;
    vuint32_t F1FL:7;
  } B;
} M_TTCAN_RXF1S_tag;

typedef union M_TTCAN_RXF1A_union_tag { /* Rx FIFO 1 Acknowledge register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t F1A1:6;
  } B;
} M_TTCAN_RXF1A_tag;

typedef union M_TTCAN_TXBC_union_tag { /* Tx Buffer Configuration register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t TFQM:1;
    vuint32_t TFQS:6;
    vuint32_t  :2;
    vuint32_t NDTB:6;
    vuint32_t TBSA:14;
    vuint32_t  :2;
  } B;
} M_TTCAN_TXBC_tag;

typedef union M_TTCAN_TXFQS_union_tag { /* Tx FIFO/Queue Status register */
  vuint32_t R;
  struct {
    vuint32_t  :10;
    vuint32_t TFQF:1;
    vuint32_t TFQPI:5;
    vuint32_t  :3;
    vuint32_t TFGI:5;
    vuint32_t  :2;
    vuint32_t TFFL:6;
  } B;
} M_TTCAN_TXFQS_tag;

typedef union M_TTCAN_TXBRP_union_tag { /* Tx Buffer Request Pending register */
  vuint32_t R;
  struct {
    vuint32_t TRP:32;
  } B;
} M_TTCAN_TXBRP_tag;

typedef union M_TTCAN_TXBAR_union_tag { /* Tx Buffer Add Request register */
  vuint32_t R;
  struct {
    vuint32_t AR:32;
  } B;
} M_TTCAN_TXBAR_tag;

typedef union M_TTCAN_TXBCR_union_tag { /* Tx Buffer Cancellation Request register */
  vuint32_t R;
  struct {
    vuint32_t CR:32;
  } B;
} M_TTCAN_TXBCR_tag;

typedef union M_TTCAN_TXBTO_union_tag { /* Tx Buffer Transmission Occurred register */
  vuint32_t R;
  struct {
    vuint32_t TO:32;
  } B;
} M_TTCAN_TXBTO_tag;

typedef union M_TTCAN_TXBCF_union_tag { /* Tx Buffer Cancellation Finished register */
  vuint32_t R;
  struct {
    vuint32_t CF:32;
  } B;
} M_TTCAN_TXBCF_tag;

typedef union M_TTCAN_TXBTIE_union_tag { /* Tx Buffer Transmission Interrupt Enable register */
  vuint32_t R;
  struct {
    vuint32_t TIE:32;
  } B;
} M_TTCAN_TXBTIE_tag;

typedef union M_TTCAN_TXBCIE_union_tag { /* Tx Buffer Cancellation Finished Interrupt Enable register */
  vuint32_t R;
  struct {
    vuint32_t CFIE:32;
  } B;
} M_TTCAN_TXBCIE_tag;

typedef union M_TTCAN_TXEFC_union_tag { /* Tx Event FIFO Configuration register */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t EFWM:6;
    vuint32_t  :2;
    vuint32_t EFS:6;
    vuint32_t EFSA:14;
    vuint32_t  :2;
  } B;
} M_TTCAN_TXEFC_tag;

typedef union M_TTCAN_TXEFS_union_tag { /* Tx Event FIFO Status register */
  vuint32_t R;
  struct {
    vuint32_t  :6;
    vuint32_t TEFL:1;
    vuint32_t EFF:1;
    vuint32_t  :3;
    vuint32_t EFPI:5;
    vuint32_t  :3;
    vuint32_t EFGI:5;
    vuint32_t  :2;
    vuint32_t EFFL:6;
  } B;
} M_TTCAN_TXEFS_tag;

typedef union M_TTCAN_TXEFA_union_tag { /* Tx Event FIFO Acknowledge register */
  vuint32_t R;
  struct {
    vuint32_t  :27;
    vuint32_t EFAI:5;
  } B;
} M_TTCAN_TXEFA_tag;

typedef union M_TTCAN_TTTMC_union_tag { /* TT Trigger Memory Configuration register */
  vuint32_t R;
  struct {
    vuint32_t  :9;
    vuint32_t TME:7;
    vuint32_t TMSA:14;
    vuint32_t  :2;
  } B;
} M_TTCAN_TTTMC_tag;

typedef union M_TTCAN_TTRMC_union_tag { /* TT Reference Message Configuration register */
  vuint32_t R;
  struct {
    vuint32_t RMPS:1;
    vuint32_t XTD:1;
    vuint32_t  :1;
    vuint32_t RID:29;
  } B;
} M_TTCAN_TTRMC_tag;

typedef union M_TTCAN_TTOCF_union_tag { /* TT Operation Configuration register */
  vuint32_t R;
  struct {
    vuint32_t  :5;
    vuint32_t EVTP:1;
    vuint32_t ECC:1;
    vuint32_t EGTF:1;
    vuint32_t AWL:8;
    vuint32_t EECS:1;
    vuint32_t IRTO:7;
    vuint32_t LDSDL:3;
    vuint32_t TM:1;
    vuint32_t GEN:1;
    vuint32_t  :1;
    vuint32_t OM:2;
  } B;
} M_TTCAN_TTOCF_tag;

typedef union M_TTCAN_TTMLM_union_tag { /* TT Matrix Limits register */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t ENTT:12;
    vuint32_t  :4;
    vuint32_t TXEW:4;
    vuint32_t CSS:2;                   /* Cycle Start Synchronization */
    vuint32_t CCM:6;
  } B;
} M_TTCAN_TTMLM_tag;

typedef union M_TTCAN_TURCF_union_tag { /* TUR Configuration register */
  vuint32_t R;
  struct {
    vuint32_t ELT:1;
    vuint32_t  :1;
    vuint32_t DC:14;
    vuint32_t NCL:16;
  } B;
} M_TTCAN_TURCF_tag;

typedef union M_TTCAN_TTOCN_union_tag { /* TT Operation Control register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t LCKC:1;
    vuint32_t  :1;
    vuint32_t ESCN:1;
    vuint32_t NIG:1;
    vuint32_t TMG:1;
    vuint32_t FGP:1;
    vuint32_t GCS:1;
    vuint32_t TTIE:1;                  /* Trigger Time Mark Interrupt Pulse Enable */
    vuint32_t TMC:2;
    vuint32_t RTIE:1;
    vuint32_t SWS:2;
    vuint32_t SWP:1;
    vuint32_t ECS:1;
    vuint32_t SGT:1;
  } B;
} M_TTCAN_TTOCN_tag;

typedef union M_TTCAN_TTGTP_union_tag { /* TT Global Time Preset register */
  vuint32_t R;
  struct {
    vuint32_t CTP:16;
    vuint32_t TP:16;
  } B;
} M_TTCAN_TTGTP_tag;

typedef union M_TTCAN_TTTMK_union_tag { /* TT Time Mark register */
  vuint32_t R;
  struct {
    vuint32_t LCKM:1;
    vuint32_t  :8;
    vuint32_t TICC:7;
    vuint32_t TM:16;
  } B;
} M_TTCAN_TTTMK_tag;

typedef union M_TTCAN_TTIR_union_tag { /* TT Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t  :13;
    vuint32_t CER:1;
    vuint32_t AW:1;
    vuint32_t WT:1;
    vuint32_t IWT:1;
    vuint32_t ELC:1;
    vuint32_t SE2:1;
    vuint32_t SE1:1;
    vuint32_t TXO:1;
    vuint32_t TXU:1;
    vuint32_t GTE:1;
    vuint32_t GTD:1;
    vuint32_t GTW:1;
    vuint32_t SWE:1;
    vuint32_t TTMI:1;
    vuint32_t RTMI:1;
    vuint32_t SOG:1;
    vuint32_t CSM:1;
    vuint32_t SMC:1;
    vuint32_t SBC:1;
  } B;
} M_TTCAN_TTIR_tag;

typedef union M_TTCAN_TTIE_union_tag { /* TT Interrupt Enable register */
  vuint32_t R;
  struct {
    vuint32_t  :13;
    vuint32_t CERE:1;
    vuint32_t AWE:1;
    vuint32_t WTE:1;
    vuint32_t IWTE:1;
    vuint32_t ELCE:1;
    vuint32_t SE2E:1;
    vuint32_t SE1E:1;
    vuint32_t TXOE:1;
    vuint32_t TXUE:1;
    vuint32_t GTEE:1;
    vuint32_t GTDE:1;
    vuint32_t GTWE:1;
    vuint32_t SWEE:1;
    vuint32_t TTMIE:1;
    vuint32_t RTMIE:1;
    vuint32_t SOGE:1;
    vuint32_t CSME:1;
    vuint32_t SMCE:1;
    vuint32_t SBCE:1;
  } B;
} M_TTCAN_TTIE_tag;

typedef union M_TTCAN_TTILS_union_tag { /* TT Interrupt Line Select register */
  vuint32_t R;
  struct {
    vuint32_t  :13;
    vuint32_t CERL:1;
    vuint32_t AWL:1;
    vuint32_t WTL:1;
    vuint32_t IWTL:1;
    vuint32_t ELCL:1;
    vuint32_t SE2L:1;
    vuint32_t SE1L:1;
    vuint32_t TXOL:1;
    vuint32_t TXUL:1;
    vuint32_t GTEL:1;
    vuint32_t GTDL:1;
    vuint32_t GTWE:1;
    vuint32_t SWEL:1;
    vuint32_t TTMIL:1;
    vuint32_t RTMIL:1;
    vuint32_t SOGL:1;
    vuint32_t CSML:1;
    vuint32_t SMCL:1;
    vuint32_t SBCL:1;
  } B;
} M_TTCAN_TTILS_tag;

typedef union M_TTCAN_TTOST_union_tag { /* TT Operation Status register */
  vuint32_t R;
  struct {
    vuint32_t SPL:1;
    vuint32_t WECS:1;
    vuint32_t AWE:1;
    vuint32_t WFE:1;
    vuint32_t GSI:1;
    vuint32_t TMP:3;
    vuint32_t GFI:1;
    vuint32_t WGTD:1;
    vuint32_t  :6;
    vuint32_t RTO:8;
    vuint32_t QCS:1;
    vuint32_t QGTP:1;
    vuint32_t SYS:2;
    vuint32_t MS:2;
    vuint32_t EL:2;
  } B;
} M_TTCAN_TTOST_tag;

typedef union M_TTCAN_TURNA_union_tag { /* TUR Numerator Actual register */
  vuint32_t R;
  struct {
    vuint32_t  :14;
    vuint32_t NAV:18;
  } B;
} M_TTCAN_TURNA_tag;

typedef union M_TTCAN_TTLGT_union_tag { /* TT Local and Global Time register */
  vuint32_t R;
  struct {
    vuint32_t GT:16;
    vuint32_t LT:16;
  } B;
} M_TTCAN_TTLGT_tag;

typedef union M_TTCAN_TTCTC_union_tag { /* TT Cycle Time and Count register */
  vuint32_t R;
  struct {
    vuint32_t  :10;
    vuint32_t CC:6;
    vuint32_t CT:16;
  } B;
} M_TTCAN_TTCTC_tag;

typedef union M_TTCAN_TTCPT_union_tag { /* TT Capture Time register */
  vuint32_t R;
  struct {
    vuint32_t SWV:16;
    vuint32_t  :10;
    vuint32_t CCV:6;
  } B;
} M_TTCAN_TTCPT_tag;

typedef union M_TTCAN_TTCSM_union_tag { /* TT Cycle Sync Mark register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t CSM:16;
  } B;
} M_TTCAN_TTCSM_tag;

struct M_TTCAN_tag {
  M_TTCAN_CREL_tag CREL;               /* Core Release Register */
  M_TTCAN_ENDN_tag ENDN;               /* Endian Register */
  uint8_t M_TTCAN_reserved0[4];
  M_TTCAN_FBTP_tag FBTP;               /* Fast Bit Timing and Prescaler Register */
  M_TTCAN_TEST_tag TEST;               /* Test Register */
  M_TTCAN_RWD_tag RWD;                 /* RAM Watchdog Register */
  M_TTCAN_CCCR_tag CCCR;               /* CC Control Register */
  M_TTCAN_BTP_tag BTP;                 /* Bit Timing and Prescaler Register */
  M_TTCAN_TSCC_tag TSCC;               /* Timestamp Counter Configuration Register */
  M_TTCAN_TSCV_tag TSCV;               /* Timestamp Counter Value Register */
  M_TTCAN_TOCC_tag TOCC;               /* Timeout Counter Configuration Register */
  M_TTCAN_TOCV_tag TOCV;               /* Timeout Counter Value Register */
  uint8_t M_TTCAN_reserved1[16];
  M_TTCAN_ECR_tag ECR;                 /* Error Counter Register */
  M_TTCAN_PSR_tag PSR;                 /* Protocol Status Register */
  uint8_t M_TTCAN_reserved2[8];
  M_TTCAN_IR_tag IR;                   /* Interrupt Register */
  M_TTCAN_IE_tag IE;                   /* Interrupt Enable Register */
  M_TTCAN_ILS_tag ILS;                 /* Interrupt Line Select Register */
  M_TTCAN_ILE_tag ILE;                 /* Interrupt Line Enable Register */
  uint8_t M_TTCAN_reserved3[32];
  M_TTCAN_GFC_tag GFC;                 /* Global Filter Configuration Register */
  M_TTCAN_SIDFC_tag SIDFC;             /* Standard ID Filter Configuration Register */
  M_TTCAN_XIDFC_tag XIDFC;             /* Extended ID Filter Configuration Register */
  uint8_t M_TTCAN_reserved4[4];
  M_TTCAN_XIDAM_tag XIDAM;             /* Extended ID and Mask Register */
  M_TTCAN_HPMS_tag HPMS;               /* High Priority Message Status Register */
  M_TTCAN_NDAT1_tag NDAT1;             /* New Data 1 Register */
  M_TTCAN_NDAT2_tag NDAT2;             /* New Data 2 Register */
  M_TTCAN_RXF0C_tag RXF0C;             /* Rx FIFO 0 Configuration Register */
  M_TTCAN_RXF0S_tag RXF0S;             /* Rx FIFO 0 Status Register */
  M_TTCAN_RXF0A_tag RXF0A;             /* Rx FIFO 0 Acknowledge Register */
  M_TTCAN_RXBC_tag RXBC;               /* Rx Buffer Configuration Register */
  M_TTCAN_RXF1C_tag RXF1C;             /* Rx FIFO 1 Configuration Register */
  M_TTCAN_RXF1S_tag RXF1S;             /* Rx FIFO 1 Status Register */
  M_TTCAN_RXF1A_tag RXF1A;             /* Rx FIFO 1 Acknowledge register */
  uint8_t M_TTCAN_reserved5[4];
  M_TTCAN_TXBC_tag TXBC;               /* Tx Buffer Configuration register */
  M_TTCAN_TXFQS_tag TXFQS;             /* Tx FIFO/Queue Status register */
  uint8_t M_TTCAN_reserved6[4];
  M_TTCAN_TXBRP_tag TXBRP;             /* Tx Buffer Request Pending register */
  M_TTCAN_TXBAR_tag TXBAR;             /* Tx Buffer Add Request register */
  M_TTCAN_TXBCR_tag TXBCR;             /* Tx Buffer Cancellation Request register */
  M_TTCAN_TXBTO_tag TXBTO;             /* Tx Buffer Transmission Occurred register */
  M_TTCAN_TXBCF_tag TXBCF;             /* Tx Buffer Cancellation Finished register */
  M_TTCAN_TXBTIE_tag TXBTIE;           /* Tx Buffer Transmission Interrupt Enable register */
  M_TTCAN_TXBCIE_tag TXBCIE;           /* Tx Buffer Cancellation Finished Interrupt Enable register */
  uint8_t M_TTCAN_reserved7[8];
  M_TTCAN_TXEFC_tag TXEFC;             /* Tx Event FIFO Configuration register */
  M_TTCAN_TXEFS_tag TXEFS;             /* Tx Event FIFO Status register */
  M_TTCAN_TXEFA_tag TXEFA;             /* Tx Event FIFO Acknowledge register */
  uint8_t M_TTCAN_reserved8[4];
  M_TTCAN_TTTMC_tag TTTMC;             /* TT Trigger Memory Configuration register */
  M_TTCAN_TTRMC_tag TTRMC;             /* TT Reference Message Configuration register */
  M_TTCAN_TTOCF_tag TTOCF;             /* TT Operation Configuration register */
  M_TTCAN_TTMLM_tag TTMLM;             /* TT Matrix Limits register */
  M_TTCAN_TURCF_tag TURCF;             /* TUR Configuration register */
  M_TTCAN_TTOCN_tag TTOCN;             /* TT Operation Control register */
  M_TTCAN_TTGTP_tag TTGTP;             /* TT Global Time Preset register */
  M_TTCAN_TTTMK_tag TTTMK;             /* TT Time Mark register */
  M_TTCAN_TTIR_tag TTIR;               /* TT Interrupt Register */
  M_TTCAN_TTIE_tag TTIE;               /* TT Interrupt Enable register */
  M_TTCAN_TTILS_tag TTILS;             /* TT Interrupt Line Select register */
  M_TTCAN_TTOST_tag TTOST;             /* TT Operation Status register */
  M_TTCAN_TURNA_tag TURNA;             /* TUR Numerator Actual register */
  M_TTCAN_TTLGT_tag TTLGT;             /* TT Local and Global Time register */
  M_TTCAN_TTCTC_tag TTCTC;             /* TT Cycle Time and Count register */
  M_TTCAN_TTCPT_tag TTCPT;             /* TT Capture Time register */
  M_TTCAN_TTCSM_tag TTCSM;             /* TT Cycle Sync Mark register */
};


/* ============================================================================
   =============================== Module: PASS ===============================
   ============================================================================ */

typedef union PASS_LCSTAT_union_tag {  /* Life Cycle Status Register */
  vuint32_t R;
  struct {
    vuint32_t CNS:1;
    vuint32_t JUN:1;
    vuint32_t  :1;
    vuint32_t  :21;
    vuint32_t LIFE:8;
  } B;
} PASS_LCSTAT_tag;

typedef union PASS_CHSEL_union_tag {   /* Challenge Selector Register */
  vuint32_t R;
  struct {
    vuint32_t  :29;
    vuint32_t GRP:3;
  } B;
} PASS_CHSEL_tag;

typedef union PASS_CSTAT_union_tag {   /* Challenge Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :28;
    vuint32_t CMST:4;
  } B;
} PASS_CSTAT_tag;

typedef union PASS_CIN_union_tag {     /* Challenge Input Register */
  vuint32_t R;
  struct {
    vuint32_t PW32:32;
  } B;
} PASS_CIN_tag;

typedef union PASS_CJE_union_tag {     /* Clock Jitter Enable */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t CJE:1;
  } B;
} PASS_CJE_tag;

typedef union PASS_PG_LOCK0_union_tag { /* Password Group n - Lock 0 Status Register */
  vuint32_t R;
  struct {
    vuint32_t TSLOCK:1;
    vuint32_t ATSL:1;
    vuint32_t LOWLOCK:14;
    vuint32_t MIDLOCK:16;
  } B;
} PASS_PG_LOCK0_tag;

typedef union PASS_PG_LOCK1_union_tag { /* Password Group n - Lock 1 Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t HIGHLOCK:16;
  } B;
} PASS_PG_LOCK1_tag;

typedef union PASS_PG_LOCK2_union_tag { /* Password Group n - Lock 2 Status Register */
  vuint32_t R;
  struct {
    vuint32_t L_256LCK:32;
  } B;
} PASS_PG_LOCK2_tag;

typedef union PASS_PG_LOCK3_union_tag { /* Password Group n - Lock 3 Status Register */
  vuint32_t R;
  struct {
    vuint32_t PGL:1;
    vuint32_t DBL:1;
    vuint32_t MO:1;
    vuint32_t  :1;
    vuint32_t MSTR:4;
    vuint32_t  :3;
    vuint32_t RL4:1;
    vuint32_t RL3:1;
    vuint32_t RL2:1;
    vuint32_t RL1:1;
    vuint32_t RL0:1;
    vuint32_t U_256LCK:16;
  } B;
} PASS_PG_LOCK3_tag;

typedef struct PASS_PG_struct_tag {
  PASS_PG_LOCK0_tag LOCK0;             /* Password Group n - Lock 0 Status Register */
  PASS_PG_LOCK1_tag LOCK1;             /* Password Group n - Lock 1 Status Register */
  PASS_PG_LOCK2_tag LOCK2;             /* Password Group n - Lock 2 Status Register */
  PASS_PG_LOCK3_tag LOCK3;             /* Password Group n - Lock 3 Status Register */
} PASS_PG_tag;

struct PASS_tag {
  PASS_LCSTAT_tag LCSTAT;              /* Life Cycle Status Register */
  uint8_t PASS_reserved0[4];
  PASS_CHSEL_tag CHSEL;                /* Challenge Selector Register */
  uint8_t PASS_reserved1[4];
  PASS_CSTAT_tag CSTAT;                /* Challenge Status Register */
  uint8_t PASS_reserved2[12];
  PASS_CIN_tag CIN[8];                 /* Challenge Input Register */
  uint8_t PASS_reserved3[144];
  PASS_CJE_tag CJE;                    /* Clock Jitter Enable */
  uint8_t PASS_reserved4[44];
  PASS_PG_tag PG[4];
};


/* ============================================================================
   =============================== Module: PBRIDGE ============================
   ============================================================================ */

typedef union PBRIDGE_MPRA_union_tag { /* Master Privilege Register A */
  vuint32_t R;
  struct {
    vuint32_t MPROT0:4;
    vuint32_t MPROT1:4;
    vuint32_t MPROT2:4;
    vuint32_t MPROT3:4;
    vuint32_t MPROT4:4;
    vuint32_t MPROT5:4;
    vuint32_t MPROT6:4;
    vuint32_t MPROT7:4;
  } B;
} PBRIDGE_MPRA_tag;

typedef union PBRIDGE_MPRB_union_tag { /* Master Privilege Register B */
  vuint32_t R;
  struct {
    vuint32_t MPROT8:4;
    vuint32_t MPROT9:4;
    vuint32_t MPROT10:4;
    vuint32_t MPROT11:4;
    vuint32_t MPROT12:4;
    vuint32_t MPROT13:4;
    vuint32_t MPROT14:4;
    vuint32_t MPROT15:4;
  } B;
} PBRIDGE_MPRB_tag;

typedef union PBRIDGE_PACR_union_tag { /* Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t PACRa:4;
    vuint32_t PACRb:4;
    vuint32_t PACRc:4;
    vuint32_t PACRd:4;
    vuint32_t PACRe:4;
    vuint32_t PACRf:4;
    vuint32_t PACRg:4;
    vuint32_t PACRh:4;
  } B;
} PBRIDGE_PACR_tag;

typedef union PBRIDGE_OPACR_union_tag { /* Off-platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t OPACRa:4;
    vuint32_t OPACRb:4;
    vuint32_t OPACRc:4;
    vuint32_t OPACRd:4;
    vuint32_t OPACRe:4;
    vuint32_t OPACRf:4;
    vuint32_t OPACRg:4;
    vuint32_t OPACRh:4;
  } B;
} PBRIDGE_OPACR_tag;

struct PBRIDGE_tag {
  PBRIDGE_MPRA_tag MPRA;               /* Master Privilege Register A */
  PBRIDGE_MPRB_tag MPRB;               /* Master Privilege Register B */
  uint8_t PBRIDGE_reserved0[248];
  PBRIDGE_PACR_tag PACR[8];            /* Peripheral Access Control Register */
  uint8_t PBRIDGE_reserved1[32];
  PBRIDGE_OPACR_tag OPACR[32];         /* Off-platform Peripheral Access Control Register */
};


/* ============================================================================
   =============================== Module: PCM ================================
   ============================================================================ */

typedef union PCM_FBOMCR_union_tag {   /* FEC Burst Optimization Master Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t ACCERR:1;
    vuint32_t WBEN:1;
    vuint32_t RBEN:1;
    vuint32_t FXSBE:8;
  } B;
} PCM_FBOMCR_tag;

typedef union PCM_IAHB_BE1_union_tag { /* IAHB Burst Enable 1 Register */
  vuint32_t R;
  struct {
    vuint32_t  :5;
    vuint32_t RSV:3;
    vuint32_t  :5;
    vuint32_t PRE_DMA:1;
    vuint32_t BRE_DMA:1;
    vuint32_t BWE_DMA:1;
    vuint32_t  :5;
    vuint32_t PRE_S0:1;
    vuint32_t BRE_S0:1;
    vuint32_t BWE_S0:1;
    vuint32_t  :5;
    vuint32_t PRE_M3:1;
    vuint32_t BRE_M3:1;
    vuint32_t BWE_M3:1;
  } B;
} PCM_IAHB_BE1_tag;

typedef union PCM_IAHB_BE2_union_tag { /* IAHB Burst Enable 2 Register */
  vuint32_t R;
  struct {
    vuint32_t  :5;
    vuint32_t RSV:3;
    vuint32_t  :5;
    vuint32_t PRE_SIPI:1;
    vuint32_t BRE_SIPI:1;
    vuint32_t BWE_SIPI:1;
    vuint32_t  :5;
    vuint32_t PRE_FlexRay:1;
    vuint32_t BRE_FlexRay:1;
    vuint32_t BWE_FlexRay:1;
    vuint32_t  :5;
    vuint32_t PRE_FEC:1;
    vuint32_t BRE_FEC:1;
    vuint32_t BWE_FEC:1;
  } B;
} PCM_IAHB_BE2_tag;

struct PCM_tag {
  PCM_FBOMCR_tag FBOMCR;               /* FEC Burst Optimization Master Control Register */
  PCM_IAHB_BE1_tag IAHB_BE1;           /* IAHB Burst Enable 1 Register */
  PCM_IAHB_BE2_tag IAHB_BE2;           /* IAHB Burst Enable 2 Register */
};


/* ============================================================================
   =============================== Module: PFLASH =============================
   ============================================================================ */

typedef union PFLASH_PFCR1_union_tag { /* Platform Flash Configuration Register 1 */
  vuint32_t R;
  struct {
    vuint32_t P0_M15PFE:1;
    vuint32_t P0_M14PFE:1;
    vuint32_t P0_M13PFE:1;
    vuint32_t P0_M12PFE:1;
    vuint32_t P0_M11PFE:1;
    vuint32_t P0_M10PFE:1;
    vuint32_t P0_M9PFE:1;
    vuint32_t P0_M8PFE:1;
    vuint32_t P0_M7PFE:1;
    vuint32_t P0_M6PFE:1;
    vuint32_t P0_M5PFE:1;
    vuint32_t P0_M4PFE:1;
    vuint32_t P0_M3PFE:1;
    vuint32_t P0_M2PFE:1;
    vuint32_t P0_M1PFE:1;
    vuint32_t P0_M0PFE:1;
    vuint32_t APC:3;
    vuint32_t RWSC:5;
    vuint32_t  :1;
    vuint32_t P0_DPFEN:1;
    vuint32_t  :1;
    vuint32_t P0_IPFEN:1;
    vuint32_t  :1;
    vuint32_t P0_PFLIM:2;
    vuint32_t P0_BFEN:1;
  } B;
} PFLASH_PFCR1_tag;

typedef union PFLASH_PFCR2_union_tag { /* Platform Flash Configuration Register 2 */
  vuint32_t R;
  struct {
    vuint32_t P1_M15PFE:1;
    vuint32_t P1_M14PFE:1;
    vuint32_t P1_M13PFE:1;
    vuint32_t P1_M12PFE:1;
    vuint32_t P1_M11PFE:1;
    vuint32_t P1_M10PFE:1;
    vuint32_t P1_M9PFE:1;
    vuint32_t P1_M8PFE:1;
    vuint32_t P1_M7PFE:1;
    vuint32_t P1_M6PFE:1;
    vuint32_t P1_M5PFE:1;
    vuint32_t P1_M4PFE:1;
    vuint32_t P1_M3PFE:1;
    vuint32_t P1_M2PFE:1;
    vuint32_t P1_M1PFE:1;
    vuint32_t P1_M0PFE:1;
    vuint32_t  :9;
    vuint32_t P1_DPFEN:1;
    vuint32_t  :1;
    vuint32_t P1_IPFEN:1;
    vuint32_t  :1;
    vuint32_t P1_PFLIM:2;
    vuint32_t P1_BFEN:1;
  } B;
} PFLASH_PFCR2_tag;

typedef union PFLASH_PFCR3_union_tag { /* Platform Flash Configuration Register 3 */
  vuint32_t R;
  struct {
    vuint32_t P0_WCFG:2;
    vuint32_t P1_WCFG:2;
    vuint32_t  :2;
    vuint32_t  :5;
    vuint32_t BDRM:1;
    vuint32_t  :3;
    vuint32_t BAF_DIS:1;
    vuint32_t ARBM:2;
    vuint32_t  :2;
    vuint32_t  :11;
    vuint32_t  :1;
  } B;
} PFLASH_PFCR3_tag;

typedef union PFLASH_PFAPR_union_tag { /* Platform Flash Access Protection Register */
  vuint32_t R;
  struct {
    vuint32_t M0AP:2;
    vuint32_t M1AP:2;
    vuint32_t M2AP:2;
    vuint32_t M3AP:2;
    vuint32_t M4AP:2;
    vuint32_t M5AP:2;
    vuint32_t M6AP:2;
    vuint32_t M7AP:2;
    vuint32_t M8AP:2;
    vuint32_t M9AP:2;
    vuint32_t M10AP:2;
    vuint32_t M11AP:2;
    vuint32_t M12AP:2;
    vuint32_t M13AP:2;
    vuint32_t M14AP:2;
    vuint32_t M15AP:2;
  } B;
} PFLASH_PFAPR_tag;

typedef union PFLASH_PFCRCR_union_tag { /* Platform Flash Remap Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :23;
    vuint32_t SAFE_CAL:1;
    vuint32_t  :3;
    vuint32_t IRMEN:1;
    vuint32_t  :3;
    vuint32_t GRMEN:1;
  } B;
} PFLASH_PFCRCR_tag;

typedef union PFLASH_PFCRDE_union_tag { /* Platform Flash Remap Descriptor Enable Register */
  vuint32_t R;
  struct {
    vuint32_t CRD0EN:1;
    vuint32_t CRD1EN:1;
    vuint32_t CRD2EN:1;
    vuint32_t CRD3EN:1;
    vuint32_t CRD4EN:1;
    vuint32_t CRD5EN:1;
    vuint32_t CRD6EN:1;
    vuint32_t CRD7EN:1;
    vuint32_t CRD8EN:1;
    vuint32_t CRD9EN:1;
    vuint32_t CRD10EN:1;
    vuint32_t CRD11EN:1;
    vuint32_t CRD12EN:1;
    vuint32_t CRD13EN:1;
    vuint32_t CRD14EN:1;
    vuint32_t CRD15EN:1;
    vuint32_t CRD16EN:1;
    vuint32_t CRD17EN:1;
    vuint32_t CRD18EN:1;
    vuint32_t CRD19EN:1;
    vuint32_t CRD20EN:1;
    vuint32_t CRD21EN:1;
    vuint32_t CRD22EN:1;
    vuint32_t CRD23EN:1;
    vuint32_t CRD24EN:1;
    vuint32_t CRD25EN:1;
    vuint32_t CRD26EN:1;
    vuint32_t CRD27EN:1;
    vuint32_t CRD28EN:1;
    vuint32_t CRD29EN:1;
    vuint32_t CRD30EN:1;
    vuint32_t CRD31EN:1;
  } B;
} PFLASH_PFCRDE_tag;

typedef union PFLASH_PFCRD_Word0_union_tag { /* Platform Flash Calibration Region Descriptor n Word0 */
  vuint32_t R;
  struct {
    vuint32_t LSTARTADDR:28;
    vuint32_t  :4;
  } B;
} PFLASH_PFCRD_Word0_tag;

typedef union PFLASH_PFCRD_Word1_union_tag { /* Platform Flash Calibration Region Descriptor n Word1 */
  vuint32_t R;
  struct {
    vuint32_t PSTARTADDR:28;
    vuint32_t  :4;
  } B;
} PFLASH_PFCRD_Word1_tag;

typedef union PFLASH_PFCRD_Word2_union_tag { /* Platform Flash Calibration Region Descriptor n Word2 */
  vuint32_t R;
  struct {
    vuint32_t M0EN:1;
    vuint32_t M1EN:1;
    vuint32_t M2EN:1;
    vuint32_t M3EN:1;
    vuint32_t M4EN:1;
    vuint32_t M5EN:1;
    vuint32_t M6EN:1;
    vuint32_t M7EN:1;
    vuint32_t M8EN:1;
    vuint32_t M9EN:1;
    vuint32_t M10EN:1;
    vuint32_t M11EN:1;
    vuint32_t M12EN:1;
    vuint32_t M13EN:1;
    vuint32_t M14EN:1;
    vuint32_t M15EN:1;
    vuint32_t  :11;
    vuint32_t CRDSize:5;
  } B;
} PFLASH_PFCRD_Word2_tag;

typedef struct PFLASH_PFCRD_struct_tag {
  PFLASH_PFCRD_Word0_tag Word0;        /* Platform Flash Calibration Region Descriptor n Word0 */
  PFLASH_PFCRD_Word1_tag Word1;        /* Platform Flash Calibration Region Descriptor n Word1 */
  PFLASH_PFCRD_Word2_tag Word2;        /* Platform Flash Calibration Region Descriptor n Word2 */
  uint8_t PFCRD_reserved0[4];
} PFLASH_PFCRD_tag;

struct PFLASH_tag {
  PFLASH_PFCR1_tag PFCR1;              /* Platform Flash Configuration Register 1 */
  PFLASH_PFCR2_tag PFCR2;              /* Platform Flash Configuration Register 2 */
  PFLASH_PFCR3_tag PFCR3;              /* Platform Flash Configuration Register 3 */
  PFLASH_PFAPR_tag PFAPR;              /* Platform Flash Access Protection Register */
  PFLASH_PFCRCR_tag PFCRCR;            /* Platform Flash Remap Control Register */
  PFLASH_PFCRDE_tag PFCRDE;            /* Platform Flash Remap Descriptor Enable Register */
  uint8_t PFLASH_reserved0[232];
  PFLASH_PFCRD_tag PFCRD[32];
};


/* ============================================================================
   =============================== Module: PIT ================================
   ============================================================================ */

typedef union PIT_MCR_union_tag {      /* PIT Module Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :29;
    vuint32_t MDIS_RTI:1;
    vuint32_t MDIS:1;
    vuint32_t FRZ:1;
  } B;
} PIT_MCR_tag;

typedef union PIT_LTMR64H_union_tag {  /* PIT Upper Lifetime Timer Register */
  vuint32_t R;
  struct {
    vuint32_t LTH:32;
  } B;
} PIT_LTMR64H_tag;

typedef union PIT_LTMR64L_union_tag {  /* PIT Lower Lifetime Timer Register */
  vuint32_t R;
  struct {
    vuint32_t LTL:32;
  } B;
} PIT_LTMR64L_tag;

typedef union PIT_RTI_LDVAL_union_tag { /* PIT RTI Timer Load Value Register */
  vuint32_t R;
  struct {
    vuint32_t TSV:32;
  } B;
} PIT_RTI_LDVAL_tag;

typedef union PIT_RTI_CVAL_union_tag { /* PIT RTI Current Timer Value Register */
  vuint32_t R;
  struct {
    vuint32_t TVL:32;
  } B;
} PIT_RTI_CVAL_tag;

typedef union PIT_RTI_TCTRL_union_tag { /* PIT RTI Timer Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :29;
    vuint32_t CHN:1;
    vuint32_t TIE:1;
    vuint32_t TEN:1;
  } B;
} PIT_RTI_TCTRL_tag;

typedef union PIT_RTI_TFLG_union_tag { /* PIT RTI Timer Flag Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t TIF:1;
  } B;
} PIT_RTI_TFLG_tag;

typedef union PIT_TIMER_LDVAL_union_tag { /* PIT Timer Load Value Register n */
  vuint32_t R;
  struct {
    vuint32_t TSV:32;
  } B;
} PIT_TIMER_LDVAL_tag;

typedef union PIT_TIMER_CVAL_union_tag { /* PIT Current Timer Value Register n */
  vuint32_t R;
  struct {
    vuint32_t TVL:32;
  } B;
} PIT_TIMER_CVAL_tag;

typedef union PIT_TIMER_TCTRL_union_tag { /* PIT Timer Control Register n */
  vuint32_t R;
  struct {
    vuint32_t  :29;
    vuint32_t CHN:1;
    vuint32_t TIE:1;
    vuint32_t TEN:1;
  } B;
} PIT_TIMER_TCTRL_tag;

typedef union PIT_TIMER_TFLG_union_tag { /* PIT Timer Flag Register n */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t TIF:1;
  } B;
} PIT_TIMER_TFLG_tag;

typedef struct PIT_TIMER_struct_tag {
  PIT_TIMER_LDVAL_tag LDVAL;           /* PIT Timer Load Value Register n */
  PIT_TIMER_CVAL_tag CVAL;             /* PIT Current Timer Value Register n */
  PIT_TIMER_TCTRL_tag TCTRL;           /* PIT Timer Control Register n */
  PIT_TIMER_TFLG_tag TFLG;             /* PIT Timer Flag Register n */
} PIT_TIMER_tag;

struct PIT_tag {
  PIT_MCR_tag MCR;                     /* PIT Module Control Register */
  uint8_t PIT_reserved0[220];
  PIT_LTMR64H_tag LTMR64H;             /* PIT Upper Lifetime Timer Register */
  PIT_LTMR64L_tag LTMR64L;             /* PIT Lower Lifetime Timer Register */
  uint8_t PIT_reserved1[8];
  PIT_RTI_LDVAL_tag RTI_LDVAL;         /* PIT RTI Timer Load Value Register */
  PIT_RTI_CVAL_tag RTI_CVAL;           /* PIT RTI Current Timer Value Register */
  PIT_RTI_TCTRL_tag RTI_TCTRL;         /* PIT RTI Timer Control Register */
  PIT_RTI_TFLG_tag RTI_TFLG;           /* PIT RTI Timer Flag Register */
  PIT_TIMER_tag TIMER[8];
};


/* ============================================================================
   =============================== Module: PLLDIG =============================
   ============================================================================ */

typedef union PLLDIG_PLL0CR_union_tag { /* PLLDIG PLL0 Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t  :1;
    vuint32_t CLKCFG:2;                /* Clock Configuration */
    vuint32_t EXPDIE:1;                /* External Power Down Cycle Complete indication interrupt enable. */
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t LOLIE:1;                 /* Loss-of-lock interrupt enable. */
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t  :1;
  } B;
} PLLDIG_PLL0CR_tag;

typedef union PLLDIG_PLL0SR_union_tag { /* PLLDIG PLL0 Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t EXTPDF:1;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t LOLF:1;                  /* Loss-of-lock flag. */
    vuint32_t LOCK:1;
    vuint32_t  :1;
    vuint32_t  :1;
  } B;
} PLLDIG_PLL0SR_tag;

typedef union PLLDIG_PLL0DV_union_tag { /* PLLDIG PLL0 Divider Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t RFDPHI1:4;               /* PHI1 reduced frequency divider. */
    vuint32_t  :5;
    vuint32_t RFDPHI:6;                /* PHI reduced frequency divider. */
    vuint32_t  :1;
    vuint32_t PREDIV:3;                /* Input clock predivider. */
    vuint32_t  :5;
    vuint32_t MFD:7;                   /* Loop multiplication factor divider. */
  } B;
} PLLDIG_PLL0DV_tag;

typedef union PLLDIG_PLL1CR_union_tag { /* PLLDIG PLL1 Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t  :1;
    vuint32_t CLKCFG:2;                /* Clock Configuration */
    vuint32_t EXPDIE:1;                /* External Power Down Cycle Complete indication interrupt enable. */
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t LOLIE:1;                 /* Loss-of-lock interrupt enable. */
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t  :1;
  } B;
} PLLDIG_PLL1CR_tag;

typedef union PLLDIG_PLL1SR_union_tag { /* PLLDIG PLL1 Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t EXTPDF:1;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t LOLF:1;                  /* Loss-of-lock flag. */
    vuint32_t LOCK:1;
    vuint32_t  :1;
    vuint32_t  :1;
  } B;
} PLLDIG_PLL1SR_tag;

typedef union PLLDIG_PLL1DV_union_tag { /* PLLDIG PLL1 Divider Register */
  vuint32_t R;
  struct {
    vuint32_t  :10;
    vuint32_t RFDPHI:6;                /* PHI reduced frequency divider. */
    vuint32_t  :5;
    vuint32_t  :4;
    vuint32_t MFD:7;                   /* Loop multiplication factor divider. */
  } B;
} PLLDIG_PLL1DV_tag;

typedef union PLLDIG_PLL1FM_union_tag { /* PLLDIG PLL1 Frequency Modulation Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MODEN:1;                 /* Modulation enable. */
    vuint32_t MODSEL:1;                /* Modulation selection. */
    vuint32_t MODPRD:13;               /* Modulation period. */
    vuint32_t  :1;
    vuint32_t INCSTP:15;               /* Increment step. */
  } B;
} PLLDIG_PLL1FM_tag;

typedef union PLLDIG_PLL1FD_union_tag { /* PLLDIG PLL1 Fractional Divide Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t FDEN:1;                  /* Fractional Divide Enable */
    vuint32_t  :12;
    vuint32_t DTHDIS:2;                /* Dither Disable. */
    vuint32_t  :4;
    vuint32_t FRCDIV:12;
  } B;
} PLLDIG_PLL1FD_tag;

struct PLLDIG_tag {
  PLLDIG_PLL0CR_tag PLL0CR;            /* PLLDIG PLL0 Control Register */
  PLLDIG_PLL0SR_tag PLL0SR;            /* PLLDIG PLL0 Status Register */
  PLLDIG_PLL0DV_tag PLL0DV;            /* PLLDIG PLL0 Divider Register */
  uint8_t PLLDIG_reserved0[20];
  PLLDIG_PLL1CR_tag PLL1CR;            /* PLLDIG PLL1 Control Register */
  PLLDIG_PLL1SR_tag PLL1SR;            /* PLLDIG PLL1 Status Register */
  PLLDIG_PLL1DV_tag PLL1DV;            /* PLLDIG PLL1 Divider Register */
  PLLDIG_PLL1FM_tag PLL1FM;            /* PLLDIG PLL1 Frequency Modulation Register */
  PLLDIG_PLL1FD_tag PLL1FD;            /* PLLDIG PLL1 Fractional Divide Register */
};


/* ============================================================================
   =============================== Module: PMCDIG =============================
   ============================================================================ */

typedef union PMCDIG_GR_S_union_tag {  /* Supply Gauge Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :5;                     /* Reserved. */
    vuint32_t TS3:1;                   /* TS3 over temperature detect flag. */
    vuint32_t TS2:1;                   /* TS2 over temperature detect flag. */
    vuint32_t TS0:1;                   /* TS0 under temperature detect flag. */
    vuint32_t  :8;
    vuint32_t VD15:1;                  /* VD15 high-voltage detect flag. */
    vuint32_t VD14:1;                  /* VD14 low-voltage detect flag. */
    vuint32_t VD13:1;                  /* VD13 low-voltage detect flag. */
    vuint32_t VD12:1;                  /* VD12 high-voltage detect flag. */
    vuint32_t  :1;
    vuint32_t VD10:1;                  /* HVD occurrence detected on the high voltage 3.60 V supply. */
    vuint32_t VD9:1;                   /* VD9 low-voltage detect flag. */
    vuint32_t VD8:1;                   /* VD8 high-voltage detect flag. */
    vuint32_t VD7:1;                   /* VD7 high-voltage detect flag. */
    vuint32_t  :2;
    vuint32_t VD4:1;                   /* VD4 low-voltage detect flag. */
    vuint32_t VD3:1;                   /* VD3 low-voltage detect flag. */
    vuint32_t  :3;                     /* Reserved */
  } B;
} PMCDIG_GR_S_tag;

typedef union PMCDIG_GR_P_union_tag {  /* Pending Gauge Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :6;
    vuint32_t VD15_A:1;                /* VD15_A high-voltage detect flag. */
    vuint32_t VD15_C:1;                /* VD15_C high-voltage detect flag. */
    vuint32_t  :1;
    vuint32_t VD14_A:1;                /* VD14_A low-voltage detect flag. */
    vuint32_t VD14_IM:1;               /* VD14_IM low-voltage detect flag. */
    vuint32_t  :2;
    vuint32_t VD13_IM:1;               /* VD13_IM low-voltage detect flag. */
    vuint32_t VD12_F:1;                /* VD12_F high-voltage detect flag. */
    vuint32_t VD10_A:1;                /* VD10_A low-voltage detect flag. */
    vuint32_t VD10_F:1;                /* VD10_F low-voltage detect flag. */
    vuint32_t VD9_O:1;                 /* VD9_O low-voltage detect flag. */
    vuint32_t VD9_IF2:1;               /* VD9_IF2 low-voltage detect flag. */
    vuint32_t VD9_IF:1;                /* VD9_IF low-voltage detect flag. */
    vuint32_t VD9_IJ:1;                /* VD9_IJ low-voltage detect flag. */
    vuint32_t VD9_IM:1;                /* VD9_IM low-voltage detect flag. */
    vuint32_t VD9_F:1;                 /* VD9_F low-voltage detect flag. */
    vuint32_t VD9_EBI:1;               /* VD9_EBI low-voltage detect flag. */
    vuint32_t VD9_C:1;                 /* VD9_C low-voltage detect flag. */
    vuint32_t VD8_C:1;                 /* VD8_C high-voltage detect flag. */
    vuint32_t VD8_F:1;                 /* VD8_F high-voltage detect flag. */
    vuint32_t VD7_C:1;                 /* VD7_C high-voltage detect flag. */
    vuint32_t VD4_C:1;                 /* VD4_C low-voltage detect flag. */
    vuint32_t VD3_P:1;                 /* VD3_P low-voltage detect flag. */
    vuint32_t VD3_F:1;                 /* VD3_F low-voltage detect flag. */
    vuint32_t VD3_C:1;                 /* VD3_C low-voltage detect flag. */
  } B;
} PMCDIG_GR_P_tag;

typedef union PMCDIG_IE_P_union_tag {  /* Interrupt Enable Pending Register */
  vuint32_t R;
  struct {
    vuint32_t IE_EN:1;
    vuint32_t  :5;
    vuint32_t VD15IE_A:1;              /* VD15IE_A Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
    vuint32_t VD15IE_C:1;              /* VD15IE_C Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
    vuint32_t  :1;
    vuint32_t VD14IE_A:1;              /* VD14IE_A Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
    vuint32_t VD14IE_IM:1;             /* VD14IE_IM Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
    vuint32_t  :2;
    vuint32_t VD13IE_IM:1;             /* VD13IE_IM Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
    vuint32_t VD12IE_F:1;              /* VD12IE_F Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
    vuint32_t VD10IE_A:1;              /* VD10IE_F Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
    vuint32_t VD10IE_F:1;              /* VD10IE_A Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
    vuint32_t VD9IE_O:1;               /* VD9IE_O Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
    vuint32_t VD9IE_IF2:1;             /* VD9IE_IF2 Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
    vuint32_t VD9IE_IF:1;              /* VD9IE_IF Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
    vuint32_t VD9IE_IJ:1;              /* VD9IE_IJ Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
    vuint32_t VD9IE_IM:1;              /* VD9IE_IM Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
    vuint32_t VD9IE_F:1;               /* VD9IE_F Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
    vuint32_t VD9IE_EBI:1;             /* VD9IE_EBI Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
    vuint32_t VD9IE_C:1;               /* VD9IE_C Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
    vuint32_t VD8IE_C:1;               /* VD8IE_C Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
    vuint32_t VD8IE_F:1;               /* VD8IE_F Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
    vuint32_t VD7IE_C:1;               /* VD7IE_C Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
    vuint32_t VD4IE_C:1;               /* VD4IE_C Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
    vuint32_t VD3IE_P:1;               /* VD3IE_P Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
    vuint32_t VD3IE_F:1;               /* VD3IE_F Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
    vuint32_t VD3IE_C:1;               /* VD3IE_C Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
  } B;
} PMCDIG_IE_P_tag;

typedef union PMCDIG_EPR_VD3_union_tag { /* Event Pending Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t LVD3_P:1;                /* LVD3_P flag. */
    vuint32_t LVD3_F:1;                /* LVD3_F flag. */
    vuint32_t  :5;
    vuint32_t LVD3_C:1;                /* LVD3_C flag. */
  } B;
} PMCDIG_EPR_VD3_tag;

typedef union PMCDIG_REE_VD3_union_tag { /* Reset Event Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t LVD3_P:1;                /* LVD3_P reset enable. */
    vuint32_t LVD3_F:1;                /* LVD3_F reset enable. */
    vuint32_t  :5;
    vuint32_t LVD3_C:1;                /* LVD3_C reset enable. */
  } B;
} PMCDIG_REE_VD3_tag;

typedef union PMCDIG_RES_VD3_union_tag { /* Reset Event Select Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t LVD3_P:1;                /* LVD3_P reset event select. */
    vuint32_t LVD3_F:1;                /* LVD3_F reset event select. */
    vuint32_t  :5;
    vuint32_t LVD3_C:1;                /* LVD3_C reset event select. */
  } B;
} PMCDIG_RES_VD3_tag;

typedef union PMCDIG_FEE_VD3_union_tag { /* FCCU Event Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t FEE3_P:1;                /* FEE3_P FCCU event enable. */
    vuint32_t FEE3_F:1;                /* FEE3_F FCCU event enable. */
    vuint32_t  :5;
    vuint32_t FEE3_C:1;                /* FEE3_C FCCU event enable. */
  } B;
} PMCDIG_FEE_VD3_tag;

typedef union PMCDIG_EPR_VD4_union_tag { /* LVD108 Event Pending Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t LVD4_C:1;                /* LVD4_C flag. */
  } B;
} PMCDIG_EPR_VD4_tag;

typedef union PMCDIG_REE_VD4_union_tag { /* Reset Event Select Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t LVD4_C:1;                /* LVD4_C reset enable. */
  } B;
} PMCDIG_REE_VD4_tag;

typedef union PMCDIG_RES_VD4_union_tag { /* Reset Event Select Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t LVD4_C:1;                /* LVD4_H reset event select. */
  } B;
} PMCDIG_RES_VD4_tag;

typedef union PMCDIG_FEE_VD4_union_tag { /* FCCU Event Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t FEE4_C:1;                /* FEE4_C FCCU event enable. */
  } B;
} PMCDIG_FEE_VD4_tag;

typedef union PMCDIG_EPR_VD7_union_tag { /* Event Pending Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t  :9;
    vuint32_t  :1;
    vuint32_t  :5;
    vuint32_t HVD7_C:1;                /* HVD7_C flag. */
  } B;
} PMCDIG_EPR_VD7_tag;

typedef union PMCDIG_REE_VD7_union_tag { /* Reset Event Enable VD7 Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t  :9;
    vuint32_t  :1;
    vuint32_t  :5;
    vuint32_t HVD7_C:1;                /* HVD7_C reset enable. */
  } B;
} PMCDIG_REE_VD7_tag;

typedef union PMCDIG_RES_VD7_union_tag { /* Reset Event Select Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t  :9;
    vuint32_t  :1;
    vuint32_t  :5;
    vuint32_t HVD7_C:1;                /* HVD7_C reset event select. */
  } B;
} PMCDIG_RES_VD7_tag;

typedef union PMCDIG_FEE_VD7_union_tag { /* FCCU Event Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t  :9;
    vuint32_t  :1;
    vuint32_t  :5;
    vuint32_t FEE7_C:1;                /* FEE7_C FCCU event enable. This bit defines whether an HVD assertion on the supply of the cold point generates an FCCU event. */
  } B;
} PMCDIG_FEE_VD7_tag;

typedef union PMCDIG_EPR_VD8_union_tag { /* Event Pending Register */
  vuint32_t R;
  struct {
    vuint32_t  :25;
    vuint32_t HVD8_F:1;                /* HVD8_F flag. */
    vuint32_t  :5;                     /* Reserved. */
    vuint32_t HVD8_C:1;                /* HVD8_C flag. */
  } B;
} PMCDIG_EPR_VD8_tag;

typedef union PMCDIG_REE_VD8_union_tag { /* Reset Event Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :25;
    vuint32_t HVD8_F:1;                /* HVD8_F reset enable. */
    vuint32_t  :5;                     /* Reserved. */
    vuint32_t HVD8_C:1;                /* HVD8_C reset enable. */
  } B;
} PMCDIG_REE_VD8_tag;

typedef union PMCDIG_RES_VD8_union_tag { /* Reset Event Select Registerr */
  vuint32_t R;
  struct {
    vuint32_t  :25;
    vuint32_t HVD8_F:1;                /* HVD8_F reset event select */
    vuint32_t  :5;                     /* Reserved. */
    vuint32_t HVD8_C:1;                /* HVD8_C reset event select. */
  } B;
} PMCDIG_RES_VD8_tag;

typedef union PMCDIG_FEE_VD8_union_tag { /* FCCU Event Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :25;
    vuint32_t FEE8_F:1;                /* FEE8_F FCCU event enable. */
    vuint32_t  :5;
    vuint32_t FEE8_C:1;                /* FEE8_C FCCU event enable. */
  } B;
} PMCDIG_FEE_VD8_tag;

typedef union PMCDIG_EPR_VD9_union_tag { /* LVD270 Event Pending Register */
  vuint32_t R;
  struct {
    vuint32_t  :17;
    vuint32_t LVD9_O:1;                /* LVD9_O flag. */
    vuint32_t  :2;
    vuint32_t LVD9_IF2:1;              /* LVD9_IF2 flag. */
    vuint32_t LVD9_IF:1;               /* LVD9_IF flag. */
    vuint32_t LVD9_IJ:1;               /* LVD9_IJ flag. */
    vuint32_t LVD9_IM:1;               /* LVD9_IM flag. */
    vuint32_t  :1;
    vuint32_t LVD9_F:1;                /* LVD9_F flag. */
    vuint32_t  :2;
    vuint32_t LVD9_EBI:1;              /* LVD9_EBI flag. */
    vuint32_t  :2;
    vuint32_t LVD9_C:1;                /* LVD9_C flag. */
  } B;
} PMCDIG_EPR_VD9_tag;

typedef union PMCDIG_REE_VD9_union_tag { /* Reset Event Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :17;
    vuint32_t LVD9_O:1;                /* LVD9_O reset enable. */
    vuint32_t  :2;
    vuint32_t LVD9_IF2:1;              /* LVD9_IF2 reset enable. */
    vuint32_t LVD9_IF:1;               /* LVD9_IF reset enable. */
    vuint32_t LVD9_IJ:1;               /* LVD9_IJ reset enable. */
    vuint32_t LVD9_IM:1;               /* LVD9_IM reset enable. */
    vuint32_t  :1;
    vuint32_t LVD9_F:1;                /* LVD9_F reset enable. */
    vuint32_t  :2;
    vuint32_t LVD9_EBI:1;              /* LVD9_EBI reset enable. */
    vuint32_t  :2;
    vuint32_t LVD9_C:1;                /* LVD9_C reset enable. */
  } B;
} PMCDIG_REE_VD9_tag;

typedef union PMCDIG_RES_VD9_union_tag { /* Reset Event Select Register */
  vuint32_t R;
  struct {
    vuint32_t  :20;
    vuint32_t LVD9_IF2:1;              /* LVD9_IF2 reset event select. */
    vuint32_t LVD9_IF:1;               /* LVD9_IF reset event select. */
    vuint32_t  :6;
    vuint32_t LVD9_EBI:1;              /* LVD9_EBI reset event select. */
    vuint32_t  :3;
  } B;
} PMCDIG_RES_VD9_tag;

typedef union PMCDIG_FEE_VD9_union_tag { /* FCCU Event Enable VD9 */
  vuint32_t R;
  struct {
    vuint32_t  :17;
    vuint32_t FEE9_O:1;                /* FEE9_O FCCU event enable. */
    vuint32_t  :2;
    vuint32_t FEE9_IF2:1;              /* FEE9_IF2 FCCU event enable. */
    vuint32_t FEE9_IF:1;               /* FEE9_IF FCCU event enable. */
    vuint32_t FEE9_IJ:1;               /* FEE9_IJ FCCU event enable. */
    vuint32_t FEE9_IM:1;               /* FEE9_IM FCCU event enable. */
    vuint32_t  :1;
    vuint32_t FEE9_F:1;                /* FEE9_F FCCU event enable. */
    vuint32_t  :2;
    vuint32_t FEE9_EBI:1;              /* FEE9_EBI FCCU event enable. */
    vuint32_t  :2;
    vuint32_t FEE9_C:1;                /* FEE9_C FCCU event enable. */
  } B;
} PMCDIG_FEE_VD9_tag;

typedef union PMCDIG_EPR_VD10_union_tag { /* LVD295 Event Pending Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t LVD10_A:1;               /* LVD10_A flag. */
    vuint32_t  :8;
    vuint32_t LVD10_F:1;               /* LVD10_F flag. */
    vuint32_t  :6;
  } B;
} PMCDIG_EPR_VD10_tag;

typedef union PMCDIG_REE_VD10_union_tag { /* Reset Event Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t LVD10_A:1;               /* LVD10_A reset enable. */
    vuint32_t  :8;
    vuint32_t LVD10_F:1;               /* LVD10_F reset enable. */
    vuint32_t  :6;
  } B;
} PMCDIG_REE_VD10_tag;

typedef union PMCDIG_FEE_VD10_union_tag { /* FCCU Event Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t FEE10_A:1;               /* FEE10_A FCCU event enable. */
    vuint32_t  :8;
    vuint32_t FEE10_F:1;               /* FEE10_F FCCU event enable. */
    vuint32_t  :6;
  } B;
} PMCDIG_FEE_VD10_tag;

typedef union PMCDIG_EPR_VD12_union_tag { /* HVD360 Event Pending Register */
  vuint32_t R;
  struct {
    vuint32_t  :25;
    vuint32_t HVD12_F:1;               /* HVD12_F flag. */
    vuint32_t  :6;
  } B;
} PMCDIG_EPR_VD12_tag;

typedef union PMCDIG_REE_VD12_union_tag { /* Reset Event Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :25;
    vuint32_t HVD12_F:1;               /* HVD12_F reset enable. */
    vuint32_t  :6;
  } B;
} PMCDIG_REE_VD12_tag;

typedef union PMCDIG_RES_VD12_union_tag { /* Reset Event Select Register */
  vuint32_t R;
  struct {
    vuint32_t  :25;
    vuint32_t HVD12_F:1;               /* HVD12_F reset event select. */
    vuint32_t  :6;
  } B;
} PMCDIG_RES_VD12_tag;

typedef union PMCDIG_FEE_VD12_union_tag { /* FCCU Event Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :25;
    vuint32_t FEE12_F:1;               /* FEE12_F FCCU event enable. */
    vuint32_t  :6;
  } B;
} PMCDIG_FEE_VD12_tag;

typedef union PMCDIG_EPR_VD13_union_tag { /* Event Pending Register */
  vuint32_t R;
  struct {
    vuint32_t  :23;
    vuint32_t LVD13_IM:1;              /* LVD13_IM flag. */
    vuint32_t  :8;
  } B;
} PMCDIG_EPR_VD13_tag;

typedef union PMCDIG_REE_VD13_union_tag { /* Reset Event Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :23;
    vuint32_t LVD13_IM:1;              /* LVD13_IM reset enable. */
    vuint32_t  :8;
  } B;
} PMCDIG_REE_VD13_tag;

typedef union PMCDIG_RES_VD13_union_tag { /* Reset Event Select Register */
  vuint32_t R;
  struct {
    vuint32_t  :23;
    vuint32_t LVD13_IM:1;              /* LVD13_IM reset event select. */
    vuint32_t  :8;
  } B;
} PMCDIG_RES_VD13_tag;

typedef union PMCDIG_FEE_VD13_union_tag { /* FCCU Event Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :23;
    vuint32_t FEE13_IM:1;              /* FEE13_IM FCCU event enable. */
    vuint32_t  :8;
  } B;
} PMCDIG_FEE_VD13_tag;

typedef union PMCDIG_EPR_VD14_union_tag { /* Event Pending Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t LVD14_A:1;               /* LVD14_A flag. */
    vuint32_t  :6;
    vuint32_t LVD14_IM:1;              /* LVD14_IM flag. */
    vuint32_t  :8;
  } B;
} PMCDIG_EPR_VD14_tag;

typedef union PMCDIG_REE_VD14_union_tag { /* Reset Event Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t LVD14_A:1;               /* LVD14_A reset enable. */
    vuint32_t  :6;
    vuint32_t LVD14_IM:1;              /* LVD14_IM reset enable. */
    vuint32_t  :8;
  } B;
} PMCDIG_REE_VD14_tag;

typedef union PMCDIG_RES_VD14_union_tag { /* Reset Event Select Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t LVD14_A:1;               /* LVD14_A reset event select. */
    vuint32_t  :6;
    vuint32_t LVD14_IM:1;              /* LVD14_IM reset event select. */
    vuint32_t  :8;
  } B;
} PMCDIG_RES_VD14_tag;

typedef union PMCDIG_FEE_VD14_union_tag { /* FCCU Event Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t FEE14_A:1;               /* FEE14_A FCCU event enable. */
    vuint32_t  :6;
    vuint32_t FEE14_IM:1;              /* FEE14_IM FCCU event enable. */
    vuint32_t  :8;
  } B;
} PMCDIG_FEE_VD14_tag;

typedef union PMCDIG_EPR_VD15_union_tag { /* Event Pending Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t HVD15_A:1;               /* HVD15_A flag. */
    vuint32_t  :14;
    vuint32_t HVD15_C:1;               /* HVD15_C flag. */
  } B;
} PMCDIG_EPR_VD15_tag;

typedef union PMCDIG_REE_VD15_union_tag { /* Reset Event Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t HVD15_A:1;               /* HVD15_A reset enable. */
    vuint32_t  :14;
    vuint32_t HVD15_C:1;
  } B;
} PMCDIG_REE_VD15_tag;

typedef union PMCDIG_RES_VD15_union_tag { /* Reset Event Select Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t HVD15_A:1;               /* HVD15_A reset event select. */
    vuint32_t  :14;
    vuint32_t HVD15_C:1;               /* HVD15_C reset event select. */
  } B;
} PMCDIG_RES_VD15_tag;

typedef union PMCDIG_FEE_VD15_union_tag { /* FCCU Event Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t FEE15_A:1;               /* FEE15_A FCCU event enable. */
    vuint32_t  :14;
    vuint32_t FEE15_C:1;               /* FEE15_C FCCU event enable. */
  } B;
} PMCDIG_FEE_VD15_tag;

typedef union PMCDIG_VSIO_union_tag {  /* Voltage Supply for I/O Segment Register */
  vuint32_t R;
  struct {
    vuint32_t  :20;
    vuint32_t VSIO_IF2:1;              /* VSIO_IF2 control. */
    vuint32_t VSIO_IF:1;               /* VSIO_IF control. */
    vuint32_t VSIO_IJ:1;               /* VSIO_IJ control. */
    vuint32_t VSIO_IM:1;               /* VSIO_IM control. */
    vuint32_t  :8;
  } B;
} PMCDIG_VSIO_tag;

typedef union PMCDIG_EPR_TD_union_tag { /* Event Pending Register */
  vuint32_t R;
  struct {
    vuint32_t  :28;
    vuint32_t TEMP_3:1;                /* TEMP_3 flag. */
    vuint32_t TEMP_2:1;                /* TEMP_2 flag. */
    vuint32_t  :1;
    vuint32_t TEMP_0:1;                /* TEMP_0 flag. */
  } B;
} PMCDIG_EPR_TD_tag;

typedef union PMCDIG_REE_TD_union_tag { /* Reset Event Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :28;
    vuint32_t TEMP_3:1;                /* TEMP_3 reset enable. */
    vuint32_t TEMP_2:1;                /* TEMP_2 reset enable. */
    vuint32_t  :1;
    vuint32_t TEMP_0:1;                /* TEMP_0 reset enable. */
  } B;
} PMCDIG_REE_TD_tag;

typedef union PMCDIG_RES_TD_union_tag { /* Reset Event Select Register */
  vuint32_t R;
  struct {
    vuint32_t  :28;
    vuint32_t TEMP_3:1;                /* TEMP_3 reset event select. */
    vuint32_t TEMP_2:1;                /* TEMP_2 reset event select. */
    vuint32_t  :1;
    vuint32_t TEMP_0:1;                /* TEMP_0 reset event select. */
  } B;
} PMCDIG_RES_TD_tag;

typedef union PMCDIG_CTL_TD_union_tag { /* Temperature Sensor Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t TS3IE:1;                 /* TS3IE Temperature Sensor input 3 Interrupt Enable. */
    vuint32_t TS2IE:1;                 /* TS2IE Temperature Sensor input 0 Interrupt Enable. */
    vuint32_t TS0IE:1;                 /* TS0IE Temperature Sensor input 0 Interrupt Enable. */
    vuint32_t  :1;
    vuint32_t TRIM_ADJ_OVER:4;         /* Customer adjustable over trim register. */
    vuint32_t  :2;
    vuint32_t TRIM_ADJ_UNDER:4;        /* Customer adjustable trim register. */
    vuint32_t DOUT_EN:1;               /* Digital Output Enable. */
    vuint32_t AOUT_EN:1;               /* Analog Output Enable. */
  } B;
} PMCDIG_CTL_TD_tag;

typedef union PMCDIG_FEE_TD_union_tag { /* Temp Sensor FCCU Event Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :28;
    vuint32_t FEE_TS3:1;               /* FEE_TS3 Temp Sensor FCCU event enable. */
    vuint32_t FEE_TS2:1;               /* FEE_TS2 Temp Sensor FCCU event enable. */
    vuint32_t  :1;
    vuint32_t FEE_TS0:1;               /* FEE_TS0 Temp Sensor FCCU event enable. */
  } B;
} PMCDIG_FEE_TD_tag;

typedef union PMCDIG_VD_UTST_union_tag { /* Voltage Detect User Mode Test Register */
  vuint32_t R;
  struct {
    vuint32_t  :4;                     /* Reserved. */
    vuint32_t VOLT4_EN:1;              /* VOLT4 enable. */
    vuint32_t VOLT3_EN:1;              /* VOLT3 enable. */
    vuint32_t VOLT2_EN:1;              /* VOLT2 enable. */
    vuint32_t VOLT1_EN:1;              /* VOLT1 enable. */
    vuint32_t  :4;                     /* Reserved. */
    vuint32_t VOLT4:1;                 /* VOLT4 flag. */
    vuint32_t VOLT3:1;                 /* VOLT3 flag. */
    vuint32_t VOLT2:1;                 /* VOLT2 flag. */
    vuint32_t VOLT1:1;                 /* VOLT1 flag. */
    vuint32_t  :10;
    vuint32_t VD_UTST:6;               /* Voltage Detect: User Test. */
  } B;
} PMCDIG_VD_UTST_tag;

typedef union PMCDIG_ADC_CH_union_tag { /* ADC Channel Select Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t ADC_CS:6;                /* ADC_CS Channel Select. */
  } B;
} PMCDIG_ADC_CH_tag;

typedef union PMCDIG_VREG1P2_CTRL_union_tag { /* Voltage Regulator 1.2V Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t VREG1P2_DIS:1;           /* This bit controls if the AUX Regulator (Vreg1p2) is disabled. */
  } B;
} PMCDIG_VREG1P2_CTRL_tag;

typedef union PMCDIG_MCR_union_tag {   /* Module Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;                    /* Reserved. */
    vuint32_t  :1;
    vuint32_t USER_SELF_TEST_EN:1;     /* This bit allows the VD_UTST bits int he VD_UTST register to be enabled. */
    vuint32_t  :6;                     /* Reserved. */
    vuint32_t TEST_PIN:1;              /* This bit is indicates the current value of the Test Pin. */
    vuint32_t  :6;                     /* Reserved. */
    vuint32_t SBRAM_BRDET:1;           /* SBRAM_BRDET. */
  } B;
} PMCDIG_MCR_tag;

struct PMCDIG_tag {
  PMCDIG_GR_S_tag GR_S;                /* Supply Gauge Status Register */
  PMCDIG_GR_P_tag GR_P;                /* Pending Gauge Status Register */
  PMCDIG_IE_P_tag IE_P;                /* Interrupt Enable Pending Register */
  uint8_t PMCDIG_reserved0[36];
  PMCDIG_EPR_VD3_tag EPR_VD3;          /* Event Pending Register */
  PMCDIG_REE_VD3_tag REE_VD3;          /* Reset Event Enable Register */
  PMCDIG_RES_VD3_tag RES_VD3;          /* Reset Event Select Register */
  PMCDIG_FEE_VD3_tag FEE_VD3;          /* FCCU Event Enable Register */
  PMCDIG_EPR_VD4_tag EPR_VD4;          /* LVD108 Event Pending Register */
  PMCDIG_REE_VD4_tag REE_VD4;          /* Reset Event Select Register */
  PMCDIG_RES_VD4_tag RES_VD4;          /* Reset Event Select Register */
  PMCDIG_FEE_VD4_tag FEE_VD4;          /* FCCU Event Enable Register */
  uint8_t PMCDIG_reserved1[32];
  PMCDIG_EPR_VD7_tag EPR_VD7;          /* Event Pending Register */
  PMCDIG_REE_VD7_tag REE_VD7;          /* Reset Event Enable VD7 Register */
  PMCDIG_RES_VD7_tag RES_VD7;          /* Reset Event Select Register */
  PMCDIG_FEE_VD7_tag FEE_VD7;          /* FCCU Event Enable Register */
  PMCDIG_EPR_VD8_tag EPR_VD8;          /* Event Pending Register */
  PMCDIG_REE_VD8_tag REE_VD8;          /* Reset Event Enable Register */
  PMCDIG_RES_VD8_tag RES_VD8;          /* Reset Event Select Registerr */
  PMCDIG_FEE_VD8_tag FEE_VD8;          /* FCCU Event Enable Register */
  PMCDIG_EPR_VD9_tag EPR_VD9;          /* LVD270 Event Pending Register */
  PMCDIG_REE_VD9_tag REE_VD9;          /* Reset Event Enable Register */
  PMCDIG_RES_VD9_tag RES_VD9;          /* Reset Event Select Register */
  PMCDIG_FEE_VD9_tag FEE_VD9;          /* FCCU Event Enable VD9 */
  PMCDIG_EPR_VD10_tag EPR_VD10;        /* LVD295 Event Pending Register */
  PMCDIG_REE_VD10_tag REE_VD10;        /* Reset Event Enable Register */
  uint8_t PMCDIG_reserved2[4];
  PMCDIG_FEE_VD10_tag FEE_VD10;        /* FCCU Event Enable Register */
  uint8_t PMCDIG_reserved3[16];
  PMCDIG_EPR_VD12_tag EPR_VD12;        /* HVD360 Event Pending Register */
  PMCDIG_REE_VD12_tag REE_VD12;        /* Reset Event Enable Register */
  PMCDIG_RES_VD12_tag RES_VD12;        /* Reset Event Select Register */
  PMCDIG_FEE_VD12_tag FEE_VD12;        /* FCCU Event Enable Register */
  PMCDIG_EPR_VD13_tag EPR_VD13;        /* Event Pending Register */
  PMCDIG_REE_VD13_tag REE_VD13;        /* Reset Event Enable Register */
  PMCDIG_RES_VD13_tag RES_VD13;        /* Reset Event Select Register */
  PMCDIG_FEE_VD13_tag FEE_VD13;        /* FCCU Event Enable Register */
  PMCDIG_EPR_VD14_tag EPR_VD14;        /* Event Pending Register */
  PMCDIG_REE_VD14_tag REE_VD14;        /* Reset Event Enable Register */
  PMCDIG_RES_VD14_tag RES_VD14;        /* Reset Event Select Register */
  PMCDIG_FEE_VD14_tag FEE_VD14;        /* FCCU Event Enable Register */
  PMCDIG_EPR_VD15_tag EPR_VD15;        /* Event Pending Register */
  PMCDIG_REE_VD15_tag REE_VD15;        /* Reset Event Enable Register */
  PMCDIG_RES_VD15_tag RES_VD15;        /* Reset Event Select Register */
  PMCDIG_FEE_VD15_tag FEE_VD15;        /* FCCU Event Enable Register */
  uint8_t PMCDIG_reserved4[4];
  PMCDIG_VSIO_tag VSIO;                /* Voltage Supply for I/O Segment Register */
  uint8_t PMCDIG_reserved5[504];
  PMCDIG_EPR_TD_tag EPR_TD;            /* Event Pending Register */
  PMCDIG_REE_TD_tag REE_TD;            /* Reset Event Enable Register */
  PMCDIG_RES_TD_tag RES_TD;            /* Reset Event Select Register */
  PMCDIG_CTL_TD_tag CTL_TD;            /* Temperature Sensor Configuration Register */
  uint8_t PMCDIG_reserved6[8];
  PMCDIG_FEE_TD_tag FEE_TD;            /* Temp Sensor FCCU Event Enable Register */
  uint8_t PMCDIG_reserved7[36];
  PMCDIG_VD_UTST_tag VD_UTST;          /* Voltage Detect User Mode Test Register */
  PMCDIG_ADC_CH_tag ADC_CH;            /* ADC Channel Select Register */
  uint8_t PMCDIG_reserved8[4];
  PMCDIG_VREG1P2_CTRL_tag VREG1P2_CTRL; /* Voltage Regulator 1.2V Control Register */
  PMCDIG_MCR_tag MCR;                  /* Module Control Register */
};


/* ============================================================================
   =============================== Module: PRAMC ==============================
   ============================================================================ */

typedef union PRAMC_PRCR1_union_tag {  /* Platform RAM Configuration Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t PRI:2;                   /* AHB port arbitration mode. */
    vuint32_t P1_BO_DIS:1;             /* Port p1 read burst optimization disable. */
    vuint32_t P0_BO_DIS:1;             /* Port p0 read burst optimization disable. */
    vuint32_t P1_RB_DIS:1;             /* Port p1 read buffer disable. */
    vuint32_t P0_RB_DIS:1;             /* Port p0 read buffer disable. */
    vuint32_t  :3;
    vuint32_t FT_DIS:1;                /* Flow through disabled. */
  } B;
} PRAMC_PRCR1_tag;

struct PRAMC_tag {
  PRAMC_PRCR1_tag PRCR1;               /* Platform RAM Configuration Register 1 */
};


/* ============================================================================
   =============================== Module: PSI5 ===============================
   ============================================================================ */

typedef union PSI5_GCR_union_tag {     /* Global Control Register */
  vuint16_t R;
  struct {
    vuint16_t  :14;
    vuint16_t CTC_GED:1;
    vuint16_t GLOBAL_DISABLE_REQ:1;
  } B;
} PSI5_GCR_tag;

typedef union PSI5_CH0_PCCR_union_tag { /* PSI5 Channel Control Register */
  vuint32_t R;
  struct {
    vuint32_t CTC_GED_SEL:1;
    vuint32_t CTC_ED:1;
    vuint32_t  :1;
    vuint32_t MEM_DEPTH:5;
    vuint32_t  :3;
    vuint32_t ERROR_SELECT4:1;
    vuint32_t ERROR_SELECT3:1;
    vuint32_t ERROR_SELECT2:1;
    vuint32_t ERROR_SELECT1:1;
    vuint32_t ERROR_SELECT0:1;
    vuint32_t  :1;
    vuint32_t GTM_RESET_ASYNC_EN:1;
    vuint32_t  :3;
    vuint32_t DEBUG_EN:1;
    vuint32_t DEBUG_FREEZE_CTRL:1;
    vuint32_t SP_TS_CLK_SEL:1;
    vuint32_t  :2;
    vuint32_t FAST_CLR_SMC:1;
    vuint32_t FAST_CLR_PSI5:1;
    vuint32_t BIT_RATE:1;              /* Bit Rate */
    vuint32_t MODE:1;
    vuint32_t PSI5_CH_CONFIG:1;
    vuint32_t PSI5_CH_EN:1;
  } B;
} PSI5_CH0_PCCR_tag;

typedef union PSI5_CH0_DCR_union_tag { /* DMA Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t  :2;
    vuint32_t DMA_PM_DS_WM:5;
    vuint32_t  :5;
    vuint32_t IE_DMA_TF_SF:1;
    vuint32_t IE_DMA_TF_PM_DS:1;
    vuint32_t  :5;
    vuint32_t IE_DMA_PM_DS_FIFO_FULL:1;
    vuint32_t IE_DMA_SFUF:1;
    vuint32_t  :1;
    vuint32_t IE_DMA_PM_DS_UF:1;
    vuint32_t  :5;
    vuint32_t DMA_EN_SF:1;
    vuint32_t DMA_PM_DS_CONFIG:2;
  } B;
} PSI5_CH0_DCR_tag;

typedef union PSI5_CH0_DSR_union_tag { /* DMA Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :13;
    vuint32_t IS_DMA_TF_SF:1;
    vuint32_t IS_DMA_TF_PM_DS:1;
    vuint32_t  :5;
    vuint32_t IS_DMA_PM_DS_FIFO_FULL:1;
    vuint32_t IS_DMA_SFUF:1;
    vuint32_t  :1;
    vuint32_t IS_DMA_PM_DS_UF:1;
    vuint32_t  :8;
  } B;
} PSI5_CH0_DSR_tag;

typedef union PSI5_CH0_GICR_union_tag { /* General Interrupt Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t IE_CESM:6;
    vuint32_t IE_STS:1;
    vuint32_t IE_DTS:1;
    vuint32_t IE_DSROW:1;
    vuint32_t IE_BROW:1;
    vuint32_t IE_PROW:1;
    vuint32_t IE_DSRR:1;
    vuint32_t IE_BRR:1;
    vuint32_t IE_PRR:1;
    vuint32_t  :2;
    vuint32_t IE_OWSM:6;
    vuint32_t  :2;
    vuint32_t IE_NVSM:6;
  } B;
} PSI5_CH0_GICR_tag;

typedef union PSI5_CH0_NDICR_union_tag { /* New Data Interrupt Control Register */
  vuint32_t R;
  struct {
    vuint32_t IE_ND:32;
  } B;
} PSI5_CH0_NDICR_tag;

typedef union PSI5_CH0_OWICR_union_tag { /* Overwrite Interrupt Control Register */
  vuint32_t R;
  struct {
    vuint32_t IE_OW:32;
  } B;
} PSI5_CH0_OWICR_tag;

typedef union PSI5_CH0_EICR_union_tag { /* Error Interrupt Control Register */
  vuint32_t R;
  struct {
    vuint32_t IE_ERROR:32;
  } B;
} PSI5_CH0_EICR_tag;

typedef union PSI5_CH0_GISR_union_tag { /* General Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t IS_DB_FR:1;
    vuint32_t  :1;
    vuint32_t IS_CESM:6;
    vuint32_t IS_STS:1;
    vuint32_t IS_DTS:1;
    vuint32_t IS_DSROW:1;
    vuint32_t IS_BROW:1;
    vuint32_t IS_PROW:1;
    vuint32_t DSR_RDY:1;
    vuint32_t DBR_RDY:1;
    vuint32_t DPR_RDY:1;
    vuint32_t  :2;
    vuint32_t IS_OWSM:6;
    vuint32_t  :2;
    vuint32_t IS_NVSM:6;
  } B;
} PSI5_CH0_GISR_tag;

typedef union PSI5_CH0_DPMR_union_tag { /* DMA PSI5 Message Register */
  vuint32_t R;
  struct {
    vuint32_t PSI5_RXDATA:32;
  } B;
} PSI5_CH0_DPMR_tag;

typedef union PSI5_CH0_DSFR_union_tag { /* DMA SMC Frame Register */
  vuint32_t R;
  struct {
    vuint32_t SMC_RXDATA:32;
  } B;
} PSI5_CH0_DSFR_tag;

typedef union PSI5_CH0_DDSR_union_tag { /* DMA Diagnostic Status Register */
  vuint32_t R;
  struct {
    vuint32_t DDS:32;
  } B;
} PSI5_CH0_DDSR_tag;

typedef union PSI5_CH0_PMRRL_union_tag { /* PSI5 Message Receive Register Low */
  vuint32_t R;
  struct {
    vuint32_t DATA_REGION:28;
    vuint32_t CRC:3;
    vuint32_t C:1;
  } B;
} PSI5_CH0_PMRRL_tag;

typedef union PSI5_CH0_PMRRH_union_tag { /* PSI5 Message Receive Register High */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t F:1;
    vuint32_t EM:1;
    vuint32_t E:1;
    vuint32_t T:1;
    vuint32_t SlotCounter:3;
    vuint32_t TimeStampValue:24;
  } B;
} PSI5_CH0_PMRRH_tag;

typedef union PSI5_CH0_PMRL_union_tag { /* PSI5 Message Register Low i */
  vuint32_t R;
  struct {
    vuint32_t DATA_REGION:28;
    vuint32_t CRCP:3;
    vuint32_t C:1;
  } B;
} PSI5_CH0_PMRL_tag;

typedef union PSI5_CH0_PMRH_union_tag { /* PSI5 Message Register High i */
  vuint32_t R;
  struct {
    vuint32_t O:1;
    vuint32_t F:1;
    vuint32_t EM:1;
    vuint32_t E:1;
    vuint32_t T:1;
    vuint32_t Slot_Counter:3;
    vuint32_t TimeStampValue:24;
  } B;
} PSI5_CH0_PMRH_tag;

typedef struct PSI5_CH0_struct_tag {
  PSI5_CH0_PMRL_tag PMRL;              /* PSI5 Message Register Low i */
  PSI5_CH0_PMRH_tag PMRH;              /* PSI5 Message Register High i */
} PSI5_CH0_tag;

typedef union PSI5_CH0_SFR_union_tag { /* SMC Frame Register n */
  vuint32_t R;
  struct {
    vuint32_t SLOT_NO:3;
    vuint32_t CER:1;
    vuint32_t OW:1;
    vuint32_t CRC:6;
    vuint32_t C:1;
    vuint32_t ID:4;
    vuint32_t IDDATA:4;
    vuint32_t DATA:12;
  } B;
} PSI5_CH0_SFR_tag;

typedef union PSI5_CH0_NDSR_union_tag { /* New Data Status Register */
  vuint32_t R;
  struct {
    vuint32_t NDS:32;
  } B;
} PSI5_CH0_NDSR_tag;

typedef union PSI5_CH0_OWSR_union_tag { /* Overwrite Status Register */
  vuint32_t R;
  struct {
    vuint32_t OWS:32;
  } B;
} PSI5_CH0_OWSR_tag;

typedef union PSI5_CH0_EISR_union_tag { /* Error Indication Status Register */
  vuint32_t R;
  struct {
    vuint32_t ERROR:32;
  } B;
} PSI5_CH0_EISR_tag;

typedef union PSI5_CH0_SNDSR_union_tag { /* Set New Data Status Register */
  vuint32_t R;
  struct {
    vuint32_t SNDS:32;
  } B;
} PSI5_CH0_SNDSR_tag;

typedef union PSI5_CH0_SOWSR_union_tag { /* Set Overwrite Status Register */
  vuint32_t R;
  struct {
    vuint32_t SOWS:32;
  } B;
} PSI5_CH0_SOWSR_tag;

typedef union PSI5_CH0_SEISR_union_tag { /* Set Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t SERROR:32;
  } B;
} PSI5_CH0_SEISR_tag;

typedef union PSI5_CH0_SSESR_union_tag { /* Set SMC Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t SCESM:6;
    vuint32_t  :10;
    vuint32_t SOWSM:6;
    vuint32_t  :2;
    vuint32_t SNVSM:6;
  } B;
} PSI5_CH0_SSESR_tag;

typedef union PSI5_CH0_STSRR_union_tag { /* Sync Time Stamp Read Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t STSV:24;
  } B;
} PSI5_CH0_STSRR_tag;

typedef union PSI5_CH0_DTSRR_union_tag { /* Data Time Stamp Read Register */
  vuint32_t R;
  struct {
    vuint32_t  :5;
    vuint32_t SLOT_COUNTER:3;
    vuint32_t DTSV:24;
  } B;
} PSI5_CH0_DTSRR_tag;

typedef union PSI5_CH0_SFCR_union_tag { /* Slot n Frame Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :13;
    vuint32_t SLOT_EN:1;
    vuint32_t TS_CAPT:1;
    vuint32_t  :1;
    vuint32_t SMCL:1;
    vuint32_t  :9;
    vuint32_t DRL:5;
    vuint32_t CRCP:1;
  } B;
} PSI5_CH0_SFCR_tag;

typedef union PSI5_CH0_S1SBR_union_tag { /* Slot 1 Start Boundary Register */
  vuint16_t R;
  struct {
    vuint16_t  :1;
    vuint16_t S1SBT:15;
  } B;
} PSI5_CH0_S1SBR_tag;

typedef union PSI5_CH0_S2SBR_union_tag { /* Slot 2 Start Boundary Register */
  vuint16_t R;
  struct {
    vuint16_t  :1;
    vuint16_t S2SBT:15;
  } B;
} PSI5_CH0_S2SBR_tag;

typedef union PSI5_CH0_S3SBR_union_tag { /* Slot 3 Start Boundary Register */
  vuint16_t R;
  struct {
    vuint16_t  :1;
    vuint16_t S3SBT:15;
  } B;
} PSI5_CH0_S3SBR_tag;

typedef union PSI5_CH0_S4SBR_union_tag { /* Slot 4 Start Boundary Register */
  vuint16_t R;
  struct {
    vuint16_t  :1;
    vuint16_t S4SBT:15;
  } B;
} PSI5_CH0_S4SBR_tag;

typedef union PSI5_CH0_S5SBR_union_tag { /* Slot 5 Start Boundary Register */
  vuint16_t R;
  struct {
    vuint16_t  :1;
    vuint16_t S5SBT:15;
  } B;
} PSI5_CH0_S5SBR_tag;

typedef union PSI5_CH0_S6SBR_union_tag { /* Slot 6 Start Boundary Register */
  vuint16_t R;
  struct {
    vuint16_t  :1;
    vuint16_t S6SBT:15;
  } B;
} PSI5_CH0_S6SBR_tag;

typedef union PSI5_CH0_SnEBR_union_tag { /* Slot n End Boundary Register */
  vuint32_t R;
  struct {
    vuint32_t  :13;
    vuint32_t SLOT_NO:3;
    vuint32_t  :1;
    vuint32_t SnEBT:15;
  } B;
} PSI5_CH0_SnEBR_tag;

typedef union PSI5_CH0_DOBCR_union_tag { /* Data Output Block Configuration Register */
  vuint16_t R;
  struct {
    vuint16_t DATA_LENGTH:6;
    vuint16_t DBR_RST:1;
    vuint16_t DSR_RST:1;
    vuint16_t CMD_TYPE:3;
    vuint16_t DEFAULT_SYNC:1;
    vuint16_t GTM_TRIG_SEL:1;
    vuint16_t SP_PULSE_SEL:1;
    vuint16_t OP_SEL:1;
    vuint16_t SW_READY:1;
  } B;
} PSI5_CH0_DOBCR_tag;

typedef union PSI5_CH0_MDDIS_OFF_union_tag { /* Manchestor Decoder Disable Offset */
  vuint16_t R;
  struct {
    vuint16_t  :9;
    vuint16_t MDDIS_OFF:7;
  } B;
} PSI5_CH0_MDDIS_OFF_tag;

typedef union PSI5_CH0_PW0D_union_tag { /* Pulse Width for Data Bit Value 0 */
  vuint16_t R;
  struct {
    vuint16_t  :9;
    vuint16_t Pulse_Width0:7;
  } B;
} PSI5_CH0_PW0D_tag;

typedef union PSI5_CH0_PW1D_union_tag { /* Pulse Width for Data Bit Value 1 */
  vuint16_t R;
  struct {
    vuint16_t  :9;
    vuint16_t Pulse_Width1:7;
  } B;
} PSI5_CH0_PW1D_tag;

typedef union PSI5_CH0_CTPR_union_tag { /* Counter Target Pulse Register */
  vuint16_t R;
  struct {
    vuint16_t CTPR:16;
  } B;
} PSI5_CH0_CTPR_tag;

typedef union PSI5_CH0_CIPR_union_tag { /* Counter Initialize Pulse Register */
  vuint16_t R;
  struct {
    vuint16_t CIPR:16;
  } B;
} PSI5_CH0_CIPR_tag;

typedef union PSI5_CH0_DPRL_union_tag { /* Data Preparation Register Low */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t DPR:24;
  } B;
} PSI5_CH0_DPRL_tag;

typedef union PSI5_CH0_DPRH_union_tag { /* Data Preparation Register High */
  vuint32_t R;
  struct {
    vuint32_t  :32;
  } B;
} PSI5_CH0_DPRH_tag;

typedef union PSI5_CH0_DBRL_union_tag { /* Data Buffer Register Low */
  vuint32_t R;
  struct {
    vuint32_t DBR:32;
  } B;
} PSI5_CH0_DBRL_tag;

typedef union PSI5_CH0_DBRH_union_tag { /* Data Buffer Register High */
  vuint32_t R;
  struct {
    vuint32_t DBR:32;
  } B;
} PSI5_CH0_DBRH_tag;

typedef union PSI5_CH0_DSRL_union_tag { /* Data Shift Register Low */
  vuint32_t R;
  struct {
    vuint32_t DSR:32;
  } B;
} PSI5_CH0_DSRL_tag;

typedef union PSI5_CH0_DSRH_union_tag { /* Data Shift Register High */
  vuint32_t R;
  struct {
    vuint32_t DSR:32;
  } B;
} PSI5_CH0_DSRH_tag;

typedef union PSI5_CH1_PCCR_union_tag { /* PSI5 Channel Control Register */
  vuint32_t R;
  struct {
    vuint32_t CTC_GED_SEL:1;
    vuint32_t CTC_ED:1;
    vuint32_t  :1;
    vuint32_t MEM_DEPTH:5;
    vuint32_t  :3;
    vuint32_t ERROR_SELECT4:1;
    vuint32_t ERROR_SELECT3:1;
    vuint32_t ERROR_SELECT2:1;
    vuint32_t ERROR_SELECT1:1;
    vuint32_t ERROR_SELECT0:1;
    vuint32_t  :1;
    vuint32_t GTM_RESET_ASYNC_EN:1;
    vuint32_t  :3;
    vuint32_t DEBUG_EN:1;
    vuint32_t DEBUG_FREEZE_CTRL:1;
    vuint32_t SP_TS_CLK_SEL:1;
    vuint32_t  :2;
    vuint32_t FAST_CLR_SMC:1;
    vuint32_t FAST_CLR_PSI5:1;
    vuint32_t BIT_RATE:1;
    vuint32_t MODE:1;
    vuint32_t PSI5_CH_CONFIG:1;
    vuint32_t PSI5_CH_EN:1;
  } B;
} PSI5_CH1_PCCR_tag;

typedef union PSI5_CH1_DCR_union_tag { /* DMA Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :3;
    vuint32_t DMA_PM_DS_WM:5;
    vuint32_t  :5;
    vuint32_t IE_DMA_TF_SF:1;
    vuint32_t IE_DMA_TF_PM_DS:1;
    vuint32_t  :5;
    vuint32_t IE_DMA_PM_DS_FIFO_FULL:1;
    vuint32_t IE_DMA_SFUF:1;
    vuint32_t  :1;
    vuint32_t IE_DMA_PM_DS_UF:1;
    vuint32_t  :5;
    vuint32_t DMA_EN_SF:1;
    vuint32_t DMA_PM_DS_CONFIG:2;
  } B;
} PSI5_CH1_DCR_tag;

typedef union PSI5_CH1_DSR_union_tag { /* DMA Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :13;
    vuint32_t IS_DMA_TF_SF:1;
    vuint32_t IS_DMA_TF_PM_DS:1;
    vuint32_t  :5;
    vuint32_t IS_DMA_PM_DS_FIFO_FULL:1;
    vuint32_t IS_DMA_SFUF:1;
    vuint32_t  :1;
    vuint32_t IS_DMA_PM_DS_UF:1;
    vuint32_t  :8;
  } B;
} PSI5_CH1_DSR_tag;

typedef union PSI5_CH1_GICR_union_tag { /* General Interrupt Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t IE_CESM:6;
    vuint32_t IE_STS:1;
    vuint32_t IE_DTS:1;
    vuint32_t IE_DSROW:1;
    vuint32_t IE_BROW:1;
    vuint32_t IE_PROW:1;
    vuint32_t IE_DSRR:1;
    vuint32_t IE_BRR:1;
    vuint32_t IE_PRR:1;
    vuint32_t  :2;
    vuint32_t IE_OWSM:6;
    vuint32_t  :2;
    vuint32_t IE_NVSM:6;
  } B;
} PSI5_CH1_GICR_tag;

typedef union PSI5_CH1_NDICR_union_tag { /* New Data Interrupt Control Register */
  vuint32_t R;
  struct {
    vuint32_t IE_ND:32;
  } B;
} PSI5_CH1_NDICR_tag;

typedef union PSI5_CH1_OWICR_union_tag { /* Overwrite Interrupt Control Register */
  vuint32_t R;
  struct {
    vuint32_t IE_OW:32;
  } B;
} PSI5_CH1_OWICR_tag;

typedef union PSI5_CH1_EICR_union_tag { /* Error Interrupt Control Register */
  vuint32_t R;
  struct {
    vuint32_t IE_ERROR:32;
  } B;
} PSI5_CH1_EICR_tag;

typedef union PSI5_CH1_GISR_union_tag { /* General Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t IS_DB_FR:1;
    vuint32_t  :1;
    vuint32_t IS_CESM:6;
    vuint32_t IS_STS:1;
    vuint32_t IS_DTS:1;
    vuint32_t IS_DSROW:1;
    vuint32_t IS_BROW:1;
    vuint32_t IS_PROW:1;
    vuint32_t DSR_RDY:1;
    vuint32_t DBR_RDY:1;
    vuint32_t DPR_RDY:1;
    vuint32_t  :2;
    vuint32_t IS_OWSM:6;
    vuint32_t  :2;
    vuint32_t IS_NVSM:6;
  } B;
} PSI5_CH1_GISR_tag;

typedef union PSI5_CH1_DPMR_union_tag { /* DMA PSI5 Message Register */
  vuint32_t R;
  struct {
    vuint32_t PSI5_RXDATA:32;
  } B;
} PSI5_CH1_DPMR_tag;

typedef union PSI5_CH1_DSFR_union_tag { /* DMA SMC Frame Register */
  vuint32_t R;
  struct {
    vuint32_t SMC_RXDATA:32;
  } B;
} PSI5_CH1_DSFR_tag;

typedef union PSI5_CH1_DDSR_union_tag { /* DMA Diagnostic Status Register */
  vuint32_t R;
  struct {
    vuint32_t DDS:32;
  } B;
} PSI5_CH1_DDSR_tag;

typedef union PSI5_CH1_PMRRL_union_tag { /* PSI5 Message Receive Register Low */
  vuint32_t R;
  struct {
    vuint32_t DATA_REGION:28;
    vuint32_t CRC:3;
    vuint32_t C:1;
  } B;
} PSI5_CH1_PMRRL_tag;

typedef union PSI5_CH1_PMRRH_union_tag { /* PSI5 Message Receive Register High */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t F:1;
    vuint32_t EM:1;
    vuint32_t E:1;
    vuint32_t T:1;
    vuint32_t SlotCounter:3;
    vuint32_t TimeStampValue:24;
  } B;
} PSI5_CH1_PMRRH_tag;

typedef union PSI5_CH1_PMRL_union_tag { /* PSI5 Message Register Low i */
  vuint32_t R;
  struct {
    vuint32_t DATA_REGION:28;
    vuint32_t CRCP:3;
    vuint32_t C:1;
  } B;
} PSI5_CH1_PMRL_tag;

typedef union PSI5_CH1_PMRH_union_tag { /* PSI5 Message Register High i */
  vuint32_t R;
  struct {
    vuint32_t O:1;
    vuint32_t F:1;
    vuint32_t EM:1;
    vuint32_t E:1;
    vuint32_t T:1;
    vuint32_t Slot_Counter:3;
    vuint32_t TimeStampValue:24;
  } B;
} PSI5_CH1_PMRH_tag;

typedef struct PSI5_CH1_struct_tag {
  PSI5_CH1_PMRL_tag PMRL;              /* PSI5 Message Register Low i */
  PSI5_CH1_PMRH_tag PMRH;              /* PSI5 Message Register High i */
} PSI5_CH1_tag;

typedef union PSI5_CH1_SFR_union_tag { /* SMC Frame Register n */
  vuint32_t R;
  struct {
    vuint32_t SLOT_NO:3;
    vuint32_t CER:1;
    vuint32_t OW:1;
    vuint32_t CRC:6;
    vuint32_t C:1;
    vuint32_t ID:4;
    vuint32_t IDDATA:4;
    vuint32_t DATA:12;
  } B;
} PSI5_CH1_SFR_tag;

typedef union PSI5_CH1_NDSR_union_tag { /* New Data Status Register */
  vuint32_t R;
  struct {
    vuint32_t NDS:32;
  } B;
} PSI5_CH1_NDSR_tag;

typedef union PSI5_CH1_OWSR_union_tag { /* Overwrite Status Register */
  vuint32_t R;
  struct {
    vuint32_t OWS:32;
  } B;
} PSI5_CH1_OWSR_tag;

typedef union PSI5_CH1_EISR_union_tag { /* Error Indication Status Register */
  vuint32_t R;
  struct {
    vuint32_t ERROR:32;
  } B;
} PSI5_CH1_EISR_tag;

typedef union PSI5_CH1_SNDSR_union_tag { /* Set New Data Status Register */
  vuint32_t R;
  struct {
    vuint32_t SNDS:32;
  } B;
} PSI5_CH1_SNDSR_tag;

typedef union PSI5_CH1_SOWSR_union_tag { /* Set Overwrite Status Register */
  vuint32_t R;
  struct {
    vuint32_t SOWS:32;
  } B;
} PSI5_CH1_SOWSR_tag;

typedef union PSI5_CH1_SEISR_union_tag { /* Set Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t SERROR:32;
  } B;
} PSI5_CH1_SEISR_tag;

typedef union PSI5_CH1_SSESR_union_tag { /* Set SMC Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t SCESM:6;
    vuint32_t  :10;
    vuint32_t SOWSM:6;
    vuint32_t  :2;
    vuint32_t SNVSM:6;
  } B;
} PSI5_CH1_SSESR_tag;

typedef union PSI5_CH1_STSRR_union_tag { /* Sync Time Stamp Read Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t STSV:24;
  } B;
} PSI5_CH1_STSRR_tag;

typedef union PSI5_CH1_DTSRR_union_tag { /* Data Time Stamp Read Register */
  vuint32_t R;
  struct {
    vuint32_t  :5;
    vuint32_t SLOT_COUNTER:3;
    vuint32_t DTSV:24;
  } B;
} PSI5_CH1_DTSRR_tag;

typedef union PSI5_CH1_SFCR_union_tag { /* Slot n Frame Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :13;
    vuint32_t SLOT_EN:1;               /* SLOT_EN */
    vuint32_t TS_CAPT:1;               /* TS_CAPT */
    vuint32_t  :1;
    vuint32_t SMCL:1;
    vuint32_t  :9;
    vuint32_t DRL:5;
    vuint32_t CRCP:1;                  /* CRCP */
  } B;
} PSI5_CH1_SFCR_tag;

typedef union PSI5_CH1_S1SBR_union_tag { /* Slot 1 Start Boundary Register */
  vuint16_t R;
  struct {
    vuint16_t  :1;
    vuint16_t S1SBT:15;
  } B;
} PSI5_CH1_S1SBR_tag;

typedef union PSI5_CH1_S2SBR_union_tag { /* Slot 2 Start Boundary Register */
  vuint16_t R;
  struct {
    vuint16_t  :1;
    vuint16_t S2SBT:15;
  } B;
} PSI5_CH1_S2SBR_tag;

typedef union PSI5_CH1_S3SBR_union_tag { /* Slot 3 Start Boundary Register */
  vuint16_t R;
  struct {
    vuint16_t  :1;
    vuint16_t S3SBT:15;
  } B;
} PSI5_CH1_S3SBR_tag;

typedef union PSI5_CH1_S4SBR_union_tag { /* Slot 4 Start Boundary Register */
  vuint16_t R;
  struct {
    vuint16_t  :1;
    vuint16_t S4SBT:15;
  } B;
} PSI5_CH1_S4SBR_tag;

typedef union PSI5_CH1_S5SBR_union_tag { /* Slot 5 Start Boundary Register */
  vuint16_t R;
  struct {
    vuint16_t  :1;
    vuint16_t S5SBT:15;
  } B;
} PSI5_CH1_S5SBR_tag;

typedef union PSI5_CH1_S6SBR_union_tag { /* Slot 6 Start Boundary Register */
  vuint16_t R;
  struct {
    vuint16_t  :1;
    vuint16_t S6SBT:15;
  } B;
} PSI5_CH1_S6SBR_tag;

typedef union PSI5_CH1_SnEBR_union_tag { /* Slot n End Boundary Register */
  vuint32_t R;
  struct {
    vuint32_t  :13;
    vuint32_t SLOT_NO:3;
    vuint32_t  :1;
    vuint32_t SnEBT:15;
  } B;
} PSI5_CH1_SnEBR_tag;

typedef union PSI5_CH1_DOBCR_union_tag { /* Data Output Block Configuration Register */
  vuint16_t R;
  struct {
    vuint16_t DATA_LENGTH:6;
    vuint16_t DBR_RST:1;
    vuint16_t DSR_RST:1;
    vuint16_t CMD_TYPE:3;
    vuint16_t DEFAULT_SYNC:1;
    vuint16_t GTM_TRIG_SEL:1;
    vuint16_t SP_PULSE_SEL:1;
    vuint16_t OP_SEL:1;
    vuint16_t SW_READY:1;
  } B;
} PSI5_CH1_DOBCR_tag;

typedef union PSI5_CH1_MDDIS_OFF_union_tag { /* Manchestor Decoder Disable Offset */
  vuint16_t R;
  struct {
    vuint16_t  :9;
    vuint16_t MDDIS_OFF:7;
  } B;
} PSI5_CH1_MDDIS_OFF_tag;

typedef union PSI5_CH1_PW0D_union_tag { /* Pulse Width for Data Bit Value 0 */
  vuint16_t R;
  struct {
    vuint16_t  :9;
    vuint16_t Pulse_Width0:7;
  } B;
} PSI5_CH1_PW0D_tag;

typedef union PSI5_CH1_PW1D_union_tag { /* Pulse Width for Data Bit Value 1 */
  vuint16_t R;
  struct {
    vuint16_t  :9;
    vuint16_t Pulse_Width1:7;
  } B;
} PSI5_CH1_PW1D_tag;

typedef union PSI5_CH1_CTPR_union_tag { /* Counter Target Pulse Register */
  vuint16_t R;
  struct {
    vuint16_t CTPR:16;
  } B;
} PSI5_CH1_CTPR_tag;

typedef union PSI5_CH1_CIPR_union_tag { /* Counter Initialize Pulse Register */
  vuint16_t R;
  struct {
    vuint16_t CIPR:16;
  } B;
} PSI5_CH1_CIPR_tag;

typedef union PSI5_CH1_DPRL_union_tag { /* Data Preparation Register Low */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t DPR:24;
  } B;
} PSI5_CH1_DPRL_tag;

typedef union PSI5_CH1_DPRH_union_tag { /* Data Preparation Register High */
  vuint32_t R;
  struct {
    vuint32_t  :32;
  } B;
} PSI5_CH1_DPRH_tag;

typedef union PSI5_CH1_DBRL_union_tag { /* Data Buffer Register Low */
  vuint32_t R;
  struct {
    vuint32_t DBR:32;
  } B;
} PSI5_CH1_DBRL_tag;

typedef union PSI5_CH1_DBRH_union_tag { /* Data Buffer Register High */
  vuint32_t R;
  struct {
    vuint32_t DBR:32;
  } B;
} PSI5_CH1_DBRH_tag;

typedef union PSI5_CH1_DSRL_union_tag { /* Data Shift Register Low */
  vuint32_t R;
  struct {
    vuint32_t DSR:32;
  } B;
} PSI5_CH1_DSRL_tag;

typedef union PSI5_CH1_DSRH_union_tag { /* Data Shift Register High */
  vuint32_t R;
  struct {
    vuint32_t DSR:32;
  } B;
} PSI5_CH1_DSRH_tag;

typedef union PSI5_CH2_PCCR_union_tag { /* PSI5 Channel Control Register */
  vuint32_t R;
  struct {
    vuint32_t CTC_GED_SEL:1;
    vuint32_t CTC_ED:1;
    vuint32_t  :1;
    vuint32_t MEM_DEPTH:5;
    vuint32_t  :3;
    vuint32_t ERROR_SELECT4:1;
    vuint32_t ERROR_SELECT3:1;
    vuint32_t ERROR_SELECT2:1;
    vuint32_t ERROR_SELECT1:1;
    vuint32_t ERROR_SELECT0:1;
    vuint32_t  :1;
    vuint32_t GTM_RESET_ASYNC_EN:1;
    vuint32_t  :3;
    vuint32_t DEBUG_EN:1;
    vuint32_t DEBUG_FREEZE_CTRL:1;
    vuint32_t SP_TS_CLK_SEL:1;
    vuint32_t  :2;
    vuint32_t FAST_CLR_SMC:1;
    vuint32_t FAST_CLR_PSI5:1;
    vuint32_t BIT_RATE:1;
    vuint32_t MODE:1;
    vuint32_t PSI5_CH_CONFIG:1;
    vuint32_t PSI5_CH_EN:1;
  } B;
} PSI5_CH2_PCCR_tag;

typedef union PSI5_CH2_DCR_union_tag { /* DMA Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :3;
    vuint32_t DMA_PM_DS_WM:5;
    vuint32_t  :5;
    vuint32_t IE_DMA_TF_SF:1;
    vuint32_t IE_DMA_TF_PM_DS:1;
    vuint32_t  :5;
    vuint32_t IE_DMA_PM_DS_FIFO_FULL:1;
    vuint32_t IE_DMA_SFUF:1;
    vuint32_t  :1;
    vuint32_t IE_DMA_PM_DS_UF:1;
    vuint32_t  :5;
    vuint32_t DMA_EN_SF:1;
    vuint32_t DMA_PM_DS_CONFIG:2;
  } B;
} PSI5_CH2_DCR_tag;

typedef union PSI5_CH2_DSR_union_tag { /* DMA Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :13;
    vuint32_t IS_DMA_TF_SF:1;
    vuint32_t IS_DMA_TF_PM_DS:1;
    vuint32_t  :5;
    vuint32_t IS_DMA_PM_DS_FIFO_FULL:1;
    vuint32_t IS_DMA_SFUF:1;
    vuint32_t  :1;
    vuint32_t IS_DMA_PM_DS_UF:1;
    vuint32_t  :8;
  } B;
} PSI5_CH2_DSR_tag;

typedef union PSI5_CH2_GICR_union_tag { /* General Interrupt Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t IE_CESM:6;
    vuint32_t IE_STS:1;
    vuint32_t IE_DTS:1;
    vuint32_t IE_DSROW:1;
    vuint32_t IE_BROW:1;
    vuint32_t IE_PROW:1;
    vuint32_t IE_DSRR:1;
    vuint32_t IE_BRR:1;
    vuint32_t IE_PRR:1;
    vuint32_t  :2;
    vuint32_t IE_OWSM:6;
    vuint32_t  :2;
    vuint32_t IE_NVSM:6;
  } B;
} PSI5_CH2_GICR_tag;

typedef union PSI5_CH2_NDICR_union_tag { /* New Data Interrupt Control Register */
  vuint32_t R;
  struct {
    vuint32_t IE_ND:32;
  } B;
} PSI5_CH2_NDICR_tag;

typedef union PSI5_CH2_OWICR_union_tag { /* Overwrite Interrupt Control Register */
  vuint32_t R;
  struct {
    vuint32_t IE_OW:32;
  } B;
} PSI5_CH2_OWICR_tag;

typedef union PSI5_CH2_EICR_union_tag { /* Error Interrupt Control Register */
  vuint32_t R;
  struct {
    vuint32_t IE_ERROR:32;
  } B;
} PSI5_CH2_EICR_tag;

typedef union PSI5_CH2_GISR_union_tag { /* General Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t IS_DB_FR:1;
    vuint32_t  :1;
    vuint32_t IS_CESM:6;
    vuint32_t IS_STS:1;
    vuint32_t IS_DTS:1;
    vuint32_t IS_DSROW:1;
    vuint32_t IS_BROW:1;
    vuint32_t IS_PROW:1;
    vuint32_t DSR_RDY:1;
    vuint32_t DBR_RDY:1;
    vuint32_t DPR_RDY:1;
    vuint32_t  :2;
    vuint32_t IS_OWSM:6;
    vuint32_t  :2;
    vuint32_t IS_NVSM:6;
  } B;
} PSI5_CH2_GISR_tag;

typedef union PSI5_CH2_DPMR_union_tag { /* DMA PSI5 Message Register */
  vuint32_t R;
  struct {
    vuint32_t PSI5_RXDATA:32;
  } B;
} PSI5_CH2_DPMR_tag;

typedef union PSI5_CH2_DSFR_union_tag { /* DMA SMC Frame Register */
  vuint32_t R;
  struct {
    vuint32_t SMC_RXDATA:32;
  } B;
} PSI5_CH2_DSFR_tag;

typedef union PSI5_CH2_DDSR_union_tag { /* DMA Diagnostic Status Register */
  vuint32_t R;
  struct {
    vuint32_t DDS:32;
  } B;
} PSI5_CH2_DDSR_tag;

typedef union PSI5_CH2_PMRRL_union_tag { /* PSI5 Message Receive Register Low */
  vuint32_t R;
  struct {
    vuint32_t DATA_REGION:28;
    vuint32_t CRC:3;
    vuint32_t C:1;
  } B;
} PSI5_CH2_PMRRL_tag;

typedef union PSI5_CH2_PMRRH_union_tag { /* PSI5 Message Receive Register High */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t F:1;
    vuint32_t EM:1;
    vuint32_t E:1;
    vuint32_t T:1;
    vuint32_t SlotCounter:3;
    vuint32_t TimeStampValue:24;
  } B;
} PSI5_CH2_PMRRH_tag;

typedef union PSI5_CH2_PMRL_union_tag { /* PSI5 Message Register Low i */
  vuint32_t R;
  struct {
    vuint32_t DATA_REGION:28;
    vuint32_t CRCP:3;
    vuint32_t C:1;
  } B;
} PSI5_CH2_PMRL_tag;

typedef union PSI5_CH2_PMRH_union_tag { /* PSI5 Message Register High i */
  vuint32_t R;
  struct {
    vuint32_t O:1;
    vuint32_t F:1;
    vuint32_t EM:1;
    vuint32_t E:1;
    vuint32_t T:1;
    vuint32_t Slot_Counter:3;
    vuint32_t TimeStampValue:24;
  } B;
} PSI5_CH2_PMRH_tag;

typedef struct PSI5_CH2_struct_tag {
  PSI5_CH2_PMRL_tag PMRL;              /* PSI5 Message Register Low i */
  PSI5_CH2_PMRH_tag PMRH;              /* PSI5 Message Register High i */
} PSI5_CH2_tag;

typedef union PSI5_CH2_SFR_union_tag { /* SMC Frame Register n */
  vuint32_t R;
  struct {
    vuint32_t SLOT_NO:3;
    vuint32_t CER:1;
    vuint32_t OW:1;
    vuint32_t CRC:6;
    vuint32_t C:1;
    vuint32_t ID:4;
    vuint32_t IDDATA:4;
    vuint32_t DATA:12;
  } B;
} PSI5_CH2_SFR_tag;

typedef union PSI5_CH2_NDSR_union_tag { /* New Data Status Register */
  vuint32_t R;
  struct {
    vuint32_t NDS:32;
  } B;
} PSI5_CH2_NDSR_tag;

typedef union PSI5_CH2_OWSR_union_tag { /* Overwrite Status Register */
  vuint32_t R;
  struct {
    vuint32_t OWS:32;
  } B;
} PSI5_CH2_OWSR_tag;

typedef union PSI5_CH2_EISR_union_tag { /* Error Indication Status Register */
  vuint32_t R;
  struct {
    vuint32_t ERROR:32;
  } B;
} PSI5_CH2_EISR_tag;

typedef union PSI5_CH2_SNDSR_union_tag { /* Set New Data Status Register */
  vuint32_t R;
  struct {
    vuint32_t SNDS:32;
  } B;
} PSI5_CH2_SNDSR_tag;

typedef union PSI5_CH2_SOWSR_union_tag { /* Set Overwrite Status Register */
  vuint32_t R;
  struct {
    vuint32_t SOWS:32;
  } B;
} PSI5_CH2_SOWSR_tag;

typedef union PSI5_CH2_SEISR_union_tag { /* Set Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t SERROR:32;
  } B;
} PSI5_CH2_SEISR_tag;

typedef union PSI5_CH2_SSESR_union_tag { /* Set SMC Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t SCESM:6;
    vuint32_t  :10;
    vuint32_t SOWSM:6;
    vuint32_t  :2;
    vuint32_t SNVSM:6;
  } B;
} PSI5_CH2_SSESR_tag;

typedef union PSI5_CH2_STSRR_union_tag { /* Sync Time Stamp Read Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t STSV:24;
  } B;
} PSI5_CH2_STSRR_tag;

typedef union PSI5_CH2_DTSRR_union_tag { /* Data Time Stamp Read Register */
  vuint32_t R;
  struct {
    vuint32_t  :5;
    vuint32_t SLOT_COUNTER:3;
    vuint32_t DTSV:24;
  } B;
} PSI5_CH2_DTSRR_tag;

typedef union PSI5_CH2_SFCR_union_tag { /* Slot n Frame Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :13;
    vuint32_t SLOT_EN:1;
    vuint32_t TS_CAPT:1;
    vuint32_t  :1;
    vuint32_t SMCL:1;
    vuint32_t  :9;
    vuint32_t DRL:5;
    vuint32_t CRCP:1;
  } B;
} PSI5_CH2_SFCR_tag;

typedef union PSI5_CH2_S1SBR_union_tag { /* Slot 1 Start Boundary Register */
  vuint16_t R;
  struct {
    vuint16_t  :1;
    vuint16_t S1SBT:15;
  } B;
} PSI5_CH2_S1SBR_tag;

typedef union PSI5_CH2_S2SBR_union_tag { /* Slot 2 Start Boundary Register */
  vuint16_t R;
  struct {
    vuint16_t  :1;
    vuint16_t S2SBT:15;
  } B;
} PSI5_CH2_S2SBR_tag;

typedef union PSI5_CH2_S3SBR_union_tag { /* Slot 3 Start Boundary Register */
  vuint16_t R;
  struct {
    vuint16_t  :1;
    vuint16_t S3SBT:15;
  } B;
} PSI5_CH2_S3SBR_tag;

typedef union PSI5_CH2_S4SBR_union_tag { /* Slot 4 Start Boundary Register */
  vuint16_t R;
  struct {
    vuint16_t  :1;
    vuint16_t S4SBT:15;
  } B;
} PSI5_CH2_S4SBR_tag;

typedef union PSI5_CH2_S5SBR_union_tag { /* Slot 5 Start Boundary Register */
  vuint16_t R;
  struct {
    vuint16_t  :1;
    vuint16_t S5SBT:15;
  } B;
} PSI5_CH2_S5SBR_tag;

typedef union PSI5_CH2_S6SBR_union_tag { /* Slot 6 Start Boundary Register */
  vuint16_t R;
  struct {
    vuint16_t  :1;
    vuint16_t S6SBT:15;
  } B;
} PSI5_CH2_S6SBR_tag;

typedef union PSI5_CH2_SnEBR_union_tag { /* Slot n End Boundary Register */
  vuint32_t R;
  struct {
    vuint32_t  :13;
    vuint32_t SLOT_NO:3;
    vuint32_t  :1;
    vuint32_t SnEBT:15;
  } B;
} PSI5_CH2_SnEBR_tag;

typedef union PSI5_CH2_DOBCR_union_tag { /* Data Output Block Configuration Register */
  vuint16_t R;
  struct {
    vuint16_t DATA_LENGTH:6;
    vuint16_t DBR_RST:1;
    vuint16_t DSR_RST:1;
    vuint16_t CMD_TYPE:3;
    vuint16_t DEFAULT_SYNC:1;
    vuint16_t GTM_TRIG_SEL:1;
    vuint16_t SP_PULSE_SEL:1;
    vuint16_t OP_SEL:1;
    vuint16_t SW_READY:1;
  } B;
} PSI5_CH2_DOBCR_tag;

typedef union PSI5_CH2_MDDIS_OFF_union_tag { /* Manchestor Decoder Disable Offset */
  vuint16_t R;
  struct {
    vuint16_t  :9;
    vuint16_t MDDIS_OFF:7;
  } B;
} PSI5_CH2_MDDIS_OFF_tag;

typedef union PSI5_CH2_PW0D_union_tag { /* Pulse Width for Data Bit Value 0 */
  vuint16_t R;
  struct {
    vuint16_t  :9;
    vuint16_t Pulse_Width0:7;
  } B;
} PSI5_CH2_PW0D_tag;

typedef union PSI5_CH2_PW1D_union_tag { /* Pulse Width for Data Bit Value 1 */
  vuint16_t R;
  struct {
    vuint16_t  :9;
    vuint16_t Pulse_Width1:7;
  } B;
} PSI5_CH2_PW1D_tag;

typedef union PSI5_CH2_CTPR_union_tag { /* Counter Target Pulse Register */
  vuint16_t R;
  struct {
    vuint16_t CTPR:16;
  } B;
} PSI5_CH2_CTPR_tag;

typedef union PSI5_CH2_CIPR_union_tag { /* Counter Initialize Pulse Register */
  vuint16_t R;
  struct {
    vuint16_t CIPR:16;
  } B;
} PSI5_CH2_CIPR_tag;

typedef union PSI5_CH2_DPRL_union_tag { /* Data Preparation Register Low */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t DPR:24;
  } B;
} PSI5_CH2_DPRL_tag;

typedef union PSI5_CH2_DPRH_union_tag { /* Data Preparation Register High */
  vuint32_t R;
  struct {
    vuint32_t  :32;
  } B;
} PSI5_CH2_DPRH_tag;

typedef union PSI5_CH2_DBRL_union_tag { /* Data Buffer Register Low */
  vuint32_t R;
  struct {
    vuint32_t DBR:32;
  } B;
} PSI5_CH2_DBRL_tag;

typedef union PSI5_CH2_DBRH_union_tag { /* Data Buffer Register High */
  vuint32_t R;
  struct {
    vuint32_t DBR:32;
  } B;
} PSI5_CH2_DBRH_tag;

typedef union PSI5_CH2_DSRL_union_tag { /* Data Shift Register Low */
  vuint32_t R;
  struct {
    vuint32_t DSR:32;
  } B;
} PSI5_CH2_DSRL_tag;

typedef union PSI5_CH2_DSRH_union_tag { /* Data Shift Register High */
  vuint32_t R;
  struct {
    vuint32_t DSR:32;
  } B;
} PSI5_CH2_DSRH_tag;

struct PSI5_tag {
  PSI5_GCR_tag GCR;                    /* Global Control Register */
  uint8_t PSI5_reserved0[6];
  PSI5_CH0_PCCR_tag CH0_PCCR;          /* PSI5 Channel Control Register */
  PSI5_CH0_DCR_tag CH0_DCR;            /* DMA Control Register */
  PSI5_CH0_DSR_tag CH0_DSR;            /* DMA Status Register */
  PSI5_CH0_GICR_tag CH0_GICR;          /* General Interrupt Control Register */
  PSI5_CH0_NDICR_tag CH0_NDICR;        /* New Data Interrupt Control Register */
  PSI5_CH0_OWICR_tag CH0_OWICR;        /* Overwrite Interrupt Control Register */
  PSI5_CH0_EICR_tag CH0_EICR;          /* Error Interrupt Control Register */
  PSI5_CH0_GISR_tag CH0_GISR;          /* General Interrupt Status Register */
  PSI5_CH0_DPMR_tag CH0_DPMR;          /* DMA PSI5 Message Register */
  PSI5_CH0_DSFR_tag CH0_DSFR;          /* DMA SMC Frame Register */
  PSI5_CH0_DDSR_tag CH0_DDSR;          /* DMA Diagnostic Status Register */
  PSI5_CH0_PMRRL_tag CH0_PMRRL;        /* PSI5 Message Receive Register Low */
  PSI5_CH0_PMRRH_tag CH0_PMRRH;        /* PSI5 Message Receive Register High */
  PSI5_CH0_tag CH0[32];
  PSI5_CH0_SFR_tag CH0_SFR[6];         /* SMC Frame Register n */
  PSI5_CH0_NDSR_tag CH0_NDSR;          /* New Data Status Register */
  PSI5_CH0_OWSR_tag CH0_OWSR;          /* Overwrite Status Register */
  PSI5_CH0_EISR_tag CH0_EISR;          /* Error Indication Status Register */
  PSI5_CH0_SNDSR_tag CH0_SNDSR;        /* Set New Data Status Register */
  PSI5_CH0_SOWSR_tag CH0_SOWSR;        /* Set Overwrite Status Register */
  PSI5_CH0_SEISR_tag CH0_SEISR;        /* Set Error Status Register */
  PSI5_CH0_SSESR_tag CH0_SSESR;        /* Set SMC Error Status Register */
  PSI5_CH0_STSRR_tag CH0_STSRR;        /* Sync Time Stamp Read Register */
  PSI5_CH0_DTSRR_tag CH0_DTSRR;        /* Data Time Stamp Read Register */
  PSI5_CH0_SFCR_tag CH0_SFCR[6];       /* Slot n Frame Configuration Register */
  PSI5_CH0_S1SBR_tag CH0_S1SBR;        /* Slot 1 Start Boundary Register */
  PSI5_CH0_S2SBR_tag CH0_S2SBR;        /* Slot 2 Start Boundary Register */
  PSI5_CH0_S3SBR_tag CH0_S3SBR;        /* Slot 3 Start Boundary Register */
  PSI5_CH0_S4SBR_tag CH0_S4SBR;        /* Slot 4 Start Boundary Register */
  PSI5_CH0_S5SBR_tag CH0_S5SBR;        /* Slot 5 Start Boundary Register */
  PSI5_CH0_S6SBR_tag CH0_S6SBR;        /* Slot 6 Start Boundary Register */
  PSI5_CH0_SnEBR_tag CH0_SnEBR;        /* Slot n End Boundary Register */
  PSI5_CH0_DOBCR_tag CH0_DOBCR;        /* Data Output Block Configuration Register */
  PSI5_CH0_MDDIS_OFF_tag CH0_MDDIS_OFF; /* Manchestor Decoder Disable Offset */
  PSI5_CH0_PW0D_tag CH0_PW0D;          /* Pulse Width for Data Bit Value 0 */
  PSI5_CH0_PW1D_tag CH0_PW1D;          /* Pulse Width for Data Bit Value 1 */
  PSI5_CH0_CTPR_tag CH0_CTPR;          /* Counter Target Pulse Register */
  PSI5_CH0_CIPR_tag CH0_CIPR;          /* Counter Initialize Pulse Register */
  PSI5_CH0_DPRL_tag CH0_DPRL;          /* Data Preparation Register Low */
  PSI5_CH0_DPRH_tag CH0_DPRH;          /* Data Preparation Register High */
  PSI5_CH0_DBRL_tag CH0_DBRL;          /* Data Buffer Register Low */
  PSI5_CH0_DBRH_tag CH0_DBRH;          /* Data Buffer Register High */
  PSI5_CH0_DSRL_tag CH0_DSRL;          /* Data Shift Register Low */
  PSI5_CH0_DSRH_tag CH0_DSRH;          /* Data Shift Register High */
  uint8_t PSI5_reserved1[4];
  PSI5_CH1_PCCR_tag CH1_PCCR;          /* PSI5 Channel Control Register */
  PSI5_CH1_DCR_tag CH1_DCR;            /* DMA Control Register */
  PSI5_CH1_DSR_tag CH1_DSR;            /* DMA Status Register */
  PSI5_CH1_GICR_tag CH1_GICR;          /* General Interrupt Control Register */
  PSI5_CH1_NDICR_tag CH1_NDICR;        /* New Data Interrupt Control Register */
  PSI5_CH1_OWICR_tag CH1_OWICR;        /* Overwrite Interrupt Control Register */
  PSI5_CH1_EICR_tag CH1_EICR;          /* Error Interrupt Control Register */
  PSI5_CH1_GISR_tag CH1_GISR;          /* General Interrupt Status Register */
  PSI5_CH1_DPMR_tag CH1_DPMR;          /* DMA PSI5 Message Register */
  PSI5_CH1_DSFR_tag CH1_DSFR;          /* DMA SMC Frame Register */
  PSI5_CH1_DDSR_tag CH1_DDSR;          /* DMA Diagnostic Status Register */
  PSI5_CH1_PMRRL_tag CH1_PMRRL;        /* PSI5 Message Receive Register Low */
  PSI5_CH1_PMRRH_tag CH1_PMRRH;        /* PSI5 Message Receive Register High */
  PSI5_CH1_tag CH1[32];
  PSI5_CH1_SFR_tag CH1_SFR[6];         /* SMC Frame Register n */
  PSI5_CH1_NDSR_tag CH1_NDSR;          /* New Data Status Register */
  PSI5_CH1_OWSR_tag CH1_OWSR;          /* Overwrite Status Register */
  PSI5_CH1_EISR_tag CH1_EISR;          /* Error Indication Status Register */
  PSI5_CH1_SNDSR_tag CH1_SNDSR;        /* Set New Data Status Register */
  PSI5_CH1_SOWSR_tag CH1_SOWSR;        /* Set Overwrite Status Register */
  PSI5_CH1_SEISR_tag CH1_SEISR;        /* Set Error Status Register */
  PSI5_CH1_SSESR_tag CH1_SSESR;        /* Set SMC Error Status Register */
  PSI5_CH1_STSRR_tag CH1_STSRR;        /* Sync Time Stamp Read Register */
  PSI5_CH1_DTSRR_tag CH1_DTSRR;        /* Data Time Stamp Read Register */
  PSI5_CH1_SFCR_tag CH1_SFCR[6];       /* Slot n Frame Configuration Register */
  PSI5_CH1_S1SBR_tag CH1_S1SBR;        /* Slot 1 Start Boundary Register */
  PSI5_CH1_S2SBR_tag CH1_S2SBR;        /* Slot 2 Start Boundary Register */
  PSI5_CH1_S3SBR_tag CH1_S3SBR;        /* Slot 3 Start Boundary Register */
  PSI5_CH1_S4SBR_tag CH1_S4SBR;        /* Slot 4 Start Boundary Register */
  PSI5_CH1_S5SBR_tag CH1_S5SBR;        /* Slot 5 Start Boundary Register */
  PSI5_CH1_S6SBR_tag CH1_S6SBR;        /* Slot 6 Start Boundary Register */
  PSI5_CH1_SnEBR_tag CH1_SnEBR;        /* Slot n End Boundary Register */
  PSI5_CH1_DOBCR_tag CH1_DOBCR;        /* Data Output Block Configuration Register */
  PSI5_CH1_MDDIS_OFF_tag CH1_MDDIS_OFF; /* Manchestor Decoder Disable Offset */
  PSI5_CH1_PW0D_tag CH1_PW0D;          /* Pulse Width for Data Bit Value 0 */
  PSI5_CH1_PW1D_tag CH1_PW1D;          /* Pulse Width for Data Bit Value 1 */
  PSI5_CH1_CTPR_tag CH1_CTPR;          /* Counter Target Pulse Register */
  PSI5_CH1_CIPR_tag CH1_CIPR;          /* Counter Initialize Pulse Register */
  PSI5_CH1_DPRL_tag CH1_DPRL;          /* Data Preparation Register Low */
  PSI5_CH1_DPRH_tag CH1_DPRH;          /* Data Preparation Register High */
  PSI5_CH1_DBRL_tag CH1_DBRL;          /* Data Buffer Register Low */
  PSI5_CH1_DBRH_tag CH1_DBRH;          /* Data Buffer Register High */
  PSI5_CH1_DSRL_tag CH1_DSRL;          /* Data Shift Register Low */
  PSI5_CH1_DSRH_tag CH1_DSRH;          /* Data Shift Register High */
  uint8_t PSI5_reserved2[4];
  PSI5_CH2_PCCR_tag CH2_PCCR;          /* PSI5 Channel Control Register */
  PSI5_CH2_DCR_tag CH2_DCR;            /* DMA Control Register */
  PSI5_CH2_DSR_tag CH2_DSR;            /* DMA Status Register */
  PSI5_CH2_GICR_tag CH2_GICR;          /* General Interrupt Control Register */
  PSI5_CH2_NDICR_tag CH2_NDICR;        /* New Data Interrupt Control Register */
  PSI5_CH2_OWICR_tag CH2_OWICR;        /* Overwrite Interrupt Control Register */
  PSI5_CH2_EICR_tag CH2_EICR;          /* Error Interrupt Control Register */
  PSI5_CH2_GISR_tag CH2_GISR;          /* General Interrupt Status Register */
  PSI5_CH2_DPMR_tag CH2_DPMR;          /* DMA PSI5 Message Register */
  PSI5_CH2_DSFR_tag CH2_DSFR;          /* DMA SMC Frame Register */
  PSI5_CH2_DDSR_tag CH2_DDSR;          /* DMA Diagnostic Status Register */
  PSI5_CH2_PMRRL_tag CH2_PMRRL;        /* PSI5 Message Receive Register Low */
  PSI5_CH2_PMRRH_tag CH2_PMRRH;        /* PSI5 Message Receive Register High */
  PSI5_CH2_tag CH2[32];
  PSI5_CH2_SFR_tag CH2_SFR[6];         /* SMC Frame Register n */
  PSI5_CH2_NDSR_tag CH2_NDSR;          /* New Data Status Register */
  PSI5_CH2_OWSR_tag CH2_OWSR;          /* Overwrite Status Register */
  PSI5_CH2_EISR_tag CH2_EISR;          /* Error Indication Status Register */
  PSI5_CH2_SNDSR_tag CH2_SNDSR;        /* Set New Data Status Register */
  PSI5_CH2_SOWSR_tag CH2_SOWSR;        /* Set Overwrite Status Register */
  PSI5_CH2_SEISR_tag CH2_SEISR;        /* Set Error Status Register */
  PSI5_CH2_SSESR_tag CH2_SSESR;        /* Set SMC Error Status Register */
  PSI5_CH2_STSRR_tag CH2_STSRR;        /* Sync Time Stamp Read Register */
  PSI5_CH2_DTSRR_tag CH2_DTSRR;        /* Data Time Stamp Read Register */
  PSI5_CH2_SFCR_tag CH2_SFCR[6];       /* Slot n Frame Configuration Register */
  PSI5_CH2_S1SBR_tag CH2_S1SBR;        /* Slot 1 Start Boundary Register */
  PSI5_CH2_S2SBR_tag CH2_S2SBR;        /* Slot 2 Start Boundary Register */
  PSI5_CH2_S3SBR_tag CH2_S3SBR;        /* Slot 3 Start Boundary Register */
  PSI5_CH2_S4SBR_tag CH2_S4SBR;        /* Slot 4 Start Boundary Register */
  PSI5_CH2_S5SBR_tag CH2_S5SBR;        /* Slot 5 Start Boundary Register */
  PSI5_CH2_S6SBR_tag CH2_S6SBR;        /* Slot 6 Start Boundary Register */
  PSI5_CH2_SnEBR_tag CH2_SnEBR;        /* Slot n End Boundary Register */
  PSI5_CH2_DOBCR_tag CH2_DOBCR;        /* Data Output Block Configuration Register */
  PSI5_CH2_MDDIS_OFF_tag CH2_MDDIS_OFF; /* Manchestor Decoder Disable Offset */
  PSI5_CH2_PW0D_tag CH2_PW0D;          /* Pulse Width for Data Bit Value 0 */
  PSI5_CH2_PW1D_tag CH2_PW1D;          /* Pulse Width for Data Bit Value 1 */
  PSI5_CH2_CTPR_tag CH2_CTPR;          /* Counter Target Pulse Register */
  PSI5_CH2_CIPR_tag CH2_CIPR;          /* Counter Initialize Pulse Register */
  PSI5_CH2_DPRL_tag CH2_DPRL;          /* Data Preparation Register Low */
  PSI5_CH2_DPRH_tag CH2_DPRH;          /* Data Preparation Register High */
  PSI5_CH2_DBRL_tag CH2_DBRL;          /* Data Buffer Register Low */
  PSI5_CH2_DBRH_tag CH2_DBRH;          /* Data Buffer Register High */
  PSI5_CH2_DSRL_tag CH2_DSRL;          /* Data Shift Register Low */
  PSI5_CH2_DSRH_tag CH2_DSRH;          /* Data Shift Register High */
};


/* ============================================================================
   =============================== Module: PSI5S ==============================
   ============================================================================ */

typedef union PSI5S_LINCR1_union_tag { /* PSI5-S LIN Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :19;
    vuint32_t AUTOWU:1;
    vuint32_t  :4;
    vuint32_t  :1;
    vuint32_t SLFM:1;
    vuint32_t LBKM:1;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t RBLM:1;
    vuint32_t SLEEP:1;
    vuint32_t INIT:1;
  } B;
} PSI5S_LINCR1_tag;

typedef union PSI5S_LINIER_union_tag { /* PSI5-S LIN Interrupt enable register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t SZIE:1;
    vuint32_t OCIE:1;
    vuint32_t  :5;
    vuint32_t FEIE:1;
    vuint32_t BOIE:1;
    vuint32_t  :1;
    vuint32_t WUIE:1;
    vuint32_t  :1;
    vuint32_t TOIE:1;
    vuint32_t DRIE:1;
    vuint32_t DTIE:1;
    vuint32_t  :1;
  } B;
} PSI5S_LINIER_tag;

typedef union PSI5S_LINSR_union_tag {  /* PSI5-S LIN Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t LINS3:1;
    vuint32_t LINS2:1;
    vuint32_t LINS1:1;
    vuint32_t LINS0:1;
    vuint32_t  :5;
    vuint32_t  :1;
    vuint32_t  :6;
  } B;
} PSI5S_LINSR_tag;

typedef union PSI5S_UARTCR_union_tag { /* PSI5-S UART Mode Control Register */
  vuint32_t R;
  struct {
    vuint32_t MIS:1;
    vuint32_t CSP:3;
    vuint32_t OSR:4;
    vuint32_t ROSE:1;
    vuint32_t NEF:3;
    vuint32_t PCE_TXDTU:1;
    vuint32_t SBUR:2;
    vuint32_t WLS:1;
    vuint32_t TDFLTFC:3;
    vuint32_t RDFLRFC:3;
    vuint32_t RFBM:1;
    vuint32_t TFBM:1;
    vuint32_t WL1:1;
    vuint32_t PC1:1;
    vuint32_t RxEn:1;
    vuint32_t TxEn:1;
    vuint32_t PC0:1;
    vuint32_t PCE_Rx:1;
    vuint32_t WL0:1;
    vuint32_t UART:1;
  } B;
} PSI5S_UARTCR_tag;

typedef union PSI5S_UARTSR_union_tag { /* PSI5-S UART Mode Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t SZF:1;
    vuint32_t OCF:1;
    vuint32_t PE3:1;
    vuint32_t PE2:1;
    vuint32_t PE1:1;
    vuint32_t PE0:1;
    vuint32_t RMB:1;
    vuint32_t FEF:1;
    vuint32_t BOF:1;
    vuint32_t RDI:1;
    vuint32_t WUF:1;
    vuint32_t RFNE:1;
    vuint32_t TO:1;
    vuint32_t DRF:1;
    vuint32_t DTF:1;
    vuint32_t NF:1;
  } B;
} PSI5S_UARTSR_tag;

typedef union PSI5S_LINFBRR_union_tag { /* PSI5-S LIN Fractional Baud Rate Register */
  vuint32_t R;
  struct {
    vuint32_t  :28;
    vuint32_t FBR:4;
  } B;
} PSI5S_LINFBRR_tag;

typedef union PSI5S_LINIBRR_union_tag { /* PSI5-S LIN Integer Baud Rate Register */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t IBR:20;
  } B;
} PSI5S_LINIBRR_tag;

typedef union PSI5S_LINCR2_union_tag { /* PSI5-S LIN Control Register 2 */
  vuint32_t R;
  struct {
    vuint32_t  :17;
    vuint32_t  :1;
    vuint32_t  :4;
    vuint32_t ABRQ:1;
    vuint32_t  :9;
  } B;
} PSI5S_LINCR2_tag;

typedef union PSI5S_BDRL_union_tag {   /* PSI5-S Buffer Data Register Least Significant */
  vuint32_t R;
  struct {
    vuint32_t DATA_TX3:8;
    vuint32_t DATA_TX2:8;
    vuint32_t DATA_TX1:8;
    vuint32_t DATA_TX0:8;
  } B;
} PSI5S_BDRL_tag;

typedef union PSI5S_BDRM_union_tag {   /* PSI5-S Buffer Data Register Most Significant */
  vuint32_t R;
  struct {
    vuint32_t DATA_RX3:8;
    vuint32_t DATA_RX2:8;
    vuint32_t DATA_RX1:8;
    vuint32_t DATA_RX0:8;
  } B;
} PSI5S_BDRM_tag;

typedef union PSI5S_GCR_union_tag {    /* PSI5-S Global Control register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t TDFBM:1;
    vuint32_t RDFBM:1;
    vuint32_t TDLIS:1;
    vuint32_t RDLIS:1;
    vuint32_t STOP:1;
    vuint32_t SR:1;
  } B;
} PSI5S_GCR_tag;

typedef union PSI5S_UARTPTO_union_tag { /* PSI5-S UART Preset Timeout Register */
  vuint32_t R;
  struct {
    vuint32_t  :20;
    vuint32_t PTO:12;
  } B;
} PSI5S_UARTPTO_tag;

typedef union PSI5S_UARTCTO_union_tag { /* UPSI5-S ART Current Timeout register */
  vuint32_t R;
  struct {
    vuint32_t  :20;
    vuint32_t CTO:12;
  } B;
} PSI5S_UARTCTO_tag;

typedef union PSI5S_DMATXE_union_tag { /* DMA Tx Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t DTE0:1;
  } B;
} PSI5S_DMATXE_tag;

typedef union PSI5S_DMARXE_union_tag { /* DMA Rx Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t DRE0:1;
  } B;
} PSI5S_DMARXE_tag;

typedef union PSI5S_PTD_union_tag {    /* PSI5-S UART Tx Idle Delay Time Register */
  vuint32_t R;
  struct {
    vuint32_t  :27;
    vuint32_t IFD:4;
    vuint32_t EN:1;
  } B;
} PSI5S_PTD_tag;

typedef union PSI5S_GLCR_union_tag {   /* PSI5-S Global Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t DIRCMD_LEN:2;
    vuint32_t  :1;
    vuint32_t IE_DIRCMD_RDY:1;
    vuint32_t  :1;
    vuint32_t DEBUG_EN:1;
    vuint32_t GTM_TRIG_SEL:2;
    vuint32_t GL_DDSR_TRIG:1;
    vuint32_t GL_MODETR_DONE_EN:1;
    vuint32_t MRU_ERR_EN:1;
    vuint32_t TSCS_B:1;
    vuint32_t TSCS_A:1;
    vuint32_t CLR_CNTR_B:1;
    vuint32_t CLR_CNTR_A:1;
    vuint32_t CLRTSCNT_G:1;
    vuint32_t CLRTSCNT_G_L:1;
    vuint32_t TSCNT_EN_B:1;
    vuint32_t TSCNT_EN_A:1;
    vuint32_t TSCNTEN_G:1;
    vuint32_t TSCNTEN_G_L:1;
    vuint32_t GLOBAL_MODE:3;
  } B;
} PSI5S_GLCR_tag;

typedef union PSI5S_GLSR_union_tag {   /* PSI5-S Global Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :11;
    vuint32_t DIRCMD_RDY:1;
    vuint32_t  :5;
    vuint32_t GL_MODETR_DONE:1;
    vuint32_t MRU_ERR:1;
    vuint32_t  :7;
    vuint32_t FID:3;
    vuint32_t CHID:3;
  } B;
} PSI5S_GLSR_tag;

typedef union PSI5S_CH_BASE_ADDR_union_tag { /* PSI5-S CHANNEL_BASE_ADDRESS */
  vuint32_t R;
  struct {
    vuint32_t MAILBOX_BASE_ADDR:32;
  } B;
} PSI5S_CH_BASE_ADDR_tag;

typedef union PSI5S_MRU_BUF2_REG0_union_tag { /* PSI5-S MRU OUTPUT BUFFER2 REGISTER0 */
  vuint32_t R;
  struct {
    vuint32_t CHANNEL_SPECIFIC_MAILBOX_ADDR:32;
  } B;
} PSI5S_MRU_BUF2_REG0_tag;

typedef union PSI5S_MRU_BUF2_REG1_union_tag { /* PSI5-S MRU OUTPUT BUFFER2 REGISTER1 */
  vuint32_t R;
  struct {
    vuint32_t DCI:4;
    vuint32_t  :1;
    vuint32_t R_UVL_ERR:1;
    vuint32_t N_ERR:1;
    vuint32_t CHID:3;
    vuint32_t FID:3;
    vuint32_t R_OVL_ERR:1;
    vuint32_t F_WD_ERR:1;
    vuint32_t SCI_O_ERR:1;
    vuint32_t SCI_F_ERR:1;
    vuint32_t SCI_P_ERR:1;
    vuint32_t HD_ERR:1;
    vuint32_t ERR:2;
    vuint32_t CRC_ERR_P_ERR:1;
    vuint32_t CRC:3;
    vuint32_t XCRC_ERR:1;
    vuint32_t XCRC:6;
  } B;
} PSI5S_MRU_BUF2_REG1_tag;

typedef union PSI5S_MRU_BUF2_REG2_union_tag { /* PSI5-S MRU OUTPUT BUFFER2 REGISTER2 */
  vuint32_t R;
  struct {
    vuint32_t DCI:4;
    vuint32_t PS_DATA:28;
  } B;
} PSI5S_MRU_BUF2_REG2_tag;

typedef union PSI5S_MRU_BUF2_REG3_union_tag { /* PSI5-S MRU OUTPUT BUFFER2 REGISTER3 */
  vuint32_t R;
  struct {
    vuint32_t DCI:4;
    vuint32_t  :4;
    vuint32_t TIMESTAMP:24;
  } B;
} PSI5S_MRU_BUF2_REG3_tag;

typedef union PSI5S_MBOX_SR_IRQ_union_tag { /* PSI5-S Mbox Status Irq */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t MBOX_CH7:1;
    vuint32_t MBOX_CH6:1;
    vuint32_t MBOX_CH5:1;
    vuint32_t MBOX_CH4:1;
    vuint32_t MBOX_CH3:1;
    vuint32_t MBOX_CH2:1;
    vuint32_t MBOX_CH1:1;
    vuint32_t MBOX_CH0:1;
  } B;
} PSI5S_MBOX_SR_IRQ_tag;

typedef union PSI5S_ERR_SR_IRQ_union_tag { /* PSI5-S Error Status Irq */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t R_UVL_ERR:1;
    vuint32_t N_ERR:1;
    vuint32_t R_OVL_ERR:1;
    vuint32_t F_WD_ERR:1;
    vuint32_t SCI_O_ERR:1;
    vuint32_t SCI_F_ERR:1;
    vuint32_t SCI_P_ERR:1;
    vuint32_t HD_ERR:1;
    vuint32_t CRC_ERR_P_ERR:1;
    vuint32_t XCRC_ERR:1;
  } B;
} PSI5S_ERR_SR_IRQ_tag;

typedef union PSI5S_SEL_IRQ_MBOX_union_tag { /* PSI5-S Mailbox select IRQ[irq_n] */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t MBOX_CH7_SEL:1;
    vuint32_t MBOX_CH6_SEL:1;
    vuint32_t MBOX_CH5_SEL:1;
    vuint32_t MBOX_CH4_SEL:1;
    vuint32_t MBOX_CH3_SEL:1;
    vuint32_t MBOX_CH2_SEL:1;
    vuint32_t MBOX_CH1_SEL:1;
    vuint32_t MBOX_CH0_SEL:1;
  } B;
} PSI5S_SEL_IRQ_MBOX_tag;

typedef union PSI5S_SEL_IRQ_ERR_union_tag { /* PSI5-S Error Select IRQ[iq_n] */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t R_UVL_ERR_SEL:1;
    vuint32_t N_ERR_SEL:1;
    vuint32_t R_OVL_ERR_SEL:1;
    vuint32_t F_WD_ERR_SEL:1;
    vuint32_t SCI_O_ERR_SEL:1;
    vuint32_t SCI_F_ERR_SEL:1;
    vuint32_t SCI_P_ERR_SEL:1;
    vuint32_t HD_ERR_SEL:1;
    vuint32_t CRC_ERR_SEL:1;
    vuint32_t XCRC_ERR_SEL:1;
  } B;
} PSI5S_SEL_IRQ_ERR_tag;

typedef struct PSI5S_SEL_IRQ_struct_tag {
  PSI5S_SEL_IRQ_MBOX_tag MBOX;         /* PSI5-S Mailbox select IRQ[irq_n] */
  PSI5S_SEL_IRQ_ERR_tag ERR;           /* PSI5-S Error Select IRQ[iq_n] */
} PSI5S_SEL_IRQ_tag;

typedef union PSI5S_WDGTSSR_union_tag { /* PSI5-S Watchdog Error Status and Watchdog Timestamp status register */
  vuint32_t R;
  struct {
    vuint32_t F_WD_ERR_STATUS:7;
    vuint32_t  :1;
    vuint32_t WDTS_STATUS:24;
  } B;
} PSI5S_WDGTSSR_tag;

typedef union PSI5S_DIRCMD_union_tag { /* PSI5-S ECU to Sensor Direct Command Write register */
  vuint32_t R;
  struct {
    vuint32_t DIRCMD_BYTE3:8;
    vuint32_t DIRCMD_BYTE2:8;
    vuint32_t DIRCMD_BYTE1:8;
    vuint32_t DIRCMD_BYTE0:8;
  } B;
} PSI5S_DIRCMD_tag;

typedef union PSI5S_MSGA_CH0_union_tag { /* PSI5-S channel 0 message configuration register A */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t F0_BYTE:3;
    vuint32_t  :2;
    vuint32_t TIMESTAMP_A_B_SEL:1;
    vuint32_t  :1;
    vuint32_t TSBUF_CLR:1;
    vuint32_t TSBUF_EN:1;
    vuint32_t  :2;
  } B;
} PSI5S_MSGA_CH0_tag;

typedef union PSI5S_MSGB_CH0_union_tag { /* PSI5-S channel 0 message configuration register B */
  vuint32_t R;
  struct {
    vuint32_t  :27;
    vuint32_t F0_payload:5;
  } B;
} PSI5S_MSGB_CH0_tag;

typedef union PSI5S_MBOX_SR_CH0_union_tag { /* PSI5-S Mailbox status register channel0 */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t F1_ERR:1;
    vuint32_t F1_OV:1;
    vuint32_t F1_READ:1;
    vuint32_t F0_ERR:1;
    vuint32_t F0_OV:1;
    vuint32_t F0_READ:1;
  } B;
} PSI5S_MBOX_SR_CH0_tag;

typedef union PSI5S_MSGA_CH1_union_tag { /* PSI5-S channel message configuration register A */
  vuint32_t R;
  struct {
    vuint32_t L_PC_EN:1;
    vuint32_t F5_BYTE:3;
    vuint32_t L_PC5:1;
    vuint32_t F4_BYTE:3;
    vuint32_t L_PC4:1;
    vuint32_t F3_BYTE:3;
    vuint32_t L_PC3:1;
    vuint32_t F2_BYTE:3;
    vuint32_t L_PC2:1;
    vuint32_t F1_BYTE:3;
    vuint32_t L_PC1:1;
    vuint32_t F0_BYTE:3;
    vuint32_t L_PC0:1;
    vuint32_t MODE:1;
    vuint32_t TIME_STAMP_A_B_SEL:1;
    vuint32_t TMSG_TCMD:1;
    vuint32_t TSBUF_CLR:1;
    vuint32_t TSBUF_EN:1;
    vuint32_t G_PC:1;
    vuint32_t CH_EN:1;
  } B;
} PSI5S_MSGA_CH1_tag;

typedef union PSI5S_MSGB_CH1_union_tag { /* PSI5-S channel message configuration register B */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t F5_payload:5;
    vuint32_t F4_payload:5;
    vuint32_t F3_payload:5;
    vuint32_t F2_payload:5;
    vuint32_t F1_payload:5;
    vuint32_t F0_payload:5;
  } B;
} PSI5S_MSGB_CH1_tag;

typedef union PSI5S_MBOX_SR_CH1_union_tag { /* PSI5-S Mailbox status register channel */
  vuint32_t R;
  struct {
    vuint32_t  :14;
    vuint32_t F5_ERR:1;
    vuint32_t F5_OV:1;
    vuint32_t F5_READ:1;
    vuint32_t F4_ERR:1;
    vuint32_t F4_OV:1;
    vuint32_t F4_READ:1;
    vuint32_t F3_ERR:1;
    vuint32_t F3_OV:1;
    vuint32_t F3_READ:1;
    vuint32_t F2_ERR:1;
    vuint32_t F2_OV:1;
    vuint32_t F2_READ:1;
    vuint32_t F1_ERR:1;
    vuint32_t F1_OV:1;
    vuint32_t F1_READ:1;
    vuint32_t F0_ERR:1;
    vuint32_t F0_OV:1;
    vuint32_t F0_READ:1;
  } B;
} PSI5S_MBOX_SR_CH1_tag;

typedef union PSI5S_WD_CFGR_CH1_union_tag { /* PSI5-S channel watchdog configuration register */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t WDRST:1;
    vuint32_t WDCS:1;
    vuint32_t WDEN:1;
    vuint32_t  :1;
    vuint32_t WD_TO:24;
  } B;
} PSI5S_WD_CFGR_CH1_tag;

typedef union PSI5S_DDTRIG_OFFR_CH1_union_tag { /* PSI5-S DDSR Trigger offset register channel */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t DDTRIG_OFFR:16;
  } B;
} PSI5S_DDTRIG_OFFR_CH1_tag;

typedef union PSI5S_DDTRIG_PERR_CH1_union_tag { /* PSI5-S DDSR Trigger period register channel */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t DDTRIG_PERR:16;
  } B;
} PSI5S_DDTRIG_PERR_CH1_tag;

typedef union PSI5S_E2SCR_CH1_union_tag { /* PSI5-S ECU to Sensor Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t CMD:5;
    vuint32_t  :1;
    vuint32_t ACMD:5;
    vuint32_t  :2;
    vuint32_t CH_TRIG:1;
    vuint32_t GL_TRIG_SEL:1;
    vuint32_t DEFAULT_SYNC:1;
    vuint32_t DDSR_SHIFT_SEL:1;
    vuint32_t DDSR_CLR:1;
    vuint32_t DDSR_CLK_SEL:1;
    vuint32_t CMDTR_SW_CTRL:1;
    vuint32_t  :1;
    vuint32_t SYNCHRO_OVF_IE:1;
    vuint32_t  :1;
    vuint32_t CMDTR_NWRT_IE:1;
    vuint32_t CMDPR_BZY_IE:1;
    vuint32_t DDSR_RDY_IE:1;
    vuint32_t  :2;
    vuint32_t CMD_TYPE:3;
  } B;
} PSI5S_E2SCR_CH1_tag;

typedef union PSI5S_E2SSR_CH1_union_tag { /* PSI5-S ECU to Sensor Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t SYCHRO_OVF:1;
    vuint32_t  :1;
    vuint32_t CMDTR_NWRT:1;
    vuint32_t CMDPR_BZY:1;
    vuint32_t DDSR_RDY:1;
    vuint32_t  :5;
  } B;
} PSI5S_E2SSR_CH1_tag;

typedef union PSI5S_DDSR_H_CH1_union_tag { /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register High */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t DDSR_H:11;
  } B;
} PSI5S_DDSR_H_CH1_tag;

typedef union PSI5S_DDSR_L_CH1_union_tag { /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register Low */
  vuint32_t R;
  struct {
    vuint32_t DDSR_L1:8;
    vuint32_t DDSR_L2:24;
  } B;
} PSI5S_DDSR_L_CH1_tag;

typedef union PSI5S_MSGA_CH2_union_tag { /* PSI5-S channel message configuration register A */
  vuint32_t R;
  struct {
    vuint32_t L_PC_EN:1;
    vuint32_t F5_BYTE:3;
    vuint32_t L_PC5:1;
    vuint32_t F4_BYTE:3;
    vuint32_t L_PC4:1;
    vuint32_t F3_BYTE:3;
    vuint32_t L_PC3:1;
    vuint32_t F2_BYTE:3;
    vuint32_t L_PC2:1;
    vuint32_t F1_BYTE:3;
    vuint32_t L_PC1:1;
    vuint32_t F0_BYTE:3;
    vuint32_t L_PC0:1;
    vuint32_t MODE:1;
    vuint32_t TIME_STAMP_A_B_SEL:1;
    vuint32_t TMSG_TCMD:1;
    vuint32_t TSBUF_CLR:1;
    vuint32_t TSBUF_EN:1;
    vuint32_t G_PC:1;
    vuint32_t CH_EN:1;
  } B;
} PSI5S_MSGA_CH2_tag;

typedef union PSI5S_MSGB_CH2_union_tag { /* PSI5-S channel message configuration register B */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t F5_payload:5;
    vuint32_t F4_payload:5;
    vuint32_t F3_payload:5;
    vuint32_t F2_payload:5;
    vuint32_t F1_payload:5;
    vuint32_t F0_payload:5;
  } B;
} PSI5S_MSGB_CH2_tag;

typedef union PSI5S_MBOX_SR_CH2_union_tag { /* PSI5-S Mailbox status register channel */
  vuint32_t R;
  struct {
    vuint32_t  :14;
    vuint32_t F5_ERR:1;
    vuint32_t F5_OV:1;
    vuint32_t F5_READ:1;
    vuint32_t F4_ERR:1;
    vuint32_t F4_OV:1;
    vuint32_t F4_READ:1;
    vuint32_t F3_ERR:1;
    vuint32_t F3_OV:1;
    vuint32_t F3_READ:1;
    vuint32_t F2_ERR:1;
    vuint32_t F2_OV:1;
    vuint32_t F2_READ:1;
    vuint32_t F1_ERR:1;
    vuint32_t F1_OV:1;
    vuint32_t F1_READ:1;
    vuint32_t F0_ERR:1;
    vuint32_t F0_OV:1;
    vuint32_t F0_READ:1;
  } B;
} PSI5S_MBOX_SR_CH2_tag;

typedef union PSI5S_WD_CFGR_CH2_union_tag { /* PSI5-S channel watchdog configuration register */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t WDRST:1;
    vuint32_t WDCS:1;
    vuint32_t WDEN:1;
    vuint32_t  :1;
    vuint32_t WD_TO:24;
  } B;
} PSI5S_WD_CFGR_CH2_tag;

typedef union PSI5S_DDTRIG_OFFR_CH2_union_tag { /* PSI5-S DDSR Trigger offset register channel */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t DDTRIG_OFFR:16;
  } B;
} PSI5S_DDTRIG_OFFR_CH2_tag;

typedef union PSI5S_DDTRIG_PERR_CH2_union_tag { /* PSI5-S DDSR Trigger period register channel */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t DDTRIG_PERR:16;
  } B;
} PSI5S_DDTRIG_PERR_CH2_tag;

typedef union PSI5S_E2SCR_CH2_union_tag { /* PSI5-S ECU to Sensor Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t CMD:5;
    vuint32_t  :1;
    vuint32_t ACMD:5;
    vuint32_t  :2;
    vuint32_t CH_TRIG:1;
    vuint32_t GL_TRIG_SEL:1;
    vuint32_t DEFAULT_SYNC:1;
    vuint32_t DDSR_SHIFT_SEL:1;
    vuint32_t DDSR_CLR:1;
    vuint32_t DDSR_CLK_SEL:1;
    vuint32_t CMDTR_SW_CTRL:1;
    vuint32_t  :1;
    vuint32_t SYNCHRO_OVF_IE:1;
    vuint32_t  :1;
    vuint32_t CMDTR_NWRT_IE:1;
    vuint32_t CMDPR_BZY_IE:1;
    vuint32_t DDSR_RDY_IE:1;
    vuint32_t  :2;
    vuint32_t CMD_TYPE:3;
  } B;
} PSI5S_E2SCR_CH2_tag;

typedef union PSI5S_E2SSR_CH2_union_tag { /* PSI5-S ECU to Sensor Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t SYCHRO_OVF:1;
    vuint32_t  :1;
    vuint32_t CMDTR_NWRT:1;
    vuint32_t CMDPR_BZY:1;
    vuint32_t DDSR_RDY:1;
    vuint32_t  :5;
  } B;
} PSI5S_E2SSR_CH2_tag;

typedef union PSI5S_DDSR_H_CH2_union_tag { /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register High */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t DDSR_H:11;
  } B;
} PSI5S_DDSR_H_CH2_tag;

typedef union PSI5S_DDSR_L_CH2_union_tag { /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register Low */
  vuint32_t R;
  struct {
    vuint32_t DDSR_L1:8;
    vuint32_t DDSR_L2:24;
  } B;
} PSI5S_DDSR_L_CH2_tag;

typedef union PSI5S_MSGA_CH3_union_tag { /* PSI5-S channel message configuration register A */
  vuint32_t R;
  struct {
    vuint32_t L_PC_EN:1;
    vuint32_t F5_BYTE:3;
    vuint32_t L_PC5:1;
    vuint32_t F4_BYTE:3;
    vuint32_t L_PC4:1;
    vuint32_t F3_BYTE:3;
    vuint32_t L_PC3:1;
    vuint32_t F2_BYTE:3;
    vuint32_t L_PC2:1;
    vuint32_t F1_BYTE:3;
    vuint32_t L_PC1:1;
    vuint32_t F0_BYTE:3;
    vuint32_t L_PC0:1;
    vuint32_t MODE:1;
    vuint32_t TIME_STAMP_A_B_SEL:1;
    vuint32_t TMSG_TCMD:1;
    vuint32_t TSBUF_CLR:1;
    vuint32_t TSBUF_EN:1;
    vuint32_t G_PC:1;
    vuint32_t CH_EN:1;
  } B;
} PSI5S_MSGA_CH3_tag;

typedef union PSI5S_MSGB_CH3_union_tag { /* PSI5-S channel message configuration register B */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t F5_payload:5;
    vuint32_t F4_payload:5;
    vuint32_t F3_payload:5;
    vuint32_t F2_payload:5;
    vuint32_t F1_payload:5;
    vuint32_t F0_payload:5;
  } B;
} PSI5S_MSGB_CH3_tag;

typedef union PSI5S_MBOX_SR_CH3_union_tag { /* PSI5-S Mailbox status register channel */
  vuint32_t R;
  struct {
    vuint32_t  :14;
    vuint32_t F5_ERR:1;
    vuint32_t F5_OV:1;
    vuint32_t F5_READ:1;
    vuint32_t F4_ERR:1;
    vuint32_t F4_OV:1;
    vuint32_t F4_READ:1;
    vuint32_t F3_ERR:1;
    vuint32_t F3_OV:1;
    vuint32_t F3_READ:1;
    vuint32_t F2_ERR:1;
    vuint32_t F2_OV:1;
    vuint32_t F2_READ:1;
    vuint32_t F1_ERR:1;
    vuint32_t F1_OV:1;
    vuint32_t F1_READ:1;
    vuint32_t F0_ERR:1;
    vuint32_t F0_OV:1;
    vuint32_t F0_READ:1;
  } B;
} PSI5S_MBOX_SR_CH3_tag;

typedef union PSI5S_WD_CFGR_CH3_union_tag { /* PSI5-S channel watchdog configuration register */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t WDRST:1;
    vuint32_t WDCS:1;
    vuint32_t WDEN:1;
    vuint32_t  :1;
    vuint32_t WD_TO:24;
  } B;
} PSI5S_WD_CFGR_CH3_tag;

typedef union PSI5S_DDTRIG_OFFR_CH3_union_tag { /* PSI5-S DDSR Trigger offset register channel */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t DDTRIG_OFFR:16;
  } B;
} PSI5S_DDTRIG_OFFR_CH3_tag;

typedef union PSI5S_DDTRIG_PERR_CH3_union_tag { /* PSI5-S DDSR Trigger period register channel */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t DDTRIG_PERR:16;
  } B;
} PSI5S_DDTRIG_PERR_CH3_tag;

typedef union PSI5S_E2SCR_CH3_union_tag { /* PSI5-S ECU to Sensor Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t CMD:5;
    vuint32_t  :1;
    vuint32_t ACMD:5;
    vuint32_t  :2;
    vuint32_t CH_TRIG:1;
    vuint32_t GL_TRIG_SEL:1;
    vuint32_t DEFAULT_SYNC:1;
    vuint32_t DDSR_SHIFT_SEL:1;
    vuint32_t DDSR_CLR:1;
    vuint32_t DDSR_CLK_SEL:1;
    vuint32_t CMDTR_SW_CTRL:1;
    vuint32_t  :1;
    vuint32_t SYNCHRO_OVF_IE:1;
    vuint32_t  :1;
    vuint32_t CMDTR_NWRT_IE:1;
    vuint32_t CMDPR_BZY_IE:1;
    vuint32_t DDSR_RDY_IE:1;
    vuint32_t  :2;
    vuint32_t CMD_TYPE:3;
  } B;
} PSI5S_E2SCR_CH3_tag;

typedef union PSI5S_E2SSR_CH3_union_tag { /* PSI5-S ECU to Sensor Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t SYCHRO_OVF:1;
    vuint32_t  :1;
    vuint32_t CMDTR_NWRT:1;
    vuint32_t CMDPR_BZY:1;
    vuint32_t DDSR_RDY:1;
    vuint32_t  :5;
  } B;
} PSI5S_E2SSR_CH3_tag;

typedef union PSI5S_DDSR_H_CH3_union_tag { /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register High */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t DDSR_H:11;
  } B;
} PSI5S_DDSR_H_CH3_tag;

typedef union PSI5S_DDSR_L_CH3_union_tag { /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register Low */
  vuint32_t R;
  struct {
    vuint32_t DDSR_L1:8;
    vuint32_t DDSR_L2:24;
  } B;
} PSI5S_DDSR_L_CH3_tag;

typedef union PSI5S_MSGA_CH4_union_tag { /* PSI5-S channel message configuration register A */
  vuint32_t R;
  struct {
    vuint32_t L_PC_EN:1;
    vuint32_t F5_BYTE:3;
    vuint32_t L_PC5:1;
    vuint32_t F4_BYTE:3;
    vuint32_t L_PC4:1;
    vuint32_t F3_BYTE:3;
    vuint32_t L_PC3:1;
    vuint32_t F2_BYTE:3;
    vuint32_t L_PC2:1;
    vuint32_t F1_BYTE:3;
    vuint32_t L_PC1:1;
    vuint32_t F0_BYTE:3;
    vuint32_t L_PC0:1;
    vuint32_t MODE:1;
    vuint32_t TIME_STAMP_A_B_SEL:1;
    vuint32_t TMSG_TCMD:1;
    vuint32_t TSBUF_CLR:1;
    vuint32_t TSBUF_EN:1;
    vuint32_t G_PC:1;
    vuint32_t CH_EN:1;
  } B;
} PSI5S_MSGA_CH4_tag;

typedef union PSI5S_MSGB_CH4_union_tag { /* PSI5-S channel message configuration register B */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t F5_payload:5;
    vuint32_t F4_payload:5;
    vuint32_t F3_payload:5;
    vuint32_t F2_payload:5;
    vuint32_t F1_payload:5;
    vuint32_t F0_payload:5;
  } B;
} PSI5S_MSGB_CH4_tag;

typedef union PSI5S_MBOX_SR_CH4_union_tag { /* PSI5-S Mailbox status register channel */
  vuint32_t R;
  struct {
    vuint32_t  :14;
    vuint32_t F5_ERR:1;
    vuint32_t F5_OV:1;
    vuint32_t F5_READ:1;
    vuint32_t F4_ERR:1;
    vuint32_t F4_OV:1;
    vuint32_t F4_READ:1;
    vuint32_t F3_ERR:1;
    vuint32_t F3_OV:1;
    vuint32_t F3_READ:1;
    vuint32_t F2_ERR:1;
    vuint32_t F2_OV:1;
    vuint32_t F2_READ:1;
    vuint32_t F1_ERR:1;
    vuint32_t F1_OV:1;
    vuint32_t F1_READ:1;
    vuint32_t F0_ERR:1;
    vuint32_t F0_OV:1;
    vuint32_t F0_READ:1;
  } B;
} PSI5S_MBOX_SR_CH4_tag;

typedef union PSI5S_WD_CFGR_CH4_union_tag { /* PSI5-S channel watchdog configuration register */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t WDRST:1;
    vuint32_t WDCS:1;
    vuint32_t WDEN:1;
    vuint32_t  :1;
    vuint32_t WD_TO:24;
  } B;
} PSI5S_WD_CFGR_CH4_tag;

typedef union PSI5S_DDTRIG_OFFR_CH4_union_tag { /* PSI5-S DDSR Trigger offset register channel */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t DDTRIG_OFFR:16;
  } B;
} PSI5S_DDTRIG_OFFR_CH4_tag;

typedef union PSI5S_DDTRIG_PERR_CH4_union_tag { /* PSI5-S DDSR Trigger period register channel */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t DDTRIG_PERR:16;
  } B;
} PSI5S_DDTRIG_PERR_CH4_tag;

typedef union PSI5S_E2SCR_CH4_union_tag { /* PSI5-S ECU to Sensor Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t CMD:5;
    vuint32_t  :1;
    vuint32_t ACMD:5;
    vuint32_t  :2;
    vuint32_t CH_TRIG:1;
    vuint32_t GL_TRIG_SEL:1;
    vuint32_t DEFAULT_SYNC:1;
    vuint32_t DDSR_SHIFT_SEL:1;
    vuint32_t DDSR_CLR:1;
    vuint32_t DDSR_CLK_SEL:1;
    vuint32_t CMDTR_SW_CTRL:1;
    vuint32_t  :1;
    vuint32_t SYNCHRO_OVF_IE:1;
    vuint32_t  :1;
    vuint32_t CMDTR_NWRT_IE:1;
    vuint32_t CMDPR_BZY_IE:1;
    vuint32_t DDSR_RDY_IE:1;
    vuint32_t  :2;
    vuint32_t CMD_TYPE:3;
  } B;
} PSI5S_E2SCR_CH4_tag;

typedef union PSI5S_E2SSR_CH4_union_tag { /* PSI5-S ECU to Sensor Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t SYCHRO_OVF:1;
    vuint32_t  :1;
    vuint32_t CMDTR_NWRT:1;
    vuint32_t CMDPR_BZY:1;
    vuint32_t DDSR_RDY:1;
    vuint32_t  :5;
  } B;
} PSI5S_E2SSR_CH4_tag;

typedef union PSI5S_DDSR_H_CH4_union_tag { /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register High */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t DDSR_H:11;
  } B;
} PSI5S_DDSR_H_CH4_tag;

typedef union PSI5S_DDSR_L_CH4_union_tag { /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register Low */
  vuint32_t R;
  struct {
    vuint32_t DDSR_L1:8;
    vuint32_t DDSR_L2:24;
  } B;
} PSI5S_DDSR_L_CH4_tag;

typedef union PSI5S_MSGA_CH5_union_tag { /* PSI5-S channel message configuration register A */
  vuint32_t R;
  struct {
    vuint32_t L_PC_EN:1;
    vuint32_t F5_BYTE:3;
    vuint32_t L_PC5:1;
    vuint32_t F4_BYTE:3;
    vuint32_t L_PC4:1;
    vuint32_t F3_BYTE:3;
    vuint32_t L_PC3:1;
    vuint32_t F2_BYTE:3;
    vuint32_t L_PC2:1;
    vuint32_t F1_BYTE:3;
    vuint32_t L_PC1:1;
    vuint32_t F0_BYTE:3;
    vuint32_t L_PC0:1;
    vuint32_t MODE:1;
    vuint32_t TIME_STAMP_A_B_SEL:1;
    vuint32_t TMSG_TCMD:1;
    vuint32_t TSBUF_CLR:1;
    vuint32_t TSBUF_EN:1;
    vuint32_t G_PC:1;
    vuint32_t CH_EN:1;
  } B;
} PSI5S_MSGA_CH5_tag;

typedef union PSI5S_MSGB_CH5_union_tag { /* PSI5-S channel message configuration register B */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t F5_payload:5;
    vuint32_t F4_payload:5;
    vuint32_t F3_payload:5;
    vuint32_t F2_payload:5;
    vuint32_t F1_payload:5;
    vuint32_t F0_payload:5;
  } B;
} PSI5S_MSGB_CH5_tag;

typedef union PSI5S_MBOX_SR_CH5_union_tag { /* PSI5-S Mailbox status register channel */
  vuint32_t R;
  struct {
    vuint32_t  :14;
    vuint32_t F5_ERR:1;
    vuint32_t F5_OV:1;
    vuint32_t F5_READ:1;
    vuint32_t F4_ERR:1;
    vuint32_t F4_OV:1;
    vuint32_t F4_READ:1;
    vuint32_t F3_ERR:1;
    vuint32_t F3_OV:1;
    vuint32_t F3_READ:1;
    vuint32_t F2_ERR:1;
    vuint32_t F2_OV:1;
    vuint32_t F2_READ:1;
    vuint32_t F1_ERR:1;
    vuint32_t F1_OV:1;
    vuint32_t F1_READ:1;
    vuint32_t F0_ERR:1;
    vuint32_t F0_OV:1;
    vuint32_t F0_READ:1;
  } B;
} PSI5S_MBOX_SR_CH5_tag;

typedef union PSI5S_WD_CFGR_CH5_union_tag { /* PSI5-S channel watchdog configuration register */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t WDRST:1;
    vuint32_t WDCS:1;
    vuint32_t WDEN:1;
    vuint32_t  :1;
    vuint32_t WD_TO:24;
  } B;
} PSI5S_WD_CFGR_CH5_tag;

typedef union PSI5S_DDTRIG_OFFR_CH5_union_tag { /* PSI5-S DDSR Trigger offset register channel */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t DDTRIG_OFFR:16;
  } B;
} PSI5S_DDTRIG_OFFR_CH5_tag;

typedef union PSI5S_DDTRIG_PERR_CH5_union_tag { /* PSI5-S DDSR Trigger period register channel */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t DDTRIG_PERR:16;
  } B;
} PSI5S_DDTRIG_PERR_CH5_tag;

typedef union PSI5S_E2SCR_CH5_union_tag { /* PSI5-S ECU to Sensor Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t CMD:5;
    vuint32_t  :1;
    vuint32_t ACMD:5;
    vuint32_t  :2;
    vuint32_t CH_TRIG:1;
    vuint32_t GL_TRIG_SEL:1;
    vuint32_t DEFAULT_SYNC:1;
    vuint32_t DDSR_SHIFT_SEL:1;
    vuint32_t DDSR_CLR:1;
    vuint32_t DDSR_CLK_SEL:1;
    vuint32_t CMDTR_SW_CTRL:1;
    vuint32_t  :1;
    vuint32_t SYNCHRO_OVF_IE:1;
    vuint32_t  :1;
    vuint32_t CMDTR_NWRT_IE:1;
    vuint32_t CMDPR_BZY_IE:1;
    vuint32_t DDSR_RDY_IE:1;
    vuint32_t  :2;
    vuint32_t CMD_TYPE:3;
  } B;
} PSI5S_E2SCR_CH5_tag;

typedef union PSI5S_E2SSR_CH5_union_tag { /* PSI5-S ECU to Sensor Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t SYCHRO_OVF:1;
    vuint32_t  :1;
    vuint32_t CMDTR_NWRT:1;
    vuint32_t CMDPR_BZY:1;
    vuint32_t DDSR_RDY:1;
    vuint32_t  :5;
  } B;
} PSI5S_E2SSR_CH5_tag;

typedef union PSI5S_DDSR_H_CH5_union_tag { /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register High */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t DDSR_H:11;
  } B;
} PSI5S_DDSR_H_CH5_tag;

typedef union PSI5S_DDSR_L_CH5_union_tag { /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register Low */
  vuint32_t R;
  struct {
    vuint32_t DDSR_L1:8;
    vuint32_t DDSR_L2:24;
  } B;
} PSI5S_DDSR_L_CH5_tag;

typedef union PSI5S_MSGA_CH6_union_tag { /* PSI5-S channel message configuration register A */
  vuint32_t R;
  struct {
    vuint32_t L_PC_EN:1;
    vuint32_t F5_BYTE:3;
    vuint32_t L_PC5:1;
    vuint32_t F4_BYTE:3;
    vuint32_t L_PC4:1;
    vuint32_t F3_BYTE:3;
    vuint32_t L_PC3:1;
    vuint32_t F2_BYTE:3;
    vuint32_t L_PC2:1;
    vuint32_t F1_BYTE:3;
    vuint32_t L_PC1:1;
    vuint32_t F0_BYTE:3;
    vuint32_t L_PC0:1;
    vuint32_t MODE:1;
    vuint32_t TIME_STAMP_A_B_SEL:1;
    vuint32_t TMSG_TCMD:1;
    vuint32_t TSBUF_CLR:1;
    vuint32_t TSBUF_EN:1;
    vuint32_t G_PC:1;
    vuint32_t CH_EN:1;
  } B;
} PSI5S_MSGA_CH6_tag;

typedef union PSI5S_MSGB_CH6_union_tag { /* PSI5-S channel message configuration register B */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t F5_payload:5;
    vuint32_t F4_payload:5;
    vuint32_t F3_payload:5;
    vuint32_t F2_payload:5;
    vuint32_t F1_payload:5;
    vuint32_t F0_payload:5;
  } B;
} PSI5S_MSGB_CH6_tag;

typedef union PSI5S_MBOX_SR_CH6_union_tag { /* PSI5-S Mailbox status register channel */
  vuint32_t R;
  struct {
    vuint32_t  :14;
    vuint32_t F5_ERR:1;
    vuint32_t F5_OV:1;
    vuint32_t F5_READ:1;
    vuint32_t F4_ERR:1;
    vuint32_t F4_OV:1;
    vuint32_t F4_READ:1;
    vuint32_t F3_ERR:1;
    vuint32_t F3_OV:1;
    vuint32_t F3_READ:1;
    vuint32_t F2_ERR:1;
    vuint32_t F2_OV:1;
    vuint32_t F2_READ:1;
    vuint32_t F1_ERR:1;
    vuint32_t F1_OV:1;
    vuint32_t F1_READ:1;
    vuint32_t F0_ERR:1;
    vuint32_t F0_OV:1;
    vuint32_t F0_READ:1;
  } B;
} PSI5S_MBOX_SR_CH6_tag;

typedef union PSI5S_WD_CFGR_CH6_union_tag { /* PSI5-S channel watchdog configuration register */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t WDRST:1;
    vuint32_t WDCS:1;
    vuint32_t WDEN:1;
    vuint32_t  :1;
    vuint32_t WD_TO:24;
  } B;
} PSI5S_WD_CFGR_CH6_tag;

typedef union PSI5S_DDTRIG_OFFR_CH6_union_tag { /* PSI5-S DDSR Trigger offset register channel */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t DDTRIG_OFFR:16;
  } B;
} PSI5S_DDTRIG_OFFR_CH6_tag;

typedef union PSI5S_DDTRIG_PERR_CH6_union_tag { /* PSI5-S DDSR Trigger period register channel */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t DDTRIG_PERR:16;
  } B;
} PSI5S_DDTRIG_PERR_CH6_tag;

typedef union PSI5S_E2SCR_CH6_union_tag { /* PSI5-S ECU to Sensor Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t CMD:5;
    vuint32_t  :1;
    vuint32_t ACMD:5;
    vuint32_t  :2;
    vuint32_t CH_TRIG:1;
    vuint32_t GL_TRIG_SEL:1;
    vuint32_t DEFAULT_SYNC:1;
    vuint32_t DDSR_SHIFT_SEL:1;
    vuint32_t DDSR_CLR:1;
    vuint32_t DDSR_CLK_SEL:1;
    vuint32_t CMDTR_SW_CTRL:1;
    vuint32_t  :1;
    vuint32_t SYNCHRO_OVF_IE:1;
    vuint32_t  :1;
    vuint32_t CMDTR_NWRT_IE:1;
    vuint32_t CMDPR_BZY_IE:1;
    vuint32_t DDSR_RDY_IE:1;
    vuint32_t  :2;
    vuint32_t CMD_TYPE:3;
  } B;
} PSI5S_E2SCR_CH6_tag;

typedef union PSI5S_E2SSR_CH6_union_tag { /* PSI5-S ECU to Sensor Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t SYCHRO_OVF:1;
    vuint32_t  :1;
    vuint32_t CMDTR_NWRT:1;
    vuint32_t CMDPR_BZY:1;
    vuint32_t DDSR_RDY:1;
    vuint32_t  :5;
  } B;
} PSI5S_E2SSR_CH6_tag;

typedef union PSI5S_DDSR_H_CH6_union_tag { /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register High */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t DDSR_H:11;
  } B;
} PSI5S_DDSR_H_CH6_tag;

typedef union PSI5S_DDSR_L_CH6_union_tag { /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register Low */
  vuint32_t R;
  struct {
    vuint32_t DDSR_L1:8;
    vuint32_t DDSR_L2:24;
  } B;
} PSI5S_DDSR_L_CH6_tag;

typedef union PSI5S_MSGA_CH7_union_tag { /* PSI5-S channel message configuration register A */
  vuint32_t R;
  struct {
    vuint32_t L_PC_EN:1;
    vuint32_t F5_BYTE:3;
    vuint32_t L_PC5:1;
    vuint32_t F4_BYTE:3;
    vuint32_t L_PC4:1;
    vuint32_t F3_BYTE:3;
    vuint32_t L_PC3:1;
    vuint32_t F2_BYTE:3;
    vuint32_t L_PC2:1;
    vuint32_t F1_BYTE:3;
    vuint32_t L_PC1:1;
    vuint32_t F0_BYTE:3;
    vuint32_t L_PC0:1;
    vuint32_t MODE:1;
    vuint32_t TIME_STAMP_A_B_SEL:1;
    vuint32_t TMSG_TCMD:1;
    vuint32_t TSBUF_CLR:1;
    vuint32_t TSBUF_EN:1;
    vuint32_t G_PC:1;
    vuint32_t CH_EN:1;
  } B;
} PSI5S_MSGA_CH7_tag;

typedef union PSI5S_MSGB_CH7_union_tag { /* PSI5-S channel message configuration register B */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t F5_payload:5;
    vuint32_t F4_payload:5;
    vuint32_t F3_payload:5;
    vuint32_t F2_payload:5;
    vuint32_t F1_payload:5;
    vuint32_t F0_payload:5;
  } B;
} PSI5S_MSGB_CH7_tag;

typedef union PSI5S_MBOX_SR_CH7_union_tag { /* PSI5-S Mailbox status register channel */
  vuint32_t R;
  struct {
    vuint32_t  :14;
    vuint32_t F5_ERR:1;
    vuint32_t F5_OV:1;
    vuint32_t F5_READ:1;
    vuint32_t F4_ERR:1;
    vuint32_t F4_OV:1;
    vuint32_t F4_READ:1;
    vuint32_t F3_ERR:1;
    vuint32_t F3_OV:1;
    vuint32_t F3_READ:1;
    vuint32_t F2_ERR:1;
    vuint32_t F2_OV:1;
    vuint32_t F2_READ:1;
    vuint32_t F1_ERR:1;
    vuint32_t F1_OV:1;
    vuint32_t F1_READ:1;
    vuint32_t F0_ERR:1;
    vuint32_t F0_OV:1;
    vuint32_t F0_READ:1;
  } B;
} PSI5S_MBOX_SR_CH7_tag;

typedef union PSI5S_WD_CFGR_CH7_union_tag { /* PSI5-S channel watchdog configuration register */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t WDRST:1;
    vuint32_t WDCS:1;
    vuint32_t WDEN:1;
    vuint32_t  :1;
    vuint32_t WD_TO:24;
  } B;
} PSI5S_WD_CFGR_CH7_tag;

typedef union PSI5S_DDTRIG_OFFR_CH7_union_tag { /* PSI5-S DDSR Trigger offset register channel */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t DDTRIG_OFFR:16;
  } B;
} PSI5S_DDTRIG_OFFR_CH7_tag;

typedef union PSI5S_DDTRIG_PERR_CH7_union_tag { /* PSI5-S DDSR Trigger period register channel */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t DDTRIG_PERR:16;
  } B;
} PSI5S_DDTRIG_PERR_CH7_tag;

typedef union PSI5S_E2SCR_CH7_union_tag { /* PSI5-S ECU to Sensor Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t CMD:5;
    vuint32_t  :1;
    vuint32_t ACMD:5;
    vuint32_t  :2;
    vuint32_t CH_TRIG:1;
    vuint32_t GL_TRIG_SEL:1;
    vuint32_t DEFAULT_SYNC:1;
    vuint32_t DDSR_SHIFT_SEL:1;
    vuint32_t DDSR_CLR:1;
    vuint32_t DDSR_CLK_SEL:1;
    vuint32_t CMDTR_SW_CTRL:1;
    vuint32_t  :1;
    vuint32_t SYNCHRO_OVF_IE:1;
    vuint32_t  :1;
    vuint32_t CMDTR_NWRT_IE:1;
    vuint32_t CMDPR_BZY_IE:1;
    vuint32_t DDSR_RDY_IE:1;
    vuint32_t  :2;
    vuint32_t CMD_TYPE:3;
  } B;
} PSI5S_E2SCR_CH7_tag;

typedef union PSI5S_E2SSR_CH7_union_tag { /* PSI5-S ECU to Sensor Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t SYCHRO_OVF:1;
    vuint32_t  :1;
    vuint32_t CMDTR_NWRT:1;
    vuint32_t CMDPR_BZY:1;
    vuint32_t DDSR_RDY:1;
    vuint32_t  :5;
  } B;
} PSI5S_E2SSR_CH7_tag;

typedef union PSI5S_DDSR_H_CH7_union_tag { /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register High */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t DDSR_H:11;
  } B;
} PSI5S_DDSR_H_CH7_tag;

typedef union PSI5S_DDSR_L_CH7_union_tag { /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register Low */
  vuint32_t R;
  struct {
    vuint32_t DDSR_L1:8;
    vuint32_t DDSR_L2:24;
  } B;
} PSI5S_DDSR_L_CH7_tag;

struct PSI5S_tag {
  PSI5S_LINCR1_tag LINCR1;             /* PSI5-S LIN Control Register 1 */
  PSI5S_LINIER_tag LINIER;             /* PSI5-S LIN Interrupt enable register */
  PSI5S_LINSR_tag LINSR;               /* PSI5-S LIN Status Register */
  uint8_t PSI5S_reserved0[4];
  PSI5S_UARTCR_tag UARTCR;             /* PSI5-S UART Mode Control Register */
  PSI5S_UARTSR_tag UARTSR;             /* PSI5-S UART Mode Status Register */
  uint8_t PSI5S_reserved1[12];
  PSI5S_LINFBRR_tag LINFBRR;           /* PSI5-S LIN Fractional Baud Rate Register */
  PSI5S_LINIBRR_tag LINIBRR;           /* PSI5-S LIN Integer Baud Rate Register */
  uint8_t PSI5S_reserved2[4];
  PSI5S_LINCR2_tag LINCR2;             /* PSI5-S LIN Control Register 2 */
  uint8_t PSI5S_reserved3[4];
  PSI5S_BDRL_tag BDRL;                 /* PSI5-S Buffer Data Register Least Significant */
  PSI5S_BDRM_tag BDRM;                 /* PSI5-S Buffer Data Register Most Significant */
  uint8_t PSI5S_reserved4[12];
  PSI5S_GCR_tag GCR;                   /* PSI5-S Global Control register */
  PSI5S_UARTPTO_tag UARTPTO;           /* PSI5-S UART Preset Timeout Register */
  PSI5S_UARTCTO_tag UARTCTO;           /* UPSI5-S ART Current Timeout register */
  PSI5S_DMATXE_tag DMATXE;             /* DMA Tx Enable Register */
  PSI5S_DMARXE_tag DMARXE;             /* DMA Rx Enable Register */
  PSI5S_PTD_tag PTD;                   /* PSI5-S UART Tx Idle Delay Time Register */
  uint8_t PSI5S_reserved5[80];
  PSI5S_GLCR_tag GLCR;                 /* PSI5-S Global Control Register */
  PSI5S_GLSR_tag GLSR;                 /* PSI5-S Global Status Register */
  PSI5S_CH_BASE_ADDR_tag CH_BASE_ADDR; /* PSI5-S CHANNEL_BASE_ADDRESS */
  PSI5S_MRU_BUF2_REG0_tag MRU_BUF2_REG0; /* PSI5-S MRU OUTPUT BUFFER2 REGISTER0 */
  PSI5S_MRU_BUF2_REG1_tag MRU_BUF2_REG1; /* PSI5-S MRU OUTPUT BUFFER2 REGISTER1 */
  PSI5S_MRU_BUF2_REG2_tag MRU_BUF2_REG2; /* PSI5-S MRU OUTPUT BUFFER2 REGISTER2 */
  PSI5S_MRU_BUF2_REG3_tag MRU_BUF2_REG3; /* PSI5-S MRU OUTPUT BUFFER2 REGISTER3 */
  uint8_t PSI5S_reserved6[16];
  PSI5S_MBOX_SR_IRQ_tag MBOX_SR_IRQ;   /* PSI5-S Mbox Status Irq */
  PSI5S_ERR_SR_IRQ_tag ERR_SR_IRQ;     /* PSI5-S Error Status Irq */
  PSI5S_SEL_IRQ_tag SEL_IRQ[8];
  PSI5S_WDGTSSR_tag WDGTSSR;           /* PSI5-S Watchdog Error Status and Watchdog Timestamp status register */
  PSI5S_DIRCMD_tag DIRCMD;             /* PSI5-S ECU to Sensor Direct Command Write register */
  uint8_t PSI5S_reserved7[60];
  PSI5S_MSGA_CH0_tag MSGA_CH0;         /* PSI5-S channel 0 message configuration register A */
  PSI5S_MSGB_CH0_tag MSGB_CH0;         /* PSI5-S channel 0 message configuration register B */
  uint8_t PSI5S_reserved8[4];
  PSI5S_MBOX_SR_CH0_tag MBOX_SR_CH0;   /* PSI5-S Mailbox status register channel0 */
  uint8_t PSI5S_reserved9[20];
  PSI5S_MSGA_CH1_tag MSGA_CH1;         /* PSI5-S channel message configuration register A */
  PSI5S_MSGB_CH1_tag MSGB_CH1;         /* PSI5-S channel message configuration register B */
  uint8_t PSI5S_reserved10[4];
  PSI5S_MBOX_SR_CH1_tag MBOX_SR_CH1;   /* PSI5-S Mailbox status register channel */
  PSI5S_WD_CFGR_CH1_tag WD_CFGR_CH1;   /* PSI5-S channel watchdog configuration register */
  PSI5S_DDTRIG_OFFR_CH1_tag DDTRIG_OFFR_CH1; /* PSI5-S DDSR Trigger offset register channel */
  PSI5S_DDTRIG_PERR_CH1_tag DDTRIG_PERR_CH1; /* PSI5-S DDSR Trigger period register channel */
  PSI5S_E2SCR_CH1_tag E2SCR_CH1;       /* PSI5-S ECU to Sensor Control Register */
  PSI5S_E2SSR_CH1_tag E2SSR_CH1;       /* PSI5-S ECU to Sensor Status Register */
  PSI5S_DDSR_H_CH1_tag DDSR_H_CH1;     /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register High */
  PSI5S_DDSR_L_CH1_tag DDSR_L_CH1;     /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register Low */
  uint8_t PSI5S_reserved11[16];
  PSI5S_MSGA_CH2_tag MSGA_CH2;         /* PSI5-S channel message configuration register A */
  PSI5S_MSGB_CH2_tag MSGB_CH2;         /* PSI5-S channel message configuration register B */
  uint8_t PSI5S_reserved12[4];
  PSI5S_MBOX_SR_CH2_tag MBOX_SR_CH2;   /* PSI5-S Mailbox status register channel */
  PSI5S_WD_CFGR_CH2_tag WD_CFGR_CH2;   /* PSI5-S channel watchdog configuration register */
  PSI5S_DDTRIG_OFFR_CH2_tag DDTRIG_OFFR_CH2; /* PSI5-S DDSR Trigger offset register channel */
  PSI5S_DDTRIG_PERR_CH2_tag DDTRIG_PERR_CH2; /* PSI5-S DDSR Trigger period register channel */
  PSI5S_E2SCR_CH2_tag E2SCR_CH2;       /* PSI5-S ECU to Sensor Control Register */
  PSI5S_E2SSR_CH2_tag E2SSR_CH2;       /* PSI5-S ECU to Sensor Status Register */
  PSI5S_DDSR_H_CH2_tag DDSR_H_CH2;     /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register High */
  PSI5S_DDSR_L_CH2_tag DDSR_L_CH2;     /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register Low */
  uint8_t PSI5S_reserved13[16];
  PSI5S_MSGA_CH3_tag MSGA_CH3;         /* PSI5-S channel message configuration register A */
  PSI5S_MSGB_CH3_tag MSGB_CH3;         /* PSI5-S channel message configuration register B */
  uint8_t PSI5S_reserved14[4];
  PSI5S_MBOX_SR_CH3_tag MBOX_SR_CH3;   /* PSI5-S Mailbox status register channel */
  PSI5S_WD_CFGR_CH3_tag WD_CFGR_CH3;   /* PSI5-S channel watchdog configuration register */
  PSI5S_DDTRIG_OFFR_CH3_tag DDTRIG_OFFR_CH3; /* PSI5-S DDSR Trigger offset register channel */
  PSI5S_DDTRIG_PERR_CH3_tag DDTRIG_PERR_CH3; /* PSI5-S DDSR Trigger period register channel */
  PSI5S_E2SCR_CH3_tag E2SCR_CH3;       /* PSI5-S ECU to Sensor Control Register */
  PSI5S_E2SSR_CH3_tag E2SSR_CH3;       /* PSI5-S ECU to Sensor Status Register */
  PSI5S_DDSR_H_CH3_tag DDSR_H_CH3;     /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register High */
  PSI5S_DDSR_L_CH3_tag DDSR_L_CH3;     /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register Low */
  uint8_t PSI5S_reserved15[16];
  PSI5S_MSGA_CH4_tag MSGA_CH4;         /* PSI5-S channel message configuration register A */
  PSI5S_MSGB_CH4_tag MSGB_CH4;         /* PSI5-S channel message configuration register B */
  uint8_t PSI5S_reserved16[4];
  PSI5S_MBOX_SR_CH4_tag MBOX_SR_CH4;   /* PSI5-S Mailbox status register channel */
  PSI5S_WD_CFGR_CH4_tag WD_CFGR_CH4;   /* PSI5-S channel watchdog configuration register */
  PSI5S_DDTRIG_OFFR_CH4_tag DDTRIG_OFFR_CH4; /* PSI5-S DDSR Trigger offset register channel */
  PSI5S_DDTRIG_PERR_CH4_tag DDTRIG_PERR_CH4; /* PSI5-S DDSR Trigger period register channel */
  PSI5S_E2SCR_CH4_tag E2SCR_CH4;       /* PSI5-S ECU to Sensor Control Register */
  PSI5S_E2SSR_CH4_tag E2SSR_CH4;       /* PSI5-S ECU to Sensor Status Register */
  PSI5S_DDSR_H_CH4_tag DDSR_H_CH4;     /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register High */
  PSI5S_DDSR_L_CH4_tag DDSR_L_CH4;     /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register Low */
  uint8_t PSI5S_reserved17[16];
  PSI5S_MSGA_CH5_tag MSGA_CH5;         /* PSI5-S channel message configuration register A */
  PSI5S_MSGB_CH5_tag MSGB_CH5;         /* PSI5-S channel message configuration register B */
  uint8_t PSI5S_reserved18[4];
  PSI5S_MBOX_SR_CH5_tag MBOX_SR_CH5;   /* PSI5-S Mailbox status register channel */
  PSI5S_WD_CFGR_CH5_tag WD_CFGR_CH5;   /* PSI5-S channel watchdog configuration register */
  PSI5S_DDTRIG_OFFR_CH5_tag DDTRIG_OFFR_CH5; /* PSI5-S DDSR Trigger offset register channel */
  PSI5S_DDTRIG_PERR_CH5_tag DDTRIG_PERR_CH5; /* PSI5-S DDSR Trigger period register channel */
  PSI5S_E2SCR_CH5_tag E2SCR_CH5;       /* PSI5-S ECU to Sensor Control Register */
  PSI5S_E2SSR_CH5_tag E2SSR_CH5;       /* PSI5-S ECU to Sensor Status Register */
  PSI5S_DDSR_H_CH5_tag DDSR_H_CH5;     /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register High */
  PSI5S_DDSR_L_CH5_tag DDSR_L_CH5;     /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register Low */
  uint8_t PSI5S_reserved19[16];
  PSI5S_MSGA_CH6_tag MSGA_CH6;         /* PSI5-S channel message configuration register A */
  PSI5S_MSGB_CH6_tag MSGB_CH6;         /* PSI5-S channel message configuration register B */
  uint8_t PSI5S_reserved20[4];
  PSI5S_MBOX_SR_CH6_tag MBOX_SR_CH6;   /* PSI5-S Mailbox status register channel */
  PSI5S_WD_CFGR_CH6_tag WD_CFGR_CH6;   /* PSI5-S channel watchdog configuration register */
  PSI5S_DDTRIG_OFFR_CH6_tag DDTRIG_OFFR_CH6; /* PSI5-S DDSR Trigger offset register channel */
  PSI5S_DDTRIG_PERR_CH6_tag DDTRIG_PERR_CH6; /* PSI5-S DDSR Trigger period register channel */
  PSI5S_E2SCR_CH6_tag E2SCR_CH6;       /* PSI5-S ECU to Sensor Control Register */
  PSI5S_E2SSR_CH6_tag E2SSR_CH6;       /* PSI5-S ECU to Sensor Status Register */
  PSI5S_DDSR_H_CH6_tag DDSR_H_CH6;     /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register High */
  PSI5S_DDSR_L_CH6_tag DDSR_L_CH6;     /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register Low */
  uint8_t PSI5S_reserved21[16];
  PSI5S_MSGA_CH7_tag MSGA_CH7;         /* PSI5-S channel message configuration register A */
  PSI5S_MSGB_CH7_tag MSGB_CH7;         /* PSI5-S channel message configuration register B */
  uint8_t PSI5S_reserved22[4];
  PSI5S_MBOX_SR_CH7_tag MBOX_SR_CH7;   /* PSI5-S Mailbox status register channel */
  PSI5S_WD_CFGR_CH7_tag WD_CFGR_CH7;   /* PSI5-S channel watchdog configuration register */
  PSI5S_DDTRIG_OFFR_CH7_tag DDTRIG_OFFR_CH7; /* PSI5-S DDSR Trigger offset register channel */
  PSI5S_DDTRIG_PERR_CH7_tag DDTRIG_PERR_CH7; /* PSI5-S DDSR Trigger period register channel */
  PSI5S_E2SCR_CH7_tag E2SCR_CH7;       /* PSI5-S ECU to Sensor Control Register */
  PSI5S_E2SSR_CH7_tag E2SSR_CH7;       /* PSI5-S ECU to Sensor Status Register */
  PSI5S_DDSR_H_CH7_tag DDSR_H_CH7;     /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register High */
  PSI5S_DDSR_L_CH7_tag DDSR_L_CH7;     /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register Low */
};


/* ============================================================================
   =============================== Module: REG_PROT ===========================
   ============================================================================ */

typedef union REG_PROT_SLBRn_union_tag { /* Soft Lock Bit Register n */
  vuint8_t R;
  struct {
    vuint8_t WE0:1;                    /* Write Enable Bits for Soft Lock Bits (SLB) */
    vuint8_t WE1:1;                    /* Write Enable Bits for Soft Lock Bits (SLB) */
    vuint8_t WE2:1;                    /* Write Enable Bits for Soft Lock Bits (SLB) */
    vuint8_t WE3:1;                    /* Write Enable Bits for Soft Lock Bits (SLB) */
    vuint8_t SLB0:1;                   /* Soft Lock Bits for one MRn register */
    vuint8_t SLB1:1;                   /* Soft Lock Bits for one MRn register */
    vuint8_t SLB2:1;                   /* Soft Lock Bits for one MRn register */
    vuint8_t SLB3:1;                   /* Soft Lock Bits for one MRn register */
  } B;
} REG_PROT_SLBRn_tag;

typedef union REG_PROT_GCR_union_tag { /* Global Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t HLB:1;                   /* Hard Lock Bit */
    vuint32_t  :7;
    vuint32_t UAA:1;                   /* User Access Allowed. */
    vuint32_t  :23;
  } B;
} REG_PROT_GCR_tag;

struct REG_PROT_tag {
  uint8_t REG_PROT_reserved0[14336];
  REG_PROT_SLBRn_tag SLBRn;            /* Soft Lock Bit Register n */
  uint8_t REG_PROT_reserved1[2043];
  REG_PROT_GCR_tag GCR;                /* Global Configuration Register */
};


/* ============================================================================
   =============================== Module: SARADC =============================
   ============================================================================ */

typedef union SARADC_MCR_union_tag {   /* Main Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t OWREN:1;
    vuint32_t WLSIDE:1;
    vuint32_t MODE:1;
    vuint32_t  :1;
    vuint32_t NSTART:1;
    vuint32_t NTRGEN:1;
    vuint32_t NEDGESEL:2;
    vuint32_t JSTART:1;
    vuint32_t JTRGEN:1;
    vuint32_t JEDGESEL:2;
    vuint32_t JTRGSEQ:1;
    vuint32_t  :1;
    vuint32_t  :2;
    vuint32_t WTRIGOUT:1;
    vuint32_t  :3;
    vuint32_t JTRGSEL:4;
    vuint32_t ABORTCHAIN:1;
    vuint32_t ABORT:1;
    vuint32_t  :1;
    vuint32_t FRZ:1;
    vuint32_t  :2;
    vuint32_t EDCSELF:1;
    vuint32_t PWDN:1;
  } B;
} SARADC_MCR_tag;

typedef union SARADC_MSR_union_tag {   /* Main Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t NSTART:1;
    vuint32_t  :3;
    vuint32_t JSTART:1;
    vuint32_t  :4;
    vuint32_t JABORTCHAIN:1;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t CHADDR:8;
    vuint32_t  :5;
    vuint32_t ADCSTATUS:3;
  } B;
} SARADC_MSR_tag;

typedef union SARADC_ISR_union_tag {   /* Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :27;
    vuint32_t  :1;
    vuint32_t JEOC:1;
    vuint32_t JECH:1;
    vuint32_t NEOC:1;
    vuint32_t NECH:1;
  } B;
} SARADC_ISR_tag;

typedef union SARADC_ICIPR_union_tag { /* Internal channel Interrupt Pending Register */
  vuint32_t R;
  struct {
    vuint32_t EOC_CHx:32;
  } B;
} SARADC_ICIPR_tag;

typedef union SARADC_IMR_union_tag {   /* Interrupt Mask Register */
  vuint32_t R;
  struct {
    vuint32_t  :27;
    vuint32_t  :1;
    vuint32_t MSKJEOC:1;
    vuint32_t MSKJECH:1;
    vuint32_t MSKNEOC:1;
    vuint32_t MSKNECH:1;
  } B;
} SARADC_IMR_tag;

typedef union SARADC_ICIMR_union_tag { /* Internal Channel Interrupt Mask Register */
  vuint32_t R;
  struct {
    vuint32_t IM_CHx:32;
  } B;
} SARADC_ICIMR_tag;

typedef union SARADC_WTISR_union_tag { /* Watchdog Threshold Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t WDG15H:1;
    vuint32_t WDG15L:1;
    vuint32_t WDG14H:1;
    vuint32_t WDG14L:1;
    vuint32_t WDG13H:1;
    vuint32_t WDG13L:1;
    vuint32_t WDG12H:1;
    vuint32_t WDG12L:1;
    vuint32_t WDG11H:1;
    vuint32_t WDG11L:1;
    vuint32_t WDG10H:1;
    vuint32_t WDG10L:1;
    vuint32_t WDG9H:1;
    vuint32_t WDG9L:1;
    vuint32_t WDG8H:1;
    vuint32_t WDG8L:1;
    vuint32_t WDG7H:1;
    vuint32_t WDG7L:1;
    vuint32_t WDG6H:1;
    vuint32_t WDG6L:1;
    vuint32_t WDG5H:1;
    vuint32_t WDG5L:1;
    vuint32_t WDG4H:1;
    vuint32_t WDG4L:1;
    vuint32_t WDG3H:1;
    vuint32_t WDG3L:1;
    vuint32_t WDG2H:1;
    vuint32_t WDG2L:1;
    vuint32_t WDG1H:1;
    vuint32_t WDG1L:1;
    vuint32_t WDG0H:1;
    vuint32_t WDG0L:1;
  } B;
} SARADC_WTISR_tag;

typedef union SARADC_WTIMR_union_tag { /* Watchdog Threshold Interrupt Mask Register */
  vuint32_t R;
  struct {
    vuint32_t MSKWDG15H:1;
    vuint32_t MSKWDG15L:1;
    vuint32_t MSKWDG14H:1;
    vuint32_t MSKWDG14L:1;
    vuint32_t MSKWDG13H:1;
    vuint32_t MSKWDG13L:1;
    vuint32_t MSKWDG12H:1;
    vuint32_t MSKWDG12L:1;
    vuint32_t MSKWDG11H:1;
    vuint32_t MSKWDG11L:1;
    vuint32_t MSKWDG10H:1;
    vuint32_t MSKWDG10L:1;
    vuint32_t MSKWDG9H:1;
    vuint32_t MSKWDG9L:1;
    vuint32_t MSKWDG8H:1;
    vuint32_t MSKWDG8L:1;
    vuint32_t MSKWDG7H:1;
    vuint32_t MSKWDG7L:1;
    vuint32_t MSKWDG6H:1;
    vuint32_t MSKWDG6L:1;
    vuint32_t MSKWDG5H:1;
    vuint32_t MSKWDG5L:1;
    vuint32_t MSKWDG4H:1;
    vuint32_t MSKWDG4L:1;
    vuint32_t MSKWDG3H:1;
    vuint32_t MSKWDG3L:1;
    vuint32_t MSKWDG2H:1;
    vuint32_t MSKWDG2L:1;
    vuint32_t MSKWDG1H:1;
    vuint32_t MSKWDG1L:1;
    vuint32_t MSKWDG0H:1;
    vuint32_t MSKWDG0L:1;
  } B;
} SARADC_WTIMR_tag;

typedef union SARADC_DMAE_union_tag {  /* DMA Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :30;
    vuint32_t DCLR:1;
    vuint32_t DMAEN:1;
  } B;
} SARADC_DMAE_tag;

typedef union SARADC_ICDSR_union_tag { /* Internal Channel DMA Select Register */
  vuint32_t R;
  struct {
    vuint32_t DS_CHx:32;
  } B;
} SARADC_ICDSR_tag;

typedef union SARADC_WTHRHLR_union_tag { /* Watchdog Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t THRH:12;
    vuint32_t  :4;
    vuint32_t THRL:12;
  } B;
} SARADC_WTHRHLR_tag;

typedef union SARADC_CTR_union_tag {   /* Conversion Timing Register */
  vuint32_t R;
  struct {
    vuint32_t CRES:1;
    vuint32_t  :19;
    vuint32_t PRECHG:4;
    vuint32_t INPSAMP:8;
  } B;
} SARADC_CTR_tag;

typedef union SARADC_ICNCMR_union_tag { /* Internal Channel Normal Conversion Mask Register */
  vuint32_t R;
  struct {
    vuint32_t NCE_CHx:32;
  } B;
} SARADC_ICNCMR_tag;

typedef union SARADC_ICJCMR_union_tag { /* Internal Channel Injected Conversion Mask Register */
  vuint32_t R;
  struct {
    vuint32_t JCE_CH:32;
  } B;
} SARADC_ICJCMR_tag;

typedef union SARADC_PDEDR_union_tag { /* Power Down Exit Delay Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t PDED:8;
  } B;
} SARADC_PDEDR_tag;

typedef union SARADC_ICDR_union_tag {  /* Internal Channel Data Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t REFSEL:1;
    vuint32_t  :2;
    vuint32_t PCE:1;
    vuint32_t  :1;
    vuint32_t CTSEL:2;
    vuint32_t  :4;
    vuint32_t VALID:1;
    vuint32_t OVERW:1;
    vuint32_t RESULT:2;
    vuint32_t CDATA:16;
  } B;
} SARADC_ICDR_tag;

typedef union SARADC_ICWSELR_union_tag { /* Internal Channel Watchdog Selection Register */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH7:4;
    vuint32_t WSEL_CH6:4;
    vuint32_t WSEL_CH5:4;
    vuint32_t WSEL_CH4:4;
    vuint32_t WSEL_CH3:4;
    vuint32_t WSEL_CH2:4;
    vuint32_t WSEL_CH1:4;
    vuint32_t WSEL_CH0:4;
  } B;
} SARADC_ICWSELR_tag;

typedef union SARADC_ICWENR_union_tag { /* Internal Channel Watchdog Enable Register */
  vuint32_t R;
  struct {
    vuint32_t WEN_CHx:32;
  } B;
} SARADC_ICWENR_tag;

typedef union SARADC_ICAWORR_union_tag { /* Internal Channel Analog Watchdog Out of Range register */
  vuint32_t R;
  struct {
    vuint32_t AWOR_CHx:32;
  } B;
} SARADC_ICAWORR_tag;

typedef union SARADC_TCIPR_union_tag { /* Test Channel Interrupt Pending Register */
  vuint32_t R;
  struct {
    vuint32_t EOC_CHx:32;
  } B;
} SARADC_TCIPR_tag;

typedef union SARADC_TCIMR_union_tag { /* Test Channel Interrupt Mask Register */
  vuint32_t R;
  struct {
    vuint32_t IM_CHx:32;
  } B;
} SARADC_TCIMR_tag;

typedef union SARADC_TCDSR_union_tag { /* Test Channel DMA Select Register */
  vuint32_t R;
  struct {
    vuint32_t DS_CHx:32;
  } B;
} SARADC_TCDSR_tag;

typedef union SARADC_TCNCMR_union_tag { /* Test Channel Normal Conversion Mask Register */
  vuint32_t R;
  struct {
    vuint32_t NCE_CHx:32;
  } B;
} SARADC_TCNCMR_tag;

typedef union SARADC_TCJCMR_union_tag { /* Test Channel Injected Conversion Mask Register */
  vuint32_t R;
  struct {
    vuint32_t JCE_CHx:32;
  } B;
} SARADC_TCJCMR_tag;

typedef union SARADC_TCWSELR_union_tag { /* Test Channel Watchdog Selection Register */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CHa:4;
    vuint32_t WSEL_CHb:4;
    vuint32_t WSEL_CHc:4;
    vuint32_t WSEL_CHd:4;
    vuint32_t WSEL_CHe:4;
    vuint32_t WSEL_CHf:4;
    vuint32_t WSEL_CHg:4;
    vuint32_t WSEL_CHh:4;
  } B;
} SARADC_TCWSELR_tag;

typedef union SARADC_TCWENR_union_tag { /* Test Channel Watchdog Enable Register */
  vuint32_t R;
  struct {
    vuint32_t WEN_CHx:32;
  } B;
} SARADC_TCWENR_tag;

typedef union SARADC_TCAWORR_union_tag { /* Test Channel Analog Watchdog Out of Range Register */
  vuint32_t R;
  struct {
    vuint32_t AWOR_CHx:32;
  } B;
} SARADC_TCAWORR_tag;

typedef union SARADC_TCCAPR_union_tag { /* Test Channel Connection with Analog Pin Register */
  vuint32_t R;
  struct {
    vuint32_t ESIC_TCH3:1;
    vuint32_t ICSEL_TCH3:7;
    vuint32_t ESIC_TCH2:1;
    vuint32_t ICSEL_TCH2:7;
    vuint32_t ESIC_TCH1:1;
    vuint32_t ICSEL_TCH1:7;
    vuint32_t ESIC_TCH0:1;
    vuint32_t ICSEL_TCH0:7;
  } B;
} SARADC_TCCAPR_tag;

typedef union SARADC_TCDR_union_tag {  /* Test Channel Data Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t REFSEL:1;
    vuint32_t  :2;
    vuint32_t PCE:1;
    vuint32_t  :1;
    vuint32_t CTSEL:2;
    vuint32_t  :4;
    vuint32_t VALID:1;
    vuint32_t OVERW:1;
    vuint32_t RESULT:2;
    vuint32_t CDATA:16;
  } B;
} SARADC_TCDR_tag;

typedef union SARADC_ECDSDR_union_tag { /* External Channel Decode Signals Delay Register */
  vuint32_t R;
  struct {
    vuint32_t  :20;
    vuint32_t DSD:12;
  } B;
} SARADC_ECDSDR_tag;

typedef union SARADC_ECIPR_union_tag { /* External Channel Interrupt Pending Register */
  vuint32_t R;
  struct {
    vuint32_t EOC_CHx:32;
  } B;
} SARADC_ECIPR_tag;

typedef union SARADC_ECIMR_union_tag { /* External Channel Interrupt Mask Register */
  vuint32_t R;
  struct {
    vuint32_t IM_CHx:32;
  } B;
} SARADC_ECIMR_tag;

typedef union SARADC_ECDSR_union_tag { /* External Channel DMA Select Register */
  vuint32_t R;
  struct {
    vuint32_t DS_CHx:32;
  } B;
} SARADC_ECDSR_tag;

typedef union SARADC_ECNCMR_union_tag { /* External Channel Normal Conversion Mask Register */
  vuint32_t R;
  struct {
    vuint32_t NCE_CHx:32;
  } B;
} SARADC_ECNCMR_tag;

typedef union SARADC_ECJCMR_union_tag { /* External Channel Injected Conversion Mask Register */
  vuint32_t R;
  struct {
    vuint32_t JCE_CHx:32;
  } B;
} SARADC_ECJCMR_tag;

typedef union SARADC_ECWSELR_union_tag { /* External Channel Watchdog Selection Register */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CHa:4;
    vuint32_t WSEL_CHb:4;
    vuint32_t WSEL_CHc:4;
    vuint32_t WSEL_CHd:4;
    vuint32_t WSEL_CHe:4;
    vuint32_t WSEL_CHf:4;
    vuint32_t WSEL_CHg:4;
    vuint32_t WSEL_CHh:4;
  } B;
} SARADC_ECWSELR_tag;

typedef union SARADC_ECWENR_union_tag { /* External Channel Watchdog Enable Register */
  vuint32_t R;
  struct {
    vuint32_t WEN_CHx:32;
  } B;
} SARADC_ECWENR_tag;

typedef union SARADC_ECAWORR_union_tag { /* External Channel Analog Watchdog Out of Range register */
  vuint32_t R;
  struct {
    vuint32_t AWOR_CHx:32;
  } B;
} SARADC_ECAWORR_tag;

typedef union SARADC_ECMICR_union_tag { /* External Channel Mapping to Internal Channel Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t ICSEL_ECH152_159:7;
    vuint32_t  :1;
    vuint32_t ICSEL_ECH144_151:7;
    vuint32_t  :1;
    vuint32_t ICSEL_ECH136_143:7;
    vuint32_t  :1;
    vuint32_t ICSEL_ECH128_135:7;
  } B;
} SARADC_ECMICR_tag;

typedef union SARADC_ECDR_union_tag {  /* External Channel Data Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t REFSEL:1;
    vuint32_t  :2;
    vuint32_t PCE:1;
    vuint32_t  :1;
    vuint32_t CTSEL:2;
    vuint32_t  :4;
    vuint32_t VALID:1;
    vuint32_t OVERW:1;
    vuint32_t RESULT:2;
    vuint32_t CDATA:16;
  } B;
} SARADC_ECDR_tag;

struct SARADC_tag {
  SARADC_MCR_tag MCR;                  /* Main Configuration Register */
  SARADC_MSR_tag MSR;                  /* Main Status Register */
  uint8_t SARADC_reserved0[8];
  SARADC_ISR_tag ISR;                  /* Interrupt Status Register */
  SARADC_ICIPR_tag ICIPR[3];           /* Internal channel Interrupt Pending Register */
  SARADC_IMR_tag IMR;                  /* Interrupt Mask Register */
  SARADC_ICIMR_tag ICIMR[3];           /* Internal Channel Interrupt Mask Register */
  SARADC_WTISR_tag WTISR;              /* Watchdog Threshold Interrupt Status Register */
  SARADC_WTIMR_tag WTIMR;              /* Watchdog Threshold Interrupt Mask Register */
  uint8_t SARADC_reserved1[8];
  SARADC_DMAE_tag DMAE;                /* DMA Enable Register */
  SARADC_ICDSR_tag ICDSR[3];           /* Internal Channel DMA Select Register */
  uint8_t SARADC_reserved2[16];
  SARADC_WTHRHLR_tag WTHRHLR[4];       /* Watchdog Threshold Register */
  uint8_t SARADC_reserved3[36];
  SARADC_CTR_tag CTR[4];               /* Conversion Timing Register */
  SARADC_ICNCMR_tag ICNCMR[3];         /* Internal Channel Normal Conversion Mask Register */
  uint8_t SARADC_reserved4[4];
  SARADC_ICJCMR_tag ICJCMR[3];         /* Internal Channel Injected Conversion Mask Register */
  uint8_t SARADC_reserved5[8];
  SARADC_PDEDR_tag PDEDR;              /* Power Down Exit Delay Register */
  uint8_t SARADC_reserved6[52];
  SARADC_ICDR_tag ICDR[96];            /* Internal Channel Data Register */
  uint8_t SARADC_reserved7[48];
  SARADC_ICWSELR_tag ICWSELR[12];      /* Internal Channel Watchdog Selection Register */
  SARADC_ICWENR_tag ICWENR[3];         /* Internal Channel Watchdog Enable Register */
  uint8_t SARADC_reserved8[4];
  SARADC_ICAWORR_tag ICAWORR[3];       /* Internal Channel Analog Watchdog Out of Range register */
  uint8_t SARADC_reserved9[260];
  SARADC_TCIPR_tag TCIPR;              /* Test Channel Interrupt Pending Register */
  SARADC_TCIMR_tag TCIMR;              /* Test Channel Interrupt Mask Register */
  SARADC_TCDSR_tag TCDSR;              /* Test Channel DMA Select Register */
  SARADC_TCNCMR_tag TCNCMR;            /* Test Channel Normal Conversion Mask Register */
  SARADC_TCJCMR_tag TCJCMR;            /* Test Channel Injected Conversion Mask Register */
  SARADC_TCWSELR_tag TCWSELR[4];       /* Test Channel Watchdog Selection Register */
  SARADC_TCWENR_tag TCWENR;            /* Test Channel Watchdog Enable Register */
  SARADC_TCAWORR_tag TCAWORR;          /* Test Channel Analog Watchdog Out of Range Register */
  uint8_t SARADC_reserved10[4];
  SARADC_TCCAPR_tag TCCAPR[8];         /* Test Channel Connection with Analog Pin Register */
  SARADC_TCDR_tag TCDR[32];            /* Test Channel Data Register */
  uint8_t SARADC_reserved11[48];
  SARADC_ECDSDR_tag ECDSDR;            /* External Channel Decode Signals Delay Register */
  uint8_t SARADC_reserved12[12];
  SARADC_ECIPR_tag ECIPR[4];           /* External Channel Interrupt Pending Register */
  SARADC_ECIMR_tag ECIMR[4];           /* External Channel Interrupt Mask Register */
  SARADC_ECDSR_tag ECDSR[4];           /* External Channel DMA Select Register */
  SARADC_ECNCMR_tag ECNCMR[4];         /* External Channel Normal Conversion Mask Register */
  SARADC_ECJCMR_tag ECJCMR[4];         /* External Channel Injected Conversion Mask Register */
  SARADC_ECWSELR_tag ECWSELR[16];      /* External Channel Watchdog Selection Register */
  SARADC_ECWENR_tag ECWENR[4];         /* External Channel Watchdog Enable Register */
  SARADC_ECAWORR_tag ECAWORR[4];       /* External Channel Analog Watchdog Out of Range register */
  SARADC_ECMICR_tag ECMICR[4];         /* External Channel Mapping to Internal Channel Register */
  SARADC_ECDR_tag ECDR[128];           /* External Channel Data Register */
};


/* ============================================================================
   =============================== Module: SDADC ==============================
   ============================================================================ */

typedef union SDADC_MCR_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :3;
    vuint32_t PDR:5;
    vuint32_t  :1;
    vuint32_t PGAN:3;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t EMSEL:1;
    vuint32_t HPFEN:1;
    vuint32_t WDGEN:1;
    vuint32_t TRIGEDSEL:2;
    vuint32_t TRIGEN:1;
    vuint32_t TRIGSEL:4;
    vuint32_t FRZ:1;
    vuint32_t  :2;
    vuint32_t VCOMSEL:1;
    vuint32_t WRMODE:1;
    vuint32_t GECEN:1;                 /* Accurate Gain Error Mode Enable */
    vuint32_t MODE:1;
    vuint32_t EN:1;
  } B;
} SDADC_MCR_tag;

typedef union SDADC_CSR_union_tag {    /* Channel Selection Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t BIASEN:8;
    vuint32_t  :5;
    vuint32_t ANCHSEL_WRAP:3;
    vuint32_t  :5;
    vuint32_t ANCHSEL:3;
  } B;
} SDADC_CSR_tag;

typedef union SDADC_RKR_union_tag {    /* Reset Key Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t RESET_KEY:16;
  } B;
} SDADC_RKR_tag;

typedef union SDADC_SFR_union_tag {    /* Status Flag Register */
  vuint32_t R;
  struct {
    vuint32_t  :13;
    vuint32_t ANCHSEL_CNT:3;
    vuint32_t  :7;
    vuint32_t DFEF:1;
    vuint32_t  :3;
    vuint32_t WTHH:1;
    vuint32_t WTHL:1;
    vuint32_t CDVF:1;
    vuint32_t DFORF:1;
    vuint32_t DFFF:1;
  } B;
} SDADC_SFR_tag;

typedef union SDADC_RSER_union_tag {   /* Request Select and Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :14;
    vuint32_t WTHDIRS:1;
    vuint32_t DFFDIRS:1;
    vuint32_t GDIGE:1;
    vuint32_t  :11;
    vuint32_t WTHDIRE:1;
    vuint32_t CDVEE:1;
    vuint32_t DFORIE:1;
    vuint32_t DFFDIRE:1;
  } B;
} SDADC_RSER_tag;

typedef union SDADC_OSDR_union_tag {   /* Output Settling Delay Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t OSD:8;
  } B;
} SDADC_OSDR_tag;

typedef union SDADC_FCR_union_tag {    /* FIFO Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :20;
    vuint32_t FTHLD:4;
    vuint32_t  :5;
    vuint32_t FSIZE:2;
    vuint32_t FE:1;
  } B;
} SDADC_FCR_tag;

typedef union SDADC_STKR_union_tag {   /* Software Trigger Key Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t ST_KEY:16;
  } B;
} SDADC_STKR_tag;

typedef union SDADC_CDR_union_tag {    /* Converted Data Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t CDATA:16;
  } B;
} SDADC_CDR_tag;

typedef union SDADC_WTHHLR_union_tag { /* WDG Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t THRH:16;
    vuint32_t THRL:16;
  } B;
} SDADC_WTHHLR_tag;

struct SDADC_tag {
  SDADC_MCR_tag MCR;                   /* Module Configuration Register */
  SDADC_CSR_tag CSR;                   /* Channel Selection Register */
  SDADC_RKR_tag RKR;                   /* Reset Key Register */
  SDADC_SFR_tag SFR;                   /* Status Flag Register */
  SDADC_RSER_tag RSER;                 /* Request Select and Enable Register */
  SDADC_OSDR_tag OSDR;                 /* Output Settling Delay Register */
  SDADC_FCR_tag FCR;                   /* FIFO Control Register */
  SDADC_STKR_tag STKR;                 /* Software Trigger Key Register */
  SDADC_CDR_tag CDR;                   /* Converted Data Register */
  SDADC_WTHHLR_tag WTHHLR;             /* WDG Threshold Register */
};


/* ============================================================================
   =============================== Module: SEMA42 =============================
   ============================================================================ */

typedef union SEMA42_GATE_union_tag {  /* Gate Register */
  vuint8_t R;
  struct {
    vuint8_t  :4;
    vuint8_t GTFSM:4;                  /* Gate Finite State Machine. */
  } B;
} SEMA42_GATE_tag;

typedef union SEMA42_RSTGT_R_union_tag { /* Reset Gate Read */
  vuint16_t R;
  struct {
    vuint16_t  :2;
    vuint16_t RSTGSM:2;
    vuint16_t RSTGMS:4;
    vuint16_t RSTGTN:8;
  } B;
} SEMA42_RSTGT_R_tag;

typedef union SEMA42_RSTGT_W_union_tag { /* Reset Gate Write */
  vuint16_t R;
  struct {
    vuint16_t RSTGDP:8;
    vuint16_t RSTGTN:8;
  } B;
} SEMA42_RSTGT_W_tag;

typedef union SEMA42_RSTGT_union_tag {
  SEMA42_RSTGT_R_tag R;                /* Reset Gate Read */
  SEMA42_RSTGT_W_tag W;                /* Reset Gate Write */
} SEMA42_RSTGT_tag;

struct SEMA42_tag {
  SEMA42_GATE_tag GATE[16];            /* Gate Register */
  uint8_t SEMA42_reserved0[48];
  SEMA42_RSTGT_tag RSTGT;
};


/* ============================================================================
   =============================== Module: SIPI ===============================
   ============================================================================ */

typedef union SIPI_CCR0_union_tag {    /* SIPI Channel Control Register 0 */
  vuint32_t R;
  struct {
    vuint32_t  :15;
    vuint32_t TC:1;                    /* Send Trigger Command. */
    vuint32_t  :8;
    vuint32_t WL:2;                    /* Word Length Transfer. */
    vuint32_t CHEN:1;                  /* Channel Enable. */
    vuint32_t ST:1;                    /* Streaming Transfer. */
    vuint32_t IDT:1;                   /* ID Read Request Transfer. */
    vuint32_t RRT:1;                   /* Read Request Transfer. */
    vuint32_t WRT:1;                   /* Write Request Transfer. */
    vuint32_t DEN:1;                   /* DMA Enable. */
  } B;
} SIPI_CCR0_tag;

typedef union SIPI_CSR0_union_tag {    /* SIPI Channel Status Register 0 */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t RAR:1;
    vuint32_t TID:3;                   /* Transaction ID of transmitted frame. */
    vuint32_t ACKR:1;
    vuint32_t CB:1;                    /* Channel Busy. */
    vuint32_t  :2;
  } B;
} SIPI_CSR0_tag;

typedef union SIPI_CIR0_union_tag {    /* SIPI Channel Interrupt Register 0 */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WAIE:1;                  /* Write Acknowledge Interrupt Enable. */
    vuint32_t RAIE:1;                  /* Read Answer Interrupt Enable. */
    vuint32_t TCIE:1;                  /* Trigger Command Interrupt Enable. */
    vuint32_t TOIE:1;                  /* Timeout Error Interrupt Enabled. */
    vuint32_t TIDIE:1;                 /* Transaction ID Error Interrupt Enable. */
    vuint32_t ACKIE:1;                 /* Acknowledge Error Interrupt Enable. */
  } B;
} SIPI_CIR0_tag;

typedef union SIPI_CTOR0_union_tag {   /* SIPI Channel Timeout Register 0 */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t TOR:8;                   /* Timeout value for transmitted requests. */
  } B;
} SIPI_CTOR0_tag;

typedef union SIPI_CCRC0_union_tag {   /* SIPI Channel CRC Register 0 */
  vuint32_t R;
  struct {
    vuint32_t CRCI:16;
    vuint32_t CRCT:16;
  } B;
} SIPI_CCRC0_tag;

typedef union SIPI_CAR0_union_tag {    /* SIPI Channel Address Register 0 */
  vuint32_t R;
  struct {
    vuint32_t CAR:32;
  } B;
} SIPI_CAR0_tag;

typedef union SIPI_CDR0_union_tag {    /* SIPI Channel Data Register 0 */
  vuint32_t R;
  struct {
    vuint32_t CDR:32;
  } B;
} SIPI_CDR0_tag;

typedef union SIPI_CCR1_union_tag {    /* SIPI Channel Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :15;
    vuint32_t TC:1;                    /* Send Trigger Command. */
    vuint32_t  :8;
    vuint32_t WL:2;                    /* Word Length Transfer. */
    vuint32_t CHEN:1;                  /* Channel Enable. */
    vuint32_t ST:1;
    vuint32_t IDT:1;                   /* ID Read Request Transfer. */
    vuint32_t RRT:1;
    vuint32_t WRT:1;                   /* Write Request Transfer. */
    vuint32_t DEN:1;                   /* DMA Enable. */
  } B;
} SIPI_CCR1_tag;

typedef union SIPI_CSR1_union_tag {    /* SIPI Channel Status Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t RAR:1;
    vuint32_t TID:3;
    vuint32_t ACKR:1;
    vuint32_t CB:1;                    /* Channel Busy. */
    vuint32_t  :2;
  } B;
} SIPI_CSR1_tag;

typedef union SIPI_CIR1_union_tag {    /* SIPI Channel Interrupt Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WAIE:1;
    vuint32_t RAIE:1;
    vuint32_t TCIE:1;
    vuint32_t TOIE:1;
    vuint32_t TIDIE:1;
    vuint32_t ACKIE:1;
  } B;
} SIPI_CIR1_tag;

typedef union SIPI_CTOR1_union_tag {   /* SIPI Channel Timeout Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t TOR:8;                   /* Timeout value for transmitted requests. */
  } B;
} SIPI_CTOR1_tag;

typedef union SIPI_CCRC1_union_tag {   /* SIPI Channel CRC Register 1 */
  vuint32_t R;
  struct {
    vuint32_t CRCI:16;
    vuint32_t CRCT:16;
  } B;
} SIPI_CCRC1_tag;

typedef union SIPI_CAR1_union_tag {    /* SIPI Channel Address Register 1 */
  vuint32_t R;
  struct {
    vuint32_t CAR:32;
  } B;
} SIPI_CAR1_tag;

typedef union SIPI_CDR1_union_tag {    /* SIPI Channel Data Register 1 */
  vuint32_t R;
  struct {
    vuint32_t CDR:32;
  } B;
} SIPI_CDR1_tag;

typedef union SIPI_CCR2_union_tag {    /* SIPI Channel Control Register 2 */
  vuint32_t R;
  struct {
    vuint32_t  :15;
    vuint32_t TC:1;                    /* Send Trigger Command. */
    vuint32_t  :8;
    vuint32_t WL:2;                    /* Word Length Transfer. */
    vuint32_t CHEN:1;                  /* Channel Enable. */
    vuint32_t ST:1;
    vuint32_t IDT:1;                   /* ID Read Request Transfer. */
    vuint32_t RRT:1;                   /* Read Request Transfer. */
    vuint32_t WRT:1;                   /* Write Request Transfer. */
    vuint32_t DEN:1;                   /* DMA Enable. */
  } B;
} SIPI_CCR2_tag;

typedef union SIPI_CSR2_union_tag {    /* SIPI Channel Status Register 2 */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t RAR:1;
    vuint32_t TID:3;                   /* Transaction ID of transmitted frame. */
    vuint32_t ACKR:1;
    vuint32_t CB:1;                    /* Channel Busy. */
    vuint32_t  :2;
  } B;
} SIPI_CSR2_tag;

typedef union SIPI_CIR2_union_tag {    /* SIPI Channel Interrupt Register 2 */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WAIE:1;
    vuint32_t RAIE:1;
    vuint32_t TCIE:1;
    vuint32_t TOIE:1;
    vuint32_t TIDIE:1;
    vuint32_t ACKIE:1;
  } B;
} SIPI_CIR2_tag;

typedef union SIPI_CTOR2_union_tag {   /* SIPI Channel Timeout Register 2 */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t TOR:8;
  } B;
} SIPI_CTOR2_tag;

typedef union SIPI_CCRC2_union_tag {   /* SIPI Channel CRC Register 2 */
  vuint32_t R;
  struct {
    vuint32_t CRCI:16;
    vuint32_t CRCT:16;
  } B;
} SIPI_CCRC2_tag;

typedef union SIPI_CAR2_union_tag {    /* SIPI Channel Address Register 2 */
  vuint32_t R;
  struct {
    vuint32_t CAR:32;
  } B;
} SIPI_CAR2_tag;

typedef union SIPI_CDR2_union_tag {    /* SIPI Channel Data Register 2 */
  vuint32_t R;
  struct {
    vuint32_t CDR2:32;
  } B;
} SIPI_CDR2_tag;

typedef union SIPI_CCR3_union_tag {    /* SIPI Channel Control Register 3 */
  vuint32_t R;
  struct {
    vuint32_t  :15;
    vuint32_t TC:1;                    /* Send Trigger Command. */
    vuint32_t  :8;
    vuint32_t WL:2;                    /* Word Length Transfer. */
    vuint32_t CHEN:1;                  /* Channel Enable. */
    vuint32_t ST:1;                    /* Streaming Transfer. */
    vuint32_t IDT:1;                   /* ID Read Request Transfer. */
    vuint32_t RRT:1;                   /* Read Request Transfer. */
    vuint32_t WRT:1;                   /* Write Request Transfer. */
    vuint32_t DEN:1;                   /* DMA Enable. */
  } B;
} SIPI_CCR3_tag;

typedef union SIPI_CSR3_union_tag {    /* SIPI Channel Status Register 3 */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t RAR:1;
    vuint32_t TID:3;                   /* Transaction ID of transmitted frame. */
    vuint32_t ACKR:1;
    vuint32_t CB:1;                    /* Channel Busy. */
    vuint32_t  :2;
  } B;
} SIPI_CSR3_tag;

typedef union SIPI_CIR3_union_tag {    /* SIPI Channel Interrupt Register 3 */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WAIE:1;
    vuint32_t RAIE:1;
    vuint32_t TCIE:1;
    vuint32_t TOIE:1;
    vuint32_t TIDIE:1;
    vuint32_t ACKIE:1;
  } B;
} SIPI_CIR3_tag;

typedef union SIPI_CTOR3_union_tag {   /* SIPI Channel Timeout Register 3 */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t TOR:8;                   /* Timeout value for transmitted requests. */
  } B;
} SIPI_CTOR3_tag;

typedef union SIPI_CCRC3_union_tag {   /* SIPI Channel CRC Register 3 */
  vuint32_t R;
  struct {
    vuint32_t CRCI:16;
    vuint32_t CRCT:16;
  } B;
} SIPI_CCRC3_tag;

typedef union SIPI_CAR3_union_tag {    /* SIPI Channel Address Register 3 */
  vuint32_t R;
  struct {
    vuint32_t CAR:32;
  } B;
} SIPI_CAR3_tag;

typedef union SIPI_CDR3_union_tag {    /* SIPI Channel Data Register 3 */
  vuint32_t R;
  struct {
    vuint32_t CDR:32;
  } B;
} SIPI_CDR3_tag;

typedef union SIPI_MCR_union_tag {     /* SIPI Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t FRZ:1;                   /* Freeze Enable */
    vuint32_t  :1;
    vuint32_t HALT:1;                  /* Halt Mode Enable */
    vuint32_t  :2;
    vuint32_t PRSCLR:11;               /* Timeout counter prescaler */
    vuint32_t AID:2;                   /* Address Increment/Decrement */
    vuint32_t  :3;
    vuint32_t CRCIE:1;                 /* CRC Error Interrupt Enable */
    vuint32_t MCRIE:1;                 /* Max Count Reached Interrupt Enable */
    vuint32_t  :4;
    vuint32_t CHNSB:1;                 /* Channel coding select bit. */
    vuint32_t TEN:1;                   /* Target Enable */
    vuint32_t INIT:1;                  /* Initialization Mode */
    vuint32_t MOEN:1;                  /* Module Enable */
    vuint32_t SR:1;                    /* Soft Reset */
  } B;
} SIPI_MCR_tag;

typedef union SIPI_SR_union_tag {      /* SIPI Status Register */
  vuint32_t R;
  struct {
    vuint32_t FRZACK:1;
    vuint32_t LPMACK:1;                /* Low Power Mode Acknowledge. */
    vuint32_t  :19;
    vuint32_t GCRCE:1;
    vuint32_t MCR:1;                   /* Maximum Count Reached. */
    vuint32_t  :1;
    vuint32_t TE:4;
    vuint32_t STATE:4;
  } B;
} SIPI_SR_tag;

typedef union SIPI_MAXCR_union_tag {   /* SIPI Max Count Register */
  vuint32_t R;
  struct {
    vuint32_t MXCNT:30;
    vuint32_t  :2;
  } B;
} SIPI_MAXCR_tag;

typedef union SIPI_ARR_union_tag {     /* SIPI Address Reload Register */
  vuint32_t R;
  struct {
    vuint32_t ADRLD:30;
    vuint32_t  :2;
  } B;
} SIPI_ARR_tag;

typedef union SIPI_ACR_union_tag {     /* SIPI Address Count Register */
  vuint32_t R;
  struct {
    vuint32_t ADCNT:30;                /* Feflects the count value of address counter at target node. */
    vuint32_t  :2;
  } B;
} SIPI_ACR_tag;

typedef union SIPI_ERR_union_tag {     /* SIPI Error Register */
  vuint32_t R;
  struct {
    vuint32_t  :5;
    vuint32_t TOE3:1;
    vuint32_t TIDE3:1;
    vuint32_t ACKE3:1;
    vuint32_t  :5;
    vuint32_t TOE2:1;
    vuint32_t TIDE2:1;
    vuint32_t ACKE2:1;
    vuint32_t  :5;
    vuint32_t TOE1:1;
    vuint32_t TIDE1:1;
    vuint32_t ACKE1:1;
    vuint32_t  :5;
    vuint32_t TOE0:1;
    vuint32_t TIDE0:1;
    vuint32_t ACKE0:1;
  } B;
} SIPI_ERR_tag;

struct SIPI_tag {
  SIPI_CCR0_tag CCR0;                  /* SIPI Channel Control Register 0 */
  SIPI_CSR0_tag CSR0;                  /* SIPI Channel Status Register 0 */
  uint8_t SIPI_reserved0[4];
  SIPI_CIR0_tag CIR0;                  /* SIPI Channel Interrupt Register 0 */
  SIPI_CTOR0_tag CTOR0;                /* SIPI Channel Timeout Register 0 */
  SIPI_CCRC0_tag CCRC0;                /* SIPI Channel CRC Register 0 */
  SIPI_CAR0_tag CAR0;                  /* SIPI Channel Address Register 0 */
  SIPI_CDR0_tag CDR0;                  /* SIPI Channel Data Register 0 */
  SIPI_CCR1_tag CCR1;                  /* SIPI Channel Control Register 1 */
  SIPI_CSR1_tag CSR1;                  /* SIPI Channel Status Register 1 */
  uint8_t SIPI_reserved1[4];
  SIPI_CIR1_tag CIR1;                  /* SIPI Channel Interrupt Register 1 */
  SIPI_CTOR1_tag CTOR1;                /* SIPI Channel Timeout Register 1 */
  SIPI_CCRC1_tag CCRC1;                /* SIPI Channel CRC Register 1 */
  SIPI_CAR1_tag CAR1;                  /* SIPI Channel Address Register 1 */
  SIPI_CDR1_tag CDR1;                  /* SIPI Channel Data Register 1 */
  SIPI_CCR2_tag CCR2;                  /* SIPI Channel Control Register 2 */
  SIPI_CSR2_tag CSR2;                  /* SIPI Channel Status Register 2 */
  uint8_t SIPI_reserved2[4];
  SIPI_CIR2_tag CIR2;                  /* SIPI Channel Interrupt Register 2 */
  SIPI_CTOR2_tag CTOR2;                /* SIPI Channel Timeout Register 2 */
  SIPI_CCRC2_tag CCRC2;                /* SIPI Channel CRC Register 2 */
  SIPI_CAR2_tag CAR2;                  /* SIPI Channel Address Register 2 */
  SIPI_CDR2_tag CDR2[8];               /* SIPI Channel Data Register 2 */
  SIPI_CCR3_tag CCR3;                  /* SIPI Channel Control Register 3 */
  SIPI_CSR3_tag CSR3;                  /* SIPI Channel Status Register 3 */
  uint8_t SIPI_reserved3[4];
  SIPI_CIR3_tag CIR3;                  /* SIPI Channel Interrupt Register 3 */
  SIPI_CTOR3_tag CTOR3;                /* SIPI Channel Timeout Register 3 */
  SIPI_CCRC3_tag CCRC3;                /* SIPI Channel CRC Register 3 */
  SIPI_CAR3_tag CAR3;                  /* SIPI Channel Address Register 3 */
  SIPI_CDR3_tag CDR3;                  /* SIPI Channel Data Register 3 */
  SIPI_MCR_tag MCR;                    /* SIPI Module Configuration Register */
  SIPI_SR_tag SR;                      /* SIPI Status Register */
  SIPI_MAXCR_tag MAXCR;                /* SIPI Max Count Register */
  SIPI_ARR_tag ARR;                    /* SIPI Address Reload Register */
  SIPI_ACR_tag ACR;                    /* SIPI Address Count Register */
  SIPI_ERR_tag ERR;                    /* SIPI Error Register */
};


/* ============================================================================
   =============================== Module: SIUL2 ==============================
   ============================================================================ */

typedef union SIUL2_MIDR1_union_tag {  /* MCU ID Register #1 */
  vuint32_t R;
  struct {
    vuint32_t PARTNUM:16;
    vuint32_t ED:1;
    vuint32_t PKG:5;
    vuint32_t  :2;
    vuint32_t MAJOR_MASK:4;
    vuint32_t MINOR_MASK:4;
  } B;
} SIUL2_MIDR1_tag;

typedef union SIUL2_MIDR2_union_tag {  /* MCU ID Register #2 */
  vuint32_t R;
  struct {
    vuint32_t SF:1;
    vuint32_t FLASH_SIZE_1:4;
    vuint32_t FLASH_SIZE_2:4;
    vuint32_t  :7;
    vuint32_t FAMILYNUM:8;
    vuint32_t  :8;
  } B;
} SIUL2_MIDR2_tag;

typedef union SIUL2_DISR0_union_tag {  /* DMA/Interrupt Status Flag Register0 */
  vuint32_t R;
  struct {
    vuint32_t  :20;
    vuint32_t EIF11:1;
    vuint32_t EIF10:1;
    vuint32_t EIF9:1;
    vuint32_t EIF8:1;
    vuint32_t  :2;
    vuint32_t EIF5:1;
    vuint32_t EIF4:1;
    vuint32_t EIF3:1;
    vuint32_t EIF2:1;
    vuint32_t EIF1:1;
    vuint32_t EIF0:1;
  } B;
} SIUL2_DISR0_tag;

typedef union SIUL2_DIRER0_union_tag { /* DMA/Interrupt Request Enable Register0 */
  vuint32_t R;
  struct {
    vuint32_t  :20;
    vuint32_t EIRE11:1;
    vuint32_t EIRE10:1;
    vuint32_t EIRE9:1;
    vuint32_t EIRE8:1;
    vuint32_t  :2;
    vuint32_t EIRE5:1;
    vuint32_t EIRE4:1;
    vuint32_t EIRE3:1;
    vuint32_t EIRE2:1;
    vuint32_t EIRE1:1;
    vuint32_t EIRE0:1;
  } B;
} SIUL2_DIRER0_tag;

typedef union SIUL2_DIRSR0_union_tag { /* DMA/Interrupt Request Select Register0 */
  vuint32_t R;
  struct {
    vuint32_t  :20;
    vuint32_t DIRS11:1;
    vuint32_t DIRS10:1;
    vuint32_t DIRS9:1;
    vuint32_t DIRS8:1;
    vuint32_t  :2;
    vuint32_t DIRS5:1;
    vuint32_t DIRS4:1;
    vuint32_t DIRS3:1;
    vuint32_t DIRS2:1;
    vuint32_t DIRS1:1;
    vuint32_t DIRS0:1;
  } B;
} SIUL2_DIRSR0_tag;

typedef union SIUL2_IREER0_union_tag { /* Interrupt Rising-Edge Event Enable Register0 */
  vuint32_t R;
  struct {
    vuint32_t  :20;
    vuint32_t IREE11:1;
    vuint32_t IREE10:1;
    vuint32_t IREE9:1;
    vuint32_t IREE8:1;
    vuint32_t  :2;
    vuint32_t IREE5:1;
    vuint32_t IREE4:1;
    vuint32_t IREE3:1;
    vuint32_t IREE2:1;
    vuint32_t IREE1:1;
    vuint32_t IREE0:1;
  } B;
} SIUL2_IREER0_tag;

typedef union SIUL2_IFEER0_union_tag { /* Interrupt Falling-Edge Event Enable Register0 */
  vuint32_t R;
  struct {
    vuint32_t  :20;
    vuint32_t IFEE11:1;
    vuint32_t IFEE10:1;
    vuint32_t IFEE9:1;
    vuint32_t IFEE8:1;
    vuint32_t  :2;
    vuint32_t IFEE5:1;
    vuint32_t IFEE4:1;
    vuint32_t IFEE3:1;
    vuint32_t IFEE2:1;
    vuint32_t IFEE1:1;
    vuint32_t IFEE0:1;
  } B;
} SIUL2_IFEER0_tag;

typedef union SIUL2_IFER0_union_tag {  /* Interrupt Filter Enable Register0 */
  vuint32_t R;
  struct {
    vuint32_t  :20;
    vuint32_t IFE11:1;
    vuint32_t IFE10:1;
    vuint32_t IFE9:1;
    vuint32_t IFE8:1;
    vuint32_t  :2;
    vuint32_t IFE5:1;
    vuint32_t IFE4:1;
    vuint32_t IFE3:1;
    vuint32_t IFE2:1;
    vuint32_t IFE1:1;
    vuint32_t IFE0:1;
  } B;
} SIUL2_IFER0_tag;

typedef union SIUL2_IFMCR_union_tag {  /* Interrupt Filter Maximum Counter Register */
  vuint32_t R;
  struct {
    vuint32_t  :28;
    vuint32_t MAXCNTx:4;
  } B;
} SIUL2_IFMCR_tag;

typedef union SIUL2_IFCPR_union_tag {  /* Interrupt Filter Clock Prescaler */
  vuint32_t R;
  struct {
    vuint32_t  :28;
    vuint32_t IFCP:4;
  } B;
} SIUL2_IFCPR_tag;

typedef union SIUL2_SCR0_union_tag {   /* SoC Configuration Register0 */
  vuint32_t R;
  struct {
    vuint32_t FEC_MODE:1;
    vuint32_t  :7;
    vuint32_t ESR0_ASSERT:1;
    vuint32_t  :23;
  } B;
} SIUL2_SCR0_tag;

typedef union SIUL2_MSCR_IO_union_tag { /* I/O Pin Multiplexed Signal Configuration Registers */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t OERC:3;
    vuint32_t  :1;
    vuint32_t ODC:3;
    vuint32_t SMC:1;
    vuint32_t APC:1;
    vuint32_t ILS:2;
    vuint32_t IBE:1;
    vuint32_t HYS:1;
    vuint32_t WPDE:1;
    vuint32_t WPUE:1;
    vuint32_t INV:1;
    vuint32_t  :7;
    vuint32_t SSS:8;
  } B;
} SIUL2_MSCR_IO_tag;

typedef union SIUL2_MSCR_MUX_union_tag { /* Multiplexed Signal Configuration Register for Multiplexed Input Selection */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t INV:1;
    vuint32_t  :7;
    vuint32_t SSS:8;
  } B;
} SIUL2_MSCR_MUX_tag;

typedef union SIUL2_GPDO_union_tag {   /* GPIO Pad Data Out Register */
  vuint8_t R;
  struct {
    vuint8_t  :7;
    vuint8_t PDO:1;
  } B;
} SIUL2_GPDO_tag;

typedef union SIUL2_GPDI_union_tag {   /* GPIO Pad Data In Register */
  vuint8_t R;
  struct {
    vuint8_t  :7;
    vuint8_t PDI:1;
  } B;
} SIUL2_GPDI_tag;

typedef union SIUL2_PGPDO_union_tag {  /* Parallel GPIO Pad Data Out Register */
  vuint16_t R;
  struct {
    vuint16_t PPDO:16;
  } B;
} SIUL2_PGPDO_tag;

typedef union SIUL2_PGPDI_union_tag {  /* Parallel GPIO Pad Data In Register */
  vuint16_t R;
  struct {
    vuint16_t PPDI:16;
  } B;
} SIUL2_PGPDI_tag;

typedef union SIUL2_MPGPDO_union_tag { /* Masked Parallel GPIO Pad Data Out Register */
  vuint32_t R;
  struct {
    vuint32_t MASK:16;
    vuint32_t MPPDO:16;
  } B;
} SIUL2_MPGPDO_tag;

struct SIUL2_tag {
  uint8_t SIUL2_reserved0[4];
  SIUL2_MIDR1_tag MIDR1;               /* MCU ID Register #1 */
  SIUL2_MIDR2_tag MIDR2;               /* MCU ID Register #2 */
  uint8_t SIUL2_reserved1[4];
  SIUL2_DISR0_tag DISR0;               /* DMA/Interrupt Status Flag Register0 */
  uint8_t SIUL2_reserved2[4];
  SIUL2_DIRER0_tag DIRER0;             /* DMA/Interrupt Request Enable Register0 */
  uint8_t SIUL2_reserved3[4];
  SIUL2_DIRSR0_tag DIRSR0;             /* DMA/Interrupt Request Select Register0 */
  uint8_t SIUL2_reserved4[4];
  SIUL2_IREER0_tag IREER0;             /* Interrupt Rising-Edge Event Enable Register0 */
  uint8_t SIUL2_reserved5[4];
  SIUL2_IFEER0_tag IFEER0;             /* Interrupt Falling-Edge Event Enable Register0 */
  uint8_t SIUL2_reserved6[4];
  SIUL2_IFER0_tag IFER0;               /* Interrupt Filter Enable Register0 */
  uint8_t SIUL2_reserved7[4];
  SIUL2_IFMCR_tag IFMCR[32];           /* Interrupt Filter Maximum Counter Register */
  SIUL2_IFCPR_tag IFCPR;               /* Interrupt Filter Clock Prescaler */
  uint8_t SIUL2_reserved8[60];
  SIUL2_SCR0_tag SCR0;                 /* SoC Configuration Register0 */
  uint8_t SIUL2_reserved9[316];
  SIUL2_MSCR_IO_tag MSCR_IO[512];      /* I/O Pin Multiplexed Signal Configuration Registers */
  SIUL2_MSCR_MUX_tag MSCR_MUX[512];    /* Multiplexed Signal Configuration Register for Multiplexed Input Selection */
  uint8_t SIUL2_reserved10[192];
  SIUL2_GPDO_tag GPDO[512];            /* GPIO Pad Data Out Register */
  SIUL2_GPDI_tag GPDI[512];            /* GPIO Pad Data In Register */
  SIUL2_PGPDO_tag PGPDO[32];           /* Parallel GPIO Pad Data Out Register */
  SIUL2_PGPDI_tag PGPDI[32];           /* Parallel GPIO Pad Data In Register */
  SIUL2_MPGPDO_tag MPGPDO[32];         /* Masked Parallel GPIO Pad Data Out Register */
};


/* ============================================================================
   =============================== Module: SMPU ===============================
   ============================================================================ */

typedef union SMPU_CESR0_union_tag {   /* Control/Error Status Register 0 */
  vuint32_t R;
  struct {
    vuint32_t MERR:16;
    vuint32_t  :1;
    vuint32_t  :11;
    vuint32_t HRL:3;
    vuint32_t GVLD:1;
  } B;
} SMPU_CESR0_tag;

typedef union SMPU_CESR1_union_tag {   /* Control/Error Status Register 1 */
  vuint32_t R;
  struct {
    vuint32_t MEOVR:16;
    vuint32_t  :1;
    vuint32_t  :11;
    vuint32_t NRGD:4;
  } B;
} SMPU_CESR1_tag;

typedef union SMPU_ERROR_EAR_union_tag { /* Error Address Register, Bus Master n */
  vuint32_t R;
  struct {
    vuint32_t EADDR:32;
  } B;
} SMPU_ERROR_EAR_tag;

typedef union SMPU_ERROR_EDR_union_tag { /* Error Detail Register, Bus Master n */
  vuint32_t R;
  struct {
    vuint32_t EACD:24;
    vuint32_t  :1;
    vuint32_t EATTR:2;
    vuint32_t ERW:1;
    vuint32_t EMN:4;
  } B;
} SMPU_ERROR_EDR_tag;

typedef struct SMPU_ERROR_struct_tag {
  SMPU_ERROR_EAR_tag EAR;              /* Error Address Register, Bus Master n */
  SMPU_ERROR_EDR_tag EDR;              /* Error Detail Register, Bus Master n */
} SMPU_ERROR_tag;

typedef union SMPU_RGD_WORD0_union_tag { /* Region Descriptor n, Word 0 */
  vuint32_t R;
  struct {
    vuint32_t SRTADDR:32;
  } B;
} SMPU_RGD_WORD0_tag;

typedef union SMPU_RGD_WORD1_union_tag { /* Region Descriptor n, Word 1 */
  vuint32_t R;
  struct {
    vuint32_t ENDADDR:32;
  } B;
} SMPU_RGD_WORD1_tag;

typedef union SMPU_RGD_WORD2_union_tag { /* Region Descriptor n, Word 2 Format 0 */
  vuint32_t R;
  struct {
    vuint32_t M0P:2;
    vuint32_t M1P:2;
    vuint32_t M2P:2;
    vuint32_t M3P:2;
    vuint32_t M4P:2;
    vuint32_t M5P:2;
    vuint32_t M6P:2;
    vuint32_t M7P:2;
    vuint32_t M8P:2;
    vuint32_t M9P:2;
    vuint32_t M10P:2;
    vuint32_t M11P:2;
    vuint32_t M12P:2;
    vuint32_t M13P:2;
    vuint32_t M14P:2;
    vuint32_t M15P:2;
  } B;
} SMPU_RGD_WORD2_tag;

typedef union SMPU_RGD_WORD3_union_tag { /* Region Descriptor n, Word 3 */
  vuint32_t R;
  struct {
    vuint32_t  :27;
    vuint32_t FMT:1;
    vuint32_t RO:1;
    vuint32_t  :1;
    vuint32_t CI:1;
    vuint32_t VLD:1;
  } B;
} SMPU_RGD_WORD3_tag;

typedef struct SMPU_RGD_struct_tag {
  SMPU_RGD_WORD0_tag WORD0;            /* Region Descriptor n, Word 0 */
  SMPU_RGD_WORD1_tag WORD1;            /* Region Descriptor n, Word 1 */
  SMPU_RGD_WORD2_tag WORD2;            /* Region Descriptor n, Word 2 Format 0 */
  SMPU_RGD_WORD3_tag WORD3;            /* Region Descriptor n, Word 3 */
} SMPU_RGD_tag;

struct SMPU_tag {
  SMPU_CESR0_tag CESR0;                /* Control/Error Status Register 0 */
  SMPU_CESR1_tag CESR1;                /* Control/Error Status Register 1 */
  uint8_t SMPU_reserved0[248];
  SMPU_ERROR_tag ERROR[16];
  uint8_t SMPU_reserved1[640];
  SMPU_RGD_tag RGD[12];
};


/* ============================================================================
   =============================== Module: SRX ================================
   ============================================================================ */

typedef union SRX_GBL_CTRL_union_tag { /* Global Control Register */
  vuint32_t R;
  struct {
    vuint32_t TSPRSC:8;
    vuint32_t  :8;
    vuint32_t  :1;
    vuint32_t  :5;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t FAST_CLR:1;
    vuint32_t  :1;
    vuint32_t DBG_FRZ:1;
    vuint32_t  :1;
    vuint32_t SENT_EN:1;
  } B;
} SRX_GBL_CTRL_tag;

typedef union SRX_CHNL_EN_union_tag {  /* Channel Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t EN_CH:8;
  } B;
} SRX_CHNL_EN_tag;

typedef union SRX_GBL_STATUS_union_tag { /* Global Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t FMDU:1;
    vuint32_t SMDU:1;
    vuint32_t  :8;
  } B;
} SRX_GBL_STATUS_tag;

typedef union SRX_FMSG_RDY_union_tag { /* Fast Message Ready Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t F_RDY:8;
  } B;
} SRX_FMSG_RDY_tag;

typedef union SRX_SMSG_RDY_union_tag { /* Slow Serial Message Ready Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t S_RDY:8;
  } B;
} SRX_SMSG_RDY_tag;

typedef union SRX_DATA_CTRL1_union_tag { /* Data Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t NIBBCH0:3;
    vuint32_t  :1;
    vuint32_t NIBBCH1:3;
    vuint32_t  :1;
    vuint32_t NIBBCH2:3;
    vuint32_t  :1;
    vuint32_t NIBBCH3:3;
    vuint32_t  :1;
    vuint32_t NIBBCH4:3;
    vuint32_t  :1;
    vuint32_t NIBBCH5:3;
    vuint32_t  :1;
    vuint32_t NIBBCH6:3;
    vuint32_t  :1;
    vuint32_t NIBBCH7:3;
  } B;
} SRX_DATA_CTRL1_tag;

typedef union SRX_FDMA_CTRL_union_tag { /* Fast Message DMA Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t FDMA_EN:8;
  } B;
} SRX_FDMA_CTRL_tag;

typedef union SRX_SDMA_CTRL_union_tag { /* Slow Serial Message DMA Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t SDMA_EN:8;
  } B;
} SRX_SDMA_CTRL_tag;

typedef union SRX_FRDY_IE_union_tag {  /* Fast Message Ready Interrupt Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t FRDY_IE:8;
  } B;
} SRX_FRDY_IE_tag;

typedef union SRX_SRDY_IE_union_tag {  /* Slow Serial Message Ready Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t SRDY_IE:8;
  } B;
} SRX_SRDY_IE_tag;

typedef union SRX_DMA_FMSG_DATA_union_tag { /* DMA Fast Message Data Read Register */
  vuint32_t R;
  struct {
    vuint32_t CHNUM:4;
    vuint32_t SCNIB:4;
    vuint32_t DNIB1:4;
    vuint32_t DNIB2:4;
    vuint32_t DNIB3:4;
    vuint32_t DNIB4:4;
    vuint32_t DNIB5:4;
    vuint32_t DNIB6:4;
  } B;
} SRX_DMA_FMSG_DATA_tag;

typedef union SRX_DMA_FMSG_CRC_union_tag { /* DMA Fast Message CRC Read Register */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t CRC4b:4;
    vuint32_t  :16;
  } B;
} SRX_DMA_FMSG_CRC_tag;

typedef union SRX_DMA_FMSG_TS_union_tag { /* DMA Fast Message Time Stamp Read Register */
  vuint32_t R;
  struct {
    vuint32_t TS:32;
  } B;
} SRX_DMA_FMSG_TS_tag;

typedef union SRX_DMA_SMSG_BIT3_union_tag { /* DMA Slow Serial Message Bit3 Read Register */
  vuint32_t R;
  struct {
    vuint32_t CHNUM:4;
    vuint32_t TYPE:1;
    vuint32_t  :16;
    vuint32_t CFG:1;
    vuint32_t ID7_4_ID3_0:4;
    vuint32_t  :1;
    vuint32_t ID3_0_DATA15_12:4;
    vuint32_t  :1;
  } B;
} SRX_DMA_SMSG_BIT3_tag;

typedef union SRX_DMA_SMSG_BIT2_union_tag { /* DMA Slow Serial Message Bit2 Read Register */
  vuint32_t R;
  struct {
    vuint32_t  :10;
    vuint32_t SMCRC:6;
    vuint32_t  :4;
    vuint32_t DATA:12;
  } B;
} SRX_DMA_SMSG_BIT2_tag;

typedef union SRX_DMA_SMSG_TS_union_tag { /* DMA Slow Serial Message Time Stamp Read Register */
  vuint32_t R;
  struct {
    vuint32_t TS:32;
  } B;
} SRX_DMA_SMSG_TS_tag;

typedef union SRX_CH_CLK_CTRL_union_tag { /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t CM_PRSC:15;
    vuint32_t COMP_EN:1;
    vuint32_t  :1;
    vuint32_t PRSC:14;
  } B;
} SRX_CH_CLK_CTRL_tag;

typedef union SRX_CH_STATUS_union_tag { /* Channel 'n' Status Register (n=0 to (CH-1)) */
  vuint32_t R;
  struct {
    vuint32_t BUS_IDLE:1;
    vuint32_t  :3;
    vuint32_t CAL_RESYNC:1;
    vuint32_t CAL_20_25:1;
    vuint32_t SMSG_OFLW:1;
    vuint32_t FMSG_OFLW:1;
    vuint32_t  :1;
    vuint32_t PP_DIAG_ERR:1;
    vuint32_t CAL_LEN_ERR:1;
    vuint32_t CAL_DIAG_ERR:1;
    vuint32_t NIB_VAL_ERR:1;
    vuint32_t SMSG_CRC_ERR:1;
    vuint32_t FMSG_CRC_ERR:1;
    vuint32_t NUM_EDGES_ERR:1;
    vuint32_t  :16;
  } B;
} SRX_CH_STATUS_tag;

typedef union SRX_CH_CONFIG_union_tag { /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
  vuint32_t R;
  struct {
    vuint32_t BUS_IDLE_CNT:4;
    vuint32_t IE_CAL_RESYNC:1;
    vuint32_t IE_CAL_20_25:1;
    vuint32_t IE_SMSG_OFLW:1;
    vuint32_t IE_FMSG_OFLW:1;
    vuint32_t FCRC_CHK_OFF:1;
    vuint32_t IE_PP_DIAG_ERR:1;
    vuint32_t IE_CAL_LEN_ERR:1;
    vuint32_t IE_CAL_DIAG_ERR:1;
    vuint32_t IE_NIB_VAL_ERR:1;
    vuint32_t IE_SMSG_CRC_ERR:1;
    vuint32_t IE_FMSG_CRC_ERR:1;
    vuint32_t IE_NUM_EDGES_ERR:1;
    vuint32_t DCHNG_INT:1;
    vuint32_t CAL_RNG:1;
    vuint32_t PP_CHKSEL:1;
    vuint32_t FCRC_TYPE:1;
    vuint32_t FCRC_SC_EN:1;
    vuint32_t SCRC_TYPE:1;
    vuint32_t PAUSE_EN:1;
    vuint32_t SUCC_CAL_CHK:1;
    vuint32_t FIL_CNT:8;
  } B;
} SRX_CH_CONFIG_tag;

typedef struct SRX_CH_struct_tag {
  SRX_CH_CLK_CTRL_tag CLK_CTRL;        /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
  SRX_CH_STATUS_tag STATUS;            /* Channel 'n' Status Register (n=0 to (CH-1)) */
  SRX_CH_CONFIG_tag CONFIG;            /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
  uint8_t CH_reserved0[4];
} SRX_CH_tag;

typedef union SRX_CHANNEL_FMSG_DATA_union_tag { /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
  vuint32_t R;
  struct {
    vuint32_t CHNUM:4;
    vuint32_t SCNIB:4;
    vuint32_t DNIB1:4;
    vuint32_t DNIB2:4;
    vuint32_t DNIB3:4;
    vuint32_t DNIB4:4;
    vuint32_t DNIB5:4;
    vuint32_t DNIB6:4;
  } B;
} SRX_CHANNEL_FMSG_DATA_tag;

typedef union SRX_CHANNEL_FMSG_CRC_union_tag { /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t CRC4b:4;
    vuint32_t  :16;
  } B;
} SRX_CHANNEL_FMSG_CRC_tag;

typedef union SRX_CHANNEL_FMSG_TS_union_tag { /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
  vuint32_t R;
  struct {
    vuint32_t TS:32;
  } B;
} SRX_CHANNEL_FMSG_TS_tag;

typedef union SRX_CHANNEL_SMSG_BIT3_union_tag { /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
  vuint32_t R;
  struct {
    vuint32_t CHNUM:4;
    vuint32_t TYPE:1;
    vuint32_t  :16;
    vuint32_t CFG:1;
    vuint32_t ID7_4_ID3_0:4;
    vuint32_t  :1;
    vuint32_t ID3_0_DATA15_12:4;
    vuint32_t  :1;
  } B;
} SRX_CHANNEL_SMSG_BIT3_tag;

typedef union SRX_CHANNEL_SMSG_BIT2_union_tag { /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
  vuint32_t R;
  struct {
    vuint32_t  :10;
    vuint32_t SMCRC:6;
    vuint32_t  :4;
    vuint32_t DATA:12;
  } B;
} SRX_CHANNEL_SMSG_BIT2_tag;

typedef union SRX_CHANNEL_SMSG_TS_union_tag { /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
  vuint32_t R;
  struct {
    vuint32_t TS:32;
  } B;
} SRX_CHANNEL_SMSG_TS_tag;

typedef struct SRX_CHANNEL_struct_tag {
  SRX_CHANNEL_FMSG_DATA_tag FMSG_DATA; /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
  SRX_CHANNEL_FMSG_CRC_tag FMSG_CRC;   /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
  SRX_CHANNEL_FMSG_TS_tag FMSG_TS;     /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
  SRX_CHANNEL_SMSG_BIT3_tag SMSG_BIT3; /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
  SRX_CHANNEL_SMSG_BIT2_tag SMSG_BIT2; /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
  SRX_CHANNEL_SMSG_TS_tag SMSG_TS;     /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
} SRX_CHANNEL_tag;

struct SRX_tag {
  SRX_GBL_CTRL_tag GBL_CTRL;           /* Global Control Register */
  SRX_CHNL_EN_tag CHNL_EN;             /* Channel Enable Register */
  SRX_GBL_STATUS_tag GBL_STATUS;       /* Global Status Register */
  SRX_FMSG_RDY_tag FMSG_RDY;           /* Fast Message Ready Status Register */
  SRX_SMSG_RDY_tag SMSG_RDY;           /* Slow Serial Message Ready Status Register */
  uint8_t SRX_reserved0[4];
  SRX_DATA_CTRL1_tag DATA_CTRL1;       /* Data Control Register 1 */
  uint8_t SRX_reserved1[12];
  SRX_FDMA_CTRL_tag FDMA_CTRL;         /* Fast Message DMA Control Register */
  SRX_SDMA_CTRL_tag SDMA_CTRL;         /* Slow Serial Message DMA Control Register */
  uint8_t SRX_reserved2[4];
  SRX_FRDY_IE_tag FRDY_IE;             /* Fast Message Ready Interrupt Control Register */
  SRX_SRDY_IE_tag SRDY_IE;             /* Slow Serial Message Ready Interrupt Enable Register */
  uint8_t SRX_reserved3[4];
  SRX_DMA_FMSG_DATA_tag DMA_FMSG_DATA; /* DMA Fast Message Data Read Register */
  SRX_DMA_FMSG_CRC_tag DMA_FMSG_CRC;   /* DMA Fast Message CRC Read Register */
  SRX_DMA_FMSG_TS_tag DMA_FMSG_TS;     /* DMA Fast Message Time Stamp Read Register */
  uint8_t SRX_reserved4[4];
  SRX_DMA_SMSG_BIT3_tag DMA_SMSG_BIT3; /* DMA Slow Serial Message Bit3 Read Register */
  SRX_DMA_SMSG_BIT2_tag DMA_SMSG_BIT2; /* DMA Slow Serial Message Bit2 Read Register */
  SRX_DMA_SMSG_TS_tag DMA_SMSG_TS;     /* DMA Slow Serial Message Time Stamp Read Register */
  uint8_t SRX_reserved5[4];
  SRX_CH_tag CH[8];
  uint8_t SRX_reserved6[128];
  SRX_CHANNEL_tag CHANNEL[8];
};


/* ============================================================================
   =============================== Module: SSCM ===============================
   ============================================================================ */

typedef union SSCM_STATUS_union_tag {  /* SSCM System Status */
  vuint16_t R;
  struct {
    vuint16_t  :1;
    vuint16_t CER:1;                   /* Configuration Error */
    vuint16_t  :1;
    vuint16_t NXEN1:1;                 /* Processor 1 Nexus enable status */
    vuint16_t NXEN:1;                  /* Processor 0 Nexus enable status */
    vuint16_t  :1;
    vuint16_t  :1;
    vuint16_t  :1;
    vuint16_t BMODE:3;                 /* Device Boot Mode */
    vuint16_t VLE:1;                   /* Variable Length Instruction Mode */
    vuint16_t  :1;
    vuint16_t  :1;
    vuint16_t  :2;
  } B;
} SSCM_STATUS_tag;

typedef union SSCM_MEMCONFIG_union_tag { /* SSCM System Memory and ID Register */
  vuint16_t R;
  struct {
    vuint16_t JPIN:10;
    vuint16_t  :1;
    vuint16_t MREV:4;                  /* Minor Mask Revision */
    vuint16_t  :1;
  } B;
} SSCM_MEMCONFIG_tag;

typedef union SSCM_ERROR_union_tag {   /* SSCM Error Configuration Register */
  vuint16_t R;
  struct {
    vuint16_t  :14;
    vuint16_t PAE:1;                   /* Peripheral Bus Abort Enable. */
    vuint16_t RAE:1;                   /* Register Bus Abort Enable. */
  } B;
} SSCM_ERROR_tag;

typedef union SSCM_PWCMPH_union_tag {  /* Password comparison register low word */
  vuint32_t R;
  struct {
    vuint32_t PWD_HI:32;
  } B;
} SSCM_PWCMPH_tag;

typedef union SSCM_PWCMPL_union_tag {  /* Password comparison register low word */
  vuint32_t R;
  struct {
    vuint32_t PWD_LO:32;
  } B;
} SSCM_PWCMPL_tag;

typedef union SSCM_UOPS_union_tag {    /* SSCM HSM and User Option Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :28;
    vuint32_t HSB:3;                   /* HSM Boot Configuration */
    vuint32_t HSE:1;                   /* HSM Enabled */
  } B;
} SSCM_UOPS_tag;

typedef union SSCM_PSA_union_tag {     /* Processor Start Address Register */
  vuint32_t R;
  struct {
    vuint32_t SADR:32;                 /* Processor Start Address */
  } B;
} SSCM_PSA_tag;

typedef union SSCM_HSA_union_tag {     /* SSCM HSM Start Address Register */
  vuint32_t R;
  struct {
    vuint32_t HADR:32;                 /* HSM Start Address */
  } B;
} SSCM_HSA_tag;

typedef union SSCM_LCSTAT_union_tag {  /* Life Cycle Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t  :2;
    vuint32_t  :5;
    vuint32_t LC:3;                    /* Life Cycle */
  } B;
} SSCM_LCSTAT_tag;

struct SSCM_tag {
  SSCM_STATUS_tag STATUS;              /* SSCM System Status */
  SSCM_MEMCONFIG_tag MEMCONFIG;        /* SSCM System Memory and ID Register */
  uint8_t SSCM_reserved0[2];
  SSCM_ERROR_tag ERROR;                /* SSCM Error Configuration Register */
  uint8_t SSCM_reserved1[4];
  SSCM_PWCMPH_tag PWCMPH;              /* Password comparison register low word */
  SSCM_PWCMPL_tag PWCMPL;              /* Password comparison register low word */
  uint8_t SSCM_reserved2[12];
  SSCM_UOPS_tag UOPS;                  /* SSCM HSM and User Option Status Register */
  uint8_t SSCM_reserved3[4];
  SSCM_PSA_tag PSA;                    /* Processor Start Address Register */
  uint8_t SSCM_reserved4[4];
  SSCM_HSA_tag HSA;                    /* SSCM HSM Start Address Register */
  SSCM_LCSTAT_tag LCSTAT;              /* Life Cycle Status Register */
};


/* ============================================================================
   =============================== Module: STCU2 ==============================
   ============================================================================ */

typedef union STCU2_RUN_union_tag {    /* STCU2 Run Register */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t BYP:1;
    vuint32_t MBPLLEN:1;
    vuint32_t LBPLLEN:1;
    vuint32_t  :7;
    vuint32_t RUN:1;
  } B;
} STCU2_RUN_tag;

typedef union STCU2_RUNSW_union_tag {  /* STCU2 Run Software Register */
  vuint32_t R;
  struct {
    vuint32_t  :20;
    vuint32_t MBIE:1;
    vuint32_t LBIE:1;
    vuint32_t MBSWPLLEN:1;
    vuint32_t LBSWPLLEN:1;
    vuint32_t  :6;
    vuint32_t RUNSW_ABORT:1;
    vuint32_t RUNSW:1;
  } B;
} STCU2_RUNSW_tag;

typedef union STCU2_SKC_union_tag {    /* STCU2 SK Code Register */
  vuint32_t R;
  struct {
    vuint32_t SKC:32;
  } B;
} STCU2_SKC_tag;

typedef union STCU2_CFG_union_tag {    /* STCU2 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t PTR:7;
    vuint32_t LB_DELAY:8;
    vuint32_t  :7;
    vuint32_t WRP:1;
    vuint32_t  :2;
    vuint32_t CRCEN:1;
    vuint32_t PMOSEN:1;
    vuint32_t MBU:1;
    vuint32_t CLK_CFG:3;
  } B;
} STCU2_CFG_tag;

typedef union STCU2_PLL_CFG_union_tag { /* STCU2 PLL Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t PLLODF:6;
    vuint32_t  :5;
    vuint32_t PLLIDF:3;
    vuint32_t  :9;
    vuint32_t PLLLDF:7;
  } B;
} STCU2_PLL_CFG_tag;

typedef union STCU2_WDG_union_tag {    /* STCU2 Watchdog Register Granularity */
  vuint32_t R;
  struct {
    vuint32_t WDGEOC:32;
  } B;
} STCU2_WDG_tag;

typedef union STCU2_INT_FLG_union_tag { /* STCU2 Interrupt Flag Register */
  vuint32_t R;
  struct {
    vuint32_t  :30;
    vuint32_t MBIFLG:1;
    vuint32_t LBIFLG:1;
  } B;
} STCU2_INT_FLG_tag;

typedef union STCU2_CRCE_union_tag {   /* STCU2 CRC Expected Status Register */
  vuint32_t R;
  struct {
    vuint32_t CRCE:32;
  } B;
} STCU2_CRCE_tag;

typedef union STCU2_CRCR_union_tag {   /* STCU2 CRC Read Status Register */
  vuint32_t R;
  struct {
    vuint32_t CRCR:32;
  } B;
} STCU2_CRCR_tag;

typedef union STCU2_ERR_STAT_union_tag { /* STCU2 Error Register */
  vuint32_t R;
  struct {
    vuint32_t  :6;
    vuint32_t ABORTHW:1;
    vuint32_t ABORTSW:1;
    vuint32_t  :3;
    vuint32_t LOCKESW:1;
    vuint32_t WDTOSW:1;
    vuint32_t CRCSSW:1;
    vuint32_t ENGESW:1;
    vuint32_t INVPSW:1;
    vuint32_t  :6;
    vuint32_t UFSF:1;
    vuint32_t RFSF:1;
    vuint32_t  :3;
    vuint32_t LOCKE:1;
    vuint32_t WDTO:1;
    vuint32_t CRCS:1;
    vuint32_t ENGE:1;
    vuint32_t INVP:1;
  } B;
} STCU2_ERR_STAT_tag;

typedef union STCU2_ERR_FM_union_tag { /* STCU2 Error FM Register */
  vuint32_t R;
  struct {
    vuint32_t  :27;
    vuint32_t LOCKEUFM:1;
    vuint32_t WDTOUFM:1;
    vuint32_t CRCSUFM:1;
    vuint32_t ENGEUFM:1;
    vuint32_t INVPUFM:1;
  } B;
} STCU2_ERR_FM_tag;

typedef union STCU2_LBS_union_tag {    /* STCU2 Off-Line LBIST Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t LBS9:1;
    vuint32_t LBS8:1;
    vuint32_t LBS7:1;
    vuint32_t LBS6:1;
    vuint32_t LBS5:1;
    vuint32_t LBS4:1;
    vuint32_t LBS3:1;
    vuint32_t LBS2:1;
    vuint32_t LBS1:1;
    vuint32_t LBS0:1;
  } B;
} STCU2_LBS_tag;

typedef union STCU2_LBE_union_tag {    /* STCU2 Off-Line LBIST End Flag Register */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t LBE9:1;
    vuint32_t LBE8:1;
    vuint32_t LBE7:1;
    vuint32_t LBE6:1;
    vuint32_t LBE5:1;
    vuint32_t LBE4:1;
    vuint32_t LBE3:1;
    vuint32_t LBE2:1;
    vuint32_t LBE1:1;
    vuint32_t LBE0:1;
  } B;
} STCU2_LBE_tag;

typedef union STCU2_LBSSW_union_tag {  /* STCU2 On-Line LBIST Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t LBSSW9:1;
    vuint32_t LBSSW8:1;
    vuint32_t LBSSW7:1;
    vuint32_t LBSSW6:1;
    vuint32_t LBSSW5:1;
    vuint32_t LBSSW4:1;
    vuint32_t LBSSW3:1;
    vuint32_t LBSSW2:1;
    vuint32_t LBSSW1:1;
    vuint32_t LBSSW0:1;
  } B;
} STCU2_LBSSW_tag;

typedef union STCU2_LBESW_union_tag {  /* STCU2 On-Line LBIST End Flag Register */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t LBESW9:1;
    vuint32_t LBESW8:1;
    vuint32_t LBESW7:1;
    vuint32_t LBESW6:1;
    vuint32_t LBESW5:1;
    vuint32_t LBESW4:1;
    vuint32_t LBESW3:1;
    vuint32_t LBESW2:1;
    vuint32_t LBESW1:1;
    vuint32_t LBESW0:1;
  } B;
} STCU2_LBESW_tag;

typedef union STCU2_LBRMSW_union_tag { /* STCU2 On-Line LBIST Reset Management */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t LBRMSW9:1;
    vuint32_t LBRMSW8:1;
    vuint32_t LBRMSW7:1;
    vuint32_t LBRMSW6:1;
    vuint32_t LBRMSW5:1;
    vuint32_t LBRMSW4:1;
    vuint32_t LBRMSW3:1;
    vuint32_t LBRMSW2:1;
    vuint32_t LBRMSW1:1;
    vuint32_t LBRMSW0:1;
  } B;
} STCU2_LBRMSW_tag;

typedef union STCU2_LBUFM_union_tag {  /* STCU2 LBIST Unrecoverable FM Register */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t LBUFM9:1;
    vuint32_t LBUFM8:1;
    vuint32_t LBUFM7:1;
    vuint32_t LBUFM6:1;
    vuint32_t LBUFM5:1;
    vuint32_t LBUFM4:1;
    vuint32_t LBUFM3:1;
    vuint32_t LBUFM2:1;
    vuint32_t LBUFM1:1;
    vuint32_t LBUFM0:1;
  } B;
} STCU2_LBUFM_tag;

typedef union STCU2_MBSL_union_tag {   /* STCU2 Off-Line MBIST Status Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBS31:1;
    vuint32_t MBS30:1;
    vuint32_t MBS29:1;
    vuint32_t MBS28:1;
    vuint32_t MBS27:1;
    vuint32_t MBS26:1;
    vuint32_t MBS25:1;
    vuint32_t MBS24:1;
    vuint32_t MBS23:1;
    vuint32_t MBS22:1;
    vuint32_t MBS21:1;
    vuint32_t MBS20:1;
    vuint32_t MBS19:1;
    vuint32_t MBS18:1;
    vuint32_t MBS17:1;
    vuint32_t MBS16:1;
    vuint32_t MBS15:1;
    vuint32_t MBS14:1;
    vuint32_t MBS13:1;
    vuint32_t MBS12:1;
    vuint32_t MBS11:1;
    vuint32_t MBS10:1;
    vuint32_t MBS9:1;
    vuint32_t MBS8:1;
    vuint32_t MBS7:1;
    vuint32_t MBS6:1;
    vuint32_t MBS5:1;
    vuint32_t MBS4:1;
    vuint32_t MBS3:1;
    vuint32_t MBS2:1;
    vuint32_t MBS1:1;
    vuint32_t MBS0:1;
  } B;
} STCU2_MBSL_tag;

typedef union STCU2_MBSM_union_tag {   /* STCU2 Off-Line MBIST Status Medium Register */
  vuint32_t R;
  struct {
    vuint32_t MBS63:1;
    vuint32_t MBS62:1;
    vuint32_t MBS61:1;
    vuint32_t MBS60:1;
    vuint32_t MBS59:1;
    vuint32_t MBS58:1;
    vuint32_t MBS57:1;
    vuint32_t MBS56:1;
    vuint32_t MBS55:1;
    vuint32_t MBS54:1;
    vuint32_t MBS53:1;
    vuint32_t MBS52:1;
    vuint32_t MBS51:1;
    vuint32_t MBS50:1;
    vuint32_t MBS49:1;
    vuint32_t MBS48:1;
    vuint32_t MBS47:1;
    vuint32_t MBS46:1;
    vuint32_t MBS45:1;
    vuint32_t MBS44:1;
    vuint32_t MBS43:1;
    vuint32_t MBS42:1;
    vuint32_t MBS41:1;
    vuint32_t MBS40:1;
    vuint32_t MBS39:1;
    vuint32_t MBS38:1;
    vuint32_t MBS37:1;
    vuint32_t MBS36:1;
    vuint32_t MBS35:1;
    vuint32_t MBS34:1;
    vuint32_t MBS33:1;
    vuint32_t MBS32:1;
  } B;
} STCU2_MBSM_tag;

typedef union STCU2_MBSH_union_tag {   /* STCU2 Off-Line MBIST Status High Register */
  vuint32_t R;
  struct {
    vuint32_t  :18;
    vuint32_t MBS77:1;
    vuint32_t MBS76:1;
    vuint32_t MBS75:1;
    vuint32_t MBS74:1;
    vuint32_t MBS73:1;
    vuint32_t MBS72:1;
    vuint32_t MBS71:1;
    vuint32_t MBS70:1;
    vuint32_t MBS69:1;
    vuint32_t MBS68:1;
    vuint32_t MBS67:1;
    vuint32_t MBS66:1;
    vuint32_t MBS65:1;
    vuint32_t MBS64:1;
  } B;
} STCU2_MBSH_tag;

typedef union STCU2_MBEL_union_tag {   /* STCU2 Off-Line MBIST End Flag Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBE31:1;
    vuint32_t MBE30:1;
    vuint32_t MBE29:1;
    vuint32_t MBE28:1;
    vuint32_t MBE27:1;
    vuint32_t MBE26:1;
    vuint32_t MBE25:1;
    vuint32_t MBE24:1;
    vuint32_t MBE23:1;
    vuint32_t MBE22:1;
    vuint32_t MBE21:1;
    vuint32_t MBE20:1;
    vuint32_t MBE19:1;
    vuint32_t MBE18:1;
    vuint32_t MBE17:1;
    vuint32_t MBE16:1;
    vuint32_t MBE15:1;
    vuint32_t MBE14:1;
    vuint32_t MBE13:1;
    vuint32_t MBE12:1;
    vuint32_t MBE11:1;
    vuint32_t MBE10:1;
    vuint32_t MBE9:1;
    vuint32_t MBE8:1;
    vuint32_t MBE7:1;
    vuint32_t MBE6:1;
    vuint32_t MBE5:1;
    vuint32_t MBE4:1;
    vuint32_t MBE3:1;
    vuint32_t MBE2:1;
    vuint32_t MBE1:1;
    vuint32_t MBE0:1;
  } B;
} STCU2_MBEL_tag;

typedef union STCU2_MBEM_union_tag {   /* STCU2 Off-Line MBIST End Flag Medium Register */
  vuint32_t R;
  struct {
    vuint32_t MBE63:1;
    vuint32_t MBE62:1;
    vuint32_t MBE61:1;
    vuint32_t MBE60:1;
    vuint32_t MBE59:1;
    vuint32_t MBE58:1;
    vuint32_t MBE57:1;
    vuint32_t MBE56:1;
    vuint32_t MBE55:1;
    vuint32_t MBE54:1;
    vuint32_t MBE53:1;
    vuint32_t MBE52:1;
    vuint32_t MBE51:1;
    vuint32_t MBE50:1;
    vuint32_t MBE49:1;
    vuint32_t MBE48:1;
    vuint32_t MBE47:1;
    vuint32_t MBE46:1;
    vuint32_t MBE45:1;
    vuint32_t MBE44:1;
    vuint32_t MBE43:1;
    vuint32_t MBE42:1;
    vuint32_t MBE41:1;
    vuint32_t MBE40:1;
    vuint32_t MBE39:1;
    vuint32_t MBE38:1;
    vuint32_t MBE37:1;
    vuint32_t MBE36:1;
    vuint32_t MBE35:1;
    vuint32_t MBE34:1;
    vuint32_t MBE33:1;
    vuint32_t MBE32:1;
  } B;
} STCU2_MBEM_tag;

typedef union STCU2_MBEH_union_tag {   /* STCU2 Off-Line MBIST End Flag High Register */
  vuint32_t R;
  struct {
    vuint32_t  :18;
    vuint32_t MBE77:1;
    vuint32_t MBE76:1;
    vuint32_t MBE75:1;
    vuint32_t MBE74:1;
    vuint32_t MBE73:1;
    vuint32_t MBE72:1;
    vuint32_t MBE71:1;
    vuint32_t MBE70:1;
    vuint32_t MBE69:1;
    vuint32_t MBE68:1;
    vuint32_t MBE67:1;
    vuint32_t MBE66:1;
    vuint32_t MBE65:1;
    vuint32_t MBE64:1;
  } B;
} STCU2_MBEH_tag;

typedef union STCU2_MBSLSW_union_tag { /* STCU2 On-Line MBIST Status Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBSSW31:1;
    vuint32_t MBSSW30:1;
    vuint32_t MBSSW29:1;
    vuint32_t MBSSW28:1;
    vuint32_t MBSSW27:1;
    vuint32_t MBSSW26:1;
    vuint32_t MBSSW25:1;
    vuint32_t MBSSW24:1;
    vuint32_t MBSSW23:1;
    vuint32_t MBSSW22:1;
    vuint32_t MBSSW21:1;
    vuint32_t MBSSW20:1;
    vuint32_t MBSSW19:1;
    vuint32_t MBSSW18:1;
    vuint32_t MBSSW17:1;
    vuint32_t MBSSW16:1;
    vuint32_t MBSSW15:1;
    vuint32_t MBSSW14:1;
    vuint32_t MBSSW13:1;
    vuint32_t MBSSW12:1;
    vuint32_t MBSSW11:1;
    vuint32_t MBSSW10:1;
    vuint32_t MBSSW9:1;
    vuint32_t MBSSW8:1;
    vuint32_t MBSSW7:1;
    vuint32_t MBSSW6:1;
    vuint32_t MBSSW5:1;
    vuint32_t MBSSW4:1;
    vuint32_t MBSSW3:1;
    vuint32_t MBSSW2:1;
    vuint32_t MBSSW1:1;
    vuint32_t MBSSW0:1;
  } B;
} STCU2_MBSLSW_tag;

typedef union STCU2_MBSMSW_union_tag { /* STCU2 On-Line MBIST Status Medium Register */
  vuint32_t R;
  struct {
    vuint32_t MBSSW63:1;
    vuint32_t MBSSW62:1;
    vuint32_t MBSSW61:1;
    vuint32_t MBSSW60:1;
    vuint32_t MBSSW59:1;
    vuint32_t MBSSW58:1;
    vuint32_t MBSSW57:1;
    vuint32_t MBSSW56:1;
    vuint32_t MBSSW55:1;
    vuint32_t MBSSW54:1;
    vuint32_t MBSSW53:1;
    vuint32_t MBSSW52:1;
    vuint32_t MBSSW51:1;
    vuint32_t MBSSW50:1;
    vuint32_t MBSSW49:1;
    vuint32_t MBSSW48:1;
    vuint32_t MBSSW47:1;
    vuint32_t MBSSW46:1;
    vuint32_t MBSSW45:1;
    vuint32_t MBSSW44:1;
    vuint32_t MBSSW43:1;
    vuint32_t MBSSW42:1;
    vuint32_t MBSSW41:1;
    vuint32_t MBSSW40:1;
    vuint32_t MBSSW39:1;
    vuint32_t MBSSW38:1;
    vuint32_t MBSSW37:1;
    vuint32_t MBSSW36:1;
    vuint32_t MBSSW35:1;
    vuint32_t MBSSW34:1;
    vuint32_t MBSSW33:1;
    vuint32_t MBSSW32:1;
  } B;
} STCU2_MBSMSW_tag;

typedef union STCU2_MBSHSW_union_tag { /* STCU2 On-Line MBIST Status High Register */
  vuint32_t R;
  struct {
    vuint32_t  :18;
    vuint32_t MBSSW77:1;
    vuint32_t MBSSW76:1;
    vuint32_t MBSSW75:1;
    vuint32_t MBSSW74:1;
    vuint32_t MBSSW73:1;
    vuint32_t MBSSW72:1;
    vuint32_t MBSSW71:1;
    vuint32_t MBSSW70:1;
    vuint32_t MBSSW69:1;
    vuint32_t MBSSW68:1;
    vuint32_t MBSSW67:1;
    vuint32_t MBSSW66:1;
    vuint32_t MBSSW65:1;
    vuint32_t MBSSW64:1;
  } B;
} STCU2_MBSHSW_tag;

typedef union STCU2_MBELSW_union_tag { /* STCU2 On-Line MBIST End Flag Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBESW31:1;
    vuint32_t MBESW30:1;
    vuint32_t MBESW29:1;
    vuint32_t MBESW28:1;
    vuint32_t MBESW27:1;
    vuint32_t MBESW26:1;
    vuint32_t MBESW25:1;
    vuint32_t MBESW24:1;
    vuint32_t MBESW23:1;
    vuint32_t MBESW22:1;
    vuint32_t MBESW21:1;
    vuint32_t MBESW20:1;
    vuint32_t MBESW19:1;
    vuint32_t MBESW18:1;
    vuint32_t MBESW17:1;
    vuint32_t MBESW16:1;
    vuint32_t MBESW15:1;
    vuint32_t MBESW14:1;
    vuint32_t MBESW13:1;
    vuint32_t MBESW12:1;
    vuint32_t MBESW11:1;
    vuint32_t MBESW10:1;
    vuint32_t MBESW9:1;
    vuint32_t MBESW8:1;
    vuint32_t MBESW7:1;
    vuint32_t MBESW6:1;
    vuint32_t MBESW5:1;
    vuint32_t MBESW4:1;
    vuint32_t MBESW3:1;
    vuint32_t MBESW2:1;
    vuint32_t MBESW1:1;
    vuint32_t MBESW0:1;
  } B;
} STCU2_MBELSW_tag;

typedef union STCU2_MBEMSW_union_tag { /* STCU2 On-Line MBIST End Flag Medium Register */
  vuint32_t R;
  struct {
    vuint32_t MBESW63:1;
    vuint32_t MBESW62:1;
    vuint32_t MBESW61:1;
    vuint32_t MBESW60:1;
    vuint32_t MBESW59:1;
    vuint32_t MBESW58:1;
    vuint32_t MBESW57:1;
    vuint32_t MBESW56:1;
    vuint32_t MBESW55:1;
    vuint32_t MBESW54:1;
    vuint32_t MBESW53:1;
    vuint32_t MBESW52:1;
    vuint32_t MBESW51:1;
    vuint32_t MBESW50:1;
    vuint32_t MBESW49:1;
    vuint32_t MBESW48:1;
    vuint32_t MBESW47:1;
    vuint32_t MBESW46:1;
    vuint32_t MBESW45:1;
    vuint32_t MBESW44:1;
    vuint32_t MBESW43:1;
    vuint32_t MBESW42:1;
    vuint32_t MBESW41:1;
    vuint32_t MBESW40:1;
    vuint32_t MBESW39:1;
    vuint32_t MBESW38:1;
    vuint32_t MBESW37:1;
    vuint32_t MBESW36:1;
    vuint32_t MBESW35:1;
    vuint32_t MBESW34:1;
    vuint32_t MBESW33:1;
    vuint32_t MBESW32:1;
  } B;
} STCU2_MBEMSW_tag;

typedef union STCU2_MBEHSW_union_tag { /* STCU2 On-Line MBIST End Flag High Register */
  vuint32_t R;
  struct {
    vuint32_t  :18;
    vuint32_t MBESW77:1;
    vuint32_t MBESW76:1;
    vuint32_t MBESW75:1;
    vuint32_t MBESW74:1;
    vuint32_t MBESW73:1;
    vuint32_t MBESW72:1;
    vuint32_t MBESW71:1;
    vuint32_t MBESW70:1;
    vuint32_t MBESW69:1;
    vuint32_t MBESW68:1;
    vuint32_t MBESW67:1;
    vuint32_t MBESW66:1;
    vuint32_t MBESW65:1;
    vuint32_t MBESW64:1;
  } B;
} STCU2_MBEHSW_tag;

typedef union STCU2_MBUFML_union_tag { /* STCU2 MBIST Unrecoverable FM Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBUFM31:1;
    vuint32_t MBUFM30:1;
    vuint32_t MBUFM29:1;
    vuint32_t MBUFM28:1;
    vuint32_t MBUFM27:1;
    vuint32_t MBUFM26:1;
    vuint32_t MBUFM25:1;
    vuint32_t MBUFM24:1;
    vuint32_t MBUFM23:1;
    vuint32_t MBUFM22:1;
    vuint32_t MBUFM21:1;
    vuint32_t MBUFM20:1;
    vuint32_t MBUFM19:1;
    vuint32_t MBUFM18:1;
    vuint32_t MBUFM17:1;
    vuint32_t MBUFM16:1;
    vuint32_t MBUFM15:1;
    vuint32_t MBUFM14:1;
    vuint32_t MBUFM13:1;
    vuint32_t MBUFM12:1;
    vuint32_t MBUFM11:1;
    vuint32_t MBUFM10:1;
    vuint32_t MBUFM9:1;
    vuint32_t MBUFM8:1;
    vuint32_t MBUFM7:1;
    vuint32_t MBUFM6:1;
    vuint32_t MBUFM5:1;
    vuint32_t MBUFM4:1;
    vuint32_t MBUFM3:1;
    vuint32_t MBUFM2:1;
    vuint32_t MBUFM1:1;
    vuint32_t MBUFM0:1;
  } B;
} STCU2_MBUFML_tag;

typedef union STCU2_MBUFMM_union_tag { /* STCU2 MBIST Unrecoverable FM Medium Register */
  vuint32_t R;
  struct {
    vuint32_t MBUFM63:1;
    vuint32_t MBUFM62:1;
    vuint32_t MBUFM61:1;
    vuint32_t MBUFM60:1;
    vuint32_t MBUFM59:1;
    vuint32_t MBUFM58:1;
    vuint32_t MBUFM57:1;
    vuint32_t MBUFM56:1;
    vuint32_t MBUFM55:1;
    vuint32_t MBUFM54:1;
    vuint32_t MBUFM53:1;
    vuint32_t MBUFM52:1;
    vuint32_t MBUFM51:1;
    vuint32_t MBUFM50:1;
    vuint32_t MBUFM49:1;
    vuint32_t MBUFM48:1;
    vuint32_t MBUFM47:1;
    vuint32_t MBUFM46:1;
    vuint32_t MBUFM45:1;
    vuint32_t MBUFM44:1;
    vuint32_t MBUFM43:1;
    vuint32_t MBUFM42:1;
    vuint32_t MBUFM41:1;
    vuint32_t MBUFM40:1;
    vuint32_t MBUFM39:1;
    vuint32_t MBUFM38:1;
    vuint32_t MBUFM37:1;
    vuint32_t MBUFM36:1;
    vuint32_t MBUFM35:1;
    vuint32_t MBUFM34:1;
    vuint32_t MBUFM33:1;
    vuint32_t MBUFM32:1;
  } B;
} STCU2_MBUFMM_tag;

typedef union STCU2_MBUFMH_union_tag { /* STCU2 MBIST Unrecoverable FM High Register */
  vuint32_t R;
  struct {
    vuint32_t  :18;
    vuint32_t MBUFM77:1;
    vuint32_t MBUFM76:1;
    vuint32_t MBUFM75:1;
    vuint32_t MBUFM74:1;
    vuint32_t MBUFM73:1;
    vuint32_t MBUFM72:1;
    vuint32_t MBUFM71:1;
    vuint32_t MBUFM70:1;
    vuint32_t MBUFM69:1;
    vuint32_t MBUFM68:1;
    vuint32_t MBUFM67:1;
    vuint32_t MBUFM66:1;
    vuint32_t MBUFM65:1;
    vuint32_t MBUFM64:1;
  } B;
} STCU2_MBUFMH_tag;

typedef union STCU2_LB_LB_CTRL_union_tag { /* STCU2 LBIST Control Register */
  vuint32_t R;
  struct {
    vuint32_t CSM:1;
    vuint32_t PTR:7;
    vuint32_t  :4;
    vuint32_t PRPGEN:1;
    vuint32_t SHS:3;
    vuint32_t SCEN_OFF:4;
    vuint32_t SCEN_ON:4;
    vuint32_t  :4;
    vuint32_t PFT:1;
    vuint32_t CWS:3;
  } B;
} STCU2_LB_LB_CTRL_tag;

typedef union STCU2_LB_LB_PCS_union_tag { /* STCU2 LBIST PC Stop Register */
  vuint32_t R;
  struct {
    vuint32_t  :6;
    vuint32_t PCS:26;
  } B;
} STCU2_LB_LB_PCS_tag;

typedef union STCU2_LB_LB_PRPGL_union_tag { /* STCU2 LBIST PRPG Low Register */
  vuint32_t R;
  struct {
    vuint32_t PRPGx:32;
  } B;
} STCU2_LB_LB_PRPGL_tag;

typedef union STCU2_LB_LB_PRPGH_union_tag { /* STCU2 LBIST PRPG High Register */
  vuint32_t R;
  struct {
    vuint32_t PRPGx:32;
  } B;
} STCU2_LB_LB_PRPGH_tag;

typedef union STCU2_LB_LB_MISREL_union_tag { /* STCU2 Off-Line LBIST MISR Expected Low Register */
  vuint32_t R;
  struct {
    vuint32_t MISREx:32;
  } B;
} STCU2_LB_LB_MISREL_tag;

typedef union STCU2_LB_LB_MISREH_union_tag { /* STCU2 Off-Line LBIST MISR Expected High Register */
  vuint32_t R;
  struct {
    vuint32_t MISREx:32;
  } B;
} STCU2_LB_LB_MISREH_tag;

typedef union STCU2_LB_LB_MISRRL_union_tag { /* STCU2 Off-Line LBIST MISR Read Low Register */
  vuint32_t R;
  struct {
    vuint32_t MISRRx:32;
  } B;
} STCU2_LB_LB_MISRRL_tag;

typedef union STCU2_LB_LB_MISRRH_union_tag { /* STCU2 Off-Line LBIST MISR Read High Register */
  vuint32_t R;
  struct {
    vuint32_t MISRRx:32;
  } B;
} STCU2_LB_LB_MISRRH_tag;

typedef union STCU2_LB_LB_MISRELSW_union_tag { /* STCU2 On-Line LBIST MISR Expected Low Register */
  vuint32_t R;
  struct {
    vuint32_t MISRESWx:32;
  } B;
} STCU2_LB_LB_MISRELSW_tag;

typedef union STCU2_LB_LB_MISREHSW_union_tag { /* STCU2 On-Line LBIST MISR Expected High Register */
  vuint32_t R;
  struct {
    vuint32_t MISRESWx:32;
  } B;
} STCU2_LB_LB_MISREHSW_tag;

typedef union STCU2_LB_LB_MISRRLSW_union_tag { /* STCU2 On-Line LBIST MISR Read Low Register */
  vuint32_t R;
  struct {
    vuint32_t MISRRSWx:32;
  } B;
} STCU2_LB_LB_MISRRLSW_tag;

typedef union STCU2_LB_LB_MISRRHSW_union_tag { /* STCU2 On-Line LBIST MISR Read High Register */
  vuint32_t R;
  struct {
    vuint32_t MISRRSWx:32;
  } B;
} STCU2_LB_LB_MISRRHSW_tag;

typedef struct STCU2_LB_struct_tag {
  STCU2_LB_LB_CTRL_tag LB_CTRL;        /* STCU2 LBIST Control Register */
  STCU2_LB_LB_PCS_tag LB_PCS;          /* STCU2 LBIST PC Stop Register */
  STCU2_LB_LB_PRPGL_tag LB_PRPGL;      /* STCU2 LBIST PRPG Low Register */
  STCU2_LB_LB_PRPGH_tag LB_PRPGH;      /* STCU2 LBIST PRPG High Register */
  STCU2_LB_LB_MISREL_tag LB_MISREL;    /* STCU2 Off-Line LBIST MISR Expected Low Register */
  STCU2_LB_LB_MISREH_tag LB_MISREH;    /* STCU2 Off-Line LBIST MISR Expected High Register */
  STCU2_LB_LB_MISRRL_tag LB_MISRRL;    /* STCU2 Off-Line LBIST MISR Read Low Register */
  STCU2_LB_LB_MISRRH_tag LB_MISRRH;    /* STCU2 Off-Line LBIST MISR Read High Register */
  STCU2_LB_LB_MISRELSW_tag LB_MISRELSW; /* STCU2 On-Line LBIST MISR Expected Low Register */
  STCU2_LB_LB_MISREHSW_tag LB_MISREHSW; /* STCU2 On-Line LBIST MISR Expected High Register */
  STCU2_LB_LB_MISRRLSW_tag LB_MISRRLSW; /* STCU2 On-Line LBIST MISR Read Low Register */
  STCU2_LB_LB_MISRRHSW_tag LB_MISRRHSW; /* STCU2 On-Line LBIST MISR Read High Register */
  uint8_t LB_reserved0[16];
} STCU2_LB_tag;

typedef union STCU2_MB_CTRL_union_tag { /* STCU2 MBIST Control Register */
  vuint32_t R;
  struct {
    vuint32_t CSM:1;
    vuint32_t PTR:7;
    vuint32_t  :24;
  } B;
} STCU2_MB_CTRL_tag;

struct STCU2_tag {
  STCU2_RUN_tag RUN;                   /* STCU2 Run Register */
  STCU2_RUNSW_tag RUNSW;               /* STCU2 Run Software Register */
  STCU2_SKC_tag SKC;                   /* STCU2 SK Code Register */
  STCU2_CFG_tag CFG;                   /* STCU2 Configuration Register */
  STCU2_PLL_CFG_tag PLL_CFG;           /* STCU2 PLL Configuration Register */
  STCU2_WDG_tag WDG;                   /* STCU2 Watchdog Register Granularity */
  STCU2_INT_FLG_tag INT_FLG;           /* STCU2 Interrupt Flag Register */
  STCU2_CRCE_tag CRCE;                 /* STCU2 CRC Expected Status Register */
  STCU2_CRCR_tag CRCR;                 /* STCU2 CRC Read Status Register */
  STCU2_ERR_STAT_tag ERR_STAT;         /* STCU2 Error Register */
  STCU2_ERR_FM_tag ERR_FM;             /* STCU2 Error FM Register */
  STCU2_LBS_tag LBS;                   /* STCU2 Off-Line LBIST Status Register */
  STCU2_LBE_tag LBE;                   /* STCU2 Off-Line LBIST End Flag Register */
  STCU2_LBSSW_tag LBSSW;               /* STCU2 On-Line LBIST Status Register */
  STCU2_LBESW_tag LBESW;               /* STCU2 On-Line LBIST End Flag Register */
  STCU2_LBRMSW_tag LBRMSW;             /* STCU2 On-Line LBIST Reset Management */
  STCU2_LBUFM_tag LBUFM;               /* STCU2 LBIST Unrecoverable FM Register */
  STCU2_MBSL_tag MBSL;                 /* STCU2 Off-Line MBIST Status Low Register */
  STCU2_MBSM_tag MBSM;                 /* STCU2 Off-Line MBIST Status Medium Register */
  STCU2_MBSH_tag MBSH;                 /* STCU2 Off-Line MBIST Status High Register */
  STCU2_MBEL_tag MBEL;                 /* STCU2 Off-Line MBIST End Flag Low Register */
  STCU2_MBEM_tag MBEM;                 /* STCU2 Off-Line MBIST End Flag Medium Register */
  STCU2_MBEH_tag MBEH;                 /* STCU2 Off-Line MBIST End Flag High Register */
  STCU2_MBSLSW_tag MBSLSW;             /* STCU2 On-Line MBIST Status Low Register */
  STCU2_MBSMSW_tag MBSMSW;             /* STCU2 On-Line MBIST Status Medium Register */
  STCU2_MBSHSW_tag MBSHSW;             /* STCU2 On-Line MBIST Status High Register */
  STCU2_MBELSW_tag MBELSW;             /* STCU2 On-Line MBIST End Flag Low Register */
  STCU2_MBEMSW_tag MBEMSW;             /* STCU2 On-Line MBIST End Flag Medium Register */
  STCU2_MBEHSW_tag MBEHSW;             /* STCU2 On-Line MBIST End Flag High Register */
  STCU2_MBUFML_tag MBUFML;             /* STCU2 MBIST Unrecoverable FM Low Register */
  STCU2_MBUFMM_tag MBUFMM;             /* STCU2 MBIST Unrecoverable FM Medium Register */
  STCU2_MBUFMH_tag MBUFMH;             /* STCU2 MBIST Unrecoverable FM High Register */
  uint8_t STCU2_reserved0[128];
  STCU2_LB_tag LB[10];
  uint8_t STCU2_reserved1[640];
  STCU2_MB_CTRL_tag MB_CTRL[78];       /* STCU2 MBIST Control Register */
};


/* ============================================================================
   =============================== Module: STM ================================
   ============================================================================ */

typedef union STM_CR_union_tag {       /* STM Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t CPS:8;                   /* Counter Prescaler. */
    vuint32_t  :6;
    vuint32_t FRZ:1;                   /* Freeze. */
    vuint32_t TEN:1;                   /* Timer counter Enabled. */
  } B;
} STM_CR_tag;

typedef union STM_CNT_union_tag {      /* STM Count Register */
  vuint32_t R;
  struct {
    vuint32_t CNT:32;                  /* Timer count value used as the time base for all channels. */
  } B;
} STM_CNT_tag;

typedef union STM_CHANNEL_CCR_union_tag { /* STM Channel Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t CEN:1;                   /* Channel Enable */
  } B;
} STM_CHANNEL_CCR_tag;

typedef union STM_CHANNEL_CIR_union_tag { /* STM Channel Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t CIF:1;                   /* Channel Interrupt Flag */
  } B;
} STM_CHANNEL_CIR_tag;

typedef union STM_CHANNEL_CMP_union_tag { /* STM Channel Compare Register */
  vuint32_t R;
  struct {
    vuint32_t CMP:32;                  /* Compare value for channel n. */
  } B;
} STM_CHANNEL_CMP_tag;

typedef struct STM_CHANNEL_struct_tag {
  STM_CHANNEL_CCR_tag CCR;             /* STM Channel Control Register */
  STM_CHANNEL_CIR_tag CIR;             /* STM Channel Interrupt Register */
  STM_CHANNEL_CMP_tag CMP;             /* STM Channel Compare Register */
  uint8_t CHANNEL_reserved0[4];
} STM_CHANNEL_tag;

struct STM_tag {
  STM_CR_tag CR;                       /* STM Control Register */
  STM_CNT_tag CNT;                     /* STM Count Register */
  uint8_t STM_reserved0[8];
  STM_CHANNEL_tag CHANNEL[4];
};


/* ============================================================================
   =============================== Module: SWT ================================
   ============================================================================ */

typedef union SWT_CR_union_tag {       /* SWT Control Register */
  vuint32_t R;
  struct {
    vuint32_t MAP0:1;
    vuint32_t MAP1:1;
    vuint32_t MAP2:1;
    vuint32_t MAP3:1;
    vuint32_t MAP4:1;
    vuint32_t MAP5:1;
    vuint32_t MAP6:1;
    vuint32_t MAP7:1;
    vuint32_t  :13;
    vuint32_t SMD:2;                   /* Service Mode. */
    vuint32_t RIA:1;
    vuint32_t WND:1;
    vuint32_t ITR:1;
    vuint32_t HLK:1;
    vuint32_t SLK:1;
    vuint32_t  :1;                     /* Reserved */
    vuint32_t STP:1;
    vuint32_t FRZ:1;
    vuint32_t WEN:1;
  } B;
} SWT_CR_tag;

typedef union SWT_IR_union_tag {       /* SWT Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t TIF:1;                   /* Time-out Interrupt Flag */
  } B;
} SWT_IR_tag;

typedef union SWT_TO_union_tag {       /* SWT Time-out Register */
  vuint32_t R;
  struct {
    vuint32_t WTO:32;
  } B;
} SWT_TO_tag;

typedef union SWT_WN_union_tag {       /* SWT Window Register */
  vuint32_t R;
  struct {
    vuint32_t WST:32;                  /* Window Start Value */
  } B;
} SWT_WN_tag;

typedef union SWT_SR_union_tag {       /* SWT Service Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t WSC:16;                  /* Watchdog Service Code */
  } B;
} SWT_SR_tag;

typedef union SWT_CO_union_tag {       /* SWT Counter Output Register */
  vuint32_t R;
  struct {
    vuint32_t CNT:32;
  } B;
} SWT_CO_tag;

typedef union SWT_SK_union_tag {       /* SWT Service Key Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t SK:16;                   /* Service Key */
  } B;
} SWT_SK_tag;

struct SWT_tag {
  SWT_CR_tag CR;                       /* SWT Control Register */
  SWT_IR_tag IR;                       /* SWT Interrupt Register */
  SWT_TO_tag TO;                       /* SWT Time-out Register */
  SWT_WN_tag WN;                       /* SWT Window Register */
  SWT_SR_tag SR;                       /* SWT Service Register */
  SWT_CO_tag CO;                       /* SWT Counter Output Register */
  SWT_SK_tag SK;                       /* SWT Service Key Register */
};


/* ============================================================================
   =============================== Module: TDM ================================
   ============================================================================ */

typedef union TDM_TDRSR_union_tag {    /* TDR Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t TDRSR5:1;
    vuint32_t TDRSR4:1;
    vuint32_t TDRSR3:1;
    vuint32_t TDRSR2:1;
    vuint32_t TDRSR1:1;
    vuint32_t TDRSR0:1;
  } B;
} TDM_TDRSR_tag;

typedef union TDM_LFPAR_union_tag {    /* Last Flash Programmed Address Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t LFPAR:24;
  } B;
} TDM_LFPAR_tag;

typedef union TDM_DBA_union_tag {      /* Diary Base Address */
  vuint32_t R;
  struct {
    vuint32_t DBA:32;
  } B;
} TDM_DBA_tag;

typedef union TDM_STO_KEY_union_tag {  /* Software Tamper Override Key Region */
  vuint32_t R;
  struct {
    vuint32_t STO_KEY:32;
  } B;
} TDM_STO_KEY_tag;

struct TDM_tag {
  TDM_TDRSR_tag TDRSR;                 /* TDR Status Register */
  TDM_LFPAR_tag LFPAR;                 /* Last Flash Programmed Address Register */
  TDM_DBA_tag DBA;                     /* Diary Base Address */
  uint8_t TDM_reserved0[4];
  TDM_STO_KEY_tag STO_KEY[6];          /* Software Tamper Override Key Region */
};


/* ============================================================================
   =============================== Module: WKPU ===============================
   ============================================================================ */

typedef union WKPU_NSR_union_tag {     /* NMI Status Flag Register */
  vuint32_t R;
  struct {
    vuint32_t NIF0:1;                  /* NMI Status Flag 0 (safety core) */
    vuint32_t NOVF0:1;                 /* NMI Overrun Status Flag 0 (safety core) */
    vuint32_t  :6;
    vuint32_t NIF1:1;                  /* NMI Status Flag 1 (main core) */
    vuint32_t NOVF1:1;                 /* NMI Overrun Status Flag 1 (main core) */
    vuint32_t  :6;
    vuint32_t NIF2:1;                  /* NMI Status Flag 2 (IOP) */
    vuint32_t NOVF2:1;                 /* NMI Overrun Status Flag 2 (IOP) */
    vuint32_t  :6;
    vuint32_t RIF:1;                   /* Reset Status Flag */
    vuint32_t ROVF:1;                  /* Reset Overrun Status Flag */
    vuint32_t  :6;
  } B;
} WKPU_NSR_tag;

typedef union WKPU_NCR_union_tag {     /* NMI Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t NLOCK0:1;                /* NMI Configuration Lock Register 0 */
    vuint32_t NDSS0:2;                 /* NMI Destination Source Select 0 */
    vuint32_t NWRE0:1;                 /* NMI Wakeup Request Enable 0 */
    vuint32_t  :1;
    vuint32_t NREE0:1;                 /* NMI Rising-edge Events Enable 0 */
    vuint32_t NFEE0:1;                 /* NMI Falling-edge Events Enable 0 */
    vuint32_t NFE0:1;                  /* NMI Filter Enable */
    vuint32_t NLOCK1:1;                /* NMI Configuration Lock Register 1 */
    vuint32_t NDSS1:2;                 /* NMI Destination Source Select 1 */
    vuint32_t NWRE1:1;                 /* NMI Wakeup Request Enable 1 */
    vuint32_t  :1;
    vuint32_t NREE1:1;                 /* NMI Rising-edge Events Enable 1 */
    vuint32_t NFEE1:1;                 /* NMI Falling-edge Events Enable 1 */
    vuint32_t  :1;
    vuint32_t NLOCK2:1;                /* NMI Configuration Lock Register 2 */
    vuint32_t NDSS2:2;                 /* NMI Destination Source Select 2 */
    vuint32_t NWRE2:1;                 /* NMI Wakeup Request Enable 2 */
    vuint32_t  :1;
    vuint32_t NREE2:1;                 /* NMI Rising-edge Events Enable 2 */
    vuint32_t NFEE2:1;                 /* NMI Falling-edge Events Enable 2 */
    vuint32_t  :1;
    vuint32_t RLOCK:1;                 /* Reset Configuration Lock Register */
    vuint32_t RDSS:2;                  /* Reset Destination Source Select */
    vuint32_t RWRE:1;                  /* Reset Wakeup Request Enable */
    vuint32_t  :1;
    vuint32_t RREE:1;                  /* Reset Rising-edge Events Enable */
    vuint32_t RFEE:1;                  /* Reset Falling-edge Events Enable */
    vuint32_t  :1;
  } B;
} WKPU_NCR_tag;

struct WKPU_tag {
  WKPU_NSR_tag NSR;                    /* NMI Status Flag Register */
  uint8_t WKPU_reserved0[4];
  WKPU_NCR_tag NCR;                    /* NMI Configuration Register */
};


/* ============================================================================
   =============================== Module: XBAR ===============================
   ============================================================================ */

typedef union XBAR_PORT_PRS_union_tag { /* XBAR Priority Registers Slave */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t M7:3;
    vuint32_t  :1;
    vuint32_t M6:3;
    vuint32_t  :1;
    vuint32_t M5:3;
    vuint32_t  :1;
    vuint32_t M4:3;
    vuint32_t  :1;
    vuint32_t M3:3;
    vuint32_t  :1;
    vuint32_t M2:3;
    vuint32_t  :1;
    vuint32_t M1:3;
    vuint32_t  :1;
    vuint32_t M0:3;
  } B;
} XBAR_PORT_PRS_tag;

typedef union XBAR_PORT_CRS_union_tag { /* XBAR Control Register */
  vuint32_t R;
  struct {
    vuint32_t RO:1;
    vuint32_t HRP:1;
    vuint32_t  :6;
    vuint32_t HPE7:1;
    vuint32_t HPE6:1;
    vuint32_t HPE5:1;
    vuint32_t HPE4:1;
    vuint32_t HPE3:1;
    vuint32_t HPE2:1;
    vuint32_t HPE1:1;
    vuint32_t HPE0:1;
    vuint32_t  :6;
    vuint32_t ARB:2;
    vuint32_t  :2;
    vuint32_t PCTL:2;
    vuint32_t  :1;
    vuint32_t PARK:3;
  } B;
} XBAR_PORT_CRS_tag;

typedef struct XBAR_PORT_struct_tag {
  XBAR_PORT_PRS_tag PRS;               /* XBAR Priority Registers Slave */
  uint8_t PORT_reserved0[12];
  XBAR_PORT_CRS_tag CRS;               /* XBAR Control Register */
  uint8_t PORT_reserved1[236];
} XBAR_PORT_tag;

struct XBAR_tag {
  XBAR_PORT_tag PORT[8];
};


/* ============================================================================
   =============================== Module: XBIC ===============================
   ============================================================================ */

typedef union XBIC_MCR_union_tag {     /* XBIC Module Control Register */
  vuint32_t R;
  struct {
    vuint32_t SE0:1;
    vuint32_t SE1:1;
    vuint32_t SE2:1;
    vuint32_t SE3:1;
    vuint32_t SE4:1;
    vuint32_t SE5:1;
    vuint32_t SE6:1;
    vuint32_t SE7:1;
    vuint32_t ME0:1;
    vuint32_t ME1:1;
    vuint32_t ME2:1;
    vuint32_t ME3:1;
    vuint32_t ME4:1;
    vuint32_t ME5:1;
    vuint32_t ME6:1;
    vuint32_t ME7:1;
    vuint32_t  :16;
  } B;
} XBIC_MCR_tag;

typedef union XBIC_EIR_union_tag {     /* XBIC Error Injection Register */
  vuint32_t R;
  struct {
    vuint32_t EIE:1;
    vuint32_t  :16;
    vuint32_t SLV:3;
    vuint32_t MST:4;
    vuint32_t SYN:8;
  } B;
} XBIC_EIR_tag;

typedef union XBIC_ESR_union_tag {     /* XBIC Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t DPSE0:1;
    vuint32_t DPSE1:1;
    vuint32_t DPSE2:1;
    vuint32_t DPSE3:1;
    vuint32_t DPSE4:1;
    vuint32_t DPSE5:1;
    vuint32_t DPSE6:1;
    vuint32_t DPSE7:1;
    vuint32_t DPME0:1;
    vuint32_t DPME1:1;
    vuint32_t DPME2:1;
    vuint32_t DPME3:1;
    vuint32_t DPME4:1;
    vuint32_t DPME5:1;
    vuint32_t DPME6:1;
    vuint32_t DPME7:1;
    vuint32_t SLV:3;
    vuint32_t MST:4;
    vuint32_t SYN:8;
  } B;
} XBIC_ESR_tag;

typedef union XBIC_EAR_union_tag {     /* XBIC Error Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:32;
  } B;
} XBIC_EAR_tag;

struct XBIC_tag {
  XBIC_MCR_tag MCR;                    /* XBIC Module Control Register */
  XBIC_EIR_tag EIR;                    /* XBIC Error Injection Register */
  XBIC_ESR_tag ESR;                    /* XBIC Error Status Register */
  XBIC_EAR_tag EAR;                    /* XBIC Error Address Register */
};


/* ============================================================================
   =============================== Module: XOSC ===============================
   ============================================================================ */

typedef union XOSC_CTL_union_tag {     /* XOSC Control Register */
  vuint32_t R;
  struct {
    vuint32_t OSCBYP:1;
    vuint32_t  :2;
    vuint32_t  :5;
    vuint32_t EOCV:8;                  /* End of Count Value */
    vuint32_t M_OSC:1;                 /* Crystal oscillator clock interrupt mask */
    vuint32_t  :2;
    vuint32_t  :5;
    vuint32_t I_OSC:1;
    vuint32_t  :5;
    vuint32_t  :1;
    vuint32_t  :1;
  } B;
} XOSC_CTL_tag;

struct XOSC_tag {
  XOSC_CTL_tag CTL;                    /* XOSC Control Register */
};


/* ============================================================================
   =============================== Module: eDMA ===============================
   ============================================================================ */

typedef union eDMA_CR_union_tag {      /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :14;
    vuint32_t CX:1;
    vuint32_t ECX:1;
    vuint32_t GRP3PRI:2;
    vuint32_t GRP2PRI:2;
    vuint32_t GRP1PRI:2;
    vuint32_t GRP0PRI:2;
    vuint32_t EMLM:1;
    vuint32_t CLM:1;
    vuint32_t HALT:1;
    vuint32_t HOE:1;
    vuint32_t ERGA:1;
    vuint32_t ERCA:1;
    vuint32_t EDBG:1;
    vuint32_t  :1;
  } B;
} eDMA_CR_tag;

typedef union eDMA_ES_union_tag {      /* Error Status */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t  :13;
    vuint32_t UCE:1;
    vuint32_t ECX:1;
    vuint32_t GPE:1;
    vuint32_t CPE:1;
    vuint32_t ERRCHN:6;
    vuint32_t SAE:1;
    vuint32_t SOE:1;
    vuint32_t DAE:1;
    vuint32_t DOE:1;
    vuint32_t NCE:1;
    vuint32_t SGE:1;
    vuint32_t SBE:1;
    vuint32_t DBE:1;
  } B;
} eDMA_ES_tag;

typedef union eDMA_ERQH_union_tag {    /* Enable Request Register High */
  vuint32_t R;
  struct {
    vuint32_t ERQ63:1;
    vuint32_t ERQ62:1;
    vuint32_t ERQ61:1;
    vuint32_t ERQ60:1;
    vuint32_t ERQ59:1;
    vuint32_t ERQ58:1;
    vuint32_t ERQ57:1;
    vuint32_t ERQ56:1;
    vuint32_t ERQ55:1;
    vuint32_t ERQ54:1;
    vuint32_t ERQ53:1;
    vuint32_t ERQ52:1;
    vuint32_t ERQ51:1;
    vuint32_t ERQ50:1;
    vuint32_t ERQ49:1;
    vuint32_t ERQ48:1;
    vuint32_t ERQ47:1;
    vuint32_t ERQ46:1;
    vuint32_t ERQ45:1;
    vuint32_t ERQ44:1;
    vuint32_t ERQ43:1;
    vuint32_t ERQ42:1;
    vuint32_t ERQ41:1;
    vuint32_t ERQ40:1;
    vuint32_t ERQ39:1;
    vuint32_t ERQ38:1;
    vuint32_t ERQ37:1;
    vuint32_t ERQ36:1;
    vuint32_t ERQ35:1;
    vuint32_t ERQ34:1;
    vuint32_t ERQ33:1;
    vuint32_t ERQ32:1;
  } B;
} eDMA_ERQH_tag;

typedef union eDMA_ERQL_union_tag {    /* Enable Request Register Low */
  vuint32_t R;
  struct {
    vuint32_t ERQ31:1;
    vuint32_t ERQ30:1;
    vuint32_t ERQ29:1;
    vuint32_t ERQ28:1;
    vuint32_t ERQ27:1;
    vuint32_t ERQ26:1;
    vuint32_t ERQ25:1;
    vuint32_t ERQ24:1;
    vuint32_t ERQ23:1;
    vuint32_t ERQ22:1;
    vuint32_t ERQ21:1;
    vuint32_t ERQ20:1;
    vuint32_t ERQ19:1;
    vuint32_t ERQ18:1;
    vuint32_t ERQ17:1;
    vuint32_t ERQ16:1;
    vuint32_t ERQ15:1;
    vuint32_t ERQ14:1;
    vuint32_t ERQ13:1;
    vuint32_t ERQ12:1;
    vuint32_t ERQ11:1;
    vuint32_t ERQ10:1;
    vuint32_t ERQ9:1;
    vuint32_t ERQ8:1;
    vuint32_t ERQ7:1;
    vuint32_t ERQ6:1;
    vuint32_t ERQ5:1;
    vuint32_t ERQ4:1;
    vuint32_t ERQ3:1;
    vuint32_t ERQ2:1;
    vuint32_t ERQ1:1;
    vuint32_t ERQ0:1;
  } B;
} eDMA_ERQL_tag;

typedef union eDMA_EEIH_union_tag {    /* Enable Error Interrupt Register High */
  vuint32_t R;
  struct {
    vuint32_t EEI63:1;
    vuint32_t EEI62:1;
    vuint32_t EEI61:1;
    vuint32_t EEI60:1;
    vuint32_t EEI59:1;
    vuint32_t EEI58:1;
    vuint32_t EEI57:1;
    vuint32_t EEI56:1;
    vuint32_t EEI55:1;
    vuint32_t EEI54:1;
    vuint32_t EEI53:1;
    vuint32_t EEI52:1;
    vuint32_t EEI51:1;
    vuint32_t EEI50:1;
    vuint32_t EEI49:1;
    vuint32_t EEI48:1;
    vuint32_t EEI47:1;
    vuint32_t EEI46:1;
    vuint32_t EEI45:1;
    vuint32_t EEI44:1;
    vuint32_t EEI43:1;
    vuint32_t EEI42:1;
    vuint32_t EEI41:1;
    vuint32_t EEI40:1;
    vuint32_t EEI39:1;
    vuint32_t EEI38:1;
    vuint32_t EEI37:1;
    vuint32_t EEI36:1;
    vuint32_t EEI35:1;
    vuint32_t EEI34:1;
    vuint32_t EEI33:1;
    vuint32_t EEI32:1;
  } B;
} eDMA_EEIH_tag;

typedef union eDMA_EEIL_union_tag {    /* Enable Error Interrupt Register Low */
  vuint32_t R;
  struct {
    vuint32_t EEI31:1;
    vuint32_t EEI30:1;
    vuint32_t EEI29:1;
    vuint32_t EEI28:1;
    vuint32_t EEI27:1;
    vuint32_t EEI26:1;
    vuint32_t EEI25:1;
    vuint32_t EEI24:1;
    vuint32_t EEI23:1;
    vuint32_t EEI22:1;
    vuint32_t EEI21:1;
    vuint32_t EEI20:1;
    vuint32_t EEI19:1;
    vuint32_t EEI18:1;
    vuint32_t EEI17:1;
    vuint32_t EEI16:1;
    vuint32_t EEI15:1;
    vuint32_t EEI14:1;
    vuint32_t EEI13:1;
    vuint32_t EEI12:1;
    vuint32_t EEI11:1;
    vuint32_t EEI10:1;
    vuint32_t EEI9:1;
    vuint32_t EEI8:1;
    vuint32_t EEI7:1;
    vuint32_t EEI6:1;
    vuint32_t EEI5:1;
    vuint32_t EEI4:1;
    vuint32_t EEI3:1;
    vuint32_t EEI2:1;
    vuint32_t EEI1:1;
    vuint32_t EEI0:1;
  } B;
} eDMA_EEIL_tag;

typedef union eDMA_SERQ_union_tag {    /* Set Enable Request Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;
    vuint8_t SAER:1;
    vuint8_t SERQ:6;
  } B;
} eDMA_SERQ_tag;

typedef union eDMA_CERQ_union_tag {    /* Clear Enable Request Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;
    vuint8_t CAER:1;
    vuint8_t CERQ:6;
  } B;
} eDMA_CERQ_tag;

typedef union eDMA_SEEI_union_tag {    /* Set Enable Error Interrupt Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;
    vuint8_t SAEE:1;
    vuint8_t SEEI:6;
  } B;
} eDMA_SEEI_tag;

typedef union eDMA_CEEI_union_tag {    /* Clear Enable Error Interrupt Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;
    vuint8_t CAEE:1;
    vuint8_t CEEI:6;
  } B;
} eDMA_CEEI_tag;

typedef union eDMA_CINT_union_tag {    /* Clear Interrupt Request Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;
    vuint8_t CAIR:1;
    vuint8_t CINT:6;
  } B;
} eDMA_CINT_tag;

typedef union eDMA_CERR_union_tag {    /* Clear Error Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;
    vuint8_t CAEI:1;
    vuint8_t CERR:6;
  } B;
} eDMA_CERR_tag;

typedef union eDMA_SSRT_union_tag {    /* Set START Bit Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;
    vuint8_t SAST:1;
    vuint8_t SSRT:6;
  } B;
} eDMA_SSRT_tag;

typedef union eDMA_CDNE_union_tag {    /* Clear DONE Status Bit Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;
    vuint8_t CADN:1;
    vuint8_t CDNE:6;
  } B;
} eDMA_CDNE_tag;

typedef union eDMA_INTH_union_tag {    /* Interrupt Request Register High */
  vuint32_t R;
  struct {
    vuint32_t INT63:1;
    vuint32_t INT62:1;
    vuint32_t INT61:1;
    vuint32_t INT60:1;
    vuint32_t INT59:1;
    vuint32_t INT58:1;
    vuint32_t INT57:1;
    vuint32_t INT56:1;
    vuint32_t INT55:1;
    vuint32_t INT54:1;
    vuint32_t INT53:1;
    vuint32_t INT52:1;
    vuint32_t INT51:1;
    vuint32_t INT50:1;
    vuint32_t INT49:1;
    vuint32_t INT48:1;
    vuint32_t INT47:1;
    vuint32_t INT46:1;
    vuint32_t INT45:1;
    vuint32_t INT44:1;
    vuint32_t INT43:1;
    vuint32_t INT42:1;
    vuint32_t INT41:1;
    vuint32_t INT40:1;
    vuint32_t INT39:1;
    vuint32_t INT38:1;
    vuint32_t INT37:1;
    vuint32_t INT36:1;
    vuint32_t INT35:1;
    vuint32_t INT34:1;
    vuint32_t INT33:1;
    vuint32_t INT32:1;
  } B;
} eDMA_INTH_tag;

typedef union eDMA_INTL_union_tag {    /* Interrupt Request Register Low */
  vuint32_t R;
  struct {
    vuint32_t INT31:1;
    vuint32_t INT30:1;
    vuint32_t INT29:1;
    vuint32_t INT28:1;
    vuint32_t INT27:1;
    vuint32_t INT26:1;
    vuint32_t INT25:1;
    vuint32_t INT24:1;
    vuint32_t INT23:1;
    vuint32_t INT22:1;
    vuint32_t INT21:1;
    vuint32_t INT20:1;
    vuint32_t INT19:1;
    vuint32_t INT18:1;
    vuint32_t INT17:1;
    vuint32_t INT16:1;
    vuint32_t INT15:1;
    vuint32_t INT14:1;
    vuint32_t INT13:1;
    vuint32_t INT12:1;
    vuint32_t INT11:1;
    vuint32_t INT10:1;
    vuint32_t INT9:1;
    vuint32_t INT8:1;
    vuint32_t INT7:1;
    vuint32_t INT6:1;
    vuint32_t INT5:1;
    vuint32_t INT4:1;
    vuint32_t INT3:1;
    vuint32_t INT2:1;
    vuint32_t INT1:1;
    vuint32_t INT0:1;
  } B;
} eDMA_INTL_tag;

typedef union eDMA_ERRH_union_tag {    /* Error Register High */
  vuint32_t R;
  struct {
    vuint32_t ERR63:1;
    vuint32_t ERR62:1;
    vuint32_t ERR61:1;
    vuint32_t ERR60:1;
    vuint32_t ERR59:1;
    vuint32_t ERR58:1;
    vuint32_t ERR57:1;
    vuint32_t ERR56:1;
    vuint32_t ERR55:1;
    vuint32_t ERR54:1;
    vuint32_t ERR53:1;
    vuint32_t ERR52:1;
    vuint32_t ERR51:1;
    vuint32_t ERR50:1;
    vuint32_t ERR49:1;
    vuint32_t ERR48:1;
    vuint32_t ERR47:1;
    vuint32_t ERR46:1;
    vuint32_t ERR45:1;
    vuint32_t ERR44:1;
    vuint32_t ERR43:1;
    vuint32_t ERR42:1;
    vuint32_t ERR41:1;
    vuint32_t ERR40:1;
    vuint32_t ERR39:1;
    vuint32_t ERR38:1;
    vuint32_t ERR37:1;
    vuint32_t ERR36:1;
    vuint32_t ERR35:1;
    vuint32_t ERR34:1;
    vuint32_t ERR33:1;
    vuint32_t ERR32:1;
  } B;
} eDMA_ERRH_tag;

typedef union eDMA_ERRL_union_tag {    /* Error Register Low */
  vuint32_t R;
  struct {
    vuint32_t ERR31:1;
    vuint32_t ERR30:1;
    vuint32_t ERR29:1;
    vuint32_t ERR28:1;
    vuint32_t ERR27:1;
    vuint32_t ERR26:1;
    vuint32_t ERR25:1;
    vuint32_t ERR24:1;
    vuint32_t ERR23:1;
    vuint32_t ERR22:1;
    vuint32_t ERR21:1;
    vuint32_t ERR20:1;
    vuint32_t ERR19:1;
    vuint32_t ERR18:1;
    vuint32_t ERR17:1;
    vuint32_t ERR16:1;
    vuint32_t ERR15:1;
    vuint32_t ERR14:1;
    vuint32_t ERR13:1;
    vuint32_t ERR12:1;
    vuint32_t ERR11:1;
    vuint32_t ERR10:1;
    vuint32_t ERR9:1;
    vuint32_t ERR8:1;
    vuint32_t ERR7:1;
    vuint32_t ERR6:1;
    vuint32_t ERR5:1;
    vuint32_t ERR4:1;
    vuint32_t ERR3:1;
    vuint32_t ERR2:1;
    vuint32_t ERR1:1;
    vuint32_t ERR0:1;
  } B;
} eDMA_ERRL_tag;

typedef union eDMA_HRSH_union_tag {    /* Hardware Request Status Register High */
  vuint32_t R;
  struct {
    vuint32_t HRS63:1;
    vuint32_t HRS62:1;
    vuint32_t HRS61:1;
    vuint32_t HRS60:1;
    vuint32_t HRS59:1;
    vuint32_t HRS58:1;
    vuint32_t HRS57:1;
    vuint32_t HRS56:1;
    vuint32_t HRS55:1;
    vuint32_t HRS54:1;
    vuint32_t HRS53:1;
    vuint32_t HRS52:1;
    vuint32_t HRS51:1;
    vuint32_t HRS50:1;
    vuint32_t HRS49:1;
    vuint32_t HRS48:1;
    vuint32_t HRS47:1;
    vuint32_t HRS46:1;
    vuint32_t HRS45:1;
    vuint32_t HRS44:1;
    vuint32_t HRS43:1;
    vuint32_t HRS42:1;
    vuint32_t HRS41:1;
    vuint32_t HRS40:1;
    vuint32_t HRS39:1;
    vuint32_t HRS38:1;
    vuint32_t HRS37:1;
    vuint32_t HRS36:1;
    vuint32_t HRS35:1;
    vuint32_t HRS34:1;
    vuint32_t HRS33:1;
    vuint32_t HRS32:1;
  } B;
} eDMA_HRSH_tag;

typedef union eDMA_HRSL_union_tag {    /* Hardware Request Status Register Low */
  vuint32_t R;
  struct {
    vuint32_t HRS31:1;
    vuint32_t HRS30:1;
    vuint32_t HRS29:1;
    vuint32_t HRS28:1;
    vuint32_t HRS27:1;
    vuint32_t HRS26:1;
    vuint32_t HRS25:1;
    vuint32_t HRS24:1;
    vuint32_t HRS23:1;
    vuint32_t HRS22:1;
    vuint32_t HRS21:1;
    vuint32_t HRS20:1;
    vuint32_t HRS19:1;
    vuint32_t HRS18:1;
    vuint32_t HRS17:1;
    vuint32_t HRS16:1;
    vuint32_t HRS15:1;
    vuint32_t HRS14:1;
    vuint32_t HRS13:1;
    vuint32_t HRS12:1;
    vuint32_t HRS11:1;
    vuint32_t HRS10:1;
    vuint32_t HRS9:1;
    vuint32_t HRS8:1;
    vuint32_t HRS7:1;
    vuint32_t HRS6:1;
    vuint32_t HRS5:1;
    vuint32_t HRS4:1;
    vuint32_t HRS3:1;
    vuint32_t HRS2:1;
    vuint32_t HRS1:1;
    vuint32_t HRS0:1;
  } B;
} eDMA_HRSL_tag;

typedef union eDMA_DCHPRI_union_tag {  /* Channel Priority Register */
  vuint8_t R;
  struct {
    vuint8_t ECP:1;
    vuint8_t DPA:1;
    vuint8_t GRPPRI:2;
    vuint8_t CHPRI:4;
  } B;
} eDMA_DCHPRI_tag;

typedef union eDMA_DCHMID_union_tag {  /* Channel Master ID Register */
  vuint8_t R;
  struct {
    vuint8_t EMI:1;
    vuint8_t PAL:1;
    vuint8_t  :2;
    vuint8_t MID:4;
  } B;
} eDMA_DCHMID_tag;

typedef union eDMA_TCD_SADDR_union_tag { /* TCD Source Address */
  vuint32_t R;
  struct {
    vuint32_t SADDR:32;
  } B;
} eDMA_TCD_SADDR_tag;

typedef union eDMA_TCD_ATTR_union_tag { /* TCD Transfer Attributes */
  vuint16_t R;
  struct {
    vuint16_t SMOD:5;
    vuint16_t SSIZE:3;
    vuint16_t DMOD:5;
    vuint16_t DSIZE:3;
  } B;
} eDMA_TCD_ATTR_tag;

typedef union eDMA_TCD_SOFF_union_tag { /* TCD Signed Source Address Offset */
  vuint16_t R;
  struct {
    vuint16_t SOFF:16;
  } B;
} eDMA_TCD_SOFF_tag;

typedef union eDMA_TCD_NBYTES_MLNO_union_tag { /* TCD Minor Byte Count Minor Loop Disabled */
  vuint32_t R;
  struct {
    vuint32_t NBYTES:32;
  } B;
} eDMA_TCD_NBYTES_MLNO_tag;

typedef union eDMA_TCD_NBYTES_MLOFFNO_union_tag { /* TCD Signed Minor Loop Offset Minor Loop Enabled and Offset Disabled */
  vuint32_t R;
  struct {
    vuint32_t SMLOE:1;
    vuint32_t DMLOE:1;
    vuint32_t NBYTES:30;
  } B;
} eDMA_TCD_NBYTES_MLOFFNO_tag;

typedef union eDMA_TCD_NBYTES_MLOFFYES_union_tag { /* TCD Signed Minor Loop Offset Minor Loop and Offset Enabled */
  vuint32_t R;
  struct {
    vuint32_t SMLOE:1;
    vuint32_t DMLOE:1;
    vuint32_t MLOFF:20;
    vuint32_t NBYTES:10;
  } B;
} eDMA_TCD_NBYTES_MLOFFYES_tag;

typedef union eDMA_TCD_NBYTES_union_tag {
  eDMA_TCD_NBYTES_MLNO_tag MLNO;       /* TCD Minor Byte Count Minor Loop Disabled */
  eDMA_TCD_NBYTES_MLOFFNO_tag MLOFFNO; /* TCD Signed Minor Loop Offset Minor Loop Enabled and Offset Disabled */
  eDMA_TCD_NBYTES_MLOFFYES_tag MLOFFYES; /* TCD Signed Minor Loop Offset Minor Loop and Offset Enabled */
} eDMA_TCD_NBYTES_tag;

typedef union eDMA_TCD_SLAST_union_tag { /* TCD Last Source Address Adjustment */
  vuint32_t R;
  struct {
    vuint32_t SLAST:32;
  } B;
} eDMA_TCD_SLAST_tag;

typedef union eDMA_TCD_DADDR_union_tag { /* TCD Destination Address */
  vuint32_t R;
  struct {
    vuint32_t DADDR:32;
  } B;
} eDMA_TCD_DADDR_tag;

typedef union eDMA_TCD_CITER_ELINKNO_union_tag { /* TCD Current Minor Loop Link, Major Loop Count Channel Linking Disabled */
  vuint16_t R;
  struct {
    vuint16_t ELINK:1;
    vuint16_t CITER:15;
  } B;
} eDMA_TCD_CITER_ELINKNO_tag;

typedef union eDMA_TCD_CITER_ELINKYES_union_tag { /* TCD Current Minor Loop Link, Major Loop Count Channel Linking Enabled */
  vuint16_t R;
  struct {
    vuint16_t ELINK:1;
    vuint16_t LINKCH:6;
    vuint16_t CITER:9;
  } B;
} eDMA_TCD_CITER_ELINKYES_tag;

typedef union eDMA_TCD_CITER_union_tag {
  eDMA_TCD_CITER_ELINKNO_tag ELINKNO;  /* TCD Current Minor Loop Link, Major Loop Count Channel Linking Disabled */
  eDMA_TCD_CITER_ELINKYES_tag ELINKYES; /* TCD Current Minor Loop Link, Major Loop Count Channel Linking Enabled */
} eDMA_TCD_CITER_tag;

typedef union eDMA_TCD_DOFF_union_tag { /* TCD Signed Destination Address Offset */
  vuint16_t R;
  struct {
    vuint16_t DOFF:16;
  } B;
} eDMA_TCD_DOFF_tag;

typedef union eDMA_TCD_DLASTSGA_union_tag { /* TCD Last Destination Address Adjustment/Scatter Gather Address */
  vuint32_t R;
  struct {
    vuint32_t DLASTSGA:32;
  } B;
} eDMA_TCD_DLASTSGA_tag;

typedef union eDMA_TCD_BITER_ELINKNO_union_tag { /* TCD Beginning Minor Loop Link, Major Loop Count Channel Linking Disabled */
  vuint16_t R;
  struct {
    vuint16_t ELINK:1;
    vuint16_t BITER:15;
  } B;
} eDMA_TCD_BITER_ELINKNO_tag;

typedef union eDMA_TCD_BITER_ELINKYES_union_tag { /* TCD Beginning Minor Loop Link, Major Loop Count Channel Linking Enabled */
  vuint16_t R;
  struct {
    vuint16_t ELINK:1;
    vuint16_t LINKCH:6;
    vuint16_t BITER:9;
  } B;
} eDMA_TCD_BITER_ELINKYES_tag;

typedef union eDMA_TCD_BITER_union_tag {
  eDMA_TCD_BITER_ELINKNO_tag ELINKNO;  /* TCD Beginning Minor Loop Link, Major Loop Count Channel Linking Disabled */
  eDMA_TCD_BITER_ELINKYES_tag ELINKYES; /* TCD Beginning Minor Loop Link, Major Loop Count Channel Linking Enabled */
} eDMA_TCD_BITER_tag;

typedef union eDMA_TCD_CSR_union_tag { /* TCD Control and Status */
  vuint16_t R;
  struct {
    vuint16_t BWC:2;
    vuint16_t MAJORLINKCH:6;
    vuint16_t DONE:1;
    vuint16_t ACTIVE:1;
    vuint16_t MAJORELINK:1;
    vuint16_t ESG:1;
    vuint16_t DREQ:1;
    vuint16_t INTHALF:1;
    vuint16_t INTMAJOR:1;
    vuint16_t START:1;
  } B;
} eDMA_TCD_CSR_tag;

typedef struct eDMA_TCD_struct_tag {
  eDMA_TCD_SADDR_tag SADDR;            /* TCD Source Address */
  eDMA_TCD_ATTR_tag ATTR;              /* TCD Transfer Attributes */
  eDMA_TCD_SOFF_tag SOFF;              /* TCD Signed Source Address Offset */
  eDMA_TCD_NBYTES_tag NBYTES;
  eDMA_TCD_SLAST_tag SLAST;            /* TCD Last Source Address Adjustment */
  eDMA_TCD_DADDR_tag DADDR;            /* TCD Destination Address */
  eDMA_TCD_CITER_tag CITER;
  eDMA_TCD_DOFF_tag DOFF;              /* TCD Signed Destination Address Offset */
  eDMA_TCD_DLASTSGA_tag DLASTSGA;      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
  eDMA_TCD_BITER_tag BITER;
  eDMA_TCD_CSR_tag CSR;                /* TCD Control and Status */
} eDMA_TCD_tag;

struct eDMA_tag {
  eDMA_CR_tag CR;                      /* Control Register */
  eDMA_ES_tag ES;                      /* Error Status */
  eDMA_ERQH_tag ERQH;                  /* Enable Request Register High */
  eDMA_ERQL_tag ERQL;                  /* Enable Request Register Low */
  eDMA_EEIH_tag EEIH;                  /* Enable Error Interrupt Register High */
  eDMA_EEIL_tag EEIL;                  /* Enable Error Interrupt Register Low */
  eDMA_SERQ_tag SERQ;                  /* Set Enable Request Register */
  eDMA_CERQ_tag CERQ;                  /* Clear Enable Request Register */
  eDMA_SEEI_tag SEEI;                  /* Set Enable Error Interrupt Register */
  eDMA_CEEI_tag CEEI;                  /* Clear Enable Error Interrupt Register */
  eDMA_CINT_tag CINT;                  /* Clear Interrupt Request Register */
  eDMA_CERR_tag CERR;                  /* Clear Error Register */
  eDMA_SSRT_tag SSRT;                  /* Set START Bit Register */
  eDMA_CDNE_tag CDNE;                  /* Clear DONE Status Bit Register */
  eDMA_INTH_tag INTH;                  /* Interrupt Request Register High */
  eDMA_INTL_tag INTL;                  /* Interrupt Request Register Low */
  eDMA_ERRH_tag ERRH;                  /* Error Register High */
  eDMA_ERRL_tag ERRL;                  /* Error Register Low */
  eDMA_HRSH_tag HRSH;                  /* Hardware Request Status Register High */
  eDMA_HRSL_tag HRSL;                  /* Hardware Request Status Register Low */
  uint8_t eDMA_reserved0[200];
  eDMA_DCHPRI_tag DCHPRI[64];          /* Channel Priority Register */
  eDMA_DCHMID_tag DCHMID[64];          /* Channel Master ID Register */
  uint8_t eDMA_reserved1[3712];
  eDMA_TCD_tag TCD[64];
};

#define SRAM0_START 0x40000000UL;
#define C55FMC (*(volatile struct C55FMC_tag *) 0xFFFE0000UL)
#define CMU_ADCSAR (*(volatile struct CMU_tag *) 0xFBFB0340UL)
#define CMU_ADCSD (*(volatile struct CMU_tag *) 0xFBFB0300UL)
#define CMU_CLKOUT (*(volatile struct CMU_tag *) 0xFBFB04C0UL)
#define CMU_CORE (*(volatile struct CMU_tag *) 0xFBFB0480UL)
#define CMU_FXBAR (*(volatile struct CMU_tag *) 0xFBFB0200UL)
#define CMU_PBRIDGE (*(volatile struct CMU_tag *) 0xFBFB0280UL)
#define CMU_PER (*(volatile struct CMU_tag *) 0xFBFB02C0UL)
#define CMU_PLL (*(volatile struct CMU_tag *) 0xFFFB0200UL)
#define CMU_PSI5_1US (*(volatile struct CMU_tag *) 0xFBFB0440UL)
#define CMU_PSI5_F125 (*(volatile struct CMU_tag *) 0xFBFB0400UL)
#define CMU_PSI5_F189 (*(volatile struct CMU_tag *) 0xFBFB03C0UL)
#define CMU_SENT (*(volatile struct CMU_tag *) 0xFBFB0380UL)
#define CMU_SXBAR (*(volatile struct CMU_tag *) 0xFBFB0240UL)
#define CRC_0 (*(volatile struct CRC_tag *) 0xFFF64000UL)
#define CRC_1 (*(volatile struct CRC_tag *) 0xFBF64000UL)
#define DMAMUX_0 (*(volatile struct DMAMUX_tag *) 0xFFF6C000UL)
#define DMAMUX_1 (*(volatile struct DMAMUX_tag *) 0xFFF6C200UL)
#define DMAMUX_2 (*(volatile struct DMAMUX_tag *) 0xFFF6C400UL)
#define DMAMUX_3 (*(volatile struct DMAMUX_tag *) 0xFFF6C600UL)
#define DMAMUX_4 (*(volatile struct DMAMUX_tag *) 0xFFF6C800UL)
#define DMAMUX_5 (*(volatile struct DMAMUX_tag *) 0xFFF6CA00UL)
#define DMAMUX_6 (*(volatile struct DMAMUX_tag *) 0xFFF6CC00UL)
#define DMAMUX_7 (*(volatile struct DMAMUX_tag *) 0xFFF6CE00UL)
#define DMAMUX_8 (*(volatile struct DMAMUX_tag *) 0xFFF6D000UL)
#define DMAMUX_9 (*(volatile struct DMAMUX_tag *) 0xFFF6D200UL)
#define DSPI_0 (*(volatile struct DSPI_tag *) 0xFFE70000UL)
#define DSPI_1 (*(volatile struct DSPI_tag *) 0xFFE74000UL)
#define DSPI_12 (*(volatile struct DSPI_tag *) 0xFFE88000UL)
#define DSPI_2 (*(volatile struct DSPI_tag *) 0xFBE70000UL)
#define DSPI_3 (*(volatile struct DSPI_tag *) 0xFBE74000UL)
#define DSPI_4 (*(volatile struct DSPI_tag *) 0xFFE78000UL)
#define DSPI_5 (*(volatile struct DSPI_tag *) 0xFBE78000UL)
#define DSPI_6 (*(volatile struct DSPI_tag *) 0xFFE7C000UL)
#define DTS (*(volatile struct DTS_tag *) 0xFFF38000UL)
#define EBI (*(volatile struct EBI_tag *) 0xFFFF0000UL)
#define FCCU (*(volatile struct FCCU_tag *) 0xFBF58000UL)
#define FEC (*(volatile struct FEC_tag *) 0xFC0B0000UL)
#define FR_0 (*(volatile struct FR_tag *) 0xFFE50000UL)
#define FR_1 (*(volatile struct FR_tag *) 0xFBE50000UL)
#define GTM (*(volatile struct GTM_tag *) 0xFFD00000UL)
#define GTMINT (*(volatile struct GTMINT_tag *) 0xFFD00000UL)
#define GTM_AFD_0 (*(volatile struct GTM_AFD_tag *) 0xFFD18000UL)
#define GTM_AFD_1 (*(volatile struct GTM_AFD_tag *) 0xFFD1C000UL)
#define GTM_ARU (*(volatile struct GTM_ARU_tag *) 0xFFD00280UL)
#define GTM_ATOM_0 (*(volatile struct GTM_ATOM_tag *) 0xFFD0D000UL)
#define GTM_ATOM_1 (*(volatile struct GTM_ATOM_tag *) 0xFFD0D800UL)
#define GTM_ATOM_2 (*(volatile struct GTM_ATOM_tag *) 0xFFD0E000UL)
#define GTM_ATOM_3 (*(volatile struct GTM_ATOM_tag *) 0xFFD0E800UL)
#define GTM_ATOM_4 (*(volatile struct GTM_ATOM_tag *) 0xFFD0F000UL)
#define GTM_ATOM_5 (*(volatile struct GTM_ATOM_tag *) 0xFFD0F800UL)
#define GTM_ATOM_6 (*(volatile struct GTM_ATOM_tag *) 0xFFD10000UL)
#define GTM_ATOM_7 (*(volatile struct GTM_ATOM_tag *) 0xFFD10800UL)
#define GTM_ATOM_8 (*(volatile struct GTM_ATOM_tag *) 0xFFD11000UL)
#define GTM_BRC (*(volatile struct GTM_BRC_tag *) 0xFFD00400UL)
#define GTM_CMP (*(volatile struct GTM_CMP_tag *) 0xFFD00200UL)
#define GTM_CMU (*(volatile struct GTM_CMU_tag *) 0xFFD00300UL)
#define GTM_DPLL (*(volatile struct GTM_DPLL_tag *) 0xFFD28000UL)
#define GTM_F2A_0 (*(volatile struct GTM_F2A_tag *) 0xFFD18080UL)
#define GTM_F2A_1 (*(volatile struct GTM_F2A_tag *) 0xFFD1C080UL)
#define GTM_FIFO_0 (*(volatile struct GTM_FIFO_tag *) 0xFFD18400UL)
#define GTM_FIFO_1 (*(volatile struct GTM_FIFO_tag *) 0xFFD1C400UL)
#define GTM_ICM (*(volatile struct GTM_ICM_tag *) 0xFFD00600UL)
#define GTM_MAP (*(volatile struct GTM_MAP_tag *) 0xFFD00F00UL)
#define GTM_MCFG (*(volatile struct GTM_MCFG_tag *) 0xFFD00F40UL)
#define GTM_MCS_0 (*(volatile struct GTM_MCS_tag *) 0xFFD30000UL)
#define GTM_MCS_1 (*(volatile struct GTM_MCS_tag *) 0xFFD31000UL)
#define GTM_MCS_2 (*(volatile struct GTM_MCS_tag *) 0xFFD32000UL)
#define GTM_MCS_3 (*(volatile struct GTM_MCS_tag *) 0xFFD33000UL)
#define GTM_MCS_4 (*(volatile struct GTM_MCS_tag *) 0xFFD34000UL)
#define GTM_MCS_5 (*(volatile struct GTM_MCS_tag *) 0xFFD35000UL)
#define GTM_MON (*(volatile struct GTM_MON_tag *) 0xFFD00180UL)
#define GTM_SPE_0 (*(volatile struct GTM_SPE_tag *) 0xFFD00800UL)
#define GTM_SPE_1 (*(volatile struct GTM_SPE_tag *) 0xFFD00880UL)
#define GTM_SPE_2 (*(volatile struct GTM_SPE_tag *) 0xFFD00900UL)
#define GTM_SPE_3 (*(volatile struct GTM_SPE_tag *) 0xFFD00980UL)
#define GTM_TBU (*(volatile struct GTM_TBU_tag *) 0xFFD00100UL)
#define GTM_TIM_0 (*(volatile struct GTM_TIM_tag *) 0xFFD01000UL)
#define GTM_TIM_1 (*(volatile struct GTM_TIM_tag *) 0xFFD01800UL)
#define GTM_TIM_2 (*(volatile struct GTM_TIM_tag *) 0xFFD02000UL)
#define GTM_TIM_3 (*(volatile struct GTM_TIM_tag *) 0xFFD02800UL)
#define GTM_TIM_4 (*(volatile struct GTM_TIM_tag *) 0xFFD03000UL)
#define GTM_TIM_5 (*(volatile struct GTM_TIM_tag *) 0xFFD03800UL)
#define GTM_TOM_0 (*(volatile struct GTM_TOM_tag *) 0xFFD08000UL)
#define GTM_TOM_1 (*(volatile struct GTM_TOM_tag *) 0xFFD08800UL)
#define GTM_TOM_2 (*(volatile struct GTM_TOM_tag *) 0xFFD09000UL)
#define GTM_TOM_3 (*(volatile struct GTM_TOM_tag *) 0xFFD09800UL)
#define GTM_TOM_4 (*(volatile struct GTM_TOM_tag *) 0xFFD0A000UL)
#define I2C_0 (*(volatile struct I2C_tag *) 0xFFE68000UL)
#define I2C_1 (*(volatile struct I2C_tag *) 0xFBE68000UL)
#define IMA (*(volatile struct IMA_tag *) 0xFFF54000UL)
#define INTC_0 (*(volatile struct INTC_tag *) 0xFC040000UL)
#define IRCOSC (*(volatile struct IRCOSC_tag *) 0xFFFB0000UL)
#define JDC (*(volatile struct JDC_tag *) 0xFFF3C000UL)
#define JTAGM (*(volatile struct JTAGM_tag *) 0xFFF48000UL)
#define LFAST_0 (*(volatile struct LFAST_tag *) 0xFFFD8000UL)
#define LINFlexD_0 (*(volatile struct LINFlexD_tag *) 0xFFE8C000UL)
#define LINFlexD_1 (*(volatile struct LINFlexD_tag *) 0xFFE90000UL)
#define LINFlexD_14 (*(volatile struct LINFlexD_tag *) 0xFFEA8000UL)
#define LINFlexD_15 (*(volatile struct LINFlexD_tag *) 0xFBEA8000UL)
#define LINFlexD_16 (*(volatile struct LINFlexD_tag *) 0xFFEAC000UL)
#define LINFlexD_2 (*(volatile struct LINFlexD_tag *) 0xFBE8C000UL)
#define MC_CGM (*(volatile struct MC_CGM_tag *) 0xFFFB0000UL)
#define MC_ME (*(volatile struct MC_ME_tag *) 0xFFFB8000UL)
#define MC_PCU (*(volatile struct MC_PCU_tag *) 0xFFFA0000UL)
#define MC_RGM (*(volatile struct MC_RGM_tag *) 0xFFFA8000UL)
#define MEMU (*(volatile struct MEMU_tag *) 0xFFF50000UL)
#define M_CAN_1 (*(volatile struct M_CAN_tag *) 0xFFEE4000UL)
#define M_CAN_2 (*(volatile struct M_CAN_tag *) 0xFFEE8000UL)
#define M_CAN_3 (*(volatile struct M_CAN_tag *) 0xFFEEC000UL)
#define M_CAN_4 (*(volatile struct M_CAN_tag *) 0xFFEF0000UL)
#define M_TTCAN (*(volatile struct M_TTCAN_tag *) 0xFFEDC000UL)
#define PASS (*(volatile struct PASS_tag *) 0xFFFF4000UL)
#define PBRIDGE_A (*(volatile struct PBRIDGE_tag *) 0xFC000000UL)
#define PBRIDGE_B (*(volatile struct PBRIDGE_tag *) 0xF8000000UL)
#define PCM (*(volatile struct PCM_tag *) 0xFC028000UL)
#define PFLASH (*(volatile struct PFLASH_tag *) 0xFC030000UL)
#define PIT_0 (*(volatile struct PIT_tag *) 0xFFF84000UL)
#define PIT_1 (*(volatile struct PIT_tag *) 0xFFF80000UL)
#define PLLDIG (*(volatile struct PLLDIG_tag *) 0xFFFB0100UL)
#define PMCDIG (*(volatile struct PMCDIG_tag *) 0xFFFA0400UL)
#define PRAMC (*(volatile struct PRAMC_tag *) 0xFC020000UL)
#define PSI5_0 (*(volatile struct PSI5_tag *) 0xFFE40000UL)
#define PSI5_1 (*(volatile struct PSI5_tag *) 0xFBE40000UL)
#define PSI5S (*(volatile struct PSI5S_tag *) 0xFBF74000UL)
#define REG_PROT (*(volatile struct REG_PROT_tag *) 0UL)
#define SARADC_0 (*(volatile struct SARADC_tag *) 0xFFE00000UL)
#define SARADC_1 (*(volatile struct SARADC_tag *) 0xFBE04000UL)
#define SARADC_10 (*(volatile struct SARADC_tag *) 0xFBE28000UL)
#define SARADC_2 (*(volatile struct SARADC_tag *) 0xFBE08000UL)
#define SARADC_3 (*(volatile struct SARADC_tag *) 0xFBE0C000UL)
#define SARADC_4 (*(volatile struct SARADC_tag *) 0xFFE10000UL)
#define SARADC_5 (*(volatile struct SARADC_tag *) 0xFBE14000UL)
#define SARADC_6 (*(volatile struct SARADC_tag *) 0xFBE18000UL)
#define SARADC_7 (*(volatile struct SARADC_tag *) 0xFBE1C000UL)
#define SARADC_8 (*(volatile struct SARADC_tag *) 0xFBE20000UL)
#define SARADC_9 (*(volatile struct SARADC_tag *) 0xFBE24000UL)
#define SARADC_B (*(volatile struct SARADC_tag *) 0xFFE3C000UL)
#define SDADC_0 (*(volatile struct SDADC_tag *) 0xFFF0C000UL)
#define SDADC_1 (*(volatile struct SDADC_tag *) 0xFBF0C000UL)
#define SDADC_2 (*(volatile struct SDADC_tag *) 0xFFF10000UL)
#define SDADC_3 (*(volatile struct SDADC_tag *) 0xFBF10000UL)
#define SDADC_4 (*(volatile struct SDADC_tag *) 0xFFF14000UL)
#define SDADC_5 (*(volatile struct SDADC_tag *) 0xFBF14000UL)
#define SDADC_6 (*(volatile struct SDADC_tag *) 0xFFF18000UL)
#define SDADC_7 (*(volatile struct SDADC_tag *) 0xFBF18000UL)
#define SDADC_8 (*(volatile struct SDADC_tag *) 0xFFF1C000UL)
#define SDADC_9 (*(volatile struct SDADC_tag *) 0xFBF1C000UL)
#define SEMA42 (*(volatile struct SEMA42_tag *) 0xFC03C000UL)
#define SIPI_0 (*(volatile struct SIPI_tag *) 0xFFFD0000UL)
#define SIUL2 (*(volatile struct SIUL2_tag *) 0xFFFC0000UL)
#define SMPU_0 (*(volatile struct SMPU_tag *) 0xFC010000UL)
#define SMPU_1 (*(volatile struct SMPU_tag *) 0xFC014000UL)
#define SRX_0 (*(volatile struct SRX_tag *) 0xFFE5C000UL)
#define SRX_1 (*(volatile struct SRX_tag *) 0xFBE5C000UL)
#define SSCM (*(volatile struct SSCM_tag *) 0xFFFF8000UL)
#define STCU2 (*(volatile struct STCU2_tag *) 0xFFF44000UL)
#define STM_0 (*(volatile struct STM_tag *) 0xFC068000UL)
#define STM_1 (*(volatile struct STM_tag *) 0xFC06C000UL)
#define STM_2 (*(volatile struct STM_tag *) 0xFC070000UL)
#define SWT_0 (*(volatile struct SWT_tag *) 0xFC050000UL)
#define SWT_1 (*(volatile struct SWT_tag *) 0xFC054000UL)
#define SWT_2 (*(volatile struct SWT_tag *) 0xFC058000UL)
#define SWT_3 (*(volatile struct SWT_tag *) 0xFC05C000UL)
#define TDM (*(volatile struct TDM_tag *) 0xFFF34000UL)
#define WKPU (*(volatile struct WKPU_tag *) 0xFFF98000UL)
#define XBAR_0 (*(volatile struct XBAR_tag *) 0xFC004000UL)
#define XBAR_1 (*(volatile struct XBAR_tag *) 0xFC008000UL)
#define XBIC_0 (*(volatile struct XBIC_tag *) 0xFC018000UL)
#define XBIC_1 (*(volatile struct XBIC_tag *) 0xFC01C000UL)
#define XOSC (*(volatile struct XOSC_tag *) 0xFFFB0080UL)
#define eDMA_0 (*(volatile struct eDMA_tag *) 0xFC0A0000UL)
#define eDMA_1 (*(volatile struct eDMA_tag *) 0xFC0A4000UL)

/* C55FMC */
#define C55FMC_MCR           C55FMC.MCR.R                  /* Module Configuration Register */
#define C55FMC_MCRA          C55FMC.MCRA.R                 /* Alternate Module Configuration Register */
#define C55FMC_MCRE          C55FMC.MCRE.R                 /* Extended Module Configuration Register */
#define C55FMC_LOCK0         C55FMC.LOCK0.R                /* Lock 0 register */
#define C55FMC_LOCK1         C55FMC.LOCK1.R                /* Lock 1 register */
#define C55FMC_LOCK2         C55FMC.LOCK2.R                /* Lock 2 register */
#define C55FMC_LOCK3         C55FMC.LOCK3.R                /* Lock 3 register */
#define C55FMC_LOCK0A        C55FMC.LOCK0A.R               /* Alternate Lock 0 register */
#define C55FMC_LOCK1A        C55FMC.LOCK1A.R               /* Alternate Lock 1 register */
#define C55FMC_SEL0          C55FMC.SEL0.R                 /* Select 0 register */
#define C55FMC_SEL1          C55FMC.SEL1.R                 /* Select 1 register */
#define C55FMC_SEL2          C55FMC.SEL2.R                 /* Select 2 register */
#define C55FMC_SEL3          C55FMC.SEL3.R                 /* Select 3 register */
#define C55FMC_ADR           C55FMC.ADR.R                  /* Address register */
#define C55FMC_UT0           C55FMC.UT0.R                  /* UTest 0 register */
#define C55FMC_UM0           C55FMC.UM[0].R                /* UMISR register */
#define C55FMC_UM1           C55FMC.UM[1].R                /* UMISR register */
#define C55FMC_UM2           C55FMC.UM[2].R                /* UMISR register */
#define C55FMC_UM3           C55FMC.UM[3].R                /* UMISR register */
#define C55FMC_UM4           C55FMC.UM[4].R                /* UMISR register */
#define C55FMC_UM5           C55FMC.UM[5].R                /* UMISR register */
#define C55FMC_UM6           C55FMC.UM[6].R                /* UMISR register */
#define C55FMC_UM7           C55FMC.UM[7].R                /* UMISR register */
#define C55FMC_UM8           C55FMC.UM[8].R                /* UMISR register */
#define C55FMC_UM9           C55FMC.UM9.R                  /* UMISR register */
#define C55FMC_OPP0          C55FMC.OPP0.R                 /* Over-Program Protection 0 register */
#define C55FMC_OPP1          C55FMC.OPP1.R                 /* Over-Program Protection 1 register */
#define C55FMC_OPP2          C55FMC.OPP2.R                 /* Over-Program Protection 2 register */
#define C55FMC_OPP3          C55FMC.OPP3.R                 /* Over-Program Protection 3 register */
#define C55FMC_TMD           C55FMC.TMD.R                  /* Test Mode Disable Password Check register */

/* CMU */
#define CMU_ADCSAR_CSR       CMU_ADCSAR.CSR.R              /* CMU Control Status Register */
#define CMU_ADCSAR_FDR       CMU_ADCSAR.FDR.R              /* CMU Frequency Display Register */
#define CMU_ADCSAR_HFREFR    CMU_ADCSAR.HFREFR.R           /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_ADCSAR_LFREFR    CMU_ADCSAR.LFREFR.R           /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_ADCSAR_ISR       CMU_ADCSAR.ISR.R              /* CMU Interrupt Status Register */
#define CMU_ADCSAR_MDR       CMU_ADCSAR.MDR.R              /* CMU Measurement Duration Register */

#define CMU_ADCSD_CSR        CMU_ADCSD.CSR.R               /* CMU Control Status Register */
#define CMU_ADCSD_FDR        CMU_ADCSD.FDR.R               /* CMU Frequency Display Register */
#define CMU_ADCSD_HFREFR     CMU_ADCSD.HFREFR.R            /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_ADCSD_LFREFR     CMU_ADCSD.LFREFR.R            /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_ADCSD_ISR        CMU_ADCSD.ISR.R               /* CMU Interrupt Status Register */
#define CMU_ADCSD_MDR        CMU_ADCSD.MDR.R               /* CMU Measurement Duration Register */

#define CMU_CLKOUT_CSR       CMU_CLKOUT.CSR.R              /* CMU Control Status Register */
#define CMU_CLKOUT_FDR       CMU_CLKOUT.FDR.R              /* CMU Frequency Display Register */
#define CMU_CLKOUT_HFREFR    CMU_CLKOUT.HFREFR.R           /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_CLKOUT_LFREFR    CMU_CLKOUT.LFREFR.R           /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_CLKOUT_ISR       CMU_CLKOUT.ISR.R              /* CMU Interrupt Status Register */
#define CMU_CLKOUT_MDR       CMU_CLKOUT.MDR.R              /* CMU Measurement Duration Register */

#define CMU_CORE_CSR         CMU_CORE.CSR.R                /* CMU Control Status Register */
#define CMU_CORE_FDR         CMU_CORE.FDR.R                /* CMU Frequency Display Register */
#define CMU_CORE_HFREFR      CMU_CORE.HFREFR.R             /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_CORE_LFREFR      CMU_CORE.LFREFR.R             /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_CORE_ISR         CMU_CORE.ISR.R                /* CMU Interrupt Status Register */
#define CMU_CORE_MDR         CMU_CORE.MDR.R                /* CMU Measurement Duration Register */

#define CMU_FXBAR_CSR        CMU_FXBAR.CSR.R               /* CMU Control Status Register */
#define CMU_FXBAR_FDR        CMU_FXBAR.FDR.R               /* CMU Frequency Display Register */
#define CMU_FXBAR_HFREFR     CMU_FXBAR.HFREFR.R            /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_FXBAR_LFREFR     CMU_FXBAR.LFREFR.R            /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_FXBAR_ISR        CMU_FXBAR.ISR.R               /* CMU Interrupt Status Register */
#define CMU_FXBAR_MDR        CMU_FXBAR.MDR.R               /* CMU Measurement Duration Register */

#define CMU_PBRIDGE_CSR      CMU_PBRIDGE.CSR.R             /* CMU Control Status Register */
#define CMU_PBRIDGE_FDR      CMU_PBRIDGE.FDR.R             /* CMU Frequency Display Register */
#define CMU_PBRIDGE_HFREFR   CMU_PBRIDGE.HFREFR.R          /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_PBRIDGE_LFREFR   CMU_PBRIDGE.LFREFR.R          /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_PBRIDGE_ISR      CMU_PBRIDGE.ISR.R             /* CMU Interrupt Status Register */
#define CMU_PBRIDGE_MDR      CMU_PBRIDGE.MDR.R             /* CMU Measurement Duration Register */

#define CMU_PER_CSR          CMU_PER.CSR.R                 /* CMU Control Status Register */
#define CMU_PER_FDR          CMU_PER.FDR.R                 /* CMU Frequency Display Register */
#define CMU_PER_HFREFR       CMU_PER.HFREFR.R              /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_PER_LFREFR       CMU_PER.LFREFR.R              /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_PER_ISR          CMU_PER.ISR.R                 /* CMU Interrupt Status Register */
#define CMU_PER_MDR          CMU_PER.MDR.R                 /* CMU Measurement Duration Register */

#define CMU_PLL_CSR          CMU_PLL.CSR.R                 /* CMU Control Status Register */
#define CMU_PLL_FDR          CMU_PLL.FDR.R                 /* CMU Frequency Display Register */
#define CMU_PLL_HFREFR       CMU_PLL.HFREFR.R              /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_PLL_LFREFR       CMU_PLL.LFREFR.R              /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_PLL_ISR          CMU_PLL.ISR.R                 /* CMU Interrupt Status Register */
#define CMU_PLL_MDR          CMU_PLL.MDR.R                 /* CMU Measurement Duration Register */

#define CMU_PSI5_1US_CSR     CMU_PSI5_1US.CSR.R            /* CMU Control Status Register */
#define CMU_PSI5_1US_FDR     CMU_PSI5_1US.FDR.R            /* CMU Frequency Display Register */
#define CMU_PSI5_1US_HFREFR  CMU_PSI5_1US.HFREFR.R         /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_PSI5_1US_LFREFR  CMU_PSI5_1US.LFREFR.R         /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_PSI5_1US_ISR     CMU_PSI5_1US.ISR.R            /* CMU Interrupt Status Register */
#define CMU_PSI5_1US_MDR     CMU_PSI5_1US.MDR.R            /* CMU Measurement Duration Register */

#define CMU_PSI5_F125_CSR    CMU_PSI5_F125.CSR.R           /* CMU Control Status Register */
#define CMU_PSI5_F125_FDR    CMU_PSI5_F125.FDR.R           /* CMU Frequency Display Register */
#define CMU_PSI5_F125_HFREFR CMU_PSI5_F125.HFREFR.R        /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_PSI5_F125_LFREFR CMU_PSI5_F125.LFREFR.R        /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_PSI5_F125_ISR    CMU_PSI5_F125.ISR.R           /* CMU Interrupt Status Register */
#define CMU_PSI5_F125_MDR    CMU_PSI5_F125.MDR.R           /* CMU Measurement Duration Register */

#define CMU_PSI5_F189_CSR    CMU_PSI5_F189.CSR.R           /* CMU Control Status Register */
#define CMU_PSI5_F189_FDR    CMU_PSI5_F189.FDR.R           /* CMU Frequency Display Register */
#define CMU_PSI5_F189_HFREFR CMU_PSI5_F189.HFREFR.R        /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_PSI5_F189_LFREFR CMU_PSI5_F189.LFREFR.R        /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_PSI5_F189_ISR    CMU_PSI5_F189.ISR.R           /* CMU Interrupt Status Register */
#define CMU_PSI5_F189_MDR    CMU_PSI5_F189.MDR.R           /* CMU Measurement Duration Register */

#define CMU_SENT_CSR         CMU_SENT.CSR.R                /* CMU Control Status Register */
#define CMU_SENT_FDR         CMU_SENT.FDR.R                /* CMU Frequency Display Register */
#define CMU_SENT_HFREFR      CMU_SENT.HFREFR.R             /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_SENT_LFREFR      CMU_SENT.LFREFR.R             /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_SENT_ISR         CMU_SENT.ISR.R                /* CMU Interrupt Status Register */
#define CMU_SENT_MDR         CMU_SENT.MDR.R                /* CMU Measurement Duration Register */

#define CMU_SXBAR_CSR        CMU_SXBAR.CSR.R               /* CMU Control Status Register */
#define CMU_SXBAR_FDR        CMU_SXBAR.FDR.R               /* CMU Frequency Display Register */
#define CMU_SXBAR_HFREFR     CMU_SXBAR.HFREFR.R            /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_SXBAR_LFREFR     CMU_SXBAR.LFREFR.R            /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_SXBAR_ISR        CMU_SXBAR.ISR.R               /* CMU Interrupt Status Register */
#define CMU_SXBAR_MDR        CMU_SXBAR.MDR.R               /* CMU Measurement Duration Register */

/* CRC */
#define CRC_0_CFG            CRC_0.CFG.R                   /* Configuration Register */
#define CRC_0_INP            CRC_0.INP.R                   /* Input Register */
#define CRC_0_CSTAT          CRC_0.CSTAT.R                 /* Current Status Register */
#define CRC_0_OUTP           CRC_0.OUTP.R                  /* Output Register */

#define CRC_1_CFG            CRC_1.CFG.R                   /* Configuration Register */
#define CRC_1_INP            CRC_1.INP.R                   /* Input Register */
#define CRC_1_CSTAT          CRC_1.CSTAT.R                 /* Current Status Register */
#define CRC_1_OUTP           CRC_1.OUTP.R                  /* Output Register */

/* DMAMUX */
#define DMAMUX_0_CHCFG0      DMAMUX_0.CHCFG[0].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG1      DMAMUX_0.CHCFG[1].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG2      DMAMUX_0.CHCFG[2].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG3      DMAMUX_0.CHCFG[3].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG4      DMAMUX_0.CHCFG[4].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG5      DMAMUX_0.CHCFG[5].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG6      DMAMUX_0.CHCFG[6].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG7      DMAMUX_0.CHCFG[7].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG8      DMAMUX_0.CHCFG[8].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG9      DMAMUX_0.CHCFG[9].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG10     DMAMUX_0.CHCFG[10].R          /* Channel Configuration register */
#define DMAMUX_0_CHCFG11     DMAMUX_0.CHCFG[11].R          /* Channel Configuration register */
#define DMAMUX_0_CHCFG12     DMAMUX_0.CHCFG[12].R          /* Channel Configuration register */
#define DMAMUX_0_CHCFG13     DMAMUX_0.CHCFG[13].R          /* Channel Configuration register */
#define DMAMUX_0_CHCFG14     DMAMUX_0.CHCFG[14].R          /* Channel Configuration register */
#define DMAMUX_0_CHCFG15     DMAMUX_0.CHCFG[15].R          /* Channel Configuration register */

#define DMAMUX_1_CHCFG0      DMAMUX_1.CHCFG[0].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG1      DMAMUX_1.CHCFG[1].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG2      DMAMUX_1.CHCFG[2].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG3      DMAMUX_1.CHCFG[3].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG4      DMAMUX_1.CHCFG[4].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG5      DMAMUX_1.CHCFG[5].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG6      DMAMUX_1.CHCFG[6].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG7      DMAMUX_1.CHCFG[7].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG8      DMAMUX_1.CHCFG[8].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG9      DMAMUX_1.CHCFG[9].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG10     DMAMUX_1.CHCFG[10].R          /* Channel Configuration register */
#define DMAMUX_1_CHCFG11     DMAMUX_1.CHCFG[11].R          /* Channel Configuration register */
#define DMAMUX_1_CHCFG12     DMAMUX_1.CHCFG[12].R          /* Channel Configuration register */
#define DMAMUX_1_CHCFG13     DMAMUX_1.CHCFG[13].R          /* Channel Configuration register */
#define DMAMUX_1_CHCFG14     DMAMUX_1.CHCFG[14].R          /* Channel Configuration register */
#define DMAMUX_1_CHCFG15     DMAMUX_1.CHCFG[15].R          /* Channel Configuration register */

#define DMAMUX_2_CHCFG0      DMAMUX_2.CHCFG[0].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG1      DMAMUX_2.CHCFG[1].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG2      DMAMUX_2.CHCFG[2].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG3      DMAMUX_2.CHCFG[3].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG4      DMAMUX_2.CHCFG[4].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG5      DMAMUX_2.CHCFG[5].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG6      DMAMUX_2.CHCFG[6].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG7      DMAMUX_2.CHCFG[7].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG8      DMAMUX_2.CHCFG[8].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG9      DMAMUX_2.CHCFG[9].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG10     DMAMUX_2.CHCFG[10].R          /* Channel Configuration register */
#define DMAMUX_2_CHCFG11     DMAMUX_2.CHCFG[11].R          /* Channel Configuration register */
#define DMAMUX_2_CHCFG12     DMAMUX_2.CHCFG[12].R          /* Channel Configuration register */
#define DMAMUX_2_CHCFG13     DMAMUX_2.CHCFG[13].R          /* Channel Configuration register */
#define DMAMUX_2_CHCFG14     DMAMUX_2.CHCFG[14].R          /* Channel Configuration register */
#define DMAMUX_2_CHCFG15     DMAMUX_2.CHCFG[15].R          /* Channel Configuration register */

#define DMAMUX_3_CHCFG0      DMAMUX_3.CHCFG[0].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG1      DMAMUX_3.CHCFG[1].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG2      DMAMUX_3.CHCFG[2].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG3      DMAMUX_3.CHCFG[3].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG4      DMAMUX_3.CHCFG[4].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG5      DMAMUX_3.CHCFG[5].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG6      DMAMUX_3.CHCFG[6].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG7      DMAMUX_3.CHCFG[7].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG8      DMAMUX_3.CHCFG[8].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG9      DMAMUX_3.CHCFG[9].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG10     DMAMUX_3.CHCFG[10].R          /* Channel Configuration register */
#define DMAMUX_3_CHCFG11     DMAMUX_3.CHCFG[11].R          /* Channel Configuration register */
#define DMAMUX_3_CHCFG12     DMAMUX_3.CHCFG[12].R          /* Channel Configuration register */
#define DMAMUX_3_CHCFG13     DMAMUX_3.CHCFG[13].R          /* Channel Configuration register */
#define DMAMUX_3_CHCFG14     DMAMUX_3.CHCFG[14].R          /* Channel Configuration register */
#define DMAMUX_3_CHCFG15     DMAMUX_3.CHCFG[15].R          /* Channel Configuration register */

#define DMAMUX_4_CHCFG0      DMAMUX_4.CHCFG[0].R           /* Channel Configuration register */
#define DMAMUX_4_CHCFG1      DMAMUX_4.CHCFG[1].R           /* Channel Configuration register */
#define DMAMUX_4_CHCFG2      DMAMUX_4.CHCFG[2].R           /* Channel Configuration register */
#define DMAMUX_4_CHCFG3      DMAMUX_4.CHCFG[3].R           /* Channel Configuration register */
#define DMAMUX_4_CHCFG4      DMAMUX_4.CHCFG[4].R           /* Channel Configuration register */
#define DMAMUX_4_CHCFG5      DMAMUX_4.CHCFG[5].R           /* Channel Configuration register */
#define DMAMUX_4_CHCFG6      DMAMUX_4.CHCFG[6].R           /* Channel Configuration register */
#define DMAMUX_4_CHCFG7      DMAMUX_4.CHCFG[7].R           /* Channel Configuration register */
#define DMAMUX_4_CHCFG8      DMAMUX_4.CHCFG[8].R           /* Channel Configuration register */
#define DMAMUX_4_CHCFG9      DMAMUX_4.CHCFG[9].R           /* Channel Configuration register */
#define DMAMUX_4_CHCFG10     DMAMUX_4.CHCFG[10].R          /* Channel Configuration register */
#define DMAMUX_4_CHCFG11     DMAMUX_4.CHCFG[11].R          /* Channel Configuration register */
#define DMAMUX_4_CHCFG12     DMAMUX_4.CHCFG[12].R          /* Channel Configuration register */
#define DMAMUX_4_CHCFG13     DMAMUX_4.CHCFG[13].R          /* Channel Configuration register */
#define DMAMUX_4_CHCFG14     DMAMUX_4.CHCFG[14].R          /* Channel Configuration register */
#define DMAMUX_4_CHCFG15     DMAMUX_4.CHCFG[15].R          /* Channel Configuration register */

#define DMAMUX_5_CHCFG0      DMAMUX_5.CHCFG[0].R           /* Channel Configuration register */
#define DMAMUX_5_CHCFG1      DMAMUX_5.CHCFG[1].R           /* Channel Configuration register */
#define DMAMUX_5_CHCFG2      DMAMUX_5.CHCFG[2].R           /* Channel Configuration register */
#define DMAMUX_5_CHCFG3      DMAMUX_5.CHCFG[3].R           /* Channel Configuration register */
#define DMAMUX_5_CHCFG4      DMAMUX_5.CHCFG[4].R           /* Channel Configuration register */
#define DMAMUX_5_CHCFG5      DMAMUX_5.CHCFG[5].R           /* Channel Configuration register */
#define DMAMUX_5_CHCFG6      DMAMUX_5.CHCFG[6].R           /* Channel Configuration register */
#define DMAMUX_5_CHCFG7      DMAMUX_5.CHCFG[7].R           /* Channel Configuration register */
#define DMAMUX_5_CHCFG8      DMAMUX_5.CHCFG[8].R           /* Channel Configuration register */
#define DMAMUX_5_CHCFG9      DMAMUX_5.CHCFG[9].R           /* Channel Configuration register */
#define DMAMUX_5_CHCFG10     DMAMUX_5.CHCFG[10].R          /* Channel Configuration register */
#define DMAMUX_5_CHCFG11     DMAMUX_5.CHCFG[11].R          /* Channel Configuration register */
#define DMAMUX_5_CHCFG12     DMAMUX_5.CHCFG[12].R          /* Channel Configuration register */
#define DMAMUX_5_CHCFG13     DMAMUX_5.CHCFG[13].R          /* Channel Configuration register */
#define DMAMUX_5_CHCFG14     DMAMUX_5.CHCFG[14].R          /* Channel Configuration register */
#define DMAMUX_5_CHCFG15     DMAMUX_5.CHCFG[15].R          /* Channel Configuration register */

#define DMAMUX_6_CHCFG0      DMAMUX_6.CHCFG[0].R           /* Channel Configuration register */
#define DMAMUX_6_CHCFG1      DMAMUX_6.CHCFG[1].R           /* Channel Configuration register */
#define DMAMUX_6_CHCFG2      DMAMUX_6.CHCFG[2].R           /* Channel Configuration register */
#define DMAMUX_6_CHCFG3      DMAMUX_6.CHCFG[3].R           /* Channel Configuration register */
#define DMAMUX_6_CHCFG4      DMAMUX_6.CHCFG[4].R           /* Channel Configuration register */
#define DMAMUX_6_CHCFG5      DMAMUX_6.CHCFG[5].R           /* Channel Configuration register */
#define DMAMUX_6_CHCFG6      DMAMUX_6.CHCFG[6].R           /* Channel Configuration register */
#define DMAMUX_6_CHCFG7      DMAMUX_6.CHCFG[7].R           /* Channel Configuration register */
#define DMAMUX_6_CHCFG8      DMAMUX_6.CHCFG[8].R           /* Channel Configuration register */
#define DMAMUX_6_CHCFG9      DMAMUX_6.CHCFG[9].R           /* Channel Configuration register */
#define DMAMUX_6_CHCFG10     DMAMUX_6.CHCFG[10].R          /* Channel Configuration register */
#define DMAMUX_6_CHCFG11     DMAMUX_6.CHCFG[11].R          /* Channel Configuration register */
#define DMAMUX_6_CHCFG12     DMAMUX_6.CHCFG[12].R          /* Channel Configuration register */
#define DMAMUX_6_CHCFG13     DMAMUX_6.CHCFG[13].R          /* Channel Configuration register */
#define DMAMUX_6_CHCFG14     DMAMUX_6.CHCFG[14].R          /* Channel Configuration register */
#define DMAMUX_6_CHCFG15     DMAMUX_6.CHCFG[15].R          /* Channel Configuration register */

#define DMAMUX_7_CHCFG0      DMAMUX_7.CHCFG[0].R           /* Channel Configuration register */
#define DMAMUX_7_CHCFG1      DMAMUX_7.CHCFG[1].R           /* Channel Configuration register */
#define DMAMUX_7_CHCFG2      DMAMUX_7.CHCFG[2].R           /* Channel Configuration register */
#define DMAMUX_7_CHCFG3      DMAMUX_7.CHCFG[3].R           /* Channel Configuration register */
#define DMAMUX_7_CHCFG4      DMAMUX_7.CHCFG[4].R           /* Channel Configuration register */
#define DMAMUX_7_CHCFG5      DMAMUX_7.CHCFG[5].R           /* Channel Configuration register */
#define DMAMUX_7_CHCFG6      DMAMUX_7.CHCFG[6].R           /* Channel Configuration register */
#define DMAMUX_7_CHCFG7      DMAMUX_7.CHCFG[7].R           /* Channel Configuration register */
#define DMAMUX_7_CHCFG8      DMAMUX_7.CHCFG[8].R           /* Channel Configuration register */
#define DMAMUX_7_CHCFG9      DMAMUX_7.CHCFG[9].R           /* Channel Configuration register */
#define DMAMUX_7_CHCFG10     DMAMUX_7.CHCFG[10].R          /* Channel Configuration register */
#define DMAMUX_7_CHCFG11     DMAMUX_7.CHCFG[11].R          /* Channel Configuration register */
#define DMAMUX_7_CHCFG12     DMAMUX_7.CHCFG[12].R          /* Channel Configuration register */
#define DMAMUX_7_CHCFG13     DMAMUX_7.CHCFG[13].R          /* Channel Configuration register */
#define DMAMUX_7_CHCFG14     DMAMUX_7.CHCFG[14].R          /* Channel Configuration register */
#define DMAMUX_7_CHCFG15     DMAMUX_7.CHCFG[15].R          /* Channel Configuration register */

#define DMAMUX_8_CHCFG0      DMAMUX_8.CHCFG[0].R           /* Channel Configuration register */
#define DMAMUX_8_CHCFG1      DMAMUX_8.CHCFG[1].R           /* Channel Configuration register */
#define DMAMUX_8_CHCFG2      DMAMUX_8.CHCFG[2].R           /* Channel Configuration register */
#define DMAMUX_8_CHCFG3      DMAMUX_8.CHCFG[3].R           /* Channel Configuration register */
#define DMAMUX_8_CHCFG4      DMAMUX_8.CHCFG[4].R           /* Channel Configuration register */
#define DMAMUX_8_CHCFG5      DMAMUX_8.CHCFG[5].R           /* Channel Configuration register */
#define DMAMUX_8_CHCFG6      DMAMUX_8.CHCFG[6].R           /* Channel Configuration register */
#define DMAMUX_8_CHCFG7      DMAMUX_8.CHCFG[7].R           /* Channel Configuration register */
#define DMAMUX_8_CHCFG8      DMAMUX_8.CHCFG[8].R           /* Channel Configuration register */
#define DMAMUX_8_CHCFG9      DMAMUX_8.CHCFG[9].R           /* Channel Configuration register */
#define DMAMUX_8_CHCFG10     DMAMUX_8.CHCFG[10].R          /* Channel Configuration register */
#define DMAMUX_8_CHCFG11     DMAMUX_8.CHCFG[11].R          /* Channel Configuration register */
#define DMAMUX_8_CHCFG12     DMAMUX_8.CHCFG[12].R          /* Channel Configuration register */
#define DMAMUX_8_CHCFG13     DMAMUX_8.CHCFG[13].R          /* Channel Configuration register */
#define DMAMUX_8_CHCFG14     DMAMUX_8.CHCFG[14].R          /* Channel Configuration register */
#define DMAMUX_8_CHCFG15     DMAMUX_8.CHCFG[15].R          /* Channel Configuration register */

#define DMAMUX_9_CHCFG0      DMAMUX_9.CHCFG[0].R           /* Channel Configuration register */
#define DMAMUX_9_CHCFG1      DMAMUX_9.CHCFG[1].R           /* Channel Configuration register */
#define DMAMUX_9_CHCFG2      DMAMUX_9.CHCFG[2].R           /* Channel Configuration register */
#define DMAMUX_9_CHCFG3      DMAMUX_9.CHCFG[3].R           /* Channel Configuration register */
#define DMAMUX_9_CHCFG4      DMAMUX_9.CHCFG[4].R           /* Channel Configuration register */
#define DMAMUX_9_CHCFG5      DMAMUX_9.CHCFG[5].R           /* Channel Configuration register */
#define DMAMUX_9_CHCFG6      DMAMUX_9.CHCFG[6].R           /* Channel Configuration register */
#define DMAMUX_9_CHCFG7      DMAMUX_9.CHCFG[7].R           /* Channel Configuration register */
#define DMAMUX_9_CHCFG8      DMAMUX_9.CHCFG[8].R           /* Channel Configuration register */
#define DMAMUX_9_CHCFG9      DMAMUX_9.CHCFG[9].R           /* Channel Configuration register */
#define DMAMUX_9_CHCFG10     DMAMUX_9.CHCFG[10].R          /* Channel Configuration register */
#define DMAMUX_9_CHCFG11     DMAMUX_9.CHCFG[11].R          /* Channel Configuration register */
#define DMAMUX_9_CHCFG12     DMAMUX_9.CHCFG[12].R          /* Channel Configuration register */
#define DMAMUX_9_CHCFG13     DMAMUX_9.CHCFG[13].R          /* Channel Configuration register */
#define DMAMUX_9_CHCFG14     DMAMUX_9.CHCFG[14].R          /* Channel Configuration register */
#define DMAMUX_9_CHCFG15     DMAMUX_9.CHCFG[15].R          /* Channel Configuration register */

/* DSPI */
#define DSPI_0_MCR           DSPI_0.MCR.R                  /* DSPI Module Configuration Register */
#define DSPI_0_TCR           DSPI_0.TCR.R                  /* DSPI Transfer Count Register */
#define DSPI_0_CTAR0         DSPI_0.MODE.CTAR[0].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_CTAR1         DSPI_0.MODE.CTAR[1].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_CTAR2         DSPI_0.MODE.CTAR[2].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_CTAR3         DSPI_0.MODE.CTAR[3].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_CTAR4         DSPI_0.MODE.CTAR[4].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_CTAR5         DSPI_0.MODE.CTAR[5].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_CTAR6         DSPI_0.MODE.CTAR[6].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_CTAR7         DSPI_0.MODE.CTAR[7].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_CTAR_SLAVE0   DSPI_0.MODE.CTAR_SLAVE[0].R   /* DSPI Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_0_CTAR_SLAVE1   DSPI_0.MODE.CTAR_SLAVE[1].R   /* DSPI Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_0_SR            DSPI_0.SR.R                   /* DSPI Status Register */
#define DSPI_0_RSER          DSPI_0.RSER.R                 /* DSPI DMA/Interrupt Request Select and Enable Register */
#define DSPI_0_PUSHR         DSPI_0.PUSHR.PUSHR.R          /* DSPI PUSH FIFO Register In Master Mode */
#define DSPI_0_PUSHR_SLAVE   DSPI_0.PUSHR.PUSHR_SLAVE.R    /* DSPI PUSH FIFO Register In Slave Mode */
#define DSPI_0_POPR          DSPI_0.POPR.R                 /* DSPI POP FIFO Register */
#define DSPI_0_TXFR0         DSPI_0.TXFR[0].R              /* DSPI Transmit FIFO Registers */
#define DSPI_0_TXFR1         DSPI_0.TXFR[1].R              /* DSPI Transmit FIFO Registers */
#define DSPI_0_TXFR2         DSPI_0.TXFR[2].R              /* DSPI Transmit FIFO Registers */
#define DSPI_0_TXFR3         DSPI_0.TXFR[3].R              /* DSPI Transmit FIFO Registers */
#define DSPI_0_RXFR0         DSPI_0.RXFR[0].R              /* DSPI Receive FIFO Registers */
#define DSPI_0_RXFR1         DSPI_0.RXFR[1].R              /* DSPI Receive FIFO Registers */
#define DSPI_0_RXFR2         DSPI_0.RXFR[2].R              /* DSPI Receive FIFO Registers */
#define DSPI_0_RXFR3         DSPI_0.RXFR[3].R              /* DSPI Receive FIFO Registers */
#define DSPI_0_DSICR0        DSPI_0.DSICR0.R               /* DSPI DSI Configuration Register 0 */
#define DSPI_0_SDR0          DSPI_0.SDR0.R                 /* DSPI DSI Serialization Data Register 0 */
#define DSPI_0_ASDR0         DSPI_0.ASDR0.R                /* DSPI DSI Alternate Serialization Data Register 0 */
#define DSPI_0_COMPR0        DSPI_0.COMPR0.R               /* DSPI DSI Transmit Comparison Register 0 */
#define DSPI_0_DDR0          DSPI_0.DDR0.R                 /* DSPI DSI Deserialization Data Register 0 */
#define DSPI_0_DSICR1        DSPI_0.DSICR1.R               /* DSPI DSI Configuration Register 1 */
#define DSPI_0_SSR0          DSPI_0.SSR0.R                 /* DSPI DSI Serialization Source Select Register 0 */
#define DSPI_0_DIMR0         DSPI_0.DIMR0.R                /* DSPI DSI Deserialized Data Interrupt Mask Register 0 */
#define DSPI_0_DPIR0         DSPI_0.DPIR0.R                /* DSPI DSI Deserialized Data Polarity Interrupt Register 0 */
#define DSPI_0_CTARE0        DSPI_0.CTARE[0].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_0_CTARE1        DSPI_0.CTARE[1].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_0_CTARE2        DSPI_0.CTARE[2].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_0_CTARE3        DSPI_0.CTARE[3].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_0_CTARE4        DSPI_0.CTARE[4].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_0_CTARE5        DSPI_0.CTARE[5].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_0_CTARE6        DSPI_0.CTARE[6].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_0_CTARE7        DSPI_0.CTARE[7].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_0_SREX          DSPI_0.SREX.R                 /* DSPI Status Register Extended */

#define DSPI_1_MCR           DSPI_1.MCR.R                  /* DSPI Module Configuration Register */
#define DSPI_1_TCR           DSPI_1.TCR.R                  /* DSPI Transfer Count Register */
#define DSPI_1_CTAR0         DSPI_1.MODE.CTAR[0].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_CTAR1         DSPI_1.MODE.CTAR[1].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_CTAR2         DSPI_1.MODE.CTAR[2].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_CTAR3         DSPI_1.MODE.CTAR[3].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_CTAR4         DSPI_1.MODE.CTAR[4].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_CTAR5         DSPI_1.MODE.CTAR[5].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_CTAR6         DSPI_1.MODE.CTAR[6].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_CTAR7         DSPI_1.MODE.CTAR[7].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_CTAR_SLAVE0   DSPI_1.MODE.CTAR_SLAVE[0].R   /* DSPI Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_1_CTAR_SLAVE1   DSPI_1.MODE.CTAR_SLAVE[1].R   /* DSPI Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_1_SR            DSPI_1.SR.R                   /* DSPI Status Register */
#define DSPI_1_RSER          DSPI_1.RSER.R                 /* DSPI DMA/Interrupt Request Select and Enable Register */
#define DSPI_1_PUSHR         DSPI_1.PUSHR.PUSHR.R          /* DSPI PUSH FIFO Register In Master Mode */
#define DSPI_1_PUSHR_SLAVE   DSPI_1.PUSHR.PUSHR_SLAVE.R    /* DSPI PUSH FIFO Register In Slave Mode */
#define DSPI_1_POPR          DSPI_1.POPR.R                 /* DSPI POP FIFO Register */
#define DSPI_1_TXFR0         DSPI_1.TXFR[0].R              /* DSPI Transmit FIFO Registers */
#define DSPI_1_TXFR1         DSPI_1.TXFR[1].R              /* DSPI Transmit FIFO Registers */
#define DSPI_1_TXFR2         DSPI_1.TXFR[2].R              /* DSPI Transmit FIFO Registers */
#define DSPI_1_TXFR3         DSPI_1.TXFR[3].R              /* DSPI Transmit FIFO Registers */
#define DSPI_1_RXFR0         DSPI_1.RXFR[0].R              /* DSPI Receive FIFO Registers */
#define DSPI_1_RXFR1         DSPI_1.RXFR[1].R              /* DSPI Receive FIFO Registers */
#define DSPI_1_RXFR2         DSPI_1.RXFR[2].R              /* DSPI Receive FIFO Registers */
#define DSPI_1_RXFR3         DSPI_1.RXFR[3].R              /* DSPI Receive FIFO Registers */
#define DSPI_1_DSICR0        DSPI_1.DSICR0.R               /* DSPI DSI Configuration Register 0 */
#define DSPI_1_SDR0          DSPI_1.SDR0.R                 /* DSPI DSI Serialization Data Register 0 */
#define DSPI_1_ASDR0         DSPI_1.ASDR0.R                /* DSPI DSI Alternate Serialization Data Register 0 */
#define DSPI_1_COMPR0        DSPI_1.COMPR0.R               /* DSPI DSI Transmit Comparison Register 0 */
#define DSPI_1_DDR0          DSPI_1.DDR0.R                 /* DSPI DSI Deserialization Data Register 0 */
#define DSPI_1_DSICR1        DSPI_1.DSICR1.R               /* DSPI DSI Configuration Register 1 */
#define DSPI_1_SSR0          DSPI_1.SSR0.R                 /* DSPI DSI Serialization Source Select Register 0 */
#define DSPI_1_DIMR0         DSPI_1.DIMR0.R                /* DSPI DSI Deserialized Data Interrupt Mask Register 0 */
#define DSPI_1_DPIR0         DSPI_1.DPIR0.R                /* DSPI DSI Deserialized Data Polarity Interrupt Register 0 */
#define DSPI_1_CTARE0        DSPI_1.CTARE[0].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_1_CTARE1        DSPI_1.CTARE[1].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_1_CTARE2        DSPI_1.CTARE[2].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_1_CTARE3        DSPI_1.CTARE[3].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_1_CTARE4        DSPI_1.CTARE[4].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_1_CTARE5        DSPI_1.CTARE[5].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_1_CTARE6        DSPI_1.CTARE[6].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_1_CTARE7        DSPI_1.CTARE[7].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_1_SREX          DSPI_1.SREX.R                 /* DSPI Status Register Extended */

#define DSPI_12_MCR          DSPI_12.MCR.R                 /* DSPI Module Configuration Register */
#define DSPI_12_TCR          DSPI_12.TCR.R                 /* DSPI Transfer Count Register */
#define DSPI_12_CTAR0        DSPI_12.MODE.CTAR[0].R        /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_12_CTAR1        DSPI_12.MODE.CTAR[1].R        /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_12_CTAR2        DSPI_12.MODE.CTAR[2].R        /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_12_CTAR3        DSPI_12.MODE.CTAR[3].R        /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_12_CTAR4        DSPI_12.MODE.CTAR[4].R        /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_12_CTAR5        DSPI_12.MODE.CTAR[5].R        /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_12_CTAR6        DSPI_12.MODE.CTAR[6].R        /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_12_CTAR7        DSPI_12.MODE.CTAR[7].R        /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_12_CTAR_SLAVE0  DSPI_12.MODE.CTAR_SLAVE[0].R  /* DSPI Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_12_CTAR_SLAVE1  DSPI_12.MODE.CTAR_SLAVE[1].R  /* DSPI Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_12_SR           DSPI_12.SR.R                  /* DSPI Status Register */
#define DSPI_12_RSER         DSPI_12.RSER.R                /* DSPI DMA/Interrupt Request Select and Enable Register */
#define DSPI_12_PUSHR        DSPI_12.PUSHR.PUSHR.R         /* DSPI PUSH FIFO Register In Master Mode */
#define DSPI_12_PUSHR_SLAVE  DSPI_12.PUSHR.PUSHR_SLAVE.R   /* DSPI PUSH FIFO Register In Slave Mode */
#define DSPI_12_POPR         DSPI_12.POPR.R                /* DSPI POP FIFO Register */
#define DSPI_12_TXFR0        DSPI_12.TXFR[0].R             /* DSPI Transmit FIFO Registers */
#define DSPI_12_TXFR1        DSPI_12.TXFR[1].R             /* DSPI Transmit FIFO Registers */
#define DSPI_12_TXFR2        DSPI_12.TXFR[2].R             /* DSPI Transmit FIFO Registers */
#define DSPI_12_TXFR3        DSPI_12.TXFR[3].R             /* DSPI Transmit FIFO Registers */
#define DSPI_12_RXFR0        DSPI_12.RXFR[0].R             /* DSPI Receive FIFO Registers */
#define DSPI_12_RXFR1        DSPI_12.RXFR[1].R             /* DSPI Receive FIFO Registers */
#define DSPI_12_RXFR2        DSPI_12.RXFR[2].R             /* DSPI Receive FIFO Registers */
#define DSPI_12_RXFR3        DSPI_12.RXFR[3].R             /* DSPI Receive FIFO Registers */
#define DSPI_12_DSICR0       DSPI_12.DSICR0.R              /* DSPI DSI Configuration Register 0 */
#define DSPI_12_SDR0         DSPI_12.SDR0.R                /* DSPI DSI Serialization Data Register 0 */
#define DSPI_12_ASDR0        DSPI_12.ASDR0.R               /* DSPI DSI Alternate Serialization Data Register 0 */
#define DSPI_12_COMPR0       DSPI_12.COMPR0.R              /* DSPI DSI Transmit Comparison Register 0 */
#define DSPI_12_DDR0         DSPI_12.DDR0.R                /* DSPI DSI Deserialization Data Register 0 */
#define DSPI_12_DSICR1       DSPI_12.DSICR1.R              /* DSPI DSI Configuration Register 1 */
#define DSPI_12_SSR0         DSPI_12.SSR0.R                /* DSPI DSI Serialization Source Select Register 0 */
#define DSPI_12_DIMR0        DSPI_12.DIMR0.R               /* DSPI DSI Deserialized Data Interrupt Mask Register 0 */
#define DSPI_12_DPIR0        DSPI_12.DPIR0.R               /* DSPI DSI Deserialized Data Polarity Interrupt Register 0 */
#define DSPI_12_CTARE0       DSPI_12.CTARE[0].R            /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_12_CTARE1       DSPI_12.CTARE[1].R            /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_12_CTARE2       DSPI_12.CTARE[2].R            /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_12_CTARE3       DSPI_12.CTARE[3].R            /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_12_CTARE4       DSPI_12.CTARE[4].R            /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_12_CTARE5       DSPI_12.CTARE[5].R            /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_12_CTARE6       DSPI_12.CTARE[6].R            /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_12_CTARE7       DSPI_12.CTARE[7].R            /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_12_SREX         DSPI_12.SREX.R                /* DSPI Status Register Extended */

#define DSPI_2_MCR           DSPI_2.MCR.R                  /* DSPI Module Configuration Register */
#define DSPI_2_TCR           DSPI_2.TCR.R                  /* DSPI Transfer Count Register */
#define DSPI_2_CTAR0         DSPI_2.MODE.CTAR[0].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_CTAR1         DSPI_2.MODE.CTAR[1].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_CTAR2         DSPI_2.MODE.CTAR[2].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_CTAR3         DSPI_2.MODE.CTAR[3].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_CTAR4         DSPI_2.MODE.CTAR[4].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_CTAR5         DSPI_2.MODE.CTAR[5].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_CTAR6         DSPI_2.MODE.CTAR[6].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_CTAR7         DSPI_2.MODE.CTAR[7].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_CTAR_SLAVE0   DSPI_2.MODE.CTAR_SLAVE[0].R   /* DSPI Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_2_CTAR_SLAVE1   DSPI_2.MODE.CTAR_SLAVE[1].R   /* DSPI Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_2_SR            DSPI_2.SR.R                   /* DSPI Status Register */
#define DSPI_2_RSER          DSPI_2.RSER.R                 /* DSPI DMA/Interrupt Request Select and Enable Register */
#define DSPI_2_PUSHR         DSPI_2.PUSHR.PUSHR.R          /* DSPI PUSH FIFO Register In Master Mode */
#define DSPI_2_PUSHR_SLAVE   DSPI_2.PUSHR.PUSHR_SLAVE.R    /* DSPI PUSH FIFO Register In Slave Mode */
#define DSPI_2_POPR          DSPI_2.POPR.R                 /* DSPI POP FIFO Register */
#define DSPI_2_TXFR0         DSPI_2.TXFR[0].R              /* DSPI Transmit FIFO Registers */
#define DSPI_2_TXFR1         DSPI_2.TXFR[1].R              /* DSPI Transmit FIFO Registers */
#define DSPI_2_TXFR2         DSPI_2.TXFR[2].R              /* DSPI Transmit FIFO Registers */
#define DSPI_2_TXFR3         DSPI_2.TXFR[3].R              /* DSPI Transmit FIFO Registers */
#define DSPI_2_RXFR0         DSPI_2.RXFR[0].R              /* DSPI Receive FIFO Registers */
#define DSPI_2_RXFR1         DSPI_2.RXFR[1].R              /* DSPI Receive FIFO Registers */
#define DSPI_2_RXFR2         DSPI_2.RXFR[2].R              /* DSPI Receive FIFO Registers */
#define DSPI_2_RXFR3         DSPI_2.RXFR[3].R              /* DSPI Receive FIFO Registers */
#define DSPI_2_DSICR0        DSPI_2.DSICR0.R               /* DSPI DSI Configuration Register 0 */
#define DSPI_2_SDR0          DSPI_2.SDR0.R                 /* DSPI DSI Serialization Data Register 0 */
#define DSPI_2_ASDR0         DSPI_2.ASDR0.R                /* DSPI DSI Alternate Serialization Data Register 0 */
#define DSPI_2_COMPR0        DSPI_2.COMPR0.R               /* DSPI DSI Transmit Comparison Register 0 */
#define DSPI_2_DDR0          DSPI_2.DDR0.R                 /* DSPI DSI Deserialization Data Register 0 */
#define DSPI_2_DSICR1        DSPI_2.DSICR1.R               /* DSPI DSI Configuration Register 1 */
#define DSPI_2_SSR0          DSPI_2.SSR0.R                 /* DSPI DSI Serialization Source Select Register 0 */
#define DSPI_2_DIMR0         DSPI_2.DIMR0.R                /* DSPI DSI Deserialized Data Interrupt Mask Register 0 */
#define DSPI_2_DPIR0         DSPI_2.DPIR0.R                /* DSPI DSI Deserialized Data Polarity Interrupt Register 0 */
#define DSPI_2_CTARE0        DSPI_2.CTARE[0].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_2_CTARE1        DSPI_2.CTARE[1].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_2_CTARE2        DSPI_2.CTARE[2].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_2_CTARE3        DSPI_2.CTARE[3].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_2_CTARE4        DSPI_2.CTARE[4].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_2_CTARE5        DSPI_2.CTARE[5].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_2_CTARE6        DSPI_2.CTARE[6].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_2_CTARE7        DSPI_2.CTARE[7].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_2_SREX          DSPI_2.SREX.R                 /* DSPI Status Register Extended */

#define DSPI_3_MCR           DSPI_3.MCR.R                  /* DSPI Module Configuration Register */
#define DSPI_3_TCR           DSPI_3.TCR.R                  /* DSPI Transfer Count Register */
#define DSPI_3_CTAR0         DSPI_3.MODE.CTAR[0].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_CTAR1         DSPI_3.MODE.CTAR[1].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_CTAR2         DSPI_3.MODE.CTAR[2].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_CTAR3         DSPI_3.MODE.CTAR[3].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_CTAR4         DSPI_3.MODE.CTAR[4].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_CTAR5         DSPI_3.MODE.CTAR[5].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_CTAR6         DSPI_3.MODE.CTAR[6].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_CTAR7         DSPI_3.MODE.CTAR[7].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_CTAR_SLAVE0   DSPI_3.MODE.CTAR_SLAVE[0].R   /* DSPI Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_3_CTAR_SLAVE1   DSPI_3.MODE.CTAR_SLAVE[1].R   /* DSPI Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_3_SR            DSPI_3.SR.R                   /* DSPI Status Register */
#define DSPI_3_RSER          DSPI_3.RSER.R                 /* DSPI DMA/Interrupt Request Select and Enable Register */
#define DSPI_3_PUSHR         DSPI_3.PUSHR.PUSHR.R          /* DSPI PUSH FIFO Register In Master Mode */
#define DSPI_3_PUSHR_SLAVE   DSPI_3.PUSHR.PUSHR_SLAVE.R    /* DSPI PUSH FIFO Register In Slave Mode */
#define DSPI_3_POPR          DSPI_3.POPR.R                 /* DSPI POP FIFO Register */
#define DSPI_3_TXFR0         DSPI_3.TXFR[0].R              /* DSPI Transmit FIFO Registers */
#define DSPI_3_TXFR1         DSPI_3.TXFR[1].R              /* DSPI Transmit FIFO Registers */
#define DSPI_3_TXFR2         DSPI_3.TXFR[2].R              /* DSPI Transmit FIFO Registers */
#define DSPI_3_TXFR3         DSPI_3.TXFR[3].R              /* DSPI Transmit FIFO Registers */
#define DSPI_3_RXFR0         DSPI_3.RXFR[0].R              /* DSPI Receive FIFO Registers */
#define DSPI_3_RXFR1         DSPI_3.RXFR[1].R              /* DSPI Receive FIFO Registers */
#define DSPI_3_RXFR2         DSPI_3.RXFR[2].R              /* DSPI Receive FIFO Registers */
#define DSPI_3_RXFR3         DSPI_3.RXFR[3].R              /* DSPI Receive FIFO Registers */
#define DSPI_3_DSICR0        DSPI_3.DSICR0.R               /* DSPI DSI Configuration Register 0 */
#define DSPI_3_SDR0          DSPI_3.SDR0.R                 /* DSPI DSI Serialization Data Register 0 */
#define DSPI_3_ASDR0         DSPI_3.ASDR0.R                /* DSPI DSI Alternate Serialization Data Register 0 */
#define DSPI_3_COMPR0        DSPI_3.COMPR0.R               /* DSPI DSI Transmit Comparison Register 0 */
#define DSPI_3_DDR0          DSPI_3.DDR0.R                 /* DSPI DSI Deserialization Data Register 0 */
#define DSPI_3_DSICR1        DSPI_3.DSICR1.R               /* DSPI DSI Configuration Register 1 */
#define DSPI_3_SSR0          DSPI_3.SSR0.R                 /* DSPI DSI Serialization Source Select Register 0 */
#define DSPI_3_DIMR0         DSPI_3.DIMR0.R                /* DSPI DSI Deserialized Data Interrupt Mask Register 0 */
#define DSPI_3_DPIR0         DSPI_3.DPIR0.R                /* DSPI DSI Deserialized Data Polarity Interrupt Register 0 */
#define DSPI_3_CTARE0        DSPI_3.CTARE[0].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_3_CTARE1        DSPI_3.CTARE[1].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_3_CTARE2        DSPI_3.CTARE[2].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_3_CTARE3        DSPI_3.CTARE[3].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_3_CTARE4        DSPI_3.CTARE[4].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_3_CTARE5        DSPI_3.CTARE[5].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_3_CTARE6        DSPI_3.CTARE[6].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_3_CTARE7        DSPI_3.CTARE[7].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_3_SREX          DSPI_3.SREX.R                 /* DSPI Status Register Extended */

#define DSPI_4_MCR           DSPI_4.MCR.R                  /* DSPI Module Configuration Register */
#define DSPI_4_TCR           DSPI_4.TCR.R                  /* DSPI Transfer Count Register */
#define DSPI_4_CTAR0         DSPI_4.MODE.CTAR[0].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_4_CTAR1         DSPI_4.MODE.CTAR[1].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_4_CTAR2         DSPI_4.MODE.CTAR[2].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_4_CTAR3         DSPI_4.MODE.CTAR[3].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_4_CTAR4         DSPI_4.MODE.CTAR[4].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_4_CTAR5         DSPI_4.MODE.CTAR[5].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_4_CTAR6         DSPI_4.MODE.CTAR[6].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_4_CTAR7         DSPI_4.MODE.CTAR[7].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_4_CTAR_SLAVE0   DSPI_4.MODE.CTAR_SLAVE[0].R   /* DSPI Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_4_CTAR_SLAVE1   DSPI_4.MODE.CTAR_SLAVE[1].R   /* DSPI Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_4_SR            DSPI_4.SR.R                   /* DSPI Status Register */
#define DSPI_4_RSER          DSPI_4.RSER.R                 /* DSPI DMA/Interrupt Request Select and Enable Register */
#define DSPI_4_PUSHR         DSPI_4.PUSHR.PUSHR.R          /* DSPI PUSH FIFO Register In Master Mode */
#define DSPI_4_PUSHR_SLAVE   DSPI_4.PUSHR.PUSHR_SLAVE.R    /* DSPI PUSH FIFO Register In Slave Mode */
#define DSPI_4_POPR          DSPI_4.POPR.R                 /* DSPI POP FIFO Register */
#define DSPI_4_TXFR0         DSPI_4.TXFR[0].R              /* DSPI Transmit FIFO Registers */
#define DSPI_4_TXFR1         DSPI_4.TXFR[1].R              /* DSPI Transmit FIFO Registers */
#define DSPI_4_TXFR2         DSPI_4.TXFR[2].R              /* DSPI Transmit FIFO Registers */
#define DSPI_4_TXFR3         DSPI_4.TXFR[3].R              /* DSPI Transmit FIFO Registers */
#define DSPI_4_RXFR0         DSPI_4.RXFR[0].R              /* DSPI Receive FIFO Registers */
#define DSPI_4_RXFR1         DSPI_4.RXFR[1].R              /* DSPI Receive FIFO Registers */
#define DSPI_4_RXFR2         DSPI_4.RXFR[2].R              /* DSPI Receive FIFO Registers */
#define DSPI_4_RXFR3         DSPI_4.RXFR[3].R              /* DSPI Receive FIFO Registers */
#define DSPI_4_DSICR0        DSPI_4.DSICR0.R               /* DSPI DSI Configuration Register 0 */
#define DSPI_4_SDR0          DSPI_4.SDR0.R                 /* DSPI DSI Serialization Data Register 0 */
#define DSPI_4_ASDR0         DSPI_4.ASDR0.R                /* DSPI DSI Alternate Serialization Data Register 0 */
#define DSPI_4_COMPR0        DSPI_4.COMPR0.R               /* DSPI DSI Transmit Comparison Register 0 */
#define DSPI_4_DDR0          DSPI_4.DDR0.R                 /* DSPI DSI Deserialization Data Register 0 */
#define DSPI_4_DSICR1        DSPI_4.DSICR1.R               /* DSPI DSI Configuration Register 1 */
#define DSPI_4_SSR0          DSPI_4.SSR0.R                 /* DSPI DSI Serialization Source Select Register 0 */
#define DSPI_4_DIMR0         DSPI_4.DIMR0.R                /* DSPI DSI Deserialized Data Interrupt Mask Register 0 */
#define DSPI_4_DPIR0         DSPI_4.DPIR0.R                /* DSPI DSI Deserialized Data Polarity Interrupt Register 0 */
#define DSPI_4_CTARE0        DSPI_4.CTARE[0].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_4_CTARE1        DSPI_4.CTARE[1].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_4_CTARE2        DSPI_4.CTARE[2].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_4_CTARE3        DSPI_4.CTARE[3].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_4_CTARE4        DSPI_4.CTARE[4].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_4_CTARE5        DSPI_4.CTARE[5].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_4_CTARE6        DSPI_4.CTARE[6].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_4_CTARE7        DSPI_4.CTARE[7].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_4_SREX          DSPI_4.SREX.R                 /* DSPI Status Register Extended */

#define DSPI_5_MCR           DSPI_5.MCR.R                  /* DSPI Module Configuration Register */
#define DSPI_5_TCR           DSPI_5.TCR.R                  /* DSPI Transfer Count Register */
#define DSPI_5_CTAR0         DSPI_5.MODE.CTAR[0].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_5_CTAR1         DSPI_5.MODE.CTAR[1].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_5_CTAR2         DSPI_5.MODE.CTAR[2].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_5_CTAR3         DSPI_5.MODE.CTAR[3].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_5_CTAR4         DSPI_5.MODE.CTAR[4].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_5_CTAR5         DSPI_5.MODE.CTAR[5].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_5_CTAR6         DSPI_5.MODE.CTAR[6].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_5_CTAR7         DSPI_5.MODE.CTAR[7].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_5_CTAR_SLAVE0   DSPI_5.MODE.CTAR_SLAVE[0].R   /* DSPI Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_5_CTAR_SLAVE1   DSPI_5.MODE.CTAR_SLAVE[1].R   /* DSPI Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_5_SR            DSPI_5.SR.R                   /* DSPI Status Register */
#define DSPI_5_RSER          DSPI_5.RSER.R                 /* DSPI DMA/Interrupt Request Select and Enable Register */
#define DSPI_5_PUSHR         DSPI_5.PUSHR.PUSHR.R          /* DSPI PUSH FIFO Register In Master Mode */
#define DSPI_5_PUSHR_SLAVE   DSPI_5.PUSHR.PUSHR_SLAVE.R    /* DSPI PUSH FIFO Register In Slave Mode */
#define DSPI_5_POPR          DSPI_5.POPR.R                 /* DSPI POP FIFO Register */
#define DSPI_5_TXFR0         DSPI_5.TXFR[0].R              /* DSPI Transmit FIFO Registers */
#define DSPI_5_TXFR1         DSPI_5.TXFR[1].R              /* DSPI Transmit FIFO Registers */
#define DSPI_5_TXFR2         DSPI_5.TXFR[2].R              /* DSPI Transmit FIFO Registers */
#define DSPI_5_TXFR3         DSPI_5.TXFR[3].R              /* DSPI Transmit FIFO Registers */
#define DSPI_5_RXFR0         DSPI_5.RXFR[0].R              /* DSPI Receive FIFO Registers */
#define DSPI_5_RXFR1         DSPI_5.RXFR[1].R              /* DSPI Receive FIFO Registers */
#define DSPI_5_RXFR2         DSPI_5.RXFR[2].R              /* DSPI Receive FIFO Registers */
#define DSPI_5_RXFR3         DSPI_5.RXFR[3].R              /* DSPI Receive FIFO Registers */
#define DSPI_5_DSICR0        DSPI_5.DSICR0.R               /* DSPI DSI Configuration Register 0 */
#define DSPI_5_SDR0          DSPI_5.SDR0.R                 /* DSPI DSI Serialization Data Register 0 */
#define DSPI_5_ASDR0         DSPI_5.ASDR0.R                /* DSPI DSI Alternate Serialization Data Register 0 */
#define DSPI_5_COMPR0        DSPI_5.COMPR0.R               /* DSPI DSI Transmit Comparison Register 0 */
#define DSPI_5_DDR0          DSPI_5.DDR0.R                 /* DSPI DSI Deserialization Data Register 0 */
#define DSPI_5_DSICR1        DSPI_5.DSICR1.R               /* DSPI DSI Configuration Register 1 */
#define DSPI_5_SSR0          DSPI_5.SSR0.R                 /* DSPI DSI Serialization Source Select Register 0 */
#define DSPI_5_DIMR0         DSPI_5.DIMR0.R                /* DSPI DSI Deserialized Data Interrupt Mask Register 0 */
#define DSPI_5_DPIR0         DSPI_5.DPIR0.R                /* DSPI DSI Deserialized Data Polarity Interrupt Register 0 */
#define DSPI_5_CTARE0        DSPI_5.CTARE[0].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_5_CTARE1        DSPI_5.CTARE[1].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_5_CTARE2        DSPI_5.CTARE[2].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_5_CTARE3        DSPI_5.CTARE[3].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_5_CTARE4        DSPI_5.CTARE[4].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_5_CTARE5        DSPI_5.CTARE[5].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_5_CTARE6        DSPI_5.CTARE[6].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_5_CTARE7        DSPI_5.CTARE[7].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_5_SREX          DSPI_5.SREX.R                 /* DSPI Status Register Extended */

#define DSPI_6_MCR           DSPI_6.MCR.R                  /* DSPI Module Configuration Register */
#define DSPI_6_TCR           DSPI_6.TCR.R                  /* DSPI Transfer Count Register */
#define DSPI_6_CTAR0         DSPI_6.MODE.CTAR[0].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_6_CTAR1         DSPI_6.MODE.CTAR[1].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_6_CTAR2         DSPI_6.MODE.CTAR[2].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_6_CTAR3         DSPI_6.MODE.CTAR[3].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_6_CTAR4         DSPI_6.MODE.CTAR[4].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_6_CTAR5         DSPI_6.MODE.CTAR[5].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_6_CTAR6         DSPI_6.MODE.CTAR[6].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_6_CTAR7         DSPI_6.MODE.CTAR[7].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_6_CTAR_SLAVE0   DSPI_6.MODE.CTAR_SLAVE[0].R   /* DSPI Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_6_CTAR_SLAVE1   DSPI_6.MODE.CTAR_SLAVE[1].R   /* DSPI Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_6_SR            DSPI_6.SR.R                   /* DSPI Status Register */
#define DSPI_6_RSER          DSPI_6.RSER.R                 /* DSPI DMA/Interrupt Request Select and Enable Register */
#define DSPI_6_PUSHR         DSPI_6.PUSHR.PUSHR.R          /* DSPI PUSH FIFO Register In Master Mode */
#define DSPI_6_PUSHR_SLAVE   DSPI_6.PUSHR.PUSHR_SLAVE.R    /* DSPI PUSH FIFO Register In Slave Mode */
#define DSPI_6_POPR          DSPI_6.POPR.R                 /* DSPI POP FIFO Register */
#define DSPI_6_TXFR0         DSPI_6.TXFR[0].R              /* DSPI Transmit FIFO Registers */
#define DSPI_6_TXFR1         DSPI_6.TXFR[1].R              /* DSPI Transmit FIFO Registers */
#define DSPI_6_TXFR2         DSPI_6.TXFR[2].R              /* DSPI Transmit FIFO Registers */
#define DSPI_6_TXFR3         DSPI_6.TXFR[3].R              /* DSPI Transmit FIFO Registers */
#define DSPI_6_RXFR0         DSPI_6.RXFR[0].R              /* DSPI Receive FIFO Registers */
#define DSPI_6_RXFR1         DSPI_6.RXFR[1].R              /* DSPI Receive FIFO Registers */
#define DSPI_6_RXFR2         DSPI_6.RXFR[2].R              /* DSPI Receive FIFO Registers */
#define DSPI_6_RXFR3         DSPI_6.RXFR[3].R              /* DSPI Receive FIFO Registers */
#define DSPI_6_DSICR0        DSPI_6.DSICR0.R               /* DSPI DSI Configuration Register 0 */
#define DSPI_6_SDR0          DSPI_6.SDR0.R                 /* DSPI DSI Serialization Data Register 0 */
#define DSPI_6_ASDR0         DSPI_6.ASDR0.R                /* DSPI DSI Alternate Serialization Data Register 0 */
#define DSPI_6_COMPR0        DSPI_6.COMPR0.R               /* DSPI DSI Transmit Comparison Register 0 */
#define DSPI_6_DDR0          DSPI_6.DDR0.R                 /* DSPI DSI Deserialization Data Register 0 */
#define DSPI_6_DSICR1        DSPI_6.DSICR1.R               /* DSPI DSI Configuration Register 1 */
#define DSPI_6_SSR0          DSPI_6.SSR0.R                 /* DSPI DSI Serialization Source Select Register 0 */
#define DSPI_6_DIMR0         DSPI_6.DIMR0.R                /* DSPI DSI Deserialized Data Interrupt Mask Register 0 */
#define DSPI_6_DPIR0         DSPI_6.DPIR0.R                /* DSPI DSI Deserialized Data Polarity Interrupt Register 0 */
#define DSPI_6_CTARE0        DSPI_6.CTARE[0].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_6_CTARE1        DSPI_6.CTARE[1].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_6_CTARE2        DSPI_6.CTARE[2].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_6_CTARE3        DSPI_6.CTARE[3].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_6_CTARE4        DSPI_6.CTARE[4].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_6_CTARE5        DSPI_6.CTARE[5].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_6_CTARE6        DSPI_6.CTARE[6].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_6_CTARE7        DSPI_6.CTARE[7].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_6_SREX          DSPI_6.SREX.R                 /* DSPI Status Register Extended */

/* DTS */
#define DTS_ENABLE           DTS.ENABLE.R                  /* Output Enable Register */
#define DTS_STARTUP          DTS.STARTUP.R                 /* Startup Register */
#define DTS_SEMAPHORE        DTS.SEMAPHORE.R               /* Semaphore Register */
#define DTS_SEMAPHORE_B      DTS.SEMAPHORE_B.R             /* Semaphore Extension */

/* EBI */
#define EBI_MCR              EBI.MCR.R                     /* Module Configuration Register */
#define EBI_BR0              EBI.BR0.R                     /* Base Register Bank */
#define EBI_OR0              EBI.OR0.R                     /* Option Register Bank */
#define EBI_BR1              EBI.BR1.R                     /* Base Register Bank */
#define EBI_OR1              EBI.OR1.R                     /* Option Register Bank */
#define EBI_BR2              EBI.BR2.R                     /* Base Register Bank */
#define EBI_OR2              EBI.OR2.R                     /* Option Register Bank */

/* FCCU */
#define FCCU_CTRL            FCCU.CTRL.R                   /* Control Register */
#define FCCU_CTRLK           FCCU.CTRLK.R                  /* CTRL Key Register */
#define FCCU_CFG             FCCU.CFG.R                    /* Configuration Register */
#define FCCU_RF_CFG0         FCCU.RF_CFG[0].R              /* RF Configuration Register */
#define FCCU_RF_CFG1         FCCU.RF_CFG[1].R              /* RF Configuration Register */
#define FCCU_RF_CFG2         FCCU.RF_CFG[2].R              /* RF Configuration Register */
#define FCCU_RF_CFG3         FCCU.RF_CFG[3].R              /* RF Configuration Register */
#define FCCU_RFS_CFG0        FCCU.RFS_CFG[0].R             /* RFS Configuration Register */
#define FCCU_RFS_CFG1        FCCU.RFS_CFG[1].R             /* RFS Configuration Register */
#define FCCU_RFS_CFG2        FCCU.RFS_CFG[2].R             /* RFS Configuration Register */
#define FCCU_RFS_CFG3        FCCU.RFS_CFG[3].R             /* RFS Configuration Register */
#define FCCU_RFS_CFG4        FCCU.RFS_CFG[4].R             /* RFS Configuration Register */
#define FCCU_RFS_CFG5        FCCU.RFS_CFG[5].R             /* RFS Configuration Register */
#define FCCU_RFS_CFG6        FCCU.RFS_CFG[6].R             /* RFS Configuration Register */
#define FCCU_RFS_CFG7        FCCU.RFS_CFG[7].R             /* RFS Configuration Register */
#define FCCU_RF_S0           FCCU.RF_S[0].R                /* UF Status Register */
#define FCCU_RF_S1           FCCU.RF_S[1].R                /* UF Status Register */
#define FCCU_RF_S2           FCCU.RF_S[2].R                /* UF Status Register */
#define FCCU_RF_S3           FCCU.RF_S[3].R                /* UF Status Register */
#define FCCU_RFK             FCCU.RFK.R                    /* RF Key Register */
#define FCCU_RF_E0           FCCU.RF_E[0].R                /* RF Enable Register */
#define FCCU_RF_E1           FCCU.RF_E[1].R                /* RF Enable Register */
#define FCCU_RF_E2           FCCU.RF_E[2].R                /* RF Enable Register */
#define FCCU_RF_E3           FCCU.RF_E[3].R                /* RF Enable Register */
#define FCCU_RF_TOE0         FCCU.RF_TOE[0].R              /* RF Time-out Enable Register */
#define FCCU_RF_TOE1         FCCU.RF_TOE[1].R              /* RF Time-out Enable Register */
#define FCCU_RF_TOE2         FCCU.RF_TOE[2].R              /* RF Time-out Enable Register */
#define FCCU_RF_TOE3         FCCU.RF_TOE[3].R              /* RF Time-out Enable Register */
#define FCCU_RF_TO           FCCU.RF_TO.R                  /* RF Time-out Register */
#define FCCU_CFG_TO          FCCU.CFG_TO.R                 /* CFG Timeout Register */
#define FCCU_EINOUT          FCCU.EINOUT.R                 /* IO Control Register */
#define FCCU_STAT            FCCU.STAT.R                   /* Status Register */
#define FCCU_N2AF_STATUS     FCCU.N2AF_STATUS.R            /* NA Freeze Status Register */
#define FCCU_A2FF_STATUS     FCCU.A2FF_STATUS.R            /* AF Freeze Status Register */
#define FCCU_N2FF_STATUS     FCCU.N2FF_STATUS.R            /* NF Freeze Status Register */
#define FCCU_F2A_STATUS      FCCU.F2A_STATUS.R             /* FA Freeze Status Register */
#define FCCU_RFF             FCCU.RFF.R                    /* RF Fake Register */
#define FCCU_IRQ_STAT        FCCU.IRQ_STAT.R               /* IRQ Status Register */
#define FCCU_IRQ_EN          FCCU.IRQ_EN.R                 /* IRQ Enable Register */
#define FCCU_XTMR            FCCU.XTMR.R                   /* XTMR Register */
#define FCCU_MCS             FCCU.MCS.R                    /* MCS Register */
#define FCCU_TRANS_LOCK      FCCU.TRANS_LOCK.R             /* Transient Lock Register */
#define FCCU_PERMNT_LOCK     FCCU.PERMNT_LOCK.R            /* Permanent Lock Register */
#define FCCU_DELTA_T         FCCU.DELTA_T.R                /* Delta T Register */
#define FCCU_IRQ_ALARM_EN0   FCCU.IRQ_ALARM_EN[0].R        /* IRQ Alarm Enable Register */
#define FCCU_IRQ_ALARM_EN1   FCCU.IRQ_ALARM_EN[1].R        /* IRQ Alarm Enable Register */
#define FCCU_IRQ_ALARM_EN2   FCCU.IRQ_ALARM_EN[2].R        /* IRQ Alarm Enable Register */
#define FCCU_IRQ_ALARM_EN3   FCCU.IRQ_ALARM_EN[3].R        /* IRQ Alarm Enable Register */
#define FCCU_NMI_EN0         FCCU.NMI_EN[0].R              /* NMI Enable Register */
#define FCCU_NMI_EN1         FCCU.NMI_EN[1].R              /* NMI Enable Register */
#define FCCU_NMI_EN2         FCCU.NMI_EN[2].R              /* NMI Enable Register */
#define FCCU_NMI_EN3         FCCU.NMI_EN[3].R              /* NMI Enable Register */
#define FCCU_EOUT_SIG_EN0    FCCU.EOUT_SIG_EN[0].R         /* EOUT Signaling Enable Register */
#define FCCU_EOUT_SIG_EN1    FCCU.EOUT_SIG_EN[1].R         /* EOUT Signaling Enable Register */
#define FCCU_EOUT_SIG_EN2    FCCU.EOUT_SIG_EN[2].R         /* EOUT Signaling Enable Register */
#define FCCU_EOUT_SIG_EN3    FCCU.EOUT_SIG_EN[3].R         /* EOUT Signaling Enable Register */

/* FEC */
#define FEC_EIR              FEC.EIR.R                     /* Interrupt Event Register */
#define FEC_EIMR             FEC.EIMR.R                    /* Interrupt Mask Register */
#define FEC_RDAR             FEC.RDAR.R                    /* Receive Descriptor Active Register */
#define FEC_TDAR             FEC.TDAR.R                    /* Transmit Descriptor Active Register */
#define FEC_ECR              FEC.ECR.R                     /* Ethernet Control Register */
#define FEC_MMFR             FEC.MMFR.R                    /* MII Management Frame Register */
#define FEC_MSCR             FEC.MSCR.R                    /* MII Speed Control Register */
#define FEC_MIBC             FEC.MIBC.R                    /* MIB Control Register */
#define FEC_RCR              FEC.RCR.R                     /* Receive Control Register */
#define FEC_TCR              FEC.TCR.R                     /* Transmit Control Register */
#define FEC_PALR             FEC.PALR.R                    /* Physical Address Low Register */
#define FEC_PAUR             FEC.PAUR.R                    /* Physical Address High Register and Type Field */
#define FEC_OPD              FEC.OPD.R                     /* Opcode/Pause Duration */
#define FEC_IAUR             FEC.IAUR.R                    /* Descriptor Individual Upper Address Register */
#define FEC_IALR             FEC.IALR.R                    /* Descriptor Individual Lower Address Register */
#define FEC_GAUR             FEC.GAUR.R                    /* Descriptor Group Upper Address Register */
#define FEC_GALR             FEC.GALR.R                    /* Descriptor Group Lower Address Register */
#define FEC_TFWR             FEC.TFWR.R                    /* Transmit FIFO Watermark */
#define FEC_FRBR             FEC.FRBR.R                    /* FIFO Receive Bound Register */
#define FEC_FRSR             FEC.FRSR.R                    /* FIFO Receive Start Register */
#define FEC_ERDSR            FEC.ERDSR.R                   /* Receive Descriptor Ring Start Register */
#define FEC_ETDSR            FEC.ETDSR.R                   /* Transmit Buffer Descriptor Ring Start Register */
#define FEC_EMRBR            FEC.EMRBR.R                   /* Receive Buffer Size Register */
#define FEC_RMON_T_DROP      FEC.RMON_T_DROP.R             /* Count of frames not counted correctly */
#define FEC_RMON_T_PACKETS   FEC.RMON_T_PACKETS.R          /* RMON Tx packet count */
#define FEC_RMON_T_BC_PKT    FEC.RMON_T_BC_PKT.R           /* RMON Tx broadcast packets */
#define FEC_RMON_T_MC_PKT    FEC.RMON_T_MC_PKT.R           /* RMON Tx multicast packets */
#define FEC_RMON_T_CRC_ALIGN FEC.RMON_T_CRC_ALIGN.R        /* RMON Tx packets with CRC/align error */
#define FEC_RMON_T_UNDERSIZE FEC.RMON_T_UNDERSIZE.R        /* RMON Tx packets < 64 bytes, good CRC */
#define FEC_RMON_T_OVERSIZE  FEC.RMON_T_OVERSIZE.R         /* RMON Tx packets > MAX_FL bytes, good CRC */
#define FEC_RMON_T_FRAG      FEC.RMON_T_FRAG.R             /* RMON Tx packets < 64 bytes, bad CRC */
#define FEC_RMON_T_JAB       FEC.RMON_T_JAB.R              /* RMON Tx packets > MAX_FL bytes, bad CRC */
#define FEC_RMON_T_COL       FEC.RMON_T_COL.R              /* RMON Tx collision count */
#define FEC_RMON_T_P64       FEC.RMON_T_P64.R              /* RMON Tx 64 byte packets */
#define FEC_RMON_T_P65TO127  FEC.RMON_T_P65TO127.R         /* RMON Tx 65 to 127 byte packets */
#define FEC_RMON_T_P128TO255 FEC.RMON_T_P128TO255.R        /* RMON Tx 128 to 255 byte packets */
#define FEC_RMON_T_P256TO511 FEC.RMON_T_P256TO511.R        /* RMON Tx 256 to 511 byte packets */
#define FEC_RMON_T_P512TO1023 FEC.RMON_T_P512TO1023.R      /* RMON Tx 512 to 1023 byte packets */
#define FEC_RMON_T_P1024TO2047 FEC.RMON_T_P1024TO2047.R    /* RMON Tx 1024 to 2047 byte packets */
#define FEC_RMON_T_P_GTE2048 FEC.RMON_T_P_GTE2048.R        /* RMON Tx packets with > 2048 bytes */
#define FEC_RMON_T_OCTETS    FEC.RMON_T_OCTETS.R           /* RMON Tx Octets */
#define FEC_IEEE_T_DROP      FEC.IEEE_T_DROP.R             /* Count of transmitted frames not counted correctly */
#define FEC_IEEE_T_FRAME_OK  FEC.IEEE_T_FRAME_OK.R         /* Frames transmitted OK */
#define FEC_IEEE_T_1COL      FEC.IEEE_T_1COL.R             /* Frames transmitted with single collision */
#define FEC_IEEE_T_MCOL      FEC.IEEE_T_MCOL.R             /* Frames transmitted with multiple collisions */
#define FEC_IEEE_T_DEF       FEC.IEEE_T_DEF.R              /* Frames transmitted after deferral delay */
#define FEC_IEEE_T_LCOL      FEC.IEEE_T_LCOL.R             /* Frames transmitted with late collision */
#define FEC_IEEE_T_EXCOL     FEC.IEEE_T_EXCOL.R            /* Frames transmitted with excessive collisions */
#define FEC_IEEE_T_MACERR    FEC.IEEE_T_MACERR.R           /* Frames transmitted with Tx FIFO underrun */
#define FEC_IEEE_T_CSERR     FEC.IEEE_T_CSERR.R            /* Frames transmitted with carrier sense error */
#define FEC_IEEE_T_SQE       FEC.IEEE_T_SQE.R              /* Frames transmitted with SQE error */
#define FEC_IEEE_T_FDXFC     FEC.IEEE_T_FDXFC.R            /* Flow control pause frames transmitted */
#define FEC_IEEE_T_OCTETS_OK FEC.IEEE_T_OCTETS_OK.R        /* Octet count for frames transmitted without error */
#define FEC_RMON_R_DROP      FEC.RMON_R_DROP.R             /* Count of received frames not counted correctly */
#define FEC_RMON_R_PACKETS   FEC.RMON_R_PACKETS.R          /* RMON Rx packet count */
#define FEC_RMON_R_BC_PKT    FEC.RMON_R_BC_PKT.R           /* RMON Rx broadcast packets */
#define FEC_RMON_R_MC_PKT    FEC.RMON_R_MC_PKT.R           /* RMON Rx multicast packets */
#define FEC_RMON_R_CRC_ALIGN FEC.RMON_R_CRC_ALIGN.R        /* RMON Rx packets with CRC/Align error */
#define FEC_RMON_R_UNDERSIZE FEC.RMON_R_UNDERSIZE.R        /* RMON Rx packets < 64 bytes, good CRC */
#define FEC_RMON_R_OVERSIZE  FEC.RMON_R_OVERSIZE.R         /* RMON Rx packets > MAX_FL bytes, good CRC */
#define FEC_RMON_R_FRAG      FEC.RMON_R_FRAG.R             /* RMON Rx packets < 64 bytes, bad CRC */
#define FEC_RMON_R_JAB       FEC.RMON_R_JAB.R              /* RMON Rx packets > MAX_FL bytes, bad CRC */
#define FEC_RMON_R_RESVD_0   FEC.RMON_R_RESVD_0.R          /* Reserved */
#define FEC_RMON_R_P64       FEC.RMON_R_P64.R              /* RMON Rx 64 byte packets */
#define FEC_RMON_R_P65TO127  FEC.RMON_R_P65TO127.R         /* RMON Rx 65 to 127 byte packets */
#define FEC_RMON_R_P128TO255 FEC.RMON_R_P128TO255.R        /* RMON Rx 128 to 255 byte packets */
#define FEC_RMON_R_P256TO511 FEC.RMON_R_P256TO511.R        /* RMON Rx 256 to 511 byte packets */
#define FEC_RMON_R_P512TO1023 FEC.RMON_R_P512TO1023.R      /* RMON Rx 512 to 1023 byte packets */
#define FEC_RMON_R_P1024TO2047 FEC.RMON_R_P1024TO2047.R    /* RMON Rx 1024 to 2047 byte packets */
#define FEC_RMON_R_P_GTE2048 FEC.RMON_R_P_GTE2048.R        /* RMON Rx packets with > 2048 bytes */
#define FEC_RMON_R_OCTETS    FEC.RMON_R_OCTETS.R           /* RMON Rx octets */
#define FEC_IEEE_R_DROP      FEC.IEEE_R_DROP.R             /* Count of received frames not counted correctly */
#define FEC_IEEE_R_FRAME_OK  FEC.IEEE_R_FRAME_OK.R         /* Frames received OK */
#define FEC_IEEE_R_CRC       FEC.IEEE_R_CRC.R              /* Frames received with CRC error */
#define FEC_IEEE_R_ALIGN     FEC.IEEE_R_ALIGN.R            /* Frames received with alignment error */
#define FEC_IEEE_R_MACERR    FEC.IEEE_R_MACERR.R           /* Receive FIFO overflow count */
#define FEC_IEEE_R_FDXFC     FEC.IEEE_R_FDXFC.R            /* Flow control pause frames received */
#define FEC_IEEE_R_OCTETS_OK FEC.IEEE_R_OCTETS_OK.R        /* Octet count for frames received without error */

/* FR */
#define FR_0_MVR             FR_0.MVR.R                    /* Module Version Register */
#define FR_0_MCR             FR_0.MCR.R                    /* Module Configuration Register */
#define FR_0_SYMBADHR        FR_0.SYMBADHR.R               /* System Memory Base Address High Register */
#define FR_0_SYMBADLR        FR_0.SYMBADLR.R               /* System Memory Base Address Low Register */
#define FR_0_STBSCR          FR_0.STBSCR.R                 /* Strobe Signal Control Register */
#define FR_0_MBDSR           FR_0.MBDSR.R                  /* Message Buffer Data Size Register */
#define FR_0_MBSSUTR         FR_0.MBSSUTR.R                /* Message Buffer Segment Size and Utilization Register */
#define FR_0_PEDRAR          FR_0.PEDRAR.R                 /* PE DRAM Access Register */
#define FR_0_PEDRDR          FR_0.PEDRDR.R                 /* PE DRAM Data Register */
#define FR_0_POCR            FR_0.POCR.R                   /* Protocol Operation Control Register */
#define FR_0_GIFER           FR_0.GIFER.R                  /* Global Interrupt Flag and Enable Register */
#define FR_0_PIFR0           FR_0.PIFR0.R                  /* Protocol Interrupt Flag Register 0 */
#define FR_0_PIFR1           FR_0.PIFR1.R                  /* Protocol Interrupt Flag Register 1 */
#define FR_0_PIER0           FR_0.PIER0.R                  /* Protocol Interrupt Enable Register 0 */
#define FR_0_PIER1           FR_0.PIER1.R                  /* Protocol Interrupt Enable Register 1 */
#define FR_0_CHIERFR         FR_0.CHIERFR.R                /* CHI Error Flag Register */
#define FR_0_MBIVEC          FR_0.MBIVEC.R                 /* Message Buffer Interrupt Vector Register */
#define FR_0_CASERCR         FR_0.CASERCR.R                /* Channel A Status Error Counter Register */
#define FR_0_CBSERCR         FR_0.CBSERCR.R                /* Channel B Status Error Counter Register */
#define FR_0_PSR0            FR_0.PSR0.R                   /* Protocol Status Register 0 */
#define FR_0_PSR1            FR_0.PSR1.R                   /* Protocol Status Register 1 */
#define FR_0_PSR2            FR_0.PSR2.R                   /* Protocol Status Register 2 */
#define FR_0_PSR3            FR_0.PSR3.R                   /* Protocol Status Register 3 */
#define FR_0_MTCTR           FR_0.MTCTR.R                  /* Macrotick Counter Register */
#define FR_0_CYCTR           FR_0.CYCTR.R                  /* Cycle Counter Register */
#define FR_0_SLTCTAR         FR_0.SLTCTAR.R                /* Slot Counter Channel A Register */
#define FR_0_SLTCTBR         FR_0.SLTCTBR.R                /* Slot Counter Channel B Register */
#define FR_0_RTCORVR         FR_0.RTCORVR.R                /* Rate Correction Value Register */
#define FR_0_OFCORVR         FR_0.OFCORVR.R                /* Offset Correction Value Register */
#define FR_0_CIFR            FR_0.CIFR.R                   /* Combined Interrupt Flag Register */
#define FR_0_SYMATOR         FR_0.SYMATOR.R                /* System Memory Access Time-Out Register */
#define FR_0_SFCNTR          FR_0.SFCNTR.R                 /* Sync Frame Counter Register */
#define FR_0_SFTOR           FR_0.SFTOR.R                  /* Sync Frame Table Offset Register */
#define FR_0_SFTCCSR         FR_0.SFTCCSR.R                /* Sync Frame Table Configuration, Control, Status Register */
#define FR_0_SFIDRFR         FR_0.SFIDRFR.R                /* Sync Frame ID Rejection Filter Register */
#define FR_0_SFIDAFVR        FR_0.SFIDAFVR.R               /* Sync Frame ID Acceptance Filter Value Register */
#define FR_0_SFIDAFMR        FR_0.SFIDAFMR.R               /* Sync Frame ID Acceptance Filter Mask Register */
#define FR_0_NMVR0           FR_0.NMVR[0].R                /* Network Management Vector Register */
#define FR_0_NMVR1           FR_0.NMVR[1].R                /* Network Management Vector Register */
#define FR_0_NMVR2           FR_0.NMVR[2].R                /* Network Management Vector Register */
#define FR_0_NMVR3           FR_0.NMVR[3].R                /* Network Management Vector Register */
#define FR_0_NMVR4           FR_0.NMVR[4].R                /* Network Management Vector Register */
#define FR_0_NMVR5           FR_0.NMVR[5].R                /* Network Management Vector Register */
#define FR_0_NMVLR           FR_0.NMVLR.R                  /* Network Management Vector Length Register */
#define FR_0_TICCR           FR_0.TICCR.R                  /* Timer Configuration and Control Register */
#define FR_0_TI1CYSR         FR_0.TI1CYSR.R                /* Timer 1 Cycle Set Register */
#define FR_0_TI1MTOR         FR_0.TI1MTOR.R                /* Timer 1 Macrotick Offset Register */
#define FR_0_TI2CR0_ABS      FR_0.TI2CR0.ABS.R             /* Timer 2 Configuration Register 0 (Absolute Timer Configuration) */
#define FR_0_TI2CR0_REL      FR_0.TI2CR0.REL.R             /* Timer 2 Configuration Register 0 (Relative Timer Configuration) */
#define FR_0_TI2CR1_ABS      FR_0.TI2CR1.ABS.R             /* Timer 2 Configuration Register 1 (Absolute Timer Configuration) */
#define FR_0_TI2CR1_REL      FR_0.TI2CR1.REL.R             /* Timer 2 Configuration Register 1 (Relative Timer Configuration) */
#define FR_0_SSSR            FR_0.SSSR.R                   /* Slot Status Selection Register */
#define FR_0_SSCCR           FR_0.SSCCR.R                  /* Slot Status Counter Condition Register */
#define FR_0_SSR0            FR_0.SSR[0].R                 /* Slot Status Register */
#define FR_0_SSR1            FR_0.SSR[1].R                 /* Slot Status Register */
#define FR_0_SSR2            FR_0.SSR[2].R                 /* Slot Status Register */
#define FR_0_SSR3            FR_0.SSR[3].R                 /* Slot Status Register */
#define FR_0_SSR4            FR_0.SSR[4].R                 /* Slot Status Register */
#define FR_0_SSR5            FR_0.SSR[5].R                 /* Slot Status Register */
#define FR_0_SSR6            FR_0.SSR[6].R                 /* Slot Status Register */
#define FR_0_SSR7            FR_0.SSR[7].R                 /* Slot Status Register */
#define FR_0_SSCR0           FR_0.SSCR[0].R                /* Slot Status Counter Register */
#define FR_0_SSCR1           FR_0.SSCR[1].R                /* Slot Status Counter Register */
#define FR_0_SSCR2           FR_0.SSCR[2].R                /* Slot Status Counter Register */
#define FR_0_SSCR3           FR_0.SSCR[3].R                /* Slot Status Counter Register */
#define FR_0_MTSACFR         FR_0.MTSACFR.R                /* MTS A Configuration Register */
#define FR_0_MTSBCFR         FR_0.MTSBCFR.R                /* MTS B Configuration Register */
#define FR_0_RSBIR           FR_0.RSBIR.R                  /* Receive Shadow Buffer Index Register */
#define FR_0_RFWMSR          FR_0.RFWMSR.R                 /* Receive FIFO Watermark and Selection Register */
#define FR_0_RFSIR           FR_0.RFSIR.R                  /* Receive FIFO Start Index Register */
#define FR_0_RFDSR           FR_0.RFDSR.R                  /* Receive FIFO Depth and Size Register */
#define FR_0_RFARIR          FR_0.RFARIR.R                 /* Receive FIFO A Read Index Register */
#define FR_0_RFBRIR          FR_0.RFBRIR.R                 /* Receive FIFO B Read Index Register */
#define FR_0_RFMIDAFVR       FR_0.RFMIDAFVR.R              /* Receive FIFO Message ID Acceptance Filter Value Register */
#define FR_0_RFMIDAFMR       FR_0.RFMIDAFMR.R              /* Receive FIFO Message ID Acceptance Filter Mask Register */
#define FR_0_RFFIDRFVR       FR_0.RFFIDRFVR.R              /* Receive FIFO Frame ID Rejection Filter Value Register */
#define FR_0_RFFIDRFMR       FR_0.RFFIDRFMR.R              /* Receive FIFO Frame ID Rejection Filter Mask Register */
#define FR_0_RFRFCFR         FR_0.RFRFCFR.R                /* Receive FIFO Range Filter Configuration Register */
#define FR_0_RFRFCTR         FR_0.RFRFCTR.R                /* Receive FIFO Range Filter Control Register */
#define FR_0_LDTXSLAR        FR_0.LDTXSLAR.R               /* Last Dynamic Transmit Slot Channel A Register */
#define FR_0_LDTXSLBR        FR_0.LDTXSLBR.R               /* Last Dynamic Transmit Slot Channel B Register */
#define FR_0_PCR0            FR_0.PCR0.R                   /* Protocol Configuration Register 0 */
#define FR_0_PCR1            FR_0.PCR1.R                   /* Protocol Configuration Register 1 */
#define FR_0_PCR2            FR_0.PCR2.R                   /* Protocol Configuration Register 2 */
#define FR_0_PCR3            FR_0.PCR3.R                   /* Protocol Configuration Register 3 */
#define FR_0_PCR4            FR_0.PCR4.R                   /* Protocol Configuration Register 4 */
#define FR_0_PCR5            FR_0.PCR5.R                   /* Protocol Configuration Register 5 */
#define FR_0_PCR6            FR_0.PCR6.R                   /* Protocol Configuration Register 6 */
#define FR_0_PCR7            FR_0.PCR7.R                   /* Protocol Configuration Register 7 */
#define FR_0_PCR8            FR_0.PCR8.R                   /* Protocol Configuration Register 8 */
#define FR_0_PCR9            FR_0.PCR9.R                   /* Protocol Configuration Register 9 */
#define FR_0_PCR10           FR_0.PCR10.R                  /* Protocol Configuration Register 10 */
#define FR_0_PCR11           FR_0.PCR11.R                  /* Protocol Configuration Register 11 */
#define FR_0_PCR12           FR_0.PCR12.R                  /* Protocol Configuration Register 12 */
#define FR_0_PCR13           FR_0.PCR13.R                  /* Protocol Configuration Register 13 */
#define FR_0_PCR14           FR_0.PCR14.R                  /* Protocol Configuration Register 14 */
#define FR_0_PCR15           FR_0.PCR15.R                  /* Protocol Configuration Register 15 */
#define FR_0_PCR16           FR_0.PCR16.R                  /* Protocol Configuration Register 16 */
#define FR_0_PCR17           FR_0.PCR17.R                  /* Protocol Configuration Register 17 */
#define FR_0_PCR18           FR_0.PCR18.R                  /* Protocol Configuration Register 18 */
#define FR_0_PCR19           FR_0.PCR19.R                  /* Protocol Configuration Register 19 */
#define FR_0_PCR20           FR_0.PCR20.R                  /* Protocol Configuration Register 20 */
#define FR_0_PCR21           FR_0.PCR21.R                  /* Protocol Configuration Register 21 */
#define FR_0_PCR22           FR_0.PCR22.R                  /* Protocol Configuration Register 22 */
#define FR_0_PCR23           FR_0.PCR23.R                  /* Protocol Configuration Register 23 */
#define FR_0_PCR24           FR_0.PCR24.R                  /* Protocol Configuration Register 24 */
#define FR_0_PCR25           FR_0.PCR25.R                  /* Protocol Configuration Register 25 */
#define FR_0_PCR26           FR_0.PCR26.R                  /* Protocol Configuration Register 26 */
#define FR_0_PCR27           FR_0.PCR27.R                  /* Protocol Configuration Register 27 */
#define FR_0_PCR28           FR_0.PCR28.R                  /* Protocol Configuration Register 28 */
#define FR_0_PCR29           FR_0.PCR29.R                  /* Protocol Configuration Register 29 */
#define FR_0_PCR30           FR_0.PCR30.R                  /* Protocol Configuration Register 30 */
#define FR_0_STPWR           FR_0.STPWR.R                  /* StopWatch Count Register */
#define FR_0_PEOER           FR_0.PEOER.R                  /* Protocol Event Output Enable and StopWatch Control Register */
#define FR_0_RFSDOR          FR_0.RFSDOR.R                 /* Receive FIFO Start Data Offset Register */
#define FR_0_RFSYMBADHR      FR_0.RFSYMBADHR.R             /* Receive FIFO System Memory Base Address High Register */
#define FR_0_RFSYMBADLR      FR_0.RFSYMBADLR.R             /* Receive FIFO System Memory Base Address Low Register */
#define FR_0_RFPTR           FR_0.RFPTR.R                  /* Receive FIFO Periodic Timer Register */
#define FR_0_RFFLPCR         FR_0.RFFLPCR.R                /* Receive FIFO Fill Level and POP Count Register */
#define FR_0_EEIFER          FR_0.EEIFER.R                 /* ECC Error Interrupt Flag and Enable Register */
#define FR_0_EERICR          FR_0.EERICR.R                 /* ECC Error Report and Injection Control Register */
#define FR_0_EERAR           FR_0.EERAR.R                  /* ECC Error Report Address Register */
#define FR_0_EERDR           FR_0.EERDR.R                  /* ECC Error Report Data Register */
#define FR_0_EERCR           FR_0.EERCR.R                  /* ECC Error Report Code Register */
#define FR_0_EEIAR           FR_0.EEIAR.R                  /* ECC Error Injection Address Register */
#define FR_0_EEIDR           FR_0.EEIDR.R                  /* ECC Error Injection Data Register */
#define FR_0_EEICR           FR_0.EEICR.R                  /* ECC Error Injection Code Register */
#define FR_0_MBCCSR0         FR_0.MB[0].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR0         FR_0.MB[0].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR0         FR_0.MB[0].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR0         FR_0.MB[0].IDXR.R             /* Message Buffer Index Register */
#define FR_0_MBCCSR1         FR_0.MB[1].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR1         FR_0.MB[1].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR1         FR_0.MB[1].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR1         FR_0.MB[1].IDXR.R             /* Message Buffer Index Register */
#define FR_0_MBCCSR2         FR_0.MB[2].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR2         FR_0.MB[2].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR2         FR_0.MB[2].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR2         FR_0.MB[2].IDXR.R             /* Message Buffer Index Register */
#define FR_0_MBCCSR3         FR_0.MB[3].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR3         FR_0.MB[3].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR3         FR_0.MB[3].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR3         FR_0.MB[3].IDXR.R             /* Message Buffer Index Register */
#define FR_0_MBCCSR4         FR_0.MB[4].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR4         FR_0.MB[4].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR4         FR_0.MB[4].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR4         FR_0.MB[4].IDXR.R             /* Message Buffer Index Register */
#define FR_0_MBCCSR5         FR_0.MB[5].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR5         FR_0.MB[5].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR5         FR_0.MB[5].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR5         FR_0.MB[5].IDXR.R             /* Message Buffer Index Register */
#define FR_0_MBCCSR6         FR_0.MB[6].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR6         FR_0.MB[6].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR6         FR_0.MB[6].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR6         FR_0.MB[6].IDXR.R             /* Message Buffer Index Register */
#define FR_0_MBCCSR7         FR_0.MB[7].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR7         FR_0.MB[7].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR7         FR_0.MB[7].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR7         FR_0.MB[7].IDXR.R             /* Message Buffer Index Register */
#define FR_0_MBCCSR8         FR_0.MB[8].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR8         FR_0.MB[8].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR8         FR_0.MB[8].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR8         FR_0.MB[8].IDXR.R             /* Message Buffer Index Register */
#define FR_0_MBCCSR9         FR_0.MB[9].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR9         FR_0.MB[9].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR9         FR_0.MB[9].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR9         FR_0.MB[9].IDXR.R             /* Message Buffer Index Register */
#define FR_0_MBCCSR10        FR_0.MB[10].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR10        FR_0.MB[10].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR10        FR_0.MB[10].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR10        FR_0.MB[10].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR11        FR_0.MB[11].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR11        FR_0.MB[11].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR11        FR_0.MB[11].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR11        FR_0.MB[11].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR12        FR_0.MB[12].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR12        FR_0.MB[12].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR12        FR_0.MB[12].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR12        FR_0.MB[12].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR13        FR_0.MB[13].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR13        FR_0.MB[13].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR13        FR_0.MB[13].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR13        FR_0.MB[13].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR14        FR_0.MB[14].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR14        FR_0.MB[14].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR14        FR_0.MB[14].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR14        FR_0.MB[14].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR15        FR_0.MB[15].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR15        FR_0.MB[15].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR15        FR_0.MB[15].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR15        FR_0.MB[15].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR16        FR_0.MB[16].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR16        FR_0.MB[16].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR16        FR_0.MB[16].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR16        FR_0.MB[16].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR17        FR_0.MB[17].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR17        FR_0.MB[17].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR17        FR_0.MB[17].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR17        FR_0.MB[17].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR18        FR_0.MB[18].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR18        FR_0.MB[18].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR18        FR_0.MB[18].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR18        FR_0.MB[18].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR19        FR_0.MB[19].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR19        FR_0.MB[19].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR19        FR_0.MB[19].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR19        FR_0.MB[19].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR20        FR_0.MB[20].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR20        FR_0.MB[20].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR20        FR_0.MB[20].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR20        FR_0.MB[20].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR21        FR_0.MB[21].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR21        FR_0.MB[21].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR21        FR_0.MB[21].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR21        FR_0.MB[21].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR22        FR_0.MB[22].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR22        FR_0.MB[22].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR22        FR_0.MB[22].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR22        FR_0.MB[22].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR23