/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.examples.core.utils;

import com.nxp.s32ds.ext.rcp.jse.utils.FuncUtils;
import com.nxp.s32ds.ext.rcp.runtime.Log;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public final class ExampleImportUtils {
    private static final String WSP_LOC = "\\${workspace_loc:/";
    private static final String QUO = "\"";
    public static final String EMPTY = "";

    private ExampleImportUtils() {
    }

    public static void rename(IProject project, String projectSetsName, String name, Map<String, String> nameMap) throws CoreException, BuildException {
        if (CoreModel.hasCNature((IProject)project)) {
            ExampleImportUtils.updateCProject(project, projectSetsName, name, nameMap);
            IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
            if (buildInfo != null) {
                ManagedProject managed = (ManagedProject)ManagedBuildManager.getBuildInfo((IResource)project).getManagedProject();
                managed.setId(ExampleImportUtils.renameAll("(?<=^)[^.]*(?=\\..*$)", nameMap).apply(managed.getId()));
            }
        }
        ExampleImportUtils.updateReferencesProject(project, projectSetsName, name, nameMap);
    }

    private static void updateCProject(IProject project, String projectSetsName, String name, Map<String, String> nameMap) throws CoreException, BuildException {
        ICProjectDescription desc = CoreModel.getDefault().getProjectDescription(project);
        String oldLocation = (project.getLocation().removeLastSegments(1) + File.separator + project.getDescription().getName()).replace('\\', '/');
        String newLocation = (project.getLocation().removeLastSegments(1) + File.separator + project.getName()).replace('\\', '/');
        ICConfigurationDescription[] iCConfigurationDescriptionArray = desc.getConfigurations();
        int n = iCConfigurationDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription cConfig = iCConfigurationDescriptionArray[n2];
            IConfiguration configurationForDescription = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)cConfig);
            if (configurationForDescription != null) {
                IBuilder builder = configurationForDescription.getBuilder();
                String oldName = WSP_LOC + project.getDescription().getName() + '}';
                String newName = WSP_LOC + project.getName() + '}';
                builder.setBuildPath(builder.getBuildPath().replace(oldName, newName));
                Map referencesFrom = cConfig.getReferenceInfo();
                HashMap<String, String> referencesTo = new HashMap<String, String>();
                for (Map.Entry iter : referencesFrom.entrySet()) {
                    String key = ((String)iter.getKey()).replace(projectSetsName, name);
                    referencesTo.put(key, (String)iter.getValue());
                }
                cConfig.setReferenceInfo(referencesTo);
                ITool[] iToolArray = configurationForDescription.getTools();
                int n3 = iToolArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ITool tool = iToolArray[n4];
                    ExampleImportUtils.renameToolOptions(tool, projectSetsName, name);
                    ExampleImportUtils.updateLists(tool, oldLocation, oldName, newLocation);
                    ++n4;
                }
            }
            ++n2;
        }
        CoreModel.getDefault().setProjectDescription(project, desc);
    }

    private static IResource rename(IResource resource, String name) {
        if (resource instanceof IProject) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        }
        return resource;
    }

    private static void renameToolOptions(ITool tool, String projectSetsName, String name) throws BuildException {
        List opts;
        String c_cpp_tool;
        String toolName = tool.getBaseId();
        IOption opt = null;
        if (toolName.indexOf(".linker") != -1 && toolName.indexOf("cortexm") != -1) {
            String string = toolName.contains(".cpp.") ? "cpp" : (c_cpp_tool = toolName.contains(".c.") ? "c" : null);
            if (c_cpp_tool != null) {
                opt = tool.getOptionBySuperClassId("gnu." + c_cpp_tool + ".link.option.userobjs");
            }
        }
        if (toolName.indexOf("cx_linker") != -1 || toolName.indexOf("cc_linker") != -1) {
            String string = toolName.contains("cx_linker") ? "cx_linker" : (c_cpp_tool = toolName.contains("cc_linker") ? "cc_linker" : null);
            if (c_cpp_tool != null) {
                opt = tool.getOptionBySuperClassId("ghs.managedmake.arm.executable.toolchain." + c_cpp_tool + ".linker.raw_import_files");
            }
        }
        if (opt != null) {
            ArrayList<String> curValueList = new ArrayList<String>(Arrays.asList(opt.getBasicStringListValue()));
            if (opt.getBasicValueType() == 3) {
                opt.setValue(curValueList.stream().map(s -> s.replace(projectSetsName, name)).collect(Collectors.toList()));
            }
        }
        if (toolName.indexOf(".linker") != -1 && toolName.indexOf("iar") != -1 && (opts = Stream.of("iar.arm.toolchain.linker.option.extraOptions.v5.4.0", "iar.arm.toolchain.linker.option.imageInput.v5.4.0").map(arg_0 -> ((ITool)tool).getOptionBySuperClassId(arg_0)).collect(Collectors.toList())).stream().allMatch(Objects::nonNull)) {
            opts.stream().forEach(ExampleImportUtils.renameOption(projectSetsName, name));
        }
    }

    private static Consumer<IOption> renameOption(String oldName, String newName) {
        return FuncUtils.rethrowingConsumer(opt -> {
            if (opt.getBasicValueType() == 2) {
                opt.setValue(opt.getStringValue().replace(oldName, newName));
            }
        });
    }

    private static Function<String, String> renameAll(String regex, Map<String, String> nameMap) {
        return ExampleImportUtils.replaceAll(regex, key -> nameMap.getOrDefault(key, (String)key));
    }

    private static Function<String, String> replaceAll(String regexp, Function<String, String> func) {
        return input -> {
            Matcher matcher = Pattern.compile(regexp).matcher((CharSequence)input);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(sb, (String)func.apply(matcher.group()));
            }
            matcher.appendTail(sb);
            return sb.toString();
        };
    }

    private static void updateReferencesProject(IProject project, String projectSetsName, String name, Map<String, String> nameMap) throws CoreException {
        IProjectDescription pd = project.getDescription();
        pd.setName(nameMap.get(pd.getName()));
        IPath pathLocation = pd.getLocation();
        String lastSegment = pathLocation.lastSegment();
        String segmentReplacement = nameMap.get(lastSegment);
        if (segmentReplacement != null) {
            String newLastSegment = lastSegment.replace(lastSegment, segmentReplacement);
            IPath newPath = pathLocation.removeLastSegments(1).append(newLastSegment);
            pd.setLocation(newPath);
        }
        pd.setReferencedProjects(new IProject[0]);
        project.move(pd, true, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IProject toProject(String name) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(name);
    }

    private static void updateLists(ITool tool, String oldAbsolutePath, String s1, String newPath) {
        IOption[] iOptionArray = tool.getOptions();
        int n = iOptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IOption op = iOptionArray[n2];
            try {
                String[] data = null;
                if (op.getValueType() == 3) {
                    data = op.getStringListValue();
                } else if (op.getValueType() == 4) {
                    data = op.getIncludePaths();
                }
                if (data != null) {
                    boolean isChanged = false;
                    int i = 0;
                    while (i < data.length) {
                        String a = data[i].replace('\\', '/');
                        String quote = a.startsWith(QUO) ? QUO : EMPTY;
                        String b = String.valueOf(quote) + oldAbsolutePath;
                        String c = String.valueOf(quote) + s1;
                        if (a.startsWith(b)) {
                            data[i] = String.valueOf(quote) + newPath + a.substring(b.length());
                            isChanged = true;
                        } else if (a.startsWith(c)) {
                            data[i] = String.valueOf(quote) + newPath + a.substring(c.length());
                            isChanged = true;
                        }
                        ++i;
                    }
                    if (isChanged) {
                        op.setValue(data);
                    }
                }
            }
            catch (BuildException be) {
                Log.logError((String)be.getMessage());
            }
            ++n2;
        }
    }
}

