/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cross.sdk.S32Rx7x_0_8_3.pexconf;

import com.nxp.s32ds.cross.sdk.S32Rx7x_0_8_3.pexconf.Activator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.CSourceEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

class PExConfigAdjuster {
    private static final String[] sourceFolders = new String[]{"SDK", "Generated_Code", "Sources"};
    private static final String[] includeFolders = new String[]{"Generated_Code", "Sources"};
    private static final String[] backupFolders = new String[]{"Project_Settings", "src", "include"};
    private static final String[] backupFiles = new String[]{".cproject"};
    private static final Map<String, String> toolchainsIncludeOptions = new HashMap<String, String>();
    protected static final Map<String, String> toolchainsAsmOptions = new HashMap<String, String>();
    protected static final List<String> AsmDefines = Arrays.asList("SEMIHOSTING");
    protected static final Map<String, String> toolchainsCOptions = new HashMap<String, String>();
    protected static final Map<String, String> toolchainsOtherOptions = new HashMap<String, String>();
    protected static final Map<String, List<String>> OtherOptions = new HashMap<String, List<String>>();
    protected IProject project;

    PExConfigAdjuster(IProject project) {
        toolchainsIncludeOptions.put("com.freescale.s32ds.cross.gnu.e200.tool.c.compiler", "gnu.c.compiler.option.include.paths");
        toolchainsIncludeOptions.put("com.freescale.s32ds.cross.gnu.e200.tool.cpp.compiler", "gnu.cpp.compiler.option.include.paths");
        toolchainsIncludeOptions.put("com.freescale.s32ds.cross.gnu.e200.tool.assembler", "gnu.both.asm.option.include.paths");
        toolchainsIncludeOptions.put("ghs.managedmake.ppc.executable.toolchain.cx_compiler", "ghs.managedmake.ppc.executable.toolchain.cx_compiler.project.include_directories");
        toolchainsIncludeOptions.put("ghs.managedmake.ppc.executable.toolchain.cc_compiler", "ghs.managedmake.ppc.executable.toolchain.cc_compiler.project.include_directories");
        toolchainsIncludeOptions.put("com.windriver.cdt.diab.tool.compiler.c", "com.windriver.cdt.diab.option.compiler.includePath");
        toolchainsIncludeOptions.put("com.windriver.cdt.diab.tool.compiler.cxx", "com.windriver.cdt.diab.option.compiler.includePath");
        toolchainsAsmOptions.put("com.freescale.s32ds.cross.gnu.e200.tool.assembler", "com.freescale.s32ds.cross.gnu.tool.assembler.option.defs");
        toolchainsAsmOptions.put("com.windriver.cdt.diab.tool.assembler", "com.windriver.cdt.diab.option.assembler.defines");
        toolchainsCOptions.put("com.freescale.s32ds.cross.gnu.e200.tool.c.compiler", "gnu.c.compiler.option.preprocessor.def.symbols");
        toolchainsCOptions.put("com.windriver.cdt.diab.tool.compiler.c", "com.windriver.cdt.diab.option.compiler.defines");
        toolchainsOtherOptions.put("com.windriver.cdt.diab.tool.compiler.c", "com.windriver.cdt.diab.option.compiler.other");
        toolchainsOtherOptions.put("com.windriver.cdt.diab.tool.linker.c", "com.windriver.cdt.diab.option.linker.other");
        OtherOptions.put("com.windriver.cdt.diab.option.compiler.other", Arrays.asList("-Wa,-Xisa-vle", "-Xdialect-c99", "-Xsmall-data=0", "-Xsmall-const=0", "-Xdebug-dwarf2", "-Xdebug-local-all", "-Xdebug-local-cie", "-Xdebug-struct-all"));
        OtherOptions.put("com.windriver.cdt.diab.option.linker.other", Arrays.asList("-Xpreprocess-lecl"));
        this.project = project;
    }

    void adjustPExConfiguration() {
        try {
            this.backupProjectResources();
            this.createSourceEntries();
            this.adjustOptions();
            this.cleanupFolders();
        }
        catch (Exception e) {
            Activator.log(e);
        }
    }

    protected void setOptions(IOption option, String idx, List<String> l, Map<String, List<String>> m) {
        try {
            if (option != null && option.getBasicValueType() == 3) {
                LinkedHashSet<String> opt = new LinkedHashSet<String>();
                if (l != null) {
                    opt.addAll(l);
                }
                if (m != null && m.containsKey(idx)) {
                    opt.addAll((Collection)m.get(idx));
                }
                option.setValue(new ArrayList(opt));
            }
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
    }

    protected void insertOptions(IOption option, String idx, List<String> l, Map<String, List<String>> m, int pos) {
        try {
            if (option != null && option.getBasicValueType() == 3) {
                LinkedHashSet<String> old = new LinkedHashSet<String>(Arrays.asList(option.getBasicStringListValue()));
                this.setOptions(option, idx, l, m);
                LinkedHashSet<String> cur = new LinkedHashSet<String>(Arrays.asList(option.getBasicStringListValue()));
                if (pos == 0) {
                    cur.addAll(old);
                    option.setValue(new ArrayList<String>(cur));
                } else {
                    old.addAll(cur);
                    option.setValue(new ArrayList<String>(old));
                }
            }
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
    }

    protected void adjustOptions() throws BuildException {
        IConfiguration[] configs;
        IConfiguration[] iConfigurationArray = configs = ManagedBuildManager.getBuildInfo((IResource)this.project).getManagedProject().getConfigurations();
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            ITool[] tools;
            IConfiguration config = iConfigurationArray[n2];
            ITool[] iToolArray = tools = config.getTools();
            int n3 = tools.length;
            int n4 = 0;
            while (n4 < n3) {
                IOption option;
                ITool tool = iToolArray[n4];
                String toolBaseId = tool.getBaseId();
                String optionSuperClassId = toolchainsIncludeOptions.get(toolBaseId);
                if (optionSuperClassId != null) {
                    option = tool.getOptionToSet(tool.getOptionBySuperClassId(optionSuperClassId), false);
                    String[] stringArray = includeFolders;
                    int n5 = includeFolders.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String includeFolder = stringArray[n6];
                        this.addOptionValue(option, includeFolder);
                        ++n6;
                    }
                }
                if ((optionSuperClassId = toolchainsAsmOptions.get(toolBaseId)) != null) {
                    option = tool.getOptionToSet(tool.getOptionBySuperClassId(optionSuperClassId), false);
                    this.insertOptions(option, null, AsmDefines, null, 0);
                }
                if ((optionSuperClassId = toolchainsOtherOptions.get(toolBaseId)) != null) {
                    option = tool.getOptionToSet(tool.getOptionBySuperClassId(optionSuperClassId), false);
                    this.insertOptions(option, optionSuperClassId, null, OtherOptions, 0);
                }
                ++n4;
            }
            ++n2;
        }
    }

    protected void createSourceEntries() throws CoreException {
        HashSet<CSourceEntry> additionalSourceEntrires = new HashSet<CSourceEntry>();
        String[] stringArray = sourceFolders;
        int n = sourceFolders.length;
        int n2 = 0;
        while (n2 < n) {
            String sourceFolder = stringArray[n2];
            additionalSourceEntrires.add(new CSourceEntry(this.project.getFolder(sourceFolder), null, 0));
            ++n2;
        }
        ICProjectDescription description = CCorePlugin.getDefault().getProjectDescription(this.project);
        ICConfigurationDescription[] iCConfigurationDescriptionArray = description.getConfigurations();
        int n3 = iCConfigurationDescriptionArray.length;
        n = 0;
        while (n < n3) {
            ICConfigurationDescription config = iCConfigurationDescriptionArray[n];
            HashSet<ICSourceEntry> sourceEntries = new HashSet<ICSourceEntry>(Arrays.asList(config.getSourceEntries()));
            sourceEntries.addAll(additionalSourceEntrires);
            config.setSourceEntries(sourceEntries.toArray(new ICSourceEntry[sourceEntries.size()]));
            ++n;
        }
        CCorePlugin.getDefault().setProjectDescription(this.project, description, false, (IProgressMonitor)new NullProgressMonitor());
    }

    protected void addOptionValue(IOption opt, String value) throws BuildException {
        if (opt == null) {
            return;
        }
        ArrayList<String> curValueList = new ArrayList<String>(Arrays.asList(opt.getBasicStringListValue()));
        curValueList.add("\"${ProjDirPath}/" + value + "\"");
        opt.setValue(curValueList);
    }

    protected void addOptionValue(int pos, IOption opt, String value) throws BuildException {
        if (opt == null || pos < 0) {
            return;
        }
        if (opt.getBasicValueType() == 3) {
            ArrayList<String> curValueList = new ArrayList<String>(Arrays.asList(opt.getBasicStringListValue()));
            if (!curValueList.contains(value)) {
                curValueList.add(pos, value);
            }
            opt.setValue(curValueList);
        }
    }

    protected void cleanupFolder(String path, List<String> exclude) throws CoreException {
        IFolder fld = this.project.getFolder(path);
        if (fld.exists() && !fld.isLinked()) {
            IResource[] iResourceArray = fld.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPath fullPath;
                IResource fx = iResourceArray[n2];
                if (fx instanceof IFile && (fullPath = fx.getFullPath()).segmentCount() > 0) {
                    String lastSegment = fullPath.lastSegment();
                    if (exclude == null || !exclude.contains(lastSegment)) {
                        fx.delete(true, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
                ++n2;
            }
        }
    }

    protected void cleanupFolders(Map<String, List<String>> cleanup) throws CoreException {
        for (Map.Entry<String, List<String>> entry : cleanup.entrySet()) {
            this.cleanupFolder(entry.getKey(), entry.getValue());
        }
    }

    protected void cleanupFolders() throws CoreException {
        this.cleanupFolder("src", null);
        this.cleanupFolder("include", null);
    }

    protected void backupProjectResources() throws CoreException {
        Stream.of(backupFiles).map(f -> this.project.getFile(f)).filter(file -> file.exists() && !file.isLinked()).forEach(this::backupFile);
        Stream.of(backupFolders).map(f -> this.project.getFolder(f)).filter(fld -> fld.exists() && !fld.isLinked()).forEach(this::backupFolder);
    }

    protected void backupFolder(IFolder sourceFolder) {
        try {
            IFolder folder = this.project.getFolder(String.valueOf(sourceFolder.getName()) + ".bak");
            if (folder == null || folder.exists()) {
                return;
            }
            folder.create(1, true, (IProgressMonitor)new NullProgressMonitor());
            IPath newFolderPath = folder.getFullPath();
            IResource[] iResourceArray = sourceFolder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                IPath copyToPath = newFolderPath.append(resource.getFullPath().lastSegment());
                resource.copy(copyToPath, true, (IProgressMonitor)new NullProgressMonitor());
                ++n2;
            }
            folder.accept(new IResourceVisitor(){

                public boolean visit(IResource backupResource) throws CoreException {
                    if (1 == backupResource.getType()) {
                        PExConfigAdjuster.this.backupFile((IFile)backupResource, true);
                    }
                    return true;
                }
            });
        }
        catch (CoreException ce) {
            Activator.log((Exception)((Object)ce));
        }
    }

    protected void backupFile(IFile sourceFile) {
        this.backupFile(sourceFile, false);
    }

    protected void backupFile(IFile sourceFile, boolean isDeleteSource) {
        try {
            String pathStr = String.valueOf(sourceFile.getFullPath().lastSegment()) + ".bak";
            IFile file = this.project.getFile(pathStr);
            if (file.exists()) {
                return;
            }
            if (isDeleteSource) {
                sourceFile.move((IPath)new Path(pathStr), true, (IProgressMonitor)new NullProgressMonitor());
            } else {
                sourceFile.copy((IPath)new Path(pathStr), true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException ce) {
            Activator.log((Exception)((Object)ce));
        }
    }
}

