/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.embsysregview.internal.utils;

import java.util.function.Consumer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class GUIUtils {
    private GUIUtils() {
    }

    public static void exec(Runnable runnable) {
        GUIUtils.exec(GUIUtils.getDisplay(), runnable, false);
    }

    private static void exec(Display display, Runnable runnable, boolean blocking) {
        if (display != null && runnable != null) {
            Consumer<Runnable> exec = blocking ? arg_0 -> ((Display)display).syncExec(arg_0) : arg_0 -> ((Display)display).asyncExec(arg_0);
            exec.accept(runnable);
        }
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        return display == null ? Display.getDefault() : display;
    }

    public static IWorkbenchPage getActivePage() {
        return GUIUtils.getActiveWorkbenchWindow().getActivePage();
    }

    private static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public static Shell getShell() {
        return GUIUtils.getActiveWorkbenchWindow().getShell();
    }
}

