/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.embsysregview.internal.ui.view;

import org.eclipse.cdt.embsysregview.Activator;
import org.eclipse.cdt.embsysregview.Messages;
import org.eclipse.cdt.embsysregview.core.EmbSysRegCore;
import org.eclipse.cdt.embsysregview.core.EmbSysRegEngine;
import org.eclipse.cdt.embsysregview.internal.model.TreeElement;
import org.eclipse.cdt.embsysregview.internal.model.TreeField;
import org.eclipse.cdt.embsysregview.internal.model.TreeRegister;
import org.eclipse.cdt.embsysregview.internal.utils.Utils;
import org.eclipse.cdt.embsysregview.preferences.PreferencePageEmbSysBehavior;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;

public class HexColumnEditingSupport
extends EditingSupport {
    private final EmbSysRegEngine engine;
    private final ComboBoxViewerCellEditor comboCellEditor;
    private final TextCellEditor textCellEditor;
    private TreeElement currentEditedElement;

    HexColumnEditingSupport(TreeViewer viewer, ComboBoxViewerCellEditor comboEditor, TextCellEditor textEditor, EmbSysRegEngine embSysEngine) {
        super((ColumnViewer)viewer);
        this.engine = embSysEngine;
        this.comboCellEditor = comboEditor;
        this.textCellEditor = textEditor;
    }

    protected boolean canEdit(Object element) {
        return EmbSysRegCore.checkEditRules(element);
    }

    protected Object getValue(Object element) {
        if (element instanceof TreeField && ((TreeField)element).hasInterpretations()) {
            return new Integer((int)((TreeField)element).getValue());
        }
        if (element instanceof TreeField) {
            return Utils.longtoHexString(((TreeField)element).getValue(), ((TreeField)element).getBitLength());
        }
        if (element instanceof TreeRegister) {
            return Utils.longtoHexString(((TreeRegister)element).getValue(), ((TreeRegister)element).getBitSize());
        }
        return "";
    }

    protected void setValue(Object element, Object value) {
        if (element instanceof TreeRegister) {
            TreeRegister treeRegister = (TreeRegister)element;
            Long lvalue = EmbSysRegCore.parseLong(value);
            if (lvalue != null) {
                this.engine.setValue(treeRegister, lvalue);
            } else {
                Activator.log(4, "Cannot convert register value!");
            }
        } else if (element instanceof TreeField) {
            TreeField registerField = (TreeField)element;
            if (value instanceof String) {
                long lvalue = registerField.getInterpretations().getValue((String)value);
                if (lvalue != -1L) {
                    this.engine.updateRegisterByField(registerField, lvalue);
                } else {
                    try {
                        lvalue = EmbSysRegCore.parseLong(value);
                        if (lvalue != -1L) {
                            long maxValue = registerField.getMaxAllowedValue();
                            if (lvalue <= maxValue) {
                                this.engine.updateRegisterByField(registerField, lvalue);
                            } else {
                                Activator.log(4, NLS.bind((String)Messages.HexColumnEditionSupport_Register_filed_value_out_of_range, (Object)maxValue));
                            }
                        }
                    }
                    catch (Exception exception) {}
                }
                if (lvalue == -1L) {
                    Activator.log(4, NLS.bind((String)Messages.HexColumnEditingSupport_Cannot_convert_register_field_value, (Object[])new Object[0]));
                }
            }
        } else if (element != null) {
            Activator.log(4, "Unknown object type!");
        } else {
            Activator.log(4, "Null object!");
        }
    }

    protected CellEditor getCellEditor(Object element) {
        if (element instanceof TreeField && ((TreeField)element).hasInterpretations()) {
            this.comboCellEditor.setContentProvider(new IStructuredContentProvider(){

                public void dispose() {
                }

                public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
                }

                public Object[] getElements(Object obj) {
                    return ((TreeField)obj).getInterpretations().getLabelsArray();
                }
            });
            this.comboCellEditor.setInput(element);
            int combolength = PreferencePageEmbSysBehavior.getComboLengthPref();
            if (combolength > 0) {
                ((CCombo)this.comboCellEditor.getControl()).setVisibleItemCount(combolength);
            }
            this.currentEditedElement = (TreeElement)element;
            return this.comboCellEditor;
        }
        return this.textCellEditor;
    }

    public TreeElement getCurrentEditedElement() {
        return this.currentEditedElement;
    }
}

