/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.embsysregview.internal.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.cdt.embsysregview.internal.model.Interpretation;
import org.eclipse.cdt.embsysregview.internal.model.TreeField;
import org.eclipse.cdt.embsysregview.internal.utils.Utils;

public class Interpretations {
    private final ArrayList<Interpretation> interpretations = new ArrayList();
    private TreeField treeField;

    public void setTreeField(TreeField treeField) {
        this.treeField = treeField;
    }

    public void addInterpretation(long value, String description) {
        this.interpretations.add(new Interpretation(value, description));
    }

    public String getInterpretation(long value) {
        return this.interpretations.stream().filter(i -> i.getValue() == value).map(Interpretation::getInterpretation).findAny().orElse("");
    }

    public long getValue(String interpretation) {
        return this.interpretations.stream().filter(i -> i.getInterpretation().equals(interpretation)).map(Interpretation::getValue).findAny().orElse(-1L);
    }

    public String[] getLabelsArray() {
        Iterator<Interpretation> it = this.interpretations.iterator();
        int j = 1;
        String[] ret = new String[this.interpretations.size() + 1];
        ret[0] = Utils.longtoHexString(this.treeField.getValue(), this.treeField.getBitLength());
        while (it.hasNext()) {
            Interpretation i = it.next();
            ret[j] = i.getInterpretation();
            ++j;
        }
        return ret;
    }

    public void sort() {
        Collections.sort(this.interpretations);
    }

    public boolean hasInterpretations() {
        return !this.interpretations.isEmpty();
    }
}

