/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.embsysregview.internal;

import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.cdt.embsysregview.Activator;
import org.eclipse.cdt.embsysregview.Messages;
import org.eclipse.cdt.embsysregview.core.SortingOrder;
import org.eclipse.cdt.embsysregview.internal.RegisterXMLCollector;
import org.eclipse.cdt.embsysregview.internal.Scale;
import org.eclipse.cdt.embsysregview.internal.model.Interpretations;
import org.eclipse.cdt.embsysregview.internal.model.TreeElement;
import org.eclipse.cdt.embsysregview.internal.model.TreeField;
import org.eclipse.cdt.embsysregview.internal.model.TreeGroup;
import org.eclipse.cdt.embsysregview.internal.model.TreeParent;
import org.eclipse.cdt.embsysregview.internal.model.TreeRegister;
import org.eclipse.cdt.embsysregview.internal.model.TreeRegisterGroup;
import org.eclipse.cdt.embsysregview.properties.PropertiesHolder;
import org.eclipse.cdt.embsysregview.properties.Property;
import org.eclipse.cdt.embsysregview.properties.SettingsUtils;
import org.eclipse.cdt.embsysregview.views.EmbSysRegView;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaderXSDFactory;
import org.jdom2.input.sax.XMLReaders;
import org.osgi.framework.Bundle;

public class RegisterXMLParser {
    private static final String HEX_PREFIX = "0X";
    private static final String SCALE_SUFFIX = "KMGTB";
    private static final String separator = "/";
    private String store_board;
    private IProject project;
    private static final Map<String, String> ACCESS_MAP = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("read-write", "RW");
            this.put("write-only", "WO");
            this.put("read-only", "RO");
            this.put("writeOnce", "W1");
            this.put("read-writeOnce", "RW1");
        }
    });

    public RegisterXMLParser(IProject project) {
        this.project = project;
    }

    private Document openXML(boolean spr) throws CoreException {
        Map<String, String> registerDescriptionPaths = new RegisterXMLCollector().collectPaths();
        URL fileURL = null;
        for (String bundleName : registerDescriptionPaths.keySet()) {
            Bundle bundle = Platform.getBundle((String)bundleName);
            String directory = registerDescriptionPaths.get(bundleName);
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            String store_architecture = store.getString("architecture");
            String store_vendor = store.getString("vendor");
            String store_chip = store.getString("chip");
            this.store_board = store.getString("board");
            fileURL = bundle.getEntry(String.valueOf(directory) + separator + store_architecture + separator + store_vendor + separator + store_chip + (spr ? ".spr" : "") + ".xml");
            if (fileURL != null) break;
        }
        SAXBuilder builder = new SAXBuilder((XMLReaderJDOMFactory)XMLReaders.NONVALIDATING);
        try {
            return builder.build(fileURL);
        }
        catch (IOException | JDOMException e) {
            Status status = new Status(4, "org.eclipse.cdt.embsysregview", "File reading problem", e);
            throw new CoreException((IStatus)status);
        }
    }

    private Document openXML(IProject currentProject, boolean spr) throws CoreException {
        URL url;
        if (!currentProject.isNatureEnabled("org.eclipse.cdt.core.cnature")) {
            Status status = new Status(1, "org.eclipse.cdt.embsysregview", String.valueOf(String.format(Messages.EmbSysRegViewer_project, this.project.getName())) + Messages.EmbSysRegViewer_non_c_project);
            throw new CoreException((IStatus)status);
        }
        URL fileURL = null;
        Set<Property> propertySet = SettingsUtils.initializePropertyValues(currentProject);
        if (propertySet.isEmpty()) {
            Status status = new Status(1, "org.eclipse.cdt.embsysregview", String.format(Messages.RegisterXMLParser_Registers_definitions_not_found, currentProject.getName()));
            throw new CoreException((IStatus)status);
        }
        Map<String, String> props = propertySet.stream().collect(Collectors.toMap(Property::getName, Property::getValue));
        String store_architecture = props.get("architecture");
        String store_vendor = props.get("vendor");
        String store_chip = props.get("chip");
        this.store_board = props.get("board");
        if (this.store_board == null) {
            this.store_board = "";
        }
        if (store_architecture != null && store_vendor != null && store_chip != null) {
            fileURL = RegisterXMLParser.getFileURL(currentProject, spr);
        }
        if ((url = Activator.getDefault().getBundle().getEntry("check.xsd")) == null) {
            Status status = new Status(4, "org.eclipse.cdt.embsysregview", String.format(Messages.RegisterXMLParser_Bundle_not_found, "check.xsd", currentProject.getName()));
            throw new CoreException((IStatus)status);
        }
        if (fileURL == null) {
            Status status = new Status(4, "org.eclipse.cdt.embsysregview", String.format(Messages.RegisterXMLParser_No_data_file_for_project, currentProject.getName()));
            throw new CoreException((IStatus)status);
        }
        try {
            XMLReaderXSDFactory factory2 = new XMLReaderXSDFactory(new URL[]{url});
            SAXBuilder builder = new SAXBuilder((XMLReaderJDOMFactory)factory2);
            return builder.build(fileURL);
        }
        catch (IOException | JDOMException e) {
            Status status = new Status(4, "org.eclipse.cdt.embsysregview", String.valueOf(String.format(Messages.EmbSysRegViewer_project, this.project.getName())) + String.format(Messages.RegisterXMLParser_File_reading_problem, fileURL.getFile()), e);
            throw new CoreException((IStatus)status);
        }
    }

    private static URL getFileURL(IProject project, boolean spr) {
        Map<String, String> registerDescriptionPaths = new RegisterXMLCollector().collectPaths();
        String registerFileName = RegisterXMLParser.getRegisterFileName(project, spr);
        for (String bundleName : registerDescriptionPaths.keySet()) {
            String directory;
            Bundle bundle = Platform.getBundle((String)bundleName);
            URL fileURL = bundle.getEntry(String.valueOf(directory = registerDescriptionPaths.get(bundleName)) + separator + registerFileName);
            if (fileURL == null) continue;
            return fileURL;
        }
        return null;
    }

    private static String getRegisterFileName(IProject project, boolean spr) {
        Map<String, String> properties = PropertiesHolder.getInstance(project).getPropertySet().stream().collect(Collectors.toMap(Property::getName, Property::getValue));
        return String.valueOf(properties.get("architecture")) + separator + properties.get("vendor") + separator + properties.get(spr ? "core" : "chip") + (spr ? ".spr" : ".xml");
    }

    public TreeParent loadXML(EmbSysRegView.RegSet regSet) throws CoreException {
        return new TreeParent("", "", regSet){
            {
                TreeElement element;
                int n;
                int n2;
                TreeElement[] treeElementArray;
                super($anonymous0, $anonymous1);
                if (regSet.spr) {
                    treeElementArray = RegisterXMLParser.this.loadXML(true).getChildren();
                    n2 = treeElementArray.length;
                    n = 0;
                    while (n < n2) {
                        element = treeElementArray[n];
                        this.addChild(element);
                        ++n;
                    }
                }
                if (regSet.embsys) {
                    treeElementArray = RegisterXMLParser.this.loadXML(false).getChildren();
                    n2 = treeElementArray.length;
                    n = 0;
                    while (n < n2) {
                        element = treeElementArray[n];
                        this.addChild(element);
                        ++n;
                    }
                }
            }
        };
    }

    private TreeParent loadXML(boolean spr) throws CoreException {
        TreeParent tempRoot = new TreeParent("***", "root");
        Document doc = new Document();
        doc = this.project == null ? this.openXML(spr) : this.openXML(this.project, spr);
        if (doc != null) {
            Element root = doc.getRootElement();
            try {
                if (root.getName() == "device") {
                    return RegisterXMLParser.parseSVD(root, tempRoot, spr);
                }
                return this.parseXML(root, tempRoot, spr);
            }
            catch (ParseException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.embsysregview", "Parse file problem", (Throwable)e));
            }
        }
        return tempRoot;
    }

    private static <E extends Exception> String attr(Element element, String name, Supplier<E> exception) throws E {
        Element attr = element.getChild(name);
        if (attr == null) {
            throw (Exception)exception.get();
        }
        return attr.getValue();
    }

    private static String attr(Element element, String name, String defaultValue) {
        Element attr = element.getChild(name);
        return attr == null ? "" : attr.getValue();
    }

    private static TreeParent parseSVD(Element root, TreeParent tempRoot, boolean spr) throws ParseException {
        TreeElement oldTreeGroup = null;
        Element peripherals = root.getChild("peripherals");
        if (peripherals != null) {
            List grouplist = peripherals.getChildren("peripheral");
            for (Element group : grouplist) {
                Element registers;
                String rgname = RegisterXMLParser.attr(group, "name", () -> new ParseException("peripheral requires name", 1));
                String baseAddress = RegisterXMLParser.attr(group, "baseAddress", () -> new ParseException("peripheral requires baseAddress", 1));
                String gdescription = RegisterXMLParser.attr(group, "description", "").replaceAll("( )+", " ");
                Attribute attr_derivedFrom = group.getAttribute("derivedFrom");
                if (attr_derivedFrom != null) {
                    String derivedFrom = attr_derivedFrom.getValue();
                    for (Element linkedgroup : grouplist) {
                        String expression;
                        String lname = RegisterXMLParser.attr(linkedgroup, "name", () -> new ParseException("derived peripheral requires name of super peripheral", 1));
                        if (!lname.equals(derivedFrom)) continue;
                        group = linkedgroup;
                        Element attr_lgdescription = linkedgroup.getChild("description");
                        if (attr_lgdescription == null || !gdescription.isEmpty() || !(gdescription = attr_lgdescription.getValue().replaceAll("( )+", " ")).matches(expression = ".*[0-9]$") || gdescription.charAt(gdescription.length() - 1) != lname.charAt(lname.length() - 1)) break;
                        gdescription = String.valueOf(gdescription.substring(0, gdescription.length() - 1)) + rgname.charAt(rgname.length() - 1);
                        break;
                    }
                }
                TreeElement obj_group = null;
                Element attr_gname = group.getChild("groupName");
                if (attr_gname != null) {
                    String gname = attr_gname.getValue();
                    TreeElement[] treeElementArray = tempRoot.getChildren();
                    int n = treeElementArray.length;
                    int expression = 0;
                    while (expression < n) {
                        TreeElement te = treeElementArray[expression];
                        if (te.getName().equals(gname) && te instanceof TreeGroup) {
                            obj_group = (TreeGroup)te;
                            break;
                        }
                        ++expression;
                    }
                    if (obj_group == null) {
                        String expression2 = ".*[0-9]$";
                        String tmpgdescription = gdescription.matches(expression2) && gdescription.charAt(gdescription.length() - 1) == rgname.charAt(rgname.length() - 1) ? gdescription.substring(0, gdescription.length() - 1).trim() : gdescription;
                        obj_group = new TreeGroup(gname, tmpgdescription);
                        tempRoot.addChild(obj_group);
                    }
                    oldTreeGroup = obj_group;
                } else if (oldTreeGroup != null && oldTreeGroup.getName().equals(rgname)) {
                    obj_group = oldTreeGroup;
                } else {
                    obj_group = new TreeGroup(rgname, gdescription);
                    tempRoot.addChild(obj_group);
                    oldTreeGroup = obj_group;
                }
                TreeRegisterGroup obj_registergroup = new TreeRegisterGroup(rgname, gdescription);
                if (!spr) {
                    ((TreeParent)obj_group).addChild(obj_registergroup);
                }
                if ((registers = group.getChild("registers")) == null) continue;
                for (Element register : registers.getChildren("register")) {
                    long raddress;
                    String rname = RegisterXMLParser.attr(register, "name", () -> new ParseException("register requires name", 1));
                    String rdescription = RegisterXMLParser.attr(register, "description", "");
                    Element attr_roffsetaddress = register.getChild("addressOffset");
                    if (attr_roffsetaddress != null) {
                        raddress = attr_roffsetaddress.getValue().startsWith("0x") ? Long.parseLong(attr_roffsetaddress.getValue().substring(2), 16) : Long.parseLong(attr_roffsetaddress.getValue());
                    } else {
                        throw new ParseException("register requires address", 1);
                    }
                    Element attr_rresetvalue = register.getChild("resetValue");
                    long rresetvalue = 0L;
                    if (attr_rresetvalue != null && !attr_rresetvalue.getValue().equals("")) {
                        try {
                            rresetvalue = attr_rresetvalue.getValue().startsWith("0x") ? Long.parseLong(attr_rresetvalue.getValue().substring(2), 16) : Long.parseLong(attr_rresetvalue.getValue());
                        }
                        catch (Exception e) {
                            Activator.log(0, "Initialized by default", e);
                        }
                    }
                    String raccess = RegisterXMLParser.attr(register, "access", "RO");
                    raccess = ACCESS_MAP.getOrDefault(raccess, raccess);
                    Element attr_rsize = register.getChild("size");
                    int rsize = attr_rsize != null ? (attr_rsize.getValue().startsWith("0x") ? Integer.parseInt(attr_rsize.getValue().substring(2), 16) / 8 : Integer.parseInt(attr_rsize.getValue()) / 8) : 4;
                    long lbaseAddress = RegisterXMLParser.readScaledNonNegativeInteger("baseAddress", baseAddress);
                    Element attr_rdim = register.getChild("dim");
                    int rdim = attr_rdim != null ? Integer.parseInt(attr_rdim.getValue(), 10) : 1;
                    Element attr_rdimIncrement = register.getChild("dimIncrement");
                    int rdimIncrement = attr_rdimIncrement != null ? (attr_rdimIncrement.getValue().startsWith("0x") ? Integer.parseInt(attr_rdimIncrement.getValue().substring(2), 16) : Integer.parseInt(attr_rdimIncrement.getValue(), 10)) : 0;
                    String rdimIndex = RegisterXMLParser.attr(register, "dimIndex", "");
                    int begIdx = 0;
                    int commaIdx = 0;
                    Boolean isCommaList = rdimIndex.indexOf(44, 0) != -1;
                    Boolean isRangeList = rdimIndex.indexOf(45, 0) != -1;
                    int i = 0;
                    while (i < rdim) {
                        TreeRegister obj_register;
                        if (rdim > 1) {
                            String r;
                            if (isCommaList.booleanValue()) {
                                commaIdx = i < rdim - 1 ? rdimIndex.indexOf(44, begIdx) : rdimIndex.length();
                                if (commaIdx != -1) {
                                    r = rdimIndex.substring(begIdx, commaIdx);
                                    begIdx = commaIdx + 1;
                                } else {
                                    r = "x";
                                    begIdx = 0;
                                }
                            } else if (isRangeList.booleanValue()) {
                                r = "x";
                                begIdx = 0;
                            } else {
                                r = "[err]";
                                begIdx = 0;
                            }
                            String s = rname.replace("%s", r);
                            obj_register = new TreeRegister(s, rdescription, lbaseAddress + raddress, rresetvalue, raccess, rsize, spr);
                            lbaseAddress += (long)rdimIncrement;
                        } else {
                            obj_register = new TreeRegister(rname, rdescription, lbaseAddress + raddress, rresetvalue, raccess, rsize, spr);
                        }
                        ((TreeParent)(spr ? obj_group : obj_registergroup)).addChild(obj_register);
                        SortingOrder.BitFieldSorter sorter = SortingOrder.getFromPreference();
                        Element fields_element = register.getChild("fields");
                        if (fields_element != null) {
                            ArrayList<TreeField> bitFieldsList = new ArrayList<TreeField>();
                            boolean isLittleEndianSorting = sorter.isLittleEndian();
                            for (Element field : fields_element.getChildren("field")) {
                                TreeField obj_field = RegisterXMLParser.createBitField(field, isLittleEndianSorting);
                                bitFieldsList.add(obj_field);
                            }
                            obj_register.addBitFields(bitFieldsList, sorter);
                        }
                        ++i;
                    }
                }
                if (spr) continue;
                obj_registergroup.extractRanges();
            }
        }
        return tempRoot;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TreeField createBitField(Element field, boolean isLittleEndianSorting) throws ParseException {
        String fname = RegisterXMLParser.attr(field, "name", () -> new ParseException("field requires name", 1));
        String fdescription = RegisterXMLParser.attr(field, "description", "");
        String fAccess = RegisterXMLParser.attr(field, "access", "");
        fAccess = ACCESS_MAP.getOrDefault(fAccess, "RW");
        Element attr_fbitoffset = field.getChild("bitOffset");
        byte fbitoffset = 0;
        byte fbitlength = 0;
        if (attr_fbitoffset != null) {
            fbitoffset = Byte.parseByte(attr_fbitoffset.getValue());
            Element attr_fbitlength = field.getChild("bitWidth");
            if (attr_fbitlength == null) throw new ParseException("field requires bitlength", 1);
            fbitlength = Byte.parseByte(attr_fbitlength.getValue());
        } else {
            Element attr_fbitrange = field.getChild("bitRange");
            if (attr_fbitrange != null) {
                String range_string = attr_fbitrange.getValue();
                String range = range_string.substring(1, range_string.length() - 1);
                String[] rangeArray = range.split(":");
                fbitoffset = Byte.valueOf(rangeArray[1]);
                fbitlength = (byte)(Byte.valueOf(rangeArray[0]) - Byte.valueOf(rangeArray[1]) + 1);
            } else {
                Element element_lsb = field.getChild("lsb");
                Element element_msb = field.getChild("msb");
                if (element_lsb == null || element_msb == null) throw new ParseException("field requires some sort of start-end bit marker", 1);
                fbitoffset = Byte.valueOf(element_lsb.getValue());
                fbitlength = (byte)(Byte.valueOf(element_msb.getValue()) - Byte.valueOf(element_lsb.getValue()));
            }
        }
        Interpretations interpretations = new Interpretations();
        Element enumeratedValues = field.getChild("enumeratedValues");
        if (enumeratedValues == null) return new TreeField(fname, fdescription, fbitoffset, fbitlength, interpretations, fAccess, isLittleEndianSorting);
        for (Element interpretation : enumeratedValues.getChildren("enumeratedValue")) {
            Element attr_key = interpretation.getChild("value");
            if (attr_key == null) {
                throw new ParseException("enumeratedValue requires value", 1);
            }
            long key = RegisterXMLParser.extractKey(attr_key.getValue());
            String name = RegisterXMLParser.attr(interpretation, "name", () -> new ParseException("enumeratedValue requires name", 1));
            String text = RegisterXMLParser.attr(interpretation, "description", name);
            text = text.replaceAll("(\\r|\\n|\\t| (?= ))", "");
            interpretations.addInterpretation(key, String.valueOf(name) + ": " + text);
        }
        return new TreeField(fname, fdescription, fbitoffset, fbitlength, interpretations, fAccess, isLittleEndianSorting);
    }

    private static long extractKey(String attrKey) {
        long key = -1L;
        if (attrKey.startsWith("0x")) {
            key = Long.valueOf(attrKey.substring(2), 16);
        } else if (attrKey.startsWith("#")) {
            String str = attrKey.substring(1);
            str = str.replace('x', '0');
            str = str.replace('X', '0');
            key = Long.valueOf(str, 2);
        } else {
            key = Long.valueOf(attrKey);
        }
        return key;
    }

    private static long readScaledNonNegativeInteger(String constructionName, String value) throws ParseException {
        Scale scale = RegisterXMLParser.readScale(value);
        if (scale == Scale.UNKNOWN) {
            Object[] bindings = new String[]{value, constructionName, "Hex/Dec"};
            String message = NLS.bind((String)Messages.unsupported_format_message, (Object[])bindings);
            throw new ParseException(message, 1);
        }
        if (scale != Scale.ONE) {
            value = value.substring(0, value.length() - 1);
        }
        long result = 0L;
        result = value.toUpperCase().startsWith(HEX_PREFIX) ? Long.parseLong(value.substring(2), 16) : (value.charAt(0) == '#' ? Long.parseLong(value.substring(1), 2) : Long.parseLong(value));
        return result * scale.getMagnifier();
    }

    private static Scale readScale(String value) {
        if (value.length() == 0) {
            return Scale.UNKNOWN;
        }
        if (value.toUpperCase().endsWith(SCALE_SUFFIX)) {
            char ch = value.toUpperCase().charAt(value.length());
            if (ch == 'K') {
                return Scale.KILO;
            }
            if (ch == 'M') {
                return Scale.MEGA;
            }
            if (ch == 'G') {
                return Scale.GIGA;
            }
            if (ch == 'T') {
                return Scale.TERA;
            }
            if (ch == 'B') {
                return Scale.UNKNOWN;
            }
        }
        return Scale.ONE;
    }

    private TreeParent parseXML(Element root, TreeParent tempRoot, boolean spr) throws ParseException {
        List grouplist = root.getChildren("group");
        for (Element group : grouplist) {
            Attribute attr_gname = group.getAttribute("name");
            if (attr_gname == null) {
                throw new ParseException("group requires name", 1);
            }
            String gname = attr_gname.getValue();
            Attribute attr_gdescription = group.getAttribute("description");
            String gdescription = attr_gdescription != null ? attr_gdescription.getValue() : "";
            TreeGroup obj_group = new TreeGroup(gname, gdescription);
            tempRoot.addChild(obj_group);
            List registergrouplist = group.getChildren();
            for (Element registergroup : registergrouplist) {
                Attribute attr_rgname = registergroup.getAttribute("name");
                if (attr_rgname == null) {
                    throw new ParseException("registergroup requires name", 1);
                }
                String rgname = attr_rgname.getValue();
                Attribute attr_rgdescription = registergroup.getAttribute("description");
                String rgdescription = attr_rgdescription != null ? attr_rgdescription.getValue() : "";
                TreeRegisterGroup obj_registergroup = new TreeRegisterGroup(rgname, rgdescription);
                obj_group.addChild(obj_registergroup);
                List registerlist = registergroup.getChildren();
                for (Element register : registerlist) {
                    Attribute attr_rname = register.getAttribute("name");
                    if (attr_rname == null) {
                        throw new ParseException("register requires name", 1);
                    }
                    String rname = attr_rname.getValue();
                    Attribute attr_rdescription = register.getAttribute("description");
                    String rdescription = attr_rdescription != null ? attr_rdescription.getValue() : "";
                    Attribute attr_roffsetaddress = register.getAttribute("address");
                    if (attr_roffsetaddress == null) {
                        throw new ParseException("register requires address", 1);
                    }
                    long raddress = Long.parseLong(attr_roffsetaddress.getValue().substring(2), 16);
                    Attribute attr_rresetvalue = register.getAttribute("resetvalue");
                    long rresetvalue = attr_rresetvalue != null && attr_rresetvalue.getValue() != "" ? Long.parseLong(attr_rresetvalue.getValue().substring(2), 16) : 0L;
                    Attribute attr_raccess = register.getAttribute("access");
                    String raccess = attr_raccess != null ? attr_raccess.getValue() : "RO";
                    Attribute attr_rsize = register.getAttribute("size");
                    int rsize = attr_rsize != null ? Integer.parseInt(attr_rsize.getValue()) : 4;
                    TreeRegister obj_register = new TreeRegister(rname, rdescription, raddress, rresetvalue, raccess, rsize, spr);
                    obj_registergroup.addChild(obj_register);
                    ArrayList<TreeField> bitFieldsList = new ArrayList<TreeField>();
                    Element register_description = register.getChild("description");
                    if (register_description != null) {
                        rdescription = register_description.getText();
                        obj_register.setDescription(rdescription);
                    }
                    SortingOrder.BitFieldSorter sorter = SortingOrder.getFromPreference();
                    List fieldlist = register.getChildren("field");
                    for (Element field : fieldlist) {
                        Attribute attr_fboard_id = field.getAttribute("board_id");
                        String fboard_id = attr_fboard_id != null ? attr_fboard_id.getValue() : "";
                        if (fboard_id.equals("") || fboard_id.equals(this.store_board)) {
                            Attribute attr_fname = field.getAttribute("name");
                            if (attr_fname == null) {
                                throw new ParseException("field requires name", 1);
                            }
                            String fname = attr_fname.getValue();
                            Attribute attr_fdescription = field.getAttribute("description");
                            String fdescription = attr_fdescription != null ? attr_fdescription.getValue() : "";
                            Attribute attr_fbitoffset = field.getAttribute("bitoffset");
                            if (attr_fbitoffset == null) {
                                throw new ParseException("field requires bitoffset", 1);
                            }
                            byte fbitoffset = Byte.parseByte(attr_fbitoffset.getValue());
                            Attribute attr_fbitlength = field.getAttribute("bitlength");
                            if (attr_fbitlength == null) {
                                throw new ParseException("field requires bitlength", 1);
                            }
                            byte fbitlength = Byte.parseByte(attr_fbitlength.getValue());
                            Element field_description = field.getChild("description");
                            if (field_description != null) {
                                fdescription = field_description.getText();
                            }
                            Interpretations interpretations = new Interpretations();
                            List interpretationlist = field.getChildren("interpretation");
                            for (Element interpretation : interpretationlist) {
                                long key;
                                Attribute attr_key = interpretation.getAttribute("key");
                                if (attr_key != null) {
                                    String skey = attr_key.getValue();
                                    key = skey.startsWith("0x") ? Long.parseLong(skey.substring(2), 16) : Long.parseLong(skey);
                                } else {
                                    throw new ParseException("interpretation requires key", 1);
                                }
                                Attribute attr_text = interpretation.getAttribute("text");
                                if (attr_text == null) {
                                    throw new ParseException("interpretation requires text", 1);
                                }
                                String text = attr_text.getValue();
                                interpretations.addInterpretation(key, text);
                            }
                            TreeField obj_field = new TreeField(fname, fdescription, fbitoffset, fbitlength, interpretations, "RW", false);
                            bitFieldsList.add(obj_field);
                        }
                        obj_register.addBitFields(bitFieldsList, sorter);
                        obj_registergroup.extractRanges();
                    }
                }
            }
        }
        return tempRoot;
    }
}

