/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.embsysregview.core;

import java.util.List;
import java.util.Set;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.embsysregview.internal.model.EmbSysRegModel;
import org.eclipse.cdt.embsysregview.internal.model.TreeElement;
import org.eclipse.cdt.embsysregview.internal.model.TreeField;
import org.eclipse.cdt.embsysregview.internal.model.TreeParent;
import org.eclipse.cdt.embsysregview.internal.model.TreeRange;
import org.eclipse.cdt.embsysregview.internal.model.TreeRegister;
import org.eclipse.cdt.embsysregview.internal.model.TreeRegisterGroup;
import org.eclipse.cdt.embsysregview.internal.ui.view.EmbSysRegViewer;
import org.eclipse.cdt.embsysregview.internal.utils.DSFAccessor;
import org.eclipse.cdt.embsysregview.internal.utils.DSFDebugModelListener;
import org.eclipse.cdt.embsysregview.internal.utils.DSFSessionState;
import org.eclipse.cdt.embsysregview.internal.utils.EmbSysRegViewDsfEventListener;
import org.eclipse.cdt.embsysregview.views.EmbSysRegView;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class EmbSysRegEngine
implements DSFDebugModelListener,
ISelectionChangedListener {
    protected final EmbSysRegModel fDataModel;
    protected final EmbSysRegViewer m_regViewer;
    private DSFSessionState m_sessionState;
    protected final EmbSysRegViewDsfEventListener fEventListener = new EmbSysRegViewDsfEventListener(this);
    private TreeViewer m_control;

    public EmbSysRegEngine(EmbSysRegViewer embSysRegViewer, EmbSysRegView.RegSet regSet) {
        this.fDataModel = new EmbSysRegModel(regSet);
        this.m_regViewer = embSysRegViewer;
    }

    public TreeViewer createTreeViewer(Composite parent) {
        if (this.m_control == null) {
            this.m_control = new TreeViewer(parent, 66304);
            this.m_control.getControl().setLayoutData((Object)"height 100%,width 100%,hmin 0,wmin 0");
            this.m_control.getTree().setLinesVisible(true);
            this.m_control.getTree().setHeaderVisible(true);
            this.m_control.addSelectionChangedListener((ISelectionChangedListener)this);
            this.m_control.setContentProvider((IContentProvider)new ViewContentProvider());
            this.m_control.addFilter((ViewerFilter)new ViewContentFilter());
            this.m_regViewer.updateInfoLabel();
            this.setTreeViewModel(this.fDataModel.getRoot());
        }
        return this.m_control;
    }

    public synchronized boolean updateDebugContext() {
        DsfSession session = EmbSysRegEngine.getSessionContext();
        if (session != null) {
            return this.setSessionTrack(session);
        }
        return true;
    }

    private static DsfSession getSessionContext() {
        ILaunch launch;
        IAdaptable dbgContext = DebugUITools.getDebugContext();
        if (dbgContext != null && (launch = (ILaunch)dbgContext.getAdapter(ILaunch.class)) instanceof GdbLaunch) {
            return ((GdbLaunch)launch).getSession();
        }
        return null;
    }

    public final EmbSysRegModel getModel() {
        return this.fDataModel;
    }

    public boolean setSessionTrack(DsfSession context) {
        boolean changed = false;
        String sessionId = context.getId();
        if (this.m_sessionState != null && !this.m_sessionState.getSessionID().equals(sessionId)) {
            this.m_sessionState.removeServiceEventListener(this.fEventListener);
            this.m_sessionState.dispose();
            this.m_sessionState = null;
            changed = true;
        }
        if (this.m_sessionState == null && sessionId != null) {
            this.m_sessionState = new DSFSessionState(context);
            this.m_sessionState.addServiceEventListener(this.fEventListener);
            changed = true;
        }
        if (changed) {
            this.update();
        }
        return changed;
    }

    private void update() {
        if (this.m_sessionState == null) {
            this.setTreeViewModel(null);
            this.fDataModel.setRootReadOnly(true);
            return;
        }
        this.fDataModel.setRootReadOnly(false);
    }

    private void setTreeViewModel(TreeParent model) {
        this.m_control.setInput((Object)model);
    }

    public void getEmbSysRegUpdate(final IDMContext context, final boolean onlyOne) {
        if (this.m_sessionState != null) {
            this.m_sessionState.execute(new DsfRunnable(){

                public void run() {
                    if (onlyOne) {
                        EmbSysRegEngine.this.getSingleRegUpdate(context);
                    } else if (EmbSysRegEngine.this.fDataModel.getRegSet().isSPR()) {
                        EmbSysRegEngine.this.getCherryPickedRegUpdate(context);
                    } else {
                        EmbSysRegEngine.this.getRangedRegUpdate(context);
                    }
                }
            });
        }
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    protected void getSingleRegUpdate(IDMContext context) {
        TreeRegister reg = this.fDataModel.getPendingRead();
        if (reg != null) {
            DSFAccessor.getEmbSysRegisterData(context, this.m_sessionState, reg, this, this.fDataModel);
        }
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    protected void getRangedRegUpdate(IDMContext context) {
        Set<TreeRange> ranges = this.fDataModel.createRangeList();
        if (!ranges.isEmpty()) {
            for (TreeRange range : ranges) {
                DSFAccessor.getEmbSysDeviceData(context, this.m_sessionState, range, this, this.fDataModel);
            }
        }
    }

    public final EmbSysRegViewer getEmbSysRegViewer() {
        return this.m_regViewer;
    }

    @Override
    public void getEmbSysRegisterDataDone(IStatus status, TreeRegister register, Object arg) {
        EmbSysRegModel model = (EmbSysRegModel)arg;
        assert (model != null);
        if (status.isOK()) {
            model.pushRegister(register);
        } else {
            register.clearValue();
        }
        this.m_regViewer.requestUpdate();
    }

    public void selectionChanged(SelectionChangedEvent arg0) {
    }

    public final boolean isEmpty() {
        return this.fDataModel.isEmpty();
    }

    public void toggleOnLineState(TreeRegister treeRegister) {
        if (treeRegister.isRetrievalActive()) {
            this.getModel().setRegisterOffLine(treeRegister);
            this.m_control.refresh((Object)treeRegister);
            for (TreeRegister reg : treeRegister.getAlterName()) {
                this.m_control.refresh((Object)reg);
            }
        } else if (!treeRegister.isWriteOnly()) {
            this.getModel().setRegisterLive(treeRegister);
            this.updateDebugContext();
            if (this.isSessionReady()) {
                this.getEmbSysRegUpdate(EmbSysRegEngine.getDebugDmc(), true);
            }
        }
    }

    private boolean isSessionReady() {
        return this.m_sessionState != null;
    }

    public void setValue(TreeRegister treeRegister, long lvalue) {
        if (treeRegister.checkWriteModifiers(lvalue)) {
            this.updateDebugContext();
            if (this.isSessionReady()) {
                this.writeEmbSysReg(treeRegister, lvalue);
            }
        }
    }

    protected void writeEmbSysReg(TreeRegister treeRegister, long lvalue) {
        if (this.m_sessionState != null) {
            final IDMContext context = EmbSysRegEngine.getDebugDmc();
            this.fDataModel.setRegisterToWrite(treeRegister);
            final TreeRegister regHolder = new TreeRegister(treeRegister.getName(), null, treeRegister.getRegisterAddress(), 0L, treeRegister.getType(), treeRegister.getByteSize(), treeRegister.isSPR());
            regHolder.setValue(lvalue);
            this.m_sessionState.execute(new DsfRunnable(){

                public void run() {
                    EmbSysRegEngine.this.writeReg(context, regHolder);
                }
            });
        }
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    protected void writeReg(IDMContext context, TreeRegister regHolder) {
        if (regHolder != null) {
            DSFAccessor.writeEmbSysRegisterData(context, this.m_sessionState, regHolder, this, this.fDataModel);
        }
    }

    @Override
    public void writeEmbSysRegisterDataDone(IStatus status, TreeRegister regHolder, Object arg) {
        EmbSysRegModel model = (EmbSysRegModel)arg;
        assert (model != null);
        TreeRegister reg = this.fDataModel.getPendingReg();
        if (reg != null) {
            if (status.isOK()) {
                long lvalue = regHolder.getValue();
                reg.setValue(lvalue);
                for (TreeRegister altReg : reg.getAlterName()) {
                    if (reg.getByteSize() != altReg.getByteSize()) continue;
                    altReg.setValue(lvalue);
                }
            } else {
                reg.rollbackValue();
                for (TreeRegister altReg : reg.getAlterName()) {
                    altReg.rollbackValue();
                }
            }
        }
        this.m_regViewer.requestUpdate();
    }

    public void updateRegisterByField(TreeField registerField, long fvalue) {
        TreeRegister treeRegister = (TreeRegister)registerField.getParent();
        long rvalue = treeRegister.getValue();
        long mask = registerField.getBitMask();
        rvalue &= mask ^ 0xFFFFFFFFFFFFFFFFL;
        long value = fvalue << registerField.getBitOffset();
        this.setValue(treeRegister, rvalue |= (value &= mask));
    }

    @Override
    public void readEmbSysRangeDataDone(IStatus status, TreeRange range, MemoryByte[] bytes, Object arg) {
        if (status.isOK()) {
            EmbSysRegModel model = (EmbSysRegModel)arg;
            assert (model != null);
            model.applyRangeData(range, bytes);
            this.m_regViewer.requestUpdate();
        }
    }

    public void restoreSelections() {
    }

    public void toggleSelectedGroupOff(TreeRegisterGroup deviceEntry) {
        if (deviceEntry.isChecked()) {
            deviceEntry.setChecked(false);
            this.toggleSelectedGroupInternal(deviceEntry);
        }
    }

    public void toggleSelectedRegisterOff(TreeRegister register) {
        this.getModel().setRegisterOffLine(register);
    }

    public void toggleSelectGroup(TreeRegisterGroup deviceEntry) {
        deviceEntry.toggleChecked();
        this.toggleSelectedGroupInternal(deviceEntry);
    }

    private static IDMContext getDebugDmc() {
        IAdaptable context = DebugUITools.getDebugContext();
        if (context instanceof IAdaptable) {
            return (IDMContext)context.getAdapter(IDMContext.class);
        }
        return null;
    }

    public String getSessionTrackId() {
        if (this.m_sessionState != null) {
            return this.m_sessionState.getSessionID();
        }
        return null;
    }

    private void getCherryPickedRegUpdate(IDMContext context) {
        this.fDataModel.getCherryPicked().values().forEach(reg -> DSFAccessor.getEmbSysRegisterData(context, this.m_sessionState, reg, this, this.fDataModel));
    }

    private void toggleSelectedGroupInternal(TreeRegisterGroup deviceEntry) {
        List<TreeElement> deviceRanges = deviceEntry.getModelChildren();
        for (TreeElement treeElementRange : deviceRanges) {
            if (!(treeElementRange instanceof TreeRange)) continue;
            TreeRange deviceRange = (TreeRange)treeElementRange;
            for (TreeElement treeElement : deviceRange.getModelChildren()) {
                TreeRegister deviceRegister;
                if (!(treeElement instanceof TreeRegister) || !(deviceRegister = (TreeRegister)treeElement).isReadOnly() && !deviceRegister.isReadWrite()) continue;
                if (deviceEntry.isChecked()) {
                    this.getModel().setRegisterLive(deviceRegister);
                    continue;
                }
                this.getModel().setRegisterOffLine(deviceRegister);
            }
        }
        if (deviceEntry.isChecked()) {
            this.updateDebugContext();
            if (this.isSessionReady()) {
                this.getEmbSysRegUpdate(EmbSysRegEngine.getDebugDmc(), false);
            }
        } else {
            this.m_regViewer.requestUpdate();
        }
    }

    class ViewContentFilter
    extends ViewerFilter {
        ViewContentFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return true;
        }
    }

    class ViewContentProvider
    implements ITreeContentProvider {
        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            if (newInput == null) {
                EmbSysRegEngine.this.fDataModel.initialize();
            } else if (newInput instanceof IProject) {
                EmbSysRegEngine.this.fDataModel.initialize((IProject)newInput);
            } else {
                return;
            }
            this.updateRegViewerInfoLabel();
        }

        private void updateRegViewerInfoLabel() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ((ViewContentProvider)ViewContentProvider.this).EmbSysRegEngine.this.m_regViewer.updateInfoLabel();
                }
            });
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            if (child instanceof TreeElement) {
                return ((TreeElement)child).getParent();
            }
            return null;
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof TreeParent) {
                return ((TreeParent)parent).getChildren();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object parent) {
            if (parent instanceof TreeParent) {
                return ((TreeParent)parent).hasChildren();
            }
            return false;
        }
    }
}

