/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.vgt.ide.ui.actions;

import com.nxp.s32ds.vgt.ide.internal.ui.VgtIdeUiActivator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.wizards.IWizardDescriptor;

public abstract class OpenWizardAction
extends Action {
    private String wizardId;

    public OpenWizardAction(String wizardId) {
        this.wizardId = wizardId;
    }

    public void run() {
        Shell shell = null;
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow == null) {
            return;
        }
        shell = activeWindow.getShell();
        try {
            IWizardDescriptor wizardDesc = PlatformUI.getWorkbench().getNewWizardRegistry().findWizard(this.wizardId);
            if (wizardDesc != null) {
                this.openWizard(shell, wizardDesc);
            } else {
                IWizardDescriptor impWizardDesc = PlatformUI.getWorkbench().getImportWizardRegistry().findWizard(this.wizardId);
                if (impWizardDesc != null) {
                    this.openWizard(shell, impWizardDesc);
                }
            }
        }
        catch (CoreException ex) {
            VgtIdeUiActivator.getDefault().getLog().log(ex.getStatus());
        }
    }

    private void openWizard(Shell shell, IWizardDescriptor wizardDesc) throws CoreException {
        if (wizardDesc != null) {
            IWorkbenchWizard wizard = wizardDesc.createWizard();
            wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            if (dialog.open() == 0) {
                IIntroPart introPart = PlatformUI.getWorkbench().getIntroManager().getIntro();
                PlatformUI.getWorkbench().getIntroManager().closeIntro(introPart);
            }
        }
    }
}

