/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.resources;

import com.nxp.s32ds.ext.ide.internal.resources.ResourcesMessages;
import com.nxp.s32ds.ext.ide.resources.ResourceNameValidator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class WorkspaceResources {
    public static final String BUNDLE_SYMBOLIC_NAME = "com.nxp.s32ds.ext.ide.resources";
    private static final String EMPTY_CONTENT = "";

    public static List<IFile> collectFiles(String ... extensions) throws CoreException {
        IWorkspaceRoot resource = ResourcesPlugin.getWorkspace().getRoot();
        return WorkspaceResources.collectFiles((IResource)resource, extensions);
    }

    public static List<IFile> collectFiles(IResource resource, String ... extensions) throws CoreException {
        if (resource == null || extensions == null) {
            return Collections.emptyList();
        }
        FileExtensionFilter collector = new FileExtensionFilter(extensions);
        try {
            resource.accept((IResourceVisitor)collector);
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Throwable e) {
            String message = NLS.bind((String)ResourcesMessages.WorkspaceResources_e_collecting_files_for_extensions, (Object)Arrays.toString(extensions));
            Status error = new Status(4, BUNDLE_SYMBOLIC_NAME, message, e);
            throw new CoreException((IStatus)error);
        }
        List<IFile> collected = collector.getCollected();
        return collected;
    }

    public static IFolder createFolder(IProject projectHandle, String targetPath, IProgressMonitor monitor) throws CoreException {
        IStatus validate = ResourceNameValidator.file().validate(targetPath);
        if (!validate.isOK()) {
            throw new CoreException(validate);
        }
        if (projectHandle == null) {
            String message = NLS.bind((String)ResourcesMessages.WorkspaceResources_e_create_folder_project_invalid, (Object)targetPath);
            Status error = new Status(4, BUNDLE_SYMBOLIC_NAME, message);
            throw new CoreException((IStatus)error);
        }
        if (!projectHandle.isAccessible()) {
            String message = NLS.bind((String)ResourcesMessages.WorkspaceResources_e_create_folder_project_not_accessible, (Object)targetPath, (Object)projectHandle.getName());
            Status error = new Status(4, BUNDLE_SYMBOLIC_NAME, message);
            throw new CoreException((IStatus)error);
        }
        IFolder folder = projectHandle.getFolder(targetPath);
        if (!folder.exists()) {
            folder.create(false, true, monitor);
        }
        return folder;
    }

    public static String getFileContents(IFile file) throws CoreException {
        if (file == null) {
            String message = ResourcesMessages.WorkspaceResources_e_get_file_content_invalid;
            Status status = new Status(4, BUNDLE_SYMBOLIC_NAME, message);
            throw new CoreException((IStatus)status);
        }
        String charset = file.getCharset();
        InputStream is = file.getContents(true);
        try (Scanner scanner = null;){
            String content;
            scanner = new Scanner(is, charset);
            scanner.useDelimiter("\\A");
            String string = content = scanner.hasNext() ? scanner.next() : EMPTY_CONTENT;
            return string;
        }
    }

    public static IFile getFile(IPath path) {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(path);
    }

    public static String setFileContents(IFile file, String revised, IProgressMonitor monitor) throws CoreException {
        return WorkspaceResources.setFileContents(file, revised, 3, monitor);
    }

    public static String setFileContents(IFile file, String revised, int flags, IProgressMonitor monitor) throws CoreException {
        byte[] bytes;
        if (file == null) {
            String message = ResourcesMessages.WorkspaceResources_e_set_file_content_invalid;
            Status status = new Status(4, BUNDLE_SYMBOLIC_NAME, message);
            throw new CoreException((IStatus)status);
        }
        String outdated = EMPTY_CONTENT;
        String charset = file.getCharset();
        try {
            bytes = revised.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            String message = NLS.bind((String)ResourcesMessages.WorkspaceResources_e_set_file_content_failed, (Object)file.getFullPath());
            Status status = new Status(4, BUNDLE_SYMBOLIC_NAME, message, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        if (file.exists()) {
            outdated = WorkspaceResources.getFileContents(file);
            file.setContents((InputStream)stream, flags, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
        } else {
            file.create((InputStream)stream, flags, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
        }
        return outdated;
    }

    public static class FileExtensionFilter
    implements IResourceVisitor {
        private final Set<String> extensions;
        private final List<IFile> collected;

        public FileExtensionFilter(String ... extensions) {
            this.extensions = new HashSet<String>(Arrays.asList(extensions));
            this.collected = new ArrayList<IFile>();
        }

        public List<IFile> getCollected() {
            return new ArrayList<IFile>(this.collected);
        }

        public boolean visit(IResource resource) throws CoreException {
            IFile file;
            String extension;
            if (this.extensions.isEmpty()) {
                return false;
            }
            if (resource instanceof IContainer) {
                return true;
            }
            if (resource instanceof IFile && this.extensions.contains(extension = (file = (IFile)resource).getFileExtension())) {
                this.collected.add(file);
            }
            return false;
        }
    }
}

