/*****************************************************************************/
/* FILE NAME: ghsvle.ld   Copyright (c) 2016-2017 Freescale Semiconductor, Inc.  */
/*                                                       All Rights Reserved */
/* DESCRIPTION:                                                              */
/* Compiler: GHS                                                             */
/*****************************************************************************/

DEFAULTS {
/* define heap and stack size */
__HEAP_SIZE            = 0x1000;
__STACK_SIZE           = 0x1000;

SRAM_SIZE =  $(RAM_LENGTH)K;    
/* Define SRAM Base Address */
SRAM_BASE_ADDR = $(RAM_START);
}
    
MEMORY
{
    internal_ram       : org = SRAM_BASE_ADDR, len = SRAM_SIZE - __STACK_SIZE     
    stack_ram          : org = (SRAM_BASE_ADDR + SRAM_SIZE - __STACK_SIZE)  len = __STACK_SIZE    
}
   
SECTIONS
{

    .startup  ALIGN(0x400):
    {
        __start = . ;
        *(.startup)
    } > internal_ram

    .core_exceptions_table ALIGN(0x1000): {KEEP(*(.core_exceptions_table))} > . /* Exception Vector Table (IVPR) - align 4K boundary */        
    .intc_vector_table ALIGN(0x1000): {KEEP(*(.intc_vector_table ))} > .     /* ISR Vector Table - must be 4K aligned */        
            
    .init : {} > .
    .init_vle: {*(.init) *(.init_vle)} > .            
    .text : {} > .                         /* BookE Code */
    .vletext : {} > .                      /* VLE Code */ 
    .fixaddr : {} > .                      /* Required for         */
    .fixtype : {} > .                      /* compatibility with   */
    .secinfo : {} > .                      /* GHS provided startup */
    .syscall : {} > .                      /* code                 */
    
    __argv=.;
    __env=.;

    .rodata  : {*(.rdata) *(.rodata)} > .  /* Read Only Data */
    .ctors  ALIGN (0x4): { *(.ctors) } > .
    .dtors  ALIGN (0x4): { *(.dtors) } > .
    extab : {} > .
    extabindex : {} > .
    .sdata2 : {} > .                       /* Small Initialised Constant Data */
    .sbss2 :  {} > .                       /* Small Uninitialised Data (Area2) */

    . = ALIGN(0x8);
    _ROMADDR = .;

    __DATA_ROM = _ROMADDR;
    __DATA_ROM_ADDR = __DATA_ROM;

__DATA_RAM=.;
    .data  LOAD (__DATA_ROM): { *(.data)  } > .                       /* Initialised Data */
__DATA_END=.;

__SDATA_RAM=.;        
    .sdata  LOAD ((ADDR(.sdata) - ADDR(.data)) + __DATA_ROM): { *(.sdata)  } > . /* Small Initialised Data (Area1) */
__SDATA_END=.;

__BSS_START=.;
    .sbss : { *(.sbss) } > . /* Small Uninitialised Data (Area1) */
    .bss : { *(.bss) } > .   /* Uninitialised Data               */
__BSS_END=.;

    .heap   ALIGN(16) PAD(__HEAP_SIZE)       : {} > .             /* Heap Area  */
    .stack  ALIGN(4)  PAD(__STACK_SIZE)      : {} > stack_ram     /* Stack Area */

__SP_INIT      = ADDR(stack_ram) + SIZEOF(stack_ram); 

__DATA_SRAM_ADDR  = ADDR(.data);
__DATA_SIZE  = __DATA_END - __DATA_SRAM_ADDR;
__SDATA_SIZE = __SDATA_END - __SDATA_RAM;
__BSS_SIZE   = __BSS_END - __BSS_START;
  
/* Labels Used for Initialising SRAM ECC */
__SRAM_SIZE = SRAM_SIZE - (__BSS_START - SRAM_BASE_ADDR);
/* Skip .data section*/
__SRAM_BASE_ADDR = __BSS_START;

__SDATA_ROM_ADDR  = __DATA_ROM_ADDR + __DATA_SIZE;
__SDATA_SRAM_ADDR = __SDATA_RAM;
      
}





