/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.vgt.ide.core;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class VgtProjectNature
implements IProjectNature {
    private static final String GTE_NATURE_ID = "com.nxp.s32ds.gte.core.gtenature";
    private IProject fProject;

    public VgtProjectNature() {
    }

    public VgtProjectNature(IProject project) {
        this.setProject(project);
    }

    public void add() throws CoreException {
        VgtProjectNature.addNature(this.fProject, null);
    }

    public void remove() throws CoreException {
        VgtProjectNature.removeNature(this.fProject, null);
    }

    public static void addNature(IProject project, IProgressMonitor mon) throws CoreException {
        VgtProjectNature.addNature(project, GTE_NATURE_ID, mon);
        VgtProjectNature.configure(project);
    }

    public static void removeNature(IProject project, IProgressMonitor mon) throws CoreException {
        VgtProjectNature.removeNature(project, GTE_NATURE_ID, mon);
    }

    public static void addNature(IProject project, String natureId, IProgressMonitor monitor) throws CoreException {
        String[] prevNatures;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IProjectDescription description = project.getDescription();
        String[] stringArray = prevNatures = description.getNatureIds();
        int n = prevNatures.length;
        int n2 = 0;
        while (n2 < n) {
            String prevNature = stringArray[n2];
            if (natureId.equals(prevNature)) {
                return;
            }
            ++n2;
        }
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        description.setNatureIds(newNatures);
        project.setDescription(description, monitor);
        monitor.done();
    }

    public static void removeNature(IProject project, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] prevNatures = description.getNatureIds();
        ArrayList<String> newNatures = new ArrayList<String>(Arrays.asList(prevNatures));
        newNatures.remove(natureId);
        description.setNatureIds(newNatures.toArray(new String[newNatures.size()]));
        project.setDescription(description, monitor);
    }

    public void configure() throws CoreException {
        VgtProjectNature.configure(this.fProject);
    }

    public static void configure(IProject project) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("com.nxp.s32ds.gte.core.gteBuilder")) {
                return;
            }
            ++i;
        }
        ICommand[] newCommands = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, newCommands, 1, commands.length);
        ICommand command = desc.newCommand();
        command.setBuilderName("com.nxp.s32ds.gte.core.gteBuilder");
        command.setBuilding(6, true);
        command.setBuilding(9, true);
        command.setBuilding(10, true);
        command.setBuilding(15, false);
        newCommands[newCommands.length - 1] = command;
        desc.setBuildSpec(newCommands);
        project.setDescription(desc, null);
    }

    public void deconfigure() throws CoreException {
        this.deconfigure(this.fProject);
    }

    public void deconfigure(IProject project) throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("com.nxp.s32ds.gte.core.gteBuilder")) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                project.setDescription(description, null);
                return;
            }
            ++i;
        }
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }
}

