/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.databinding.validation;

import com.nxp.s32ds.ext.rcp.databinding.internal.validation.ValidationMessages;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class CIdentifierValidator
implements IValidator {
    public static final CIdentifierValidator INSTANCE = new CIdentifierValidator();
    private static final Pattern PATTERN = Pattern.compile("^[a-zA-Z_$][a-zA-Z_$0-9]*$");
    private static final String BUNDLE_SYMBOLIC_NAME = "com.nxp.s32ds.ext.rcp.resources";

    public IStatus validate(Object value) {
        if (!(value instanceof String)) {
            return new Status(4, BUNDLE_SYMBOLIC_NAME, ValidationMessages.CIdentifier_e_name_invalid);
        }
        String name = (String)value;
        if (name.length() == 0) {
            return new Status(4, BUNDLE_SYMBOLIC_NAME, ValidationMessages.CIdentifier_e_name_empty);
        }
        Matcher matcher = PATTERN.matcher(name);
        if (matcher.matches()) {
            return Status.OK_STATUS;
        }
        int i = 0;
        while (i < name.length()) {
            matcher.reset(name.substring(0, i + 1));
            if (!matcher.matches()) {
                String message = "";
                message = i > 0 ? NLS.bind((String)ValidationMessages.CIdentifier_e_name_invalid_character, (Object)Character.valueOf(name.charAt(i)), (Object)name) : NLS.bind((String)ValidationMessages.CIdentifier_e_name_must_begin_alphabet_character, (Object)Character.valueOf(name.charAt(i)), (Object)name);
                return new Status(4, BUNDLE_SYMBOLIC_NAME, message);
            }
            ++i;
        }
        return new Status(4, BUNDLE_SYMBOLIC_NAME, ValidationMessages.CIdentifier_e_name_invalid);
    }
}

