/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.embsysregview.preferences;

import net.miginfocom.swt.MigLayout;
import org.eclipse.cdt.embsysregview.Activator;
import org.eclipse.cdt.embsysregview.core.SortingOrder;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PreferencePageEmbSysBehavior
extends PreferencePage
implements IWorkbenchPreferencePage {
    Button bitbuttons;
    Combo comboLength;
    Combo comboSort;

    public PreferencePageEmbSysBehavior() {
        this.noDefaultAndApplyButton();
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription("How the EmbSysRegisters view should behave");
    }

    public boolean performOk() {
        if (this.bitbuttons != null && this.comboLength != null) {
            int index;
            IPreferenceStore store = this.getPreferenceStore();
            store.setValue("embsys_bitbuttons", this.bitbuttons.getSelection());
            if (this.comboLength.getSelectionIndex() != -1) {
                store.setValue("embsys_combolength", Integer.valueOf(this.comboLength.getItem(this.comboLength.getSelectionIndex())).intValue());
            }
            if ((index = this.comboSort.getSelectionIndex()) != -1) {
                SortingOrder.saveToPreference(index);
            }
        }
        return true;
    }

    private void restoreStoredSettings() {
        IPreferenceStore store = this.getPreferenceStore();
        boolean store_bitbuttons = store.getBoolean("embsys_bitbuttons");
        this.bitbuttons.setSelection(store_bitbuttons);
        int store_combolength = store.getInt("embsys_combolength");
        this.comboLength.setText(String.valueOf(store_combolength));
        this.comboSort.setText(SortingOrder.getFromPreference().getLabel());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new MigLayout("ins 1, gap 1"));
        this.bitbuttons = new Button(composite, 32);
        this.bitbuttons.setLayoutData((Object)"grow, span, wrap 15");
        this.bitbuttons.setText("Binary column Bit Buttons immediate effect");
        this.bitbuttons.setToolTipText("LONG DESCR...");
        this.bitbuttons.setSelection(false);
        Label combolengthLabel = new Label(composite, 0);
        combolengthLabel.setLayoutData((Object)"wrap");
        combolengthLabel.setText("Number of elements shown in drop down List (Interpretations in Hex Column)");
        this.comboLength = new Combo(composite, 4);
        this.comboLength.setLayoutData((Object)"hmin 0, wmin 0, wrap 15");
        this.comboLength.setVisibleItemCount(4);
        this.comboLength.add("5");
        this.comboLength.add("10");
        this.comboLength.add("15");
        this.comboLength.add("20");
        Label sortingLabel = new Label(composite, 0);
        sortingLabel.setLayoutData((Object)"wrap");
        sortingLabel.setText("Bit fields sorting order");
        this.comboSort = new Combo(composite, 4);
        this.comboSort.setLayoutData((Object)"hmin 0, wmin 50, wrap 15");
        this.comboSort.setVisibleItemCount(3);
        SortingOrder.getSortersMap().stream().map(SortingOrder.BitFieldSorter::getLabel).forEach(arg_0 -> ((Combo)this.comboSort).add(arg_0));
        this.restoreStoredSettings();
        return composite;
    }

    public static boolean getBitButtonPref() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getBoolean("embsys_bitbuttons");
    }

    public static int getComboLengthPref() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getInt("embsys_combolength");
    }
}

