/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.embsysregview.internal.ui.view;

import org.eclipse.cdt.embsysregview.core.EmbSysRegEngine;
import org.eclipse.cdt.embsysregview.internal.model.TreeElement;
import org.eclipse.cdt.embsysregview.internal.model.TreeField;
import org.eclipse.cdt.embsysregview.internal.model.TreeRegister;
import org.eclipse.cdt.embsysregview.internal.utils.Utils;
import org.eclipse.cdt.embsysregview.preferences.PreferencePageEmbSysBehavior;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class BinaryButtonsCellEditor
extends CellEditor {
    private Composite composite;
    private TreeElement element;
    private int cellHeight;
    private boolean isInstantApply;
    private Label[] b;
    private EmbSysRegEngine m_engine;
    protected final int THIN_GAP = 2;

    public BinaryButtonsCellEditor(Tree parent, EmbSysRegEngine engine) {
        super((Composite)parent, 0);
        this.m_engine = engine;
    }

    protected Control createControl(Composite parent) {
        RowLayout layout = new RowLayout();
        layout.wrap = false;
        layout.pack = true;
        layout.justify = false;
        layout.type = 256;
        layout.marginLeft = 1;
        layout.marginTop = 2;
        layout.marginRight = 1;
        layout.marginBottom = 1;
        layout.spacing = 0;
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)layout);
        this.cellHeight = ((Tree)parent).getItemHeight();
        this.isInstantApply = PreferencePageEmbSysBehavior.getBitButtonPref();
        return this.composite;
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData data = super.getLayoutData();
        if (this.cellHeight > 0) {
            data.minimumHeight = this.cellHeight + 2;
        }
        return data;
    }

    protected Object doGetValue() {
        return 45054;
    }

    protected void doSetFocus() {
        if (this.composite != null) {
            this.composite.setFocus();
        }
    }

    protected void updateBinaryValue(Object inputData) {
        long value = 0L;
        int i = this.b.length - 1;
        while (i >= 0) {
            value = (value << 1) + (long)Integer.valueOf(this.b[i].getText()).intValue();
            --i;
        }
        if (inputData instanceof TreeRegister) {
            TreeRegister register = (TreeRegister)inputData;
            this.m_engine.setValue(register, value);
        } else if (inputData instanceof TreeField) {
            TreeField registerField = (TreeField)inputData;
            this.m_engine.updateRegisterByField(registerField, value);
        }
    }

    protected void doSetValue(Object value) {
        int bitsize = 0;
        this.element = (TreeElement)value;
        if (this.element instanceof TreeRegister) {
            bitsize = ((TreeRegister)this.element).getBitSize();
        }
        if (this.element instanceof TreeField) {
            bitsize = ((TreeField)this.element).getBitLength();
        }
        this.drawEditor(bitsize);
        if (!this.isInstantApply) {
            this.showSetButton();
        }
    }

    private void drawEditor(int bitsize) {
        this.b = new Label[bitsize];
        int i = bitsize - 1;
        while (i >= 0) {
            this.b[i] = new Label(this.composite, 0x1800000);
            RowData data = new RowData();
            data.width = this.cellHeight * 65 / 100;
            data.height = this.cellHeight - 2;
            this.b[i].setLayoutData((Object)data);
            this.b[i].addMouseListener(new MouseListener(){

                public void mouseUp(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                    Label but = (Label)e.getSource();
                    if (but.getData() == null) {
                        if (but.getText().equals("1")) {
                            but.setText("0");
                        } else {
                            but.setText("1");
                        }
                        if (BinaryButtonsCellEditor.this.isInstantApply) {
                            BinaryButtonsCellEditor.this.updateBinaryValue(BinaryButtonsCellEditor.this.element);
                        }
                    }
                }

                public void mouseDoubleClick(MouseEvent e) {
                }
            });
            this.b[i].setText("-");
            if (this.element instanceof TreeRegister) {
                TreeElement[] children;
                this.b[i].setText(String.valueOf(Utils.getBitFromValue(i, ((TreeRegister)this.element).getValue())));
                if (Utils.getBitFromValue(i, ((TreeRegister)this.element).getReadOnlyMask()) == 1) {
                    this.b[i].setData(new Object());
                }
                this.b[i].setToolTipText("Bit " + i);
                TreeElement[] treeElementArray = children = ((TreeRegister)this.element).getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeField tf;
                    TreeElement child = treeElementArray[n2];
                    if (child instanceof TreeField && i - (tf = (TreeField)child).getBitOffset() >= 0 && i - tf.getBitOffset() <= tf.getBitLength() - 1) {
                        this.b[i].setToolTipText("Bit " + i + ": " + tf.getName());
                    }
                    ++n2;
                }
            }
            if (this.element instanceof TreeField) {
                this.b[i].setText(String.valueOf(Utils.getBitFromValue(i, ((TreeField)this.element).getValue())));
                this.b[i].setToolTipText("Bit " + (i + ((TreeField)this.element).getBitOffset()));
            }
            if (i > 0 && i % 4 == 0) {
                RowData ldata = new RowData();
                int style = 0;
                ldata.width = 3;
                ldata.height = this.cellHeight - 2;
                if (i % 8 == 0) {
                    ldata.width = 7;
                    style = 514;
                }
                Label l = new Label(this.composite, style);
                l.setText(".");
                l.setLayoutData((Object)ldata);
            }
            --i;
        }
    }

    private void showSetButton() {
        Button setButton = new Button(this.composite, 0);
        setButton.setText("Set");
        RowData data = new RowData();
        data.width = 45;
        data.height = this.cellHeight - 2;
        setButton.setLayoutData((Object)data);
        setButton.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                BinaryButtonsCellEditor.this.updateBinaryValue(BinaryButtonsCellEditor.this.element);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }
}

