/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.forms;

import com.pemicro.forms.JFS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class FirmwareUpdate
implements Runnable {
    Display disp;
    Shell shell;
    Shell parentShell;
    public Label picLabel;
    private Image img;
    public Label interfaceDetectedLabel;
    public Label orgFirmLabel;
    public Label curFirmLabel;
    public Label upFirmLabel;
    public Label updateFormLabel;
    public Label orgVerLabel;
    public Label curVerLabel;
    public Label upVerLabel;
    public short javaFirmUpCmd;
    public String javaTitle = "";
    public String interfaceDetectedString = "";
    public String originalFirmwareString = "";
    public String currentFirmwareString = "";
    public String updateFirmwareString = "";
    public String originalVersion = "";
    public String currentVersion = "";
    public String updateVersion = "";
    public short imageInt = 0;
    public short bkgColor = 0;
    public String outs = "";

    public void run() {
        this.disp = PlatformUI.getWorkbench().getDisplay();
        this.parentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (this.javaFirmUpCmd == 0 || this.shell == null || this.shell.isDisposed()) {
            this.shell = new Shell(this.parentShell, 2144);
            this.createContents();
            this.shell.open();
            this.shell.layout();
        }
        if (this.javaFirmUpCmd == 1 && !this.shell.isDisposed()) {
            this.updateContents();
            this.shell.update();
            this.shell.setActive();
        }
        if (this.javaFirmUpCmd == 2) {
            this.setBkgColor(this.bkgColor);
            this.interfaceDetectedLabel.setText(this.interfaceDetectedString);
            this.curVerLabel.setText(this.currentVersion);
            this.shell.update();
            this.shell.setActive();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            this.close();
        }
    }

    public void close() {
        if (!this.shell.isDisposed()) {
            this.shell.dispose();
        }
    }

    private void setBkgColor(short bkgColor) {
        Color color;
        Color defaultColor = new Color((Device)this.disp, JFS.BACKGROUND_GRAY);
        Color maroon = new Color((Device)this.disp, JFS.MAROON);
        Color green = new Color((Device)this.disp, JFS.GREEN);
        switch (bkgColor) {
            case 0: {
                color = defaultColor;
                break;
            }
            case 1: {
                color = green;
                break;
            }
            case 2: {
                color = maroon;
                break;
            }
            default: {
                color = defaultColor;
            }
        }
        this.shell.setBackground(color);
        this.shell.update();
        this.picLabel.update();
        this.interfaceDetectedLabel.update();
        this.orgFirmLabel.update();
        this.curFirmLabel.update();
        this.upFirmLabel.update();
        this.updateFormLabel.update();
        this.orgVerLabel.update();
        this.curVerLabel.update();
        this.upVerLabel.update();
    }

    public void setItems(short javaFirmUpCmd, String javaTitle, String interfaceDetectedString, String originalFirmwareString, String currentFirmwareString, String updateFirmwareString, String originalVersion, String currentVersion, String updateVersion, short imageInt, short bkgColor, String outs) {
        this.javaFirmUpCmd = javaFirmUpCmd;
        this.javaTitle = javaTitle;
        this.interfaceDetectedString = interfaceDetectedString;
        this.originalFirmwareString = originalFirmwareString;
        this.currentFirmwareString = currentFirmwareString;
        this.updateFirmwareString = updateFirmwareString;
        this.originalVersion = originalVersion;
        this.currentVersion = currentVersion;
        this.updateVersion = updateVersion;
        this.imageInt = imageInt;
        this.bkgColor = bkgColor;
        this.outs = outs;
    }

    protected void updateContents() {
        this.updateFormLabel.setText(this.outs);
        this.updateFormLabel.pack();
        this.shell.setBackgroundMode(2);
        this.shell.pack();
    }

    protected void createContents() {
        Rectangle bounds = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getBounds();
        GridLayout layout = new GridLayout(3, false);
        this.shell.setLayout((Layout)layout);
        this.shell.setBackgroundMode(2);
        GridData data = new GridData();
        data.verticalSpan = 5;
        this.picLabel = new Label((Composite)this.shell, 0);
        switch (this.imageInt) {
            case 0: {
                this.img = new Image((Device)this.disp, this.getClass().getResourceAsStream("/images/firmwareUpdate/multilink_universal_small.bmp"));
                break;
            }
            case 1: {
                this.img = new Image((Device)this.disp, this.getClass().getResourceAsStream("/images/firmwareUpdate/parallel_ml_small.bmp"));
                break;
            }
            case 2: {
                this.img = new Image((Device)this.disp, this.getClass().getResourceAsStream("/images/firmwareUpdate/cyclonepro_small.bmp"));
                break;
            }
            case 3: {
                this.img = new Image((Device)this.disp, this.getClass().getResourceAsStream("/images/firmwareUpdate/cyclonemax_small.bmp"));
                break;
            }
            case 4: {
                this.img = new Image((Device)this.disp, this.getClass().getResourceAsStream("/images/firmwareUpdate/tower_image.bmp"));
            }
        }
        this.picLabel.setImage(this.img);
        this.picLabel.setLayoutData((Object)data);
        this.picLabel.pack();
        data = new GridData();
        data.horizontalSpan = 2;
        data.widthHint = 500;
        this.interfaceDetectedLabel = new Label((Composite)this.shell, 64);
        this.interfaceDetectedLabel.setText(this.interfaceDetectedString);
        this.interfaceDetectedLabel.setLayoutData((Object)data);
        this.orgFirmLabel = new Label((Composite)this.shell, 0);
        this.orgVerLabel = new Label((Composite)this.shell, 0);
        this.curFirmLabel = new Label((Composite)this.shell, 0);
        this.curVerLabel = new Label((Composite)this.shell, 0);
        this.upFirmLabel = new Label((Composite)this.shell, 0);
        this.upVerLabel = new Label((Composite)this.shell, 0);
        data = new GridData();
        data.horizontalSpan = 2;
        this.updateFormLabel = new Label((Composite)this.shell, 64);
        this.updateFormLabel.setLayoutData((Object)data);
        this.shell.setText(this.javaTitle);
        this.interfaceDetectedLabel.pack();
        this.orgFirmLabel.setText(this.originalFirmwareString);
        this.curFirmLabel.setText(this.currentFirmwareString);
        this.upFirmLabel.setText(this.updateFirmwareString);
        this.orgVerLabel.setText(this.originalVersion);
        this.curVerLabel.setText(this.currentVersion);
        this.upVerLabel.setText(this.updateVersion);
        this.updateFormLabel.setText(this.outs);
        this.updateFormLabel.pack();
        this.orgVerLabel.setForeground(new Color((Device)this.disp, JFS.BLUE));
        this.curVerLabel.setForeground(new Color((Device)this.disp, JFS.BLUE));
        this.upVerLabel.setForeground(new Color((Device)this.disp, JFS.BLUE));
        this.shell.pack();
        this.shell.setLocation(bounds.x + (bounds.width - this.shell.getSize().x) / 2, bounds.y + (bounds.height - this.shell.getSize().y) / 2);
        this.setBkgColor(this.bkgColor);
        if (this.imageInt != 0) {
            data = new GridData();
            data.exclude = true;
            this.orgFirmLabel.setVisible(false);
            this.orgFirmLabel.setLayoutData((Object)data);
            data = new GridData();
            data.exclude = true;
            this.orgVerLabel.setVisible(false);
            this.orgVerLabel.setLayoutData((Object)data);
        }
    }
}

