/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.corePlugin;

import com.pemicro.corePlugin.MyCallback;
import com.pemicro.corePlugin.PException;
import com.pemicro.debugView.CoreDebug;
import com.pemicro.forms.ProcessWindow;

public class JLink {
    private byte byteValue = 0;
    private short wordValue = 0;
    private int longValue = 0;
    private String stringValue = "";
    private boolean booleanValue = false;
    private static final byte SUPPORTED_COMMAND = 1;
    private static final byte UNSUPPORTED_COMMAND = -1;
    public static final int javaDialogMaxPacketSize = 8192;
    public static final int javaDialogTppickWindow = 1;
    public static final int javaDialogBdcPowerDialog = 2;
    public static final int javaDialogInputQuery = 3;
    public static final int javaDialogMessageDialog = 4;
    public static final int javaDialogAdvProgrammingOptions = 5;
    public static final int javaDialogFirmwareUpdate = 7;
    public static final int javaDialogRS08Ports = 8;
    public static final int javaDialogCycles = 9;
    public static final int javaDialogHCS08Ports = 10;
    public static final int javaDialogAddEthernetIP = 11;
    public static final int javaDialogAskProgramFlash = 13;
    public static final int javaDialogInputWindow = 16;
    public static final int javaDialogConnectionAssistant = 17;
    public static final int javaDialogCProgStatus = 20;
    public static final int javaDialogChipWindow = 21;
    public static final int javaDialogOpenURL = 22;
    public static final int javaDialogOpenView = 23;
    public static final int javaDialogGetProjectPath = 24;
    public static final int javaDialogLCFWrite = 25;
    public static final int javaDialogUnsecureWindow = 26;
    public static final int javaDialogLCFRead = 27;
    public static final int javaDialogMenuSetup = 48;
    private int dialogNumber;
    private byte[] inBuffer;
    private int inBufferIndex = 0;
    private boolean inBufferValid = false;
    private int inBufferLength = 0;
    private byte[] outBuffer;
    private int outBufferLength = 0;
    private int packetNumber = 0;
    private int sessionNumber = 0;
    private ProcessWindow processWindow;
    private MyCallback callback = null;

    public JLink() {
        CoreDebug.initialize();
    }

    private void resetInputBufferToBeginning() throws PException {
        this.inBufferIndex = 0;
        this.inBufferValid = false;
        this.inBufferLength = 0;
        if (this.inBuffer[0] != -86) {
            throw new PException("Error in Unique Identifier");
        }
        if (this.inBuffer[1] != 85) {
            throw new PException("Error in Unique Identifier");
        }
        if (this.inBuffer[2] != 1) {
            throw new PException("Unsupported packet version");
        }
        this.inBufferLength = (this.inBuffer[3] << 24 & 0xFF000000) + (this.inBuffer[4] << 16 & 0xFF0000) + (this.inBuffer[5] << 8 & 0xFF00) + (this.inBuffer[6] & 0xFF);
        this.packetNumber = (this.inBuffer[7] << 24 & 0xFF000000) + (this.inBuffer[8] << 16 & 0xFF0000) + (this.inBuffer[9] << 8 & 0xFF00) + (this.inBuffer[10] & 0xFF);
        this.sessionNumber = (this.inBuffer[11] << 24 & 0xFF000000) + (this.inBuffer[12] << 16 & 0xFF0000) + (this.inBuffer[13] << 8 & 0xFF00) + (this.inBuffer[14] & 0xFF);
        if (this.inBufferLength < 11 || this.inBufferLength >= 8192) {
            throw new PException("Error in packet size");
        }
        this.inBufferIndex = 11;
        this.inBufferValid = true;
        this.readLong();
        this.readLong();
        this.readLong();
    }

    private boolean processRequestedCall() throws PException {
        this.setDialogNumber(this.readWord());
        CoreDebug.writeDebugNoLn(1, "Dialog = " + this.getDialogNumber() + ": ");
        if (this.processWindow == null) {
            this.processWindow = new ProcessWindow(this.callback);
        }
        this.processWindow.configureProcessWindow(this);
        switch (this.getDialogNumber()) {
            case 1: {
                CoreDebug.writeDebug(0, "PICK WINDOW");
                return this.processWindow.processTpPickWindow();
            }
            case 2: {
                CoreDebug.writeDebug(0, "POWER DIALOG");
                return this.processWindow.processBdcPowerDialog();
            }
            case 3: {
                CoreDebug.writeDebug(0, "INPUT QUERY");
                return this.processWindow.processInputQuery();
            }
            case 4: {
                CoreDebug.writeDebug(0, "MESSAGE DLG");
                return this.processWindow.processMessageDialog();
            }
            case 5: {
                CoreDebug.writeDebug(0, "ADV PRG DLG");
                return this.processWindow.processAdvProgrammingOptions();
            }
            case 17: {
                CoreDebug.writeDebug(0, "CONNECTION ASSISTANT");
                return this.processWindow.processConnectionAssistant();
            }
            case 7: {
                CoreDebug.writeDebug(0, "FIRMWARE UPDATE");
                return this.processWindow.processFirmwareUpdate();
            }
            case 8: {
                CoreDebug.writeDebug(0, "RS08 Ports");
                return this.processWindow.processRS08Ports();
            }
            case 9: {
                CoreDebug.writeDebug(0, "Cycles");
                return this.processWindow.processCycles();
            }
            case 10: {
                CoreDebug.writeDebug(0, "HCS08 Ports");
                return this.processWindow.processHCS08Ports();
            }
            case 11: {
                CoreDebug.writeDebug(0, "Add Ethernet");
                return this.processWindow.processAddEthernetIP();
            }
            case 13: {
                CoreDebug.writeDebug(0, "Ask Program Flash");
                return this.processWindow.processAskProgramFlash();
            }
            case 16: {
                CoreDebug.writeDebug(0, "Input Window");
                return this.processWindow.processInputs();
            }
            case 20: {
                CoreDebug.writeDebug(0, "CProg status");
                return this.processWindow.processCProgStatus();
            }
            case 21: {
                CoreDebug.writeDebug(0, "Chip Window");
                if (this.sessionNumber == 1) {
                    return this.processWindow.processChipWindow();
                }
                this.writeWord((short)21);
                this.writeWord((short)1);
                this.writeWord((short)7);
                return true;
            }
            case 48: {
                CoreDebug.writeDebug(0, "Menu");
                return this.processWindow.processMenuSetup();
            }
            case 22: {
                CoreDebug.writeDebug(0, "Open URL");
                return this.processWindow.processOpenURL();
            }
            case 23: {
                CoreDebug.writeDebug(0, "Open View");
                return this.processWindow.processOpenView();
            }
            case 24: {
                CoreDebug.writeDebug(0, "Get Project Path");
                return this.processWindow.processGetProjectPath();
            }
            case 25: {
                CoreDebug.writeDebug(0, "LCF Write");
                return this.processWindow.processLCFWrite();
            }
            case 26: {
                CoreDebug.writeDebug(0, "Unsecure Window");
                return this.processWindow.processUnsecureWindow();
            }
            case 27: {
                CoreDebug.writeDebug(0, "LCF Read");
                return this.processWindow.processLCFRead();
            }
        }
        return this.processWindow.unsupportedCommand();
    }

    public int getSession() {
        return this.sessionNumber;
    }

    public byte[] doSomethingWithBuffer(byte[] inStream) {
        try {
            try {
                this.inBuffer = inStream;
                this.resetInputBufferToBeginning();
                this.initializeOutBuffer();
                this.outBuffer[7] = (byte)(this.inBuffer[7] & 0xFF ^ 0xFF);
                this.outBuffer[8] = (byte)(this.inBuffer[8] & 0xFF ^ 0xFF);
                this.outBuffer[9] = (byte)(this.inBuffer[9] & 0xFF ^ 0xFF);
                this.outBuffer[10] = (byte)(this.inBuffer[10] & 0xFF ^ 0xFF);
                this.processRequestedCall();
                this.outBuffer[3] = (byte)(this.outBufferLength >> 24 & 0xFF);
                this.outBuffer[4] = (byte)(this.outBufferLength >> 16 & 0xFF);
                this.outBuffer[5] = (byte)(this.outBufferLength >> 8 & 0xFF);
                this.outBuffer[6] = (byte)(this.outBufferLength & 0xFF);
            }
            catch (PException e) {
                e.printStackTrace(System.err);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        catch (Throwable throwable) {}
        return this.outBuffer;
    }

    private void initializeOutBuffer() throws PException {
        this.outBufferLength = 0;
        this.outBuffer = new byte[8192];
        this.outBuffer[3] = -18;
        this.outBuffer[4] = -18;
        this.outBuffer[5] = -18;
        this.outBuffer[6] = -18;
        this.writeWord((short)-17562);
        this.writeByte((byte)1);
        this.writeLong(0);
        this.writeLong(0);
        this.writeLong(0);
        this.writeLong(0);
        this.writeLong(0);
    }

    public void writeByte(byte value) throws PException {
        if (this.outBufferLength >= 8192) {
            throw new PException("Incorrect bufferLength value");
        }
        this.outBuffer[this.outBufferLength++] = value;
    }

    public void writeWord(short value) throws PException {
        this.writeByte((byte)(value >> 8));
        this.writeByte((byte)value);
    }

    public void writeLong(int value) throws PException {
        this.writeByte((byte)(value >> 24));
        this.writeByte((byte)(value >> 16));
        this.writeByte((byte)(value >> 8));
        this.writeByte((byte)value);
    }

    public void writeString(String value) throws PException {
        this.writeByte((byte)value.length());
        int i = 1;
        while (i <= value.length()) {
            this.writeByte((byte)value.charAt(i - 1));
            ++i;
        }
    }

    public void writeBoolean(boolean value) throws PException {
        if (value) {
            this.writeByte((byte)-1);
        } else {
            this.writeByte((byte)0);
        }
    }

    public byte readByte() throws PException {
        this.byteValue = 0;
        if (!this.inBufferValid) {
            throw new PException("Invalid Buffer");
        }
        if (this.inBufferIndex > this.inBufferLength) {
            throw new PException("Invalid Buffer Length");
        }
        this.byteValue = this.inBuffer[this.inBufferIndex++];
        return this.byteValue;
    }

    public short readWord() throws PException {
        this.byteValue = 0;
        this.wordValue = 0;
        this.wordValue = (short)((short)(this.readByte() & 0xFF) << 8);
        this.wordValue = (short)(this.wordValue | (short)(this.readByte() & 0xFF));
        return this.wordValue;
    }

    public int readLong() throws PException {
        this.wordValue = 0;
        this.longValue = 0;
        this.longValue = this.readWord() << 16;
        this.longValue |= this.readWord();
        return this.longValue;
    }

    public String readString() throws PException {
        int length = this.readByte() & 0xFF;
        StringBuffer str = new StringBuffer(length + 1);
        int i = 1;
        while (i <= length) {
            str.append((char)this.readByte());
            ++i;
        }
        this.stringValue = str.toString().replaceAll("\t", "  ");
        return this.stringValue;
    }

    public boolean readBoolean() throws PException {
        this.byteValue = 0;
        this.booleanValue = false;
        this.booleanValue = this.readByte() != 0;
        return this.booleanValue;
    }

    public void setCallback(MyCallback callback) {
        this.callback = callback;
        if (this.processWindow != null) {
            this.processWindow.setCallback(callback);
        }
    }

    public void setDialogNumber(int dialogNumber) {
        this.dialogNumber = dialogNumber;
    }

    public int getDialogNumber() {
        return this.dialogNumber;
    }
}

