/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.vgt.ide.ui.viewers;

import com.nxp.s32ds.vgt.ide.core.VgtIdeCore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class EnumeratorContentProvider
implements IStructuredContentProvider {
    private static final Object[] NO_OBJECTS = new Object[0];
    private final List<String> suppressed;

    public EnumeratorContentProvider(EStructuralFeature feature) {
        this.suppressed = VgtIdeCore.getSuppressLiterals((EModelElement)feature);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof Enumerator[]) {
            Enumerator[] enumerators = (Enumerator[])inputElement;
            List<Enumerator> list = Arrays.asList(enumerators);
            return this.suppress(list);
        }
        if (inputElement instanceof Collection) {
            Collection collection = (Collection)inputElement;
            return this.suppress(collection);
        }
        return NO_OBJECTS;
    }

    private Object[] suppress(Collection<?> collection) {
        if (collection.isEmpty()) {
            return NO_OBJECTS;
        }
        ArrayList<Enumerator> enumerators = new ArrayList<Enumerator>();
        for (Object object : collection) {
            Enumerator enumerator;
            String literal;
            if (!(object instanceof Enumerator) || this.suppressed.contains(literal = (enumerator = (Enumerator)object).getLiteral())) continue;
            enumerators.add(enumerator);
        }
        return enumerators.toArray();
    }
}

