/**************************************************************************
 * FILE NAME: MPC577xC.h                     COPYRIGHT (c) Freescale 2015 *
 * REVISION:  4.0.0                                   All Rights Reserved *
 *                                                                        *
 * DESCRIPTION:                                                           *
 * This file contains all of the register and bit field definitions for   *
 * the MPC577xC.                                                          *
 *========================================================================*
 * UPDATE HISTORY                                                         *
 * REV      AUTHOR      DATE       DESCRIPTION OF CHANGE                  *
 * ---   -----------  ---------    ---------------------                  *
 * 0.8.0  M. Doidge  16/Sep/2013  Generated from SIDSC                    *
 * 0.8.1  M. Doidge  23/Oct/2013  Generated from draft RDP                *
 * 0.8.2  M. Doidge  25/Oct/2013  Added SIU                               *
 * 0.8.3  M. Doidge  29/Oct/2013  Updated with corrections to SIU, REACM2,*
 *                                eDMA and SDADC                          *
 * 1.0.0  M. Doidge  21/Nov/2013  Generated from RDP v1.0                 *
 *                                                                        *
 * 1.0.1  M. Doidge  27/Nov/2013  Resolved multiple reg def in IGF        *
 *                                                                        *
 * 1.0.2  M. Doidge  27/Feb/2014  Added eMIOS_UC                          *
 *                                                                        *
 * 2.0.0  M. Doidge  03/Jul/2014  Generated from RDP v2.0                 *
 *                                                                        *
 * 3.0.0  M. Doidge  17/Feb/2014  Generated from RDP v3.0                 *
 *                                                                        *
 * 3.0.1  M. Doidge  17/Feb/2014  Generated from RDP v3.0 with corrected  *
 *                                filters file for SIU module             *
 *                                                                        *
 * 4.0.0  M. Doidge  15/Jul/2015  Generated from RDP v4.0                 *
 *                                                                        *
 *========================================================================*
 * COPYRIGHT:                                                             *
 *  Freescale Semiconductor, INC. All Rights Reserved. You are hereby     *
 *  granted a copyright license to use, modify, and distribute the        *
 *  SOFTWARE so long as this entire notice is retained without alteration *
 *  in any modified and/or redistributed versions, and that such modified *
 *  versions are clearly identified as such. No licenses are granted by   *
 *  implication, estoppel or otherwise under any patentsor trademarks     *
 *  of Freescale Semiconductor, Inc. This software is provided on an      *
 *  "AS IS" basis and without warranty.                                   *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, Freescale          *
 *  Semiconductor DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED,    *
 *  INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A      *
 *  PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD  *
 *  TO THE SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY     *
 *  ACCOMPANYING WRITTEN MATERIALS.                                       *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, IN NO EVENT        *
 *  SHALL Freescale Semiconductor BE LIABLE FOR ANY DAMAGES WHATSOEVER    *
 *  (INCLUDING WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,  *
 *  BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER         *
 *  PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.  *
 *                                                                        *
 *  Freescale Semiconductor assumes no responsibility for the             *
 *  maintenance and support of this software                              *
 *                                                                        *
 **************************************************************************/
/*>>>>>>> NOTE! this file is auto-generated please do not edit it! <<<<<<<*/

/**************************************************************************
 * Example register & bit field write:                                    *
 *                                                                        *
 *  <MODULE>.<REGISTER>.B.<BIT> = 1;                                      *
 *  <MODULE>.<REGISTER>.R       = 0x10000000;                             *
 *                                                                        *
 **************************************************************************/

#ifndef _MPC577xC_H_
#define _MPC577xC_H_
#include "typedefs.h"
#ifdef __cplusplus
extern "C" {
#endif
#ifdef __MWERKS__
#pragma push
#pragma ANSI_strict off
#endif
#ifdef __ghs__
#pragma ghs nowarning 618
#endif


/* ============================================================================
   =============================== Module: AIPS ===============================
   ============================================================================ */

typedef union AIPS_MPRA_union_tag {    /* Master Privilege Register A */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MTR0:1;                  /* Master 0 Trusted For Read */
    vuint32_t MTW0:1;                  /* Master 0 Trusted For Writes */
    vuint32_t MPL0:1;                  /* Master 0 Privilege Level */
    vuint32_t  :1;
    vuint32_t MTR1:1;                  /* Master 1 Trusted for Read */
    vuint32_t MTW1:1;                  /* Master 1 Trusted for Writes */
    vuint32_t MPL1:1;                  /* Master 1 Privilege Level */
    vuint32_t  :1;
    vuint32_t MTR2:1;                  /* Master 2 Trusted For Read */
    vuint32_t MTW2:1;                  /* Master 2 Trusted For Writes */
    vuint32_t MPL2:1;                  /* Master 2 Privilege Level */
    vuint32_t  :1;
    vuint32_t MTR3:1;                  /* Master 3 Trusted For Read */
    vuint32_t MTW3:1;                  /* Master 3 Trusted For Writes */
    vuint32_t MPL3:1;                  /* Master 3 Privilege Level */
    vuint32_t  :1;
    vuint32_t MTR4:1;                  /* Master 4 Trusted For Read */
    vuint32_t MTW4:1;                  /* Master 4 Trusted For Writes */
    vuint32_t MPL4:1;                  /* Master 4 Privilege Level */
    vuint32_t  :1;
    vuint32_t MTR5:1;                  /* Master 5 Trusted For Read */
    vuint32_t MTW5:1;                  /* Master 5 Trusted For Writes */
    vuint32_t MPL5:1;                  /* Master 5 Privilege Level */
    vuint32_t  :1;
    vuint32_t MTR6:1;                  /* Master 6 Trusted for Read */
    vuint32_t MTW6:1;                  /* Master 6 Trusted for Writes */
    vuint32_t MPL6:1;                  /* Master 6 Privilege Level */
    vuint32_t  :4;
  } B;
} AIPS_MPRA_tag;

typedef union AIPS_MPRB_union_tag {    /* Master Privilege Register B */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MTR8:1;                  /* Master 8 Trusted for Read */
    vuint32_t MTW8:1;                  /* Master 8 Trusted for Writes */
    vuint32_t MPL8:1;                  /* Master 8 Privilege Level */
    vuint32_t  :1;
    vuint32_t MTR9:1;                  /* Master 9 Trusted for Read */
    vuint32_t MTW9:1;                  /* Master 9 Trusted for Writes */
    vuint32_t MPL9:1;                  /* Master 9 Privilege Level */
    vuint32_t  :4;
    vuint32_t  :4;
    vuint32_t  :4;
    vuint32_t  :4;
    vuint32_t  :4;
    vuint32_t  :4;
  } B;
} AIPS_MPRB_tag;

typedef union AIPS_PACR_union_tag {    /* Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t  :1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t  :1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t  :1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t  :1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t  :1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t  :1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t  :1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_PACR_tag;

typedef union AIPS_OPACR_union_tag {   /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t  :1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t  :1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t  :1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t  :1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t  :1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t  :1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t  :1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_OPACR_tag;

struct AIPS_tag {
  AIPS_MPRA_tag MPRA;                  /* Master Privilege Register A */
  AIPS_MPRB_tag MPRB;                  /* Master Privilege Register B */
  uint8_t AIPS_reserved0[24];
  AIPS_PACR_tag PACR[4];               /* Peripheral Access Control Register */
  uint8_t AIPS_reserved1[16];
  AIPS_OPACR_tag OPACR[8];             /* Off-Platform Peripheral Access Control Register */
};


/* ============================================================================
   =============================== Module: C55FMC =============================
   ============================================================================ */

typedef union C55FMC_MCR_union_tag {   /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t RVE:1;                   /* Read Voltage Error */
    vuint32_t RRE:1;                   /* Read Reference Error */
    vuint32_t AEE:1;                   /* Address Encode Error */
    vuint32_t EEE:1;                   /* ECC after ECC Error */
    vuint32_t  :12;
    vuint32_t EER:1;                   /* ECC Event Error */
    vuint32_t RWE:1;                   /* Read-While-Write Event Error */
    vuint32_t SBC:1;                   /* Single Bit Correction */
    vuint32_t  :1;
    vuint32_t PEAS:1;                  /* Program Access Space */
    vuint32_t DONE:1;                  /* State Machine Status */
    vuint32_t PEG:1;                   /* Program/Erase Good */
    vuint32_t PECIE:1;                 /* Program/Erase Complete Interrupt Enable */
    vuint32_t  :3;
    vuint32_t PGM:1;                   /* Program */
    vuint32_t PSUS:1;                  /* Program Suspend */
    vuint32_t ERS:1;                   /* Erase */
    vuint32_t ESUS:1;                  /* Erase Suspend */
    vuint32_t EHV:1;                   /* Enable High Voltage */
  } B;
} C55FMC_MCR_tag;

typedef union C55FMC_MCRE_union_tag {  /* Extended Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t HT:1;                    /* High Temperature Enabled. */
    vuint32_t  :2;
    vuint32_t n256K:5;
    vuint32_t n64Kh:3;
    vuint32_t n32Kh:2;
    vuint32_t n16Kh:3;
    vuint32_t n64Km:3;
    vuint32_t n32Km:2;
    vuint32_t n16Km:3;
    vuint32_t n64Kl:3;
    vuint32_t n32Kl:2;
    vuint32_t n16Kl:3;
  } B;
} C55FMC_MCRE_tag;

typedef union C55FMC_LOCK0_union_tag { /* Lock 0 register */
  vuint32_t R;
  struct {
    vuint32_t TSLOCK:1;                /* UTest NVM Lock. */
    vuint32_t  :1;
    vuint32_t LOWLOCK:14;              /* Low Block Lock */
    vuint32_t MIDLOCK:16;              /* Mid Block Lock */
  } B;
} C55FMC_LOCK0_tag;

typedef union C55FMC_LOCK1_union_tag { /* Lock 1 register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t HIGHLOCK:16;             /* High Block Lock */
  } B;
} C55FMC_LOCK1_tag;

typedef union C55FMC_LOCK2_union_tag { /* Lock 2 register */
  vuint32_t R;
  struct {
    vuint32_t A256KLOCK:32;            /* 256 KB Block Lock */
  } B;
} C55FMC_LOCK2_tag;

typedef union C55FMC_LOCK3_union_tag { /* Lock 3 register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t A256KLOCK:16;            /* 256 KB Block Lock */
  } B;
} C55FMC_LOCK3_tag;

typedef union C55FMC_SEL0_union_tag {  /* Select 0 register */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t LOWSEL:14;               /* LOW Block Select. */
    vuint32_t MIDSEL:16;               /* Mid Block Select. */
  } B;
} C55FMC_SEL0_tag;

typedef union C55FMC_SEL1_union_tag {  /* Select 1 register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t HIGHSEL:16;              /* High Block Select. */
  } B;
} C55FMC_SEL1_tag;

typedef union C55FMC_SEL2_union_tag {  /* Select 2 register */
  vuint32_t R;
  struct {
    vuint32_t A256KSEL:32;             /* 256 KB Block Select. */
  } B;
} C55FMC_SEL2_tag;

typedef union C55FMC_SEL3_union_tag {  /* Select 3 register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t A256KSEL:16;             /* 256 KB Block Select. */
  } B;
} C55FMC_SEL3_tag;

typedef union C55FMC_ADR_union_tag {   /* Address register */
  vuint32_t R;
  struct {
    vuint32_t SAD:1;
    vuint32_t aH:1;
    vuint32_t aM:1;
    vuint32_t aL:1;
    vuint32_t a256k:1;
    vuint32_t a64k:1;
    vuint32_t a32k:1;
    vuint32_t a16k:1;
    vuint32_t ADDR:21;
    vuint32_t  :3;
  } B;
} C55FMC_ADR_tag;

typedef union C55FMC_UT0_union_tag {   /* UTest 0 register */
  vuint32_t R;
  struct {
    vuint32_t UTE:1;
    vuint32_t SBCE:1;
    vuint32_t  :11;
    vuint32_t CPR:1;
    vuint32_t CPA:1;
    vuint32_t CPE:1;
    vuint32_t  :6;
    vuint32_t NAIBP:1;
    vuint32_t AIBPE:1;
    vuint32_t  :1;
    vuint32_t AISUS:1;
    vuint32_t MRE:1;
    vuint32_t MRV:1;
    vuint32_t  :1;
    vuint32_t AIS:1;
    vuint32_t AIE:1;
    vuint32_t AID:1;
  } B;
} C55FMC_UT0_tag;

typedef union C55FMC_UM_union_tag {    /* UMISR register */
  vuint32_t R;
  struct {
    vuint32_t MISR:32;
  } B;
} C55FMC_UM_tag;

typedef union C55FMC_UM9_union_tag {   /* UMISR register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t MISR:1;                  /* MISR[288]. */
  } B;
} C55FMC_UM9_tag;

typedef union C55FMC_OPP0_union_tag {  /* Over-Program Protection 0 register */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t LOWOPP:14;               /* Low Block Over-Program Protection[13:0]. */
    vuint32_t MIDOPP:16;               /* Mid Block Over-Program Protection[15:0]. */
  } B;
} C55FMC_OPP0_tag;

typedef union C55FMC_OPP1_union_tag {  /* Over-Program Protection 1 register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t HIGHOPP:16;              /* High Block Over-Program Protection[15:0]. */
  } B;
} C55FMC_OPP1_tag;

typedef union C55FMC_OPP2_union_tag {  /* Over-Program Protection 2 register */
  vuint32_t R;
  struct {
    vuint32_t A256KOPP:32;             /* 256K Block Over-Program Protection[31:0]. */
  } B;
} C55FMC_OPP2_tag;

typedef union C55FMC_OPP3_union_tag {  /* Over-Program Protection 3 register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t A256KOPP:16;             /* 256K Block Over-Program Protection[47:32]. */
  } B;
} C55FMC_OPP3_tag;

typedef union C55FMC_TMD_union_tag {   /* Test Mode Disable Password Check register */
  vuint32_t R;
  struct {
    vuint32_t PWD:32;                  /* Password challenge */
  } B;
} C55FMC_TMD_tag;

struct C55FMC_tag {
  C55FMC_MCR_tag MCR;                  /* Module Configuration Register */
  uint8_t C55FMC_reserved0[4];
  C55FMC_MCRE_tag MCRE;                /* Extended Module Configuration Register */
  uint8_t C55FMC_reserved1[4];
  C55FMC_LOCK0_tag LOCK0;              /* Lock 0 register */
  C55FMC_LOCK1_tag LOCK1;              /* Lock 1 register */
  C55FMC_LOCK2_tag LOCK2;              /* Lock 2 register */
  C55FMC_LOCK3_tag LOCK3;              /* Lock 3 register */
  uint8_t C55FMC_reserved2[24];
  C55FMC_SEL0_tag SEL0;                /* Select 0 register */
  C55FMC_SEL1_tag SEL1;                /* Select 1 register */
  C55FMC_SEL2_tag SEL2;                /* Select 2 register */
  C55FMC_SEL3_tag SEL3;                /* Select 3 register */
  uint8_t C55FMC_reserved3[8];
  C55FMC_ADR_tag ADR;                  /* Address register */
  C55FMC_UT0_tag UT0;                  /* UTest 0 register */
  C55FMC_UM_tag UM[9];                 /* UMISR register */
  C55FMC_UM9_tag UM9;                  /* UMISR register */
  C55FMC_OPP0_tag OPP0;                /* Over-Program Protection 0 register */
  C55FMC_OPP1_tag OPP1;                /* Over-Program Protection 1 register */
  C55FMC_OPP2_tag OPP2;                /* Over-Program Protection 2 register */
  C55FMC_OPP3_tag OPP3;                /* Over-Program Protection 3 register */
  C55FMC_TMD_tag TMD;                  /* Test Mode Disable Password Check register */
};


/* ============================================================================
   =============================== Module: CAN ================================
   ============================================================================ */

typedef union CAN_MCR_union_tag {      /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze Enable */
    vuint32_t RFEN:1;                  /* Rx FIFO Enable */
    vuint32_t HALT:1;                  /* Halt FlexCAN */
    vuint32_t NOTRDY:1;                /* FlexCAN Not Ready */
    vuint32_t  :1;
    vuint32_t SOFTRST:1;               /* Soft Reset */
    vuint32_t FRZACK:1;                /* Freeze Mode Acknowledge */
    vuint32_t SUPV:1;                  /* Supervisor Mode */
    vuint32_t  :1;
    vuint32_t WRNEN:1;                 /* Warning Interrupt Enable */
    vuint32_t LPMACK:1;                /* Low-Power Mode Acknowledge */
    vuint32_t  :1;
    vuint32_t DOZE:1;                  /* Doze Mode Enable */
    vuint32_t SRXDIS:1;                /* Self Reception Disable */
    vuint32_t IRMQ:1;                  /* Individual Rx Masking And Queue Enable */
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t LPRIOEN:1;               /* Local Priority Enable */
    vuint32_t AEN:1;                   /* Abort Enable */
    vuint32_t  :2;
    vuint32_t IDAM:2;                  /* ID Acceptance Mode */
    vuint32_t  :1;
    vuint32_t MAXMB:7;                 /* Number Of The Last Message Buffer */
  } B;
} CAN_MCR_tag;

typedef union CAN_CTRL1_union_tag {    /* Control 1 register */
  vuint32_t R;
  struct {
    vuint32_t PRESDIV:8;               /* Prescaler Division Factor */
    vuint32_t RJW:2;                   /* Resync Jump Width */
    vuint32_t PSEG1:3;                 /* Phase Segment 1 */
    vuint32_t PSEG2:3;                 /* Phase Segment 2 */
    vuint32_t BOFFMSK:1;               /* Bus Off Mask */
    vuint32_t ERRMSK:1;                /* Error Mask */
    vuint32_t CLKSRC:1;                /* CAN Engine Clock Source */
    vuint32_t LPB:1;                   /* Loop Back Mode */
    vuint32_t TWRNMSK:1;               /* Tx Warning Interrupt Mask */
    vuint32_t RWRNMSK:1;               /* Rx Warning Interrupt Mask */
    vuint32_t  :2;
    vuint32_t SMP:1;                   /* CAN Bit Sampling */
    vuint32_t BOFFREC:1;               /* Bus Off Recovery */
    vuint32_t TSYN:1;                  /* Timer Sync */
    vuint32_t LBUF:1;                  /* Lowest Buffer Transmitted First */
    vuint32_t LOM:1;                   /* Listen-Only Mode */
    vuint32_t PROPSEG:3;               /* Propagation Segment */
  } B;
} CAN_CTRL1_tag;

typedef union CAN_TIMER_union_tag {    /* Free Running Timer */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t TIMER:16;                /* Timer Value */
  } B;
} CAN_TIMER_tag;

typedef union CAN_RXMGMASK_union_tag { /* Rx Mailboxes Global Mask Register */
  vuint32_t R;
  struct {
    vuint32_t MG:32;                   /* Rx Mailboxes Global Mask Bits */
  } B;
} CAN_RXMGMASK_tag;

typedef union CAN_RX14MASK_union_tag { /* Rx 14 Mask register */
  vuint32_t R;
  struct {
    vuint32_t RX14M:32;                /* Rx Buffer 14 Mask Bits */
  } B;
} CAN_RX14MASK_tag;

typedef union CAN_RX15MASK_union_tag { /* Rx 15 Mask register */
  vuint32_t R;
  struct {
    vuint32_t RX15M:32;                /* Rx Buffer 15 Mask Bits */
  } B;
} CAN_RX15MASK_tag;

typedef union CAN_ECR_union_tag {      /* Error Counter */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t RXERRCNT:8;              /* Receive Error Counter */
    vuint32_t TXERRCNT:8;              /* Transmit Error Counter */
  } B;
} CAN_ECR_tag;

typedef union CAN_ESR1_union_tag {     /* Error and Status 1 register */
  vuint32_t R;
  struct {
    vuint32_t  :13;
    vuint32_t SYNCH:1;                 /* CAN Synchronization Status */
    vuint32_t TWRNINT:1;               /* Tx Warning Interrupt Flag */
    vuint32_t RWRNINT:1;               /* Rx Warning Interrupt Flag */
    vuint32_t BIT1ERR:1;               /* Bit1 Error */
    vuint32_t BIT0ERR:1;               /* Bit0 Error */
    vuint32_t ACKERR:1;                /* Acknowledge Error */
    vuint32_t CRCERR:1;                /* Cyclic Redundancy Check Error */
    vuint32_t FRMERR:1;                /* Form Error */
    vuint32_t STFERR:1;                /* Stuffing Error */
    vuint32_t TXWRN:1;                 /* TX Error Warning */
    vuint32_t RXWRN:1;                 /* Rx Error Warning */
    vuint32_t IDLE:1;
    vuint32_t TX:1;                    /* FlexCAN In Transmission */
    vuint32_t FLTCONF:2;               /* Fault Confinement State */
    vuint32_t RX:1;                    /* FlexCAN In Reception */
    vuint32_t BOFFINT:1;               /* Bus Off Interrupt */
    vuint32_t ERRINT:1;                /* Error Interrupt */
    vuint32_t  :1;
  } B;
} CAN_ESR1_tag;

typedef union CAN_IMASK2_union_tag {   /* Interrupt Masks 2 register */
  vuint32_t R;
  struct {
    vuint32_t BUFHM:32;                /* Buffer MB i Mask */
  } B;
} CAN_IMASK2_tag;

typedef union CAN_IMASK1_union_tag {   /* Interrupt Masks 1 register */
  vuint32_t R;
  struct {
    vuint32_t BUFLM:32;                /* Buffer MB i Mask */
  } B;
} CAN_IMASK1_tag;

typedef union CAN_IFLAG2_union_tag {   /* Interrupt Flags 2 register */
  vuint32_t R;
  struct {
    vuint32_t BUFHI:32;                /* Buffer MB i Interrupt */
  } B;
} CAN_IFLAG2_tag;

typedef union CAN_IFLAG1_union_tag {   /* Interrupt Flags 1 register */
  vuint32_t R;
  struct {
    vuint32_t BUF31TO8I:24;            /* Buffer MBi Interrupt */
    vuint32_t BUF7I:1;                 /* Buffer MB7 Interrupt Or "Rx FIFO Overflow" */
    vuint32_t BUF6I:1;                 /* Buffer MB6 Interrupt Or "Rx FIFO Warning" */
    vuint32_t BUF5I:1;                 /* Buffer MB5 Interrupt Or "Frames available in Rx FIFO" */
    vuint32_t BUF4TO1I:4;              /* Buffer MB i Interrupt Or "reserved" */
    vuint32_t BUF0I:1;                 /* Buffer MB0 Interrupt Or "reserved" */
  } B;
} CAN_IFLAG1_tag;

typedef union CAN_CTRL2_union_tag {    /* Control 2 register */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t ECRWRE:1;                /* Error-correction Configuration Register Write Enable */
    vuint32_t WRMFRZ:1;                /* Write-Access To Memory In Freeze Mode */
    vuint32_t RFFN:4;                  /* Number Of Rx FIFO Filters */
    vuint32_t TASD:5;                  /* Tx Arbitration Start Delay */
    vuint32_t MRP:1;                   /* Mailboxes Reception Priority */
    vuint32_t RRS:1;                   /* Remote Request Storing */
    vuint32_t EACEN:1;                 /* Entire Frame Arbitration Field Comparison Enable For Rx Mailboxes */
    vuint32_t  :16;
  } B;
} CAN_CTRL2_tag;

typedef union CAN_ESR2_union_tag {     /* Error and Status 2 register */
  vuint32_t R;
  struct {
    vuint32_t  :9;
    vuint32_t LPTM:7;                  /* Lowest Priority Tx Mailbox */
    vuint32_t  :1;
    vuint32_t VPS:1;                   /* Valid Priority Status */
    vuint32_t IMB:1;                   /* Inactive Mailbox */
    vuint32_t  :13;
  } B;
} CAN_ESR2_tag;

typedef union CAN_CRCR_union_tag {     /* CRC Register */
  vuint32_t R;
  struct {
    vuint32_t  :9;
    vuint32_t MBCRC:7;                 /* CRC Mailbox */
    vuint32_t  :1;
    vuint32_t TXCRC:15;                /* CRC Transmitted */
  } B;
} CAN_CRCR_tag;

typedef union CAN_RXFGMASK_union_tag { /* Rx FIFO Global Mask register */
  vuint32_t R;
  struct {
    vuint32_t FGM:32;                  /* Rx FIFO Global Mask Bits */
  } B;
} CAN_RXFGMASK_tag;

typedef union CAN_RXFIR_union_tag {    /* Rx FIFO Information Register */
  vuint32_t R;
  struct {
    vuint32_t  :23;
    vuint32_t IDHIT:9;                 /* Identifier Acceptance Filter Hit Indicator */
  } B;
} CAN_RXFIR_tag;

typedef union CAN_MB_CS_union_tag {    /* Message Buffer 0 CS Register */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t CODE:4;                  /* Message Buffer Code */
    vuint32_t  :1;
    vuint32_t SRR:1;                   /* Substitute Remote Request. Contains a fixed recessive bit. */
    vuint32_t IDE:1;                   /* ID Extended. One/zero for extended/standard format frame. */
    vuint32_t RTR:1;                   /* Remote Transmission Request. One/zero for remote/data frame. */
    vuint32_t DLC:4;                   /* Length of the data to be stored/transmitted. */
    vuint32_t TIMESTAMP:16;            /* Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus. */
  } B;
} CAN_MB_CS_tag;

typedef union CAN_MB_ID_union_tag {    /* Message Buffer 0 ID Register */
  vuint32_t R;
  struct {
    vuint32_t PRIO:3;                  /* Local Priority */
    vuint32_t ID_STD:11;               /* Frame Identifier Standard */
    vuint32_t ID_EXT:18;               /* Frame Identifier Extended */
  } B;
} CAN_MB_ID_tag;

typedef union CAN_MB_DATA_union_tag {
  vuint8_t B[8];
  vuint16_t H[4];
  vuint32_t W[2];
} CAN_MB_DATA_tag;

typedef struct CAN_MB_struct_tag {
  CAN_MB_CS_tag CS;                    /* Message Buffer 0 CS Register */
  CAN_MB_ID_tag ID;                    /* Message Buffer 0 ID Register */
  CAN_MB_DATA_tag DATA;
} CAN_MB_tag;

typedef union CAN_RXIMR_union_tag {    /* Rx Individual Mask Registers */
  vuint32_t R;
  struct {
    vuint32_t MI:32;                   /* Individual Mask Bits */
  } B;
} CAN_RXIMR_tag;

typedef union CAN_MECR_union_tag {     /* Memory Error Control Register */
  vuint32_t R;
  struct {
    vuint32_t ECRWRDIS:1;              /* Error Configuration Register Write Disable */
    vuint32_t  :11;
    vuint32_t HANCEI_MSK:1;            /* Host Access With Non-Correctable Errors Interrupt Mask */
    vuint32_t FANCEI_MSK:1;            /* FlexCAN Access With Non-Correctable Errors Interrupt Mask */
    vuint32_t  :1;
    vuint32_t CEI_MSK:1;               /* Correctable Errors Interrupt Mask */
    vuint32_t HAERRIE:1;               /* Host Access Error Injection Enable */
    vuint32_t FAERRIE:1;               /* FlexCAN Access Error Injection Enable */
    vuint32_t EXTERRIE:1;              /* Extended Error Injection Enable */
    vuint32_t  :3;
    vuint32_t RERRDIS:1;               /* Error Report Disable */
    vuint32_t ECCDIS:1;                /* Error Correction Disable */
    vuint32_t NCEFAFRZ:1;              /* Non-Correctable Errors In FlexCAN Access Put Device In Freeze Mode */
    vuint32_t  :7;
  } B;
} CAN_MECR_tag;

typedef union CAN_ERRIAR_union_tag {   /* Error Injection Address Register */
  vuint32_t R;
  struct {
    vuint32_t  :18;
    vuint32_t INJADDR:14;              /* Address Where Error Is To Be Injected */
  } B;
} CAN_ERRIAR_tag;

typedef union CAN_ERRIDPR_union_tag {  /* Error Injection Data Pattern Register */
  vuint32_t R;
  struct {
    vuint32_t DFLIP:32;                /* Data flip pattern */
  } B;
} CAN_ERRIDPR_tag;

typedef union CAN_ERRIPPR_union_tag {  /* Error Injection Parity Pattern Register */
  vuint32_t R;
  struct {
    vuint32_t  :3;
    vuint32_t PFLIP3:5;                /* Parity Flip Pattern For Byte 3 (most significant) */
    vuint32_t  :3;
    vuint32_t PFLIP2:5;                /* Parity Flip Pattern For Byte 2 */
    vuint32_t  :3;
    vuint32_t PFLIP1:5;                /* Parity Flip Pattern For Byte 1 */
    vuint32_t  :3;
    vuint32_t PFLIP0:5;                /* Parity Flip Pattern For Byte 0 (Least Significant) */
  } B;
} CAN_ERRIPPR_tag;

typedef union CAN_RERRAR_union_tag {   /* Error Report Address Register */
  vuint32_t R;
  struct {
    vuint32_t  :7;
    vuint32_t NCE:1;                   /* Non-Correctable Error */
    vuint32_t  :5;
    vuint32_t SAID:3;
    vuint32_t  :2;
    vuint32_t ERRADDR:14;              /* Address Where The Error Was Detected */
  } B;
} CAN_RERRAR_tag;

typedef union CAN_RERRDR_union_tag {   /* Error Report Data Register */
  vuint32_t R;
  struct {
    vuint32_t RDATA:32;                /* Raw data word read from memory with error */
  } B;
} CAN_RERRDR_tag;

typedef union CAN_RERRSYNR_union_tag { /* Error Report Syndrome Register */
  vuint32_t R;
  struct {
    vuint32_t BE3:1;                   /* Byte Enabled For Byte 3 (Most Significant) */
    vuint32_t  :2;
    vuint32_t SYND3:5;                 /* Error Syndrome For Byte 3 (Most Significant) */
    vuint32_t BE2:1;                   /* Byte Enabled For Byte 2 */
    vuint32_t  :2;
    vuint32_t SYND2:5;                 /* Error Syndrome For Byte 2 */
    vuint32_t BE1:1;                   /* Byte Enabled For Byte 1 */
    vuint32_t  :2;
    vuint32_t SYND1:5;                 /* Error Syndrome for Byte 1 */
    vuint32_t BE0:1;                   /* Byte Enabled For Byte 0 (least significant) */
    vuint32_t  :2;
    vuint32_t SYND0:5;                 /* Error Syndrome For Byte 0 (least significant) */
  } B;
} CAN_RERRSYNR_tag;

typedef union CAN_ERRSR_union_tag {    /* Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t HANCEIF:1;               /* Host Access With Non-Correctable Error Interrupt Flag */
    vuint32_t FANCEIF:1;               /* FlexCAN Access With Non-Correctable Error Interrupt Flag */
    vuint32_t  :1;
    vuint32_t CEIF:1;                  /* Correctable Error Interrupt Flag */
    vuint32_t  :12;
    vuint32_t HANCEIOF:1;              /* Host Access With Non-Correctable Error Interrupt Overrun Flag */
    vuint32_t FANCEIOF:1;              /* FlexCAN Access With Non-Correctable Error Interrupt Overrun Flag */
    vuint32_t  :1;
    vuint32_t CEIOF:1;                 /* Correctable Error Interrupt Overrun Flag */
  } B;
} CAN_ERRSR_tag;

struct CAN_tag {
  CAN_MCR_tag MCR;                     /* Module Configuration Register */
  CAN_CTRL1_tag CTRL1;                 /* Control 1 register */
  CAN_TIMER_tag TIMER;                 /* Free Running Timer */
  uint8_t CAN_reserved0[4];
  CAN_RXMGMASK_tag RXMGMASK;           /* Rx Mailboxes Global Mask Register */
  CAN_RX14MASK_tag RX14MASK;           /* Rx 14 Mask register */
  CAN_RX15MASK_tag RX15MASK;           /* Rx 15 Mask register */
  CAN_ECR_tag ECR;                     /* Error Counter */
  CAN_ESR1_tag ESR1;                   /* Error and Status 1 register */
  CAN_IMASK2_tag IMASK2;               /* Interrupt Masks 2 register */
  CAN_IMASK1_tag IMASK1;               /* Interrupt Masks 1 register */
  CAN_IFLAG2_tag IFLAG2;               /* Interrupt Flags 2 register */
  CAN_IFLAG1_tag IFLAG1;               /* Interrupt Flags 1 register */
  CAN_CTRL2_tag CTRL2;                 /* Control 2 register */
  CAN_ESR2_tag ESR2;                   /* Error and Status 2 register */
  uint8_t CAN_reserved1[8];
  CAN_CRCR_tag CRCR;                   /* CRC Register */
  CAN_RXFGMASK_tag RXFGMASK;           /* Rx FIFO Global Mask register */
  CAN_RXFIR_tag RXFIR;                 /* Rx FIFO Information Register */
  uint8_t CAN_reserved2[48];
  CAN_MB_tag MB[64];
  uint8_t CAN_reserved3[1024];
  CAN_RXIMR_tag RXIMR[64];             /* Rx Individual Mask Registers */
  uint8_t CAN_reserved4[352];
  CAN_MECR_tag MECR;                   /* Memory Error Control Register */
  CAN_ERRIAR_tag ERRIAR;               /* Error Injection Address Register */
  CAN_ERRIDPR_tag ERRIDPR;             /* Error Injection Data Pattern Register */
  CAN_ERRIPPR_tag ERRIPPR;             /* Error Injection Parity Pattern Register */
  CAN_RERRAR_tag RERRAR;               /* Error Report Address Register */
  CAN_RERRDR_tag RERRDR;               /* Error Report Data Register */
  CAN_RERRSYNR_tag RERRSYNR;           /* Error Report Syndrome Register */
  CAN_ERRSR_tag ERRSR;                 /* Error Status Register */
};


/* ============================================================================
   =============================== Module: CMU ================================
   ============================================================================ */

typedef union CMU_CSR_union_tag {      /* CMU Control Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t SFM:1;                   /* Start frequency measure. */
    vuint32_t  :13;
    vuint32_t CKSEL1:2;                /* Frequency measure clock selection bit. */
    vuint32_t  :5;
    vuint32_t RCDIV:2;                 /* CLKMT0_RMN division factor. */
    vuint32_t CME:1;                   /* CLKMN1 monitor enable. */
  } B;
} CMU_CSR_tag;

typedef union CMU_FDR_union_tag {      /* CMU Frequency Display Register */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t FD:20;                   /* Measured frequency bits. */
  } B;
} CMU_FDR_tag;

typedef union CMU_HFREFR_union_tag {   /* CMU High Frequency Reference Register CLKMN1 */
  vuint32_t R;
  struct {
    vuint32_t  :20;
    vuint32_t HFREF:12;                /* High Frequency reference value. */
  } B;
} CMU_HFREFR_tag;

typedef union CMU_LFREFR_union_tag {   /* CMU Low Frequency Reference Register CLKMN1 */
  vuint32_t R;
  struct {
    vuint32_t  :20;
    vuint32_t LFREF:12;                /* Low Frequency reference value. */
  } B;
} CMU_LFREFR_tag;

typedef union CMU_ISR_union_tag {      /* CMU Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :28;
    vuint32_t FLCI:1;                  /* CLKMN1 frequency less than reference clock event status. */
    vuint32_t FHHI:1;                  /* CLKMN1 frequency higher than high reference event status. */
    vuint32_t FLLI:1;                  /* CLKMN1 frequency less than low reference event status. */
    vuint32_t OLRI:1;                  /* Oscillator frequency less than f CLKMT0_RMN * 2CMU_CSR[RCDIV]event status. */
  } B;
} CMU_ISR_tag;

typedef union CMU_MDR_union_tag {      /* CMU Measurement Duration Register */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t MD:20;                   /* Measurement duration bits */
  } B;
} CMU_MDR_tag;

struct CMU_tag {
  CMU_CSR_tag CSR;                     /* CMU Control Status Register */
  CMU_FDR_tag FDR;                     /* CMU Frequency Display Register */
  CMU_HFREFR_tag HFREFR;               /* CMU High Frequency Reference Register CLKMN1 */
  CMU_LFREFR_tag LFREFR;               /* CMU Low Frequency Reference Register CLKMN1 */
  CMU_ISR_tag ISR;                     /* CMU Interrupt Status Register */
  uint8_t CMU_reserved0[4];
  CMU_MDR_tag MDR;                     /* CMU Measurement Duration Register */
};


/* ============================================================================
   =============================== Module: CRC ================================
   ============================================================================ */

typedef union CRC_CHANNEL_CFG_union_tag { /* Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t  :18;
    vuint32_t SWAP_BYTEWISE:1;         /* Swap CRC_INP byte-wise */
    vuint32_t SWAP_BITWISE:1;          /* Swap CRC_INP bit-wise */
    vuint32_t POLYG:2;                 /* Polynomial selection */
    vuint32_t SWAP:1;                  /* Swap selection */
    vuint32_t INV:1;                   /* Inversion selection */
  } B;
} CRC_CHANNEL_CFG_tag;

typedef union CRC_CHANNEL_INP_union_tag { /* Input Register */
  vuint32_t R;
  struct {
    vuint32_t INP:32;                  /* Input data for the CRC computation */
  } B;
} CRC_CHANNEL_INP_tag;

typedef union CRC_CHANNEL_CSTAT_union_tag { /* Current Status Register */
  vuint32_t R;
  struct {
    vuint32_t CSTAT:32;                /* CRC signature status */
  } B;
} CRC_CHANNEL_CSTAT_tag;

typedef union CRC_CHANNEL_OUTP_union_tag { /* Output Register */
  vuint32_t R;
  struct {
    vuint32_t OUTP:32;                 /* Final CRC signature */
  } B;
} CRC_CHANNEL_OUTP_tag;

typedef struct CRC_CHANNEL_struct_tag {
  CRC_CHANNEL_CFG_tag CFG;             /* Configuration Register */
  CRC_CHANNEL_INP_tag INP;             /* Input Register */
  CRC_CHANNEL_CSTAT_tag CSTAT;         /* Current Status Register */
  CRC_CHANNEL_OUTP_tag OUTP;           /* Output Register */
} CRC_CHANNEL_tag;

struct CRC_tag {
  CRC_CHANNEL_tag CHANNEL[3];
};


/* ============================================================================
   =============================== Module: CSE ================================
   ============================================================================ */

typedef union CSE_CR_union_tag {       /* CSE Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t DIV:8;
    vuint32_t  :2;
    vuint32_t KBS:1;
    vuint32_t SFE:1;
    vuint32_t MDIS:1;
    vuint32_t SUS:1;
    vuint32_t DRE:1;
    vuint32_t CIE:1;
  } B;
} CSE_CR_tag;

typedef union CSE_SR_union_tag {       /* CSE Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :23;
    vuint32_t EX:1;
    vuint32_t IDB:1;
    vuint32_t EDB:1;
    vuint32_t RIN:1;
    vuint32_t BOK:1;
    vuint32_t BFN:1;
    vuint32_t BIN:1;
    vuint32_t SB:1;
    vuint32_t BSY:1;
  } B;
} CSE_SR_tag;

typedef union CSE_IR_union_tag {       /* CSE Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t CIF:1;
  } B;
} CSE_IR_tag;

typedef union CSE_ECR_union_tag {      /* CSE Error Code Register */
  vuint32_t R;
  struct {
    vuint32_t  :27;
    vuint32_t EC:5;
  } B;
} CSE_ECR_tag;

typedef union CSE_CMD_union_tag {      /* CSE Command Register */
  vuint32_t R;
  struct {
    vuint32_t  :27;
    vuint32_t CMD:5;
  } B;
} CSE_CMD_tag;

typedef union CSE_P_union_tag {        /* CSE Parameter Register */
  vuint32_t R;
  struct {
    vuint32_t PARM:32;
  } B;
} CSE_P_tag;

struct CSE_tag {
  CSE_CR_tag CR;                       /* CSE Control Register */
  CSE_SR_tag SR;                       /* CSE Status Register */
  CSE_IR_tag IR;                       /* CSE Interrupt Register */
  CSE_ECR_tag ECR;                     /* CSE Error Code Register */
  uint8_t CSE_reserved0[16];
  CSE_CMD_tag CMD;                     /* CSE Command Register */
  CSE_P_tag P[5];                      /* CSE Parameter Register */
};


/* ============================================================================
   =============================== Module: DECFILTER ==========================
   ============================================================================ */

typedef union DECFILTER_MCR_union_tag { /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FREN:1;                  /* Freeze Enable */
    vuint32_t  :1;
    vuint32_t FRZ:1;                   /* Freeze Mode */
    vuint32_t SRES:1;                  /* Software-reset bit */
    vuint32_t CASCD:2;                 /* Cascade Mode Configuration */
    vuint32_t IDEN:1;                  /* Input Data Interrupt Enable */
    vuint32_t ODEN:1;                  /* Output Data Interrupt Enable */
    vuint32_t ERREN:1;                 /* Error Interrupt Enable */
    vuint32_t  :1;
    vuint32_t FTYPE:2;                 /* Filter Type Selection bits */
    vuint32_t  :1;
    vuint32_t SCAL:2;                  /* Filter Scaling Factor */
    vuint32_t IDIS:1;                  /* Input Disable */
    vuint32_t SAT:1;                   /* Saturation Enable */
    vuint32_t ISEL:1;                  /* Input Selection */
    vuint32_t MIXM:1;                  /* Mixed Mode */
    vuint32_t DEC_RATE:4;              /* Decimation Rate Selection */
    vuint32_t SDIE:1;                  /* Integrator Data Interrupt Enable */
    vuint32_t DSEL:1;                  /* DMA Selection */
    vuint32_t IBIE:1;                  /* Input Buffer Interrupt Request Enable */
    vuint32_t OBIE:1;                  /* Output Buffer Interrupt Request Enable */
    vuint32_t EDME:1;                  /* Enhanced Debug Monitor Enable */
    vuint32_t TORE:1;                  /* Triggered Output Result Enable */
    vuint32_t TMODE:2;                 /* Trigger Mode */
  } B;
} DECFILTER_MCR_tag;

typedef union DECFILTER_MSR_union_tag { /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t BSY:1;                   /* Decimation Filter Busy indication */
    vuint32_t  :1;
    vuint32_t DEC_COUNTER:4;           /* Decimation Counter */
    vuint32_t IDFC:1;                  /* Input Data Flag Clear bit */
    vuint32_t ODFC:1;                  /* Output Data Flag Clear bit */
    vuint32_t  :1;
    vuint32_t IBIC:1;                  /* Input Buffer Interrupt Request Clear bit */
    vuint32_t OBIC:1;                  /* Output Buffer Interrupt Request Clear bit */
    vuint32_t  :1;
    vuint32_t DIVRC:1;                 /* DIVR Clear bit */
    vuint32_t OVFC:1;                  /* OVF Clear bit */
    vuint32_t OVRC:1;                  /* OVR Clear bit */
    vuint32_t IVRC:1;                  /* IVR Clear bit */
    vuint32_t  :6;
    vuint32_t IDF:1;                   /* Input Data Flag */
    vuint32_t ODF:1;                   /* Output Data Flag */
    vuint32_t  :1;
    vuint32_t IBIF:1;                  /* Input Buffer Interrupt Request Flag */
    vuint32_t OBIF:1;                  /* Output Buffer Interrupt Request Flag */
    vuint32_t  :1;
    vuint32_t DIVR:1;                  /* Enhanced Debug Monitor Input Data Read Overrun */
    vuint32_t OVF:1;                   /* Filter Overflow Flag */
    vuint32_t OVR:1;                   /* Output Interface Buffer Overrun */
    vuint32_t IVR:1;                   /* Input Interface Buffer Overrun */
  } B;
} DECFILTER_MSR_tag;

typedef union DECFILTER_MXCR_union_tag { /* Module Extended Config Register */
  vuint32_t R;
  struct {
    vuint32_t SDMAE:1;                 /* Integrator DMA Enable */
    vuint32_t SSIG:1;                  /* Integrator Signal operation selection */
    vuint32_t SSAT:1;                  /* Integrator Saturated operation selection */
    vuint32_t SCSAT:1;                 /* Integrator Counter Saturated operation selection */
    vuint32_t  :10;
    vuint32_t SRQ:1;                   /* Integrator Output Request */
    vuint32_t SZRO:1;                  /* Integrator Zero */
    vuint32_t SISEL:1;                 /* Integrator Input Selection */
    vuint32_t  :1;
    vuint32_t SZROSEL:2;               /* Integrator Zero Control Mode Selection */
    vuint32_t  :2;
    vuint32_t SHLTSEL:2;               /* Integrator Halt Control Selection */
    vuint32_t  :1;
    vuint32_t SRQSEL:3;                /* Integrator Output Read Request Mode Selection */
    vuint32_t  :2;
    vuint32_t SENSEL:2;                /* Integrator Enable Control Selection */
  } B;
} DECFILTER_MXCR_tag;

typedef union DECFILTER_MXSR_union_tag { /* Module Extended Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :7;
    vuint32_t SDFC:1;                  /* Integrator Output Data Flag Clear bit */
    vuint32_t  :2;
    vuint32_t SSEC:1;                  /* Integrator Sum Exception Clear bit */
    vuint32_t SCEC:1;                  /* Integrator Count Exception Clear bit */
    vuint32_t  :1;
    vuint32_t SSOVFC:1;                /* Integrator Sum Overflow Clear bit */
    vuint32_t SCOVFC:1;                /* Integrator Count Overflow Clear bit */
    vuint32_t SVRC:1;                  /* SVR Clear bit */
    vuint32_t  :7;
    vuint32_t SDF:1;                   /* Integrator Data Flag */
    vuint32_t  :2;
    vuint32_t SSE:1;                   /* Integrator Sum Exception flag */
    vuint32_t SCE:1;                   /* Integrator Count Exception flag */
    vuint32_t  :1;
    vuint32_t SSOVF:1;                 /* Integrator Sum Overflow Flag */
    vuint32_t SCOVF:1;                 /* Integrator Count Overflow Flag */
    vuint32_t SVR:1;                   /* Integrator Data Overrun */
  } B;
} DECFILTER_MXSR_tag;

typedef union DECFILTER_IB_union_tag { /* Interface Input Buffer */
  vuint32_t R;
  struct {
    vuint32_t  :3;
    vuint32_t PSIOSEL:1;               /* PSI Output Selection */
    vuint32_t INTAG:4;                 /* Decimation filter input tag bits */
    vuint32_t  :6;
    vuint32_t PREFILL:1;               /* Decimation Filter Prefill/Filter control bit */
    vuint32_t FLUSH:1;                 /* Decimation Filter Flush control bit */
    vuint32_t INPBUF:16;               /* Input Buffer Data */
  } B;
} DECFILTER_IB_tag;

typedef union DECFILTER_OB_union_tag { /* Interface Output Buffer */
  vuint32_t R;
  struct {
    vuint32_t  :11;
    vuint32_t PSIOSEL:1;               /* Selected PSI Output */
    vuint32_t OUTTAG:4;                /* Decimation filter output tag bits */
    vuint32_t OUTBUF:16;               /* Output Buffer Data */
  } B;
} DECFILTER_OB_tag;

typedef union DECFILTER_COEF_union_tag { /* Filter Coefficient */
  vuint32_t R;
  struct {
    vuint32_t COEFnSIGNR:8;            /* COEFn sign repeated */
    vuint32_t COEFn:24;                /* Coefficient n field */
  } B;
} DECFILTER_COEF_tag;

typedef union DECFILTER_TAP_union_tag { /* Filter TAP */
  vuint32_t R;
  struct {
    vuint32_t TAPnSIGNR:8;             /* TAPn sign repeated */
    vuint32_t TAPn:24;                 /* TAPn Register */
  } B;
} DECFILTER_TAP_tag;

typedef union DECFILTER_EDID_union_tag { /* Enhanced Debug Input Data */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t SAMP_DATA:16;            /* Conversion Sample Data */
  } B;
} DECFILTER_EDID_tag;

typedef union DECFILTER_FINTVAL_union_tag { /* Final Integer Value Register */
  vuint32_t R;
  struct {
    vuint32_t SUM_VALUE:32;            /* Integration Sum Value */
  } B;
} DECFILTER_FINTVAL_tag;

typedef union DECFILTER_FINTCNT_union_tag { /* Final Integer Count Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Integration Count Value */
  } B;
} DECFILTER_FINTCNT_tag;

typedef union DECFILTER_CINTVAL_union_tag { /* Current Integer Value Register */
  vuint32_t R;
  struct {
    vuint32_t SUM_VALUE:32;            /* Integration Sum Value */
  } B;
} DECFILTER_CINTVAL_tag;

typedef union DECFILTER_CINTCNT_union_tag { /* Current Integer Count Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Integration Count Value */
  } B;
} DECFILTER_CINTCNT_tag;

struct DECFILTER_tag {
  DECFILTER_MCR_tag MCR;               /* Module Configuration Register */
  DECFILTER_MSR_tag MSR;               /* Module Status Register */
  DECFILTER_MXCR_tag MXCR;             /* Module Extended Config Register */
  DECFILTER_MXSR_tag MXSR;             /* Module Extended Status Register */
  DECFILTER_IB_tag IB;                 /* Interface Input Buffer */
  DECFILTER_OB_tag OB;                 /* Interface Output Buffer */
  uint8_t DECFILTER_reserved0[8];
  DECFILTER_COEF_tag COEF[9];          /* Filter Coefficient */
  uint8_t DECFILTER_reserved1[52];
  DECFILTER_TAP_tag TAP[8];            /* Filter TAP */
  uint8_t DECFILTER_reserved2[56];
  DECFILTER_EDID_tag EDID;             /* Enhanced Debug Input Data */
  uint8_t DECFILTER_reserved3[12];
  DECFILTER_FINTVAL_tag FINTVAL;       /* Final Integer Value Register */
  DECFILTER_FINTCNT_tag FINTCNT;       /* Final Integer Count Register */
  DECFILTER_CINTVAL_tag CINTVAL;       /* Current Integer Value Register */
  DECFILTER_CINTCNT_tag CINTCNT;       /* Current Integer Count Register */
};


/* ============================================================================
   =============================== Module: DMA ================================
   ============================================================================ */

typedef union DMA_CR_union_tag {       /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :14;
    vuint32_t CX:1;                    /* Cancel Transfer */
    vuint32_t ECX:1;                   /* Error Cancel Transfer */
    vuint32_t GRP3PRI:2;               /* Channel Group 3 Priority */
    vuint32_t GRP2PRI:2;               /* Channel Group 2 Priority */
    vuint32_t GRP1PRI:2;               /* Channel Group 1 Priority */
    vuint32_t GRP0PRI:2;               /* Channel Group 0 Priority */
    vuint32_t EMLM:1;                  /* Enable Minor Loop Mapping */
    vuint32_t CLM:1;                   /* Continuous Link Mode */
    vuint32_t HALT:1;                  /* Halt DMA Operations */
    vuint32_t HOE:1;                   /* Halt On Error */
    vuint32_t ERGA:1;                  /* Enable Round Robin Group Arbitration */
    vuint32_t ERCA:1;                  /* Enable Round Robin Channel Arbitration */
    vuint32_t EDBG:1;                  /* Enable Debug */
    vuint32_t  :1;
  } B;
} DMA_CR_tag;

typedef union DMA_ES_union_tag {       /* Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t  :13;
    vuint32_t UCE:1;                   /* Uncorrectable ECC error during channel execution. */
    vuint32_t ECX:1;                   /* Transfer Canceled */
    vuint32_t GPE:1;                   /* Group Priority Error */
    vuint32_t CPE:1;                   /* Channel Priority Error */
    vuint32_t ERRCHN:6;                /* Error Channel Number or Canceled Channel Number */
    vuint32_t SAE:1;                   /* Source Address Error */
    vuint32_t SOE:1;                   /* Source Offset Error */
    vuint32_t DAE:1;                   /* Destination Address Error */
    vuint32_t DOE:1;                   /* Destination Offset Error */
    vuint32_t NCE:1;                   /* NBYTES/CITER Configuration Error */
    vuint32_t SGE:1;                   /* Scatter/Gather Configuration Error */
    vuint32_t SBE:1;                   /* Source Bus Error */
    vuint32_t DBE:1;                   /* Destination Bus Error */
  } B;
} DMA_ES_tag;

typedef union DMA_ERQH_union_tag {     /* Enable Request Register High */
  vuint32_t R;
  struct {
    vuint32_t ERQ63:1;                 /* Enable DMA Request 63 */
    vuint32_t ERQ62:1;                 /* Enable DMA Request 62 */
    vuint32_t ERQ61:1;                 /* Enable DMA Request 61 */
    vuint32_t ERQ60:1;                 /* Enable DMA Request 60 */
    vuint32_t ERQ59:1;                 /* Enable DMA Request 59 */
    vuint32_t ERQ58:1;                 /* Enable DMA Request 58 */
    vuint32_t ERQ57:1;                 /* Enable DMA Request 57 */
    vuint32_t ERQ56:1;                 /* Enable DMA Request 56 */
    vuint32_t ERQ55:1;                 /* Enable DMA Request 55 */
    vuint32_t ERQ54:1;                 /* Enable DMA Request 54 */
    vuint32_t ERQ53:1;                 /* Enable DMA Request 53 */
    vuint32_t ERQ52:1;                 /* Enable DMA Request 52 */
    vuint32_t ERQ51:1;                 /* Enable DMA Request 51 */
    vuint32_t ERQ50:1;                 /* Enable DMA Request 50 */
    vuint32_t ERQ49:1;                 /* Enable DMA Request 49 */
    vuint32_t ERQ48:1;                 /* Enable DMA Request 48 */
    vuint32_t ERQ47:1;                 /* Enable DMA Request 47 */
    vuint32_t ERQ46:1;                 /* Enable DMA Request 46 */
    vuint32_t ERQ45:1;                 /* Enable DMA Request 45 */
    vuint32_t ERQ44:1;                 /* Enable DMA Request 44 */
    vuint32_t ERQ43:1;                 /* Enable DMA Request 43 */
    vuint32_t ERQ42:1;                 /* Enable DMA Request 42 */
    vuint32_t ERQ41:1;                 /* Enable DMA Request 41 */
    vuint32_t ERQ40:1;                 /* Enable DMA Request 40 */
    vuint32_t ERQ39:1;                 /* Enable DMA Request 39 */
    vuint32_t ERQ38:1;                 /* Enable DMA Request 38 */
    vuint32_t ERQ37:1;                 /* Enable DMA Request 37 */
    vuint32_t ERQ36:1;                 /* Enable DMA Request 36 */
    vuint32_t ERQ35:1;                 /* Enable DMA Request 35 */
    vuint32_t ERQ34:1;                 /* Enable DMA Request 34 */
    vuint32_t ERQ33:1;                 /* Enable DMA Request 33 */
    vuint32_t ERQ32:1;                 /* Enable DMA Request 32 */
  } B;
} DMA_ERQH_tag;

typedef union DMA_ERQL_union_tag {     /* Enable Request Register Low */
  vuint32_t R;
  struct {
    vuint32_t ERQ31:1;                 /* Enable DMA Request 31 */
    vuint32_t ERQ30:1;                 /* Enable DMA Request 30 */
    vuint32_t ERQ29:1;                 /* Enable DMA Request 29 */
    vuint32_t ERQ28:1;                 /* Enable DMA Request 28 */
    vuint32_t ERQ27:1;                 /* Enable DMA Request 27 */
    vuint32_t ERQ26:1;                 /* Enable DMA Request 26 */
    vuint32_t ERQ25:1;                 /* Enable DMA Request 25 */
    vuint32_t ERQ24:1;                 /* Enable DMA Request 24 */
    vuint32_t ERQ23:1;                 /* Enable DMA Request 23 */
    vuint32_t ERQ22:1;                 /* Enable DMA Request 22 */
    vuint32_t ERQ21:1;                 /* Enable DMA Request 21 */
    vuint32_t ERQ20:1;                 /* Enable DMA Request 20 */
    vuint32_t ERQ19:1;                 /* Enable DMA Request 19 */
    vuint32_t ERQ18:1;                 /* Enable DMA Request 18 */
    vuint32_t ERQ17:1;                 /* Enable DMA Request 17 */
    vuint32_t ERQ16:1;                 /* Enable DMA Request 16 */
    vuint32_t ERQ15:1;                 /* Enable DMA Request 15 */
    vuint32_t ERQ14:1;                 /* Enable DMA Request 14 */
    vuint32_t ERQ13:1;                 /* Enable DMA Request 13 */
    vuint32_t ERQ12:1;                 /* Enable DMA Request 12 */
    vuint32_t ERQ11:1;                 /* Enable DMA Request 11 */
    vuint32_t ERQ10:1;                 /* Enable DMA Request 10 */
    vuint32_t ERQ9:1;                  /* Enable DMA Request 9 */
    vuint32_t ERQ8:1;                  /* Enable DMA Request 8 */
    vuint32_t ERQ7:1;                  /* Enable DMA Request 7 */
    vuint32_t ERQ6:1;                  /* Enable DMA Request 6 */
    vuint32_t ERQ5:1;                  /* Enable DMA Request 5 */
    vuint32_t ERQ4:1;                  /* Enable DMA Request 4 */
    vuint32_t ERQ3:1;                  /* Enable DMA Request 3 */
    vuint32_t ERQ2:1;                  /* Enable DMA Request 2 */
    vuint32_t ERQ1:1;                  /* Enable DMA Request 1 */
    vuint32_t ERQ0:1;                  /* Enable DMA Request 0 */
  } B;
} DMA_ERQL_tag;

typedef union DMA_EEIH_union_tag {     /* Enable Error Interrupt Register High */
  vuint32_t R;
  struct {
    vuint32_t EEI63:1;                 /* Enable Error Interrupt 63 */
    vuint32_t EEI62:1;                 /* Enable Error Interrupt 62 */
    vuint32_t EEI61:1;                 /* Enable Error Interrupt 61 */
    vuint32_t EEI60:1;                 /* Enable Error Interrupt 60 */
    vuint32_t EEI59:1;                 /* Enable Error Interrupt 59 */
    vuint32_t EEI58:1;                 /* Enable Error Interrupt 58 */
    vuint32_t EEI57:1;                 /* Enable Error Interrupt 57 */
    vuint32_t EEI56:1;                 /* Enable Error Interrupt 56 */
    vuint32_t EEI55:1;                 /* Enable Error Interrupt 55 */
    vuint32_t EEI54:1;                 /* Enable Error Interrupt 54 */
    vuint32_t EEI53:1;                 /* Enable Error Interrupt 53 */
    vuint32_t EEI52:1;                 /* Enable Error Interrupt 52 */
    vuint32_t EEI51:1;                 /* Enable Error Interrupt 51 */
    vuint32_t EEI50:1;                 /* Enable Error Interrupt 50 */
    vuint32_t EEI49:1;                 /* Enable Error Interrupt 49 */
    vuint32_t EEI48:1;                 /* Enable Error Interrupt 48 */
    vuint32_t EEI47:1;                 /* Enable Error Interrupt 47 */
    vuint32_t EEI46:1;                 /* Enable Error Interrupt 46 */
    vuint32_t EEI45:1;                 /* Enable Error Interrupt 45 */
    vuint32_t EEI44:1;                 /* Enable Error Interrupt 44 */
    vuint32_t EEI43:1;                 /* Enable Error Interrupt 43 */
    vuint32_t EEI42:1;                 /* Enable Error Interrupt 42 */
    vuint32_t EEI41:1;                 /* Enable Error Interrupt 41 */
    vuint32_t EEI40:1;                 /* Enable Error Interrupt 40 */
    vuint32_t EEI39:1;                 /* Enable Error Interrupt 39 */
    vuint32_t EEI38:1;                 /* Enable ErrorInterrupt 38 */
    vuint32_t EEI37:1;                 /* Enable Error Interrupt 37 */
    vuint32_t EEI36:1;                 /* Enable Error Interrupt 36 */
    vuint32_t EEI35:1;                 /* Enable Error Interrupt 35 */
    vuint32_t EEI34:1;                 /* Enable Error Interrupt 34 */
    vuint32_t EEI33:1;                 /* Enable Error Interrupt 33 */
    vuint32_t EEI32:1;                 /* Enable Error Interrupt 32 */
  } B;
} DMA_EEIH_tag;

typedef union DMA_EEIL_union_tag {     /* Enable Error Interrupt Register Low */
  vuint32_t R;
  struct {
    vuint32_t EEI31:1;                 /* Enable Error Interrupt 31 */
    vuint32_t EEI30:1;                 /* Enable Error Interrupt 30 */
    vuint32_t EEI29:1;                 /* Enable Error Interrupt 29 */
    vuint32_t EEI28:1;                 /* Enable Error Interrupt 28 */
    vuint32_t EEI27:1;                 /* Enable Error Interrupt 27 */
    vuint32_t EEI26:1;                 /* Enable Error Interrupt 26 */
    vuint32_t EEI25:1;                 /* Enable Error Interrupt 25 */
    vuint32_t EEI24:1;                 /* Enable Error Interrupt 24 */
    vuint32_t EEI23:1;                 /* Enable Error Interrupt 23 */
    vuint32_t EEI22:1;                 /* Enable Error Interrupt 22 */
    vuint32_t EEI21:1;                 /* Enable Error Interrupt 21 */
    vuint32_t EEI20:1;                 /* Enable Error Interrupt 20 */
    vuint32_t EEI19:1;                 /* Enable Error Interrupt 19 */
    vuint32_t EEI18:1;                 /* Enable Error Interrupt 18 */
    vuint32_t EEI17:1;                 /* Enable Error Interrupt 17 */
    vuint32_t EEI16:1;                 /* Enable Error Interrupt 16 */
    vuint32_t EEI15:1;                 /* Enable Error Interrupt 15 */
    vuint32_t EEI14:1;                 /* Enable Error Interrupt 14 */
    vuint32_t EEI13:1;                 /* Enable Error Interrupt 13 */
    vuint32_t EEI12:1;                 /* Enable Error Interrupt 12 */
    vuint32_t EEI11:1;                 /* Enable Error Interrupt 11 */
    vuint32_t EEI10:1;                 /* Enable Error Interrupt 10 */
    vuint32_t EEI9:1;                  /* Enable Error Interrupt 9 */
    vuint32_t EEI8:1;                  /* Enable Error Interrupt 8 */
    vuint32_t EEI7:1;                  /* Enable Error Interrupt 7 */
    vuint32_t EEI6:1;                  /* Enable Error Interrupt 6 */
    vuint32_t EEI5:1;                  /* Enable Error Interrupt 5 */
    vuint32_t EEI4:1;                  /* Enable Error Interrupt 4 */
    vuint32_t EEI3:1;                  /* Enable Error Interrupt 3 */
    vuint32_t EEI2:1;                  /* Enable Error Interrupt 2 */
    vuint32_t EEI1:1;                  /* Enable Error Interrupt 1 */
    vuint32_t EEI0:1;                  /* Enable Error Interrupt 0 */
  } B;
} DMA_EEIL_tag;

typedef union DMA_SERQ_union_tag {     /* Set Enable Request Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t SAER:1;                   /* Set All Enable Requests */
    vuint8_t SERQ:6;                   /* Set Enable Request */
  } B;
} DMA_SERQ_tag;

typedef union DMA_CERQ_union_tag {     /* Clear Enable Request Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t CAER:1;                   /* Clear All Enable Requests */
    vuint8_t CERQ:6;                   /* Clear Enable Request */
  } B;
} DMA_CERQ_tag;

typedef union DMA_SEEI_union_tag {     /* Set Enable Error Interrupt Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t SAEE:1;                   /* Sets All Enable Error Interrupts */
    vuint8_t SEEI:6;                   /* Set Enable Error Interrupt */
  } B;
} DMA_SEEI_tag;

typedef union DMA_CEEI_union_tag {     /* Clear Enable Error Interrupt Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t CAEE:1;                   /* Clear All Enable Error Interrupts */
    vuint8_t CEEI:6;                   /* Clear Enable Error Interrupt */
  } B;
} DMA_CEEI_tag;

typedef union DMA_CINT_union_tag {     /* Clear Interrupt Request Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t CAIR:1;                   /* Clear All Interrupt Requests */
    vuint8_t CINT:6;                   /* Clear Interrupt Request */
  } B;
} DMA_CINT_tag;

typedef union DMA_CERR_union_tag {     /* Clear Error Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t CAEI:1;                   /* Clear All Error Indicators */
    vuint8_t CERR:6;                   /* Clear Error Indicator */
  } B;
} DMA_CERR_tag;

typedef union DMA_SSRT_union_tag {     /* Set START Bit Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t SAST:1;                   /* Set All START Bits (activates all channels) */
    vuint8_t SSRT:6;                   /* Set START Bit */
  } B;
} DMA_SSRT_tag;

typedef union DMA_CDNE_union_tag {     /* Clear DONE Status Bit Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t CADN:1;                   /* Clears All DONE Bits */
    vuint8_t CDNE:6;                   /* Clear DONE Bit */
  } B;
} DMA_CDNE_tag;

typedef union DMA_INTH_union_tag {     /* Interrupt Request Register High */
  vuint32_t R;
  struct {
    vuint32_t INT63:1;                 /* Interrupt Request 63 */
    vuint32_t INT62:1;                 /* Interrupt Request 62 */
    vuint32_t INT61:1;                 /* Interrupt Request 61 */
    vuint32_t INT60:1;                 /* Interrupt Request 60 */
    vuint32_t INT59:1;                 /* Interrupt Request 59 */
    vuint32_t INT58:1;                 /* Interrupt Request 58 */
    vuint32_t INT57:1;                 /* Interrupt Request 57 */
    vuint32_t INT56:1;                 /* Interrupt Request 56 */
    vuint32_t INT55:1;                 /* Interrupt Request 55 */
    vuint32_t INT54:1;                 /* Interrupt Request 54 */
    vuint32_t INT53:1;                 /* Interrupt Request 53 */
    vuint32_t INT52:1;                 /* Interrupt Request 52 */
    vuint32_t INT51:1;                 /* Interrupt Request 51 */
    vuint32_t INT50:1;                 /* Interrupt Request 50 */
    vuint32_t INT49:1;                 /* Interrupt Request 49 */
    vuint32_t INT48:1;                 /* Interrupt Request 48 */
    vuint32_t INT47:1;                 /* Interrupt Request 47 */
    vuint32_t INT46:1;                 /* Interrupt Request 46 */
    vuint32_t INT45:1;                 /* Interrupt Request 45 */
    vuint32_t INT44:1;                 /* Interrupt Request 44 */
    vuint32_t INT43:1;                 /* Interrupt Request 43 */
    vuint32_t INT42:1;                 /* Interrupt Request 42 */
    vuint32_t INT41:1;                 /* Interrupt Request 41 */
    vuint32_t INT40:1;                 /* Interrupt Request 40 */
    vuint32_t INT39:1;                 /* Interrupt Request 30 */
    vuint32_t INT38:1;                 /* Interrupt Request 38 */
    vuint32_t INT37:1;                 /* Interrupt Request 37 */
    vuint32_t INT36:1;                 /* Interrupt Request 36 */
    vuint32_t INT35:1;                 /* Interrupt Request 35 */
    vuint32_t INT34:1;                 /* Interrupt Request 34 */
    vuint32_t INT33:1;                 /* Interrupt Request 33 */
    vuint32_t INT32:1;                 /* Interrupt Request 32 */
  } B;
} DMA_INTH_tag;

typedef union DMA_INTL_union_tag {     /* Interrupt Request Register Low */
  vuint32_t R;
  struct {
    vuint32_t INT31:1;                 /* Interrupt Request 31 */
    vuint32_t INT30:1;                 /* Interrupt Request 30 */
    vuint32_t INT29:1;                 /* Interrupt Request 29 */
    vuint32_t INT28:1;                 /* Interrupt Request 28 */
    vuint32_t INT27:1;                 /* Interrupt Request 27 */
    vuint32_t INT26:1;                 /* Interrupt Request 26 */
    vuint32_t INT25:1;                 /* Interrupt Request 25 */
    vuint32_t INT24:1;                 /* Interrupt Request 24 */
    vuint32_t INT23:1;                 /* Interrupt Request 23 */
    vuint32_t INT22:1;                 /* Interrupt Request 22 */
    vuint32_t INT21:1;                 /* Interrupt Request 21 */
    vuint32_t INT20:1;                 /* Interrupt Request 20 */
    vuint32_t INT19:1;                 /* Interrupt Request 19 */
    vuint32_t INT18:1;                 /* Interrupt Request 18 */
    vuint32_t INT17:1;                 /* Interrupt Request 17 */
    vuint32_t INT16:1;                 /* Interrupt Request 16 */
    vuint32_t INT15:1;                 /* Interrupt Request 15 */
    vuint32_t INT14:1;                 /* Interrupt Request 14 */
    vuint32_t INT13:1;                 /* Interrupt Request 13 */
    vuint32_t INT12:1;                 /* Interrupt Request 12 */
    vuint32_t INT11:1;                 /* Interrupt Request 11 */
    vuint32_t INT10:1;                 /* Interrupt Request 10 */
    vuint32_t INT9:1;                  /* Interrupt Request 9 */
    vuint32_t INT8:1;                  /* Interrupt Request 8 */
    vuint32_t INT7:1;                  /* Interrupt Request 7 */
    vuint32_t INT6:1;                  /* Interrupt Request 6 */
    vuint32_t INT5:1;                  /* Interrupt Request 5 */
    vuint32_t INT4:1;                  /* Interrupt Request 4 */
    vuint32_t INT3:1;                  /* Interrupt Request 3 */
    vuint32_t INT2:1;                  /* Interrupt Request 2 */
    vuint32_t INT1:1;                  /* Interrupt Request 1 */
    vuint32_t INT0:1;                  /* Interrupt Request 0 */
  } B;
} DMA_INTL_tag;

typedef union DMA_ERRH_union_tag {     /* Error Register High */
  vuint32_t R;
  struct {
    vuint32_t ERR63:1;                 /* Error In Channel 63 */
    vuint32_t ERR62:1;                 /* Error In Channel 62 */
    vuint32_t ERR61:1;                 /* Error In Channel 61 */
    vuint32_t ERR60:1;                 /* Error In Channel 60 */
    vuint32_t ERR59:1;                 /* Error In Channel 59 */
    vuint32_t ERR58:1;                 /* Error In Channel 58 */
    vuint32_t ERR57:1;                 /* Error In Channel 57 */
    vuint32_t ERR56:1;                 /* Error In Channel 56 */
    vuint32_t ERR55:1;                 /* Error In Channel 55 */
    vuint32_t ERR54:1;                 /* Error In Channel 54 */
    vuint32_t ERR53:1;                 /* Error In Channel 53 */
    vuint32_t ERR52:1;                 /* Error In Channel 52 */
    vuint32_t ERR51:1;                 /* Error In Channel 51 */
    vuint32_t ERR50:1;                 /* Error In Channel 50 */
    vuint32_t ERR49:1;                 /* Error In Channel 49 */
    vuint32_t ERR48:1;                 /* Error In Channel 48 */
    vuint32_t ERR47:1;                 /* Error In Channel 47 */
    vuint32_t ERR46:1;                 /* Error In Channel 46 */
    vuint32_t ERR45:1;                 /* Error In Channel 45 */
    vuint32_t ERR44:1;                 /* Error In Channel 44 */
    vuint32_t ERR43:1;                 /* Error In Channel 43 */
    vuint32_t ERR42:1;                 /* Error In Channel 42 */
    vuint32_t ERR41:1;                 /* Error In Channel 41 */
    vuint32_t ERR40:1;                 /* Error In Channel 40 */
    vuint32_t ERR39:1;                 /* Error In Channel 39 */
    vuint32_t ERR38:1;                 /* Error In Channel 38 */
    vuint32_t ERR37:1;                 /* Error In Channel 37 */
    vuint32_t ERR36:1;                 /* Error In Channel 36 */
    vuint32_t ERR35:1;                 /* Error In Channel 35 */
    vuint32_t ERR34:1;                 /* Error In Channel 34 */
    vuint32_t ERR33:1;                 /* Error In Channel 33 */
    vuint32_t ERR32:1;                 /* Error In Channel 32 */
  } B;
} DMA_ERRH_tag;

typedef union DMA_ERRL_union_tag {     /* Error Register Low */
  vuint32_t R;
  struct {
    vuint32_t ERR31:1;                 /* Error In Channel 31 */
    vuint32_t ERR30:1;                 /* Error In Channel 30 */
    vuint32_t ERR29:1;                 /* Error In Channel 29 */
    vuint32_t ERR28:1;                 /* Error In Channel 28 */
    vuint32_t ERR27:1;                 /* Error In Channel 27 */
    vuint32_t ERR26:1;                 /* Error In Channel 26 */
    vuint32_t ERR25:1;                 /* Error In Channel 25 */
    vuint32_t ERR24:1;                 /* Error In Channel 24 */
    vuint32_t ERR23:1;                 /* Error In Channel 23 */
    vuint32_t ERR22:1;                 /* Error In Channel 22 */
    vuint32_t ERR21:1;                 /* Error In Channel 21 */
    vuint32_t ERR20:1;                 /* Error In Channel 20 */
    vuint32_t ERR19:1;                 /* Error In Channel 19 */
    vuint32_t ERR18:1;                 /* Error In Channel 18 */
    vuint32_t ERR17:1;                 /* Error In Channel 17 */
    vuint32_t ERR16:1;                 /* Error In Channel 16 */
    vuint32_t ERR15:1;                 /* Error In Channel 15 */
    vuint32_t ERR14:1;                 /* Error In Channel 14 */
    vuint32_t ERR13:1;                 /* Error In Channel 13 */
    vuint32_t ERR12:1;                 /* Error In Channel 12 */
    vuint32_t ERR11:1;                 /* Error In Channel 11 */
    vuint32_t ERR10:1;                 /* Error In Channel 10 */
    vuint32_t ERR9:1;                  /* Error In Channel 9 */
    vuint32_t ERR8:1;                  /* Error In Channel 8 */
    vuint32_t ERR7:1;                  /* Error In Channel 7 */
    vuint32_t ERR6:1;                  /* Error In Channel 6 */
    vuint32_t ERR5:1;                  /* Error In Channel 5 */
    vuint32_t ERR4:1;                  /* Error In Channel 4 */
    vuint32_t ERR3:1;                  /* Error In Channel 3 */
    vuint32_t ERR2:1;                  /* Error In Channel 2 */
    vuint32_t ERR1:1;                  /* Error In Channel 1 */
    vuint32_t ERR0:1;                  /* Error In Channel 0 */
  } B;
} DMA_ERRL_tag;

typedef union DMA_HRSH_union_tag {     /* Hardware Request Status Register High */
  vuint32_t R;
  struct {
    vuint32_t HRS63:1;                 /* Hardware Request Status Channel 63 */
    vuint32_t HRS62:1;                 /* Hardware Request Status Channel 62 */
    vuint32_t HRS61:1;                 /* Hardware Request Status Channel 61 */
    vuint32_t HRS60:1;                 /* Hardware Request Status Channel 60 */
    vuint32_t HRS59:1;                 /* Hardware Request Status Channel 59 */
    vuint32_t HRS58:1;                 /* Hardware Request Status Channel 58 */
    vuint32_t HRS57:1;                 /* Hardware Request Status Channel 57 */
    vuint32_t HRS56:1;                 /* Hardware Request Status Channel 56 */
    vuint32_t HRS55:1;                 /* Hardware Request Status Channel 55 */
    vuint32_t HRS54:1;                 /* Hardware Request Status Channel 54 */
    vuint32_t HRS53:1;                 /* Hardware Request Status Channel 53 */
    vuint32_t HRS52:1;                 /* Hardware Request Status Channel 52 */
    vuint32_t HRS51:1;                 /* Hardware Request Status Channel 51 */
    vuint32_t HRS50:1;                 /* Hardware Request Status Channel 50 */
    vuint32_t HRS49:1;                 /* Hardware Request Status Channel 49 */
    vuint32_t HRS48:1;                 /* Hardware Request Status Channel 48 */
    vuint32_t HRS47:1;                 /* Hardware Request Status Channel 47 */
    vuint32_t HRS46:1;                 /* Hardware Request Status Channel 46 */
    vuint32_t HRS45:1;                 /* Hardware Request Status Channel 45 */
    vuint32_t HRS44:1;                 /* Hardware Request Status Channel 44 */
    vuint32_t HRS43:1;                 /* Hardware Request Status Channel 43 */
    vuint32_t HRS42:1;                 /* Hardware Request Status Channel 42 */
    vuint32_t HRS41:1;                 /* Hardware Request Status Channel 41 */
    vuint32_t HRS40:1;                 /* Hardware Request Status Channel 40 */
    vuint32_t HRS39:1;                 /* Hardware Request Status Channel 39 */
    vuint32_t HRS38:1;                 /* Hardware Request Status Channel 38 */
    vuint32_t HRS37:1;                 /* Hardware Request Status Channel 37 */
    vuint32_t HRS36:1;                 /* Hardware Request Status Channel 36 */
    vuint32_t HRS35:1;                 /* Hardware Request Status Channel 35 */
    vuint32_t HRS34:1;                 /* Hardware Request Status Channel 34 */
    vuint32_t HRS33:1;                 /* Hardware Request Status Channel 33 */
    vuint32_t HRS32:1;                 /* Hardware Request Status Channel 32 */
  } B;
} DMA_HRSH_tag;

typedef union DMA_HRSL_union_tag {     /* Hardware Request Status Register Low */
  vuint32_t R;
  struct {
    vuint32_t HRS31:1;                 /* Hardware Request Status Channel 31 */
    vuint32_t HRS30:1;                 /* Hardware Request Status Channel 30 */
    vuint32_t HRS29:1;                 /* Hardware Request Status Channel 29 */
    vuint32_t HRS28:1;                 /* Hardware Request Status Channel 28 */
    vuint32_t HRS27:1;                 /* Hardware Request Status Channel 27 */
    vuint32_t HRS26:1;                 /* Hardware Request Status Channel 26 */
    vuint32_t HRS25:1;                 /* Hardware Request Status Channel 25 */
    vuint32_t HRS24:1;                 /* Hardware Request Status Channel 24 */
    vuint32_t HRS23:1;                 /* Hardware Request Status Channel 23 */
    vuint32_t HRS22:1;                 /* Hardware Request Status Channel 22 */
    vuint32_t HRS21:1;                 /* Hardware Request Status Channel 21 */
    vuint32_t HRS20:1;                 /* Hardware Request Status Channel 20 */
    vuint32_t HRS19:1;                 /* Hardware Request Status Channel 19 */
    vuint32_t HRS18:1;                 /* Hardware Request Status Channel 18 */
    vuint32_t HRS17:1;                 /* Hardware Request Status Channel 17 */
    vuint32_t HRS16:1;                 /* Hardware Request Status Channel 16 */
    vuint32_t HRS15:1;                 /* Hardware Request Status Channel 15 */
    vuint32_t HRS14:1;                 /* Hardware Request Status Channel 14 */
    vuint32_t HRS13:1;                 /* Hardware Request Status Channel 13 */
    vuint32_t HRS12:1;                 /* Hardware Request Status Channel 12 */
    vuint32_t HRS11:1;                 /* Hardware Request Status Channel 11 */
    vuint32_t HRS10:1;                 /* Hardware Request Status Channel 10 */
    vuint32_t HRS9:1;                  /* Hardware Request Status Channel 9 */
    vuint32_t HRS8:1;                  /* Hardware Request Status Channel 8 */
    vuint32_t HRS7:1;                  /* Hardware Request Status Channel 7 */
    vuint32_t HRS6:1;                  /* Hardware Request Status Channel 6 */
    vuint32_t HRS5:1;                  /* Hardware Request Status Channel 5 */
    vuint32_t HRS4:1;                  /* Hardware Request Status Channel 4 */
    vuint32_t HRS3:1;                  /* Hardware Request Status Channel 3 */
    vuint32_t HRS2:1;                  /* Hardware Request Status Channel 2 */
    vuint32_t HRS1:1;                  /* Hardware Request Status Channel 1 */
    vuint32_t HRS0:1;                  /* Hardware Request Status Channel 0 */
  } B;
} DMA_HRSL_tag;

typedef union DMA_GPOR_union_tag {     /* Global PCU Output Register */
  vuint32_t R;
  struct {
    vuint32_t GPOR:32;                 /* Global channel write control */
  } B;
} DMA_GPOR_tag;

typedef union DMA_DCHPRI_union_tag {   /* Channel n Priority Register */
  vuint8_t R;
  struct {
    vuint8_t ECP:1;                    /* Enable Channel Preemption. This field resets to 0. */
    vuint8_t DPA:1;                    /* Disable Preempt Ability. This field resets to 0. */
    vuint8_t GRPPRI:2;                 /* Channel n Current Group Priority */
    vuint8_t CHPRI:4;                  /* Channel n Arbitration Priority */
  } B;
} DMA_DCHPRI_tag;

typedef union DMA_TCD_SADDR_union_tag { /* TCD Source Address */
  vuint32_t R;
  struct {
    vuint32_t SADDR:32;                /* Source Address */
  } B;
} DMA_TCD_SADDR_tag;

typedef union DMA_TCD_ATTR_union_tag { /* TCD Transfer Attributes */
  vuint16_t R;
  struct {
    vuint16_t SMOD:5;                  /* Source Address Modulo */
    vuint16_t SSIZE:3;                 /* Source data transfer size */
    vuint16_t DMOD:5;                  /* Destination Address Modulo */
    vuint16_t DSIZE:3;                 /* Destination data transfer size */
  } B;
} DMA_TCD_ATTR_tag;

typedef union DMA_TCD_SOFF_union_tag { /* TCD Signed Source Address Offset */
  vuint16_t R;
  struct {
    vuint16_t SOFF:16;                 /* Source address signed offset */
  } B;
} DMA_TCD_SOFF_tag;

typedef union DMA_TCD_NBYTES_MLNO_union_tag { /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
  vuint32_t R;
  struct {
    vuint32_t NBYTES:32;               /* Minor Byte Transfer Count */
  } B;
} DMA_TCD_NBYTES_MLNO_tag;

typedef union DMA_TCD_NBYTES_MLOFFNO_union_tag { /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
  vuint32_t R;
  struct {
    vuint32_t SMLOE:1;                 /* Source Minor Loop Offset Enable */
    vuint32_t DMLOE:1;                 /* Destination Minor Loop Offset enable */
    vuint32_t NBYTES:30;               /* Minor Byte Transfer Count */
  } B;
} DMA_TCD_NBYTES_MLOFFNO_tag;

typedef union DMA_TCD_NBYTES_MLOFFYES_union_tag { /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
  vuint32_t R;
  struct {
    vuint32_t SMLOE:1;                 /* Source Minor Loop Offset Enable */
    vuint32_t DMLOE:1;                 /* Destination Minor Loop Offset enable */
    vuint32_t MLOFF:20;                /* If SMLOE or DMLOE is set, this field represents a sign-extended offset applied to the source or destination address to form the next-state value after the minor loop completes. */
    vuint32_t NBYTES:10;               /* Minor Byte Transfer Count */
  } B;
} DMA_TCD_NBYTES_MLOFFYES_tag;

typedef union DMA_TCD_NBYTES_union_tag {
  DMA_TCD_NBYTES_MLNO_tag MLNO;        /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
  DMA_TCD_NBYTES_MLOFFNO_tag MLOFFNO;  /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
  DMA_TCD_NBYTES_MLOFFYES_tag MLOFFYES; /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
} DMA_TCD_NBYTES_tag;

typedef union DMA_TCD_SLAST_union_tag { /* TCD Last Source Address Adjustment */
  vuint32_t R;
  struct {
    vuint32_t SLAST:32;                /* Last Source Address Adjustment */
  } B;
} DMA_TCD_SLAST_tag;

typedef union DMA_TCD_DADDR_union_tag { /* TCD Destination Address */
  vuint32_t R;
  struct {
    vuint32_t DADDR:32;                /* Destination Address */
  } B;
} DMA_TCD_DADDR_tag;

typedef union DMA_TCD_CITER_ELINKNO_union_tag { /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
  vuint16_t R;
  struct {
    vuint16_t ELINK:1;                 /* Enable channel-to-channel linking on minor-loop complete */
    vuint16_t CITER:15;                /* Current Major Iteration Count */
  } B;
} DMA_TCD_CITER_ELINKNO_tag;

typedef union DMA_TCD_CITER_ELINKYES_union_tag { /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
  vuint16_t R;
  struct {
    vuint16_t ELINK:1;                 /* Enable channel-to-channel linking on minor-loop complete */
    vuint16_t LINKCH:6;                /* Minor Loop Link Channel Number */
    vuint16_t CITER:9;                 /* Current Major Iteration Count */
  } B;
} DMA_TCD_CITER_ELINKYES_tag;

typedef union DMA_TCD_CITER_union_tag {
  DMA_TCD_CITER_ELINKNO_tag ELINKNO;   /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
  DMA_TCD_CITER_ELINKYES_tag ELINKYES; /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
} DMA_TCD_CITER_tag;

typedef union DMA_TCD_DOFF_union_tag { /* TCD Signed Destination Address Offset */
  vuint16_t R;
  struct {
    vuint16_t DOFF:16;                 /* Destination Address Signed Offset */
  } B;
} DMA_TCD_DOFF_tag;

typedef union DMA_TCD_DLASTSGA_union_tag { /* TCD Last Destination Address Adjustment/Scatter Gather Address */
  vuint32_t R;
  struct {
    vuint32_t DLASTSGA:32;
  } B;
} DMA_TCD_DLASTSGA_tag;

typedef union DMA_TCD_BITER_ELINKNO_union_tag { /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
  vuint16_t R;
  struct {
    vuint16_t ELINK:1;                 /* Enables channel-to-channel linking on minor loop complete */
    vuint16_t BITER:15;                /* Starting Major Iteration Count */
  } B;
} DMA_TCD_BITER_ELINKNO_tag;

typedef union DMA_TCD_BITER_ELINKYES_union_tag { /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
  vuint16_t R;
  struct {
    vuint16_t ELINK:1;                 /* Enables channel-to-channel linking on minor loop complete */
    vuint16_t LINKCH:6;                /* Link Channel Number */
    vuint16_t BITER:9;                 /* Starting major iteration count */
  } B;
} DMA_TCD_BITER_ELINKYES_tag;

typedef union DMA_TCD_BITER_union_tag {
  DMA_TCD_BITER_ELINKNO_tag ELINKNO;   /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
  DMA_TCD_BITER_ELINKYES_tag ELINKYES; /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
} DMA_TCD_BITER_tag;

typedef union DMA_TCD_CSR_union_tag {  /* TCD Control and Status */
  vuint16_t R;
  struct {
    vuint16_t BWC:2;                   /* Bandwidth Control */
    vuint16_t MAJORLINKCH:6;           /* Major Loop Link Channel Number */
    vuint16_t DONE:1;                  /* Channel Done */
    vuint16_t ACTIVE:1;                /* Channel Active */
    vuint16_t MAJORELINK:1;            /* Enable channel-to-channel linking on major loop complete */
    vuint16_t ESG:1;                   /* Enable Scatter/Gather Processing */
    vuint16_t DREQ:1;                  /* Disable Request */
    vuint16_t INTHALF:1;               /* Enable an interrupt when major counter is half complete. */
    vuint16_t INTMAJOR:1;              /* Enable an interrupt when major iteration count completes. */
    vuint16_t START:1;                 /* Channel Start */
  } B;
} DMA_TCD_CSR_tag;

typedef struct DMA_TCD_struct_tag {
  DMA_TCD_SADDR_tag SADDR;             /* TCD Source Address */
  DMA_TCD_ATTR_tag ATTR;               /* TCD Transfer Attributes */
  DMA_TCD_SOFF_tag SOFF;               /* TCD Signed Source Address Offset */
  DMA_TCD_NBYTES_tag NBYTES;
  DMA_TCD_SLAST_tag SLAST;             /* TCD Last Source Address Adjustment */
  DMA_TCD_DADDR_tag DADDR;             /* TCD Destination Address */
  DMA_TCD_CITER_tag CITER;
  DMA_TCD_DOFF_tag DOFF;               /* TCD Signed Destination Address Offset */
  DMA_TCD_DLASTSGA_tag DLASTSGA;       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
  DMA_TCD_BITER_tag BITER;
  DMA_TCD_CSR_tag CSR;                 /* TCD Control and Status */
} DMA_TCD_tag;

struct DMA_tag {
  DMA_CR_tag CR;                       /* Control Register */
  DMA_ES_tag ES;                       /* Error Status Register */
  DMA_ERQH_tag ERQH;                   /* Enable Request Register High */
  DMA_ERQL_tag ERQL;                   /* Enable Request Register Low */
  DMA_EEIH_tag EEIH;                   /* Enable Error Interrupt Register High */
  DMA_EEIL_tag EEIL;                   /* Enable Error Interrupt Register Low */
  DMA_SERQ_tag SERQ;                   /* Set Enable Request Register */
  DMA_CERQ_tag CERQ;                   /* Clear Enable Request Register */
  DMA_SEEI_tag SEEI;                   /* Set Enable Error Interrupt Register */
  DMA_CEEI_tag CEEI;                   /* Clear Enable Error Interrupt Register */
  DMA_CINT_tag CINT;                   /* Clear Interrupt Request Register */
  DMA_CERR_tag CERR;                   /* Clear Error Register */
  DMA_SSRT_tag SSRT;                   /* Set START Bit Register */
  DMA_CDNE_tag CDNE;                   /* Clear DONE Status Bit Register */
  DMA_INTH_tag INTH;                   /* Interrupt Request Register High */
  DMA_INTL_tag INTL;                   /* Interrupt Request Register Low */
  DMA_ERRH_tag ERRH;                   /* Error Register High */
  DMA_ERRL_tag ERRL;                   /* Error Register Low */
  DMA_HRSH_tag HRSH;                   /* Hardware Request Status Register High */
  DMA_HRSL_tag HRSL;                   /* Hardware Request Status Register Low */
  DMA_GPOR_tag GPOR[2];                /* Global PCU Output Register */
  uint8_t DMA_reserved0[192];
  DMA_DCHPRI_tag DCHPRI[64];           /* Channel n Priority Register */
  uint8_t DMA_reserved1[3776];
  DMA_TCD_tag TCD[64];
};


/* ============================================================================
   =============================== Module: DSPI ===============================
   ============================================================================ */

typedef union DSPI_MCR_union_tag {     /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MSTR:1;                  /* Master/Slave Mode Select */
    vuint32_t CONT_SCKE:1;             /* Continuous SCK Enable */
    vuint32_t DCONF:2;                 /* Interface Configuration */
    vuint32_t FRZ:1;                   /* Freeze */
    vuint32_t MTFE:1;                  /* Modified Transfer Format Enable */
    vuint32_t PCSSE:1;                 /* Peripheral Chip Select Strobe Enable */
    vuint32_t ROOE:1;                  /* Receive FIFO Overflow Overwrite Enable */
    vuint32_t  :2;                     /* Always write the reset value to this field. */
    vuint32_t PCSIS:6;                 /* Peripheral Chip Select x Inactive State */
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t DIS_TXF:1;               /* Disable Transmit FIFO */
    vuint32_t DIS_RXF:1;               /* Disable Receive FIFO */
    vuint32_t CLR_TXF:1;               /* Clear TX FIFO */
    vuint32_t CLR_RXF:1;               /* CLR_RXF */
    vuint32_t SMPL_PT:2;               /* Sample Point */
    vuint32_t  :5;
    vuint32_t  :1;
    vuint32_t PES:1;                   /* Parity Error Stop */
    vuint32_t HALT:1;                  /* Halt */
  } B;
} DSPI_MCR_tag;

typedef union DSPI_TCR_union_tag {     /* Transfer Count Register */
  vuint32_t R;
  struct {
    vuint32_t SPI_TCNT:16;             /* SPI Transfer Counter */
    vuint32_t  :16;
  } B;
} DSPI_TCR_tag;

typedef union DSPI_MODE_CTAR_union_tag { /* Clock and Transfer Attributes Register (In Master Mode) */
  vuint32_t R;
  struct {
    vuint32_t DBR:1;                   /* Double Baud Rate */
    vuint32_t FMSZ:4;                  /* Frame Size */
    vuint32_t CPOL:1;                  /* Clock Polarity */
    vuint32_t CPHA:1;                  /* Clock Phase */
    vuint32_t LSBFE:1;                 /* LSB First */
    vuint32_t PCSSCK:2;                /* PCS to SCK Delay Prescaler */
    vuint32_t PASC:2;                  /* After SCK Delay Prescaler */
    vuint32_t PDT:2;                   /* Delay after Transfer Prescaler */
    vuint32_t PBR:2;                   /* Baud Rate Prescaler */
    vuint32_t CSSCK:4;                 /* PCS to SCK Delay Scaler */
    vuint32_t ASC:4;                   /* After SCK Delay Scaler */
    vuint32_t DT:4;                    /* Delay After Transfer Scaler */
    vuint32_t BR:4;                    /* Baud Rate Scaler */
  } B;
} DSPI_MODE_CTAR_tag;

typedef union DSPI_MODE_CTAR_SLAVE_union_tag { /* Clock and Transfer Attributes Register (In Slave Mode) */
  vuint32_t R;
  struct {
    vuint32_t  :1;                     /* Always write the reset value to this field. */
    vuint32_t FMSZ:4;                  /* Frame Size */
    vuint32_t CPOL:1;                  /* Clock Polarity */
    vuint32_t CPHA:1;                  /* Clock Phase */
    vuint32_t PE:1;                    /* Parity Enable */
    vuint32_t PP:1;                    /* Parity Polarity */
    vuint32_t  :1;
    vuint32_t  :22;
  } B;
} DSPI_MODE_CTAR_SLAVE_tag;

typedef union DSPI_MODE_union_tag {
  DSPI_MODE_CTAR_tag CTAR[8];          /* Clock and Transfer Attributes Register (In Master Mode) */
  DSPI_MODE_CTAR_SLAVE_tag CTAR_SLAVE[2]; /* Clock and Transfer Attributes Register (In Slave Mode) */
} DSPI_MODE_tag;

typedef union DSPI_SR_union_tag {      /* Status Register */
  vuint32_t R;
  struct {
    vuint32_t TCF:1;                   /* Transfer Complete Flag */
    vuint32_t TXRXS:1;                 /* TX and RX Status */
    vuint32_t  :1;
    vuint32_t EOQF:1;                  /* End of Queue Flag */
    vuint32_t TFUF:1;                  /* Transmit FIFO Underflow Flag */
    vuint32_t  :1;
    vuint32_t TFFF:1;                  /* Transmit FIFO Fill Flag */
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t DPEF:1;                  /* DSI Parity Error Flag */
    vuint32_t SPEF:1;                  /* SPI Parity Error Flag */
    vuint32_t DDIF:1;                  /* DSI Data Received with Active Bits */
    vuint32_t RFOF:1;                  /* Receive FIFO Overflow Flag */
    vuint32_t  :1;
    vuint32_t RFDF:1;                  /* Receive FIFO Drain Flag */
    vuint32_t  :1;
    vuint32_t TXCTR:4;                 /* TX FIFO Counter */
    vuint32_t TXNXTPTR:4;              /* Transmit Next Pointer */
    vuint32_t RXCTR:4;                 /* RX FIFO Counter */
    vuint32_t POPNXTPTR:4;             /* Pop Next Pointer */
  } B;
} DSPI_SR_tag;

typedef union DSPI_RSER_union_tag {    /* DMA/Interrupt Request Select and Enable Register */
  vuint32_t R;
  struct {
    vuint32_t TCF_RE:1;                /* Transmission Complete Request Enable */
    vuint32_t  :1;                     /* Always write the reset value to this field. */
    vuint32_t  :1;
    vuint32_t EOQF_RE:1;               /* Finished Request Enable */
    vuint32_t TFUF_RE:1;               /* Transmit FIFO Underflow Request Enable */
    vuint32_t  :1;
    vuint32_t TFFF_RE:1;               /* Transmit FIFO Fill Request Enable */
    vuint32_t TFFF_DIRS:1;             /* Transmit FIFO Fill DMA or Interrupt Request Select */
    vuint32_t  :1;                     /* Always write the reset value to this field. */
    vuint32_t DPEF_RE:1;               /* DSI Parity Error Request Enable */
    vuint32_t SPEF_RE:1;               /* SPI Parity Error Request Enable */
    vuint32_t DDIF_RE:1;               /* DSI data received with active bits Request Enable */
    vuint32_t RFOF_RE:1;               /* Receive FIFO Overflow Request Enable */
    vuint32_t  :1;                     /* Always write the reset value to this field. */
    vuint32_t RFDF_RE:1;               /* Receive FIFO Drain Request Enable */
    vuint32_t RFDF_DIRS:1;             /* Receive FIFO Drain DMA or Interrupt Request Select */
    vuint32_t  :1;                     /* Always write the reset value to this field. */
    vuint32_t  :1;                     /* Always write the reset value to this field. */
    vuint32_t  :14;
  } B;
} DSPI_RSER_tag;

typedef union DSPI_PUSHR_PUSHR_union_tag { /* PUSH TX FIFO Register In Master Mode */
  vuint32_t R;
  struct {
    vuint32_t CONT:1;                  /* Continuous Peripheral Chip Select Enable */
    vuint32_t CTAS:3;                  /* Clock and Transfer Attributes Select */
    vuint32_t EOQ:1;                   /* End Of Queue */
    vuint32_t CTCNT:1;                 /* Clear Transfer Counter */
    vuint32_t PE:1;                    /* Parity Enable */
    vuint32_t PP:1;                    /* Parity Polarity */
    vuint32_t  :2;                     /* Always write the reset value to this field. */
    vuint32_t PCS:6;
    vuint32_t TXDATA:16;               /* Transmit Data */
  } B;
} DSPI_PUSHR_PUSHR_tag;

typedef union DSPI_PUSHR_PUSHR_SLAVE_union_tag { /* PUSH TX FIFO Register In Slave Mode */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t TXDATA:16;               /* Transmit Data */
  } B;
} DSPI_PUSHR_PUSHR_SLAVE_tag;

typedef union DSPI_PUSHR_union_tag {
  DSPI_PUSHR_PUSHR_tag PUSHR;          /* PUSH TX FIFO Register In Master Mode */
  DSPI_PUSHR_PUSHR_SLAVE_tag PUSHR_SLAVE; /* PUSH TX FIFO Register In Slave Mode */
} DSPI_PUSHR_tag;

typedef union DSPI_POPR_union_tag {    /* POP RX FIFO Register */
  vuint32_t R;
  struct {
    vuint32_t RXDATA:32;               /* Received Data */
  } B;
} DSPI_POPR_tag;

typedef union DSPI_TXFR_union_tag {    /* Transmit FIFO Registers */
  vuint32_t R;
  struct {
    vuint32_t TXCMD_TXDATA:16;         /* Transmit Command or Transmit Data */
    vuint32_t TXDATA:16;               /* Transmit Data */
  } B;
} DSPI_TXFR_tag;

typedef union DSPI_RXFR_union_tag {    /* Receive FIFO Registers */
  vuint32_t R;
  struct {
    vuint32_t RXDATA:32;               /* Receive Data */
  } B;
} DSPI_RXFR_tag;

typedef union DSPI_DSICR0_union_tag {  /* DSI Configuration Register 0 */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t FMSZ4:1;                 /* MSB of the frame size in master mode. */
    vuint32_t  :6;
    vuint32_t  :1;
    vuint32_t  :2;
    vuint32_t TSBC:1;                  /* Timed Serial Bus Configuration. */
    vuint32_t TXSS:1;                  /* Transmit Data Source Select. */
    vuint32_t TPOL:1;                  /* Trigger Polarity */
    vuint32_t TRRE:1;                  /* Trigger Reception Enable */
    vuint32_t CID:1;                   /* Change In Data Transfer Enable */
    vuint32_t DCONT:1;                 /* DSI Continuous Peripheral Chip Select Enable */
    vuint32_t DSICTAS:3;               /* DSI Clock and Transfer Attributes Select */
    vuint32_t DMS:1;                   /* Data Match Stop */
    vuint32_t PES:1;                   /* Parity Error Stop */
    vuint32_t PE:1;                    /* Parity Enable */
    vuint32_t PP:1;                    /* Parity Polarity */
    vuint32_t DPCSx:8;                 /* DSI Peripheral Chip Select 0-7 */
  } B;
} DSPI_DSICR0_tag;

typedef union DSPI_SDR0_union_tag {    /* DSI Serialization Data Register 0 */
  vuint32_t R;
  struct {
    vuint32_t SER_DATA:32;             /* Serialized Data */
  } B;
} DSPI_SDR0_tag;

typedef union DSPI_ASDR0_union_tag {   /* DSI Alternate Serialization Data Register 0 */
  vuint32_t R;
  struct {
    vuint32_t ASER_DATA:32;            /* Alternate Serialized Data */
  } B;
} DSPI_ASDR0_tag;

typedef union DSPI_COMPR0_union_tag {  /* DSI Transmit Comparison Register 0 */
  vuint32_t R;
  struct {
    vuint32_t COMP_DATA:32;            /* Compare Data */
  } B;
} DSPI_COMPR0_tag;

typedef union DSPI_DDR0_union_tag {    /* DSI Deserialization Data Register 0 */
  vuint32_t R;
  struct {
    vuint32_t DESER_DATA:32;           /* Deserialized Data */
  } B;
} DSPI_DDR0_tag;

typedef union DSPI_DSICR1_union_tag {  /* DSI Configuration Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :3;
    vuint32_t TSBCNT:5;                /* Timed Serial Bus Operation Count */
    vuint32_t  :3;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t DSE1:1;                  /* Data Select Enable 1 */
    vuint32_t DSE0:1;                  /* Data Select Enable 0 */
    vuint32_t  :8;
    vuint32_t DPCS1_x:8;               /* DSI Peripheral Chip Select 0-7 */
  } B;
} DSPI_DSICR1_tag;

typedef union DSPI_SSR0_union_tag {    /* DSI Serialization Source Select Register 0 */
  vuint32_t R;
  struct {
    vuint32_t SS:32;                   /* Source Select */
  } B;
} DSPI_SSR0_tag;

typedef union DSPI_PISR0_union_tag {   /* DSI Parallel Input Select Register 0 */
  vuint32_t R;
  struct {
    vuint32_t IPS7:4;                  /* Input Pin Select 7 */
    vuint32_t IPS6:4;                  /* Input Pin Select 6 */
    vuint32_t IPS5:4;                  /* Input Pin Select 5 */
    vuint32_t IPS4:4;                  /* Input Pin Select 5 */
    vuint32_t IPS3:4;                  /* Input Pin Select 3 */
    vuint32_t IPS2:4;                  /* Input Pin Select 2 */
    vuint32_t IPS1:4;                  /* Input Pin Select 1 */
    vuint32_t IPS0:4;                  /* Input Pin Select 0 */
  } B;
} DSPI_PISR0_tag;

typedef union DSPI_PISR1_union_tag {   /* DSI Parallel Input Select Register 1 */
  vuint32_t R;
  struct {
    vuint32_t IPS15:4;                 /* Input Pin Select 15 */
    vuint32_t IPS14:4;                 /* Input Pin Select 14 */
    vuint32_t IPS13:4;                 /* Input Pin Select 13 */
    vuint32_t IPS12:4;                 /* Input Pin Select 12 */
    vuint32_t IPS11:4;                 /* Input Pin Select 11 */
    vuint32_t IPS10:4;                 /* Input Pin Select 10 */
    vuint32_t IPS9:4;                  /* Input Pin Select 9 */
    vuint32_t IPS8:4;                  /* Input Pin Select 8 */
  } B;
} DSPI_PISR1_tag;

typedef union DSPI_PISR2_union_tag {   /* DSI Parallel Input Select Register 2 */
  vuint32_t R;
  struct {
    vuint32_t IPS23:4;                 /* Input Pin Select 23 */
    vuint32_t IPS22:4;                 /* Input Pin Select 22 */
    vuint32_t IPS21:4;                 /* Input Pin Select 21 */
    vuint32_t IPS20:4;                 /* Input Pin Select 20 */
    vuint32_t IPS19:4;                 /* Input Pin Select 19 */
    vuint32_t IPS18:4;                 /* Input Pin Select 18 */
    vuint32_t IPS17:4;                 /* Input Pin Select 17 */
    vuint32_t IPS16:4;                 /* Input Pin Select 16 */
  } B;
} DSPI_PISR2_tag;

typedef union DSPI_PISR3_union_tag {   /* DSI Parallel Input Select Register 3 */
  vuint32_t R;
  struct {
    vuint32_t IPS31:4;                 /* Input Pin Select 31 */
    vuint32_t IPS30:4;                 /* Input Pin Select 30 */
    vuint32_t IPS29:4;                 /* Input Pin Select 29 */
    vuint32_t IPS28:4;                 /* Input Pin Select 28 */
    vuint32_t IPS27:4;                 /* Input Pin Select 27 */
    vuint32_t IPS26:4;                 /* Input Pin Select 26 */
    vuint32_t IPS25:4;                 /* Input Pin Select 25 */
    vuint32_t IPS24:4;                 /* Input Pin Select 24 */
  } B;
} DSPI_PISR3_tag;

typedef union DSPI_DIMR0_union_tag {   /* DSI Deserialized Data Interrupt Mask Register 0 */
  vuint32_t R;
  struct {
    vuint32_t MASK:32;                 /* Mask */
  } B;
} DSPI_DIMR0_tag;

typedef union DSPI_DPIR0_union_tag {   /* DSI Deserialized Data Polarity Interrupt Register 0 */
  vuint32_t R;
  struct {
    vuint32_t DP:32;                   /* Data Polarity */
  } B;
} DSPI_DPIR0_tag;

typedef union DSPI_SREX_union_tag {    /* Status Register Extended */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t CMDCTR:4;                /* CMD FIFO Counter */
    vuint32_t CMDNXTPTR:4;             /* Command Next Pointer */
  } B;
} DSPI_SREX_tag;

struct DSPI_tag {
  DSPI_MCR_tag MCR;                    /* Module Configuration Register */
  uint8_t DSPI_reserved0[4];
  DSPI_TCR_tag TCR;                    /* Transfer Count Register */
  DSPI_MODE_tag MODE;
  DSPI_SR_tag SR;                      /* Status Register */
  DSPI_RSER_tag RSER;                  /* DMA/Interrupt Request Select and Enable Register */
  DSPI_PUSHR_tag PUSHR;
  DSPI_POPR_tag POPR;                  /* POP RX FIFO Register */
  DSPI_TXFR_tag TXFR[4];               /* Transmit FIFO Registers */
  uint8_t DSPI_reserved1[48];
  DSPI_RXFR_tag RXFR[4];               /* Receive FIFO Registers */
  uint8_t DSPI_reserved2[48];
  DSPI_DSICR0_tag DSICR0;              /* DSI Configuration Register 0 */
  DSPI_SDR0_tag SDR0;                  /* DSI Serialization Data Register 0 */
  DSPI_ASDR0_tag ASDR0;                /* DSI Alternate Serialization Data Register 0 */
  DSPI_COMPR0_tag COMPR0;              /* DSI Transmit Comparison Register 0 */
  DSPI_DDR0_tag DDR0;                  /* DSI Deserialization Data Register 0 */
  DSPI_DSICR1_tag DSICR1;              /* DSI Configuration Register 1 */
  DSPI_SSR0_tag SSR0;                  /* DSI Serialization Source Select Register 0 */
  DSPI_PISR0_tag PISR0;                /* DSI Parallel Input Select Register 0 */
  DSPI_PISR1_tag PISR1;                /* DSI Parallel Input Select Register 1 */
  DSPI_PISR2_tag PISR2;                /* DSI Parallel Input Select Register 2 */
  DSPI_PISR3_tag PISR3;                /* DSI Parallel Input Select Register 3 */
  DSPI_DIMR0_tag DIMR0;                /* DSI Deserialized Data Interrupt Mask Register 0 */
  DSPI_DPIR0_tag DPIR0;                /* DSI Deserialized Data Polarity Interrupt Register 0 */
  uint8_t DSPI_reserved3[76];
  DSPI_SREX_tag SREX;                  /* Status Register Extended */
};


/* ============================================================================
   =============================== Module: DTS ================================
   ============================================================================ */

typedef union DTS_ENABLE_union_tag {   /* Output Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :30;
    vuint32_t DTS_EN_B:1;
    vuint32_t DTS_EN:1;
  } B;
} DTS_ENABLE_tag;

typedef union DTS_STARTUP_union_tag {  /* Startup Register */
  vuint32_t R;
  struct {
    vuint32_t AD:32;
  } B;
} DTS_STARTUP_tag;

typedef union DTS_SEMAPHORE_union_tag { /* Semaphore Register */
  vuint32_t R;
  struct {
    vuint32_t ST:32;
  } B;
} DTS_SEMAPHORE_tag;

typedef union DTS_SEMAPHORE_B_union_tag { /* Semaphore Extension */
  vuint32_t R;
  struct {
    vuint32_t ST_B:32;
  } B;
} DTS_SEMAPHORE_B_tag;

struct DTS_tag {
  DTS_ENABLE_tag ENABLE;               /* Output Enable Register */
  DTS_STARTUP_tag STARTUP;             /* Startup Register */
  DTS_SEMAPHORE_tag SEMAPHORE;         /* Semaphore Register */
  DTS_SEMAPHORE_B_tag SEMAPHORE_B;     /* Semaphore Extension */
};


/* ============================================================================
   =============================== Module: EBI ================================
   ============================================================================ */

typedef union EBI_MCR_union_tag {      /* EBI Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :5;
    vuint32_t  :3;
    vuint32_t  :8;
    vuint32_t ACGE:1;
    vuint32_t  :4;
    vuint32_t  :4;
    vuint32_t MDIS:1;
    vuint32_t  :3;
    vuint32_t D16_31:1;
    vuint32_t AD_MUX:1;
    vuint32_t DBM:1;
  } B;
} EBI_MCR_tag;

typedef union EBI_TESR_union_tag {     /* EBI Transfer Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :30;
    vuint32_t TEAF:1;
    vuint32_t BMTF:1;
  } B;
} EBI_TESR_tag;

typedef union EBI_BMCR_union_tag {     /* EBI Bus Monitor Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t BMT:8;
    vuint32_t BME:1;
    vuint32_t  :7;
  } B;
} EBI_BMCR_tag;

typedef union EBI_CAL_BR_union_tag {   /* EBI Calibration Base Register */
  vuint32_t R;
  struct {
    vuint32_t BA:17;
    vuint32_t  :2;
    vuint32_t LWRN:1;
    vuint32_t PS:1;
    vuint32_t EOE:2;
    vuint32_t SBL:1;
    vuint32_t AD_MUX:1;
    vuint32_t BL:1;
    vuint32_t WEBS:1;
    vuint32_t TBDIP:1;
    vuint32_t GCSN:1;
    vuint32_t SETA:1;
    vuint32_t BI:1;
    vuint32_t V:1;
  } B;
} EBI_CAL_BR_tag;

typedef union EBI_CAL_OR_union_tag {   /* EBI Calibration Option Register */
  vuint32_t R;
  struct {
    vuint32_t AM:17;
    vuint32_t  :2;
    vuint32_t APS:1;
    vuint32_t  :1;
    vuint32_t AWE:1;
    vuint32_t  :2;
    vuint32_t SCY:4;
    vuint32_t  :1;
    vuint32_t BSCY:2;
    vuint32_t  :1;
  } B;
} EBI_CAL_OR_tag;

typedef struct EBI_CAL_struct_tag {
  EBI_CAL_BR_tag BR;                   /* EBI Calibration Base Register */
  EBI_CAL_OR_tag OR;                   /* EBI Calibration Option Register */
} EBI_CAL_tag;

struct EBI_tag {
  EBI_MCR_tag MCR;                     /* EBI Module Configuration Register */
  uint8_t EBI_reserved0[4];
  EBI_TESR_tag TESR;                   /* EBI Transfer Error Status Register */
  EBI_BMCR_tag BMCR;                   /* EBI Bus Monitor Control Register */
  uint8_t EBI_reserved1[48];
  EBI_CAL_tag CAL[4];
};


/* ============================================================================
   =============================== Module: EIM ================================
   ============================================================================ */

typedef union EIM_EIMCR_union_tag {    /* Error Injection Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t GEIEN:1;                 /* Global Error Injection Enable */
  } B;
} EIM_EIMCR_tag;

typedef union EIM_EICHEN_union_tag {   /* Error Injection Channel Enable register */
  vuint32_t R;
  struct {
    vuint32_t EICH0EN:1;               /* Error Injection Channel 0 Enable */
    vuint32_t EICH1EN:1;               /* Error Injection Channel 1 Enable */
    vuint32_t EICH2EN:1;               /* Error Injection Channel 2 Enable */
    vuint32_t EICH3EN:1;               /* Error Injection Channel 3 Enable */
    vuint32_t EICH4EN:1;               /* Error Injection Channel 4 Enable */
    vuint32_t EICH5EN:1;               /* Error Injection Channel 5 Enable */
    vuint32_t  :26;
  } B;
} EIM_EICHEN_tag;

typedef union EIM_EICHD_WORD0_union_tag { /* Error Injection Channel Descriptor, Word0 */
  vuint32_t R;
  struct {
    vuint32_t CHKBIT_MASK:8;           /* Checkbit Mask */
    vuint32_t  :24;
  } B;
} EIM_EICHD_WORD0_tag;

typedef union EIM_EICHD_WORD1_union_tag { /* Error Injection Channel Descriptor, Word1 */
  vuint32_t R;
  struct {
    vuint32_t B0_3DATA_MASK:32;        /* Data Mask Bytes 0-3 */
  } B;
} EIM_EICHD_WORD1_tag;

typedef union EIM_EICHD_WORD2_union_tag { /* Error Injection Channel Descriptor, Word2 */
  vuint32_t R;
  struct {
    vuint32_t B4_7DATA_MASK:32;        /* Data Mask Bytes 4-7 */
  } B;
} EIM_EICHD_WORD2_tag;

typedef struct EIM_EICHD_struct_tag {
  EIM_EICHD_WORD0_tag WORD0;           /* Error Injection Channel Descriptor, Word0 */
  EIM_EICHD_WORD1_tag WORD1;           /* Error Injection Channel Descriptor, Word1 */
  EIM_EICHD_WORD2_tag WORD2;           /* Error Injection Channel Descriptor, Word2 */
  uint8_t EICHD_reserved0[244];
} EIM_EICHD_tag;

struct EIM_tag {
  EIM_EIMCR_tag EIMCR;                 /* Error Injection Module Configuration Register */
  EIM_EICHEN_tag EICHEN;               /* Error Injection Channel Enable register */
  uint8_t EIM_reserved0[248];
  EIM_EICHD_tag EICHD[6];
};


/* ============================================================================
   =============================== Module: EQADC ==============================
   ============================================================================ */

typedef union EQADC_MCR_union_tag {    /* EQADC Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t ICEA0:1;
    vuint32_t ICEA1:1;
    vuint32_t DAM:1;
    vuint32_t  :2;
    vuint32_t  :1;
    vuint32_t DBG:2;
  } B;
} EQADC_MCR_tag;

typedef union EQADC_TST_union_tag {    /* EQADC Test Register */
  vuint32_t R;
  struct {
    vuint32_t  :32;
  } B;
} EQADC_TST_tag;

typedef union EQADC_ETDFR_union_tag {  /* EQADC External Trigger Digital Filter Register */
  vuint32_t R;
  struct {
    vuint32_t  :28;
    vuint32_t DFL:4;
  } B;
} EQADC_ETDFR_tag;

typedef union EQADC_CFPR_union_tag {   /* EQADC CFIFO Push Register */
  vuint32_t R;
  struct {
    vuint32_t CF_PUSHX:32;
  } B;
} EQADC_CFPR_tag;

typedef union EQADC_RFPR_union_tag {   /* EQADC Result FIFO Pop Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t RF_POPX:16;
  } B;
} EQADC_RFPR_tag;

typedef union EQADC_CFCR0_union_tag {  /* EQADC CFIFO Control Register 0 */
  vuint32_t R;
  struct {
    vuint32_t  :3;
    vuint32_t CFEEE0:1;
    vuint32_t STRME0:1;
    vuint32_t SSE0:1;
    vuint32_t CFINV0:1;
    vuint32_t  :1;
    vuint32_t MODE0:4;
    vuint32_t AMODE0:4;
    vuint32_t  :5;
    vuint32_t SSE1:1;
    vuint32_t CFINV1:1;
    vuint32_t  :1;
    vuint32_t MODE1:4;
    vuint32_t  :4;
  } B;
} EQADC_CFCR0_tag;

typedef union EQADC_CFCR1_union_tag {  /* EQADC CFIFO Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :5;
    vuint32_t SSE2:1;
    vuint32_t CFINV2:1;
    vuint32_t  :1;
    vuint32_t MODE2:4;
    vuint32_t  :9;
    vuint32_t SSE3:1;
    vuint32_t CFINV3:1;
    vuint32_t  :1;
    vuint32_t MODE3:4;
    vuint32_t  :4;
  } B;
} EQADC_CFCR1_tag;

typedef union EQADC_CFCR2_union_tag {  /* EQADC CFIFO Control Register 2 */
  vuint32_t R;
  struct {
    vuint32_t  :5;
    vuint32_t SSE4:1;
    vuint32_t CFINV4:1;
    vuint32_t  :1;
    vuint32_t MODE4:4;
    vuint32_t  :9;
    vuint32_t SSE5:1;
    vuint32_t CFINV5:1;
    vuint32_t  :1;
    vuint32_t MODE5:4;
    vuint32_t  :4;
  } B;
} EQADC_CFCR2_tag;

typedef union EQADC_IDCR0_union_tag {  /* EQADC Interrupt and DMA Control Register 0 */
  vuint32_t R;
  struct {
    vuint32_t NCIE0:1;
    vuint32_t TORIE0:1;
    vuint32_t PIE0:1;
    vuint32_t EOQIE0:1;
    vuint32_t CFUIE0:1;
    vuint32_t  :1;
    vuint32_t CFFE0:1;
    vuint32_t CFFS0:1;
    vuint32_t  :4;
    vuint32_t RFOIE0:1;
    vuint32_t  :1;
    vuint32_t RFDE0:1;
    vuint32_t RFDS0:1;
    vuint32_t NCIE1:1;
    vuint32_t TORIE1:1;
    vuint32_t PIE1:1;
    vuint32_t EOQIE1:1;
    vuint32_t CFUIE1:1;
    vuint32_t  :1;
    vuint32_t CFFE1:1;
    vuint32_t CFFS1:1;
    vuint32_t  :4;
    vuint32_t RFOIE1:1;
    vuint32_t  :1;
    vuint32_t RFDE1:1;
    vuint32_t RFDS1:1;
  } B;
} EQADC_IDCR0_tag;

typedef union EQADC_IDCR1_union_tag {  /* EQADC Interrupt and DMA Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t NCIE2:1;
    vuint32_t TORIE2:1;
    vuint32_t PIE2:1;
    vuint32_t EOQIE2:1;
    vuint32_t CFUIE2:1;
    vuint32_t  :1;
    vuint32_t CFFE2:1;
    vuint32_t CFFS2:1;
    vuint32_t  :4;
    vuint32_t RFOIE2:1;
    vuint32_t  :1;
    vuint32_t RFDE2:1;
    vuint32_t RFDS2:1;
    vuint32_t NCIE3:1;
    vuint32_t TORIE3:1;
    vuint32_t PIE3:1;
    vuint32_t EOQIE3:1;
    vuint32_t CFUIE3:1;
    vuint32_t  :1;
    vuint32_t CFFE3:1;
    vuint32_t CFFS3:1;
    vuint32_t  :4;
    vuint32_t RFOIE3:1;
    vuint32_t  :1;
    vuint32_t RFDE3:1;
    vuint32_t RFDS3:1;
  } B;
} EQADC_IDCR1_tag;

typedef union EQADC_IDCR2_union_tag {  /* EQADC Interrupt and DMA Control Register 2 */
  vuint32_t R;
  struct {
    vuint32_t NCIE4:1;
    vuint32_t TORIE4:1;
    vuint32_t PIE4:1;
    vuint32_t EOQIE4:1;
    vuint32_t CFUIE4:1;
    vuint32_t  :1;
    vuint32_t CFFE4:1;
    vuint32_t CFFS4:1;
    vuint32_t  :4;
    vuint32_t RFOIE4:1;
    vuint32_t  :1;
    vuint32_t RFDE4:1;
    vuint32_t RFDS4:1;
    vuint32_t NCIE5:1;
    vuint32_t TORIE5:1;
    vuint32_t PIE5:1;
    vuint32_t EOQIE5:1;
    vuint32_t CFUIE5:1;
    vuint32_t  :1;
    vuint32_t CFFE5:1;
    vuint32_t CFFS5:1;
    vuint32_t  :4;
    vuint32_t RFOIE5:1;
    vuint32_t  :1;
    vuint32_t RFDE5:1;
    vuint32_t RFDS5:1;
  } B;
} EQADC_IDCR2_tag;

typedef union EQADC_FISR_union_tag {   /* EQADC FIFO and Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t NCFX:1;
    vuint32_t TORFX:1;
    vuint32_t PFX:1;
    vuint32_t EOQFX:1;
    vuint32_t CFUFX:1;
    vuint32_t SSSX:1;
    vuint32_t CFFFX:1;
    vuint32_t  :5;
    vuint32_t RFOFX:1;
    vuint32_t  :1;
    vuint32_t RFDFX:1;
    vuint32_t  :1;
    vuint32_t CFCTRX:4;
    vuint32_t TNXTPTRX:4;
    vuint32_t RFCTRX:4;
    vuint32_t POPNXTPTRX:4;
  } B;
} EQADC_FISR_tag;

typedef union EQADC_CFTCR0_union_tag { /* EQADC CFIFO Transfer Counter Register 0 */
  vuint32_t R;
  struct {
    vuint32_t  :5;
    vuint32_t TC_CF0:11;
    vuint32_t  :5;
    vuint32_t TC_CF1:11;
  } B;
} EQADC_CFTCR0_tag;

typedef union EQADC_CFTCR1_union_tag { /* EQADC CFIFO Transfer Counter Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :5;
    vuint32_t TC_CF2:11;
    vuint32_t  :5;
    vuint32_t TC_CF3:11;
  } B;
} EQADC_CFTCR1_tag;

typedef union EQADC_CFTCR2_union_tag { /* EQADC CFIFO Transfer Counter Register 2 */
  vuint32_t R;
  struct {
    vuint32_t  :5;
    vuint32_t TC_CF4:11;
    vuint32_t  :5;
    vuint32_t TC_CF5:11;
  } B;
} EQADC_CFTCR2_tag;

typedef union EQADC_CFSSR0_union_tag { /* EQADC CFIFO Status Snapshot Register 0 */
  vuint32_t R;
  struct {
    vuint32_t CFS0_TCB0:2;
    vuint32_t CFS1_TCB0:2;
    vuint32_t CFS2_TCB0:2;
    vuint32_t CFS3_TCB0:2;
    vuint32_t CFS4_TCB0:2;
    vuint32_t CFS5_TCB0:2;
    vuint32_t  :5;
    vuint32_t LCFTCB0:4;
    vuint32_t TC_LCFTCB0:11;
  } B;
} EQADC_CFSSR0_tag;

typedef union EQADC_CFSSR1_union_tag { /* EQADC CFIFO Status Snapshot Register 1 */
  vuint32_t R;
  struct {
    vuint32_t CFS0_TCB1:2;
    vuint32_t CFS1_TCB1:2;
    vuint32_t CFS2_TCB1:2;
    vuint32_t CFS3_TCB1:2;
    vuint32_t CFS4_TCB1:2;
    vuint32_t CFS5_TCB1:2;
    vuint32_t  :5;
    vuint32_t LCFTCB1:4;
    vuint32_t TC_LCFTCB1:11;
  } B;
} EQADC_CFSSR1_tag;

typedef union EQADC_CFSR_union_tag {   /* EQADC CFIFO Status Register */
  vuint32_t R;
  struct {
    vuint32_t CFS0:2;
    vuint32_t CFS1:2;
    vuint32_t CFS2:2;
    vuint32_t CFS3:2;
    vuint32_t CFS4:2;
    vuint32_t CFS5:2;
    vuint32_t  :20;
  } B;
} EQADC_CFSR_tag;

typedef union EQADC_STACCCR_union_tag { /* EQADC STAC Bus Client Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t STACBS2:4;
    vuint32_t SRV2:4;
    vuint32_t STACBS1:4;
    vuint32_t SRV1:4;
  } B;
} EQADC_STACCCR_tag;

typedef union EQADC_CF0R_union_tag {   /* EQADC CFIFO0 Register */
  vuint32_t R;
  struct {
    vuint32_t CFIFO0_DATAW:32;
  } B;
} EQADC_CF0R_tag;

typedef union EQADC_CF0ER_union_tag {  /* EQADC CFIFO0 Extension Register */
  vuint32_t R;
  struct {
    vuint32_t CFIFO0_EDATAW:32;
  } B;
} EQADC_CF0ER_tag;

typedef union EQADC_CF1R_union_tag {   /* EQADC CFIFO1 Register */
  vuint32_t R;
  struct {
    vuint32_t CFIFO1_DATAW:32;
  } B;
} EQADC_CF1R_tag;

typedef union EQADC_CF2R_union_tag {   /* EQADC CFIFO2 Register */
  vuint32_t R;
  struct {
    vuint32_t CFIFO2_DATAW:32;
  } B;
} EQADC_CF2R_tag;

typedef union EQADC_CF3R_union_tag {   /* EQADC CFIFO3 Register */
  vuint32_t R;
  struct {
    vuint32_t CFIFO3_DATAW:32;
  } B;
} EQADC_CF3R_tag;

typedef union EQADC_CF4R_union_tag {   /* EQADC CFIFO4 Register */
  vuint32_t R;
  struct {
    vuint32_t CFIFO4_DATAW:32;
  } B;
} EQADC_CF4R_tag;

typedef union EQADC_CF5R_union_tag {   /* EQADC CFIFO5 Register */
  vuint32_t R;
  struct {
    vuint32_t CFIFO5_DATAW:32;
  } B;
} EQADC_CF5R_tag;

typedef union EQADC_RF0R_union_tag {   /* EQADC RFIFO0 Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t RFIFO0_DATAW:16;
  } B;
} EQADC_RF0R_tag;

typedef union EQADC_RF1R_union_tag {   /* EQADC RFIFO1 Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t RFIFO1_DATAW:16;
  } B;
} EQADC_RF1R_tag;

typedef union EQADC_RF2R_union_tag {   /* EQADC RFIFO2 Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t RFIFO2_DATAW:16;
  } B;
} EQADC_RF2R_tag;

typedef union EQADC_RF3R_union_tag {   /* EQADC RFIFO3 Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t RFIFO3_DATAW:16;
  } B;
} EQADC_RF3R_tag;

typedef union EQADC_RF4R_union_tag {   /* EQADC RFIFO4 Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t RFIFO4_DATAW:16;
  } B;
} EQADC_RF4R_tag;

typedef union EQADC_RF5R_union_tag {   /* EQADC RFIFO5 Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t RFIFO5_DATAW:16;
  } B;
} EQADC_RF5R_tag;

struct EQADC_tag {
  EQADC_MCR_tag MCR;                   /* EQADC Module Configuration Register */
  EQADC_TST_tag TST;                   /* EQADC Test Register */
  uint8_t EQADC_reserved0[4];
  EQADC_ETDFR_tag ETDFR;               /* EQADC External Trigger Digital Filter Register */
  EQADC_CFPR_tag CFPR[6];              /* EQADC CFIFO Push Register */
  uint8_t EQADC_reserved1[8];
  EQADC_RFPR_tag RFPR[6];              /* EQADC Result FIFO Pop Register */
  uint8_t EQADC_reserved2[8];
  EQADC_CFCR0_tag CFCR0;               /* EQADC CFIFO Control Register 0 */
  EQADC_CFCR1_tag CFCR1;               /* EQADC CFIFO Control Register 1 */
  EQADC_CFCR2_tag CFCR2;               /* EQADC CFIFO Control Register 2 */
  uint8_t EQADC_reserved3[4];
  EQADC_IDCR0_tag IDCR0;               /* EQADC Interrupt and DMA Control Register 0 */
  EQADC_IDCR1_tag IDCR1;               /* EQADC Interrupt and DMA Control Register 1 */
  EQADC_IDCR2_tag IDCR2;               /* EQADC Interrupt and DMA Control Register 2 */
  uint8_t EQADC_reserved4[4];
  EQADC_FISR_tag FISR[6];              /* EQADC FIFO and Interrupt Status Register */
  uint8_t EQADC_reserved5[8];
  EQADC_CFTCR0_tag CFTCR0;             /* EQADC CFIFO Transfer Counter Register 0 */
  EQADC_CFTCR1_tag CFTCR1;             /* EQADC CFIFO Transfer Counter Register 1 */
  EQADC_CFTCR2_tag CFTCR2;             /* EQADC CFIFO Transfer Counter Register 2 */
  uint8_t EQADC_reserved6[4];
  EQADC_CFSSR0_tag CFSSR0;             /* EQADC CFIFO Status Snapshot Register 0 */
  EQADC_CFSSR1_tag CFSSR1;             /* EQADC CFIFO Status Snapshot Register 1 */
  uint8_t EQADC_reserved7[4];
  EQADC_CFSR_tag CFSR;                 /* EQADC CFIFO Status Register */
  uint8_t EQADC_reserved8[32];
  EQADC_STACCCR_tag STACCCR;           /* EQADC STAC Bus Client Configuration Register */
  uint8_t EQADC_reserved9[44];
  EQADC_CF0R_tag CF0R[4];              /* EQADC CFIFO0 Register */
  EQADC_CF0ER_tag CF0ER[4];            /* EQADC CFIFO0 Extension Register */
  uint8_t EQADC_reserved10[32];
  EQADC_CF1R_tag CF1R[4];              /* EQADC CFIFO1 Register */
  uint8_t EQADC_reserved11[48];
  EQADC_CF2R_tag CF2R[4];              /* EQADC CFIFO2 Register */
  uint8_t EQADC_reserved12[48];
  EQADC_CF3R_tag CF3R[4];              /* EQADC CFIFO3 Register */
  uint8_t EQADC_reserved13[48];
  EQADC_CF4R_tag CF4R[4];              /* EQADC CFIFO4 Register */
  uint8_t EQADC_reserved14[48];
  EQADC_CF5R_tag CF5R[4];              /* EQADC CFIFO5 Register */
  uint8_t EQADC_reserved15[176];
  EQADC_RF0R_tag RF0R[4];              /* EQADC RFIFO0 Register */
  uint8_t EQADC_reserved16[48];
  EQADC_RF1R_tag RF1R[4];              /* EQADC RFIFO1 Register */
  uint8_t EQADC_reserved17[48];
  EQADC_RF2R_tag RF2R[4];              /* EQADC RFIFO2 Register */
  uint8_t EQADC_reserved18[48];
  EQADC_RF3R_tag RF3R[4];              /* EQADC RFIFO3 Register */
  uint8_t EQADC_reserved19[48];
  EQADC_RF4R_tag RF4R[4];              /* EQADC RFIFO4 Register */
  uint8_t EQADC_reserved20[48];
  EQADC_RF5R_tag RF5R[4];              /* EQADC RFIFO5 Register */
};


/* ============================================================================
   =============================== Module: ERM ================================
   ============================================================================ */

typedef union ERM_CR0_union_tag {      /* ERM Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t ESCIE0:1;
    vuint32_t ENCIE0:1;
    vuint32_t  :2;
    vuint32_t ESCIE1:1;
    vuint32_t ENCIE1:1;
    vuint32_t  :2;
    vuint32_t ESCIE2:1;
    vuint32_t ENCIE2:1;
    vuint32_t  :2;
    vuint32_t ESCIE3:1;
    vuint32_t ENCIE3:1;
    vuint32_t  :2;
    vuint32_t ESCIE4:1;
    vuint32_t ENCIE4:1;
    vuint32_t  :2;
    vuint32_t ESCIE5:1;
    vuint32_t ENCIE5:1;
    vuint32_t  :2;
    vuint32_t ESCIE6:1;
    vuint32_t ENCIE6:1;
    vuint32_t  :2;
    vuint32_t ESCIE7:1;
    vuint32_t ENCIE7:1;
    vuint32_t  :2;
  } B;
} ERM_CR0_tag;

typedef union ERM_CR1_union_tag {      /* ERM Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t ESCIE8:1;
    vuint32_t ENCIE8:1;
    vuint32_t  :2;
    vuint32_t ESCIE9:1;
    vuint32_t ENCIE9:1;
    vuint32_t  :2;
    vuint32_t ESCIE10:1;
    vuint32_t ENCIE10:1;
    vuint32_t  :2;
    vuint32_t ESCIE11:1;
    vuint32_t ENCIE11:1;
    vuint32_t  :2;
    vuint32_t ESCIE12:1;
    vuint32_t ENCIE12:1;
    vuint32_t  :2;
    vuint32_t ESCIE13:1;
    vuint32_t ENCIE13:1;
    vuint32_t  :2;
    vuint32_t ESCIE14:1;
    vuint32_t ENCIE14:1;
    vuint32_t  :2;
    vuint32_t ESCIE15:1;
    vuint32_t ENCIE15:1;
    vuint32_t  :2;
  } B;
} ERM_CR1_tag;

typedef union ERM_CR2_union_tag {      /* ERM Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t ESCIE16:1;
    vuint32_t ENCIE16:1;
    vuint32_t  :2;
    vuint32_t ESCIE17:1;
    vuint32_t ENCIE17:1;
    vuint32_t  :2;
    vuint32_t ESCIE18:1;
    vuint32_t ENCIE18:1;
    vuint32_t  :2;
    vuint32_t ESCIE19:1;
    vuint32_t ENCIE19:1;
    vuint32_t  :2;
    vuint32_t  :16;
  } B;
} ERM_CR2_tag;

typedef union ERM_SR0_union_tag {      /* ERM Status Register */
  vuint32_t R;
  struct {
    vuint32_t SBC0:1;
    vuint32_t NCE0:1;
    vuint32_t  :2;
    vuint32_t SBC1:1;
    vuint32_t NCE1:1;
    vuint32_t  :2;
    vuint32_t SBC2:1;
    vuint32_t NCE2:1;
    vuint32_t  :2;
    vuint32_t SBC3:1;
    vuint32_t NCE3:1;
    vuint32_t  :2;
    vuint32_t SBC4:1;
    vuint32_t NCE4:1;
    vuint32_t  :2;
    vuint32_t SBC5:1;
    vuint32_t NCE5:1;
    vuint32_t  :2;
    vuint32_t SBC6:1;
    vuint32_t NCE6:1;
    vuint32_t  :2;
    vuint32_t SBC7:1;
    vuint32_t NCE7:1;
    vuint32_t  :2;
  } B;
} ERM_SR0_tag;

typedef union ERM_SR1_union_tag {      /* ERM Status Register */
  vuint32_t R;
  struct {
    vuint32_t SBC8:1;
    vuint32_t NCE8:1;
    vuint32_t  :2;
    vuint32_t SBC9:1;
    vuint32_t NCE9:1;
    vuint32_t  :2;
    vuint32_t SBC10:1;
    vuint32_t NCE10:1;
    vuint32_t  :2;
    vuint32_t SBC11:1;
    vuint32_t NCE11:1;
    vuint32_t  :2;
    vuint32_t SBC12:1;
    vuint32_t NCE12:1;
    vuint32_t  :2;
    vuint32_t SBC13:1;
    vuint32_t NCE13:1;
    vuint32_t  :2;
    vuint32_t SBC14:1;
    vuint32_t NCE14:1;
    vuint32_t  :2;
    vuint32_t SBC15:1;
    vuint32_t NCE15:1;
    vuint32_t  :2;
  } B;
} ERM_SR1_tag;

typedef union ERM_SR2_union_tag {      /* ERM Status Register */
  vuint32_t R;
  struct {
    vuint32_t SBC16:1;
    vuint32_t NCE16:1;
    vuint32_t  :2;
    vuint32_t SBC17:1;
    vuint32_t NCE17:1;
    vuint32_t  :2;
    vuint32_t SBC18:1;
    vuint32_t NCE18:1;
    vuint32_t  :2;
    vuint32_t SBC19:1;
    vuint32_t NCE19:1;
    vuint32_t  :18;
  } B;
} ERM_SR2_tag;

typedef union ERM_ERROR_EAR_union_tag { /* ERM Memory n Error Address Register */
  vuint32_t R;
  struct {
    vuint32_t EAR:32;
  } B;
} ERM_ERROR_EAR_tag;

typedef union ERM_ERROR_SYN_union_tag { /* ERM Memory n Syndrome Register */
  vuint32_t R;
  struct {
    vuint32_t SYNDROME:8;
    vuint32_t  :24;
  } B;
} ERM_ERROR_SYN_tag;

typedef struct ERM_ERROR_struct_tag {
  ERM_ERROR_EAR_tag EAR;               /* ERM Memory n Error Address Register */
  ERM_ERROR_SYN_tag SYN;               /* ERM Memory n Syndrome Register */
  uint8_t ERROR_reserved0[8];
} ERM_ERROR_tag;

struct ERM_tag {
  ERM_CR0_tag CR0;                     /* ERM Configuration Register */
  ERM_CR1_tag CR1;                     /* ERM Configuration Register */
  ERM_CR2_tag CR2;                     /* ERM Configuration Register */
  uint8_t ERM_reserved0[4];
  ERM_SR0_tag SR0;                     /* ERM Status Register */
  ERM_SR1_tag SR1;                     /* ERM Status Register */
  ERM_SR2_tag SR2;                     /* ERM Status Register */
  uint8_t ERM_reserved1[228];
  ERM_ERROR_tag ERROR[20];
};


/* ============================================================================
   =============================== Module: FCCU ===============================
   ============================================================================ */

typedef union FCCU_CTRL_union_tag {    /* Control */
  vuint32_t R;
  struct {
    vuint32_t FILTER_BYPASS:1;
    vuint32_t FILTER_WIDTH:2;
    vuint32_t  :19;
    vuint32_t DEBUG:1;
    vuint32_t  :1;
    vuint32_t OPS:2;
    vuint32_t  :1;
    vuint32_t OPR:5;
  } B;
} FCCU_CTRL_tag;

typedef union FCCU_CTRLK_union_tag {   /* Control Key */
  vuint32_t R;
  struct {
    vuint32_t CTRLK:32;
  } B;
} FCCU_CTRLK_tag;

typedef union FCCU_CFG_union_tag {     /* Configuration */
  vuint32_t R;
  struct {
    vuint32_t  :7;
    vuint32_t FCCU_SET_AFTER_RESET:1;
    vuint32_t FCCU_SET_CLEAR:2;
    vuint32_t  :2;
    vuint32_t  :4;
    vuint32_t  :1;
    vuint32_t  :2;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t SM:1;
    vuint32_t PS:1;
    vuint32_t FOM:3;
    vuint32_t  :6;
  } B;
} FCCU_CFG_tag;

typedef union FCCU_NCF_CFG_union_tag { /* Noncritical Fault Configuration */
  vuint32_t R;
  struct {
    vuint32_t NCFCx:32;
  } B;
} FCCU_NCF_CFG_tag;

typedef union FCCU_NCFS_CFG_union_tag { /* Noncritical Fault State Configuration */
  vuint32_t R;
  struct {
    vuint32_t NCFSCx:32;
  } B;
} FCCU_NCFS_CFG_tag;

typedef union FCCU_NCF_S_union_tag {   /* Noncritical Fault Status */
  vuint32_t R;
  struct {
    vuint32_t NCFSx:32;
  } B;
} FCCU_NCF_S_tag;

typedef union FCCU_NCFK_union_tag {    /* Noncritical Fault Key */
  vuint32_t R;
  struct {
    vuint32_t NCFK:32;
  } B;
} FCCU_NCFK_tag;

typedef union FCCU_NCF_E_union_tag {   /* Noncritical Fault Enable */
  vuint32_t R;
  struct {
    vuint32_t NCFEx:32;
  } B;
} FCCU_NCF_E_tag;

typedef union FCCU_NCF_TOE_union_tag { /* Noncritical Fault Timeout Enable */
  vuint32_t R;
  struct {
    vuint32_t NCFTOEx:32;
  } B;
} FCCU_NCF_TOE_tag;

typedef union FCCU_NCF_TO_union_tag {  /* Noncritical Fault Timeout */
  vuint32_t R;
  struct {
    vuint32_t TO:32;
  } B;
} FCCU_NCF_TO_tag;

typedef union FCCU_CFG_TO_union_tag {  /* CFG Timeout */
  vuint32_t R;
  struct {
    vuint32_t  :29;
    vuint32_t TO:3;
  } B;
} FCCU_CFG_TO_tag;

typedef union FCCU_EINOUT_union_tag {  /* IO Control */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t EIN1:1;
    vuint32_t EIN0:1;
    vuint32_t  :2;
    vuint32_t EOUT1:1;
    vuint32_t EOUT0:1;
  } B;
} FCCU_EINOUT_tag;

typedef union FCCU_STAT_union_tag {    /* Status */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t PhysicErrorPin:2;
    vuint32_t ESTAT:1;
    vuint32_t STATUS:3;
  } B;
} FCCU_STAT_tag;

typedef union FCCU_N2AF_STATUS_union_tag { /* NA Freeze Status */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t NAFS:8;
  } B;
} FCCU_N2AF_STATUS_tag;

typedef union FCCU_A2FF_STATUS_union_tag { /* AF Freeze Status */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t AF_SRC:2;
    vuint32_t AFFS:8;
  } B;
} FCCU_A2FF_STATUS_tag;

typedef union FCCU_N2FF_STATUS_union_tag { /* NF Freeze Status */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t NF_SRC:2;
    vuint32_t NFFS:8;
  } B;
} FCCU_N2FF_STATUS_tag;

typedef union FCCU_F2A_STATUS_union_tag { /* FA Freeze Status */
  vuint32_t R;
  struct {
    vuint32_t  :23;
    vuint32_t FAFS:9;
  } B;
} FCCU_F2A_STATUS_tag;

typedef union FCCU_NCFF_union_tag {    /* Noncritical Fault Fake */
  vuint32_t R;
  struct {
    vuint32_t  :25;
    vuint32_t FNCFC:7;
  } B;
} FCCU_NCFF_tag;

typedef union FCCU_IRQ_STAT_union_tag { /* IRQ Status */
  vuint32_t R;
  struct {
    vuint32_t  :27;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t NMI_STAT:1;
    vuint32_t ALRM_STAT:1;
    vuint32_t CFG_TO_STAT:1;
  } B;
} FCCU_IRQ_STAT_tag;

typedef union FCCU_IRQ_EN_union_tag {  /* IRQ Enable */
  vuint32_t R;
  struct {
    vuint32_t  :28;
    vuint32_t  :1;
    vuint32_t  :2;
    vuint32_t CFG_TO_IEN:1;
  } B;
} FCCU_IRQ_EN_tag;

typedef union FCCU_XTMR_union_tag {    /* XTMR */
  vuint32_t R;
  struct {
    vuint32_t XTMR:32;
  } B;
} FCCU_XTMR_tag;

typedef union FCCU_TRANS_LOCK_union_tag { /* Transient Lock */
  vuint32_t R;
  struct {
    vuint32_t  :23;
    vuint32_t TRANSKEY:9;
  } B;
} FCCU_TRANS_LOCK_tag;

typedef union FCCU_PERMNT_LOCK_union_tag { /* Permanent Lock */
  vuint32_t R;
  struct {
    vuint32_t  :23;
    vuint32_t PERMNTKEY:9;
  } B;
} FCCU_PERMNT_LOCK_tag;

typedef union FCCU_DELTA_T_union_tag { /* Delta T */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t  :14;
    vuint32_t  :2;
    vuint32_t DELTA_T:14;
  } B;
} FCCU_DELTA_T_tag;

typedef union FCCU_IRQ_ALARM_EN_union_tag { /* IRQ Alarm Enable */
  vuint32_t R;
  struct {
    vuint32_t IRQENx:32;
  } B;
} FCCU_IRQ_ALARM_EN_tag;

typedef union FCCU_NMI_EN_union_tag {  /* NMI Enable */
  vuint32_t R;
  struct {
    vuint32_t NMIENx:32;
  } B;
} FCCU_NMI_EN_tag;

typedef union FCCU_EOUT_SIG_EN_union_tag { /* EOUT Signaling Enable */
  vuint32_t R;
  struct {
    vuint32_t EOUTENx:32;
  } B;
} FCCU_EOUT_SIG_EN_tag;

struct FCCU_tag {
  FCCU_CTRL_tag CTRL;                  /* Control */
  FCCU_CTRLK_tag CTRLK;                /* Control Key */
  FCCU_CFG_tag CFG;                    /* Configuration */
  uint8_t FCCU_reserved0[16];
  FCCU_NCF_CFG_tag NCF_CFG[2];         /* Noncritical Fault Configuration */
  uint8_t FCCU_reserved1[40];
  FCCU_NCFS_CFG_tag NCFS_CFG[3];       /* Noncritical Fault State Configuration */
  uint8_t FCCU_reserved2[40];
  FCCU_NCF_S_tag NCF_S[2];             /* Noncritical Fault Status */
  uint8_t FCCU_reserved3[8];
  FCCU_NCFK_tag NCFK;                  /* Noncritical Fault Key */
  FCCU_NCF_E_tag NCF_E[2];             /* Noncritical Fault Enable */
  uint8_t FCCU_reserved4[8];
  FCCU_NCF_TOE_tag NCF_TOE[2];         /* Noncritical Fault Timeout Enable */
  uint8_t FCCU_reserved5[8];
  FCCU_NCF_TO_tag NCF_TO;              /* Noncritical Fault Timeout */
  FCCU_CFG_TO_tag CFG_TO;              /* CFG Timeout */
  FCCU_EINOUT_tag EINOUT;              /* IO Control */
  FCCU_STAT_tag STAT;                  /* Status */
  FCCU_N2AF_STATUS_tag N2AF_STATUS;    /* NA Freeze Status */
  FCCU_A2FF_STATUS_tag A2FF_STATUS;    /* AF Freeze Status */
  FCCU_N2FF_STATUS_tag N2FF_STATUS;    /* NF Freeze Status */
  FCCU_F2A_STATUS_tag F2A_STATUS;      /* FA Freeze Status */
  uint8_t FCCU_reserved6[8];
  FCCU_NCFF_tag NCFF;                  /* Noncritical Fault Fake */
  FCCU_IRQ_STAT_tag IRQ_STAT;          /* IRQ Status */
  FCCU_IRQ_EN_tag IRQ_EN;              /* IRQ Enable */
  FCCU_XTMR_tag XTMR;                  /* XTMR */
  uint8_t FCCU_reserved7[4];
  FCCU_TRANS_LOCK_tag TRANS_LOCK;      /* Transient Lock */
  FCCU_PERMNT_LOCK_tag PERMNT_LOCK;    /* Permanent Lock */
  FCCU_DELTA_T_tag DELTA_T;            /* Delta T */
  FCCU_IRQ_ALARM_EN_tag IRQ_ALARM_EN[2]; /* IRQ Alarm Enable */
  uint8_t FCCU_reserved8[8];
  FCCU_NMI_EN_tag NMI_EN[2];           /* NMI Enable */
  uint8_t FCCU_reserved9[8];
  FCCU_EOUT_SIG_EN_tag EOUT_SIG_EN[2]; /* EOUT Signaling Enable */
};


/* ============================================================================
   =============================== Module: FEC ================================
   ============================================================================ */

typedef union FEC_EIR_union_tag {      /* Interrupt Event Register */
  vuint32_t R;
  struct {
    vuint32_t HBERR:1;
    vuint32_t BABR:1;
    vuint32_t BABT:1;
    vuint32_t GRA:1;
    vuint32_t TXF:1;
    vuint32_t TXB:1;
    vuint32_t RXF:1;
    vuint32_t RXB:1;
    vuint32_t MII:1;
    vuint32_t EBERR:1;
    vuint32_t LC:1;
    vuint32_t RL:1;
    vuint32_t UN:1;
    vuint32_t  :19;
  } B;
} FEC_EIR_tag;

typedef union FEC_EIMR_union_tag {     /* Interrupt Mask Register */
  vuint32_t R;
  struct {
    vuint32_t HBERR:1;
    vuint32_t BABR:1;
    vuint32_t BABT:1;
    vuint32_t GRA:1;
    vuint32_t TXF:1;
    vuint32_t TXB:1;
    vuint32_t RXF:1;
    vuint32_t RXB:1;
    vuint32_t MII:1;
    vuint32_t EBERR:1;
    vuint32_t LC:1;
    vuint32_t RL:1;
    vuint32_t UN:1;
    vuint32_t  :19;
  } B;
} FEC_EIMR_tag;

typedef union FEC_RDAR_union_tag {     /* Receive Descriptor Active Register */
  vuint32_t R;
  struct {
    vuint32_t  :7;
    vuint32_t RDAR:1;
    vuint32_t  :24;
  } B;
} FEC_RDAR_tag;

typedef union FEC_TDAR_union_tag {     /* Transmit Descriptor Active Register */
  vuint32_t R;
  struct {
    vuint32_t  :7;
    vuint32_t TDAR:1;
    vuint32_t  :24;
  } B;
} FEC_TDAR_tag;

typedef union FEC_ECR_union_tag {      /* Ethernet Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t  :23;
    vuint32_t  :1;
    vuint32_t ETHER_EN:1;
    vuint32_t RESET:1;
  } B;
} FEC_ECR_tag;

typedef union FEC_MMFR_union_tag {     /* MII Management Frame Register */
  vuint32_t R;
  struct {
    vuint32_t ST:2;
    vuint32_t OP:2;
    vuint32_t PA:5;
    vuint32_t RA:5;
    vuint32_t TA:2;
    vuint32_t DATA:16;
  } B;
} FEC_MMFR_tag;

typedef union FEC_MSCR_union_tag {     /* MII Speed Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t DIS_PRE:1;
    vuint32_t MII_SPEED:6;
    vuint32_t  :1;
  } B;
} FEC_MSCR_tag;

typedef union FEC_MIBC_union_tag {     /* MIB Control Register */
  vuint32_t R;
  struct {
    vuint32_t MIB_DIS:1;
    vuint32_t MIB_IDLE:1;
    vuint32_t  :30;
  } B;
} FEC_MIBC_tag;

typedef union FEC_RCR_union_tag {      /* Receive Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :5;
    vuint32_t MAX_FL:11;
    vuint32_t  :4;
    vuint32_t RMII_ECHO:1;
    vuint32_t RMII_LOOP:1;
    vuint32_t RMII_10T:1;
    vuint32_t RMII_MODE:1;
    vuint32_t  :2;
    vuint32_t FCE:1;
    vuint32_t BC_REJ:1;
    vuint32_t PROM:1;
    vuint32_t MII_MODE:1;
    vuint32_t DRT:1;
    vuint32_t LOOP:1;
  } B;
} FEC_RCR_tag;

typedef union FEC_TCR_union_tag {      /* Transmit Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :27;
    vuint32_t RFC_PAUSE:1;
    vuint32_t TFC_PAUSE:1;
    vuint32_t FDEN:1;
    vuint32_t HBC:1;
    vuint32_t GTS:1;
  } B;
} FEC_TCR_tag;

typedef union FEC_PALR_union_tag {     /* Physical Address Low Register */
  vuint32_t R;
  struct {
    vuint32_t PADDR1:32;
  } B;
} FEC_PALR_tag;

typedef union FEC_PAUR_union_tag {     /* Physical Address High Register and Type Field */
  vuint32_t R;
  struct {
    vuint32_t PADDR2:16;
    vuint32_t TYPE:16;
  } B;
} FEC_PAUR_tag;

typedef union FEC_OPD_union_tag {      /* Opcode/Pause Duration */
  vuint32_t R;
  struct {
    vuint32_t OPCODE:16;
    vuint32_t PAUSE_DUR:16;
  } B;
} FEC_OPD_tag;

typedef union FEC_IAUR_union_tag {     /* Descriptor Individual Upper Address Register */
  vuint32_t R;
  struct {
    vuint32_t IADDR1:32;
  } B;
} FEC_IAUR_tag;

typedef union FEC_IALR_union_tag {     /* Descriptor Individual Lower Address Register */
  vuint32_t R;
  struct {
    vuint32_t IADDR2:32;
  } B;
} FEC_IALR_tag;

typedef union FEC_GAUR_union_tag {     /* Descriptor Group Upper Address Register */
  vuint32_t R;
  struct {
    vuint32_t GADDR1:32;
  } B;
} FEC_GAUR_tag;

typedef union FEC_GALR_union_tag {     /* Descriptor Group Lower Address Register */
  vuint32_t R;
  struct {
    vuint32_t GADDR2:32;
  } B;
} FEC_GALR_tag;

typedef union FEC_TFWR_union_tag {     /* Transmit FIFO Watermark */
  vuint32_t R;
  struct {
    vuint32_t  :30;
    vuint32_t TFWR:2;
  } B;
} FEC_TFWR_tag;

typedef union FEC_FRBR_union_tag {     /* FIFO Receive Bound Register */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t  :1;
    vuint32_t R_BOUND:8;
    vuint32_t  :2;
  } B;
} FEC_FRBR_tag;

typedef union FEC_FRSR_union_tag {     /* FIFO Receive Start Register */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t  :1;
    vuint32_t R_FSTART:8;
    vuint32_t  :2;
  } B;
} FEC_FRSR_tag;

typedef union FEC_ERDSR_union_tag {    /* Receive Descriptor Ring Start Register */
  vuint32_t R;
  struct {
    vuint32_t R_DES_START:30;
    vuint32_t  :2;
  } B;
} FEC_ERDSR_tag;

typedef union FEC_ETDSR_union_tag {    /* Transmit Buffer Descriptor Ring Start Register */
  vuint32_t R;
  struct {
    vuint32_t X_DES_START:30;
    vuint32_t  :2;
  } B;
} FEC_ETDSR_tag;

typedef union FEC_EMRBR_union_tag {    /* Receive Buffer Size Register */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t R_BUF_SIZE:7;
    vuint32_t  :4;
  } B;
} FEC_EMRBR_tag;

typedef union FEC_RMON_T_DROP_union_tag { /* Count of frames not counted correctly */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_DROP:32;
  } B;
} FEC_RMON_T_DROP_tag;

typedef union FEC_RMON_T_PACKETS_union_tag { /* RMON Tx packet count */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_PACKETS:32;
  } B;
} FEC_RMON_T_PACKETS_tag;

typedef union FEC_RMON_T_BC_PKT_union_tag { /* RMON Tx broadcast packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_BC_PKT:32;
  } B;
} FEC_RMON_T_BC_PKT_tag;

typedef union FEC_RMON_T_MC_PKT_union_tag { /* RMON Tx multicast packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_MC_PKT:32;
  } B;
} FEC_RMON_T_MC_PKT_tag;

typedef union FEC_RMON_T_CRC_ALIGN_union_tag { /* RMON Tx packets with CRC/align error */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_CRC_ALIGN:32;
  } B;
} FEC_RMON_T_CRC_ALIGN_tag;

typedef union FEC_RMON_T_UNDERSIZE_union_tag { /* RMON Tx packets < 64 bytes, good CRC */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_UNDERSIZE:32;
  } B;
} FEC_RMON_T_UNDERSIZE_tag;

typedef union FEC_RMON_T_OVERSIZE_union_tag { /* RMON Tx packets > MAX_FL bytes, good CRC */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_OVERSIZE:32;
  } B;
} FEC_RMON_T_OVERSIZE_tag;

typedef union FEC_RMON_T_FRAG_union_tag { /* RMON Tx packets < 64 bytes, bad CRC */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_FRAG:32;
  } B;
} FEC_RMON_T_FRAG_tag;

typedef union FEC_RMON_T_JAB_union_tag { /* RMON Tx packets > MAX_FL bytes, bad CRC */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_JAB:32;
  } B;
} FEC_RMON_T_JAB_tag;

typedef union FEC_RMON_T_COL_union_tag { /* RMON Tx collision count */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_COL:32;
  } B;
} FEC_RMON_T_COL_tag;

typedef union FEC_RMON_T_P64_union_tag { /* RMON Tx 64 byte packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_P64:32;
  } B;
} FEC_RMON_T_P64_tag;

typedef union FEC_RMON_T_P65TO127_union_tag { /* RMON Tx 65 to 127 byte packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_P65TO127:32;
  } B;
} FEC_RMON_T_P65TO127_tag;

typedef union FEC_RMON_T_P128TO255_union_tag { /* RMON Tx 128 to 255 byte packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_P128TO255:32;
  } B;
} FEC_RMON_T_P128TO255_tag;

typedef union FEC_RMON_T_P256TO511_union_tag { /* RMON Tx 256 to 511 byte packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_P256TO511:32;
  } B;
} FEC_RMON_T_P256TO511_tag;

typedef union FEC_RMON_T_P512TO1023_union_tag { /* RMON Tx 512 to 1023 byte packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_P512TO1023:32;
  } B;
} FEC_RMON_T_P512TO1023_tag;

typedef union FEC_RMON_T_P1024TO2047_union_tag { /* RMON Tx 1024 to 2047 byte packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_P1024TO2047:32;
  } B;
} FEC_RMON_T_P1024TO2047_tag;

typedef union FEC_RMON_T_P_GTE2048_union_tag { /* RMON Tx packets with > 2048 bytes */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_P_GTE2048:32;
  } B;
} FEC_RMON_T_P_GTE2048_tag;

typedef union FEC_RMON_T_OCTETS_union_tag { /* RMON Tx Octets */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_OCTETS:32;
  } B;
} FEC_RMON_T_OCTETS_tag;

typedef union FEC_IEEE_T_DROP_union_tag { /* Count of transmitted frames not counted correctly */
  vuint32_t R;
  struct {
    vuint32_t IEEE_T_DROP:32;
  } B;
} FEC_IEEE_T_DROP_tag;

typedef union FEC_IEEE_T_FRAME_OK_union_tag { /* Frames transmitted OK */
  vuint32_t R;
  struct {
    vuint32_t IEEE_T_FRAME_OK:32;
  } B;
} FEC_IEEE_T_FRAME_OK_tag;

typedef union FEC_IEEE_T_1COL_union_tag { /* Frames transmitted with single collision */
  vuint32_t R;
  struct {
    vuint32_t IEEE_T_1COL:32;
  } B;
} FEC_IEEE_T_1COL_tag;

typedef union FEC_IEEE_T_MCOL_union_tag { /* Frames transmitted with multiple collisions */
  vuint32_t R;
  struct {
    vuint32_t IEEE_T_MCOL:32;
  } B;
} FEC_IEEE_T_MCOL_tag;

typedef union FEC_IEEE_T_DEF_union_tag { /* Frames transmitted after deferral delay */
  vuint32_t R;
  struct {
    vuint32_t IEEE_T_DEF:32;
  } B;
} FEC_IEEE_T_DEF_tag;

typedef union FEC_IEEE_T_LCOL_union_tag { /* Frames transmitted with late collision */
  vuint32_t R;
  struct {
    vuint32_t IEEE_T_LCOL:32;
  } B;
} FEC_IEEE_T_LCOL_tag;

typedef union FEC_IEEE_T_EXCOL_union_tag { /* Frames transmitted with excessive collisions */
  vuint32_t R;
  struct {
    vuint32_t IEEE_T_EXCOL:32;
  } B;
} FEC_IEEE_T_EXCOL_tag;

typedef union FEC_IEEE_T_MACERR_union_tag { /* Frames transmitted with Tx FIFO underrun */
  vuint32_t R;
  struct {
    vuint32_t IEEE_T_MACERR:32;
  } B;
} FEC_IEEE_T_MACERR_tag;

typedef union FEC_IEEE_T_CSERR_union_tag { /* Frames transmitted with carrier sense error */
  vuint32_t R;
  struct {
    vuint32_t IEEE_T_CSERR:32;
  } B;
} FEC_IEEE_T_CSERR_tag;

typedef union FEC_IEEE_T_SQE_union_tag { /* Frames transmitted with SQE error */
  vuint32_t R;
  struct {
    vuint32_t IEEE_T_SQE:32;
  } B;
} FEC_IEEE_T_SQE_tag;

typedef union FEC_IEEE_T_FDXFC_union_tag { /* Flow control pause frames transmitted */
  vuint32_t R;
  struct {
    vuint32_t IEEE_T_FDXFC:32;
  } B;
} FEC_IEEE_T_FDXFC_tag;

typedef union FEC_IEEE_T_OCTETS_OK_union_tag { /* Octet count for frames transmitted without error */
  vuint32_t R;
  struct {
    vuint32_t IEEE_T_OCTETS_OK:32;
  } B;
} FEC_IEEE_T_OCTETS_OK_tag;

typedef union FEC_RMON_R_DROP_union_tag { /* Count of received frames not counted correctly */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_DROP:32;
  } B;
} FEC_RMON_R_DROP_tag;

typedef union FEC_RMON_R_PACKETS_union_tag { /* RMON Rx packet count */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_PACKETS:32;
  } B;
} FEC_RMON_R_PACKETS_tag;

typedef union FEC_RMON_R_BC_PKT_union_tag { /* RMON Rx broadcast packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_BC_PKT:32;
  } B;
} FEC_RMON_R_BC_PKT_tag;

typedef union FEC_RMON_R_MC_PKT_union_tag { /* RMON Rx multicast packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_MC_PKT:32;
  } B;
} FEC_RMON_R_MC_PKT_tag;

typedef union FEC_RMON_R_CRC_ALIGN_union_tag { /* RMON Rx packets with CRC/Align error */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_CRC_ALIGN:32;
  } B;
} FEC_RMON_R_CRC_ALIGN_tag;

typedef union FEC_RMON_R_UNDERSIZE_union_tag { /* RMON Rx packets < 64 bytes, good CRC */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_UNDERSIZE:32;
  } B;
} FEC_RMON_R_UNDERSIZE_tag;

typedef union FEC_RMON_R_OVERSIZE_union_tag { /* RMON Rx packets > MAX_FL bytes, good CRC */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_OVERSIZE:32;
  } B;
} FEC_RMON_R_OVERSIZE_tag;

typedef union FEC_RMON_R_FRAG_union_tag { /* RMON Rx packets < 64 bytes, bad CRC */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_FRAG:32;
  } B;
} FEC_RMON_R_FRAG_tag;

typedef union FEC_RMON_R_JAB_union_tag { /* RMON Rx packets > MAX_FL bytes, bad CRC */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_JAB:32;
  } B;
} FEC_RMON_R_JAB_tag;

typedef union FEC_RMON_R_RESVD_0_union_tag { /* Reserved */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_RESVD_0:32;
  } B;
} FEC_RMON_R_RESVD_0_tag;

typedef union FEC_RMON_R_P64_union_tag { /* RMON Rx 64 byte packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_P64:32;
  } B;
} FEC_RMON_R_P64_tag;

typedef union FEC_RMON_R_P65TO127_union_tag { /* RMON Rx 65 to 127 byte packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_P65TO127:32;
  } B;
} FEC_RMON_R_P65TO127_tag;

typedef union FEC_RMON_R_P128TO255_union_tag { /* RMON Rx 128 to 255 byte packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_P128TO255:32;
  } B;
} FEC_RMON_R_P128TO255_tag;

typedef union FEC_RMON_R_P256TO511_union_tag { /* RMON Rx 256 to 511 byte packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_P256TO511:32;
  } B;
} FEC_RMON_R_P256TO511_tag;

typedef union FEC_RMON_R_P512TO1023_union_tag { /* RMON Rx 512 to 1023 byte packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_P512TO1023:32;
  } B;
} FEC_RMON_R_P512TO1023_tag;

typedef union FEC_RMON_R_P1024TO2047_union_tag { /* RMON Rx 1024 to 2047 byte packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_P1024TO2047:32;
  } B;
} FEC_RMON_R_P1024TO2047_tag;

typedef union FEC_RMON_R_P_GTE2048_union_tag { /* RMON Rx packets with > 2048 bytes */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_P_GTE2048:32;
  } B;
} FEC_RMON_R_P_GTE2048_tag;

typedef union FEC_RMON_R_OCTETS_union_tag { /* RMON Rx octets */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_OCTETS:32;
  } B;
} FEC_RMON_R_OCTETS_tag;

typedef union FEC_IEEE_R_DROP_union_tag { /* Count of received frames not counted correctly */
  vuint32_t R;
  struct {
    vuint32_t IEEE_R_DROP:32;
  } B;
} FEC_IEEE_R_DROP_tag;

typedef union FEC_IEEE_R_FRAME_OK_union_tag { /* Frames received OK */
  vuint32_t R;
  struct {
    vuint32_t IEEE_R_FRAME_OK:32;
  } B;
} FEC_IEEE_R_FRAME_OK_tag;

typedef union FEC_IEEE_R_CRC_union_tag { /* Frames received with CRC error */
  vuint32_t R;
  struct {
    vuint32_t IEEE_R_CRC:32;
  } B;
} FEC_IEEE_R_CRC_tag;

typedef union FEC_IEEE_R_ALIGN_union_tag { /* Frames received with alignment error */
  vuint32_t R;
  struct {
    vuint32_t IEEE_R_ALIGN:32;
  } B;
} FEC_IEEE_R_ALIGN_tag;

typedef union FEC_IEEE_R_MACERR_union_tag { /* Receive FIFO overflow count */
  vuint32_t R;
  struct {
    vuint32_t IEEE_R_MACERR:32;
  } B;
} FEC_IEEE_R_MACERR_tag;

typedef union FEC_IEEE_R_FDXFC_union_tag { /* Flow control pause frames received */
  vuint32_t R;
  struct {
    vuint32_t IEEE_R_FDXFC:32;
  } B;
} FEC_IEEE_R_FDXFC_tag;

typedef union FEC_IEEE_R_OCTETS_OK_union_tag { /* Octet count for frames received without error */
  vuint32_t R;
  struct {
    vuint32_t IEEE_R_OCTETS_OK:32;
  } B;
} FEC_IEEE_R_OCTETS_OK_tag;

struct FEC_tag {
  uint8_t FEC_reserved0[4];
  FEC_EIR_tag EIR;                     /* Interrupt Event Register */
  FEC_EIMR_tag EIMR;                   /* Interrupt Mask Register */
  uint8_t FEC_reserved1[4];
  FEC_RDAR_tag RDAR;                   /* Receive Descriptor Active Register */
  FEC_TDAR_tag TDAR;                   /* Transmit Descriptor Active Register */
  uint8_t FEC_reserved2[12];
  FEC_ECR_tag ECR;                     /* Ethernet Control Register */
  uint8_t FEC_reserved3[24];
  FEC_MMFR_tag MMFR;                   /* MII Management Frame Register */
  FEC_MSCR_tag MSCR;                   /* MII Speed Control Register */
  uint8_t FEC_reserved4[28];
  FEC_MIBC_tag MIBC;                   /* MIB Control Register */
  uint8_t FEC_reserved5[28];
  FEC_RCR_tag RCR;                     /* Receive Control Register */
  uint8_t FEC_reserved6[60];
  FEC_TCR_tag TCR;                     /* Transmit Control Register */
  uint8_t FEC_reserved7[28];
  FEC_PALR_tag PALR;                   /* Physical Address Low Register */
  FEC_PAUR_tag PAUR;                   /* Physical Address High Register and Type Field */
  FEC_OPD_tag OPD;                     /* Opcode/Pause Duration */
  uint8_t FEC_reserved8[40];
  FEC_IAUR_tag IAUR;                   /* Descriptor Individual Upper Address Register */
  FEC_IALR_tag IALR;                   /* Descriptor Individual Lower Address Register */
  FEC_GAUR_tag GAUR;                   /* Descriptor Group Upper Address Register */
  FEC_GALR_tag GALR;                   /* Descriptor Group Lower Address Register */
  uint8_t FEC_reserved9[28];
  FEC_TFWR_tag TFWR;                   /* Transmit FIFO Watermark */
  uint8_t FEC_reserved10[4];
  FEC_FRBR_tag FRBR;                   /* FIFO Receive Bound Register */
  FEC_FRSR_tag FRSR;                   /* FIFO Receive Start Register */
  uint8_t FEC_reserved11[44];
  FEC_ERDSR_tag ERDSR;                 /* Receive Descriptor Ring Start Register */
  FEC_ETDSR_tag ETDSR;                 /* Transmit Buffer Descriptor Ring Start Register */
  FEC_EMRBR_tag EMRBR;                 /* Receive Buffer Size Register */
  uint8_t FEC_reserved12[116];
  FEC_RMON_T_DROP_tag RMON_T_DROP;     /* Count of frames not counted correctly */
  FEC_RMON_T_PACKETS_tag RMON_T_PACKETS; /* RMON Tx packet count */
  FEC_RMON_T_BC_PKT_tag RMON_T_BC_PKT; /* RMON Tx broadcast packets */
  FEC_RMON_T_MC_PKT_tag RMON_T_MC_PKT; /* RMON Tx multicast packets */
  FEC_RMON_T_CRC_ALIGN_tag RMON_T_CRC_ALIGN; /* RMON Tx packets with CRC/align error */
  FEC_RMON_T_UNDERSIZE_tag RMON_T_UNDERSIZE; /* RMON Tx packets < 64 bytes, good CRC */
  FEC_RMON_T_OVERSIZE_tag RMON_T_OVERSIZE; /* RMON Tx packets > MAX_FL bytes, good CRC */
  FEC_RMON_T_FRAG_tag RMON_T_FRAG;     /* RMON Tx packets < 64 bytes, bad CRC */
  FEC_RMON_T_JAB_tag RMON_T_JAB;       /* RMON Tx packets > MAX_FL bytes, bad CRC */
  FEC_RMON_T_COL_tag RMON_T_COL;       /* RMON Tx collision count */
  FEC_RMON_T_P64_tag RMON_T_P64;       /* RMON Tx 64 byte packets */
  FEC_RMON_T_P65TO127_tag RMON_T_P65TO127; /* RMON Tx 65 to 127 byte packets */
  FEC_RMON_T_P128TO255_tag RMON_T_P128TO255; /* RMON Tx 128 to 255 byte packets */
  FEC_RMON_T_P256TO511_tag RMON_T_P256TO511; /* RMON Tx 256 to 511 byte packets */
  FEC_RMON_T_P512TO1023_tag RMON_T_P512TO1023; /* RMON Tx 512 to 1023 byte packets */
  FEC_RMON_T_P1024TO2047_tag RMON_T_P1024TO2047; /* RMON Tx 1024 to 2047 byte packets */
  FEC_RMON_T_P_GTE2048_tag RMON_T_P_GTE2048; /* RMON Tx packets with > 2048 bytes */
  FEC_RMON_T_OCTETS_tag RMON_T_OCTETS; /* RMON Tx Octets */
  FEC_IEEE_T_DROP_tag IEEE_T_DROP;     /* Count of transmitted frames not counted correctly */
  FEC_IEEE_T_FRAME_OK_tag IEEE_T_FRAME_OK; /* Frames transmitted OK */
  FEC_IEEE_T_1COL_tag IEEE_T_1COL;     /* Frames transmitted with single collision */
  FEC_IEEE_T_MCOL_tag IEEE_T_MCOL;     /* Frames transmitted with multiple collisions */
  FEC_IEEE_T_DEF_tag IEEE_T_DEF;       /* Frames transmitted after deferral delay */
  FEC_IEEE_T_LCOL_tag IEEE_T_LCOL;     /* Frames transmitted with late collision */
  FEC_IEEE_T_EXCOL_tag IEEE_T_EXCOL;   /* Frames transmitted with excessive collisions */
  FEC_IEEE_T_MACERR_tag IEEE_T_MACERR; /* Frames transmitted with Tx FIFO underrun */
  FEC_IEEE_T_CSERR_tag IEEE_T_CSERR;   /* Frames transmitted with carrier sense error */
  FEC_IEEE_T_SQE_tag IEEE_T_SQE;       /* Frames transmitted with SQE error */
  FEC_IEEE_T_FDXFC_tag IEEE_T_FDXFC;   /* Flow control pause frames transmitted */
  FEC_IEEE_T_OCTETS_OK_tag IEEE_T_OCTETS_OK; /* Octet count for frames transmitted without error */
  uint8_t FEC_reserved13[8];
  FEC_RMON_R_DROP_tag RMON_R_DROP;     /* Count of received frames not counted correctly */
  FEC_RMON_R_PACKETS_tag RMON_R_PACKETS; /* RMON Rx packet count */
  FEC_RMON_R_BC_PKT_tag RMON_R_BC_PKT; /* RMON Rx broadcast packets */
  FEC_RMON_R_MC_PKT_tag RMON_R_MC_PKT; /* RMON Rx multicast packets */
  FEC_RMON_R_CRC_ALIGN_tag RMON_R_CRC_ALIGN; /* RMON Rx packets with CRC/Align error */
  FEC_RMON_R_UNDERSIZE_tag RMON_R_UNDERSIZE; /* RMON Rx packets < 64 bytes, good CRC */
  FEC_RMON_R_OVERSIZE_tag RMON_R_OVERSIZE; /* RMON Rx packets > MAX_FL bytes, good CRC */
  FEC_RMON_R_FRAG_tag RMON_R_FRAG;     /* RMON Rx packets < 64 bytes, bad CRC */
  FEC_RMON_R_JAB_tag RMON_R_JAB;       /* RMON Rx packets > MAX_FL bytes, bad CRC */
  FEC_RMON_R_RESVD_0_tag RMON_R_RESVD_0; /* Reserved */
  FEC_RMON_R_P64_tag RMON_R_P64;       /* RMON Rx 64 byte packets */
  FEC_RMON_R_P65TO127_tag RMON_R_P65TO127; /* RMON Rx 65 to 127 byte packets */
  FEC_RMON_R_P128TO255_tag RMON_R_P128TO255; /* RMON Rx 128 to 255 byte packets */
  FEC_RMON_R_P256TO511_tag RMON_R_P256TO511; /* RMON Rx 256 to 511 byte packets */
  FEC_RMON_R_P512TO1023_tag RMON_R_P512TO1023; /* RMON Rx 512 to 1023 byte packets */
  FEC_RMON_R_P1024TO2047_tag RMON_R_P1024TO2047; /* RMON Rx 1024 to 2047 byte packets */
  FEC_RMON_R_P_GTE2048_tag RMON_R_P_GTE2048; /* RMON Rx packets with > 2048 bytes */
  FEC_RMON_R_OCTETS_tag RMON_R_OCTETS; /* RMON Rx octets */
  FEC_IEEE_R_DROP_tag IEEE_R_DROP;     /* Count of received frames not counted correctly */
  FEC_IEEE_R_FRAME_OK_tag IEEE_R_FRAME_OK; /* Frames received OK */
  FEC_IEEE_R_CRC_tag IEEE_R_CRC;       /* Frames received with CRC error */
  FEC_IEEE_R_ALIGN_tag IEEE_R_ALIGN;   /* Frames received with alignment error */
  FEC_IEEE_R_MACERR_tag IEEE_R_MACERR; /* Receive FIFO overflow count */
  FEC_IEEE_R_FDXFC_tag IEEE_R_FDXFC;   /* Flow control pause frames received */
  FEC_IEEE_R_OCTETS_OK_tag IEEE_R_OCTETS_OK; /* Octet count for frames received without error */
};


/* ============================================================================
   =============================== Module: IGF ================================
   ============================================================================ */

typedef union IGF_MCR0_union_tag {     /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR0_tag;

typedef union IGF_MSR0_union_tag {     /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR0_tag;

typedef union IGF_PRESR0_union_tag {   /* Prescaler Register */
  vuint32_t R;
  struct {
    vuint32_t  :23;
    vuint32_t FPRE:9;                  /* Filter prescaler */
  } B;
} IGF_PRESR0_tag;

typedef union IGF_RTHR0_union_tag {    /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR0_tag;

typedef union IGF_FTHR_union_tag {     /* Falling edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t FTH:24;                  /* Falling edge threshold */
  } B;
} IGF_FTHR_tag;

typedef union IGF_MCR1_union_tag {     /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR1_tag;

typedef union IGF_MSR1_union_tag {     /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR1_tag;

typedef union IGF_RTHR1_union_tag {    /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR1_tag;

typedef union IGF_MCR2_union_tag {     /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR2_tag;

typedef union IGF_MSR2_union_tag {     /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR2_tag;

typedef union IGF_RTHR2_union_tag {    /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR2_tag;

typedef union IGF_MCR3_union_tag {     /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR3_tag;

typedef union IGF_MSR3_union_tag {     /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR3_tag;

typedef union IGF_RTHR3_union_tag {    /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR3_tag;

typedef union IGF_MCR4_union_tag {     /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR4_tag;

typedef union IGF_MSR4_union_tag {     /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR4_tag;

typedef union IGF_RTHR4_union_tag {    /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR4_tag;

typedef union IGF_MCR5_union_tag {     /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR5_tag;

typedef union IGF_MSR5_union_tag {     /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR5_tag;

typedef union IGF_RTHR5_union_tag {    /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR5_tag;

typedef union IGF_MCR6_union_tag {     /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR6_tag;

typedef union IGF_MSR6_union_tag {     /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR6_tag;

typedef union IGF_RTHR6_union_tag {    /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR6_tag;

typedef union IGF_MCR7_union_tag {     /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR7_tag;

typedef union IGF_MSR7_union_tag {     /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR7_tag;

typedef union IGF_RTHR7_union_tag {    /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR7_tag;

typedef union IGF_MCR8_union_tag {     /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR8_tag;

typedef union IGF_MSR8_union_tag {     /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR8_tag;

typedef union IGF_RTHR8_union_tag {    /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR8_tag;

typedef union IGF_MCR9_union_tag {     /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR9_tag;

typedef union IGF_MSR9_union_tag {     /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR9_tag;

typedef union IGF_RTHR9_union_tag {    /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR9_tag;

typedef union IGF_MCR10_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR10_tag;

typedef union IGF_MSR10_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR10_tag;

typedef union IGF_RTHR10_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR10_tag;

typedef union IGF_MCR11_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR11_tag;

typedef union IGF_MSR11_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR11_tag;

typedef union IGF_RTHR11_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR11_tag;

typedef union IGF_MCR12_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR12_tag;

typedef union IGF_MSR12_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR12_tag;

typedef union IGF_RTHR12_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR12_tag;

typedef union IGF_MCR13_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR13_tag;

typedef union IGF_MSR13_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR13_tag;

typedef union IGF_RTHR13_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR13_tag;

typedef union IGF_MCR14_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR14_tag;

typedef union IGF_MSR14_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR14_tag;

typedef union IGF_RTHR14_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR14_tag;

typedef union IGF_MCR15_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR15_tag;

typedef union IGF_MSR15_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR15_tag;

typedef union IGF_RTHR15_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR15_tag;

typedef union IGF_MCR16_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR16_tag;

typedef union IGF_MSR16_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR16_tag;

typedef union IGF_RTHR16_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR16_tag;

typedef union IGF_MCR17_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR17_tag;

typedef union IGF_MSR17_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR17_tag;

typedef union IGF_RTHR17_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR17_tag;

typedef union IGF_MCR18_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR18_tag;

typedef union IGF_MSR18_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR18_tag;

typedef union IGF_RTHR18_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR18_tag;

typedef union IGF_MCR19_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR19_tag;

typedef union IGF_MSR19_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR19_tag;

typedef union IGF_RTHR19_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR19_tag;

typedef union IGF_MCR20_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR20_tag;

typedef union IGF_MSR20_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR20_tag;

typedef union IGF_RTHR20_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR20_tag;

typedef union IGF_MCR21_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR21_tag;

typedef union IGF_MSR21_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR21_tag;

typedef union IGF_RTHR21_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR21_tag;

typedef union IGF_MCR22_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR22_tag;

typedef union IGF_MSR22_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR22_tag;

typedef union IGF_RTHR22_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR22_tag;

typedef union IGF_MCR23_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR23_tag;

typedef union IGF_MSR23_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR23_tag;

typedef union IGF_RTHR23_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR23_tag;

typedef union IGF_MCR24_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR24_tag;

typedef union IGF_MSR24_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR24_tag;

typedef union IGF_RTHR24_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR24_tag;

typedef union IGF_MCR25_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR25_tag;

typedef union IGF_MSR25_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR25_tag;

typedef union IGF_RTHR25_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR25_tag;

typedef union IGF_MCR26_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR26_tag;

typedef union IGF_MSR26_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR26_tag;

typedef union IGF_RTHR26_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR26_tag;

typedef union IGF_MCR27_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR27_tag;

typedef union IGF_MSR27_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR27_tag;

typedef union IGF_RTHR27_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR27_tag;

typedef union IGF_MCR28_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR28_tag;

typedef union IGF_MSR28_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR28_tag;

typedef union IGF_RTHR28_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR28_tag;

typedef union IGF_MCR29_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR29_tag;

typedef union IGF_MSR29_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR29_tag;

typedef union IGF_RTHR29_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR29_tag;

typedef union IGF_MCR30_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR30_tag;

typedef union IGF_MSR30_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR30_tag;

typedef union IGF_RTHR30_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR30_tag;

typedef union IGF_MCR31_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR31_tag;

typedef union IGF_MSR31_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR31_tag;

typedef union IGF_RTHR31_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR31_tag;

typedef union IGF_MCR32_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR32_tag;

typedef union IGF_MSR32_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR32_tag;

typedef union IGF_PRESR32_union_tag {  /* Prescaler Register */
  vuint32_t R;
  struct {
    vuint32_t  :23;
    vuint32_t FPRE:9;                  /* Filter prescaler */
  } B;
} IGF_PRESR32_tag;

typedef union IGF_RTHR32_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR32_tag;

typedef union IGF_MCR33_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR33_tag;

typedef union IGF_MSR33_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR33_tag;

typedef union IGF_RTHR33_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR33_tag;

typedef union IGF_MCR34_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR34_tag;

typedef union IGF_MSR34_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR34_tag;

typedef union IGF_RTHR34_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR34_tag;

typedef union IGF_MCR35_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR35_tag;

typedef union IGF_MSR35_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR35_tag;

typedef union IGF_RTHR35_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR35_tag;

typedef union IGF_MCR36_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR36_tag;

typedef union IGF_MSR36_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR36_tag;

typedef union IGF_RTHR36_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR36_tag;

typedef union IGF_MCR37_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR37_tag;

typedef union IGF_MSR37_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR37_tag;

typedef union IGF_RTHR37_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR37_tag;

typedef union IGF_MCR38_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR38_tag;

typedef union IGF_MSR38_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR38_tag;

typedef union IGF_RTHR38_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR38_tag;

typedef union IGF_MCR39_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR39_tag;

typedef union IGF_MSR39_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR39_tag;

typedef union IGF_RTHR39_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR39_tag;

typedef union IGF_MCR40_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR40_tag;

typedef union IGF_MSR40_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR40_tag;

typedef union IGF_RTHR40_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR40_tag;

typedef union IGF_MCR41_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR41_tag;

typedef union IGF_MSR41_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR41_tag;

typedef union IGF_RTHR41_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR41_tag;

typedef union IGF_MCR42_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR42_tag;

typedef union IGF_MSR42_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR42_tag;

typedef union IGF_RTHR42_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR42_tag;

typedef union IGF_MCR43_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR43_tag;

typedef union IGF_MSR43_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR43_tag;

typedef union IGF_RTHR43_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR43_tag;

typedef union IGF_MCR44_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR44_tag;

typedef union IGF_MSR44_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR44_tag;

typedef union IGF_RTHR44_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR44_tag;

typedef union IGF_MCR45_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR45_tag;

typedef union IGF_MSR45_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR45_tag;

typedef union IGF_RTHR45_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR45_tag;

struct IGF_tag {
  IGF_MCR0_tag MCR0;                   /* Module Configuration Register */
  IGF_MSR0_tag MSR0;                   /* Module Status Register */
  uint8_t IGF_reserved0[8];
  IGF_PRESR0_tag PRESR0;               /* Prescaler Register */
  uint8_t IGF_reserved1[8];
  IGF_RTHR0_tag RTHR0;                 /* Rising edge Threshold Register */
  IGF_FTHR_tag FTHR;                   /* Falling edge Threshold Register */
  uint8_t IGF_reserved2[28];
  IGF_MCR1_tag MCR1;                   /* Module Configuration Register */
  IGF_MSR1_tag MSR1;                   /* Module Status Register */
  uint8_t IGF_reserved3[20];
  IGF_RTHR1_tag RTHR1;                 /* Rising edge Threshold Register */
  uint8_t IGF_reserved4[32];
  IGF_MCR2_tag MCR2;                   /* Module Configuration Register */
  IGF_MSR2_tag MSR2;                   /* Module Status Register */
  uint8_t IGF_reserved5[20];
  IGF_RTHR2_tag RTHR2;                 /* Rising edge Threshold Register */
  uint8_t IGF_reserved6[32];
  IGF_MCR3_tag MCR3;                   /* Module Configuration Register */
  IGF_MSR3_tag MSR3;                   /* Module Status Register */
  uint8_t IGF_reserved7[20];
  IGF_RTHR3_tag RTHR3;                 /* Rising edge Threshold Register */
  uint8_t IGF_reserved8[32];
  IGF_MCR4_tag MCR4;                   /* Module Configuration Register */
  IGF_MSR4_tag MSR4;                   /* Module Status Register */
  uint8_t IGF_reserved9[20];
  IGF_RTHR4_tag RTHR4;                 /* Rising edge Threshold Register */
  uint8_t IGF_reserved10[32];
  IGF_MCR5_tag MCR5;                   /* Module Configuration Register */
  IGF_MSR5_tag MSR5;                   /* Module Status Register */
  uint8_t IGF_reserved11[20];
  IGF_RTHR5_tag RTHR5;                 /* Rising edge Threshold Register */
  uint8_t IGF_reserved12[32];
  IGF_MCR6_tag MCR6;                   /* Module Configuration Register */
  IGF_MSR6_tag MSR6;                   /* Module Status Register */
  uint8_t IGF_reserved13[20];
  IGF_RTHR6_tag RTHR6;                 /* Rising edge Threshold Register */
  uint8_t IGF_reserved14[32];
  IGF_MCR7_tag MCR7;                   /* Module Configuration Register */
  IGF_MSR7_tag MSR7;                   /* Module Status Register */
  uint8_t IGF_reserved15[20];
  IGF_RTHR7_tag RTHR7;                 /* Rising edge Threshold Register */
  uint8_t IGF_reserved16[32];
  IGF_MCR8_tag MCR8;                   /* Module Configuration Register */
  IGF_MSR8_tag MSR8;                   /* Module Status Register */
  uint8_t IGF_reserved17[20];
  IGF_RTHR8_tag RTHR8;                 /* Rising edge Threshold Register */
  uint8_t IGF_reserved18[32];
  IGF_MCR9_tag MCR9;                   /* Module Configuration Register */
  IGF_MSR9_tag MSR9;                   /* Module Status Register */
  uint8_t IGF_reserved19[20];
  IGF_RTHR9_tag RTHR9;                 /* Rising edge Threshold Register */
  uint8_t IGF_reserved20[32];
  IGF_MCR10_tag MCR10;                 /* Module Configuration Register */
  IGF_MSR10_tag MSR10;                 /* Module Status Register */
  uint8_t IGF_reserved21[20];
  IGF_RTHR10_tag RTHR10;               /* Rising edge Threshold Register */
  uint8_t IGF_reserved22[32];
  IGF_MCR11_tag MCR11;                 /* Module Configuration Register */
  IGF_MSR11_tag MSR11;                 /* Module Status Register */
  uint8_t IGF_reserved23[20];
  IGF_RTHR11_tag RTHR11;               /* Rising edge Threshold Register */
  uint8_t IGF_reserved24[32];
  IGF_MCR12_tag MCR12;                 /* Module Configuration Register */
  IGF_MSR12_tag MSR12;                 /* Module Status Register */
  uint8_t IGF_reserved25[20];
  IGF_RTHR12_tag RTHR12;               /* Rising edge Threshold Register */
  uint8_t IGF_reserved26[32];
  IGF_MCR13_tag MCR13;                 /* Module Configuration Register */
  IGF_MSR13_tag MSR13;                 /* Module Status Register */
  uint8_t IGF_reserved27[20];
  IGF_RTHR13_tag RTHR13;               /* Rising edge Threshold Register */
  uint8_t IGF_reserved28[32];
  IGF_MCR14_tag MCR14;                 /* Module Configuration Register */
  IGF_MSR14_tag MSR14;                 /* Module Status Register */
  uint8_t IGF_reserved29[20];
  IGF_RTHR14_tag RTHR14;               /* Rising edge Threshold Register */
  uint8_t IGF_reserved30[32];
  IGF_MCR15_tag MCR15;                 /* Module Configuration Register */
  IGF_MSR15_tag MSR15;                 /* Module Status Register */
  uint8_t IGF_reserved31[20];
  IGF_RTHR15_tag RTHR15;               /* Rising edge Threshold Register */
  uint8_t IGF_reserved32[32];
  IGF_MCR16_tag MCR16;                 /* Module Configuration Register */
  IGF_MSR16_tag MSR16;                 /* Module Status Register */
  uint8_t IGF_reserved33[20];
  IGF_RTHR16_tag RTHR16;               /* Rising edge Threshold Register */
  uint8_t IGF_reserved34[32];
  IGF_MCR17_tag MCR17;                 /* Module Configuration Register */
  IGF_MSR17_tag MSR17;                 /* Module Status Register */
  uint8_t IGF_reserved35[20];
  IGF_RTHR17_tag RTHR17;               /* Rising edge Threshold Register */
  uint8_t IGF_reserved36[32];
  IGF_MCR18_tag MCR18;                 /* Module Configuration Register */
  IGF_MSR18_tag MSR18;                 /* Module Status Register */
  uint8_t IGF_reserved37[20];
  IGF_RTHR18_tag RTHR18;               /* Rising edge Threshold Register */
  uint8_t IGF_reserved38[32];
  IGF_MCR19_tag MCR19;                 /* Module Configuration Register */
  IGF_MSR19_tag MSR19;                 /* Module Status Register */
  uint8_t IGF_reserved39[20];
  IGF_RTHR19_tag RTHR19;               /* Rising edge Threshold Register */
  uint8_t IGF_reserved40[32];
  IGF_MCR20_tag MCR20;                 /* Module Configuration Register */
  IGF_MSR20_tag MSR20;                 /* Module Status Register */
  uint8_t IGF_reserved41[20];
  IGF_RTHR20_tag RTHR20;               /* Rising edge Threshold Register */
  uint8_t IGF_reserved42[32];
  IGF_MCR21_tag MCR21;                 /* Module Configuration Register */
  IGF_MSR21_tag MSR21;                 /* Module Status Register */
  uint8_t IGF_reserved43[20];
  IGF_RTHR21_tag RTHR21;               /* Rising edge Threshold Register */
  uint8_t IGF_reserved44[32];
  IGF_MCR22_tag MCR22;                 /* Module Configuration Register */
  IGF_MSR22_tag MSR22;                 /* Module Status Register */
  uint8_t IGF_reserved45[20];
  IGF_RTHR22_tag RTHR22;               /* Rising edge Threshold Register */
  uint8_t IGF_reserved46[32];
  IGF_MCR23_tag MCR23;                 /* Module Configuration Register */
  IGF_MSR23_tag MSR23;                 /* Module Status Register */
  uint8_t IGF_reserved47[20];
  IGF_RTHR23_tag RTHR23;               /* Rising edge Threshold Register */
  uint8_t IGF_reserved48[32];
  IGF_MCR24_tag MCR24;                 /* Module Configuration Register */
  IGF_MSR24_tag MSR24;                 /* Module Status Register */
  uint8_t IGF_reserved49[20];
  IGF_RTHR24_tag RTHR24;               /* Rising edge Threshold Register */
  uint8_t IGF_reserved50[32];
  IGF_MCR25_tag MCR25;                 /* Module Configuration Register */
  IGF_MSR25_tag MSR25;                 /* Module Status Register */
  uint8_t IGF_reserved51[20];
  IGF_RTHR25_tag RTHR25;               /* Rising edge Threshold Register */
  uint8_t IGF_reserved52[32];
  IGF_MCR26_tag MCR26;                 /* Module Configuration Register */
  IGF_MSR26_tag MSR26;                 /* Module Status Register */
  uint8_t IGF_reserved53[20];
  IGF_RTHR26_tag RTHR26;               /* Rising edge Threshold Register */
  uint8_t IGF_reserved54[32];
  IGF_MCR27_tag MCR27;                 /* Module Configuration Register */
  IGF_MSR27_tag MSR27;                 /* Module Status Register */
  uint8_t IGF_reserved55[20];
  IGF_RTHR27_tag RTHR27;               /* Rising edge Threshold Register */
  uint8_t IGF_reserved56[32];
  IGF_MCR28_tag MCR28;                 /* Module Configuration Register */
  IGF_MSR28_tag MSR28;                 /* Module Status Register */
  uint8_t IGF_reserved57[20];
  IGF_RTHR28_tag RTHR28;               /* Rising edge Threshold Register */
  uint8_t IGF_reserved58[32];
  IGF_MCR29_tag MCR29;                 /* Module Configuration Register */
  IGF_MSR29_tag MSR29;                 /* Module Status Register */
  uint8_t IGF_reserved59[20];
  IGF_RTHR29_tag RTHR29;               /* Rising edge Threshold Register */
  uint8_t IGF_reserved60[32];
  IGF_MCR30_tag MCR30;                 /* Module Configuration Register */
  IGF_MSR30_tag MSR30;                 /* Module Status Register */
  uint8_t IGF_reserved61[20];
  IGF_RTHR30_tag RTHR30;               /* Rising edge Threshold Register */
  uint8_t IGF_reserved62[32];
  IGF_MCR31_tag MCR31;                 /* Module Configuration Register */
  IGF_MSR31_tag MSR31;                 /* Module Status Register */
  uint8_t IGF_reserved63[20];
  IGF_RTHR31_tag RTHR31;               /* Rising edge Threshold Register */
  uint8_t IGF_reserved64[32];
  IGF_MCR32_tag MCR32;                 /* Module Configuration Register */
  IGF_MSR32_tag MSR32;                 /* Module Status Register */
  uint8_t IGF_reserved65[8];
  IGF_PRESR32_tag PRESR32;             /* Prescaler Register */
  uint8_t IGF_reserved66[8];
  IGF_RTHR32_tag RTHR32;               /* Rising edge Threshold Register */
  uint8_t IGF_reserved67[32];
  IGF_MCR33_tag MCR33;                 /* Module Configuration Register */
  IGF_MSR33_tag MSR33;                 /* Module Status Register */
  uint8_t IGF_reserved68[20];
  IGF_RTHR33_tag RTHR33;               /* Rising edge Threshold Register */
  uint8_t IGF_reserved69[32];
  IGF_MCR34_tag MCR34;                 /* Module Configuration Register */
  IGF_MSR34_tag MSR34;                 /* Module Status Register */
  uint8_t IGF_reserved70[20];
  IGF_RTHR34_tag RTHR34;               /* Rising edge Threshold Register */
  uint8_t IGF_reserved71[32];
  IGF_MCR35_tag MCR35;                 /* Module Configuration Register */
  IGF_MSR35_tag MSR35;                 /* Module Status Register */
  uint8_t IGF_reserved72[20];
  IGF_RTHR35_tag RTHR35;               /* Rising edge Threshold Register */
  uint8_t IGF_reserved73[32];
  IGF_MCR36_tag MCR36;                 /* Module Configuration Register */
  IGF_MSR36_tag MSR36;                 /* Module Status Register */
  uint8_t IGF_reserved74[20];
  IGF_RTHR36_tag RTHR36;               /* Rising edge Threshold Register */
  uint8_t IGF_reserved75[32];
  IGF_MCR37_tag MCR37;                 /* Module Configuration Register */
  IGF_MSR37_tag MSR37;                 /* Module Status Register */
  uint8_t IGF_reserved76[20];
  IGF_RTHR37_tag RTHR37;               /* Rising edge Threshold Register */
  uint8_t IGF_reserved77[32];
  IGF_MCR38_tag MCR38;                 /* Module Configuration Register */
  IGF_MSR38_tag MSR38;                 /* Module Status Register */
  uint8_t IGF_reserved78[20];
  IGF_RTHR38_tag RTHR38;               /* Rising edge Threshold Register */
  uint8_t IGF_reserved79[32];
  IGF_MCR39_tag MCR39;                 /* Module Configuration Register */
  IGF_MSR39_tag MSR39;                 /* Module Status Register */
  uint8_t IGF_reserved80[20];
  IGF_RTHR39_tag RTHR39;               /* Rising edge Threshold Register */
  uint8_t IGF_reserved81[32];
  IGF_MCR40_tag MCR40;                 /* Module Configuration Register */
  IGF_MSR40_tag MSR40;                 /* Module Status Register */
  uint8_t IGF_reserved82[20];
  IGF_RTHR40_tag RTHR40;               /* Rising edge Threshold Register */
  uint8_t IGF_reserved83[32];
  IGF_MCR41_tag MCR41;                 /* Module Configuration Register */
  IGF_MSR41_tag MSR41;                 /* Module Status Register */
  uint8_t IGF_reserved84[20];
  IGF_RTHR41_tag RTHR41;               /* Rising edge Threshold Register */
  uint8_t IGF_reserved85[32];
  IGF_MCR42_tag MCR42;                 /* Module Configuration Register */
  IGF_MSR42_tag MSR42;                 /* Module Status Register */
  uint8_t IGF_reserved86[20];
  IGF_RTHR42_tag RTHR42;               /* Rising edge Threshold Register */
  uint8_t IGF_reserved87[32];
  IGF_MCR43_tag MCR43;                 /* Module Configuration Register */
  IGF_MSR43_tag MSR43;                 /* Module Status Register */
  uint8_t IGF_reserved88[20];
  IGF_RTHR43_tag RTHR43;               /* Rising edge Threshold Register */
  uint8_t IGF_reserved89[32];
  IGF_MCR44_tag MCR44;                 /* Module Configuration Register */
  IGF_MSR44_tag MSR44;                 /* Module Status Register */
  uint8_t IGF_reserved90[20];
  IGF_RTHR44_tag RTHR44;               /* Rising edge Threshold Register */
  uint8_t IGF_reserved91[32];
  IGF_MCR45_tag MCR45;                 /* Module Configuration Register */
  IGF_MSR45_tag MSR45;                 /* Module Status Register */
  uint8_t IGF_reserved92[20];
  IGF_RTHR45_tag RTHR45;               /* Rising edge Threshold Register */
};


/* ============================================================================
   =============================== Module: INTC ===============================
   ============================================================================ */

typedef union INTC_MCR_union_tag {     /* INTC Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :18;
    vuint32_t VTES_PRC1:1;             /* Vector Table Entry Size for Processor 1 (Core 1) */
    vuint32_t  :4;
    vuint32_t HVEN_PRC1:1;             /* Hardware Vector Enable for Processor 1 (Core 1) */
    vuint32_t  :2;
    vuint32_t VTES_PRC0:1;             /* Vector Table Entry Size for Processor 0 (Core 0) */
    vuint32_t  :4;
    vuint32_t HVEN_PRC0:1;             /* Hardware Vector Enable for Processor 0 (Core 0) */
  } B;
} INTC_MCR_tag;

typedef union INTC_CPR_PRC_union_tag { /* INTC Current Priority Register for Processor n */
  vuint32_t R;
  struct {
    vuint32_t  :28;
    vuint32_t PRI:4;
  } B;
} INTC_CPR_PRC_tag;

typedef union INTC_IACKR_PRC_union_tag { /* INTC Interrupt Acknowledge Register for Processor n */
  vuint32_t R;
  struct {
    vuint32_t VTBA_PRCn:21;            /* Vector Table Base Address */
    vuint32_t INTVEC_PRCn:9;           /* Interrupt Vector */
    vuint32_t  :2;
  } B;
} INTC_IACKR_PRC_tag;

typedef union INTC_EOIR_PRC_union_tag { /* INTC End Of Interrupt Register for Processor n */
  vuint32_t R;
  struct {
    vuint32_t EOI_PRCn:32;             /* End of Interrupt */
  } B;
} INTC_EOIR_PRC_tag;

typedef union INTC_SSCIR_union_tag {   /* INTC Software Set/Clear Interrupt Register */
  vuint8_t R;
  struct {
    vuint8_t  :6;
    vuint8_t SETn:1;
    vuint8_t CLRn:1;
  } B;
} INTC_SSCIR_tag;

typedef union INTC_PSR_union_tag {     /* INTC Priority Select Register */
  vuint8_t R;
  struct {
    vuint8_t PRC_SELn:2;
    vuint8_t  :2;
    vuint8_t PRIn:4;
  } B;
} INTC_PSR_tag;

struct INTC_tag {
  INTC_MCR_tag MCR;                    /* INTC Module Configuration Register */
  uint8_t INTC_reserved0[4];
  INTC_CPR_PRC_tag CPR_PRC[2];         /* INTC Current Priority Register for Processor n */
  INTC_IACKR_PRC_tag IACKR_PRC[2];     /* INTC Interrupt Acknowledge Register for Processor n */
  INTC_EOIR_PRC_tag EOIR_PRC[2];       /* INTC End Of Interrupt Register for Processor n */
  INTC_SSCIR_tag SSCIR[8];             /* INTC Software Set/Clear Interrupt Register */
  uint8_t INTC_reserved1[24];
  INTC_PSR_tag PSR[512];               /* INTC Priority Select Register */
};


/* ============================================================================
   =============================== Module: JDC ================================
   ============================================================================ */

typedef union JDC_MCR_union_tag {      /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :15;
    vuint32_t JIN_IEN:1;
    vuint32_t  :15;
    vuint32_t JOUT_IEN:1;
  } B;
} JDC_MCR_tag;

typedef union JDC_MSR_union_tag {      /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :13;
    vuint32_t JIN_RDY:1;
    vuint32_t  :1;
    vuint32_t JIN_INT:1;
    vuint32_t  :13;
    vuint32_t JOUT_RDY:1;
    vuint32_t  :1;
    vuint32_t JOUT_INT:1;
  } B;
} JDC_MSR_tag;

typedef union JDC_JOUT_IPS_union_tag { /* JTAG Output Data Register */
  vuint32_t R;
  struct {
    vuint32_t Data:32;
  } B;
} JDC_JOUT_IPS_tag;

typedef union JDC_JIN_IPS_union_tag {  /* JTAG Input Data Register */
  vuint32_t R;
  struct {
    vuint32_t Data:32;
  } B;
} JDC_JIN_IPS_tag;

struct JDC_tag {
  JDC_MCR_tag MCR;                     /* Module Configuration Register */
  JDC_MSR_tag MSR;                     /* Module Status Register */
  JDC_JOUT_IPS_tag JOUT_IPS;           /* JTAG Output Data Register */
  JDC_JIN_IPS_tag JIN_IPS;             /* JTAG Input Data Register */
};


/* ============================================================================
   =============================== Module: LFAST ==============================
   ============================================================================ */

typedef union LFAST_MCR_union_tag {    /* LFAST Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MSEN:1;
    vuint32_t  :6;
    vuint32_t IPGDBG:1;
    vuint32_t  :7;
    vuint32_t LSSEL:1;
    vuint32_t DRFEN:1;
    vuint32_t RXEN:1;
    vuint32_t TXEN:1;
    vuint32_t  :8;
    vuint32_t TXARBD:1;
    vuint32_t CTSEN:1;
    vuint32_t  :1;
    vuint32_t DRFRST:1;
    vuint32_t DATAEN:1;
  } B;
} LFAST_MCR_tag;

typedef union LFAST_SCR_union_tag {    /* LFAST Speed Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :15;
    vuint32_t DRMD:1;
    vuint32_t  :7;
    vuint32_t RDR:1;
    vuint32_t  :7;
    vuint32_t TDR:1;
  } B;
} LFAST_SCR_tag;

typedef union LFAST_COCR_union_tag {   /* LFAST Correlator Control Register */
  vuint32_t R;
  struct {
    vuint32_t SMPSEL:8;
    vuint32_t  :6;
    vuint32_t  :2;
    vuint32_t  :12;
    vuint32_t CORRTH:3;
    vuint32_t PHSSEL:1;
  } B;
} LFAST_COCR_tag;

typedef union LFAST_TMCR_union_tag {   /* LFAST Test Mode Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :6;
    vuint32_t CLKTST:1;
    vuint32_t LPON:1;
    vuint32_t  :5;
    vuint32_t LPMOD:3;
    vuint32_t LPFRMTH:16;
  } B;
} LFAST_TMCR_tag;

typedef union LFAST_ALCR_union_tag {   /* LFAST Auto Loopback Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :15;
    vuint32_t LPCNTEN:1;
    vuint32_t LPFMCNT:16;
  } B;
} LFAST_ALCR_tag;

typedef union LFAST_RCDCR_union_tag {  /* LFAST Rate Change Delay Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t DRCNT:4;
    vuint32_t  :16;
  } B;
} LFAST_RCDCR_tag;

typedef union LFAST_SLCR_union_tag {   /* LFAST Wakeup Delay Control Register */
  vuint32_t R;
  struct {
    vuint32_t HSCNT:8;
    vuint32_t  :4;
    vuint32_t LSCNT:4;
    vuint32_t HWKCNT:8;
    vuint32_t  :4;
    vuint32_t LWKCNT:4;
  } B;
} LFAST_SLCR_tag;

typedef union LFAST_ICR_union_tag {    /* LFAST ICLC Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :14;
    vuint32_t ICLCSEQ:1;
    vuint32_t SNDICLC:1;
    vuint32_t  :8;
    vuint32_t ICLCPLD:8;
  } B;
} LFAST_ICR_tag;

typedef union LFAST_PICR_union_tag {   /* LFAST Ping Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :15;
    vuint32_t PNGREQ:1;
    vuint32_t PNGAUTO:1;
    vuint32_t  :7;
    vuint32_t PNGPYLD:8;
  } B;
} LFAST_PICR_tag;

typedef union LFAST_RFCR_union_tag {   /* LFAST Rx FIFO CTS Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :10;
    vuint32_t RCTSMX:6;
    vuint32_t  :10;
    vuint32_t RCTSMN:6;
  } B;
} LFAST_RFCR_tag;

typedef union LFAST_TIER_union_tag {   /* LFAST Tx Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :14;
    vuint32_t TXIIE:1;
    vuint32_t TXOVIE:1;
    vuint32_t  :11;
    vuint32_t TXPNGIE:1;
    vuint32_t  :1;
    vuint32_t TXUNSIE:1;
    vuint32_t TXICLCIE:1;
    vuint32_t TXDTIE:1;
  } B;
} LFAST_TIER_tag;

typedef union LFAST_RIER_union_tag {   /* LFAST Rx Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RXUOIE:1;
    vuint32_t RXMNIE:1;
    vuint32_t RXMXIE:1;
    vuint32_t RXUFIE:1;
    vuint32_t RXOFIE:1;
    vuint32_t RXSZIE:1;
    vuint32_t RXICIE:1;
    vuint32_t RXLCEIE:1;
    vuint32_t  :12;
    vuint32_t RXCTSIE:1;
    vuint32_t RXDIE:1;
    vuint32_t RXUNSIE:1;
    vuint32_t  :1;
  } B;
} LFAST_RIER_tag;

typedef union LFAST_RIIER_union_tag {  /* LFAST Rx ICLC Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :18;
    vuint32_t ICPFIE:1;
    vuint32_t ICPSIE:1;
    vuint32_t ICPRIE:1;
    vuint32_t ICTOIE:1;
    vuint32_t ICLPIE:1;
    vuint32_t ICCTIE:1;
    vuint32_t ICTDIE:1;
    vuint32_t ICTEIE:1;
    vuint32_t ICRFIE:1;
    vuint32_t ICRSIE:1;
    vuint32_t ICTFIE:1;
    vuint32_t ICTSIE:1;
    vuint32_t ICPOFIE:1;
    vuint32_t ICPONIE:1;
  } B;
} LFAST_RIIER_tag;

typedef union LFAST_PLLCR_union_tag {  /* LFAST PLL Control Register */
  vuint32_t R;
  struct {
    vuint32_t IPTMOD:3;
    vuint32_t  :11;
    vuint32_t SWPOFF:1;
    vuint32_t SWPON:1;
    vuint32_t REFINV:1;
    vuint32_t LPCFG:2;
    vuint32_t  :2;
    vuint32_t PLCKCW:2;
    vuint32_t FDIVEN:1;
    vuint32_t FBDIV:6;
    vuint32_t PREDIV:2;
  } B;
} LFAST_PLLCR_tag;

typedef union LFAST_LCR_union_tag {    /* LFAST LVDS Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t SWWKLD:1;
    vuint32_t SWSLPLD:1;
    vuint32_t SWWKLR:1;
    vuint32_t SWSLPLR:1;
    vuint32_t SWOFFLD:1;
    vuint32_t SWONLD:1;
    vuint32_t SWOFFLR:1;
    vuint32_t SWONLR:1;
    vuint32_t LVRXOFF:1;
    vuint32_t LVTXOE:1;
    vuint32_t TXCMUX:1;
    vuint32_t LVRFEN:1;
    vuint32_t LVLPEN:1;                /* Tx LVDS internal loopback enable */
    vuint32_t  :5;
    vuint32_t LVRXOP_TR:1;
    vuint32_t  :1;
    vuint32_t LVRXOP_BR:1;
    vuint32_t LVTXOP:1;
    vuint32_t LVCKSS:1;                /* LVDS Clock Sync Select */
    vuint32_t LVCKP:1;
  } B;
} LFAST_LCR_tag;

typedef union LFAST_UNSTCR_union_tag { /* LFAST Unsolicited Tx Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :15;
    vuint32_t USNDRQ:1;
    vuint32_t  :9;
    vuint32_t UNSHDR:7;
  } B;
} LFAST_UNSTCR_tag;

typedef union LFAST_UNSTDR_union_tag { /* LFAST Unsolicited Tx Data Registers */
  vuint32_t R;
  struct {
    vuint32_t UNTXD:32;
  } B;
} LFAST_UNSTDR_tag;

typedef union LFAST_GSR_union_tag {    /* LFAST Global Status Register */
  vuint32_t R;
  struct {
    vuint32_t DUALMD:1;
    vuint32_t  :12;
    vuint32_t LRMD:1;
    vuint32_t LDSM:1;
    vuint32_t DRSM:1;
    vuint32_t  :11;
    vuint32_t LPTXDN:1;
    vuint32_t LPFPDV:1;
    vuint32_t LPCPDV:1;
    vuint32_t LPCHDV:1;
    vuint32_t LPCSDV:1;
  } B;
} LFAST_GSR_tag;

typedef union LFAST_PISR_union_tag {   /* LFAST Ping Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t RXPNGD:8;
  } B;
} LFAST_PISR_tag;

typedef union LFAST_DFSR_union_tag {   /* LFAST Data Frame Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t RXDCNT:6;
    vuint32_t  :5;
    vuint32_t RXFCNT:3;
    vuint32_t  :2;
    vuint32_t TXDCNT:6;
    vuint32_t  :5;
    vuint32_t TXFCNT:3;
  } B;
} LFAST_DFSR_tag;

typedef union LFAST_TISR_union_tag {   /* LFAST Tx Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :14;
    vuint32_t TXIEF:1;
    vuint32_t TXOVF:1;
    vuint32_t  :11;
    vuint32_t TXPNGF:1;
    vuint32_t  :1;
    vuint32_t TXUNSF:1;
    vuint32_t TXICLCF:1;
    vuint32_t TXDTF:1;
  } B;
} LFAST_TISR_tag;

typedef union LFAST_RISR_union_tag {   /* LFAST Rx Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RXUOF:1;
    vuint32_t RXMNF:1;
    vuint32_t RXMXF:1;
    vuint32_t RXUFF:1;
    vuint32_t RXOFF:1;
    vuint32_t RXSZF:1;
    vuint32_t RXICF:1;
    vuint32_t RXLCEF:1;
    vuint32_t  :12;
    vuint32_t RXCTSF:1;
    vuint32_t RXDF:1;
    vuint32_t RXUNSF:1;
    vuint32_t  :1;
  } B;
} LFAST_RISR_tag;

typedef union LFAST_RIISR_union_tag {  /* LFAST Rx ICLC Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :18;
    vuint32_t ICPFF:1;
    vuint32_t ICPSF:1;
    vuint32_t ICPRF:1;
    vuint32_t ICTOF:1;
    vuint32_t ICLPF:1;
    vuint32_t ICCTF:1;
    vuint32_t ICTDF:1;
    vuint32_t ICTEF:1;
    vuint32_t ICRFF:1;
    vuint32_t ICRSF:1;
    vuint32_t ICTFF:1;
    vuint32_t ICTSF:1;
    vuint32_t ICPOFF:1;
    vuint32_t ICPONF:1;
  } B;
} LFAST_RIISR_tag;

typedef union LFAST_PLLLSR_union_tag { /* LFAST PLL and LVDS Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :14;
    vuint32_t PLLDIS:1;
    vuint32_t PLDCR:1;
    vuint32_t  :12;
    vuint32_t LRSLPS:1;
    vuint32_t LDSLPS:1;
    vuint32_t LDPDS:1;
    vuint32_t LRPDS:1;
  } B;
} LFAST_PLLLSR_tag;

typedef union LFAST_UNSRSR_union_tag { /* LFAST Unsolicited Rx Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :23;
    vuint32_t URXDV:1;
    vuint32_t  :5;
    vuint32_t URPCNT:3;
  } B;
} LFAST_UNSRSR_tag;

typedef union LFAST_UNSRDR_union_tag { /* LFAST Unsolicited Rx Data Register */
  vuint32_t R;
  struct {
    vuint32_t UNRXD:32;
  } B;
} LFAST_UNSRDR_tag;

struct LFAST_tag {
  LFAST_MCR_tag MCR;                   /* LFAST Mode Configuration Register */
  LFAST_SCR_tag SCR;                   /* LFAST Speed Control Register */
  LFAST_COCR_tag COCR;                 /* LFAST Correlator Control Register */
  LFAST_TMCR_tag TMCR;                 /* LFAST Test Mode Control Register */
  LFAST_ALCR_tag ALCR;                 /* LFAST Auto Loopback Control Register */
  LFAST_RCDCR_tag RCDCR;               /* LFAST Rate Change Delay Control Register */
  LFAST_SLCR_tag SLCR;                 /* LFAST Wakeup Delay Control Register */
  LFAST_ICR_tag ICR;                   /* LFAST ICLC Control Register */
  LFAST_PICR_tag PICR;                 /* LFAST Ping Control Register */
  uint8_t LFAST_reserved0[8];
  LFAST_RFCR_tag RFCR;                 /* LFAST Rx FIFO CTS Control Register */
  LFAST_TIER_tag TIER;                 /* LFAST Tx Interrupt Enable Register */
  LFAST_RIER_tag RIER;                 /* LFAST Rx Interrupt Enable Register */
  LFAST_RIIER_tag RIIER;               /* LFAST Rx ICLC Interrupt Enable Register */
  LFAST_PLLCR_tag PLLCR;               /* LFAST PLL Control Register */
  LFAST_LCR_tag LCR;                   /* LFAST LVDS Control Register */
  LFAST_UNSTCR_tag UNSTCR;             /* LFAST Unsolicited Tx Control Register */
  LFAST_UNSTDR_tag UNSTDR[9];          /* LFAST Unsolicited Tx Data Registers */
  uint8_t LFAST_reserved1[20];
  LFAST_GSR_tag GSR;                   /* LFAST Global Status Register */
  LFAST_PISR_tag PISR;                 /* LFAST Ping Status Register */
  uint8_t LFAST_reserved2[12];
  LFAST_DFSR_tag DFSR;                 /* LFAST Data Frame Status Register */
  LFAST_TISR_tag TISR;                 /* LFAST Tx Interrupt Status Register */
  LFAST_RISR_tag RISR;                 /* LFAST Rx Interrupt Status Register */
  LFAST_RIISR_tag RIISR;               /* LFAST Rx ICLC Interrupt Status Register */
  LFAST_PLLLSR_tag PLLLSR;             /* LFAST PLL and LVDS Status Register */
  LFAST_UNSRSR_tag UNSRSR;             /* LFAST Unsolicited Rx Status Register */
  LFAST_UNSRDR_tag UNSRDR[9];          /* LFAST Unsolicited Rx Data Register */
};


/* ============================================================================
   =============================== Module: MPU ================================
   ============================================================================ */

typedef union MPU_CESR_union_tag {     /* Control/Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t SPERR:3;                 /* Slave Port n Error */
    vuint32_t  :5;
    vuint32_t  :1;
    vuint32_t  :3;
    vuint32_t HRL:4;                   /* Hardware Revision Level */
    vuint32_t NSP:4;                   /* Number Of Slave Ports */
    vuint32_t NRGD:4;                  /* Number Of Region Descriptors */
    vuint32_t  :7;
    vuint32_t VLD:1;                   /* Valid */
  } B;
} MPU_CESR_tag;

typedef union MPU_ERROR_EAR_union_tag { /* Error Address Register, slave port n */
  vuint32_t R;
  struct {
    vuint32_t EADDR:32;                /* Error Address */
  } B;
} MPU_ERROR_EAR_tag;

typedef union MPU_ERROR_EDR_union_tag { /* Error Detail Register, slave port n */
  vuint32_t R;
  struct {
    vuint32_t EACD:16;                 /* Error Access Control Detail */
    vuint32_t EPID:8;                  /* Error Process Identification */
    vuint32_t EMN:4;                   /* Error Master Number */
    vuint32_t EATTR:3;                 /* Error Attributes */
    vuint32_t ERW:1;                   /* Error Read/Write */
  } B;
} MPU_ERROR_EDR_tag;

typedef struct MPU_ERROR_struct_tag {
  MPU_ERROR_EAR_tag EAR;               /* Error Address Register, slave port n */
  MPU_ERROR_EDR_tag EDR;               /* Error Detail Register, slave port n */
} MPU_ERROR_tag;

typedef union MPU_RGD_WORD0_union_tag { /* Region Descriptor n, Word 0 */
  vuint32_t R;
  struct {
    vuint32_t SRTADDR:27;              /* Start Address */
    vuint32_t  :5;
  } B;
} MPU_RGD_WORD0_tag;

typedef union MPU_RGD_WORD1_union_tag { /* Region Descriptor n, Word 1 */
  vuint32_t R;
  struct {
    vuint32_t ENDADDR:27;              /* End Address */
    vuint32_t  :5;
  } B;
} MPU_RGD_WORD1_tag;

typedef union MPU_RGD_WORD2_union_tag { /* Region Descriptor n, Word 2 */
  vuint32_t R;
  struct {
    vuint32_t M7RE:1;                  /* Bus Master 7 Read Enable */
    vuint32_t M7WE:1;                  /* Bus Master 7 Write Enable */
    vuint32_t M6RE:1;                  /* Bus Master 6 Read Enable */
    vuint32_t M6WE:1;                  /* Bus Master 6 Write Enable */
    vuint32_t M5RE:1;                  /* Bus Master 5 Read Enable */
    vuint32_t M5WE:1;                  /* Bus Master 5 Write Enable */
    vuint32_t M4RE:1;                  /* Bus Master 4 Read Enable */
    vuint32_t M4WE:1;                  /* Bus Master 4 Write Enable */
    vuint32_t M3PE:1;                  /* Bus Master 3 Process Identifier Enable */
    vuint32_t M3SM:2;                  /* Bus Master 3 Supervisor Mode Access Control */
    vuint32_t M3UM:3;                  /* Bus Master 3 User Mode Access Control */
    vuint32_t M2PE:1;                  /* Bus Master 2 Process Identifier Enable */
    vuint32_t M2SM:2;                  /* Bus Master 2 Supervisor Mode Access Control */
    vuint32_t M2UM:3;                  /* Bus Master 2 User Mode Access control */
    vuint32_t M1PE:1;                  /* Bus Master 1 Process Identifier enable */
    vuint32_t M1SM:2;                  /* Bus Master 1 Supervisor Mode Access Control */
    vuint32_t M1UM:3;                  /* Bus Master 1 User Mode Access Control */
    vuint32_t M0PE:1;                  /* Bus Master 0 Process Identifier enable */
    vuint32_t M0SM:2;                  /* Bus Master 0 Supervisor Mode Access Control */
    vuint32_t M0UM:3;                  /* Bus Master 0 User Mode Access Control */
  } B;
} MPU_RGD_WORD2_tag;

typedef union MPU_RGD_WORD3_union_tag { /* Region Descriptor n, Word 3 */
  vuint32_t R;
  struct {
    vuint32_t PID:8;                   /* Process Identifier */
    vuint32_t PIDMASK:8;               /* Process Identifier Mask */
    vuint32_t  :15;
    vuint32_t VLD:1;                   /* Valid */
  } B;
} MPU_RGD_WORD3_tag;

typedef struct MPU_RGD_struct_tag {
  MPU_RGD_WORD0_tag WORD0;             /* Region Descriptor n, Word 0 */
  MPU_RGD_WORD1_tag WORD1;             /* Region Descriptor n, Word 1 */
  MPU_RGD_WORD2_tag WORD2;             /* Region Descriptor n, Word 2 */
  MPU_RGD_WORD3_tag WORD3;             /* Region Descriptor n, Word 3 */
} MPU_RGD_tag;

typedef union MPU_RGDAAC_union_tag {   /* Region Descriptor Alternate Access Control n */
  vuint32_t R;
  struct {
    vuint32_t M7RE:1;                  /* Bus Master 7 Read Enable */
    vuint32_t M7WE:1;                  /* Bus Master 7 Write Enable */
    vuint32_t M6RE:1;                  /* Bus Master 6 Read Enable */
    vuint32_t M6WE:1;                  /* Bus Master 6 Write Enable */
    vuint32_t M5RE:1;                  /* Bus Master 5 Read Enable */
    vuint32_t M5WE:1;                  /* Bus Master 5 Write Enable */
    vuint32_t M4RE:1;                  /* Bus Master 4 Read Enable */
    vuint32_t M4WE:1;                  /* Bus Master 4 Write Enable */
    vuint32_t M3PE:1;                  /* Bus Master 3 Process Identifier Enable */
    vuint32_t M3SM:2;                  /* Bus Master 3 Supervisor Mode Access Control */
    vuint32_t M3UM:3;                  /* Bus Master 3 User Mode Access Control */
    vuint32_t M2PE:1;                  /* Bus Master 2 Process Identifier Enable */
    vuint32_t M2SM:2;                  /* Bus Master 2 Supervisor Mode Access Control */
    vuint32_t M2UM:3;                  /* Bus Master 2 User Mode Access Control */
    vuint32_t M1PE:1;                  /* Bus Master 1 Process Identifier Enable */
    vuint32_t M1SM:2;                  /* Bus Master 1 Supervisor Mode Access Control */
    vuint32_t M1UM:3;                  /* Bus Master 1 User Mode Access Control */
    vuint32_t M0PE:1;                  /* Bus Master 0 Process Identifier Enable */
    vuint32_t M0SM:2;                  /* Bus Master 0 Supervisor Mode Access Control */
    vuint32_t M0UM:3;                  /* Bus Master 0 User Mode Access Control */
  } B;
} MPU_RGDAAC_tag;

struct MPU_tag {
  MPU_CESR_tag CESR;                   /* Control/Error Status Register */
  uint8_t MPU_reserved0[12];
  MPU_ERROR_tag ERROR[3];
  uint8_t MPU_reserved1[984];
  MPU_RGD_tag RGD[16];
  uint8_t MPU_reserved2[768];
  MPU_RGDAAC_tag RGDAAC[16];           /* Region Descriptor Alternate Access Control n */
};


/* ============================================================================
   =============================== Module: M_CAN ==============================
   ============================================================================ */

typedef union M_CAN_CREL_union_tag {   /* Core Release Register */
  vuint32_t R;
  struct {
    vuint32_t REL:4;                   /* Core Release */
    vuint32_t STEP:4;                  /* Step of Core Release */
    vuint32_t SUBSTEP:4;               /* Sub-step of Core Release */
    vuint32_t YEAR:4;                  /* Time Stamp Year */
    vuint32_t MON:8;                   /* Time Stamp Month */
    vuint32_t DAY:8;                   /* Time Stamp Day */
  } B;
} M_CAN_CREL_tag;

typedef union M_CAN_ENDN_union_tag {   /* Endian Register */
  vuint32_t R;
  struct {
    vuint32_t ETV:32;                  /* Endianness Test Value */
  } B;
} M_CAN_ENDN_tag;

typedef union M_CAN_FBTP_union_tag {   /* Fast Bit Timing and Prescaler Register */
  vuint32_t R;
  struct {
    vuint32_t  :3;
    vuint32_t TDCO:5;                  /* Transceiver Delay Compensation Offset */
    vuint32_t TDC:1;                   /* Transceiver Delay Compensation */
    vuint32_t  :2;
    vuint32_t FBRP:5;                  /* Fast Baud Rate Prescaler */
    vuint32_t  :4;
    vuint32_t FTSEG1:4;                /* Fast time segment before sample point */
    vuint32_t  :1;
    vuint32_t FTSEG2:3;                /* Fast time segment after sample point */
    vuint32_t  :2;
    vuint32_t FSJW:2;                  /* Fast (Re) Synchronization Jump Width */
  } B;
} M_CAN_FBTP_tag;

typedef union M_CAN_TEST_union_tag {   /* Test Register */
  vuint32_t R;
  struct {
    vuint32_t  :18;
    vuint32_t TDCV:6;                  /* Transceiver Delay Compensation Value */
    vuint32_t RX:1;                    /* Receive Pin */
    vuint32_t TX:2;                    /* Control of Transmit Pin */
    vuint32_t LBCK:1;                  /* Loopback mode */
    vuint32_t  :4;
  } B;
} M_CAN_TEST_tag;

typedef union M_CAN_RWD_union_tag {    /* RAM Watchdog Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t WDV:8;                   /* Watchdog Value */
    vuint32_t WDC:8;                   /* Watchdog Configuration */
  } B;
} M_CAN_RWD_tag;

typedef union M_CAN_CCCR_union_tag {   /* CC Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :17;
    vuint32_t TXP:1;                   /* Transmit Pause */
    vuint32_t FDBS:1;                  /* CAN FD Bit Rate Switching */
    vuint32_t FDO:1;                   /* CAN FD Operation */
    vuint32_t CMR:2;                   /* CAN Mode Request */
    vuint32_t CME:2;                   /* CAN Mode Enable */
    vuint32_t TEST:1;                  /* Test Mode Enable */
    vuint32_t DAR:1;                   /* Disable Automatic Retransmission */
    vuint32_t MON:1;                   /* Bus Monitoring Mode */
    vuint32_t CSR:1;                   /* Clock Stop Request */
    vuint32_t CSA:1;                   /* Clock Stop Acknowledge */
    vuint32_t ASM:1;                   /* Restricted Operation Mode */
    vuint32_t CCE:1;                   /* Configuration Change Enable */
    vuint32_t INIT:1;                  /* Initialization */
  } B;
} M_CAN_CCCR_tag;

typedef union M_CAN_BTP_union_tag {    /* Bit Timing and Prescaler Register */
  vuint32_t R;
  struct {
    vuint32_t  :6;
    vuint32_t BRP:10;                  /* Baud Rate Prescaler */
    vuint32_t  :2;
    vuint32_t TSEG1:6;                 /* Time segment before sample point */
    vuint32_t TSEG2:4;                 /* Time segment after sample point */
    vuint32_t SJW:4;                   /* (Re) Synchronization Jump Width */
  } B;
} M_CAN_BTP_tag;

typedef union M_CAN_TSCC_union_tag {   /* Timestamp Counter Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t TCP:4;                   /* Timestamp Counter Prescaler */
    vuint32_t  :14;
    vuint32_t TSS:2;                   /* Timestamp Select */
  } B;
} M_CAN_TSCC_tag;

typedef union M_CAN_TSCV_union_tag {   /* Timestamp Counter Value Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t TSC:16;                  /* Timestamp Counter */
  } B;
} M_CAN_TSCV_tag;

typedef union M_CAN_TOCC_union_tag {   /* Timeout Counter Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t TOP:16;                  /* Timeout Period */
    vuint32_t  :13;
    vuint32_t TOS:2;                   /* Timeout Select */
    vuint32_t ETOC:1;                  /* Enable Timeout Counte */
  } B;
} M_CAN_TOCC_tag;

typedef union M_CAN_TOCV_union_tag {   /* Timeout Counter Value Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t TOC:16;                  /* Timeout Counter */
  } B;
} M_CAN_TOCV_tag;

typedef union M_CAN_ECR_union_tag {    /* Error Counter Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t CEL:8;                   /* CAN Error Logging */
    vuint32_t RP:1;                    /* Receive Error Passive */
    vuint32_t REC:7;                   /* Receive Error Counter */
    vuint32_t TEC:8;                   /* Transmit Error Counter */
  } B;
} M_CAN_ECR_tag;

typedef union M_CAN_PSR_union_tag {    /* Protocol Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :18;
    vuint32_t REDL:1;                  /* Received a CAN FD Message */
    vuint32_t RBRS:1;                  /* BRS flag of last received CAN FD Message */
    vuint32_t RESI:1;                  /* ESI flag of last received CAN FD Message */
    vuint32_t FLEC:3;                  /* Fast Last Error Code */
    vuint32_t BO:1;                    /* Bus_Off Status */
    vuint32_t EW:1;                    /* Warning Status */
    vuint32_t EP:1;                    /* Error Passive */
    vuint32_t ACT:2;                   /* Activity */
    vuint32_t LEC:3;                   /* Last Error Code */
  } B;
} M_CAN_PSR_tag;

typedef union M_CAN_IR_union_tag {     /* Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t STE:1;                   /* Stuff Error */
    vuint32_t FOE:1;                   /* Format Error */
    vuint32_t ACKE:1;                  /* Acknowledge Error */
    vuint32_t BE:1;                    /* Bit Error */
    vuint32_t CRCE:1;                  /* CRC Error */
    vuint32_t WDI:1;                   /* Watchdog Interrupt */
    vuint32_t BO:1;                    /* Bus_Off Status */
    vuint32_t EW:1;                    /* Warning Status */
    vuint32_t EP:1;                    /* Error Passive */
    vuint32_t ELO:1;                   /* Error Logging Overflow */
    vuint32_t BEU:1;                   /* Bit Error Uncorrected */
    vuint32_t BEC:1;                   /* Bit Error Corrected */
    vuint32_t DRX:1;                   /* Message stored to Dedicated Rx Buffer */
    vuint32_t TOO:1;                   /* Timeout Occurred */
    vuint32_t MRAF:1;                  /* Message RAM Access Failure */
    vuint32_t TSW:1;                   /* Timestamp Wraparound */
    vuint32_t TEFL:1;                  /* Tx Event FIFO Element Lost */
    vuint32_t TEFF:1;                  /* Tx Event FIFO Full */
    vuint32_t TEFW:1;                  /* Tx Event FIFO Watermark Reached */
    vuint32_t TEFN:1;                  /* Tx Event FIFO New Entry */
    vuint32_t TFE:1;                   /* Tx FIFO Empty */
    vuint32_t TCF:1;                   /* Transmission Cancellation Finished */
    vuint32_t TC:1;
    vuint32_t HPM:1;                   /* High Priority Message */
    vuint32_t RF1L:1;                  /* Rx FIFO 1 Message Lost */
    vuint32_t RF1F:1;                  /* Rx FIFO 1 Full */
    vuint32_t RF1W:1;                  /* Rx FIFO 1 Watermark Reached */
    vuint32_t RF1N:1;                  /* Rx FIFO 1 New Message */
    vuint32_t RF0L:1;                  /* Rx FIFO 0 Message Lost */
    vuint32_t RF0F:1;                  /* Rx FIFO 0 Full */
    vuint32_t RF0W:1;                  /* Rx FIFO 0 Watermark Reached */
    vuint32_t RF0N:1;                  /* Rx FIFO 0 New Message */
  } B;
} M_CAN_IR_tag;

typedef union M_CAN_IE_union_tag {     /* Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t STEE:1;                  /* Stuff Error Interrupt Enable */
    vuint32_t FOEE:1;                  /* Format Error Interrupt Enable */
    vuint32_t ACKEE:1;                 /* Acknowledge Error Interrupt Enable */
    vuint32_t BEE:1;                   /* Bit Error Interrupt Enable */
    vuint32_t CRCEE:1;                 /* CRC Error Interrupt Enable */
    vuint32_t WDIE:1;                  /* Watchdog Interrupt Enable */
    vuint32_t BOE:1;                   /* Bus_Off Status Interrupt Enable */
    vuint32_t EWE:1;                   /* Warning Status Interrupt Enable */
    vuint32_t EPE:1;                   /* Error Passive Interrupt Enable */
    vuint32_t ELOE:1;                  /* Error Logging Overflow Interrupt Enable */
    vuint32_t BEUE:1;                  /* Bit Error Uncorrected Interrupt Enable */
    vuint32_t BECE:1;                  /* Bit Error Corrected Interrupt Enable */
    vuint32_t DRXE:1;                  /* Message stored to Dedicated Rx Buffer Interrupt Enable */
    vuint32_t TOOE:1;                  /* Timeout Occurred Interrupt Enable */
    vuint32_t MRAFE:1;                 /* Message RAM Access Failure Interrupt Enable */
    vuint32_t TSWE:1;                  /* Timestamp Wraparound Interrupt Enable */
    vuint32_t TEFLE:1;                 /* Tx Event FIFO Element Lost Interrupt Enable */
    vuint32_t TEFFE:1;                 /* Tx Event FIFO Full Interrupt Enable */
    vuint32_t TEFWE:1;                 /* Tx Event FIFO Watermark Reached Interrupt Enable */
    vuint32_t TEFNE:1;                 /* Tx Event FIFO New Entry Interrupt Enable */
    vuint32_t TFEE:1;                  /* Tx FIFO Empty Interrupt Enable */
    vuint32_t TCFE:1;                  /* Transmission Cancellation Finished Interrupt Enable */
    vuint32_t TCE:1;                   /* Transmission Completed Interrupt Enable */
    vuint32_t HPME:1;                  /* High Priority Message Interrupt Enable */
    vuint32_t RF1LE:1;                 /* Rx FIFO 1 Message Lost Interrupt Enable */
    vuint32_t RF1FE:1;                 /* Rx FIFO 1 Full Interrupt Enable */
    vuint32_t RF1WE:1;                 /* Rx FIFO 1 Watermark Reached Interrupt Enable */
    vuint32_t RF1NE:1;                 /* Rx FIFO 1 New Message Interrupt Enable */
    vuint32_t RF0LE:1;                 /* Rx FIFO 0 Message Lost Interrupt Enable */
    vuint32_t RF0FE:1;                 /* Rx FIFO 0 Full Interrupt Enable */
    vuint32_t RF0WE:1;                 /* Rx FIFO 0 Watermark Reached Interrupt Enable */
    vuint32_t RF0NE:1;                 /* Rx FIFO 0 New Message Interrupt Enable */
  } B;
} M_CAN_IE_tag;

typedef union M_CAN_ILS_union_tag {    /* Interrupt Line Select Register */
  vuint32_t R;
  struct {
    vuint32_t STEL:1;                  /* Stuff Error Interrupt Line */
    vuint32_t FOEL:1;                  /* Format Error Interrupt Line */
    vuint32_t ACKEL:1;                 /* Acknowledge Error Interrupt Line */
    vuint32_t BEL:1;                   /* Bit Error Interrupt Line */
    vuint32_t CRCEL:1;                 /* CRC Error Interrupt Line */
    vuint32_t WDIL:1;                  /* Watchdog Interrupt Line */
    vuint32_t BOL:1;                   /* Bus_Off Status Interrupt Line */
    vuint32_t EWL:1;                   /* Warning Status Interrupt Line */
    vuint32_t EPL:1;                   /* Error Passive Interrupt Line */
    vuint32_t ELOL:1;                  /* Error Logging Overflow Interrupt Line */
    vuint32_t BEUL:1;                  /* Bit Error Uncorrected Interrupt Line */
    vuint32_t BECL:1;                  /* Bit Error Corrected Interrupt Line */
    vuint32_t DRXL:1;                  /* Message stored to Dedicated Rx Buffer Interrupt Line */
    vuint32_t TOOL:1;                  /* Timeout Occurred Interrupt Line */
    vuint32_t MRAFL:1;                 /* Message RAM Access Failure Interrupt Line */
    vuint32_t TSWL:1;                  /* Timestamp Wraparound Interrupt Line */
    vuint32_t TEFLL:1;                 /* Tx Event FIFO Element Lost Interrupt Line */
    vuint32_t TEFFL:1;                 /* Tx Event FIFO Full Interrupt Line */
    vuint32_t TEFWL:1;                 /* Tx Event FIFO Watermark Reached Interrupt Line */
    vuint32_t TEFNL:1;                 /* Tx Event FIFO New Entry Interrupt Line */
    vuint32_t TFEL:1;                  /* Tx FIFO Empty Interrupt Line */
    vuint32_t TCFL:1;                  /* Transmission Cancellation Finished Interrupt Line */
    vuint32_t TCL:1;                   /* Transmission Completed Interrupt Line */
    vuint32_t HPML:1;                  /* High Priority Message Interrupt Line */
    vuint32_t RF1LL:1;                 /* Rx FIFO 1 Message Lost Interrupt Line */
    vuint32_t RF1FL:1;                 /* Rx FIFO 1 Full Interrupt Line */
    vuint32_t RF1WL:1;                 /* Rx FIFO 1 Watermark Reached Interrupt Line */
    vuint32_t RF1NL:1;                 /* Rx FIFO 1 New Message Interrupt Line */
    vuint32_t RF0LL:1;                 /* Rx FIFO 0 Message Lost Interrupt Line */
    vuint32_t RF0FL:1;                 /* Rx FIFO 0 Full Interrupt Line */
    vuint32_t RF0WL:1;                 /* Rx FIFO 0 Watermark Reached Interrupt Line */
    vuint32_t RF0NL:1;                 /* Rx FIFO 0 New Message Interrupt Line */
  } B;
} M_CAN_ILS_tag;

typedef union M_CAN_ILE_union_tag {    /* Interrupt Line Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :30;
    vuint32_t EINT1:1;                 /* Enable Interrupt Line 1 */
    vuint32_t EINT0:1;                 /* Enable Interrupt Line 0 */
  } B;
} M_CAN_ILE_tag;

typedef union M_CAN_GFC_union_tag {    /* Global Filter Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t ANFS:2;                  /* Accept Non-matching Frames Standard */
    vuint32_t ANFE:2;                  /* Accept Non-matching Frames Extended */
    vuint32_t RRFS:1;                  /* Reject Remote Frames Standard */
    vuint32_t RRFE:1;                  /* Reject Remote Frames Extended */
  } B;
} M_CAN_GFC_tag;

typedef union M_CAN_SIDFC_union_tag {  /* Standard ID Filter Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t LSS:8;                   /* List Size Standard */
    vuint32_t FLSSA:14;                /* Filter List Standard Start Address */
    vuint32_t  :2;
  } B;
} M_CAN_SIDFC_tag;

typedef union M_CAN_XIDFC_union_tag {  /* Extended ID Filter Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :9;
    vuint32_t LSE:7;                   /* List Size Extended */
    vuint32_t FLESA:14;                /* Filter List Extended Start Address */
    vuint32_t  :2;
  } B;
} M_CAN_XIDFC_tag;

typedef union M_CAN_XIDAM_union_tag {  /* Extended ID and Mask Register */
  vuint32_t R;
  struct {
    vuint32_t  :3;
    vuint32_t EIDM:29;                 /* Extended ID Mask */
  } B;
} M_CAN_XIDAM_tag;

typedef union M_CAN_HPMS_union_tag {   /* High Priority Message Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t FLST:1;                  /* Filter List */
    vuint32_t FIDX:7;                  /* Filter Index */
    vuint32_t MSI:2;                   /* Message Storage Indicator */
    vuint32_t BIDX:6;                  /* Buffer Index */
  } B;
} M_CAN_HPMS_tag;

typedef union M_CAN_NDAT1_union_tag {  /* New Data 1 Register */
  vuint32_t R;
  struct {
    vuint32_t ND1:32;                  /* New Data[0:31] */
  } B;
} M_CAN_NDAT1_tag;

typedef union M_CAN_NDAT2_union_tag {  /* New Data 2 Register */
  vuint32_t R;
  struct {
    vuint32_t ND2:32;                  /* New Data[32:63] */
  } B;
} M_CAN_NDAT2_tag;

typedef union M_CAN_RXF0C_union_tag {  /* Rx FIFO 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t F0OM:1;                  /* FIFO 0 Operation Mode */
    vuint32_t F0WM:7;                  /* Rx FIFO 0 Watermark */
    vuint32_t  :1;
    vuint32_t F0S:7;                   /* Rx FIFO 0 Size */
    vuint32_t F0SA:14;                 /* Rx FIFO 0 Start Address */
    vuint32_t  :2;
  } B;
} M_CAN_RXF0C_tag;

typedef union M_CAN_RXF0S_union_tag {  /* Rx FIFO 0 Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :6;
    vuint32_t RF0L:1;
    vuint32_t F0F:1;
    vuint32_t  :2;
    vuint32_t F0PI:6;                  /* Rx FIFO 0 Put Index */
    vuint32_t  :2;
    vuint32_t F0GI:6;
    vuint32_t  :1;
    vuint32_t F0FL:7;
  } B;
} M_CAN_RXF0S_tag;

typedef union M_CAN_RXF0A_union_tag {  /* Rx FIFO 0 Acknowledge Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t F0AI:6;                  /* Rx FIFO 0 Acknowledge Index */
  } B;
} M_CAN_RXF0A_tag;

typedef union M_CAN_RXBC_union_tag {   /* Rx Buffer Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t RBSA:14;                 /* Rx Buffer Start Address */
    vuint32_t  :2;
  } B;
} M_CAN_RXBC_tag;

typedef union M_CAN_RXF1C_union_tag {  /* Rx FIFO 1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t F1OM:1;                  /* FIFO 1 Operation Mode */
    vuint32_t F1WM:7;                  /* Rx FIFO 1 Watermark */
    vuint32_t  :1;
    vuint32_t F1S:7;                   /* Rx FIFO 1 Size */
    vuint32_t F1SA:14;                 /* Rx FIFO 1 Start Address */
    vuint32_t  :2;
  } B;
} M_CAN_RXF1C_tag;

typedef union M_CAN_RXF1S_union_tag {  /* Rx FIFO 1 Status Register */
  vuint32_t R;
  struct {
    vuint32_t DMS:2;                   /* Debug Message Status */
    vuint32_t  :4;
    vuint32_t RF1L:1;                  /* Rx FIFO 1 Message Lost */
    vuint32_t F1F:1;                   /* Rx FIFO 1 Full */
    vuint32_t  :2;
    vuint32_t F1PI:6;                  /* Rx FIFO 1 Put Index */
    vuint32_t  :2;
    vuint32_t F1GI:6;                  /* Rx FIFO 1 Get Index */
    vuint32_t  :1;
    vuint32_t F1FL:7;                  /* Rx FIFO 1 Fill Level */
  } B;
} M_CAN_RXF1S_tag;

typedef union M_CAN_RXF1A_union_tag {  /* Rx FIFO 1 Acknowledge Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t F1AI:6;                  /* Rx FIFO 1 Acknowledge Index */
  } B;
} M_CAN_RXF1A_tag;

typedef union M_CAN_RXESC_union_tag {  /* Rx Buffer / FIFO Element Size Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t RBDS:3;                  /* Rx Buffer Data Field Size */
    vuint32_t  :1;
    vuint32_t F1DS:3;                  /* Rx FIFO 1 Data Field Size */
    vuint32_t  :1;
    vuint32_t F0DS:3;                  /* Rx FIFO 0 Data Field Size */
  } B;
} M_CAN_RXESC_tag;

typedef union M_CAN_TXBC_union_tag {   /* Tx Buffer Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t TFQM:1;                  /* Tx FIFO/Queue Mode */
    vuint32_t TFQS:6;                  /* Transmit FIFO/Queue Size */
    vuint32_t  :2;
    vuint32_t NDTB:6;                  /* Number of Dedicated Transmit Buffers */
    vuint32_t TBSA:14;                 /* Tx Buffers Start Address */
    vuint32_t  :2;
  } B;
} M_CAN_TXBC_tag;

typedef union M_CAN_TXFQS_union_tag {  /* Tx FIFO/Queue Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :10;
    vuint32_t TFQF:1;                  /* Tx FIFO/Queue Full */
    vuint32_t TFQPI:5;                 /* Tx FIFO/Queue Put Index */
    vuint32_t  :3;
    vuint32_t TFGI:5;                  /* Tx FIFO Get Index */
    vuint32_t  :2;
    vuint32_t TFFL:6;                  /* Tx FIFO Free Level */
  } B;
} M_CAN_TXFQS_tag;

typedef union M_CAN_TXESC_union_tag {  /* Tx Buffer Element Size Configuration */
  vuint32_t R;
  struct {
    vuint32_t  :29;
    vuint32_t TBDS:3;                  /* Tx Buffer Data Field Size */
  } B;
} M_CAN_TXESC_tag;

typedef union M_CAN_TXBRP_union_tag {  /* Tx Buffer Request Pending Register */
  vuint32_t R;
  struct {
    vuint32_t TRP:32;                  /* Transmission Request Pending */
  } B;
} M_CAN_TXBRP_tag;

typedef union M_CAN_TXBAR_union_tag {  /* Tx Buffer Add Request Register */
  vuint32_t R;
  struct {
    vuint32_t AR:32;                   /* Add Request */
  } B;
} M_CAN_TXBAR_tag;

typedef union M_CAN_TXBCR_union_tag {  /* Tx Buffer Cancellation Request Register */
  vuint32_t R;
  struct {
    vuint32_t CR:32;                   /* Cancellation Request */
  } B;
} M_CAN_TXBCR_tag;

typedef union M_CAN_TXBTO_union_tag {  /* Tx Buffer Transmission Occurred Register */
  vuint32_t R;
  struct {
    vuint32_t TO:32;                   /* Transmission Occurred */
  } B;
} M_CAN_TXBTO_tag;

typedef union M_CAN_TXBCF_union_tag {  /* Tx Buffer Cancellation Finished Register */
  vuint32_t R;
  struct {
    vuint32_t CF:32;                   /* Cancellation Finished */
  } B;
} M_CAN_TXBCF_tag;

typedef union M_CAN_TXBTIE_union_tag { /* Tx Buffer Transmission Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t TIE:32;                  /* Transmission Interrupt Enable */
  } B;
} M_CAN_TXBTIE_tag;

typedef union M_CAN_TXBCIE_union_tag { /* Tx Buffer Cancellation Finished Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t CFIE:32;                 /* Cancellation Finished Interrupt Enable */
  } B;
} M_CAN_TXBCIE_tag;

typedef union M_CAN_TXEFC_union_tag {  /* Tx Event FIFO Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t EFWM:6;                  /* Event FIFO Watermark */
    vuint32_t  :2;
    vuint32_t EFS:6;                   /* Event FIFO Size */
    vuint32_t EFSA:14;                 /* Event FIFO Start Address */
    vuint32_t  :2;
  } B;
} M_CAN_TXEFC_tag;

typedef union M_CAN_TXEFS_union_tag {  /* Tx Event FIFO Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :6;
    vuint32_t TEFL:1;                  /* Tx Event FIFO Element Lost */
    vuint32_t EFF:1;                   /* Event FIFO Full */
    vuint32_t  :3;
    vuint32_t EFPI:5;                  /* Event FIFO Put Index */
    vuint32_t  :3;
    vuint32_t EFGI:5;                  /* Event FIFO Get Index */
    vuint32_t  :2;
    vuint32_t EFFL:6;                  /* Event FIFO Fill Level */
  } B;
} M_CAN_TXEFS_tag;

typedef union M_CAN_TXEFA_union_tag {  /* Tx Event FIFO Acknowledge Register */
  vuint32_t R;
  struct {
    vuint32_t  :27;
    vuint32_t EFAI:5;                  /* Event FIFO Acknowledge Index */
  } B;
} M_CAN_TXEFA_tag;

struct M_CAN_tag {
  M_CAN_CREL_tag CREL;                 /* Core Release Register */
  M_CAN_ENDN_tag ENDN;                 /* Endian Register */
  uint8_t M_CAN_reserved0[4];
  M_CAN_FBTP_tag FBTP;                 /* Fast Bit Timing and Prescaler Register */
  M_CAN_TEST_tag TEST;                 /* Test Register */
  M_CAN_RWD_tag RWD;                   /* RAM Watchdog Register */
  M_CAN_CCCR_tag CCCR;                 /* CC Control Register */
  M_CAN_BTP_tag BTP;                   /* Bit Timing and Prescaler Register */
  M_CAN_TSCC_tag TSCC;                 /* Timestamp Counter Configuration Register */
  M_CAN_TSCV_tag TSCV;                 /* Timestamp Counter Value Register */
  M_CAN_TOCC_tag TOCC;                 /* Timeout Counter Configuration Register */
  M_CAN_TOCV_tag TOCV;                 /* Timeout Counter Value Register */
  uint8_t M_CAN_reserved1[16];
  M_CAN_ECR_tag ECR;                   /* Error Counter Register */
  M_CAN_PSR_tag PSR;                   /* Protocol Status Register */
  uint8_t M_CAN_reserved2[8];
  M_CAN_IR_tag IR;                     /* Interrupt Register */
  M_CAN_IE_tag IE;                     /* Interrupt Enable Register */
  M_CAN_ILS_tag ILS;                   /* Interrupt Line Select Register */
  M_CAN_ILE_tag ILE;                   /* Interrupt Line Enable Register */
  uint8_t M_CAN_reserved3[32];
  M_CAN_GFC_tag GFC;                   /* Global Filter Configuration Register */
  M_CAN_SIDFC_tag SIDFC;               /* Standard ID Filter Configuration Register */
  M_CAN_XIDFC_tag XIDFC;               /* Extended ID Filter Configuration Register */
  uint8_t M_CAN_reserved4[4];
  M_CAN_XIDAM_tag XIDAM;               /* Extended ID and Mask Register */
  M_CAN_HPMS_tag HPMS;                 /* High Priority Message Status Register */
  M_CAN_NDAT1_tag NDAT1;               /* New Data 1 Register */
  M_CAN_NDAT2_tag NDAT2;               /* New Data 2 Register */
  M_CAN_RXF0C_tag RXF0C;               /* Rx FIFO 0 Configuration Register */
  M_CAN_RXF0S_tag RXF0S;               /* Rx FIFO 0 Status Register */
  M_CAN_RXF0A_tag RXF0A;               /* Rx FIFO 0 Acknowledge Register */
  M_CAN_RXBC_tag RXBC;                 /* Rx Buffer Configuration Register */
  M_CAN_RXF1C_tag RXF1C;               /* Rx FIFO 1 Configuration Register */
  M_CAN_RXF1S_tag RXF1S;               /* Rx FIFO 1 Status Register */
  M_CAN_RXF1A_tag RXF1A;               /* Rx FIFO 1 Acknowledge Register */
  M_CAN_RXESC_tag RXESC;               /* Rx Buffer / FIFO Element Size Configuration Register */
  M_CAN_TXBC_tag TXBC;                 /* Tx Buffer Configuration Register */
  M_CAN_TXFQS_tag TXFQS;               /* Tx FIFO/Queue Status Register */
  M_CAN_TXESC_tag TXESC;               /* Tx Buffer Element Size Configuration */
  M_CAN_TXBRP_tag TXBRP;               /* Tx Buffer Request Pending Register */
  M_CAN_TXBAR_tag TXBAR;               /* Tx Buffer Add Request Register */
  M_CAN_TXBCR_tag TXBCR;               /* Tx Buffer Cancellation Request Register */
  M_CAN_TXBTO_tag TXBTO;               /* Tx Buffer Transmission Occurred Register */
  M_CAN_TXBCF_tag TXBCF;               /* Tx Buffer Cancellation Finished Register */
  M_CAN_TXBTIE_tag TXBTIE;             /* Tx Buffer Transmission Interrupt Enable Register */
  M_CAN_TXBCIE_tag TXBCIE;             /* Tx Buffer Cancellation Finished Interrupt Enable Register */
  uint8_t M_CAN_reserved5[8];
  M_CAN_TXEFC_tag TXEFC;               /* Tx Event FIFO Configuration Register */
  M_CAN_TXEFS_tag TXEFS;               /* Tx Event FIFO Status Register */
  M_CAN_TXEFA_tag TXEFA;               /* Tx Event FIFO Acknowledge Register */
};


/* ============================================================================
   =============================== Module: PASS ===============================
   ============================================================================ */

typedef union PASS_LCSTAT_union_tag {  /* Life Cycle Status Register */
  vuint32_t R;
  struct {
    vuint32_t CNS:1;
    vuint32_t JUN:1;
    vuint32_t  :1;
    vuint32_t  :26;
    vuint32_t LIFE:3;
  } B;
} PASS_LCSTAT_tag;

typedef union PASS_CHSEL_union_tag {   /* Challenge Selector Register */
  vuint32_t R;
  struct {
    vuint32_t  :29;
    vuint32_t GRP:3;
  } B;
} PASS_CHSEL_tag;

typedef union PASS_CSTAT_union_tag {   /* Challenge Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :28;
    vuint32_t CMST:4;
  } B;
} PASS_CSTAT_tag;

typedef union PASS_CIN_union_tag {     /* Challenge Input Register */
  vuint32_t R;
  struct {
    vuint32_t PW32:32;
  } B;
} PASS_CIN_tag;

typedef union PASS_PG_LOCK0_union_tag { /* Password Group n - Lock 0 Status Register */
  vuint32_t R;
  struct {
    vuint32_t TSLOCK:1;
    vuint32_t  :1;
    vuint32_t LOWLOCK:14;
    vuint32_t MIDLOCK:16;
  } B;
} PASS_PG_LOCK0_tag;

typedef union PASS_PG_LOCK1_union_tag { /* Password Group n - Lock 1 Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t HIGHLOCK:16;
  } B;
} PASS_PG_LOCK1_tag;

typedef union PASS_PG_LOCK2_union_tag { /* Password Group n - Lock 2 Status Register */
  vuint32_t R;
  struct {
    vuint32_t L_256LCK:32;
  } B;
} PASS_PG_LOCK2_tag;

typedef union PASS_PG_LOCK3_union_tag { /* Password Group n - Lock 3 Status Register */
  vuint32_t R;
  struct {
    vuint32_t PGL:1;
    vuint32_t DBL:1;
    vuint32_t MO:1;
    vuint32_t  :1;
    vuint32_t MSTR:4;
    vuint32_t  :3;
    vuint32_t  :1;
    vuint32_t RL3:1;
    vuint32_t RL2:1;
    vuint32_t RL1:1;
    vuint32_t RL0:1;
    vuint32_t U_256LCK:16;
  } B;
} PASS_PG_LOCK3_tag;

typedef struct PASS_PG_struct_tag {
  PASS_PG_LOCK0_tag LOCK0;             /* Password Group n - Lock 0 Status Register */
  PASS_PG_LOCK1_tag LOCK1;             /* Password Group n - Lock 1 Status Register */
  PASS_PG_LOCK2_tag LOCK2;             /* Password Group n - Lock 2 Status Register */
  PASS_PG_LOCK3_tag LOCK3;             /* Password Group n - Lock 3 Status Register */
} PASS_PG_tag;

struct PASS_tag {
  PASS_LCSTAT_tag LCSTAT;              /* Life Cycle Status Register */
  uint8_t PASS_reserved0[4];
  PASS_CHSEL_tag CHSEL;                /* Challenge Selector Register */
  uint8_t PASS_reserved1[4];
  PASS_CSTAT_tag CSTAT;                /* Challenge Status Register */
  uint8_t PASS_reserved2[12];
  PASS_CIN_tag CIN[8];                 /* Challenge Input Register */
  uint8_t PASS_reserved3[192];
  PASS_PG_tag PG[4];
};


/* ============================================================================
   =============================== Module: PCM ================================
   ============================================================================ */

typedef union PCM_FBOMCR_union_tag {   /* FEC Burst Optimization Master Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t ACCERR:1;                /* Accumulate Error */
    vuint32_t WBEN:1;
    vuint32_t RBEN:1;
    vuint32_t FXSBE:8;                 /* FEC XBAR slave burst enable */
  } B;
} PCM_FBOMCR_tag;

typedef union PCM_IAHB_BE1_union_tag { /* Bus Bridge Configuration Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :5;
    vuint32_t PRE_CORE1_D:1;           /* Pending Read Enable Core1 Data */
    vuint32_t BRE_CORE1_D:1;           /* Burst Read Enable Core1 Data */
    vuint32_t BWE_CORE1_D:1;           /* Burst Write Enable Core1 Data */
    vuint32_t  :5;
    vuint32_t PRE_CORE1_I:1;           /* Pending Read Enable Core1 Instruction */
    vuint32_t BRE_CORE1_I:1;           /* Burst Read Enable Core1 Instruction */
    vuint32_t BWE_CORE1_I:1;           /* Burst Write Enable Core1 Instruction */
    vuint32_t  :5;
    vuint32_t PRE_CORE0_D:1;           /* Pending Read Enable Core0 Data */
    vuint32_t BRE_CORE0_D:1;           /* Burst Read Enable Core0 Data */
    vuint32_t BWE_CORE0_D:1;           /* Burst Write Enable Core0 Data */
    vuint32_t  :5;
    vuint32_t PRE_CORE0_I:1;           /* Pending Read Enable Core0 Instruction */
    vuint32_t BRE_CORE0_I:1;           /* Burst Read Enable Core0 Instruction */
    vuint32_t BWE_CORE0_I:1;           /* Burst Write Enable Core0 Instruction */
  } B;
} PCM_IAHB_BE1_tag;

typedef union PCM_IAHB_BE2_union_tag { /* Bus Bridge Configuration Register 2 */
  vuint32_t R;
  struct {
    vuint32_t  :5;
    vuint32_t PRE_FEC:1;               /* Pending Read Enable FEC */
    vuint32_t BRE_FEC:1;               /* Burst Read Enable FEC */
    vuint32_t BWE_FEC:1;               /* Burst Write Enable FEC */
    vuint32_t  :5;
    vuint32_t PRE_M6:1;                /* Pending Read Enable Master Port 6 Concentrator */
    vuint32_t BRE_M6:1;                /* Burst Read Enable Master Port 6 Concentrator */
    vuint32_t BWE_M6:1;                /* Burst Write Enable Master Port 6 Concentrator */
    vuint32_t  :5;
    vuint32_t PRE_DMA_B:1;             /* Pending Read Enable eDMA_B */
    vuint32_t BRE_DMA_B:1;             /* Burst Read Enable eDMA_B */
    vuint32_t BWE_DMA_B:1;             /* Burst Write Enable eDMA_B */
    vuint32_t  :5;
    vuint32_t PRE_DMA_A:1;             /* Pending Read Enable eDMA_A */
    vuint32_t BRE_DMA_A:1;             /* Burst Read Enable eDMA_A */
    vuint32_t BWE_DMA_A:1;             /* Burst Write Enable eDMA_A */
  } B;
} PCM_IAHB_BE2_tag;

struct PCM_tag {
  PCM_FBOMCR_tag FBOMCR;               /* FEC Burst Optimization Master Control Register */
  PCM_IAHB_BE1_tag IAHB_BE1;           /* Bus Bridge Configuration Register 1 */
  PCM_IAHB_BE2_tag IAHB_BE2;           /* Bus Bridge Configuration Register 2 */
};


/* ============================================================================
   =============================== Module: PCS ================================
   ============================================================================ */

typedef union PCS_SDUR_union_tag {     /* PCS Switch Duration Register */
  vuint32_t R;
  struct {
    vuint32_t SDUR:8;                  /* Switch Duration */
    vuint32_t  :24;
  } B;
} PCS_SDUR_tag;

typedef union PCS_DIVC1_union_tag {    /* PCS Divider Change Register for XOSC */
  vuint32_t R;
  struct {
    vuint32_t INIT:16;                 /* Divider Change Initial Value */
    vuint32_t  :8;
    vuint32_t RATE:8;                  /* Divider Change Rate */
  } B;
} PCS_DIVC1_tag;

typedef union PCS_DIVE1_union_tag {    /* PCS Divider End Register for XOSC */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t DIVE:20;                 /* Divider End Value */
  } B;
} PCS_DIVE1_tag;

typedef union PCS_DIVS1_union_tag {    /* PCS Divider Start Register for XOSC */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t DIVS:20;                 /* Divider Start Value */
  } B;
} PCS_DIVS1_tag;

typedef union PCS_DIVC2_union_tag {    /* PCS Divider Change Register for PLL1 */
  vuint32_t R;
  struct {
    vuint32_t INIT:16;                 /* Divider Change Initial Value */
    vuint32_t  :8;
    vuint32_t RATE:8;                  /* Divider Change Rate */
  } B;
} PCS_DIVC2_tag;

typedef union PCS_DIVE2_union_tag {    /* PCS Divider End Register for PLL1 */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t DIVE:20;                 /* Divider End Value */
  } B;
} PCS_DIVE2_tag;

typedef union PCS_DIVS2_union_tag {    /* PCS Divider Start Register for PLL1 */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t DIVS:20;                 /* Divider Start Value */
  } B;
} PCS_DIVS2_tag;

typedef union PCS_DIVC3_union_tag {    /* PCS Divider Change Register for PLL0 */
  vuint32_t R;
  struct {
    vuint32_t INIT:16;                 /* Divider Change Initial Value */
    vuint32_t  :8;
    vuint32_t RATE:8;                  /* Divider Change Rate */
  } B;
} PCS_DIVC3_tag;

typedef union PCS_DIVE3_union_tag {    /* PCS Divider End Register for PLL0 */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t DIVE:20;                 /* Divider End Value */
  } B;
} PCS_DIVE3_tag;

typedef union PCS_DIVS3_union_tag {    /* PCS Divider Start Register for PLL0 */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t DIVS:20;                 /* Divider Start Value */
  } B;
} PCS_DIVS3_tag;

struct PCS_tag {
  uint8_t PCS_reserved0[1792];
  PCS_SDUR_tag SDUR;                   /* PCS Switch Duration Register */
  PCS_DIVC1_tag DIVC1;                 /* PCS Divider Change Register for XOSC */
  PCS_DIVE1_tag DIVE1;                 /* PCS Divider End Register for XOSC */
  PCS_DIVS1_tag DIVS1;                 /* PCS Divider Start Register for XOSC */
  PCS_DIVC2_tag DIVC2;                 /* PCS Divider Change Register for PLL1 */
  PCS_DIVE2_tag DIVE2;                 /* PCS Divider End Register for PLL1 */
  PCS_DIVS2_tag DIVS2;                 /* PCS Divider Start Register for PLL1 */
  PCS_DIVC3_tag DIVC3;                 /* PCS Divider Change Register for PLL0 */
  PCS_DIVE3_tag DIVE3;                 /* PCS Divider End Register for PLL0 */
  PCS_DIVS3_tag DIVS3;                 /* PCS Divider Start Register for PLL0 */
};


/* ============================================================================
   =============================== Module: PCU ================================
   ============================================================================ */

typedef union PCU_CESR_union_tag {     /* PCU Configuration and Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t CP1ERR:2;                /* Core Processor 1 Error */
    vuint32_t CP0ERR:2;                /* Core Processor 0 Error */
    vuint32_t SRST_FLAG:1;             /* Software Reset Flag */
    vuint32_t  :1;
    vuint32_t CP1IDLE:1;               /* Core Processor 1 Idle */
    vuint32_t CP0IDLE:1;               /* Core Processor 0 Idle */
    vuint32_t  :2;
    vuint32_t CP1IEN:1;                /* Core Processor 1 Interrupt Enable */
    vuint32_t CP0IEN:1;                /* Core Processor 0 Interrupt Enable */
    vuint32_t  :4;
    vuint32_t M3WMEN:1;                /* Master 3 Write Monitor Enable */
    vuint32_t M2WMEN:1;                /* Master 2 Write Monitor Enable */
    vuint32_t M1WMEN:1;                /* Master 1 Write Monitor Enable */
    vuint32_t M0WMEN:1;                /* Master 0 Write Monitor Enable */
    vuint32_t  :2;
    vuint32_t CP1DS:3;                 /* Core1 Disable Snoop */
    vuint32_t CP0DS:3;                 /* Core0 Disable Snoop */
    vuint32_t  :2;
    vuint32_t SRST_EN:1;               /* Software Reset Enable */
    vuint32_t ENB:1;                   /* PCU Enable */
  } B;
} PCU_CESR_tag;

typedef union PCU_ERROR_EAR_union_tag { /* PCU Error Address Register, Core n */
  vuint32_t R;
  struct {
    vuint32_t EADDR:32;                /* Error Address */
  } B;
} PCU_ERROR_EAR_tag;

typedef union PCU_ERROR_EDR_union_tag { /* PCU Error Detail Register, Core n */
  vuint32_t R;
  struct {
    vuint32_t EMSTR:4;                 /* Error Master */
    vuint32_t EPTR:4;                  /* Error Pointer */
    vuint32_t ESTAMP:8;                /* Error Time Stamp */
    vuint32_t  :2;
    vuint32_t EPROT:6;                 /* Error Protection Attribute */
    vuint32_t ERESP:5;                 /* Error Snoop Response */
    vuint32_t  :3;
  } B;
} PCU_ERROR_EDR_tag;

typedef struct PCU_ERROR_struct_tag {
  PCU_ERROR_EAR_tag EAR;               /* PCU Error Address Register, Core n */
  PCU_ERROR_EDR_tag EDR;               /* PCU Error Detail Register, Core n */
  uint8_t ERROR_reserved0[8];
} PCU_ERROR_tag;

typedef union PCU_IR_union_tag {       /* PCU Interrupt Register, Core n */
  vuint32_t R;
  struct {
    vuint32_t  :30;
    vuint32_t OIF:1;                   /* Overflow Interrupt Flag */
    vuint32_t EIF:1;                   /* Error Interrupt Flag */
  } B;
} PCU_IR_tag;

struct PCU_tag {
  PCU_CESR_tag CESR;                   /* PCU Configuration and Error Status Register */
  uint8_t PCU_reserved0[12];
  PCU_ERROR_tag ERROR[2];
  PCU_IR_tag IR[2];                    /* PCU Interrupt Register, Core n */
};


/* ============================================================================
   =============================== Module: PFLASH =============================
   ============================================================================ */

typedef union PFLASH_PFCR1_union_tag { /* Platform Flash Configuration Register 1 */
  vuint32_t R;
  struct {
    vuint32_t P0_M15PFE:1;
    vuint32_t P0_M14PFE:1;
    vuint32_t P0_M13PFE:1;
    vuint32_t P0_M12PFE:1;
    vuint32_t P0_M11PFE:1;
    vuint32_t P0_M10PFE:1;
    vuint32_t P0_M9PFE:1;
    vuint32_t P0_M8PFE:1;
    vuint32_t P0_M7PFE:1;
    vuint32_t P0_M6PFE:1;
    vuint32_t P0_M5PFE:1;
    vuint32_t P0_M4PFE:1;
    vuint32_t P0_M3PFE:1;
    vuint32_t P0_M2PFE:1;
    vuint32_t P0_M1PFE:1;
    vuint32_t P0_M0PFE:1;
    vuint32_t APC:3;
    vuint32_t  :1;
    vuint32_t RWSC:4;
    vuint32_t  :1;
    vuint32_t P0_DPFEN:1;
    vuint32_t  :1;
    vuint32_t P0_IPFEN:1;
    vuint32_t  :1;
    vuint32_t P0_PFLIM:2;
    vuint32_t P0_BFEN:1;
  } B;
} PFLASH_PFCR1_tag;

typedef union PFLASH_PFCR2_union_tag { /* Platform Flash Configuration Register 2 */
  vuint32_t R;
  struct {
    vuint32_t P1_M15PFE:1;
    vuint32_t P1_M14PFE:1;
    vuint32_t P1_M13PFE:1;
    vuint32_t P1_M12PFE:1;
    vuint32_t P1_M11PFE:1;
    vuint32_t P1_M10PFE:1;
    vuint32_t P1_M9PFE:1;
    vuint32_t P1_M8PFE:1;
    vuint32_t P1_M7PFE:1;
    vuint32_t P1_M6PFE:1;
    vuint32_t P1_M5PFE:1;
    vuint32_t P1_M4PFE:1;
    vuint32_t P1_M3PFE:1;
    vuint32_t P1_M2PFE:1;
    vuint32_t P1_M1PFE:1;
    vuint32_t P1_M0PFE:1;
    vuint32_t  :9;
    vuint32_t P1_DPFEN:1;
    vuint32_t  :1;
    vuint32_t P1_IPFEN:1;
    vuint32_t  :1;
    vuint32_t P1_PFLIM:2;
    vuint32_t P1_BFEN:1;
  } B;
} PFLASH_PFCR2_tag;

typedef union PFLASH_PFCR3_union_tag { /* Platform Flash Configuration Register 3 */
  vuint32_t R;
  struct {
    vuint32_t P0_WCFG:2;
    vuint32_t P1_WCFG:2;
    vuint32_t  :2;
    vuint32_t  :5;
    vuint32_t  :1;
    vuint32_t  :3;
    vuint32_t BFEN_LK:1;
    vuint32_t ARBM:2;
    vuint32_t  :2;
    vuint32_t  :11;
    vuint32_t DERR_SUP:1;
  } B;
} PFLASH_PFCR3_tag;

typedef union PFLASH_PFAPR_union_tag { /* Platform Flash Access Protection Register */
  vuint32_t R;
  struct {
    vuint32_t M0AP:2;
    vuint32_t M1AP:2;
    vuint32_t M2AP:2;
    vuint32_t M3AP:2;
    vuint32_t M4AP:2;
    vuint32_t M5AP:2;
    vuint32_t M6AP:2;
    vuint32_t M7AP:2;
    vuint32_t M8AP:2;
    vuint32_t M9AP:2;
    vuint32_t M10AP:2;
    vuint32_t M11AP:2;
    vuint32_t M12AP:2;
    vuint32_t M13AP:2;
    vuint32_t M14AP:2;
    vuint32_t M15AP:2;
  } B;
} PFLASH_PFAPR_tag;

struct PFLASH_tag {
  PFLASH_PFCR1_tag PFCR1;              /* Platform Flash Configuration Register 1 */
  PFLASH_PFCR2_tag PFCR2;              /* Platform Flash Configuration Register 2 */
  PFLASH_PFCR3_tag PFCR3;              /* Platform Flash Configuration Register 3 */
  PFLASH_PFAPR_tag PFAPR;              /* Platform Flash Access Protection Register */
};


/* ============================================================================
   =============================== Module: PIT ================================
   ============================================================================ */

typedef union PIT_MCR_union_tag {      /* PIT Module Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :29;
    vuint32_t MDIS_RTI:1;              /* Module Disable - RTI section */
    vuint32_t MDIS:1;                  /* Module Disable - (PIT section) */
    vuint32_t FRZ:1;                   /* Freeze */
  } B;
} PIT_MCR_tag;

typedef union PIT_LTMR64H_union_tag {  /* PIT Upper Lifetime Timer Register */
  vuint32_t R;
  struct {
    vuint32_t LTH:32;                  /* Life Timer value */
  } B;
} PIT_LTMR64H_tag;

typedef union PIT_LTMR64L_union_tag {  /* PIT Lower Lifetime Timer Register */
  vuint32_t R;
  struct {
    vuint32_t LTL:32;                  /* Life Timer value */
  } B;
} PIT_LTMR64L_tag;

typedef union PIT_RTI_LDVAL_union_tag { /* Timer Load Value Register */
  vuint32_t R;
  struct {
    vuint32_t TSV:32;                  /* Timer Start Value */
  } B;
} PIT_RTI_LDVAL_tag;

typedef union PIT_RTI_CVAL_union_tag { /* Current Timer Value Register */
  vuint32_t R;
  struct {
    vuint32_t TVL:32;                  /* Current Timer Value */
  } B;
} PIT_RTI_CVAL_tag;

typedef union PIT_RTI_TCTRL_union_tag { /* Timer Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :30;
    vuint32_t TIE:1;                   /* Timer Interrupt Enable */
    vuint32_t TEN:1;                   /* Timer Enable Bit */
  } B;
} PIT_RTI_TCTRL_tag;

typedef union PIT_RTI_TFLG_union_tag { /* Timer Flag Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t TIF:1;                   /* Timer Interrupt Flag. */
  } B;
} PIT_RTI_TFLG_tag;

typedef union PIT_TIMER_LDVAL_union_tag { /* Timer Load Value Register */
  vuint32_t R;
  struct {
    vuint32_t TSV:32;                  /* Timer Start Value */
  } B;
} PIT_TIMER_LDVAL_tag;

typedef union PIT_TIMER_CVAL_union_tag { /* Current Timer Value Register */
  vuint32_t R;
  struct {
    vuint32_t TVL:32;                  /* Current Timer Value */
  } B;
} PIT_TIMER_CVAL_tag;

typedef union PIT_TIMER_TCTRL_union_tag { /* Timer Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :29;
    vuint32_t CHN:1;                   /* Chain Mode */
    vuint32_t TIE:1;                   /* Timer Interrupt Enable */
    vuint32_t TEN:1;                   /* Timer Enable */
  } B;
} PIT_TIMER_TCTRL_tag;

typedef union PIT_TIMER_TFLG_union_tag { /* Timer Flag Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t TIF:1;                   /* Timer Interrupt Flag */
  } B;
} PIT_TIMER_TFLG_tag;

typedef struct PIT_TIMER_struct_tag {
  PIT_TIMER_LDVAL_tag LDVAL;           /* Timer Load Value Register */
  PIT_TIMER_CVAL_tag CVAL;             /* Current Timer Value Register */
  PIT_TIMER_TCTRL_tag TCTRL;           /* Timer Control Register */
  PIT_TIMER_TFLG_tag TFLG;             /* Timer Flag Register */
} PIT_TIMER_tag;

struct PIT_tag {
  PIT_MCR_tag MCR;                     /* PIT Module Control Register */
  uint8_t PIT_reserved0[220];
  PIT_LTMR64H_tag LTMR64H;             /* PIT Upper Lifetime Timer Register */
  PIT_LTMR64L_tag LTMR64L;             /* PIT Lower Lifetime Timer Register */
  uint8_t PIT_reserved1[8];
  PIT_RTI_LDVAL_tag RTI_LDVAL;         /* Timer Load Value Register */
  PIT_RTI_CVAL_tag RTI_CVAL;           /* Current Timer Value Register */
  PIT_RTI_TCTRL_tag RTI_TCTRL;         /* Timer Control Register */
  PIT_RTI_TFLG_tag RTI_TFLG;           /* Timer Flag Register */
  PIT_TIMER_tag TIMER[4];
};


/* ============================================================================
   =============================== Module: PLLDIG =============================
   ============================================================================ */

typedef union PLLDIG_PLL0CR_union_tag { /* PLLDIG PLL0 Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t CLKCFG:2;                /* Clock Configuration */
    vuint32_t  :4;
    vuint32_t LOLIE:1;                 /* Loss-of-lock interrupt enable */
    vuint32_t  :3;
  } B;
} PLLDIG_PLL0CR_tag;

typedef union PLLDIG_PLL0SR_union_tag { /* PLLDIG PLL0 Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :28;
    vuint32_t LOLF:1;                  /* Loss-of-lock flag */
    vuint32_t LOCK:1;                  /* Lock status bit */
    vuint32_t  :2;
  } B;
} PLLDIG_PLL0SR_tag;

typedef union PLLDIG_PLL0DV_union_tag { /* PLLDIG PLL0 Divider Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t RFDPHI1:4;               /* PHI1 reduced frequency divider */
    vuint32_t  :5;
    vuint32_t RFDPHI:6;                /* PHI reduced frequency divider */
    vuint32_t  :1;
    vuint32_t PREDIV:3;                /* Input clock predivider */
    vuint32_t  :5;
    vuint32_t MFD:7;                   /* Loop multiplication factor divider */
  } B;
} PLLDIG_PLL0DV_tag;

typedef union PLLDIG_PLL1CR_union_tag { /* PLLDIG PLL1 Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t CLKCFG:2;                /* Clock Configuration */
    vuint32_t  :4;
    vuint32_t LOLIE:1;                 /* Loss-of-lock interrupt enable */
    vuint32_t  :3;
  } B;
} PLLDIG_PLL1CR_tag;

typedef union PLLDIG_PLL1SR_union_tag { /* PLLDIG PLL1 Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :28;
    vuint32_t LOLF:1;                  /* Loss-of-lock flag */
    vuint32_t LOCK:1;                  /* Lock status bit */
    vuint32_t  :2;
  } B;
} PLLDIG_PLL1SR_tag;

typedef union PLLDIG_PLL1DV_union_tag { /* PLLDIG PLL1 Divider Register */
  vuint32_t R;
  struct {
    vuint32_t  :10;
    vuint32_t RFDPHI:6;                /* PHI reduced frequency divider */
    vuint32_t  :9;
    vuint32_t MFD:7;                   /* Loop multiplication factor divider */
  } B;
} PLLDIG_PLL1DV_tag;

typedef union PLLDIG_PLL1FM_union_tag { /* PLLDIG PLL1 Frequency Modulation Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MODEN:1;                 /* Modulation enable */
    vuint32_t MODSEL:1;                /* Modulation selection */
    vuint32_t MODPRD:13;               /* Modulation period */
    vuint32_t  :1;
    vuint32_t INCSTP:15;               /* Increment step */
  } B;
} PLLDIG_PLL1FM_tag;

typedef union PLLDIG_PLL1FD_union_tag { /* PLLDIG PLL1 Fractional Divide Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t FDEN:1;                  /* Fractional Divide Enable */
    vuint32_t  :12;
    vuint32_t DTHDIS1:1;               /* Rectangular Dither Disable */
    vuint32_t DTHDIS0:1;               /* Triangular Dither Disable */
    vuint32_t  :4;
    vuint32_t FRCDIV:12;               /* Fractional divide input */
  } B;
} PLLDIG_PLL1FD_tag;

struct PLLDIG_tag {
  PLLDIG_PLL0CR_tag PLL0CR;            /* PLLDIG PLL0 Control Register */
  PLLDIG_PLL0SR_tag PLL0SR;            /* PLLDIG PLL0 Status Register */
  PLLDIG_PLL0DV_tag PLL0DV;            /* PLLDIG PLL0 Divider Register */
  uint8_t PLLDIG_reserved0[20];
  PLLDIG_PLL1CR_tag PLL1CR;            /* PLLDIG PLL1 Control Register */
  PLLDIG_PLL1SR_tag PLL1SR;            /* PLLDIG PLL1 Status Register */
  PLLDIG_PLL1DV_tag PLL1DV;            /* PLLDIG PLL1 Divider Register */
  PLLDIG_PLL1FM_tag PLL1FM;            /* PLLDIG PLL1 Frequency Modulation Register */
  PLLDIG_PLL1FD_tag PLL1FD;            /* PLLDIG PLL1 Fractional Divide Register */
};


/* ============================================================================
   =============================== Module: PMC ================================
   ============================================================================ */

typedef union PMC_TS_IER_union_tag {   /* Temperature Sensor Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t TS_EN:1;                 /* Temperature Sensor interrupts Enable */
    vuint32_t  :25;                    /* Reserved */
    vuint32_t  :1;                     /* Reserved */
    vuint32_t TS1_2IE:1;               /* Temperature Sensor 1 input 2 Interrupt Enable */
    vuint32_t TS1_0IE:1;               /* Temperature Sensor 1 input 0 Interrupt Enable */
    vuint32_t  :1;                     /* Reserved */
    vuint32_t TS0_2IE:1;               /* Temperature Sensor 0 input 2 Interrupt Enable */
    vuint32_t TS0_0IE:1;               /* Temperature Sensor 0 input 0 Interrupt Enable */
  } B;
} PMC_TS_IER_tag;

typedef union PMC_ESR_TD_union_tag {   /* Temperature Event Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;                    /* Reserved */
    vuint32_t  :1;                     /* Reserved */
    vuint32_t TEMP1_2:1;
    vuint32_t TEMP1_0:1;
    vuint32_t  :1;                     /* Reserved */
    vuint32_t TEMP0_2:1;
    vuint32_t TEMP0_0:1;
  } B;
} PMC_ESR_TD_tag;

typedef union PMC_REE_TD_union_tag {   /* Temperature Reset Event Enable register */
  vuint32_t R;
  struct {
    vuint32_t  :26;                    /* Reserved */
    vuint32_t  :1;                     /* Reserved */
    vuint32_t TEMP1_2:1;               /* Temperature sensor 1 detect assertion reset enable 2 */
    vuint32_t TEMP1_0:1;               /* Temperature sensor 1 detect assertion reset enable 0 */
    vuint32_t  :1;                     /* Reserved */
    vuint32_t TEMP0_2:1;               /* Temperature sensor 0 detect assertion reset enable 2 */
    vuint32_t TEMP0_0:1;               /* Temperature sensor 0 detect assertion reset enable 0 */
  } B;
} PMC_REE_TD_tag;

typedef union PMC_RES_TD_union_tag {   /* Temperature Reset Event Selection Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;                    /* Reserved */
    vuint32_t  :1;                     /* Reserved */
    vuint32_t TEMP1_2:1;               /* TEMP1_2 Reset Event Select */
    vuint32_t TEMP1_0:1;               /* TEMP1_0 Reset Event Select */
    vuint32_t  :1;                     /* Reserved */
    vuint32_t TEMP0_2:1;               /* TEMP0_2 Reset Event Select */
    vuint32_t TEMP0_0:1;               /* TEMP0_0 Reset Event Select */
  } B;
} PMC_RES_TD_tag;

typedef union PMC_CTL_TD_union_tag {   /* Temperature Detector Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :17;
    vuint32_t  :5;
    vuint32_t  :1;
    vuint32_t TS1_EN:1;
    vuint32_t  :1;
    vuint32_t  :5;
    vuint32_t  :1;
    vuint32_t TS0_EN:1;
  } B;
} PMC_CTL_TD_tag;

typedef union PMC_TS_FIR_union_tag {   /* Temperature Sensor Fault Injection Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;                    /* Reserved */
    vuint32_t TSNS_FAULT:1;            /* Temperature Sensor Fault injection. */
  } B;
} PMC_TS_FIR_tag;

typedef union PMC_SELF_TEST_UM_VD_REG_union_tag { /* Voltage Detect User Mode Test Register */
  vuint32_t R;
  struct {
    vuint32_t  :14;                    /* Reserved */
    vuint32_t ST_RESULT:1;
    vuint32_t ST_DONE:1;
    vuint32_t  :8;                     /* Reserved */
    vuint32_t ST_MODE:2;               /* Self Test Mode bits for testing LVDs and HVDs */
    vuint32_t VD_ST_CTRL:6;
  } B;
} PMC_SELF_TEST_UM_VD_REG_tag;

typedef union PMC_FIR_union_tag {      /* FCCU Fault Injection Register */
  vuint32_t R;
  struct {
    vuint32_t  :28;                    /* Reserved */
    vuint32_t STEST_FAULT:1;
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t HVD_FAULT:1;             /* High Voltage Detect Fault injection. */
    vuint32_t LVD_FAULT:1;             /* Low Voltage Detect Fault injection. */
  } B;
} PMC_FIR_tag;

typedef union PMC_LVD_HVD_INTR_ENB_union_tag { /* LVD/HVD Interrupt Enable Control Register */
  vuint32_t R;
  struct {
    vuint32_t PMC_ENABLE:1;            /* PMC Enable Control */
    vuint32_t  :23;                    /* Reserved */
    vuint32_t  :2;                     /* Reserved */
    vuint32_t HVD_FLASH:1;             /* HVD Flash Enable/Disable */
    vuint32_t  :1;                     /* Reserved */
    vuint32_t HVD_HV:1;                /* HVD_HV Enable/Disable */
    vuint32_t HVD_CORE:1;              /* HVD_CORE Enable/Disable */
    vuint32_t  :1;                     /* Reserved */
    vuint32_t LVD_CORE_COLD:1;         /* LVD Core Cold Enable/Disable */
  } B;
} PMC_LVD_HVD_INTR_ENB_tag;

typedef union PMC_LVD_HVD_EVENT_STATUS_union_tag { /* LVD/HVD Event Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t  :1;                     /* Reserved */
    vuint32_t  :1;                     /* Reserved */
    vuint32_t HVD_FLASH:1;
    vuint32_t  :1;                     /* Reserved */
    vuint32_t HVD_HV:1;                /* HVD_HV Status Flag */
    vuint32_t HVD_CORE:1;              /* HVD Core Status Flag */
    vuint32_t  :1;                     /* Reserved */
    vuint32_t LVD_CORE_COLD:1;         /* LVD Core Cold Status Flag */
  } B;
} PMC_LVD_HVD_EVENT_STATUS_tag;

typedef union PMC_ADC_CS_union_tag {   /* ADC Channel Select Register */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t STND_BY_RAM_BO_CLR:1;    /* Standby RAM Brownout Clear */
    vuint32_t STND_BY_RAM_BR_DETCT:1;  /* Standby RAM Brownout Detect */
    vuint32_t  :2;
    vuint32_t ADC_CS:6;
  } B;
} PMC_ADC_CS_tag;

typedef union PMC_REE_union_tag {      /* Reset Event Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t  :2;                     /* Reserved */
    vuint32_t HVD_FLASH:1;             /* Reset Enable/Disable Control */
    vuint32_t  :1;                     /* Reserved */
    vuint32_t HVD_HV:1;                /* Reset Enable/Disable Control */
    vuint32_t HVD_CORE:1;              /* Reset Enable/Disable Control */
    vuint32_t  :1;                     /* Reserved */
    vuint32_t LVD_CORE_COLD:1;         /* Reset Enable/Disable Control */
  } B;
} PMC_REE_tag;

struct PMC_tag {
  uint8_t PMC_reserved0[136];
  PMC_TS_IER_tag TS_IER;               /* Temperature Sensor Interrupt Enable Register */
  PMC_ESR_TD_tag ESR_TD;               /* Temperature Event Status Register */
  PMC_REE_TD_tag REE_TD;               /* Temperature Reset Event Enable register */
  PMC_RES_TD_tag RES_TD;               /* Temperature Reset Event Selection Register */
  PMC_CTL_TD_tag CTL_TD;               /* Temperature Detector Configuration Register */
  uint8_t PMC_reserved1[8];
  PMC_TS_FIR_tag TS_FIR;               /* Temperature Sensor Fault Injection Register */
  uint8_t PMC_reserved2[12];
  PMC_SELF_TEST_UM_VD_REG_tag SELF_TEST_UM_VD_REG; /* Voltage Detect User Mode Test Register */
  PMC_FIR_tag FIR;                     /* FCCU Fault Injection Register */
  PMC_LVD_HVD_INTR_ENB_tag LVD_HVD_INTR_ENB; /* LVD/HVD Interrupt Enable Control Register */
  PMC_LVD_HVD_EVENT_STATUS_tag LVD_HVD_EVENT_STATUS; /* LVD/HVD Event Status Register */
  PMC_ADC_CS_tag ADC_CS;               /* ADC Channel Select Register */
  uint8_t PMC_reserved3[8];
  PMC_REE_tag REE;                     /* Reset Event Enable Register */
};


/* ============================================================================
   =============================== Module: PRAMC ==============================
   ============================================================================ */

typedef union PRAMC_PRCR1_union_tag {  /* Platform RAM Configuration Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t  :2;
    vuint32_t  :1;
    vuint32_t P0_BO_DIS:1;             /* Port p0 read burst optimization disable. */
    vuint32_t  :5;
    vuint32_t FT_DIS:1;                /* Flow through disabled. */
  } B;
} PRAMC_PRCR1_tag;

struct PRAMC_tag {
  PRAMC_PRCR1_tag PRCR1;               /* Platform RAM Configuration Register 1 */
};


/* ============================================================================
   =============================== Module: PSI5 ===============================
   ============================================================================ */

typedef union PSI5_GCR_union_tag {     /* Global Control Register */
  vuint16_t R;
  struct {
    vuint16_t  :14;
    vuint16_t CTC_GED:1;
    vuint16_t GLOBAL_DISABLE_REQ:1;
  } B;
} PSI5_GCR_tag;

typedef union PSI5_CH0_PCCR_union_tag { /* PSI5 Channel Control Register */
  vuint32_t R;
  struct {
    vuint32_t CTC_GED_SEL:1;
    vuint32_t CTC_ED:1;
    vuint32_t  :1;
    vuint32_t MEM_DEPTH:5;
    vuint32_t  :3;
    vuint32_t ERROR_SELECT4:1;
    vuint32_t ERROR_SELECT3:1;
    vuint32_t ERROR_SELECT2:1;
    vuint32_t ERROR_SELECT1:1;
    vuint32_t ERROR_SELECT0:1;
    vuint32_t  :1;
    vuint32_t GTM_RESET_ASYNC_EN:1;
    vuint32_t  :3;
    vuint32_t DEBUG_EN:1;
    vuint32_t DEBUG_FREEZE_CTRL:1;
    vuint32_t SP_TS_CLK_SEL:1;
    vuint32_t  :2;
    vuint32_t FAST_CLR_SMC:1;
    vuint32_t FAST_CLR_PSI5:1;
    vuint32_t BIT_RATE:1;              /* Bit Rate */
    vuint32_t MODE:1;
    vuint32_t PSI5_CH_CONFIG:1;
    vuint32_t PSI5_CH_EN:1;
  } B;
} PSI5_CH0_PCCR_tag;

typedef union PSI5_CH0_DCR_union_tag { /* DMA Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t  :2;
    vuint32_t DMA_PM_DS_WM:5;
    vuint32_t  :5;
    vuint32_t IE_DMA_TF_SF:1;
    vuint32_t IE_DMA_TF_PM_DS:1;
    vuint32_t  :5;
    vuint32_t IE_DMA_PM_DS_FIFO_FULL:1;
    vuint32_t IE_DMA_SFUF:1;
    vuint32_t  :1;
    vuint32_t IE_DMA_PM_DS_UF:1;
    vuint32_t  :5;
    vuint32_t DMA_EN_SF:1;
    vuint32_t DMA_PM_DS_CONFIG:2;
  } B;
} PSI5_CH0_DCR_tag;

typedef union PSI5_CH0_DSR_union_tag { /* DMA Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :13;
    vuint32_t IS_DMA_TF_SF:1;
    vuint32_t IS_DMA_TF_PM_DS:1;
    vuint32_t  :5;
    vuint32_t IS_DMA_PM_DS_FIFO_FULL:1;
    vuint32_t IS_DMA_SFUF:1;
    vuint32_t  :1;
    vuint32_t IS_DMA_PM_DS_UF:1;
    vuint32_t  :8;
  } B;
} PSI5_CH0_DSR_tag;

typedef union PSI5_CH0_GICR_union_tag { /* General Interrupt Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t  :6;
    vuint32_t IE_STS:1;
    vuint32_t IE_DTS:1;
    vuint32_t IE_DSROW:1;
    vuint32_t IE_BROW:1;
    vuint32_t IE_PROW:1;
    vuint32_t IE_DSRR:1;
    vuint32_t IE_BRR:1;
    vuint32_t IE_PRR:1;
    vuint32_t  :2;
    vuint32_t  :6;
    vuint32_t  :2;
    vuint32_t  :6;
  } B;
} PSI5_CH0_GICR_tag;

typedef union PSI5_CH0_NDICR_union_tag { /* New Data Interrupt Control Register */
  vuint32_t R;
  struct {
    vuint32_t IE_ND:32;
  } B;
} PSI5_CH0_NDICR_tag;

typedef union PSI5_CH0_OWICR_union_tag { /* Overwrite Interrupt Control Register */
  vuint32_t R;
  struct {
    vuint32_t IE_OW:32;
  } B;
} PSI5_CH0_OWICR_tag;

typedef union PSI5_CH0_EICR_union_tag { /* Error Interrupt Control Register */
  vuint32_t R;
  struct {
    vuint32_t IE_ERROR:32;
  } B;
} PSI5_CH0_EICR_tag;

typedef union PSI5_CH0_GISR_union_tag { /* General Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t IS_DB_FR:1;
    vuint32_t  :1;
    vuint32_t IS_CESM:6;
    vuint32_t IS_STS:1;
    vuint32_t IS_DTS:1;
    vuint32_t IS_DSROW:1;
    vuint32_t IS_BROW:1;
    vuint32_t IS_PROW:1;
    vuint32_t DSR_RDY:1;
    vuint32_t DBR_RDY:1;
    vuint32_t DPR_RDY:1;
    vuint32_t  :2;
    vuint32_t IS_OWSM:6;
    vuint32_t  :2;
    vuint32_t IS_NVSM:6;
  } B;
} PSI5_CH0_GISR_tag;

typedef union PSI5_CH0_DPMR_union_tag { /* DMA PSI5 Message Register */
  vuint32_t R;
  struct {
    vuint32_t PSI5_RXDATA:32;
  } B;
} PSI5_CH0_DPMR_tag;

typedef union PSI5_CH0_DSFR_union_tag { /* DMA SMC Frame Register */
  vuint32_t R;
  struct {
    vuint32_t SMC_RXDATA:32;
  } B;
} PSI5_CH0_DSFR_tag;

typedef union PSI5_CH0_DDSR_union_tag { /* DMA Diagnostic Status Register */
  vuint32_t R;
  struct {
    vuint32_t DDS:32;
  } B;
} PSI5_CH0_DDSR_tag;

typedef union PSI5_CH0_PMRRL_union_tag { /* PSI5 Message Receive Register Low */
  vuint32_t R;
  struct {
    vuint32_t DATA_REGION:28;
    vuint32_t CRC:3;
    vuint32_t C:1;
  } B;
} PSI5_CH0_PMRRL_tag;

typedef union PSI5_CH0_PMRRH_union_tag { /* PSI5 Message Receive Register High */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t F:1;
    vuint32_t EM:1;
    vuint32_t E:1;
    vuint32_t T:1;
    vuint32_t SlotCounter:3;
    vuint32_t TimeStampValue:24;
  } B;
} PSI5_CH0_PMRRH_tag;

typedef union PSI5_CH0_PMRL_union_tag { /* PSI5 Message Register Low i */
  vuint32_t R;
  struct {
    vuint32_t DATA_REGION:28;
    vuint32_t CRCP:3;
    vuint32_t C:1;
  } B;
} PSI5_CH0_PMRL_tag;

typedef union PSI5_CH0_PMRH_union_tag { /* PSI5 Message Register High i */
  vuint32_t R;
  struct {
    vuint32_t O:1;
    vuint32_t F:1;
    vuint32_t EM:1;
    vuint32_t E:1;
    vuint32_t T:1;
    vuint32_t Slot_Counter:3;
    vuint32_t TimeStampValue:24;
  } B;
} PSI5_CH0_PMRH_tag;

typedef struct PSI5_CH0_struct_tag {
  PSI5_CH0_PMRL_tag PMRL;              /* PSI5 Message Register Low i */
  PSI5_CH0_PMRH_tag PMRH;              /* PSI5 Message Register High i */
} PSI5_CH0_tag;

typedef union PSI5_CH0_SFR_union_tag { /* SMC Frame Register n */
  vuint32_t R;
  struct {
    vuint32_t SLOT_NO:3;
    vuint32_t CER:1;
    vuint32_t OW:1;
    vuint32_t CRC:6;
    vuint32_t C:1;
    vuint32_t ID:4;
    vuint32_t IDDATA:4;
    vuint32_t DATA:12;
  } B;
} PSI5_CH0_SFR_tag;

typedef union PSI5_CH0_NDSR_union_tag { /* New Data Status Register */
  vuint32_t R;
  struct {
    vuint32_t NDS:32;
  } B;
} PSI5_CH0_NDSR_tag;

typedef union PSI5_CH0_OWSR_union_tag { /* Overwrite Status Register */
  vuint32_t R;
  struct {
    vuint32_t OWS:32;
  } B;
} PSI5_CH0_OWSR_tag;

typedef union PSI5_CH0_EISR_union_tag { /* Error Indication Status Register */
  vuint32_t R;
  struct {
    vuint32_t ERROR:32;
  } B;
} PSI5_CH0_EISR_tag;

typedef union PSI5_CH0_SNDSR_union_tag { /* Set New Data Status Register */
  vuint32_t R;
  struct {
    vuint32_t SNDS:32;
  } B;
} PSI5_CH0_SNDSR_tag;

typedef union PSI5_CH0_SOWSR_union_tag { /* Set Overwrite Status Register */
  vuint32_t R;
  struct {
    vuint32_t SOWS:32;
  } B;
} PSI5_CH0_SOWSR_tag;

typedef union PSI5_CH0_SEISR_union_tag { /* Set Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t SERROR:32;
  } B;
} PSI5_CH0_SEISR_tag;

typedef union PSI5_CH0_SSESR_union_tag { /* Set SMC Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t SCESM:6;
    vuint32_t  :10;
    vuint32_t SOWSM:6;
    vuint32_t  :2;
    vuint32_t SNVSM:6;
  } B;
} PSI5_CH0_SSESR_tag;

typedef union PSI5_CH0_STSRR_union_tag { /* Sync Time Stamp Read Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t STSV:24;
  } B;
} PSI5_CH0_STSRR_tag;

typedef union PSI5_CH0_DTSRR_union_tag { /* Data Time Stamp Read Register */
  vuint32_t R;
  struct {
    vuint32_t  :5;
    vuint32_t SLOT_COUNTER:3;
    vuint32_t DTSV:24;
  } B;
} PSI5_CH0_DTSRR_tag;

typedef union PSI5_CH0_SFCR_union_tag { /* Slot n Frame Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :13;
    vuint32_t SLOT_EN:1;
    vuint32_t TS_CAPT:1;
    vuint32_t  :1;
    vuint32_t SMCL:1;
    vuint32_t  :9;
    vuint32_t DRL:5;
    vuint32_t CRCP:1;
  } B;
} PSI5_CH0_SFCR_tag;

typedef union PSI5_CH0_S1SBR_union_tag { /* Slot 1 Start Boundary Register */
  vuint16_t R;
  struct {
    vuint16_t  :1;
    vuint16_t S1SBT:15;
  } B;
} PSI5_CH0_S1SBR_tag;

typedef union PSI5_CH0_S2SBR_union_tag { /* Slot 2 Start Boundary Register */
  vuint16_t R;
  struct {
    vuint16_t  :1;
    vuint16_t S2SBT:15;
  } B;
} PSI5_CH0_S2SBR_tag;

typedef union PSI5_CH0_S3SBR_union_tag { /* Slot 3 Start Boundary Register */
  vuint16_t R;
  struct {
    vuint16_t  :1;
    vuint16_t S3SBT:15;
  } B;
} PSI5_CH0_S3SBR_tag;

typedef union PSI5_CH0_S4SBR_union_tag { /* Slot 4 Start Boundary Register */
  vuint16_t R;
  struct {
    vuint16_t  :1;
    vuint16_t S4SBT:15;
  } B;
} PSI5_CH0_S4SBR_tag;

typedef union PSI5_CH0_S5SBR_union_tag { /* Slot 5 Start Boundary Register */
  vuint16_t R;
  struct {
    vuint16_t  :1;
    vuint16_t S5SBT:15;
  } B;
} PSI5_CH0_S5SBR_tag;

typedef union PSI5_CH0_S6SBR_union_tag { /* Slot 6 Start Boundary Register */
  vuint16_t R;
  struct {
    vuint16_t  :1;
    vuint16_t S6SBT:15;
  } B;
} PSI5_CH0_S6SBR_tag;

typedef union PSI5_CH0_SnEBR_union_tag { /* Slot n End Boundary Register */
  vuint32_t R;
  struct {
    vuint32_t  :13;
    vuint32_t SLOT_NO:3;
    vuint32_t  :1;
    vuint32_t SnEBT:15;
  } B;
} PSI5_CH0_SnEBR_tag;

typedef union PSI5_CH0_DOBCR_union_tag { /* Data Output Block Configuration Register */
  vuint16_t R;
  struct {
    vuint16_t DATA_LENGTH:6;
    vuint16_t DBR_RST:1;
    vuint16_t DSR_RST:1;
    vuint16_t CMD_TYPE:3;
    vuint16_t DEFAULT_SYNC:1;
    vuint16_t GTM_TRIG_SEL:1;
    vuint16_t SP_PULSE_SEL:1;
    vuint16_t OP_SEL:1;
    vuint16_t SW_READY:1;
  } B;
} PSI5_CH0_DOBCR_tag;

typedef union PSI5_CH0_MDDIS_OFF_union_tag { /* Manchestor Decoder Disable Offset */
  vuint16_t R;
  struct {
    vuint16_t  :9;
    vuint16_t MDDIS_OFF:7;
  } B;
} PSI5_CH0_MDDIS_OFF_tag;

typedef union PSI5_CH0_PW0D_union_tag { /* Pulse Width for Data Bit Value 0 */
  vuint16_t R;
  struct {
    vuint16_t  :9;
    vuint16_t Pulse_Width0:7;
  } B;
} PSI5_CH0_PW0D_tag;

typedef union PSI5_CH0_PW1D_union_tag { /* Pulse Width for Data Bit Value 1 */
  vuint16_t R;
  struct {
    vuint16_t  :9;
    vuint16_t Pulse_Width1:7;
  } B;
} PSI5_CH0_PW1D_tag;

typedef union PSI5_CH0_CTPR_union_tag { /* Counter Target Pulse Register */
  vuint16_t R;
  struct {
    vuint16_t CTPR:16;
  } B;
} PSI5_CH0_CTPR_tag;

typedef union PSI5_CH0_CIPR_union_tag { /* Counter Initialize Pulse Register */
  vuint16_t R;
  struct {
    vuint16_t CIPR:16;
  } B;
} PSI5_CH0_CIPR_tag;

typedef union PSI5_CH0_DPRL_union_tag { /* Data Preparation Register Low */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t DPR:24;
  } B;
} PSI5_CH0_DPRL_tag;

typedef union PSI5_CH0_DPRH_union_tag { /* Data Preparation Register High */
  vuint32_t R;
  struct {
    vuint32_t  :32;
  } B;
} PSI5_CH0_DPRH_tag;

typedef union PSI5_CH0_DBRL_union_tag { /* Data Buffer Register Low */
  vuint32_t R;
  struct {
    vuint32_t DBR:32;
  } B;
} PSI5_CH0_DBRL_tag;

typedef union PSI5_CH0_DBRH_union_tag { /* Data Buffer Register High */
  vuint32_t R;
  struct {
    vuint32_t DBR:32;
  } B;
} PSI5_CH0_DBRH_tag;

typedef union PSI5_CH0_DSRL_union_tag { /* Data Shift Register Low */
  vuint32_t R;
  struct {
    vuint32_t DSR:32;
  } B;
} PSI5_CH0_DSRL_tag;

typedef union PSI5_CH0_DSRH_union_tag { /* Data Shift Register High */
  vuint32_t R;
  struct {
    vuint32_t DSR:32;
  } B;
} PSI5_CH0_DSRH_tag;

struct PSI5_tag {
  PSI5_GCR_tag GCR;                    /* Global Control Register */
  uint8_t PSI5_reserved0[6];
  PSI5_CH0_PCCR_tag CH0_PCCR;          /* PSI5 Channel Control Register */
  PSI5_CH0_DCR_tag CH0_DCR;            /* DMA Control Register */
  PSI5_CH0_DSR_tag CH0_DSR;            /* DMA Status Register */
  PSI5_CH0_GICR_tag CH0_GICR;          /* General Interrupt Control Register */
  PSI5_CH0_NDICR_tag CH0_NDICR;        /* New Data Interrupt Control Register */
  PSI5_CH0_OWICR_tag CH0_OWICR;        /* Overwrite Interrupt Control Register */
  PSI5_CH0_EICR_tag CH0_EICR;          /* Error Interrupt Control Register */
  PSI5_CH0_GISR_tag CH0_GISR;          /* General Interrupt Status Register */
  PSI5_CH0_DPMR_tag CH0_DPMR;          /* DMA PSI5 Message Register */
  PSI5_CH0_DSFR_tag CH0_DSFR;          /* DMA SMC Frame Register */
  PSI5_CH0_DDSR_tag CH0_DDSR;          /* DMA Diagnostic Status Register */
  PSI5_CH0_PMRRL_tag CH0_PMRRL;        /* PSI5 Message Receive Register Low */
  PSI5_CH0_PMRRH_tag CH0_PMRRH;        /* PSI5 Message Receive Register High */
  PSI5_CH0_tag CH0[32];
  PSI5_CH0_SFR_tag CH0_SFR[6];         /* SMC Frame Register n */
  PSI5_CH0_NDSR_tag CH0_NDSR;          /* New Data Status Register */
  PSI5_CH0_OWSR_tag CH0_OWSR;          /* Overwrite Status Register */
  PSI5_CH0_EISR_tag CH0_EISR;          /* Error Indication Status Register */
  PSI5_CH0_SNDSR_tag CH0_SNDSR;        /* Set New Data Status Register */
  PSI5_CH0_SOWSR_tag CH0_SOWSR;        /* Set Overwrite Status Register */
  PSI5_CH0_SEISR_tag CH0_SEISR;        /* Set Error Status Register */
  PSI5_CH0_SSESR_tag CH0_SSESR;        /* Set SMC Error Status Register */
  PSI5_CH0_STSRR_tag CH0_STSRR;        /* Sync Time Stamp Read Register */
  PSI5_CH0_DTSRR_tag CH0_DTSRR;        /* Data Time Stamp Read Register */
  PSI5_CH0_SFCR_tag CH0_SFCR[6];       /* Slot n Frame Configuration Register */
  PSI5_CH0_S1SBR_tag CH0_S1SBR;        /* Slot 1 Start Boundary Register */
  PSI5_CH0_S2SBR_tag CH0_S2SBR;        /* Slot 2 Start Boundary Register */
  PSI5_CH0_S3SBR_tag CH0_S3SBR;        /* Slot 3 Start Boundary Register */
  PSI5_CH0_S4SBR_tag CH0_S4SBR;        /* Slot 4 Start Boundary Register */
  PSI5_CH0_S5SBR_tag CH0_S5SBR;        /* Slot 5 Start Boundary Register */
  PSI5_CH0_S6SBR_tag CH0_S6SBR;        /* Slot 6 Start Boundary Register */
  PSI5_CH0_SnEBR_tag CH0_SnEBR;        /* Slot n End Boundary Register */
  PSI5_CH0_DOBCR_tag CH0_DOBCR;        /* Data Output Block Configuration Register */
  PSI5_CH0_MDDIS_OFF_tag CH0_MDDIS_OFF; /* Manchestor Decoder Disable Offset */
  PSI5_CH0_PW0D_tag CH0_PW0D;          /* Pulse Width for Data Bit Value 0 */
  PSI5_CH0_PW1D_tag CH0_PW1D;          /* Pulse Width for Data Bit Value 1 */
  PSI5_CH0_CTPR_tag CH0_CTPR;          /* Counter Target Pulse Register */
  PSI5_CH0_CIPR_tag CH0_CIPR;          /* Counter Initialize Pulse Register */
  PSI5_CH0_DPRL_tag CH0_DPRL;          /* Data Preparation Register Low */
  PSI5_CH0_DPRH_tag CH0_DPRH;          /* Data Preparation Register High */
  PSI5_CH0_DBRL_tag CH0_DBRL;          /* Data Buffer Register Low */
  PSI5_CH0_DBRH_tag CH0_DBRH;          /* Data Buffer Register High */
  PSI5_CH0_DSRL_tag CH0_DSRL;          /* Data Shift Register Low */
  PSI5_CH0_DSRH_tag CH0_DSRH;          /* Data Shift Register High */
};


/* ============================================================================
   =============================== Module: REACM2 =============================
   ============================================================================ */

typedef union REACM2_MCR_union_tag {   /* Module Configuration */
  vuint32_t R;
  struct {
    vuint32_t OVRC:1;                  /* Overrun Detection Flag Clear */
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze Control */
    vuint32_t  :1;
    vuint32_t FREN:1;                  /* Freeze Enable */
    vuint32_t TPREN:1;                 /* Timer Prescaler Enable */
    vuint32_t HPREN:1;                 /* Hold Timer Prescaler Enable */
    vuint32_t GIEN:1;                  /* Global Interrupt Enable */
    vuint32_t OVREN:1;                 /* Overrun Detection Interrupt Enable */
    vuint32_t  :23;
  } B;
} REACM2_MCR_tag;

typedef union REACM2_TCR_union_tag {   /* Timer Configuration */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t HPRE:12;                 /* Hold Timer Prescaler */
    vuint32_t  :8;
    vuint32_t TPRE:8;                  /* Timer Prescaler */
  } B;
} REACM2_TCR_tag;

typedef union REACM2_THRR_union_tag {  /* Threshold Router Register */
  vuint32_t R;
  struct {
    vuint32_t  :6;
    vuint32_t WREN1:1;                 /* Write Enable Bit for THRADC1 */
    vuint32_t WREN0:1;                 /* Write Enable Bit for THRADC0 */
    vuint32_t  :12;
    vuint32_t THRADC1:4;               /* ADC result Router value for Threshold Bank address one */
    vuint32_t  :4;
    vuint32_t THRADC0:4;               /* ADC result Router for Threshold Bank address zero */
  } B;
} REACM2_THRR_tag;

typedef union REACM2_SINR_union_tag {  /* ADC Sensor Input Register */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t ADC_TAG:4;               /* TAG value */
    vuint32_t ADC_RESULT:16;           /* ADC conversion result value */
  } B;
} REACM2_SINR_tag;

typedef union REACM2_PCR_union_tag {   /* Period Generator Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t PERPRESC:8;              /* Period prescaler rate value */
    vuint32_t PER:16;                  /* Period time value */
  } B;
} REACM2_PCR_tag;

typedef union REACM2_PSCR_union_tag {  /* Period Shift Delay Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t DLY:16;                  /* Delay value between two consecutive channel period pulses */
  } B;
} REACM2_PSCR_tag;

typedef union REACM2_GEFR_union_tag {  /* Global Error Flag Register */
  vuint32_t R;
  struct {
    vuint32_t OVR:1;                   /* Overrun Detection Flag */
    vuint32_t  :21;
    vuint32_t EF9:1;                   /* Error Flag */
    vuint32_t EF8:1;                   /* Error Flag */
    vuint32_t EF7:1;                   /* Error Flag */
    vuint32_t EF6:1;                   /* Error Flag */
    vuint32_t EF5:1;                   /* Error Flag */
    vuint32_t EF4:1;                   /* Error Flag */
    vuint32_t EF3:1;                   /* Error Flag */
    vuint32_t EF2:1;                   /* Error Flag */
    vuint32_t EF1:1;                   /* Error Flag */
    vuint32_t EF0:1;                   /* Error Flag */
  } B;
} REACM2_GEFR_tag;

typedef union REACM2_CH_CR_union_tag { /* Channel n Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t CHEN:2;                  /* Channel Enable Bits */
    vuint32_t SWMC:1;                  /* Software Modulation Control bit */
    vuint32_t MAXLEN:1;                /* ADC result Maximum Limit Interrupt Enable bit */
    vuint32_t OCDFEN:1;                /* OCDF Interrupt Enable bit */
    vuint32_t SCDFEN:1;                /* SCDF Interrupt Enable bit */
    vuint32_t TAEREN:1;                /* TAER Interrupt Enable bit */
    vuint32_t SQEREN:1;                /* Modulation Word Sequence Error Interrupt Enable */
    vuint32_t RAEREN:1;                /* Resource Allocation Error Interrupt Enable */
    vuint32_t  :1;
    vuint32_t CHOFF:1;                 /* Output Disable bit */
    vuint32_t SDCM:1;                  /* Short Detection Counting Mode */
    vuint32_t  :1;
    vuint32_t DOFF:3;                  /* Drive Off Control field */
    vuint32_t  :5;
    vuint32_t BSB:3;                   /* Bank Support Bits */
    vuint32_t  :3;
    vuint32_t MODULATION_ADDR:5;       /* Address for Modulation Control Bank */
  } B;
} REACM2_CH_CR_tag;

typedef union REACM2_CH_SR_union_tag { /* Channel n Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t MODACT:1;                /* Modulation Active Flag */
    vuint32_t MAXL:1;                  /* ADC Maximum Limit Detection Flag */
    vuint32_t OCDF:1;                  /* Open Circuit Detection Flag */
    vuint32_t SCDF:1;                  /* Short Circuit Detection Flag */
    vuint32_t TAER:1;                  /* Timer Allocation Error */
    vuint32_t SQER:1;                  /* Modulation Word Sequence Error Flag */
    vuint32_t RAER:1;                  /* Resource Allocation Error Flag */
    vuint32_t CHOUT:3;                 /* Channel Output Monitoring bits */
    vuint32_t  :7;
    vuint32_t MAXLC:1;                 /* ADC Maximum Limit Flag Clear */
    vuint32_t OCDFC:1;                 /* Open Circuit Detection Flag Clear */
    vuint32_t SCDFC:1;                 /* Short Circuit Detection Flag clear */
    vuint32_t TAERC:1;                 /* TAER Clear bit */
    vuint32_t SQERC:1;                 /* Modulation Word Sequence Error Flag clear */
    vuint32_t RAERC:1;                 /* Resource Allocation Error Flag clear */
    vuint32_t  :1;
    vuint32_t MODULATION_POINTER:6;    /* Modulation bank address generated by the channel */
  } B;
} REACM2_CH_SR_tag;

typedef union REACM2_CH_RR_union_tag { /* Channel n Router Register */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t ADCR:4;                  /* ADC result router field */
    vuint32_t  :12;
    vuint32_t CHIR:4;                  /* Channel Input router field */
  } B;
} REACM2_CH_RR_tag;

typedef struct REACM2_CH_struct_tag {
  REACM2_CH_CR_tag CR;                 /* Channel n Configuration Register */
  REACM2_CH_SR_tag SR;                 /* Channel n Status Register */
  REACM2_CH_RR_tag RR;                 /* Channel n Router Register */
  uint8_t CH_reserved0[4];
} REACM2_CH_tag;

typedef union REACM2_STBK_union_tag {  /* Shared Timer Bank */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t SHARED_TIMER:16;         /* Timer Value */
  } B;
} REACM2_STBK_tag;

typedef union REACM2_HOTBK_union_tag { /* Hold Timer Bank */
  vuint32_t R;
  struct {
    vuint32_t  :20;
    vuint32_t HOLD_TIM:12;             /* Hold Timer Value */
  } B;
} REACM2_HOTBK_tag;

typedef union REACM2_THBK_union_tag {  /* Threshold Bank */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t THRESHOLD_VALUE:16;      /* Threshold Value */
  } B;
} REACM2_THBK_tag;

typedef union REACM2_ADCMAX_union_tag { /* ADC Result Maximum Limit Check */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t ADC_MAX_LIMIT:16;        /* Maximum Limit allowed for the ADC result */
  } B;
} REACM2_ADCMAX_tag;

typedef union REACM2_RANGE_PWD_union_tag { /* Modulation Range Pulse Width */
  vuint32_t R;
  struct {
    vuint32_t  :20;
    vuint32_t RANGE_PWD:12;            /* Range Pulse Width */
  } B;
} REACM2_RANGE_PWD_tag;

typedef union REACM2_MIN_PWD_union_tag { /* Modulation Minimum Pulse Width */
  vuint32_t R;
  struct {
    vuint32_t  :20;
    vuint32_t MIN_PWD:12;              /* Minimum Pulse Width */
  } B;
} REACM2_MIN_PWD_tag;

typedef union REACM2_MWBK_union_tag {  /* Modulation Control Word Bank */
  vuint32_t R;
  struct {
    vuint32_t LOOP:1;                  /* Loop Control Bit */
    vuint32_t IOSS:1;                  /* Initial Output State Selection */
    vuint32_t  :1;
    vuint32_t MM:2;                    /* Modulation Mode */
    vuint32_t  :1;
    vuint32_t SM:2;                    /* Sequencer Mode */
    vuint32_t  :1;
    vuint32_t HOD:3;                   /* High Output Drive */
    vuint32_t  :1;
    vuint32_t LOD:3;                   /* Low Output Drive */
    vuint32_t  :2;
    vuint32_t THRESPT:5;               /* Threshold Pointer */
    vuint32_t  :1;
    vuint32_t STPT:3;                  /* Shared Timer Pointer */
    vuint32_t  :2;
    vuint32_t HDOFFTPT:3;              /* Hold on/off Pointer */
  } B;
} REACM2_MWBK_tag;

struct REACM2_tag {
  REACM2_MCR_tag MCR;                  /* Module Configuration */
  REACM2_TCR_tag TCR;                  /* Timer Configuration */
  REACM2_THRR_tag THRR;                /* Threshold Router Register */
  uint8_t REACM2_reserved0[4];
  REACM2_SINR_tag SINR;                /* ADC Sensor Input Register */
  REACM2_PCR_tag PCR;                  /* Period Generator Configuration Register */
  REACM2_PSCR_tag PSCR;                /* Period Shift Delay Configuration Register */
  uint8_t REACM2_reserved1[4];
  REACM2_GEFR_tag GEFR;                /* Global Error Flag Register */
  uint8_t REACM2_reserved2[220];
  REACM2_CH_tag CH[10];
  uint8_t REACM2_reserved3[352];
  REACM2_STBK_tag STBK[5];             /* Shared Timer Bank */
  uint8_t REACM2_reserved4[108];
  REACM2_HOTBK_tag HOTBK[5];           /* Hold Timer Bank */
  uint8_t REACM2_reserved5[108];
  REACM2_THBK_tag THBK[32];            /* Threshold Bank */
  uint8_t REACM2_reserved6[384];
  REACM2_ADCMAX_tag ADCMAX;            /* ADC Result Maximum Limit Check */
  uint8_t REACM2_reserved7[124];
  REACM2_RANGE_PWD_tag RANGE_PWD;      /* Modulation Range Pulse Width */
  uint8_t REACM2_reserved8[60];
  REACM2_MIN_PWD_tag MIN_PWD;          /* Modulation Minimum Pulse Width */
  uint8_t REACM2_reserved9[60];
  REACM2_MWBK_tag MWBK[32];            /* Modulation Control Word Bank */
};


/* ============================================================================
   =============================== Module: SDADC ==============================
   ============================================================================ */

typedef union SDADC_MCR_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :3;
    vuint32_t PDR:5;
    vuint32_t  :1;
    vuint32_t PGAN:3;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t HPFEN:1;
    vuint32_t WDGEN:1;
    vuint32_t TRIGEDSEL:2;
    vuint32_t TRIGEN:1;
    vuint32_t TRIGSEL:4;
    vuint32_t FRZ:1;
    vuint32_t  :2;
    vuint32_t VCOMSEL:1;
    vuint32_t WRMODE:1;
    vuint32_t GECEN:1;                 /* Accurate Gain Error Mode Enable */
    vuint32_t MODE:1;
    vuint32_t EN:1;
  } B;
} SDADC_MCR_tag;

typedef union SDADC_CSR_union_tag {    /* Channel Selection Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t BIASEN:8;
    vuint32_t  :5;
    vuint32_t ANCHSEL_WRAP:3;
    vuint32_t  :5;
    vuint32_t ANCHSEL:3;
  } B;
} SDADC_CSR_tag;

typedef union SDADC_RKR_union_tag {    /* Reset Key Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t RESET_KEY:16;
  } B;
} SDADC_RKR_tag;

typedef union SDADC_SFR_union_tag {    /* Status Flag Register */
  vuint32_t R;
  struct {
    vuint32_t  :13;
    vuint32_t ANCHSEL_CNT:3;
    vuint32_t  :7;
    vuint32_t DFEF:1;
    vuint32_t  :3;
    vuint32_t WTHH:1;
    vuint32_t WTHL:1;
    vuint32_t CDVF:1;
    vuint32_t DFORF:1;
    vuint32_t DFFF:1;
  } B;
} SDADC_SFR_tag;

typedef union SDADC_RSER_union_tag {   /* Request Select and Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :14;
    vuint32_t WTHDIRS:1;
    vuint32_t DFFDIRS:1;
    vuint32_t GDIGE:1;
    vuint32_t  :11;
    vuint32_t WTHDIRE:1;
    vuint32_t CDVEE:1;
    vuint32_t DFORIE:1;
    vuint32_t DFFDIRE:1;
  } B;
} SDADC_RSER_tag;

typedef union SDADC_OSDR_union_tag {   /* Output Settling Delay Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t OSD:8;
  } B;
} SDADC_OSDR_tag;

typedef union SDADC_FCR_union_tag {    /* FIFO Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :15;
    vuint32_t FRST:1;
    vuint32_t  :4;
    vuint32_t FTHLD:4;
    vuint32_t  :4;
    vuint32_t FOWEN:1;
    vuint32_t FSIZE:2;
    vuint32_t FE:1;
  } B;
} SDADC_FCR_tag;

typedef union SDADC_STKR_union_tag {   /* Software Trigger Key Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t ST_KEY:16;
  } B;
} SDADC_STKR_tag;

typedef union SDADC_CDR_union_tag {    /* Converted Data Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t CDATA:16;
  } B;
} SDADC_CDR_tag;

typedef union SDADC_WTHHLR_union_tag { /* WDG Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t THRH:16;
    vuint32_t THRL:16;
  } B;
} SDADC_WTHHLR_tag;

struct SDADC_tag {
  SDADC_MCR_tag MCR;                   /* Module Configuration Register */
  SDADC_CSR_tag CSR;                   /* Channel Selection Register */
  SDADC_RKR_tag RKR;                   /* Reset Key Register */
  SDADC_SFR_tag SFR;                   /* Status Flag Register */
  SDADC_RSER_tag RSER;                 /* Request Select and Enable Register */
  SDADC_OSDR_tag OSDR;                 /* Output Settling Delay Register */
  SDADC_FCR_tag FCR;                   /* FIFO Control Register */
  SDADC_STKR_tag STKR;                 /* Software Trigger Key Register */
  SDADC_CDR_tag CDR;                   /* Converted Data Register */
  SDADC_WTHHLR_tag WTHHLR;             /* WDG Threshold Register */
};


/* ============================================================================
   =============================== Module: SEMA4 ==============================
   ============================================================================ */

typedef union SEMA4_Gate_union_tag {   /* Semaphores Gate 0 Register */
  vuint8_t R;
  struct {
    vuint8_t  :6;
    vuint8_t GTFSM:2;                  /* Gate Finite State Machine. */
  } B;
} SEMA4_Gate_tag;

typedef union SEMA4_CPINE_CPINE_union_tag { /* Semaphores Processor n IRQ Notification Enable */
  vuint16_t R;
  struct {
    vuint16_t INE0:1;
    vuint16_t INE1:1;
    vuint16_t INE2:1;
    vuint16_t INE3:1;
    vuint16_t INE4:1;                  /* Interrupt Request Notification Enable 4. This field is a bitmap to enable the generation of an interrupt notification from a failed attempt to lock gate 4. */
    vuint16_t INE5:1;                  /* Interrupt Request Notification Enable 5. This field is a bitmap to enable the generation of an interrupt notification from a failed attempt to lock gate 5. */
    vuint16_t INE6:1;                  /* Interrupt Request Notification Enable 6. This field is a bitmap to enable the generation of an interrupt notification from a failed attempt to lock gate 6. */
    vuint16_t INE7:1;                  /* Interrupt Request Notification Enable 7. This field is a bitmap to enable the generation of an interrupt notification from a failed attempt to lock gate 7. */
    vuint16_t INE8:1;                  /* Interrupt Request Notification Enable 8. This field is a bitmap to enable the generation of an interrupt notification from a failed attempt to lock gate 8. */
    vuint16_t INE9:1;                  /* Interrupt Request Notification Enable 9. This field is a bitmap to enable the generation of an interrupt notification from a failed attempt to lock gate 9. */
    vuint16_t INE10:1;                 /* Interrupt Request Notification Enable 10. This field is a bitmap to enable the generation of an interrupt notification from a failed attempt to lock gate 10. */
    vuint16_t INE11:1;                 /* Interrupt Request Notification Enable 11. This field is a bitmap to enable the generation of an interrupt notification from a failed attempt to lock gate 11. */
    vuint16_t INE12:1;                 /* Interrupt Request Notification Enable 12. This field is a bitmap to enable the generation of an interrupt notification from a failed attempt to lock gate 12. */
    vuint16_t INE13:1;                 /* Interrupt Request Notification Enable 13. This field is a bitmap to enable the generation of an interrupt notification from a failed attempt to lock gate 13. */
    vuint16_t INE14:1;                 /* Interrupt Request Notification Enable 14. This field is a bitmap to enable the generation of an interrupt notification from a failed attempt to lock gate 14. */
    vuint16_t INE15:1;                 /* Interrupt Request Notification Enable 15. This field is a bitmap to enable the generation of an interrupt notification from a failed attempt to lock gate 15. */
  } B;
} SEMA4_CPINE_CPINE_tag;

typedef struct SEMA4_CPINE_struct_tag {
  SEMA4_CPINE_CPINE_tag CPINE;         /* Semaphores Processor n IRQ Notification Enable */
  uint8_t CPINE_reserved0[6];
} SEMA4_CPINE_tag;

typedef union SEMA4_CPNTF_CPNTF_union_tag { /* Semaphores Processor n IRQ Notification */
  vuint16_t R;
  struct {
    vuint16_t GNn:16;
  } B;
} SEMA4_CPNTF_CPNTF_tag;

typedef struct SEMA4_CPNTF_struct_tag {
  SEMA4_CPNTF_CPNTF_tag CPNTF;         /* Semaphores Processor n IRQ Notification */
  uint8_t CPNTF_reserved0[6];
} SEMA4_CPNTF_tag;

typedef union SEMA4_RSTGT_union_tag {  /* Semaphores (Secure) Reset Gate n */
  vuint16_t R;
  struct {
    vuint16_t RSTGSM_RSTGMS_RSTGDP:8;
    vuint16_t RSTGTN:8;
  } B;
} SEMA4_RSTGT_tag;

typedef union SEMA4_RSTNTF_union_tag { /* Semaphores (Secure) Reset IRQ Notification */
  vuint16_t R;
  struct {
    vuint16_t RSTNSM_RSTNMS_RSTNDP:8;
    vuint16_t RSTNTN:8;
  } B;
} SEMA4_RSTNTF_tag;

struct SEMA4_tag {
  SEMA4_Gate_tag Gate[16];             /* Semaphores Gate 0 Register */
  uint8_t SEMA4_reserved0[48];
  SEMA4_CPINE_tag CPINE[2];
  uint8_t SEMA4_reserved1[48];
  SEMA4_CPNTF_tag CPNTF[2];
  uint8_t SEMA4_reserved2[112];
  SEMA4_RSTGT_tag RSTGT;               /* Semaphores (Secure) Reset Gate n */
  uint8_t SEMA4_reserved3[2];
  SEMA4_RSTNTF_tag RSTNTF;             /* Semaphores (Secure) Reset IRQ Notification */
};


/* ============================================================================
   =============================== Module: SIPI ===============================
   ============================================================================ */

typedef union SIPI_CCR0_union_tag {    /* SIPI Channel Control Register 0 */
  vuint32_t R;
  struct {
    vuint32_t  :15;
    vuint32_t TC:1;                    /* Send Trigger Command. */
    vuint32_t  :8;
    vuint32_t WL:2;                    /* Word Length Transfer. */
    vuint32_t CHEN:1;                  /* Channel Enable. */
    vuint32_t ST:1;                    /* Streaming Transfer. */
    vuint32_t IDT:1;                   /* ID Read Request Transfer. */
    vuint32_t RRT:1;                   /* Read Request Transfer. */
    vuint32_t WRT:1;                   /* Write Request Transfer. */
    vuint32_t DEN:1;                   /* DMA Enable. */
  } B;
} SIPI_CCR0_tag;

typedef union SIPI_CSR0_union_tag {    /* SIPI Channel Status Register 0 */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t RAR:1;
    vuint32_t TID:3;                   /* Transaction ID of transmitted frame. */
    vuint32_t ACKR:1;
    vuint32_t CB:1;                    /* Channel Busy. */
    vuint32_t  :2;
  } B;
} SIPI_CSR0_tag;

typedef union SIPI_CIR0_union_tag {    /* SIPI Channel Interrupt Register 0 */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WAIE:1;                  /* Write Acknowledge Interrupt Enable. */
    vuint32_t RAIE:1;                  /* Read Answer Interrupt Enable. */
    vuint32_t TCIE:1;                  /* Trigger Command Interrupt Enable. */
    vuint32_t TOIE:1;                  /* Timeout Error Interrupt Enabled. */
    vuint32_t TIDIE:1;                 /* Transaction ID Error Interrupt Enable. */
    vuint32_t ACKIE:1;                 /* Acknowledge Error Interrupt Enable. */
  } B;
} SIPI_CIR0_tag;

typedef union SIPI_CTOR0_union_tag {   /* SIPI Channel Timeout Register 0 */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t TOR:8;                   /* Timeout value for transmitted requests. */
  } B;
} SIPI_CTOR0_tag;

typedef union SIPI_CCRC0_union_tag {   /* SIPI Channel CRC Register 0 */
  vuint32_t R;
  struct {
    vuint32_t CRCI:16;
    vuint32_t CRCT:16;
  } B;
} SIPI_CCRC0_tag;

typedef union SIPI_CAR0_union_tag {    /* SIPI Channel Address Register 0 */
  vuint32_t R;
  struct {
    vuint32_t CAR:32;
  } B;
} SIPI_CAR0_tag;

typedef union SIPI_CDR0_union_tag {    /* SIPI Channel Data Register 0 */
  vuint32_t R;
  struct {
    vuint32_t CDR:32;
  } B;
} SIPI_CDR0_tag;

typedef union SIPI_CCR1_union_tag {    /* SIPI Channel Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :15;
    vuint32_t TC:1;                    /* Send Trigger Command. */
    vuint32_t  :8;
    vuint32_t WL:2;                    /* Word Length Transfer. */
    vuint32_t CHEN:1;                  /* Channel Enable. */
    vuint32_t ST:1;
    vuint32_t IDT:1;                   /* ID Read Request Transfer. */
    vuint32_t RRT:1;
    vuint32_t WRT:1;                   /* Write Request Transfer. */
    vuint32_t DEN:1;                   /* DMA Enable. */
  } B;
} SIPI_CCR1_tag;

typedef union SIPI_CSR1_union_tag {    /* SIPI Channel Status Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t RAR:1;
    vuint32_t TID:3;
    vuint32_t ACKR:1;
    vuint32_t CB:1;                    /* Channel Busy. */
    vuint32_t  :2;
  } B;
} SIPI_CSR1_tag;

typedef union SIPI_CIR1_union_tag {    /* SIPI Channel Interrupt Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WAIE:1;
    vuint32_t RAIE:1;
    vuint32_t TCIE:1;
    vuint32_t TOIE:1;
    vuint32_t TIDIE:1;
    vuint32_t ACKIE:1;
  } B;
} SIPI_CIR1_tag;

typedef union SIPI_CTOR1_union_tag {   /* SIPI Channel Timeout Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t TOR:8;                   /* Timeout value for transmitted requests. */
  } B;
} SIPI_CTOR1_tag;

typedef union SIPI_CCRC1_union_tag {   /* SIPI Channel CRC Register 1 */
  vuint32_t R;
  struct {
    vuint32_t CRCI:16;
    vuint32_t CRCT:16;
  } B;
} SIPI_CCRC1_tag;

typedef union SIPI_CAR1_union_tag {    /* SIPI Channel Address Register 1 */
  vuint32_t R;
  struct {
    vuint32_t CAR:32;
  } B;
} SIPI_CAR1_tag;

typedef union SIPI_CDR1_union_tag {    /* SIPI Channel Data Register 1 */
  vuint32_t R;
  struct {
    vuint32_t CDR:32;
  } B;
} SIPI_CDR1_tag;

typedef union SIPI_CCR2_union_tag {    /* SIPI Channel Control Register 2 */
  vuint32_t R;
  struct {
    vuint32_t  :15;
    vuint32_t TC:1;                    /* Send Trigger Command. */
    vuint32_t  :8;
    vuint32_t WL:2;                    /* Word Length Transfer. */
    vuint32_t CHEN:1;                  /* Channel Enable. */
    vuint32_t ST:1;
    vuint32_t IDT:1;                   /* ID Read Request Transfer. */
    vuint32_t RRT:1;                   /* Read Request Transfer. */
    vuint32_t WRT:1;                   /* Write Request Transfer. */
    vuint32_t DEN:1;                   /* DMA Enable. */
  } B;
} SIPI_CCR2_tag;

typedef union SIPI_CSR2_union_tag {    /* SIPI Channel Status Register 2 */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t RAR:1;
    vuint32_t TID:3;                   /* Transaction ID of transmitted frame. */
    vuint32_t ACKR:1;
    vuint32_t CB:1;                    /* Channel Busy. */
    vuint32_t  :2;
  } B;
} SIPI_CSR2_tag;

typedef union SIPI_CIR2_union_tag {    /* SIPI Channel Interrupt Register 2 */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WAIE:1;
    vuint32_t RAIE:1;
    vuint32_t TCIE:1;
    vuint32_t TOIE:1;
    vuint32_t TIDIE:1;
    vuint32_t ACKIE:1;
  } B;
} SIPI_CIR2_tag;

typedef union SIPI_CTOR2_union_tag {   /* SIPI Channel Timeout Register 2 */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t TOR:8;
  } B;
} SIPI_CTOR2_tag;

typedef union SIPI_CCRC2_union_tag {   /* SIPI Channel CRC Register 2 */
  vuint32_t R;
  struct {
    vuint32_t CRCI:16;
    vuint32_t CRCT:16;
  } B;
} SIPI_CCRC2_tag;

typedef union SIPI_CAR2_union_tag {    /* SIPI Channel Address Register 2 */
  vuint32_t R;
  struct {
    vuint32_t CAR:32;
  } B;
} SIPI_CAR2_tag;

typedef union SIPI_CDR2_union_tag {    /* SIPI Channel Data Register 2 */
  vuint32_t R;
  struct {
    vuint32_t CDR2:32;
  } B;
} SIPI_CDR2_tag;

typedef union SIPI_CCR3_union_tag {    /* SIPI Channel Control Register 3 */
  vuint32_t R;
  struct {
    vuint32_t  :15;
    vuint32_t TC:1;                    /* Send Trigger Command. */
    vuint32_t  :8;
    vuint32_t WL:2;                    /* Word Length Transfer. */
    vuint32_t CHEN:1;                  /* Channel Enable. */
    vuint32_t ST:1;                    /* Streaming Transfer. */
    vuint32_t IDT:1;                   /* ID Read Request Transfer. */
    vuint32_t RRT:1;                   /* Read Request Transfer. */
    vuint32_t WRT:1;                   /* Write Request Transfer. */
    vuint32_t DEN:1;                   /* DMA Enable. */
  } B;
} SIPI_CCR3_tag;

typedef union SIPI_CSR3_union_tag {    /* SIPI Channel Status Register 3 */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t RAR:1;
    vuint32_t TID:3;                   /* Transaction ID of transmitted frame. */
    vuint32_t ACKR:1;
    vuint32_t CB:1;                    /* Channel Busy. */
    vuint32_t  :2;
  } B;
} SIPI_CSR3_tag;

typedef union SIPI_CIR3_union_tag {    /* SIPI Channel Interrupt Register 3 */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WAIE:1;
    vuint32_t RAIE:1;
    vuint32_t TCIE:1;
    vuint32_t TOIE:1;
    vuint32_t TIDIE:1;
    vuint32_t ACKIE:1;
  } B;
} SIPI_CIR3_tag;

typedef union SIPI_CTOR3_union_tag {   /* SIPI Channel Timeout Register 3 */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t TOR:8;                   /* Timeout value for transmitted requests. */
  } B;
} SIPI_CTOR3_tag;

typedef union SIPI_CCRC3_union_tag {   /* SIPI Channel CRC Register 3 */
  vuint32_t R;
  struct {
    vuint32_t CRCI:16;
    vuint32_t CRCT:16;
  } B;
} SIPI_CCRC3_tag;

typedef union SIPI_CAR3_union_tag {    /* SIPI Channel Address Register 3 */
  vuint32_t R;
  struct {
    vuint32_t CAR:32;
  } B;
} SIPI_CAR3_tag;

typedef union SIPI_CDR3_union_tag {    /* SIPI Channel Data Register 3 */
  vuint32_t R;
  struct {
    vuint32_t CDR:32;
  } B;
} SIPI_CDR3_tag;

typedef union SIPI_MCR_union_tag {     /* SIPI Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t FRZ:1;                   /* Freeze Enable */
    vuint32_t  :1;
    vuint32_t HALT:1;                  /* Halt Mode Enable */
    vuint32_t  :2;
    vuint32_t PRSCLR:11;               /* Timeout counter prescaler */
    vuint32_t AID:2;                   /* Address Increment/Decrement */
    vuint32_t  :3;
    vuint32_t CRCIE:1;                 /* CRC Error Interrupt Enable */
    vuint32_t MCRIE:1;                 /* Max Count Reached Interrupt Enable */
    vuint32_t  :4;
    vuint32_t CHNSB:1;                 /* Channel coding select bit. */
    vuint32_t TEN:1;                   /* Target Enable */
    vuint32_t INIT:1;                  /* Initialization Mode */
    vuint32_t MOEN:1;                  /* Module Enable */
    vuint32_t SR:1;                    /* Soft Reset */
  } B;
} SIPI_MCR_tag;

typedef union SIPI_SR_union_tag {      /* SIPI Status Register */
  vuint32_t R;
  struct {
    vuint32_t FRZACK:1;
    vuint32_t  :1;
    vuint32_t  :19;
    vuint32_t GCRCE:1;
    vuint32_t MCR:1;                   /* Maximum Count Reached. */
    vuint32_t  :1;
    vuint32_t TE:4;
    vuint32_t STATE:4;
  } B;
} SIPI_SR_tag;

typedef union SIPI_MAXCR_union_tag {   /* SIPI Max Count Register */
  vuint32_t R;
  struct {
    vuint32_t MXCNT:30;
    vuint32_t  :2;
  } B;
} SIPI_MAXCR_tag;

typedef union SIPI_ARR_union_tag {     /* SIPI Address Reload Register */
  vuint32_t R;
  struct {
    vuint32_t ADRLD:30;
    vuint32_t  :2;
  } B;
} SIPI_ARR_tag;

typedef union SIPI_ACR_union_tag {     /* SIPI Address Count Register */
  vuint32_t R;
  struct {
    vuint32_t ADCNT:30;                /* Feflects the count value of address counter at target node. */
    vuint32_t  :2;
  } B;
} SIPI_ACR_tag;

typedef union SIPI_ERR_union_tag {     /* SIPI Error Register */
  vuint32_t R;
  struct {
    vuint32_t  :5;
    vuint32_t TOE3:1;
    vuint32_t TIDE3:1;
    vuint32_t ACKE3:1;
    vuint32_t  :5;
    vuint32_t TOE2:1;
    vuint32_t TIDE2:1;
    vuint32_t ACKE2:1;
    vuint32_t  :5;
    vuint32_t TOE1:1;
    vuint32_t TIDE1:1;
    vuint32_t ACKE1:1;
    vuint32_t  :5;
    vuint32_t TOE0:1;
    vuint32_t TIDE0:1;
    vuint32_t ACKE0:1;
  } B;
} SIPI_ERR_tag;

struct SIPI_tag {
  SIPI_CCR0_tag CCR0;                  /* SIPI Channel Control Register 0 */
  SIPI_CSR0_tag CSR0;                  /* SIPI Channel Status Register 0 */
  uint8_t SIPI_reserved0[4];
  SIPI_CIR0_tag CIR0;                  /* SIPI Channel Interrupt Register 0 */
  SIPI_CTOR0_tag CTOR0;                /* SIPI Channel Timeout Register 0 */
  SIPI_CCRC0_tag CCRC0;                /* SIPI Channel CRC Register 0 */
  SIPI_CAR0_tag CAR0;                  /* SIPI Channel Address Register 0 */
  SIPI_CDR0_tag CDR0;                  /* SIPI Channel Data Register 0 */
  SIPI_CCR1_tag CCR1;                  /* SIPI Channel Control Register 1 */
  SIPI_CSR1_tag CSR1;                  /* SIPI Channel Status Register 1 */
  uint8_t SIPI_reserved1[4];
  SIPI_CIR1_tag CIR1;                  /* SIPI Channel Interrupt Register 1 */
  SIPI_CTOR1_tag CTOR1;                /* SIPI Channel Timeout Register 1 */
  SIPI_CCRC1_tag CCRC1;                /* SIPI Channel CRC Register 1 */
  SIPI_CAR1_tag CAR1;                  /* SIPI Channel Address Register 1 */
  SIPI_CDR1_tag CDR1;                  /* SIPI Channel Data Register 1 */
  SIPI_CCR2_tag CCR2;                  /* SIPI Channel Control Register 2 */
  SIPI_CSR2_tag CSR2;                  /* SIPI Channel Status Register 2 */
  uint8_t SIPI_reserved2[4];
  SIPI_CIR2_tag CIR2;                  /* SIPI Channel Interrupt Register 2 */
  SIPI_CTOR2_tag CTOR2;                /* SIPI Channel Timeout Register 2 */
  SIPI_CCRC2_tag CCRC2;                /* SIPI Channel CRC Register 2 */
  SIPI_CAR2_tag CAR2;                  /* SIPI Channel Address Register 2 */
  SIPI_CDR2_tag CDR2[8];               /* SIPI Channel Data Register 2 */
  SIPI_CCR3_tag CCR3;                  /* SIPI Channel Control Register 3 */
  SIPI_CSR3_tag CSR3;                  /* SIPI Channel Status Register 3 */
  uint8_t SIPI_reserved3[4];
  SIPI_CIR3_tag CIR3;                  /* SIPI Channel Interrupt Register 3 */
  SIPI_CTOR3_tag CTOR3;                /* SIPI Channel Timeout Register 3 */
  SIPI_CCRC3_tag CCRC3;                /* SIPI Channel CRC Register 3 */
  SIPI_CAR3_tag CAR3;                  /* SIPI Channel Address Register 3 */
  SIPI_CDR3_tag CDR3;                  /* SIPI Channel Data Register 3 */
  SIPI_MCR_tag MCR;                    /* SIPI Module Configuration Register */
  SIPI_SR_tag SR;                      /* SIPI Status Register */
  SIPI_MAXCR_tag MAXCR;                /* SIPI Max Count Register */
  SIPI_ARR_tag ARR;                    /* SIPI Address Reload Register */
  SIPI_ACR_tag ACR;                    /* SIPI Address Count Register */
  SIPI_ERR_tag ERR;                    /* SIPI Error Register */
};


/* ============================================================================
   =============================== Module: SIU ================================
   ============================================================================ */

typedef union SIU_MIDR_union_tag {     /* MCU Identification Register */
  vuint32_t R;
  struct {
    vuint32_t PARTNUM:16;
    vuint32_t PKG:4;
    vuint32_t  :4;
    vuint32_t MASKNUM_MAJOR:4;
    vuint32_t MASKNUM_MINOR:4;
  } B;
} SIU_MIDR_tag;

typedef union SIU_RSR_union_tag {      /* Reset Status Register */
  vuint32_t R;
  struct {
    vuint32_t PORS:1;
    vuint32_t ERS:1;
    vuint32_t  :7;
    vuint32_t CPURS:1;
    vuint32_t  :1;
    vuint32_t FOSURS:1;
    vuint32_t FCCURS:1;
    vuint32_t STCURS:1;
    vuint32_t SSRS:1;
    vuint32_t SERF:1;
    vuint32_t WKPCFG:1;
    vuint32_t  :7;
    vuint32_t XOSC:1;
    vuint32_t  :2;
    vuint32_t XOSCHIGH:1;
    vuint32_t ABR:1;
    vuint32_t BOOTCFG:2;
    vuint32_t RGF:1;
  } B;
} SIU_RSR_tag;

typedef union SIU_SRCR_union_tag {     /* System Reset Control Register */
  vuint32_t R;
  struct {
    vuint32_t SSR:1;
    vuint32_t SER:1;
    vuint32_t  :30;
  } B;
} SIU_SRCR_tag;

typedef union SIU_EISR_union_tag {     /* External IRQ Status Register */
  vuint32_t R;
  struct {
    vuint32_t NMI0:1;
    vuint32_t NMI1:1;
    vuint32_t  :14;
    vuint32_t EIF15:1;
    vuint32_t EIF14:1;
    vuint32_t EIF13:1;
    vuint32_t EIF12:1;
    vuint32_t EIF11:1;
    vuint32_t EIF10:1;
    vuint32_t EIF9:1;
    vuint32_t EIF8:1;
    vuint32_t EIF7:1;
    vuint32_t EIF6:1;
    vuint32_t EIF5:1;
    vuint32_t EIF4:1;
    vuint32_t EIF3:1;
    vuint32_t EIF2:1;
    vuint32_t EIF1:1;
    vuint32_t EIF0:1;
  } B;
} SIU_EISR_tag;

typedef union SIU_DIRER_union_tag {    /* DMA/Interrupt Request Enable Register */
  vuint32_t R;
  struct {
    vuint32_t NMISEL8:1;
    vuint32_t NMISEL7:1;
    vuint32_t  :6;
    vuint32_t NMISEL0:1;
    vuint32_t NMISEL1:1;
    vuint32_t  :6;
    vuint32_t EIRE15:1;
    vuint32_t EIRE14:1;
    vuint32_t EIRE13:1;
    vuint32_t EIRE12:1;
    vuint32_t EIRE11:1;
    vuint32_t EIRE10:1;
    vuint32_t EIRE9:1;
    vuint32_t EIRE8:1;
    vuint32_t EIRE7:1;
    vuint32_t EIRE6:1;
    vuint32_t EIRE5:1;
    vuint32_t EIRE4:1;
    vuint32_t EIRE3:1;
    vuint32_t EIRE2:1;
    vuint32_t EIRE1:1;
    vuint32_t EIRE0:1;
  } B;
} SIU_DIRER_tag;

typedef union SIU_DIRSR_union_tag {    /* DMA/Interrupt Request Select Register */
  vuint32_t R;
  struct {
    vuint32_t  :28;
    vuint32_t DIRS3:1;
    vuint32_t DIRS2:1;
    vuint32_t DIRS1:1;
    vuint32_t DIRS0:1;
  } B;
} SIU_DIRSR_tag;

typedef union SIU_OSR_union_tag {      /* Overrun Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t OVF15:1;
    vuint32_t OVF14:1;
    vuint32_t OVF13:1;
    vuint32_t OVF12:1;
    vuint32_t OVF11:1;
    vuint32_t OVF10:1;
    vuint32_t OVF9:1;
    vuint32_t OVF8:1;
    vuint32_t OVF7:1;
    vuint32_t OVF6:1;
    vuint32_t OVF5:1;
    vuint32_t OVF4:1;
    vuint32_t OVF3:1;
    vuint32_t OVF2:1;
    vuint32_t OVF1:1;
    vuint32_t OVF0:1;
  } B;
} SIU_OSR_tag;

typedef union SIU_ORER_union_tag {     /* Overrun Request Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t ORE15:1;
    vuint32_t ORE14:1;
    vuint32_t ORE13:1;
    vuint32_t ORE12:1;
    vuint32_t ORE11:1;
    vuint32_t ORE10:1;
    vuint32_t ORE9:1;
    vuint32_t ORE8:1;
    vuint32_t ORE7:1;
    vuint32_t ORE6:1;
    vuint32_t ORE5:1;
    vuint32_t ORE4:1;
    vuint32_t ORE3:1;
    vuint32_t ORE2:1;
    vuint32_t ORE1:1;
    vuint32_t ORE0:1;
  } B;
} SIU_ORER_tag;

typedef union SIU_IREER_union_tag {    /* IRQ Rising-Edge Event Enable Register */
  vuint32_t R;
  struct {
    vuint32_t IREE_NMI8:1;
    vuint32_t IREE_NMI7:1;
    vuint32_t  :14;
    vuint32_t IREE15:1;
    vuint32_t IREE14:1;
    vuint32_t IREE13:1;
    vuint32_t IREE12:1;
    vuint32_t IREE11:1;
    vuint32_t IREE10:1;
    vuint32_t IREE9:1;
    vuint32_t IREE8:1;
    vuint32_t IREE7:1;
    vuint32_t IREE6:1;
    vuint32_t IREE5:1;
    vuint32_t IREE4:1;
    vuint32_t IREE3:1;
    vuint32_t IREE2:1;
    vuint32_t IREE1:1;
    vuint32_t IREE0:1;
  } B;
} SIU_IREER_tag;

typedef union SIU_IFEER_union_tag {    /* IRQ Falling-Edge Event Enable Register */
  vuint32_t R;
  struct {
    vuint32_t IFEE_NMI8:1;
    vuint32_t IFEE_NMI7:1;
    vuint32_t  :14;
    vuint32_t IFEEN15:1;
    vuint32_t IFEEN14:1;
    vuint32_t IFEEN13:1;
    vuint32_t IFEEN12:1;
    vuint32_t IFEEN11:1;
    vuint32_t IFEEN10:1;
    vuint32_t IFEEN9:1;
    vuint32_t IFEEN8:1;
    vuint32_t IFEEN7:1;
    vuint32_t IFEEN6:1;
    vuint32_t IFEEN5:1;
    vuint32_t IFEEN4:1;
    vuint32_t IFEEN3:1;
    vuint32_t IFEEN2:1;
    vuint32_t IFEEN1:1;
    vuint32_t IFEEN0:1;
  } B;
} SIU_IFEER_tag;

typedef union SIU_IDFR_union_tag {     /* IRQ Digital Filter Register */
  vuint32_t R;
  struct {
    vuint32_t  :28;
    vuint32_t DFL:4;
  } B;
} SIU_IDFR_tag;

typedef union SIU_IFIR_union_tag {     /* IRQ Filtered Input Register */
  vuint32_t R;
  struct {
    vuint32_t IFI_NMI8:1;
    vuint32_t IFI_NMI7:1;
    vuint32_t  :14;
    vuint32_t IFI15:1;
    vuint32_t IFI14:1;
    vuint32_t IFI13:1;
    vuint32_t IFI12:1;
    vuint32_t IFI11:1;
    vuint32_t IFI10:1;
    vuint32_t IFI9:1;
    vuint32_t IFI8:1;
    vuint32_t IFI7:1;
    vuint32_t IFI6:1;
    vuint32_t IFI5:1;
    vuint32_t IFI4:1;
    vuint32_t IFI3:1;
    vuint32_t IFI2:1;
    vuint32_t IFI1:1;
    vuint32_t IFI0:1;
  } B;
} SIU_IFIR_tag;

typedef union SIU_PCR_union_tag {      /* Pad Configuration Register */
  vuint16_t R;
  struct {
    vuint16_t  :3;
    vuint16_t PA:3;
    vuint16_t OBE:1;
    vuint16_t IBE:1;
    vuint16_t DSC:2;
    vuint16_t ODE:1;
    vuint16_t HYS:1;
    vuint16_t SRC:2;
    vuint16_t WPE:1;
    vuint16_t WPS:1;
  } B;
} SIU_PCR_tag;

typedef union SIU_GPDO_union_tag {     /* GPIO Pin Data Output Register */
  vuint8_t R;
  struct {
    vuint8_t  :7;
    vuint8_t PDOn:1;
  } B;
} SIU_GPDO_tag;

typedef union SIU_GPDIL_union_tag {    /* GPIO Pin Data Input Register (legacy) */
  vuint8_t R;
  struct {
    vuint8_t  :7;
    vuint8_t PDIn:1;
  } B;
} SIU_GPDIL_tag;

typedef union SIU_EIISR_union_tag {    /* External IRQ Input Select Register */
  vuint32_t R;
  struct {
    vuint32_t ESEL15:2;
    vuint32_t ESEL14:2;
    vuint32_t ESEL13:2;
    vuint32_t ESEL12:2;
    vuint32_t ESEL11:2;
    vuint32_t ESEL10:2;
    vuint32_t ESEL9:2;
    vuint32_t ESEL8:2;
    vuint32_t ESEL7:2;
    vuint32_t ESEL6:2;
    vuint32_t ESEL5:2;
    vuint32_t ESEL4:2;
    vuint32_t ESEL3:2;
    vuint32_t ESEL2:2;
    vuint32_t ESEL1:2;
    vuint32_t ESEL0:2;
  } B;
} SIU_EIISR_tag;

typedef union SIU_DISR_union_tag {     /* DSPI Input Select Register */
  vuint32_t R;
  struct {
    vuint32_t SINSELA:2;
    vuint32_t SSSELA:2;
    vuint32_t SCKSELA:2;
    vuint32_t  :2;
    vuint32_t SINSELB:2;
    vuint32_t SSSELB:2;
    vuint32_t SCKSELB:2;
    vuint32_t  :2;
    vuint32_t SINSELC:2;
    vuint32_t SSSELC:2;
    vuint32_t SCKSELC:2;
    vuint32_t  :2;
    vuint32_t SINSELD:2;
    vuint32_t SSSELD:2;
    vuint32_t SCKSELD:2;
    vuint32_t  :2;
  } B;
} SIU_DISR_tag;

typedef union SIU_ISEL4_union_tag {    /* eQADC Command FIFO Trigger Source Registers */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t CTSEL5_A:7;
    vuint32_t  :1;
    vuint32_t CTSEL4_A:7;
    vuint32_t  :1;
    vuint32_t CTSEL3_A:7;
    vuint32_t  :1;
    vuint32_t CTSEL2_A:7;
  } B;
} SIU_ISEL4_tag;

typedef union SIU_ISEL5_union_tag {    /* eQADC Command FIFO Trigger Source Registers */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t CTSEL1_A:7;
    vuint32_t  :1;
    vuint32_t CTSEL0_A:7;
    vuint32_t  :16;
  } B;
} SIU_ISEL5_tag;

typedef union SIU_ISEL6_union_tag {    /* eQADC Command FIFO Trigger Source Registers */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t CTSEL5_B:7;
    vuint32_t  :1;
    vuint32_t CTSEL4_B:7;
    vuint32_t  :1;
    vuint32_t CTSEL3_B:7;
    vuint32_t  :1;
    vuint32_t CTSEL2_B:7;
  } B;
} SIU_ISEL6_tag;

typedef union SIU_ISEL7_union_tag {    /* eQADC Command FIFO Trigger Source Registers */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t CTSEL1_B:7;
    vuint32_t  :1;
    vuint32_t CTSEL0_B:7;
    vuint32_t  :16;
  } B;
} SIU_ISEL7_tag;

typedef union SIU_ISEL8_union_tag {    /* eTPU_A Input Select Register */
  vuint32_t R;
  struct {
    vuint32_t  :11;
    vuint32_t ETPU29:1;
    vuint32_t  :3;
    vuint32_t ETPU28:1;
    vuint32_t  :3;
    vuint32_t ETPU27:1;
    vuint32_t  :3;
    vuint32_t ETPU26:1;
    vuint32_t  :3;
    vuint32_t ETPU25:1;
    vuint32_t  :3;
    vuint32_t ETPU24:1;
  } B;
} SIU_ISEL8_tag;

typedef union SIU_ISEL9_union_tag {    /* eQADC Advance Trigger Source Register */
  vuint32_t R;
  struct {
    vuint32_t  :11;
    vuint32_t EETSEL0ADV_A:5;
    vuint32_t  :11;
    vuint32_t EETSEL0ADV_B:5;
  } B;
} SIU_ISEL9_tag;

typedef union SIU_DECFIL1_union_tag {  /* Decimation Filter Register 1 */
  vuint32_t R;
  struct {
    vuint32_t HSELD:4;
    vuint32_t ZSELD:4;
    vuint32_t HSELC:4;
    vuint32_t ZSELC:4;
    vuint32_t HSELB:4;
    vuint32_t ZSELB:4;
    vuint32_t HSELA:4;
    vuint32_t ZSELA:4;
  } B;
} SIU_DECFIL1_tag;

typedef union SIU_DECFIL2_union_tag {  /* Decimation Filter Register 2 */
  vuint32_t R;
  struct {
    vuint32_t HSELH:4;
    vuint32_t ZSELH:4;
    vuint32_t HSELG:4;
    vuint32_t ZSELG:4;
    vuint32_t HSELF:4;
    vuint32_t ZSELF:4;
    vuint32_t HSELE:4;
    vuint32_t ZSELE:4;
  } B;
} SIU_DECFIL2_tag;

typedef union SIU_DECFIL3_union_tag {  /* Decimation Filter Register 3 */
  vuint32_t R;
  struct {
    vuint32_t HSELL:4;
    vuint32_t ZSELL:4;
    vuint32_t HSELK:4;
    vuint32_t ZSELK:4;
    vuint32_t HSELJ:4;
    vuint32_t ZSELJ:4;
    vuint32_t HSELI:4;
    vuint32_t ZSELI:4;
  } B;
} SIU_DECFIL3_tag;

typedef union SIU_DECFIL4_union_tag {  /* Decimation Filter Register 4 */
  vuint32_t R;
  struct {
    vuint32_t TRIG_SRCH:4;
    vuint32_t TRIG_SRCG:4;
    vuint32_t TRIG_SRCF:4;
    vuint32_t TRIG_SRCE:4;
    vuint32_t TRIG_SRCD:4;
    vuint32_t TRIG_SRCC:4;
    vuint32_t TRIG_SRCB:4;
    vuint32_t TRIG_SRCA:4;
  } B;
} SIU_DECFIL4_tag;

typedef union SIU_DECFIL5_union_tag {  /* Decimation Filter Register 5 */
  vuint32_t R;
  struct {
    vuint32_t TRIG_SRCL:4;
    vuint32_t TRIG_SRCK:4;
    vuint32_t TRIG_SRCJ:4;
    vuint32_t TRIG_SRCI:4;
    vuint32_t  :16;
  } B;
} SIU_DECFIL5_tag;

typedef union SIU_REACTSR_union_tag {  /* Reaction Module Trigger Selection Register */
  vuint32_t R;
  struct {
    vuint32_t TS15:2;
    vuint32_t TS14:2;
    vuint32_t TS13:2;
    vuint32_t TS12:2;
    vuint32_t TS11:2;
    vuint32_t TS10:2;
    vuint32_t TS9:2;
    vuint32_t TS8:2;
    vuint32_t TS7:2;
    vuint32_t TS6:2;
    vuint32_t TS5:2;
    vuint32_t TS4:2;
    vuint32_t TS3:2;
    vuint32_t TS2:2;
    vuint32_t TS1:2;
    vuint32_t TS0:2;
  } B;
} SIU_REACTSR_tag;

typedef union SIU_SDGATE_SEL_union_tag { /* Sigma-Delta Gate Selection Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t SD_D_GATE_SEL:4;
    vuint32_t SD_C_GATE_SEL:4;
    vuint32_t SD_B_GATE_SEL:4;
    vuint32_t SD_A_GATE_SEL:4;
  } B;
} SIU_SDGATE_SEL_tag;

typedef union SIU_SDETPUA_union_tag {  /* Sigma-Delta to eTPU_A Connection Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t CH1:1;
    vuint32_t CH2:1;
    vuint32_t  :1;
    vuint32_t CH4:1;
    vuint32_t CH5:1;
    vuint32_t CH6:1;
    vuint32_t CH7:1;
    vuint32_t  :1;
    vuint32_t CH9:1;
    vuint32_t CH10:1;
    vuint32_t CH11:1;
    vuint32_t CH12:1;
    vuint32_t  :1;
    vuint32_t CH14:1;
    vuint32_t CH15:1;
    vuint32_t CH16:1;
    vuint32_t CH17:1;
    vuint32_t  :1;
    vuint32_t CH19:1;
    vuint32_t  :10;
    vuint32_t CH30:1;
    vuint32_t  :1;
  } B;
} SIU_SDETPUA_tag;

typedef union SIU_SDETPUB_union_tag {  /* Sigma-Delta to eTPU_B Connection Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t CH1:1;
    vuint32_t CH2:1;
    vuint32_t  :1;
    vuint32_t CH4:1;
    vuint32_t CH5:1;
    vuint32_t CH6:1;
    vuint32_t CH7:1;
    vuint32_t  :1;
    vuint32_t CH9:1;
    vuint32_t CH10:1;
    vuint32_t CH11:1;
    vuint32_t CH12:1;
    vuint32_t  :1;
    vuint32_t CH14:1;
    vuint32_t CH15:1;
    vuint32_t CH16:1;
    vuint32_t CH17:1;
    vuint32_t  :1;
    vuint32_t CH19:1;
    vuint32_t  :10;
    vuint32_t CH30:1;
    vuint32_t  :1;
  } B;
} SIU_SDETPUB_tag;

typedef union SIU_SDETPUC_union_tag {  /* Sigma-Delta to eTPU_C Connection Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t CH2:1;
    vuint32_t CH3:1;
    vuint32_t CH4:1;
    vuint32_t CH5:1;
    vuint32_t  :1;
    vuint32_t CH7:1;
    vuint32_t CH8:1;
    vuint32_t CH9:1;
    vuint32_t CH10:1;
    vuint32_t  :1;
    vuint32_t CH12:1;
    vuint32_t CH13:1;
    vuint32_t CH14:1;
    vuint32_t  :10;
    vuint32_t CH25:1;
    vuint32_t  :1;
    vuint32_t CH27:1;
    vuint32_t CH28:1;
    vuint32_t CH29:1;
    vuint32_t CH30:1;
    vuint32_t  :1;
  } B;
} SIU_SDETPUC_tag;

typedef union SIU_TBG_CR_A_union_tag { /* Trigger Burst Generator Control Registers for eQADC_A */
  vuint32_t R;
  struct {
    vuint32_t GEN:1;
    vuint32_t  :3;
    vuint32_t CLKSEL:2;
    vuint32_t  :2;
    vuint32_t TRIGPER:24;
  } B;
} SIU_TBG_CR_A_tag;

typedef union SIU_TBG_CR_B_union_tag { /* Trigger Burst Generator Control Registers for eQADC_B */
  vuint32_t R;
  struct {
    vuint32_t GEN:1;
    vuint32_t  :3;
    vuint32_t CLKSEL:2;
    vuint32_t  :2;
    vuint32_t TRIGPER:24;
  } B;
} SIU_TBG_CR_B_tag;

typedef union SIU_ECCR_union_tag {     /* External Clock Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t ENGDIV:8;
    vuint32_t ECCS:1;
    vuint32_t  :3;
    vuint32_t EBTS:1;
    vuint32_t  :1;
    vuint32_t EBDF:2;
  } B;
} SIU_ECCR_tag;

typedef union SIU_SYSDIV_union_tag {   /* System Clock Register */
  vuint32_t R;
  struct {
    vuint32_t LCK:1;
    vuint32_t  :2;
    vuint32_t PLL0SEL:1;
    vuint32_t  :1;
    vuint32_t PLL1SEL:1;
    vuint32_t  :1;
    vuint32_t PERCLKSEL:1;
    vuint32_t  :2;
    vuint32_t FMPERDIV:2;
    vuint32_t  :2;
    vuint32_t PERDIV:2;
    vuint32_t MCANSEL:1;
    vuint32_t  :1;
    vuint32_t SYSCLKSEL:2;
    vuint32_t  :3;
    vuint32_t ETPUDIV:1;
    vuint32_t  :3;
    vuint32_t SYSCLKDIV:3;
    vuint32_t  :1;
    vuint32_t PCSEN:1;
  } B;
} SIU_SYSDIV_tag;

typedef union SIU_HLT1_union_tag {     /* Halt Register 1 */
  vuint32_t R;
  struct {
    vuint32_t CORE0:1;
    vuint32_t CORE1:1;
    vuint32_t  :1;
    vuint32_t CSE:1;
    vuint32_t ETPUC:1;
    vuint32_t ETPUA:1;
    vuint32_t NPC:1;
    vuint32_t EBI:1;
    vuint32_t EQADCB:1;
    vuint32_t EQADCA:1;
    vuint32_t EMIOS0:1;
    vuint32_t DECFIL:1;
    vuint32_t EMIOS1:1;
    vuint32_t PIT:1;
    vuint32_t  :2;
    vuint32_t FLEXCAND:1;
    vuint32_t FLEXCANC:1;
    vuint32_t FLEXCANB:1;
    vuint32_t FLEXCANA:1;
    vuint32_t DSPID:1;
    vuint32_t DSPIC:1;
    vuint32_t DSPIB:1;
    vuint32_t DSPIA:1;
    vuint32_t DSPIE:1;
    vuint32_t  :1;
    vuint32_t ESCIF:1;
    vuint32_t ESCIE:1;
    vuint32_t ESCID:1;
    vuint32_t ESCIC:1;
    vuint32_t ESCIB:1;
    vuint32_t ESCIA:1;
  } B;
} SIU_HLT1_tag;

typedef union SIU_HLTACK1_union_tag {  /* Halt Acknowledge Register 1 */
  vuint32_t R;
  struct {
    vuint32_t CORE0:1;
    vuint32_t CORE1:1;
    vuint32_t  :1;
    vuint32_t CSE:1;
    vuint32_t ETPUC:1;
    vuint32_t ETPUA:1;
    vuint32_t NPC:1;
    vuint32_t EBI:1;
    vuint32_t EQADCB:1;
    vuint32_t EQADCA:1;
    vuint32_t EMIOS0:1;
    vuint32_t DECFIL:1;
    vuint32_t EMIOS1:1;
    vuint32_t PIT:1;
    vuint32_t  :2;
    vuint32_t FLEXCAND:1;
    vuint32_t FLEXCANC:1;
    vuint32_t FLEXCANB:1;
    vuint32_t FLEXCANA:1;
    vuint32_t DSPID:1;
    vuint32_t DSPIC:1;
    vuint32_t DSPIB:1;
    vuint32_t DSPIA:1;
    vuint32_t DSPIE:1;
    vuint32_t  :1;
    vuint32_t ESCIF:1;
    vuint32_t ESCIE:1;
    vuint32_t ESCID:1;
    vuint32_t ESCIC:1;
    vuint32_t ESCIB:1;
    vuint32_t ESCIA:1;
  } B;
} SIU_HLTACK1_tag;

typedef union SIU_RSTVEC0_union_tag {  /* Core0 Reset Vector Register */
  vuint32_t R;
  struct {
    vuint32_t RSTVEC:30;
    vuint32_t RST:1;
    vuint32_t VLE:1;
  } B;
} SIU_RSTVEC0_tag;

typedef union SIU_RSTVEC1_union_tag {  /* Core1 Reset Vector Register */
  vuint32_t R;
  struct {
    vuint32_t RSTVEC:30;
    vuint32_t RST:1;
    vuint32_t VLE:1;
  } B;
} SIU_RSTVEC1_tag;

typedef union SIU_C0PID_union_tag {    /* Core0 PID mapping control register */
  vuint32_t R;
  struct {
    vuint32_t EXT_PID_EN:1;
    vuint32_t EXT_PID_SYNC:1;
    vuint32_t  :28;
    vuint32_t EXT_PID:2;
  } B;
} SIU_C0PID_tag;

typedef union SIU_C1PID_union_tag {    /* Core1 PID mapping control register */
  vuint32_t R;
  struct {
    vuint32_t EXT_PID_EN:1;
    vuint32_t EXT_PID_SYNC:1;
    vuint32_t  :28;
    vuint32_t EXT_PID:2;
  } B;
} SIU_C1PID_tag;

typedef union SIU_HLT2_union_tag {     /* Halt Register 2 */
  vuint32_t R;
  struct {
    vuint32_t FEC:1;
    vuint32_t  :11;
    vuint32_t SDD:1;
    vuint32_t SDC:1;
    vuint32_t SDB:1;
    vuint32_t SDA:1;
    vuint32_t SIPI:1;
    vuint32_t CRC:1;
    vuint32_t STCU:1;
    vuint32_t  :3;
    vuint32_t SRX1:1;
    vuint32_t SRX0:1;
    vuint32_t  :2;
    vuint32_t PSI5B:1;
    vuint32_t PSI5A:1;
    vuint32_t  :2;
    vuint32_t MCANB:1;
    vuint32_t MCANA:1;
  } B;
} SIU_HLT2_tag;

typedef union SIU_HLTACK2_union_tag {  /* Halt Acknowledge Register 2 */
  vuint32_t R;
  struct {
    vuint32_t FEC:1;
    vuint32_t  :11;
    vuint32_t SDD:1;
    vuint32_t SDC:1;
    vuint32_t SDB:1;
    vuint32_t SDA:1;
    vuint32_t SIPI:1;
    vuint32_t CRC:1;
    vuint32_t STCU:1;
    vuint32_t  :3;
    vuint32_t SRX1:1;
    vuint32_t SRX0:1;
    vuint32_t  :2;
    vuint32_t PSI5B:1;
    vuint32_t PSI5A:1;
    vuint32_t  :2;
    vuint32_t MCANB:1;
    vuint32_t MCANA:1;
  } B;
} SIU_HLTACK2_tag;

typedef union SIU_SDCLKCFG_union_tag { /* Sigma-Delta Clock Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t LCK:1;
    vuint32_t  :24;
    vuint32_t SDDIV:7;
  } B;
} SIU_SDCLKCFG_tag;

typedef union SIU_LFCLKCFG_union_tag { /* LFAST Clock Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t LCK:1;
    vuint32_t  :17;
    vuint32_t LFCLKSEL:2;
    vuint32_t  :5;
    vuint32_t LFDIV:7;
  } B;
} SIU_LFCLKCFG_tag;

typedef union SIU_PSCLKCFG_union_tag { /* PSI5 Clock Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t LCK:1;
    vuint32_t  :7;
    vuint32_t PSDIV:8;
    vuint32_t  :6;
    vuint32_t PSDIV1M:10;
  } B;
} SIU_PSCLKCFG_tag;

typedef union SIU_RCR_union_tag {      /* Reset Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :28;
    vuint32_t RET:4;
  } B;
} SIU_RCR_tag;

typedef union SIU_LOCKSTEP_union_tag { /* Lock-Step Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t LSE:1;
  } B;
} SIU_LOCKSTEP_tag;

typedef union SIU_PCSER_union_tag {    /* Progressive Clock Switch Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t PCSE:1;
  } B;
} SIU_PCSER_tag;

typedef union SIU_PCSIFR_union_tag {   /* Progressive Clock Switch Interrupt Flag Register */
  vuint32_t R;
  struct {
    vuint32_t  :29;
    vuint32_t PCSMS:2;
    vuint32_t PCSI:1;
  } B;
} SIU_PCSIFR_tag;

typedef union SIU_FECCR_union_tag {    /* Fast Ethernet Controller Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t FM:1;
  } B;
} SIU_FECCR_tag;

typedef union SIU_ECCEIR_union_tag {   /* ECC Error Injection Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t INVC:1;
    vuint32_t CHKINVM:7;
  } B;
} SIU_ECCEIR_tag;

typedef union SIU_PGPDO_union_tag {    /* Parallel GPIO Pin Data Output Registers */
  vuint32_t R;
  struct {
    vuint32_t PGPDO0:1;
    vuint32_t PGPDO1:1;
    vuint32_t PGPDO2:1;
    vuint32_t PGPDO3:1;
    vuint32_t PGPDO4:1;
    vuint32_t PGPDO5:1;
    vuint32_t PGPDO6:1;
    vuint32_t PGPDO7:1;
    vuint32_t PGPDO8:1;
    vuint32_t PGPDO9:1;
    vuint32_t PGPDO10:1;
    vuint32_t PGPDO11:1;
    vuint32_t PGPDO12:1;
    vuint32_t PGPDO13:1;
    vuint32_t PGPDO14:1;
    vuint32_t PGPDO15:1;
    vuint32_t PGPDO16:1;
    vuint32_t PGPDO17:1;
    vuint32_t PGPDO18:1;
    vuint32_t PGPDO19:1;
    vuint32_t PGPDO20:1;
    vuint32_t PGPDO21:1;
    vuint32_t PGPDO22:1;
    vuint32_t PGPDO23:1;
    vuint32_t PGPDO24:1;
    vuint32_t PGPDO25:1;
    vuint32_t PGPDO26:1;
    vuint32_t PGPDO27:1;
    vuint32_t PGPDO28:1;
    vuint32_t PGPDO29:1;
    vuint32_t PGPDO30:1;
    vuint32_t PGPDO31:1;
  } B;
} SIU_PGPDO_tag;

typedef union SIU_PGPDI_union_tag {    /* Parallel GPIO Pin Data Input Registers */
  vuint32_t R;
  struct {
    vuint32_t PGPDI0:1;
    vuint32_t PGPDI1:1;
    vuint32_t PGPDI2:1;
    vuint32_t PGPDI3:1;
    vuint32_t PGPDI4:1;
    vuint32_t PGPDI5:1;
    vuint32_t PGPDI6:1;
    vuint32_t PGPDI7:1;
    vuint32_t PGPDI8:1;
    vuint32_t PGPDI9:1;
    vuint32_t PGPDI10:1;
    vuint32_t PGPDI11:1;
    vuint32_t PGPDI12:1;
    vuint32_t PGPDI13:1;
    vuint32_t PGPDI14:1;
    vuint32_t PGPDI15:1;
    vuint32_t PGPDI16:1;
    vuint32_t PGPDI17:1;
    vuint32_t PGPDI18:1;
    vuint32_t PGPDI19:1;
    vuint32_t PGPDI20:1;
    vuint32_t PGPDI21:1;
    vuint32_t PGPDI22:1;
    vuint32_t PGPDI23:1;
    vuint32_t PGPDI24:1;
    vuint32_t PGPDI25:1;
    vuint32_t PGPDI26:1;
    vuint32_t PGPDI27:1;
    vuint32_t PGPDI28:1;
    vuint32_t PGPDI29:1;
    vuint32_t PGPDI30:1;
    vuint32_t PGPDI31:1;
  } B;
} SIU_PGPDI_tag;

typedef union SIU_MPGPDO_union_tag {   /* Masked Parallel GPIO Pin Data Output Registers */
  vuint32_t R;
  struct {
    vuint32_t MASK0:1;
    vuint32_t MASK1:1;
    vuint32_t MASK2:1;
    vuint32_t MASK3:1;
    vuint32_t MASK4:1;
    vuint32_t MASK5:1;
    vuint32_t MASK6:1;
    vuint32_t MASK7:1;
    vuint32_t MASK8:1;
    vuint32_t MASK9:1;
    vuint32_t MASK10:1;
    vuint32_t MASK11:1;
    vuint32_t MASK12:1;
    vuint32_t MASK13:1;
    vuint32_t MASK14:1;
    vuint32_t MASK15:1;
    vuint32_t DATA0:1;
    vuint32_t DATA1:1;
    vuint32_t DATA2:1;
    vuint32_t DATA3:1;
    vuint32_t DATA4:1;
    vuint32_t DATA5:1;
    vuint32_t DATA6:1;
    vuint32_t DATA7:1;
    vuint32_t DATA8:1;
    vuint32_t DATA9:1;
    vuint32_t DATA10:1;
    vuint32_t DATA11:1;
    vuint32_t DATA12:1;
    vuint32_t DATA13:1;
    vuint32_t DATA14:1;
    vuint32_t DATA15:1;
  } B;
} SIU_MPGPDO_tag;

typedef union SIU_DSPI_DSPIH_union_tag { /* Mask-Output High Register */
  vuint32_t R;
  struct {
    vuint32_t MASK0:1;
    vuint32_t MASK1:1;
    vuint32_t MASK2:1;
    vuint32_t MASK3:1;
    vuint32_t MASK4:1;
    vuint32_t MASK5:1;
    vuint32_t MASK6:1;
    vuint32_t MASK7:1;
    vuint32_t MASK8:1;
    vuint32_t MASK9:1;
    vuint32_t MASK10:1;
    vuint32_t MASK11:1;
    vuint32_t MASK12:1;
    vuint32_t MASK13:1;
    vuint32_t MASK14:1;
    vuint32_t MASK15:1;
    vuint32_t DATA0:1;
    vuint32_t DATA1:1;
    vuint32_t DATA2:1;
    vuint32_t DATA3:1;
    vuint32_t DATA4:1;
    vuint32_t DATA5:1;
    vuint32_t DATA6:1;
    vuint32_t DATA7:1;
    vuint32_t DATA8:1;
    vuint32_t DATA9:1;
    vuint32_t DATA10:1;
    vuint32_t DATA11:1;
    vuint32_t DATA12:1;
    vuint32_t DATA13:1;
    vuint32_t DATA14:1;
    vuint32_t DATA15:1;
  } B;
} SIU_DSPI_DSPIH_tag;

typedef union SIU_DSPI_DSPIL_union_tag { /* Mask-Output Low Register */
  vuint32_t R;
  struct {
    vuint32_t MASK16:1;
    vuint32_t MASK17:1;
    vuint32_t MASK18:1;
    vuint32_t MASK19:1;
    vuint32_t MASK20:1;
    vuint32_t MASK21:1;
    vuint32_t MASK22:1;
    vuint32_t MASK23:1;
    vuint32_t MASK24:1;
    vuint32_t MASK25:1;
    vuint32_t MASK26:1;
    vuint32_t MASK27:1;
    vuint32_t MASK28:1;
    vuint32_t MASK29:1;
    vuint32_t MASK30:1;
    vuint32_t MASK31:1;
    vuint32_t DATA16:1;
    vuint32_t DATA17:1;
    vuint32_t DATA18:1;
    vuint32_t DATA19:1;
    vuint32_t DATA20:1;
    vuint32_t DATA21:1;
    vuint32_t DATA22:1;
    vuint32_t DATA23:1;
    vuint32_t DATA24:1;
    vuint32_t DATA25:1;
    vuint32_t DATA26:1;
    vuint32_t DATA27:1;
    vuint32_t DATA28:1;
    vuint32_t DATA29:1;
    vuint32_t DATA30:1;
    vuint32_t DATA31:1;
  } B;
} SIU_DSPI_DSPIL_tag;

typedef struct SIU_DSPI_struct_tag {
  SIU_DSPI_DSPIH_tag DSPIH;            /* Mask-Output High Register */
  SIU_DSPI_DSPIL_tag DSPIL;            /* Mask-Output Low Register */
} SIU_DSPI_tag;

typedef union SIU_ETPUBA_union_tag {   /* Serialized Output Signal Selection Register for DSPI_A */
  vuint32_t R;
  struct {
    vuint32_t ETPUB15:1;
    vuint32_t ETPUB14:1;
    vuint32_t ETPUB13:1;
    vuint32_t ETPUB12:1;
    vuint32_t ETPUB11:1;
    vuint32_t ETPUB10:1;
    vuint32_t ETPUB9:1;
    vuint32_t ETPUB8:1;
    vuint32_t ETPUB7:1;
    vuint32_t ETPUB6:1;
    vuint32_t ETPUB5:1;
    vuint32_t ETPUB4:1;
    vuint32_t ETPUB3:1;
    vuint32_t ETPUB2:1;
    vuint32_t ETPUB1:1;
    vuint32_t ETPUB0:1;
    vuint32_t ETPUB31:1;
    vuint32_t ETPUB30:1;
    vuint32_t ETPUB29:1;
    vuint32_t ETPUB28:1;
    vuint32_t ETPUB27:1;
    vuint32_t ETPUB26:1;
    vuint32_t ETPUB25:1;
    vuint32_t ETPUB24:1;
    vuint32_t ETPUB23:1;
    vuint32_t ETPUB22:1;
    vuint32_t ETPUB21:1;
    vuint32_t ETPUB20:1;
    vuint32_t ETPUB19:1;
    vuint32_t ETPUB18:1;
    vuint32_t ETPUB17:1;
    vuint32_t ETPUB16:1;
  } B;
} SIU_ETPUBA_tag;

typedef union SIU_EMIOSA_union_tag {   /* Serialized Output Signal Selection Register for DSPI_A */
  vuint32_t R;
  struct {
    vuint32_t EMIOS0_7_OUT0:1;
    vuint32_t EMIOS0_6_OUT1:1;
    vuint32_t EMIOS0_5_OUT2:1;
    vuint32_t EMIOS0_4_OUT3:1;
    vuint32_t EMIOS0_3_OUT4:1;
    vuint32_t EMIOS0_2_OUT5:1;
    vuint32_t EMIOS0_1_OUT6:1;
    vuint32_t EMIOS0_0_OUT7:1;
    vuint32_t EMIOS1_0_OUT8:1;
    vuint32_t EMIOS1_1_OUT9:1;
    vuint32_t EMIOS1_2_OUT10:1;
    vuint32_t EMIOS1_3_OUT11:1;
    vuint32_t EMIOS1_4_OUT12:1;
    vuint32_t EMIOS1_5_OUT13:1;
    vuint32_t EMIOS1_6_OUT14:1;
    vuint32_t EMIOS1_7_OUT15:1;
    vuint32_t EMIOS0_16_OUT16:1;
    vuint32_t EMIOS0_17_OUT17:1;
    vuint32_t EMIOS0_18_OUT18:1;
    vuint32_t EMIOS0_19_OUT19:1;
    vuint32_t EMIOS0_20_OUT20:1;
    vuint32_t EMIOS0_21_OUT21:1;
    vuint32_t EMIOS0_22_OUT22:1;
    vuint32_t EMIOS0_23_OUT23:1;
    vuint32_t EMIOS0_0_OUT24:1;
    vuint32_t EMIOS0_1_OUT25:1;
    vuint32_t EMIOS0_2_OUT26:1;
    vuint32_t EMIOS0_3_OUT27:1;
    vuint32_t EMIOS0_4_OUT28:1;
    vuint32_t EMIOS0_5_OUT29:1;
    vuint32_t EMIOS0_6_OUT30:1;
    vuint32_t EMIOS0_7_OUT31:1;
  } B;
} SIU_EMIOSA_tag;

typedef union SIU_DSPIAHLA_union_tag { /* Serialized Output Signal Selection Register for DSPI_A */
  vuint32_t R;
  struct {
    vuint32_t DSPIAH0:1;
    vuint32_t DSPIAH1:1;
    vuint32_t DSPIAH2:1;
    vuint32_t DSPIAH3:1;
    vuint32_t DSPIAH4:1;
    vuint32_t DSPIAH5:1;
    vuint32_t DSPIAH6:1;
    vuint32_t DSPIAH7:1;
    vuint32_t DSPIAH8:1;
    vuint32_t DSPIAH9:1;
    vuint32_t DSPIAH10:1;
    vuint32_t DSPIAH11:1;
    vuint32_t DSPIAH12:1;
    vuint32_t DSPIAH13:1;
    vuint32_t DSPIAH14:1;
    vuint32_t DSPIAH15:1;
    vuint32_t DSPIAL16:1;
    vuint32_t DSPIAL17:1;
    vuint32_t DSPIAL18:1;
    vuint32_t DSPIAL19:1;
    vuint32_t DSPIAL20:1;
    vuint32_t DSPIAL21:1;
    vuint32_t DSPIAL22:1;
    vuint32_t DSPIAL23:1;
    vuint32_t DSPIAL24:1;
    vuint32_t DSPIAL25:1;
    vuint32_t DSPIAL26:1;
    vuint32_t DSPIAL27:1;
    vuint32_t DSPIAL28:1;
    vuint32_t DSPIAL29:1;
    vuint32_t DSPIAL30:1;
    vuint32_t DSPIAL31:1;
  } B;
} SIU_DSPIAHLA_tag;

typedef union SIU_ETPUAB_union_tag {   /* Serialized Output Signal Selection Register for DSPI_B */
  vuint32_t R;
  struct {
    vuint32_t ETPUA23:1;
    vuint32_t ETPUA22:1;
    vuint32_t ETPUA21:1;
    vuint32_t ETPUA20:1;
    vuint32_t ETPUA19:1;
    vuint32_t ETPUA18:1;
    vuint32_t ETPUA17:1;
    vuint32_t ETPUA16:1;
    vuint32_t ETPUA29:1;
    vuint32_t ETPUA28:1;
    vuint32_t ETPUA27:1;
    vuint32_t ETPUA26:1;
    vuint32_t ETPUA25:1;
    vuint32_t ETPUA24:1;
    vuint32_t ETPUA31:1;
    vuint32_t ETPUA30:1;
    vuint32_t ETPUA12:1;
    vuint32_t ETPUA13:1;
    vuint32_t ETPUA14:1;
    vuint32_t ETPUA15:1;
    vuint32_t ETPUA0:1;
    vuint32_t ETPUA1:1;
    vuint32_t ETPUA2:1;
    vuint32_t ETPUA3:1;
    vuint32_t ETPUA4:1;
    vuint32_t ETPUA5:1;
    vuint32_t ETPUA6:1;
    vuint32_t ETPUA7:1;
    vuint32_t ETPUA8:1;
    vuint32_t ETPUA9:1;
    vuint32_t ETPUA10:1;
    vuint32_t ETPUA11:1;
  } B;
} SIU_ETPUAB_tag;

typedef union SIU_EMIOSB_union_tag {   /* Serialized Output Signal Selection Register for DSPI_B */
  vuint32_t R;
  struct {
    vuint32_t EMIOS1_3_OUT0:1;
    vuint32_t EMIOS1_2_OUT1:1;
    vuint32_t EMIOS1_1_OUT2:1;
    vuint32_t EMIOS1_0_OUT3:1;
    vuint32_t EMIOS0_6_OUT4:1;
    vuint32_t EMIOS0_5_OUT5:1;
    vuint32_t EMIOS0_4_OUT6:1;
    vuint32_t EMIOS0_3_OUT7:1;
    vuint32_t EMIOS0_2_OUT8:1;
    vuint32_t EMIOS0_1_OUT9:1;
    vuint32_t EMIOS0_0_OUT10:1;
    vuint32_t EMIOS0_23_OUT11:1;
    vuint32_t EMIOS1_7_OUT12:1;
    vuint32_t EMIOS1_6_OUT13:1;
    vuint32_t EMIOS1_5_OUT14:1;
    vuint32_t EMIOS1_4_OUT15:1;
    vuint32_t EMIOS0_23_OUT16:1;
    vuint32_t EMIOS1_7_OUT17:1;
    vuint32_t EMIOS1_6_OUT18:1;
    vuint32_t EMIOS1_5_OUT19:1;
    vuint32_t EMIOS1_4_OUT20:1;
    vuint32_t EMIOS1_3_OUT21:1;
    vuint32_t EMIOS1_2_OUT22:1;
    vuint32_t EMIOS1_1_OUT23:1;
    vuint32_t EMIOS1_0_OUT24:1;
    vuint32_t EMIOS0_6_OUT25:1;
    vuint32_t EMIOS0_5_OUT26:1;
    vuint32_t EMIOS0_4_OUT27:1;
    vuint32_t EMIOS0_3_OUT28:1;
    vuint32_t EMIOS0_2_OUT29:1;
    vuint32_t EMIOS0_1_OUT30:1;
    vuint32_t EMIOS0_0_OUT31:1;
  } B;
} SIU_EMIOSB_tag;

typedef union SIU_DSPIBHLB_union_tag { /* Serialized Output Signal Selection Register for DSPI_B */
  vuint32_t R;
  struct {
    vuint32_t DSPIBH0:1;
    vuint32_t DSPIBH1:1;
    vuint32_t DSPIBH2:1;
    vuint32_t DSPIBH3:1;
    vuint32_t DSPIBH4:1;
    vuint32_t DSPIBH5:1;
    vuint32_t DSPIBH6:1;
    vuint32_t DSPIBH7:1;
    vuint32_t DSPIBH8:1;
    vuint32_t DSPIBH9:1;
    vuint32_t DSPIBH10:1;
    vuint32_t DSPIBH11:1;
    vuint32_t DSPIBH12:1;
    vuint32_t DSPIBH13:1;
    vuint32_t DSPIBH14:1;
    vuint32_t DSPIBH15:1;
    vuint32_t DSPIBL16:1;
    vuint32_t DSPIBL17:1;
    vuint32_t DSPIBL18:1;
    vuint32_t DSPIBL19:1;
    vuint32_t DSPIBL20:1;
    vuint32_t DSPIBL21:1;
    vuint32_t DSPIBL22:1;
    vuint32_t DSPIBL23:1;
    vuint32_t DSPIBL24:1;
    vuint32_t DSPIBL25:1;
    vuint32_t DSPIBL26:1;
    vuint32_t DSPIBL27:1;
    vuint32_t DSPIBL28:1;
    vuint32_t DSPIBL29:1;
    vuint32_t DSPIBL30:1;
    vuint32_t DSPIBL31:1;
  } B;
} SIU_DSPIBHLB_tag;

typedef union SIU_ETPUAC_union_tag {   /* Serialized Output Signal Selection Register for DSPI_C */
  vuint32_t R;
  struct {
    vuint32_t ETPUA12:1;
    vuint32_t ETPUA13:1;
    vuint32_t ETPUA14:1;
    vuint32_t ETPUA15:1;
    vuint32_t ETPUA0:1;
    vuint32_t ETPUA1:1;
    vuint32_t ETPUA2:1;
    vuint32_t ETPUA3:1;
    vuint32_t ETPUA4:1;
    vuint32_t ETPUA5:1;
    vuint32_t ETPUA6:1;
    vuint32_t ETPUA7:1;
    vuint32_t ETPUA8:1;
    vuint32_t ETPUA9:1;
    vuint32_t ETPUA10:1;
    vuint32_t ETPUA11:1;
    vuint32_t ETPUA23:1;
    vuint32_t ETPUA22:1;
    vuint32_t ETPUA21:1;
    vuint32_t ETPUA20:1;
    vuint32_t ETPUA19:1;
    vuint32_t ETPUA18:1;
    vuint32_t ETPUA17:1;
    vuint32_t ETPUA16:1;
    vuint32_t ETPUA29:1;
    vuint32_t ETPUA28:1;
    vuint32_t ETPUA27:1;
    vuint32_t ETPUA26:1;
    vuint32_t ETPUA25:1;
    vuint32_t ETPUA24:1;
    vuint32_t ETPUA31:1;
    vuint32_t ETPUA30:1;
  } B;
} SIU_ETPUAC_tag;

typedef union SIU_EMIOSC_union_tag {   /* Serialized Output Signal Selection Register for DSPI_C */
  vuint32_t R;
  struct {
    vuint32_t EMIOS1_4_OUT0:1;
    vuint32_t EMIOS1_5_OUT1:1;
    vuint32_t EMIOS1_6_OUT2:1;
    vuint32_t EMIOS1_7_OUT3:1;
    vuint32_t EMIOS0_23_OUT4:1;
    vuint32_t EMIOS0_0_OUT5:1;
    vuint32_t EMIOS0_1_OUT6:1;
    vuint32_t EMIOS0_2_OUT7:1;
    vuint32_t EMIOS0_3_OUT8:1;
    vuint32_t EMIOS0_4_OUT9:1;
    vuint32_t EMIOS0_5_OUT10:1;
    vuint32_t EMIOS0_6_OUT11:1;
    vuint32_t EMIOS1_0_OUT12:1;
    vuint32_t EMIOS1_1_OUT13:1;
    vuint32_t EMIOS1_2_OUT14:1;
    vuint32_t EMIOS1_3_OUT15:1;
    vuint32_t EMIOS0_0_OUT16:1;
    vuint32_t EMIOS0_1_OUT17:1;
    vuint32_t EMIOS0_2_OUT18:1;
    vuint32_t EMIOS0_3_OUT19:1;
    vuint32_t EMIOS0_4_OUT20:1;
    vuint32_t EMIOS0_5_OUT21:1;
    vuint32_t EMIOS0_6_OUT22:1;
    vuint32_t EMIOS1_0_OUT23:1;
    vuint32_t EMIOS1_1_OUT24:1;
    vuint32_t EMIOS1_2_OUT25:1;
    vuint32_t EMIOS1_3_OUT26:1;
    vuint32_t EMIOS1_4_OUT27:1;
    vuint32_t EMIOS1_5_OUT28:1;
    vuint32_t EMIOS1_6_OUT29:1;
    vuint32_t EMIOS1_7_OUT30:1;
    vuint32_t EMIOS0_23_OUT31:1;
  } B;
} SIU_EMIOSC_tag;

typedef union SIU_DSPICHLC_union_tag { /* Serialized Output Signal Selection Register for DSPI_C */
  vuint32_t R;
  struct {
    vuint32_t DSPICH0:1;
    vuint32_t DSPICH1:1;
    vuint32_t DSPICH2:1;
    vuint32_t DSPICH3:1;
    vuint32_t DSPICH4:1;
    vuint32_t DSPICH5:1;
    vuint32_t DSPICH6:1;
    vuint32_t DSPICH7:1;
    vuint32_t DSPICH8:1;
    vuint32_t DSPICH9:1;
    vuint32_t DSPICH10:1;
    vuint32_t DSPICH11:1;
    vuint32_t DSPICH12:1;
    vuint32_t DSPICH13:1;
    vuint32_t DSPICH14:1;
    vuint32_t DSPICH15:1;
    vuint32_t DSPICL16:1;
    vuint32_t DSPICL17:1;
    vuint32_t DSPICL18:1;
    vuint32_t DSPICL19:1;
    vuint32_t DSPICL20:1;
    vuint32_t DSPICL21:1;
    vuint32_t DSPICL22:1;
    vuint32_t DSPICL23:1;
    vuint32_t DSPICL24:1;
    vuint32_t DSPICL25:1;
    vuint32_t DSPICL26:1;
    vuint32_t DSPICL27:1;
    vuint32_t DSPICL28:1;
    vuint32_t DSPICL29:1;
    vuint32_t DSPICL30:1;
    vuint32_t DSPICL31:1;
  } B;
} SIU_DSPICHLC_tag;

typedef union SIU_ETPUBC_union_tag {   /* Serialized Output Signal Selection Register for DSPI_C */
  vuint32_t R;
  struct {
    vuint32_t ETPUB15:1;
    vuint32_t ETPUB14:1;
    vuint32_t ETPUB13:1;
    vuint32_t ETPUB12:1;
    vuint32_t ETPUB11:1;
    vuint32_t ETPUB10:1;
    vuint32_t ETPUB9:1;
    vuint32_t ETPUB8:1;
    vuint32_t ETPUB7:1;
    vuint32_t ETPUB6:1;
    vuint32_t ETPUB5:1;
    vuint32_t ETPUB4:1;
    vuint32_t ETPUB3:1;
    vuint32_t ETPUB2:1;
    vuint32_t ETPUB1:1;
    vuint32_t ETPUB0:1;
    vuint32_t ETPUB31:1;
    vuint32_t ETPUB30:1;
    vuint32_t ETPUB29:1;
    vuint32_t ETPUB28:1;
    vuint32_t ETPUB27:1;
    vuint32_t ETPUB26:1;
    vuint32_t ETPUB25:1;
    vuint32_t ETPUB24:1;
    vuint32_t ETPUB23:1;
    vuint32_t ETPUB22:1;
    vuint32_t ETPUB21:1;
    vuint32_t ETPUB20:1;
    vuint32_t ETPUB19:1;
    vuint32_t ETPUB18:1;
    vuint32_t ETPUB17:1;
    vuint32_t ETPUB16:1;
  } B;
} SIU_ETPUBC_tag;

typedef union SIU_ETPUBD_union_tag {   /* Serialized Output Signal Selection Register for DSPI_D */
  vuint32_t R;
  struct {
    vuint32_t ETPUB21:1;
    vuint32_t ETPUB20:1;
    vuint32_t ETPUB19:1;
    vuint32_t ETPUB18:1;
    vuint32_t ETPUB17:1;
    vuint32_t ETPUB16:1;
    vuint32_t  :4;
    vuint32_t ETPUB29:1;
    vuint32_t ETPUB28:1;
    vuint32_t ETPUB27:1;
    vuint32_t ETPUB26:1;
    vuint32_t ETPUB25:1;
    vuint32_t ETPUB24:1;
    vuint32_t  :16;
  } B;
} SIU_ETPUBD_tag;

typedef union SIU_EMIOSD_union_tag {   /* Serialized Output Signal Selection Register for DSPI_D */
  vuint32_t R;
  struct {
    vuint32_t  :6;
    vuint32_t EMIOS1_3_OUT6:1;
    vuint32_t EMIOS1_2_OUT7:1;
    vuint32_t EMIOS1_5_OUT8:1;
    vuint32_t EMIOS1_4_OUT9:1;
    vuint32_t  :22;
  } B;
} SIU_EMIOSD_tag;

typedef union SIU_DSPIDHLD_union_tag { /* Serialized Output Signal Selection Register for DSPI_D */
  vuint32_t R;
  struct {
    vuint32_t DSPIDH0:1;
    vuint32_t DSPIDH1:1;
    vuint32_t DSPIDH2:1;
    vuint32_t DSPIDH3:1;
    vuint32_t DSPIDH4:1;
    vuint32_t DSPIDH5:1;
    vuint32_t DSPIDH6:1;
    vuint32_t DSPIDH7:1;
    vuint32_t DSPIDH8:1;
    vuint32_t DSPIDH9:1;
    vuint32_t DSPIDH10:1;
    vuint32_t DSPIDH11:1;
    vuint32_t DSPIDH12:1;
    vuint32_t DSPIDH13:1;
    vuint32_t DSPIDH14:1;
    vuint32_t DSPIDH15:1;
    vuint32_t DSPIDL16:1;
    vuint32_t DSPIDL17:1;
    vuint32_t DSPIDL18:1;
    vuint32_t DSPIDL19:1;
    vuint32_t DSPIDL20:1;
    vuint32_t DSPIDL21:1;
    vuint32_t DSPIDL22:1;
    vuint32_t DSPIDL23:1;
    vuint32_t DSPIDL24:1;
    vuint32_t DSPIDL25:1;
    vuint32_t DSPIDL26:1;
    vuint32_t DSPIDL27:1;
    vuint32_t DSPIDL28:1;
    vuint32_t DSPIDL29:1;
    vuint32_t DSPIDL30:1;
    vuint32_t DSPIDL31:1;
  } B;
} SIU_DSPIDHLD_tag;

typedef union SIU_GPDI_union_tag {     /* GPIO Pin Data Input Register */
  vuint8_t R;
  struct {
    vuint8_t  :7;
    vuint8_t PDIn:1;
  } B;
} SIU_GPDI_tag;

typedef union SIU_IMUX0_union_tag {    /* Input Multiplexing Register0 */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t MUXSEL11:2;
    vuint32_t MUXSEL10:2;
    vuint32_t MUXSEL9:2;
    vuint32_t MUXSEL8:2;
    vuint32_t MUXSEL7:2;
    vuint32_t MUXSEL6:2;
    vuint32_t MUXSEL5:2;
    vuint32_t MUXSEL4:2;
    vuint32_t MUXSEL3:2;
    vuint32_t MUXSEL2:2;
    vuint32_t MUXSEL1:2;
    vuint32_t MUXSEL0:2;
  } B;
} SIU_IMUX0_tag;

typedef union SIU_IMUX1_union_tag {    /* Input Multiplexing Register1 */
  vuint32_t R;
  struct {
    vuint32_t  :20;
    vuint32_t MUXSEL5:2;
    vuint32_t  :6;
    vuint32_t MUXSEL1:2;
    vuint32_t MUXSEL0:2;
  } B;
} SIU_IMUX1_tag;

typedef union SIU_IMUX2_union_tag {    /* Input Multiplexing Register2 */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t MUXSEL11:2;
    vuint32_t MUXSEL10:2;
    vuint32_t MUXSEL9:2;
    vuint32_t MUXSEL8:2;
    vuint32_t MUXSEL7:2;
    vuint32_t MUXSEL6:2;
    vuint32_t MUXSEL5:2;
    vuint32_t  :10;
  } B;
} SIU_IMUX2_tag;

typedef union SIU_IMUX3_union_tag {    /* Input Multiplexing Register3 */
  vuint32_t R;
  struct {
    vuint32_t  :18;
    vuint32_t MUXSEL6:2;
    vuint32_t MUXSEL5:2;
    vuint32_t MUXSEL4:2;
    vuint32_t MUXSEL3:2;
    vuint32_t MUXSEL2:2;
    vuint32_t MUXSEL1:2;
    vuint32_t MUXSEL0:2;
  } B;
} SIU_IMUX3_tag;

typedef union SIU_IMUX4_union_tag {    /* Input Multiplexing Register4 */
  vuint32_t R;
  struct {
    vuint32_t  :14;
    vuint32_t MUXSEL8:2;
    vuint32_t  :8;
    vuint32_t MUXSEL3:2;
    vuint32_t MUXSEL2:2;
    vuint32_t MUXSEL1:2;
    vuint32_t MUXSEL0:2;
  } B;
} SIU_IMUX4_tag;

typedef union SIU_IMUX5_union_tag {    /* Input Multiplexing Register5 */
  vuint32_t R;
  struct {
    vuint32_t MUXSEL15:2;
    vuint32_t MUXSEL14:2;
    vuint32_t MUXSEL13:2;
    vuint32_t MUXSEL12:2;
    vuint32_t MUXSEL11:2;
    vuint32_t MUXSEL10:2;
    vuint32_t MUXSEL9:2;
    vuint32_t MUXSEL8:2;
    vuint32_t MUXSEL7:2;
    vuint32_t MUXSEL6:2;
    vuint32_t MUXSEL5:2;
    vuint32_t MUXSEL4:2;
    vuint32_t MUXSEL3:2;
    vuint32_t MUXSEL2:2;
    vuint32_t MUXSEL1:2;
    vuint32_t MUXSEL0:2;
  } B;
} SIU_IMUX5_tag;

typedef union SIU_IMUX7_union_tag {    /* Input Multiplexing Register7 */
  vuint32_t R;
  struct {
    vuint32_t MUXSEL15:2;
    vuint32_t MUXSEL14:2;
    vuint32_t MUXSEL13:2;
    vuint32_t MUXSEL12:2;
    vuint32_t MUXSEL11:2;
    vuint32_t MUXSEL10:2;
    vuint32_t MUXSEL9:2;
    vuint32_t MUXSEL8:2;
    vuint32_t  :16;
  } B;
} SIU_IMUX7_tag;

typedef union SIU_IMUX10_union_tag {   /* Input Multiplexing Register10 */
  vuint32_t R;
  struct {
    vuint32_t MUXSEL15:2;
    vuint32_t MUXSEL14:2;
    vuint32_t MUXSEL13:2;
    vuint32_t MUXSEL12:2;
    vuint32_t MUXSEL11:2;
    vuint32_t MUXSEL10:2;
    vuint32_t MUXSEL9:2;
    vuint32_t MUXSEL8:2;
    vuint32_t  :8;
    vuint32_t MUXSEL3:2;
    vuint32_t  :2;
    vuint32_t MUXSEL1:2;
    vuint32_t MUXSEL0:2;
  } B;
} SIU_IMUX10_tag;

typedef union SIU_IMUX12_union_tag {   /* Input Multiplexing Register12 */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t MUXSEL2:2;
    vuint32_t  :4;
  } B;
} SIU_IMUX12_tag;

struct SIU_tag {
  uint8_t SIU_reserved0[4];
  SIU_MIDR_tag MIDR;                   /* MCU Identification Register */
  uint8_t SIU_reserved1[4];
  SIU_RSR_tag RSR;                     /* Reset Status Register */
  SIU_SRCR_tag SRCR;                   /* System Reset Control Register */
  SIU_EISR_tag EISR;                   /* External IRQ Status Register */
  SIU_DIRER_tag DIRER;                 /* DMA/Interrupt Request Enable Register */
  SIU_DIRSR_tag DIRSR;                 /* DMA/Interrupt Request Select Register */
  SIU_OSR_tag OSR;                     /* Overrun Status Register */
  SIU_ORER_tag ORER;                   /* Overrun Request Enable Register */
  SIU_IREER_tag IREER;                 /* IRQ Rising-Edge Event Enable Register */
  SIU_IFEER_tag IFEER;                 /* IRQ Falling-Edge Event Enable Register */
  SIU_IDFR_tag IDFR;                   /* IRQ Digital Filter Register */
  SIU_IFIR_tag IFIR;                   /* IRQ Filtered Input Register */
  uint8_t SIU_reserved2[8];
  SIU_PCR_tag PCR[512];                /* Pad Configuration Register */
  uint8_t SIU_reserved3[448];
  SIU_GPDO_tag GPDO[512];              /* GPIO Pin Data Output Register */
  SIU_GPDIL_tag GPDIL[256];            /* GPIO Pin Data Input Register (legacy) */
  uint8_t SIU_reserved4[4];
  SIU_EIISR_tag EIISR;                 /* External IRQ Input Select Register */
  SIU_DISR_tag DISR;                   /* DSPI Input Select Register */
  uint8_t SIU_reserved5[4];
  SIU_ISEL4_tag ISEL4;                 /* eQADC Command FIFO Trigger Source Registers */
  SIU_ISEL5_tag ISEL5;                 /* eQADC Command FIFO Trigger Source Registers */
  SIU_ISEL6_tag ISEL6;                 /* eQADC Command FIFO Trigger Source Registers */
  SIU_ISEL7_tag ISEL7;                 /* eQADC Command FIFO Trigger Source Registers */
  SIU_ISEL8_tag ISEL8;                 /* eTPU_A Input Select Register */
  SIU_ISEL9_tag ISEL9;                 /* eQADC Advance Trigger Source Register */
  SIU_DECFIL1_tag DECFIL1;             /* Decimation Filter Register 1 */
  SIU_DECFIL2_tag DECFIL2;             /* Decimation Filter Register 2 */
  SIU_DECFIL3_tag DECFIL3;             /* Decimation Filter Register 3 */
  SIU_DECFIL4_tag DECFIL4;             /* Decimation Filter Register 4 */
  SIU_DECFIL5_tag DECFIL5;             /* Decimation Filter Register 5 */
  SIU_REACTSR_tag REACTSR;             /* Reaction Module Trigger Selection Register */
  SIU_SDGATE_SEL_tag SDGATE_SEL;       /* Sigma-Delta Gate Selection Register */
  SIU_SDETPUA_tag SDETPUA;             /* Sigma-Delta to eTPU_A Connection Configuration Register */
  SIU_SDETPUB_tag SDETPUB;             /* Sigma-Delta to eTPU_B Connection Configuration Register */
  SIU_SDETPUC_tag SDETPUC;             /* Sigma-Delta to eTPU_C Connection Configuration Register */
  SIU_TBG_CR_A_tag TBG_CR_A[6];        /* Trigger Burst Generator Control Registers for eQADC_A */
  SIU_TBG_CR_B_tag TBG_CR_B[6];        /* Trigger Burst Generator Control Registers for eQADC_B */
  uint8_t SIU_reserved6[4];
  SIU_ECCR_tag ECCR;                   /* External Clock Control Register */
  uint8_t SIU_reserved7[24];
  SIU_SYSDIV_tag SYSDIV;               /* System Clock Register */
  SIU_HLT1_tag HLT1;                   /* Halt Register 1 */
  SIU_HLTACK1_tag HLTACK1;             /* Halt Acknowledge Register 1 */
  SIU_RSTVEC0_tag RSTVEC0;             /* Core0 Reset Vector Register */
  SIU_RSTVEC1_tag RSTVEC1;             /* Core1 Reset Vector Register */
  SIU_C0PID_tag C0PID;                 /* Core0 PID mapping control register */
  SIU_C1PID_tag C1PID;                 /* Core1 PID mapping control register */
  SIU_HLT2_tag HLT2;                   /* Halt Register 2 */
  SIU_HLTACK2_tag HLTACK2;             /* Halt Acknowledge Register 2 */
  SIU_SDCLKCFG_tag SDCLKCFG;           /* Sigma-Delta Clock Configuration Register */
  SIU_LFCLKCFG_tag LFCLKCFG;           /* LFAST Clock Configuration Register */
  SIU_PSCLKCFG_tag PSCLKCFG;           /* PSI5 Clock Configuration Register */
  SIU_RCR_tag RCR;                     /* Reset Configuration Register */
  SIU_LOCKSTEP_tag LOCKSTEP;           /* Lock-Step Status Register */
  SIU_PCSER_tag PCSER;                 /* Progressive Clock Switch Interrupt Enable Register */
  SIU_PCSIFR_tag PCSIFR;               /* Progressive Clock Switch Interrupt Flag Register */
  SIU_FECCR_tag FECCR;                 /* Fast Ethernet Controller Control Register */
  SIU_ECCEIR_tag ECCEIR;               /* ECC Error Injection Register */
  uint8_t SIU_reserved8[536];
  SIU_PGPDO_tag PGPDO[16];             /* Parallel GPIO Pin Data Output Registers */
  SIU_PGPDI_tag PGPDI[16];             /* Parallel GPIO Pin Data Input Registers */
  SIU_MPGPDO_tag MPGPDO[32];           /* Masked Parallel GPIO Pin Data Output Registers */
  SIU_DSPI_tag DSPI[4];
  uint8_t SIU_reserved9[32];
  SIU_ETPUBA_tag ETPUBA;               /* Serialized Output Signal Selection Register for DSPI_A */
  SIU_EMIOSA_tag EMIOSA;               /* Serialized Output Signal Selection Register for DSPI_A */
  SIU_DSPIAHLA_tag DSPIAHLA;           /* Serialized Output Signal Selection Register for DSPI_A */
  uint8_t SIU_reserved10[4];
  SIU_ETPUAB_tag ETPUAB;               /* Serialized Output Signal Selection Register for DSPI_B */
  SIU_EMIOSB_tag EMIOSB;               /* Serialized Output Signal Selection Register for DSPI_B */
  SIU_DSPIBHLB_tag DSPIBHLB;           /* Serialized Output Signal Selection Register for DSPI_B */
  uint8_t SIU_reserved11[4];
  SIU_ETPUAC_tag ETPUAC;               /* Serialized Output Signal Selection Register for DSPI_C */
  SIU_EMIOSC_tag EMIOSC;               /* Serialized Output Signal Selection Register for DSPI_C */
  SIU_DSPICHLC_tag DSPICHLC;           /* Serialized Output Signal Selection Register for DSPI_C */
  SIU_ETPUBC_tag ETPUBC;               /* Serialized Output Signal Selection Register for DSPI_C */
  SIU_ETPUBD_tag ETPUBD;               /* Serialized Output Signal Selection Register for DSPI_D */
  SIU_EMIOSD_tag EMIOSD;               /* Serialized Output Signal Selection Register for DSPI_D */
  SIU_DSPIDHLD_tag DSPIDHLD;           /* Serialized Output Signal Selection Register for DSPI_D */
  uint8_t SIU_reserved12[132];
  SIU_GPDI_tag GPDI[512];              /* GPIO Pin Data Input Register */
  uint8_t SIU_reserved13[512];
  SIU_IMUX0_tag IMUX0;                 /* Input Multiplexing Register0 */
  SIU_IMUX1_tag IMUX1;                 /* Input Multiplexing Register1 */
  SIU_IMUX2_tag IMUX2;                 /* Input Multiplexing Register2 */
  SIU_IMUX3_tag IMUX3;                 /* Input Multiplexing Register3 */
  SIU_IMUX4_tag IMUX4;                 /* Input Multiplexing Register4 */
  SIU_IMUX5_tag IMUX5;                 /* Input Multiplexing Register5 */
  uint8_t SIU_reserved14[4];
  SIU_IMUX7_tag IMUX7;                 /* Input Multiplexing Register7 */
  uint8_t SIU_reserved15[8];
  SIU_IMUX10_tag IMUX10;               /* Input Multiplexing Register10 */
  uint8_t SIU_reserved16[4];
  SIU_IMUX12_tag IMUX12;               /* Input Multiplexing Register12 */
};


/* ============================================================================
   =============================== Module: SIU_B ==============================
   ============================================================================ */

typedef union SIU_B_PCRM_union_tag {   /* Pad Configuration Register Mirrored */
  vuint16_t R;
  struct {
    vuint16_t  :3;
    vuint16_t PA:3;
    vuint16_t OBE:1;
    vuint16_t IBE:1;
    vuint16_t DSC:2;
    vuint16_t ODE:1;
    vuint16_t HYS:1;
    vuint16_t SRC:2;
    vuint16_t WPE:1;
    vuint16_t WPS:1;
  } B;
} SIU_B_PCRM_tag;

typedef union SIU_B_GPDOM_union_tag {  /* GPIO Pin Data Output Register Mirrored */
  vuint8_t R;
  struct {
    vuint8_t  :7;
    vuint8_t PDOn:1;
  } B;
} SIU_B_GPDOM_tag;

typedef union SIU_B_GPDIM_union_tag {  /* GPIO Pin Data Input Register Mirrored */
  vuint8_t R;
  struct {
    vuint8_t  :7;
    vuint8_t PDIn:1;
  } B;
} SIU_B_GPDIM_tag;

struct SIU_B_tag {
  uint8_t SIU_B_reserved0[544];
  SIU_B_PCRM_tag PCRM[4];              /* Pad Configuration Register Mirrored */
  uint8_t SIU_B_reserved1[1224];
  SIU_B_GPDOM_tag GPDOM[4];            /* GPIO Pin Data Output Register Mirrored */
  uint8_t SIU_B_reserved2[508];
  SIU_B_GPDIM_tag GPDIM[4];            /* GPIO Pin Data Input Register Mirrored */
};


/* ============================================================================
   =============================== Module: SRX ================================
   ============================================================================ */

typedef union SRX_GBL_CTRL_union_tag { /* Global Control Register */
  vuint32_t R;
  struct {
    vuint32_t TSPRSC:8;
    vuint32_t  :3;
    vuint32_t FIFOWM:5;
    vuint32_t NIB_LEN_VAR_LIMIT:1;     /* Decides the allowable jitter/clock drift limit for nibble length measurement. */
    vuint32_t  :4;
    vuint32_t FMFOIE:1;
    vuint32_t FMDUIE:1;
    vuint32_t SMDUIE:1;
    vuint32_t  :1;
    vuint32_t FIFO_EN:1;
    vuint32_t  :1;
    vuint32_t FAST_CLR:1;
    vuint32_t  :1;
    vuint32_t DBG_FRZ:1;
    vuint32_t  :1;
    vuint32_t SENT_EN:1;
  } B;
} SRX_GBL_CTRL_tag;

typedef union SRX_CHNL_EN_union_tag {  /* Channel Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t EN_CH:6;
  } B;
} SRX_CHNL_EN_tag;

typedef union SRX_GBL_STATUS_union_tag { /* Global Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t FMFO:1;
    vuint32_t FMDU:1;
    vuint32_t SMDU:1;
    vuint32_t  :8;
  } B;
} SRX_GBL_STATUS_tag;

typedef union SRX_FMSG_RDY_union_tag { /* Fast Message Ready Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t F_RDY:6;
  } B;
} SRX_FMSG_RDY_tag;

typedef union SRX_SMSG_RDY_union_tag { /* Slow Serial Message Ready Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t S_RDY:6;
  } B;
} SRX_SMSG_RDY_tag;

typedef union SRX_DATA_CTRL1_union_tag { /* Data Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t NIBBCH0:3;
    vuint32_t  :1;
    vuint32_t NIBBCH1:3;
    vuint32_t  :1;
    vuint32_t NIBBCH2:3;
    vuint32_t  :1;
    vuint32_t NIBBCH3:3;
    vuint32_t  :1;
    vuint32_t NIBBCH4:3;
    vuint32_t  :1;
    vuint32_t NIBBCH5:3;
    vuint32_t  :1;
    vuint32_t  :3;
    vuint32_t  :1;
    vuint32_t  :3;
  } B;
} SRX_DATA_CTRL1_tag;

typedef union SRX_FDMA_CTRL_union_tag { /* Fast Message DMA Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t FDMA_EN:6;
  } B;
} SRX_FDMA_CTRL_tag;

typedef union SRX_SDMA_CTRL_union_tag { /* Slow Serial Message DMA Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t SDMA_EN:6;
  } B;
} SRX_SDMA_CTRL_tag;

typedef union SRX_FRDY_IE_union_tag {  /* Fast Message Ready Interrupt Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t FRDY_IE:6;
  } B;
} SRX_FRDY_IE_tag;

typedef union SRX_SRDY_IE_union_tag {  /* Slow Serial Message Ready Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t SRDY_IE:6;
  } B;
} SRX_SRDY_IE_tag;

typedef union SRX_DMA_FMSG_DATA_union_tag { /* DMA Fast Message Data Read Register */
  vuint32_t R;
  struct {
    vuint32_t CHNUM:4;
    vuint32_t SCNIB:4;
    vuint32_t DNIB1:4;
    vuint32_t DNIB2:4;
    vuint32_t DNIB3:4;
    vuint32_t DNIB4:4;
    vuint32_t DNIB5:4;
    vuint32_t DNIB6:4;
  } B;
} SRX_DMA_FMSG_DATA_tag;

typedef union SRX_DMA_FMSG_CRC_union_tag { /* DMA Fast Message CRC Read Register */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t CRC4b:4;
    vuint32_t  :16;
  } B;
} SRX_DMA_FMSG_CRC_tag;

typedef union SRX_DMA_FMSG_TS_union_tag { /* DMA Fast Message Time Stamp Read Register */
  vuint32_t R;
  struct {
    vuint32_t TS:32;
  } B;
} SRX_DMA_FMSG_TS_tag;

typedef union SRX_DMA_SMSG_BIT3_union_tag { /* DMA Slow Serial Message Bit3 Read Register */
  vuint32_t R;
  struct {
    vuint32_t CHNUM:4;
    vuint32_t TYPE:1;
    vuint32_t  :16;
    vuint32_t CFG:1;
    vuint32_t ID7_4_ID3_0:4;
    vuint32_t  :1;
    vuint32_t ID3_0_DATA15_12:4;
    vuint32_t  :1;
  } B;
} SRX_DMA_SMSG_BIT3_tag;

typedef union SRX_DMA_SMSG_BIT2_union_tag { /* DMA Slow Serial Message Bit2 Read Register */
  vuint32_t R;
  struct {
    vuint32_t  :10;
    vuint32_t SMCRC:6;
    vuint32_t  :4;
    vuint32_t DATA:12;
  } B;
} SRX_DMA_SMSG_BIT2_tag;

typedef union SRX_DMA_SMSG_TS_union_tag { /* DMA Slow Serial Message Time Stamp Read Register */
  vuint32_t R;
  struct {
    vuint32_t TS:32;
  } B;
} SRX_DMA_SMSG_TS_tag;

typedef union SRX_CH_CLK_CTRL_union_tag { /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t CM_PRSC:15;
    vuint32_t COMP_EN:1;
    vuint32_t  :1;
    vuint32_t PRSC:14;
  } B;
} SRX_CH_CLK_CTRL_tag;

typedef union SRX_CH_STATUS_union_tag { /* Channel 'n' Status Register (n=0 to (CH-1)) */
  vuint32_t R;
  struct {
    vuint32_t BUS_IDLE:1;
    vuint32_t  :3;
    vuint32_t CAL_RESYNC:1;
    vuint32_t CAL_20_25:1;
    vuint32_t SMSG_OFLW:1;
    vuint32_t FMSG_OFLW:1;
    vuint32_t  :1;
    vuint32_t PP_DIAG_ERR:1;
    vuint32_t CAL_LEN_ERR:1;
    vuint32_t CAL_DIAG_ERR:1;
    vuint32_t NIB_VAL_ERR:1;
    vuint32_t SMSG_CRC_ERR:1;
    vuint32_t FMSG_CRC_ERR:1;
    vuint32_t NUM_EDGES_ERR:1;
    vuint32_t  :16;
  } B;
} SRX_CH_STATUS_tag;

typedef union SRX_CH_CONFIG_union_tag { /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
  vuint32_t R;
  struct {
    vuint32_t BUS_IDLE_CNT:4;
    vuint32_t IE_CAL_RESYNC:1;
    vuint32_t IE_CAL_20_25:1;
    vuint32_t IE_SMSG_OFLW:1;
    vuint32_t IE_FMSG_OFLW:1;
    vuint32_t FCRC_CHK_OFF:1;
    vuint32_t IE_PP_DIAG_ERR:1;
    vuint32_t IE_CAL_LEN_ERR:1;
    vuint32_t IE_CAL_DIAG_ERR:1;
    vuint32_t IE_NIB_VAL_ERR:1;
    vuint32_t IE_SMSG_CRC_ERR:1;
    vuint32_t IE_FMSG_CRC_ERR:1;
    vuint32_t IE_NUM_EDGES_ERR:1;
    vuint32_t DCHNG_INT:1;
    vuint32_t CAL_RNG:1;
    vuint32_t PP_CHKSEL:1;
    vuint32_t FCRC_TYPE:1;
    vuint32_t FCRC_SC_EN:1;
    vuint32_t SCRC_TYPE:1;
    vuint32_t PAUSE_EN:1;
    vuint32_t SUCC_CAL_CHK:1;
    vuint32_t FIL_CNT:8;
  } B;
} SRX_CH_CONFIG_tag;

typedef struct SRX_CH_struct_tag {
  SRX_CH_CLK_CTRL_tag CLK_CTRL;        /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
  SRX_CH_STATUS_tag STATUS;            /* Channel 'n' Status Register (n=0 to (CH-1)) */
  SRX_CH_CONFIG_tag CONFIG;            /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
  uint8_t CH_reserved0[4];
} SRX_CH_tag;

typedef union SRX_CHANNEL_FMSG_DATA_union_tag { /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
  vuint32_t R;
  struct {
    vuint32_t CHNUM:4;
    vuint32_t SCNIB:4;
    vuint32_t DNIB1:4;
    vuint32_t DNIB2:4;
    vuint32_t DNIB3:4;
    vuint32_t DNIB4:4;
    vuint32_t DNIB5:4;
    vuint32_t DNIB6:4;
  } B;
} SRX_CHANNEL_FMSG_DATA_tag;

typedef union SRX_CHANNEL_FMSG_CRC_union_tag { /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t CRC4b:4;
    vuint32_t  :16;
  } B;
} SRX_CHANNEL_FMSG_CRC_tag;

typedef union SRX_CHANNEL_FMSG_TS_union_tag { /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
  vuint32_t R;
  struct {
    vuint32_t TS:32;
  } B;
} SRX_CHANNEL_FMSG_TS_tag;

typedef union SRX_CHANNEL_SMSG_BIT3_union_tag { /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
  vuint32_t R;
  struct {
    vuint32_t CHNUM:4;
    vuint32_t TYPE:1;
    vuint32_t  :16;
    vuint32_t CFG:1;
    vuint32_t ID7_4_ID3_0:4;
    vuint32_t  :1;
    vuint32_t ID3_0_DATA15_12:4;
    vuint32_t  :1;
  } B;
} SRX_CHANNEL_SMSG_BIT3_tag;

typedef union SRX_CHANNEL_SMSG_BIT2_union_tag { /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
  vuint32_t R;
  struct {
    vuint32_t  :10;
    vuint32_t SMCRC:6;
    vuint32_t  :4;
    vuint32_t DATA:12;
  } B;
} SRX_CHANNEL_SMSG_BIT2_tag;

typedef union SRX_CHANNEL_SMSG_TS_union_tag { /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
  vuint32_t R;
  struct {
    vuint32_t TS:32;
  } B;
} SRX_CHANNEL_SMSG_TS_tag;

typedef struct SRX_CHANNEL_struct_tag {
  SRX_CHANNEL_FMSG_DATA_tag FMSG_DATA; /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
  SRX_CHANNEL_FMSG_CRC_tag FMSG_CRC;   /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
  SRX_CHANNEL_FMSG_TS_tag FMSG_TS;     /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
  SRX_CHANNEL_SMSG_BIT3_tag SMSG_BIT3; /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
  SRX_CHANNEL_SMSG_BIT2_tag SMSG_BIT2; /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
  SRX_CHANNEL_SMSG_TS_tag SMSG_TS;     /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
} SRX_CHANNEL_tag;

struct SRX_tag {
  SRX_GBL_CTRL_tag GBL_CTRL;           /* Global Control Register */
  SRX_CHNL_EN_tag CHNL_EN;             /* Channel Enable Register */
  SRX_GBL_STATUS_tag GBL_STATUS;       /* Global Status Register */
  SRX_FMSG_RDY_tag FMSG_RDY;           /* Fast Message Ready Status Register */
  SRX_SMSG_RDY_tag SMSG_RDY;           /* Slow Serial Message Ready Status Register */
  uint8_t SRX_reserved0[4];
  SRX_DATA_CTRL1_tag DATA_CTRL1;       /* Data Control Register 1 */
  uint8_t SRX_reserved1[12];
  SRX_FDMA_CTRL_tag FDMA_CTRL;         /* Fast Message DMA Control Register */
  SRX_SDMA_CTRL_tag SDMA_CTRL;         /* Slow Serial Message DMA Control Register */
  uint8_t SRX_reserved2[4];
  SRX_FRDY_IE_tag FRDY_IE;             /* Fast Message Ready Interrupt Control Register */
  SRX_SRDY_IE_tag SRDY_IE;             /* Slow Serial Message Ready Interrupt Enable Register */
  uint8_t SRX_reserved3[4];
  SRX_DMA_FMSG_DATA_tag DMA_FMSG_DATA; /* DMA Fast Message Data Read Register */
  SRX_DMA_FMSG_CRC_tag DMA_FMSG_CRC;   /* DMA Fast Message CRC Read Register */
  SRX_DMA_FMSG_TS_tag DMA_FMSG_TS;     /* DMA Fast Message Time Stamp Read Register */
  uint8_t SRX_reserved4[4];
  SRX_DMA_SMSG_BIT3_tag DMA_SMSG_BIT3; /* DMA Slow Serial Message Bit3 Read Register */
  SRX_DMA_SMSG_BIT2_tag DMA_SMSG_BIT2; /* DMA Slow Serial Message Bit2 Read Register */
  SRX_DMA_SMSG_TS_tag DMA_SMSG_TS;     /* DMA Slow Serial Message Time Stamp Read Register */
  uint8_t SRX_reserved5[4];
  SRX_CH_tag CH[6];
  uint8_t SRX_reserved6[160];
  SRX_CHANNEL_tag CHANNEL[6];
};


/* ============================================================================
   =============================== Module: SSCM ===============================
   ============================================================================ */

typedef union SSCM_STATUS_union_tag {  /* SSCM System Status */
  vuint16_t R;
  struct {
    vuint16_t  :1;
    vuint16_t CER:1;                   /* Configuration Error */
    vuint16_t MER:1;                   /* Memory Configuration Error */
    vuint16_t NXEN1:1;                 /* Processor 1 Nexus enable status */
    vuint16_t NXEN:1;                  /* Processor 0 Nexus enable status */
    vuint16_t  :1;
    vuint16_t  :1;
    vuint16_t  :1;
    vuint16_t  :3;
    vuint16_t  :1;
    vuint16_t  :1;
    vuint16_t  :1;
    vuint16_t  :2;
  } B;
} SSCM_STATUS_tag;

typedef union SSCM_ERROR_union_tag {   /* SSCM Error Configuration Register */
  vuint16_t R;
  struct {
    vuint16_t  :14;
    vuint16_t PAE:1;                   /* Peripheral Bus Abort Enable. */
    vuint16_t  :1;
  } B;
} SSCM_ERROR_tag;

typedef union SSCM_LCSTAT_union_tag {  /* Life Cycle Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t  :2;
    vuint32_t  :5;
    vuint32_t LC:3;                    /* Life Cycle */
  } B;
} SSCM_LCSTAT_tag;

struct SSCM_tag {
  SSCM_STATUS_tag STATUS;              /* SSCM System Status */
  uint8_t SSCM_reserved0[4];
  SSCM_ERROR_tag ERROR;                /* SSCM Error Configuration Register */
  uint8_t SSCM_reserved1[44];
  SSCM_LCSTAT_tag LCSTAT;              /* Life Cycle Status Register */
};


/* ============================================================================
   =============================== Module: STCU2 ==============================
   ============================================================================ */

typedef union STCU2_RUN_union_tag {    /* STCU2 Run Register */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t BYP:1;
    vuint32_t MBPLLEN:1;
    vuint32_t LBPLLEN:1;
    vuint32_t  :7;
    vuint32_t RUN:1;
  } B;
} STCU2_RUN_tag;

typedef union STCU2_RUNSW_union_tag {  /* STCU2 Run Software Register */
  vuint32_t R;
  struct {
    vuint32_t  :20;
    vuint32_t MBIE:1;
    vuint32_t  :1;
    vuint32_t MBSWPLLEN:1;
    vuint32_t LBSWPLLEN:1;
    vuint32_t  :6;
    vuint32_t  :1;
    vuint32_t RUNSW:1;
  } B;
} STCU2_RUNSW_tag;

typedef union STCU2_SKC_union_tag {    /* STCU2 SK Code Register */
  vuint32_t R;
  struct {
    vuint32_t SKC:32;
  } B;
} STCU2_SKC_tag;

typedef union STCU2_CFG_union_tag {    /* STCU2 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t PTR:7;
    vuint32_t LB_DELAY:8;
    vuint32_t  :7;
    vuint32_t WRP:1;
    vuint32_t  :2;
    vuint32_t  :1;
    vuint32_t PMOSEN:1;
    vuint32_t MBU:1;
    vuint32_t CLK_CFG:3;
  } B;
} STCU2_CFG_tag;

typedef union STCU2_PLL_CFG_union_tag { /* STCU2 PLL Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t PLLODF:6;
    vuint32_t  :5;
    vuint32_t PLLIDF:3;
    vuint32_t  :9;
    vuint32_t PLLLDF:7;
  } B;
} STCU2_PLL_CFG_tag;

typedef union STCU2_WDG_union_tag {    /* STCU2 Watchdog Register Granularity */
  vuint32_t R;
  struct {
    vuint32_t WDGEOC:32;
  } B;
} STCU2_WDG_tag;

typedef union STCU2_INT_FLG_union_tag { /* STCU2 Interrupt Flag Register */
  vuint32_t R;
  struct {
    vuint32_t  :30;
    vuint32_t MBIFLG:1;
    vuint32_t  :1;
  } B;
} STCU2_INT_FLG_tag;

typedef union STCU2_ERR_STAT_union_tag { /* STCU2 Error Register */
  vuint32_t R;
  struct {
    vuint32_t  :6;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t  :3;
    vuint32_t LOCKESW:1;
    vuint32_t WDTOSW:1;
    vuint32_t  :1;
    vuint32_t ENGESW:1;
    vuint32_t INVPSW:1;
    vuint32_t  :6;
    vuint32_t UFSF:1;
    vuint32_t RFSF:1;
    vuint32_t  :3;
    vuint32_t LOCKE:1;
    vuint32_t WDTO:1;
    vuint32_t  :1;
    vuint32_t ENGE:1;
    vuint32_t INVP:1;
  } B;
} STCU2_ERR_STAT_tag;

typedef union STCU2_ERR_FM_union_tag { /* STCU2 Error FM Register */
  vuint32_t R;
  struct {
    vuint32_t  :27;
    vuint32_t LOCKEUFM:1;
    vuint32_t WDTOUFM:1;
    vuint32_t  :1;
    vuint32_t ENGEUFM:1;
    vuint32_t INVPUFM:1;
  } B;
} STCU2_ERR_FM_tag;

typedef union STCU2_LBS_union_tag {    /* STCU2 Off-Line LBIST Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t LBS5:1;
    vuint32_t LBS4:1;
    vuint32_t LBS3:1;
    vuint32_t LBS2:1;
    vuint32_t LBS1:1;
    vuint32_t LBS0:1;
  } B;
} STCU2_LBS_tag;

typedef union STCU2_LBE_union_tag {    /* STCU2 Off-Line LBIST End Flag Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t LBE5:1;
    vuint32_t LBE4:1;
    vuint32_t LBE3:1;
    vuint32_t LBE2:1;
    vuint32_t LBE1:1;
    vuint32_t LBE0:1;
  } B;
} STCU2_LBE_tag;

typedef union STCU2_LBSSW_union_tag {  /* STCU2 On-Line LBIST Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t LBSSW5:1;
    vuint32_t LBSSW4:1;
    vuint32_t LBSSW3:1;
    vuint32_t LBSSW2:1;
    vuint32_t LBSSW1:1;
    vuint32_t LBSSW0:1;
  } B;
} STCU2_LBSSW_tag;

typedef union STCU2_LBESW_union_tag {  /* STCU2 On-Line LBIST End Flag Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t LBESW5:1;
    vuint32_t LBESW4:1;
    vuint32_t LBESW3:1;
    vuint32_t LBESW2:1;
    vuint32_t LBESW1:1;
    vuint32_t LBESW0:1;
  } B;
} STCU2_LBESW_tag;

typedef union STCU2_LBRMSW_union_tag { /* STCU2 On-Line LBIST Reset Management */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t LBRMSW5:1;
    vuint32_t LBRMSW4:1;
    vuint32_t LBRMSW3:1;
    vuint32_t LBRMSW2:1;
    vuint32_t LBRMSW1:1;
    vuint32_t LBRMSW0:1;
  } B;
} STCU2_LBRMSW_tag;

typedef union STCU2_LBUFM_union_tag {  /* STCU2 LBIST Unrecoverable FM Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t LBUFM5:1;
    vuint32_t LBUFM4:1;
    vuint32_t LBUFM3:1;
    vuint32_t LBUFM2:1;
    vuint32_t LBUFM1:1;
    vuint32_t LBUFM0:1;
  } B;
} STCU2_LBUFM_tag;

typedef union STCU2_MBSL_union_tag {   /* STCU2 Off-Line MBIST Status Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBS31:1;
    vuint32_t MBS30:1;
    vuint32_t MBS29:1;
    vuint32_t MBS28:1;
    vuint32_t MBS27:1;
    vuint32_t MBS26:1;
    vuint32_t MBS25:1;
    vuint32_t MBS24:1;
    vuint32_t MBS23:1;
    vuint32_t MBS22:1;
    vuint32_t MBS21:1;
    vuint32_t MBS20:1;
    vuint32_t MBS19:1;
    vuint32_t MBS18:1;
    vuint32_t MBS17:1;
    vuint32_t MBS16:1;
    vuint32_t MBS15:1;
    vuint32_t MBS14:1;
    vuint32_t MBS13:1;
    vuint32_t MBS12:1;
    vuint32_t MBS11:1;
    vuint32_t MBS10:1;
    vuint32_t MBS9:1;
    vuint32_t MBS8:1;
    vuint32_t MBS7:1;
    vuint32_t MBS6:1;
    vuint32_t MBS5:1;
    vuint32_t MBS4:1;
    vuint32_t MBS3:1;
    vuint32_t MBS2:1;
    vuint32_t MBS1:1;
    vuint32_t MBS0:1;
  } B;
} STCU2_MBSL_tag;

typedef union STCU2_MBSM_union_tag {   /* STCU2 Off-Line MBIST Status Medium Register */
  vuint32_t R;
  struct {
    vuint32_t MBS63:1;
    vuint32_t MBS62:1;
    vuint32_t MBS61:1;
    vuint32_t MBS60:1;
    vuint32_t MBS59:1;
    vuint32_t MBS58:1;
    vuint32_t MBS57:1;
    vuint32_t MBS56:1;
    vuint32_t MBS55:1;
    vuint32_t MBS54:1;
    vuint32_t MBS53:1;
    vuint32_t MBS52:1;
    vuint32_t MBS51:1;
    vuint32_t MBS50:1;
    vuint32_t MBS49:1;
    vuint32_t MBS48:1;
    vuint32_t MBS47:1;
    vuint32_t MBS46:1;
    vuint32_t MBS45:1;
    vuint32_t MBS44:1;
    vuint32_t MBS43:1;
    vuint32_t MBS42:1;
    vuint32_t MBS41:1;
    vuint32_t MBS40:1;
    vuint32_t MBS39:1;
    vuint32_t MBS38:1;
    vuint32_t MBS37:1;
    vuint32_t MBS36:1;
    vuint32_t MBS35:1;
    vuint32_t MBS34:1;
    vuint32_t MBS33:1;
    vuint32_t MBS32:1;
  } B;
} STCU2_MBSM_tag;

typedef union STCU2_MBSH_union_tag {   /* STCU2 Off-Line MBIST Status High Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t MBS64:1;
  } B;
} STCU2_MBSH_tag;

typedef union STCU2_MBEL_union_tag {   /* STCU2 Off-Line MBIST End Flag Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBE31:1;
    vuint32_t MBE30:1;
    vuint32_t MBE29:1;
    vuint32_t MBE28:1;
    vuint32_t MBE27:1;
    vuint32_t MBE26:1;
    vuint32_t MBE25:1;
    vuint32_t MBE24:1;
    vuint32_t MBE23:1;
    vuint32_t MBE22:1;
    vuint32_t MBE21:1;
    vuint32_t MBE20:1;
    vuint32_t MBE19:1;
    vuint32_t MBE18:1;
    vuint32_t MBE17:1;
    vuint32_t MBE16:1;
    vuint32_t MBE15:1;
    vuint32_t MBE14:1;
    vuint32_t MBE13:1;
    vuint32_t MBE12:1;
    vuint32_t MBE11:1;
    vuint32_t MBE10:1;
    vuint32_t MBE9:1;
    vuint32_t MBE8:1;
    vuint32_t MBE7:1;
    vuint32_t MBE6:1;
    vuint32_t MBE5:1;
    vuint32_t MBE4:1;
    vuint32_t MBE3:1;
    vuint32_t MBE2:1;
    vuint32_t MBE1:1;
    vuint32_t MBE0:1;
  } B;
} STCU2_MBEL_tag;

typedef union STCU2_MBEM_union_tag {   /* STCU2 Off-Line MBIST End Flag Medium Register */
  vuint32_t R;
  struct {
    vuint32_t MBE63:1;
    vuint32_t MBE62:1;
    vuint32_t MBE61:1;
    vuint32_t MBE60:1;
    vuint32_t MBE59:1;
    vuint32_t MBE58:1;
    vuint32_t MBE57:1;
    vuint32_t MBE56:1;
    vuint32_t MBE55:1;
    vuint32_t MBE54:1;
    vuint32_t MBE53:1;
    vuint32_t MBE52:1;
    vuint32_t MBE51:1;
    vuint32_t MBE50:1;
    vuint32_t MBE49:1;
    vuint32_t MBE48:1;
    vuint32_t MBE47:1;
    vuint32_t MBE46:1;
    vuint32_t MBE45:1;
    vuint32_t MBE44:1;
    vuint32_t MBE43:1;
    vuint32_t MBE42:1;
    vuint32_t MBE41:1;
    vuint32_t MBE40:1;
    vuint32_t MBE39:1;
    vuint32_t MBE38:1;
    vuint32_t MBE37:1;
    vuint32_t MBE36:1;
    vuint32_t MBE35:1;
    vuint32_t MBE34:1;
    vuint32_t MBE33:1;
    vuint32_t MBE32:1;
  } B;
} STCU2_MBEM_tag;

typedef union STCU2_MBEH_union_tag {   /* STCU2 Off-Line MBIST End Flag High Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t MBE64:1;
  } B;
} STCU2_MBEH_tag;

typedef union STCU2_MBSLSW_union_tag { /* STCU2 On-Line MBIST Status Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBSSW31:1;
    vuint32_t MBSSW30:1;
    vuint32_t MBSSW29:1;
    vuint32_t MBSSW28:1;
    vuint32_t MBSSW27:1;
    vuint32_t MBSSW26:1;
    vuint32_t MBSSW25:1;
    vuint32_t MBSSW24:1;
    vuint32_t MBSSW23:1;
    vuint32_t MBSSW22:1;
    vuint32_t MBSSW21:1;
    vuint32_t MBSSW20:1;
    vuint32_t MBSSW19:1;
    vuint32_t MBSSW18:1;
    vuint32_t MBSSW17:1;
    vuint32_t MBSSW16:1;
    vuint32_t MBSSW15:1;
    vuint32_t MBSSW14:1;
    vuint32_t MBSSW13:1;
    vuint32_t MBSSW12:1;
    vuint32_t MBSSW11:1;
    vuint32_t MBSSW10:1;
    vuint32_t MBSSW9:1;
    vuint32_t MBSSW8:1;
    vuint32_t MBSSW7:1;
    vuint32_t MBSSW6:1;
    vuint32_t MBSSW5:1;
    vuint32_t MBSSW4:1;
    vuint32_t MBSSW3:1;
    vuint32_t MBSSW2:1;
    vuint32_t MBSSW1:1;
    vuint32_t MBSSW0:1;
  } B;
} STCU2_MBSLSW_tag;

typedef union STCU2_MBSMSW_union_tag { /* STCU2 On-Line MBIST Status Medium Register */
  vuint32_t R;
  struct {
    vuint32_t MBSSW63:1;
    vuint32_t MBSSW62:1;
    vuint32_t MBSSW61:1;
    vuint32_t MBSSW60:1;
    vuint32_t MBSSW59:1;
    vuint32_t MBSSW58:1;
    vuint32_t MBSSW57:1;
    vuint32_t MBSSW56:1;
    vuint32_t MBSSW55:1;
    vuint32_t MBSSW54:1;
    vuint32_t MBSSW53:1;
    vuint32_t MBSSW52:1;
    vuint32_t MBSSW51:1;
    vuint32_t MBSSW50:1;
    vuint32_t MBSSW49:1;
    vuint32_t MBSSW48:1;
    vuint32_t MBSSW47:1;
    vuint32_t MBSSW46:1;
    vuint32_t MBSSW45:1;
    vuint32_t MBSSW44:1;
    vuint32_t MBSSW43:1;
    vuint32_t MBSSW42:1;
    vuint32_t MBSSW41:1;
    vuint32_t MBSSW40:1;
    vuint32_t MBSSW39:1;
    vuint32_t MBSSW38:1;
    vuint32_t MBSSW37:1;
    vuint32_t MBSSW36:1;
    vuint32_t MBSSW35:1;
    vuint32_t MBSSW34:1;
    vuint32_t MBSSW33:1;
    vuint32_t MBSSW32:1;
  } B;
} STCU2_MBSMSW_tag;

typedef union STCU2_MBSHSW_union_tag { /* STCU2 On-Line MBIST Status High Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t MBSSW64:1;
  } B;
} STCU2_MBSHSW_tag;

typedef union STCU2_MBELSW_union_tag { /* STCU2 On-Line MBIST End Flag Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBESW31:1;
    vuint32_t MBESW30:1;
    vuint32_t MBESW29:1;
    vuint32_t MBESW28:1;
    vuint32_t MBESW27:1;
    vuint32_t MBESW26:1;
    vuint32_t MBESW25:1;
    vuint32_t MBESW24:1;
    vuint32_t MBESW23:1;
    vuint32_t MBESW22:1;
    vuint32_t MBESW21:1;
    vuint32_t MBESW20:1;
    vuint32_t MBESW19:1;
    vuint32_t MBESW18:1;
    vuint32_t MBESW17:1;
    vuint32_t MBESW16:1;
    vuint32_t MBESW15:1;
    vuint32_t MBESW14:1;
    vuint32_t MBESW13:1;
    vuint32_t MBESW12:1;
    vuint32_t MBESW11:1;
    vuint32_t MBESW10:1;
    vuint32_t MBESW9:1;
    vuint32_t MBESW8:1;
    vuint32_t MBESW7:1;
    vuint32_t MBESW6:1;
    vuint32_t MBESW5:1;
    vuint32_t MBESW4:1;
    vuint32_t MBESW3:1;
    vuint32_t MBESW2:1;
    vuint32_t MBESW1:1;
    vuint32_t MBESW0:1;
  } B;
} STCU2_MBELSW_tag;

typedef union STCU2_MBEMSW_union_tag { /* STCU2 On-Line MBIST End Flag Medium Register */
  vuint32_t R;
  struct {
    vuint32_t MBESW63:1;
    vuint32_t MBESW62:1;
    vuint32_t MBESW61:1;
    vuint32_t MBESW60:1;
    vuint32_t MBESW59:1;
    vuint32_t MBESW58:1;
    vuint32_t MBESW57:1;
    vuint32_t MBESW56:1;
    vuint32_t MBESW55:1;
    vuint32_t MBESW54:1;
    vuint32_t MBESW53:1;
    vuint32_t MBESW52:1;
    vuint32_t MBESW51:1;
    vuint32_t MBESW50:1;
    vuint32_t MBESW49:1;
    vuint32_t MBESW48:1;
    vuint32_t MBESW47:1;
    vuint32_t MBESW46:1;
    vuint32_t MBESW45:1;
    vuint32_t MBESW44:1;
    vuint32_t MBESW43:1;
    vuint32_t MBESW42:1;
    vuint32_t MBESW41:1;
    vuint32_t MBESW40:1;
    vuint32_t MBESW39:1;
    vuint32_t MBESW38:1;
    vuint32_t MBESW37:1;
    vuint32_t MBESW36:1;
    vuint32_t MBESW35:1;
    vuint32_t MBESW34:1;
    vuint32_t MBESW33:1;
    vuint32_t MBESW32:1;
  } B;
} STCU2_MBEMSW_tag;

typedef union STCU2_MBEHSW_union_tag { /* STCU2 On-Line MBIST End Flag High Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t MBESW64:1;
  } B;
} STCU2_MBEHSW_tag;

typedef union STCU2_MBUFML_union_tag { /* STCU2 MBIST Unrecoverable FM Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBUFM31:1;
    vuint32_t MBUFM30:1;
    vuint32_t MBUFM29:1;
    vuint32_t MBUFM28:1;
    vuint32_t MBUFM27:1;
    vuint32_t MBUFM26:1;
    vuint32_t MBUFM25:1;
    vuint32_t MBUFM24:1;
    vuint32_t MBUFM23:1;
    vuint32_t MBUFM22:1;
    vuint32_t MBUFM21:1;
    vuint32_t MBUFM20:1;
    vuint32_t MBUFM19:1;
    vuint32_t MBUFM18:1;
    vuint32_t MBUFM17:1;
    vuint32_t MBUFM16:1;
    vuint32_t MBUFM15:1;
    vuint32_t MBUFM14:1;
    vuint32_t MBUFM13:1;
    vuint32_t MBUFM12:1;
    vuint32_t MBUFM11:1;
    vuint32_t MBUFM10:1;
    vuint32_t MBUFM9:1;
    vuint32_t MBUFM8:1;
    vuint32_t MBUFM7:1;
    vuint32_t MBUFM6:1;
    vuint32_t MBUFM5:1;
    vuint32_t MBUFM4:1;
    vuint32_t MBUFM3:1;
    vuint32_t MBUFM2:1;
    vuint32_t MBUFM1:1;
    vuint32_t MBUFM0:1;
  } B;
} STCU2_MBUFML_tag;

typedef union STCU2_MBUFMM_union_tag { /* STCU2 MBIST Unrecoverable FM Medium Register */
  vuint32_t R;
  struct {
    vuint32_t MBUFM63:1;
    vuint32_t MBUFM62:1;
    vuint32_t MBUFM61:1;
    vuint32_t MBUFM60:1;
    vuint32_t MBUFM59:1;
    vuint32_t MBUFM58:1;
    vuint32_t MBUFM57:1;
    vuint32_t MBUFM56:1;
    vuint32_t MBUFM55:1;
    vuint32_t MBUFM54:1;
    vuint32_t MBUFM53:1;
    vuint32_t MBUFM52:1;
    vuint32_t MBUFM51:1;
    vuint32_t MBUFM50:1;
    vuint32_t MBUFM49:1;
    vuint32_t MBUFM48:1;
    vuint32_t MBUFM47:1;
    vuint32_t MBUFM46:1;
    vuint32_t MBUFM45:1;
    vuint32_t MBUFM44:1;
    vuint32_t MBUFM43:1;
    vuint32_t MBUFM42:1;
    vuint32_t MBUFM41:1;
    vuint32_t MBUFM40:1;
    vuint32_t MBUFM39:1;
    vuint32_t MBUFM38:1;
    vuint32_t MBUFM37:1;
    vuint32_t MBUFM36:1;
    vuint32_t MBUFM35:1;
    vuint32_t MBUFM34:1;
    vuint32_t MBUFM33:1;
    vuint32_t MBUFM32:1;
  } B;
} STCU2_MBUFMM_tag;

typedef union STCU2_MBUFMH_union_tag { /* STCU2 MBIST Unrecoverable FM High Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t MBUFM64:1;
  } B;
} STCU2_MBUFMH_tag;

typedef union STCU2_LB_LB_CTRL_union_tag { /* STCU2 LBIST Control Register */
  vuint32_t R;
  struct {
    vuint32_t CSM:1;
    vuint32_t PTR:7;
    vuint32_t  :4;
    vuint32_t PRPGEN:1;
    vuint32_t SHS:3;
    vuint32_t SCEN_OFF:4;
    vuint32_t SCEN_ON:4;
    vuint32_t  :4;
    vuint32_t PFT:1;
    vuint32_t CWS:3;
  } B;
} STCU2_LB_LB_CTRL_tag;

typedef union STCU2_LB_LB_PCS_union_tag { /* STCU2 LBIST PC Stop Register */
  vuint32_t R;
  struct {
    vuint32_t  :6;
    vuint32_t PCS:26;
  } B;
} STCU2_LB_LB_PCS_tag;

typedef union STCU2_LB_LB_PRPGL_union_tag { /* STCU2 LBIST PRPG Low Register */
  vuint32_t R;
  struct {
    vuint32_t PRPGx:32;
  } B;
} STCU2_LB_LB_PRPGL_tag;

typedef union STCU2_LB_LB_PRPGH_union_tag { /* STCU2 LBIST PRPG High Register */
  vuint32_t R;
  struct {
    vuint32_t PRPGx:32;
  } B;
} STCU2_LB_LB_PRPGH_tag;

typedef union STCU2_LB_LB_MISREL_union_tag { /* STCU2 Off-Line LBIST MISR Expected Low Register */
  vuint32_t R;
  struct {
    vuint32_t MISREx:32;
  } B;
} STCU2_LB_LB_MISREL_tag;

typedef union STCU2_LB_LB_MISREH_union_tag { /* STCU2 Off-Line LBIST MISR Expected High Register */
  vuint32_t R;
  struct {
    vuint32_t MISREx:32;
  } B;
} STCU2_LB_LB_MISREH_tag;

typedef union STCU2_LB_LB_MISRRL_union_tag { /* STCU2 Off-Line LBIST MISR Read Low Register */
  vuint32_t R;
  struct {
    vuint32_t MISRRx:32;
  } B;
} STCU2_LB_LB_MISRRL_tag;

typedef union STCU2_LB_LB_MISRRH_union_tag { /* STCU2 Off-Line LBIST MISR Read High Register */
  vuint32_t R;
  struct {
    vuint32_t MISRRx:32;
  } B;
} STCU2_LB_LB_MISRRH_tag;

typedef union STCU2_LB_LB_MISRELSW_union_tag { /* STCU2 On-Line LBIST MISR Expected Low Register */
  vuint32_t R;
  struct {
    vuint32_t MISRESWx:32;
  } B;
} STCU2_LB_LB_MISRELSW_tag;

typedef union STCU2_LB_LB_MISREHSW_union_tag { /* STCU2 On-Line LBIST MISR Expected High Register */
  vuint32_t R;
  struct {
    vuint32_t MISRESWx:32;
  } B;
} STCU2_LB_LB_MISREHSW_tag;

typedef union STCU2_LB_LB_MISRRLSW_union_tag { /* STCU2 On-Line LBIST MISR Read Low Register */
  vuint32_t R;
  struct {
    vuint32_t MISRRSWx:32;
  } B;
} STCU2_LB_LB_MISRRLSW_tag;

typedef union STCU2_LB_LB_MISRRHSW_union_tag { /* STCU2 On-Line LBIST MISR Read High Register */
  vuint32_t R;
  struct {
    vuint32_t MISRRSWx:32;
  } B;
} STCU2_LB_LB_MISRRHSW_tag;

typedef struct STCU2_LB_struct_tag {
  STCU2_LB_LB_CTRL_tag LB_CTRL;        /* STCU2 LBIST Control Register */
  STCU2_LB_LB_PCS_tag LB_PCS;          /* STCU2 LBIST PC Stop Register */
  STCU2_LB_LB_PRPGL_tag LB_PRPGL;      /* STCU2 LBIST PRPG Low Register */
  STCU2_LB_LB_PRPGH_tag LB_PRPGH;      /* STCU2 LBIST PRPG High Register */
  STCU2_LB_LB_MISREL_tag LB_MISREL;    /* STCU2 Off-Line LBIST MISR Expected Low Register */
  STCU2_LB_LB_MISREH_tag LB_MISREH;    /* STCU2 Off-Line LBIST MISR Expected High Register */
  STCU2_LB_LB_MISRRL_tag LB_MISRRL;    /* STCU2 Off-Line LBIST MISR Read Low Register */
  STCU2_LB_LB_MISRRH_tag LB_MISRRH;    /* STCU2 Off-Line LBIST MISR Read High Register */
  STCU2_LB_LB_MISRELSW_tag LB_MISRELSW; /* STCU2 On-Line LBIST MISR Expected Low Register */
  STCU2_LB_LB_MISREHSW_tag LB_MISREHSW; /* STCU2 On-Line LBIST MISR Expected High Register */
  STCU2_LB_LB_MISRRLSW_tag LB_MISRRLSW; /* STCU2 On-Line LBIST MISR Read Low Register */
  STCU2_LB_LB_MISRRHSW_tag LB_MISRRHSW; /* STCU2 On-Line LBIST MISR Read High Register */
  uint8_t LB_reserved0[16];
} STCU2_LB_tag;

typedef union STCU2_MB_CTRL_union_tag { /* STCU2 MBIST Control Register */
  vuint32_t R;
  struct {
    vuint32_t CSM:1;
    vuint32_t PTR:7;
    vuint32_t  :24;
  } B;
} STCU2_MB_CTRL_tag;

struct STCU2_tag {
  STCU2_RUN_tag RUN;                   /* STCU2 Run Register */
  STCU2_RUNSW_tag RUNSW;               /* STCU2 Run Software Register */
  STCU2_SKC_tag SKC;                   /* STCU2 SK Code Register */
  STCU2_CFG_tag CFG;                   /* STCU2 Configuration Register */
  STCU2_PLL_CFG_tag PLL_CFG;           /* STCU2 PLL Configuration Register */
  STCU2_WDG_tag WDG;                   /* STCU2 Watchdog Register Granularity */
  STCU2_INT_FLG_tag INT_FLG;           /* STCU2 Interrupt Flag Register */
  uint8_t STCU2_reserved0[8];
  STCU2_ERR_STAT_tag ERR_STAT;         /* STCU2 Error Register */
  STCU2_ERR_FM_tag ERR_FM;             /* STCU2 Error FM Register */
  STCU2_LBS_tag LBS;                   /* STCU2 Off-Line LBIST Status Register */
  STCU2_LBE_tag LBE;                   /* STCU2 Off-Line LBIST End Flag Register */
  STCU2_LBSSW_tag LBSSW;               /* STCU2 On-Line LBIST Status Register */
  STCU2_LBESW_tag LBESW;               /* STCU2 On-Line LBIST End Flag Register */
  STCU2_LBRMSW_tag LBRMSW;             /* STCU2 On-Line LBIST Reset Management */
  STCU2_LBUFM_tag LBUFM;               /* STCU2 LBIST Unrecoverable FM Register */
  STCU2_MBSL_tag MBSL;                 /* STCU2 Off-Line MBIST Status Low Register */
  STCU2_MBSM_tag MBSM;                 /* STCU2 Off-Line MBIST Status Medium Register */
  STCU2_MBSH_tag MBSH;                 /* STCU2 Off-Line MBIST Status High Register */
  STCU2_MBEL_tag MBEL;                 /* STCU2 Off-Line MBIST End Flag Low Register */
  STCU2_MBEM_tag MBEM;                 /* STCU2 Off-Line MBIST End Flag Medium Register */
  STCU2_MBEH_tag MBEH;                 /* STCU2 Off-Line MBIST End Flag High Register */
  STCU2_MBSLSW_tag MBSLSW;             /* STCU2 On-Line MBIST Status Low Register */
  STCU2_MBSMSW_tag MBSMSW;             /* STCU2 On-Line MBIST Status Medium Register */
  STCU2_MBSHSW_tag MBSHSW;             /* STCU2 On-Line MBIST Status High Register */
  STCU2_MBELSW_tag MBELSW;             /* STCU2 On-Line MBIST End Flag Low Register */
  STCU2_MBEMSW_tag MBEMSW;             /* STCU2 On-Line MBIST End Flag Medium Register */
  STCU2_MBEHSW_tag MBEHSW;             /* STCU2 On-Line MBIST End Flag High Register */
  STCU2_MBUFML_tag MBUFML;             /* STCU2 MBIST Unrecoverable FM Low Register */
  STCU2_MBUFMM_tag MBUFMM;             /* STCU2 MBIST Unrecoverable FM Medium Register */
  STCU2_MBUFMH_tag MBUFMH;             /* STCU2 MBIST Unrecoverable FM High Register */
  uint8_t STCU2_reserved1[128];
  STCU2_LB_tag LB[6];
  uint8_t STCU2_reserved2[896];
  STCU2_MB_CTRL_tag MB_CTRL[65];       /* STCU2 MBIST Control Register */
};


/* ============================================================================
   =============================== Module: STM ================================
   ============================================================================ */

typedef union STM_CR_union_tag {       /* STM Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t CPS:8;                   /* Counter Prescaler. */
    vuint32_t  :6;
    vuint32_t FRZ:1;                   /* Freeze. */
    vuint32_t TEN:1;                   /* Timer counter Enabled. */
  } B;
} STM_CR_tag;

typedef union STM_CNT_union_tag {      /* STM Count Register */
  vuint32_t R;
  struct {
    vuint32_t CNT:32;                  /* Timer count value used as the time base for all channels. */
  } B;
} STM_CNT_tag;

typedef union STM_CHANNEL_CCR_union_tag { /* STM Channel Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t CEN:1;                   /* Channel Enable */
  } B;
} STM_CHANNEL_CCR_tag;

typedef union STM_CHANNEL_CIR_union_tag { /* STM Channel Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t CIF:1;                   /* Channel Interrupt Flag */
  } B;
} STM_CHANNEL_CIR_tag;

typedef union STM_CHANNEL_CMP_union_tag { /* STM Channel Compare Register */
  vuint32_t R;
  struct {
    vuint32_t CMP:32;                  /* Compare value for channel n. */
  } B;
} STM_CHANNEL_CMP_tag;

typedef struct STM_CHANNEL_struct_tag {
  STM_CHANNEL_CCR_tag CCR;             /* STM Channel Control Register */
  STM_CHANNEL_CIR_tag CIR;             /* STM Channel Interrupt Register */
  STM_CHANNEL_CMP_tag CMP;             /* STM Channel Compare Register */
  uint8_t CHANNEL_reserved0[4];
} STM_CHANNEL_tag;

struct STM_tag {
  STM_CR_tag CR;                       /* STM Control Register */
  STM_CNT_tag CNT;                     /* STM Count Register */
  uint8_t STM_reserved0[8];
  STM_CHANNEL_tag CHANNEL[4];
};


/* ============================================================================
   =============================== Module: SWT ================================
   ============================================================================ */

typedef union SWT_CR_union_tag {       /* SWT Control Register */
  vuint32_t R;
  struct {
    vuint32_t MAP0:1;
    vuint32_t MAP1:1;
    vuint32_t MAP2:1;
    vuint32_t MAP3:1;
    vuint32_t MAP4:1;
    vuint32_t MAP5:1;
    vuint32_t MAP6:1;
    vuint32_t MAP7:1;
    vuint32_t  :13;
    vuint32_t SMD:2;                   /* Service Mode. */
    vuint32_t RIA:1;
    vuint32_t WND:1;
    vuint32_t ITR:1;
    vuint32_t HLK:1;
    vuint32_t SLK:1;
    vuint32_t CSL:1;
    vuint32_t STP:1;
    vuint32_t FRZ:1;
    vuint32_t WEN:1;
  } B;
} SWT_CR_tag;

typedef union SWT_IR_union_tag {       /* SWT Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t TIF:1;                   /* Time-out Interrupt Flag */
  } B;
} SWT_IR_tag;

typedef union SWT_TO_union_tag {       /* SWT Time-out Register */
  vuint32_t R;
  struct {
    vuint32_t WTO:32;
  } B;
} SWT_TO_tag;

typedef union SWT_WN_union_tag {       /* SWT Window Register */
  vuint32_t R;
  struct {
    vuint32_t WST:32;                  /* Window Start Value */
  } B;
} SWT_WN_tag;

typedef union SWT_SR_union_tag {       /* SWT Service Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t WSC:16;                  /* Watchdog Service Code */
  } B;
} SWT_SR_tag;

typedef union SWT_CO_union_tag {       /* SWT Counter Output Register */
  vuint32_t R;
  struct {
    vuint32_t CNT:32;
  } B;
} SWT_CO_tag;

typedef union SWT_SK_union_tag {       /* SWT Service Key Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t SK:16;                   /* Service Key */
  } B;
} SWT_SK_tag;

struct SWT_tag {
  SWT_CR_tag CR;                       /* SWT Control Register */
  SWT_IR_tag IR;                       /* SWT Interrupt Register */
  SWT_TO_tag TO;                       /* SWT Time-out Register */
  SWT_WN_tag WN;                       /* SWT Window Register */
  SWT_SR_tag SR;                       /* SWT Service Register */
  SWT_CO_tag CO;                       /* SWT Counter Output Register */
  SWT_SK_tag SK;                       /* SWT Service Key Register */
};


/* ============================================================================
   =============================== Module: TDM ================================
   ============================================================================ */

typedef union TDM_TDRSR_union_tag {    /* TDR Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t TDRSR5:1;
    vuint32_t TDRSR4:1;
    vuint32_t TDRSR3:1;
    vuint32_t TDRSR2:1;
    vuint32_t TDRSR1:1;
    vuint32_t TDRSR0:1;
  } B;
} TDM_TDRSR_tag;

typedef union TDM_LFPAR_union_tag {    /* Last Flash Programmed Address Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t LFPAR:24;
  } B;
} TDM_LFPAR_tag;

typedef union TDM_DBA_union_tag {      /* Diary Base Address */
  vuint32_t R;
  struct {
    vuint32_t DBA:32;
  } B;
} TDM_DBA_tag;

typedef union TDM_STO_KEY_union_tag {  /* Software Tamper Override Key Region */
  vuint32_t R;
  struct {
    vuint32_t STO_KEY:32;
  } B;
} TDM_STO_KEY_tag;

struct TDM_tag {
  TDM_TDRSR_tag TDRSR;                 /* TDR Status Register */
  TDM_LFPAR_tag LFPAR;                 /* Last Flash Programmed Address Register */
  TDM_DBA_tag DBA;                     /* Diary Base Address */
  uint8_t TDM_reserved0[4];
  TDM_STO_KEY_tag STO_KEY[6];          /* Software Tamper Override Key Region */
};


/* ============================================================================
   =============================== Module: XBAR ===============================
   ============================================================================ */

typedef union XBAR_PORT_PRS_union_tag { /* Priority Registers Slave */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t M7:3;                    /* Master 7 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t  :1;
    vuint32_t M6:3;                    /* Master 6 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t  :1;
    vuint32_t M5:3;                    /* Master 5 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t  :1;
    vuint32_t M4:3;                    /* Master 4 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t  :1;
    vuint32_t M3:3;                    /* Master 3 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t  :1;
    vuint32_t M2:3;                    /* Master 2 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t  :1;
    vuint32_t M1:3;                    /* Master 1 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t  :1;
    vuint32_t M0:3;                    /* Master 0 Priority. Sets the arbitration priority for this port on the associated slave port. */
  } B;
} XBAR_PORT_PRS_tag;

typedef union XBAR_PORT_CRS_union_tag { /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t RO:1;                    /* Read Only */
    vuint32_t HLP:1;                   /* Halt Low Priority */
    vuint32_t  :6;
    vuint32_t HPE7:1;
    vuint32_t HPE6:1;
    vuint32_t HPE5:1;
    vuint32_t HPE4:1;
    vuint32_t HPE3:1;
    vuint32_t HPE2:1;
    vuint32_t HPE1:1;
    vuint32_t HPE0:1;
    vuint32_t  :6;
    vuint32_t ARB:2;                   /* Arbitration Mode */
    vuint32_t  :2;
    vuint32_t PCTL:2;                  /* Parking Control */
    vuint32_t  :1;
    vuint32_t PARK:3;                  /* Park */
  } B;
} XBAR_PORT_CRS_tag;

typedef struct XBAR_PORT_struct_tag {
  XBAR_PORT_PRS_tag PRS;               /* Priority Registers Slave */
  uint8_t PORT_reserved0[12];
  XBAR_PORT_CRS_tag CRS;               /* Control Register */
  uint8_t PORT_reserved1[236];
} XBAR_PORT_tag;

struct XBAR_tag {
  XBAR_PORT_tag PORT[8];
};


/* ============================================================================
   =============================== Module: XBIC ===============================
   ============================================================================ */

typedef union XBIC_MCR_union_tag {     /* XBIC Module Control Register */
  vuint32_t R;
  struct {
    vuint32_t SE0:1;
    vuint32_t SE1:1;
    vuint32_t SE2:1;
    vuint32_t SE3:1;
    vuint32_t SE4:1;
    vuint32_t SE5:1;
    vuint32_t SE6:1;
    vuint32_t SE7:1;
    vuint32_t ME0:1;
    vuint32_t ME1:1;
    vuint32_t ME2:1;
    vuint32_t ME3:1;
    vuint32_t ME4:1;
    vuint32_t ME5:1;
    vuint32_t ME6:1;
    vuint32_t ME7:1;
    vuint32_t  :16;
  } B;
} XBIC_MCR_tag;

typedef union XBIC_EIR_union_tag {     /* XBIC Error Injection Register */
  vuint32_t R;
  struct {
    vuint32_t EIE:1;
    vuint32_t  :16;
    vuint32_t SLV:3;
    vuint32_t MST:4;
    vuint32_t SYN:8;
  } B;
} XBIC_EIR_tag;

typedef union XBIC_ESR_union_tag {     /* XBIC Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t DPSE0:1;
    vuint32_t DPSE1:1;
    vuint32_t DPSE2:1;
    vuint32_t DPSE3:1;
    vuint32_t DPSE4:1;
    vuint32_t DPSE5:1;
    vuint32_t DPSE6:1;
    vuint32_t DPSE7:1;
    vuint32_t DPME0:1;
    vuint32_t DPME1:1;
    vuint32_t DPME2:1;
    vuint32_t DPME3:1;
    vuint32_t DPME4:1;
    vuint32_t DPME5:1;
    vuint32_t DPME6:1;
    vuint32_t DPME7:1;
    vuint32_t SLV:3;
    vuint32_t MST:4;
    vuint32_t SYN:8;
  } B;
} XBIC_ESR_tag;

typedef union XBIC_EAR_union_tag {     /* XBIC Error Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:32;
  } B;
} XBIC_EAR_tag;

struct XBIC_tag {
  XBIC_MCR_tag MCR;                    /* XBIC Module Control Register */
  XBIC_EIR_tag EIR;                    /* XBIC Error Injection Register */
  XBIC_ESR_tag ESR;                    /* XBIC Error Status Register */
  XBIC_EAR_tag EAR;                    /* XBIC Error Address Register */
};


/* ============================================================================
   =============================== Module: eMIOS ==============================
   ============================================================================ */

typedef union eMIOS_MCR_union_tag {    /* eMIOS Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t MDIS:1;                  /* Module Disable bit. */
    vuint32_t FRZ:1;                   /* Freeze bit. */
    vuint32_t GTBE:1;                  /* Global Time Base Enable bit. */
    vuint32_t ETB:1;                   /* External Time Base bit */
    vuint32_t GPREN:1;                 /* Global Prescaler Enable bit. */
    vuint32_t  :6;                     /* Reserved. */
    vuint32_t SRV:4;                   /* Server Time Slot bits. */
    vuint32_t GPRE:8;                  /* Global Prescaler bits. */
    vuint32_t  :8;                     /* Reserved. */
  } B;
} eMIOS_MCR_tag;

typedef union eMIOS_GFLAG_union_tag {  /* eMIOS Global FLAG Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved */
    vuint32_t F23_F16:8;               /* Channel [n] mirrored FLAG bit. */
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t F7_F0:8;                 /* Channel [n] mirrored FLAG bit. */
  } B;
} eMIOS_GFLAG_tag;

typedef union eMIOS_OUDIS_union_tag {  /* eMIOS Output Update Disable register */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t OU23_OU16:8;             /* Channel [n] Output Update Disable bit. */
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t OU7_OU0:8;               /* Channel [n] Output Update Disable bit. */
  } B;
} eMIOS_OUDIS_tag;

typedef union eMIOS_UC_A_union_tag {   /* eMIOS UC A register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t A:24;
  } B;
} eMIOS_UC_A_tag;

typedef union eMIOS_UC_B_union_tag {   /* eMIOS UC B register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t B:24;                    /* See text above register figure. */
  } B;
} eMIOS_UC_B_tag;

typedef union eMIOS_UC_CNT_union_tag { /* eMIOS CNT register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t C:24;                    /* The C field contains the value of the internal counter. */
  } B;
} eMIOS_UC_CNT_tag;

typedef union eMIOS_UC_C_union_tag {   /* eMIOS UC Control register n */
  vuint32_t R;
  struct {
    vuint32_t FREN:1;                  /* Freeze Enable bit. */
    vuint32_t ODIS:1;                  /* Output Disable bit. */
    vuint32_t ODISSL:2;                /* Output Disable select bits. */
    vuint32_t UCPRE:2;                 /* Prescaler bits. */
    vuint32_t UCPREN:1;                /* Prescaler Enable bit. */
    vuint32_t DMA:1;                   /* Direct Memory Access bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t IF:4;                    /* Input Filter bits. */
    vuint32_t FCK:1;                   /* Filter Clock select bit. */
    vuint32_t FEN:1;                   /* FLAG Enable bit. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t FORCMA:1;                /* Force Match A bit. */
    vuint32_t FORCMB:1;                /* Force Match B bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t BSL:2;                   /* Bus Select bits. */
    vuint32_t EDSEL:1;                 /* Edge Selection bit. */
    vuint32_t EDPOL:1;                 /* Edge Polarity bit. */
    vuint32_t MODE:7;                  /* Mode selection bits. */
  } B;
} eMIOS_UC_C_tag;

typedef union eMIOS_UC_S_union_tag {   /* eMIOS UC Status register n */
  vuint32_t R;
  struct {
    vuint32_t OVR:1;                   /* Overrun bit. */
    vuint32_t  :15;                    /* Reserved. */
    vuint32_t OVFL:1;                  /* Overflow bit. */
    vuint32_t  :12;                    /* Reserved. */
    vuint32_t UCIN:1;                  /* Unified Channel Input pin bit. */
    vuint32_t UCOUT:1;                 /* Unified Channel Output pin bit. */
    vuint32_t FLAG:1;                  /* FLAG bit. */
  } B;
} eMIOS_UC_S_tag;

typedef union eMIOS_UC_ALTA_union_tag { /* eMIOS Alternate Address register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t ALTA:24;                 /* See text above register figure. */
  } B;
} eMIOS_UC_ALTA_tag;

typedef struct eMIOS_UC_struct_tag {
  eMIOS_UC_A_tag A;                    /* eMIOS UC A register n */
  eMIOS_UC_B_tag B;                    /* eMIOS UC B register n */
  eMIOS_UC_CNT_tag CNT;                /* eMIOS CNT register n */
  eMIOS_UC_C_tag C;                    /* eMIOS UC Control register n */
  eMIOS_UC_S_tag S;                    /* eMIOS UC Status register n */
  eMIOS_UC_ALTA_tag ALTA;              /* eMIOS Alternate Address register n */
  uint8_t UC_reserved0[8];
} eMIOS_UC_tag;

struct eMIOS_tag {
  eMIOS_MCR_tag MCR;                   /* eMIOS Module Configuration Register */
  eMIOS_GFLAG_tag GFLAG;               /* eMIOS Global FLAG Register */
  eMIOS_OUDIS_tag OUDIS;               /* eMIOS Output Update Disable register */
  uint8_t eMIOS_reserved0[20];
  eMIOS_UC_tag UC[24];
};


/* ============================================================================
   =============================== Module: eSCI ===============================
   ============================================================================ */

typedef union eSCI_BRR_union_tag {     /* Baud Rate Register */
  vuint16_t R;
  struct {
    vuint16_t  :3;
    vuint16_t SBR:13;
  } B;
} eSCI_BRR_tag;

typedef union eSCI_CR1_union_tag {     /* Control Register 1 */
  vuint16_t R;
  struct {
    vuint16_t LOOPS:1;
    vuint16_t  :1;
    vuint16_t RSRC:1;
    vuint16_t M:1;
    vuint16_t WAKE:1;
    vuint16_t  :1;
    vuint16_t PE:1;
    vuint16_t PT:1;
    vuint16_t TIE:1;
    vuint16_t TCIE:1;
    vuint16_t RIE:1;
    vuint16_t ILIE:1;
    vuint16_t TE:1;
    vuint16_t RE:1;
    vuint16_t RWU:1;
    vuint16_t SBK:1;
  } B;
} eSCI_CR1_tag;

typedef union eSCI_CR2_union_tag {     /* Control Register 2 */
  vuint16_t R;
  struct {
    vuint16_t MDIS:1;
    vuint16_t FBR:1;
    vuint16_t BSTP:1;
    vuint16_t BERRIE:1;
    vuint16_t RXDMA:1;
    vuint16_t TXDMA:1;
    vuint16_t BRCL:1;
    vuint16_t TXDIR:1;
    vuint16_t BESM:1;
    vuint16_t BESTP:1;
    vuint16_t RXPOL:1;
    vuint16_t PMSK:1;
    vuint16_t ORIE:1;
    vuint16_t NFIE:1;
    vuint16_t FEIE:1;
    vuint16_t PFIE:1;
  } B;
} eSCI_CR2_tag;

typedef union eSCI_SDR_union_tag {     /* SCI Data Register */
  vuint16_t R;
  struct {
    vuint16_t RN:1;
    vuint16_t TN:1;
    vuint16_t ERR:1;
    vuint16_t  :1;
    vuint16_t RDTD:12;
  } B;
} eSCI_SDR_tag;

typedef union eSCI_IFSR1_union_tag {   /* Interrupt Flag and Status Register 1 */
  vuint16_t R;
  struct {
    vuint16_t TDRE:1;
    vuint16_t TC:1;
    vuint16_t RDRF:1;
    vuint16_t IDLE:1;
    vuint16_t OR:1;
    vuint16_t NF:1;
    vuint16_t FE:1;
    vuint16_t PF:1;
    vuint16_t  :2;
    vuint16_t DACT:1;
    vuint16_t BERR:1;
    vuint16_t WACT:1;
    vuint16_t LACT:1;
    vuint16_t TACT:1;
    vuint16_t RACT:1;
  } B;
} eSCI_IFSR1_tag;

typedef union eSCI_IFSR2_union_tag {   /* Interrupt Flag and Status Register 2 */
  vuint16_t R;
  struct {
    vuint16_t RXRDY:1;
    vuint16_t TXRDY:1;
    vuint16_t LWAKE:1;
    vuint16_t STO:1;
    vuint16_t PBERR:1;
    vuint16_t CERR:1;
    vuint16_t CKERR:1;
    vuint16_t FRC:1;
    vuint16_t  :6;
    vuint16_t UREQ:1;
    vuint16_t OVFL:1;
  } B;
} eSCI_IFSR2_tag;

typedef union eSCI_LCR1_union_tag {    /* LIN Control Register 1 */
  vuint16_t R;
  struct {
    vuint16_t LRES:1;
    vuint16_t WU:1;
    vuint16_t WUD:2;
    vuint16_t  :2;
    vuint16_t PRTY:1;
    vuint16_t LIN:1;
    vuint16_t RXIE:1;
    vuint16_t TXIE:1;
    vuint16_t WUIE:1;
    vuint16_t STIE:1;
    vuint16_t PBIE:1;
    vuint16_t CIE:1;
    vuint16_t CKIE:1;
    vuint16_t FCIE:1;
  } B;
} eSCI_LCR1_tag;

typedef union eSCI_LCR2_union_tag {    /* LIN Control Register 2 */
  vuint16_t R;
  struct {
    vuint16_t  :6;
    vuint16_t UQIE:1;
    vuint16_t OFIE:1;
    vuint16_t  :8;
  } B;
} eSCI_LCR2_tag;

typedef union eSCI_LTR_union_tag {     /* LIN Transmit Register */
  vuint8_t R;
  struct {
    vuint8_t DATA:8;
  } B;
} eSCI_LTR_tag;

typedef union eSCI_LRR_union_tag {     /* LIN Receive Register */
  vuint8_t R;
  struct {
    vuint8_t D:8;
  } B;
} eSCI_LRR_tag;

typedef union eSCI_LPR_union_tag {     /* LIN CRC Polynomial Register */
  vuint16_t R;
  struct {
    vuint16_t P:16;
  } B;
} eSCI_LPR_tag;

typedef union eSCI_CR3_union_tag {     /* Control Register 3 */
  vuint16_t R;
  struct {
    vuint16_t  :4;
    vuint16_t EROE:1;
    vuint16_t ERFE:1;
    vuint16_t ERPE:1;
    vuint16_t M2:1;
    vuint16_t  :8;
  } B;
} eSCI_CR3_tag;

struct eSCI_tag {
  eSCI_BRR_tag BRR;                    /* Baud Rate Register */
  eSCI_CR1_tag CR1;                    /* Control Register 1 */
  eSCI_CR2_tag CR2;                    /* Control Register 2 */
  eSCI_SDR_tag SDR;                    /* SCI Data Register */
  eSCI_IFSR1_tag IFSR1;                /* Interrupt Flag and Status Register 1 */
  eSCI_IFSR2_tag IFSR2;                /* Interrupt Flag and Status Register 2 */
  eSCI_LCR1_tag LCR1;                  /* LIN Control Register 1 */
  eSCI_LCR2_tag LCR2;                  /* LIN Control Register 2 */
  eSCI_LTR_tag LTR;                    /* LIN Transmit Register */
  uint8_t eSCI_reserved0[3];
  eSCI_LRR_tag LRR;                    /* LIN Receive Register */
  uint8_t eSCI_reserved1[3];
  eSCI_LPR_tag LPR;                    /* LIN CRC Polynomial Register */
  eSCI_CR3_tag CR3;                    /* Control Register 3 */
};


/* ============================================================================
   =============================== Module: eTPU_CCCR ==========================
   ============================================================================ */

typedef union eTPU_CCCR_ENG1_C_CR_union_tag { /* eTPU Channel n Configuration Register for Engine 1 */
  vuint32_t R;
  struct {
    vuint32_t CIE:1;                   /* Channel Interrupt Enable (see the eTPU Channel Interrupt Enable Register (ETPUCIER)). */
    vuint32_t DTRE:1;                  /* Channel Data Transfer Request Enable (see the "Channel Interrupt and Data Transfer Requests" section). */
    vuint32_t CPR:2;                   /* Channel Priority. */
    vuint32_t T4DIS:1;                 /* T4 channel action Disable. */
    vuint32_t SSMAE:1;                 /* Shared Subsystem Microengine Access Enable. */
    vuint32_t ETPD:1;                  /* Entry Table Pin Direction. */
    vuint32_t ETCS:1;                  /* Entry Table Condition Select. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t CFS:5;                   /* Channel Function Select. */
    vuint32_t ODIS:1;                  /* Output Disable. */
    vuint32_t OPOL:1;                  /* Output Polarity. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t CPBA:11;                 /* Channel n Parameter Base Address. */
  } B;
} eTPU_CCCR_ENG1_C_CR_tag;

typedef union eTPU_CCCR_ENG1_C_SCR_union_tag { /* eTPU Channel n Status Control Register for Engine 1 */
  vuint32_t R;
  struct {
    vuint32_t CIS:1;                   /* Channel Interrupt Status. */
    vuint32_t CIOS:1;                  /* Channel Interrupt Overflow Status. */
    vuint32_t  :6;                     /* Reserved. */
    vuint32_t DTRS:1;                  /* Data Transfer Request Status. */
    vuint32_t DTROS:1;                 /* Data Transfer Request Overflow Status. */
    vuint32_t  :6;                     /* Reserved. */
    vuint32_t IPS:1;                   /* Channel Input Pin State. */
    vuint32_t OPS:1;                   /* Channel Output Pin State. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t  :11;                    /* Reserved. */
    vuint32_t FM:2;                    /* Channel Function Mode. */
  } B;
} eTPU_CCCR_ENG1_C_SCR_tag;

typedef union eTPU_CCCR_ENG1_C_HSRR_union_tag { /* eTPU Channel n Host Service Request Register for Engine 1 */
  vuint32_t R;
  struct {
    vuint32_t  :29;                    /* Reserved. */
    vuint32_t HSR:3;                   /* Host Service Request */
  } B;
} eTPU_CCCR_ENG1_C_HSRR_tag;

typedef struct eTPU_CCCR_ENG1_C_struct_tag {
  eTPU_CCCR_ENG1_C_CR_tag CR;          /* eTPU Channel n Configuration Register for Engine 1 */
  eTPU_CCCR_ENG1_C_SCR_tag SCR;        /* eTPU Channel n Status Control Register for Engine 1 */
  eTPU_CCCR_ENG1_C_HSRR_tag HSRR;      /* eTPU Channel n Host Service Request Register for Engine 1 */
  uint8_t ENG1_C_reserved0[4];
} eTPU_CCCR_ENG1_C_tag;

typedef union eTPU_CCCR_ENG2_C_CR_union_tag { /* eTPU Channel n Configuration Register for Engine 2 */
  vuint32_t R;
  struct {
    vuint32_t CIE:1;                   /* Channel Interrupt Enable (see the Channel Interrupts ad Data Transfer Requests section). */
    vuint32_t DTRE:1;                  /* Channel Data Transfer Request Enable (see the "Channel Interrupt and Data Transfer Requests" section). */
    vuint32_t CPR:2;                   /* Channel Priority. */
    vuint32_t T4DIS:1;                 /* T4 channel action Disable. */
    vuint32_t SSMAE:1;                 /* Shared Subsystem Microengine Access Enable. */
    vuint32_t ETPD:1;                  /* Entry Table Pin Direction. */
    vuint32_t ETCS:1;                  /* Entry Table Condition Select. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t CFS:5;                   /* Channel Function Select. */
    vuint32_t ODIS:1;                  /* Output Disable. */
    vuint32_t OPOL:1;                  /* Output Polarity. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t CPBA:11;                 /* Channel n Parameter Base Address. */
  } B;
} eTPU_CCCR_ENG2_C_CR_tag;

typedef union eTPU_CCCR_ENG2_C_SCR_union_tag { /* eTPU Channel n Status Control Register for Engine 2 */
  vuint32_t R;
  struct {
    vuint32_t CIS:1;                   /* Channel Interrupt Status. */
    vuint32_t CIOS:1;                  /* Channel Interrupt Overflow Status. */
    vuint32_t  :6;                     /* Reserved. */
    vuint32_t DTRS:1;                  /* Data Transfer Request Status. */
    vuint32_t DTROS:1;                 /* Data Transfer Request Overflow Status. */
    vuint32_t  :6;                     /* Reserved. */
    vuint32_t IPS:1;                   /* Channel Input Pin State. */
    vuint32_t OPS:1;                   /* Channel Output Pin State. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t  :11;                    /* Reserved. */
    vuint32_t FM:2;                    /* Channel Function Mode. */
  } B;
} eTPU_CCCR_ENG2_C_SCR_tag;

typedef union eTPU_CCCR_ENG2_C_HSRR_union_tag { /* eTPU Channel n Host Service Request Register for Engine 2 */
  vuint32_t R;
  struct {
    vuint32_t  :29;                    /* Reserved. */
    vuint32_t HSR:3;                   /* Host Service Request */
  } B;
} eTPU_CCCR_ENG2_C_HSRR_tag;

typedef struct eTPU_CCCR_ENG2_C_struct_tag {
  eTPU_CCCR_ENG2_C_CR_tag CR;          /* eTPU Channel n Configuration Register for Engine 2 */
  eTPU_CCCR_ENG2_C_SCR_tag SCR;        /* eTPU Channel n Status Control Register for Engine 2 */
  eTPU_CCCR_ENG2_C_HSRR_tag HSRR;      /* eTPU Channel n Host Service Request Register for Engine 2 */
  uint8_t ENG2_C_reserved0[4];
} eTPU_CCCR_ENG2_C_tag;

struct eTPU_CCCR_tag {
  uint8_t eTPU_CCCR_reserved0[1024];
  eTPU_CCCR_ENG1_C_tag ENG1_C[32];
  uint8_t eTPU_CCCR_reserved1[512];
  eTPU_CCCR_ENG2_C_tag ENG2_C[32];
};


/* ============================================================================
   =============================== Module: eTPU_ER ============================
   ============================================================================ */

typedef union eTPU_ER_WDTR_ENG1_union_tag { /* eTPU Watchdog Timer Register for Engine 1 */
  vuint32_t R;
  struct {
    vuint32_t WDM:2;                   /* Watchdog Mode. */
    vuint32_t  :1;
    vuint32_t WMO:1;                   /* Watchdog Monitor Operation. */
    vuint32_t  :12;
    vuint32_t WDCNT:16;                /* Watchdog Count. */
  } B;
} eTPU_ER_WDTR_ENG1_tag;

typedef union eTPU_ER_IDLER_ENG1_union_tag { /* eTPU Idle Register for Engine 1 */
  vuint32_t R;
  struct {
    vuint32_t IDLE_CNT:31;             /* Idle Count. */
    vuint32_t ICLR:1;                  /* Idle Clear. */
  } B;
} eTPU_ER_IDLER_ENG1_tag;

typedef union eTPU_ER_WDTR_ENG2_union_tag { /* eTPU Watchdog Timer Register for Engine 2 */
  vuint32_t R;
  struct {
    vuint32_t WDM:2;                   /* Watchdog Mode. */
    vuint32_t  :1;
    vuint32_t WMO:1;                   /* Watchdog Monitor Operation. */
    vuint32_t  :12;
    vuint32_t WDCNT:16;                /* Watchdog Count. */
  } B;
} eTPU_ER_WDTR_ENG2_tag;

typedef union eTPU_ER_IDLER_ENG2_union_tag { /* eTPU Idle Register for Engine 2 */
  vuint32_t R;
  struct {
    vuint32_t IDLE_CNT:31;             /* Idle Count. */
    vuint32_t ICLR:1;                  /* Idle Clear. */
  } B;
} eTPU_ER_IDLER_ENG2_tag;

struct eTPU_ER_tag {
  uint8_t eTPU_ER_reserved0[96];
  eTPU_ER_WDTR_ENG1_tag WDTR_ENG1;     /* eTPU Watchdog Timer Register for Engine 1 */
  uint8_t eTPU_ER_reserved1[4];
  eTPU_ER_IDLER_ENG1_tag IDLER_ENG1;   /* eTPU Idle Register for Engine 1 */
  uint8_t eTPU_ER_reserved2[4];
  eTPU_ER_WDTR_ENG2_tag WDTR_ENG2;     /* eTPU Watchdog Timer Register for Engine 2 */
  uint8_t eTPU_ER_reserved3[4];
  eTPU_ER_IDLER_ENG2_tag IDLER_ENG2;   /* eTPU Idle Register for Engine 2 */
};


/* ============================================================================
   =============================== Module: eTPU_GCR ===========================
   ============================================================================ */

typedef union eTPU_GCR_CISR_ENG1_union_tag { /* eTPU Channel Interrupt Status Register for Engine 1 */
  vuint32_t R;
  struct {
    vuint32_t CISn:32;                 /* Channel n Interrupt Status. */
  } B;
} eTPU_GCR_CISR_ENG1_tag;

typedef union eTPU_GCR_CISR_ENG2_union_tag { /* eTPU Channel Interrupt Status Register for Engine 2 */
  vuint32_t R;
  struct {
    vuint32_t CISn:32;                 /* Channel n Interrupt Status. */
  } B;
} eTPU_GCR_CISR_ENG2_tag;

typedef union eTPU_GCR_CDTRSR_ENG1_union_tag { /* eTPU Channel Data Transfer Request Status Register for Engine 1 */
  vuint32_t R;
  struct {
    vuint32_t DTRSn:32;                /* Channel n Data Transfer Request Status. */
  } B;
} eTPU_GCR_CDTRSR_ENG1_tag;

typedef union eTPU_GCR_CDTRSR_ENG2_union_tag { /* eTPU Channel Data Transfer Request Status Register for Engine 2 */
  vuint32_t R;
  struct {
    vuint32_t DTRSn:32;                /* Channel n Data Transfer Request Status. */
  } B;
} eTPU_GCR_CDTRSR_ENG2_tag;

typedef union eTPU_GCR_CIOSR_ENG1_union_tag { /* eTPU Channel Interrupt Overflow Status Register for Engine 1 */
  vuint32_t R;
  struct {
    vuint32_t CIOSn:32;                /* Channel n Interrupt Overflow Status */
  } B;
} eTPU_GCR_CIOSR_ENG1_tag;

typedef union eTPU_GCR_CIOSR_ENG2_union_tag { /* eTPU Channel Interrupt Overflow Status Register for Engine 2 */
  vuint32_t R;
  struct {
    vuint32_t CIOSn:32;                /* Channel n Interrupt Overflow Status */
  } B;
} eTPU_GCR_CIOSR_ENG2_tag;

typedef union eTPU_GCR_CDTROSR_ENG1_union_tag { /* eTPU Channel Data Transfer Request Overflow Status Register for Engine 1 */
  vuint32_t R;
  struct {
    vuint32_t DTROSn:32;               /* Channel n Data Transfer Request Overflow Status. */
  } B;
} eTPU_GCR_CDTROSR_ENG1_tag;

typedef union eTPU_GCR_CDTROSR_ENG2_union_tag { /* eTPU Channel Data Transfer Request Overflow Status Register for Engine 2 */
  vuint32_t R;
  struct {
    vuint32_t DTROSn:32;               /* Channel n Data Transfer Request Overflow Status. */
  } B;
} eTPU_GCR_CDTROSR_ENG2_tag;

typedef union eTPU_GCR_CIER_ENG1_union_tag { /* eTPU Channel Interrupt Enable Register for Engine 1 */
  vuint32_t R;
  struct {
    vuint32_t CIEn:32;                 /* Channel n Interrupt Enable. */
  } B;
} eTPU_GCR_CIER_ENG1_tag;

typedef union eTPU_GCR_CIER_ENG2_union_tag { /* eTPU Channel Interrupt Enable Register for Engine 2 */
  vuint32_t R;
  struct {
    vuint32_t CIEn:32;                 /* Channel n Interrupt Enable. */
  } B;
} eTPU_GCR_CIER_ENG2_tag;

typedef union eTPU_GCR_CDTRER_ENG1_union_tag { /* eTPU Channel Data Transfer Request Enable Register for Engine 1 */
  vuint32_t R;
  struct {
    vuint32_t DTREn:32;                /* Channel n Data Transfer Request Enable. */
  } B;
} eTPU_GCR_CDTRER_ENG1_tag;

typedef union eTPU_GCR_CDTRER_ENG2_union_tag { /* eTPU Channel Data Transfer Request Enable Register for Engine 2 */
  vuint32_t R;
  struct {
    vuint32_t DTREn:32;                /* Channel n Data Transfer Request Enable. */
  } B;
} eTPU_GCR_CDTRER_ENG2_tag;

typedef union eTPU_GCR_WDSR_ENG1_union_tag { /* eTPU Watchdog Status Register for Engine 1 */
  vuint32_t R;
  struct {
    vuint32_t WDSn:32;                 /* Channel n Watchdog Status. For details about Watchdog mechanism, see the Watchdog section. */
  } B;
} eTPU_GCR_WDSR_ENG1_tag;

typedef union eTPU_GCR_WDSR_ENG2_union_tag { /* eTPU Watchdog Status Register for Engine 2 */
  vuint32_t R;
  struct {
    vuint32_t WDSn:32;                 /* Channel n Watchdog Status. For details about Watchdog mechanism, see the Watchdog section. */
  } B;
} eTPU_GCR_WDSR_ENG2_tag;

typedef union eTPU_GCR_CPSSR_ENG1_union_tag { /* eTPU Channel Pending Service Status Register for Engine 1 */
  vuint32_t R;
  struct {
    vuint32_t SRn:32;                  /* Pending Service Request n. */
  } B;
} eTPU_GCR_CPSSR_ENG1_tag;

typedef union eTPU_GCR_CPSSR_ENG2_union_tag { /* eTPU Channel Pending Service Status Register for Engine 2 */
  vuint32_t R;
  struct {
    vuint32_t SRn:32;                  /* Pending Service Request n. */
  } B;
} eTPU_GCR_CPSSR_ENG2_tag;

typedef union eTPU_GCR_CSSR_ENG1_union_tag { /* eTPU Channel Service Status Register for Engine 1 */
  vuint32_t R;
  struct {
    vuint32_t SSn:32;                  /* Service Status n. */
  } B;
} eTPU_GCR_CSSR_ENG1_tag;

typedef union eTPU_GCR_CSSR_ENG2_union_tag { /* eTPU Channel Service Status Register for Engine 2 */
  vuint32_t R;
  struct {
    vuint32_t SSn:32;                  /* Service Status n. */
  } B;
} eTPU_GCR_CSSR_ENG2_tag;

struct eTPU_GCR_tag {
  uint8_t eTPU_GCR_reserved0[512];
  eTPU_GCR_CISR_ENG1_tag CISR_ENG1;    /* eTPU Channel Interrupt Status Register for Engine 1 */
  eTPU_GCR_CISR_ENG2_tag CISR_ENG2;    /* eTPU Channel Interrupt Status Register for Engine 2 */
  uint8_t eTPU_GCR_reserved1[8];
  eTPU_GCR_CDTRSR_ENG1_tag CDTRSR_ENG1; /* eTPU Channel Data Transfer Request Status Register for Engine 1 */
  eTPU_GCR_CDTRSR_ENG2_tag CDTRSR_ENG2; /* eTPU Channel Data Transfer Request Status Register for Engine 2 */
  uint8_t eTPU_GCR_reserved2[8];
  eTPU_GCR_CIOSR_ENG1_tag CIOSR_ENG1;  /* eTPU Channel Interrupt Overflow Status Register for Engine 1 */
  eTPU_GCR_CIOSR_ENG2_tag CIOSR_ENG2;  /* eTPU Channel Interrupt Overflow Status Register for Engine 2 */
  uint8_t eTPU_GCR_reserved3[8];
  eTPU_GCR_CDTROSR_ENG1_tag CDTROSR_ENG1; /* eTPU Channel Data Transfer Request Overflow Status Register for Engine 1 */
  eTPU_GCR_CDTROSR_ENG2_tag CDTROSR_ENG2; /* eTPU Channel Data Transfer Request Overflow Status Register for Engine 2 */
  uint8_t eTPU_GCR_reserved4[8];
  eTPU_GCR_CIER_ENG1_tag CIER_ENG1;    /* eTPU Channel Interrupt Enable Register for Engine 1 */
  eTPU_GCR_CIER_ENG2_tag CIER_ENG2;    /* eTPU Channel Interrupt Enable Register for Engine 2 */
  uint8_t eTPU_GCR_reserved5[8];
  eTPU_GCR_CDTRER_ENG1_tag CDTRER_ENG1; /* eTPU Channel Data Transfer Request Enable Register for Engine 1 */
  eTPU_GCR_CDTRER_ENG2_tag CDTRER_ENG2; /* eTPU Channel Data Transfer Request Enable Register for Engine 2 */
  uint8_t eTPU_GCR_reserved6[8];
  eTPU_GCR_WDSR_ENG1_tag WDSR_ENG1;    /* eTPU Watchdog Status Register for Engine 1 */
  eTPU_GCR_WDSR_ENG2_tag WDSR_ENG2;    /* eTPU Watchdog Status Register for Engine 2 */
  uint8_t eTPU_GCR_reserved7[24];
  eTPU_GCR_CPSSR_ENG1_tag CPSSR_ENG1;  /* eTPU Channel Pending Service Status Register for Engine 1 */
  eTPU_GCR_CPSSR_ENG2_tag CPSSR_ENG2;  /* eTPU Channel Pending Service Status Register for Engine 2 */
  uint8_t eTPU_GCR_reserved8[8];
  eTPU_GCR_CSSR_ENG1_tag CSSR_ENG1;    /* eTPU Channel Service Status Register for Engine 1 */
  eTPU_GCR_CSSR_ENG2_tag CSSR_ENG2;    /* eTPU Channel Service Status Register for Engine 2 */
};


/* ============================================================================
   =============================== Module: eTPU_LMR ===========================
   ============================================================================ */

typedef union eTPU_LMR_ENG1_LM_CR_union_tag { /* eTPU Latency Monitor Configuration Register for Engine 1 */
  vuint32_t R;
  struct {
    vuint32_t LMM:2;                   /* Latency Monitor Mode. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t SRSEL:3;                 /* Service Request Selection */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t MONCHAN:5;               /* Monitored Channel. */
    vuint32_t MAXLAT:16;               /* Maximum Latency. */
  } B;
} eTPU_LMR_ENG1_LM_CR_tag;

typedef union eTPU_LMR_ENG1_LM_MR_union_tag { /* eTPU Latency Monitor Measure Register for Engine 1 */
  vuint32_t R;
  struct {
    vuint32_t  :16;                    /* Reserved. */
    vuint32_t LATENCY:15;              /* Latency measurement. */
    vuint32_t LTC:1;                   /* Latency measurement clear */
  } B;
} eTPU_LMR_ENG1_LM_MR_tag;

typedef struct eTPU_LMR_ENG1_LM_struct_tag {
  eTPU_LMR_ENG1_LM_CR_tag CR;          /* eTPU Latency Monitor Configuration Register for Engine 1 */
  eTPU_LMR_ENG1_LM_MR_tag MR;          /* eTPU Latency Monitor Measure Register for Engine 1 */
} eTPU_LMR_ENG1_LM_tag;

typedef union eTPU_LMR_ENG2_LM_CR_union_tag { /* eTPU Latency Monitor Configuration Register for Engine 2 */
  vuint32_t R;
  struct {
    vuint32_t LMM:2;                   /* Latency Monitor Mode. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t SRSEL:3;                 /* Service Request Selection */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t MONCHAN:5;               /* Monitored Channel. */
    vuint32_t MAXLAT:16;               /* Maximum Latency. */
  } B;
} eTPU_LMR_ENG2_LM_CR_tag;

typedef union eTPU_LMR_ENG2_LM_MR_union_tag { /* eTPU Latency Monitor Measure Register for Engine 2 */
  vuint32_t R;
  struct {
    vuint32_t  :16;                    /* Reserved. */
    vuint32_t LATENCY:15;              /* Latency measurement. */
    vuint32_t LTC:1;                   /* Latency measurement clear. */
  } B;
} eTPU_LMR_ENG2_LM_MR_tag;

typedef struct eTPU_LMR_ENG2_LM_struct_tag {
  eTPU_LMR_ENG2_LM_CR_tag CR;          /* eTPU Latency Monitor Configuration Register for Engine 2 */
  eTPU_LMR_ENG2_LM_MR_tag MR;          /* eTPU Latency Monitor Measure Register for Engine 2 */
} eTPU_LMR_ENG2_LM_tag;

struct eTPU_LMR_tag {
  uint8_t eTPU_LMR_reserved0[128];
  eTPU_LMR_ENG1_LM_tag ENG1_LM[6];
  uint8_t eTPU_LMR_reserved1[16];
  eTPU_LMR_ENG2_LM_tag ENG2_LM[6];
};


/* ============================================================================
   =============================== Module: eTPU_MESR ==========================
   ============================================================================ */

typedef union eTPU_MESR_MECR_union_tag { /* eTPU Memory Error Control Register */
  vuint32_t R;
  struct {
    vuint32_t FME:1;                   /* Field Modification Enable. */
    vuint32_t  :14;                    /* Reserved. */
    vuint32_t MECIE:1;                 /* Memory Error Correction Interrupt Enable. */
    vuint32_t HDEIE:1;                 /* Host Data Error Injection Enable */
    vuint32_t MDEIE:1;                 /* Microengine(s) Data Error Injection Enable. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t DTEND:1;                 /* Thread End on Data Non-correctable Error. */
    vuint32_t DRDIS:1;                 /* Data Error Report Disable. */
    vuint32_t DEDD:1;                  /* Data Error Detection Disable. */
    vuint32_t CEIE:1;                  /* Code Error Injection Enable. */
    vuint32_t  :4;                     /* Reserved. */
    vuint32_t CTEND:1;                 /* Thread End on Code Non-correctable Error. */
    vuint32_t CRDIS:1;                 /* Code Error Report Disable. */
    vuint32_t CEDD:1;                  /* Code Error Detection Disable. */
  } B;
} eTPU_MESR_MECR_tag;

typedef union eTPU_MESR_DEIAR_union_tag { /* eTPU Data Error Injection Address Register */
  vuint32_t R;
  struct {
    vuint32_t  :18;                    /* Reserved. */
    vuint32_t INJ_ADDR:12;             /* Injection Address. */
    vuint32_t  :2;                     /* Reserved. */
  } B;
} eTPU_MESR_DEIAR_tag;

typedef union eTPU_MESR_DEIDPR_union_tag { /* eTPU Data Error Injection Data Pattern Register */
  vuint32_t R;
  struct {
    vuint32_t DFLIP:32;                /* Data Flip bits. */
  } B;
} eTPU_MESR_DEIDPR_tag;

typedef union eTPU_MESR_DEIPPR_union_tag { /* eTPU Data Error Injection Parity Pattern Register */
  vuint32_t R;
  struct {
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t PFLIP_19_15:5;           /* Parity Flip bits. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t PFLIP_14_10:5;           /* Parity Flip bits. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t PFLIP_9_5:5;             /* Parity Flip bits. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t PFLIP_4_0:5;             /* Parity Flip bits. */
  } B;
} eTPU_MESR_DEIPPR_tag;

typedef union eTPU_MESR_DERAR_union_tag { /* eTPU Data Error Report Address Register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ACC:2;               /* Error Access Source Indication. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t ERR_CHANNEL:5;           /* Error Channel Access Indication. */
    vuint32_t  :10;                    /* Reserved. */
    vuint32_t ERR_ADDR:12;             /* Error Address. */
    vuint32_t  :2;                     /* Reserved. */
  } B;
} eTPU_MESR_DERAR_tag;

typedef union eTPU_MESR_DERDR_union_tag { /* eTPU Data Error Report Data Register */
  vuint32_t R;
  struct {
    vuint32_t DATA:32;                 /* DATA. */
  } B;
} eTPU_MESR_DERDR_tag;

typedef union eTPU_MESR_DERSR_union_tag { /* eTPU Data Error Report Syndrome Register */
  vuint32_t R;
  struct {
    vuint32_t BE3:1;                   /* Byte Enable 3. */
    vuint32_t  :2;                     /* Reserved. */
    vuint32_t SYND3:5;                 /* Error Syndrome 3. */
    vuint32_t BE2:1;                   /* Byte Enable 2. */
    vuint32_t  :2;                     /* Reserved. */
    vuint32_t SYND2:5;                 /* Error Syndrome 2. */
    vuint32_t BE1:1;                   /* Byte Enable 1. */
    vuint32_t  :2;                     /* Reserved. */
    vuint32_t SYND1:5;                 /* Error Syndrome 1. */
    vuint32_t BE0:1;                   /* Byte Enable 0. */
    vuint32_t  :2;                     /* Reserved. */
    vuint32_t SYND0:5;                 /* Error Syndrome 0. */
  } B;
} eTPU_MESR_DERSR_tag;

typedef union eTPU_MESR_MESR_union_tag { /* eTPU Memory Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t DCERR:1;                 /* Data Correctable Error flag. */
    vuint32_t  :6;                     /* Reserved. */
    vuint32_t DCOVR:1;                 /* Data Correctable Overrun flag. */
    vuint32_t CCERR:1;                 /* Code Error flag. */
    vuint32_t  :6;                     /* Reserved. */
    vuint32_t CCOVR:1;                 /* Code Correctable Overrun flag */
    vuint32_t DNCERR:1;                /* Data Non-Correctable Error flag */
    vuint32_t  :6;                     /* Reserved. */
    vuint32_t DNCOVR:1;                /* Data Non-Correctable Overrun flag. */
    vuint32_t CNCERR:1;                /* Code Non-Correctable Error flag */
    vuint32_t  :6;                     /* Reserved. */
    vuint32_t CNCOVR:1;                /* Code Non-Correctable Overrun flag. */
  } B;
} eTPU_MESR_MESR_tag;

typedef union eTPU_MESR_CEIAR_union_tag { /* eTPU Code Error Injection Address Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;                    /* Reserved. */
    vuint32_t INJ_ADDR:14;             /* Injection Address. */
    vuint32_t  :2;                     /* Reserved. */
  } B;
} eTPU_MESR_CEIAR_tag;

typedef union eTPU_MESR_CEIDPR_union_tag { /* eTPU Code Error Injection Data Pattern Register */
  vuint32_t R;
  struct {
    vuint32_t DFLIP:32;                /* Data Flip bits. */
  } B;
} eTPU_MESR_CEIDPR_tag;

typedef union eTPU_MESR_CEIPPR_union_tag { /* eTPU Code Error Injection Parity Pattern Register */
  vuint32_t R;
  struct {
    vuint32_t  :25;                    /* Reserved. */
    vuint32_t PFLIP:7;                 /* Parity Flip bits. */
  } B;
} eTPU_MESR_CEIPPR_tag;

typedef union eTPU_MESR_CERAR_union_tag { /* eTPU Code Error Report Address Register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ACC:2;               /* Error Access Source Indication. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t ERR_CHANNEL:5;           /* Error Channel Access Indication. */
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t ERR_ADDR:14;             /* Error Address. */
    vuint32_t  :2;                     /* Reserved. */
  } B;
} eTPU_MESR_CERAR_tag;

typedef union eTPU_MESR_CERDR_union_tag { /* eTPU Code Error Report Data Register */
  vuint32_t R;
  struct {
    vuint32_t CODE:32;                 /* CODE[31-0]. */
  } B;
} eTPU_MESR_CERDR_tag;

typedef union eTPU_MESR_CERSR_union_tag { /* eTPU Code Error Report Syndrome Register */
  vuint32_t R;
  struct {
    vuint32_t  :25;                    /* Reserved. */
    vuint32_t SYND:7;                  /* Error Syndrome. */
  } B;
} eTPU_MESR_CERSR_tag;

typedef union eTPU_MESR_CEFR_union_tag { /* eTPU Code Error Fix Register */
  vuint32_t R;
  struct {
    vuint32_t CFIXM:2;                 /* Code Fix Mode. */
    vuint32_t  :14;                    /* Reserved. */
    vuint32_t CFIX_ADDR:14;            /* Code Fix Address. */
    vuint32_t  :2;                     /* Reserved. */
  } B;
} eTPU_MESR_CEFR_tag;

struct eTPU_MESR_tag {
  uint8_t eTPU_MESR_reserved0[256];
  eTPU_MESR_MECR_tag MECR;             /* eTPU Memory Error Control Register */
  eTPU_MESR_DEIAR_tag DEIAR;           /* eTPU Data Error Injection Address Register */
  eTPU_MESR_DEIDPR_tag DEIDPR;         /* eTPU Data Error Injection Data Pattern Register */
  eTPU_MESR_DEIPPR_tag DEIPPR;         /* eTPU Data Error Injection Parity Pattern Register */
  eTPU_MESR_DERAR_tag DERAR;           /* eTPU Data Error Report Address Register */
  eTPU_MESR_DERDR_tag DERDR;           /* eTPU Data Error Report Data Register */
  eTPU_MESR_DERSR_tag DERSR;           /* eTPU Data Error Report Syndrome Register */
  uint8_t eTPU_MESR_reserved1[4];
  eTPU_MESR_MESR_tag MESR;             /* eTPU Memory Error Status Register */
  eTPU_MESR_CEIAR_tag CEIAR;           /* eTPU Code Error Injection Address Register */
  eTPU_MESR_CEIDPR_tag CEIDPR;         /* eTPU Code Error Injection Data Pattern Register */
  eTPU_MESR_CEIPPR_tag CEIPPR;         /* eTPU Code Error Injection Parity Pattern Register */
  eTPU_MESR_CERAR_tag CERAR;           /* eTPU Code Error Report Address Register */
  eTPU_MESR_CERDR_tag CERDR;           /* eTPU Code Error Report Data Register */
  eTPU_MESR_CERSR_tag CERSR;           /* eTPU Code Error Report Syndrome Register */
  eTPU_MESR_CEFR_tag CEFR;             /* eTPU Code Error Fix Register */
};


/* ============================================================================
   =============================== Module: eTPU_SCR ===========================
   ============================================================================ */

typedef union eTPU_SCR_MCR_union_tag { /* eTPU Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t GEC:1;                   /* Global Exception Clear. */
    vuint32_t SDMERR:1;                /* SDM Read Error */
    vuint32_t WDTO1:1;                 /* Watchdog 1 Timeout. */
    vuint32_t WDTO2:1;                 /* Watchdog 2 Timeout. */
    vuint32_t MGE1:1;                  /* Microcode Global Exception Engine 1. */
    vuint32_t MGE2:1;                  /* Microcode Global Exception Engine 2. */
    vuint32_t ILF1:1;                  /* Illegal Instruction Flag for Engine 1. */
    vuint32_t ILF2:1;                  /* Illegal Instruction Flag for Engine 2. */
    vuint32_t SSAERR:1;                /* Shared Subsystem Access Error. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t SCMSIZE:5;               /* SCM Size */
    vuint32_t LTO1:1;                  /* Latency Timeout for Engine 1. */
    vuint32_t LTO2:1;                  /* Latency Timeout for Engine 2. */
    vuint32_t  :2;                     /* Reserved. */
    vuint32_t SCMMISC:1;               /* SCM MISC Complete flag. */
    vuint32_t SCMMISF:1;               /* SCM MISC Flag. */
    vuint32_t SCMMISEN:1;              /* SCM MISC Enable. */
    vuint32_t SCMERR:1;                /* SCM Read Error. */
    vuint32_t  :1;
    vuint32_t VIS:1;                   /* SCM Visibility Bit. */
    vuint32_t  :5;                     /* Reserved. */
    vuint32_t GTBE:1;                  /* Global Time Base Enable. */
  } B;
} eTPU_SCR_MCR_tag;

typedef union eTPU_SCR_CDCR_union_tag { /* eTPU Coherent Dual-Parameter Controller Register */
  vuint32_t R;
  struct {
    vuint32_t STS:1;                   /* Start Bit. */
    vuint32_t CTBASE:5;                /* Channel Transfer Base. */
    vuint32_t PBBASE:10;               /* Parameter Buffer Base Address. */
    vuint32_t PWIDTH:1;                /* Parameter Width Selection. */
    vuint32_t PARM0:7;                 /* Channel Parameter number 0. */
    vuint32_t WR:1;                    /* Read/Write selection. */
    vuint32_t PARM1:7;                 /* Channel Parameter number 1. */
  } B;
} eTPU_SCR_CDCR_tag;

typedef union eTPU_SCR_MISCCMPR_union_tag { /* eTPU MISC Compare Register */
  vuint32_t R;
  struct {
    vuint32_t ETPUMISCCMP:32;          /* Expected Multiple Input Signature Register value. */
  } B;
} eTPU_SCR_MISCCMPR_tag;

typedef union eTPU_SCR_SCMOFFDATAR_union_tag { /* eTPU SCM Off-range Data Register */
  vuint32_t R;
  struct {
    vuint32_t ETPUSCMOFFDATAR:32;      /* SCM Off-range read data value. */
  } B;
} eTPU_SCR_SCMOFFDATAR_tag;

typedef union eTPU_SCR_ECR_ENG1_union_tag { /* eTPU Engine 1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t FEND:1;                  /* Force End. */
    vuint32_t MDIS:1;                  /* Module Disable Bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t STF:1;                   /* Stop Flag Bit. */
    vuint32_t  :4;                     /* Reserved. */
    vuint32_t HLTF:1;                  /* Halt Mode Flag. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t FCSS:1;                  /* Filter Clock Source Selection */
    vuint32_t FPSCK:3;                 /* Filter Prescaler Clock Control. */
    vuint32_t CDFC:2;                  /* Channel Digital Filter Control. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t ERBA:5;                  /* Engine Relative Base Address. */
    vuint32_t SPPDIS:1;                /* Schedule Priority Passing Disable. */
    vuint32_t  :2;                     /* Reserved. */
    vuint32_t ETB:5;                   /* Entry Table Base. */
  } B;
} eTPU_SCR_ECR_ENG1_tag;

typedef union eTPU_SCR_ECR_ENG2_union_tag { /* eTPU Engine 2 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t FEND:1;                  /* Force End. */
    vuint32_t MDIS:1;                  /* Module Disable Bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t STF:1;                   /* Stop Flag Bit. */
    vuint32_t  :4;                     /* Reserved. */
    vuint32_t HLTF:1;                  /* Halt Mode Flag. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t FCSS:1;                  /* Filter Clock Source Selection */
    vuint32_t FPSCK:3;                 /* Filter Prescaler Clock Control. */
    vuint32_t CDFC:2;                  /* Channel Digital Filter Control. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t ERBA:5;                  /* Engine Relative Base Address. */
    vuint32_t SPPDIS:1;                /* Schedule Priority Passing Disable. */
    vuint32_t  :2;                     /* Reserved. */
    vuint32_t ETB:5;                   /* Entry Table Base. */
  } B;
} eTPU_SCR_ECR_ENG2_tag;

struct eTPU_SCR_tag {
  eTPU_SCR_MCR_tag MCR;                /* eTPU Module Configuration Register */
  eTPU_SCR_CDCR_tag CDCR;              /* eTPU Coherent Dual-Parameter Controller Register */
  uint8_t eTPU_SCR_reserved0[4];
  eTPU_SCR_MISCCMPR_tag MISCCMPR;      /* eTPU MISC Compare Register */
  eTPU_SCR_SCMOFFDATAR_tag SCMOFFDATAR; /* eTPU SCM Off-range Data Register */
  eTPU_SCR_ECR_ENG1_tag ECR_ENG1;      /* eTPU Engine 1 Configuration Register */
  eTPU_SCR_ECR_ENG2_tag ECR_ENG2;      /* eTPU Engine 2 Configuration Register */
};


/* ============================================================================
   =============================== Module: eTPU_SSIR ==========================
   ============================================================================ */

typedef union eTPU_SSIR_ETPUSSSIR_union_tag { /* eTPU Shared Subsystem n Integration Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;                    /* Reserved. */
    vuint32_t LENG:2;                  /* Link Engine. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t LCHAN:5;                 /* Link Channel. */
  } B;
} eTPU_SSIR_ETPUSSSIR_tag;

struct eTPU_SSIR_tag {
  uint8_t eTPU_SSIR_reserved0[3072];
  eTPU_SSIR_ETPUSSSIR_tag ETPUSSSIR[10]; /* eTPU Shared Subsystem n Integration Register */
};


/* ============================================================================
   =============================== Module: eTPU_TBR ===========================
   ============================================================================ */

typedef union eTPU_TBR_TBCR_ENG1_union_tag { /* eTPU Engine 1 Time Base Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t TCR2CTL:3;               /* TCR2 Clock/Gate Control. */
    vuint32_t TCRCF:2;                 /* TCRCLK Signal Filter Control. */
    vuint32_t AM:2;                    /* Angle Mode Selection. */
    vuint32_t ATGC:1;                  /* Angle Tick Generator Clock. */
    vuint32_t  :2;                     /* Reserved. */
    vuint32_t TCR2P:6;                 /* Timer Count Register 2 Prescaler Control. */
    vuint32_t TCR1CTL:2;               /* TCR1 Clock/Gate Control. */
    vuint32_t TCR1CS:1;                /* TCR1 Clock Source */
    vuint32_t  :5;                     /* Reserved. */
    vuint32_t TCR1P:8;                 /* Timer Count Register 1 Prescaler Control. */
  } B;
} eTPU_TBR_TBCR_ENG1_tag;

typedef union eTPU_TBR_TB1R_ENG1_union_tag { /* eTPU Engine 1 Time Base 1 (TCR1) Visibility Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t TCR1:24;                 /* TCR1 value. */
  } B;
} eTPU_TBR_TB1R_ENG1_tag;

typedef union eTPU_TBR_TB2R_ENG1_union_tag { /* eTPU Engine 1 Time Base 2 (TCR2) Visibility Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t TCR2:24;                 /* TCR2 value. */
  } B;
} eTPU_TBR_TB2R_ENG1_tag;

typedef union eTPU_TBR_STAC_ENG1_union_tag { /* eTPU Engine 1 STAC Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t REN1:1;                  /* TCR1 Resource Client/Server Operation Enable Bit. */
    vuint32_t RSC1:1;                  /* TCR1 Resource Server/Client Assignment Bits. */
    vuint32_t  :2;                     /* Reserved. */
    vuint32_t SERVER_ID1:4;            /* STAC ID 1. */
    vuint32_t  :4;                     /* Reserved. */
    vuint32_t SRV1:4;                  /* TCR1 Resource Server. */
    vuint32_t REN2:1;                  /* TCR2 Resource Client/Server Operation Enable Bit. */
    vuint32_t RSC2:1;                  /* TCR2 Resource Server/Client Assignment Bits. */
    vuint32_t  :2;                     /* Reserved. */
    vuint32_t SERVER_ID2:4;            /* STAC ID 2. */
    vuint32_t  :4;                     /* Reserved. */
    vuint32_t SRV2:4;                  /* TCR2 Resource Server. */
  } B;
} eTPU_TBR_STAC_ENG1_tag;

typedef union eTPU_TBR_TBCR_ENG2_union_tag { /* eTPU Engine 2 Time Base Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t TCR2CTL:3;               /* TCR2 Clock/Gate Control. */
    vuint32_t TCRCF:2;                 /* TCRCLK Signal Filter Control. */
    vuint32_t AM:2;                    /* Angle Mode Selection. */
    vuint32_t ATGC:1;                  /* Angle Tick Generator Clock. */
    vuint32_t  :2;                     /* Reserved. */
    vuint32_t TCR2P:6;                 /* Timer Count Register 2 Prescaler Control. */
    vuint32_t TCR1CTL:2;               /* TCR1 Clock/Gate Control. */
    vuint32_t TCR1CS:1;                /* TCR1 Clock Source */
    vuint32_t  :5;                     /* Reserved. */
    vuint32_t TCR1P:8;                 /* Timer Count Register 1 Prescaler Control. */
  } B;
} eTPU_TBR_TBCR_ENG2_tag;

typedef union eTPU_TBR_TB1R_ENG2_union_tag { /* eTPU Engine 2 Time Base 1 (TCR1) Visibility Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t TCR1:24;                 /* TCR1 value. */
  } B;
} eTPU_TBR_TB1R_ENG2_tag;

typedef union eTPU_TBR_TB2R_ENG2_union_tag { /* eTPU Engine 2 Time Base 2 (TCR2) Visibility Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t TCR2:24;                 /* TCR2 value. */
  } B;
} eTPU_TBR_TB2R_ENG2_tag;

typedef union eTPU_TBR_STAC_ENG2_union_tag { /* eTPU Engine 2 STAC Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t REN1:1;                  /* TCR1 Resource Client/Server Operation Enable Bit. */
    vuint32_t RSC1:1;                  /* TCR1 Resource Server/Client Assignment Bits. */
    vuint32_t  :2;                     /* Reserved. */
    vuint32_t SERVER_ID1:4;            /* STAC ID 1. */
    vuint32_t  :4;                     /* Reserved. */
    vuint32_t SRV1:4;                  /* TCR1 Resource Server. */
    vuint32_t REN2:1;                  /* TCR2 Resource Client/Server Operation Enable Bit. */
    vuint32_t RSC2:1;                  /* TCR2 Resource Server/Client Assignment Bits. */
    vuint32_t  :2;                     /* Reserved. */
    vuint32_t SERVER_ID2:4;            /* STAC ID 2. */
    vuint32_t  :4;                     /* Reserved. */
    vuint32_t SRV2:4;                  /* TCR2 Resource Server. */
  } B;
} eTPU_TBR_STAC_ENG2_tag;

struct eTPU_TBR_tag {
  uint8_t eTPU_TBR_reserved0[32];
  eTPU_TBR_TBCR_ENG1_tag TBCR_ENG1;    /* eTPU Engine 1 Time Base Configuration Register */
  eTPU_TBR_TB1R_ENG1_tag TB1R_ENG1;    /* eTPU Engine 1 Time Base 1 (TCR1) Visibility Register */
  eTPU_TBR_TB2R_ENG1_tag TB2R_ENG1;    /* eTPU Engine 1 Time Base 2 (TCR2) Visibility Register */
  eTPU_TBR_STAC_ENG1_tag STAC_ENG1;    /* eTPU Engine 1 STAC Configuration Register */
  uint8_t eTPU_TBR_reserved1[16];
  eTPU_TBR_TBCR_ENG2_tag TBCR_ENG2;    /* eTPU Engine 2 Time Base Configuration Register */
  eTPU_TBR_TB1R_ENG2_tag TB1R_ENG2;    /* eTPU Engine 2 Time Base 1 (TCR1) Visibility Register */
  eTPU_TBR_TB2R_ENG2_tag TB2R_ENG2;    /* eTPU Engine 2 Time Base 2 (TCR2) Visibility Register */
  eTPU_TBR_STAC_ENG2_tag STAC_ENG2;    /* eTPU Engine 2 STAC Configuration Register */
};

#define AIPS_0 (*(volatile struct AIPS_tag *) 0xFFF00000UL)
#define AIPS_1 (*(volatile struct AIPS_tag *) 0xC3F00000UL)
#define C55FMC (*(volatile struct C55FMC_tag *) 0xFFFE8000UL)
#define CAN_A (*(volatile struct CAN_tag *) 0xFFFC0000UL)
#define CAN_B (*(volatile struct CAN_tag *) 0xFFFC4000UL)
#define CAN_C (*(volatile struct CAN_tag *) 0xC3E60000UL)
#define CAN_D (*(volatile struct CAN_tag *) 0xC3E64000UL)
#define CMU_0 (*(volatile struct CMU_tag *) 0xC3E6C200UL)
#define CMU_1 (*(volatile struct CMU_tag *) 0xC3E6C240UL)
#define CMU_2 (*(volatile struct CMU_tag *) 0xC3E6C280UL)
#define CMU_3 (*(volatile struct CMU_tag *) 0xC3E6C2C0UL)
#define CMU_4 (*(volatile struct CMU_tag *) 0xC3E6C300UL)
#define CMU_5 (*(volatile struct CMU_tag *) 0xC3E6C340UL)
#define CMU_6 (*(volatile struct CMU_tag *) 0xC3E6C380UL)
#define CMU_7 (*(volatile struct CMU_tag *) 0xC3E6C3C0UL)
#define CMU_8 (*(volatile struct CMU_tag *) 0xC3E6C400UL)
#define CRC (*(volatile struct CRC_tag *) 0xFFE68000UL)
#define CSE (*(volatile struct CSE_tag *) 0xFFF14000UL)
#define DECFILTER_A (*(volatile struct DECFILTER_tag *) 0xFFF88000UL)
#define DECFILTER_B (*(volatile struct DECFILTER_tag *) 0xFFF88800UL)
#define DECFILTER_C (*(volatile struct DECFILTER_tag *) 0xFFF89000UL)
#define DECFILTER_D (*(volatile struct DECFILTER_tag *) 0xFFF89800UL)
#define DECFILTER_E (*(volatile struct DECFILTER_tag *) 0xFFF8A000UL)
#define DECFILTER_F (*(volatile struct DECFILTER_tag *) 0xFFF8A800UL)
#define DECFILTER_G (*(volatile struct DECFILTER_tag *) 0xFFF8B000UL)
#define DECFILTER_H (*(volatile struct DECFILTER_tag *) 0xFFF8B800UL)
#define DECFILTER_I (*(volatile struct DECFILTER_tag *) 0xFFF8C000UL)
#define DECFILTER_J (*(volatile struct DECFILTER_tag *) 0xFFF8C800UL)
#define DECFILTER_K (*(volatile struct DECFILTER_tag *) 0xFFF8D000UL)
#define DECFILTER_L (*(volatile struct DECFILTER_tag *) 0xFFF8D800UL)
#define DMA_A (*(volatile struct DMA_tag *) 0xFFF44000UL)
#define DMA_B (*(volatile struct DMA_tag *) 0xFFF54000UL)
#define DSPI_A (*(volatile struct DSPI_tag *) 0xFFF90000UL)
#define DSPI_B (*(volatile struct DSPI_tag *) 0xFFF94000UL)
#define DSPI_C (*(volatile struct DSPI_tag *) 0xFFF98000UL)
#define DSPI_D (*(volatile struct DSPI_tag *) 0xC3FDC000UL)
#define DSPI_E (*(volatile struct DSPI_tag *) 0xC3FE0000UL)
#define DTS (*(volatile struct DTS_tag *) 0xFFE78000UL)
#define EBI (*(volatile struct EBI_tag *) 0xC3F84000UL)
#define EIM (*(volatile struct EIM_tag *) 0xFFF64000UL)
#define EQADC_A (*(volatile struct EQADC_tag *) 0xFFF80000UL)
#define EQADC_B (*(volatile struct EQADC_tag *) 0xC3E54000UL)
#define ERM (*(volatile struct ERM_tag *) 0xFFF60000UL)
#define FCCU (*(volatile struct FCCU_tag *) 0xC3F80000UL)
#define FEC (*(volatile struct FEC_tag *) 0xFFF4C000UL)
#define IGF_0 (*(volatile struct IGF_tag *) 0xFFE20000UL)
#define IGF_1 (*(volatile struct IGF_tag *) 0xC3E04000UL)
#define INTC (*(volatile struct INTC_tag *) 0xFFF48000UL)
#define JDC (*(volatile struct JDC_tag *) 0xFFE7C000UL)
#define LFAST (*(volatile struct LFAST_tag *) 0xFFFD8000UL)
#define MPU_0 (*(volatile struct MPU_tag *) 0xFFF0C000UL)
#define MPU_1 (*(volatile struct MPU_tag *) 0xFFF10000UL)
#define M_CAN_0 (*(volatile struct M_CAN_tag *) 0xFFE30000UL)
#define M_CAN_1 (*(volatile struct M_CAN_tag *) 0xFFE38000UL)
#define PASS (*(volatile struct PASS_tag *) 0xFFFF4000UL)
#define PCM (*(volatile struct PCM_tag *) 0xFFF6C000UL)
#define PCS (*(volatile struct PCS_tag *) 0xFFE70000UL)
#define PCU (*(volatile struct PCU_tag *) 0xFFF50000UL)
#define PFLASH (*(volatile struct PFLASH_tag *) 0xFFF68000UL)
#define PIT (*(volatile struct PIT_tag *) 0xC3FF0000UL)
#define PLLDIG (*(volatile struct PLLDIG_tag *) 0xFFE74000UL)
#define PMC (*(volatile struct PMC_tag *) 0xC3FBC000UL)
#define PRAMC_0 (*(volatile struct PRAMC_tag *) 0xFFF1C000UL)
#define PRAMC_1 (*(volatile struct PRAMC_tag *) 0xFFF20000UL)
#define PSI5_0 (*(volatile struct PSI5_tag *) 0xFFE3C000UL)
#define PSI5_1 (*(volatile struct PSI5_tag *) 0xC3E14000UL)
#define REACM2 (*(volatile struct REACM2_tag *) 0xFFE04000UL)
#define SDADC_1 (*(volatile struct SDADC_tag *) 0xFFE44000UL)
#define SDADC_2 (*(volatile struct SDADC_tag *) 0xC3E44000UL)
#define SDADC_3 (*(volatile struct SDADC_tag *) 0xFFE48000UL)
#define SDADC_4 (*(volatile struct SDADC_tag *) 0xC3E48000UL)
#define SEMA4 (*(volatile struct SEMA4_tag *) 0xFFF24000UL)
#define SIPI (*(volatile struct SIPI_tag *) 0xFFE6C000UL)
#define SIU (*(volatile struct SIU_tag *) 0xC3F90000UL)
#define SIU_B (*(volatile struct SIU_B_tag *) 0xC3F98000UL)
#define SRX_0 (*(volatile struct SRX_tag *) 0xFFE5C000UL)
#define SRX_1 (*(volatile struct SRX_tag *) 0xC3E5C000UL)
#define SSCM (*(volatile struct SSCM_tag *) 0xFFFF8000UL)
#define STCU2 (*(volatile struct STCU2_tag *) 0xC3FF4000UL)
#define STM_A (*(volatile struct STM_tag *) 0xFFF3C000UL)
#define SWT_A (*(volatile struct SWT_tag *) 0xFFF38000UL)
#define SWT_B (*(volatile struct SWT_tag *) 0xFFF34000UL)
#define TDM (*(volatile struct TDM_tag *) 0xFFF18000UL)
#define XBAR (*(volatile struct XBAR_tag *) 0xFFF04000UL)
#define XBIC (*(volatile struct XBIC_tag *) 0xFFF08000UL)
#define eMIOS_0 (*(volatile struct eMIOS_tag *) 0xFFE64000UL)
#define eMIOS_0_UC (*(volatile struct eMIOS_tag *) 0xFFE64000UL)
#define eMIOS_1 (*(volatile struct eMIOS_tag *) 0xC3FA0000UL)
#define eMIOS_1_UC (*(volatile struct eMIOS_tag *) 0xC3FA0000UL)
#define eSCI_A (*(volatile struct eSCI_tag *) 0xFFFB0000UL)
#define eSCI_B (*(volatile struct eSCI_tag *) 0xFFFB4000UL)
#define eSCI_C (*(volatile struct eSCI_tag *) 0xFFFB8000UL)
#define eSCI_D (*(volatile struct eSCI_tag *) 0xC3FB0000UL)
#define eSCI_E (*(volatile struct eSCI_tag *) 0xC3FB4000UL)
#define eSCI_F (*(volatile struct eSCI_tag *) 0xC3FB8000UL)
#define eTPU_AB_CCCR (*(volatile struct eTPU_CCCR_tag *) 0xC3FC0000UL)
#define eTPU_C_CCCR (*(volatile struct eTPU_CCCR_tag *) 0xFFE00000UL)
#define eTPU_AB_ER (*(volatile struct eTPU_ER_tag *) 0xC3FC0000UL)
#define eTPU_C_ER (*(volatile struct eTPU_ER_tag *) 0xFFE00000UL)
#define eTPU_AB_GCR (*(volatile struct eTPU_GCR_tag *) 0xC3FC0000UL)
#define eTPU_C_GCR (*(volatile struct eTPU_GCR_tag *) 0xFFE00000UL)
#define eTPU_AB_LMR (*(volatile struct eTPU_LMR_tag *) 0xC3FC0000UL)
#define eTPU_C_LMR (*(volatile struct eTPU_LMR_tag *) 0xFFE00000UL)
#define eTPU_AB_MESR (*(volatile struct eTPU_MESR_tag *) 0xC3FC0000UL)
#define eTPU_C_MESR (*(volatile struct eTPU_MESR_tag *) 0xFFE00000UL)
#define eTPU_AB_SCR (*(volatile struct eTPU_SCR_tag *) 0xC3FC0000UL)
#define eTPU_C_SCR (*(volatile struct eTPU_SCR_tag *) 0xFFE00000UL)
#define eTPU_AB_SSIR (*(volatile struct eTPU_SSIR_tag *) 0xC3FC0000UL)
#define eTPU_C_SSIR (*(volatile struct eTPU_SSIR_tag *) 0xFFE00000UL)
#define eTPU_AB_TBR (*(volatile struct eTPU_TBR_tag *) 0xC3FC0000UL)
#define eTPU_C_TBR (*(volatile struct eTPU_TBR_tag *) 0xFFE00000UL)

/* AIPS */
#define AIPS_0_MPRA          AIPS_0.MPRA.R                 /* Master Privilege Register A */
#define AIPS_0_MPRB          AIPS_0.MPRB.R                 /* Master Privilege Register B */
#define AIPS_0_PACRA         AIPS_0.PACR[0].R              /* Peripheral Access Control Register */
#define AIPS_0_PACRB         AIPS_0.PACR[1].R              /* Peripheral Access Control Register */
#define AIPS_0_PACRC         AIPS_0.PACR[2].R              /* Peripheral Access Control Register */
#define AIPS_0_PACRD         AIPS_0.PACR[3].R              /* Peripheral Access Control Register */
#define AIPS_0_OPACRA        AIPS_0.OPACR[0].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRB        AIPS_0.OPACR[1].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRC        AIPS_0.OPACR[2].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRD        AIPS_0.OPACR[3].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRE        AIPS_0.OPACR[4].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRF        AIPS_0.OPACR[5].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRG        AIPS_0.OPACR[6].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRH        AIPS_0.OPACR[7].R             /* Off-Platform Peripheral Access Control Register */

#define AIPS_1_MPRA          AIPS_1.MPRA.R                 /* Master Privilege Register A */
#define AIPS_1_MPRB          AIPS_1.MPRB.R                 /* Master Privilege Register B */
#define AIPS_1_PACRA         AIPS_1.PACR[0].R              /* Peripheral Access Control Register */
#define AIPS_1_PACRB         AIPS_1.PACR[1].R              /* Peripheral Access Control Register */
#define AIPS_1_PACRC         AIPS_1.PACR[2].R              /* Peripheral Access Control Register */
#define AIPS_1_PACRD         AIPS_1.PACR[3].R              /* Peripheral Access Control Register */
#define AIPS_1_OPACRA        AIPS_1.OPACR[0].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRB        AIPS_1.OPACR[1].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRC        AIPS_1.OPACR[2].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRD        AIPS_1.OPACR[3].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRE        AIPS_1.OPACR[4].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRF        AIPS_1.OPACR[5].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRG        AIPS_1.OPACR[6].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRH        AIPS_1.OPACR[7].R             /* Off-Platform Peripheral Access Control Register */

/* C55FMC */
#define C55FMC_MCR           C55FMC.MCR.R                  /* Module Configuration Register */
#define C55FMC_MCRE          C55FMC.MCRE.R                 /* Extended Module Configuration Register */
#define C55FMC_LOCK0         C55FMC.LOCK0.R                /* Lock 0 register */
#define C55FMC_LOCK1         C55FMC.LOCK1.R                /* Lock 1 register */
#define C55FMC_LOCK2         C55FMC.LOCK2.R                /* Lock 2 register */
#define C55FMC_LOCK3         C55FMC.LOCK3.R                /* Lock 3 register */
#define C55FMC_SEL0          C55FMC.SEL0.R                 /* Select 0 register */
#define C55FMC_SEL1          C55FMC.SEL1.R                 /* Select 1 register */
#define C55FMC_SEL2          C55FMC.SEL2.R                 /* Select 2 register */
#define C55FMC_SEL3          C55FMC.SEL3.R                 /* Select 3 register */
#define C55FMC_ADR           C55FMC.ADR.R                  /* Address register */
#define C55FMC_UT0           C55FMC.UT0.R                  /* UTest 0 register */
#define C55FMC_UM0           C55FMC.UM[0].R                /* UMISR register */
#define C55FMC_UM1           C55FMC.UM[1].R                /* UMISR register */
#define C55FMC_UM2           C55FMC.UM[2].R                /* UMISR register */
#define C55FMC_UM3           C55FMC.UM[3].R                /* UMISR register */
#define C55FMC_UM4           C55FMC.UM[4].R                /* UMISR register */
#define C55FMC_UM5           C55FMC.UM[5].R                /* UMISR register */
#define C55FMC_UM6           C55FMC.UM[6].R                /* UMISR register */
#define C55FMC_UM7           C55FMC.UM[7].R                /* UMISR register */
#define C55FMC_UM8           C55FMC.UM[8].R                /* UMISR register */
#define C55FMC_UM9           C55FMC.UM9.R                  /* UMISR register */
#define C55FMC_OPP0          C55FMC.OPP0.R                 /* Over-Program Protection 0 register */
#define C55FMC_OPP1          C55FMC.OPP1.R                 /* Over-Program Protection 1 register */
#define C55FMC_OPP2          C55FMC.OPP2.R                 /* Over-Program Protection 2 register */
#define C55FMC_OPP3          C55FMC.OPP3.R                 /* Over-Program Protection 3 register */
#define C55FMC_TMD           C55FMC.TMD.R                  /* Test Mode Disable Password Check register */

/* CAN */
#define CAN_A_MCR            CAN_A.MCR.R                   /* Module Configuration Register */
#define CAN_A_CTRL1          CAN_A.CTRL1.R                 /* Control 1 register */
#define CAN_A_TIMER          CAN_A.TIMER.R                 /* Free Running Timer */
#define CAN_A_RXMGMASK       CAN_A.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_A_RX14MASK       CAN_A.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_A_RX15MASK       CAN_A.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_A_ECR            CAN_A.ECR.R                   /* Error Counter */
#define CAN_A_ESR1           CAN_A.ESR1.R                  /* Error and Status 1 register */
#define CAN_A_IMASK2         CAN_A.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_A_IMASK1         CAN_A.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_A_IFLAG2         CAN_A.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_A_IFLAG1         CAN_A.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_A_CTRL2          CAN_A.CTRL2.R                 /* Control 2 register */
#define CAN_A_ESR2           CAN_A.ESR2.R                  /* Error and Status 2 register */
#define CAN_A_CRCR           CAN_A.CRCR.R                  /* CRC Register */
#define CAN_A_RXFGMASK       CAN_A.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_A_RXFIR          CAN_A.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_A_CS0            CAN_A.MB[0].CS.R              /* Message Buffer 0 CS Register */
#define CAN_A_ID0            CAN_A.MB[0].ID.R              /* Message Buffer 0 ID Register */
#define CAN_A_B0             CAN_A.MB[0].DATA.B            /* Message Buffer 0 B Register */
#define CAN_A_H0             CAN_A.MB[0].DATA.H            /* Message Buffer 0 H Register */
#define CAN_A_W0             CAN_A.MB[0].DATA.W            /* Message Buffer 0 W Register */
#define CAN_A_CS1            CAN_A.MB[1].CS.R              /* Message Buffer 1 CS Register */
#define CAN_A_ID1            CAN_A.MB[1].ID.R              /* Message Buffer 1 ID Register */
#define CAN_A_B1             CAN_A.MB[1].DATA.B            /* Message Buffer 1 B Register */
#define CAN_A_H1             CAN_A.MB[1].DATA.H            /* Message Buffer 1 H Register */
#define CAN_A_W1             CAN_A.MB[1].DATA.W            /* Message Buffer 1 W Register */
#define CAN_A_CS2            CAN_A.MB[2].CS.R              /* Message Buffer 2 CS Register */
#define CAN_A_ID2            CAN_A.MB[2].ID.R              /* Message Buffer 2 ID Register */
#define CAN_A_B2             CAN_A.MB[2].DATA.B            /* Message Buffer 2 B Register */
#define CAN_A_H2             CAN_A.MB[2].DATA.H            /* Message Buffer 2 H Register */
#define CAN_A_W2             CAN_A.MB[2].DATA.W            /* Message Buffer 2 W Register */
#define CAN_A_CS3            CAN_A.MB[3].CS.R              /* Message Buffer 3 CS Register */
#define CAN_A_ID3            CAN_A.MB[3].ID.R              /* Message Buffer 3 ID Register */
#define CAN_A_B3             CAN_A.MB[3].DATA.B            /* Message Buffer 3 B Register */
#define CAN_A_H3             CAN_A.MB[3].DATA.H            /* Message Buffer 3 H Register */
#define CAN_A_W3             CAN_A.MB[3].DATA.W            /* Message Buffer 3 W Register */
#define CAN_A_CS4            CAN_A.MB[4].CS.R              /* Message Buffer 4 CS Register */
#define CAN_A_ID4            CAN_A.MB[4].ID.R              /* Message Buffer 4 ID Register */
#define CAN_A_B4             CAN_A.MB[4].DATA.B            /* Message Buffer 4 B Register */
#define CAN_A_H4             CAN_A.MB[4].DATA.H            /* Message Buffer 4 H Register */
#define CAN_A_W4             CAN_A.MB[4].DATA.W            /* Message Buffer 4 W Register */
#define CAN_A_CS5            CAN_A.MB[5].CS.R              /* Message Buffer 5 CS Register */
#define CAN_A_ID5            CAN_A.MB[5].ID.R              /* Message Buffer 5 ID Register */
#define CAN_A_B5             CAN_A.MB[5].DATA.B            /* Message Buffer 5 B Register */
#define CAN_A_H5             CAN_A.MB[5].DATA.H            /* Message Buffer 5 H Register */
#define CAN_A_W5             CAN_A.MB[5].DATA.W            /* Message Buffer 5 W Register */
#define CAN_A_CS6            CAN_A.MB[6].CS.R              /* Message Buffer 6 CS Register */
#define CAN_A_ID6            CAN_A.MB[6].ID.R              /* Message Buffer 6 ID Register */
#define CAN_A_B6             CAN_A.MB[6].DATA.B            /* Message Buffer 6 B Register */
#define CAN_A_H6             CAN_A.MB[6].DATA.H            /* Message Buffer 6 H Register */
#define CAN_A_W6             CAN_A.MB[6].DATA.W            /* Message Buffer 6 W Register */
#define CAN_A_CS7            CAN_A.MB[7].CS.R              /* Message Buffer 7 CS Register */
#define CAN_A_ID7            CAN_A.MB[7].ID.R              /* Message Buffer 7 ID Register */
#define CAN_A_B7             CAN_A.MB[7].DATA.B            /* Message Buffer 7 B Register */
#define CAN_A_H7             CAN_A.MB[7].DATA.H            /* Message Buffer 7 H Register */
#define CAN_A_W7             CAN_A.MB[7].DATA.W            /* Message Buffer 7 W Register */
#define CAN_A_CS8            CAN_A.MB[8].CS.R              /* Message Buffer 8 CS Register */
#define CAN_A_ID8            CAN_A.MB[8].ID.R              /* Message Buffer 8 ID Register */
#define CAN_A_B8             CAN_A.MB[8].DATA.B            /* Message Buffer 8 B Register */
#define CAN_A_H8             CAN_A.MB[8].DATA.H            /* Message Buffer 8 H Register */
#define CAN_A_W8             CAN_A.MB[8].DATA.W            /* Message Buffer 8 W Register */
#define CAN_A_CS9            CAN_A.MB[9].CS.R              /* Message Buffer 9 CS Register */
#define CAN_A_ID9            CAN_A.MB[9].ID.R              /* Message Buffer 9 ID Register */
#define CAN_A_B9             CAN_A.MB[9].DATA.B            /* Message Buffer 9 B Register */
#define CAN_A_H9             CAN_A.MB[9].DATA.H            /* Message Buffer 9 H Register */
#define CAN_A_W9             CAN_A.MB[9].DATA.W            /* Message Buffer 9 W Register */
#define CAN_A_CS10           CAN_A.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_A_ID10           CAN_A.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_A_B10            CAN_A.MB[10].DATA.B           /* Message Buffer 10 B Register */
#define CAN_A_H10            CAN_A.MB[10].DATA.H           /* Message Buffer 10 H Register */
#define CAN_A_W10            CAN_A.MB[10].DATA.W           /* Message Buffer 10 W Register */
#define CAN_A_CS11           CAN_A.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_A_ID11           CAN_A.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_A_B11            CAN_A.MB[11].DATA.B           /* Message Buffer 11 B Register */
#define CAN_A_H11            CAN_A.MB[11].DATA.H           /* Message Buffer 11 H Register */
#define CAN_A_W11            CAN_A.MB[11].DATA.W           /* Message Buffer 11 W Register */
#define CAN_A_CS12           CAN_A.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_A_ID12           CAN_A.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_A_B12            CAN_A.MB[12].DATA.B           /* Message Buffer 12 B Register */
#define CAN_A_H12            CAN_A.MB[12].DATA.H           /* Message Buffer 12 H Register */
#define CAN_A_W12            CAN_A.MB[12].DATA.W           /* Message Buffer 12 W Register */
#define CAN_A_CS13           CAN_A.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_A_ID13           CAN_A.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_A_B13            CAN_A.MB[13].DATA.B           /* Message Buffer 13 B Register */
#define CAN_A_H13            CAN_A.MB[13].DATA.H           /* Message Buffer 13 H Register */
#define CAN_A_W13            CAN_A.MB[13].DATA.W           /* Message Buffer 13 W Register */
#define CAN_A_CS14           CAN_A.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_A_ID14           CAN_A.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_A_B14            CAN_A.MB[14].DATA.B           /* Message Buffer 14 B Register */
#define CAN_A_H14            CAN_A.MB[14].DATA.H           /* Message Buffer 14 H Register */
#define CAN_A_W14            CAN_A.MB[14].DATA.W           /* Message Buffer 14 W Register */
#define CAN_A_CS15           CAN_A.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_A_ID15           CAN_A.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_A_B15            CAN_A.MB[15].DATA.B           /* Message Buffer 15 B Register */
#define CAN_A_H15            CAN_A.MB[15].DATA.H           /* Message Buffer 15 H Register */
#define CAN_A_W15            CAN_A.MB[15].DATA.W           /* Message Buffer 15 W Register */
#define CAN_A_CS16           CAN_A.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_A_ID16           CAN_A.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_A_B16            CAN_A.MB[16].DATA.B           /* Message Buffer 16 B Register */
#define CAN_A_H16            CAN_A.MB[16].DATA.H           /* Message Buffer 16 H Register */
#define CAN_A_W16            CAN_A.MB[16].DATA.W           /* Message Buffer 16 W Register */
#define CAN_A_CS17           CAN_A.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_A_ID17           CAN_A.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_A_B17            CAN_A.MB[17].DATA.B           /* Message Buffer 17 B Register */
#define CAN_A_H17            CAN_A.MB[17].DATA.H           /* Message Buffer 17 H Register */
#define CAN_A_W17            CAN_A.MB[17].DATA.W           /* Message Buffer 17 W Register */
#define CAN_A_CS18           CAN_A.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_A_ID18           CAN_A.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_A_B18            CAN_A.MB[18].DATA.B           /* Message Buffer 18 B Register */
#define CAN_A_H18            CAN_A.MB[18].DATA.H           /* Message Buffer 18 H Register */
#define CAN_A_W18            CAN_A.MB[18].DATA.W           /* Message Buffer 18 W Register */
#define CAN_A_CS19           CAN_A.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_A_ID19           CAN_A.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_A_B19            CAN_A.MB[19].DATA.B           /* Message Buffer 19 B Register */
#define CAN_A_H19            CAN_A.MB[19].DATA.H           /* Message Buffer 19 H Register */
#define CAN_A_W19            CAN_A.MB[19].DATA.W           /* Message Buffer 19 W Register */
#define CAN_A_CS20           CAN_A.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_A_ID20           CAN_A.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_A_B20            CAN_A.MB[20].DATA.B           /* Message Buffer 20 B Register */
#define CAN_A_H20            CAN_A.MB[20].DATA.H           /* Message Buffer 20 H Register */
#define CAN_A_W20            CAN_A.MB[20].DATA.W           /* Message Buffer 20 W Register */
#define CAN_A_CS21           CAN_A.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_A_ID21           CAN_A.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_A_B21            CAN_A.MB[21].DATA.B           /* Message Buffer 21 B Register */
#define CAN_A_H21            CAN_A.MB[21].DATA.H           /* Message Buffer 21 H Register */
#define CAN_A_W21            CAN_A.MB[21].DATA.W           /* Message Buffer 21 W Register */
#define CAN_A_CS22           CAN_A.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_A_ID22           CAN_A.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_A_B22            CAN_A.MB[22].DATA.B           /* Message Buffer 22 B Register */
#define CAN_A_H22            CAN_A.MB[22].DATA.H           /* Message Buffer 22 H Register */
#define CAN_A_W22            CAN_A.MB[22].DATA.W           /* Message Buffer 22 W Register */
#define CAN_A_CS23           CAN_A.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_A_ID23           CAN_A.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_A_B23            CAN_A.MB[23].DATA.B           /* Message Buffer 23 B Register */
#define CAN_A_H23            CAN_A.MB[23].DATA.H           /* Message Buffer 23 H Register */
#define CAN_A_W23            CAN_A.MB[23].DATA.W           /* Message Buffer 23 W Register */
#define CAN_A_CS24           CAN_A.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_A_ID24           CAN_A.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_A_B24            CAN_A.MB[24].DATA.B           /* Message Buffer 24 B Register */
#define CAN_A_H24            CAN_A.MB[24].DATA.H           /* Message Buffer 24 H Register */
#define CAN_A_W24            CAN_A.MB[24].DATA.W           /* Message Buffer 24 W Register */
#define CAN_A_CS25           CAN_A.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_A_ID25           CAN_A.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_A_B25            CAN_A.MB[25].DATA.B           /* Message Buffer 25 B Register */
#define CAN_A_H25            CAN_A.MB[25].DATA.H           /* Message Buffer 25 H Register */
#define CAN_A_W25            CAN_A.MB[25].DATA.W           /* Message Buffer 25 W Register */
#define CAN_A_CS26           CAN_A.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_A_ID26           CAN_A.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_A_B26            CAN_A.MB[26].DATA.B           /* Message Buffer 26 B Register */
#define CAN_A_H26            CAN_A.MB[26].DATA.H           /* Message Buffer 26 H Register */
#define CAN_A_W26            CAN_A.MB[26].DATA.W           /* Message Buffer 26 W Register */
#define CAN_A_CS27           CAN_A.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_A_ID27           CAN_A.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_A_B27            CAN_A.MB[27].DATA.B           /* Message Buffer 27 B Register */
#define CAN_A_H27            CAN_A.MB[27].DATA.H           /* Message Buffer 27 H Register */
#define CAN_A_W27            CAN_A.MB[27].DATA.W           /* Message Buffer 27 W Register */
#define CAN_A_CS28           CAN_A.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_A_ID28           CAN_A.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_A_B28            CAN_A.MB[28].DATA.B           /* Message Buffer 28 B Register */
#define CAN_A_H28            CAN_A.MB[28].DATA.H           /* Message Buffer 28 H Register */
#define CAN_A_W28            CAN_A.MB[28].DATA.W           /* Message Buffer 28 W Register */
#define CAN_A_CS29           CAN_A.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_A_ID29           CAN_A.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_A_B29            CAN_A.MB[29].DATA.B           /* Message Buffer 29 B Register */
#define CAN_A_H29            CAN_A.MB[29].DATA.H           /* Message Buffer 29 H Register */
#define CAN_A_W29            CAN_A.MB[29].DATA.W           /* Message Buffer 29 W Register */
#define CAN_A_CS30           CAN_A.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_A_ID30           CAN_A.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_A_B30            CAN_A.MB[30].DATA.B           /* Message Buffer 30 B Register */
#define CAN_A_H30            CAN_A.MB[30].DATA.H           /* Message Buffer 30 H Register */
#define CAN_A_W30            CAN_A.MB[30].DATA.W           /* Message Buffer 30 W Register */
#define CAN_A_CS31           CAN_A.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_A_ID31           CAN_A.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_A_B31            CAN_A.MB[31].DATA.B           /* Message Buffer 31 B Register */
#define CAN_A_H31            CAN_A.MB[31].DATA.H           /* Message Buffer 31 H Register */
#define CAN_A_W31            CAN_A.MB[31].DATA.W           /* Message Buffer 31 W Register */
#define CAN_A_CS32           CAN_A.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_A_ID32           CAN_A.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_A_B32            CAN_A.MB[32].DATA.B           /* Message Buffer 32 B Register */
#define CAN_A_H32            CAN_A.MB[32].DATA.H           /* Message Buffer 32 H Register */
#define CAN_A_W32            CAN_A.MB[32].DATA.W           /* Message Buffer 32 W Register */
#define CAN_A_CS33           CAN_A.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_A_ID33           CAN_A.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_A_B33            CAN_A.MB[33].DATA.B           /* Message Buffer 33 B Register */
#define CAN_A_H33            CAN_A.MB[33].DATA.H           /* Message Buffer 33 H Register */
#define CAN_A_W33            CAN_A.MB[33].DATA.W           /* Message Buffer 33 W Register */
#define CAN_A_CS34           CAN_A.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_A_ID34           CAN_A.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_A_B34            CAN_A.MB[34].DATA.B           /* Message Buffer 34 B Register */
#define CAN_A_H34            CAN_A.MB[34].DATA.H           /* Message Buffer 34 H Register */
#define CAN_A_W34            CAN_A.MB[34].DATA.W           /* Message Buffer 34 W Register */
#define CAN_A_CS35           CAN_A.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_A_ID35           CAN_A.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_A_B35            CAN_A.MB[35].DATA.B           /* Message Buffer 35 B Register */
#define CAN_A_H35            CAN_A.MB[35].DATA.H           /* Message Buffer 35 H Register */
#define CAN_A_W35            CAN_A.MB[35].DATA.W           /* Message Buffer 35 W Register */
#define CAN_A_CS36           CAN_A.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_A_ID36           CAN_A.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_A_B36            CAN_A.MB[36].DATA.B           /* Message Buffer 36 B Register */
#define CAN_A_H36            CAN_A.MB[36].DATA.H           /* Message Buffer 36 H Register */
#define CAN_A_W36            CAN_A.MB[36].DATA.W           /* Message Buffer 36 W Register */
#define CAN_A_CS37           CAN_A.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_A_ID37           CAN_A.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_A_B37            CAN_A.MB[37].DATA.B           /* Message Buffer 37 B Register */
#define CAN_A_H37            CAN_A.MB[37].DATA.H           /* Message Buffer 37 H Register */
#define CAN_A_W37            CAN_A.MB[37].DATA.W           /* Message Buffer 37 W Register */
#define CAN_A_CS38           CAN_A.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_A_ID38           CAN_A.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_A_B38            CAN_A.MB[38].DATA.B           /* Message Buffer 38 B Register */
#define CAN_A_H38            CAN_A.MB[38].DATA.H           /* Message Buffer 38 H Register */
#define CAN_A_W38            CAN_A.MB[38].DATA.W           /* Message Buffer 38 W Register */
#define CAN_A_CS39           CAN_A.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_A_ID39           CAN_A.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_A_B39            CAN_A.MB[39].DATA.B           /* Message Buffer 39 B Register */
#define CAN_A_H39            CAN_A.MB[39].DATA.H           /* Message Buffer 39 H Register */
#define CAN_A_W39            CAN_A.MB[39].DATA.W           /* Message Buffer 39 W Register */
#define CAN_A_CS40           CAN_A.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_A_ID40           CAN_A.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_A_B40            CAN_A.MB[40].DATA.B           /* Message Buffer 40 B Register */
#define CAN_A_H40            CAN_A.MB[40].DATA.H           /* Message Buffer 40 H Register */
#define CAN_A_W40            CAN_A.MB[40].DATA.W           /* Message Buffer 40 W Register */
#define CAN_A_CS41           CAN_A.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_A_ID41           CAN_A.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_A_B41            CAN_A.MB[41].DATA.B           /* Message Buffer 41 B Register */
#define CAN_A_H41            CAN_A.MB[41].DATA.H           /* Message Buffer 41 H Register */
#define CAN_A_W41            CAN_A.MB[41].DATA.W           /* Message Buffer 41 W Register */
#define CAN_A_CS42           CAN_A.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_A_ID42           CAN_A.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_A_B42            CAN_A.MB[42].DATA.B           /* Message Buffer 42 B Register */
#define CAN_A_H42            CAN_A.MB[42].DATA.H           /* Message Buffer 42 H Register */
#define CAN_A_W42            CAN_A.MB[42].DATA.W           /* Message Buffer 42 W Register */
#define CAN_A_CS43           CAN_A.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_A_ID43           CAN_A.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_A_B43            CAN_A.MB[43].DATA.B           /* Message Buffer 43 B Register */
#define CAN_A_H43            CAN_A.MB[43].DATA.H           /* Message Buffer 43 H Register */
#define CAN_A_W43            CAN_A.MB[43].DATA.W           /* Message Buffer 43 W Register */
#define CAN_A_CS44           CAN_A.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_A_ID44           CAN_A.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_A_B44            CAN_A.MB[44].DATA.B           /* Message Buffer 44 B Register */
#define CAN_A_H44            CAN_A.MB[44].DATA.H           /* Message Buffer 44 H Register */
#define CAN_A_W44            CAN_A.MB[44].DATA.W           /* Message Buffer 44 W Register */
#define CAN_A_CS45           CAN_A.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_A_ID45           CAN_A.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_A_B45            CAN_A.MB[45].DATA.B           /* Message Buffer 45 B Register */
#define CAN_A_H45            CAN_A.MB[45].DATA.H           /* Message Buffer 45 H Register */
#define CAN_A_W45            CAN_A.MB[45].DATA.W           /* Message Buffer 45 W Register */
#define CAN_A_CS46           CAN_A.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_A_ID46           CAN_A.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_A_B46            CAN_A.MB[46].DATA.B           /* Message Buffer 46 B Register */
#define CAN_A_H46            CAN_A.MB[46].DATA.H           /* Message Buffer 46 H Register */
#define CAN_A_W46            CAN_A.MB[46].DATA.W           /* Message Buffer 46 W Register */
#define CAN_A_CS47           CAN_A.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_A_ID47           CAN_A.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_A_B47            CAN_A.MB[47].DATA.B           /* Message Buffer 47 B Register */
#define CAN_A_H47            CAN_A.MB[47].DATA.H           /* Message Buffer 47 H Register */
#define CAN_A_W47            CAN_A.MB[47].DATA.W           /* Message Buffer 47 W Register */
#define CAN_A_CS48           CAN_A.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_A_ID48           CAN_A.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_A_B48            CAN_A.MB[48].DATA.B           /* Message Buffer 48 B Register */
#define CAN_A_H48            CAN_A.MB[48].DATA.H           /* Message Buffer 48 H Register */
#define CAN_A_W48            CAN_A.MB[48].DATA.W           /* Message Buffer 48 W Register */
#define CAN_A_CS49           CAN_A.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_A_ID49           CAN_A.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_A_B49            CAN_A.MB[49].DATA.B           /* Message Buffer 49 B Register */
#define CAN_A_H49            CAN_A.MB[49].DATA.H           /* Message Buffer 49 H Register */
#define CAN_A_W49            CAN_A.MB[49].DATA.W           /* Message Buffer 49 W Register */
#define CAN_A_CS50           CAN_A.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_A_ID50           CAN_A.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_A_B50            CAN_A.MB[50].DATA.B           /* Message Buffer 50 B Register */
#define CAN_A_H50            CAN_A.MB[50].DATA.H           /* Message Buffer 50 H Register */
#define CAN_A_W50            CAN_A.MB[50].DATA.W           /* Message Buffer 50 W Register */
#define CAN_A_CS51           CAN_A.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_A_ID51           CAN_A.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_A_B51            CAN_A.MB[51].DATA.B           /* Message Buffer 51 B Register */
#define CAN_A_H51            CAN_A.MB[51].DATA.H           /* Message Buffer 51 H Register */
#define CAN_A_W51            CAN_A.MB[51].DATA.W           /* Message Buffer 51 W Register */
#define CAN_A_CS52           CAN_A.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_A_ID52           CAN_A.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_A_B52            CAN_A.MB[52].DATA.B           /* Message Buffer 52 B Register */
#define CAN_A_H52            CAN_A.MB[52].DATA.H           /* Message Buffer 52 H Register */
#define CAN_A_W52            CAN_A.MB[52].DATA.W           /* Message Buffer 52 W Register */
#define CAN_A_CS53           CAN_A.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_A_ID53           CAN_A.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_A_B53            CAN_A.MB[53].DATA.B           /* Message Buffer 53 B Register */
#define CAN_A_H53            CAN_A.MB[53].DATA.H           /* Message Buffer 53 H Register */
#define CAN_A_W53            CAN_A.MB[53].DATA.W           /* Message Buffer 53 W Register */
#define CAN_A_CS54           CAN_A.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_A_ID54           CAN_A.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_A_B54            CAN_A.MB[54].DATA.B           /* Message Buffer 54 B Register */
#define CAN_A_H54            CAN_A.MB[54].DATA.H           /* Message Buffer 54 H Register */
#define CAN_A_W54            CAN_A.MB[54].DATA.W           /* Message Buffer 54 W Register */
#define CAN_A_CS55           CAN_A.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_A_ID55           CAN_A.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_A_B55            CAN_A.MB[55].DATA.B           /* Message Buffer 55 B Register */
#define CAN_A_H55            CAN_A.MB[55].DATA.H           /* Message Buffer 55 H Register */
#define CAN_A_W55            CAN_A.MB[55].DATA.W           /* Message Buffer 55 W Register */
#define CAN_A_CS56           CAN_A.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_A_ID56           CAN_A.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_A_B56            CAN_A.MB[56].DATA.B           /* Message Buffer 56 B Register */
#define CAN_A_H56            CAN_A.MB[56].DATA.H           /* Message Buffer 56 H Register */
#define CAN_A_W56            CAN_A.MB[56].DATA.W           /* Message Buffer 56 W Register */
#define CAN_A_CS57           CAN_A.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_A_ID57           CAN_A.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_A_B57            CAN_A.MB[57].DATA.B           /* Message Buffer 57 B Register */
#define CAN_A_H57            CAN_A.MB[57].DATA.H           /* Message Buffer 57 H Register */
#define CAN_A_W57            CAN_A.MB[57].DATA.W           /* Message Buffer 57 W Register */
#define CAN_A_CS58           CAN_A.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_A_ID58           CAN_A.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_A_B58            CAN_A.MB[58].DATA.B           /* Message Buffer 58 B Register */
#define CAN_A_H58            CAN_A.MB[58].DATA.H           /* Message Buffer 58 H Register */
#define CAN_A_W58            CAN_A.MB[58].DATA.W           /* Message Buffer 58 W Register */
#define CAN_A_CS59           CAN_A.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_A_ID59           CAN_A.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_A_B59            CAN_A.MB[59].DATA.B           /* Message Buffer 59 B Register */
#define CAN_A_H59            CAN_A.MB[59].DATA.H           /* Message Buffer 59 H Register */
#define CAN_A_W59            CAN_A.MB[59].DATA.W           /* Message Buffer 59 W Register */
#define CAN_A_CS60           CAN_A.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_A_ID60           CAN_A.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_A_B60            CAN_A.MB[60].DATA.B           /* Message Buffer 60 B Register */
#define CAN_A_H60            CAN_A.MB[60].DATA.H           /* Message Buffer 60 H Register */
#define CAN_A_W60            CAN_A.MB[60].DATA.W           /* Message Buffer 60 W Register */
#define CAN_A_CS61           CAN_A.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_A_ID61           CAN_A.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_A_B61            CAN_A.MB[61].DATA.B           /* Message Buffer 61 B Register */
#define CAN_A_H61            CAN_A.MB[61].DATA.H           /* Message Buffer 61 H Register */
#define CAN_A_W61            CAN_A.MB[61].DATA.W           /* Message Buffer 61 W Register */
#define CAN_A_CS62           CAN_A.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_A_ID62           CAN_A.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_A_B62            CAN_A.MB[62].DATA.B           /* Message Buffer 62 B Register */
#define CAN_A_H62            CAN_A.MB[62].DATA.H           /* Message Buffer 62 H Register */
#define CAN_A_W62            CAN_A.MB[62].DATA.W           /* Message Buffer 62 W Register */
#define CAN_A_CS63           CAN_A.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_A_ID63           CAN_A.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_A_B63            CAN_A.MB[63].DATA.B           /* Message Buffer 63 B Register */
#define CAN_A_H63            CAN_A.MB[63].DATA.H           /* Message Buffer 63 H Register */
#define CAN_A_W63            CAN_A.MB[63].DATA.W           /* Message Buffer 63 W Register */
#define CAN_A_RXIMR0         CAN_A.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_A_RXIMR1         CAN_A.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_A_RXIMR2         CAN_A.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_A_RXIMR3         CAN_A.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_A_RXIMR4         CAN_A.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_A_RXIMR5         CAN_A.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_A_RXIMR6         CAN_A.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_A_RXIMR7         CAN_A.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_A_RXIMR8         CAN_A.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_A_RXIMR9         CAN_A.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_A_RXIMR10        CAN_A.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR11        CAN_A.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR12        CAN_A.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR13        CAN_A.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR14        CAN_A.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR15        CAN_A.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR16        CAN_A.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR17        CAN_A.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR18        CAN_A.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR19        CAN_A.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR20        CAN_A.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR21        CAN_A.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR22        CAN_A.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR23        CAN_A.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR24        CAN_A.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR25        CAN_A.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR26        CAN_A.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR27        CAN_A.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR28        CAN_A.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR29        CAN_A.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR30        CAN_A.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR31        CAN_A.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR32        CAN_A.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR33        CAN_A.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR34        CAN_A.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR35        CAN_A.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR36        CAN_A.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR37        CAN_A.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR38        CAN_A.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR39        CAN_A.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR40        CAN_A.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR41        CAN_A.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR42        CAN_A.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR43        CAN_A.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR44        CAN_A.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR45        CAN_A.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR46        CAN_A.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR47        CAN_A.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR48        CAN_A.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR49        CAN_A.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR50        CAN_A.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR51        CAN_A.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR52        CAN_A.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR53        CAN_A.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR54        CAN_A.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR55        CAN_A.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR56        CAN_A.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR57        CAN_A.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR58        CAN_A.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR59        CAN_A.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR60        CAN_A.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR61        CAN_A.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR62        CAN_A.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_A_RXIMR63        CAN_A.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_A_MECR           CAN_A.MECR.R                  /* Memory Error Control Register */
#define CAN_A_ERRIAR         CAN_A.ERRIAR.R                /* Error Injection Address Register */
#define CAN_A_ERRIDPR        CAN_A.ERRIDPR.R               /* Error Injection Data Pattern Register */
#define CAN_A_ERRIPPR        CAN_A.ERRIPPR.R               /* Error Injection Parity Pattern Register */
#define CAN_A_RERRAR         CAN_A.RERRAR.R                /* Error Report Address Register */
#define CAN_A_RERRDR         CAN_A.RERRDR.R                /* Error Report Data Register */
#define CAN_A_RERRSYNR       CAN_A.RERRSYNR.R              /* Error Report Syndrome Register */
#define CAN_A_ERRSR          CAN_A.ERRSR.R                 /* Error Status Register */

#define CAN_B_MCR            CAN_B.MCR.R                   /* Module Configuration Register */
#define CAN_B_CTRL1          CAN_B.CTRL1.R                 /* Control 1 register */
#define CAN_B_TIMER          CAN_B.TIMER.R                 /* Free Running Timer */
#define CAN_B_RXMGMASK       CAN_B.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_B_RX14MASK       CAN_B.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_B_RX15MASK       CAN_B.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_B_ECR            CAN_B.ECR.R                   /* Error Counter */
#define CAN_B_ESR1           CAN_B.ESR1.R                  /* Error and Status 1 register */
#define CAN_B_IMASK2         CAN_B.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_B_IMASK1         CAN_B.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_B_IFLAG2         CAN_B.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_B_IFLAG1         CAN_B.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_B_CTRL2          CAN_B.CTRL2.R                 /* Control 2 register */
#define CAN_B_ESR2           CAN_B.ESR2.R                  /* Error and Status 2 register */
#define CAN_B_CRCR           CAN_B.CRCR.R                  /* CRC Register */
#define CAN_B_RXFGMASK       CAN_B.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_B_RXFIR          CAN_B.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_B_CS0            CAN_B.MB[0].CS.R              /* Message Buffer 0 CS Register */
#define CAN_B_ID0            CAN_B.MB[0].ID.R              /* Message Buffer 0 ID Register */
#define CAN_B_B0             CAN_B.MB[0].DATA.B            /* Message Buffer 0 B Register */
#define CAN_B_H0             CAN_B.MB[0].DATA.H            /* Message Buffer 0 H Register */
#define CAN_B_W0             CAN_B.MB[0].DATA.W            /* Message Buffer 0 W Register */
#define CAN_B_CS1            CAN_B.MB[1].CS.R              /* Message Buffer 1 CS Register */
#define CAN_B_ID1            CAN_B.MB[1].ID.R              /* Message Buffer 1 ID Register */
#define CAN_B_B1             CAN_B.MB[1].DATA.B            /* Message Buffer 1 B Register */
#define CAN_B_H1             CAN_B.MB[1].DATA.H            /* Message Buffer 1 H Register */
#define CAN_B_W1             CAN_B.MB[1].DATA.W            /* Message Buffer 1 W Register */
#define CAN_B_CS2            CAN_B.MB[2].CS.R              /* Message Buffer 2 CS Register */
#define CAN_B_ID2            CAN_B.MB[2].ID.R              /* Message Buffer 2 ID Register */
#define CAN_B_B2             CAN_B.MB[2].DATA.B            /* Message Buffer 2 B Register */
#define CAN_B_H2             CAN_B.MB[2].DATA.H            /* Message Buffer 2 H Register */
#define CAN_B_W2             CAN_B.MB[2].DATA.W            /* Message Buffer 2 W Register */
#define CAN_B_CS3            CAN_B.MB[3].CS.R              /* Message Buffer 3 CS Register */
#define CAN_B_ID3            CAN_B.MB[3].ID.R              /* Message Buffer 3 ID Register */
#define CAN_B_B3             CAN_B.MB[3].DATA.B            /* Message Buffer 3 B Register */
#define CAN_B_H3             CAN_B.MB[3].DATA.H            /* Message Buffer 3 H Register */
#define CAN_B_W3             CAN_B.MB[3].DATA.W            /* Message Buffer 3 W Register */
#define CAN_B_CS4            CAN_B.MB[4].CS.R              /* Message Buffer 4 CS Register */
#define CAN_B_ID4            CAN_B.MB[4].ID.R              /* Message Buffer 4 ID Register */
#define CAN_B_B4             CAN_B.MB[4].DATA.B            /* Message Buffer 4 B Register */
#define CAN_B_H4             CAN_B.MB[4].DATA.H            /* Message Buffer 4 H Register */
#define CAN_B_W4             CAN_B.MB[4].DATA.W            /* Message Buffer 4 W Register */
#define CAN_B_CS5            CAN_B.MB[5].CS.R              /* Message Buffer 5 CS Register */
#define CAN_B_ID5            CAN_B.MB[5].ID.R              /* Message Buffer 5 ID Register */
#define CAN_B_B5             CAN_B.MB[5].DATA.B            /* Message Buffer 5 B Register */
#define CAN_B_H5             CAN_B.MB[5].DATA.H            /* Message Buffer 5 H Register */
#define CAN_B_W5             CAN_B.MB[5].DATA.W            /* Message Buffer 5 W Register */
#define CAN_B_CS6            CAN_B.MB[6].CS.R              /* Message Buffer 6 CS Register */
#define CAN_B_ID6            CAN_B.MB[6].ID.R              /* Message Buffer 6 ID Register */
#define CAN_B_B6             CAN_B.MB[6].DATA.B            /* Message Buffer 6 B Register */
#define CAN_B_H6             CAN_B.MB[6].DATA.H            /* Message Buffer 6 H Register */
#define CAN_B_W6             CAN_B.MB[6].DATA.W            /* Message Buffer 6 W Register */
#define CAN_B_CS7            CAN_B.MB[7].CS.R              /* Message Buffer 7 CS Register */
#define CAN_B_ID7            CAN_B.MB[7].ID.R              /* Message Buffer 7 ID Register */
#define CAN_B_B7             CAN_B.MB[7].DATA.B            /* Message Buffer 7 B Register */
#define CAN_B_H7             CAN_B.MB[7].DATA.H            /* Message Buffer 7 H Register */
#define CAN_B_W7             CAN_B.MB[7].DATA.W            /* Message Buffer 7 W Register */
#define CAN_B_CS8            CAN_B.MB[8].CS.R              /* Message Buffer 8 CS Register */
#define CAN_B_ID8            CAN_B.MB[8].ID.R              /* Message Buffer 8 ID Register */
#define CAN_B_B8             CAN_B.MB[8].DATA.B            /* Message Buffer 8 B Register */
#define CAN_B_H8             CAN_B.MB[8].DATA.H            /* Message Buffer 8 H Register */
#define CAN_B_W8             CAN_B.MB[8].DATA.W            /* Message Buffer 8 W Register */
#define CAN_B_CS9            CAN_B.MB[9].CS.R              /* Message Buffer 9 CS Register */
#define CAN_B_ID9            CAN_B.MB[9].ID.R              /* Message Buffer 9 ID Register */
#define CAN_B_B9             CAN_B.MB[9].DATA.B            /* Message Buffer 9 B Register */
#define CAN_B_H9             CAN_B.MB[9].DATA.H            /* Message Buffer 9 H Register */
#define CAN_B_W9             CAN_B.MB[9].DATA.W            /* Message Buffer 9 W Register */
#define CAN_B_CS10           CAN_B.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_B_ID10           CAN_B.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_B_B10            CAN_B.MB[10].DATA.B           /* Message Buffer 10 B Register */
#define CAN_B_H10            CAN_B.MB[10].DATA.H           /* Message Buffer 10 H Register */
#define CAN_B_W10            CAN_B.MB[10].DATA.W           /* Message Buffer 10 W Register */
#define CAN_B_CS11           CAN_B.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_B_ID11           CAN_B.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_B_B11            CAN_B.MB[11].DATA.B           /* Message Buffer 11 B Register */
#define CAN_B_H11            CAN_B.MB[11].DATA.H           /* Message Buffer 11 H Register */
#define CAN_B_W11            CAN_B.MB[11].DATA.W           /* Message Buffer 11 W Register */
#define CAN_B_CS12           CAN_B.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_B_ID12           CAN_B.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_B_B12            CAN_B.MB[12].DATA.B           /* Message Buffer 12 B Register */
#define CAN_B_H12            CAN_B.MB[12].DATA.H           /* Message Buffer 12 H Register */
#define CAN_B_W12            CAN_B.MB[12].DATA.W           /* Message Buffer 12 W Register */
#define CAN_B_CS13           CAN_B.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_B_ID13           CAN_B.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_B_B13            CAN_B.MB[13].DATA.B           /* Message Buffer 13 B Register */
#define CAN_B_H13            CAN_B.MB[13].DATA.H           /* Message Buffer 13 H Register */
#define CAN_B_W13            CAN_B.MB[13].DATA.W           /* Message Buffer 13 W Register */
#define CAN_B_CS14           CAN_B.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_B_ID14           CAN_B.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_B_B14            CAN_B.MB[14].DATA.B           /* Message Buffer 14 B Register */
#define CAN_B_H14            CAN_B.MB[14].DATA.H           /* Message Buffer 14 H Register */
#define CAN_B_W14            CAN_B.MB[14].DATA.W           /* Message Buffer 14 W Register */
#define CAN_B_CS15           CAN_B.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_B_ID15           CAN_B.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_B_B15            CAN_B.MB[15].DATA.B           /* Message Buffer 15 B Register */
#define CAN_B_H15            CAN_B.MB[15].DATA.H           /* Message Buffer 15 H Register */
#define CAN_B_W15            CAN_B.MB[15].DATA.W           /* Message Buffer 15 W Register */
#define CAN_B_CS16           CAN_B.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_B_ID16           CAN_B.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_B_B16            CAN_B.MB[16].DATA.B           /* Message Buffer 16 B Register */
#define CAN_B_H16            CAN_B.MB[16].DATA.H           /* Message Buffer 16 H Register */
#define CAN_B_W16            CAN_B.MB[16].DATA.W           /* Message Buffer 16 W Register */
#define CAN_B_CS17           CAN_B.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_B_ID17           CAN_B.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_B_B17            CAN_B.MB[17].DATA.B           /* Message Buffer 17 B Register */
#define CAN_B_H17            CAN_B.MB[17].DATA.H           /* Message Buffer 17 H Register */
#define CAN_B_W17            CAN_B.MB[17].DATA.W           /* Message Buffer 17 W Register */
#define CAN_B_CS18           CAN_B.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_B_ID18           CAN_B.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_B_B18            CAN_B.MB[18].DATA.B           /* Message Buffer 18 B Register */
#define CAN_B_H18            CAN_B.MB[18].DATA.H           /* Message Buffer 18 H Register */
#define CAN_B_W18            CAN_B.MB[18].DATA.W           /* Message Buffer 18 W Register */
#define CAN_B_CS19           CAN_B.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_B_ID19           CAN_B.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_B_B19            CAN_B.MB[19].DATA.B           /* Message Buffer 19 B Register */
#define CAN_B_H19            CAN_B.MB[19].DATA.H           /* Message Buffer 19 H Register */
#define CAN_B_W19            CAN_B.MB[19].DATA.W           /* Message Buffer 19 W Register */
#define CAN_B_CS20           CAN_B.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_B_ID20           CAN_B.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_B_B20            CAN_B.MB[20].DATA.B           /* Message Buffer 20 B Register */
#define CAN_B_H20            CAN_B.MB[20].DATA.H           /* Message Buffer 20 H Register */
#define CAN_B_W20            CAN_B.MB[20].DATA.W           /* Message Buffer 20 W Register */
#define CAN_B_CS21           CAN_B.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_B_ID21           CAN_B.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_B_B21            CAN_B.MB[21].DATA.B           /* Message Buffer 21 B Register */
#define CAN_B_H21            CAN_B.MB[21].DATA.H           /* Message Buffer 21 H Register */
#define CAN_B_W21            CAN_B.MB[21].DATA.W           /* Message Buffer 21 W Register */
#define CAN_B_CS22           CAN_B.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_B_ID22           CAN_B.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_B_B22            CAN_B.MB[22].DATA.B           /* Message Buffer 22 B Register */
#define CAN_B_H22            CAN_B.MB[22].DATA.H           /* Message Buffer 22 H Register */
#define CAN_B_W22            CAN_B.MB[22].DATA.W           /* Message Buffer 22 W Register */
#define CAN_B_CS23           CAN_B.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_B_ID23           CAN_B.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_B_B23            CAN_B.MB[23].DATA.B           /* Message Buffer 23 B Register */
#define CAN_B_H23            CAN_B.MB[23].DATA.H           /* Message Buffer 23 H Register */
#define CAN_B_W23            CAN_B.MB[23].DATA.W           /* Message Buffer 23 W Register */
#define CAN_B_CS24           CAN_B.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_B_ID24           CAN_B.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_B_B24            CAN_B.MB[24].DATA.B           /* Message Buffer 24 B Register */
#define CAN_B_H24            CAN_B.MB[24].DATA.H           /* Message Buffer 24 H Register */
#define CAN_B_W24            CAN_B.MB[24].DATA.W           /* Message Buffer 24 W Register */
#define CAN_B_CS25           CAN_B.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_B_ID25           CAN_B.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_B_B25            CAN_B.MB[25].DATA.B           /* Message Buffer 25 B Register */
#define CAN_B_H25            CAN_B.MB[25].DATA.H           /* Message Buffer 25 H Register */
#define CAN_B_W25            CAN_B.MB[25].DATA.W           /* Message Buffer 25 W Register */
#define CAN_B_CS26           CAN_B.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_B_ID26           CAN_B.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_B_B26            CAN_B.MB[26].DATA.B           /* Message Buffer 26 B Register */
#define CAN_B_H26            CAN_B.MB[26].DATA.H           /* Message Buffer 26 H Register */
#define CAN_B_W26            CAN_B.MB[26].DATA.W           /* Message Buffer 26 W Register */
#define CAN_B_CS27           CAN_B.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_B_ID27           CAN_B.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_B_B27            CAN_B.MB[27].DATA.B           /* Message Buffer 27 B Register */
#define CAN_B_H27            CAN_B.MB[27].DATA.H           /* Message Buffer 27 H Register */
#define CAN_B_W27            CAN_B.MB[27].DATA.W           /* Message Buffer 27 W Register */
#define CAN_B_CS28           CAN_B.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_B_ID28           CAN_B.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_B_B28            CAN_B.MB[28].DATA.B           /* Message Buffer 28 B Register */
#define CAN_B_H28            CAN_B.MB[28].DATA.H           /* Message Buffer 28 H Register */
#define CAN_B_W28            CAN_B.MB[28].DATA.W           /* Message Buffer 28 W Register */
#define CAN_B_CS29           CAN_B.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_B_ID29           CAN_B.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_B_B29            CAN_B.MB[29].DATA.B           /* Message Buffer 29 B Register */
#define CAN_B_H29            CAN_B.MB[29].DATA.H           /* Message Buffer 29 H Register */
#define CAN_B_W29            CAN_B.MB[29].DATA.W           /* Message Buffer 29 W Register */
#define CAN_B_CS30           CAN_B.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_B_ID30           CAN_B.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_B_B30            CAN_B.MB[30].DATA.B           /* Message Buffer 30 B Register */
#define CAN_B_H30            CAN_B.MB[30].DATA.H           /* Message Buffer 30 H Register */
#define CAN_B_W30            CAN_B.MB[30].DATA.W           /* Message Buffer 30 W Register */
#define CAN_B_CS31           CAN_B.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_B_ID31           CAN_B.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_B_B31            CAN_B.MB[31].DATA.B           /* Message Buffer 31 B Register */
#define CAN_B_H31            CAN_B.MB[31].DATA.H           /* Message Buffer 31 H Register */
#define CAN_B_W31            CAN_B.MB[31].DATA.W           /* Message Buffer 31 W Register */
#define CAN_B_CS32           CAN_B.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_B_ID32           CAN_B.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_B_B32            CAN_B.MB[32].DATA.B           /* Message Buffer 32 B Register */
#define CAN_B_H32            CAN_B.MB[32].DATA.H           /* Message Buffer 32 H Register */
#define CAN_B_W32            CAN_B.MB[32].DATA.W           /* Message Buffer 32 W Register */
#define CAN_B_CS33           CAN_B.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_B_ID33           CAN_B.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_B_B33            CAN_B.MB[33].DATA.B           /* Message Buffer 33 B Register */
#define CAN_B_H33            CAN_B.MB[33].DATA.H           /* Message Buffer 33 H Register */
#define CAN_B_W33            CAN_B.MB[33].DATA.W           /* Message Buffer 33 W Register */
#define CAN_B_CS34           CAN_B.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_B_ID34           CAN_B.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_B_B34            CAN_B.MB[34].DATA.B           /* Message Buffer 34 B Register */
#define CAN_B_H34            CAN_B.MB[34].DATA.H           /* Message Buffer 34 H Register */
#define CAN_B_W34            CAN_B.MB[34].DATA.W           /* Message Buffer 34 W Register */
#define CAN_B_CS35           CAN_B.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_B_ID35           CAN_B.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_B_B35            CAN_B.MB[35].DATA.B           /* Message Buffer 35 B Register */
#define CAN_B_H35            CAN_B.MB[35].DATA.H           /* Message Buffer 35 H Register */
#define CAN_B_W35            CAN_B.MB[35].DATA.W           /* Message Buffer 35 W Register */
#define CAN_B_CS36           CAN_B.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_B_ID36           CAN_B.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_B_B36            CAN_B.MB[36].DATA.B           /* Message Buffer 36 B Register */
#define CAN_B_H36            CAN_B.MB[36].DATA.H           /* Message Buffer 36 H Register */
#define CAN_B_W36            CAN_B.MB[36].DATA.W           /* Message Buffer 36 W Register */
#define CAN_B_CS37           CAN_B.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_B_ID37           CAN_B.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_B_B37            CAN_B.MB[37].DATA.B           /* Message Buffer 37 B Register */
#define CAN_B_H37            CAN_B.MB[37].DATA.H           /* Message Buffer 37 H Register */
#define CAN_B_W37            CAN_B.MB[37].DATA.W           /* Message Buffer 37 W Register */
#define CAN_B_CS38           CAN_B.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_B_ID38           CAN_B.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_B_B38            CAN_B.MB[38].DATA.B           /* Message Buffer 38 B Register */
#define CAN_B_H38            CAN_B.MB[38].DATA.H           /* Message Buffer 38 H Register */
#define CAN_B_W38            CAN_B.MB[38].DATA.W           /* Message Buffer 38 W Register */
#define CAN_B_CS39           CAN_B.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_B_ID39           CAN_B.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_B_B39            CAN_B.MB[39].DATA.B           /* Message Buffer 39 B Register */
#define CAN_B_H39            CAN_B.MB[39].DATA.H           /* Message Buffer 39 H Register */
#define CAN_B_W39            CAN_B.MB[39].DATA.W           /* Message Buffer 39 W Register */
#define CAN_B_CS40           CAN_B.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_B_ID40           CAN_B.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_B_B40            CAN_B.MB[40].DATA.B           /* Message Buffer 40 B Register */
#define CAN_B_H40            CAN_B.MB[40].DATA.H           /* Message Buffer 40 H Register */
#define CAN_B_W40            CAN_B.MB[40].DATA.W           /* Message Buffer 40 W Register */
#define CAN_B_CS41           CAN_B.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_B_ID41           CAN_B.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_B_B41            CAN_B.MB[41].DATA.B           /* Message Buffer 41 B Register */
#define CAN_B_H41            CAN_B.MB[41].DATA.H           /* Message Buffer 41 H Register */
#define CAN_B_W41            CAN_B.MB[41].DATA.W           /* Message Buffer 41 W Register */
#define CAN_B_CS42           CAN_B.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_B_ID42           CAN_B.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_B_B42            CAN_B.MB[42].DATA.B           /* Message Buffer 42 B Register */
#define CAN_B_H42            CAN_B.MB[42].DATA.H           /* Message Buffer 42 H Register */
#define CAN_B_W42            CAN_B.MB[42].DATA.W           /* Message Buffer 42 W Register */
#define CAN_B_CS43           CAN_B.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_B_ID43           CAN_B.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_B_B43            CAN_B.MB[43].DATA.B           /* Message Buffer 43 B Register */
#define CAN_B_H43            CAN_B.MB[43].DATA.H           /* Message Buffer 43 H Register */
#define CAN_B_W43            CAN_B.MB[43].DATA.W           /* Message Buffer 43 W Register */
#define CAN_B_CS44           CAN_B.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_B_ID44           CAN_B.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_B_B44            CAN_B.MB[44].DATA.B           /* Message Buffer 44 B Register */
#define CAN_B_H44            CAN_B.MB[44].DATA.H           /* Message Buffer 44 H Register */
#define CAN_B_W44            CAN_B.MB[44].DATA.W           /* Message Buffer 44 W Register */
#define CAN_B_CS45           CAN_B.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_B_ID45           CAN_B.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_B_B45            CAN_B.MB[45].DATA.B           /* Message Buffer 45 B Register */
#define CAN_B_H45            CAN_B.MB[45].DATA.H           /* Message Buffer 45 H Register */
#define CAN_B_W45            CAN_B.MB[45].DATA.W           /* Message Buffer 45 W Register */
#define CAN_B_CS46           CAN_B.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_B_ID46           CAN_B.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_B_B46            CAN_B.MB[46].DATA.B           /* Message Buffer 46 B Register */
#define CAN_B_H46            CAN_B.MB[46].DATA.H           /* Message Buffer 46 H Register */
#define CAN_B_W46            CAN_B.MB[46].DATA.W           /* Message Buffer 46 W Register */
#define CAN_B_CS47           CAN_B.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_B_ID47           CAN_B.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_B_B47            CAN_B.MB[47].DATA.B           /* Message Buffer 47 B Register */
#define CAN_B_H47            CAN_B.MB[47].DATA.H           /* Message Buffer 47 H Register */
#define CAN_B_W47            CAN_B.MB[47].DATA.W           /* Message Buffer 47 W Register */
#define CAN_B_CS48           CAN_B.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_B_ID48           CAN_B.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_B_B48            CAN_B.MB[48].DATA.B           /* Message Buffer 48 B Register */
#define CAN_B_H48            CAN_B.MB[48].DATA.H           /* Message Buffer 48 H Register */
#define CAN_B_W48            CAN_B.MB[48].DATA.W           /* Message Buffer 48 W Register */
#define CAN_B_CS49           CAN_B.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_B_ID49           CAN_B.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_B_B49            CAN_B.MB[49].DATA.B           /* Message Buffer 49 B Register */
#define CAN_B_H49            CAN_B.MB[49].DATA.H           /* Message Buffer 49 H Register */
#define CAN_B_W49            CAN_B.MB[49].DATA.W           /* Message Buffer 49 W Register */
#define CAN_B_CS50           CAN_B.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_B_ID50           CAN_B.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_B_B50            CAN_B.MB[50].DATA.B           /* Message Buffer 50 B Register */
#define CAN_B_H50            CAN_B.MB[50].DATA.H           /* Message Buffer 50 H Register */
#define CAN_B_W50            CAN_B.MB[50].DATA.W           /* Message Buffer 50 W Register */
#define CAN_B_CS51           CAN_B.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_B_ID51           CAN_B.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_B_B51            CAN_B.MB[51].DATA.B           /* Message Buffer 51 B Register */
#define CAN_B_H51            CAN_B.MB[51].DATA.H           /* Message Buffer 51 H Register */
#define CAN_B_W51            CAN_B.MB[51].DATA.W           /* Message Buffer 51 W Register */
#define CAN_B_CS52           CAN_B.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_B_ID52           CAN_B.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_B_B52            CAN_B.MB[52].DATA.B           /* Message Buffer 52 B Register */
#define CAN_B_H52            CAN_B.MB[52].DATA.H           /* Message Buffer 52 H Register */
#define CAN_B_W52            CAN_B.MB[52].DATA.W           /* Message Buffer 52 W Register */
#define CAN_B_CS53           CAN_B.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_B_ID53           CAN_B.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_B_B53            CAN_B.MB[53].DATA.B           /* Message Buffer 53 B Register */
#define CAN_B_H53            CAN_B.MB[53].DATA.H           /* Message Buffer 53 H Register */
#define CAN_B_W53            CAN_B.MB[53].DATA.W           /* Message Buffer 53 W Register */
#define CAN_B_CS54           CAN_B.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_B_ID54           CAN_B.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_B_B54            CAN_B.MB[54].DATA.B           /* Message Buffer 54 B Register */
#define CAN_B_H54            CAN_B.MB[54].DATA.H           /* Message Buffer 54 H Register */
#define CAN_B_W54            CAN_B.MB[54].DATA.W           /* Message Buffer 54 W Register */
#define CAN_B_CS55           CAN_B.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_B_ID55           CAN_B.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_B_B55            CAN_B.MB[55].DATA.B           /* Message Buffer 55 B Register */
#define CAN_B_H55            CAN_B.MB[55].DATA.H           /* Message Buffer 55 H Register */
#define CAN_B_W55            CAN_B.MB[55].DATA.W           /* Message Buffer 55 W Register */
#define CAN_B_CS56           CAN_B.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_B_ID56           CAN_B.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_B_B56            CAN_B.MB[56].DATA.B           /* Message Buffer 56 B Register */
#define CAN_B_H56            CAN_B.MB[56].DATA.H           /* Message Buffer 56 H Register */
#define CAN_B_W56            CAN_B.MB[56].DATA.W           /* Message Buffer 56 W Register */
#define CAN_B_CS57           CAN_B.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_B_ID57           CAN_B.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_B_B57            CAN_B.MB[57].DATA.B           /* Message Buffer 57 B Register */
#define CAN_B_H57            CAN_B.MB[57].DATA.H           /* Message Buffer 57 H Register */
#define CAN_B_W57            CAN_B.MB[57].DATA.W           /* Message Buffer 57 W Register */
#define CAN_B_CS58           CAN_B.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_B_ID58           CAN_B.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_B_B58            CAN_B.MB[58].DATA.B           /* Message Buffer 58 B Register */
#define CAN_B_H58            CAN_B.MB[58].DATA.H           /* Message Buffer 58 H Register */
#define CAN_B_W58            CAN_B.MB[58].DATA.W           /* Message Buffer 58 W Register */
#define CAN_B_CS59           CAN_B.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_B_ID59           CAN_B.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_B_B59            CAN_B.MB[59].DATA.B           /* Message Buffer 59 B Register */
#define CAN_B_H59            CAN_B.MB[59].DATA.H           /* Message Buffer 59 H Register */
#define CAN_B_W59            CAN_B.MB[59].DATA.W           /* Message Buffer 59 W Register */
#define CAN_B_CS60           CAN_B.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_B_ID60           CAN_B.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_B_B60            CAN_B.MB[60].DATA.B           /* Message Buffer 60 B Register */
#define CAN_B_H60            CAN_B.MB[60].DATA.H           /* Message Buffer 60 H Register */
#define CAN_B_W60            CAN_B.MB[60].DATA.W           /* Message Buffer 60 W Register */
#define CAN_B_CS61           CAN_B.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_B_ID61           CAN_B.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_B_B61            CAN_B.MB[61].DATA.B           /* Message Buffer 61 B Register */
#define CAN_B_H61            CAN_B.MB[61].DATA.H           /* Message Buffer 61 H Register */
#define CAN_B_W61            CAN_B.MB[61].DATA.W           /* Message Buffer 61 W Register */
#define CAN_B_CS62           CAN_B.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_B_ID62           CAN_B.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_B_B62            CAN_B.MB[62].DATA.B           /* Message Buffer 62 B Register */
#define CAN_B_H62            CAN_B.MB[62].DATA.H           /* Message Buffer 62 H Register */
#define CAN_B_W62            CAN_B.MB[62].DATA.W           /* Message Buffer 62 W Register */
#define CAN_B_CS63           CAN_B.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_B_ID63           CAN_B.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_B_B63            CAN_B.MB[63].DATA.B           /* Message Buffer 63 B Register */
#define CAN_B_H63            CAN_B.MB[63].DATA.H           /* Message Buffer 63 H Register */
#define CAN_B_W63            CAN_B.MB[63].DATA.W           /* Message Buffer 63 W Register */
#define CAN_B_RXIMR0         CAN_B.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_B_RXIMR1         CAN_B.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_B_RXIMR2         CAN_B.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_B_RXIMR3         CAN_B.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_B_RXIMR4         CAN_B.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_B_RXIMR5         CAN_B.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_B_RXIMR6         CAN_B.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_B_RXIMR7         CAN_B.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_B_RXIMR8         CAN_B.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_B_RXIMR9         CAN_B.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_B_RXIMR10        CAN_B.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR11        CAN_B.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR12        CAN_B.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR13        CAN_B.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR14        CAN_B.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR15        CAN_B.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR16        CAN_B.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR17        CAN_B.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR18        CAN_B.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR19        CAN_B.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR20        CAN_B.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR21        CAN_B.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR22        CAN_B.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR23        CAN_B.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR24        CAN_B.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR25        CAN_B.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR26        CAN_B.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR27        CAN_B.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR28        CAN_B.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR29        CAN_B.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR30        CAN_B.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR31        CAN_B.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR32        CAN_B.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR33        CAN_B.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR34        CAN_B.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR35        CAN_B.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR36        CAN_B.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR37        CAN_B.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR38        CAN_B.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR39        CAN_B.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR40        CAN_B.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR41        CAN_B.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR42        CAN_B.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR43        CAN_B.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR44        CAN_B.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR45        CAN_B.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR46        CAN_B.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR47        CAN_B.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR48        CAN_B.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR49        CAN_B.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR50        CAN_B.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR51        CAN_B.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR52        CAN_B.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR53        CAN_B.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR54        CAN_B.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR55        CAN_B.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR56        CAN_B.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR57        CAN_B.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR58        CAN_B.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR59        CAN_B.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR60        CAN_B.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR61        CAN_B.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR62        CAN_B.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_B_RXIMR63        CAN_B.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_B_MECR           CAN_B.MECR.R                  /* Memory Error Control Register */
#define CAN_B_ERRIAR         CAN_B.ERRIAR.R                /* Error Injection Address Register */
#define CAN_B_ERRIDPR        CAN_B.ERRIDPR.R               /* Error Injection Data Pattern Register */
#define CAN_B_ERRIPPR        CAN_B.ERRIPPR.R               /* Error Injection Parity Pattern Register */
#define CAN_B_RERRAR         CAN_B.RERRAR.R                /* Error Report Address Register */
#define CAN_B_RERRDR         CAN_B.RERRDR.R                /* Error Report Data Register */
#define CAN_B_RERRSYNR       CAN_B.RERRSYNR.R              /* Error Report Syndrome Register */
#define CAN_B_ERRSR          CAN_B.ERRSR.R                 /* Error Status Register */

#define CAN_C_MCR            CAN_C.MCR.R                   /* Module Configuration Register */
#define CAN_C_CTRL1          CAN_C.CTRL1.R                 /* Control 1 register */
#define CAN_C_TIMER          CAN_C.TIMER.R                 /* Free Running Timer */
#define CAN_C_RXMGMASK       CAN_C.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_C_RX14MASK       CAN_C.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_C_RX15MASK       CAN_C.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_C_ECR            CAN_C.ECR.R                   /* Error Counter */
#define CAN_C_ESR1           CAN_C.ESR1.R                  /* Error and Status 1 register */
#define CAN_C_IMASK2         CAN_C.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_C_IMASK1         CAN_C.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_C_IFLAG2         CAN_C.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_C_IFLAG1         CAN_C.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_C_CTRL2          CAN_C.CTRL2.R                 /* Control 2 register */
#define CAN_C_ESR2           CAN_C.ESR2.R                  /* Error and Status 2 register */
#define CAN_C_CRCR           CAN_C.CRCR.R                  /* CRC Register */
#define CAN_C_RXFGMASK       CAN_C.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_C_RXFIR          CAN_C.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_C_CS0            CAN_C.MB[0].CS.R              /* Message Buffer 0 CS Register */
#define CAN_C_ID0            CAN_C.MB[0].ID.R              /* Message Buffer 0 ID Register */
#define CAN_C_B0             CAN_C.MB[0].DATA.B            /* Message Buffer 0 B Register */
#define CAN_C_H0             CAN_C.MB[0].DATA.H            /* Message Buffer 0 H Register */
#define CAN_C_W0             CAN_C.MB[0].DATA.W            /* Message Buffer 0 W Register */
#define CAN_C_CS1            CAN_C.MB[1].CS.R              /* Message Buffer 1 CS Register */
#define CAN_C_ID1            CAN_C.MB[1].ID.R              /* Message Buffer 1 ID Register */
#define CAN_C_B1             CAN_C.MB[1].DATA.B            /* Message Buffer 1 B Register */
#define CAN_C_H1             CAN_C.MB[1].DATA.H            /* Message Buffer 1 H Register */
#define CAN_C_W1             CAN_C.MB[1].DATA.W            /* Message Buffer 1 W Register */
#define CAN_C_CS2            CAN_C.MB[2].CS.R              /* Message Buffer 2 CS Register */
#define CAN_C_ID2            CAN_C.MB[2].ID.R              /* Message Buffer 2 ID Register */
#define CAN_C_B2             CAN_C.MB[2].DATA.B            /* Message Buffer 2 B Register */
#define CAN_C_H2             CAN_C.MB[2].DATA.H            /* Message Buffer 2 H Register */
#define CAN_C_W2             CAN_C.MB[2].DATA.W            /* Message Buffer 2 W Register */
#define CAN_C_CS3            CAN_C.MB[3].CS.R              /* Message Buffer 3 CS Register */
#define CAN_C_ID3            CAN_C.MB[3].ID.R              /* Message Buffer 3 ID Register */
#define CAN_C_B3             CAN_C.MB[3].DATA.B            /* Message Buffer 3 B Register */
#define CAN_C_H3             CAN_C.MB[3].DATA.H            /* Message Buffer 3 H Register */
#define CAN_C_W3             CAN_C.MB[3].DATA.W            /* Message Buffer 3 W Register */
#define CAN_C_CS4            CAN_C.MB[4].CS.R              /* Message Buffer 4 CS Register */
#define CAN_C_ID4            CAN_C.MB[4].ID.R              /* Message Buffer 4 ID Register */
#define CAN_C_B4             CAN_C.MB[4].DATA.B            /* Message Buffer 4 B Register */
#define CAN_C_H4             CAN_C.MB[4].DATA.H            /* Message Buffer 4 H Register */
#define CAN_C_W4             CAN_C.MB[4].DATA.W            /* Message Buffer 4 W Register */
#define CAN_C_CS5            CAN_C.MB[5].CS.R              /* Message Buffer 5 CS Register */
#define CAN_C_ID5            CAN_C.MB[5].ID.R              /* Message Buffer 5 ID Register */
#define CAN_C_B5             CAN_C.MB[5].DATA.B            /* Message Buffer 5 B Register */
#define CAN_C_H5             CAN_C.MB[5].DATA.H            /* Message Buffer 5 H Register */
#define CAN_C_W5             CAN_C.MB[5].DATA.W            /* Message Buffer 5 W Register */
#define CAN_C_CS6            CAN_C.MB[6].CS.R              /* Message Buffer 6 CS Register */
#define CAN_C_ID6            CAN_C.MB[6].ID.R              /* Message Buffer 6 ID Register */
#define CAN_C_B6             CAN_C.MB[6].DATA.B            /* Message Buffer 6 B Register */
#define CAN_C_H6             CAN_C.MB[6].DATA.H            /* Message Buffer 6 H Register */
#define CAN_C_W6             CAN_C.MB[6].DATA.W            /* Message Buffer 6 W Register */
#define CAN_C_CS7            CAN_C.MB[7].CS.R              /* Message Buffer 7 CS Register */
#define CAN_C_ID7            CAN_C.MB[7].ID.R              /* Message Buffer 7 ID Register */
#define CAN_C_B7             CAN_C.MB[7].DATA.B            /* Message Buffer 7 B Register */
#define CAN_C_H7             CAN_C.MB[7].DATA.H            /* Message Buffer 7 H Register */
#define CAN_C_W7             CAN_C.MB[7].DATA.W            /* Message Buffer 7 W Register */
#define CAN_C_CS8            CAN_C.MB[8].CS.R              /* Message Buffer 8 CS Register */
#define CAN_C_ID8            CAN_C.MB[8].ID.R              /* Message Buffer 8 ID Register */
#define CAN_C_B8             CAN_C.MB[8].DATA.B            /* Message Buffer 8 B Register */
#define CAN_C_H8             CAN_C.MB[8].DATA.H            /* Message Buffer 8 H Register */
#define CAN_C_W8             CAN_C.MB[8].DATA.W            /* Message Buffer 8 W Register */
#define CAN_C_CS9            CAN_C.MB[9].CS.R              /* Message Buffer 9 CS Register */
#define CAN_C_ID9            CAN_C.MB[9].ID.R              /* Message Buffer 9 ID Register */
#define CAN_C_B9             CAN_C.MB[9].DATA.B            /* Message Buffer 9 B Register */
#define CAN_C_H9             CAN_C.MB[9].DATA.H            /* Message Buffer 9 H Register */
#define CAN_C_W9             CAN_C.MB[9].DATA.W            /* Message Buffer 9 W Register */
#define CAN_C_CS10           CAN_C.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_C_ID10           CAN_C.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_C_B10            CAN_C.MB[10].DATA.B           /* Message Buffer 10 B Register */
#define CAN_C_H10            CAN_C.MB[10].DATA.H           /* Message Buffer 10 H Register */
#define CAN_C_W10            CAN_C.MB[10].DATA.W           /* Message Buffer 10 W Register */
#define CAN_C_CS11           CAN_C.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_C_ID11           CAN_C.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_C_B11            CAN_C.MB[11].DATA.B           /* Message Buffer 11 B Register */
#define CAN_C_H11            CAN_C.MB[11].DATA.H           /* Message Buffer 11 H Register */
#define CAN_C_W11            CAN_C.MB[11].DATA.W           /* Message Buffer 11 W Register */
#define CAN_C_CS12           CAN_C.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_C_ID12           CAN_C.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_C_B12            CAN_C.MB[12].DATA.B           /* Message Buffer 12 B Register */
#define CAN_C_H12            CAN_C.MB[12].DATA.H           /* Message Buffer 12 H Register */
#define CAN_C_W12            CAN_C.MB[12].DATA.W           /* Message Buffer 12 W Register */
#define CAN_C_CS13           CAN_C.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_C_ID13           CAN_C.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_C_B13            CAN_C.MB[13].DATA.B           /* Message Buffer 13 B Register */
#define CAN_C_H13            CAN_C.MB[13].DATA.H           /* Message Buffer 13 H Register */
#define CAN_C_W13            CAN_C.MB[13].DATA.W           /* Message Buffer 13 W Register */
#define CAN_C_CS14           CAN_C.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_C_ID14           CAN_C.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_C_B14            CAN_C.MB[14].DATA.B           /* Message Buffer 14 B Register */
#define CAN_C_H14            CAN_C.MB[14].DATA.H           /* Message Buffer 14 H Register */
#define CAN_C_W14            CAN_C.MB[14].DATA.W           /* Message Buffer 14 W Register */
#define CAN_C_CS15           CAN_C.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_C_ID15           CAN_C.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_C_B15            CAN_C.MB[15].DATA.B           /* Message Buffer 15 B Register */
#define CAN_C_H15            CAN_C.MB[15].DATA.H           /* Message Buffer 15 H Register */
#define CAN_C_W15            CAN_C.MB[15].DATA.W           /* Message Buffer 15 W Register */
#define CAN_C_CS16           CAN_C.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_C_ID16           CAN_C.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_C_B16            CAN_C.MB[16].DATA.B           /* Message Buffer 16 B Register */
#define CAN_C_H16            CAN_C.MB[16].DATA.H           /* Message Buffer 16 H Register */
#define CAN_C_W16            CAN_C.MB[16].DATA.W           /* Message Buffer 16 W Register */
#define CAN_C_CS17           CAN_C.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_C_ID17           CAN_C.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_C_B17            CAN_C.MB[17].DATA.B           /* Message Buffer 17 B Register */
#define CAN_C_H17            CAN_C.MB[17].DATA.H           /* Message Buffer 17 H Register */
#define CAN_C_W17            CAN_C.MB[17].DATA.W           /* Message Buffer 17 W Register */
#define CAN_C_CS18           CAN_C.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_C_ID18           CAN_C.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_C_B18            CAN_C.MB[18].DATA.B           /* Message Buffer 18 B Register */
#define CAN_C_H18            CAN_C.MB[18].DATA.H           /* Message Buffer 18 H Register */
#define CAN_C_W18            CAN_C.MB[18].DATA.W           /* Message Buffer 18 W Register */
#define CAN_C_CS19           CAN_C.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_C_ID19           CAN_C.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_C_B19            CAN_C.MB[19].DATA.B           /* Message Buffer 19 B Register */
#define CAN_C_H19            CAN_C.MB[19].DATA.H           /* Message Buffer 19 H Register */
#define CAN_C_W19            CAN_C.MB[19].DATA.W           /* Message Buffer 19 W Register */
#define CAN_C_CS20           CAN_C.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_C_ID20           CAN_C.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_C_B20            CAN_C.MB[20].DATA.B           /* Message Buffer 20 B Register */
#define CAN_C_H20            CAN_C.MB[20].DATA.H           /* Message Buffer 20 H Register */
#define CAN_C_W20            CAN_C.MB[20].DATA.W           /* Message Buffer 20 W Register */
#define CAN_C_CS21           CAN_C.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_C_ID21           CAN_C.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_C_B21            CAN_C.MB[21].DATA.B           /* Message Buffer 21 B Register */
#define CAN_C_H21            CAN_C.MB[21].DATA.H           /* Message Buffer 21 H Register */
#define CAN_C_W21            CAN_C.MB[21].DATA.W           /* Message Buffer 21 W Register */
#define CAN_C_CS22           CAN_C.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_C_ID22           CAN_C.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_C_B22            CAN_C.MB[22].DATA.B           /* Message Buffer 22 B Register */
#define CAN_C_H22            CAN_C.MB[22].DATA.H           /* Message Buffer 22 H Register */
#define CAN_C_W22            CAN_C.MB[22].DATA.W           /* Message Buffer 22 W Register */
#define CAN_C_CS23           CAN_C.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_C_ID23           CAN_C.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_C_B23            CAN_C.MB[23].DATA.B           /* Message Buffer 23 B Register */
#define CAN_C_H23            CAN_C.MB[23].DATA.H           /* Message Buffer 23 H Register */
#define CAN_C_W23            CAN_C.MB[23].DATA.W           /* Message Buffer 23 W Register */
#define CAN_C_CS24           CAN_C.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_C_ID24           CAN_C.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_C_B24            CAN_C.MB[24].DATA.B           /* Message Buffer 24 B Register */
#define CAN_C_H24            CAN_C.MB[24].DATA.H           /* Message Buffer 24 H Register */
#define CAN_C_W24            CAN_C.MB[24].DATA.W           /* Message Buffer 24 W Register */
#define CAN_C_CS25           CAN_C.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_C_ID25           CAN_C.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_C_B25            CAN_C.MB[25].DATA.B           /* Message Buffer 25 B Register */
#define CAN_C_H25            CAN_C.MB[25].DATA.H           /* Message Buffer 25 H Register */
#define CAN_C_W25            CAN_C.MB[25].DATA.W           /* Message Buffer 25 W Register */
#define CAN_C_CS26           CAN_C.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_C_ID26           CAN_C.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_C_B26            CAN_C.MB[26].DATA.B           /* Message Buffer 26 B Register */
#define CAN_C_H26            CAN_C.MB[26].DATA.H           /* Message Buffer 26 H Register */
#define CAN_C_W26            CAN_C.MB[26].DATA.W           /* Message Buffer 26 W Register */
#define CAN_C_CS27           CAN_C.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_C_ID27           CAN_C.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_C_B27            CAN_C.MB[27].DATA.B           /* Message Buffer 27 B Register */
#define CAN_C_H27            CAN_C.MB[27].DATA.H           /* Message Buffer 27 H Register */
#define CAN_C_W27            CAN_C.MB[27].DATA.W           /* Message Buffer 27 W Register */
#define CAN_C_CS28           CAN_C.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_C_ID28           CAN_C.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_C_B28            CAN_C.MB[28].DATA.B           /* Message Buffer 28 B Register */
#define CAN_C_H28            CAN_C.MB[28].DATA.H           /* Message Buffer 28 H Register */
#define CAN_C_W28            CAN_C.MB[28].DATA.W           /* Message Buffer 28 W Register */
#define CAN_C_CS29           CAN_C.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_C_ID29           CAN_C.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_C_B29            CAN_C.MB[29].DATA.B           /* Message Buffer 29 B Register */
#define CAN_C_H29            CAN_C.MB[29].DATA.H           /* Message Buffer 29 H Register */
#define CAN_C_W29            CAN_C.MB[29].DATA.W           /* Message Buffer 29 W Register */
#define CAN_C_CS30           CAN_C.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_C_ID30           CAN_C.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_C_B30            CAN_C.MB[30].DATA.B           /* Message Buffer 30 B Register */
#define CAN_C_H30            CAN_C.MB[30].DATA.H           /* Message Buffer 30 H Register */
#define CAN_C_W30            CAN_C.MB[30].DATA.W           /* Message Buffer 30 W Register */
#define CAN_C_CS31           CAN_C.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_C_ID31           CAN_C.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_C_B31            CAN_C.MB[31].DATA.B           /* Message Buffer 31 B Register */
#define CAN_C_H31            CAN_C.MB[31].DATA.H           /* Message Buffer 31 H Register */
#define CAN_C_W31            CAN_C.MB[31].DATA.W           /* Message Buffer 31 W Register */
#define CAN_C_CS32           CAN_C.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_C_ID32           CAN_C.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_C_B32            CAN_C.MB[32].DATA.B           /* Message Buffer 32 B Register */
#define CAN_C_H32            CAN_C.MB[32].DATA.H           /* Message Buffer 32 H Register */
#define CAN_C_W32            CAN_C.MB[32].DATA.W           /* Message Buffer 32 W Register */
#define CAN_C_CS33           CAN_C.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_C_ID33           CAN_C.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_C_B33            CAN_C.MB[33].DATA.B           /* Message Buffer 33 B Register */
#define CAN_C_H33            CAN_C.MB[33].DATA.H           /* Message Buffer 33 H Register */
#define CAN_C_W33            CAN_C.MB[33].DATA.W           /* Message Buffer 33 W Register */
#define CAN_C_CS34           CAN_C.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_C_ID34           CAN_C.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_C_B34            CAN_C.MB[34].DATA.B           /* Message Buffer 34 B Register */
#define CAN_C_H34            CAN_C.MB[34].DATA.H           /* Message Buffer 34 H Register */
#define CAN_C_W34            CAN_C.MB[34].DATA.W           /* Message Buffer 34 W Register */
#define CAN_C_CS35           CAN_C.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_C_ID35           CAN_C.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_C_B35            CAN_C.MB[35].DATA.B           /* Message Buffer 35 B Register */
#define CAN_C_H35            CAN_C.MB[35].DATA.H           /* Message Buffer 35 H Register */
#define CAN_C_W35            CAN_C.MB[35].DATA.W           /* Message Buffer 35 W Register */
#define CAN_C_CS36           CAN_C.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_C_ID36           CAN_C.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_C_B36            CAN_C.MB[36].DATA.B           /* Message Buffer 36 B Register */
#define CAN_C_H36            CAN_C.MB[36].DATA.H           /* Message Buffer 36 H Register */
#define CAN_C_W36            CAN_C.MB[36].DATA.W           /* Message Buffer 36 W Register */
#define CAN_C_CS37           CAN_C.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_C_ID37           CAN_C.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_C_B37            CAN_C.MB[37].DATA.B           /* Message Buffer 37 B Register */
#define CAN_C_H37            CAN_C.MB[37].DATA.H           /* Message Buffer 37 H Register */
#define CAN_C_W37            CAN_C.MB[37].DATA.W           /* Message Buffer 37 W Register */
#define CAN_C_CS38           CAN_C.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_C_ID38           CAN_C.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_C_B38            CAN_C.MB[38].DATA.B           /* Message Buffer 38 B Register */
#define CAN_C_H38            CAN_C.MB[38].DATA.H           /* Message Buffer 38 H Register */
#define CAN_C_W38            CAN_C.MB[38].DATA.W           /* Message Buffer 38 W Register */
#define CAN_C_CS39           CAN_C.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_C_ID39           CAN_C.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_C_B39            CAN_C.MB[39].DATA.B           /* Message Buffer 39 B Register */
#define CAN_C_H39            CAN_C.MB[39].DATA.H           /* Message Buffer 39 H Register */
#define CAN_C_W39            CAN_C.MB[39].DATA.W           /* Message Buffer 39 W Register */
#define CAN_C_CS40           CAN_C.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_C_ID40           CAN_C.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_C_B40            CAN_C.MB[40].DATA.B           /* Message Buffer 40 B Register */
#define CAN_C_H40            CAN_C.MB[40].DATA.H           /* Message Buffer 40 H Register */
#define CAN_C_W40            CAN_C.MB[40].DATA.W           /* Message Buffer 40 W Register */
#define CAN_C_CS41           CAN_C.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_C_ID41           CAN_C.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_C_B41            CAN_C.MB[41].DATA.B           /* Message Buffer 41 B Register */
#define CAN_C_H41            CAN_C.MB[41].DATA.H           /* Message Buffer 41 H Register */
#define CAN_C_W41            CAN_C.MB[41].DATA.W           /* Message Buffer 41 W Register */
#define CAN_C_CS42           CAN_C.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_C_ID42           CAN_C.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_C_B42            CAN_C.MB[42].DATA.B           /* Message Buffer 42 B Register */
#define CAN_C_H42            CAN_C.MB[42].DATA.H           /* Message Buffer 42 H Register */
#define CAN_C_W42            CAN_C.MB[42].DATA.W           /* Message Buffer 42 W Register */
#define CAN_C_CS43           CAN_C.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_C_ID43           CAN_C.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_C_B43            CAN_C.MB[43].DATA.B           /* Message Buffer 43 B Register */
#define CAN_C_H43            CAN_C.MB[43].DATA.H           /* Message Buffer 43 H Register */
#define CAN_C_W43            CAN_C.MB[43].DATA.W           /* Message Buffer 43 W Register */
#define CAN_C_CS44           CAN_C.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_C_ID44           CAN_C.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_C_B44            CAN_C.MB[44].DATA.B           /* Message Buffer 44 B Register */
#define CAN_C_H44            CAN_C.MB[44].DATA.H           /* Message Buffer 44 H Register */
#define CAN_C_W44            CAN_C.MB[44].DATA.W           /* Message Buffer 44 W Register */
#define CAN_C_CS45           CAN_C.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_C_ID45           CAN_C.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_C_B45            CAN_C.MB[45].DATA.B           /* Message Buffer 45 B Register */
#define CAN_C_H45            CAN_C.MB[45].DATA.H           /* Message Buffer 45 H Register */
#define CAN_C_W45            CAN_C.MB[45].DATA.W           /* Message Buffer 45 W Register */
#define CAN_C_CS46           CAN_C.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_C_ID46           CAN_C.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_C_B46            CAN_C.MB[46].DATA.B           /* Message Buffer 46 B Register */
#define CAN_C_H46            CAN_C.MB[46].DATA.H           /* Message Buffer 46 H Register */
#define CAN_C_W46            CAN_C.MB[46].DATA.W           /* Message Buffer 46 W Register */
#define CAN_C_CS47           CAN_C.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_C_ID47           CAN_C.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_C_B47            CAN_C.MB[47].DATA.B           /* Message Buffer 47 B Register */
#define CAN_C_H47            CAN_C.MB[47].DATA.H           /* Message Buffer 47 H Register */
#define CAN_C_W47            CAN_C.MB[47].DATA.W           /* Message Buffer 47 W Register */
#define CAN_C_CS48           CAN_C.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_C_ID48           CAN_C.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_C_B48            CAN_C.MB[48].DATA.B           /* Message Buffer 48 B Register */
#define CAN_C_H48            CAN_C.MB[48].DATA.H           /* Message Buffer 48 H Register */
#define CAN_C_W48            CAN_C.MB[48].DATA.W           /* Message Buffer 48 W Register */
#define CAN_C_CS49           CAN_C.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_C_ID49           CAN_C.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_C_B49            CAN_C.MB[49].DATA.B           /* Message Buffer 49 B Register */
#define CAN_C_H49            CAN_C.MB[49].DATA.H           /* Message Buffer 49 H Register */
#define CAN_C_W49            CAN_C.MB[49].DATA.W           /* Message Buffer 49 W Register */
#define CAN_C_CS50           CAN_C.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_C_ID50           CAN_C.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_C_B50            CAN_C.MB[50].DATA.B           /* Message Buffer 50 B Register */
#define CAN_C_H50            CAN_C.MB[50].DATA.H           /* Message Buffer 50 H Register */
#define CAN_C_W50            CAN_C.MB[50].DATA.W           /* Message Buffer 50 W Register */
#define CAN_C_CS51           CAN_C.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_C_ID51           CAN_C.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_C_B51            CAN_C.MB[51].DATA.B           /* Message Buffer 51 B Register */
#define CAN_C_H51            CAN_C.MB[51].DATA.H           /* Message Buffer 51 H Register */
#define CAN_C_W51            CAN_C.MB[51].DATA.W           /* Message Buffer 51 W Register */
#define CAN_C_CS52           CAN_C.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_C_ID52           CAN_C.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_C_B52            CAN_C.MB[52].DATA.B           /* Message Buffer 52 B Register */
#define CAN_C_H52            CAN_C.MB[52].DATA.H           /* Message Buffer 52 H Register */
#define CAN_C_W52            CAN_C.MB[52].DATA.W           /* Message Buffer 52 W Register */
#define CAN_C_CS53           CAN_C.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_C_ID53           CAN_C.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_C_B53            CAN_C.MB[53].DATA.B           /* Message Buffer 53 B Register */
#define CAN_C_H53            CAN_C.MB[53].DATA.H           /* Message Buffer 53 H Register */
#define CAN_C_W53            CAN_C.MB[53].DATA.W           /* Message Buffer 53 W Register */
#define CAN_C_CS54           CAN_C.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_C_ID54           CAN_C.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_C_B54            CAN_C.MB[54].DATA.B           /* Message Buffer 54 B Register */
#define CAN_C_H54            CAN_C.MB[54].DATA.H           /* Message Buffer 54 H Register */
#define CAN_C_W54            CAN_C.MB[54].DATA.W           /* Message Buffer 54 W Register */
#define CAN_C_CS55           CAN_C.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_C_ID55           CAN_C.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_C_B55            CAN_C.MB[55].DATA.B           /* Message Buffer 55 B Register */
#define CAN_C_H55            CAN_C.MB[55].DATA.H           /* Message Buffer 55 H Register */
#define CAN_C_W55            CAN_C.MB[55].DATA.W           /* Message Buffer 55 W Register */
#define CAN_C_CS56           CAN_C.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_C_ID56           CAN_C.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_C_B56            CAN_C.MB[56].DATA.B           /* Message Buffer 56 B Register */
#define CAN_C_H56            CAN_C.MB[56].DATA.H           /* Message Buffer 56 H Register */
#define CAN_C_W56            CAN_C.MB[56].DATA.W           /* Message Buffer 56 W Register */
#define CAN_C_CS57           CAN_C.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_C_ID57           CAN_C.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_C_B57            CAN_C.MB[57].DATA.B           /* Message Buffer 57 B Register */
#define CAN_C_H57            CAN_C.MB[57].DATA.H           /* Message Buffer 57 H Register */
#define CAN_C_W57            CAN_C.MB[57].DATA.W           /* Message Buffer 57 W Register */
#define CAN_C_CS58           CAN_C.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_C_ID58           CAN_C.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_C_B58            CAN_C.MB[58].DATA.B           /* Message Buffer 58 B Register */
#define CAN_C_H58            CAN_C.MB[58].DATA.H           /* Message Buffer 58 H Register */
#define CAN_C_W58            CAN_C.MB[58].DATA.W           /* Message Buffer 58 W Register */
#define CAN_C_CS59           CAN_C.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_C_ID59           CAN_C.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_C_B59            CAN_C.MB[59].DATA.B           /* Message Buffer 59 B Register */
#define CAN_C_H59            CAN_C.MB[59].DATA.H           /* Message Buffer 59 H Register */
#define CAN_C_W59            CAN_C.MB[59].DATA.W           /* Message Buffer 59 W Register */
#define CAN_C_CS60           CAN_C.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_C_ID60           CAN_C.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_C_B60            CAN_C.MB[60].DATA.B           /* Message Buffer 60 B Register */
#define CAN_C_H60            CAN_C.MB[60].DATA.H           /* Message Buffer 60 H Register */
#define CAN_C_W60            CAN_C.MB[60].DATA.W           /* Message Buffer 60 W Register */
#define CAN_C_CS61           CAN_C.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_C_ID61           CAN_C.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_C_B61            CAN_C.MB[61].DATA.B           /* Message Buffer 61 B Register */
#define CAN_C_H61            CAN_C.MB[61].DATA.H           /* Message Buffer 61 H Register */
#define CAN_C_W61            CAN_C.MB[61].DATA.W           /* Message Buffer 61 W Register */
#define CAN_C_CS62           CAN_C.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_C_ID62           CAN_C.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_C_B62            CAN_C.MB[62].DATA.B           /* Message Buffer 62 B Register */
#define CAN_C_H62            CAN_C.MB[62].DATA.H           /* Message Buffer 62 H Register */
#define CAN_C_W62            CAN_C.MB[62].DATA.W           /* Message Buffer 62 W Register */
#define CAN_C_CS63           CAN_C.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_C_ID63           CAN_C.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_C_B63            CAN_C.MB[63].DATA.B           /* Message Buffer 63 B Register */
#define CAN_C_H63            CAN_C.MB[63].DATA.H           /* Message Buffer 63 H Register */
#define CAN_C_W63            CAN_C.MB[63].DATA.W           /* Message Buffer 63 W Register */
#define CAN_C_RXIMR0         CAN_C.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_C_RXIMR1         CAN_C.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_C_RXIMR2         CAN_C.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_C_RXIMR3         CAN_C.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_C_RXIMR4         CAN_C.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_C_RXIMR5         CAN_C.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_C_RXIMR6         CAN_C.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_C_RXIMR7         CAN_C.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_C_RXIMR8         CAN_C.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_C_RXIMR9         CAN_C.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_C_RXIMR10        CAN_C.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR11        CAN_C.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR12        CAN_C.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR13        CAN_C.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR14        CAN_C.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR15        CAN_C.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR16        CAN_C.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR17        CAN_C.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR18        CAN_C.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR19        CAN_C.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR20        CAN_C.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR21        CAN_C.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR22        CAN_C.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR23        CAN_C.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR24        CAN_C.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR25        CAN_C.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR26        CAN_C.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR27        CAN_C.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR28        CAN_C.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR29        CAN_C.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR30        CAN_C.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR31        CAN_C.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR32        CAN_C.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR33        CAN_C.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR34        CAN_C.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR35        CAN_C.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR36        CAN_C.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR37        CAN_C.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR38        CAN_C.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR39        CAN_C.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR40        CAN_C.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR41        CAN_C.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR42        CAN_C.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR43        CAN_C.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR44        CAN_C.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR45        CAN_C.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR46        CAN_C.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR47        CAN_C.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR48        CAN_C.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR49        CAN_C.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR50        CAN_C.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR51        CAN_C.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR52        CAN_C.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR53        CAN_C.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR54        CAN_C.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR55        CAN_C.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR56        CAN_C.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR57        CAN_C.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR58        CAN_C.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR59        CAN_C.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR60        CAN_C.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR61        CAN_C.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR62        CAN_C.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_C_RXIMR63        CAN_C.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_C_MECR           CAN_C.MECR.R                  /* Memory Error Control Register */
#define CAN_C_ERRIAR         CAN_C.ERRIAR.R                /* Error Injection Address Register */
#define CAN_C_ERRIDPR        CAN_C.ERRIDPR.R               /* Error Injection Data Pattern Register */
#define CAN_C_ERRIPPR        CAN_C.ERRIPPR.R               /* Error Injection Parity Pattern Register */
#define CAN_C_RERRAR         CAN_C.RERRAR.R                /* Error Report Address Register */
#define CAN_C_RERRDR         CAN_C.RERRDR.R                /* Error Report Data Register */
#define CAN_C_RERRSYNR       CAN_C.RERRSYNR.R              /* Error Report Syndrome Register */
#define CAN_C_ERRSR          CAN_C.ERRSR.R                 /* Error Status Register */

#define CAN_D_MCR            CAN_D.MCR.R                   /* Module Configuration Register */
#define CAN_D_CTRL1          CAN_D.CTRL1.R                 /* Control 1 register */
#define CAN_D_TIMER          CAN_D.TIMER.R                 /* Free Running Timer */
#define CAN_D_RXMGMASK       CAN_D.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_D_RX14MASK       CAN_D.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_D_RX15MASK       CAN_D.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_D_ECR            CAN_D.ECR.R                   /* Error Counter */
#define CAN_D_ESR1           CAN_D.ESR1.R                  /* Error and Status 1 register */
#define CAN_D_IMASK2         CAN_D.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_D_IMASK1         CAN_D.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_D_IFLAG2         CAN_D.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_D_IFLAG1         CAN_D.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_D_CTRL2          CAN_D.CTRL2.R                 /* Control 2 register */
#define CAN_D_ESR2           CAN_D.ESR2.R                  /* Error and Status 2 register */
#define CAN_D_CRCR           CAN_D.CRCR.R                  /* CRC Register */
#define CAN_D_RXFGMASK       CAN_D.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_D_RXFIR          CAN_D.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_D_CS0            CAN_D.MB[0].CS.R              /* Message Buffer 0 CS Register */
#define CAN_D_ID0            CAN_D.MB[0].ID.R              /* Message Buffer 0 ID Register */
#define CAN_D_B0             CAN_D.MB[0].DATA.B            /* Message Buffer 0 B Register */
#define CAN_D_H0             CAN_D.MB[0].DATA.H            /* Message Buffer 0 H Register */
#define CAN_D_W0             CAN_D.MB[0].DATA.W            /* Message Buffer 0 W Register */
#define CAN_D_CS1            CAN_D.MB[1].CS.R              /* Message Buffer 1 CS Register */
#define CAN_D_ID1            CAN_D.MB[1].ID.R              /* Message Buffer 1 ID Register */
#define CAN_D_B1             CAN_D.MB[1].DATA.B            /* Message Buffer 1 B Register */
#define CAN_D_H1             CAN_D.MB[1].DATA.H            /* Message Buffer 1 H Register */
#define CAN_D_W1             CAN_D.MB[1].DATA.W            /* Message Buffer 1 W Register */
#define CAN_D_CS2            CAN_D.MB[2].CS.R              /* Message Buffer 2 CS Register */
#define CAN_D_ID2            CAN_D.MB[2].ID.R              /* Message Buffer 2 ID Register */
#define CAN_D_B2             CAN_D.MB[2].DATA.B            /* Message Buffer 2 B Register */
#define CAN_D_H2             CAN_D.MB[2].DATA.H            /* Message Buffer 2 H Register */
#define CAN_D_W2             CAN_D.MB[2].DATA.W            /* Message Buffer 2 W Register */
#define CAN_D_CS3            CAN_D.MB[3].CS.R              /* Message Buffer 3 CS Register */
#define CAN_D_ID3            CAN_D.MB[3].ID.R              /* Message Buffer 3 ID Register */
#define CAN_D_B3             CAN_D.MB[3].DATA.B            /* Message Buffer 3 B Register */
#define CAN_D_H3             CAN_D.MB[3].DATA.H            /* Message Buffer 3 H Register */
#define CAN_D_W3             CAN_D.MB[3].DATA.W            /* Message Buffer 3 W Register */
#define CAN_D_CS4            CAN_D.MB[4].CS.R              /* Message Buffer 4 CS Register */
#define CAN_D_ID4            CAN_D.MB[4].ID.R              /* Message Buffer 4 ID Register */
#define CAN_D_B4             CAN_D.MB[4].DATA.B            /* Message Buffer 4 B Register */
#define CAN_D_H4             CAN_D.MB[4].DATA.H            /* Message Buffer 4 H Register */
#define CAN_D_W4             CAN_D.MB[4].DATA.W            /* Message Buffer 4 W Register */
#define CAN_D_CS5            CAN_D.MB[5].CS.R              /* Message Buffer 5 CS Register */
#define CAN_D_ID5            CAN_D.MB[5].ID.R              /* Message Buffer 5 ID Register */
#define CAN_D_B5             CAN_D.MB[5].DATA.B            /* Message Buffer 5 B Register */
#define CAN_D_H5             CAN_D.MB[5].DATA.H            /* Message Buffer 5 H Register */
#define CAN_D_W5             CAN_D.MB[5].DATA.W            /* Message Buffer 5 W Register */
#define CAN_D_CS6            CAN_D.MB[6].CS.R              /* Message Buffer 6 CS Register */
#define CAN_D_ID6            CAN_D.MB[6].ID.R              /* Message Buffer 6 ID Register */
#define CAN_D_B6             CAN_D.MB[6].DATA.B            /* Message Buffer 6 B Register */
#define CAN_D_H6             CAN_D.MB[6].DATA.H            /* Message Buffer 6 H Register */
#define CAN_D_W6             CAN_D.MB[6].DATA.W            /* Message Buffer 6 W Register */
#define CAN_D_CS7            CAN_D.MB[7].CS.R              /* Message Buffer 7 CS Register */
#define CAN_D_ID7            CAN_D.MB[7].ID.R              /* Message Buffer 7 ID Register */
#define CAN_D_B7             CAN_D.MB[7].DATA.B            /* Message Buffer 7 B Register */
#define CAN_D_H7             CAN_D.MB[7].DATA.H            /* Message Buffer 7 H Register */
#define CAN_D_W7             CAN_D.MB[7].DATA.W            /* Message Buffer 7 W Register */
#define CAN_D_CS8            CAN_D.MB[8].CS.R              /* Message Buffer 8 CS Register */
#define CAN_D_ID8            CAN_D.MB[8].ID.R              /* Message Buffer 8 ID Register */
#define CAN_D_B8             CAN_D.MB[8].DATA.B            /* Message Buffer 8 B Register */
#define CAN_D_H8             CAN_D.MB[8].DATA.H            /* Message Buffer 8 H Register */
#define CAN_D_W8             CAN_D.MB[8].DATA.W            /* Message Buffer 8 W Register */
#define CAN_D_CS9            CAN_D.MB[9].CS.R              /* Message Buffer 9 CS Register */
#define CAN_D_ID9            CAN_D.MB[9].ID.R              /* Message Buffer 9 ID Register */
#define CAN_D_B9             CAN_D.MB[9].DATA.B            /* Message Buffer 9 B Register */
#define CAN_D_H9             CAN_D.MB[9].DATA.H            /* Message Buffer 9 H Register */
#define CAN_D_W9             CAN_D.MB[9].DATA.W            /* Message Buffer 9 W Register */
#define CAN_D_CS10           CAN_D.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_D_ID10           CAN_D.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_D_B10            CAN_D.MB[10].DATA.B           /* Message Buffer 10 B Register */
#define CAN_D_H10            CAN_D.MB[10].DATA.H           /* Message Buffer 10 H Register */
#define CAN_D_W10            CAN_D.MB[10].DATA.W           /* Message Buffer 10 W Register */
#define CAN_D_CS11           CAN_D.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_D_ID11           CAN_D.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_D_B11            CAN_D.MB[11].DATA.B           /* Message Buffer 11 B Register */
#define CAN_D_H11            CAN_D.MB[11].DATA.H           /* Message Buffer 11 H Register */
#define CAN_D_W11            CAN_D.MB[11].DATA.W           /* Message Buffer 11 W Register */
#define CAN_D_CS12           CAN_D.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_D_ID12           CAN_D.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_D_B12            CAN_D.MB[12].DATA.B           /* Message Buffer 12 B Register */
#define CAN_D_H12            CAN_D.MB[12].DATA.H           /* Message Buffer 12 H Register */
#define CAN_D_W12            CAN_D.MB[12].DATA.W           /* Message Buffer 12 W Register */
#define CAN_D_CS13           CAN_D.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_D_ID13           CAN_D.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_D_B13            CAN_D.MB[13].DATA.B           /* Message Buffer 13 B Register */
#define CAN_D_H13            CAN_D.MB[13].DATA.H           /* Message Buffer 13 H Register */
#define CAN_D_W13            CAN_D.MB[13].DATA.W           /* Message Buffer 13 W Register */
#define CAN_D_CS14           CAN_D.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_D_ID14           CAN_D.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_D_B14            CAN_D.MB[14].DATA.B           /* Message Buffer 14 B Register */
#define CAN_D_H14            CAN_D.MB[14].DATA.H           /* Message Buffer 14 H Register */
#define CAN_D_W14            CAN_D.MB[14].DATA.W           /* Message Buffer 14 W Register */
#define CAN_D_CS15           CAN_D.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_D_ID15           CAN_D.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_D_B15            CAN_D.MB[15].DATA.B           /* Message Buffer 15 B Register */
#define CAN_D_H15            CAN_D.MB[15].DATA.H           /* Message Buffer 15 H Register */
#define CAN_D_W15            CAN_D.MB[15].DATA.W           /* Message Buffer 15 W Register */
#define CAN_D_CS16           CAN_D.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_D_ID16           CAN_D.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_D_B16            CAN_D.MB[16].DATA.B           /* Message Buffer 16 B Register */
#define CAN_D_H16            CAN_D.MB[16].DATA.H           /* Message Buffer 16 H Register */
#define CAN_D_W16            CAN_D.MB[16].DATA.W           /* Message Buffer 16 W Register */
#define CAN_D_CS17           CAN_D.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_D_ID17           CAN_D.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_D_B17            CAN_D.MB[17].DATA.B           /* Message Buffer 17 B Register */
#define CAN_D_H17            CAN_D.MB[17].DATA.H           /* Message Buffer 17 H Register */
#define CAN_D_W17            CAN_D.MB[17].DATA.W           /* Message Buffer 17 W Register */
#define CAN_D_CS18           CAN_D.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_D_ID18           CAN_D.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_D_B18            CAN_D.MB[18].DATA.B           /* Message Buffer 18 B Register */
#define CAN_D_H18            CAN_D.MB[18].DATA.H           /* Message Buffer 18 H Register */
#define CAN_D_W18            CAN_D.MB[18].DATA.W           /* Message Buffer 18 W Register */
#define CAN_D_CS19           CAN_D.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_D_ID19           CAN_D.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_D_B19            CAN_D.MB[19].DATA.B           /* Message Buffer 19 B Register */
#define CAN_D_H19            CAN_D.MB[19].DATA.H           /* Message Buffer 19 H Register */
#define CAN_D_W19            CAN_D.MB[19].DATA.W           /* Message Buffer 19 W Register */
#define CAN_D_CS20           CAN_D.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_D_ID20           CAN_D.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_D_B20            CAN_D.MB[20].DATA.B           /* Message Buffer 20 B Register */
#define CAN_D_H20            CAN_D.MB[20].DATA.H           /* Message Buffer 20 H Register */
#define CAN_D_W20            CAN_D.MB[20].DATA.W           /* Message Buffer 20 W Register */
#define CAN_D_CS21           CAN_D.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_D_ID21           CAN_D.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_D_B21            CAN_D.MB[21].DATA.B           /* Message Buffer 21 B Register */
#define CAN_D_H21            CAN_D.MB[21].DATA.H           /* Message Buffer 21 H Register */
#define CAN_D_W21            CAN_D.MB[21].DATA.W           /* Message Buffer 21 W Register */
#define CAN_D_CS22           CAN_D.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_D_ID22           CAN_D.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_D_B22            CAN_D.MB[22].DATA.B           /* Message Buffer 22 B Register */
#define CAN_D_H22            CAN_D.MB[22].DATA.H           /* Message Buffer 22 H Register */
#define CAN_D_W22            CAN_D.MB[22].DATA.W           /* Message Buffer 22 W Register */
#define CAN_D_CS23           CAN_D.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_D_ID23           CAN_D.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_D_B23            CAN_D.MB[23].DATA.B           /* Message Buffer 23 B Register */
#define CAN_D_H23            CAN_D.MB[23].DATA.H           /* Message Buffer 23 H Register */
#define CAN_D_W23            CAN_D.MB[23].DATA.W           /* Message Buffer 23 W Register */
#define CAN_D_CS24           CAN_D.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_D_ID24           CAN_D.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_D_B24            CAN_D.MB[24].DATA.B           /* Message Buffer 24 B Register */
#define CAN_D_H24            CAN_D.MB[24].DATA.H           /* Message Buffer 24 H Register */
#define CAN_D_W24            CAN_D.MB[24].DATA.W           /* Message Buffer 24 W Register */
#define CAN_D_CS25           CAN_D.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_D_ID25           CAN_D.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_D_B25            CAN_D.MB[25].DATA.B           /* Message Buffer 25 B Register */
#define CAN_D_H25            CAN_D.MB[25].DATA.H           /* Message Buffer 25 H Register */
#define CAN_D_W25            CAN_D.MB[25].DATA.W           /* Message Buffer 25 W Register */
#define CAN_D_CS26           CAN_D.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_D_ID26           CAN_D.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_D_B26            CAN_D.MB[26].DATA.B           /* Message Buffer 26 B Register */
#define CAN_D_H26            CAN_D.MB[26].DATA.H           /* Message Buffer 26 H Register */
#define CAN_D_W26            CAN_D.MB[26].DATA.W           /* Message Buffer 26 W Register */
#define CAN_D_CS27           CAN_D.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_D_ID27           CAN_D.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_D_B27            CAN_D.MB[27].DATA.B           /* Message Buffer 27 B Register */
#define CAN_D_H27            CAN_D.MB[27].DATA.H           /* Message Buffer 27 H Register */
#define CAN_D_W27            CAN_D.MB[27].DATA.W           /* Message Buffer 27 W Register */
#define CAN_D_CS28           CAN_D.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_D_ID28           CAN_D.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_D_B28            CAN_D.MB[28].DATA.B           /* Message Buffer 28 B Register */
#define CAN_D_H28            CAN_D.MB[28].DATA.H           /* Message Buffer 28 H Register */
#define CAN_D_W28            CAN_D.MB[28].DATA.W           /* Message Buffer 28 W Register */
#define CAN_D_CS29           CAN_D.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_D_ID29           CAN_D.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_D_B29            CAN_D.MB[29].DATA.B           /* Message Buffer 29 B Register */
#define CAN_D_H29            CAN_D.MB[29].DATA.H           /* Message Buffer 29 H Register */
#define CAN_D_W29            CAN_D.MB[29].DATA.W           /* Message Buffer 29 W Register */
#define CAN_D_CS30           CAN_D.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_D_ID30           CAN_D.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_D_B30            CAN_D.MB[30].DATA.B           /* Message Buffer 30 B Register */
#define CAN_D_H30            CAN_D.MB[30].DATA.H           /* Message Buffer 30 H Register */
#define CAN_D_W30            CAN_D.MB[30].DATA.W           /* Message Buffer 30 W Register */
#define CAN_D_CS31           CAN_D.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_D_ID31           CAN_D.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_D_B31            CAN_D.MB[31].DATA.B           /* Message Buffer 31 B Register */
#define CAN_D_H31            CAN_D.MB[31].DATA.H           /* Message Buffer 31 H Register */
#define CAN_D_W31            CAN_D.MB[31].DATA.W           /* Message Buffer 31 W Register */
#define CAN_D_CS32           CAN_D.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_D_ID32           CAN_D.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_D_B32            CAN_D.MB[32].DATA.B           /* Message Buffer 32 B Register */
#define CAN_D_H32            CAN_D.MB[32].DATA.H           /* Message Buffer 32 H Register */
#define CAN_D_W32            CAN_D.MB[32].DATA.W           /* Message Buffer 32 W Register */
#define CAN_D_CS33           CAN_D.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_D_ID33           CAN_D.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_D_B33            CAN_D.MB[33].DATA.B           /* Message Buffer 33 B Register */
#define CAN_D_H33            CAN_D.MB[33].DATA.H           /* Message Buffer 33 H Register */
#define CAN_D_W33            CAN_D.MB[33].DATA.W           /* Message Buffer 33 W Register */
#define CAN_D_CS34           CAN_D.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_D_ID34           CAN_D.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_D_B34            CAN_D.MB[34].DATA.B           /* Message Buffer 34 B Register */
#define CAN_D_H34            CAN_D.MB[34].DATA.H           /* Message Buffer 34 H Register */
#define CAN_D_W34            CAN_D.MB[34].DATA.W           /* Message Buffer 34 W Register */
#define CAN_D_CS35           CAN_D.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_D_ID35           CAN_D.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_D_B35            CAN_D.MB[35].DATA.B           /* Message Buffer 35 B Register */
#define CAN_D_H35            CAN_D.MB[35].DATA.H           /* Message Buffer 35 H Register */
#define CAN_D_W35            CAN_D.MB[35].DATA.W           /* Message Buffer 35 W Register */
#define CAN_D_CS36           CAN_D.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_D_ID36           CAN_D.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_D_B36            CAN_D.MB[36].DATA.B           /* Message Buffer 36 B Register */
#define CAN_D_H36            CAN_D.MB[36].DATA.H           /* Message Buffer 36 H Register */
#define CAN_D_W36            CAN_D.MB[36].DATA.W           /* Message Buffer 36 W Register */
#define CAN_D_CS37           CAN_D.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_D_ID37           CAN_D.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_D_B37            CAN_D.MB[37].DATA.B           /* Message Buffer 37 B Register */
#define CAN_D_H37            CAN_D.MB[37].DATA.H           /* Message Buffer 37 H Register */
#define CAN_D_W37            CAN_D.MB[37].DATA.W           /* Message Buffer 37 W Register */
#define CAN_D_CS38           CAN_D.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_D_ID38           CAN_D.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_D_B38            CAN_D.MB[38].DATA.B           /* Message Buffer 38 B Register */
#define CAN_D_H38            CAN_D.MB[38].DATA.H           /* Message Buffer 38 H Register */
#define CAN_D_W38            CAN_D.MB[38].DATA.W           /* Message Buffer 38 W Register */
#define CAN_D_CS39           CAN_D.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_D_ID39           CAN_D.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_D_B39            CAN_D.MB[39].DATA.B           /* Message Buffer 39 B Register */
#define CAN_D_H39            CAN_D.MB[39].DATA.H           /* Message Buffer 39 H Register */
#define CAN_D_W39            CAN_D.MB[39].DATA.W           /* Message Buffer 39 W Register */
#define CAN_D_CS40           CAN_D.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_D_ID40           CAN_D.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_D_B40            CAN_D.MB[40].DATA.B           /* Message Buffer 40 B Register */
#define CAN_D_H40            CAN_D.MB[40].DATA.H           /* Message Buffer 40 H Register */
#define CAN_D_W40            CAN_D.MB[40].DATA.W           /* Message Buffer 40 W Register */
#define CAN_D_CS41           CAN_D.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_D_ID41           CAN_D.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_D_B41            CAN_D.MB[41].DATA.B           /* Message Buffer 41 B Register */
#define CAN_D_H41            CAN_D.MB[41].DATA.H           /* Message Buffer 41 H Register */
#define CAN_D_W41            CAN_D.MB[41].DATA.W           /* Message Buffer 41 W Register */
#define CAN_D_CS42           CAN_D.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_D_ID42           CAN_D.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_D_B42            CAN_D.MB[42].DATA.B           /* Message Buffer 42 B Register */
#define CAN_D_H42            CAN_D.MB[42].DATA.H           /* Message Buffer 42 H Register */
#define CAN_D_W42            CAN_D.MB[42].DATA.W           /* Message Buffer 42 W Register */
#define CAN_D_CS43           CAN_D.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_D_ID43           CAN_D.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_D_B43            CAN_D.MB[43].DATA.B           /* Message Buffer 43 B Register */
#define CAN_D_H43            CAN_D.MB[43].DATA.H           /* Message Buffer 43 H Register */
#define CAN_D_W43            CAN_D.MB[43].DATA.W           /* Message Buffer 43 W Register */
#define CAN_D_CS44           CAN_D.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_D_ID44           CAN_D.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_D_B44            CAN_D.MB[44].DATA.B           /* Message Buffer 44 B Register */
#define CAN_D_H44            CAN_D.MB[44].DATA.H           /* Message Buffer 44 H Register */
#define CAN_D_W44            CAN_D.MB[44].DATA.W           /* Message Buffer 44 W Register */
#define CAN_D_CS45           CAN_D.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_D_ID45           CAN_D.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_D_B45            CAN_D.MB[45].DATA.B           /* Message Buffer 45 B Register */
#define CAN_D_H45            CAN_D.MB[45].DATA.H           /* Message Buffer 45 H Register */
#define CAN_D_W45            CAN_D.MB[45].DATA.W           /* Message Buffer 45 W Register */
#define CAN_D_CS46           CAN_D.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_D_ID46           CAN_D.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_D_B46            CAN_D.MB[46].DATA.B           /* Message Buffer 46 B Register */
#define CAN_D_H46            CAN_D.MB[46].DATA.H           /* Message Buffer 46 H Register */
#define CAN_D_W46            CAN_D.MB[46].DATA.W           /* Message Buffer 46 W Register */
#define CAN_D_CS47           CAN_D.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_D_ID47           CAN_D.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_D_B47            CAN_D.MB[47].DATA.B           /* Message Buffer 47 B Register */
#define CAN_D_H47            CAN_D.MB[47].DATA.H           /* Message Buffer 47 H Register */
#define CAN_D_W47            CAN_D.MB[47].DATA.W           /* Message Buffer 47 W Register */
#define CAN_D_CS48           CAN_D.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_D_ID48           CAN_D.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_D_B48            CAN_D.MB[48].DATA.B           /* Message Buffer 48 B Register */
#define CAN_D_H48            CAN_D.MB[48].DATA.H           /* Message Buffer 48 H Register */
#define CAN_D_W48            CAN_D.MB[48].DATA.W           /* Message Buffer 48 W Register */
#define CAN_D_CS49           CAN_D.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_D_ID49           CAN_D.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_D_B49            CAN_D.MB[49].DATA.B           /* Message Buffer 49 B Register */
#define CAN_D_H49            CAN_D.MB[49].DATA.H           /* Message Buffer 49 H Register */
#define CAN_D_W49            CAN_D.MB[49].DATA.W           /* Message Buffer 49 W Register */
#define CAN_D_CS50           CAN_D.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_D_ID50           CAN_D.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_D_B50            CAN_D.MB[50].DATA.B           /* Message Buffer 50 B Register */
#define CAN_D_H50            CAN_D.MB[50].DATA.H           /* Message Buffer 50 H Register */
#define CAN_D_W50            CAN_D.MB[50].DATA.W           /* Message Buffer 50 W Register */
#define CAN_D_CS51           CAN_D.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_D_ID51           CAN_D.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_D_B51            CAN_D.MB[51].DATA.B           /* Message Buffer 51 B Register */
#define CAN_D_H51            CAN_D.MB[51].DATA.H           /* Message Buffer 51 H Register */
#define CAN_D_W51            CAN_D.MB[51].DATA.W           /* Message Buffer 51 W Register */
#define CAN_D_CS52           CAN_D.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_D_ID52           CAN_D.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_D_B52            CAN_D.MB[52].DATA.B           /* Message Buffer 52 B Register */
#define CAN_D_H52            CAN_D.MB[52].DATA.H           /* Message Buffer 52 H Register */
#define CAN_D_W52            CAN_D.MB[52].DATA.W           /* Message Buffer 52 W Register */
#define CAN_D_CS53           CAN_D.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_D_ID53           CAN_D.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_D_B53            CAN_D.MB[53].DATA.B           /* Message Buffer 53 B Register */
#define CAN_D_H53            CAN_D.MB[53].DATA.H           /* Message Buffer 53 H Register */
#define CAN_D_W53            CAN_D.MB[53].DATA.W           /* Message Buffer 53 W Register */
#define CAN_D_CS54           CAN_D.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_D_ID54           CAN_D.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_D_B54            CAN_D.MB[54].DATA.B           /* Message Buffer 54 B Register */
#define CAN_D_H54            CAN_D.MB[54].DATA.H           /* Message Buffer 54 H Register */
#define CAN_D_W54            CAN_D.MB[54].DATA.W           /* Message Buffer 54 W Register */
#define CAN_D_CS55           CAN_D.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_D_ID55           CAN_D.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_D_B55            CAN_D.MB[55].DATA.B           /* Message Buffer 55 B Register */
#define CAN_D_H55            CAN_D.MB[55].DATA.H           /* Message Buffer 55 H Register */
#define CAN_D_W55            CAN_D.MB[55].DATA.W           /* Message Buffer 55 W Register */
#define CAN_D_CS56           CAN_D.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_D_ID56           CAN_D.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_D_B56            CAN_D.MB[56].DATA.B           /* Message Buffer 56 B Register */
#define CAN_D_H56            CAN_D.MB[56].DATA.H           /* Message Buffer 56 H Register */
#define CAN_D_W56            CAN_D.MB[56].DATA.W           /* Message Buffer 56 W Register */
#define CAN_D_CS57           CAN_D.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_D_ID57           CAN_D.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_D_B57            CAN_D.MB[57].DATA.B           /* Message Buffer 57 B Register */
#define CAN_D_H57            CAN_D.MB[57].DATA.H           /* Message Buffer 57 H Register */
#define CAN_D_W57            CAN_D.MB[57].DATA.W           /* Message Buffer 57 W Register */
#define CAN_D_CS58           CAN_D.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_D_ID58           CAN_D.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_D_B58            CAN_D.MB[58].DATA.B           /* Message Buffer 58 B Register */
#define CAN_D_H58            CAN_D.MB[58].DATA.H           /* Message Buffer 58 H Register */
#define CAN_D_W58            CAN_D.MB[58].DATA.W           /* Message Buffer 58 W Register */
#define CAN_D_CS59           CAN_D.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_D_ID59           CAN_D.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_D_B59            CAN_D.MB[59].DATA.B           /* Message Buffer 59 B Register */
#define CAN_D_H59            CAN_D.MB[59].DATA.H           /* Message Buffer 59 H Register */
#define CAN_D_W59            CAN_D.MB[59].DATA.W           /* Message Buffer 59 W Register */
#define CAN_D_CS60           CAN_D.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_D_ID60           CAN_D.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_D_B60            CAN_D.MB[60].DATA.B           /* Message Buffer 60 B Register */
#define CAN_D_H60            CAN_D.MB[60].DATA.H           /* Message Buffer 60 H Register */
#define CAN_D_W60            CAN_D.MB[60].DATA.W           /* Message Buffer 60 W Register */
#define CAN_D_CS61           CAN_D.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_D_ID61           CAN_D.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_D_B61            CAN_D.MB[61].DATA.B           /* Message Buffer 61 B Register */
#define CAN_D_H61            CAN_D.MB[61].DATA.H           /* Message Buffer 61 H Register */
#define CAN_D_W61            CAN_D.MB[61].DATA.W           /* Message Buffer 61 W Register */
#define CAN_D_CS62           CAN_D.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_D_ID62           CAN_D.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_D_B62            CAN_D.MB[62].DATA.B           /* Message Buffer 62 B Register */
#define CAN_D_H62            CAN_D.MB[62].DATA.H           /* Message Buffer 62 H Register */
#define CAN_D_W62            CAN_D.MB[62].DATA.W           /* Message Buffer 62 W Register */
#define CAN_D_CS63           CAN_D.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_D_ID63           CAN_D.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_D_B63            CAN_D.MB[63].DATA.B           /* Message Buffer 63 B Register */
#define CAN_D_H63            CAN_D.MB[63].DATA.H           /* Message Buffer 63 H Register */
#define CAN_D_W63            CAN_D.MB[63].DATA.W           /* Message Buffer 63 W Register */
#define CAN_D_RXIMR0         CAN_D.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_D_RXIMR1         CAN_D.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_D_RXIMR2         CAN_D.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_D_RXIMR3         CAN_D.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_D_RXIMR4         CAN_D.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_D_RXIMR5         CAN_D.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_D_RXIMR6         CAN_D.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_D_RXIMR7         CAN_D.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_D_RXIMR8         CAN_D.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_D_RXIMR9         CAN_D.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_D_RXIMR10        CAN_D.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR11        CAN_D.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR12        CAN_D.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR13        CAN_D.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR14        CAN_D.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR15        CAN_D.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR16        CAN_D.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR17        CAN_D.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR18        CAN_D.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR19        CAN_D.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR20        CAN_D.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR21        CAN_D.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR22        CAN_D.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR23        CAN_D.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR24        CAN_D.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR25        CAN_D.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR26        CAN_D.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR27        CAN_D.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR28        CAN_D.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR29        CAN_D.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR30        CAN_D.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR31        CAN_D.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR32        CAN_D.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR33        CAN_D.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR34        CAN_D.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR35        CAN_D.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR36        CAN_D.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR37        CAN_D.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR38        CAN_D.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR39        CAN_D.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR40        CAN_D.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR41        CAN_D.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR42        CAN_D.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR43        CAN_D.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR44        CAN_D.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR45        CAN_D.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR46        CAN_D.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR47        CAN_D.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR48        CAN_D.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR49        CAN_D.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR50        CAN_D.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR51        CAN_D.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR52        CAN_D.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR53        CAN_D.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR54        CAN_D.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR55        CAN_D.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR56        CAN_D.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR57        CAN_D.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR58        CAN_D.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR59        CAN_D.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR60        CAN_D.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR61        CAN_D.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR62        CAN_D.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_D_RXIMR63        CAN_D.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_D_MECR           CAN_D.MECR.R                  /* Memory Error Control Register */
#define CAN_D_ERRIAR         CAN_D.ERRIAR.R                /* Error Injection Address Register */
#define CAN_D_ERRIDPR        CAN_D.ERRIDPR.R               /* Error Injection Data Pattern Register */
#define CAN_D_ERRIPPR        CAN_D.ERRIPPR.R               /* Error Injection Parity Pattern Register */
#define CAN_D_RERRAR         CAN_D.RERRAR.R                /* Error Report Address Register */
#define CAN_D_RERRDR         CAN_D.RERRDR.R                /* Error Report Data Register */
#define CAN_D_RERRSYNR       CAN_D.RERRSYNR.R              /* Error Report Syndrome Register */
#define CAN_D_ERRSR          CAN_D.ERRSR.R                 /* Error Status Register */

/* CMU */
#define CMU_0_CSR            CMU_0.CSR.R                   /* CMU Control Status Register */
#define CMU_0_FDR            CMU_0.FDR.R                   /* CMU Frequency Display Register */
#define CMU_0_HFREFR         CMU_0.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_0_LFREFR         CMU_0.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_0_ISR            CMU_0.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_0_MDR            CMU_0.MDR.R                   /* CMU Measurement Duration Register */

#define CMU_1_CSR            CMU_1.CSR.R                   /* CMU Control Status Register */
#define CMU_1_FDR            CMU_1.FDR.R                   /* CMU Frequency Display Register */
#define CMU_1_HFREFR         CMU_1.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_1_LFREFR         CMU_1.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_1_ISR            CMU_1.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_1_MDR            CMU_1.MDR.R                   /* CMU Measurement Duration Register */

#define CMU_2_CSR            CMU_2.CSR.R                   /* CMU Control Status Register */
#define CMU_2_FDR            CMU_2.FDR.R                   /* CMU Frequency Display Register */
#define CMU_2_HFREFR         CMU_2.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_2_LFREFR         CMU_2.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_2_ISR            CMU_2.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_2_MDR            CMU_2.MDR.R                   /* CMU Measurement Duration Register */

#define CMU_3_CSR            CMU_3.CSR.R                   /* CMU Control Status Register */
#define CMU_3_FDR            CMU_3.FDR.R                   /* CMU Frequency Display Register */
#define CMU_3_HFREFR         CMU_3.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_3_LFREFR         CMU_3.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_3_ISR            CMU_3.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_3_MDR            CMU_3.MDR.R                   /* CMU Measurement Duration Register */

#define CMU_4_CSR            CMU_4.CSR.R                   /* CMU Control Status Register */
#define CMU_4_FDR            CMU_4.FDR.R                   /* CMU Frequency Display Register */
#define CMU_4_HFREFR         CMU_4.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_4_LFREFR         CMU_4.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_4_ISR            CMU_4.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_4_MDR            CMU_4.MDR.R                   /* CMU Measurement Duration Register */

#define CMU_5_CSR            CMU_5.CSR.R                   /* CMU Control Status Register */
#define CMU_5_FDR            CMU_5.FDR.R                   /* CMU Frequency Display Register */
#define CMU_5_HFREFR         CMU_5.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_5_LFREFR         CMU_5.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_5_ISR            CMU_5.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_5_MDR            CMU_5.MDR.R                   /* CMU Measurement Duration Register */

#define CMU_6_CSR            CMU_6.CSR.R                   /* CMU Control Status Register */
#define CMU_6_FDR            CMU_6.FDR.R                   /* CMU Frequency Display Register */
#define CMU_6_HFREFR         CMU_6.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_6_LFREFR         CMU_6.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_6_ISR            CMU_6.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_6_MDR            CMU_6.MDR.R                   /* CMU Measurement Duration Register */

#define CMU_7_CSR            CMU_7.CSR.R                   /* CMU Control Status Register */
#define CMU_7_FDR            CMU_7.FDR.R                   /* CMU Frequency Display Register */
#define CMU_7_HFREFR         CMU_7.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_7_LFREFR         CMU_7.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_7_ISR            CMU_7.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_7_MDR            CMU_7.MDR.R                   /* CMU Measurement Duration Register */

#define CMU_8_CSR            CMU_8.CSR.R                   /* CMU Control Status Register */
#define CMU_8_FDR            CMU_8.FDR.R                   /* CMU Frequency Display Register */
#define CMU_8_HFREFR         CMU_8.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_8_LFREFR         CMU_8.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_8_ISR            CMU_8.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_8_MDR            CMU_8.MDR.R                   /* CMU Measurement Duration Register */

/* CRC */
#define CRC_CFG1             CRC.CHANNEL[0].CFG.R          /* Configuration Register */
#define CRC_INP1             CRC.CHANNEL[0].INP.R          /* Input Register */
#define CRC_CSTAT1           CRC.CHANNEL[0].CSTAT.R        /* Current Status Register */
#define CRC_OUTP1            CRC.CHANNEL[0].OUTP.R         /* Output Register */
#define CRC_CFG2             CRC.CHANNEL[1].CFG.R          /* Configuration Register */
#define CRC_INP2             CRC.CHANNEL[1].INP.R          /* Input Register */
#define CRC_CSTAT2           CRC.CHANNEL[1].CSTAT.R        /* Current Status Register */
#define CRC_OUTP2            CRC.CHANNEL[1].OUTP.R         /* Output Register */
#define CRC_CFG3             CRC.CHANNEL[2].CFG.R          /* Configuration Register */
#define CRC_INP3             CRC.CHANNEL[2].INP.R          /* Input Register */
#define CRC_CSTAT3           CRC.CHANNEL[2].CSTAT.R        /* Current Status Register */
#define CRC_OUTP3            CRC.CHANNEL[2].OUTP.R         /* Output Register */

/* CSE */
#define CSE_CR               CSE.CR.R                      /* CSE Control Register */
#define CSE_SR               CSE.SR.R                      /* CSE Status Register */
#define CSE_IR               CSE.IR.R                      /* CSE Interrupt Register */
#define CSE_ECR              CSE.ECR.R                     /* CSE Error Code Register */
#define CSE_CMD              CSE.CMD.R                     /* CSE Command Register */
#define CSE_P1               CSE.P[0].R                    /* CSE Parameter Register */
#define CSE_P2               CSE.P[1].R                    /* CSE Parameter Register */
#define CSE_P3               CSE.P[2].R                    /* CSE Parameter Register */
#define CSE_P4               CSE.P[3].R                    /* CSE Parameter Register */
#define CSE_P5               CSE.P[4].R                    /* CSE Parameter Register */

/* DECFILTER */
#define DECFILTER_A_MCR      DECFILTER_A.MCR.R             /* Module Configuration Register */
#define DECFILTER_A_MSR      DECFILTER_A.MSR.R             /* Module Status Register */
#define DECFILTER_A_MXCR     DECFILTER_A.MXCR.R            /* Module Extended Config Register */
#define DECFILTER_A_MXSR     DECFILTER_A.MXSR.R            /* Module Extended Status Register */
#define DECFILTER_A_IB       DECFILTER_A.IB.R              /* Interface Input Buffer */
#define DECFILTER_A_OB       DECFILTER_A.OB.R              /* Interface Output Buffer */
#define DECFILTER_A_COEF0    DECFILTER_A.COEF[0].R         /* Filter Coefficient */
#define DECFILTER_A_COEF1    DECFILTER_A.COEF[1].R         /* Filter Coefficient */
#define DECFILTER_A_COEF2    DECFILTER_A.COEF[2].R         /* Filter Coefficient */
#define DECFILTER_A_COEF3    DECFILTER_A.COEF[3].R         /* Filter Coefficient */
#define DECFILTER_A_COEF4    DECFILTER_A.COEF[4].R         /* Filter Coefficient */
#define DECFILTER_A_COEF5    DECFILTER_A.COEF[5].R         /* Filter Coefficient */
#define DECFILTER_A_COEF6    DECFILTER_A.COEF[6].R         /* Filter Coefficient */
#define DECFILTER_A_COEF7    DECFILTER_A.COEF[7].R         /* Filter Coefficient */
#define DECFILTER_A_COEF8    DECFILTER_A.COEF[8].R         /* Filter Coefficient */
#define DECFILTER_A_TAP0     DECFILTER_A.TAP[0].R          /* Filter TAP */
#define DECFILTER_A_TAP1     DECFILTER_A.TAP[1].R          /* Filter TAP */
#define DECFILTER_A_TAP2     DECFILTER_A.TAP[2].R          /* Filter TAP */
#define DECFILTER_A_TAP3     DECFILTER_A.TAP[3].R          /* Filter TAP */
#define DECFILTER_A_TAP4     DECFILTER_A.TAP[4].R          /* Filter TAP */
#define DECFILTER_A_TAP5     DECFILTER_A.TAP[5].R          /* Filter TAP */
#define DECFILTER_A_TAP6     DECFILTER_A.TAP[6].R          /* Filter TAP */
#define DECFILTER_A_TAP7     DECFILTER_A.TAP[7].R          /* Filter TAP */
#define DECFILTER_A_EDID     DECFILTER_A.EDID.R            /* Enhanced Debug Input Data */
#define DECFILTER_A_FINTVAL  DECFILTER_A.FINTVAL.R         /* Final Integer Value Register */
#define DECFILTER_A_FINTCNT  DECFILTER_A.FINTCNT.R         /* Final Integer Count Register */
#define DECFILTER_A_CINTVAL  DECFILTER_A.CINTVAL.R         /* Current Integer Value Register */
#define DECFILTER_A_CINTCNT  DECFILTER_A.CINTCNT.R         /* Current Integer Count Register */

#define DECFILTER_B_MCR      DECFILTER_B.MCR.R             /* Module Configuration Register */
#define DECFILTER_B_MSR      DECFILTER_B.MSR.R             /* Module Status Register */
#define DECFILTER_B_MXCR     DECFILTER_B.MXCR.R            /* Module Extended Config Register */
#define DECFILTER_B_MXSR     DECFILTER_B.MXSR.R            /* Module Extended Status Register */
#define DECFILTER_B_IB       DECFILTER_B.IB.R              /* Interface Input Buffer */
#define DECFILTER_B_OB       DECFILTER_B.OB.R              /* Interface Output Buffer */
#define DECFILTER_B_COEF0    DECFILTER_B.COEF[0].R         /* Filter Coefficient */
#define DECFILTER_B_COEF1    DECFILTER_B.COEF[1].R         /* Filter Coefficient */
#define DECFILTER_B_COEF2    DECFILTER_B.COEF[2].R         /* Filter Coefficient */
#define DECFILTER_B_COEF3    DECFILTER_B.COEF[3].R         /* Filter Coefficient */
#define DECFILTER_B_COEF4    DECFILTER_B.COEF[4].R         /* Filter Coefficient */
#define DECFILTER_B_COEF5    DECFILTER_B.COEF[5].R         /* Filter Coefficient */
#define DECFILTER_B_COEF6    DECFILTER_B.COEF[6].R         /* Filter Coefficient */
#define DECFILTER_B_COEF7    DECFILTER_B.COEF[7].R         /* Filter Coefficient */
#define DECFILTER_B_COEF8    DECFILTER_B.COEF[8].R         /* Filter Coefficient */
#define DECFILTER_B_TAP0     DECFILTER_B.TAP[0].R          /* Filter TAP */
#define DECFILTER_B_TAP1     DECFILTER_B.TAP[1].R          /* Filter TAP */
#define DECFILTER_B_TAP2     DECFILTER_B.TAP[2].R          /* Filter TAP */
#define DECFILTER_B_TAP3     DECFILTER_B.TAP[3].R          /* Filter TAP */
#define DECFILTER_B_TAP4     DECFILTER_B.TAP[4].R          /* Filter TAP */
#define DECFILTER_B_TAP5     DECFILTER_B.TAP[5].R          /* Filter TAP */
#define DECFILTER_B_TAP6     DECFILTER_B.TAP[6].R          /* Filter TAP */
#define DECFILTER_B_TAP7     DECFILTER_B.TAP[7].R          /* Filter TAP */
#define DECFILTER_B_EDID     DECFILTER_B.EDID.R            /* Enhanced Debug Input Data */
#define DECFILTER_B_FINTVAL  DECFILTER_B.FINTVAL.R         /* Final Integer Value Register */
#define DECFILTER_B_FINTCNT  DECFILTER_B.FINTCNT.R         /* Final Integer Count Register */
#define DECFILTER_B_CINTVAL  DECFILTER_B.CINTVAL.R         /* Current Integer Value Register */
#define DECFILTER_B_CINTCNT  DECFILTER_B.CINTCNT.R         /* Current Integer Count Register */

#define DECFILTER_C_MCR      DECFILTER_C.MCR.R             /* Module Configuration Register */
#define DECFILTER_C_MSR      DECFILTER_C.MSR.R             /* Module Status Register */
#define DECFILTER_C_MXCR     DECFILTER_C.MXCR.R            /* Module Extended Config Register */
#define DECFILTER_C_MXSR     DECFILTER_C.MXSR.R            /* Module Extended Status Register */
#define DECFILTER_C_IB       DECFILTER_C.IB.R              /* Interface Input Buffer */
#define DECFILTER_C_OB       DECFILTER_C.OB.R              /* Interface Output Buffer */
#define DECFILTER_C_COEF0    DECFILTER_C.COEF[0].R         /* Filter Coefficient */
#define DECFILTER_C_COEF1    DECFILTER_C.COEF[1].R         /* Filter Coefficient */
#define DECFILTER_C_COEF2    DECFILTER_C.COEF[2].R         /* Filter Coefficient */
#define DECFILTER_C_COEF3    DECFILTER_C.COEF[3].R         /* Filter Coefficient */
#define DECFILTER_C_COEF4    DECFILTER_C.COEF[4].R         /* Filter Coefficient */
#define DECFILTER_C_COEF5    DECFILTER_C.COEF[5].R         /* Filter Coefficient */
#define DECFILTER_C_COEF6    DECFILTER_C.COEF[6].R         /* Filter Coefficient */
#define DECFILTER_C_COEF7    DECFILTER_C.COEF[7].R         /* Filter Coefficient */
#define DECFILTER_C_COEF8    DECFILTER_C.COEF[8].R         /* Filter Coefficient */
#define DECFILTER_C_TAP0     DECFILTER_C.TAP[0].R          /* Filter TAP */
#define DECFILTER_C_TAP1     DECFILTER_C.TAP[1].R          /* Filter TAP */
#define DECFILTER_C_TAP2     DECFILTER_C.TAP[2].R          /* Filter TAP */
#define DECFILTER_C_TAP3     DECFILTER_C.TAP[3].R          /* Filter TAP */
#define DECFILTER_C_TAP4     DECFILTER_C.TAP[4].R          /* Filter TAP */
#define DECFILTER_C_TAP5     DECFILTER_C.TAP[5].R          /* Filter TAP */
#define DECFILTER_C_TAP6     DECFILTER_C.TAP[6].R          /* Filter TAP */
#define DECFILTER_C_TAP7     DECFILTER_C.TAP[7].R          /* Filter TAP */
#define DECFILTER_C_EDID     DECFILTER_C.EDID.R            /* Enhanced Debug Input Data */
#define DECFILTER_C_FINTVAL  DECFILTER_C.FINTVAL.R         /* Final Integer Value Register */
#define DECFILTER_C_FINTCNT  DECFILTER_C.FINTCNT.R         /* Final Integer Count Register */
#define DECFILTER_C_CINTVAL  DECFILTER_C.CINTVAL.R         /* Current Integer Value Register */
#define DECFILTER_C_CINTCNT  DECFILTER_C.CINTCNT.R         /* Current Integer Count Register */

#define DECFILTER_D_MCR      DECFILTER_D.MCR.R             /* Module Configuration Register */
#define DECFILTER_D_MSR      DECFILTER_D.MSR.R             /* Module Status Register */
#define DECFILTER_D_MXCR     DECFILTER_D.MXCR.R            /* Module Extended Config Register */
#define DECFILTER_D_MXSR     DECFILTER_D.MXSR.R            /* Module Extended Status Register */
#define DECFILTER_D_IB       DECFILTER_D.IB.R              /* Interface Input Buffer */
#define DECFILTER_D_OB       DECFILTER_D.OB.R              /* Interface Output Buffer */
#define DECFILTER_D_COEF0    DECFILTER_D.COEF[0].R         /* Filter Coefficient */
#define DECFILTER_D_COEF1    DECFILTER_D.COEF[1].R         /* Filter Coefficient */
#define DECFILTER_D_COEF2    DECFILTER_D.COEF[2].R         /* Filter Coefficient */
#define DECFILTER_D_COEF3    DECFILTER_D.COEF[3].R         /* Filter Coefficient */
#define DECFILTER_D_COEF4    DECFILTER_D.COEF[4].R         /* Filter Coefficient */
#define DECFILTER_D_COEF5    DECFILTER_D.COEF[5].R         /* Filter Coefficient */
#define DECFILTER_D_COEF6    DECFILTER_D.COEF[6].R         /* Filter Coefficient */
#define DECFILTER_D_COEF7    DECFILTER_D.COEF[7].R         /* Filter Coefficient */
#define DECFILTER_D_COEF8    DECFILTER_D.COEF[8].R         /* Filter Coefficient */
#define DECFILTER_D_TAP0     DECFILTER_D.TAP[0].R          /* Filter TAP */
#define DECFILTER_D_TAP1     DECFILTER_D.TAP[1].R          /* Filter TAP */
#define DECFILTER_D_TAP2     DECFILTER_D.TAP[2].R          /* Filter TAP */
#define DECFILTER_D_TAP3     DECFILTER_D.TAP[3].R          /* Filter TAP */
#define DECFILTER_D_TAP4     DECFILTER_D.TAP[4].R          /* Filter TAP */
#define DECFILTER_D_TAP5     DECFILTER_D.TAP[5].R          /* Filter TAP */
#define DECFILTER_D_TAP6     DECFILTER_D.TAP[6].R          /* Filter TAP */
#define DECFILTER_D_TAP7     DECFILTER_D.TAP[7].R          /* Filter TAP */
#define DECFILTER_D_EDID     DECFILTER_D.EDID.R            /* Enhanced Debug Input Data */
#define DECFILTER_D_FINTVAL  DECFILTER_D.FINTVAL.R         /* Final Integer Value Register */
#define DECFILTER_D_FINTCNT  DECFILTER_D.FINTCNT.R         /* Final Integer Count Register */
#define DECFILTER_D_CINTVAL  DECFILTER_D.CINTVAL.R         /* Current Integer Value Register */
#define DECFILTER_D_CINTCNT  DECFILTER_D.CINTCNT.R         /* Current Integer Count Register */

#define DECFILTER_E_MCR      DECFILTER_E.MCR.R             /* Module Configuration Register */
#define DECFILTER_E_MSR      DECFILTER_E.MSR.R             /* Module Status Register */
#define DECFILTER_E_MXCR     DECFILTER_E.MXCR.R            /* Module Extended Config Register */
#define DECFILTER_E_MXSR     DECFILTER_E.MXSR.R            /* Module Extended Status Register */
#define DECFILTER_E_IB       DECFILTER_E.IB.R              /* Interface Input Buffer */
#define DECFILTER_E_OB       DECFILTER_E.OB.R              /* Interface Output Buffer */
#define DECFILTER_E_COEF0    DECFILTER_E.COEF[0].R         /* Filter Coefficient */
#define DECFILTER_E_COEF1    DECFILTER_E.COEF[1].R         /* Filter Coefficient */
#define DECFILTER_E_COEF2    DECFILTER_E.COEF[2].R         /* Filter Coefficient */
#define DECFILTER_E_COEF3    DECFILTER_E.COEF[3].R         /* Filter Coefficient */
#define DECFILTER_E_COEF4    DECFILTER_E.COEF[4].R         /* Filter Coefficient */
#define DECFILTER_E_COEF5    DECFILTER_E.COEF[5].R         /* Filter Coefficient */
#define DECFILTER_E_COEF6    DECFILTER_E.COEF[6].R         /* Filter Coefficient */
#define DECFILTER_E_COEF7    DECFILTER_E.COEF[7].R         /* Filter Coefficient */
#define DECFILTER_E_COEF8    DECFILTER_E.COEF[8].R         /* Filter Coefficient */
#define DECFILTER_E_TAP0     DECFILTER_E.TAP[0].R          /* Filter TAP */
#define DECFILTER_E_TAP1     DECFILTER_E.TAP[1].R          /* Filter TAP */
#define DECFILTER_E_TAP2     DECFILTER_E.TAP[2].R          /* Filter TAP */
#define DECFILTER_E_TAP3     DECFILTER_E.TAP[3].R          /* Filter TAP */
#define DECFILTER_E_TAP4     DECFILTER_E.TAP[4].R          /* Filter TAP */
#define DECFILTER_E_TAP5     DECFILTER_E.TAP[5].R          /* Filter TAP */
#define DECFILTER_E_TAP6     DECFILTER_E.TAP[6].R          /* Filter TAP */
#define DECFILTER_E_TAP7     DECFILTER_E.TAP[7].R          /* Filter TAP */
#define DECFILTER_E_EDID     DECFILTER_E.EDID.R            /* Enhanced Debug Input Data */
#define DECFILTER_E_FINTVAL  DECFILTER_E.FINTVAL.R         /* Final Integer Value Register */
#define DECFILTER_E_FINTCNT  DECFILTER_E.FINTCNT.R         /* Final Integer Count Register */
#define DECFILTER_E_CINTVAL  DECFILTER_E.CINTVAL.R         /* Current Integer Value Register */
#define DECFILTER_E_CINTCNT  DECFILTER_E.CINTCNT.R         /* Current Integer Count Register */

#define DECFILTER_F_MCR      DECFILTER_F.MCR.R             /* Module Configuration Register */
#define DECFILTER_F_MSR      DECFILTER_F.MSR.R             /* Module Status Register */
#define DECFILTER_F_MXCR     DECFILTER_F.MXCR.R            /* Module Extended Config Register */
#define DECFILTER_F_MXSR     DECFILTER_F.MXSR.R            /* Module Extended Status Register */
#define DECFILTER_F_IB       DECFILTER_F.IB.R              /* Interface Input Buffer */
#define DECFILTER_F_OB       DECFILTER_F.OB.R              /* Interface Output Buffer */
#define DECFILTER_F_COEF0    DECFILTER_F.COEF[0].R         /* Filter Coefficient */
#define DECFILTER_F_COEF1    DECFILTER_F.COEF[1].R         /* Filter Coefficient */
#define DECFILTER_F_COEF2    DECFILTER_F.COEF[2].R         /* Filter Coefficient */
#define DECFILTER_F_COEF3    DECFILTER_F.COEF[3].R         /* Filter Coefficient */
#define DECFILTER_F_COEF4    DECFILTER_F.COEF[4].R         /* Filter Coefficient */
#define DECFILTER_F_COEF5    DECFILTER_F.COEF[5].R         /* Filter Coefficient */
#define DECFILTER_F_COEF6    DECFILTER_F.COEF[6].R         /* Filter Coefficient */
#define DECFILTER_F_COEF7    DECFILTER_F.COEF[7].R         /* Filter Coefficient */
#define DECFILTER_F_COEF8    DECFILTER_F.COEF[8].R         /* Filter Coefficient */
#define DECFILTER_F_TAP0     DECFILTER_F.TAP[0].R          /* Filter TAP */
#define DECFILTER_F_TAP1     DECFILTER_F.TAP[1].R          /* Filter TAP */
#define DECFILTER_F_TAP2     DECFILTER_F.TAP[2].R          /* Filter TAP */
#define DECFILTER_F_TAP3     DECFILTER_F.TAP[3].R          /* Filter TAP */
#define DECFILTER_F_TAP4     DECFILTER_F.TAP[4].R          /* Filter TAP */
#define DECFILTER_F_TAP5     DECFILTER_F.TAP[5].R          /* Filter TAP */
#define DECFILTER_F_TAP6     DECFILTER_F.TAP[6].R          /* Filter TAP */
#define DECFILTER_F_TAP7     DECFILTER_F.TAP[7].R          /* Filter TAP */
#define DECFILTER_F_EDID     DECFILTER_F.EDID.R            /* Enhanced Debug Input Data */
#define DECFILTER_F_FINTVAL  DECFILTER_F.FINTVAL.R         /* Final Integer Value Register */
#define DECFILTER_F_FINTCNT  DECFILTER_F.FINTCNT.R         /* Final Integer Count Register */
#define DECFILTER_F_CINTVAL  DECFILTER_F.CINTVAL.R         /* Current Integer Value Register */
#define DECFILTER_F_CINTCNT  DECFILTER_F.CINTCNT.R         /* Current Integer Count Register */

#define DECFILTER_G_MCR      DECFILTER_G.MCR.R             /* Module Configuration Register */
#define DECFILTER_G_MSR      DECFILTER_G.MSR.R             /* Module Status Register */
#define DECFILTER_G_MXCR     DECFILTER_G.MXCR.R            /* Module Extended Config Register */
#define DECFILTER_G_MXSR     DECFILTER_G.MXSR.R            /* Module Extended Status Register */
#define DECFILTER_G_IB       DECFILTER_G.IB.R              /* Interface Input Buffer */
#define DECFILTER_G_OB       DECFILTER_G.OB.R              /* Interface Output Buffer */
#define DECFILTER_G_COEF0    DECFILTER_G.COEF[0].R         /* Filter Coefficient */
#define DECFILTER_G_COEF1    DECFILTER_G.COEF[1].R         /* Filter Coefficient */
#define DECFILTER_G_COEF2    DECFILTER_G.COEF[2].R         /* Filter Coefficient */
#define DECFILTER_G_COEF3    DECFILTER_G.COEF[3].R         /* Filter Coefficient */
#define DECFILTER_G_COEF4    DECFILTER_G.COEF[4].R         /* Filter Coefficient */
#define DECFILTER_G_COEF5    DECFILTER_G.COEF[5].R         /* Filter Coefficient */
#define DECFILTER_G_COEF6    DECFILTER_G.COEF[6].R         /* Filter Coefficient */
#define DECFILTER_G_COEF7    DECFILTER_G.COEF[7].R         /* Filter Coefficient */
#define DECFILTER_G_COEF8    DECFILTER_G.COEF[8].R         /* Filter Coefficient */
#define DECFILTER_G_TAP0     DECFILTER_G.TAP[0].R          /* Filter TAP */
#define DECFILTER_G_TAP1     DECFILTER_G.TAP[1].R          /* Filter TAP */
#define DECFILTER_G_TAP2     DECFILTER_G.TAP[2].R          /* Filter TAP */
#define DECFILTER_G_TAP3     DECFILTER_G.TAP[3].R          /* Filter TAP */
#define DECFILTER_G_TAP4     DECFILTER_G.TAP[4].R          /* Filter TAP */
#define DECFILTER_G_TAP5     DECFILTER_G.TAP[5].R          /* Filter TAP */
#define DECFILTER_G_TAP6     DECFILTER_G.TAP[6].R          /* Filter TAP */
#define DECFILTER_G_TAP7     DECFILTER_G.TAP[7].R          /* Filter TAP */
#define DECFILTER_G_EDID     DECFILTER_G.EDID.R            /* Enhanced Debug Input Data */
#define DECFILTER_G_FINTVAL  DECFILTER_G.FINTVAL.R         /* Final Integer Value Register */
#define DECFILTER_G_FINTCNT  DECFILTER_G.FINTCNT.R         /* Final Integer Count Register */
#define DECFILTER_G_CINTVAL  DECFILTER_G.CINTVAL.R         /* Current Integer Value Register */
#define DECFILTER_G_CINTCNT  DECFILTER_G.CINTCNT.R         /* Current Integer Count Register */

#define DECFILTER_H_MCR      DECFILTER_H.MCR.R             /* Module Configuration Register */
#define DECFILTER_H_MSR      DECFILTER_H.MSR.R             /* Module Status Register */
#define DECFILTER_H_MXCR     DECFILTER_H.MXCR.R            /* Module Extended Config Register */
#define DECFILTER_H_MXSR     DECFILTER_H.MXSR.R            /* Module Extended Status Register */
#define DECFILTER_H_IB       DECFILTER_H.IB.R              /* Interface Input Buffer */
#define DECFILTER_H_OB       DECFILTER_H.OB.R              /* Interface Output Buffer */
#define DECFILTER_H_COEF0    DECFILTER_H.COEF[0].R         /* Filter Coefficient */
#define DECFILTER_H_COEF1    DECFILTER_H.COEF[1].R         /* Filter Coefficient */
#define DECFILTER_H_COEF2    DECFILTER_H.COEF[2].R         /* Filter Coefficient */
#define DECFILTER_H_COEF3    DECFILTER_H.COEF[3].R         /* Filter Coefficient */
#define DECFILTER_H_COEF4    DECFILTER_H.COEF[4].R         /* Filter Coefficient */
#define DECFILTER_H_COEF5    DECFILTER_H.COEF[5].R         /* Filter Coefficient */
#define DECFILTER_H_COEF6    DECFILTER_H.COEF[6].R         /* Filter Coefficient */
#define DECFILTER_H_COEF7    DECFILTER_H.COEF[7].R         /* Filter Coefficient */
#define DECFILTER_H_COEF8    DECFILTER_H.COEF[8].R         /* Filter Coefficient */
#define DECFILTER_H_TAP0     DECFILTER_H.TAP[0].R          /* Filter TAP */
#define DECFILTER_H_TAP1     DECFILTER_H.TAP[1].R          /* Filter TAP */
#define DECFILTER_H_TAP2     DECFILTER_H.TAP[2].R          /* Filter TAP */
#define DECFILTER_H_TAP3     DECFILTER_H.TAP[3].R          /* Filter TAP */
#define DECFILTER_H_TAP4     DECFILTER_H.TAP[4].R          /* Filter TAP */
#define DECFILTER_H_TAP5     DECFILTER_H.TAP[5].R          /* Filter TAP */
#define DECFILTER_H_TAP6     DECFILTER_H.TAP[6].R          /* Filter TAP */
#define DECFILTER_H_TAP7     DECFILTER_H.TAP[7].R          /* Filter TAP */
#define DECFILTER_H_EDID     DECFILTER_H.EDID.R            /* Enhanced Debug Input Data */
#define DECFILTER_H_FINTVAL  DECFILTER_H.FINTVAL.R         /* Final Integer Value Register */
#define DECFILTER_H_FINTCNT  DECFILTER_H.FINTCNT.R         /* Final Integer Count Register */
#define DECFILTER_H_CINTVAL  DECFILTER_H.CINTVAL.R         /* Current Integer Value Register */
#define DECFILTER_H_CINTCNT  DECFILTER_H.CINTCNT.R         /* Current Integer Count Register */

#define DECFILTER_I_MCR      DECFILTER_I.MCR.R             /* Module Configuration Register */
#define DECFILTER_I_MSR      DECFILTER_I.MSR.R             /* Module Status Register */
#define DECFILTER_I_MXCR     DECFILTER_I.MXCR.R            /* Module Extended Config Register */
#define DECFILTER_I_MXSR     DECFILTER_I.MXSR.R            /* Module Extended Status Register */
#define DECFILTER_I_IB       DECFILTER_I.IB.R              /* Interface Input Buffer */
#define DECFILTER_I_OB       DECFILTER_I.OB.R              /* Interface Output Buffer */
#define DECFILTER_I_COEF0    DECFILTER_I.COEF[0].R         /* Filter Coefficient */
#define DECFILTER_I_COEF1    DECFILTER_I.COEF[1].R         /* Filter Coefficient */
#define DECFILTER_I_COEF2    DECFILTER_I.COEF[2].R         /* Filter Coefficient */
#define DECFILTER_I_COEF3    DECFILTER_I.COEF[3].R         /* Filter Coefficient */
#define DECFILTER_I_COEF4    DECFILTER_I.COEF[4].R         /* Filter Coefficient */
#define DECFILTER_I_COEF5    DECFILTER_I.COEF[5].R         /* Filter Coefficient */
#define DECFILTER_I_COEF6    DECFILTER_I.COEF[6].R         /* Filter Coefficient */
#define DECFILTER_I_COEF7    DECFILTER_I.COEF[7].R         /* Filter Coefficient */
#define DECFILTER_I_COEF8    DECFILTER_I.COEF[8].R         /* Filter Coefficient */
#define DECFILTER_I_TAP0     DECFILTER_I.TAP[0].R          /* Filter TAP */
#define DECFILTER_I_TAP1     DECFILTER_I.TAP[1].R          /* Filter TAP */
#define DECFILTER_I_TAP2     DECFILTER_I.TAP[2].R          /* Filter TAP */
#define DECFILTER_I_TAP3     DECFILTER_I.TAP[3].R          /* Filter TAP */
#define DECFILTER_I_TAP4     DECFILTER_I.TAP[4].R          /* Filter TAP */
#define DECFILTER_I_TAP5     DECFILTER_I.TAP[5].R          /* Filter TAP */
#define DECFILTER_I_TAP6     DECFILTER_I.TAP[6].R          /* Filter TAP */
#define DECFILTER_I_TAP7     DECFILTER_I.TAP[7].R          /* Filter TAP */
#define DECFILTER_I_EDID     DECFILTER_I.EDID.R            /* Enhanced Debug Input Data */
#define DECFILTER_I_FINTVAL  DECFILTER_I.FINTVAL.R         /* Final Integer Value Register */
#define DECFILTER_I_FINTCNT  DECFILTER_I.FINTCNT.R         /* Final Integer Count Register */
#define DECFILTER_I_CINTVAL  DECFILTER_I.CINTVAL.R         /* Current Integer Value Register */
#define DECFILTER_I_CINTCNT  DECFILTER_I.CINTCNT.R         /* Current Integer Count Register */

#define DECFILTER_J_MCR      DECFILTER_J.MCR.R             /* Module Configuration Register */
#define DECFILTER_J_MSR      DECFILTER_J.MSR.R             /* Module Status Register */
#define DECFILTER_J_MXCR     DECFILTER_J.MXCR.R            /* Module Extended Config Register */
#define DECFILTER_J_MXSR     DECFILTER_J.MXSR.R            /* Module Extended Status Register */
#define DECFILTER_J_IB       DECFILTER_J.IB.R              /* Interface Input Buffer */
#define DECFILTER_J_OB       DECFILTER_J.OB.R              /* Interface Output Buffer */
#define DECFILTER_J_COEF0    DECFILTER_J.COEF[0].R         /* Filter Coefficient */
#define DECFILTER_J_COEF1    DECFILTER_J.COEF[1].R         /* Filter Coefficient */
#define DECFILTER_J_COEF2    DECFILTER_J.COEF[2].R         /* Filter Coefficient */
#define DECFILTER_J_COEF3    DECFILTER_J.COEF[3].R         /* Filter Coefficient */
#define DECFILTER_J_COEF4    DECFILTER_J.COEF[4].R         /* Filter Coefficient */
#define DECFILTER_J_COEF5    DECFILTER_J.COEF[5].R         /* Filter Coefficient */
#define DECFILTER_J_COEF6    DECFILTER_J.COEF[6].R         /* Filter Coefficient */
#define DECFILTER_J_COEF7    DECFILTER_J.COEF[7].R         /* Filter Coefficient */
#define DECFILTER_J_COEF8    DECFILTER_J.COEF[8].R         /* Filter Coefficient */
#define DECFILTER_J_TAP0     DECFILTER_J.TAP[0].R          /* Filter TAP */
#define DECFILTER_J_TAP1     DECFILTER_J.TAP[1].R          /* Filter TAP */
#define DECFILTER_J_TAP2     DECFILTER_J.TAP[2].R          /* Filter TAP */
#define DECFILTER_J_TAP3     DECFILTER_J.TAP[3].R          /* Filter TAP */
#define DECFILTER_J_TAP4     DECFILTER_J.TAP[4].R          /* Filter TAP */
#define DECFILTER_J_TAP5     DECFILTER_J.TAP[5].R          /* Filter TAP */
#define DECFILTER_J_TAP6     DECFILTER_J.TAP[6].R          /* Filter TAP */
#define DECFILTER_J_TAP7     DECFILTER_J.TAP[7].R          /* Filter TAP */
#define DECFILTER_J_EDID     DECFILTER_J.EDID.R            /* Enhanced Debug Input Data */
#define DECFILTER_J_FINTVAL  DECFILTER_J.FINTVAL.R         /* Final Integer Value Register */
#define DECFILTER_J_FINTCNT  DECFILTER_J.FINTCNT.R         /* Final Integer Count Register */
#define DECFILTER_J_CINTVAL  DECFILTER_J.CINTVAL.R         /* Current Integer Value Register */
#define DECFILTER_J_CINTCNT  DECFILTER_J.CINTCNT.R         /* Current Integer Count Register */

#define DECFILTER_K_MCR      DECFILTER_K.MCR.R             /* Module Configuration Register */
#define DECFILTER_K_MSR      DECFILTER_K.MSR.R             /* Module Status Register */
#define DECFILTER_K_MXCR     DECFILTER_K.MXCR.R            /* Module Extended Config Register */
#define DECFILTER_K_MXSR     DECFILTER_K.MXSR.R            /* Module Extended Status Register */
#define DECFILTER_K_IB       DECFILTER_K.IB.R              /* Interface Input Buffer */
#define DECFILTER_K_OB       DECFILTER_K.OB.R              /* Interface Output Buffer */
#define DECFILTER_K_COEF0    DECFILTER_K.COEF[0].R         /* Filter Coefficient */
#define DECFILTER_K_COEF1    DECFILTER_K.COEF[1].R         /* Filter Coefficient */
#define DECFILTER_K_COEF2    DECFILTER_K.COEF[2].R         /* Filter Coefficient */
#define DECFILTER_K_COEF3    DECFILTER_K.COEF[3].R         /* Filter Coefficient */
#define DECFILTER_K_COEF4    DECFILTER_K.COEF[4].R         /* Filter Coefficient */
#define DECFILTER_K_COEF5    DECFILTER_K.COEF[5].R         /* Filter Coefficient */
#define DECFILTER_K_COEF6    DECFILTER_K.COEF[6].R         /* Filter Coefficient */
#define DECFILTER_K_COEF7    DECFILTER_K.COEF[7].R         /* Filter Coefficient */
#define DECFILTER_K_COEF8    DECFILTER_K.COEF[8].R         /* Filter Coefficient */
#define DECFILTER_K_TAP0     DECFILTER_K.TAP[0].R          /* Filter TAP */
#define DECFILTER_K_TAP1     DECFILTER_K.TAP[1].R          /* Filter TAP */
#define DECFILTER_K_TAP2     DECFILTER_K.TAP[2].R          /* Filter TAP */
#define DECFILTER_K_TAP3     DECFILTER_K.TAP[3].R          /* Filter TAP */
#define DECFILTER_K_TAP4     DECFILTER_K.TAP[4].R          /* Filter TAP */
#define DECFILTER_K_TAP5     DECFILTER_K.TAP[5].R          /* Filter TAP */
#define DECFILTER_K_TAP6     DECFILTER_K.TAP[6].R          /* Filter TAP */
#define DECFILTER_K_TAP7     DECFILTER_K.TAP[7].R          /* Filter TAP */
#define DECFILTER_K_EDID     DECFILTER_K.EDID.R            /* Enhanced Debug Input Data */
#define DECFILTER_K_FINTVAL  DECFILTER_K.FINTVAL.R         /* Final Integer Value Register */
#define DECFILTER_K_FINTCNT  DECFILTER_K.FINTCNT.R         /* Final Integer Count Register */
#define DECFILTER_K_CINTVAL  DECFILTER_K.CINTVAL.R         /* Current Integer Value Register */
#define DECFILTER_K_CINTCNT  DECFILTER_K.CINTCNT.R         /* Current Integer Count Register */

#define DECFILTER_L_MCR      DECFILTER_L.MCR.R             /* Module Configuration Register */
#define DECFILTER_L_MSR      DECFILTER_L.MSR.R             /* Module Status Register */
#define DECFILTER_L_MXCR     DECFILTER_L.MXCR.R            /* Module Extended Config Register */
#define DECFILTER_L_MXSR     DECFILTER_L.MXSR.R            /* Module Extended Status Register */
#define DECFILTER_L_IB       DECFILTER_L.IB.R              /* Interface Input Buffer */
#define DECFILTER_L_OB       DECFILTER_L.OB.R              /* Interface Output Buffer */
#define DECFILTER_L_COEF0    DECFILTER_L.COEF[0].R         /* Filter Coefficient */
#define DECFILTER_L_COEF1    DECFILTER_L.COEF[1].R         /* Filter Coefficient */
#define DECFILTER_L_COEF2    DECFILTER_L.COEF[2].R         /* Filter Coefficient */
#define DECFILTER_L_COEF3    DECFILTER_L.COEF[3].R         /* Filter Coefficient */
#define DECFILTER_L_COEF4    DECFILTER_L.COEF[4].R         /* Filter Coefficient */
#define DECFILTER_L_COEF5    DECFILTER_L.COEF[5].R         /* Filter Coefficient */
#define DECFILTER_L_COEF6    DECFILTER_L.COEF[6].R         /* Filter Coefficient */
#define DECFILTER_L_COEF7    DECFILTER_L.COEF[7].R         /* Filter Coefficient */
#define DECFILTER_L_COEF8    DECFILTER_L.COEF[8].R         /* Filter Coefficient */
#define DECFILTER_L_TAP0     DECFILTER_L.TAP[0].R          /* Filter TAP */
#define DECFILTER_L_TAP1     DECFILTER_L.TAP[1].R          /* Filter TAP */
#define DECFILTER_L_TAP2     DECFILTER_L.TAP[2].R          /* Filter TAP */
#define DECFILTER_L_TAP3     DECFILTER_L.TAP[3].R          /* Filter TAP */
#define DECFILTER_L_TAP4     DECFILTER_L.TAP[4].R          /* Filter TAP */
#define DECFILTER_L_TAP5     DECFILTER_L.TAP[5].R          /* Filter TAP */
#define DECFILTER_L_TAP6     DECFILTER_L.TAP[6].R          /* Filter TAP */
#define DECFILTER_L_TAP7     DECFILTER_L.TAP[7].R          /* Filter TAP */
#define DECFILTER_L_EDID     DECFILTER_L.EDID.R            /* Enhanced Debug Input Data */
#define DECFILTER_L_FINTVAL  DECFILTER_L.FINTVAL.R         /* Final Integer Value Register */
#define DECFILTER_L_FINTCNT  DECFILTER_L.FINTCNT.R         /* Final Integer Count Register */
#define DECFILTER_L_CINTVAL  DECFILTER_L.CINTVAL.R         /* Current Integer Value Register */
#define DECFILTER_L_CINTCNT  DECFILTER_L.CINTCNT.R         /* Current Integer Count Register */

/* DMA */
#define DMA_A_CR             DMA_A.CR.R                    /* Control Register */
#define DMA_A_ES             DMA_A.ES.R                    /* Error Status Register */
#define DMA_A_ERQH           DMA_A.ERQH.R                  /* Enable Request Register High */
#define DMA_A_ERQL           DMA_A.ERQL.R                  /* Enable Request Register Low */
#define DMA_A_EEIH           DMA_A.EEIH.R                  /* Enable Error Interrupt Register High */
#define DMA_A_EEIL           DMA_A.EEIL.R                  /* Enable Error Interrupt Register Low */
#define DMA_A_SERQ           DMA_A.SERQ.R                  /* Set Enable Request Register */
#define DMA_A_CERQ           DMA_A.CERQ.R                  /* Clear Enable Request Register */
#define DMA_A_SEEI           DMA_A.SEEI.R                  /* Set Enable Error Interrupt Register */
#define DMA_A_CEEI           DMA_A.CEEI.R                  /* Clear Enable Error Interrupt Register */
#define DMA_A_CINT           DMA_A.CINT.R                  /* Clear Interrupt Request Register */
#define DMA_A_CERR           DMA_A.CERR.R                  /* Clear Error Register */
#define DMA_A_SSRT           DMA_A.SSRT.R                  /* Set START Bit Register */
#define DMA_A_CDNE           DMA_A.CDNE.R                  /* Clear DONE Status Bit Register */
#define DMA_A_INTH           DMA_A.INTH.R                  /* Interrupt Request Register High */
#define DMA_A_INTL           DMA_A.INTL.R                  /* Interrupt Request Register Low */
#define DMA_A_ERRH           DMA_A.ERRH.R                  /* Error Register High */
#define DMA_A_ERRL           DMA_A.ERRL.R                  /* Error Register Low */
#define DMA_A_HRSH           DMA_A.HRSH.R                  /* Hardware Request Status Register High */
#define DMA_A_HRSL           DMA_A.HRSL.R                  /* Hardware Request Status Register Low */
#define DMA_A_GPORH          DMA_A.GPOR[0].R               /* Global PCU Output Register */
#define DMA_A_GPORL          DMA_A.GPOR[1].R               /* Global PCU Output Register */
#define DMA_A_DCHPRI0        DMA_A.DCHPRI[0].R             /* Channel n Priority Register */
#define DMA_A_DCHPRI1        DMA_A.DCHPRI[1].R             /* Channel n Priority Register */
#define DMA_A_DCHPRI2        DMA_A.DCHPRI[2].R             /* Channel n Priority Register */
#define DMA_A_DCHPRI3        DMA_A.DCHPRI[3].R             /* Channel n Priority Register */
#define DMA_A_DCHPRI4        DMA_A.DCHPRI[4].R             /* Channel n Priority Register */
#define DMA_A_DCHPRI5        DMA_A.DCHPRI[5].R             /* Channel n Priority Register */
#define DMA_A_DCHPRI6        DMA_A.DCHPRI[6].R             /* Channel n Priority Register */
#define DMA_A_DCHPRI7        DMA_A.DCHPRI[7].R             /* Channel n Priority Register */
#define DMA_A_DCHPRI8        DMA_A.DCHPRI[8].R             /* Channel n Priority Register */
#define DMA_A_DCHPRI9        DMA_A.DCHPRI[9].R             /* Channel n Priority Register */
#define DMA_A_DCHPRI10       DMA_A.DCHPRI[10].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI11       DMA_A.DCHPRI[11].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI12       DMA_A.DCHPRI[12].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI13       DMA_A.DCHPRI[13].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI14       DMA_A.DCHPRI[14].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI15       DMA_A.DCHPRI[15].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI16       DMA_A.DCHPRI[16].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI17       DMA_A.DCHPRI[17].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI18       DMA_A.DCHPRI[18].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI19       DMA_A.DCHPRI[19].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI20       DMA_A.DCHPRI[20].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI21       DMA_A.DCHPRI[21].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI22       DMA_A.DCHPRI[22].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI23       DMA_A.DCHPRI[23].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI24       DMA_A.DCHPRI[24].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI25       DMA_A.DCHPRI[25].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI26       DMA_A.DCHPRI[26].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI27       DMA_A.DCHPRI[27].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI28       DMA_A.DCHPRI[28].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI29       DMA_A.DCHPRI[29].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI30       DMA_A.DCHPRI[30].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI31       DMA_A.DCHPRI[31].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI32       DMA_A.DCHPRI[32].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI33       DMA_A.DCHPRI[33].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI34       DMA_A.DCHPRI[34].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI35       DMA_A.DCHPRI[35].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI36       DMA_A.DCHPRI[36].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI37       DMA_A.DCHPRI[37].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI38       DMA_A.DCHPRI[38].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI39       DMA_A.DCHPRI[39].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI40       DMA_A.DCHPRI[40].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI41       DMA_A.DCHPRI[41].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI42       DMA_A.DCHPRI[42].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI43       DMA_A.DCHPRI[43].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI44       DMA_A.DCHPRI[44].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI45       DMA_A.DCHPRI[45].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI46       DMA_A.DCHPRI[46].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI47       DMA_A.DCHPRI[47].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI48       DMA_A.DCHPRI[48].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI49       DMA_A.DCHPRI[49].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI50       DMA_A.DCHPRI[50].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI51       DMA_A.DCHPRI[51].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI52       DMA_A.DCHPRI[52].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI53       DMA_A.DCHPRI[53].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI54       DMA_A.DCHPRI[54].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI55       DMA_A.DCHPRI[55].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI56       DMA_A.DCHPRI[56].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI57       DMA_A.DCHPRI[57].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI58       DMA_A.DCHPRI[58].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI59       DMA_A.DCHPRI[59].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI60       DMA_A.DCHPRI[60].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI61       DMA_A.DCHPRI[61].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI62       DMA_A.DCHPRI[62].R            /* Channel n Priority Register */
#define DMA_A_DCHPRI63       DMA_A.DCHPRI[63].R            /* Channel n Priority Register */
#define DMA_A_TCD0_SADDR     DMA_A.TCD[0].SADDR.R          /* TCD Source Address */
#define DMA_A_TCD0_ATTR      DMA_A.TCD[0].ATTR.R           /* TCD Transfer Attributes */
#define DMA_A_TCD0_SOFF      DMA_A.TCD[0].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_A_TCD0_NBYTES_MLNO DMA_A.TCD[0].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD0_NBYTES_MLOFFNO DMA_A.TCD[0].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD0_NBYTES_MLOFFYES DMA_A.TCD[0].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD0_SLAST     DMA_A.TCD[0].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_A_TCD0_DADDR     DMA_A.TCD[0].DADDR.R          /* TCD Destination Address */
#define DMA_A_TCD0_CITER_ELINKNO DMA_A.TCD[0].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD0_CITER_ELINKYES DMA_A.TCD[0].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD0_DOFF      DMA_A.TCD[0].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_A_TCD0_DLASTSGA  DMA_A.TCD[0].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD0_BITER_ELINKNO DMA_A.TCD[0].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD0_BITER_ELINKYES DMA_A.TCD[0].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD0_CSR       DMA_A.TCD[0].CSR.R            /* TCD Control and Status */
#define DMA_A_TCD1_SADDR     DMA_A.TCD[1].SADDR.R          /* TCD Source Address */
#define DMA_A_TCD1_ATTR      DMA_A.TCD[1].ATTR.R           /* TCD Transfer Attributes */
#define DMA_A_TCD1_SOFF      DMA_A.TCD[1].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_A_TCD1_NBYTES_MLNO DMA_A.TCD[1].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD1_NBYTES_MLOFFNO DMA_A.TCD[1].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD1_NBYTES_MLOFFYES DMA_A.TCD[1].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD1_SLAST     DMA_A.TCD[1].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_A_TCD1_DADDR     DMA_A.TCD[1].DADDR.R          /* TCD Destination Address */
#define DMA_A_TCD1_CITER_ELINKNO DMA_A.TCD[1].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD1_CITER_ELINKYES DMA_A.TCD[1].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD1_DOFF      DMA_A.TCD[1].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_A_TCD1_DLASTSGA  DMA_A.TCD[1].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD1_BITER_ELINKNO DMA_A.TCD[1].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD1_BITER_ELINKYES DMA_A.TCD[1].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD1_CSR       DMA_A.TCD[1].CSR.R            /* TCD Control and Status */
#define DMA_A_TCD2_SADDR     DMA_A.TCD[2].SADDR.R          /* TCD Source Address */
#define DMA_A_TCD2_ATTR      DMA_A.TCD[2].ATTR.R           /* TCD Transfer Attributes */
#define DMA_A_TCD2_SOFF      DMA_A.TCD[2].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_A_TCD2_NBYTES_MLNO DMA_A.TCD[2].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD2_NBYTES_MLOFFNO DMA_A.TCD[2].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD2_NBYTES_MLOFFYES DMA_A.TCD[2].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD2_SLAST     DMA_A.TCD[2].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_A_TCD2_DADDR     DMA_A.TCD[2].DADDR.R          /* TCD Destination Address */
#define DMA_A_TCD2_CITER_ELINKNO DMA_A.TCD[2].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD2_CITER_ELINKYES DMA_A.TCD[2].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD2_DOFF      DMA_A.TCD[2].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_A_TCD2_DLASTSGA  DMA_A.TCD[2].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD2_BITER_ELINKNO DMA_A.TCD[2].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD2_BITER_ELINKYES DMA_A.TCD[2].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD2_CSR       DMA_A.TCD[2].CSR.R            /* TCD Control and Status */
#define DMA_A_TCD3_SADDR     DMA_A.TCD[3].SADDR.R          /* TCD Source Address */
#define DMA_A_TCD3_ATTR      DMA_A.TCD[3].ATTR.R           /* TCD Transfer Attributes */
#define DMA_A_TCD3_SOFF      DMA_A.TCD[3].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_A_TCD3_NBYTES_MLNO DMA_A.TCD[3].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD3_NBYTES_MLOFFNO DMA_A.TCD[3].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD3_NBYTES_MLOFFYES DMA_A.TCD[3].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD3_SLAST     DMA_A.TCD[3].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_A_TCD3_DADDR     DMA_A.TCD[3].DADDR.R          /* TCD Destination Address */
#define DMA_A_TCD3_CITER_ELINKNO DMA_A.TCD[3].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD3_CITER_ELINKYES DMA_A.TCD[3].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD3_DOFF      DMA_A.TCD[3].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_A_TCD3_DLASTSGA  DMA_A.TCD[3].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD3_BITER_ELINKNO DMA_A.TCD[3].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD3_BITER_ELINKYES DMA_A.TCD[3].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD3_CSR       DMA_A.TCD[3].CSR.R            /* TCD Control and Status */
#define DMA_A_TCD4_SADDR     DMA_A.TCD[4].SADDR.R          /* TCD Source Address */
#define DMA_A_TCD4_ATTR      DMA_A.TCD[4].ATTR.R           /* TCD Transfer Attributes */
#define DMA_A_TCD4_SOFF      DMA_A.TCD[4].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_A_TCD4_NBYTES_MLNO DMA_A.TCD[4].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD4_NBYTES_MLOFFNO DMA_A.TCD[4].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD4_NBYTES_MLOFFYES DMA_A.TCD[4].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD4_SLAST     DMA_A.TCD[4].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_A_TCD4_DADDR     DMA_A.TCD[4].DADDR.R          /* TCD Destination Address */
#define DMA_A_TCD4_CITER_ELINKNO DMA_A.TCD[4].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD4_CITER_ELINKYES DMA_A.TCD[4].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD4_DOFF      DMA_A.TCD[4].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_A_TCD4_DLASTSGA  DMA_A.TCD[4].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD4_BITER_ELINKNO DMA_A.TCD[4].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD4_BITER_ELINKYES DMA_A.TCD[4].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD4_CSR       DMA_A.TCD[4].CSR.R            /* TCD Control and Status */
#define DMA_A_TCD5_SADDR     DMA_A.TCD[5].SADDR.R          /* TCD Source Address */
#define DMA_A_TCD5_ATTR      DMA_A.TCD[5].ATTR.R           /* TCD Transfer Attributes */
#define DMA_A_TCD5_SOFF      DMA_A.TCD[5].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_A_TCD5_NBYTES_MLNO DMA_A.TCD[5].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD5_NBYTES_MLOFFNO DMA_A.TCD[5].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD5_NBYTES_MLOFFYES DMA_A.TCD[5].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD5_SLAST     DMA_A.TCD[5].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_A_TCD5_DADDR     DMA_A.TCD[5].DADDR.R          /* TCD Destination Address */
#define DMA_A_TCD5_CITER_ELINKNO DMA_A.TCD[5].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD5_CITER_ELINKYES DMA_A.TCD[5].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD5_DOFF      DMA_A.TCD[5].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_A_TCD5_DLASTSGA  DMA_A.TCD[5].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD5_BITER_ELINKNO DMA_A.TCD[5].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD5_BITER_ELINKYES DMA_A.TCD[5].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD5_CSR       DMA_A.TCD[5].CSR.R            /* TCD Control and Status */
#define DMA_A_TCD6_SADDR     DMA_A.TCD[6].SADDR.R          /* TCD Source Address */
#define DMA_A_TCD6_ATTR      DMA_A.TCD[6].ATTR.R           /* TCD Transfer Attributes */
#define DMA_A_TCD6_SOFF      DMA_A.TCD[6].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_A_TCD6_NBYTES_MLNO DMA_A.TCD[6].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD6_NBYTES_MLOFFNO DMA_A.TCD[6].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD6_NBYTES_MLOFFYES DMA_A.TCD[6].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD6_SLAST     DMA_A.TCD[6].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_A_TCD6_DADDR     DMA_A.TCD[6].DADDR.R          /* TCD Destination Address */
#define DMA_A_TCD6_CITER_ELINKNO DMA_A.TCD[6].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD6_CITER_ELINKYES DMA_A.TCD[6].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD6_DOFF      DMA_A.TCD[6].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_A_TCD6_DLASTSGA  DMA_A.TCD[6].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD6_BITER_ELINKNO DMA_A.TCD[6].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD6_BITER_ELINKYES DMA_A.TCD[6].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD6_CSR       DMA_A.TCD[6].CSR.R            /* TCD Control and Status */
#define DMA_A_TCD7_SADDR     DMA_A.TCD[7].SADDR.R          /* TCD Source Address */
#define DMA_A_TCD7_ATTR      DMA_A.TCD[7].ATTR.R           /* TCD Transfer Attributes */
#define DMA_A_TCD7_SOFF      DMA_A.TCD[7].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_A_TCD7_NBYTES_MLNO DMA_A.TCD[7].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD7_NBYTES_MLOFFNO DMA_A.TCD[7].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD7_NBYTES_MLOFFYES DMA_A.TCD[7].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD7_SLAST     DMA_A.TCD[7].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_A_TCD7_DADDR     DMA_A.TCD[7].DADDR.R          /* TCD Destination Address */
#define DMA_A_TCD7_CITER_ELINKNO DMA_A.TCD[7].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD7_CITER_ELINKYES DMA_A.TCD[7].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD7_DOFF      DMA_A.TCD[7].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_A_TCD7_DLASTSGA  DMA_A.TCD[7].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD7_BITER_ELINKNO DMA_A.TCD[7].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD7_BITER_ELINKYES DMA_A.TCD[7].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD7_CSR       DMA_A.TCD[7].CSR.R            /* TCD Control and Status */
#define DMA_A_TCD8_SADDR     DMA_A.TCD[8].SADDR.R          /* TCD Source Address */
#define DMA_A_TCD8_ATTR      DMA_A.TCD[8].ATTR.R           /* TCD Transfer Attributes */
#define DMA_A_TCD8_SOFF      DMA_A.TCD[8].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_A_TCD8_NBYTES_MLNO DMA_A.TCD[8].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD8_NBYTES_MLOFFNO DMA_A.TCD[8].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD8_NBYTES_MLOFFYES DMA_A.TCD[8].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD8_SLAST     DMA_A.TCD[8].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_A_TCD8_DADDR     DMA_A.TCD[8].DADDR.R          /* TCD Destination Address */
#define DMA_A_TCD8_CITER_ELINKNO DMA_A.TCD[8].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD8_CITER_ELINKYES DMA_A.TCD[8].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD8_DOFF      DMA_A.TCD[8].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_A_TCD8_DLASTSGA  DMA_A.TCD[8].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD8_BITER_ELINKNO DMA_A.TCD[8].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD8_BITER_ELINKYES DMA_A.TCD[8].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD8_CSR       DMA_A.TCD[8].CSR.R            /* TCD Control and Status */
#define DMA_A_TCD9_SADDR     DMA_A.TCD[9].SADDR.R          /* TCD Source Address */
#define DMA_A_TCD9_ATTR      DMA_A.TCD[9].ATTR.R           /* TCD Transfer Attributes */
#define DMA_A_TCD9_SOFF      DMA_A.TCD[9].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_A_TCD9_NBYTES_MLNO DMA_A.TCD[9].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD9_NBYTES_MLOFFNO DMA_A.TCD[9].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD9_NBYTES_MLOFFYES DMA_A.TCD[9].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD9_SLAST     DMA_A.TCD[9].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_A_TCD9_DADDR     DMA_A.TCD[9].DADDR.R          /* TCD Destination Address */
#define DMA_A_TCD9_CITER_ELINKNO DMA_A.TCD[9].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD9_CITER_ELINKYES DMA_A.TCD[9].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD9_DOFF      DMA_A.TCD[9].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_A_TCD9_DLASTSGA  DMA_A.TCD[9].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD9_BITER_ELINKNO DMA_A.TCD[9].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD9_BITER_ELINKYES DMA_A.TCD[9].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD9_CSR       DMA_A.TCD[9].CSR.R            /* TCD Control and Status */
#define DMA_A_TCD10_SADDR    DMA_A.TCD[10].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD10_ATTR     DMA_A.TCD[10].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD10_SOFF     DMA_A.TCD[10].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD10_NBYTES_MLNO DMA_A.TCD[10].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD10_NBYTES_MLOFFNO DMA_A.TCD[10].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD10_NBYTES_MLOFFYES DMA_A.TCD[10].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD10_SLAST    DMA_A.TCD[10].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD10_DADDR    DMA_A.TCD[10].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD10_CITER_ELINKNO DMA_A.TCD[10].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD10_CITER_ELINKYES DMA_A.TCD[10].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD10_DOFF     DMA_A.TCD[10].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD10_DLASTSGA DMA_A.TCD[10].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD10_BITER_ELINKNO DMA_A.TCD[10].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD10_BITER_ELINKYES DMA_A.TCD[10].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD10_CSR      DMA_A.TCD[10].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD11_SADDR    DMA_A.TCD[11].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD11_ATTR     DMA_A.TCD[11].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD11_SOFF     DMA_A.TCD[11].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD11_NBYTES_MLNO DMA_A.TCD[11].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD11_NBYTES_MLOFFNO DMA_A.TCD[11].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD11_NBYTES_MLOFFYES DMA_A.TCD[11].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD11_SLAST    DMA_A.TCD[11].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD11_DADDR    DMA_A.TCD[11].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD11_CITER_ELINKNO DMA_A.TCD[11].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD11_CITER_ELINKYES DMA_A.TCD[11].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD11_DOFF     DMA_A.TCD[11].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD11_DLASTSGA DMA_A.TCD[11].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD11_BITER_ELINKNO DMA_A.TCD[11].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD11_BITER_ELINKYES DMA_A.TCD[11].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD11_CSR      DMA_A.TCD[11].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD12_SADDR    DMA_A.TCD[12].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD12_ATTR     DMA_A.TCD[12].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD12_SOFF     DMA_A.TCD[12].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD12_NBYTES_MLNO DMA_A.TCD[12].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD12_NBYTES_MLOFFNO DMA_A.TCD[12].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD12_NBYTES_MLOFFYES DMA_A.TCD[12].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD12_SLAST    DMA_A.TCD[12].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD12_DADDR    DMA_A.TCD[12].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD12_CITER_ELINKNO DMA_A.TCD[12].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD12_CITER_ELINKYES DMA_A.TCD[12].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD12_DOFF     DMA_A.TCD[12].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD12_DLASTSGA DMA_A.TCD[12].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD12_BITER_ELINKNO DMA_A.TCD[12].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD12_BITER_ELINKYES DMA_A.TCD[12].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD12_CSR      DMA_A.TCD[12].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD13_SADDR    DMA_A.TCD[13].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD13_ATTR     DMA_A.TCD[13].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD13_SOFF     DMA_A.TCD[13].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD13_NBYTES_MLNO DMA_A.TCD[13].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD13_NBYTES_MLOFFNO DMA_A.TCD[13].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD13_NBYTES_MLOFFYES DMA_A.TCD[13].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD13_SLAST    DMA_A.TCD[13].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD13_DADDR    DMA_A.TCD[13].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD13_CITER_ELINKNO DMA_A.TCD[13].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD13_CITER_ELINKYES DMA_A.TCD[13].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD13_DOFF     DMA_A.TCD[13].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD13_DLASTSGA DMA_A.TCD[13].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD13_BITER_ELINKNO DMA_A.TCD[13].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD13_BITER_ELINKYES DMA_A.TCD[13].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD13_CSR      DMA_A.TCD[13].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD14_SADDR    DMA_A.TCD[14].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD14_ATTR     DMA_A.TCD[14].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD14_SOFF     DMA_A.TCD[14].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD14_NBYTES_MLNO DMA_A.TCD[14].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD14_NBYTES_MLOFFNO DMA_A.TCD[14].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD14_NBYTES_MLOFFYES DMA_A.TCD[14].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD14_SLAST    DMA_A.TCD[14].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD14_DADDR    DMA_A.TCD[14].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD14_CITER_ELINKNO DMA_A.TCD[14].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD14_CITER_ELINKYES DMA_A.TCD[14].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD14_DOFF     DMA_A.TCD[14].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD14_DLASTSGA DMA_A.TCD[14].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD14_BITER_ELINKNO DMA_A.TCD[14].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD14_BITER_ELINKYES DMA_A.TCD[14].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD14_CSR      DMA_A.TCD[14].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD15_SADDR    DMA_A.TCD[15].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD15_ATTR     DMA_A.TCD[15].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD15_SOFF     DMA_A.TCD[15].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD15_NBYTES_MLNO DMA_A.TCD[15].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD15_NBYTES_MLOFFNO DMA_A.TCD[15].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD15_NBYTES_MLOFFYES DMA_A.TCD[15].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD15_SLAST    DMA_A.TCD[15].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD15_DADDR    DMA_A.TCD[15].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD15_CITER_ELINKNO DMA_A.TCD[15].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD15_CITER_ELINKYES DMA_A.TCD[15].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD15_DOFF     DMA_A.TCD[15].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD15_DLASTSGA DMA_A.TCD[15].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD15_BITER_ELINKNO DMA_A.TCD[15].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD15_BITER_ELINKYES DMA_A.TCD[15].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD15_CSR      DMA_A.TCD[15].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD16_SADDR    DMA_A.TCD[16].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD16_ATTR     DMA_A.TCD[16].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD16_SOFF     DMA_A.TCD[16].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD16_NBYTES_MLNO DMA_A.TCD[16].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD16_NBYTES_MLOFFNO DMA_A.TCD[16].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD16_NBYTES_MLOFFYES DMA_A.TCD[16].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD16_SLAST    DMA_A.TCD[16].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD16_DADDR    DMA_A.TCD[16].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD16_CITER_ELINKNO DMA_A.TCD[16].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD16_CITER_ELINKYES DMA_A.TCD[16].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD16_DOFF     DMA_A.TCD[16].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD16_DLASTSGA DMA_A.TCD[16].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD16_BITER_ELINKNO DMA_A.TCD[16].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD16_BITER_ELINKYES DMA_A.TCD[16].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD16_CSR      DMA_A.TCD[16].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD17_SADDR    DMA_A.TCD[17].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD17_ATTR     DMA_A.TCD[17].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD17_SOFF     DMA_A.TCD[17].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD17_NBYTES_MLNO DMA_A.TCD[17].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD17_NBYTES_MLOFFNO DMA_A.TCD[17].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD17_NBYTES_MLOFFYES DMA_A.TCD[17].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD17_SLAST    DMA_A.TCD[17].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD17_DADDR    DMA_A.TCD[17].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD17_CITER_ELINKNO DMA_A.TCD[17].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD17_CITER_ELINKYES DMA_A.TCD[17].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD17_DOFF     DMA_A.TCD[17].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD17_DLASTSGA DMA_A.TCD[17].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD17_BITER_ELINKNO DMA_A.TCD[17].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD17_BITER_ELINKYES DMA_A.TCD[17].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD17_CSR      DMA_A.TCD[17].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD18_SADDR    DMA_A.TCD[18].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD18_ATTR     DMA_A.TCD[18].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD18_SOFF     DMA_A.TCD[18].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD18_NBYTES_MLNO DMA_A.TCD[18].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD18_NBYTES_MLOFFNO DMA_A.TCD[18].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD18_NBYTES_MLOFFYES DMA_A.TCD[18].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD18_SLAST    DMA_A.TCD[18].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD18_DADDR    DMA_A.TCD[18].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD18_CITER_ELINKNO DMA_A.TCD[18].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD18_CITER_ELINKYES DMA_A.TCD[18].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD18_DOFF     DMA_A.TCD[18].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD18_DLASTSGA DMA_A.TCD[18].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD18_BITER_ELINKNO DMA_A.TCD[18].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD18_BITER_ELINKYES DMA_A.TCD[18].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD18_CSR      DMA_A.TCD[18].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD19_SADDR    DMA_A.TCD[19].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD19_ATTR     DMA_A.TCD[19].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD19_SOFF     DMA_A.TCD[19].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD19_NBYTES_MLNO DMA_A.TCD[19].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD19_NBYTES_MLOFFNO DMA_A.TCD[19].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD19_NBYTES_MLOFFYES DMA_A.TCD[19].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD19_SLAST    DMA_A.TCD[19].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD19_DADDR    DMA_A.TCD[19].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD19_CITER_ELINKNO DMA_A.TCD[19].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD19_CITER_ELINKYES DMA_A.TCD[19].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD19_DOFF     DMA_A.TCD[19].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD19_DLASTSGA DMA_A.TCD[19].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD19_BITER_ELINKNO DMA_A.TCD[19].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD19_BITER_ELINKYES DMA_A.TCD[19].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD19_CSR      DMA_A.TCD[19].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD20_SADDR    DMA_A.TCD[20].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD20_ATTR     DMA_A.TCD[20].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD20_SOFF     DMA_A.TCD[20].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD20_NBYTES_MLNO DMA_A.TCD[20].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD20_NBYTES_MLOFFNO DMA_A.TCD[20].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD20_NBYTES_MLOFFYES DMA_A.TCD[20].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD20_SLAST    DMA_A.TCD[20].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD20_DADDR    DMA_A.TCD[20].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD20_CITER_ELINKNO DMA_A.TCD[20].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD20_CITER_ELINKYES DMA_A.TCD[20].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD20_DOFF     DMA_A.TCD[20].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD20_DLASTSGA DMA_A.TCD[20].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD20_BITER_ELINKNO DMA_A.TCD[20].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD20_BITER_ELINKYES DMA_A.TCD[20].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD20_CSR      DMA_A.TCD[20].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD21_SADDR    DMA_A.TCD[21].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD21_ATTR     DMA_A.TCD[21].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD21_SOFF     DMA_A.TCD[21].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD21_NBYTES_MLNO DMA_A.TCD[21].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD21_NBYTES_MLOFFNO DMA_A.TCD[21].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD21_NBYTES_MLOFFYES DMA_A.TCD[21].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD21_SLAST    DMA_A.TCD[21].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD21_DADDR    DMA_A.TCD[21].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD21_CITER_ELINKNO DMA_A.TCD[21].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD21_CITER_ELINKYES DMA_A.TCD[21].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD21_DOFF     DMA_A.TCD[21].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD21_DLASTSGA DMA_A.TCD[21].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD21_BITER_ELINKNO DMA_A.TCD[21].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD21_BITER_ELINKYES DMA_A.TCD[21].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD21_CSR      DMA_A.TCD[21].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD22_SADDR    DMA_A.TCD[22].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD22_ATTR     DMA_A.TCD[22].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD22_SOFF     DMA_A.TCD[22].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD22_NBYTES_MLNO DMA_A.TCD[22].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD22_NBYTES_MLOFFNO DMA_A.TCD[22].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD22_NBYTES_MLOFFYES DMA_A.TCD[22].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD22_SLAST    DMA_A.TCD[22].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD22_DADDR    DMA_A.TCD[22].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD22_CITER_ELINKNO DMA_A.TCD[22].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD22_CITER_ELINKYES DMA_A.TCD[22].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD22_DOFF     DMA_A.TCD[22].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD22_DLASTSGA DMA_A.TCD[22].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD22_BITER_ELINKNO DMA_A.TCD[22].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD22_BITER_ELINKYES DMA_A.TCD[22].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD22_CSR      DMA_A.TCD[22].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD23_SADDR    DMA_A.TCD[23].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD23_ATTR     DMA_A.TCD[23].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD23_SOFF     DMA_A.TCD[23].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD23_NBYTES_MLNO DMA_A.TCD[23].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD23_NBYTES_MLOFFNO DMA_A.TCD[23].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD23_NBYTES_MLOFFYES DMA_A.TCD[23].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD23_SLAST    DMA_A.TCD[23].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD23_DADDR    DMA_A.TCD[23].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD23_CITER_ELINKNO DMA_A.TCD[23].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD23_CITER_ELINKYES DMA_A.TCD[23].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD23_DOFF     DMA_A.TCD[23].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD23_DLASTSGA DMA_A.TCD[23].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD23_BITER_ELINKNO DMA_A.TCD[23].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD23_BITER_ELINKYES DMA_A.TCD[23].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD23_CSR      DMA_A.TCD[23].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD24_SADDR    DMA_A.TCD[24].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD24_ATTR     DMA_A.TCD[24].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD24_SOFF     DMA_A.TCD[24].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD24_NBYTES_MLNO DMA_A.TCD[24].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD24_NBYTES_MLOFFNO DMA_A.TCD[24].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD24_NBYTES_MLOFFYES DMA_A.TCD[24].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD24_SLAST    DMA_A.TCD[24].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD24_DADDR    DMA_A.TCD[24].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD24_CITER_ELINKNO DMA_A.TCD[24].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD24_CITER_ELINKYES DMA_A.TCD[24].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD24_DOFF     DMA_A.TCD[24].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD24_DLASTSGA DMA_A.TCD[24].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD24_BITER_ELINKNO DMA_A.TCD[24].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD24_BITER_ELINKYES DMA_A.TCD[24].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD24_CSR      DMA_A.TCD[24].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD25_SADDR    DMA_A.TCD[25].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD25_ATTR     DMA_A.TCD[25].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD25_SOFF     DMA_A.TCD[25].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD25_NBYTES_MLNO DMA_A.TCD[25].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD25_NBYTES_MLOFFNO DMA_A.TCD[25].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD25_NBYTES_MLOFFYES DMA_A.TCD[25].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD25_SLAST    DMA_A.TCD[25].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD25_DADDR    DMA_A.TCD[25].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD25_CITER_ELINKNO DMA_A.TCD[25].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD25_CITER_ELINKYES DMA_A.TCD[25].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD25_DOFF     DMA_A.TCD[25].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD25_DLASTSGA DMA_A.TCD[25].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD25_BITER_ELINKNO DMA_A.TCD[25].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD25_BITER_ELINKYES DMA_A.TCD[25].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD25_CSR      DMA_A.TCD[25].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD26_SADDR    DMA_A.TCD[26].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD26_ATTR     DMA_A.TCD[26].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD26_SOFF     DMA_A.TCD[26].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD26_NBYTES_MLNO DMA_A.TCD[26].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD26_NBYTES_MLOFFNO DMA_A.TCD[26].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD26_NBYTES_MLOFFYES DMA_A.TCD[26].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD26_SLAST    DMA_A.TCD[26].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD26_DADDR    DMA_A.TCD[26].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD26_CITER_ELINKNO DMA_A.TCD[26].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD26_CITER_ELINKYES DMA_A.TCD[26].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD26_DOFF     DMA_A.TCD[26].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD26_DLASTSGA DMA_A.TCD[26].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD26_BITER_ELINKNO DMA_A.TCD[26].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD26_BITER_ELINKYES DMA_A.TCD[26].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD26_CSR      DMA_A.TCD[26].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD27_SADDR    DMA_A.TCD[27].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD27_ATTR     DMA_A.TCD[27].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD27_SOFF     DMA_A.TCD[27].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD27_NBYTES_MLNO DMA_A.TCD[27].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD27_NBYTES_MLOFFNO DMA_A.TCD[27].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD27_NBYTES_MLOFFYES DMA_A.TCD[27].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD27_SLAST    DMA_A.TCD[27].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD27_DADDR    DMA_A.TCD[27].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD27_CITER_ELINKNO DMA_A.TCD[27].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD27_CITER_ELINKYES DMA_A.TCD[27].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD27_DOFF     DMA_A.TCD[27].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD27_DLASTSGA DMA_A.TCD[27].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD27_BITER_ELINKNO DMA_A.TCD[27].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD27_BITER_ELINKYES DMA_A.TCD[27].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD27_CSR      DMA_A.TCD[27].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD28_SADDR    DMA_A.TCD[28].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD28_ATTR     DMA_A.TCD[28].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD28_SOFF     DMA_A.TCD[28].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD28_NBYTES_MLNO DMA_A.TCD[28].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD28_NBYTES_MLOFFNO DMA_A.TCD[28].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD28_NBYTES_MLOFFYES DMA_A.TCD[28].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD28_SLAST    DMA_A.TCD[28].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD28_DADDR    DMA_A.TCD[28].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD28_CITER_ELINKNO DMA_A.TCD[28].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD28_CITER_ELINKYES DMA_A.TCD[28].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD28_DOFF     DMA_A.TCD[28].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD28_DLASTSGA DMA_A.TCD[28].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD28_BITER_ELINKNO DMA_A.TCD[28].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD28_BITER_ELINKYES DMA_A.TCD[28].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD28_CSR      DMA_A.TCD[28].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD29_SADDR    DMA_A.TCD[29].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD29_ATTR     DMA_A.TCD[29].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD29_SOFF     DMA_A.TCD[29].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD29_NBYTES_MLNO DMA_A.TCD[29].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD29_NBYTES_MLOFFNO DMA_A.TCD[29].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD29_NBYTES_MLOFFYES DMA_A.TCD[29].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD29_SLAST    DMA_A.TCD[29].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD29_DADDR    DMA_A.TCD[29].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD29_CITER_ELINKNO DMA_A.TCD[29].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD29_CITER_ELINKYES DMA_A.TCD[29].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD29_DOFF     DMA_A.TCD[29].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD29_DLASTSGA DMA_A.TCD[29].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD29_BITER_ELINKNO DMA_A.TCD[29].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD29_BITER_ELINKYES DMA_A.TCD[29].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD29_CSR      DMA_A.TCD[29].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD30_SADDR    DMA_A.TCD[30].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD30_ATTR     DMA_A.TCD[30].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD30_SOFF     DMA_A.TCD[30].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD30_NBYTES_MLNO DMA_A.TCD[30].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD30_NBYTES_MLOFFNO DMA_A.TCD[30].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD30_NBYTES_MLOFFYES DMA_A.TCD[30].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD30_SLAST    DMA_A.TCD[30].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD30_DADDR    DMA_A.TCD[30].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD30_CITER_ELINKNO DMA_A.TCD[30].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD30_CITER_ELINKYES DMA_A.TCD[30].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD30_DOFF     DMA_A.TCD[30].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD30_DLASTSGA DMA_A.TCD[30].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD30_BITER_ELINKNO DMA_A.TCD[30].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD30_BITER_ELINKYES DMA_A.TCD[30].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD30_CSR      DMA_A.TCD[30].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD31_SADDR    DMA_A.TCD[31].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD31_ATTR     DMA_A.TCD[31].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD31_SOFF     DMA_A.TCD[31].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD31_NBYTES_MLNO DMA_A.TCD[31].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD31_NBYTES_MLOFFNO DMA_A.TCD[31].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD31_NBYTES_MLOFFYES DMA_A.TCD[31].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD31_SLAST    DMA_A.TCD[31].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD31_DADDR    DMA_A.TCD[31].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD31_CITER_ELINKNO DMA_A.TCD[31].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD31_CITER_ELINKYES DMA_A.TCD[31].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD31_DOFF     DMA_A.TCD[31].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD31_DLASTSGA DMA_A.TCD[31].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD31_BITER_ELINKNO DMA_A.TCD[31].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD31_BITER_ELINKYES DMA_A.TCD[31].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD31_CSR      DMA_A.TCD[31].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD32_SADDR    DMA_A.TCD[32].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD32_ATTR     DMA_A.TCD[32].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD32_SOFF     DMA_A.TCD[32].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD32_NBYTES_MLNO DMA_A.TCD[32].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD32_NBYTES_MLOFFNO DMA_A.TCD[32].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD32_NBYTES_MLOFFYES DMA_A.TCD[32].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD32_SLAST    DMA_A.TCD[32].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD32_DADDR    DMA_A.TCD[32].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD32_CITER_ELINKNO DMA_A.TCD[32].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD32_CITER_ELINKYES DMA_A.TCD[32].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD32_DOFF     DMA_A.TCD[32].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD32_DLASTSGA DMA_A.TCD[32].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD32_BITER_ELINKNO DMA_A.TCD[32].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD32_BITER_ELINKYES DMA_A.TCD[32].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD32_CSR      DMA_A.TCD[32].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD33_SADDR    DMA_A.TCD[33].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD33_ATTR     DMA_A.TCD[33].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD33_SOFF     DMA_A.TCD[33].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD33_NBYTES_MLNO DMA_A.TCD[33].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD33_NBYTES_MLOFFNO DMA_A.TCD[33].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD33_NBYTES_MLOFFYES DMA_A.TCD[33].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD33_SLAST    DMA_A.TCD[33].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD33_DADDR    DMA_A.TCD[33].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD33_CITER_ELINKNO DMA_A.TCD[33].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD33_CITER_ELINKYES DMA_A.TCD[33].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD33_DOFF     DMA_A.TCD[33].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD33_DLASTSGA DMA_A.TCD[33].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD33_BITER_ELINKNO DMA_A.TCD[33].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD33_BITER_ELINKYES DMA_A.TCD[33].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD33_CSR      DMA_A.TCD[33].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD34_SADDR    DMA_A.TCD[34].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD34_ATTR     DMA_A.TCD[34].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD34_SOFF     DMA_A.TCD[34].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD34_NBYTES_MLNO DMA_A.TCD[34].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD34_NBYTES_MLOFFNO DMA_A.TCD[34].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD34_NBYTES_MLOFFYES DMA_A.TCD[34].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD34_SLAST    DMA_A.TCD[34].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD34_DADDR    DMA_A.TCD[34].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD34_CITER_ELINKNO DMA_A.TCD[34].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD34_CITER_ELINKYES DMA_A.TCD[34].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD34_DOFF     DMA_A.TCD[34].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD34_DLASTSGA DMA_A.TCD[34].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD34_BITER_ELINKNO DMA_A.TCD[34].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD34_BITER_ELINKYES DMA_A.TCD[34].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD34_CSR      DMA_A.TCD[34].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD35_SADDR    DMA_A.TCD[35].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD35_ATTR     DMA_A.TCD[35].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD35_SOFF     DMA_A.TCD[35].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD35_NBYTES_MLNO DMA_A.TCD[35].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD35_NBYTES_MLOFFNO DMA_A.TCD[35].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD35_NBYTES_MLOFFYES DMA_A.TCD[35].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD35_SLAST    DMA_A.TCD[35].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD35_DADDR    DMA_A.TCD[35].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD35_CITER_ELINKNO DMA_A.TCD[35].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD35_CITER_ELINKYES DMA_A.TCD[35].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD35_DOFF     DMA_A.TCD[35].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD35_DLASTSGA DMA_A.TCD[35].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD35_BITER_ELINKNO DMA_A.TCD[35].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD35_BITER_ELINKYES DMA_A.TCD[35].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD35_CSR      DMA_A.TCD[35].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD36_SADDR    DMA_A.TCD[36].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD36_ATTR     DMA_A.TCD[36].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD36_SOFF     DMA_A.TCD[36].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD36_NBYTES_MLNO DMA_A.TCD[36].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD36_NBYTES_MLOFFNO DMA_A.TCD[36].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD36_NBYTES_MLOFFYES DMA_A.TCD[36].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD36_SLAST    DMA_A.TCD[36].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD36_DADDR    DMA_A.TCD[36].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD36_CITER_ELINKNO DMA_A.TCD[36].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD36_CITER_ELINKYES DMA_A.TCD[36].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD36_DOFF     DMA_A.TCD[36].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD36_DLASTSGA DMA_A.TCD[36].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD36_BITER_ELINKNO DMA_A.TCD[36].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD36_BITER_ELINKYES DMA_A.TCD[36].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD36_CSR      DMA_A.TCD[36].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD37_SADDR    DMA_A.TCD[37].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD37_ATTR     DMA_A.TCD[37].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD37_SOFF     DMA_A.TCD[37].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD37_NBYTES_MLNO DMA_A.TCD[37].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD37_NBYTES_MLOFFNO DMA_A.TCD[37].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD37_NBYTES_MLOFFYES DMA_A.TCD[37].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD37_SLAST    DMA_A.TCD[37].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD37_DADDR    DMA_A.TCD[37].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD37_CITER_ELINKNO DMA_A.TCD[37].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD37_CITER_ELINKYES DMA_A.TCD[37].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD37_DOFF     DMA_A.TCD[37].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD37_DLASTSGA DMA_A.TCD[37].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD37_BITER_ELINKNO DMA_A.TCD[37].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD37_BITER_ELINKYES DMA_A.TCD[37].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD37_CSR      DMA_A.TCD[37].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD38_SADDR    DMA_A.TCD[38].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD38_ATTR     DMA_A.TCD[38].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD38_SOFF     DMA_A.TCD[38].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD38_NBYTES_MLNO DMA_A.TCD[38].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD38_NBYTES_MLOFFNO DMA_A.TCD[38].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD38_NBYTES_MLOFFYES DMA_A.TCD[38].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD38_SLAST    DMA_A.TCD[38].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD38_DADDR    DMA_A.TCD[38].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD38_CITER_ELINKNO DMA_A.TCD[38].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD38_CITER_ELINKYES DMA_A.TCD[38].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD38_DOFF     DMA_A.TCD[38].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD38_DLASTSGA DMA_A.TCD[38].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD38_BITER_ELINKNO DMA_A.TCD[38].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD38_BITER_ELINKYES DMA_A.TCD[38].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD38_CSR      DMA_A.TCD[38].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD39_SADDR    DMA_A.TCD[39].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD39_ATTR     DMA_A.TCD[39].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD39_SOFF     DMA_A.TCD[39].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD39_NBYTES_MLNO DMA_A.TCD[39].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD39_NBYTES_MLOFFNO DMA_A.TCD[39].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD39_NBYTES_MLOFFYES DMA_A.TCD[39].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD39_SLAST    DMA_A.TCD[39].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD39_DADDR    DMA_A.TCD[39].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD39_CITER_ELINKNO DMA_A.TCD[39].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD39_CITER_ELINKYES DMA_A.TCD[39].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD39_DOFF     DMA_A.TCD[39].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD39_DLASTSGA DMA_A.TCD[39].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD39_BITER_ELINKNO DMA_A.TCD[39].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD39_BITER_ELINKYES DMA_A.TCD[39].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD39_CSR      DMA_A.TCD[39].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD40_SADDR    DMA_A.TCD[40].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD40_ATTR     DMA_A.TCD[40].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD40_SOFF     DMA_A.TCD[40].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD40_NBYTES_MLNO DMA_A.TCD[40].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD40_NBYTES_MLOFFNO DMA_A.TCD[40].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD40_NBYTES_MLOFFYES DMA_A.TCD[40].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD40_SLAST    DMA_A.TCD[40].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD40_DADDR    DMA_A.TCD[40].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD40_CITER_ELINKNO DMA_A.TCD[40].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD40_CITER_ELINKYES DMA_A.TCD[40].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD40_DOFF     DMA_A.TCD[40].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD40_DLASTSGA DMA_A.TCD[40].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD40_BITER_ELINKNO DMA_A.TCD[40].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD40_BITER_ELINKYES DMA_A.TCD[40].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD40_CSR      DMA_A.TCD[40].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD41_SADDR    DMA_A.TCD[41].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD41_ATTR     DMA_A.TCD[41].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD41_SOFF     DMA_A.TCD[41].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD41_NBYTES_MLNO DMA_A.TCD[41].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD41_NBYTES_MLOFFNO DMA_A.TCD[41].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD41_NBYTES_MLOFFYES DMA_A.TCD[41].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD41_SLAST    DMA_A.TCD[41].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD41_DADDR    DMA_A.TCD[41].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD41_CITER_ELINKNO DMA_A.TCD[41].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD41_CITER_ELINKYES DMA_A.TCD[41].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD41_DOFF     DMA_A.TCD[41].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD41_DLASTSGA DMA_A.TCD[41].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD41_BITER_ELINKNO DMA_A.TCD[41].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD41_BITER_ELINKYES DMA_A.TCD[41].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD41_CSR      DMA_A.TCD[41].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD42_SADDR    DMA_A.TCD[42].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD42_ATTR     DMA_A.TCD[42].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD42_SOFF     DMA_A.TCD[42].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD42_NBYTES_MLNO DMA_A.TCD[42].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD42_NBYTES_MLOFFNO DMA_A.TCD[42].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD42_NBYTES_MLOFFYES DMA_A.TCD[42].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD42_SLAST    DMA_A.TCD[42].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD42_DADDR    DMA_A.TCD[42].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD42_CITER_ELINKNO DMA_A.TCD[42].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD42_CITER_ELINKYES DMA_A.TCD[42].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD42_DOFF     DMA_A.TCD[42].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD42_DLASTSGA DMA_A.TCD[42].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD42_BITER_ELINKNO DMA_A.TCD[42].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD42_BITER_ELINKYES DMA_A.TCD[42].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD42_CSR      DMA_A.TCD[42].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD43_SADDR    DMA_A.TCD[43].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD43_ATTR     DMA_A.TCD[43].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD43_SOFF     DMA_A.TCD[43].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD43_NBYTES_MLNO DMA_A.TCD[43].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD43_NBYTES_MLOFFNO DMA_A.TCD[43].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD43_NBYTES_MLOFFYES DMA_A.TCD[43].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD43_SLAST    DMA_A.TCD[43].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD43_DADDR    DMA_A.TCD[43].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD43_CITER_ELINKNO DMA_A.TCD[43].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD43_CITER_ELINKYES DMA_A.TCD[43].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD43_DOFF     DMA_A.TCD[43].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD43_DLASTSGA DMA_A.TCD[43].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD43_BITER_ELINKNO DMA_A.TCD[43].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD43_BITER_ELINKYES DMA_A.TCD[43].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD43_CSR      DMA_A.TCD[43].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD44_SADDR    DMA_A.TCD[44].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD44_ATTR     DMA_A.TCD[44].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD44_SOFF     DMA_A.TCD[44].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD44_NBYTES_MLNO DMA_A.TCD[44].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD44_NBYTES_MLOFFNO DMA_A.TCD[44].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD44_NBYTES_MLOFFYES DMA_A.TCD[44].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD44_SLAST    DMA_A.TCD[44].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD44_DADDR    DMA_A.TCD[44].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD44_CITER_ELINKNO DMA_A.TCD[44].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD44_CITER_ELINKYES DMA_A.TCD[44].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD44_DOFF     DMA_A.TCD[44].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD44_DLASTSGA DMA_A.TCD[44].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD44_BITER_ELINKNO DMA_A.TCD[44].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD44_BITER_ELINKYES DMA_A.TCD[44].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD44_CSR      DMA_A.TCD[44].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD45_SADDR    DMA_A.TCD[45].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD45_ATTR     DMA_A.TCD[45].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD45_SOFF     DMA_A.TCD[45].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD45_NBYTES_MLNO DMA_A.TCD[45].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD45_NBYTES_MLOFFNO DMA_A.TCD[45].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD45_NBYTES_MLOFFYES DMA_A.TCD[45].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD45_SLAST    DMA_A.TCD[45].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD45_DADDR    DMA_A.TCD[45].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD45_CITER_ELINKNO DMA_A.TCD[45].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD45_CITER_ELINKYES DMA_A.TCD[45].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD45_DOFF     DMA_A.TCD[45].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD45_DLASTSGA DMA_A.TCD[45].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD45_BITER_ELINKNO DMA_A.TCD[45].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD45_BITER_ELINKYES DMA_A.TCD[45].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD45_CSR      DMA_A.TCD[45].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD46_SADDR    DMA_A.TCD[46].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD46_ATTR     DMA_A.TCD[46].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD46_SOFF     DMA_A.TCD[46].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD46_NBYTES_MLNO DMA_A.TCD[46].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD46_NBYTES_MLOFFNO DMA_A.TCD[46].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD46_NBYTES_MLOFFYES DMA_A.TCD[46].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD46_SLAST    DMA_A.TCD[46].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD46_DADDR    DMA_A.TCD[46].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD46_CITER_ELINKNO DMA_A.TCD[46].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD46_CITER_ELINKYES DMA_A.TCD[46].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD46_DOFF     DMA_A.TCD[46].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD46_DLASTSGA DMA_A.TCD[46].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD46_BITER_ELINKNO DMA_A.TCD[46].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD46_BITER_ELINKYES DMA_A.TCD[46].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD46_CSR      DMA_A.TCD[46].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD47_SADDR    DMA_A.TCD[47].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD47_ATTR     DMA_A.TCD[47].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD47_SOFF     DMA_A.TCD[47].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD47_NBYTES_MLNO DMA_A.TCD[47].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD47_NBYTES_MLOFFNO DMA_A.TCD[47].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD47_NBYTES_MLOFFYES DMA_A.TCD[47].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD47_SLAST    DMA_A.TCD[47].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD47_DADDR    DMA_A.TCD[47].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD47_CITER_ELINKNO DMA_A.TCD[47].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD47_CITER_ELINKYES DMA_A.TCD[47].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD47_DOFF     DMA_A.TCD[47].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD47_DLASTSGA DMA_A.TCD[47].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD47_BITER_ELINKNO DMA_A.TCD[47].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD47_BITER_ELINKYES DMA_A.TCD[47].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD47_CSR      DMA_A.TCD[47].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD48_SADDR    DMA_A.TCD[48].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD48_ATTR     DMA_A.TCD[48].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD48_SOFF     DMA_A.TCD[48].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD48_NBYTES_MLNO DMA_A.TCD[48].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD48_NBYTES_MLOFFNO DMA_A.TCD[48].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD48_NBYTES_MLOFFYES DMA_A.TCD[48].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD48_SLAST    DMA_A.TCD[48].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD48_DADDR    DMA_A.TCD[48].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD48_CITER_ELINKNO DMA_A.TCD[48].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD48_CITER_ELINKYES DMA_A.TCD[48].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD48_DOFF     DMA_A.TCD[48].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD48_DLASTSGA DMA_A.TCD[48].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD48_BITER_ELINKNO DMA_A.TCD[48].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD48_BITER_ELINKYES DMA_A.TCD[48].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD48_CSR      DMA_A.TCD[48].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD49_SADDR    DMA_A.TCD[49].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD49_ATTR     DMA_A.TCD[49].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD49_SOFF     DMA_A.TCD[49].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD49_NBYTES_MLNO DMA_A.TCD[49].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD49_NBYTES_MLOFFNO DMA_A.TCD[49].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD49_NBYTES_MLOFFYES DMA_A.TCD[49].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD49_SLAST    DMA_A.TCD[49].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD49_DADDR    DMA_A.TCD[49].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD49_CITER_ELINKNO DMA_A.TCD[49].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD49_CITER_ELINKYES DMA_A.TCD[49].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD49_DOFF     DMA_A.TCD[49].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD49_DLASTSGA DMA_A.TCD[49].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD49_BITER_ELINKNO DMA_A.TCD[49].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD49_BITER_ELINKYES DMA_A.TCD[49].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD49_CSR      DMA_A.TCD[49].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD50_SADDR    DMA_A.TCD[50].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD50_ATTR     DMA_A.TCD[50].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD50_SOFF     DMA_A.TCD[50].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD50_NBYTES_MLNO DMA_A.TCD[50].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD50_NBYTES_MLOFFNO DMA_A.TCD[50].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD50_NBYTES_MLOFFYES DMA_A.TCD[50].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD50_SLAST    DMA_A.TCD[50].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD50_DADDR    DMA_A.TCD[50].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD50_CITER_ELINKNO DMA_A.TCD[50].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD50_CITER_ELINKYES DMA_A.TCD[50].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD50_DOFF     DMA_A.TCD[50].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD50_DLASTSGA DMA_A.TCD[50].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD50_BITER_ELINKNO DMA_A.TCD[50].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD50_BITER_ELINKYES DMA_A.TCD[50].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD50_CSR      DMA_A.TCD[50].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD51_SADDR    DMA_A.TCD[51].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD51_ATTR     DMA_A.TCD[51].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD51_SOFF     DMA_A.TCD[51].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD51_NBYTES_MLNO DMA_A.TCD[51].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD51_NBYTES_MLOFFNO DMA_A.TCD[51].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD51_NBYTES_MLOFFYES DMA_A.TCD[51].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD51_SLAST    DMA_A.TCD[51].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD51_DADDR    DMA_A.TCD[51].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD51_CITER_ELINKNO DMA_A.TCD[51].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD51_CITER_ELINKYES DMA_A.TCD[51].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD51_DOFF     DMA_A.TCD[51].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD51_DLASTSGA DMA_A.TCD[51].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD51_BITER_ELINKNO DMA_A.TCD[51].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD51_BITER_ELINKYES DMA_A.TCD[51].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD51_CSR      DMA_A.TCD[51].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD52_SADDR    DMA_A.TCD[52].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD52_ATTR     DMA_A.TCD[52].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD52_SOFF     DMA_A.TCD[52].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD52_NBYTES_MLNO DMA_A.TCD[52].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD52_NBYTES_MLOFFNO DMA_A.TCD[52].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD52_NBYTES_MLOFFYES DMA_A.TCD[52].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD52_SLAST    DMA_A.TCD[52].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD52_DADDR    DMA_A.TCD[52].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD52_CITER_ELINKNO DMA_A.TCD[52].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD52_CITER_ELINKYES DMA_A.TCD[52].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD52_DOFF     DMA_A.TCD[52].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD52_DLASTSGA DMA_A.TCD[52].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD52_BITER_ELINKNO DMA_A.TCD[52].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD52_BITER_ELINKYES DMA_A.TCD[52].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD52_CSR      DMA_A.TCD[52].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD53_SADDR    DMA_A.TCD[53].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD53_ATTR     DMA_A.TCD[53].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD53_SOFF     DMA_A.TCD[53].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD53_NBYTES_MLNO DMA_A.TCD[53].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD53_NBYTES_MLOFFNO DMA_A.TCD[53].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD53_NBYTES_MLOFFYES DMA_A.TCD[53].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD53_SLAST    DMA_A.TCD[53].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD53_DADDR    DMA_A.TCD[53].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD53_CITER_ELINKNO DMA_A.TCD[53].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD53_CITER_ELINKYES DMA_A.TCD[53].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD53_DOFF     DMA_A.TCD[53].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD53_DLASTSGA DMA_A.TCD[53].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD53_BITER_ELINKNO DMA_A.TCD[53].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD53_BITER_ELINKYES DMA_A.TCD[53].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD53_CSR      DMA_A.TCD[53].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD54_SADDR    DMA_A.TCD[54].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD54_ATTR     DMA_A.TCD[54].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD54_SOFF     DMA_A.TCD[54].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD54_NBYTES_MLNO DMA_A.TCD[54].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD54_NBYTES_MLOFFNO DMA_A.TCD[54].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD54_NBYTES_MLOFFYES DMA_A.TCD[54].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD54_SLAST    DMA_A.TCD[54].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD54_DADDR    DMA_A.TCD[54].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD54_CITER_ELINKNO DMA_A.TCD[54].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD54_CITER_ELINKYES DMA_A.TCD[54].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD54_DOFF     DMA_A.TCD[54].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD54_DLASTSGA DMA_A.TCD[54].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD54_BITER_ELINKNO DMA_A.TCD[54].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD54_BITER_ELINKYES DMA_A.TCD[54].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD54_CSR      DMA_A.TCD[54].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD55_SADDR    DMA_A.TCD[55].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD55_ATTR     DMA_A.TCD[55].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD55_SOFF     DMA_A.TCD[55].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD55_NBYTES_MLNO DMA_A.TCD[55].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD55_NBYTES_MLOFFNO DMA_A.TCD[55].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD55_NBYTES_MLOFFYES DMA_A.TCD[55].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD55_SLAST    DMA_A.TCD[55].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD55_DADDR    DMA_A.TCD[55].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD55_CITER_ELINKNO DMA_A.TCD[55].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD55_CITER_ELINKYES DMA_A.TCD[55].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD55_DOFF     DMA_A.TCD[55].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD55_DLASTSGA DMA_A.TCD[55].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD55_BITER_ELINKNO DMA_A.TCD[55].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD55_BITER_ELINKYES DMA_A.TCD[55].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD55_CSR      DMA_A.TCD[55].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD56_SADDR    DMA_A.TCD[56].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD56_ATTR     DMA_A.TCD[56].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD56_SOFF     DMA_A.TCD[56].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD56_NBYTES_MLNO DMA_A.TCD[56].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD56_NBYTES_MLOFFNO DMA_A.TCD[56].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD56_NBYTES_MLOFFYES DMA_A.TCD[56].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD56_SLAST    DMA_A.TCD[56].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD56_DADDR    DMA_A.TCD[56].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD56_CITER_ELINKNO DMA_A.TCD[56].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD56_CITER_ELINKYES DMA_A.TCD[56].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD56_DOFF     DMA_A.TCD[56].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD56_DLASTSGA DMA_A.TCD[56].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD56_BITER_ELINKNO DMA_A.TCD[56].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD56_BITER_ELINKYES DMA_A.TCD[56].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD56_CSR      DMA_A.TCD[56].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD57_SADDR    DMA_A.TCD[57].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD57_ATTR     DMA_A.TCD[57].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD57_SOFF     DMA_A.TCD[57].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD57_NBYTES_MLNO DMA_A.TCD[57].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD57_NBYTES_MLOFFNO DMA_A.TCD[57].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD57_NBYTES_MLOFFYES DMA_A.TCD[57].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD57_SLAST    DMA_A.TCD[57].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD57_DADDR    DMA_A.TCD[57].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD57_CITER_ELINKNO DMA_A.TCD[57].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD57_CITER_ELINKYES DMA_A.TCD[57].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD57_DOFF     DMA_A.TCD[57].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD57_DLASTSGA DMA_A.TCD[57].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD57_BITER_ELINKNO DMA_A.TCD[57].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD57_BITER_ELINKYES DMA_A.TCD[57].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD57_CSR      DMA_A.TCD[57].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD58_SADDR    DMA_A.TCD[58].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD58_ATTR     DMA_A.TCD[58].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD58_SOFF     DMA_A.TCD[58].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD58_NBYTES_MLNO DMA_A.TCD[58].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD58_NBYTES_MLOFFNO DMA_A.TCD[58].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD58_NBYTES_MLOFFYES DMA_A.TCD[58].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD58_SLAST    DMA_A.TCD[58].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD58_DADDR    DMA_A.TCD[58].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD58_CITER_ELINKNO DMA_A.TCD[58].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD58_CITER_ELINKYES DMA_A.TCD[58].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD58_DOFF     DMA_A.TCD[58].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD58_DLASTSGA DMA_A.TCD[58].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD58_BITER_ELINKNO DMA_A.TCD[58].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD58_BITER_ELINKYES DMA_A.TCD[58].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD58_CSR      DMA_A.TCD[58].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD59_SADDR    DMA_A.TCD[59].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD59_ATTR     DMA_A.TCD[59].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD59_SOFF     DMA_A.TCD[59].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD59_NBYTES_MLNO DMA_A.TCD[59].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD59_NBYTES_MLOFFNO DMA_A.TCD[59].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD59_NBYTES_MLOFFYES DMA_A.TCD[59].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD59_SLAST    DMA_A.TCD[59].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD59_DADDR    DMA_A.TCD[59].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD59_CITER_ELINKNO DMA_A.TCD[59].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD59_CITER_ELINKYES DMA_A.TCD[59].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD59_DOFF     DMA_A.TCD[59].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD59_DLASTSGA DMA_A.TCD[59].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD59_BITER_ELINKNO DMA_A.TCD[59].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD59_BITER_ELINKYES DMA_A.TCD[59].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD59_CSR      DMA_A.TCD[59].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD60_SADDR    DMA_A.TCD[60].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD60_ATTR     DMA_A.TCD[60].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD60_SOFF     DMA_A.TCD[60].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD60_NBYTES_MLNO DMA_A.TCD[60].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD60_NBYTES_MLOFFNO DMA_A.TCD[60].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD60_NBYTES_MLOFFYES DMA_A.TCD[60].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD60_SLAST    DMA_A.TCD[60].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD60_DADDR    DMA_A.TCD[60].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD60_CITER_ELINKNO DMA_A.TCD[60].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD60_CITER_ELINKYES DMA_A.TCD[60].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD60_DOFF     DMA_A.TCD[60].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD60_DLASTSGA DMA_A.TCD[60].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD60_BITER_ELINKNO DMA_A.TCD[60].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD60_BITER_ELINKYES DMA_A.TCD[60].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD60_CSR      DMA_A.TCD[60].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD61_SADDR    DMA_A.TCD[61].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD61_ATTR     DMA_A.TCD[61].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD61_SOFF     DMA_A.TCD[61].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD61_NBYTES_MLNO DMA_A.TCD[61].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD61_NBYTES_MLOFFNO DMA_A.TCD[61].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD61_NBYTES_MLOFFYES DMA_A.TCD[61].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD61_SLAST    DMA_A.TCD[61].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD61_DADDR    DMA_A.TCD[61].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD61_CITER_ELINKNO DMA_A.TCD[61].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD61_CITER_ELINKYES DMA_A.TCD[61].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD61_DOFF     DMA_A.TCD[61].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD61_DLASTSGA DMA_A.TCD[61].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD61_BITER_ELINKNO DMA_A.TCD[61].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD61_BITER_ELINKYES DMA_A.TCD[61].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD61_CSR      DMA_A.TCD[61].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD62_SADDR    DMA_A.TCD[62].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD62_ATTR     DMA_A.TCD[62].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD62_SOFF     DMA_A.TCD[62].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD62_NBYTES_MLNO DMA_A.TCD[62].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD62_NBYTES_MLOFFNO DMA_A.TCD[62].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD62_NBYTES_MLOFFYES DMA_A.TCD[62].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD62_SLAST    DMA_A.TCD[62].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD62_DADDR    DMA_A.TCD[62].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD62_CITER_ELINKNO DMA_A.TCD[62].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD62_CITER_ELINKYES DMA_A.TCD[62].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD62_DOFF     DMA_A.TCD[62].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD62_DLASTSGA DMA_A.TCD[62].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD62_BITER_ELINKNO DMA_A.TCD[62].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD62_BITER_ELINKYES DMA_A.TCD[62].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD62_CSR      DMA_A.TCD[62].CSR.R           /* TCD Control and Status */
#define DMA_A_TCD63_SADDR    DMA_A.TCD[63].SADDR.R         /* TCD Source Address */
#define DMA_A_TCD63_ATTR     DMA_A.TCD[63].ATTR.R          /* TCD Transfer Attributes */
#define DMA_A_TCD63_SOFF     DMA_A.TCD[63].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_A_TCD63_NBYTES_MLNO DMA_A.TCD[63].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_A_TCD63_NBYTES_MLOFFNO DMA_A.TCD[63].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_A_TCD63_NBYTES_MLOFFYES DMA_A.TCD[63].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_A_TCD63_SLAST    DMA_A.TCD[63].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_A_TCD63_DADDR    DMA_A.TCD[63].DADDR.R         /* TCD Destination Address */
#define DMA_A_TCD63_CITER_ELINKNO DMA_A.TCD[63].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD63_CITER_ELINKYES DMA_A.TCD[63].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD63_DOFF     DMA_A.TCD[63].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_A_TCD63_DLASTSGA DMA_A.TCD[63].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_A_TCD63_BITER_ELINKNO DMA_A.TCD[63].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_A_TCD63_BITER_ELINKYES DMA_A.TCD[63].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_A_TCD63_CSR      DMA_A.TCD[63].CSR.R           /* TCD Control and Status */

#define DMA_B_CR             DMA_B.CR.R                    /* Control Register */
#define DMA_B_ES             DMA_B.ES.R                    /* Error Status Register */
#define DMA_B_ERQH           DMA_B.ERQH.R                  /* Enable Request Register High */
#define DMA_B_ERQL           DMA_B.ERQL.R                  /* Enable Request Register Low */
#define DMA_B_EEIH           DMA_B.EEIH.R                  /* Enable Error Interrupt Register High */
#define DMA_B_EEIL           DMA_B.EEIL.R                  /* Enable Error Interrupt Register Low */
#define DMA_B_SERQ           DMA_B.SERQ.R                  /* Set Enable Request Register */
#define DMA_B_CERQ           DMA_B.CERQ.R                  /* Clear Enable Request Register */
#define DMA_B_SEEI           DMA_B.SEEI.R                  /* Set Enable Error Interrupt Register */
#define DMA_B_CEEI           DMA_B.CEEI.R                  /* Clear Enable Error Interrupt Register */
#define DMA_B_CINT           DMA_B.CINT.R                  /* Clear Interrupt Request Register */
#define DMA_B_CERR           DMA_B.CERR.R                  /* Clear Error Register */
#define DMA_B_SSRT           DMA_B.SSRT.R                  /* Set START Bit Register */
#define DMA_B_CDNE           DMA_B.CDNE.R                  /* Clear DONE Status Bit Register */
#define DMA_B_INTH           DMA_B.INTH.R                  /* Interrupt Request Register High */
#define DMA_B_INTL           DMA_B.INTL.R                  /* Interrupt Request Register Low */
#define DMA_B_ERRH           DMA_B.ERRH.R                  /* Error Register High */
#define DMA_B_ERRL           DMA_B.ERRL.R                  /* Error Register Low */
#define DMA_B_HRSH           DMA_B.HRSH.R                  /* Hardware Request Status Register High */
#define DMA_B_HRSL           DMA_B.HRSL.R                  /* Hardware Request Status Register Low */
#define DMA_B_GPORH          DMA_B.GPOR[0].R               /* Global PCU Output Register */
#define DMA_B_GPORL          DMA_B.GPOR[1].R               /* Global PCU Output Register */
#define DMA_B_DCHPRI0        DMA_B.DCHPRI[0].R             /* Channel n Priority Register */
#define DMA_B_DCHPRI1        DMA_B.DCHPRI[1].R             /* Channel n Priority Register */
#define DMA_B_DCHPRI2        DMA_B.DCHPRI[2].R             /* Channel n Priority Register */
#define DMA_B_DCHPRI3        DMA_B.DCHPRI[3].R             /* Channel n Priority Register */
#define DMA_B_DCHPRI4        DMA_B.DCHPRI[4].R             /* Channel n Priority Register */
#define DMA_B_DCHPRI5        DMA_B.DCHPRI[5].R             /* Channel n Priority Register */
#define DMA_B_DCHPRI6        DMA_B.DCHPRI[6].R             /* Channel n Priority Register */
#define DMA_B_DCHPRI7        DMA_B.DCHPRI[7].R             /* Channel n Priority Register */
#define DMA_B_DCHPRI8        DMA_B.DCHPRI[8].R             /* Channel n Priority Register */
#define DMA_B_DCHPRI9        DMA_B.DCHPRI[9].R             /* Channel n Priority Register */
#define DMA_B_DCHPRI10       DMA_B.DCHPRI[10].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI11       DMA_B.DCHPRI[11].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI12       DMA_B.DCHPRI[12].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI13       DMA_B.DCHPRI[13].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI14       DMA_B.DCHPRI[14].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI15       DMA_B.DCHPRI[15].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI16       DMA_B.DCHPRI[16].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI17       DMA_B.DCHPRI[17].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI18       DMA_B.DCHPRI[18].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI19       DMA_B.DCHPRI[19].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI20       DMA_B.DCHPRI[20].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI21       DMA_B.DCHPRI[21].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI22       DMA_B.DCHPRI[22].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI23       DMA_B.DCHPRI[23].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI24       DMA_B.DCHPRI[24].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI25       DMA_B.DCHPRI[25].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI26       DMA_B.DCHPRI[26].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI27       DMA_B.DCHPRI[27].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI28       DMA_B.DCHPRI[28].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI29       DMA_B.DCHPRI[29].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI30       DMA_B.DCHPRI[30].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI31       DMA_B.DCHPRI[31].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI32       DMA_B.DCHPRI[32].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI33       DMA_B.DCHPRI[33].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI34       DMA_B.DCHPRI[34].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI35       DMA_B.DCHPRI[35].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI36       DMA_B.DCHPRI[36].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI37       DMA_B.DCHPRI[37].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI38       DMA_B.DCHPRI[38].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI39       DMA_B.DCHPRI[39].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI40       DMA_B.DCHPRI[40].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI41       DMA_B.DCHPRI[41].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI42       DMA_B.DCHPRI[42].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI43       DMA_B.DCHPRI[43].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI44       DMA_B.DCHPRI[44].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI45       DMA_B.DCHPRI[45].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI46       DMA_B.DCHPRI[46].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI47       DMA_B.DCHPRI[47].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI48       DMA_B.DCHPRI[48].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI49       DMA_B.DCHPRI[49].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI50       DMA_B.DCHPRI[50].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI51       DMA_B.DCHPRI[51].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI52       DMA_B.DCHPRI[52].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI53       DMA_B.DCHPRI[53].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI54       DMA_B.DCHPRI[54].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI55       DMA_B.DCHPRI[55].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI56       DMA_B.DCHPRI[56].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI57       DMA_B.DCHPRI[57].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI58       DMA_B.DCHPRI[58].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI59       DMA_B.DCHPRI[59].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI60       DMA_B.DCHPRI[60].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI61       DMA_B.DCHPRI[61].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI62       DMA_B.DCHPRI[62].R            /* Channel n Priority Register */
#define DMA_B_DCHPRI63       DMA_B.DCHPRI[63].R            /* Channel n Priority Register */
#define DMA_B_TCD0_SADDR     DMA_B.TCD[0].SADDR.R          /* TCD Source Address */
#define DMA_B_TCD0_ATTR      DMA_B.TCD[0].ATTR.R           /* TCD Transfer Attributes */
#define DMA_B_TCD0_SOFF      DMA_B.TCD[0].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_B_TCD0_NBYTES_MLNO DMA_B.TCD[0].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD0_NBYTES_MLOFFNO DMA_B.TCD[0].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD0_NBYTES_MLOFFYES DMA_B.TCD[0].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD0_SLAST     DMA_B.TCD[0].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_B_TCD0_DADDR     DMA_B.TCD[0].DADDR.R          /* TCD Destination Address */
#define DMA_B_TCD0_CITER_ELINKNO DMA_B.TCD[0].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD0_CITER_ELINKYES DMA_B.TCD[0].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD0_DOFF      DMA_B.TCD[0].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_B_TCD0_DLASTSGA  DMA_B.TCD[0].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD0_BITER_ELINKNO DMA_B.TCD[0].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD0_BITER_ELINKYES DMA_B.TCD[0].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD0_CSR       DMA_B.TCD[0].CSR.R            /* TCD Control and Status */
#define DMA_B_TCD1_SADDR     DMA_B.TCD[1].SADDR.R          /* TCD Source Address */
#define DMA_B_TCD1_ATTR      DMA_B.TCD[1].ATTR.R           /* TCD Transfer Attributes */
#define DMA_B_TCD1_SOFF      DMA_B.TCD[1].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_B_TCD1_NBYTES_MLNO DMA_B.TCD[1].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD1_NBYTES_MLOFFNO DMA_B.TCD[1].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD1_NBYTES_MLOFFYES DMA_B.TCD[1].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD1_SLAST     DMA_B.TCD[1].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_B_TCD1_DADDR     DMA_B.TCD[1].DADDR.R          /* TCD Destination Address */
#define DMA_B_TCD1_CITER_ELINKNO DMA_B.TCD[1].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD1_CITER_ELINKYES DMA_B.TCD[1].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD1_DOFF      DMA_B.TCD[1].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_B_TCD1_DLASTSGA  DMA_B.TCD[1].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD1_BITER_ELINKNO DMA_B.TCD[1].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD1_BITER_ELINKYES DMA_B.TCD[1].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD1_CSR       DMA_B.TCD[1].CSR.R            /* TCD Control and Status */
#define DMA_B_TCD2_SADDR     DMA_B.TCD[2].SADDR.R          /* TCD Source Address */
#define DMA_B_TCD2_ATTR      DMA_B.TCD[2].ATTR.R           /* TCD Transfer Attributes */
#define DMA_B_TCD2_SOFF      DMA_B.TCD[2].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_B_TCD2_NBYTES_MLNO DMA_B.TCD[2].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD2_NBYTES_MLOFFNO DMA_B.TCD[2].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD2_NBYTES_MLOFFYES DMA_B.TCD[2].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD2_SLAST     DMA_B.TCD[2].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_B_TCD2_DADDR     DMA_B.TCD[2].DADDR.R          /* TCD Destination Address */
#define DMA_B_TCD2_CITER_ELINKNO DMA_B.TCD[2].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD2_CITER_ELINKYES DMA_B.TCD[2].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD2_DOFF      DMA_B.TCD[2].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_B_TCD2_DLASTSGA  DMA_B.TCD[2].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD2_BITER_ELINKNO DMA_B.TCD[2].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD2_BITER_ELINKYES DMA_B.TCD[2].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD2_CSR       DMA_B.TCD[2].CSR.R            /* TCD Control and Status */
#define DMA_B_TCD3_SADDR     DMA_B.TCD[3].SADDR.R          /* TCD Source Address */
#define DMA_B_TCD3_ATTR      DMA_B.TCD[3].ATTR.R           /* TCD Transfer Attributes */
#define DMA_B_TCD3_SOFF      DMA_B.TCD[3].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_B_TCD3_NBYTES_MLNO DMA_B.TCD[3].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD3_NBYTES_MLOFFNO DMA_B.TCD[3].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD3_NBYTES_MLOFFYES DMA_B.TCD[3].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD3_SLAST     DMA_B.TCD[3].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_B_TCD3_DADDR     DMA_B.TCD[3].DADDR.R          /* TCD Destination Address */
#define DMA_B_TCD3_CITER_ELINKNO DMA_B.TCD[3].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD3_CITER_ELINKYES DMA_B.TCD[3].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD3_DOFF      DMA_B.TCD[3].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_B_TCD3_DLASTSGA  DMA_B.TCD[3].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD3_BITER_ELINKNO DMA_B.TCD[3].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD3_BITER_ELINKYES DMA_B.TCD[3].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD3_CSR       DMA_B.TCD[3].CSR.R            /* TCD Control and Status */
#define DMA_B_TCD4_SADDR     DMA_B.TCD[4].SADDR.R          /* TCD Source Address */
#define DMA_B_TCD4_ATTR      DMA_B.TCD[4].ATTR.R           /* TCD Transfer Attributes */
#define DMA_B_TCD4_SOFF      DMA_B.TCD[4].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_B_TCD4_NBYTES_MLNO DMA_B.TCD[4].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD4_NBYTES_MLOFFNO DMA_B.TCD[4].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD4_NBYTES_MLOFFYES DMA_B.TCD[4].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD4_SLAST     DMA_B.TCD[4].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_B_TCD4_DADDR     DMA_B.TCD[4].DADDR.R          /* TCD Destination Address */
#define DMA_B_TCD4_CITER_ELINKNO DMA_B.TCD[4].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD4_CITER_ELINKYES DMA_B.TCD[4].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD4_DOFF      DMA_B.TCD[4].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_B_TCD4_DLASTSGA  DMA_B.TCD[4].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD4_BITER_ELINKNO DMA_B.TCD[4].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD4_BITER_ELINKYES DMA_B.TCD[4].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD4_CSR       DMA_B.TCD[4].CSR.R            /* TCD Control and Status */
#define DMA_B_TCD5_SADDR     DMA_B.TCD[5].SADDR.R          /* TCD Source Address */
#define DMA_B_TCD5_ATTR      DMA_B.TCD[5].ATTR.R           /* TCD Transfer Attributes */
#define DMA_B_TCD5_SOFF      DMA_B.TCD[5].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_B_TCD5_NBYTES_MLNO DMA_B.TCD[5].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD5_NBYTES_MLOFFNO DMA_B.TCD[5].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD5_NBYTES_MLOFFYES DMA_B.TCD[5].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD5_SLAST     DMA_B.TCD[5].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_B_TCD5_DADDR     DMA_B.TCD[5].DADDR.R          /* TCD Destination Address */
#define DMA_B_TCD5_CITER_ELINKNO DMA_B.TCD[5].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD5_CITER_ELINKYES DMA_B.TCD[5].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD5_DOFF      DMA_B.TCD[5].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_B_TCD5_DLASTSGA  DMA_B.TCD[5].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD5_BITER_ELINKNO DMA_B.TCD[5].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD5_BITER_ELINKYES DMA_B.TCD[5].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD5_CSR       DMA_B.TCD[5].CSR.R            /* TCD Control and Status */
#define DMA_B_TCD6_SADDR     DMA_B.TCD[6].SADDR.R          /* TCD Source Address */
#define DMA_B_TCD6_ATTR      DMA_B.TCD[6].ATTR.R           /* TCD Transfer Attributes */
#define DMA_B_TCD6_SOFF      DMA_B.TCD[6].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_B_TCD6_NBYTES_MLNO DMA_B.TCD[6].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD6_NBYTES_MLOFFNO DMA_B.TCD[6].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD6_NBYTES_MLOFFYES DMA_B.TCD[6].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD6_SLAST     DMA_B.TCD[6].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_B_TCD6_DADDR     DMA_B.TCD[6].DADDR.R          /* TCD Destination Address */
#define DMA_B_TCD6_CITER_ELINKNO DMA_B.TCD[6].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD6_CITER_ELINKYES DMA_B.TCD[6].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD6_DOFF      DMA_B.TCD[6].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_B_TCD6_DLASTSGA  DMA_B.TCD[6].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD6_BITER_ELINKNO DMA_B.TCD[6].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD6_BITER_ELINKYES DMA_B.TCD[6].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD6_CSR       DMA_B.TCD[6].CSR.R            /* TCD Control and Status */
#define DMA_B_TCD7_SADDR     DMA_B.TCD[7].SADDR.R          /* TCD Source Address */
#define DMA_B_TCD7_ATTR      DMA_B.TCD[7].ATTR.R           /* TCD Transfer Attributes */
#define DMA_B_TCD7_SOFF      DMA_B.TCD[7].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_B_TCD7_NBYTES_MLNO DMA_B.TCD[7].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD7_NBYTES_MLOFFNO DMA_B.TCD[7].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD7_NBYTES_MLOFFYES DMA_B.TCD[7].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD7_SLAST     DMA_B.TCD[7].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_B_TCD7_DADDR     DMA_B.TCD[7].DADDR.R          /* TCD Destination Address */
#define DMA_B_TCD7_CITER_ELINKNO DMA_B.TCD[7].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD7_CITER_ELINKYES DMA_B.TCD[7].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD7_DOFF      DMA_B.TCD[7].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_B_TCD7_DLASTSGA  DMA_B.TCD[7].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD7_BITER_ELINKNO DMA_B.TCD[7].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD7_BITER_ELINKYES DMA_B.TCD[7].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD7_CSR       DMA_B.TCD[7].CSR.R            /* TCD Control and Status */
#define DMA_B_TCD8_SADDR     DMA_B.TCD[8].SADDR.R          /* TCD Source Address */
#define DMA_B_TCD8_ATTR      DMA_B.TCD[8].ATTR.R           /* TCD Transfer Attributes */
#define DMA_B_TCD8_SOFF      DMA_B.TCD[8].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_B_TCD8_NBYTES_MLNO DMA_B.TCD[8].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD8_NBYTES_MLOFFNO DMA_B.TCD[8].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD8_NBYTES_MLOFFYES DMA_B.TCD[8].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD8_SLAST     DMA_B.TCD[8].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_B_TCD8_DADDR     DMA_B.TCD[8].DADDR.R          /* TCD Destination Address */
#define DMA_B_TCD8_CITER_ELINKNO DMA_B.TCD[8].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD8_CITER_ELINKYES DMA_B.TCD[8].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD8_DOFF      DMA_B.TCD[8].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_B_TCD8_DLASTSGA  DMA_B.TCD[8].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD8_BITER_ELINKNO DMA_B.TCD[8].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD8_BITER_ELINKYES DMA_B.TCD[8].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD8_CSR       DMA_B.TCD[8].CSR.R            /* TCD Control and Status */
#define DMA_B_TCD9_SADDR     DMA_B.TCD[9].SADDR.R          /* TCD Source Address */
#define DMA_B_TCD9_ATTR      DMA_B.TCD[9].ATTR.R           /* TCD Transfer Attributes */
#define DMA_B_TCD9_SOFF      DMA_B.TCD[9].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_B_TCD9_NBYTES_MLNO DMA_B.TCD[9].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD9_NBYTES_MLOFFNO DMA_B.TCD[9].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD9_NBYTES_MLOFFYES DMA_B.TCD[9].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD9_SLAST     DMA_B.TCD[9].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_B_TCD9_DADDR     DMA_B.TCD[9].DADDR.R          /* TCD Destination Address */
#define DMA_B_TCD9_CITER_ELINKNO DMA_B.TCD[9].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD9_CITER_ELINKYES DMA_B.TCD[9].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD9_DOFF      DMA_B.TCD[9].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_B_TCD9_DLASTSGA  DMA_B.TCD[9].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD9_BITER_ELINKNO DMA_B.TCD[9].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD9_BITER_ELINKYES DMA_B.TCD[9].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD9_CSR       DMA_B.TCD[9].CSR.R            /* TCD Control and Status */
#define DMA_B_TCD10_SADDR    DMA_B.TCD[10].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD10_ATTR     DMA_B.TCD[10].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD10_SOFF     DMA_B.TCD[10].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD10_NBYTES_MLNO DMA_B.TCD[10].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD10_NBYTES_MLOFFNO DMA_B.TCD[10].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD10_NBYTES_MLOFFYES DMA_B.TCD[10].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD10_SLAST    DMA_B.TCD[10].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD10_DADDR    DMA_B.TCD[10].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD10_CITER_ELINKNO DMA_B.TCD[10].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD10_CITER_ELINKYES DMA_B.TCD[10].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD10_DOFF     DMA_B.TCD[10].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD10_DLASTSGA DMA_B.TCD[10].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD10_BITER_ELINKNO DMA_B.TCD[10].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD10_BITER_ELINKYES DMA_B.TCD[10].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD10_CSR      DMA_B.TCD[10].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD11_SADDR    DMA_B.TCD[11].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD11_ATTR     DMA_B.TCD[11].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD11_SOFF     DMA_B.TCD[11].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD11_NBYTES_MLNO DMA_B.TCD[11].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD11_NBYTES_MLOFFNO DMA_B.TCD[11].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD11_NBYTES_MLOFFYES DMA_B.TCD[11].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD11_SLAST    DMA_B.TCD[11].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD11_DADDR    DMA_B.TCD[11].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD11_CITER_ELINKNO DMA_B.TCD[11].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD11_CITER_ELINKYES DMA_B.TCD[11].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD11_DOFF     DMA_B.TCD[11].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD11_DLASTSGA DMA_B.TCD[11].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD11_BITER_ELINKNO DMA_B.TCD[11].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD11_BITER_ELINKYES DMA_B.TCD[11].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD11_CSR      DMA_B.TCD[11].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD12_SADDR    DMA_B.TCD[12].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD12_ATTR     DMA_B.TCD[12].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD12_SOFF     DMA_B.TCD[12].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD12_NBYTES_MLNO DMA_B.TCD[12].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD12_NBYTES_MLOFFNO DMA_B.TCD[12].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD12_NBYTES_MLOFFYES DMA_B.TCD[12].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD12_SLAST    DMA_B.TCD[12].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD12_DADDR    DMA_B.TCD[12].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD12_CITER_ELINKNO DMA_B.TCD[12].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD12_CITER_ELINKYES DMA_B.TCD[12].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD12_DOFF     DMA_B.TCD[12].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD12_DLASTSGA DMA_B.TCD[12].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD12_BITER_ELINKNO DMA_B.TCD[12].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD12_BITER_ELINKYES DMA_B.TCD[12].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD12_CSR      DMA_B.TCD[12].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD13_SADDR    DMA_B.TCD[13].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD13_ATTR     DMA_B.TCD[13].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD13_SOFF     DMA_B.TCD[13].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD13_NBYTES_MLNO DMA_B.TCD[13].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD13_NBYTES_MLOFFNO DMA_B.TCD[13].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD13_NBYTES_MLOFFYES DMA_B.TCD[13].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD13_SLAST    DMA_B.TCD[13].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD13_DADDR    DMA_B.TCD[13].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD13_CITER_ELINKNO DMA_B.TCD[13].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD13_CITER_ELINKYES DMA_B.TCD[13].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD13_DOFF     DMA_B.TCD[13].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD13_DLASTSGA DMA_B.TCD[13].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD13_BITER_ELINKNO DMA_B.TCD[13].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD13_BITER_ELINKYES DMA_B.TCD[13].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD13_CSR      DMA_B.TCD[13].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD14_SADDR    DMA_B.TCD[14].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD14_ATTR     DMA_B.TCD[14].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD14_SOFF     DMA_B.TCD[14].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD14_NBYTES_MLNO DMA_B.TCD[14].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD14_NBYTES_MLOFFNO DMA_B.TCD[14].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD14_NBYTES_MLOFFYES DMA_B.TCD[14].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD14_SLAST    DMA_B.TCD[14].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD14_DADDR    DMA_B.TCD[14].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD14_CITER_ELINKNO DMA_B.TCD[14].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD14_CITER_ELINKYES DMA_B.TCD[14].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD14_DOFF     DMA_B.TCD[14].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD14_DLASTSGA DMA_B.TCD[14].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD14_BITER_ELINKNO DMA_B.TCD[14].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD14_BITER_ELINKYES DMA_B.TCD[14].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD14_CSR      DMA_B.TCD[14].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD15_SADDR    DMA_B.TCD[15].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD15_ATTR     DMA_B.TCD[15].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD15_SOFF     DMA_B.TCD[15].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD15_NBYTES_MLNO DMA_B.TCD[15].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD15_NBYTES_MLOFFNO DMA_B.TCD[15].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD15_NBYTES_MLOFFYES DMA_B.TCD[15].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD15_SLAST    DMA_B.TCD[15].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD15_DADDR    DMA_B.TCD[15].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD15_CITER_ELINKNO DMA_B.TCD[15].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD15_CITER_ELINKYES DMA_B.TCD[15].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD15_DOFF     DMA_B.TCD[15].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD15_DLASTSGA DMA_B.TCD[15].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD15_BITER_ELINKNO DMA_B.TCD[15].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD15_BITER_ELINKYES DMA_B.TCD[15].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD15_CSR      DMA_B.TCD[15].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD16_SADDR    DMA_B.TCD[16].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD16_ATTR     DMA_B.TCD[16].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD16_SOFF     DMA_B.TCD[16].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD16_NBYTES_MLNO DMA_B.TCD[16].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD16_NBYTES_MLOFFNO DMA_B.TCD[16].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD16_NBYTES_MLOFFYES DMA_B.TCD[16].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD16_SLAST    DMA_B.TCD[16].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD16_DADDR    DMA_B.TCD[16].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD16_CITER_ELINKNO DMA_B.TCD[16].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD16_CITER_ELINKYES DMA_B.TCD[16].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD16_DOFF     DMA_B.TCD[16].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD16_DLASTSGA DMA_B.TCD[16].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD16_BITER_ELINKNO DMA_B.TCD[16].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD16_BITER_ELINKYES DMA_B.TCD[16].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD16_CSR      DMA_B.TCD[16].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD17_SADDR    DMA_B.TCD[17].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD17_ATTR     DMA_B.TCD[17].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD17_SOFF     DMA_B.TCD[17].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD17_NBYTES_MLNO DMA_B.TCD[17].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD17_NBYTES_MLOFFNO DMA_B.TCD[17].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD17_NBYTES_MLOFFYES DMA_B.TCD[17].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD17_SLAST    DMA_B.TCD[17].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD17_DADDR    DMA_B.TCD[17].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD17_CITER_ELINKNO DMA_B.TCD[17].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD17_CITER_ELINKYES DMA_B.TCD[17].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD17_DOFF     DMA_B.TCD[17].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD17_DLASTSGA DMA_B.TCD[17].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD17_BITER_ELINKNO DMA_B.TCD[17].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD17_BITER_ELINKYES DMA_B.TCD[17].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD17_CSR      DMA_B.TCD[17].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD18_SADDR    DMA_B.TCD[18].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD18_ATTR     DMA_B.TCD[18].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD18_SOFF     DMA_B.TCD[18].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD18_NBYTES_MLNO DMA_B.TCD[18].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD18_NBYTES_MLOFFNO DMA_B.TCD[18].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD18_NBYTES_MLOFFYES DMA_B.TCD[18].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD18_SLAST    DMA_B.TCD[18].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD18_DADDR    DMA_B.TCD[18].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD18_CITER_ELINKNO DMA_B.TCD[18].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD18_CITER_ELINKYES DMA_B.TCD[18].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD18_DOFF     DMA_B.TCD[18].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD18_DLASTSGA DMA_B.TCD[18].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD18_BITER_ELINKNO DMA_B.TCD[18].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD18_BITER_ELINKYES DMA_B.TCD[18].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD18_CSR      DMA_B.TCD[18].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD19_SADDR    DMA_B.TCD[19].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD19_ATTR     DMA_B.TCD[19].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD19_SOFF     DMA_B.TCD[19].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD19_NBYTES_MLNO DMA_B.TCD[19].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD19_NBYTES_MLOFFNO DMA_B.TCD[19].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD19_NBYTES_MLOFFYES DMA_B.TCD[19].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD19_SLAST    DMA_B.TCD[19].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD19_DADDR    DMA_B.TCD[19].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD19_CITER_ELINKNO DMA_B.TCD[19].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD19_CITER_ELINKYES DMA_B.TCD[19].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD19_DOFF     DMA_B.TCD[19].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD19_DLASTSGA DMA_B.TCD[19].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD19_BITER_ELINKNO DMA_B.TCD[19].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD19_BITER_ELINKYES DMA_B.TCD[19].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD19_CSR      DMA_B.TCD[19].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD20_SADDR    DMA_B.TCD[20].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD20_ATTR     DMA_B.TCD[20].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD20_SOFF     DMA_B.TCD[20].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD20_NBYTES_MLNO DMA_B.TCD[20].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD20_NBYTES_MLOFFNO DMA_B.TCD[20].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD20_NBYTES_MLOFFYES DMA_B.TCD[20].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD20_SLAST    DMA_B.TCD[20].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD20_DADDR    DMA_B.TCD[20].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD20_CITER_ELINKNO DMA_B.TCD[20].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD20_CITER_ELINKYES DMA_B.TCD[20].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD20_DOFF     DMA_B.TCD[20].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD20_DLASTSGA DMA_B.TCD[20].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD20_BITER_ELINKNO DMA_B.TCD[20].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD20_BITER_ELINKYES DMA_B.TCD[20].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD20_CSR      DMA_B.TCD[20].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD21_SADDR    DMA_B.TCD[21].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD21_ATTR     DMA_B.TCD[21].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD21_SOFF     DMA_B.TCD[21].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD21_NBYTES_MLNO DMA_B.TCD[21].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD21_NBYTES_MLOFFNO DMA_B.TCD[21].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD21_NBYTES_MLOFFYES DMA_B.TCD[21].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD21_SLAST    DMA_B.TCD[21].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD21_DADDR    DMA_B.TCD[21].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD21_CITER_ELINKNO DMA_B.TCD[21].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD21_CITER_ELINKYES DMA_B.TCD[21].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD21_DOFF     DMA_B.TCD[21].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD21_DLASTSGA DMA_B.TCD[21].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD21_BITER_ELINKNO DMA_B.TCD[21].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD21_BITER_ELINKYES DMA_B.TCD[21].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD21_CSR      DMA_B.TCD[21].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD22_SADDR    DMA_B.TCD[22].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD22_ATTR     DMA_B.TCD[22].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD22_SOFF     DMA_B.TCD[22].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD22_NBYTES_MLNO DMA_B.TCD[22].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD22_NBYTES_MLOFFNO DMA_B.TCD[22].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD22_NBYTES_MLOFFYES DMA_B.TCD[22].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD22_SLAST    DMA_B.TCD[22].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD22_DADDR    DMA_B.TCD[22].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD22_CITER_ELINKNO DMA_B.TCD[22].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD22_CITER_ELINKYES DMA_B.TCD[22].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD22_DOFF     DMA_B.TCD[22].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD22_DLASTSGA DMA_B.TCD[22].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD22_BITER_ELINKNO DMA_B.TCD[22].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD22_BITER_ELINKYES DMA_B.TCD[22].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD22_CSR      DMA_B.TCD[22].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD23_SADDR    DMA_B.TCD[23].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD23_ATTR     DMA_B.TCD[23].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD23_SOFF     DMA_B.TCD[23].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD23_NBYTES_MLNO DMA_B.TCD[23].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD23_NBYTES_MLOFFNO DMA_B.TCD[23].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD23_NBYTES_MLOFFYES DMA_B.TCD[23].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD23_SLAST    DMA_B.TCD[23].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD23_DADDR    DMA_B.TCD[23].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD23_CITER_ELINKNO DMA_B.TCD[23].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD23_CITER_ELINKYES DMA_B.TCD[23].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD23_DOFF     DMA_B.TCD[23].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD23_DLASTSGA DMA_B.TCD[23].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD23_BITER_ELINKNO DMA_B.TCD[23].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD23_BITER_ELINKYES DMA_B.TCD[23].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD23_CSR      DMA_B.TCD[23].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD24_SADDR    DMA_B.TCD[24].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD24_ATTR     DMA_B.TCD[24].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD24_SOFF     DMA_B.TCD[24].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD24_NBYTES_MLNO DMA_B.TCD[24].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD24_NBYTES_MLOFFNO DMA_B.TCD[24].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD24_NBYTES_MLOFFYES DMA_B.TCD[24].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD24_SLAST    DMA_B.TCD[24].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD24_DADDR    DMA_B.TCD[24].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD24_CITER_ELINKNO DMA_B.TCD[24].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD24_CITER_ELINKYES DMA_B.TCD[24].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD24_DOFF     DMA_B.TCD[24].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD24_DLASTSGA DMA_B.TCD[24].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD24_BITER_ELINKNO DMA_B.TCD[24].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD24_BITER_ELINKYES DMA_B.TCD[24].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD24_CSR      DMA_B.TCD[24].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD25_SADDR    DMA_B.TCD[25].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD25_ATTR     DMA_B.TCD[25].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD25_SOFF     DMA_B.TCD[25].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD25_NBYTES_MLNO DMA_B.TCD[25].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD25_NBYTES_MLOFFNO DMA_B.TCD[25].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD25_NBYTES_MLOFFYES DMA_B.TCD[25].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD25_SLAST    DMA_B.TCD[25].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD25_DADDR    DMA_B.TCD[25].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD25_CITER_ELINKNO DMA_B.TCD[25].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD25_CITER_ELINKYES DMA_B.TCD[25].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD25_DOFF     DMA_B.TCD[25].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD25_DLASTSGA DMA_B.TCD[25].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD25_BITER_ELINKNO DMA_B.TCD[25].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD25_BITER_ELINKYES DMA_B.TCD[25].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD25_CSR      DMA_B.TCD[25].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD26_SADDR    DMA_B.TCD[26].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD26_ATTR     DMA_B.TCD[26].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD26_SOFF     DMA_B.TCD[26].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD26_NBYTES_MLNO DMA_B.TCD[26].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD26_NBYTES_MLOFFNO DMA_B.TCD[26].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD26_NBYTES_MLOFFYES DMA_B.TCD[26].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD26_SLAST    DMA_B.TCD[26].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD26_DADDR    DMA_B.TCD[26].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD26_CITER_ELINKNO DMA_B.TCD[26].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD26_CITER_ELINKYES DMA_B.TCD[26].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD26_DOFF     DMA_B.TCD[26].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD26_DLASTSGA DMA_B.TCD[26].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD26_BITER_ELINKNO DMA_B.TCD[26].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD26_BITER_ELINKYES DMA_B.TCD[26].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD26_CSR      DMA_B.TCD[26].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD27_SADDR    DMA_B.TCD[27].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD27_ATTR     DMA_B.TCD[27].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD27_SOFF     DMA_B.TCD[27].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD27_NBYTES_MLNO DMA_B.TCD[27].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD27_NBYTES_MLOFFNO DMA_B.TCD[27].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD27_NBYTES_MLOFFYES DMA_B.TCD[27].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD27_SLAST    DMA_B.TCD[27].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD27_DADDR    DMA_B.TCD[27].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD27_CITER_ELINKNO DMA_B.TCD[27].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD27_CITER_ELINKYES DMA_B.TCD[27].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD27_DOFF     DMA_B.TCD[27].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD27_DLASTSGA DMA_B.TCD[27].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD27_BITER_ELINKNO DMA_B.TCD[27].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD27_BITER_ELINKYES DMA_B.TCD[27].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD27_CSR      DMA_B.TCD[27].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD28_SADDR    DMA_B.TCD[28].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD28_ATTR     DMA_B.TCD[28].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD28_SOFF     DMA_B.TCD[28].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD28_NBYTES_MLNO DMA_B.TCD[28].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD28_NBYTES_MLOFFNO DMA_B.TCD[28].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD28_NBYTES_MLOFFYES DMA_B.TCD[28].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD28_SLAST    DMA_B.TCD[28].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD28_DADDR    DMA_B.TCD[28].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD28_CITER_ELINKNO DMA_B.TCD[28].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD28_CITER_ELINKYES DMA_B.TCD[28].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD28_DOFF     DMA_B.TCD[28].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD28_DLASTSGA DMA_B.TCD[28].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD28_BITER_ELINKNO DMA_B.TCD[28].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD28_BITER_ELINKYES DMA_B.TCD[28].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD28_CSR      DMA_B.TCD[28].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD29_SADDR    DMA_B.TCD[29].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD29_ATTR     DMA_B.TCD[29].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD29_SOFF     DMA_B.TCD[29].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD29_NBYTES_MLNO DMA_B.TCD[29].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD29_NBYTES_MLOFFNO DMA_B.TCD[29].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD29_NBYTES_MLOFFYES DMA_B.TCD[29].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD29_SLAST    DMA_B.TCD[29].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD29_DADDR    DMA_B.TCD[29].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD29_CITER_ELINKNO DMA_B.TCD[29].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD29_CITER_ELINKYES DMA_B.TCD[29].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD29_DOFF     DMA_B.TCD[29].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD29_DLASTSGA DMA_B.TCD[29].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD29_BITER_ELINKNO DMA_B.TCD[29].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD29_BITER_ELINKYES DMA_B.TCD[29].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD29_CSR      DMA_B.TCD[29].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD30_SADDR    DMA_B.TCD[30].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD30_ATTR     DMA_B.TCD[30].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD30_SOFF     DMA_B.TCD[30].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD30_NBYTES_MLNO DMA_B.TCD[30].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD30_NBYTES_MLOFFNO DMA_B.TCD[30].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD30_NBYTES_MLOFFYES DMA_B.TCD[30].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD30_SLAST    DMA_B.TCD[30].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD30_DADDR    DMA_B.TCD[30].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD30_CITER_ELINKNO DMA_B.TCD[30].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD30_CITER_ELINKYES DMA_B.TCD[30].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD30_DOFF     DMA_B.TCD[30].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD30_DLASTSGA DMA_B.TCD[30].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD30_BITER_ELINKNO DMA_B.TCD[30].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD30_BITER_ELINKYES DMA_B.TCD[30].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD30_CSR      DMA_B.TCD[30].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD31_SADDR    DMA_B.TCD[31].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD31_ATTR     DMA_B.TCD[31].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD31_SOFF     DMA_B.TCD[31].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD31_NBYTES_MLNO DMA_B.TCD[31].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD31_NBYTES_MLOFFNO DMA_B.TCD[31].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD31_NBYTES_MLOFFYES DMA_B.TCD[31].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD31_SLAST    DMA_B.TCD[31].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD31_DADDR    DMA_B.TCD[31].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD31_CITER_ELINKNO DMA_B.TCD[31].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD31_CITER_ELINKYES DMA_B.TCD[31].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD31_DOFF     DMA_B.TCD[31].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD31_DLASTSGA DMA_B.TCD[31].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD31_BITER_ELINKNO DMA_B.TCD[31].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD31_BITER_ELINKYES DMA_B.TCD[31].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD31_CSR      DMA_B.TCD[31].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD32_SADDR    DMA_B.TCD[32].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD32_ATTR     DMA_B.TCD[32].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD32_SOFF     DMA_B.TCD[32].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD32_NBYTES_MLNO DMA_B.TCD[32].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD32_NBYTES_MLOFFNO DMA_B.TCD[32].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD32_NBYTES_MLOFFYES DMA_B.TCD[32].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD32_SLAST    DMA_B.TCD[32].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD32_DADDR    DMA_B.TCD[32].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD32_CITER_ELINKNO DMA_B.TCD[32].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD32_CITER_ELINKYES DMA_B.TCD[32].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD32_DOFF     DMA_B.TCD[32].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD32_DLASTSGA DMA_B.TCD[32].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD32_BITER_ELINKNO DMA_B.TCD[32].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD32_BITER_ELINKYES DMA_B.TCD[32].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD32_CSR      DMA_B.TCD[32].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD33_SADDR    DMA_B.TCD[33].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD33_ATTR     DMA_B.TCD[33].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD33_SOFF     DMA_B.TCD[33].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD33_NBYTES_MLNO DMA_B.TCD[33].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD33_NBYTES_MLOFFNO DMA_B.TCD[33].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD33_NBYTES_MLOFFYES DMA_B.TCD[33].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD33_SLAST    DMA_B.TCD[33].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD33_DADDR    DMA_B.TCD[33].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD33_CITER_ELINKNO DMA_B.TCD[33].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD33_CITER_ELINKYES DMA_B.TCD[33].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD33_DOFF     DMA_B.TCD[33].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD33_DLASTSGA DMA_B.TCD[33].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD33_BITER_ELINKNO DMA_B.TCD[33].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD33_BITER_ELINKYES DMA_B.TCD[33].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD33_CSR      DMA_B.TCD[33].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD34_SADDR    DMA_B.TCD[34].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD34_ATTR     DMA_B.TCD[34].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD34_SOFF     DMA_B.TCD[34].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD34_NBYTES_MLNO DMA_B.TCD[34].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD34_NBYTES_MLOFFNO DMA_B.TCD[34].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD34_NBYTES_MLOFFYES DMA_B.TCD[34].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD34_SLAST    DMA_B.TCD[34].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD34_DADDR    DMA_B.TCD[34].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD34_CITER_ELINKNO DMA_B.TCD[34].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD34_CITER_ELINKYES DMA_B.TCD[34].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD34_DOFF     DMA_B.TCD[34].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD34_DLASTSGA DMA_B.TCD[34].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD34_BITER_ELINKNO DMA_B.TCD[34].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD34_BITER_ELINKYES DMA_B.TCD[34].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD34_CSR      DMA_B.TCD[34].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD35_SADDR    DMA_B.TCD[35].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD35_ATTR     DMA_B.TCD[35].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD35_SOFF     DMA_B.TCD[35].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD35_NBYTES_MLNO DMA_B.TCD[35].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD35_NBYTES_MLOFFNO DMA_B.TCD[35].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD35_NBYTES_MLOFFYES DMA_B.TCD[35].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD35_SLAST    DMA_B.TCD[35].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD35_DADDR    DMA_B.TCD[35].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD35_CITER_ELINKNO DMA_B.TCD[35].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD35_CITER_ELINKYES DMA_B.TCD[35].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD35_DOFF     DMA_B.TCD[35].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD35_DLASTSGA DMA_B.TCD[35].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD35_BITER_ELINKNO DMA_B.TCD[35].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD35_BITER_ELINKYES DMA_B.TCD[35].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD35_CSR      DMA_B.TCD[35].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD36_SADDR    DMA_B.TCD[36].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD36_ATTR     DMA_B.TCD[36].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD36_SOFF     DMA_B.TCD[36].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD36_NBYTES_MLNO DMA_B.TCD[36].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD36_NBYTES_MLOFFNO DMA_B.TCD[36].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD36_NBYTES_MLOFFYES DMA_B.TCD[36].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD36_SLAST    DMA_B.TCD[36].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD36_DADDR    DMA_B.TCD[36].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD36_CITER_ELINKNO DMA_B.TCD[36].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD36_CITER_ELINKYES DMA_B.TCD[36].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD36_DOFF     DMA_B.TCD[36].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD36_DLASTSGA DMA_B.TCD[36].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD36_BITER_ELINKNO DMA_B.TCD[36].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD36_BITER_ELINKYES DMA_B.TCD[36].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD36_CSR      DMA_B.TCD[36].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD37_SADDR    DMA_B.TCD[37].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD37_ATTR     DMA_B.TCD[37].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD37_SOFF     DMA_B.TCD[37].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD37_NBYTES_MLNO DMA_B.TCD[37].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD37_NBYTES_MLOFFNO DMA_B.TCD[37].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD37_NBYTES_MLOFFYES DMA_B.TCD[37].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD37_SLAST    DMA_B.TCD[37].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD37_DADDR    DMA_B.TCD[37].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD37_CITER_ELINKNO DMA_B.TCD[37].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD37_CITER_ELINKYES DMA_B.TCD[37].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD37_DOFF     DMA_B.TCD[37].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD37_DLASTSGA DMA_B.TCD[37].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD37_BITER_ELINKNO DMA_B.TCD[37].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD37_BITER_ELINKYES DMA_B.TCD[37].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD37_CSR      DMA_B.TCD[37].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD38_SADDR    DMA_B.TCD[38].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD38_ATTR     DMA_B.TCD[38].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD38_SOFF     DMA_B.TCD[38].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD38_NBYTES_MLNO DMA_B.TCD[38].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD38_NBYTES_MLOFFNO DMA_B.TCD[38].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD38_NBYTES_MLOFFYES DMA_B.TCD[38].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD38_SLAST    DMA_B.TCD[38].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD38_DADDR    DMA_B.TCD[38].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD38_CITER_ELINKNO DMA_B.TCD[38].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD38_CITER_ELINKYES DMA_B.TCD[38].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD38_DOFF     DMA_B.TCD[38].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD38_DLASTSGA DMA_B.TCD[38].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD38_BITER_ELINKNO DMA_B.TCD[38].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD38_BITER_ELINKYES DMA_B.TCD[38].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD38_CSR      DMA_B.TCD[38].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD39_SADDR    DMA_B.TCD[39].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD39_ATTR     DMA_B.TCD[39].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD39_SOFF     DMA_B.TCD[39].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD39_NBYTES_MLNO DMA_B.TCD[39].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD39_NBYTES_MLOFFNO DMA_B.TCD[39].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD39_NBYTES_MLOFFYES DMA_B.TCD[39].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD39_SLAST    DMA_B.TCD[39].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD39_DADDR    DMA_B.TCD[39].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD39_CITER_ELINKNO DMA_B.TCD[39].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD39_CITER_ELINKYES DMA_B.TCD[39].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD39_DOFF     DMA_B.TCD[39].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD39_DLASTSGA DMA_B.TCD[39].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD39_BITER_ELINKNO DMA_B.TCD[39].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD39_BITER_ELINKYES DMA_B.TCD[39].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD39_CSR      DMA_B.TCD[39].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD40_SADDR    DMA_B.TCD[40].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD40_ATTR     DMA_B.TCD[40].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD40_SOFF     DMA_B.TCD[40].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD40_NBYTES_MLNO DMA_B.TCD[40].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD40_NBYTES_MLOFFNO DMA_B.TCD[40].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD40_NBYTES_MLOFFYES DMA_B.TCD[40].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD40_SLAST    DMA_B.TCD[40].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD40_DADDR    DMA_B.TCD[40].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD40_CITER_ELINKNO DMA_B.TCD[40].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD40_CITER_ELINKYES DMA_B.TCD[40].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD40_DOFF     DMA_B.TCD[40].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD40_DLASTSGA DMA_B.TCD[40].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD40_BITER_ELINKNO DMA_B.TCD[40].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD40_BITER_ELINKYES DMA_B.TCD[40].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD40_CSR      DMA_B.TCD[40].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD41_SADDR    DMA_B.TCD[41].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD41_ATTR     DMA_B.TCD[41].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD41_SOFF     DMA_B.TCD[41].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD41_NBYTES_MLNO DMA_B.TCD[41].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD41_NBYTES_MLOFFNO DMA_B.TCD[41].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD41_NBYTES_MLOFFYES DMA_B.TCD[41].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD41_SLAST    DMA_B.TCD[41].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD41_DADDR    DMA_B.TCD[41].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD41_CITER_ELINKNO DMA_B.TCD[41].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD41_CITER_ELINKYES DMA_B.TCD[41].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD41_DOFF     DMA_B.TCD[41].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD41_DLASTSGA DMA_B.TCD[41].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD41_BITER_ELINKNO DMA_B.TCD[41].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD41_BITER_ELINKYES DMA_B.TCD[41].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD41_CSR      DMA_B.TCD[41].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD42_SADDR    DMA_B.TCD[42].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD42_ATTR     DMA_B.TCD[42].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD42_SOFF     DMA_B.TCD[42].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD42_NBYTES_MLNO DMA_B.TCD[42].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD42_NBYTES_MLOFFNO DMA_B.TCD[42].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD42_NBYTES_MLOFFYES DMA_B.TCD[42].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD42_SLAST    DMA_B.TCD[42].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD42_DADDR    DMA_B.TCD[42].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD42_CITER_ELINKNO DMA_B.TCD[42].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD42_CITER_ELINKYES DMA_B.TCD[42].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD42_DOFF     DMA_B.TCD[42].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD42_DLASTSGA DMA_B.TCD[42].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD42_BITER_ELINKNO DMA_B.TCD[42].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD42_BITER_ELINKYES DMA_B.TCD[42].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD42_CSR      DMA_B.TCD[42].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD43_SADDR    DMA_B.TCD[43].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD43_ATTR     DMA_B.TCD[43].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD43_SOFF     DMA_B.TCD[43].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD43_NBYTES_MLNO DMA_B.TCD[43].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD43_NBYTES_MLOFFNO DMA_B.TCD[43].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD43_NBYTES_MLOFFYES DMA_B.TCD[43].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD43_SLAST    DMA_B.TCD[43].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD43_DADDR    DMA_B.TCD[43].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD43_CITER_ELINKNO DMA_B.TCD[43].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD43_CITER_ELINKYES DMA_B.TCD[43].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD43_DOFF     DMA_B.TCD[43].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD43_DLASTSGA DMA_B.TCD[43].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD43_BITER_ELINKNO DMA_B.TCD[43].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD43_BITER_ELINKYES DMA_B.TCD[43].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD43_CSR      DMA_B.TCD[43].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD44_SADDR    DMA_B.TCD[44].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD44_ATTR     DMA_B.TCD[44].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD44_SOFF     DMA_B.TCD[44].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD44_NBYTES_MLNO DMA_B.TCD[44].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD44_NBYTES_MLOFFNO DMA_B.TCD[44].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD44_NBYTES_MLOFFYES DMA_B.TCD[44].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD44_SLAST    DMA_B.TCD[44].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD44_DADDR    DMA_B.TCD[44].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD44_CITER_ELINKNO DMA_B.TCD[44].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD44_CITER_ELINKYES DMA_B.TCD[44].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD44_DOFF     DMA_B.TCD[44].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD44_DLASTSGA DMA_B.TCD[44].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD44_BITER_ELINKNO DMA_B.TCD[44].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD44_BITER_ELINKYES DMA_B.TCD[44].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD44_CSR      DMA_B.TCD[44].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD45_SADDR    DMA_B.TCD[45].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD45_ATTR     DMA_B.TCD[45].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD45_SOFF     DMA_B.TCD[45].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD45_NBYTES_MLNO DMA_B.TCD[45].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD45_NBYTES_MLOFFNO DMA_B.TCD[45].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD45_NBYTES_MLOFFYES DMA_B.TCD[45].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD45_SLAST    DMA_B.TCD[45].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD45_DADDR    DMA_B.TCD[45].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD45_CITER_ELINKNO DMA_B.TCD[45].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD45_CITER_ELINKYES DMA_B.TCD[45].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD45_DOFF     DMA_B.TCD[45].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD45_DLASTSGA DMA_B.TCD[45].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD45_BITER_ELINKNO DMA_B.TCD[45].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD45_BITER_ELINKYES DMA_B.TCD[45].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD45_CSR      DMA_B.TCD[45].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD46_SADDR    DMA_B.TCD[46].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD46_ATTR     DMA_B.TCD[46].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD46_SOFF     DMA_B.TCD[46].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD46_NBYTES_MLNO DMA_B.TCD[46].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD46_NBYTES_MLOFFNO DMA_B.TCD[46].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD46_NBYTES_MLOFFYES DMA_B.TCD[46].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD46_SLAST    DMA_B.TCD[46].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD46_DADDR    DMA_B.TCD[46].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD46_CITER_ELINKNO DMA_B.TCD[46].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD46_CITER_ELINKYES DMA_B.TCD[46].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD46_DOFF     DMA_B.TCD[46].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD46_DLASTSGA DMA_B.TCD[46].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD46_BITER_ELINKNO DMA_B.TCD[46].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD46_BITER_ELINKYES DMA_B.TCD[46].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD46_CSR      DMA_B.TCD[46].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD47_SADDR    DMA_B.TCD[47].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD47_ATTR     DMA_B.TCD[47].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD47_SOFF     DMA_B.TCD[47].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD47_NBYTES_MLNO DMA_B.TCD[47].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD47_NBYTES_MLOFFNO DMA_B.TCD[47].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD47_NBYTES_MLOFFYES DMA_B.TCD[47].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD47_SLAST    DMA_B.TCD[47].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD47_DADDR    DMA_B.TCD[47].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD47_CITER_ELINKNO DMA_B.TCD[47].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD47_CITER_ELINKYES DMA_B.TCD[47].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD47_DOFF     DMA_B.TCD[47].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD47_DLASTSGA DMA_B.TCD[47].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD47_BITER_ELINKNO DMA_B.TCD[47].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD47_BITER_ELINKYES DMA_B.TCD[47].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD47_CSR      DMA_B.TCD[47].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD48_SADDR    DMA_B.TCD[48].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD48_ATTR     DMA_B.TCD[48].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD48_SOFF     DMA_B.TCD[48].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD48_NBYTES_MLNO DMA_B.TCD[48].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD48_NBYTES_MLOFFNO DMA_B.TCD[48].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD48_NBYTES_MLOFFYES DMA_B.TCD[48].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD48_SLAST    DMA_B.TCD[48].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD48_DADDR    DMA_B.TCD[48].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD48_CITER_ELINKNO DMA_B.TCD[48].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD48_CITER_ELINKYES DMA_B.TCD[48].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD48_DOFF     DMA_B.TCD[48].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD48_DLASTSGA DMA_B.TCD[48].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD48_BITER_ELINKNO DMA_B.TCD[48].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD48_BITER_ELINKYES DMA_B.TCD[48].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD48_CSR      DMA_B.TCD[48].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD49_SADDR    DMA_B.TCD[49].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD49_ATTR     DMA_B.TCD[49].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD49_SOFF     DMA_B.TCD[49].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD49_NBYTES_MLNO DMA_B.TCD[49].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD49_NBYTES_MLOFFNO DMA_B.TCD[49].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD49_NBYTES_MLOFFYES DMA_B.TCD[49].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD49_SLAST    DMA_B.TCD[49].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD49_DADDR    DMA_B.TCD[49].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD49_CITER_ELINKNO DMA_B.TCD[49].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD49_CITER_ELINKYES DMA_B.TCD[49].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD49_DOFF     DMA_B.TCD[49].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD49_DLASTSGA DMA_B.TCD[49].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD49_BITER_ELINKNO DMA_B.TCD[49].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD49_BITER_ELINKYES DMA_B.TCD[49].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD49_CSR      DMA_B.TCD[49].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD50_SADDR    DMA_B.TCD[50].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD50_ATTR     DMA_B.TCD[50].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD50_SOFF     DMA_B.TCD[50].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD50_NBYTES_MLNO DMA_B.TCD[50].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD50_NBYTES_MLOFFNO DMA_B.TCD[50].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD50_NBYTES_MLOFFYES DMA_B.TCD[50].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD50_SLAST    DMA_B.TCD[50].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD50_DADDR    DMA_B.TCD[50].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD50_CITER_ELINKNO DMA_B.TCD[50].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD50_CITER_ELINKYES DMA_B.TCD[50].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD50_DOFF     DMA_B.TCD[50].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD50_DLASTSGA DMA_B.TCD[50].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD50_BITER_ELINKNO DMA_B.TCD[50].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD50_BITER_ELINKYES DMA_B.TCD[50].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD50_CSR      DMA_B.TCD[50].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD51_SADDR    DMA_B.TCD[51].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD51_ATTR     DMA_B.TCD[51].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD51_SOFF     DMA_B.TCD[51].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD51_NBYTES_MLNO DMA_B.TCD[51].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD51_NBYTES_MLOFFNO DMA_B.TCD[51].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD51_NBYTES_MLOFFYES DMA_B.TCD[51].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD51_SLAST    DMA_B.TCD[51].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD51_DADDR    DMA_B.TCD[51].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD51_CITER_ELINKNO DMA_B.TCD[51].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD51_CITER_ELINKYES DMA_B.TCD[51].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD51_DOFF     DMA_B.TCD[51].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD51_DLASTSGA DMA_B.TCD[51].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD51_BITER_ELINKNO DMA_B.TCD[51].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD51_BITER_ELINKYES DMA_B.TCD[51].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD51_CSR      DMA_B.TCD[51].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD52_SADDR    DMA_B.TCD[52].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD52_ATTR     DMA_B.TCD[52].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD52_SOFF     DMA_B.TCD[52].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD52_NBYTES_MLNO DMA_B.TCD[52].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD52_NBYTES_MLOFFNO DMA_B.TCD[52].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD52_NBYTES_MLOFFYES DMA_B.TCD[52].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD52_SLAST    DMA_B.TCD[52].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD52_DADDR    DMA_B.TCD[52].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD52_CITER_ELINKNO DMA_B.TCD[52].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD52_CITER_ELINKYES DMA_B.TCD[52].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD52_DOFF     DMA_B.TCD[52].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD52_DLASTSGA DMA_B.TCD[52].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD52_BITER_ELINKNO DMA_B.TCD[52].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD52_BITER_ELINKYES DMA_B.TCD[52].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD52_CSR      DMA_B.TCD[52].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD53_SADDR    DMA_B.TCD[53].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD53_ATTR     DMA_B.TCD[53].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD53_SOFF     DMA_B.TCD[53].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD53_NBYTES_MLNO DMA_B.TCD[53].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD53_NBYTES_MLOFFNO DMA_B.TCD[53].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD53_NBYTES_MLOFFYES DMA_B.TCD[53].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD53_SLAST    DMA_B.TCD[53].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD53_DADDR    DMA_B.TCD[53].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD53_CITER_ELINKNO DMA_B.TCD[53].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD53_CITER_ELINKYES DMA_B.TCD[53].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD53_DOFF     DMA_B.TCD[53].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD53_DLASTSGA DMA_B.TCD[53].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD53_BITER_ELINKNO DMA_B.TCD[53].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD53_BITER_ELINKYES DMA_B.TCD[53].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD53_CSR      DMA_B.TCD[53].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD54_SADDR    DMA_B.TCD[54].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD54_ATTR     DMA_B.TCD[54].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD54_SOFF     DMA_B.TCD[54].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD54_NBYTES_MLNO DMA_B.TCD[54].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD54_NBYTES_MLOFFNO DMA_B.TCD[54].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD54_NBYTES_MLOFFYES DMA_B.TCD[54].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD54_SLAST    DMA_B.TCD[54].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD54_DADDR    DMA_B.TCD[54].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD54_CITER_ELINKNO DMA_B.TCD[54].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD54_CITER_ELINKYES DMA_B.TCD[54].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD54_DOFF     DMA_B.TCD[54].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD54_DLASTSGA DMA_B.TCD[54].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD54_BITER_ELINKNO DMA_B.TCD[54].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD54_BITER_ELINKYES DMA_B.TCD[54].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD54_CSR      DMA_B.TCD[54].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD55_SADDR    DMA_B.TCD[55].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD55_ATTR     DMA_B.TCD[55].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD55_SOFF     DMA_B.TCD[55].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD55_NBYTES_MLNO DMA_B.TCD[55].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD55_NBYTES_MLOFFNO DMA_B.TCD[55].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD55_NBYTES_MLOFFYES DMA_B.TCD[55].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD55_SLAST    DMA_B.TCD[55].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD55_DADDR    DMA_B.TCD[55].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD55_CITER_ELINKNO DMA_B.TCD[55].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD55_CITER_ELINKYES DMA_B.TCD[55].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD55_DOFF     DMA_B.TCD[55].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD55_DLASTSGA DMA_B.TCD[55].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD55_BITER_ELINKNO DMA_B.TCD[55].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD55_BITER_ELINKYES DMA_B.TCD[55].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD55_CSR      DMA_B.TCD[55].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD56_SADDR    DMA_B.TCD[56].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD56_ATTR     DMA_B.TCD[56].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD56_SOFF     DMA_B.TCD[56].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD56_NBYTES_MLNO DMA_B.TCD[56].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD56_NBYTES_MLOFFNO DMA_B.TCD[56].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD56_NBYTES_MLOFFYES DMA_B.TCD[56].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD56_SLAST    DMA_B.TCD[56].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD56_DADDR    DMA_B.TCD[56].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD56_CITER_ELINKNO DMA_B.TCD[56].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD56_CITER_ELINKYES DMA_B.TCD[56].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD56_DOFF     DMA_B.TCD[56].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD56_DLASTSGA DMA_B.TCD[56].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD56_BITER_ELINKNO DMA_B.TCD[56].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD56_BITER_ELINKYES DMA_B.TCD[56].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD56_CSR      DMA_B.TCD[56].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD57_SADDR    DMA_B.TCD[57].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD57_ATTR     DMA_B.TCD[57].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD57_SOFF     DMA_B.TCD[57].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD57_NBYTES_MLNO DMA_B.TCD[57].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD57_NBYTES_MLOFFNO DMA_B.TCD[57].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD57_NBYTES_MLOFFYES DMA_B.TCD[57].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD57_SLAST    DMA_B.TCD[57].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD57_DADDR    DMA_B.TCD[57].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD57_CITER_ELINKNO DMA_B.TCD[57].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD57_CITER_ELINKYES DMA_B.TCD[57].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD57_DOFF     DMA_B.TCD[57].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD57_DLASTSGA DMA_B.TCD[57].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD57_BITER_ELINKNO DMA_B.TCD[57].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD57_BITER_ELINKYES DMA_B.TCD[57].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD57_CSR      DMA_B.TCD[57].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD58_SADDR    DMA_B.TCD[58].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD58_ATTR     DMA_B.TCD[58].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD58_SOFF     DMA_B.TCD[58].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD58_NBYTES_MLNO DMA_B.TCD[58].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD58_NBYTES_MLOFFNO DMA_B.TCD[58].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD58_NBYTES_MLOFFYES DMA_B.TCD[58].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD58_SLAST    DMA_B.TCD[58].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD58_DADDR    DMA_B.TCD[58].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD58_CITER_ELINKNO DMA_B.TCD[58].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD58_CITER_ELINKYES DMA_B.TCD[58].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD58_DOFF     DMA_B.TCD[58].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD58_DLASTSGA DMA_B.TCD[58].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD58_BITER_ELINKNO DMA_B.TCD[58].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD58_BITER_ELINKYES DMA_B.TCD[58].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD58_CSR      DMA_B.TCD[58].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD59_SADDR    DMA_B.TCD[59].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD59_ATTR     DMA_B.TCD[59].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD59_SOFF     DMA_B.TCD[59].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD59_NBYTES_MLNO DMA_B.TCD[59].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD59_NBYTES_MLOFFNO DMA_B.TCD[59].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD59_NBYTES_MLOFFYES DMA_B.TCD[59].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD59_SLAST    DMA_B.TCD[59].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD59_DADDR    DMA_B.TCD[59].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD59_CITER_ELINKNO DMA_B.TCD[59].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD59_CITER_ELINKYES DMA_B.TCD[59].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD59_DOFF     DMA_B.TCD[59].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD59_DLASTSGA DMA_B.TCD[59].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD59_BITER_ELINKNO DMA_B.TCD[59].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD59_BITER_ELINKYES DMA_B.TCD[59].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD59_CSR      DMA_B.TCD[59].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD60_SADDR    DMA_B.TCD[60].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD60_ATTR     DMA_B.TCD[60].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD60_SOFF     DMA_B.TCD[60].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD60_NBYTES_MLNO DMA_B.TCD[60].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD60_NBYTES_MLOFFNO DMA_B.TCD[60].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD60_NBYTES_MLOFFYES DMA_B.TCD[60].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD60_SLAST    DMA_B.TCD[60].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD60_DADDR    DMA_B.TCD[60].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD60_CITER_ELINKNO DMA_B.TCD[60].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD60_CITER_ELINKYES DMA_B.TCD[60].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD60_DOFF     DMA_B.TCD[60].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD60_DLASTSGA DMA_B.TCD[60].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD60_BITER_ELINKNO DMA_B.TCD[60].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD60_BITER_ELINKYES DMA_B.TCD[60].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD60_CSR      DMA_B.TCD[60].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD61_SADDR    DMA_B.TCD[61].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD61_ATTR     DMA_B.TCD[61].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD61_SOFF     DMA_B.TCD[61].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD61_NBYTES_MLNO DMA_B.TCD[61].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD61_NBYTES_MLOFFNO DMA_B.TCD[61].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD61_NBYTES_MLOFFYES DMA_B.TCD[61].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD61_SLAST    DMA_B.TCD[61].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD61_DADDR    DMA_B.TCD[61].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD61_CITER_ELINKNO DMA_B.TCD[61].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD61_CITER_ELINKYES DMA_B.TCD[61].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD61_DOFF     DMA_B.TCD[61].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD61_DLASTSGA DMA_B.TCD[61].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD61_BITER_ELINKNO DMA_B.TCD[61].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD61_BITER_ELINKYES DMA_B.TCD[61].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD61_CSR      DMA_B.TCD[61].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD62_SADDR    DMA_B.TCD[62].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD62_ATTR     DMA_B.TCD[62].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD62_SOFF     DMA_B.TCD[62].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD62_NBYTES_MLNO DMA_B.TCD[62].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD62_NBYTES_MLOFFNO DMA_B.TCD[62].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD62_NBYTES_MLOFFYES DMA_B.TCD[62].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD62_SLAST    DMA_B.TCD[62].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD62_DADDR    DMA_B.TCD[62].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD62_CITER_ELINKNO DMA_B.TCD[62].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD62_CITER_ELINKYES DMA_B.TCD[62].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD62_DOFF     DMA_B.TCD[62].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD62_DLASTSGA DMA_B.TCD[62].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD62_BITER_ELINKNO DMA_B.TCD[62].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD62_BITER_ELINKYES DMA_B.TCD[62].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD62_CSR      DMA_B.TCD[62].CSR.R           /* TCD Control and Status */
#define DMA_B_TCD63_SADDR    DMA_B.TCD[63].SADDR.R         /* TCD Source Address */
#define DMA_B_TCD63_ATTR     DMA_B.TCD[63].ATTR.R          /* TCD Transfer Attributes */
#define DMA_B_TCD63_SOFF     DMA_B.TCD[63].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_B_TCD63_NBYTES_MLNO DMA_B.TCD[63].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_B_TCD63_NBYTES_MLOFFNO DMA_B.TCD[63].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_B_TCD63_NBYTES_MLOFFYES DMA_B.TCD[63].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_B_TCD63_SLAST    DMA_B.TCD[63].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_B_TCD63_DADDR    DMA_B.TCD[63].DADDR.R         /* TCD Destination Address */
#define DMA_B_TCD63_CITER_ELINKNO DMA_B.TCD[63].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD63_CITER_ELINKYES DMA_B.TCD[63].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD63_DOFF     DMA_B.TCD[63].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_B_TCD63_DLASTSGA DMA_B.TCD[63].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_B_TCD63_BITER_ELINKNO DMA_B.TCD[63].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_B_TCD63_BITER_ELINKYES DMA_B.TCD[63].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_B_TCD63_CSR      DMA_B.TCD[63].CSR.R           /* TCD Control and Status */

/* DSPI */
#define DSPI_A_MCR           DSPI_A.MCR.R                  /* Module Configuration Register */
#define DSPI_A_TCR           DSPI_A.TCR.R                  /* Transfer Count Register */
#define DSPI_A_CTAR0         DSPI_A.MODE.CTAR[0].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_A_CTAR1         DSPI_A.MODE.CTAR[1].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_A_CTAR2         DSPI_A.MODE.CTAR[2].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_A_CTAR3         DSPI_A.MODE.CTAR[3].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_A_CTAR4         DSPI_A.MODE.CTAR[4].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_A_CTAR5         DSPI_A.MODE.CTAR[5].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_A_CTAR6         DSPI_A.MODE.CTAR[6].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_A_CTAR7         DSPI_A.MODE.CTAR[7].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_A_CTAR0_SLAVE   DSPI_A.MODE.CTAR_SLAVE[0].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_A_CTAR1_SLAVE   DSPI_A.MODE.CTAR_SLAVE[1].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_A_SR            DSPI_A.SR.R                   /* Status Register */
#define DSPI_A_RSER          DSPI_A.RSER.R                 /* DMA/Interrupt Request Select and Enable Register */
#define DSPI_A_PUSHR         DSPI_A.PUSHR.PUSHR.R          /* PUSH TX FIFO Register In Master Mode */
#define DSPI_A_PUSHR_SLAVE   DSPI_A.PUSHR.PUSHR_SLAVE.R    /* PUSH TX FIFO Register In Slave Mode */
#define DSPI_A_POPR          DSPI_A.POPR.R                 /* POP RX FIFO Register */
#define DSPI_A_TXFR0         DSPI_A.TXFR[0].R              /* Transmit FIFO Registers */
#define DSPI_A_TXFR1         DSPI_A.TXFR[1].R              /* Transmit FIFO Registers */
#define DSPI_A_TXFR2         DSPI_A.TXFR[2].R              /* Transmit FIFO Registers */
#define DSPI_A_TXFR3         DSPI_A.TXFR[3].R              /* Transmit FIFO Registers */
#define DSPI_A_RXFR0         DSPI_A.RXFR[0].R              /* Receive FIFO Registers */
#define DSPI_A_RXFR1         DSPI_A.RXFR[1].R              /* Receive FIFO Registers */
#define DSPI_A_RXFR2         DSPI_A.RXFR[2].R              /* Receive FIFO Registers */
#define DSPI_A_RXFR3         DSPI_A.RXFR[3].R              /* Receive FIFO Registers */
#define DSPI_A_DSICR0        DSPI_A.DSICR0.R               /* DSI Configuration Register 0 */
#define DSPI_A_SDR0          DSPI_A.SDR0.R                 /* DSI Serialization Data Register 0 */
#define DSPI_A_ASDR0         DSPI_A.ASDR0.R                /* DSI Alternate Serialization Data Register 0 */
#define DSPI_A_COMPR0        DSPI_A.COMPR0.R               /* DSI Transmit Comparison Register 0 */
#define DSPI_A_DDR0          DSPI_A.DDR0.R                 /* DSI Deserialization Data Register 0 */
#define DSPI_A_DSICR1        DSPI_A.DSICR1.R               /* DSI Configuration Register 1 */
#define DSPI_A_SSR0          DSPI_A.SSR0.R                 /* DSI Serialization Source Select Register 0 */
#define DSPI_A_PISR0         DSPI_A.PISR0.R                /* DSI Parallel Input Select Register 0 */
#define DSPI_A_PISR1         DSPI_A.PISR1.R                /* DSI Parallel Input Select Register 1 */
#define DSPI_A_PISR2         DSPI_A.PISR2.R                /* DSI Parallel Input Select Register 2 */
#define DSPI_A_PISR3         DSPI_A.PISR3.R                /* DSI Parallel Input Select Register 3 */
#define DSPI_A_DIMR0         DSPI_A.DIMR0.R                /* DSI Deserialized Data Interrupt Mask Register 0 */
#define DSPI_A_DPIR0         DSPI_A.DPIR0.R                /* DSI Deserialized Data Polarity Interrupt Register 0 */
#define DSPI_A_SREX          DSPI_A.SREX.R                 /* Status Register Extended */

#define DSPI_B_MCR           DSPI_B.MCR.R                  /* Module Configuration Register */
#define DSPI_B_TCR           DSPI_B.TCR.R                  /* Transfer Count Register */
#define DSPI_B_CTAR0         DSPI_B.MODE.CTAR[0].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_B_CTAR1         DSPI_B.MODE.CTAR[1].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_B_CTAR2         DSPI_B.MODE.CTAR[2].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_B_CTAR3         DSPI_B.MODE.CTAR[3].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_B_CTAR4         DSPI_B.MODE.CTAR[4].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_B_CTAR5         DSPI_B.MODE.CTAR[5].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_B_CTAR6         DSPI_B.MODE.CTAR[6].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_B_CTAR7         DSPI_B.MODE.CTAR[7].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_B_CTAR0_SLAVE   DSPI_B.MODE.CTAR_SLAVE[0].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_B_CTAR1_SLAVE   DSPI_B.MODE.CTAR_SLAVE[1].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_B_SR            DSPI_B.SR.R                   /* Status Register */
#define DSPI_B_RSER          DSPI_B.RSER.R                 /* DMA/Interrupt Request Select and Enable Register */
#define DSPI_B_PUSHR         DSPI_B.PUSHR.PUSHR.R          /* PUSH TX FIFO Register In Master Mode */
#define DSPI_B_PUSHR_SLAVE   DSPI_B.PUSHR.PUSHR_SLAVE.R    /* PUSH TX FIFO Register In Slave Mode */
#define DSPI_B_POPR          DSPI_B.POPR.R                 /* POP RX FIFO Register */
#define DSPI_B_TXFR0         DSPI_B.TXFR[0].R              /* Transmit FIFO Registers */
#define DSPI_B_TXFR1         DSPI_B.TXFR[1].R              /* Transmit FIFO Registers */
#define DSPI_B_TXFR2         DSPI_B.TXFR[2].R              /* Transmit FIFO Registers */
#define DSPI_B_TXFR3         DSPI_B.TXFR[3].R              /* Transmit FIFO Registers */
#define DSPI_B_RXFR0         DSPI_B.RXFR[0].R              /* Receive FIFO Registers */
#define DSPI_B_RXFR1         DSPI_B.RXFR[1].R              /* Receive FIFO Registers */
#define DSPI_B_RXFR2         DSPI_B.RXFR[2].R              /* Receive FIFO Registers */
#define DSPI_B_RXFR3         DSPI_B.RXFR[3].R              /* Receive FIFO Registers */
#define DSPI_B_DSICR0        DSPI_B.DSICR0.R               /* DSI Configuration Register 0 */
#define DSPI_B_SDR0          DSPI_B.SDR0.R                 /* DSI Serialization Data Register 0 */
#define DSPI_B_ASDR0         DSPI_B.ASDR0.R                /* DSI Alternate Serialization Data Register 0 */
#define DSPI_B_COMPR0        DSPI_B.COMPR0.R               /* DSI Transmit Comparison Register 0 */
#define DSPI_B_DDR0          DSPI_B.DDR0.R                 /* DSI Deserialization Data Register 0 */
#define DSPI_B_DSICR1        DSPI_B.DSICR1.R               /* DSI Configuration Register 1 */
#define DSPI_B_SSR0          DSPI_B.SSR0.R                 /* DSI Serialization Source Select Register 0 */
#define DSPI_B_PISR0         DSPI_B.PISR0.R                /* DSI Parallel Input Select Register 0 */
#define DSPI_B_PISR1         DSPI_B.PISR1.R                /* DSI Parallel Input Select Register 1 */
#define DSPI_B_PISR2         DSPI_B.PISR2.R                /* DSI Parallel Input Select Register 2 */
#define DSPI_B_PISR3         DSPI_B.PISR3.R                /* DSI Parallel Input Select Register 3 */
#define DSPI_B_DIMR0         DSPI_B.DIMR0.R                /* DSI Deserialized Data Interrupt Mask Register 0 */
#define DSPI_B_DPIR0         DSPI_B.DPIR0.R                /* DSI Deserialized Data Polarity Interrupt Register 0 */
#define DSPI_B_SREX          DSPI_B.SREX.R                 /* Status Register Extended */

#define DSPI_C_MCR           DSPI_C.MCR.R                  /* Module Configuration Register */
#define DSPI_C_TCR           DSPI_C.TCR.R                  /* Transfer Count Register */
#define DSPI_C_CTAR0         DSPI_C.MODE.CTAR[0].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_C_CTAR1         DSPI_C.MODE.CTAR[1].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_C_CTAR2         DSPI_C.MODE.CTAR[2].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_C_CTAR3         DSPI_C.MODE.CTAR[3].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_C_CTAR4         DSPI_C.MODE.CTAR[4].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_C_CTAR5         DSPI_C.MODE.CTAR[5].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_C_CTAR6         DSPI_C.MODE.CTAR[6].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_C_CTAR7         DSPI_C.MODE.CTAR[7].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_C_CTAR0_SLAVE   DSPI_C.MODE.CTAR_SLAVE[0].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_C_CTAR1_SLAVE   DSPI_C.MODE.CTAR_SLAVE[1].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_C_SR            DSPI_C.SR.R                   /* Status Register */
#define DSPI_C_RSER          DSPI_C.RSER.R                 /* DMA/Interrupt Request Select and Enable Register */
#define DSPI_C_PUSHR         DSPI_C.PUSHR.PUSHR.R          /* PUSH TX FIFO Register In Master Mode */
#define DSPI_C_PUSHR_SLAVE   DSPI_C.PUSHR.PUSHR_SLAVE.R    /* PUSH TX FIFO Register In Slave Mode */
#define DSPI_C_POPR          DSPI_C.POPR.R                 /* POP RX FIFO Register */
#define DSPI_C_TXFR0         DSPI_C.TXFR[0].R              /* Transmit FIFO Registers */
#define DSPI_C_TXFR1         DSPI_C.TXFR[1].R              /* Transmit FIFO Registers */
#define DSPI_C_TXFR2         DSPI_C.TXFR[2].R              /* Transmit FIFO Registers */
#define DSPI_C_TXFR3         DSPI_C.TXFR[3].R              /* Transmit FIFO Registers */
#define DSPI_C_RXFR0         DSPI_C.RXFR[0].R              /* Receive FIFO Registers */
#define DSPI_C_RXFR1         DSPI_C.RXFR[1].R              /* Receive FIFO Registers */
#define DSPI_C_RXFR2         DSPI_C.RXFR[2].R              /* Receive FIFO Registers */
#define DSPI_C_RXFR3         DSPI_C.RXFR[3].R              /* Receive FIFO Registers */
#define DSPI_C_DSICR0        DSPI_C.DSICR0.R               /* DSI Configuration Register 0 */
#define DSPI_C_SDR0          DSPI_C.SDR0.R                 /* DSI Serialization Data Register 0 */
#define DSPI_C_ASDR0         DSPI_C.ASDR0.R                /* DSI Alternate Serialization Data Register 0 */
#define DSPI_C_COMPR0        DSPI_C.COMPR0.R               /* DSI Transmit Comparison Register 0 */
#define DSPI_C_DDR0          DSPI_C.DDR0.R                 /* DSI Deserialization Data Register 0 */
#define DSPI_C_DSICR1        DSPI_C.DSICR1.R               /* DSI Configuration Register 1 */
#define DSPI_C_SSR0          DSPI_C.SSR0.R                 /* DSI Serialization Source Select Register 0 */
#define DSPI_C_PISR0         DSPI_C.PISR0.R                /* DSI Parallel Input Select Register 0 */
#define DSPI_C_PISR1         DSPI_C.PISR1.R                /* DSI Parallel Input Select Register 1 */
#define DSPI_C_PISR2         DSPI_C.PISR2.R                /* DSI Parallel Input Select Register 2 */
#define DSPI_C_PISR3         DSPI_C.PISR3.R                /* DSI Parallel Input Select Register 3 */
#define DSPI_C_DIMR0         DSPI_C.DIMR0.R                /* DSI Deserialized Data Interrupt Mask Register 0 */
#define DSPI_C_DPIR0         DSPI_C.DPIR0.R                /* DSI Deserialized Data Polarity Interrupt Register 0 */
#define DSPI_C_SREX          DSPI_C.SREX.R                 /* Status Register Extended */

#define DSPI_D_MCR           DSPI_D.MCR.R                  /* Module Configuration Register */
#define DSPI_D_TCR           DSPI_D.TCR.R                  /* Transfer Count Register */
#define DSPI_D_CTAR0         DSPI_D.MODE.CTAR[0].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_D_CTAR1         DSPI_D.MODE.CTAR[1].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_D_CTAR2         DSPI_D.MODE.CTAR[2].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_D_CTAR3         DSPI_D.MODE.CTAR[3].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_D_CTAR4         DSPI_D.MODE.CTAR[4].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_D_CTAR5         DSPI_D.MODE.CTAR[5].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_D_CTAR6         DSPI_D.MODE.CTAR[6].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_D_CTAR7         DSPI_D.MODE.CTAR[7].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_D_CTAR0_SLAVE   DSPI_D.MODE.CTAR_SLAVE[0].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_D_CTAR1_SLAVE   DSPI_D.MODE.CTAR_SLAVE[1].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_D_SR            DSPI_D.SR.R                   /* Status Register */
#define DSPI_D_RSER          DSPI_D.RSER.R                 /* DMA/Interrupt Request Select and Enable Register */
#define DSPI_D_PUSHR         DSPI_D.PUSHR.PUSHR.R          /* PUSH TX FIFO Register In Master Mode */
#define DSPI_D_PUSHR_SLAVE   DSPI_D.PUSHR.PUSHR_SLAVE.R    /* PUSH TX FIFO Register In Slave Mode */
#define DSPI_D_POPR          DSPI_D.POPR.R                 /* POP RX FIFO Register */
#define DSPI_D_TXFR0         DSPI_D.TXFR[0].R              /* Transmit FIFO Registers */
#define DSPI_D_TXFR1         DSPI_D.TXFR[1].R              /* Transmit FIFO Registers */
#define DSPI_D_TXFR2         DSPI_D.TXFR[2].R              /* Transmit FIFO Registers */
#define DSPI_D_TXFR3         DSPI_D.TXFR[3].R              /* Transmit FIFO Registers */
#define DSPI_D_RXFR0         DSPI_D.RXFR[0].R              /* Receive FIFO Registers */
#define DSPI_D_RXFR1         DSPI_D.RXFR[1].R              /* Receive FIFO Registers */
#define DSPI_D_RXFR2         DSPI_D.RXFR[2].R              /* Receive FIFO Registers */
#define DSPI_D_RXFR3         DSPI_D.RXFR[3].R              /* Receive FIFO Registers */
#define DSPI_D_DSICR0        DSPI_D.DSICR0.R               /* DSI Configuration Register 0 */
#define DSPI_D_SDR0          DSPI_D.SDR0.R                 /* DSI Serialization Data Register 0 */
#define DSPI_D_ASDR0         DSPI_D.ASDR0.R                /* DSI Alternate Serialization Data Register 0 */
#define DSPI_D_COMPR0        DSPI_D.COMPR0.R               /* DSI Transmit Comparison Register 0 */
#define DSPI_D_DDR0          DSPI_D.DDR0.R                 /* DSI Deserialization Data Register 0 */
#define DSPI_D_DSICR1        DSPI_D.DSICR1.R               /* DSI Configuration Register 1 */
#define DSPI_D_SSR0          DSPI_D.SSR0.R                 /* DSI Serialization Source Select Register 0 */
#define DSPI_D_PISR0         DSPI_D.PISR0.R                /* DSI Parallel Input Select Register 0 */
#define DSPI_D_PISR1         DSPI_D.PISR1.R                /* DSI Parallel Input Select Register 1 */
#define DSPI_D_PISR2         DSPI_D.PISR2.R                /* DSI Parallel Input Select Register 2 */
#define DSPI_D_PISR3         DSPI_D.PISR3.R                /* DSI Parallel Input Select Register 3 */
#define DSPI_D_DIMR0         DSPI_D.DIMR0.R                /* DSI Deserialized Data Interrupt Mask Register 0 */
#define DSPI_D_DPIR0         DSPI_D.DPIR0.R                /* DSI Deserialized Data Polarity Interrupt Register 0 */
#define DSPI_D_SREX          DSPI_D.SREX.R                 /* Status Register Extended */

#define DSPI_E_MCR           DSPI_E.MCR.R                  /* Module Configuration Register */
#define DSPI_E_TCR           DSPI_E.TCR.R                  /* Transfer Count Register */
#define DSPI_E_CTAR0         DSPI_E.MODE.CTAR[0].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_E_CTAR1         DSPI_E.MODE.CTAR[1].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_E_CTAR2         DSPI_E.MODE.CTAR[2].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_E_CTAR3         DSPI_E.MODE.CTAR[3].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_E_CTAR4         DSPI_E.MODE.CTAR[4].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_E_CTAR5         DSPI_E.MODE.CTAR[5].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_E_CTAR6         DSPI_E.MODE.CTAR[6].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_E_CTAR7         DSPI_E.MODE.CTAR[7].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_E_CTAR0_SLAVE   DSPI_E.MODE.CTAR_SLAVE[0].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_E_CTAR1_SLAVE   DSPI_E.MODE.CTAR_SLAVE[1].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_E_SR            DSPI_E.SR.R                   /* Status Register */
#define DSPI_E_RSER          DSPI_E.RSER.R                 /* DMA/Interrupt Request Select and Enable Register */
#define DSPI_E_PUSHR         DSPI_E.PUSHR.PUSHR.R          /* PUSH TX FIFO Register In Master Mode */
#define DSPI_E_PUSHR_SLAVE   DSPI_E.PUSHR.PUSHR_SLAVE.R    /* PUSH TX FIFO Register In Slave Mode */
#define DSPI_E_POPR          DSPI_E.POPR.R                 /* POP RX FIFO Register */
#define DSPI_E_TXFR0         DSPI_E.TXFR[0].R              /* Transmit FIFO Registers */
#define DSPI_E_TXFR1         DSPI_E.TXFR[1].R              /* Transmit FIFO Registers */
#define DSPI_E_TXFR2         DSPI_E.TXFR[2].R              /* Transmit FIFO Registers */
#define DSPI_E_TXFR3         DSPI_E.TXFR[3].R              /* Transmit FIFO Registers */
#define DSPI_E_RXFR0         DSPI_E.RXFR[0].R              /* Receive FIFO Registers */
#define DSPI_E_RXFR1         DSPI_E.RXFR[1].R              /* Receive FIFO Registers */
#define DSPI_E_RXFR2         DSPI_E.RXFR[2].R              /* Receive FIFO Registers */
#define DSPI_E_RXFR3         DSPI_E.RXFR[3].R              /* Receive FIFO Registers */
#define DSPI_E_DSICR0        DSPI_E.DSICR0.R               /* DSI Configuration Register 0 */
#define DSPI_E_SDR0          DSPI_E.SDR0.R                 /* DSI Serialization Data Register 0 */
#define DSPI_E_ASDR0         DSPI_E.ASDR0.R                /* DSI Alternate Serialization Data Register 0 */
#define DSPI_E_COMPR0        DSPI_E.COMPR0.R               /* DSI Transmit Comparison Register 0 */
#define DSPI_E_DDR0          DSPI_E.DDR0.R                 /* DSI Deserialization Data Register 0 */
#define DSPI_E_DSICR1        DSPI_E.DSICR1.R               /* DSI Configuration Register 1 */
#define DSPI_E_SSR0          DSPI_E.SSR0.R                 /* DSI Serialization Source Select Register 0 */
#define DSPI_E_PISR0         DSPI_E.PISR0.R                /* DSI Parallel Input Select Register 0 */
#define DSPI_E_PISR1         DSPI_E.PISR1.R                /* DSI Parallel Input Select Register 1 */
#define DSPI_E_PISR2         DSPI_E.PISR2.R                /* DSI Parallel Input Select Register 2 */
#define DSPI_E_PISR3         DSPI_E.PISR3.R                /* DSI Parallel Input Select Register 3 */
#define DSPI_E_DIMR0         DSPI_E.DIMR0.R                /* DSI Deserialized Data Interrupt Mask Register 0 */
#define DSPI_E_DPIR0         DSPI_E.DPIR0.R                /* DSI Deserialized Data Polarity Interrupt Register 0 */
#define DSPI_E_SREX          DSPI_E.SREX.R                 /* Status Register Extended */

/* DTS */
#define DTS_ENABLE           DTS.ENABLE.R                  /* Output Enable Register */
#define DTS_STARTUP          DTS.STARTUP.R                 /* Startup Register */
#define DTS_SEMAPHORE        DTS.SEMAPHORE.R               /* Semaphore Register */
#define DTS_SEMAPHORE_B      DTS.SEMAPHORE_B.R             /* Semaphore Extension */

/* EBI */
#define EBI_MCR              EBI.MCR.R                     /* EBI Module Configuration Register */
#define EBI_TESR             EBI.TESR.R                    /* EBI Transfer Error Status Register */
#define EBI_BMCR             EBI.BMCR.R                    /* EBI Bus Monitor Control Register */
#define EBI_CAL_BR0          EBI.CAL[0].BR.R               /* EBI Calibration Base Register */
#define EBI_CAL_OR0          EBI.CAL[0].OR.R               /* EBI Calibration Option Register */
#define EBI_CAL_BR1          EBI.CAL[1].BR.R               /* EBI Calibration Base Register */
#define EBI_CAL_OR1          EBI.CAL[1].OR.R               /* EBI Calibration Option Register */
#define EBI_CAL_BR2          EBI.CAL[2].BR.R               /* EBI Calibration Base Register */
#define EBI_CAL_OR2          EBI.CAL[2].OR.R               /* EBI Calibration Option Register */
#define EBI_CAL_BR3          EBI.CAL[3].BR.R               /* EBI Calibration Base Register */
#define EBI_CAL_OR3          EBI.CAL[3].OR.R               /* EBI Calibration Option Register */

/* EIM */
#define EIM_EIMCR            EIM.EIMCR.R                   /* Error Injection Module Configuration Register */
#define EIM_EICHEN           EIM.EICHEN.R                  /* Error Injection Channel Enable register */
#define EIM_EICHD0_WORD0     EIM.EICHD[0].WORD0.R          /* Error Injection Channel Descriptor, Word0 */
#define EIM_EICHD0_WORD1     EIM.EICHD[0].WORD1.R          /* Error Injection Channel Descriptor, Word1 */
#define EIM_EICHD0_WORD2     EIM.EICHD[0].WORD2.R          /* Error Injection Channel Descriptor, Word2 */
#define EIM_EICHD1_WORD0     EIM.EICHD[1].WORD0.R          /* Error Injection Channel Descriptor, Word0 */
#define EIM_EICHD1_WORD1     EIM.EICHD[1].WORD1.R          /* Error Injection Channel Descriptor, Word1 */
#define EIM_EICHD1_WORD2     EIM.EICHD[1].WORD2.R          /* Error Injection Channel Descriptor, Word2 */
#define EIM_EICHD2_WORD0     EIM.EICHD[2].WORD0.R          /* Error Injection Channel Descriptor, Word0 */
#define EIM_EICHD2_WORD1     EIM.EICHD[2].WORD1.R          /* Error Injection Channel Descriptor, Word1 */
#define EIM_EICHD2_WORD2     EIM.EICHD[2].WORD2.R          /* Error Injection Channel Descriptor, Word2 */
#define EIM_EICHD3_WORD0     EIM.EICHD[3].WORD0.R          /* Error Injection Channel Descriptor, Word0 */
#define EIM_EICHD3_WORD1     EIM.EICHD[3].WORD1.R          /* Error Injection Channel Descriptor, Word1 */
#define EIM_EICHD3_WORD2     EIM.EICHD[3].WORD2.R          /* Error Injection Channel Descriptor, Word2 */
#define EIM_EICHD4_WORD0     EIM.EICHD[4].WORD0.R          /* Error Injection Channel Descriptor, Word0 */
#define EIM_EICHD4_WORD1     EIM.EICHD[4].WORD1.R          /* Error Injection Channel Descriptor, Word1 */
#define EIM_EICHD4_WORD2     EIM.EICHD[4].WORD2.R          /* Error Injection Channel Descriptor, Word2 */
#define EIM_EICHD5_WORD0     EIM.EICHD[5].WORD0.R          /* Error Injection Channel Descriptor, Word0 */
#define EIM_EICHD5_WORD1     EIM.EICHD[5].WORD1.R          /* Error Injection Channel Descriptor, Word1 */
#define EIM_EICHD5_WORD2     EIM.EICHD[5].WORD2.R          /* Error Injection Channel Descriptor, Word2 */

/* EQADC */
#define EQADC_A_MCR          EQADC_A.MCR.R                 /* EQADC Module Configuration Register */
#define EQADC_A_TST          EQADC_A.TST.R                 /* EQADC Test Register */
#define EQADC_A_ETDFR        EQADC_A.ETDFR.R               /* EQADC External Trigger Digital Filter Register */
#define EQADC_A_CFPR0        EQADC_A.CFPR[0].R             /* EQADC CFIFO Push Register */
#define EQADC_A_CFPR1        EQADC_A.CFPR[1].R             /* EQADC CFIFO Push Register */
#define EQADC_A_CFPR2        EQADC_A.CFPR[2].R             /* EQADC CFIFO Push Register */
#define EQADC_A_CFPR3        EQADC_A.CFPR[3].R             /* EQADC CFIFO Push Register */
#define EQADC_A_CFPR4        EQADC_A.CFPR[4].R             /* EQADC CFIFO Push Register */
#define EQADC_A_CFPR5        EQADC_A.CFPR[5].R             /* EQADC CFIFO Push Register */
#define EQADC_A_RFPR0        EQADC_A.RFPR[0].R             /* EQADC Result FIFO Pop Register */
#define EQADC_A_RFPR1        EQADC_A.RFPR[1].R             /* EQADC Result FIFO Pop Register */
#define EQADC_A_RFPR2        EQADC_A.RFPR[2].R             /* EQADC Result FIFO Pop Register */
#define EQADC_A_RFPR3        EQADC_A.RFPR[3].R             /* EQADC Result FIFO Pop Register */
#define EQADC_A_RFPR4        EQADC_A.RFPR[4].R             /* EQADC Result FIFO Pop Register */
#define EQADC_A_RFPR5        EQADC_A.RFPR[5].R             /* EQADC Result FIFO Pop Register */
#define EQADC_A_CFCR0        EQADC_A.CFCR0.R               /* EQADC CFIFO Control Register 0 */
#define EQADC_A_CFCR1        EQADC_A.CFCR1.R               /* EQADC CFIFO Control Register 1 */
#define EQADC_A_CFCR2        EQADC_A.CFCR2.R               /* EQADC CFIFO Control Register 2 */
#define EQADC_A_IDCR0        EQADC_A.IDCR0.R               /* EQADC Interrupt and DMA Control Register 0 */
#define EQADC_A_IDCR1        EQADC_A.IDCR1.R               /* EQADC Interrupt and DMA Control Register 1 */
#define EQADC_A_IDCR2        EQADC_A.IDCR2.R               /* EQADC Interrupt and DMA Control Register 2 */
#define EQADC_A_FISR0        EQADC_A.FISR[0].R             /* EQADC FIFO and Interrupt Status Register */
#define EQADC_A_FISR1        EQADC_A.FISR[1].R             /* EQADC FIFO and Interrupt Status Register */
#define EQADC_A_FISR2        EQADC_A.FISR[2].R             /* EQADC FIFO and Interrupt Status Register */
#define EQADC_A_FISR3        EQADC_A.FISR[3].R             /* EQADC FIFO and Interrupt Status Register */
#define EQADC_A_FISR4        EQADC_A.FISR[4].R             /* EQADC FIFO and Interrupt Status Register */
#define EQADC_A_FISR5        EQADC_A.FISR[5].R             /* EQADC FIFO and Interrupt Status Register */
#define EQADC_A_CFTCR0       EQADC_A.CFTCR0.R              /* EQADC CFIFO Transfer Counter Register 0 */
#define EQADC_A_CFTCR1       EQADC_A.CFTCR1.R              /* EQADC CFIFO Transfer Counter Register 1 */
#define EQADC_A_CFTCR2       EQADC_A.CFTCR2.R              /* EQADC CFIFO Transfer Counter Register 2 */
#define EQADC_A_CFSSR0       EQADC_A.CFSSR0.R              /* EQADC CFIFO Status Snapshot Register 0 */
#define EQADC_A_CFSSR1       EQADC_A.CFSSR1.R              /* EQADC CFIFO Status Snapshot Register 1 */
#define EQADC_A_CFSR         EQADC_A.CFSR.R                /* EQADC CFIFO Status Register */
#define EQADC_A_STACCCR      EQADC_A.STACCCR.R             /* EQADC STAC Bus Client Configuration Register */
#define EQADC_A_CF0R0        EQADC_A.CF0R[0].R             /* EQADC CFIFO0 Register */
#define EQADC_A_CF0R1        EQADC_A.CF0R[1].R             /* EQADC CFIFO0 Register */
#define EQADC_A_CF0R2        EQADC_A.CF0R[2].R             /* EQADC CFIFO0 Register */
#define EQADC_A_CF0R3        EQADC_A.CF0R[3].R             /* EQADC CFIFO0 Register */
#define EQADC_A_CF0ER0       EQADC_A.CF0ER[0].R            /* EQADC CFIFO0 Extension Register */
#define EQADC_A_CF0ER1       EQADC_A.CF0ER[1].R            /* EQADC CFIFO0 Extension Register */
#define EQADC_A_CF0ER2       EQADC_A.CF0ER[2].R            /* EQADC CFIFO0 Extension Register */
#define EQADC_A_CF0ER3       EQADC_A.CF0ER[3].R            /* EQADC CFIFO0 Extension Register */
#define EQADC_A_CF1R0        EQADC_A.CF1R[0].R             /* EQADC CFIFO1 Register */
#define EQADC_A_CF1R1        EQADC_A.CF1R[1].R             /* EQADC CFIFO1 Register */
#define EQADC_A_CF1R2        EQADC_A.CF1R[2].R             /* EQADC CFIFO1 Register */
#define EQADC_A_CF1R3        EQADC_A.CF1R[3].R             /* EQADC CFIFO1 Register */
#define EQADC_A_CF2R0        EQADC_A.CF2R[0].R             /* EQADC CFIFO2 Register */
#define EQADC_A_CF2R1        EQADC_A.CF2R[1].R             /* EQADC CFIFO2 Register */
#define EQADC_A_CF2R2        EQADC_A.CF2R[2].R             /* EQADC CFIFO2 Register */
#define EQADC_A_CF2R3        EQADC_A.CF2R[3].R             /* EQADC CFIFO2 Register */
#define EQADC_A_CF3R0        EQADC_A.CF3R[0].R             /* EQADC CFIFO3 Register */
#define EQADC_A_CF3R1        EQADC_A.CF3R[1].R             /* EQADC CFIFO3 Register */
#define EQADC_A_CF3R2        EQADC_A.CF3R[2].R             /* EQADC CFIFO3 Register */
#define EQADC_A_CF3R3        EQADC_A.CF3R[3].R             /* EQADC CFIFO3 Register */
#define EQADC_A_CF4R0        EQADC_A.CF4R[0].R             /* EQADC CFIFO4 Register */
#define EQADC_A_CF4R1        EQADC_A.CF4R[1].R             /* EQADC CFIFO4 Register */
#define EQADC_A_CF4R2        EQADC_A.CF4R[2].R             /* EQADC CFIFO4 Register */
#define EQADC_A_CF4R3        EQADC_A.CF4R[3].R             /* EQADC CFIFO4 Register */
#define EQADC_A_CF5R0        EQADC_A.CF5R[0].R             /* EQADC CFIFO5 Register */
#define EQADC_A_CF5R1        EQADC_A.CF5R[1].R             /* EQADC CFIFO5 Register */
#define EQADC_A_CF5R2        EQADC_A.CF5R[2].R             /* EQADC CFIFO5 Register */
#define EQADC_A_CF5R3        EQADC_A.CF5R[3].R             /* EQADC CFIFO5 Register */
#define EQADC_A_RF0R0        EQADC_A.RF0R[0].R             /* EQADC RFIFO0 Register */
#define EQADC_A_RF0R1        EQADC_A.RF0R[1].R             /* EQADC RFIFO0 Register */
#define EQADC_A_RF0R2        EQADC_A.RF0R[2].R             /* EQADC RFIFO0 Register */
#define EQADC_A_RF0R3        EQADC_A.RF0R[3].R             /* EQADC RFIFO0 Register */
#define EQADC_A_RF1R0        EQADC_A.RF1R[0].R             /* EQADC RFIFO1 Register */
#define EQADC_A_RF1R1        EQADC_A.RF1R[1].R             /* EQADC RFIFO1 Register */
#define EQADC_A_RF1R2        EQADC_A.RF1R[2].R             /* EQADC RFIFO1 Register */
#define EQADC_A_RF1R3        EQADC_A.RF1R[3].R             /* EQADC RFIFO1 Register */
#define EQADC_A_RF2R0        EQADC_A.RF2R[0].R             /* EQADC RFIFO2 Register */
#define EQADC_A_RF2R1        EQADC_A.RF2R[1].R             /* EQADC RFIFO2 Register */
#define EQADC_A_RF2R2        EQADC_A.RF2R[2].R             /* EQADC RFIFO2 Register */
#define EQADC_A_RF2R3        EQADC_A.RF2R[3].R             /* EQADC RFIFO2 Register */
#define EQADC_A_RF3R0        EQADC_A.RF3R[0].R             /* EQADC RFIFO3 Register */
#define EQADC_A_RF3R1        EQADC_A.RF3R[1].R             /* EQADC RFIFO3 Register */
#define EQADC_A_RF3R2        EQADC_A.RF3R[2].R             /* EQADC RFIFO3 Register */
#define EQADC_A_RF3R3        EQADC_A.RF3R[3].R             /* EQADC RFIFO3 Register */
#define EQADC_A_RF4R0        EQADC_A.RF4R[0].R             /* EQADC RFIFO4 Register */
#define EQADC_A_RF4R1        EQADC_A.RF4R[1].R             /* EQADC RFIFO4 Register */
#define EQADC_A_RF4R2        EQADC_A.RF4R[2].R             /* EQADC RFIFO4 Register */
#define EQADC_A_RF4R3        EQADC_A.RF4R[3].R             /* EQADC RFIFO4 Register */
#define EQADC_A_RF5R0        EQADC_A.RF5R[0].R             /* EQADC RFIFO5 Register */
#define EQADC_A_RF5R1        EQADC_A.RF5R[1].R             /* EQADC RFIFO5 Register */
#define EQADC_A_RF5R2        EQADC_A.RF5R[2].R             /* EQADC RFIFO5 Register */
#define EQADC_A_RF5R3        EQADC_A.RF5R[3].R             /* EQADC RFIFO5 Register */

#define EQADC_B_MCR          EQADC_B.MCR.R                 /* EQADC Module Configuration Register */
#define EQADC_B_TST          EQADC_B.TST.R                 /* EQADC Test Register */
#define EQADC_B_ETDFR        EQADC_B.ETDFR.R               /* EQADC External Trigger Digital Filter Register */
#define EQADC_B_CFPR0        EQADC_B.CFPR[0].R             /* EQADC CFIFO Push Register */
#define EQADC_B_CFPR1        EQADC_B.CFPR[1].R             /* EQADC CFIFO Push Register */
#define EQADC_B_CFPR2        EQADC_B.CFPR[2].R             /* EQADC CFIFO Push Register */
#define EQADC_B_CFPR3        EQADC_B.CFPR[3].R             /* EQADC CFIFO Push Register */
#define EQADC_B_CFPR4        EQADC_B.CFPR[4].R             /* EQADC CFIFO Push Register */
#define EQADC_B_CFPR5        EQADC_B.CFPR[5].R             /* EQADC CFIFO Push Register */
#define EQADC_B_RFPR0        EQADC_B.RFPR[0].R             /* EQADC Result FIFO Pop Register */
#define EQADC_B_RFPR1        EQADC_B.RFPR[1].R             /* EQADC Result FIFO Pop Register */
#define EQADC_B_RFPR2        EQADC_B.RFPR[2].R             /* EQADC Result FIFO Pop Register */
#define EQADC_B_RFPR3        EQADC_B.RFPR[3].R             /* EQADC Result FIFO Pop Register */
#define EQADC_B_RFPR4        EQADC_B.RFPR[4].R             /* EQADC Result FIFO Pop Register */
#define EQADC_B_RFPR5        EQADC_B.RFPR[5].R             /* EQADC Result FIFO Pop Register */
#define EQADC_B_CFCR0        EQADC_B.CFCR0.R               /* EQADC CFIFO Control Register 0 */
#define EQADC_B_CFCR1        EQADC_B.CFCR1.R               /* EQADC CFIFO Control Register 1 */
#define EQADC_B_CFCR2        EQADC_B.CFCR2.R               /* EQADC CFIFO Control Register 2 */
#define EQADC_B_IDCR0        EQADC_B.IDCR0.R               /* EQADC Interrupt and DMA Control Register 0 */
#define EQADC_B_IDCR1        EQADC_B.IDCR1.R               /* EQADC Interrupt and DMA Control Register 1 */
#define EQADC_B_IDCR2        EQADC_B.IDCR2.R               /* EQADC Interrupt and DMA Control Register 2 */
#define EQADC_B_FISR0        EQADC_B.FISR[0].R             /* EQADC FIFO and Interrupt Status Register */
#define EQADC_B_FISR1        EQADC_B.FISR[1].R             /* EQADC FIFO and Interrupt Status Register */
#define EQADC_B_FISR2        EQADC_B.FISR[2].R             /* EQADC FIFO and Interrupt Status Register */
#define EQADC_B_FISR3        EQADC_B.FISR[3].R             /* EQADC FIFO and Interrupt Status Register */
#define EQADC_B_FISR4        EQADC_B.FISR[4].R             /* EQADC FIFO and Interrupt Status Register */
#define EQADC_B_FISR5        EQADC_B.FISR[5].R             /* EQADC FIFO and Interrupt Status Register */
#define EQADC_B_CFTCR0       EQADC_B.CFTCR0.R              /* EQADC CFIFO Transfer Counter Register 0 */
#define EQADC_B_CFTCR1       EQADC_B.CFTCR1.R              /* EQADC CFIFO Transfer Counter Register 1 */
#define EQADC_B_CFTCR2       EQADC_B.CFTCR2.R              /* EQADC CFIFO Transfer Counter Register 2 */
#define EQADC_B_CFSSR0       EQADC_B.CFSSR0.R              /* EQADC CFIFO Status Snapshot Register 0 */
#define EQADC_B_CFSSR1       EQADC_B.CFSSR1.R              /* EQADC CFIFO Status Snapshot Register 1 */
#define EQADC_B_CFSR         EQADC_B.CFSR.R                /* EQADC CFIFO Status Register */
#define EQADC_B_STACCCR      EQADC_B.STACCCR.R             /* EQADC STAC Bus Client Configuration Register */
#define EQADC_B_CF0R0        EQADC_B.CF0R[0].R             /* EQADC CFIFO0 Register */
#define EQADC_B_CF0R1        EQADC_B.CF0R[1].R             /* EQADC CFIFO0 Register */
#define EQADC_B_CF0R2        EQADC_B.CF0R[2].R             /* EQADC CFIFO0 Register */
#define EQADC_B_CF0R3        EQADC_B.CF0R[3].R             /* EQADC CFIFO0 Register */
#define EQADC_B_CF0ER0       EQADC_B.CF0ER[0].R            /* EQADC CFIFO0 Extension Register */
#define EQADC_B_CF0ER1       EQADC_B.CF0ER[1].R            /* EQADC CFIFO0 Extension Register */
#define EQADC_B_CF0ER2       EQADC_B.CF0ER[2].R            /* EQADC CFIFO0 Extension Register */
#define EQADC_B_CF0ER3       EQADC_B.CF0ER[3].R            /* EQADC CFIFO0 Extension Register */
#define EQADC_B_CF1R0        EQADC_B.CF1R[0].R             /* EQADC CFIFO1 Register */
#define EQADC_B_CF1R1        EQADC_B.CF1R[1].R             /* EQADC CFIFO1 Register */
#define EQADC_B_CF1R2        EQADC_B.CF1R[2].R             /* EQADC CFIFO1 Register */
#define EQADC_B_CF1R3        EQADC_B.CF1R[3].R             /* EQADC CFIFO1 Register */
#define EQADC_B_CF2R0        EQADC_B.CF2R[0].R             /* EQADC CFIFO2 Register */
#define EQADC_B_CF2R1        EQADC_B.CF2R[1].R             /* EQADC CFIFO2 Register */
#define EQADC_B_CF2R2        EQADC_B.CF2R[2].R             /* EQADC CFIFO2 Register */
#define EQADC_B_CF2R3        EQADC_B.CF2R[3].R             /* EQADC CFIFO2 Register */
#define EQADC_B_CF3R0        EQADC_B.CF3R[0].R             /* EQADC CFIFO3 Register */
#define EQADC_B_CF3R1        EQADC_B.CF3R[1].R             /* EQADC CFIFO3 Register */
#define EQADC_B_CF3R2        EQADC_B.CF3R[2].R             /* EQADC CFIFO3 Register */
#define EQADC_B_CF3R3        EQADC_B.CF3R[3].R             /* EQADC CFIFO3 Register */
#define EQADC_B_CF4R0        EQADC_B.CF4R[0].R             /* EQADC CFIFO4 Register */
#define EQADC_B_CF4R1        EQADC_B.CF4R[1].R             /* EQADC CFIFO4 Register */
#define EQADC_B_CF4R2        EQADC_B.CF4R[2].R             /* EQADC CFIFO4 Register */
#define EQADC_B_CF4R3        EQADC_B.CF4R[3].R             /* EQADC CFIFO4 Register */
#define EQADC_B_CF5R0        EQADC_B.CF5R[0].R             /* EQADC CFIFO5 Register */
#define EQADC_B_CF5R1        EQADC_B.CF5R[1].R             /* EQADC CFIFO5 Register */
#define EQADC_B_CF5R2        EQADC_B.CF5R[2].R             /* EQADC CFIFO5 Register */
#define EQADC_B_CF5R3        EQADC_B.CF5R[3].R             /* EQADC CFIFO5 Register */
#define EQADC_B_RF0R0        EQADC_B.RF0R[0].R             /* EQADC RFIFO0 Register */
#define EQADC_B_RF0R1        EQADC_B.RF0R[1].R             /* EQADC RFIFO0 Register */
#define EQADC_B_RF0R2        EQADC_B.RF0R[2].R             /* EQADC RFIFO0 Register */
#define EQADC_B_RF0R3        EQADC_B.RF0R[3].R             /* EQADC RFIFO0 Register */
#define EQADC_B_RF1R0        EQADC_B.RF1R[0].R             /* EQADC RFIFO1 Register */
#define EQADC_B_RF1R1        EQADC_B.RF1R[1].R             /* EQADC RFIFO1 Register */
#define EQADC_B_RF1R2        EQADC_B.RF1R[2].R             /* EQADC RFIFO1 Register */
#define EQADC_B_RF1R3        EQADC_B.RF1R[3].R             /* EQADC RFIFO1 Register */
#define EQADC_B_RF2R0        EQADC_B.RF2R[0].R             /* EQADC RFIFO2 Register */
#define EQADC_B_RF2R1        EQADC_B.RF2R[1].R             /* EQADC RFIFO2 Register */
#define EQADC_B_RF2R2        EQADC_B.RF2R[2].R             /* EQADC RFIFO2 Register */
#define EQADC_B_RF2R3        EQADC_B.RF2R[3].R             /* EQADC RFIFO2 Register */
#define EQADC_B_RF3R0        EQADC_B.RF3R[0].R             /* EQADC RFIFO3 Register */
#define EQADC_B_RF3R1        EQADC_B.RF3R[1].R             /* EQADC RFIFO3 Register */
#define EQADC_B_RF3R2        EQADC_B.RF3R[2].R             /* EQADC RFIFO3 Register */
#define EQADC_B_RF3R3        EQADC_B.RF3R[3].R             /* EQADC RFIFO3 Register */
#define EQADC_B_RF4R0        EQADC_B.RF4R[0].R             /* EQADC RFIFO4 Register */
#define EQADC_B_RF4R1        EQADC_B.RF4R[1].R             /* EQADC RFIFO4 Register */
#define EQADC_B_RF4R2        EQADC_B.RF4R[2].R             /* EQADC RFIFO4 Register */
#define EQADC_B_RF4R3        EQADC_B.RF4R[3].R             /* EQADC RFIFO4 Register */
#define EQADC_B_RF5R0        EQADC_B.RF5R[0].R             /* EQADC RFIFO5 Register */
#define EQADC_B_RF5R1        EQADC_B.RF5R[1].R             /* EQADC RFIFO5 Register */
#define EQADC_B_RF5R2        EQADC_B.RF5R[2].R             /* EQADC RFIFO5 Register */
#define EQADC_B_RF5R3        EQADC_B.RF5R[3].R             /* EQADC RFIFO5 Register */

/* ERM */
#define ERM_CR0              ERM.CR0.R                     /* ERM Configuration Register */
#define ERM_CR1              ERM.CR1.R                     /* ERM Configuration Register */
#define ERM_CR2              ERM.CR2.R                     /* ERM Configuration Register */
#define ERM_SR0              ERM.SR0.R                     /* ERM Status Register */
#define ERM_SR1              ERM.SR1.R                     /* ERM Status Register */
#define ERM_SR2              ERM.SR2.R                     /* ERM Status Register */
#define ERM_EAR0             ERM.ERROR[0].EAR.R            /* ERM Memory n Error Address Register */
#define ERM_SYN0             ERM.ERROR[0].SYN.R            /* ERM Memory n Syndrome Register */
#define ERM_EAR1             ERM.ERROR[1].EAR.R            /* ERM Memory n Error Address Register */
#define ERM_SYN1             ERM.ERROR[1].SYN.R            /* ERM Memory n Syndrome Register */
#define ERM_EAR2             ERM.ERROR[2].EAR.R            /* ERM Memory n Error Address Register */
#define ERM_SYN2             ERM.ERROR[2].SYN.R            /* ERM Memory n Syndrome Register */
#define ERM_EAR3             ERM.ERROR[3].EAR.R            /* ERM Memory n Error Address Register */
#define ERM_SYN3             ERM.ERROR[3].SYN.R            /* ERM Memory n Syndrome Register */
#define ERM_EAR4     