/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.vgt.ide.ui.wizards;

import com.nxp.s32ds.ext.ide.resources.ResourceNameValidator;
import com.nxp.s32ds.ext.rcp.databinding.validation.CIdentifierValidator;
import com.nxp.s32ds.vgt.ide.internal.ui.UiMessages;
import com.nxp.s32ds.vgt.ide.internal.ui.VgtIdeUiActivator;
import com.nxp.s32ds.vgt.ide.ui.wizards.Messages;
import com.nxp.s32ds.vgt.ide.ui.wizards.VgtProjectListener;
import com.nxp.s32ds.vgt.ide.ui.wizards.VgtTargetProjectListener;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.internal.ide.dialogs.FileSystemSelectionArea;
import org.eclipse.ui.internal.ide.dialogs.ProjectContentsLocationArea;

public class VgtProjectWizardPage
extends WizardNewProjectCreationPage {
    private static final String SCHEMA_FILE = "file";
    private static final CIdentifierValidator cIdentifierValidator = CIdentifierValidator.INSTANCE;
    private static final ResourceNameValidator projectNameValidator = ResourceNameValidator.project((String)UiMessages.GraphToolsProjectWizardPage_e_invalid_project_name);
    private final List<VgtProjectListener> projectListeners = new ArrayList<VgtProjectListener>();
    private final List<VgtTargetProjectListener> targetProjectListeners = new ArrayList<VgtTargetProjectListener>();
    private String pName = "";
    private Text locationPath;
    private ArrayList<String> additionalRestrictedNameSymbols = new ArrayList();

    public VgtProjectWizardPage(String pageName) {
        super(pageName);
    }

    public void addGraphToolsProjectListener(VgtProjectListener listener) {
        if (listener != null && !this.projectListeners.contains(listener)) {
            this.projectListeners.add(listener);
        }
    }

    public void addGraphToolsTargetProjectListener(VgtTargetProjectListener listener) {
        if (listener != null && !this.targetProjectListeners.contains(listener)) {
            this.targetProjectListeners.add(listener);
        }
    }

    private void fireProjectChanged(String projectName, IPath locationPath, URI locationURI) {
        for (VgtProjectListener listener : this.projectListeners) {
            try {
                listener.projectChanged(projectName, locationPath, locationURI);
            }
            catch (Throwable e) {
                VgtIdeUiActivator.log(UiMessages.GraphToolsProjectWizardPage_e_dispatch_project_change, e);
            }
        }
    }

    protected void fireTargetProjectChanged(String targetProject) {
        for (VgtTargetProjectListener listener : this.targetProjectListeners) {
            try {
                listener.targetProjectChanged(targetProject);
            }
            catch (Throwable e) {
                VgtIdeUiActivator.log(UiMessages.GraphToolsProjectWizardPage_e_dispatch_target_project_change, e);
            }
        }
    }

    protected void fireUseDefaultLocationChanged(boolean value) {
        for (VgtTargetProjectListener listener : this.targetProjectListeners) {
            try {
                listener.useDefaultLocationChanged(value);
            }
            catch (Throwable e) {
                VgtIdeUiActivator.log(UiMessages.GraphToolsProjectWizardPage_e_dispatch_target_project_change, e);
            }
        }
    }

    public void removeGraphToolsProjectListener(VgtProjectListener listener) {
        if (listener != null) {
            this.projectListeners.remove(listener);
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite control = (Composite)this.getControl();
        GridLayout layout = new GridLayout();
        control.setLayout((Layout)layout);
        String[] supportedWorkingSetTypes = new String[]{"org.eclipse.ui.resourceWorkingSetPage"};
        this.createWorkingSetGroup(control, (IStructuredSelection)new StructuredSelection(), supportedWorkingSetTypes);
        this.initPrivateFields();
        Dialog.applyDialogFont((Control)control);
    }

    private void initPrivateFields() {
        try {
            Field locationAreaField = WizardNewProjectCreationPage.class.getDeclaredField("locationArea");
            locationAreaField.setAccessible(true);
            ProjectContentsLocationArea locationArea = (ProjectContentsLocationArea)locationAreaField.get((Object)this);
            Field locationPathField = ProjectContentsLocationArea.class.getDeclaredField("locationPathField");
            locationPathField.setAccessible(true);
            this.locationPath = (Text)locationPathField.get(locationArea);
            Field fileSystemSelectionAreaField = ProjectContentsLocationArea.class.getDeclaredField("fileSystemSelectionArea");
            fileSystemSelectionAreaField.setAccessible(true);
            FileSystemSelectionArea fileSystemSelectionArea = (FileSystemSelectionArea)fileSystemSelectionAreaField.get(locationArea);
            if (fileSystemSelectionArea != null) {
                Field fileSystemsField = FileSystemSelectionArea.class.getDeclaredField("fileSystems");
                fileSystemsField.setAccessible(true);
                ComboViewer cv = (ComboViewer)fileSystemsField.get(fileSystemSelectionArea);
                if (cv != null) {
                    cv.addSelectionChangedListener(new ISelectionChangedListener(){

                        public void selectionChanged(SelectionChangedEvent event) {
                            VgtProjectWizardPage.this.setPageComplete(VgtProjectWizardPage.this.validatePage());
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            VgtIdeUiActivator.log(Messages.VgtProjectPage_validate_error, e);
        }
    }

    private void updateLocation(String projectName) {
        if (this.locationPath == null) {
            return;
        }
        String path = this.locationPath.getText();
        if (this.pName.isEmpty()) {
            this.pName = projectName;
            while (path.endsWith(File.separator)) {
                path = path.substring(0, path.length() - File.separator.length());
            }
            this.locationPath.setText(String.valueOf(path) + File.separator + projectName);
            return;
        }
        if (this.pName.equals(projectName)) {
            return;
        }
        if (path.endsWith(this.pName)) {
            path = path.substring(0, path.length() - this.pName.length());
        }
        while (path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - File.separator.length());
        }
        this.pName = projectName;
        this.locationPath.setText(String.valueOf(path) + File.separator + projectName);
    }

    public void addRestrictedNameSymbol(String s) {
        this.additionalRestrictedNameSymbols.add(s);
    }

    public void removeRestrictedNameSymbol(String s) {
        this.additionalRestrictedNameSymbols.remove(s);
    }

    protected boolean validatePage() {
        if (!super.validatePage()) {
            return false;
        }
        for (String s : this.additionalRestrictedNameSymbols) {
            if (!this.getProjectName().contains(s)) continue;
            this.setErrorMessage(NLS.bind((String)Messages.VgtProjectPage_restricted_symbols_occurred, (Object)s));
            return false;
        }
        String projectName = this.getProjectName();
        IStatus validate = projectNameValidator.validate((Object)projectName);
        if (!validate.isOK()) {
            this.setErrorMessage(validate.getMessage());
            return false;
        }
        IStatus validateAsCidentifier = cIdentifierValidator.validate((Object)projectName);
        if (!validateAsCidentifier.isOK()) {
            this.setErrorMessage(validateAsCidentifier.getMessage());
            return false;
        }
        if (!this.useDefaults()) {
            this.updateLocation(projectName);
        }
        IPath locationPath = this.getLocationPath();
        String scheme = null;
        URI locationURI = this.getLocationURI();
        if (locationURI != null) {
            scheme = locationURI.getScheme();
        }
        if (!SCHEMA_FILE.equals(scheme)) {
            String error = NLS.bind((String)UiMessages.GraphToolsProjectWizardPage_e_location_is_not_supported, (Object)locationPath);
            this.setErrorMessage(error);
            return false;
        }
        try {
            IFileInfo f;
            IFileStore store = EFS.getStore((URI)locationURI);
            if (store != null && (f = store.fetchInfo()).exists() && f.isDirectory()) {
                this.setErrorMessage(UiMessages.GraphToolsProjectWizardPage_e_directory_already_exist);
                return false;
            }
        }
        catch (CoreException e) {
            VgtIdeUiActivator.log(e.getStatus());
        }
        this.fireProjectChanged(projectName, locationPath, locationURI);
        this.setErrorMessage(null);
        return true;
    }
}

