/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.license.cli;

import com.nxp.s32ds.ext.rcp.license.cli.ISettings;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Settings
implements ISettings {
    private String cmdName;
    private String[] cmdArgs;
    private Map<String, String> paramVals = new HashMap<String, String>();
    private String proxyHost;
    private int proxyPort;
    private String proxyUser;
    private String proxyPassword;

    public void parseArgs(String[] args) throws IllegalArgumentException {
        if (args.length < 1) {
            throw new IllegalArgumentException();
        }
        this.cmdName = args[0];
        this.cmdArgs = Arrays.copyOfRange(args, 1, args.length);
        boolean keyState = true;
        String key = null;
        String[] stringArray = this.cmdArgs;
        int n = this.cmdArgs.length;
        int n2 = 0;
        while (n2 < n) {
            String term = stringArray[n2];
            if (term.startsWith("-")) {
                if (!keyState) {
                    throw new IllegalArgumentException(String.valueOf(term) + " is not argument name");
                }
                key = term.substring(1);
                keyState = false;
            } else {
                if (keyState) {
                    throw new IllegalArgumentException(String.valueOf(term) + " is unexpected");
                }
                this.paramVals.put(key, term);
                keyState = true;
            }
            ++n2;
        }
    }

    @Override
    public String getCommandName() {
        return this.cmdName;
    }

    @Override
    public String[] getArgs() {
        return this.cmdArgs;
    }

    @Override
    public String getLicenseDirectory() {
        return this.paramVals.get("tspath");
    }

    @Override
    public String getProxyHost() {
        return this.proxyHost;
    }

    @Override
    public int getProxyPort() {
        return this.proxyPort;
    }

    @Override
    public String getProxyUser() {
        return this.proxyUser;
    }

    @Override
    public String getProxyPassword() {
        return this.proxyPassword;
    }

    @Override
    public boolean isDebugModeOn() {
        return this.paramVals.containsKey("debug") && this.paramVals.get("debug").equals("on");
    }

    @Override
    public String getParam(String key) {
        return this.paramVals.get(key);
    }

    @Override
    public void setProxyHost(String host) {
        this.proxyHost = host;
    }

    @Override
    public void setProxyPort(int port) {
        this.proxyPort = port;
    }

    @Override
    public void setProxyUser(String user) {
        this.proxyUser = user;
    }

    @Override
    public void setProxyPassword(String password) {
        this.proxyPassword = password;
    }

    @Override
    public String getLicenseServerNameOrIP() {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public int getServerPort() {
        throw new RuntimeException("Unimplemented");
    }
}

