/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.internal.p2.engine.spi;

import com.nxp.s32ds.ext.rcp.internal.p2.engine.spi.CopyAction;
import com.nxp.s32ds.ext.rcp.internal.p2.engine.spi.Messages;
import com.nxp.s32ds.ext.rcp.internal.p2.engine.spi.Util;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.internal.p2.touchpoint.natives.IBackupStore;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;

public class Unzip {
    public static final String ACTION_UNZIP = "unzip";

    public static IStatus unzip(Map<String, Object> parameters, boolean restoreable, String targetDir) {
        String target;
        String source = (String)parameters.get("source");
        if (source == null) {
            return Util.createErrorMessage(NLS.bind((String)Messages.param_not_set, (Object)"source", (Object)ACTION_UNZIP));
        }
        String originalSource = source;
        String string = target = targetDir == null ? (String)parameters.get("target") : targetDir;
        if (target == null) {
            return Util.createErrorMessage(NLS.bind((String)Messages.param_not_set, (Object)"target", (Object)ACTION_UNZIP));
        }
        IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
        Profile profile = (Profile)parameters.get("profile");
        if (source.equals("@artifact")) {
            String artifactLocation = (String)parameters.get("artifact.location");
            if (artifactLocation == null) {
                IArtifactKey artifactKey = (IArtifactKey)parameters.get("artifact");
                return Util.createErrorMessage(NLS.bind((String)Messages.artifact_not_available, (Object)artifactKey));
            }
            source = artifactLocation;
        }
        IBackupStore store = restoreable ? (IBackupStore)parameters.get("backup") : null;
        File[] unzippedFiles = Unzip.unzip(source, target, store);
        StringBuffer unzippedFileNameBuffer = new StringBuffer();
        File[] fileArray = unzippedFiles;
        int n = unzippedFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File unzippedFile = fileArray[n2];
            unzippedFileNameBuffer.append(unzippedFile.getAbsolutePath()).append("|");
            ++n2;
        }
        profile.setInstallableUnitProperty(iu, "unzipped|" + originalSource + "|" + target, unzippedFileNameBuffer.toString());
        return Status.OK_STATUS;
    }

    private static File[] unzip(String source, String destination, IBackupStore store) {
        File zipFile = new File(source);
        if (zipFile == null || !zipFile.exists()) {
            Util.logError(String.valueOf(Unzip.class.getName()) + " the files to be unzipped is not here");
        }
        try {
            String taskName = NLS.bind((String)Messages.unzipping, (Object)source);
            return Unzip.unzipFile(zipFile, new File(destination), store, taskName, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException iOException) {
            Util.logError(String.valueOf(Unzip.class.getName()) + " error unzipping zipfile: " + zipFile.getAbsolutePath() + "destination: " + destination);
            return new File[0];
        }
    }

    public static File[] unzipFile(File zipFile, File outputDir, IBackupStore store, String taskName, IProgressMonitor monitor) throws IOException {
        try (FileInputStream in = new FileInputStream(zipFile);){
            File[] fileArray = Unzip.unzipStream(in, zipFile.length(), outputDir, store, taskName, monitor);
            return fileArray;
        }
    }

    public static File[] unzipStream(InputStream stream, long size, File outputDir, IBackupStore store, String taskName, IProgressMonitor monitor) throws IOException {
        InputStream is = monitor == null ? stream : stream;
        ZipInputStream in = new ZipInputStream(new BufferedInputStream(is));
        ZipEntry ze = in.getNextEntry();
        if (ze == null) {
            in.close();
            throw new IOException(Messages.Util_Invalid_Zip_File_Format);
        }
        ArrayList<File> unzippedFiles = new ArrayList<File>();
        do {
            File outFile = new File(outputDir, ze.getName());
            unzippedFiles.add(outFile);
            if (ze.isDirectory()) {
                outFile.mkdirs();
            } else {
                if (outFile.exists()) {
                    if (store != null) {
                        store.backup(outFile);
                    } else {
                        outFile.delete();
                    }
                } else {
                    outFile.getParentFile().mkdirs();
                }
                try {
                    Util.copyStream(in, false, new FileOutputStream(outFile), true);
                }
                catch (FileNotFoundException fileNotFoundException) {}
                outFile.setLastModified(ze.getTime());
            }
            in.closeEntry();
        } while ((ze = in.getNextEntry()) != null);
        in.close();
        return unzippedFiles.toArray(new File[unzippedFiles.size()]);
    }

    public static IStatus unzipCopy(Map<String, Object> parameters, boolean restoreable, List<File> filelist) throws URISyntaxException {
        String source = (String)parameters.get("source");
        if (source == null) {
            return Util.createErrorMessage(NLS.bind((String)Messages.param_not_set, (Object)"source", (Object)ACTION_UNZIP));
        }
        String originalSource = source;
        String target = (String)parameters.get("target");
        if (target == null) {
            return Util.createErrorMessage(NLS.bind((String)Messages.param_not_set, (Object)"target", (Object)ACTION_UNZIP));
        }
        Location location = Platform.getConfigurationLocation();
        Location eclipse = Platform.getInstallLocation();
        if (location != null && eclipse != null) {
            try {
                IPath pathTemp = CopyAction.getLocationIPath(location);
                IPath eclipsePath = CopyAction.getLocationIPath(eclipse);
                if (!eclipsePath.isPrefixOf(pathTemp)) {
                    pathTemp = pathTemp.removeLastSegments(1);
                    pathTemp = pathTemp.addTrailingSeparator();
                    String firstString = eclipsePath.toString();
                    String secondString = pathTemp.toString();
                    target = target.replace("\\", "/");
                    target = target.replace(firstString, secondString);
                    Util.logWarning(String.format("%s is the new (USER) target parameter.%n", target));
                }
            }
            catch (URISyntaxException e) {
                Util.logWarning(e.getMessage());
                e.printStackTrace();
            }
        } else {
            Util.logError(String.format("FAIL to compute/validate/re-create target parameter.%n", new Object[0]));
            return Status.CANCEL_STATUS;
        }
        IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
        Profile profile = (Profile)parameters.get("profile");
        if (source.equals("@artifact")) {
            String artifactLocation = (String)parameters.get("artifact.location");
            if (artifactLocation == null) {
                IArtifactKey artifactKey = (IArtifactKey)parameters.get("artifact");
                return Util.createErrorMessage(NLS.bind((String)Messages.artifact_not_available, (Object)artifactKey));
            }
            source = artifactLocation;
        }
        IBackupStore store = restoreable ? (IBackupStore)parameters.get("backup") : null;
        File[] unzippedFiles = Unzip.unzip(source, target, store);
        StringBuffer unzippedFileNameBuffer = new StringBuffer();
        unzippedFileNameBuffer.ensureCapacity(unzippedFiles.length * 260);
        File[] fileArray = unzippedFiles;
        int n = unzippedFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File unzippedFile = fileArray[n2];
            unzippedFileNameBuffer.append(unzippedFile.getAbsolutePath()).append("|");
            filelist.add(unzippedFile);
            ++n2;
        }
        profile.setInstallableUnitProperty(iu, "copied|" + originalSource + "|" + target, unzippedFileNameBuffer.toString());
        return Status.OK_STATUS;
    }
}

