/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.internal.p2.engine.spi;

import com.nxp.s32ds.ext.rcp.internal.p2.engine.spi.Messages;
import com.nxp.s32ds.ext.rcp.internal.p2.engine.spi.ProcessCheckRunner;
import com.nxp.s32ds.ext.rcp.internal.p2.engine.spi.Util;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

public class ProcessCheckAction
extends ProvisioningAction {
    public static final String ID = "pcheck";
    public static final String ACTION_PCHECK = "processcheck";

    public IStatus execute(Map<String, Object> parameters) {
        String[] processes = ((String)parameters.get("processName")).split(" ");
        String message = (String)parameters.get("message");
        String title = (String)parameters.get("title");
        String target = (String)parameters.get("target");
        int noProcesses = processes.length;
        String runningProc = "";
        int noFeatures = 0;
        Location location = Platform.getConfigurationLocation();
        Location eclipse = Platform.getInstallLocation();
        if (location != null && eclipse != null) {
            try {
                IPath path = ProcessCheckAction.getLocationIPath(location);
                IPath eclipsePath = ProcessCheckAction.getLocationIPath(eclipse);
                if (!eclipsePath.isPrefixOf(path)) {
                    IPath newTarget = path.removeLastSegments(1);
                    newTarget = newTarget.addTrailingSeparator();
                    Util.logWarning(String.format("%s is the new (USER) target parameter.%n", newTarget.toString()));
                    target = newTarget.toString();
                }
            }
            catch (URISyntaxException e) {
                Util.logWarning(e.getMessage());
                e.printStackTrace();
            }
        } else {
            Util.logError(String.format("FAIL to compute/validate/re-create target parameter.%n", new Object[0]));
            return Status.CANCEL_STATUS;
        }
        try {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < noProcesses) {
                if (ProcessCheckRunner.getProcessRunning(processes[i], target)) {
                    sb.append(processes[i]).append(" ");
                    ++noFeatures;
                }
                ++i;
            }
            runningProc = sb.toString();
            if (!runningProc.equals("")) {
                message = noFeatures > 1 ? String.valueOf(message) + " processes " + runningProc + "are running.\nTerminate the processes and re-launch the installer." : String.valueOf(message) + " process " + runningProc + "is running.\nTerminate the process and re-launch the installer.";
                this.ShowMessage(message, title);
                return new Status(8, "com.nxp.s32ds.ext.rcp.p2.engine", 0, NLS.bind(null, parameters), null);
            }
            return Status.OK_STATUS;
        }
        catch (IOException err) {
            err.printStackTrace();
            return new Status(4, "com.nxp.s32ds.ext.rcp.p2.engine", 0, NLS.bind((String)Messages.param_not_set, (Object)"path", (Object)ACTION_PCHECK), null);
        }
    }

    private void ShowMessage(final String message, final String title) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(null, title, null, message, 1, new String[]{"OK"}, 0);
                int result = dialog.open();
                System.out.println(result);
            }
        });
    }

    public IStatus undo(Map<String, Object> parameters) {
        return Status.OK_STATUS;
    }

    private static IPath getLocationIPath(Location loc) throws URISyntaxException {
        URI locationURI = null;
        IPath path = null;
        try {
            locationURI = loc.getURL().toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            String filePath = loc.getURL().getFile();
            File tempFile = new File(filePath);
            locationURI = tempFile.toURI();
        }
        if (locationURI != null) {
            path = URIUtil.toPath((URI)locationURI);
            return path;
        }
        Util.logWarning(String.format("Cannot obtain the proper locationURI value in getLocationIPath function. %n", new Object[0]));
        path = new Path(loc.getURL().getPath());
        if (path != null) {
            Util.logWarning(String.format("Use this [%s] path instead.%n", path.toString()));
        }
        return path;
    }
}

