/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.ide.launch.core;

import com.nxp.s32ds.ext.ide.resources.WorkspaceResources;
import com.nxp.s32ds.ext.rcp.runtime.Log;
import com.nxp.s32ds.mdt.ide.core.MdtIdeCore;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.emf.ecore.EObject;

public class MdtIdeLaunchCore {
    public static final String BUNDLE_SYMBOLIC_NAME = "com.nxp.s32ds.mdt.ide.launch.core";
    public static final String EXTENSION_LAUNCH = "launch";
    public static final String FOLDER_LAUNCHES = ".launches";
    public static final String MODE_EMIT = "emit";

    public static IFolder createEmitConfigurationsFolder(IProject project, IProgressMonitor monitor) throws CoreException {
        IFolder launches = WorkspaceResources.createFolder((IProject)project, (String)FOLDER_LAUNCHES, (IProgressMonitor)monitor);
        return launches;
    }

    public static List<EObject> extractSemanticRoots(Object[] scope) {
        return MdtIdeCore.extractSemanticRoots((Object[])scope);
    }

    public static List<ILaunchConfiguration> extractLaunchConfigurations(IProject project, String mode) {
        ArrayList<ILaunchConfiguration> configs = new ArrayList<ILaunchConfiguration>();
        IContainer container = MdtIdeLaunchCore.getLaunchConfigurationSearchScope(project, mode);
        if (!container.exists()) {
            return configs;
        }
        try {
            List collected = WorkspaceResources.collectFiles((IResource)container, (String[])new String[]{EXTENSION_LAUNCH});
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            for (IFile candidate : collected) {
                ILaunchConfiguration config = launchManager.getLaunchConfiguration(candidate);
                if (config == null || !config.exists() || !config.supportsMode(mode)) continue;
                configs.add(config);
            }
        }
        catch (CoreException e) {
            Log.log((IStatus)e.getStatus(), (String)BUNDLE_SYMBOLIC_NAME);
        }
        return configs;
    }

    private static IContainer getLaunchConfigurationSearchScope(IProject project, String mode) {
        if (project == null) {
            return null;
        }
        if (MODE_EMIT.equals(mode)) {
            return project.getFolder(FOLDER_LAUNCHES);
        }
        return project;
    }
}

