/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.core.makefilegenerator;

import com.nxp.s32ds.ext.cdt.core.makefilegenerator.Activator;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.ArgumentFileBuilder;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.BaseMakefileGenerator;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.FSLMessages;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.IMakefileGeneratorContributor;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.IMakefileGeneratorContributor3;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.IMakefileGeneratorContributor8;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.MakefileGeneratorUtil;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.ToolOutputReader;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.VariableRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceConfiguration;
import org.eclipse.cdt.managedbuilder.internal.macros.FileContextData;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroProvider;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class ToolProxy {
    protected static final String LINE_SEPARATOR;

    static {
        String s = System.getProperty("line.separator");
        LINE_SEPARATOR = s == null ? "\n" : s;
    }

    public static IPath execute(IProject project, ITool tool, IPath path, boolean useStdout, ITool macroToolHolder, MessageConsoleStream consoleStream, IProgressMonitor monitor) {
        return ToolProxy.execute(project, tool, path, useStdout, macroToolHolder, consoleStream, null, null, monitor);
    }

    public static IPath execute(IProject project, ITool tool, IPath path, boolean useStdout, ITool macroToolHolder, MessageConsoleStream consoleStream, String extraFlag, String outputExtension, IProgressMonitor monitor) {
        return ToolProxy.execute(project, tool, path, null, null, useStdout, false, false, null, macroToolHolder, consoleStream, extraFlag, outputExtension, monitor);
    }

    public static IPath execute(IProject project, ITool tool, IPath path, boolean useStdout, boolean useCmdArray, String consoleFilter, ITool macroToolHolder, MessageConsoleStream consoleStream, String extraFlag, String removeFlags, String outputExtension, IProgressMonitor monitor) {
        return ToolProxy.execute(project, tool, path, null, null, useStdout, useCmdArray, false, consoleFilter, macroToolHolder, consoleStream, extraFlag, removeFlags, outputExtension, null, monitor, false);
    }

    public static IPath execute(IProject project, ITool tool, IPath path, boolean useStdout, boolean useCmdArray, String consoleFilter, ITool macroToolHolder, MessageConsoleStream consoleStream, String extraFlag, String outputExtension, IProgressMonitor monitor) {
        return ToolProxy.execute(project, tool, path, null, null, useStdout, useCmdArray, false, consoleFilter, macroToolHolder, consoleStream, extraFlag, outputExtension, monitor);
    }

    public static IPath execute(IProject project, ITool tool, IPath path, IPath outPath, IPath workingDir, boolean useStdout, boolean parseStdout, ITool macroToolHolder, MessageConsoleStream consoleStream, String extraFlag, String outputExtension, IProgressMonitor monitor) {
        return ToolProxy.execute(project, tool, path, outPath, workingDir, useStdout, false, parseStdout, null, macroToolHolder, consoleStream, extraFlag, outputExtension, monitor);
    }

    public static IPath execute(IProject project, ITool tool, IPath path, IPath outPath, IPath workingDir, boolean useStdout, boolean needCmdArray, boolean parseStdout, String consoleFilter, ITool macroToolHolder, MessageConsoleStream consoleStream, String extraFlag, String outputExtension, IProgressMonitor monitor) {
        return ToolProxy.execute(project, tool, path, outPath, workingDir, useStdout, needCmdArray, parseStdout, consoleFilter, macroToolHolder, consoleStream, extraFlag, null, outputExtension, null, monitor, false);
    }

    public static IPath execute(IProject project, ITool tool, IPath path, IPath outPath, IPath workingDir, boolean useStdout, boolean needCmdArray, boolean parseStdout, String consoleFilter, ITool macroToolHolder, MessageConsoleStream consoleStream, String extraFlag, String outputExtension, String outputName, IProgressMonitor monitor) {
        return ToolProxy.execute(project, tool, path, outPath, workingDir, useStdout, needCmdArray, parseStdout, consoleFilter, macroToolHolder, consoleStream, extraFlag, null, outputExtension, outputName, monitor, false);
    }

    public static IPath execute(IProject project, ITool tool, IPath path, IPath outPath, IPath workingDir, boolean useStdout, boolean needCmdArray, boolean parseStdout, String consoleFilter, ITool macroToolHolder, MessageConsoleStream consoleStream, String extraFlag, String removeFlags, String outputExtension, String outputName, IProgressMonitor monitor, boolean shouldRemoveDuplicatedFlags, ExitResults results) {
        IMakefileGeneratorContributor[] contributors;
        int n;
        String[] stringArray;
        String[] tools2;
        IPath outputFileLocation;
        IManagedCommandLineGenerator generator = tool.getCommandLineGenerator();
        IPath inputFileLocation = path;
        boolean shouldCreateOutputDir = false;
        if (outputName == null) {
            outputName = ToolProxy.getOutputName(project, tool, path);
        } else {
            shouldCreateOutputDir = true;
        }
        if (outPath == null || outPath.isEmpty()) {
            outputFileLocation = inputFileLocation.removeLastSegments(1).append(outputName);
            if (workingDir != null && !workingDir.isEmpty() && !workingDir.isPrefixOf(outputFileLocation)) {
                outputFileLocation = !project.getLocation().isPrefixOf(outputFileLocation) ? workingDir.append(outputFileLocation.lastSegment()) : workingDir.append(outputFileLocation.makeRelativeTo(project.getLocation()));
                shouldCreateOutputDir = true;
            }
        } else {
            outputFileLocation = outPath;
            outputFileLocation = outputFileLocation.append(outputName);
        }
        if (outputExtension != null) {
            outputFileLocation = outputFileLocation.removeFileExtension().addFileExtension(outputExtension);
        }
        IPath workingDirectoryPath = workingDir == null || workingDir.isEmpty() ? inputFileLocation.removeLastSegments(1) : workingDir;
        File workingDirectory = workingDirectoryPath.toFile();
        inputFileLocation = inputFileLocation.makeRelativeTo(workingDirectoryPath);
        outputFileLocation = outputFileLocation.makeRelativeTo(workingDirectoryPath);
        if (shouldCreateOutputDir) {
            ToolProxy.createIfDirDoesNotExist(outputFileLocation, workingDirectoryPath);
        }
        String[] flags = null;
        try {
            if (tool.getParent() != null && tool.getParent() instanceof IToolChain) {
                IFile[] resources;
                IFile resource = null;
                IFile[] iFileArray = resources = project.getWorkspace().getRoot().findFilesForLocation(path);
                int n2 = resources.length;
                int n3 = 0;
                while (n3 < n2) {
                    IFile res = iFileArray[n3];
                    if (res.getProject().equals((Object)project)) {
                        resource = res;
                        break;
                    }
                    ++n3;
                }
                if (resource != null) {
                    IResourceConfiguration resConfig;
                    IConfiguration conf = ((IToolChain)tool.getParent()).getParent();
                    if (conf == null) {
                        conf = ManagedBuildManager.getBuildInfo((IResource)project).getDefaultConfiguration();
                    }
                    if ((resConfig = conf.getResourceConfiguration(resource.getFullPath().toString())) == null) {
                        resConfig = conf.getResourceInfo(resource.getFullPath().removeFirstSegments(1), false);
                    }
                    if (resConfig != null) {
                        String extElementID22 = ToolProxy.getExtensionElementID(tool);
                        tools2 = resConfig.getTools();
                        stringArray = tools2;
                        n = tools2.length;
                        int n4 = 0;
                        while (n4 < n) {
                            String resourceTool = stringArray[n4];
                            if (ToolProxy.getExtensionElementID((ITool)resourceTool).equals(extElementID22)) {
                                flags = resourceTool.getToolCommandFlags(inputFileLocation, outputFileLocation);
                                break;
                            }
                            ++n4;
                        }
                    }
                }
            }
            if (flags == null) {
                flags = tool.getToolCommandFlags(inputFileLocation, outputFileLocation);
            }
        }
        catch (BuildException e1) {
            e1.printStackTrace();
        }
        if (extraFlag != null) {
            ArrayList<String> existingFlags = new ArrayList<String>();
            String[] extElementID22 = flags;
            int resConfig = flags.length;
            int conf = 0;
            while (conf < resConfig) {
                String flag = extElementID22[conf];
                existingFlags.addAll(Arrays.asList(ToolProxy.mergeLinesWithQuotes(flag.split(" "))));
                ++conf;
            }
            ArrayList<String> newFlags = new ArrayList<String>(Arrays.asList(flags));
            tools2 = ToolProxy.mergeLinesWithQuotes(extraFlag.split(" "));
            int extElementID22 = tools2.length;
            resConfig = 0;
            while (resConfig < extElementID22) {
                String extraFlagItem = tools2[resConfig];
                if (!existingFlags.contains(extraFlagItem) || !shouldRemoveDuplicatedFlags) {
                    newFlags.add(extraFlagItem);
                }
                ++resConfig;
            }
            flags = newFlags.toArray(new String[0]);
        }
        if (removeFlags != null && removeFlags.length() > 0) {
            String[] flagsToRemove = removeFlags.split(" ");
            ArrayList<String> temp = new ArrayList<String>();
            int i = 0;
            while (i < flags.length) {
                boolean found = false;
                String[] stringArray2 = flagsToRemove;
                int resourceTool = flagsToRemove.length;
                int tools2 = 0;
                while (tools2 < resourceTool) {
                    String toRemove = stringArray2[tools2];
                    if (flags[i].equals(toRemove)) {
                        found = true;
                    }
                    ++tools2;
                }
                if (!found) {
                    temp.add(flags[i]);
                }
                ++i;
            }
            flags = temp.toArray(new String[0]);
        }
        if ((contributors = MakefileGeneratorUtil.getContributors(project, tool)) != null && contributors.length > 0) {
            IMakefileGeneratorContributor[] toRemove = contributors;
            int found = contributors.length;
            int i = 0;
            while (i < found) {
                List<String> aFlags;
                IMakefileGeneratorContributor contributor = toRemove[i];
                if (contributor != null && contributor instanceof IMakefileGeneratorContributor3) {
                    flags = ((IMakefileGeneratorContributor3)contributor).massageToolCommandFlags(flags);
                }
                if (contributor instanceof IMakefileGeneratorContributor8 && !(aFlags = ((IMakefileGeneratorContributor8)contributor).getAdditionalFlags(tool)).isEmpty()) {
                    stringArray = flags;
                    n = flags.length;
                    int n5 = 0;
                    while (n5 < n) {
                        String flag = stringArray[n5];
                        aFlags.add(flag);
                        ++n5;
                    }
                    flags = aFlags.toArray(new String[aFlags.size()]);
                }
                ++i;
            }
        }
        ArgumentFileBuilder argFileBuilder = new ArgumentFileBuilder();
        argFileBuilder.enable();
        if (flags.length > 0) {
            String relativePath = String.valueOf(outputFileLocation.removeLastSegments(1).toOSString()) + "/";
            flags = argFileBuilder.convertFlags(relativePath, inputFileLocation, tool, outputFileLocation, true, flags, inputFileLocation.lastSegment(), workingDirectoryPath, false, false, new VariableRegistry.StringContainer(){

                @Override
                public boolean contains(String string) {
                    return false;
                }
            });
        }
        String outputFlag = tool.getOutputFlag();
        String outputPrefix = tool.getOutputPrefix();
        String[] inputResources = new String[]{inputFileLocation.toOSString()};
        String commandLinePattern = tool.getCommandLinePattern();
        IManagedCommandLineInfo cmdLineInfo = generator.generateCommandLineInfo(tool, tool.getToolCommand(), flags, outputFlag, outputPrefix, outputFileLocation.toOSString(), inputResources, commandLinePattern);
        String cmdLine = cmdLineInfo.getCommandLine();
        cmdLine = ToolProxy.addToolPath(cmdLine, tool);
        ErrorParserManager epm_out = null;
        ErrorParserManager epm_err = null;
        String[] errorParsers = ToolProxy.getErrorParsers(project);
        MarkerGenerator markerGenerator = new MarkerGenerator(path);
        IBuildMacroProvider provider = ManagedBuildManager.getBuildMacroProvider();
        String resolvedCommand = "";
        try {
            resolvedCommand = provider.resolveValueToMakefileFormat(cmdLine, new String(), " ", 1, (Object)new FileContextData(inputFileLocation, outputFileLocation, null, (IBuildObject)macroToolHolder));
        }
        catch (BuildMacroException buildMacroException) {}
        resolvedCommand = resolvedCommand.trim();
        if (resolvedCommand.length() > 0) {
            cmdLine = resolvedCommand;
        }
        if (errorParsers != null && errorParsers.length > 0) {
            if (parseStdout) {
                epm_out = new ErrorParserManager(project, (IMarkerGenerator)markerGenerator, errorParsers);
            }
            epm_err = new ErrorParserManager(project, (IMarkerGenerator)markerGenerator, errorParsers);
        }
        try {
            if (consoleStream != null) {
                consoleStream.println(cmdLine);
                for (ArgumentFileBuilder.BuildCommand command : argFileBuilder.fBuildCommand) {
                    consoleStream.println(String.valueOf(command.fileName) + " : " + command.fileArguments);
                }
            }
            argFileBuilder.writeExternalBuildCommands(workingDirectoryPath, workingDirectoryPath);
            Process process = null;
            if (needCmdArray && Platform.getOS().equals("linux")) {
                String[] cmdArray = ToolProxy.massageCmdLineArray(cmdLine);
                process = ToolProxy.createProcess(cmdArray, workingDirectory);
            } else {
                cmdLine = ToolProxy.massageCmdLine(cmdLine);
                process = ToolProxy.createProcess(cmdLine, workingDirectory);
            }
            File inputRedirectionFile = File.createTempFile(outputFileLocation.lastSegment(), "txt");
            try (FileOutputStream inputRedirection = new FileOutputStream(inputRedirectionFile);){
                ToolOutputReader errorThread;
                block65: {
                    ToolOutputReader inputThread = new ToolOutputReader(process.getInputStream(), consoleStream, (OutputStream)epm_out, consoleFilter);
                    errorThread = new ToolOutputReader(process.getErrorStream(), consoleStream, (OutputStream)epm_err, consoleFilter);
                    inputThread.setDataOuputStream(inputRedirection);
                    ToolProxy.readProcessOutput(inputThread, errorThread, consoleStream, monitor, results);
                    if (results != null) {
                        int exitCode = -1;
                        try {
                            try {
                                exitCode = process.exitValue();
                            }
                            catch (IllegalThreadStateException illegalThreadStateException) {
                                if (exitCode > -1) {
                                    results.setExitCode(exitCode);
                                }
                                break block65;
                            }
                        }
                        catch (Throwable throwable) {
                            if (exitCode > -1) {
                                results.setExitCode(exitCode);
                            }
                            throw throwable;
                        }
                        if (exitCode > -1) {
                            results.setExitCode(exitCode);
                        }
                    }
                }
                process.destroy();
                inputRedirection.flush();
                if (markerGenerator.getErrorCount() == 0) {
                    if (!outputFileLocation.isAbsolute()) {
                        outputFileLocation = workingDirectoryPath.append(outputFileLocation);
                    }
                    inputRedirection.close();
                    inputRedirection = null;
                    if (inputRedirectionFile.exists() && inputRedirectionFile.length() > 0L && !outputFileLocation.toFile().exists() || useStdout) {
                        boolean success;
                        File file = outputFileLocation.toFile();
                        if (!file.exists() && !(success = inputRedirectionFile.renameTo(file))) {
                            ToolProxy.copyFile(inputRedirectionFile, file);
                            inputRedirectionFile.delete();
                        }
                    } else if (!outputFileLocation.toFile().exists() && errorThread.hasOutput()) {
                        ToolProxy.displayError(FSLMessages.getString("Tool_execError", new Object[]{resolvedCommand, errorThread.getString()}));
                    }
                }
                argFileBuilder.deleteBuildCommandsFiles(workingDirectoryPath, workingDirectoryPath);
            }
        }
        catch (IOException e) {
            ToolProxy.displayError(FSLMessages.getString("Tool_execExcept", new Object[]{cmdLine, workingDirectory.getAbsolutePath(), e.getLocalizedMessage()}));
            e.printStackTrace();
        }
        catch (CoreException e) {
            ToolProxy.displayError(FSLMessages.getString("Tool_execExcept", new Object[]{cmdLine, workingDirectory.getAbsolutePath(), e.getLocalizedMessage()}));
            e.printStackTrace();
        }
        return outputFileLocation.toFile().exists() ? outputFileLocation : null;
    }

    public static IPath execute(IProject project, ITool tool, IPath path, IPath outPath, IPath workingDir, boolean useStdout, boolean needCmdArray, boolean parseStdout, String consoleFilter, ITool macroToolHolder, MessageConsoleStream consoleStream, String extraFlag, String removeFlags, String outputExtension, String outputName, IProgressMonitor monitor, boolean shouldRemoveDuplicatedFlags) {
        return ToolProxy.execute(project, tool, path, outPath, workingDir, useStdout, needCmdArray, parseStdout, consoleFilter, macroToolHolder, consoleStream, extraFlag, removeFlags, outputExtension, outputName, monitor, shouldRemoveDuplicatedFlags, null);
    }

    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    private static String getExtensionElementID(ITool tool) {
        while (tool.getSuperClass() != null && !tool.isExtensionElement()) {
            tool = tool.getSuperClass();
        }
        return tool.getId();
    }

    private static void createIfDirDoesNotExist(IPath outputFileLocation, IPath workingDirectoryPath) {
        boolean created;
        IPath outputFile = workingDirectoryPath.append(outputFileLocation);
        IPath outputDir = outputFile.removeLastSegments(1);
        File outDir = outputDir.toFile();
        if (!outDir.exists() && !(created = outDir.mkdirs())) {
            Activator.getDefault().getLog().log((IStatus)new Status(2, "com.nxp.s32ds.ext.cdt.makefilegenerator", FSLMessages.getString("ToolProxy.log.cannot.create.output.dir", new Object[]{outDir.toString()})));
        }
    }

    public static void readProcessOutput(ToolOutputReader stdOutputReader, ToolOutputReader errorOutputReader, MessageConsoleStream consoleStream, IProgressMonitor monitor, ExitResults results) {
        String pendingOutput;
        stdOutputReader.start();
        errorOutputReader.start();
        while ((stdOutputReader.isAlive() || errorOutputReader.isAlive()) && !monitor.isCanceled()) {
            try {
                stdOutputReader.join(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            try {
                errorOutputReader.join(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (!monitor.isCanceled() && (pendingOutput = errorOutputReader.getPendingText()).length() > 0) {
            if (consoleStream != null) {
                consoleStream.println(pendingOutput);
            }
            if (results != null) {
                results.setErrors(true);
            }
        }
    }

    public static void readProcessOutput(ToolOutputReader stdOutputReader, ToolOutputReader errorOutputReader, MessageConsoleStream consoleStream, IProgressMonitor monitor) {
        ToolProxy.readProcessOutput(stdOutputReader, errorOutputReader, consoleStream, monitor, null);
    }

    static void displayError(String text) {
        final String text_ = text;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageBox box = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 1);
                box.setText(FSLMessages.getString("ToolProxy.execErrorTitle"));
                box.setMessage(text_);
                box.open();
            }
        });
    }

    public static String getOutputExtension(IProject project, ITool tool, IPath path) {
        return ToolProxy.getOutputName(project, tool, path);
    }

    public static String getOutputName(IProject project, ITool tool, IPath path) {
        IToolChain toolchain;
        IConfiguration cfg;
        IManagedBuilderMakefileGenerator generator;
        IFile[] files;
        IFile resource = null;
        IFile[] iFileArray = files = project.getWorkspace().getRoot().findFilesForLocationURI(URIUtil.toURI((IPath)path));
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            if (file.getProject().equals((Object)project)) {
                resource = file;
                break;
            }
            ++n2;
        }
        if (resource != null && tool.getParent() != null && tool.getParent() instanceof IToolChain && (generator = ManagedBuildManager.getBuildfileGenerator((IConfiguration)(cfg = (toolchain = (IToolChain)tool.getParent()).getParent()))) != null && generator instanceof BaseMakefileGenerator) {
            BaseMakefileGenerator baseMakefileGenerator = (BaseMakefileGenerator)generator;
            IBuilder builder = cfg.getBuilder();
            baseMakefileGenerator.initialize(cfg, builder, (IProgressMonitor)new NullProgressMonitor());
            String outputName = baseMakefileGenerator.getOutputNameForResource((IResource)resource, tool);
            if (outputName != null) {
                return Path.fromPortableString((String)outputName).lastSegment();
            }
        }
        return ToolProxy.getDefaultOutputName(tool, path);
    }

    public static String getDefaultOutputExtension(ITool tool, IPath path) {
        return ToolProxy.getDefaultOutputName(tool, path);
    }

    public static String getDefaultOutputName(ITool tool, IPath path) {
        String[] extensions;
        IOutputType[] types;
        IOutputType outputType;
        String outputName = null;
        IPath tmpOutputName = path.removeFileExtension();
        if (tmpOutputName.lastSegment().endsWith(".")) {
            String segment = tmpOutputName.lastSegment();
            tmpOutputName = tmpOutputName.removeLastSegments(1).append(segment.substring(0, segment.lastIndexOf(".")));
        }
        if ((outputType = tool.getPrimaryOutputType()) != null && outputType.getOutputExtensionsAttribute() != null && outputType.getOutputExtensionsAttribute().length > 0) {
            outputName = tmpOutputName.addFileExtension(outputType.getOutputExtensionsAttribute()[0]).lastSegment();
        }
        if (outputName == null && (types = tool.getOutputTypes()) != null && types.length > 0 && types[0].getOutputExtensionsAttribute() != null && types[0].getOutputExtensionsAttribute().length > 0) {
            outputName = tmpOutputName.addFileExtension(types[0].getOutputExtensionsAttribute()[0]).lastSegment();
        }
        if (outputName == null && (extensions = tool.getAllOutputExtensions()) != null && extensions.length > 0) {
            outputName = tmpOutputName.addFileExtension(extensions[0]).lastSegment();
        }
        if (outputName == null) {
            outputName = tmpOutputName.lastSegment();
        }
        return outputName;
    }

    private static String[] massageCmdLineArray(String cmdLine) {
        String[] result = ToolProxy.mergeLinesWithQuotes(cmdLine.split("\\s"));
        int x = 0;
        while (x < result.length) {
            if (result[x].startsWith("\"") && result[x].endsWith("\"")) {
                result[x] = result[x].substring(1, result[x].length() - 1);
            } else if (result[x].endsWith("\"") && result[x].indexOf("\"") < result[x].length() - 1) {
                int i = result[x].indexOf("\"");
                result[x] = String.valueOf(result[x].substring(0, i)) + result[x].substring(i + 1, result[x].length() - 1);
            }
            ++x;
        }
        return result;
    }

    private static String massageCmdLine(String cmdLine) {
        if (Platform.getOS().equals("linux")) {
            StringBuilder builder = new StringBuilder();
            String[] result = ToolProxy.mergeLinesWithQuotes(cmdLine.split("\\s"));
            int x = 0;
            while (x < result.length) {
                if (result[x].startsWith("\"") && result[x].endsWith("\"")) {
                    result[x] = result[x].substring(1, result[x].length() - 1);
                    result[x] = result[x].replace(" ", "\\ ");
                }
                builder.append(result[x]);
                builder.append(" ");
                ++x;
            }
            return builder.toString();
        }
        return cmdLine;
    }

    public static String[] mergeLinesWithQuotes(String[] lines) {
        LinkedList<String> result = new LinkedList<String>();
        String currentLine = null;
        int i = 0;
        while (i < lines.length) {
            if (currentLine != null) {
                currentLine = String.valueOf(currentLine) + " " + lines[i];
                if (lines[i].indexOf("\"") != -1) {
                    result.addLast(currentLine);
                    currentLine = null;
                }
            } else if (lines[i].indexOf("\"") != -1 && lines[i].lastIndexOf("\"") == lines[i].indexOf("\"")) {
                currentLine = lines[i];
            } else {
                result.add(lines[i]);
            }
            ++i;
        }
        return result.toArray(new String[0]);
    }

    public static String[] mergeLinesWithEscape(String[] lines) {
        LinkedList<String> result = new LinkedList<String>();
        String currentLine = null;
        int i = 0;
        while (i < lines.length) {
            if (currentLine != null) {
                currentLine = String.valueOf(currentLine) + " " + lines[i];
                if (!lines[i].endsWith("\\")) {
                    result.addLast(currentLine);
                    currentLine = null;
                } else {
                    currentLine = currentLine.substring(0, currentLine.length() - 1);
                }
            } else if (lines[i].endsWith("\\")) {
                currentLine = lines[i].substring(0, lines[i].length() - 1);
            } else {
                result.add(lines[i]);
            }
            ++i;
        }
        return result.toArray(new String[0]);
    }

    static String[] getErrorParsers(IProject project) {
        IManagedBuildInfo buliderInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        if (buliderInfo == null) {
            return null;
        }
        return buliderInfo.getDefaultConfiguration().getErrorParserList();
    }

    static Process createProcess(String[] commandArray, File workingDirectory) throws IOException {
        if (!workingDirectory.exists()) {
            throw new IOException(FSLMessages.getString("Tool_workingDirNotExist", new Object[]{workingDirectory.getAbsolutePath()}));
        }
        if (!workingDirectory.isDirectory()) {
            throw new IOException(FSLMessages.getString("Tool_workingDirNotDir", new Object[]{workingDirectory.getAbsolutePath()}));
        }
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(commandArray, null, workingDirectory);
        }
        catch (IOException iOException) {
            List<String> list = Arrays.asList(commandArray);
            ProcessBuilder pb = new ProcessBuilder(list);
            pb.directory(workingDirectory);
            process = pb.start();
        }
        return process;
    }

    static Process createProcess(String commandLine, File workingDirectory) throws IOException {
        if (!workingDirectory.exists()) {
            throw new IOException(FSLMessages.getString("Tool_workingDirNotExist", new Object[]{workingDirectory.getAbsolutePath()}));
        }
        if (!workingDirectory.isDirectory()) {
            throw new IOException(FSLMessages.getString("Tool_workingDirNotDir", new Object[]{workingDirectory.getAbsolutePath()}));
        }
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(commandLine, null, workingDirectory);
        }
        catch (IOException iOException) {
            process = ToolProxy.createProcessBuilder(commandLine, workingDirectory);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            process = ToolProxy.createProcessBuilder(commandLine, workingDirectory);
        }
        return process;
    }

    static Process createProcessBuilder(String commandLine, File workingDirectory) throws IOException {
        LinkedList<String> list = new LinkedList<String>();
        ParseState state = new ParseState(commandLine);
        while (state.index < commandLine.length()) {
            String tmp = state.getNext();
            list.add(tmp);
        }
        ProcessBuilder pb = new ProcessBuilder(list);
        pb.directory(workingDirectory);
        return pb.start();
    }

    public static void configureConsole(MessageConsole console) {
        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
        boolean limitBufferSize = store.getBoolean("Console.limitConsoleOutput");
        if (limitBufferSize) {
            int lowWater;
            int highWater = store.getInt("Console.highWaterMark");
            if (highWater > (lowWater = store.getInt("Console.lowWaterMark"))) {
                console.setWaterMarks(lowWater, highWater);
            }
        } else {
            console.setWaterMarks(-1, -1);
        }
    }

    public static IFile getFileFromActiveEditor() {
        IEditorInput input;
        IEditorPart editor;
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (editor = page.getActiveEditor()) != null && (input = editor.getEditorInput()) != null) {
            return (IFile)input.getAdapter(IFile.class);
        }
        return null;
    }

    public static String addToolPath(String cmdLine, ITool tool) {
        ITool toolCopy = tool;
        IOption option = null;
        while ((option = tool.getOptionBySuperClassId(String.valueOf(toolCopy.getBaseId()) + ".option.tool.path")) == null && (toolCopy = toolCopy.getSuperClass()) != null) {
        }
        if (option == null) {
            IBuildObject parent = tool.getParent();
            IToolChain toolchain = parent instanceof ResourceConfiguration ? ((ResourceConfiguration)parent).getBaseToolChain() : (IToolChain)parent;
            option = toolchain.getOptionBySuperClassId("cdt.managedbuild.option.gnu.cross.path");
        }
        if (option != null) {
            String value = null;
            try {
                value = option.getStringValue();
            }
            catch (BuildException e) {
                Activator.log((Exception)((Object)e));
            }
            if (value != null && value.length() > 0) {
                cmdLine = value.concat("/" + cmdLine);
            }
        }
        return cmdLine;
    }

    public static class ExitResults {
        private int exitCode = -1;
        private boolean errors = false;

        public int getExitCode() {
            return this.exitCode;
        }

        public void setExitCode(int exitCode) {
            this.exitCode = exitCode;
        }

        public boolean hasErrors() {
            return this.errors;
        }

        public void setErrors(boolean errors) {
            this.errors = errors;
        }
    }

    static class MarkerGenerator
    implements IMarkerGenerator {
        int m_errorCount = 0;
        IResource m_fallbackResource = null;

        public MarkerGenerator(IPath path) {
            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(path);
            if (files.length > 0) {
                this.m_fallbackResource = files[0];
                try {
                    this.m_fallbackResource.deleteMarkers("org.eclipse.cdt.core.problem", true, 2);
                }
                catch (CoreException coreException) {}
            }
        }

        public int getErrorCount() {
            return this.m_errorCount;
        }

        public void addMarker(ProblemMarkerInfo problemMarkerInfo) {
            try {
                if (this.m_fallbackResource != null) {
                    IMarker marker = null;
                    if (problemMarkerInfo.file != null) {
                        marker = problemMarkerInfo.file.createMarker("org.eclipse.cdt.core.problem");
                        marker.setAttribute("location", problemMarkerInfo.lineNumber);
                        marker.setAttribute("lineNumber", problemMarkerInfo.lineNumber);
                        marker.setAttribute("charStart", -1);
                        marker.setAttribute("charEnd", -1);
                    } else {
                        marker = this.m_fallbackResource.createMarker("org.eclipse.cdt.core.problem");
                    }
                    marker.setAttribute("message", (Object)problemMarkerInfo.description);
                    marker.setAttribute("severity", this.mapMarkerSeverity(problemMarkerInfo.severity));
                    if (problemMarkerInfo.variableName != null) {
                        marker.setAttribute("problem.variable", (Object)problemMarkerInfo.variableName);
                    }
                }
                if (problemMarkerInfo.severity == 3 || problemMarkerInfo.severity == 2) {
                    ++this.m_errorCount;
                }
            }
            catch (CoreException e) {
                CCorePlugin.log((IStatus)e.getStatus());
            }
        }

        int mapMarkerSeverity(int severity) {
            switch (severity) {
                case 2: 
                case 3: {
                    return 2;
                }
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
            }
            return 2;
        }

        public void addMarker(IResource file, int lineNumber, String errorDesc, int severity, String errorVar) {
            ProblemMarkerInfo info = new ProblemMarkerInfo(file, lineNumber, errorDesc, severity, errorVar);
            this.addMarker(info);
        }
    }

    static class ParseState {
        public String commandLine = null;
        public int index = 0;

        public ParseState(String tmp) {
            this.commandLine = tmp;
        }

        public String getNext() {
            StringBuilder tmp = new StringBuilder();
            boolean insideQuotes = false;
            boolean done = false;
            boolean innerQuote = false;
            while (this.index < this.commandLine.length()) {
                char c = this.get();
                if (c == ' ') {
                    if (!insideQuotes) {
                        done = true;
                        continue;
                    }
                    tmp.append(c);
                    continue;
                }
                if (done) {
                    if (tmp.length() > 0) {
                        this.push();
                        break;
                    }
                    done = false;
                }
                if (c == '\"') {
                    if (tmp.length() > 0 && (!insideQuotes || innerQuote)) {
                        innerQuote = !innerQuote;
                        tmp.append(c);
                    }
                    insideQuotes = !insideQuotes;
                    continue;
                }
                tmp.append(c);
            }
            return tmp.toString();
        }

        char get() {
            return this.commandLine.charAt(this.index++);
        }

        void push() {
            --this.index;
        }
    }
}

