/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.core.makefilegenerator;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class FSLPathUtil {
    public static String quotePath(String path) {
        if (!FSLPathUtil.isQuoted(path)) {
            return "\"" + path + "\"";
        }
        return path;
    }

    public static String removeQuotes(String path) {
        if (FSLPathUtil.isQuoted(path)) {
            return path.substring(1, path.length() - 1);
        }
        return path;
    }

    public static boolean containsSpecialCharacters(String path) {
        return path.matches(".*(\\s|[\\{\\}\\(\\)\\$\\@%=;]).*");
    }

    public static String escapeWhitespaces(String path) {
        String[] segments = path.split("\\s");
        if (segments.length > 1) {
            StringBuffer escapedPath = new StringBuffer();
            int index = 0;
            while (index < segments.length) {
                escapedPath.append(segments[index]);
                if (index + 1 < segments.length) {
                    escapedPath.append("\\ ");
                }
                ++index;
            }
            return escapedPath.toString().trim();
        }
        return path;
    }

    public static String removeEscapeSequence(String path) {
        String sequence = "\\ ";
        int index = path.indexOf(sequence);
        while (index > -1) {
            path = String.valueOf(path.substring(0, index)) + path.substring(index + 1);
            index = path.indexOf(sequence);
        }
        return path;
    }

    public static IFile createFile(IPath makefilePath) throws CoreException {
        IWorkspaceRoot root = CCorePlugin.getWorkspace().getRoot();
        IFile newFile = root.getFileForLocation(makefilePath);
        if (newFile == null) {
            newFile = root.getFile(makefilePath);
        }
        ByteArrayInputStream contents = new ByteArrayInputStream(new byte[0]);
        try {
            newFile.create((InputStream)contents, false, (IProgressMonitor)new NullProgressMonitor());
            if (!newFile.isDerived()) {
                newFile.setDerived(true);
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                newFile.refreshLocal(0, null);
            }
            throw e;
        }
        return newFile;
    }

    public static String getPrefixBeforeQuotes(String value) {
        int index = value.indexOf("\"");
        int lastIndex = value.lastIndexOf("\"");
        if (index != -1 && index != lastIndex) {
            return value.substring(0, index);
        }
        return null;
    }

    public static boolean isQuoted(String path) {
        return path.startsWith("\"") && path.endsWith("\"");
    }

    public static boolean isPathEscaped(String path) {
        return path.indexOf("\\ ") > -1;
    }

    public static boolean pathEquals(IPath first, IPath second) {
        if (Platform.getOS().equals("win32")) {
            return first.toOSString().toLowerCase().equals(second.toOSString().toLowerCase());
        }
        return first.equals((Object)second);
    }
}

