/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.ide.core;

import com.nxp.s32ds.ext.emf.ecore.EmfResources;
import com.nxp.s32ds.ext.ide.resources.WorkspaceResources;
import com.nxp.s32ds.mdt.ide.core.SemanticElementResolver;
import com.nxp.s32ds.mdt.ide.core.SemanticPackageDelegate;
import com.nxp.s32ds.mdt.ide.core.SemanticUsagesFinder;
import com.nxp.s32ds.mdt.ide.internal.core.MdtIdeCoreActivator;
import com.nxp.s32ds.mdt.ide.internal.core.SemanticPackageRegistryInternals;
import com.nxp.s32ds.mdt.ide.internal.core.SemanticUsagesFindersRegistry;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class MdtIdeCore {
    public static final String FOLDER_MODEL = "model";

    public static List<EObject> extractSemanticRoots(Object ... selected) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (selected != null) {
            Object[] objectArray = selected;
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                EObject extracted = MdtIdeCore.extractSemanticRoot(object);
                if (extracted != null && !result.contains(extracted)) {
                    result.add(extracted);
                }
                ++n2;
            }
            return result;
        }
        return result;
    }

    public static EObject extractSemanticElement(Object selected) {
        EObject eObject = (EObject)Adapters.adapt((Object)selected, EObject.class, (boolean)true);
        SemanticElementResolver resolver = (SemanticElementResolver)Adapters.adapt((Object)eObject, SemanticElementResolver.class, (boolean)true);
        if (resolver != null) {
            eObject = resolver.resolveSemanticElement(eObject);
            return eObject;
        }
        return null;
    }

    public static EObject extractSemanticRoot(Object selected) {
        EObject eObject = MdtIdeCore.extractSemanticElement(selected);
        if (eObject == null) {
            return null;
        }
        SemanticPackageDelegate delegate = MdtIdeCore.resolveSemanticPackageDelegate(eObject);
        if (delegate == null) {
            return null;
        }
        return delegate.getSemanticRoot(eObject);
    }

    public static IResource extractSemanticWorkspaceResource(IAdaptable adaptable) {
        EObject semanticRoot = MdtIdeCore.extractSemanticRoot(adaptable);
        if (semanticRoot == null) {
            return null;
        }
        Resource eResource = semanticRoot.eResource();
        IPath path = EmfResources.getPath((Resource)eResource);
        return ResourcesPlugin.getWorkspace().getRoot().findMember(path);
    }

    public static SemanticPackageDelegate resolveSemanticPackageDelegate(EObject eObject) {
        SemanticPackageRegistryInternals semanticPackageRegistry = MdtIdeCoreActivator.getDefault().getSemanticPackageRegistry();
        return semanticPackageRegistry.findDelegate(eObject);
    }

    public static List<EObject> findUsages(EObject object, IProgressMonitor monitor) {
        ArrayList<EObject> objects = new ArrayList<EObject>();
        SemanticUsagesFindersRegistry registry = MdtIdeCoreActivator.getDefault().getSemanticUsagesFindersRegistry();
        for (SemanticUsagesFinder finder : registry.getAll()) {
            List<EObject> list;
            if (!finder.isApplicable(object) || (list = finder.find(object, monitor)) == null) continue;
            objects.addAll(list);
        }
        return objects;
    }

    public static boolean isFindUsagesApplicable(Object selected) {
        EObject eObject = MdtIdeCore.extractSemanticElement(selected);
        if (eObject == null) {
            return false;
        }
        SemanticUsagesFindersRegistry registry = MdtIdeCoreActivator.getDefault().getSemanticUsagesFindersRegistry();
        if (registry == null) {
            return false;
        }
        List<SemanticUsagesFinder> finders = registry.getAll();
        for (SemanticUsagesFinder finder : finders) {
            if (!finder.isApplicable(eObject)) continue;
            return true;
        }
        return false;
    }

    public static IFile toWorkspaceFile(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        IPath path = EmfResources.getPath((Resource)eObject.eResource());
        if (path == null) {
            return null;
        }
        return WorkspaceResources.getFile((IPath)path);
    }

    public static String toWorkspaceVariabled(EObject eObject) {
        IFile file = MdtIdeCore.toWorkspaceFile(eObject);
        return MdtIdeCore.toWorkspaceVariabled((IResource)file);
    }

    public static String toWorkspaceVariabled(IResource resource) {
        if (resource == null) {
            return null;
        }
        return MdtIdeCore.toWorkspaceVariabled(resource.getFullPath().toPortableString());
    }

    public static String toWorkspaceVariabled(String str) {
        return VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", str);
    }
}

