/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.vgt.ide.core;

import com.nxp.s32ds.vgt.ide.core.VgtIdeCore;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.business.internal.helper.task.operations.CreateViewTask;
import org.eclipse.sirius.diagram.business.internal.metamodel.spec.DNodeContainerSpec;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.tool.CreateView;
import org.eclipse.sirius.diagram.description.tool.ToolFactory;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.MetaClassNotFoundException;
import org.eclipse.sirius.tools.api.command.CommandContext;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public abstract class VgtDesignService {
    public EObject getEdgeTargetSemantic(EObject any, DEdge view) {
        return ((DSemanticDecorator)view.getTargetNode()).getTarget();
    }

    public EObject getEdgeSourceSemantic(EObject any, DEdge view) {
        return ((DSemanticDecorator)view.getSourceNode()).getTarget();
    }

    protected void paste(EObject container, EObject semanticElement, DSemanticDecorator elementView, DSemanticDecorator containerView) {
        Session session = SessionManager.INSTANCE.getSession(container);
        TransactionalEditingDomain domain = session.getTransactionalEditingDomain();
        Command cmd = AddCommand.create((EditingDomain)domain, (Object)container, null, (Object)semanticElement);
        if (cmd.canExecute()) {
            cmd.execute();
        }
        this.createView(semanticElement, containerView, session, "containerView");
    }

    protected void createView(final EObject semanticElement, final DSemanticDecorator containerView, final Session session, String containerViewVariable) {
        List<DiagramElementMapping> semanticElementMappings = this.getMappings(semanticElement, containerView, session);
        final CreateView createViewOp = ToolFactory.eINSTANCE.createCreateView();
        Iterator<DiagramElementMapping> iterator = semanticElementMappings.iterator();
        while (iterator.hasNext()) {
            DiagramElementMapping copiedElementMapping;
            DiagramElementMapping tmpCopiedElementMapping = copiedElementMapping = iterator.next();
            createViewOp.setMapping(tmpCopiedElementMapping);
            String containerViewExpression = "var:" + containerViewVariable;
            createViewOp.setContainerViewExpression(containerViewExpression);
            session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(session.getTransactionalEditingDomain()){

                protected void doExecute() {
                    try {
                        DRepresentation representation = null;
                        if (containerView instanceof DRepresentation) {
                            representation = (DRepresentation)containerView;
                        } else if (containerView instanceof DDiagramElement) {
                            representation = ((DDiagramElement)containerView).getParentDiagram();
                        }
                        CommandContext context = new CommandContext(semanticElement, representation);
                        new CreateViewTask(context, session.getModelAccessor(), createViewOp, session.getInterpreter()).execute();
                    }
                    catch (MetaClassNotFoundException e) {
                        VgtIdeCore.log(e.getMessage(), e);
                    }
                    catch (FeatureNotFoundException e) {
                        VgtIdeCore.log(e.getMessage(), e);
                    }
                }
            });
        }
    }

    protected List<DiagramElementMapping> getMappings(EObject semanticElement, DSemanticDecorator containerView, Session session) {
        ArrayList<DiagramElementMapping> mappings;
        block5: {
            ModelAccessor modelAccessor;
            block4: {
                modelAccessor = session.getModelAccessor();
                mappings = new ArrayList<DiagramElementMapping>();
                if (!(containerView instanceof DSemanticDiagram)) break block4;
                DiagramDescription description = ((DSemanticDiagram)containerView).getDescription();
                EList allContainerMappings = description.getAllContainerMappings();
                for (DiagramElementMapping mapping : allContainerMappings) {
                    String domainClass = ((AbstractNodeMapping)mapping).getDomainClass();
                    if (!modelAccessor.eInstanceOf(semanticElement, domainClass) || mapping.isCreateElements()) continue;
                    mappings.add(mapping);
                }
                EList nodes = description.getAllNodeMappings();
                for (DiagramElementMapping mapping : nodes) {
                    String domainClass = ((AbstractNodeMapping)mapping).getDomainClass();
                    if (!modelAccessor.eInstanceOf(semanticElement, domainClass) || mapping.isCreateElements()) continue;
                    mappings.add(mapping);
                }
                break block5;
            }
            if (!(containerView instanceof DNodeContainerSpec)) break block5;
            ContainerMapping actualMapping = ((DNodeContainerSpec)containerView).getActualMapping();
            EList containers = actualMapping.getAllContainerMappings();
            for (DiagramElementMapping mapping : containers) {
                String domainClass = ((AbstractNodeMapping)mapping).getDomainClass();
                if (!modelAccessor.eInstanceOf(semanticElement, domainClass) || mapping.isCreateElements()) continue;
                mappings.add(mapping);
            }
            EList nodes = actualMapping.getAllNodeMappings();
            for (Iterator mapping : nodes) {
                String domainClass = ((AbstractNodeMapping)mapping).getDomainClass();
                if (!modelAccessor.eInstanceOf(semanticElement, domainClass) || mapping.isCreateElements()) continue;
                mappings.add((DiagramElementMapping)mapping);
            }
        }
        return mappings;
    }
}

