/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.examples.core;

import com.nxp.s32ds.ext.ide.examples.core.ExampleObject;
import com.nxp.s32ds.ext.ide.examples.core.ExampleProjectLoader;
import com.nxp.s32ds.ext.ide.examples.core.IExampleComponent;
import com.nxp.s32ds.ext.ide.examples.core.IExampleObject;
import com.nxp.s32ds.ext.ide.examples.core.IVisualComponent;
import com.nxp.s32ds.ext.ide.examples.core.VisualComponent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ExampleProjectFacade {
    private static final String PROJECT_FILE = ".project";
    private Map<String, List<IExampleComponent>> mapModelComponents;
    private Map<String, List<IExampleObject>> mapObjectComponents;
    private Map<String, List<IExampleObject>> mapTreeObjectComponents;

    public ExampleProjectFacade() {
        try {
            this.mapModelComponents = ExampleProjectLoader.loadFromExtension();
            this.mapObjectComponents = this.convertToObjects();
            this.mapTreeObjectComponents = this.convertToTreeObjects();
        }
        catch (CoreException e) {
            ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
        }
    }

    public Map<String, List<IExampleObject>> convertToObjects() throws CoreException {
        HashMap<String, List<IExampleObject>> mapObjectComponents = new HashMap<String, List<IExampleObject>>();
        for (Map.Entry<String, List<IExampleComponent>> iter : this.mapModelComponents.entrySet()) {
            ArrayList<ExampleObject> listObjectComponents = new ArrayList<ExampleObject>();
            for (IExampleComponent modelComponent : iter.getValue()) {
                IProjectDescription projectDescr;
                Path pathMeta = new Path(modelComponent.getLocation());
                IPath projectFilePath = this.findProjectFilePath(pathMeta.toFile());
                if (projectFilePath == null || projectFilePath.isEmpty() || (projectDescr = ExampleProjectLoader.getProject(projectFilePath, false)) == null) continue;
                ArrayList<IProjectDescription> relatedProjectDescr = new ArrayList<IProjectDescription>();
                IProject[] iProjectArray = modelComponent.getRelatedProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Path projectPath;
                    IProjectDescription rprojectDescr;
                    IProject pr = iProjectArray[n2];
                    IExampleComponent relatedComponent = this.findExampleComponent(pr);
                    if (relatedComponent != null && (rprojectDescr = ExampleProjectLoader.getProject((IPath)(projectPath = new Path(relatedComponent.getLocation())), false)) != null) {
                        relatedProjectDescr.add(rprojectDescr);
                    }
                    ++n2;
                }
                ExampleObject objectComponent = new ExampleObject(relatedProjectDescr, projectDescr, null, modelComponent);
                listObjectComponents.add(objectComponent);
            }
            mapObjectComponents.put(iter.getKey(), listObjectComponents);
        }
        return mapObjectComponents;
    }

    private IExampleComponent findExampleComponent(IProject project) {
        for (List<IExampleComponent> lstIter : this.mapModelComponents.values()) {
            for (IExampleComponent iter : lstIter) {
                if (!iter.getName().equals(project.getName())) continue;
                return iter;
            }
        }
        return null;
    }

    private Map<String, List<IExampleObject>> convertToTreeObjects() {
        this.mapTreeObjectComponents = new HashMap<String, List<IExampleObject>>();
        for (Map.Entry<String, List<IExampleObject>> iter : this.mapObjectComponents.entrySet()) {
            ArrayList<IExampleObject> treeObjectComponent = new ArrayList<IExampleObject>();
            ArrayList tempList = new ArrayList();
            tempList.addAll(iter.getValue());
            for (IExampleObject objectComponent : iter.getValue()) {
                IExampleComponent modelingComponent = objectComponent.getModelingComponent();
                if (modelingComponent.getRelatedProjects() == null || modelingComponent.getRelatedProjects().length <= 0) continue;
                treeObjectComponent.add(objectComponent);
                tempList.remove(objectComponent);
                for (IProjectDescription projDescr : objectComponent.getRelatedProjectsObjects()) {
                    IExampleObject child = this.findObjectComponent(projDescr, iter.getValue());
                    objectComponent.addChildObject(child);
                    tempList.remove(child);
                }
            }
            treeObjectComponent.addAll(tempList);
            this.mapTreeObjectComponents.put(iter.getKey(), treeObjectComponent);
        }
        return this.mapTreeObjectComponents;
    }

    private IExampleObject findObjectComponent(IProjectDescription pd, List<IExampleObject> listObjectComponents) {
        for (IExampleObject parentObjectIter : listObjectComponents) {
            if (!parentObjectIter.getProjectObject().getName().equals(pd.getName())) continue;
            return parentObjectIter;
        }
        return null;
    }

    public List<IVisualComponent> convertToTreeVisualComponents() {
        ArrayList<IVisualComponent> treeNodes = new ArrayList<IVisualComponent>();
        for (Map.Entry<String, List<IExampleObject>> rootCategory : this.mapTreeObjectComponents.entrySet()) {
            VisualComponent visualRoot = new VisualComponent(rootCategory.getKey(), null, null);
            for (IExampleObject iter : rootCategory.getValue()) {
                visualRoot.addNewItems(iter.getModelingComponent().getGroup(), iter);
            }
            treeNodes.add(visualRoot);
        }
        Collections.sort(treeNodes, new Comparator<IVisualComponent>(){

            @Override
            public int compare(IVisualComponent gr1, IVisualComponent gr2) {
                return gr1.getVisualComponentName().toLowerCase().compareTo(gr2.getVisualComponentName().toLowerCase());
            }
        });
        return treeNodes;
    }

    public IProjectDescription getProjectDescriptionForComponent(IExampleComponent component) throws CoreException {
        Path pathParentProject = new Path(component.getLocation());
        IPath parentProjectFile = this.findProjectFilePath(pathParentProject.toFile());
        return ExampleProjectLoader.getProject(parentProjectFile, true);
    }

    public IPath findProjectFilePath(File fileParent) {
        if (!fileParent.exists()) {
            return null;
        }
        if (fileParent.isFile()) {
            if (fileParent.getName().equals(PROJECT_FILE)) {
                return new Path(fileParent.getAbsolutePath());
            }
        } else {
            File[] fileArray = fileParent.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.getName().equals(PROJECT_FILE)) {
                    return new Path(file.getAbsolutePath());
                }
                ++n2;
            }
        }
        return null;
    }
}

