/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.embsysregview.properties;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.miginfocom.swt.MigLayout;
import org.eclipse.cdt.embsysregview.Activator;
import org.eclipse.cdt.embsysregview.Messages;
import org.eclipse.cdt.embsysregview.internal.RegisterXMLCollector;
import org.eclipse.cdt.embsysregview.properties.DefaultChipInfo;
import org.eclipse.cdt.embsysregview.properties.ProjectProperties;
import org.eclipse.cdt.embsysregview.properties.PropertiesHolder;
import org.eclipse.cdt.embsysregview.properties.Property;
import org.eclipse.cdt.embsysregview.properties.SettingsUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaders;
import org.osgi.framework.Bundle;

public class PropertyPageEmbSys
extends PropertyPage {
    private static final String E200_ID = "e200";
    private Combo architecture;
    private Combo vendor;
    private Combo chip;
    private Combo board;
    private Combo core;
    private Label coreLabel;
    private Text descriptionText;
    private Map<String, String> registerDescriptionPaths = new HashMap<String, String>();
    private String selArchitecture;
    private String selVendor;
    private String selChip;
    private String selBoard;
    private String selCore;
    private IProject selectedProject;
    private ControlDecoration archDecoration;
    private ControlDecoration vendorDecoration;
    private ControlDecoration chipDecoration;
    private ControlDecoration coreDecoration;
    private Composite composite;

    public PropertyPageEmbSys() {
        this.selectedProject = null;
    }

    public PropertyPageEmbSys(IProject project) {
        this.selectedProject = project;
    }

    public boolean performOk() {
        PlatformObject platformObject = (PlatformObject)this.getElement();
        IProject project = this.selectedProject;
        if (platformObject != null) {
            project = (IProject)platformObject.getAdapter(IProject.class);
        }
        if (this.core.isVisible() && this.core.getSelectionIndex() == -1) {
            return false;
        }
        if (this.chip.getSelectionIndex() == -1) {
            return false;
        }
        if (this.vendor.getSelectionIndex() == -1) {
            return false;
        }
        if (this.architecture.getSelectionIndex() == -1) {
            return false;
        }
        Map<String, Property> propertyMap = PropertiesHolder.getInstance(project).getPropertyMap();
        SettingsUtils.setPropertyValueFromUI(project, propertyMap.get("architecture").getQualifiedName(), this.architecture);
        SettingsUtils.setPropertyValueFromUI(project, propertyMap.get("vendor").getQualifiedName(), this.vendor);
        SettingsUtils.setPropertyValueFromUI(project, propertyMap.get("chip").getQualifiedName(), this.chip);
        SettingsUtils.setPropertyValueFromUI(project, propertyMap.get("board").getQualifiedName(), this.board);
        SettingsUtils.setPropertyValueFromUI(project, propertyMap.get("core").getQualifiedName(), this.core);
        ProjectProperties.getInstance().firePropertiesChangeEvent(project);
        return true;
    }

    protected Control createContents(Composite parent) {
        IAdaptable elem;
        this.noDefaultAndApplyButton();
        if (this.selectedProject == null && (elem = this.getElement()) != null) {
            this.selectedProject = (IProject)elem.getAdapter(IProject.class);
        }
        this.setDescription(Messages.settings_page_description);
        this.registerDescriptionPaths = new RegisterXMLCollector().collectPaths();
        this.composite = new Composite(parent, 0);
        Composite left = new Composite(this.composite, 0);
        Composite right = new Composite(this.composite, 0);
        MigLayout migLayout = new MigLayout("fill", "10[180,grow 0]10[fill,grow]", "top");
        this.composite.setLayout((Layout)migLayout);
        left.setLayoutData((Object)"width 100:180:180");
        left.setLayout((Layout)new GridLayout(1, false));
        right.setLayoutData((Object)"grow,hmin 0,wmin 0");
        right.setLayout((Layout)new FillLayout());
        Label architectureLabel = new Label(left, 16384);
        architectureLabel.setText("Architecture:");
        this.architecture = new Combo(left, 12);
        this.architecture.setVisibleItemCount(10);
        this.architecture.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label vendorLabel = new Label(left, 16384);
        vendorLabel.setText("Vendor:");
        this.vendor = new Combo(left, 12);
        this.vendor.setVisibleItemCount(10);
        this.vendor.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label chipLabel = new Label(left, 16384);
        chipLabel.setText("Chip:");
        this.chip = new Combo(left, 12);
        this.chip.setVisibleItemCount(20);
        this.chip.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.coreLabel = new Label(left, 16384);
        this.coreLabel.setText("e200 Core:");
        this.coreLabel.setVisible(false);
        this.core = new Combo(left, 12);
        this.core.setVisibleItemCount(10);
        this.core.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.core.setVisible(false);
        Label boardLabel = new Label(left, 16384);
        boardLabel.setText("Board:");
        this.board = new Combo(left, 12);
        this.board.setVisibleItemCount(10);
        this.board.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Group descriptionGroup = new Group(right, 0);
        descriptionGroup.setText("Chip description");
        descriptionGroup.setLayout((Layout)new MigLayout("fill"));
        this.descriptionText = new Text((Composite)descriptionGroup, 842);
        this.descriptionText.setLayoutData((Object)"height 100%,width 100%,hmin 0,wmin 400");
        this.descriptionText.setText("");
        FontData[] fD = this.descriptionText.getFont().getFontData();
        fD[0].setName("Lucida Console");
        Font f = new Font((Device)Display.getCurrent(), fD[0]);
        this.descriptionText.setFont(f);
        this.architecture.setSize(500, 30);
        this.vendor.setSize(500, 30);
        this.vendor.setEnabled(false);
        this.chip.setSize(500, 30);
        this.chip.setEnabled(false);
        this.board.setSize(500, 30);
        this.board.setEnabled(false);
        this.core.setSize(500, 30);
        this.core.setEnabled(false);
        this.fillArchitecture();
        this.addDecorations();
        this.architecture.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String newArchitecture = PropertyPageEmbSys.this.architecture.getItem(PropertyPageEmbSys.this.architecture.getSelectionIndex());
                if (!newArchitecture.equals(PropertyPageEmbSys.this.selArchitecture)) {
                    PropertyPageEmbSys.this.selArchitecture = newArchitecture;
                    PropertyPageEmbSys.this.hideDecoration(PropertyPageEmbSys.this.architecture, PropertyPageEmbSys.this.archDecoration);
                    PropertyPageEmbSys.this.fillVendor(newArchitecture);
                    PropertyPageEmbSys.this.setValid(false);
                }
            }
        });
        this.vendor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String newVendor = PropertyPageEmbSys.this.vendor.getItem(PropertyPageEmbSys.this.vendor.getSelectionIndex());
                if (!newVendor.equals(PropertyPageEmbSys.this.selVendor)) {
                    PropertyPageEmbSys.this.selVendor = newVendor;
                    PropertyPageEmbSys.this.hideDecoration(PropertyPageEmbSys.this.vendor, PropertyPageEmbSys.this.vendorDecoration);
                    PropertyPageEmbSys.this.fillChip(PropertyPageEmbSys.this.architecture.getItem(PropertyPageEmbSys.this.architecture.getSelectionIndex()), newVendor);
                    PropertyPageEmbSys.this.setValid(false);
                }
            }
        });
        this.chip.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String newChip = PropertyPageEmbSys.this.chip.getItem(PropertyPageEmbSys.this.chip.getSelectionIndex());
                if (!newChip.equals(PropertyPageEmbSys.this.selChip)) {
                    PropertyPageEmbSys.this.selChip = newChip;
                    PropertyPageEmbSys.this.hideDecoration(PropertyPageEmbSys.this.chip, PropertyPageEmbSys.this.chipDecoration);
                    if (PropertyPageEmbSys.this.fillCore(PropertyPageEmbSys.this.architecture.getText(), PropertyPageEmbSys.this.vendor.getText(), PropertyPageEmbSys.this.chip.getText())) {
                        PropertyPageEmbSys.this.setValid(PropertyPageEmbSys.this.core.getSelectionIndex() != -1);
                    } else {
                        PropertyPageEmbSys.this.setValid(PropertyPageEmbSys.this.chip.getSelectionIndex() != -1);
                    }
                    PropertyPageEmbSys.this.fillBoard(PropertyPageEmbSys.this.architecture.getItem(PropertyPageEmbSys.this.architecture.getSelectionIndex()), PropertyPageEmbSys.this.vendor.getItem(PropertyPageEmbSys.this.vendor.getSelectionIndex()), newChip);
                }
            }
        });
        this.core.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String newCore = PropertyPageEmbSys.this.core.getItem(PropertyPageEmbSys.this.core.getSelectionIndex());
                if (!newCore.equals(PropertyPageEmbSys.this.selCore)) {
                    PropertyPageEmbSys.this.selCore = newCore;
                    PropertyPageEmbSys.this.hideDecoration(PropertyPageEmbSys.this.core, PropertyPageEmbSys.this.coreDecoration);
                    PropertyPageEmbSys.this.setValid(PropertyPageEmbSys.this.core.getSelectionIndex() != -1);
                }
            }
        });
        parent.pack();
        return this.composite;
    }

    public void dispose() {
        super.dispose();
        this.disposeWithChildren((Control)this.composite);
        this.disposeDecorations();
    }

    private void addDecorations() {
        if (this.architecture.getSelectionIndex() == -1) {
            this.archDecoration = PropertyPageEmbSys.showDecoration((Control)this.architecture, this.archDecoration);
        }
        if (this.vendor.getSelectionIndex() == -1) {
            this.vendorDecoration = PropertyPageEmbSys.showDecoration((Control)this.vendor, this.vendorDecoration);
        }
        if (this.chip.getSelectionIndex() == -1) {
            this.chipDecoration = PropertyPageEmbSys.showDecoration((Control)this.chip, this.chipDecoration);
        }
        if (this.core.getSelectionIndex() == -1) {
            this.coreDecoration = PropertyPageEmbSys.showDecoration((Control)this.core, this.coreDecoration);
        }
    }

    private void fillArchitecture() {
        for (String entry : this.getDirList("", "*")) {
            if ("embsysregview.dtd".equals(entry)) continue;
            this.architecture.add(entry);
        }
        this.restoreStoredSettings();
    }

    private void restoreStoredSettings() {
        Set<Property> propertySet;
        PlatformObject platformObject = (PlatformObject)this.getElement();
        IProject project = this.selectedProject;
        if (platformObject != null) {
            project = (IProject)platformObject.getAdapter(IProject.class);
        }
        if ((propertySet = SettingsUtils.initializePropertyValues(project)).isEmpty()) {
            return;
        }
        for (Property property : propertySet) {
            if (property.getValue() != null) continue;
            return;
        }
        this.fillControls(project);
        if (this.core.isVisible()) {
            this.setValid(this.core.getSelectionIndex() != -1);
        } else {
            this.setValid(this.chip.getSelectionIndex() != -1);
        }
    }

    private void fillControls(IProject project) {
        Map<String, String> props = PropertiesHolder.getInstance(project).getValueMap();
        String store_architecture = props.get("architecture");
        String store_vendor = props.get("vendor");
        String store_chip = props.get("chip");
        String store_board = props.get("board");
        String store_core = props.get("core");
        int index = this.architecture.indexOf(store_architecture);
        if (index != -1) {
            this.architecture.setEnabled(true);
            this.architecture.select(index);
            this.selArchitecture = store_architecture;
            this.hideDecoration(this.architecture, this.archDecoration);
            this.fillVendor(store_architecture);
            this.vendor.setEnabled(true);
            index = this.vendor.indexOf(store_vendor);
            if (index != -1) {
                this.vendor.select(index);
                this.selVendor = store_vendor;
                this.hideDecoration(this.vendor, this.vendorDecoration);
                this.fillChip(store_architecture, store_vendor);
                this.chip.setEnabled(true);
                index = this.chip.indexOf(store_chip);
                if (index != -1) {
                    this.chip.select(index);
                    this.selChip = store_chip;
                    this.hideDecoration(this.chip, this.chipDecoration);
                    if (this.fillCore(store_architecture, store_vendor, store_chip) && (index = this.core.indexOf(store_core)) != -1) {
                        this.core.select(index);
                        this.hideDecoration(this.core, this.coreDecoration);
                        this.selCore = store_core;
                    }
                    this.fillBoard(store_architecture, store_vendor, store_chip);
                    index = this.board.indexOf(store_board);
                    if (index != -1) {
                        this.board.select(index);
                        this.selBoard = store_board;
                    }
                }
            } else {
                this.vendor.setText("");
            }
        } else {
            this.architecture.setText("");
        }
    }

    private boolean fillCore(String selectedArchitecture, String selectedVendor, String selectedChip) {
        if (E200_ID.equals(selectedArchitecture)) {
            this.core.setEnabled(true);
            this.core.removeAll();
            this.coreDecoration = PropertyPageEmbSys.showDecoration((Control)this.core, this.coreDecoration);
            DefaultChipInfo chipInfo = new DefaultChipInfo();
            Set<String> coreSet = chipInfo.getChipCores(selectedChip);
            for (String entry : this.getDirList("/" + selectedArchitecture + "/" + selectedVendor, "*.spr")) {
                String coreFile = entry.substring(0, entry.lastIndexOf(46));
                if (!coreSet.contains(coreFile)) continue;
                this.core.add(coreFile);
            }
            if (coreSet.size() == 1) {
                this.core.setText(coreSet.iterator().next());
                this.hideDecoration(this.core, this.coreDecoration);
            } else {
                this.core.setText("");
                this.selCore = null;
            }
            return true;
        }
        return false;
    }

    private void fillVendor(String selectedArchitecture) {
        if (E200_ID.equals(selectedArchitecture)) {
            this.core.setVisible(true);
            this.core.setEnabled(false);
            this.core.setText("");
            this.core.removeAll();
            this.coreLabel.setVisible(true);
        } else {
            this.core.setVisible(false);
            this.coreLabel.setVisible(false);
        }
        this.chip.setEnabled(false);
        this.board.setEnabled(false);
        this.vendor.setEnabled(true);
        this.chip.setText("");
        this.board.setText("");
        this.vendor.removeAll();
        this.chip.removeAll();
        this.board.removeAll();
        this.vendorDecoration = PropertyPageEmbSys.showDecoration((Control)this.vendor, this.vendorDecoration);
        this.chipDecoration = PropertyPageEmbSys.showDecoration((Control)this.chip, this.chipDecoration);
        this.coreDecoration = PropertyPageEmbSys.showDecoration((Control)this.core, this.coreDecoration);
        for (String entry : this.getDirList("/" + selectedArchitecture, "*")) {
            this.vendor.add(entry);
        }
        this.vendor.setText("");
        this.descriptionText.setText("");
        this.selVendor = null;
    }

    private void fillChip(String selectedArchitecture, String selectedVendor) {
        this.board.setEnabled(false);
        this.board.setText("");
        this.chip.setEnabled(true);
        this.chip.removeAll();
        this.core.setEnabled(false);
        this.core.removeAll();
        this.board.removeAll();
        this.chipDecoration = PropertyPageEmbSys.showDecoration((Control)this.chip, this.chipDecoration);
        this.coreDecoration = PropertyPageEmbSys.showDecoration((Control)this.core, this.coreDecoration);
        for (String entry : this.getDirList("/" + selectedArchitecture + "/" + selectedVendor, "*.xml")) {
            this.chip.add(entry.substring(0, entry.length() - 4));
        }
        this.chip.setText("");
        this.descriptionText.setText("");
        this.selChip = null;
    }

    private void fillBoard(String selectedArchitecture, String selectedVendor, String selectedChip) {
        this.board.removeAll();
        this.board.add("---  none ---");
        SAXBuilder builder = new SAXBuilder((XMLReaderJDOMFactory)XMLReaders.NONVALIDATING);
        for (String bundleName : this.registerDescriptionPaths.keySet()) {
            String directory = this.registerDescriptionPaths.get(bundleName);
            Bundle bundle = Platform.getBundle((String)bundleName);
            URL fileURL = bundle.getEntry(String.valueOf(directory) + "/" + selectedArchitecture + "/" + selectedVendor + "/" + selectedChip + ".xml");
            if (fileURL == null) continue;
            boolean containsBoards = false;
            try {
                Document doc = builder.build(fileURL);
                Element root = doc.getRootElement();
                if (!"device".equals(root.getName())) {
                    List grouplist = root.getChildren("boards");
                    for (Element group : grouplist) {
                        List boardlist = group.getChildren();
                        for (Element boardElement : boardlist) {
                            containsBoards = true;
                            Attribute attr_bname = boardElement.getAttribute("id");
                            String bname = attr_bname != null ? attr_bname.getValue() : "-1";
                            this.board.add(bname);
                        }
                    }
                    Element chip_description = root.getChild("chip_description");
                    if (chip_description != null) {
                        this.descriptionText.setText(chip_description.getText());
                    }
                } else {
                    Element chip_description = root.getChild("description");
                    if (chip_description != null) {
                        this.descriptionText.setText(chip_description.getText());
                    }
                }
            }
            catch (JDOMException e) {
                Activator.log(0, e.getMessage(), e);
                this.descriptionText.setText(Messages.file_SVD_bad);
            }
            catch (IOException e) {
                Activator.log(0, e.getMessage(), e);
                this.descriptionText.setText(Messages.file_SVD_bad);
            }
            if (containsBoards) {
                this.board.setEnabled(true);
            } else {
                this.board.setEnabled(false);
            }
            if (this.board.getItemCount() > 0) {
                this.board.setText(this.board.getItem(0));
                continue;
            }
            this.board.setText("");
            this.selBoard = null;
        }
    }

    private List<String> getDirList(String path, String pattern) {
        ArrayList<String> dirList = new ArrayList<String>();
        for (String bundleName : this.registerDescriptionPaths.keySet()) {
            String directory;
            String fullPath;
            Bundle bundle = Platform.getBundle((String)bundleName);
            Enumeration entries = bundle.findEntries(fullPath = String.valueOf(directory = this.registerDescriptionPaths.get(bundleName)) + path, pattern, false);
            if (entries == null) continue;
            while (entries.hasMoreElements()) {
                URL entry = (URL)entries.nextElement();
                File x = new File(entry.getFile());
                try {
                    String filename = x.getCanonicalFile().getName();
                    if (filename.startsWith(".") || dirList.contains(filename)) continue;
                    dirList.add(filename);
                }
                catch (IOException e) {
                    Activator.log(0, e.getMessage(), e);
                }
            }
        }
        return dirList;
    }

    private static ControlDecoration createErrorDecoration(Control control) {
        ControlDecoration decoration = new ControlDecoration(control, 16512);
        decoration.setDescriptionText(Messages.select_value_message);
        int margin = 2;
        decoration.setMarginWidth(margin);
        ImageDescriptor descriptor = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_DEC_FIELD_ERROR");
        Image image = descriptor.createImage();
        decoration.setImage(image);
        return decoration;
    }

    private void disposeWithChildren(Control control) {
        if (control.isDisposed()) {
            return;
        }
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.disposeWithChildren(child);
                ++n2;
            }
        }
        control.dispose();
    }

    private static void disposeDecoration(ControlDecoration decoration) {
        if (decoration == null) {
            return;
        }
        decoration.hide();
        Image image = decoration.getImage();
        decoration.dispose();
        if (!image.isDisposed()) {
            image.dispose();
        }
    }

    private static ControlDecoration showDecoration(Control control, ControlDecoration decoration) {
        if (!control.isVisible()) {
            return null;
        }
        if (decoration != null) {
            decoration.show();
            return decoration;
        }
        return PropertyPageEmbSys.createErrorDecoration(control);
    }

    private void hideDecoration(Combo control, ControlDecoration decoration) {
        if (control.getSelectionIndex() != -1 && decoration != null) {
            decoration.hide();
        }
    }

    private void disposeDecorations() {
        PropertyPageEmbSys.disposeDecoration(this.archDecoration);
        PropertyPageEmbSys.disposeDecoration(this.vendorDecoration);
        PropertyPageEmbSys.disposeDecoration(this.chipDecoration);
        PropertyPageEmbSys.disposeDecoration(this.coreDecoration);
    }
}

