/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.embsysregview.properties;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.cdt.embsysregview.Activator;
import org.eclipse.cdt.embsysregview.Messages;
import org.eclipse.cdt.embsysregview.properties.Property;
import org.eclipse.cdt.embsysregview.properties.SettingsUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class PropertiesHolder {
    private static Map<String, PropertiesHolder> instances = new HashMap<String, PropertiesHolder>();
    private ILock lock;
    private final Set<Property> properties = Collections.unmodifiableSet(new HashMap<String, Boolean>(){
        {
            Stream.of("architecture", "vendor", "chip").forEach((? super T p) -> {
                Boolean bl = this.put(p, true);
            });
            Stream.of("board", "core").forEach((? super T p) -> {
                Boolean bl = this.put(p, false);
            });
        }
    }.entrySet().stream().map(e -> new Property(new QualifiedName("register_" + e.getKey(), e.getKey()), e.getValue())).collect(Collectors.toSet()));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PropertiesHolder getInstance(IProject project) {
        String key = project == null ? "common_properties" : project.getName();
        PropertiesHolder localInstance = instances.get(key);
        if (localInstance != null) return localInstance;
        Class<PropertiesHolder> clazz = PropertiesHolder.class;
        synchronized (PropertiesHolder.class) {
            localInstance = instances.get(key);
            if (localInstance != null) return localInstance;
            localInstance = new PropertiesHolder(project);
            instances.put(key, localInstance);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return localInstance;
        }
    }

    private PropertiesHolder(IProject project) {
    }

    public Set<Property> getPropertySet() {
        return this.properties;
    }

    public Map<String, String> getValueMap() {
        return this.properties.stream().collect(Collectors.toMap(Property::getName, Property::getValue));
    }

    public Map<String, Property> getPropertyMap() {
        return this.properties.stream().collect(Collectors.toMap(Property::getName, Function.identity()));
    }

    public void setPropertyValue(IProject project, QualifiedName qualifiedName, String newValue) {
        Property property = this.getPropertyMap().get(qualifiedName.getLocalName());
        try {
            project.setPersistentProperty(qualifiedName, newValue);
            this.scheduleUpdateCProjectJob(project, qualifiedName, newValue);
            property.setValue(newValue);
        }
        catch (CoreException e) {
            Activator.log(4, "Write property problem", e);
        }
    }

    private Job storeSettingsJob(final Function<IProgressMonitor, IStatus> func) {
        if (this.lock == null) {
            this.lock = Job.getJobManager().newLock();
        }
        return new Job(""){
            {
                super($anonymous0);
                this.setSystem(true);
                this.schedule();
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    PropertiesHolder.this.lock.acquire();
                    IStatus iStatus = (IStatus)func.apply(monitor);
                    return iStatus;
                }
                finally {
                    PropertiesHolder.this.lock.release();
                }
            }
        };
    }

    public void scheduleUpdateCProjectJob(IProject project, QualifiedName qualifiedName, String value) {
        this.storeSettingsJob(m -> SettingsUtils.storePropertyInCProject(project, qualifiedName.getQualifier(), value, m));
    }

    public IStatus scheduleSetFromCProjectJob(IProject project, Property property) {
        Job j = this.storeSettingsJob(m -> SettingsUtils.setPropertyValueFromCProject(project, property));
        try {
            j.join();
        }
        catch (InterruptedException e) {
            Activator.log(4, e.getMessage(), e);
        }
        if (j.getResult().isOK() || !property.isMandatory()) {
            return new Status(0, "org.eclipse.cdt.embsysregview", NLS.bind((String)Messages.property_value_was_set_from_cproject, (Object)property.getQualifier(), (Object)project.getName()));
        }
        return new Status(2, "org.eclipse.cdt.embsysregview", NLS.bind((String)Messages.no_settings_were_found_in_cproject_file, (Object)property.getQualifier(), (Object)project.getName()));
    }

    public void saveProjectSettings(IProject project) {
        try {
            for (Property property : this.properties) {
                project.setPersistentProperty(property.getQualifiedName(), property.getValue());
            }
        }
        catch (CoreException e) {
            Activator.log(0, e.getMessage(), e);
        }
    }
}

