/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.embsysregview.internal.ui.view;

import org.eclipse.cdt.embsysregview.Activator;
import org.eclipse.cdt.embsysregview.internal.model.TreeField;
import org.eclipse.cdt.embsysregview.internal.model.TreeGroup;
import org.eclipse.cdt.embsysregview.internal.model.TreeParent;
import org.eclipse.cdt.embsysregview.internal.model.TreeRegister;
import org.eclipse.cdt.embsysregview.internal.model.TreeRegisterGroup;
import org.eclipse.cdt.embsysregview.internal.utils.Utils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

public class EmbSysRegUi {
    private EmbSysRegUi() {
    }

    public static final ImageDescriptor getButtonImage() {
        return Activator.getDefault().getImageDescriptor("IMG_EMBSYS_CONFIG_BUTTON");
    }

    public static final ImageDescriptor getToolbarImage() {
        return Activator.getDefault().getImageDescriptor("IMG_EMBSYS_TOOLBAR_FILTER");
    }

    public void setRegisterGroupLive(TreeRegisterGroup treeRegisterGroup) {
    }

    static ColumnLabelProvider getRegisterColumnLabelProvider(final Composite parent) {
        return new ColumnLabelProvider(){

            public Color getBackground(Object element) {
                if (element instanceof TreeRegister && ((TreeRegister)element).isUnsertain()) {
                    return parent.getShell().getDisplay().getSystemColor(12);
                }
                return null;
            }

            public Color getForeground(Object element) {
                if (element instanceof TreeRegister && ((TreeRegister)element).isRetrievalActive()) {
                    return parent.getShell().getDisplay().getSystemColor(6);
                }
                if (element instanceof TreeField && ((TreeRegister)((TreeField)element).getParent()).isRetrievalActive()) {
                    return parent.getShell().getDisplay().getSystemColor(6);
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof TreeRegister && !((TreeRegister)element).getAlterName().isEmpty()) {
                    return "+ " + element.toString();
                }
                if (element instanceof TreeField) {
                    return ((TreeField)element).getFieldLabel();
                }
                return element.toString();
            }

            public Image getImage(Object obj) {
                if (obj instanceof TreeRegisterGroup) {
                    if (((TreeRegisterGroup)obj).isChecked()) {
                        return Activator.getDefault().getImage("IMG_EMBSYS_REG_GROUP_SELECTED");
                    }
                    return Activator.getDefault().getImage("IMG_EMBSYS_REG_GROUP");
                }
                if (obj instanceof TreeParent) {
                    if (obj instanceof TreeRegister) {
                        if (((TreeRegister)obj).isRetrievalActive()) {
                            return Activator.getDefault().getImage("IMG_EMBSYS_SELECTED");
                        }
                        return Activator.getDefault().getImage("IMG_EMBSYS_UNSELECTED");
                    }
                } else if (obj instanceof TreeField) {
                    if (((TreeRegister)((TreeField)obj).getParent()).isRetrievalActive()) {
                        return Activator.getDefault().getImage("IMG_EMBSYS_SELECTED_FIELD");
                    }
                    return Activator.getDefault().getImage("IMG_EMBSYS_UNSELECTED_FIELD");
                }
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }
        };
    }

    static CellLabelProvider getDescriptionCellLabelProvider() {
        CellLabelProvider descriptionCellLabelProvider = new CellLabelProvider(){

            public String getToolTipText(Object element) {
                if (element instanceof TreeRegister) {
                    if (Utils.countTextLines(((TreeRegister)element).getDescription()) > 1) {
                        return ((TreeRegister)element).getDescription();
                    }
                    return null;
                }
                if (element instanceof TreeField) {
                    if (Utils.countTextLines(((TreeField)element).getDescription()) > 1 || ((TreeField)element).hasInterpretation()) {
                        return ((TreeField)element).getDescription();
                    }
                    return null;
                }
                return null;
            }

            public Point getToolTipShift(Object object) {
                return new Point(5, 5);
            }

            public int getToolTipDisplayDelayTime(Object object) {
                return 200;
            }

            public int getToolTipTimeDisplayed(Object object) {
                return 0;
            }

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof TreeGroup) {
                    cell.setText(((TreeGroup)element).getDescription());
                }
                if (element instanceof TreeRegisterGroup) {
                    cell.setText(((TreeRegisterGroup)element).getDescription());
                }
                if (element instanceof TreeRegister) {
                    cell.setText(Utils.getFirstNotEmptyTextLine(((TreeRegister)element).getDescription()).trim());
                }
                if (element instanceof TreeField) {
                    if (((TreeField)element).hasInterpretation()) {
                        cell.setText(((TreeField)element).getInterpretation());
                        cell.setImage(Activator.getDefault().getImage("IMG_EMBSYS_INTERPRETATION"));
                    } else {
                        cell.setText(Utils.getFirstNotEmptyTextLine(((TreeField)element).getDescription()).trim());
                        if (Utils.countTextLines(((TreeField)element).getDescription()) > 1) {
                            cell.setImage(Activator.getDefault().getImage("IMG_EMBSYS_INFO"));
                        }
                    }
                }
            }
        };
        return descriptionCellLabelProvider;
    }

    static ColumnLabelProvider getAccessColumnLabelProvider() {
        ColumnLabelProvider accessColumnLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof TreeGroup) {
                    return "";
                }
                if (element instanceof TreeRegisterGroup) {
                    return "";
                }
                if (element instanceof TreeRegister) {
                    return ((TreeRegister)element).getType().toUpperCase();
                }
                if (element instanceof TreeField) {
                    return "(" + ((TreeField)element).getAccess().toUpperCase() + ")";
                }
                return "";
            }
        };
        return accessColumnLabelProvider;
    }

    static ColumnLabelProvider getAddressColumnLabelProvider() {
        return new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof TreeRegister && !((TreeRegister)element).isSPR()) {
                    return Utils.longtoHexString(((TreeRegister)element).getRegisterAddress(), 32);
                }
                return "";
            }
        };
    }

    static ColumnLabelProvider getBinColumnLabelProvider(final Composite parent) {
        ColumnLabelProvider binColumnLabelProvider = new ColumnLabelProvider(){

            public Color getForeground(Object element) {
                if (element instanceof TreeRegister && !((TreeRegister)element).isWriteOnly() && ((TreeRegister)element).hasValueChanged()) {
                    return parent.getShell().getDisplay().getSystemColor(3);
                }
                if (element instanceof TreeField && !((TreeRegister)((TreeField)element).getParent()).isWriteOnly() && ((TreeField)element).hasValueChanged()) {
                    return parent.getShell().getDisplay().getSystemColor(3);
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof TreeGroup) {
                    return "";
                }
                if (element instanceof TreeRegisterGroup) {
                    return "";
                }
                if (element instanceof TreeRegister) {
                    if (!((TreeRegister)element).isRetrievalActive()) {
                        return "";
                    }
                    if (!((TreeRegister)element).isAlreadyRead()) {
                        return "";
                    }
                    if (((TreeRegister)element).isWriteOnly()) {
                        return "------------- write only -------------";
                    }
                    return Utils.longtobinarystring(((TreeRegister)element).getValue(), ((TreeRegister)element).getBitSize());
                }
                if (element instanceof TreeField) {
                    TreeRegister parent2 = (TreeRegister)((TreeField)element).getParent();
                    if (!parent2.isRetrievalActive()) {
                        return "";
                    }
                    if (!parent2.isAlreadyRead()) {
                        return ((TreeField)element).getLabelString();
                    }
                    if (parent2.isWriteOnly()) {
                        return "------------- write only -------------";
                    }
                    if (((TreeField)element).isWriteOnly()) {
                        return "";
                    }
                    return Utils.longtobinarystring(((TreeField)element).getValue(), ((TreeField)element).getBitLength());
                }
                return element.toString();
            }
        };
        return binColumnLabelProvider;
    }

    static ColumnLabelProvider getHexColumnLabelProvider(final Composite parent) {
        ColumnLabelProvider hexColumnLabelProvider = new ColumnLabelProvider(){

            public Color getForeground(Object element) {
                if (element instanceof TreeRegister && !((TreeRegister)element).isWriteOnly() && ((TreeRegister)element).hasValueChanged()) {
                    return parent.getShell().getDisplay().getSystemColor(3);
                }
                if (element instanceof TreeField && !((TreeRegister)((TreeField)element).getParent()).isWriteOnly() && ((TreeField)element).hasValueChanged()) {
                    return parent.getShell().getDisplay().getSystemColor(3);
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof TreeGroup) {
                    return "";
                }
                if (element instanceof TreeRegisterGroup) {
                    return "";
                }
                if (element instanceof TreeRegister) {
                    TreeRegister reg = (TreeRegister)element;
                    if (reg.isWriteOnly()) {
                        return "- write only -";
                    }
                    if (!reg.isRetrievalActive()) {
                        return "";
                    }
                    if (!reg.isAlreadyRead()) {
                        return "- not read -";
                    }
                    return Utils.longtoHexString(reg.getValue(), reg.getBitSize());
                }
                if (element instanceof TreeField) {
                    TreeRegister parent2 = (TreeRegister)((TreeField)element).getParent();
                    if (!parent2.isRetrievalActive()) {
                        return "";
                    }
                    if (parent2.isWriteOnly() || ((TreeField)element).isWriteOnly()) {
                        return "- write only -";
                    }
                    if (!parent2.isAlreadyRead()) {
                        return "?";
                    }
                    return Utils.longtoHexString(((TreeField)element).getValue(), ((TreeField)element).getBitLength());
                }
                return element.toString();
            }
        };
        return hexColumnLabelProvider;
    }

    static ColumnLabelProvider getResetColumnLabelProvider() {
        ColumnLabelProvider resetColumnLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof TreeGroup) {
                    return "";
                }
                if (element instanceof TreeRegisterGroup) {
                    return "";
                }
                if (element instanceof TreeRegister) {
                    return Utils.longtoHexString(((TreeRegister)element).getResetValue(), ((TreeRegister)element).getBitSize());
                }
                if (element instanceof TreeField) {
                    return "";
                }
                return "";
            }
        };
        return resetColumnLabelProvider;
    }
}

