/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.embsysregview.internal.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.embsysregview.core.SortingOrder;
import org.eclipse.cdt.embsysregview.internal.model.IEditable;
import org.eclipse.cdt.embsysregview.internal.model.TreeElement;
import org.eclipse.cdt.embsysregview.internal.model.TreeField;
import org.eclipse.cdt.embsysregview.internal.model.TreeParent;
import org.eclipse.cdt.embsysregview.internal.model.TreeRange;
import org.eclipse.cdt.embsysregview.internal.utils.Utils;

public class TreeRegister
extends TreeParent
implements IEditable {
    public static final long BAD_VALUE = 3735928559L;
    private static final char[] FILLER = new char[]{'?', '?', '?', '?', '?', '?', '?', '?'};
    private long old_value;
    private long value = -1L;
    private boolean retrievalActive = false;
    private final long resetValue;
    private final String type;
    private final long registerAddress;
    private final int size;
    private boolean uncertainFlag;
    private boolean readFlag;
    private boolean hasHistoryFlag;
    private List<TreeRegister> alterName;
    private final boolean isSPR;
    private long maskReadOnly;

    public boolean isReadWrite() {
        return this.getType().toUpperCase().equals("RW") || this.getType().toUpperCase().equals("RW1") || this.getType().toUpperCase().equals("RW1C") || this.getType().toUpperCase().equals("RW1S") || this.getType().toUpperCase().equals("RWH");
    }

    public boolean isReadOnly() {
        return this.getType().toUpperCase().equals("RO") || this.getType().toUpperCase().equals("RC") || this.getType().toUpperCase().equals("R");
    }

    public boolean isWriteOnly() {
        return this.getType().toUpperCase().equals("WO") || this.getType().toUpperCase().equals("W") || this.getType().toUpperCase().equals("W1C") || this.getType().toUpperCase().equals("W1S") || this.getType().toUpperCase().equals("W1");
    }

    public boolean hasValueChanged() {
        if (!this.hasHistoryFlag) {
            return false;
        }
        return this.old_value != this.value;
    }

    public boolean isRetrievalActive() {
        return this.retrievalActive;
    }

    public void setRetrievalActive(boolean retrievalActive) {
        this.retrievalActive = retrievalActive;
    }

    public final long getRegisterAddress() {
        return this.registerAddress;
    }

    public final String getRegisterAddrString() {
        return String.valueOf(this.registerAddress);
    }

    public TreeRegister(String name, String description, long registerAddress, long resetValue, String type, int size, boolean isSPR) {
        super(name, description);
        this.registerAddress = registerAddress;
        this.resetValue = resetValue;
        this.type = type;
        this.size = size;
        this.readFlag = false;
        this.uncertainFlag = false;
        this.isSPR = isSPR;
        this.alterName = new ArrayList<TreeRegister>();
    }

    protected long getOldValue() {
        return this.old_value;
    }

    public long getValue() {
        if (this.isWriteOnly()) {
            return this.resetValue;
        }
        return this.value;
    }

    public String getPrintValue() {
        if (this.retrievalActive) {
            return Utils.longtoHexString(this.getValue(), this.getBitSize());
        }
        return String.copyValueOf(FILLER, 0, this.getByteSize() * 2);
    }

    public long getResetValue() {
        return this.resetValue;
    }

    public String getType() {
        return this.type;
    }

    public void setValue(long lvalue) {
        this.old_value = this.value;
        this.value = lvalue;
        this.uncertainFlag = false;
        if (this.readFlag) {
            this.hasHistoryFlag = true;
        }
        this.readFlag = true;
    }

    public int getBitSize() {
        return this.size * 8;
    }

    public int getByteSize() {
        return this.size;
    }

    public void clearValue() {
        this.value = 3735928559L;
        this.uncertainFlag = false;
        this.readFlag = false;
    }

    public byte[] getByteBuffer(boolean isBigEndian) {
        long l = this.value;
        byte[] result = new byte[this.getByteSize()];
        if (isBigEndian) {
            int i = this.getByteSize() - 1;
            while (i >= 0) {
                result[i] = (byte)(l & 0xFFL);
                l >>= 8;
                --i;
            }
        } else {
            int i = 0;
            while (i < this.getByteSize()) {
                result[i] = (byte)(l & 0xFFL);
                l >>= 8;
                ++i;
            }
        }
        return result;
    }

    public void setBytes(byte[] val) {
        long r = 0L;
        int i = 0;
        while (i < val.length) {
            r <<= 8;
            long tmp = val[i];
            r += tmp & 0xFFL;
            ++i;
        }
        this.setValue(r);
    }

    public TreeRange getRange() {
        TreeElement obj = this.getModelParent();
        if (obj instanceof TreeRange) {
            return (TreeRange)obj;
        }
        return null;
    }

    public void addAlterName(TreeRegister reg) {
        this.alterName.add(reg);
    }

    public List<TreeRegister> getAlterName() {
        return this.alterName;
    }

    public void rollbackValue() {
        if (this.hasHistoryFlag) {
            this.value = this.old_value;
        }
        this.uncertainFlag = true;
    }

    public final boolean isUnsertain() {
        return this.uncertainFlag;
    }

    public final boolean isAlreadyRead() {
        return this.readFlag;
    }

    @Override
    public boolean isEditAllowed() {
        if (TreeRegister.isModelAccessGranted()) {
            if (this.isReadWrite()) {
                return this.retrievalActive;
            }
            if (this.isWriteOnly()) {
                return true;
            }
        }
        return false;
    }

    public boolean isSPR() {
        return this.isSPR;
    }

    public boolean checkWriteModifiers(long value) {
        long delta = this.getValue() ^ value;
        return (delta & this.maskReadOnly) == 0L;
    }

    public void addBitFields(List<TreeField> bitFieldsList, SortingOrder.BitFieldSorter sorter) {
        if (sorter != SortingOrder.getDefaultSorter()) {
            Collections.sort(bitFieldsList, sorter);
        }
        for (TreeField field : bitFieldsList) {
            this.addChild(field);
            this.modifyAccessMask(field);
        }
    }

    private void modifyAccessMask(TreeField field) {
        String access = field.getAccess();
        if ("RO".equals(access)) {
            this.maskReadOnly |= field.getBitMask();
        }
    }

    public long getReadOnlyMask() {
        return this.maskReadOnly;
    }
}

