/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.embsysregview.internal.model;

import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.cdt.embsysregview.internal.model.HiddenTreeParent;
import org.eclipse.cdt.embsysregview.internal.model.TreeElement;
import org.eclipse.cdt.embsysregview.internal.model.TreeRegister;

public class TreeRange
extends HiddenTreeParent {
    long startAddr;
    SortedSet<Long> endAddrs = new TreeSet<Long>(){
        private static final long serialVersionUID = -3191919051825624865L;

        @Override
        public boolean add(Long e) {
            if (this.isEmpty() || (Long)this.last() < e) {
                return super.add(e);
            }
            return false;
        }
    };

    public TreeRange(String name, String description) {
        super(name, description);
    }

    public final long getStartAddress() {
        return this.startAddr;
    }

    public final long getLastAddress() {
        return this.endAddrs.last();
    }

    @Override
    public boolean addModelChild(TreeElement child) {
        long newBoundary;
        boolean result = false;
        TreeRegister reg = (TreeRegister)child;
        if (reg.isSPR()) {
            throw new UnsupportedOperationException();
        }
        if (this.endAddrs.isEmpty()) {
            this.startAddr = reg.getRegisterAddress();
        }
        if (this.endAddrs.add(newBoundary = reg.getRegisterAddress() + (long)reg.getByteSize())) {
            result = super.addModelChild(reg);
        } else {
            this.addAlternative(reg);
        }
        return result;
    }

    public final String getRangeLowAddrString() {
        return Long.toString(this.startAddr);
    }

    public int getRangeByteCount() {
        Long res = this.endAddrs.last() - this.startAddr;
        return res.intValue();
    }

    protected void addAlternative(TreeRegister node) {
        boolean found = false;
        for (TreeElement obj : this.getModelChildren()) {
            TreeRegister reg;
            if (!(obj instanceof TreeRegister) || (reg = (TreeRegister)obj).getRegisterAddress() != node.getRegisterAddress() || reg.getByteSize() != node.getByteSize()) continue;
            node.addAlterName(reg);
            for (TreeRegister altReg : reg.getAlterName()) {
                node.addAlterName(altReg);
            }
            for (TreeRegister refReg : node.getAlterName()) {
                refReg.addAlterName(node);
            }
            found = true;
        }
        if (!found) {
            super.addModelChild(node);
        }
    }

    @Override
    public String toString() {
        if (!this.endAddrs.isEmpty()) {
            return String.valueOf(Long.toHexString(this.startAddr)) + "-" + Long.toHexString(this.endAddrs.last());
        }
        return String.valueOf(Long.toHexString(this.startAddr)) + "- ???";
    }
}

