/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.sptgen;

import com.nxp.s32ds.ext.emf.ecore.EmfResources;
import com.nxp.s32ds.ext.rcp.runtime.util.FilePaths;
import com.nxp.s32ds.gte.gas.GasPlugin;
import com.nxp.s32ds.gte.gas.GasProgram;
import com.nxp.s32ds.gte.sptgen.SptEmitter;
import com.nxp.s32ds.gte.sptgen.SptGen;
import com.nxp.s32ds.gte.sptgen.SptGenActivator;
import com.nxp.s32ds.gte.sptgen.SptgenMessages;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.osgi.util.NLS;

public class SptGenerator {
    public static final String SOURCE_FOLDER_DEFAULT = "spt_gen";
    private static final String EXTENSION_SPT = "spt";

    public IFile generate(ResourceSet resourceSet, IProgressMonitor monitor) throws CoreException {
        IFile file;
        block7: {
            SubProgressMonitor pm = new SubProgressMonitor(monitor, 1);
            file = null;
            try {
                try {
                    SptGen generator = this.findGenObject(resourceSet);
                    if (generator != null) {
                        SptEmitter emitter = new SptEmitter();
                        GasProgram program = GasPlugin.findProgramObject((ResourceSet)resourceSet);
                        String genText = emitter.generate(program, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        file = this.prepareResultFile(program, generator, monitor);
                        this.storeResultFile(genText, file, monitor);
                        file.getProject().refreshLocal(2, monitor);
                        break block7;
                    }
                    List uris = EmfResources.extractURIs((ResourceSet)resourceSet);
                    String message = NLS.bind((String)SptgenMessages.SptGenerator_e_program_not_found, (Object)uris);
                    Status error = new Status(4, SptGenActivator.getPluginID(), message);
                    throw new CoreException((IStatus)error);
                }
                catch (CoreException e) {
                    throw e;
                }
                catch (Exception e) {
                    List uris = EmfResources.extractURIs((ResourceSet)resourceSet);
                    String message = NLS.bind((String)SptgenMessages.SptGenerator_e_generation_failed, (Object)uris);
                    Status error = new Status(4, SptGenActivator.getPluginID(), message, (Throwable)e);
                    throw new CoreException((IStatus)error);
                }
            }
            finally {
                pm.done();
            }
        }
        return file;
    }

    private SptGen findGenObject(ResourceSet resourceSet) {
        SptGen program = null;
        EList resources = resourceSet.getResources();
        for (Resource resource : resources) {
            EList contents = resource.getContents();
            for (EObject content : contents) {
                if (!(content instanceof SptGen)) continue;
                program = (SptGen)content;
            }
        }
        return program;
    }

    private IFile prepareResultFile(GasProgram program, SptGen generator, IProgressMonitor monitor) throws CoreException {
        String projectDirectory = generator.getProjectDirectory();
        Path path = new Path(projectDirectory);
        String projectName = path.lastSegment();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!project.isAccessible()) {
            String message = NLS.bind((String)SptgenMessages.SptGenerator_e_project_not_accessible, (Object)project.getName());
            Status error = new Status(4, SptGenActivator.getPluginID(), message);
            throw new CoreException((IStatus)error);
        }
        String sourceFolder = generator.getSourceFolder();
        IFolder folder = project.getFolder(sourceFolder);
        if (!folder.exists()) {
            folder.create(false, true, monitor);
        }
        String programName = program.getName();
        String sptFileName = FilePaths.replaceExtension((String)programName, (String)EXTENSION_SPT);
        IFile file = folder.getFile(sptFileName);
        return file;
    }

    private void storeResultFile(String genText, IFile file, IProgressMonitor monitor) throws CoreException, UnsupportedEncodingException {
        String charset = "UTF-8";
        byte[] bytes = genText.getBytes(charset);
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        if (file.exists()) {
            file.setContents((InputStream)stream, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        } else {
            file.create((InputStream)stream, true, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
        }
    }
}

