#!/bin/bash

#
# Script to run spec2k and spec2k6 binaries remotely
#

path2k_gzip="benchspec/CINT2000/164.gzip/exe"
path2k_vpr="benchspec/CINT2000/175.vpr/exe"
path2k_gcc="benchspec/CINT2000/176.gcc/exe"
path2k_mcf="benchspec/CINT2000/181.mcf/exe"
path2k_crafty="benchspec/CINT2000/186.crafty/exe"
path2k_parser="benchspec/CINT2000/197.parser/exe"
path2k_eon="benchspec/CINT2000/252.eon/exe"
path2k_perlbmk="benchspec/CINT2000/253.perlbmk/exe"
path2k_gap="benchspec/CINT2000/254.gap/exe"
path2k_vortex="benchspec/CINT2000/255.vortex/exe"
path2k_bzip2="benchspec/CINT2000/256.bzip2/exe"
path2k_twolf="benchspec/CINT2000/300.twolf/exe"
path2k_wupwise="benchspec/CFP2000/168.wupwise/exe"
path2k_swim="benchspec/CFP2000/171.swim/exe"
path2k_mgrid="benchspec/CFP2000/172.mgrid/exe"
path2k_applu="benchspec/CFP2000/173.applu/exe"
path2k_mesa="benchspec/CFP2000/177.mesa/exe"
path2k_galgel="benchspec/CFP2000/178.galgel/exe"
path2k_art="benchspec/CFP2000/179.art/exe"
path2k_equake="benchspec/CFP2000/183.equake/exe"
path2k_facerec="benchspec/CFP2000/187.facerec/exe"
path2k_ammp="benchspec/CFP2000/188.ammp/exe"
path2k_lucas="benchspec/CFP2000/189.lucas/exe"
path2k_fma3d="benchspec/CFP2000/191.fma3d/exe"
path2k_sixtrack="benchspec/CFP2000/200.sixtrack/exe"
path2k_apsi="benchspec/CFP2000/301.apsi/exe"

path2k6_perlbench="benchspec/CPU2006/400.perlbench/exe"
path2k6_bzip2="benchspec/CPU2006/401.bzip2/exe"
path2k6_gcc="benchspec/CPU2006/403.gcc/exe"
path2k6_bwaves="benchspec/CPU2006/410.bwaves/exe"
path2k6_gamess="benchspec/CPU2006/416.gamess/exe"
path2k6_mcf="benchspec/CPU2006/429.mcf/exe"
path2k6_milc="benchspec/CPU2006/433.milc/exe"
path2k6_zeusmp="benchspec/CPU2006/434.zeusmp/exe"
path2k6_gromacs="benchspec/CPU2006/435.gromacs/exe"
path2k6_cactusADM="benchspec/CPU2006/436.cactusADM/exe"
path2k6_leslie3d="benchspec/CPU2006/437.leslie3d/exe"
path2k6_namd="benchspec/CPU2006/444.namd/exe"
path2k6_gobmk="benchspec/CPU2006/445.gobmk/exe"
path2k6_dealII="benchspec/CPU2006/447.dealII/exe"
path2k6_soplex="benchspec/CPU2006/450.soplex/exe"
path2k6_povray="benchspec/CPU2006/453.povray/exe"
path2k6_calculix="benchspec/CPU2006/454.calculix/exe"
path2k6_hmmer="benchspec/CPU2006/456.hmmer/exe"
path2k6_sjeng="benchspec/CPU2006/458.sjeng/exe"
path2k6_GemsFDTD="benchspec/CPU2006/459.GemsFDTD/exe"
path2k6_libquantum="benchspec/CPU2006/462.libquantum/exe"
path2k6_h264ref="benchspec/CPU2006/464.h264ref/exe"
path2k6_tonto="benchspec/CPU2006/465.tonto/exe"
path2k6_lbm="benchspec/CPU2006/470.lbm/exe"
path2k6_omnetpp="benchspec/CPU2006/471.omnetpp/exe"
path2k6_astar="benchspec/CPU2006/473.astar/exe"
path2k6_wrf="benchspec/CPU2006/481.wrf/exe"
path2k6_sphinx3="benchspec/CPU2006/482.sphinx3/exe"
path2k6_xalancbmk="benchspec/CPU2006/483.xalancbmk/exe"

function cp_spec2k () {
    local bname
    local path=path2k_$benchmark
    if [ "$benchmark" = "gcc" ]; then bname=cc1; else bname=$benchmark; fi
    [ "$exe" = "" ] && exe=$SPEC/${!path}/${bname}_peak.*
    ssh -l $user $target "mkdir -p $tgtspec/${!path} && rm -f $tgtspec/${!path}/${bname}_peak.tg" >/dev/null 2>&1
    sleep 1
    scp -q $exe $user@$target:$tgtspec/${!path}/${bname}_peak.tg
    exe=""
}

function cp_spec2k6 () {
    local bname
    local path=path2k6_$benchmark
    bname=$benchmark
    if [ "$benchmark" = "sphinx3" ]; then bname=sphinx_livepretend; fi
    if [ "$benchmark" = "xalancbmk" ]; then bname=Xalan; fi
    [ "$exe" = "" ] && exe=$SPEC/${!path}/${bname}_peak.*
    ssh -l $user $target "mkdir -p $tgtspec/${!path} && rm -rf $tgtspec/${!path}/${bname}_peak.tg" >/dev/null 2>&1
    sleep 1
    scp -q $exe $user@$target:$tgtspec/${!path}/${bname}_peak.tg
    exe=""
}

function run_spec2k () {
    ssh -l $user $target "cd $tgtspec && source shrc && ../timeout $TMO runspec -c spec_run.cfg -a validate -e tg -n $rep $benchmark" > spec_run.log 2>&1
    v=`grep '^Success:' spec_run.log`
    if [ "$v" != "" ]; then
	l=`grep 'format: raw' spec_run.log | awk '{print $4}'`
	ssh -l $user $target "cat $l" 2>&1 | grep 'reported_time:' | awk '{print "VALID", $2}'
    else
	echo "NOTVALID 0"
    fi
    if [ "$KEEP" = "" ]; then
	rm -f spec_run.log
    fi
}

function run_spec2k6 () {
    ssh -l $user $target "cd $tgtspec && source shrc && ../timeout $TMO runspec -c spec_run.cfg -a validate -e tg -n $rep $benchmark" > spec_run.log 2>&1
    v=`grep '^Success:' spec_run.log`
    if [ "$v" != "" ]; then
	l=`grep 'format: raw' spec_run.log | awk '{print $4}'`
	ssh -l $user $target "cat $l" 2>&1 | grep 'reported_time:' | awk '{print "VALID", $2}'
    else
	echo "NOTVALID 0"
    fi
    if [ "$KEEP" = "" ]; then
	rm -f spec_run.log
    fi
}

function copy_and_run () {
    if [ "$target" = "" ]; then
	echo "Target board is not set. use t=<target> command"
	exit 1
    fi
    if [ "$benchmark" = "" ]; then
	echo "Benchmark is not set. use b=<benchmark> command"
	exit 1
    fi
    if [ "$specv" = "" ]; then
	echo "Must specify a Spec target. use {2k|2k6} command"
	exit 1
    fi
    if [ $rep -le 0 -o $rep -gt 20 ]; then
	echo "Repetion must be number from 1 to 20: $rep"
	exit 1
    fi
    if [ "$specv" = "2k" ]; then
	[ "$tgtspec" = "" ] && tgtspec=/local/job_server/spec2k
	if [ "$Q" != "Y" ]; then echo "Copying $benchmark"; fi
	cp_spec2k
	if [ "$Q" != "Y" ]; then echo "Executing $benchmark"; fi
	run_spec2k
    else
	[ "$tgtspec" = "" ] && tgtspec=/local/job_server/spec2k6
	if [ "$Q" != "Y" ]; then echo "Copying $benchmark"; fi
	cp_spec2k6
	if [ "$Q" != "Y" ]; then echo "Executing $benchmark"; fi
	run_spec2k6
    fi
}

# Some commands have default values
user=`id -nu`
tgtspec=""
specv=""
rep=3
KEEP=""
TMO=1000

for cmd in "$@"; do
    case $cmd in
        -h)
	    cat <<EOF
Usage is spec_run.sh <cmd>...

Where <cmd> is one of:
    -h            print this help and exit
    -q            quiet. Print results only
    -k            Keep intermediate results
    tn=<target>   Name of the machine to ssh to
    tu=<username> Username to ssh as. Default is user running this script
    t=<seconds>   Timeout in seconds
    s=<path>      Path of spec tree in target machine. Default is /local/job_server
    e=<path>      Executable to run. Default is to get from benchmark exe directory
    x=9           Number of repetitions
    2k            Specifies that benchmarks names are to be interpreted as spec2k ones
    2k6           Specifies that benchmarks names are to be interpreted as spec2k6 ones
    <benchmark>   Name of the spec2k or spec2k6 benchmark
EOF
	    exit 0
	    ;;
	-q)
	    Q="Y"
	    ;;
	-k)
	    KEEP="Y"
	    ;;
	tn=*)
            target=${cmd:3}
	    ;;
	tu=*)
            user=${cmd:3}
	    ;;
	t=*)
            TMO=${cmd:2}
	    ;;
	s=*)
            tgtspec=${cmd:2}
	    ;;
	e=*)
            exe=${cmd:2}
	    ;;
	x=*)
	    let rep=${cmd:2}
	    ;;
	2k)
	    specv="2k"
	    ;;
	2k6)
	    specv="2k6"
	    ;;
	gzip|vpr|crafty|parser|eon|gap|vortex|twolf|perlbmk| \
        wupwise|swim|mgrid|applu|mesa|galgel|art|equake|facerec|ammp|lucas|fma3d|sixtrack|apsi)
	    # Unambigous spec2k benchmark name
	    if [ "$specv" = "2k6" ]; then
		echo "Don't mix spec2k and spec2k6 benchmarks in the same invocation"
		exit 1
	    fi
	    specv="2k"
            benchmark=$cmd
	    copy_and_run
	    ;;
	perlbench|bwaves|gamess|milc|zeusmp|gromacs|cactusADM|leslie3d|namd|gobmk|dealII| \
	soplex|povray|calculix|hmmer|sjeng|GemsFDTD|libquantum|h264ref|tonto| \
	lbm|omnetpp|astar|wrf|sphinx3|xalancbmk)
	    # Unambigous spec2k6 benchmark name
	    if [ "$specv" = "2k" ]; then
		echo "Don't mix spec2k and spec2k6 benchmarks in the same invocation"
		exit 1
 	    fi
	    specv="2k6"
            benchmark=$cmd
	    copy_and_run
	    ;;
	gcc|mcf|bzip2)
            # This can be either one, must rely on explicty command (2k or 2k6) to set type
            benchmark=$cmd
	    copy_and_run
	    ;;
	perl)
            # This can be either one, must rely on explicty command (2k or 2k6) to set type
            if [ "$specv" = "2k" ]; then benchmark=perlbmk; else benchmark=perlbench; fi
	    copy_and_run
	    ;;
	*)
            echo "Unkown command: $cmd"
	    ;;
    esac
done