#!/bin/bash

#
# Program to lock and unlock a computer
#

# Arguments are:
# Action
action=$1

root_mv () {
    sudo mv -f $1 $2
    sudo chown root.root $2
    sudo chmod 600 $2
}

cfgfile="/etc/ssh/sshd_config"
banner="/etc/ssh/locked.banner"
cfgtmp="sshd_config.tmp"
bantmp="locked.banner"

user=`id -un`

if [ "$action" = "lock" ]; then
    # First remove any previous sign of lock
    sudo cat $cfgfile | awk '{if ($1 != "AllowUsers" && $1 != "PasswordAuthentication" && $1 != "Banner") print}' > $cfgtmp
    sudo rm -rf $banner

    # Allow only current user to ssh into computer
    echo "AllowUsers $user" >> $cfgtmp
    echo "PasswordAuthentication no" >> $cfgtmp

    # Set a banner to warn others
    echo "Banner $banner" >> $cfgtmp
    echo "******************************************" > $bantmp
    echo "* This machine is being used for timing"    >> $bantmp
    echo "* The lock owner is:   $user"               >> $bantmp
    echo "******************************************" >> $bantmp
    root_mv $bantmp $banner

    # Replace current setup with new setup
    root_mv $cfgtmp $cfgfile
    if [ -e /etc/init.d/sshd ]; then
	sudo /etc/init.d/sshd restart
    else
	sudo /etc/init.d/ssh restart
    fi
    echo ""
    echo "BOARD IS LOCKED FOR YOUR USE ONLY"
    echo ""

elif [ "$action" = "unlock" ]; then
    # First remove any previous sign of lock
    sudo cat $cfgfile | awk '{if ($1 != "AllowUsers" && $1 != "PasswordAuthentication" && $1 != "Banner") print}' > $cfgtmp
    sudo rm -rf $banner

    # Replace current setup with new setup
    root_mv $cfgtmp $cfgfile
    if [ -e /etc/init.d/sshd ]; then
	sudo /etc/init.d/sshd restart
    else
	sudo /etc/init.d/ssh restart
    fi
    echo ""
    echo "BOARD IS RELEASED FOR ANYONE USE"
    echo ""

else
    echo "Usage is"
    echo "    $0 lock|unlock"
fi
