#!/bin/bash

# Arguments are the following
BD=$1
TU=$2
TN=$3
SUB=$4

path2k6_bwaves="benchspec/CPU2006/410.bwaves/exe"
path2k6_gamess="benchspec/CPU2006/416.gamess/exe"
path2k6_milc="benchspec/CPU2006/433.milc/exe"
path2k6_zeusmp="benchspec/CPU2006/434.zeusmp/exe"
path2k6_gromacs="benchspec/CPU2006/435.gromacs/exe"
path2k6_cactusADM="benchspec/CPU2006/436.cactusADM/exe"
path2k6_leslie3d="benchspec/CPU2006/437.leslie3d/exe"
path2k6_namd="benchspec/CPU2006/444.namd/exe"
path2k6_dealII="benchspec/CPU2006/447.dealII/exe"
path2k6_soplex="benchspec/CPU2006/450.soplex/exe"
path2k6_povray="benchspec/CPU2006/453.povray/exe"
path2k6_calculix="benchspec/CPU2006/454.calculix/exe"
path2k6_GemsFDTD="benchspec/CPU2006/459.GemsFDTD/exe"
path2k6_tonto="benchspec/CPU2006/465.tonto/exe"
path2k6_lbm="benchspec/CPU2006/470.lbm/exe"
path2k6_wrf="benchspec/CPU2006/481.wrf/exe"
path2k6_sphinx3="benchspec/CPU2006/482.sphinx3/exe"

if [ "$SUB" = "all" ]; then
    blist="bwaves gamess milc zeusmp gromacs cactusADM leslie3d namd dealII  \
    soplex povray calculix GemsFDTD tonto lbm wrf sphinx3"
else
    blist=$SUB
fi
for b in $blist; do
    path=path2k6_$b
    bname=$b
    if [ "$b" = "sphinx3" ]; then bname=sphinx_livepretend; fi
    if [ "$b" = "xalancbmk" ]; then bname=Xalan; fi
    exe=$BD/installed_spec2k6/${!path}/${bname}_peak.*
    if [ -e $exe ]; then
	ssh -l $TU $TN "mkdir -p $BD/exec_spec2k6/${!path} && rm -rf $BD/exec_spec2k6/${!path}/${bname}_peak.tg"
	sleep 1
	scp -q $exe $TH@$TN:$BD/exec_spec2k6/${!path}/${bname}_peak.tg
    fi
done
if [ $? = 0 ]; then
    # Copy successful
    echo "..PASS"
else
    # Copy failed
    echo "..FAIL"
fi
