#!/bin/bash

# Arguments are the following
MLTYPE=$1
BD=$2
HTOOLS=$3
TLIBS=$4
TOOLS=$5
PREFIX=$6
UniqueID=$7
SUB=$8
FLGS="$9"

HLOG=$BD/${UniqueID}.host_log

source $BD/f-test/set_flags.sh

cd $BD/installed_eembc/office-2.0/oav2
if [ "$TGURU_C" = "" ]; then
    export TGURU_C=$HTOOLS/$TOOLS/bin/${PREFIX}gcc
fi
if [ "$TGURU_LD" = "" ]; then
    export TGURU_LD=$HTOOLS/$TOOLS/bin/${PREFIX}gcc
fi
if [ "$TGURU_AS" = "" ]; then
    export TGURU_AS=$HTOOLS/$TOOLS/bin/${PREFIX}as
fi
if [ "$TGURU_AR" = "" ]; then
    export TGURU_AR=$HTOOLS/$TOOLS/bin/${PREFIX}ar
fi
export TGURU_SIZE=$HTOOLS/$TOOLS/bin/${PREFIX}size
export TGURU_INCLUDE=$HTOOLS/$TOOLS/include
export TGURU_FLAGS_C="$FLGS $T_CFLAGS"
export TGURU_FLAGS_LD="$T_LFLAGS -lm"
export TGURU_FLAGS_DEBUG="-g"
export TGURU_PDF_PASS1="-fprofile-generate"
export TGURU_PDF_PASS2="-fprofile-use"
export TGURU_FLAGS_WARN="-pedantic -fno-asm -fsigned-char -Wall -fno-builtin -fno-common"

make TCDIR=../util/make VER="v2" TOOLCHAIN=gcc LITE="_lite" clean >> office_build.$MLTYPE.out 2>&1
rm -f *.log
rm -f gcc/bin_lite/*
make TCDIR=../util/make VER="v2" TOOLCHAIN=gcc LITE="_lite" cheader >> office_build.$MLTYPE.out 2>&1
make TCDIR=../util/make VER="v2" TOOLCHAIN=gcc LITE="_lite" targets >> office_build.$MLTYPE.out 2>&1

P=""
F=""
if [ "$SUB" = "all" ]; then
    blist1="bezierv2fixed bezierv2float textv2 gs8"
    blist2="ditherv2 rotatev2"
else
    if [ "$SUB" = "ditherv2" -o "$SUB" = "rotatev2" ]; then
	blist1=""
	blist2=$SUB
    else
	blist1=$SUB
	blist2=""
    fi
fi
for e in $blist1; do
    if [ -e gcc/bin_lite/${e}_lite.exe ]; then
	for d in 2 3 4; do
	    echo "BMK=office-2.${e}_d${d} COMP=Y" >> $HLOG
	done
	P="$P ${e}_lite"
    else
	for d in 2 3 4; do
	    echo "BMK=office-2.${e}_d${d} COMP=N" >> $HLOG
	done
	F="$F ${e}_lite"
    fi
done
for e in $blist2; do
    if [ -e gcc/bin_lite/${e}_lite.exe ]; then
	for d in 2 3 4 5 6 7 8 9 10 11; do
	    echo "BMK=office-2.${e}_d${d} COMP=Y" >> $HLOG
	done
	P="$P ${e}_lite"
    else
	for d in 2 3 4 5 6 7 8 9 10 11; do
	    echo "BMK=office-2.${e}_d${d} COMP=N" >> $HLOG
	done
	F="$F ${e}_lite"
    fi
done
nP=0
nF=0
for n in $P; do
    let nP=$nP+1
done
for n in $F; do
    let nF=$nF+1
done
echo "..PASS $nP FAIL $nF"
