#!/bin/bash

# Arguments are the following
CORE=$1
BD=$2
TN=$3
tag=$4
rep=$5
SUB=$6
FLGS="$7"
KEEP="$8"

if [ "$KEEP" != "" ]; then
    KEEP="-keep"
fi

mkdir -p $BD/job_server
cd $BD/job_server
rm -rf *

cp $BD/installed_nbench/nbench .
cp $BD/installed_nbench/COM.DAT .
cp $BD/installed_nbench/NNET.DAT .

cat > RUN.sh <<EOF
#!/bin/bash
sh -c "../timeout \$1 ./nbench > nbench.out 2> nbench.err" >> nbench.err 2>&1
let n=\$?
x=\`cat nbench.err\`
let z=\`wc -l nbench.out | awk '{print \$1}'\`

r1=\`tail -n 4 nbench.out | grep 'INTEGER INDEX' | awk '{printf "%.0f", \$4*100}'\`
r2=\`tail -n 4 nbench.out | grep 'FLOATING-POINT INDEX:' | awk '{printf "%.0f", \$3*100}'\`

if [ \$n = 0 -a "\$x" = "" -a \$z -eq 33 ]; then
    # Execution successful
    let r=\$r1+\$r2
    echo "VALID \$r"
else
    # Execution failed
    echo "NOTVALID 0"
fi
EOF
chmod 755 RUN.sh

tar cf nbench.tar nbench COM.DAT NNET.DAT RUN.sh
jsq.sh $TN tag=$tag nbench x=$rep e=$BD/job_server/nbench.tar core=$CORE flgs="$FLGS" $KEEP
