#!/bin/bash

# Arguments are the following
CORE=$1
BD=$2
TN=$3
tag=$4
rep=$5
SUB=$6
FLGS="$7"
KEEP="$8"

if [ "$KEEP" != "" ]; then
    KEEP="-keep"
fi

mkdir -p $BD/job_server
cd $BD/job_server
rm -rf *

cp $BD/installed_dhrystone/dhry21 .

cat > RUN.sh <<EOF
#!/bin/bash
sh -c "echo 100000000 | ../timeout \$1 ./dhry21 > dhry21.out 2> dhry21.err" >> dhry21.err 2>&1
let n=\$?
x=\`cat dhry21.err\`
r=\`grep 'VAX' dhry21.out | awk '{print \$5}'\`
if [ \$n = 0 -a "\$x" = "" -a "\$r" != "" ]; then
    # Execution successful
    echo "VALID \$r"
else
    # Execution failed
    echo "NOTVALID 0"
fi
EOF
chmod 755 RUN.sh

tar cf dhrystone.tar dhry21 RUN.sh
jsq.sh $TN tag=$tag dhrystone x=$rep e=$BD/job_server/dhrystone.tar core=$CORE flgs="$FLGS" $KEEP
