#!/bin/bash

# Arguments are the following
MLTYPE=$1
BD=$2
HTOOLS=$3
TLIBS=$4
TOOLS=$5
PREFIX=$6
UniqueID=$7
SUB=$8
FLGS="$9"

HLOG=$BD/${UniqueID}.host_log

source $BD/f-test/set_flags.sh

cd $BD/installed_eembc/coremark_v1.0
if [ "$TGURU_C" = "" ]; then
    export TGURU_C=$HTOOLS/$TOOLS/bin/${PREFIX}gcc
fi
export TGURU_AS=$HTOOLS/$TOOLS/bin/${PREFIX}as
export TGURU_AR=$HTOOLS/$TOOLS/bin/${PREFIX}ar
export TGURU_SIZE=$HTOOLS/$TOOLS/bin/${PREFIX}size
export TGURU_INCLUDE=$HTOOLS/$TOOLS/include
export TGURU_FLAGS_C="$FLGS $T_CFLAGS"
export TGURU_FLAGS_LD="$FLGS $T_LFLAGS -lm"
export TGURU_FLAGS_DEBUG="-g"
export TGURU_PDF_PASS1="-fprofile-generate"
export TGURU_PDF_PASS2="-fprofile-use"
export TGURU_FLAGS_WARN="-ansi -pedantic -fno-asm -fsigned-char \
       -Wcomment -W -Wparentheses -Wreturn-type -Wswitch -Wunused -Wsign-compare \
       -Wimplicit -Wreturn-type -Wshadow -Wpointer-arith -Wwrite-strings \
       -Wsign-compare -Wstrict-prototypes -Wmissing-prototypes -Wmissing-declarations"

rm -f coremark.exe
if [ "$MLTYPE" = "64" -o "$MLTYPE" = "S64" ]; then
    make REBUILD=1 PORT_DIR=tguru64 XT_CFLAGS="-DPERFORMANCE_RUN=1" load > coremark_build.$MLTYPE.out 2>&1
else
    make REBUILD=1 PORT_DIR=tguru XT_CFLAGS="-DPERFORMANCE_RUN=1" load > coremark_build.$MLTYPE.out 2>&1
fi
if [ -e coremark.exe ]; then
    # Compilation successful
    echo "BMK=coremark COMP=Y" >> $HLOG
    echo "..PASS"
else
    # Compilation failed
    echo "BMK=coremark COMP=N" >> $HLOG
    echo "..FAIL"
fi
