#!/bin/bash

# Arguments are the following
CORE=$1
BD=$2
TN=$3
tag=$4
rep=$5
SUB=$6
FLGS="$7"
KEEP="$8"

if [ "$KEEP" != "" ]; then
    KEEP="-keep"
fi

mkdir -p $BD/job_server
cd $BD/job_server
rm -rf *

cp $BD/installed_eembc/eembc-1.1/consumer/gcc/bin/*.exe .
cp $BD/installed_eembc/eembc-1.1/consumer/gcc/bin_lite/*.exe .

if [ "$SUB" = "all" ]; then
    blist="cjpeg djpeg rgbcmy01 rgbhpg01 rgbyiq01"
else
    blist=$SUB
fi

for e in $blist; do
    cat > RUN.sh <<EOF
#!/bin/bash
sh -c "../timeout \$1 ./${e}.exe -autogo > ${e}.log 2> ${e}.err" >> ${e}.err 2>&1
let n=\$?
x=\`cat ${e}.err\`
z=\`grep 'Failure' ${e}.log\`
r=\`grep 'Iterations/Sec' ${e}.log | awk '{print \$4}'\`
if [ \$n = 0 -a "\$x" = "" -a "\$z" = "" ]; then
    echo "VALID \$r"
else
    echo "NOTVALID 0"
fi
EOF
    chmod 755 RUN.sh

    tar cf consumer-1-${e}.tar ${e}.exe RUN.sh
    jsq.sh $TN tag=${tag} ${e} x=$rep e=$BD/job_server/consumer-1-${e}.tar core=$CORE flgs="$FLGS" $KEEP

    cat > RUN.sh <<EOF
#!/bin/bash
sh -c "../timeout \$1 ./${e}_lite.exe > ${e}_lite.log 2> ${e}_lite.err" >> ${e}_lite.err 2>&1
let n=\$?
x=\`cat ${e}_lite.err\`
z=\`grep 'Failure' ${e}_lite.log\`
r=\`grep 'Iterations/Sec' ${e}_lite.log | awk '{print \$4}'\`
if [ \$n = 0 -a "\$x" = "" -a "\$z" = "" -o "$e" = "ttsprk01" ]; then
    echo "VALID \$r"
else
    echo "NOTVALID 0"
fi
EOF
    chmod 755 RUN.sh

    tar cf consumer-1-${e}_lite.tar ${e}_lite.exe RUN.sh
    jsq.sh $TN tag=${tag} ${e}_lite x=$rep e=$BD/job_server/consumer-1-${e}_lite.tar core=$CORE flgs="$FLGS" $KEEP
done
