/* Entry Point */
ENTRY(_start)

/* define heap and stack size */
__HEAP_SIZE            = 2M ;
__STACK_SIZE           = 2M ;

SRAM_SIZE =  256M;
/* Define SRAM Base Address */
SRAM_BASE_ADDR = 0x00000000;
    
MEMORY
{

    flash_rchw : org = 0xF0000000,   len = 0x08
        
    m_text :	 org = 0x00000000,   len = 256M
    /* m_data :	 org = 0x00000000,   len = 256M */
       
}


SECTIONS
{
    .rchw   : 
    {
        KEEP(*(.rchw))
    } > flash_rchw

    .startup : ALIGN(0x400)
    {
    __start = . ;
    	*(.startup)
    } > m_text
    
    .core_exceptions_table   : ALIGN(0x1000)
    {
      __IVPR_VALUE = . ;
      *(.core_exceptions_table)
    } > m_text

    .intc_vector_table   : ALIGN(0x1000)  
    {
      *(.intc_vector_table)
    } > m_text
      
    .text_booke :
    { 
      INPUT_SECTION_FLAGS (!SHF_PPC_VLE)
      *(.text*)      
    } > m_text            
           
    .text_vle : 
    { INPUT_SECTION_FLAGS (SHF_PPC_VLE) 
      *(.text.startup)
      *(.text)
      *(.init)
      *(.text.*)
      . = ALIGN(16);      
    } > m_text       /* that will force pick VLE .text sections */ 
        
    .rodata :
    {
      *(.rodata)
      *(.rodata.*)
    } > m_text
    
    .eh_frame_hdr : { *(.eh_frame_hdr) } > m_text
    .eh_frame     : { KEEP (*(.eh_frame)) } > m_text
    
    .data   : 
    {
      *(.data)
      *(.data.*)
    }  > m_text /* m_data */ AT>m_text
    
    .sdata2  :
    {  
      *(.sdata2)
      *(.sdata2.*)
    } > m_text /* m_data */ AT>m_text

    .sbss2    (NOLOAD)   :
    {
      /* _SDA2_BASE_ = .; */ 
      *(.sbss2)
      *(.sbss2.*)
    } > m_text /* m_data */
    
    .sdata  :
    {
      *(.sdata)
      *(.sdata.*)
    } > m_text /* m_data */ AT>m_text
    
    .bss   (NOLOAD)  :
    {
      __BSS_START = .;
      *(.sbss)
      *(.sbss.*)	
      *(.bss)
      *(.bss.*)
      *(.tbss)
      *(.tbss.*)
      *(COMMON)
      __BSS_END = .;
    } > m_text /* m_data */
    
    .stack (NOLOAD) : ALIGN(16) 
    {
      __HEAP = . ;
      PROVIDE (_end = . );
      PROVIDE (end = . );            
      . += __HEAP_SIZE ;
      __HEAP_END = . ;
      _stack_end = . ;
      . +=  __STACK_SIZE ;
      _stack_addr = . ;
      __SP_INIT = . ;
      . += 4;
    } > m_text /* m_data */
 
/*-------- LABELS USED IN CODE -------------------------------*/
        
/* Labels for Copying Initialised Data from Flash to RAM */
__DATA_SRAM_ADDR  = ADDR(.data);
__SDATA_SRAM_ADDR = ADDR(.sdata);

__DATA_SIZE   = SIZEOF(.data);
__SDATA_SIZE  = SIZEOF(.sdata);

__DATA_ROM_ADDR  = LOADADDR(.data);
__SDATA_ROM_ADDR = LOADADDR(.sdata);
   
/* Labels Used for Initialising SRAM ECC */
__SRAM_SIZE = SRAM_SIZE;
__SRAM_BASE_ADDR = SRAM_BASE_ADDR;
     
__BSS_SIZE    = __BSS_END - __BSS_START;

}

