/*
 * 	Main Test harness This is where all the test cases will be called from
 *
 *  Created By Michael Fleischer
 *  Created on 10-11-2010
 * 	Version 1.0
 *
 * Notes:
 * 1.  To use as a test case developer
 * set a define for CONSOLE_OUTPUT
 * 2.  To use with the Starcore tool chain
 * set a define for PA_TEST
 *
 * 3. To add test cases
 * 	a.  Create a test case by copying one of the examples
 * 		_add2.c, _abs2.c, _min2.c
 * 	b.  Add the main test function to the list of extern
 * 		test cases below
 *  c.  Add the call to the main test function below in main
 *
 *  Version 1.0
 *  Updated by Michael Fleischer
 *  Date: 10-11-2010
 *
 *  Updated - Stephen Dew
 *  Fully automated intrinsic generation
 *  December 2010. 
 */

#ifdef   PA_TEST
#include "portTItoPA.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <float.h>

#define PRINT_DOUBLE_VALUE
/*External variables */
extern char filename[255];

/* External Functions */
extern void set_output_filename(char *name);

/*Test cases (add one for each intrinsic here)*/

 /* proto externs */ 

     extern void test__bitc4();
//extern void test__dotpus4();

     extern void test__set();
     extern void test__clr();
     extern void test__abs2();
     extern void test__min2();
     extern void test__ext();
     extern void test__extu();
//     extern void test__mpyh();



// not implemented

//     extern void test__hi();
     //extern void test__hill();
     //extern void test__itod();
     //extern void test__itoll();
     //extern void test__lo();
     //extern void test__loll();
     //extern void test__abs();

     //extern void test__add2();
     //extern void test__sadd2();
     //extern void test__lsadd();
     //extern void test__bitr();
     //extern void test__cmpeq2();
     //extern void test__cmpgt2();
     //extern void test__extr();
     //extern void test__extur();

     //extern void test__amemd8_const();
     //extern void test__amem8_const();
     //extern void test__amem8();
     //extern void test__amemd8();
     //extern void test__amem2_const();
     //extern void test__amem2();
     //extern void test__amem4_const();
     //extern void test__amem4();
     //extern void test__lmbd();
     //extern void test__max2();

     //extern void test__mpy();
     //extern void test__mpyhi();
     //extern void test__mpyhir();
     //extern void test__mpyhlu();
     //extern void test__mpylh();
     //extern void test__mpylhu();
     //extern void test__mpyluhs();
     //extern void test__mpylir();

     //extern void test__mpyhsu();
     //extern void test__mpyhuls();
     //extern void test__mpyhslu();
     //extern void test__mpylshu();
     //extern void test__mpyu();
//     //extern void test__mpyus2(); // can't verify
//     //extern void test__mpysu2();
     //extern void test__mpyu4();



     //extern void test__pack2();
     //extern void test__packhl2();
     //extern void test__packh2();
     //extern void test__packl4();
     //extern void test__rotl();
     //extern void test__sadd();
     //extern void test__shr2();
     //extern void test__spack2();
     //extern void test__ssub();
     //extern void test__ssub2();
     //extern void test__cmpyr1();
     //extern void test__cmpy();
     //extern void test__sub2();
     //extern void test__xpnd2();
     //extern void test__divd();
     //extern void test__mpyhu();
     //extern void test__smpyh();
     //extern void test__smpyhl();
     //extern void test__dotpn2();
     //extern void test__dotp2();
     //extern void test__dotpu4();

     //extern void test__deal();
     //extern void test__packlh2();
     //extern void test__sshvl();
     //extern void test__sshvr();
     //extern void test__shrmb();
     //extern void test__shlmb();
     //extern void test__subc();
     //extern void test__lnorm();
     //extern void test__norm();



     //extern void test__swap4();
     //extern void test__xpnd4();
     //extern void test__xpnd2();
     //extern void test__packl4();
     //extern void test__shfl();





/* Some Test Vectors */

/* #ifdef PA_TEST */
/* int 	srcW32[32] = */
/* #else */
/* int 	srcW32[32] = */
/* #endif */
/* { */
/* 		0x00000000,	0x00000001,	0x00003FFF,	0x00007FFF, */
/* 		0x00008000,	0x0000BFFF,	0x1FFFFFFF,	0x3FFFFFFF, */
/* 		0x7FFFFFFF,	0xFFFFFFFF,	0xFFFFC001,	0xFFFF8001, */
/* 		0xFFFF8000,	0xFFFF4001,	0xE0000001,	0xC0000001, */
/* 		0x80000001,	0xAA55AA55,	0x55AA55AA,     0xF0F0F0F0, */
/* 		0x0F0F0F0F,	0x1234ABCD,     0xDCBA4321,     0x80000000, */
/* 		0x7fff7fff,     0x80008000,     0x7ffe8000,     0x80007ffe, */
/* 		0x00018000,     0x80000001,     0x80028002,     0x7ffd8000 */
/* }; */

#define EINPUT32_SIZE	256
int srcW32[EINPUT32_SIZE] =
{
	0x00000000, 0x0000ffff, 0x00007fff, 0x00008000, 0x0000fffe, 
	0x00000001, 0x00001234, 0x00005678, 0x00009abc, 0x0000def0, 
	0x00000080, 0x000077ff, 0x0000ffaa, 0x00000701, 0x000033bb, 
	0xffff0000, 0xffffffff, 0xffff7fff, 0xffff8000, 0xfffffffe, 
	0xffff0001, 0xffff1234, 0xffff5678, 0xffff9abc, 0xffffdef0, 
	0xffff0080, 0xffff77ff, 0xffffffaa, 0xffff0701, 0xffff33bb, 
	0x7fff0000, 0x7fffffff, 0x7fff7fff, 0x7fff8000, 0x7ffffffe, 
	0x7fff0001, 0x7fff1234, 0x7fff5678, 0x7fff9abc, 0x7fffdef0, 
	0x7fff0080, 0x7fff77ff, 0x7fffffaa, 0x7fff0701, 0x7fff33bb, 
	0x80000000, 0x8000ffff, 0x80007fff, 0x80008000, 0x8000fffe, 
	0x80000001, 0x80001234, 0x80005678, 0x80009abc, 0x8000def0, 
	0x80000080, 0x800077ff, 0x8000ffaa, 0x80000701, 0x800033bb, 
	0xfffe0000, 0xfffeffff, 0xfffe7fff, 0xfffe8000, 0xfffefffe, 
	0xfffe0001, 0xfffe1234, 0xfffe5678, 0xfffe9abc, 0xfffedef0, 
	0xfffe0080, 0xfffe77ff, 0xfffeffaa, 0xfffe0701, 0xfffe33bb, 
	0x00010000, 0x0001ffff, 0x00017fff, 0x00018000, 0x0001fffe, 
	0x00010001, 0x00011234, 0x00015678, 0x00019abc, 0x0001def0, 
	0x00010080, 0x000177ff, 0x0001ffaa, 0x00010701, 0x000133bb, 
	0x12340000, 0x1234ffff, 0x12347fff, 0x12348000, 0x1234fffe, 
	0x12340001, 0x12341234, 0x12345678, 0x12349abc, 0x1234def0, 
	0x12340080, 0x123477ff, 0x1234ffaa, 0x12340701, 0x123433bb, 
	0x56780000, 0x5678ffff, 0x56787fff, 0x56788000, 0x5678fffe, 
	0x56780001, 0x56781234, 0x56785678, 0x56789abc, 0x5678def0, 
	0x56780080, 0x567877ff, 0x5678ffaa, 0x56780701, 0x567833bb, 
	0x9abc0000, 0x9abcffff, 0x9abc7fff, 0x9abc8000, 0x9abcfffe, 
	0x9abc0001, 0x9abc1234, 0x9abc5678, 0x9abc9abc, 0x9abcdef0, 
	0x9abc0080, 0x9abc77ff, 0x9abcffaa, 0x9abc0701, 0x9abc33bb, 
	0xdef00000, 0xdef0ffff, 0xdef07fff, 0xdef08000, 0xdef0fffe, 
	0xdef00001, 0xdef01234, 0xdef05678, 0xdef09abc, 0xdef0def0, 
	0xdef00080, 0xdef077ff, 0xdef0ffaa, 0xdef00701, 0xdef033bb, 
	0x00800000, 0x0080ffff, 0x00807fff, 0x00808000, 0x0080fffe, 
	0x00800001, 0x00801234, 0x00805678, 0x00809abc, 0x0080def0, 
	0x00800080, 0x008077ff, 0x0080ffaa, 0x00800701, 0x008033bb, 
	0x77ff0000, 0x77ffffff, 0x77ff7fff, 0x77ff8000, 0x77fffffe, 
	0x77ff0001, 0x77ff1234, 0x77ff5678, 0x77ff9abc, 0x77ffdef0, 
	0x77ff0080, 0x77ff77ff, 0x77ffffaa, 0x77ff0701, 0x77ff33bb, 
	0xffaa0000, 0xffaaffff, 0xffaa7fff, 0xffaa8000, 0xffaafffe, 
	0xffaa0001, 0xffaa1234, 0xffaa5678, 0xffaa9abc, 0xffaadef0, 
	0xffaa0080, 0xffaa77ff, 0xffaaffaa, 0xffaa0701, 0xffaa33bb, 
	0x07010000, 0x0701ffff, 0x07017fff, 0x07018000, 0x0701fffe, 
	0x07010001, 0x07011234, 0x07015678, 0x07019abc, 0x0701def0, 
	0x07010080, 0x070177ff, 0x0701ffaa, 0x07010701, 0x070133bb, 
	0x33bb0000, 0x33bbffff, 0x33bb7fff, 0x33bb8000, 0x33bbfffe, 
	0x33bb0001, 0x33bb1234, 0x33bb5678, 0x33bb9abc, 0x33bbdef0, 
	0x33bb0080, 0x33bb77ff, 0x33bbffaa, 0x33bb0701, 0x33bb33bb,
	0x7ab0de1d, 0x7ab01e31, 0x7ab08e29, 0x1abfde6f, 0x7a7f4ead,
	0xbab07ead, 0x6ab0fe13, 0xfab03e92, 0x5abfd0f6, 0xda7f4e0d,
	0x7a60de3d, 0x7af01ead, 0x6ab08ead, 0x9abfde36, 0x7a77fea0,
	0xba302ead, 0x6a50fe3d, 0x8ab03eda, 0xa7bfd063, 0x6a7a8e0d,
	0x1a60de3d, 0x4af01ead, 0x7ab08ead, 0xfabfde36, 0x7777fea0,
	0x9a302ead, 0x3a50fe3d, 0x8ab03eda, 0xa4bfd063, 0x657a8e0d,
	0xba30e2da
};

#define EINPUT32_SIZE	256
unsigned int srcUW32[EINPUT32_SIZE] =
{
	0x00000000, 0x0000ffff, 0x00007fff, 0x00008000, 0x0000fffe, 
	0x00000001, 0x00001234, 0x00005678, 0x00009abc, 0x0000def0, 
	0x00000080, 0x000077ff, 0x0000ffaa, 0x00000701, 0x000033bb, 
	0xffff0000, 0xffffffff, 0xffff7fff, 0xffff8000, 0xfffffffe, 
	0xffff0001, 0xffff1234, 0xffff5678, 0xffff9abc, 0xffffdef0, 
	0xffff0080, 0xffff77ff, 0xffffffaa, 0xffff0701, 0xffff33bb, 
	0x7fff0000, 0x7fffffff, 0x7fff7fff, 0x7fff8000, 0x7ffffffe, 
	0x7fff0001, 0x7fff1234, 0x7fff5678, 0x7fff9abc, 0x7fffdef0, 
	0x7fff0080, 0x7fff77ff, 0x7fffffaa, 0x7fff0701, 0x7fff33bb, 
	0x80000000, 0x8000ffff, 0x80007fff, 0x80008000, 0x8000fffe, 
	0x80000001, 0x80001234, 0x80005678, 0x80009abc, 0x8000def0, 
	0x80000080, 0x800077ff, 0x8000ffaa, 0x80000701, 0x800033bb, 
	0xfffe0000, 0xfffeffff, 0xfffe7fff, 0xfffe8000, 0xfffefffe, 
	0xfffe0001, 0xfffe1234, 0xfffe5678, 0xfffe9abc, 0xfffedef0, 
	0xfffe0080, 0xfffe77ff, 0xfffeffaa, 0xfffe0701, 0xfffe33bb, 
	0x00010000, 0x0001ffff, 0x00017fff, 0x00018000, 0x0001fffe, 
	0x00010001, 0x00011234, 0x00015678, 0x00019abc, 0x0001def0, 
	0x00010080, 0x000177ff, 0x0001ffaa, 0x00010701, 0x000133bb, 
	0x12340000, 0x1234ffff, 0x12347fff, 0x12348000, 0x1234fffe, 
	0x12340001, 0x12341234, 0x12345678, 0x12349abc, 0x1234def0, 
	0x12340080, 0x123477ff, 0x1234ffaa, 0x12340701, 0x123433bb, 
	0x56780000, 0x5678ffff, 0x56787fff, 0x56788000, 0x5678fffe, 
	0x56780001, 0x56781234, 0x56785678, 0x56789abc, 0x5678def0, 
	0x56780080, 0x567877ff, 0x5678ffaa, 0x56780701, 0x567833bb, 
	0x9abc0000, 0x9abcffff, 0x9abc7fff, 0x9abc8000, 0x9abcfffe, 
	0x9abc0001, 0x9abc1234, 0x9abc5678, 0x9abc9abc, 0x9abcdef0, 
	0x9abc0080, 0x9abc77ff, 0x9abcffaa, 0x9abc0701, 0x9abc33bb, 
	0xdef00000, 0xdef0ffff, 0xdef07fff, 0xdef08000, 0xdef0fffe, 
	0xdef00001, 0xdef01234, 0xdef05678, 0xdef09abc, 0xdef0def0, 
	0xdef00080, 0xdef077ff, 0xdef0ffaa, 0xdef00701, 0xdef033bb, 
	0x00800000, 0x0080ffff, 0x00807fff, 0x00808000, 0x0080fffe, 
	0x00800001, 0x00801234, 0x00805678, 0x00809abc, 0x0080def0, 
	0x00800080, 0x008077ff, 0x0080ffaa, 0x00800701, 0x008033bb, 
	0x77ff0000, 0x77ffffff, 0x77ff7fff, 0x77ff8000, 0x77fffffe, 
	0x77ff0001, 0x77ff1234, 0x77ff5678, 0x77ff9abc, 0x77ffdef0, 
	0x77ff0080, 0x77ff77ff, 0x77ffffaa, 0x77ff0701, 0x77ff33bb, 
	0xffaa0000, 0xffaaffff, 0xffaa7fff, 0xffaa8000, 0xffaafffe, 
	0xffaa0001, 0xffaa1234, 0xffaa5678, 0xffaa9abc, 0xffaadef0, 
	0xffaa0080, 0xffaa77ff, 0xffaaffaa, 0xffaa0701, 0xffaa33bb, 
	0x07010000, 0x0701ffff, 0x07017fff, 0x07018000, 0x0701fffe, 
	0x07010001, 0x07011234, 0x07015678, 0x07019abc, 0x0701def0, 
	0x07010080, 0x070177ff, 0x0701ffaa, 0x07010701, 0x070133bb, 
	0x33bb0000, 0x33bbffff, 0x33bb7fff, 0x33bb8000, 0x33bbfffe, 
	0x33bb0001, 0x33bb1234, 0x33bb5678, 0x33bb9abc, 0x33bbdef0, 
	0x33bb0080, 0x33bb77ff, 0x33bbffaa, 0x33bb0701, 0x33bb33bb,
	0x7ab0de1d, 0x7ab01e31, 0x7ab08e29, 0x1abfde6f, 0x7a7f4ead,
	0xbab07ead, 0x6ab0fe13, 0xfab03e92, 0x5abfd0f6, 0xda7f4e0d,
	0x7a60de3d, 0x7af01ead, 0x6ab08ead, 0x9abfde36, 0x7a77fea0,
	0xba302ead, 0x6a50fe3d, 0x8ab03eda, 0xa7bfd063, 0x6a7a8e0d,
	0x1a60de3d, 0x4af01ead, 0x7ab08ead, 0xfabfde36, 0x7777fea0,
	0x9a302ead, 0x3a50fe3d, 0x8ab03eda, 0xa4bfd063, 0x657a8e0d,
	0xba30e2da
};



#ifdef PA_TEST
short int 	srcW16[32] =
#else
short int 	srcW16[32] =
#endif
{
		0x0000,	0x0001,	0x1FFF, 0x3FFF,
		0x7FFF, 0x8000,	0xBFFF,	0xFFFF,
		0xC001,	0x8001,	0x8000,	0x4001,
		0xE001,	0xC001,	0xAA55,	0x55AA,
		0xF0F0,	0xF0F0,	0x1234, 0x4321,
		0xABCD,	0xDCBA, 0xAAAA, 0x5555,
		0x7ffe, 0x8000, 0x7ffd, 0x0001,
		0x7fff, 0x8001, 0x0003, 0xab2c
};

#ifdef PA_TEST
float 	srcF[24] =
#else
float 	srcF[24] =
#endif
{
		1.175494351E-38F,	1.192092896E-07F,	-0.01,				0.7,
		2.0,				-10.0,				300.0,				7000.0,
		3.402823466E+38F,	-3.1415,			-1.175494351E-38F,	-3.402823466E+38F,
		1.175,				-1.192092896E-07F,	0.06,				0.1,
		3.0,				50.0,				-100.0,				9000.0,
		-3.4e+38F,			3.14159,			-1.175494351E-38F,	3.402823466E+38F,
};

#define SRC_D_LENGTH 24
#ifdef PA_TEST
double 	srcD[SRC_D_LENGTH] =
#else
double 	srcD[SRC_D_LENGTH] =
#endif
{
		1.175e-38,	1.19e-7,	-0.01,		0.1,
		1.0,		-10.0,		100.0,		1000.0,
		3.4e+38,	-3.1415,	-1.175e-38,	-3.4e+38,
		1.175e-38,	-1.19e-7,	0.01,		0.1,
		1.0,		10.0,		-100.0,		1000.0,
		-3.4e+38,	3.14159,	-1.175e-38,	3.4e+38,
};

int main (void)
{

#ifdef   PA_TEST
	set_output_filename("results_PA.txt");
#else
	set_output_filename("results_TI64xSim.txt");
#endif

	/*	printf ("\n sizeof char %x",sizeof(char));
	printf ("\n sizeof short %x",sizeof(short));
	printf ("\n sizeof int %x",sizeof(int));
	printf ("\n sizeof long %x",sizeof(long));

	printf ("\n sizeof long long %x",sizeof(long long));
	printf ("\n sizeof long float %x",sizeof(float));
	printf ("\n sizeof long double %x",sizeof(double));
	*/
	printf("Starting Intrinsic Tests, output goes to file:  %s\n", filename);


 /* test calls */ 
	
	test__bitc4();
	//	test__dotpus4();
	test__set();
	test__clr();
	test__abs2();
	test__min2();
	test__ext();
	test__extu();
	//	test__mpyh(); 
	

     /* not implemented on PA */

	//test__hi();
	//test__hill();
     //test__itod();
     //test__itoll();
          //test__lo();
          //test__loll();
     //test__abs();
     //test__add2();
     //test__sadd2();
     //test__lsadd();
     //test__bitr();
     //test__cmpeq2();
     //test__cmpgt2();
     //test__extr();
     //test__extur();
     //test__amemd8_const();
     //test__amem8_const();
     //test__amem8();
     //test__amemd8();
     //test__amem2_const();
     //test__amem2();
     //test__amem4_const();
     //test__amem4();
     //test__lmbd();
     //test__max2();
     //test__mpy();
     //test__mpyhir();
     //test__mpyhlu();
     //test__mpylh();
     //test__mpylhu();
     //test__mpyluhs();
     //test__mpylir();
     //test__cmpyr1();
     //test__cmpy();
     //test__mpyhsu();
     //test__mpyhuls();
     //test__mpyhslu();
     //test__mpylshu();
     //test__mpyu();
     //test__mpyus2();
     //test__mpysu2();
     //test__mpyu4();
     //test__pack2();
     //test__packhl2();
     //test__packh2();
     //test__packl4();
     //test__rotl();
     //test__sadd();
     //test__shr2();
     //test__spack2();
     //test__ssub();
     //test__ssub2();
     //test__sub2();
     //test__xpnd2();
     //test__divd();
     //test__mpyhu();
     //test__smpyh();
     //test__smpyhl();
     //test__dotpn2();
     //test__dotp2();
     //test__dotpu4();
     //test__deal();
     //test__packlh2();
     //test__sshvl();
     //test__sshvr();
     //test__shrmb();
     //test__shlmb();
     //test__subc();
     //test__lnorm();
     //test__norm();
     //test__swap4();
     //test__xpnd4();
     //test__xpnd2();
     //test__packl4();
     //test__shfl();

	printf("Ending Intrinsic Tests, output goes to file:  %s\n", filename);

  return (0);
}

